libntruprime is maintained by Daniel J. Bernstein.

libntruprime is based on the
[official](https://ntruprime.cr.yp.to/software.html)
"factored" `sntrup` software,
which in turn is based on the original `sntrup` software
from Daniel J. Bernstein, Chitchanok Chuengsatiansup, Tanja Lange, and Christine van Vredendaal.

The following components of libntruprime are from Daniel J. Bernstein:

* Infrastructure to build a library
  with automatic run-time selection of implementations
  based on the run-time CPU and a database of benchmarks.
  This infrastructure was introduced in
  [`lib25519`](https://lib25519.cr.yp.to)
  and extended in
  [`libmceliece`](https://lib.mceliece.org).

* Various software for tests and benchmarks. This is based on
  public-domain code in the SUPERCOP benchmarking framework.

* Software for the underlying subroutines
  `crypto_sort`
  (based on [djbsort](https://sorting.cr.yp.to)),
  `crypto_hashblocks`,
  and `crypto_hash`.

Beyond libntruprime,
authors of
[publications with further `sntrup` speedups](speed.html#faster)
include
Erdem Alkim,
Daniel J. Bernstein,
Billy Bob Brumley,
Han-Ting Chen,
Ming-Shing Chen,
Yi-Hua Chung,
Vincent Hwang,
Li-Jie Jian,
Chi-Ting Liu,
Gregor Seiler,
Nicola Tuveri,
Ting-Yuan Wang,
and
Bo-Yin Yang.

### Citation

For papers, a suitable citation for libntruprime is as follows,
with your access date in place of 25 August 2024:
"Daniel J. Bernstein (editor). libntruprime.
<https://libntruprime.cr.yp.to>, accessed 25 August 2024."
Here "editor" reflects the fact that
libntruprime is assembled from work by multiple authors.
