//
// $Id: CwtPeakDetectorTest.cpp 6389 2014-06-13 19:46:19Z frenchwr $
//
//
// Original author: William French <william.r.french <a.t> vanderbilt.edu>
//
// Copyright 2008 Spielberg Family Center for Applied Proteomics
//   Cedars-Sinai Medical Center, Los Angeles, California  90048
//
// Licensed under the Apache License, Version 2.0 (the "License"); 
// you may not use this file except in compliance with the License. 
// You may obtain a copy of the License at 
//
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software 
// distributed under the License is distributed on an "AS IS" BASIS, 
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
// See the License for the specific language governing permissions and 
// limitations under the License.
//


#include "CwtPeakDetector.hpp"
#include "pwiz/utility/misc/unit.hpp"
#include "pwiz/utility/misc/Std.hpp"

using namespace pwiz::util;
using namespace pwiz::analysis;


ostream* os_ = 0;


struct TestData
{
    const char* xRaw;
    const char* yRaw;
    const char* xPeakValues;
    const char* yPeakValues;
};

const TestData testData[] =
{

    // Thermo Q-Exactive Jurkat Cell Lysate data
    { "351.166  351.167  351.169  351.17  351.172  351.173  351.175  351.177  351.178  351.18  351.181  351.183  351.184  351.186  351.191  351.192  351.194  351.195  351.197  351.198  351.2  351.202  351.203  351.205  351.206  351.208  351.209  351.211  351.212  351.214  351.216  351.217  351.219  351.22  351.222  351.223  351.647  351.648  351.65  351.652  351.653  351.655  351.656  351.658  351.659  351.661  351.662  351.664  351.666  351.667  351.669  351.675  351.677  351.678  351.68  351.681  351.683  351.684  351.686  351.687  351.689  351.691  351.692  351.694  351.695  351.825  351.827  351.828  351.83  351.831  351.833  351.835  351.836  351.838  351.839  351.841  351.844  351.846  351.847  351.849  351.996  351.997  351.999  352.001  352.002  352.004  352.005  352.007  352.008  352.01  352.012  352.013  352.015  352.016  352.018  352.019  352.019  352.021  352.022  352.024  352.066  352.068  352.069  352.071  352.073  352.074  352.076  352.077  352.079  352.08  352.082  352.084  352.085  352.087  352.088  352.09  352.091  352.093  352.095  352.096  352.098  352.099  352.101  352.102  352.104  352.106  352.107  352.109  352.111  352.113  352.114  352.116  352.117  352.119  352.12  352.122  352.124  352.125  352.127  352.128  352.129  352.131  352.132  352.136  352.137  352.139  352.14  352.145  352.146  352.148  352.15  352.151  352.153  352.154  352.156  352.157  352.159  352.16  352.162  352.163  352.165  352.166  352.168  352.169  352.171  352.171  352.173  352.174  352.176  352.177  352.179  352.181  352.182  352.184  352.185  352.187  352.188  352.19  352.192  352.193  352.195  352.196  352.198  352.199  352.201  352.203  352.204  352.206  352.207  352.209  352.211  352.212  352.214  352.215  352.217  352.218  352.22  352.222  352.223  352.225  352.226  352.228  352.229  352.231  352.233  352.234  352.236  352.237  352.239  352.24  352.242  352.243  352.245  352.247  352.248  352.25  352.251  352.253  352.254  352.256  352.258  352.259  352.261  352.262  352.264  352.265  352.267  352.269  352.27  352.272  352.273  352.275  352.276  352.278  352.28  352.281  352.283  352.284  352.286  352.287  352.289  352.291  352.292  352.294  352.295  352.297  352.298  352.3  352.301  352.303  352.305  352.325  352.327  352.328  352.33  352.331  352.333  352.334  352.336  352.338  352.339  352.341  352.342  352.344  352.345  352.347  352.349  352.35  352.352  352.353  352.355  352.356  352.358  352.36  352.361  352.363  352.364  352.366  352.367  352.369  352.371  352.372  352.374  352.375  352.377  352.378  352.38  352.382  352.383  352.49  352.491  352.493  352.494  352.496  352.498  352.499  352.501  352.502  352.504  352.505  352.507  352.509  352.51  352.512  352.513  352.515  352.516  352.518  352.52  352.521  352.523  352.524  352.526  352.527  352.529  352.531  352.532  352.534  352.535  352.537  352.538  352.54  352.542  352.543  352.545  352.546  352.548  352.549  352.551  352.553  352.554  352.556  352.557  352.568  352.57  352.571  352.573  352.575  352.576  352.578  352.579  352.581  352.582  352.584  352.586  352.587  352.589  352.59  352.592  352.593  352.595  352.597  352.598  352.6  352.601  352.603  352.604  352.606  352.608  352.609  352.611  352.612  352.614  352.615  352.617  352.619  352.62  352.622  352.623  352.625  352.628  352.629  352.631  352.633  352.659  352.661  352.662  352.664  352.666  352.667  352.669  352.67  352.672  352.672  352.674  352.675  352.677  352.678  352.68  352.681  352.683  352.684  352.686  352.688  352.689  352.691  352.692  352.694  352.695  352.697  352.699  352.699  352.7  352.702  352.703  352.705  352.706  352.708  352.71  352.711  352.713  352.714  352.717  352.719  352.721  352.722  352.724  352.725  352.727  352.728  352.73  352.732  352.733  352.735  352.736  352.738  352.739  352.743  352.744  352.746  352.747  352.749  352.75  352.752  352.754  352.755  352.757  352.758  352.76  352.761  352.763  352.765  352.766  352.768  352.769  352.771  352.772  352.774  352.776  352.777  352.779  352.78  352.782  352.783  352.785  352.787  352.788  352.79  352.791  352.793  352.794  352.796  352.798  352.799  352.801  352.838  352.84  352.842  352.843  352.845  352.846  352.848  352.85  352.851  352.853  352.854  352.856  352.857  352.859  352.861  352.862  352.864  352.865  352.867  352.868  352.87  352.872  352.873  352.875  352.876  352.878  352.879  352.881  352.883  353.002  353.004  353.005  353.007  353.008  353.01  353.011  353.013  353.015  353.016  353.018  353.019  353.021  353.022  353.173  353.175  353.176  353.178  353.18  353.181  353.183  353.184  353.186  353.187  353.189  353.191  353.192  353.194  353.195  353.197  353.199  353.2  353.201  353.203  353.205  353.206  353.51  353.512  353.513  353.515  353.516  353.518  353.52  353.521  353.523  353.524  353.526  353.528  353.529  353.531  353.533  353.534  353.536  353.664  353.665  353.667  353.668  353.67  353.672  353.673  353.675  353.676  353.678  353.679  353.681  353.683  353.684  353.686  353.687  353.689  353.69  353.692  353.694  353.695  353.697  353.698  353.7  353.701  353.703  353.704  353.706  353.845  353.846  353.848  353.849  353.851  353.853  353.854  353.856  353.857  353.859  353.861  353.862  353.864  353.866  353.867  353.869  353.87  354.167  354.169  354.171  354.172  354.174  354.175  354.177  354.178  354.18  354.182  354.183  354.185  354.186  354.188  354.19  354.191  354.193  354.194  354.196  354.197  354.199  354.201  354.202  354.204  354.205  354.207  354.209  354.21  354.212  354.213  354.215  354.216  354.218  354.22  354.221  354.671  354.672  354.674  354.675  354.677  354.679  354.68  354.682  354.683  354.685  354.687  354.688  354.69",
      "0  0  0  0  8120.02  23237.3  38803  41467.4  30047.5  15008.8  0  0  0  0  0  0  0  0  15759.8  25237.7  29474.8  23502.4  12698.3  0  0  0  12610.6  26647.5  36362.6  32099.8  18001.4  6000.35  0  0  0  0  0  0  0  0  4528.55  17484.2  35392.4  42725.1  34221.6  18680.2  6308.08  0  0  0  0  0  0  0  0  10422.8  19134.8  24311.8  24054.1  17420.9  8268.2  0  0  0  0  0  0  0  0  7107.35  22527.8  44300.4  85892.3  67082.5  32158.8  0  0  0  0  0  0  0  0  0  15810.4  33994.3  55078.3  85641  151659  334684  554916  732310  590781  331957  70691.2  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  11789.5  64744.7  121807  193186  243317  202497  115645  24317.1  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  960573  174916  0  136374  993586  1.8441e+006  1.92991e+006  3.03495e+006  1.31047e+007  4.65182e+007  9.16249e+007  1.37986e+008  1.33314e+008  8.60013e+007  4.19191e+007  1.32598e+007  4.04162e+006  1.41205e+006  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  7754.61  67937.3  99051.1  150531  216079  244565  159661  63595.9  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  14452.5  29005.7  35286  30588.2  21185  11831.1  0  0  0  0  0  0  0  0  1366.36  91701  179496  288109  434197  517406  359182  151024  0  0  0  63243.7  160312  171636  95034  5596.75  0  0  0  0  0  0  0  0  8179.66  16440.3  27712.5  38477.4  47929.2  31342.5  26019.9  59155.3  135782  216038  241642  167755  85729.4  12481.1  0  0  0  0  0  0  0  14483.3  49421  110574  180946  217687  173260  105397  43313.1  0  0  0  21248.7  35694.3  19325.8  5368.26  0  0  0  0  0  0  0  0  10690.2  22788  27664.4  19704  7061.11  0  0  0  6988.12  25745.4  73160.7  83506.9  50202.2  21890.8  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  1.65038e+006  6.93915e+006  2.13171e+007  3.68888e+007  4.91278e+007  4.01078e+007  2.41707e+007  9.51399e+006  2.85991e+006  620248  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  8530.51  25618  66293.5  86071.8  68466.5  37744.3  8736.74  0  0  0  0  0  0  0  0  0  0  0  0  0  0  15988  31223.3  38828.8  30780.3  14679.4  0  0  4020.74  20084.3  96902  143334  136421  67184  3937.96  0  0  0  29215.9  58376.9  28367.3  3875.2  0  0  0  0  0  0  0  0  13779.3  28950.1  38985.4  34583.4  19994.8  7077.35  0  0  0  0  0  0  0  0  649.605  42703.1  102863  675627  2.62112e+006  5.99173e+006  9.6241e+006  1.07436e+007  7.58946e+006  4.21331e+006  1.46704e+006  480636  159069  0  0  0  0  0  0  0  0  0  6856.14  39156.2  104291  175803  203283  147265  86650.4  35519.8  10675.3  0  0  0  0  0  0  0  0  12418.6  17400.1  37178.9  107531  256363  441343  490807  339063  148145  48226.6  116906  383579  861486  1.39413e+006  1.63679e+006  1.2132e+006  707134  261800  78553.8  10524.9  0  0  0  0  0  0  0  0  785.907  25861.9  84745.9  148329  189330  150522  91819.8  38901.2  7876.87  0  0  0  0  0  0  0  0  11175.5  43705.4  97099.8  164607  190669  138639  72177.2  20538.4  17121.5  63480.2  175339  293057  374461  300567  183447  78540.5  20050.9  0  0  0  0  3744.07  17056.1  29686.2  29232.4  17226.6  5500.15  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0",
      "351.177 351.658 351.836 352.013 352.091 352.188 352.361 352.512 352.535 352.592 352.689 353.191 353.679 353.692 354.193",
      "41467.4 42725.1 85892.3 732310 243317 1.37986e+008 517406 241642 217687 83506.9 4.91278e+007 1.07436e+007 490807 1.63679e+006 374461"},

    { "346.657  346.658  346.66  346.661  346.663  346.664  346.666  346.667  346.669  346.67  346.672  346.673  346.675  346.677  346.678  346.68  346.681  346.683  346.684  346.686  346.687  346.689  346.69  346.692  346.693  347.172  347.173  347.175  347.176  347.178  347.179  347.181  347.182  347.184  347.185  347.187  347.189  347.19  347.192  347.193  347.195  347.196  347.198  347.199  347.201  347.202  347.204  347.205  347.207  347.209  347.21  347.212  347.213  347.215  347.216  347.218  347.219  347.496  347.497  347.499  347.5  347.502  347.503  347.505  347.506  347.508  347.509  347.511  347.514  347.515  347.517  347.519  347.638  347.64  347.641  347.643  347.645  347.646  347.648  347.649  347.651  347.652  347.654  347.655  347.657  347.657  347.659  347.66  347.662  347.663  347.665  347.666  347.668  347.669  347.671  347.672  347.674  347.676  347.677  347.679  347.68  347.682  347.683  347.685  347.686  347.688  347.689  347.691  347.692  347.694  347.695  347.697  347.698  347.7  347.701  347.703  347.704  347.706  347.707  347.709  347.71  347.712  347.714  347.715  347.717  347.718  347.889  347.891  347.892  347.894  347.895  347.897  347.898  347.9  347.901  347.903  347.905  347.906  347.908  347.909  347.911  348.166  348.168  348.17  348.171  348.173  348.174  348.176  348.177  348.179  348.18  348.182  348.183  348.185  348.186  348.188  348.19  348.191  348.192  348.194  348.196  348.205  348.206  348.208  348.209  348.211  348.213  348.214  348.216  348.217  348.219  348.22  348.222  348.223  348.225  348.226  348.228  348.229  348.231  348.404  348.405  348.407  348.408  348.41  348.411  348.413  348.414  348.416  348.418  348.419  348.421  348.422  348.424  348.425  348.427  348.428  348.546  348.547  348.549  348.55  348.552  348.553  348.555  348.557  348.558  348.56  348.562  348.563  348.565  348.605  348.606  348.608  348.609  348.611  348.613  348.614  348.616  348.617  348.619  348.62  348.622  348.623  348.625  348.626  348.628  348.668  348.67  348.671  348.673  348.674  348.676  348.677  348.679  348.68  348.682  348.683  348.685  348.687  348.688  348.69  348.691  348.692  348.694  348.695  348.711  348.712  348.714  348.716  348.717  348.719  348.72  348.722  348.723  348.725  348.726  348.728  348.729  348.731  348.733  348.807  348.808  348.81  348.811  348.813  348.814  348.816  348.818  348.819  348.821  348.822  348.824  348.825  348.881  348.882  348.884  348.886  348.887  348.889  348.89  348.892  348.893  348.895  348.896  348.898  348.899  348.901  349.158  349.159  349.161  349.162  349.164  349.165  349.167  349.169  349.17  349.172  349.173  349.175  349.176  349.178  349.179  349.181  349.182  349.184  349.186  349.187  349.189  349.19  349.192  349.193  349.213  349.215  349.217  349.218  349.22  349.221  349.223  349.224  349.226  349.227  349.229  349.23  349.232  349.667  349.669  349.67  349.672  349.674  349.675  349.677  349.678  349.68  349.681  349.683  349.684  349.686  349.688  349.689  349.691  349.84  349.841  349.843  349.844  349.846  349.847  349.849  349.85  349.852  349.854  349.855  349.857  349.858  349.86  349.919  349.92  349.922  349.923  349.925  349.926  349.928  349.93  349.931  349.933  349.934  349.936  349.937  349.939  349.94  349.942  350.15  350.152  350.153  350.155  350.156  350.158  350.159  350.161  350.163  350.164  350.166  350.167  350.169  350.17",
      "0  0  0  0  10961  19736  23900.7  17191.3  5730.37  0  0  0  0  3925.75  20286.6  75526.5  108467  91495.9  53060.8  18969.6  10484.3  0  0  0  0  0  0  0  0  9116.28  24824.4  60098.4  85781.8  63491.9  25226.3  7365.68  0  0  0  0  0  0  0  40008.4  163375  431393  722337  905032  693399  404135  131466  30054.5  3886.23  0  0  0  0  0  0  0  0  11650.6  20274.6  28407.2  33232.8  29180.1  16913  6058.11  0  0  0  0  0  0  0  0  7175.64  29635.3  75098.1  140327  201812  157294  79670.4  19492.5  11838  0  0  0  0  0  0  0  0  27246.2  110637  321655  1.10743e+006  3.39252e+006  6.24381e+006  8.97551e+006  8.13047e+006  5.06563e+006  2.2355e+006  589552  96055  22711.6  0  0  0  0  0  0  0  0  79486.7  135314  217641  303927  274002  158762  50415.3  5843.65  0  0  0  0  0  0  0  0  6378.47  16452  30734.8  41688.5  39587.3  24186.9  7521.96  0  0  0  0  0  0  0  0  0  137228  520728  1.47305e+006  2.54686e+006  3.43152e+006  2.89775e+006  1.7807e+006  738850  205995  25882.7  0  0  0  0  0  0  0  0  0  15056.6  18107  61576.1  140634  220529  240301  167534  90248.8  19140.2  0  0  0  0  0  0  0  0  0  3490.77  28803.8  92736.3  155649  191499  148143  86985.5  27287.5  8427.73  0  0  0  0  0  0  0  0  5484.38  18207.8  28203.5  25960.7  14556.8  0  0  0  0  0  0  0  0  13145.8  49422.9  91213.8  138111  143102  93875.7  45495.6  11453.6  0  0  0  0  0  0  0  0  0  20773.2  102388  290060  494374  663565  568254  350979  140934  25125.8  0  0  0  0  0  0  0  0  0  5373.93  18669  38749.3  52802.1  49014.6  31515.1  14239.2  0  0  0  0  0  0  0  0  12293.6  20885.9  22571.3  18410.3  13445.9  0  0  0  0  0  0  0  0  9753.48  19434  24437.9  23820.9  20193.2  13995  0  0  0  0  0  0  0  0  5937.7  17324.7  27357.2  27101.8  18934.3  11837.1  0  0  8061.73  16699.2  35868.9  65709.6  93781.2  48854.5  32311.7  13667  0  0  0  0  0  0  0  0  13770.8  25438.2  31622.3  26281.8  14405.3  0  0  0  0  0  0  0  0  11981.8  39357.6  75818.3  112272  113305  74893.5  33392.6  5898.17  0  0  0  0  0  0  0  0  6927.62  21253.5  33414.9  32682.9  21266.5  9401.1  0  0  0  0  0  0  0  0  7396.2  22461.8  57287  89930.3  82061.1  35789.6  16420.5  5355.56  0  0  0  0  0  0  0  0  15290.6  35150  47154.2  39139.1  19452.8  4374.33  0  0  0  0",
      "347.205 347.679 347.706 348.18 348.219 348.416 348.617 348.682 349.182 349.68 349.93 350.159",
      "905032 8.97551e+006 303927 3.43152e+006 240301 191499 143102 663565 93781.2 113305 89930.3 47154.2"},

    { "331.417  331.418  331.42  331.421  331.422  331.424  331.425  331.427  331.428  331.43  331.431  331.432  331.434  331.435  331.498  331.5  331.501  331.503  331.504  331.505  331.507  331.508  331.51  331.511  331.513  331.514  331.515  331.527  331.528  331.53  331.531  331.533  331.534  331.536  331.537  331.538  331.54  331.541  331.543  331.544  331.546  331.657  331.659  331.66  331.662  331.663  331.664  331.666  331.667  331.669  331.67  331.672  331.673  331.674  331.676  331.679  331.68  331.682  331.683  331.684  331.686  331.687  331.689  331.69  331.692  331.693  331.695  331.696  331.697  331.699  331.7  331.702  331.703  331.705  331.706  331.707  331.709  332.168  332.169  332.171  332.172  332.174  332.175  332.176  332.178  332.179  332.181  332.182  332.184  332.185  332.187  332.188  332.189  332.191  332.192  332.194  332.195  332.197  332.198  332.199  332.201  332.202  332.204  332.205  332.207  332.208  332.209  332.211  332.212  332.214  332.215  332.217  332.218  332.22  332.221  332.488  332.49  332.491  332.493  332.494  332.495  332.497  332.498  332.5  332.501  332.503  332.504  332.506  332.507  332.508  332.51  332.511  332.513  332.514  332.516  332.517  332.529  332.53  332.531  332.533  332.534  332.536  332.537  332.539  332.54  332.541  332.543  332.544  332.546  332.547  332.644  332.645  332.647  332.648  332.649  332.651  332.652  332.654  332.655  332.657  332.658  332.66  332.661  332.662  332.664  332.665  332.667  332.668  332.67  332.671  332.672  332.674  332.675  332.677  332.678  332.68  332.681  332.682  332.684  332.685  332.687  332.688  332.69  332.691  332.693  333.148  333.149  333.151  333.152  333.154  333.155  333.157  333.158  333.16  333.161  333.162  333.164  333.165  333.167  333.168  333.17  333.171  333.172  333.174  333.175  333.177  333.178  333.18  333.181  333.182  333.184  333.185  333.187  333.188  333.19  333.191  333.193  333.194  333.195  333.197  333.198  333.2  333.201  333.203  333.204  333.206  333.207  333.208  333.21  333.426  333.428  333.429  333.431  333.432  333.434  333.435  333.436  333.438  333.439  333.441  333.442  333.444  333.445  333.447  333.496  333.497  333.499  333.5  333.501  333.503  333.504  333.506  333.507  333.509  333.51  333.512  333.513  333.65  333.652  333.653  333.655  333.656  333.658  333.659  333.66  333.662  333.663  333.665  333.666  333.668  333.669  333.671  333.672  333.673  333.675  333.676  333.678  333.679  333.681  333.682  333.684  333.685  333.686  333.688  333.689  333.691  333.692  333.694  333.695  333.697  333.698  333.7  333.701  333.702  333.825  333.827  333.828  333.83  333.831  333.833  333.834  333.836  333.837  333.838  333.84  333.841  333.843  333.844  333.846  333.847  333.848  333.85  333.908  333.909  333.911  333.912  333.914  333.915  333.916  333.918  333.919  333.921  333.922  333.924  333.925  333.927  333.928  333.929  333.931  333.932  333.934  333.935  333.937  333.938  334.022  334.024  334.025  334.026  334.028  334.029  334.031  334.032  334.034  334.035  334.037  334.038  334.039  334.041  334.042  334.044  334.096  334.097  334.099  334.1  334.102  334.103  334.105  334.106  334.108  334.109  334.11  334.112  334.113  334.145  334.147  334.148  334.15  334.151  334.152  334.154  334.155  334.157  334.158  334.16  334.161  334.163  334.164  334.165  334.167  334.169  334.17  334.172  334.173  334.175  334.176  334.178  334.179  334.18  334.181  334.183  334.184  334.193  334.194  334.196  334.197  334.199  334.2  334.202  334.203  334.205  334.206  334.208  334.209  334.21  334.212  334.416  334.418  334.419  334.421  334.422  334.424  334.425  334.426  334.428  334.429  334.431  334.432  334.434  334.435  334.437  334.438  334.496  334.498  334.499  334.5  334.502  334.503  334.505  334.506  334.508  334.509  334.511  334.512  334.513  334.515  334.516  334.518  334.519  334.521  334.522  334.524  334.525  334.759  334.76  334.762  334.763  334.765  334.766  334.768  334.769  334.77  334.772  334.773  334.775  334.776  335.137  335.138  335.14  335.141  335.143  335.144  335.146  335.147  335.149  335.15  335.151  335.153  335.154  335.156  335.157  335.159",
      "0  0  0  0  9061.45  22475.3  35268.8  36668.2  25438.2  11599.9  0  0  0  0  0  0  0  0  9684.82  23491.2  29876.5  22922.6  10094.9  0  0  0  0  0  0  0  0  9180.43  24616.9  35830.4  33489.6  22024.2  10769.9  0  0  0  0  0  0  0  0  12611.7  26630.1  38491  37169.5  22907.8  8361.95  0  0  0  0  0  0  0  0  6017.46  16451.4  33026.8  45513  41936.2  24121.9  31508.3  96500.6  185384  268754  251719  157307  66427.3  7982.26  0  0  0  0  0  0  0  0  5301.39  16999.7  30492.7  34702  26142  13513  0  0  12371.7  21439.5  27209.5  22933.4  11143  0  0  0  12152.6  21551.1  29616.9  29137  19870.6  9552.69  0  0  9583.44  22087.5  33917  33539.6  20342.9  6326.05  0  0  0  0  0  0  0  0  16012.6  18628.8  20134.9  20056.2  14757.2  0  0  11785.8  17414.9  18161.4  17906.6  18225.8  14577.7  0  0  0  0  0  0  0  0  16134.3  28511.5  37712.6  37489.8  25852.6  10667.3  0  0  0  0  0  0  0  0  0  19508.7  82443.3  188324  619945  1.9855e+006  4.06909e+006  6.30896e+006  6.52736e+006  4.33407e+006  2.20647e+006  626399  125657  31194.3  1467.24  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  47966.7  212774  645467  1.35099e+006  2.12093e+006  2.31954e+006  1.61098e+006  869432  252399  24052.1  0  0  0  0  0  0  0  9829.23  47044.5  132065  260114  387895  434599  325228  193752  69077.4  1391.99  0  0  0  8567.48  16858.3  23593.1  19598.4  7774.21  0  0  0  0  0  0  0  0  15543.2  30067.6  41837.8  46424.1  40943.3  26134.3  10412  0  0  0  0  0  0  0  0  14687.1  24819.6  25448.2  18512.5  10335.4  0  0  0  0  0  0  0  0  5301.43  51854.2  139870  260759  390680  429501  308773  167807  48458.4  5679.48  26536.5  134058  275259  435874  415263  258480  120893  32803.5  21268.6  46093.2  77285.9  92951.2  63307.6  14315  6965.15  18630.5  30464.6  27335.3  13797.5  0  0  0  0  0  0  0  0  12223.4  40058  119628  290418  479852  572483  416679  233121  72538  13497.8  0  0  0  0  0  0  0  0  12797.7  17167.8  19493.1  18767.9  8198.32  23479.1  75136.8  150069  228020  228488  152024  81751.4  21547.1  0  0  0  0  0  0  0  0  0  6580.25  17297.4  34296.3  75219.4  90418.4  64444.5  27870.2  9619.08  0  0  0  0  0  0  0  0  9016.14  20745.7  26748.5  21052.4  9637.64  0  0  0  0  0  0  0  0  16005  31629.4  46047.7  49578.3  30034.5  0  0  18948.3  26620.7  24795.6  24223.6  34790.6  72499.6  161932  259385  313444  232452  127072  32151.1  299.507  0  0  0  0  0  0  0  0  14594.4  28556.9  39565.4  36836.2  21346.9  6174.35  0  0  0  0  0  0  0  0  10190.9  22115.6  36619.6  48988  73627.5  45387.1  21244.9  8144.69  0  0  0  0  0  0  0  0  6833.54  21736.1  33703.5  33385.7  23986.6  13445.4  0  0  15747.5  29735.5  35209.2  26973.5  13284  0  0  0  0  0  0  0  0  10951.5  18995.9  20908.2  17786.5  12780.8  0  0  0  0  0  0  0  0  9567.52  20894.6  61242.1  105287  138616  106383  57357  15748.4  0  0  0  0",
      "331.427 331.507 331.536 331.666 331.697 332.178 332.199 332.211 332.497 332.537 332.661 333.162 333.187 333.663 333.675 333.838 333.927 334.034 334.173 334.428 335.149",
      "36668.2 29876.5 35830.4 38491 268754 34702 29616.9 33917 20134.9 37712.6 6.52736e+006 2.31954e+006 434599 429501 435874 572483 228488 90418.4 313444 73627.5 138616"},

    { "323.501  323.502  323.503  323.505  323.506  323.507  323.509  323.51  323.512  323.513  323.514  323.516  323.517  323.518  323.644  323.646  323.647  323.648  323.65  323.651  323.652  323.654  323.655  323.657  323.658  323.659  323.661  323.662  323.663  323.665  323.666  323.668  323.669  323.677  323.679  323.68  323.681  323.683  323.684  323.686  323.687  323.688  323.69  323.691  323.692  323.694  323.695  323.697  323.698  323.699  323.701  323.702  323.704  323.705  323.706  323.708  323.709  323.71  323.712  323.713  323.715  323.716  323.717  323.719  323.72  323.721  323.723  323.724  323.726  323.727  323.728  323.73  323.731  323.733  323.734  323.736  323.737  323.738  323.83  323.831  323.832  323.834  323.835  323.836  323.838  323.839  323.841  323.842  323.843  323.845  323.846  323.847  323.849  323.85  323.851  324.135  324.136  324.138  324.139  324.14  324.142  324.143  324.145  324.146  324.147  324.149  324.15  324.152  324.153  324.154  324.156  324.157  324.158  324.16  324.165  324.167  324.168  324.17  324.171  324.172  324.174  324.175  324.176  324.178  324.179  324.181  324.182  324.183  324.185  324.186  324.516  324.517  324.519  324.52  324.521  324.523  324.524  324.526  324.527  324.529  324.531  324.532  324.533  324.639  324.64  324.642  324.643  324.644  324.646  324.647  324.648  324.65  324.651  324.653  324.654  324.655  324.656  324.657  324.659  324.66  324.662  324.663  324.664  324.666  324.667  324.669  324.67  324.671  324.673  324.674  324.675  324.677  324.678  324.68  324.681  324.682  324.684  324.685  324.687  324.688  324.689  324.691  324.692  324.694  324.695  324.696  324.918  324.92  324.921  324.923  324.924  324.925  324.927  324.928  324.93  324.931  324.932  324.934  324.935  324.937  324.938  324.939  324.941  324.942  324.943  324.945  325.142  325.144  325.145  325.146  325.148  325.149  325.15  325.152  325.153  325.155  325.156  325.157  325.159  325.16  325.162  325.163  325.164  325.166  325.167  325.169  325.17  325.171  325.173  325.174  325.176  325.177  325.178  325.18  325.181  325.183  325.184  325.185  325.187  325.188  325.19  325.191  325.192  325.194  325.195  325.196  325.198  325.199  325.201  325.202  325.203  325.205  325.206  325.208  325.209  325.21  325.212  325.214  325.215  325.216  325.421  325.422  325.424  325.425  325.426  325.428  325.429  325.431  325.432  325.433  325.435  325.436  325.438  325.439  325.44  325.442  325.443  325.444  325.489  325.49  325.492  325.493  325.495  325.496  325.497  325.499  325.5  325.502  325.503  325.504  325.506  325.507  325.508  325.51  325.511  325.675  325.677  325.678  325.68  325.681  325.682  325.684  325.685  325.687  325.688  325.689  325.691  325.692  325.694  325.695  325.697  325.698  325.699  325.701  325.702  325.704  325.705  325.706  325.708  325.709  325.711  325.712  325.713  325.714  325.716  325.825  325.826  325.827  325.829  325.83  325.832  325.833  325.834  325.836  325.837  325.839  325.84  325.841  325.843  325.844  325.846  325.847  325.848  325.85  326.16  326.161  326.162  326.164  326.165  326.167  326.168  326.169  326.171  326.172  326.174  326.175  326.176  326.178  326.197  326.199  326.2  326.202  326.203  326.204  326.206  326.207  326.209  326.21  326.211  326.213  326.214  326.216  326.501  326.502  326.504  326.505  326.506  326.508  326.509  326.511  326.512  326.513  326.515  326.516  326.518  326.519  326.651  326.652  326.653  326.655  326.656  326.658  326.659  326.66  326.662  326.663  326.665  326.666  326.667  326.669  326.67  326.672  326.673  326.674  326.676  326.677  326.679  326.68  326.681  326.683  326.684  326.686  326.995  326.997  326.998  326.999  327.001  327.002  327.004  327.005  327.007  327.008  327.009  327.011  327.012  327.014  327.015  327.016  327.018  327.065  327.067  327.068  327.07  327.071  327.072  327.074  327.075  327.077  327.078  327.079  327.081  327.082  327.084  327.085  327.086  327.151  327.152  327.154  327.155  327.157  327.158  327.159  327.161  327.162  327.164  327.165  327.167  327.168  327.169  327.171  327.172  327.174  327.175  327.176  327.178  327.179",
      "0  0  0  0  10337.1  18844  26745.4  27338.4  17689.7  5789.13  0  0  0  0  0  0  0  0  7286.37  14779.3  25612.3  34223.1  35399.5  33187  35262.3  38108.1  32455.4  19427.3  8598.15  0  0  0  0  0  0  0  0  13092.2  14060.2  15507.1  15363.8  10135.6  0  0  0  0  0  5642.38  15458.7  21145.9  18790.8  12537.6  0  0  0  0  0  0  0  0  12489.5  23207.2  33056  39926.3  38876.1  27563.1  13567.1  0  0  13769.2  14960.1  16061.1  15998.7  11080.1  0  0  0  0  0  0  0  0  444.065  22480.7  71263.8  120113  161383  135434  80233.6  27299.1  10688.8  0  0  0  0  0  0  0  0  7735.29  45031.6  162487  388211  638507  727670  508868  274897  82367.1  21216.6  11121.1  0  0  0  0  0  0  0  0  10105  25859  52954.1  77839.5  47540.5  32527.4  18670.8  9286.83  0  0  0  0  0  0  0  0  8622.65  20560.3  25392.8  19865.1  10677.6  0  0  0  0  0  0  0  0  4480.47  34809.1  86216.4  139740  163679  117988  63350.3  15869.6  4045.84  9890.41  28426.1  58851.2  97328  93800.3  56353.2  19169.8  0  0  0  0  0  21221.9  49062.5  178545  592302  1.4445e+006  2.36277e+006  2.81404e+006  2.08062e+006  1.19528e+006  392884  94920.7  19428.2  20638.6  0  0  0  0  0  0  0  0  0  7383.33  48332.3  197738  610304  1.15209e+006  1.70499e+006  1.65698e+006  1.07908e+006  533628  147334  15178.8  0  0  0  0  0  0  0  0  0  6147.82  19463.3  31613  31705.4  20236.4  7952.21  0  0  0  0  0  0  0  12524.1  28646.6  31545.5  20771.6  9887.13  0  0  0  45165  167066  360552  567111  636125  456093  252319  75731  6306.24  0  0  0  0  0  0  11094.4  43336.7  140496  263926  377126  339672  213119  92716.1  24500.9  9376.3  0  0  0  0  0  0  0  0  11563.4  14262.4  48032.6  111463  177177  209161  154221  84562.3  20214.7  0  0  0  0  0  0  0  0  0  9671.24  44132.1  130536  228343  319246  284670  173476  68365.2  9568.61  0  0  0  0  0  0  0  0  12291.4  26865.5  40631.8  44295.3  33657.2  16909.4  6274.83  0  0  0  0  0  0  5595.9  26001.6  79324.7  140353  195225  181277  116702  52946  6656.33  0  0  0  0  0  0  0  0  9116.18  18771.7  26816.6  30238.6  26806.1  17842.7  11908.6  17560.3  24388.6  20879.8  10532.4  0  0  0  0  0  0  0  0  10891.5  19324.2  23277.8  21311.3  13945  3618.28  0  0  0  0  0  0  0  0  5046.92  15072.7  22015.1  21299.4  16234  10706.6  0  0  0  0  0  0  0  0  6362.38  15238.3  20163  20221.7  16411.6  9357.98  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  22970.5  119833  406086  1.06384e+006  1.76941e+006  2.21103e+006  1.69738e+006  996431  330715  68393.4  0  0  0  0  0  0  0  0  0  6718.85  15941.2  58296.8  107245  139328  103126  57174.5  18600.5  6787.18  0  0  0  0  0  0  0  0  5769.67  16235.3  34910.2  71867.3  87315  65822.9  34335.3  10711.2  0  0  0  0  0  0  0  0  10055.3  18030.2  23946.1  26828  27876.2  31409.9  0  0  8799.44  77698.1  249057  523952  824207  895430  618459  331061  98200.3",
      "323.659 323.841 324.147 324.175 324.681 324.931 325.183 325.203 325.433 325.5 325.705 326.673 327.007 327.077 327.175",
      "38108.1 161383 727670 77839.5 2.81404e+006 1.70499e+006 636125 377126 209161 319246 195225 2.21103e+006 139328 87315 895430"},

    { "316.93  316.931  316.933  316.934  316.935  316.937  316.938  316.939  316.941  316.942  316.943  316.945  316.946  317.152  317.153  317.155  317.156  317.157  317.159  317.16  317.162  317.163  317.164  317.166  317.167  317.168  317.17  317.171  317.172  317.174  317.175  317.176  317.178  317.179  317.18  317.182  317.183  317.184  317.186  317.187  317.188  317.19  317.191  317.192  317.194  317.499  317.501  317.502  317.503  317.505  317.506  317.507  317.509  317.51  317.511  317.513  317.514  317.515  317.654  317.655  317.656  317.658  317.659  317.66  317.662  317.663  317.664  317.666  317.667  317.669  317.67  317.671  317.673  317.674  317.675  317.677  317.678  317.679  317.681  317.682  317.683  317.685  317.686  317.687  317.689  317.69  317.691  317.693  317.694  317.695  317.697  317.698  317.699  317.701  317.702  317.703  317.705  317.706  317.707  317.81  317.811  317.812  317.814  317.815  317.816  317.818  317.819  317.82  317.822  317.823  317.824  317.826  317.827  317.829  317.83  317.831  317.833  317.834  317.835  317.837  317.838  317.839  317.841  317.842  317.843  317.845  317.846  317.847  317.849  317.85  317.851  317.853  317.854  317.855  317.857  317.858  317.859  317.861  317.862  317.863  317.865  317.866  317.868  317.869  317.928  317.929  317.931  317.932  317.933  317.935  317.936  317.937  317.939  317.94  317.941  317.943  317.944  317.945  317.947  317.948  317.949  317.951  318.158  318.159  318.161  318.162  318.163  318.165  318.166  318.167  318.169  318.17  318.171  318.173  318.174  318.175  318.177  318.178  318.179  318.181  318.182  318.183  318.185  318.186  318.188  318.189  318.19  318.192  318.193  318.194  318.196  318.197  318.198  318.2  318.201  318.202  318.203  318.205  318.206  318.207  318.49  318.492  318.493  318.494  318.496  318.497  318.498  318.5  318.501  318.502  318.504  318.505  318.506  318.508  318.509  318.51  318.512  318.514  318.515  318.516  318.518  318.683  318.685  318.686  318.688  318.689  318.69  318.692  318.693  318.694  318.696  318.697  318.698  318.7  318.825  318.826  318.828  318.829  318.831  318.832  318.833  318.835  318.836  318.837  318.839  318.84  318.841  318.843  318.844  318.845  318.847  318.848  318.85  319.094  319.095  319.097  319.098  319.099  319.101  319.102  319.104  319.105  319.106  319.108  319.109  319.11  319.112  319.113  319.162  319.163  319.164  319.166  319.167  319.168  319.17  319.171  319.172  319.174  319.175  319.177  319.178  319.179  319.181  319.499  319.5  319.501  319.503  319.504  319.505  319.507  319.508  319.51  319.511  319.512  319.514  319.515  319.661  319.663  319.664  319.665  319.667  319.668  319.669  319.671  319.672  319.673  319.675  319.676  319.678  319.698  319.699  319.701  319.702  319.703  319.705  319.706  319.707  319.709  319.71  319.711  319.713  319.714  319.716  319.717  319.853  319.854  319.855  319.857  319.858  319.859  319.861  319.862  319.863  319.865  319.866  319.867  319.869  320.185  320.187  320.188  320.189  320.191  320.192  320.193  320.195  320.196  320.197  320.199  320.2  320.201  320.203  320.204  320.206  320.207  320.208  320.21  320.211  320.212  320.214  320.215  320.216  320.218  320.219  320.502  320.503  320.505  320.506  320.507  320.509  320.51  320.512  320.513  320.514  320.516  320.517  320.518  320.52  320.521  320.522",
      "0  0  0  0  7241.27  19682.1  27785.8  23786.1  11817.8  0  0  0  0  0  0  0  0  13211.6  54540.5  99481.3  152403  159280  100901  44174.8  5942.52  669.91  19020  24047.2  29295.1  32228.6  28107.4  17978.6  8561.04  0  0  11118.5  22135  31201.2  30940.3  22511.4  13362.5  0  0  0  0  0  0  0  0  6274.15  15618.1  18945.5  13924.8  6489.34  0  0  0  0  0  0  0  0  7115.21  22347.8  38114  40847  28384.4  12714.9  0  9728.08  20270.1  30845.3  33839  25561.4  11791.7  0  0  0  0  2838.75  30794.9  110881  264181  433533  494283  346541  186229  58071.1  31575  56479.1  88848.2  99857.9  74113.7  27142.1  10370.1  0  0  0  0  0  0  0  0  4210.3  14196.8  29404.4  40223.1  40661.7  31569.1  18046.1  6584.65  0  0  0  0  0  0  9015.66  84507.7  303362  881869  1.56398e+006  2.1689e+006  1.89473e+006  1.1745e+006  506045  129958  8192.9  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  9526.5  50942.6  157815  283530  398647  363474  232571  106562  26483.7  2350.44  0  0  0  0  0  0  0  0  0  257639  990140  1.72868e+006  2.28545e+006  1.82081e+006  1.13244e+006  598491  488134  431208  425376  153198  0  0  0  0  0  0  31092.5  77243.6  92134.5  42742.4  20480.1  9110.67  0  0  0  0  0  0  0  0  0  0  0  0  0  0  0  32241.4  201430  596658  1.01718e+006  1.32269e+006  1.07921e+006  674702  312270  150738  76963.9  26837.7  0  0  0  0  0  0  0  0  0  10405.6  18454.8  19731.5  14720  9263.62  0  0  0  0  0  0  0  0  0  30631.5  110156  256053  414666  490873  373001  223590  87841.3  20101.4  0  0  0  0  0  0  0  0  0  9320.82  22152.1  33638  38100.6  35254.2  26050.6  13168.7  0  0  0  0  0  0  0  0  13529.5  29369.4  47257.8  83492.8  58642.4  22383.5  6423.32  0  0  0  0  0  0  0  0  9006.56  21523.2  28310.6  22433.6  9918.16  0  0  0  0  0  0  0  0  5278.34  14654  21399.3  18021.8  7602  0  0  0  0  0  0  0  0  11153  59868.5  100026  127742  92760.2  45584.7  5273.03  0  0  0  0  0  0  0  0  7645.86  17039.9  21039.8  17552.4  11361  0  0  0  0  0  0  0  0  5561.98  14489.5  27837.5  40524.3  42870.9  31134.9  14509.6  4109.08  0  0  7191  20899.1  40191.3  78693.5  48652.2  35130.9  20294.4  8769.44  0  0  0  0  0  0  0  0  5084.17  17373  54040.9  90767.3  93585.1  56167.4  22545.6  8011.93  0  0  0  0",
      "317.163 317.689 317.841 317.939 318.169 318.502 318.837 319.707 320.208 320.513",
      "159280 494283 2.1689e+006 398647 2.28545e+006 1.32269e+006 490873 127742 78693.5 93585.1"},

    { "415.179  415.181  415.183  415.185  415.187  415.189  415.191  415.193  415.195  415.197  415.199  415.201  415.203  415.205  415.832  415.834  415.836  415.838  415.84  415.842  415.844  415.846  415.848  415.85  415.852  415.854  415.856  415.858  415.86  415.862  415.864  415.866  415.868  415.87  415.872  415.874  415.876  415.878  415.88  415.882  415.884  415.886  415.888  415.89  415.892  415.894  415.896  415.898  415.9  415.902  415.904  415.906  416.116  416.118  416.12  416.122  416.124  416.126  416.128  416.13  416.132  416.134  416.136  416.138  416.14  416.142  416.203  416.205  416.207  416.209  416.211  416.213  416.215  416.217  416.219  416.221  416.223  416.225  416.227  416.229  416.231  416.233  416.235  416.237  416.239  416.249  416.251  416.253  416.255  416.257  416.259  416.261  416.263  416.265  416.269  416.271  416.273  416.275  416.543  416.545  416.547  416.549  416.551  416.553  416.555  416.557  416.559  416.561  416.563  416.565  416.565  416.567  416.569  416.571  416.686  416.688  416.69  416.692  416.694  416.696  416.698  416.7  416.702  416.704  416.706  416.708  416.71  416.712  416.715  416.719  416.721  416.723  416.725  416.878  416.88  416.882  416.884  416.886  416.888  416.89  416.892  416.894  416.896  416.898  416.9  416.901  416.903  416.905  416.907  417.189  417.191  417.194  417.196  417.198  417.2  417.202  417.204  417.206  417.208  417.21  417.212  417.214  417.216  417.217  417.219  417.221  417.223  417.231  417.233  417.235  417.237  417.239  417.241  417.243  417.245  417.247  417.25  417.252  417.254  417.256  417.258  417.684  417.687  417.689  417.691  417.693  417.695  417.697  417.699  417.701  417.703  417.705  417.707  417.709  417.711  417.713  417.715  417.717  417.719  417.721",
      "0  0  0  0  13068  30313.6  44327  42763.5  27143  10681.3  0  0  0  0  0  0  0  0  12861.9  23932.4  28395.7  23919.2  16205.1  0  0  0  0  0  0  12611.1  32209.5  48624.5  29001  9739.21  0  0  0  9396.9  94225.4  360072  829765  1.33793e+006  1.52372e+006  1.08989e+006  607260  198301  46043.7  894.783  0  0  0  0  0  0  0  0  12735.4  22188  27313.5  26983.9  21415.5  11976.7  0  0  0  0  0  0  0  0  0  22379.6  82187.5  223771  484210  773082  879781  626408  345808  101896  14446.1  0  0  0  0  0  0  0  0  20150.6  32063.4  35461  26247.8  12074.9  0  0  0  0  0  0  0  0  15138  102952  166212  231266  242733  165744  82543  6802.75  0  0  0  0  0  0  0  0  1200.84  44406.5  158943  424244  713443  903608  698826  411095  139820  33835.6  2461.56  0  0  0  0  0  0  0  0  9622.32  28799.5  112977  153068  136163  77972.9  25924.5  0  0  0  0  0  0  0  0  0  7630.18  50758.5  145197  263044  375578  339783  212564  93956.1  23367.7  5491.11  0  0  0  0  0  0  0  0  13068.6  27194.7  39076.3  39616.8  27151.2  11416.8  0  0  0  0  0  0  0  0  20127.6  35614.7  43645.7  33615.7  9873.6  0  21477.2  42504.8  42405.9  24642.2  8445.45  0  0  0  0",
      "415.888 416.223 416.559 416.704 417.206",
      "1.52372e+006 879781 242733 903608 375578"},

    { "300.703  300.704  300.705  300.707  300.708  300.709  300.71  300.712  300.713  300.714  300.715  300.716  300.718  300.719  300.72  300.721  301.177  301.178  301.18  301.181  301.182  301.183  301.185  301.186  301.187  301.188  301.19  301.191  301.192  301.193  301.491  301.492  301.494  301.495  301.496  301.497  301.498  301.5  301.501  301.502  301.503  301.505  301.506  301.655  301.656  301.657  301.659  301.66  301.661  301.662  301.664  301.665  301.666  301.667  301.669  301.67  301.671  301.672  301.674  301.675  301.676  301.677  301.679  301.68  301.681  301.682  301.684  301.825  301.827  301.828  301.829  301.83  301.832  301.833  301.834  301.835  301.836  301.838  301.839  301.84  301.841  301.843  301.844  302.149  302.15  302.151  302.153  302.154  302.155  302.156  302.158  302.159  302.16  302.161  302.163  302.164  302.165  302.166  302.168  302.169  302.17  302.171  302.173  302.174  302.175  302.176  302.178  302.637  302.638  302.639  302.64  302.642  302.643  302.644  302.645  302.647  302.648  302.649  302.65  302.652  302.736  302.738  302.739  302.74  302.741  302.743  302.744  302.745  302.746  302.748  302.749  302.75  302.751  302.753  303.145  303.147  303.148  303.149  303.15  303.152  303.153  303.154  303.155  303.157  303.158  303.159  303.16  303.162  303.167  303.168  303.169  303.17  303.172  303.173  303.174  303.175  303.177  303.178  303.179  303.18  303.182  303.183  303.184  303.186  303.193  303.194  303.196  303.197  303.198  303.199  303.201  303.202  303.203  303.204  303.206  303.207  303.208  303.452  303.454  303.455  303.456  303.457  303.459  303.46  303.461  303.462  303.464  303.465  303.466  303.467  303.477  303.479  303.48  303.481  303.482  303.484  303.485  303.486  303.487  303.489  303.49  303.491  303.493  303.494  303.495  303.657  303.658  303.659  303.661  303.662  303.663  303.664  303.666  303.667  303.668  303.669  303.671  303.672  303.673  303.674  303.813  303.814  303.815  303.816  303.818  303.819  303.82  303.821  303.823  303.824  303.825  303.826  303.828  303.829  303.83  303.831  303.833  303.834  303.835  304.142  304.143  304.144  304.146  304.147  304.148  304.149  304.151  304.152  304.153  304.154  304.156  304.157  304.158  304.159",
      "0  0  0  0  4021.59  14948.3  29089.3  36172.3  33002.6  23872.1  13677  5631.91  0  0  0  0  0  0  0  0  3857.72  12358.4  21296.1  23339.3  16310.7  6581.76  0  0  0  0  0  0  0  0  5103.45  14404.9  20128  17722.4  11071  0  0  0  0  0  0  0  0  5040.13  35337.3  92693  150038  188818  156826  95523.6  36488.8  1633.48  0  14570.6  13804.9  13959  16252.2  16043.7  10491.2  0  0  0  0  0  0  0  0  11491.4  23253.9  33391.5  38064.9  35915.8  26480.2  13339.6  3360.52  0  0  0  0  0  0  0  0  9994.41  18678.4  23105.4  23357.1  21846.8  17762.7  12243  1230.6  23060.6  60254.8  97465.7  113113  88507.4  54246.1  18156.2  6643.82  0  0  0  0  0  0  0  0  9123.52  17445.2  21036  16344.5  7770.44  0  0  0  0  0  0  0  0  8312  20822.9  29108.9  25567.8  13950.4  3781.06  0  0  0  0  0  0  0  0  9115.97  17822.3  25208.4  25012.8  16827.3  8086.82  0  0  0  0  0  0  0  0  3947.37  12745.8  24975.9  32592.2  31830.1  24391.1  13880.6  4732.84  0  0  0  0  0  0  0  0  6750.57  14914.3  18383.8  16081.2  11665.7  0  0  0  0  0  0  0  0  4826.25  12462.4  16962.6  13627.1  6053.79  0  0  0  0  0  0  0  0  7090.97  18737.1  29710.3  31932.3  24547.1  13431.4  4401.52  0  0  0  0  0  0  0  0  8864.78  24483.2  54372.2  81053.3  67322.2  27272.1  10297.5  0  0  0  0  0  0  0  0  11422.7  23786.6  33943.1  32175  18417.9  5897.95  6002.16  14535.1  18982.7  14518.1  6290.84  0  0  0  0  0  0  0  0  11744.6  23937.1  31048  29687.7  22535  13681.6  8906.82  14661.8  27257.5  43105  43170.2",
      "300.712 301.186 301.665 301.834 302.168 302.644 302.744 303.153 303.175 303.486 303.666 303.82 304.159",
      "36172.3 23339.3 188818 38064.9 113113 21036 29108.9 25208.4 32592.2 31932.3 81053.3 33943.1 43170.2"},

    { "452.06  452.062  452.065  452.067  452.069  452.071  452.074  452.076  452.078  452.081  452.082  452.084  452.087  452.089  452.192  452.194  452.196  452.198  452.201  452.203  452.205  452.208  452.21  452.212  452.214  452.217  452.22  452.222  452.224  452.226  452.446  452.448  452.45  452.452  452.455  452.457  452.459  452.461  452.464  452.466  452.468  452.471  452.473  452.475  452.477  452.48  452.482  452.484  452.694  452.697  452.699  452.701  452.704  452.706  452.708  452.71  452.713  452.715  452.717  452.72  452.722  452.724  452.726  452.729  452.731  452.733  452.95  452.953  452.955  452.957  452.96  452.962  452.964  452.966  452.969  452.971  452.973  452.976  452.978  452.98  452.982  453.454  453.456  453.458  453.461  453.463  453.465  453.468  453.47  453.472  453.474  453.477  453.479  453.481  454.158  454.16  454.162  454.165  454.167  454.169  454.172  454.174  454.176  454.178  454.181  454.183  454.185  454.188  454.714  454.716  454.718  454.721  454.723  454.725  454.728  454.73  454.732  454.735  454.737  454.739  454.741",
      "0  0  0  0  9364.36  24041.2  38252.2  41150.4  31605.1  17604.6  0  0  0  0  0  0  0  0  3930.9  41824.5  95963.9  154164  152063  95638.9  43562  12495.1  0  0  0  0  0  0  0  0  0  28332.8  103440  204407  311126  307518  199724  97813.7  28554.9  2987.27  0  0  0  0  0  0  0  0  0  37076.2  121274  226216  331181  324273  217272  115224  35782.4  0  0  0  0  0  0  0  0  0  18286.8  60113.4  102915  133571  104506  59294.7  17472.9  0  0  0  0  0  0  0  0  10894.4  21954.3  28972.5  28655.5  21029.8  0  0  0  0  0  0  0  0  17264.7  32830.8  41807.6  38619.2  26607.2  12618.2  0  0  0  0  0  0  0  0  19933.8  29881.3  34532.2  30762.8  19924.3  0  0  0  0",
      "452.208 452.464 452.713 452.966 453.468 454.172 454.728",
      "154164 311126 331181 133571 28972.5 41807.6 34532.2"},

    { "307.696  307.697  307.699  307.7  307.701  307.702  307.704  307.705  307.706  307.708  307.709  307.71  307.711  307.713  307.714  307.715  307.717  307.718  308.17  308.172  308.173  308.174  308.175  308.177  308.178  308.179  308.181  308.182  308.183  308.185  308.186  308.2  308.201  308.203  308.204  308.205  308.206  308.208  308.209  308.21  308.212  308.213  308.214  308.215  308.217  308.218  308.219  308.22  308.222  308.491  308.493  308.494  308.495  308.496  308.498  308.499  308.5  308.502  308.503  308.504  308.505  308.507  308.508  308.509  308.628  308.629  308.63  308.631  308.633  308.634  308.635  308.637  308.638  308.639  308.64  308.642  308.643  308.644  308.645  308.647  308.662  308.663  308.665  308.666  308.667  308.668  308.67  308.671  308.672  308.674  308.675  308.676  308.677  308.679  308.68  308.682  308.683  308.702  308.703  308.705  308.706  308.707  308.709  308.71  308.711  308.712  308.714  308.715  308.716  308.718  308.719  308.72  308.721  308.723  308.833  308.835  308.836  308.837  308.839  308.84  308.841  308.842  308.844  308.845  308.846  308.848  308.849  308.85  308.851  308.853  308.854  308.855  308.857  308.858  308.859  308.86  308.89  308.891  308.893  308.894  308.895  308.896  308.898  308.899  308.9  308.902  308.903  308.905  308.906  309.157  309.158  309.16  309.161  309.162  309.164  309.165  309.166  309.167  309.169  309.17  309.171  309.173  309.174  309.175  309.176  309.177  309.178  309.18  309.181  309.182  309.184  309.185  309.186  309.187  309.189  309.19  309.192  309.193  309.194  309.491  309.492  309.494  309.495  309.496  309.498  309.499  309.5  309.501  309.503  309.504  309.505  309.507  309.508  309.509  309.51  309.512  309.513  309.514  309.515  309.517  309.518  309.519  309.521  309.522  309.523  309.524  309.526  309.527  309.664  309.665  309.667  309.668  309.669  309.67  309.672  309.673  309.674  309.676  309.677  309.678  309.679  309.681  309.682  309.683  309.685  309.686  309.827  309.828  309.83  309.831  309.832  309.833  309.835  309.836  309.837  309.839  309.84  309.841  309.843  309.844  309.845  309.846  310.166  310.167  310.169  310.17  310.171  310.173  310.174  310.175  310.177  310.178  310.179  310.18  310.182  310.183  310.184  310.186  310.187  310.188  310.189  310.191  310.192  310.193  310.195  310.651  310.653  310.654  310.655  310.656  310.658  310.659  310.66  310.662  310.663  310.664  310.666  310.667  310.668  310.67  310.671  310.816  310.818  310.819  310.82  310.822  310.823  310.824  310.826  310.827  310.828  310.829  310.831  310.832  310.833  310.835  310.836  310.837  310.838  310.84  310.841  310.842  310.844  310.845  310.858  310.859  310.86  310.862  310.863  310.864  310.866  310.867  310.868  310.87  310.871  310.872  310.874  310.875  311.122  311.123  311.125  311.126  311.127  311.129  311.13  311.131  311.133  311.134  311.135  311.136  311.138  311.139  311.14  311.141  311.143  311.144  311.145  311.147  311.148  311.149  311.151  311.152  311.153  311.154  311.156  311.157  311.158  311.16  311.161  311.162  311.164  311.165  311.166  311.167  311.169  311.17  311.171  311.173  311.174  311.175  311.177  311.178  311.179  311.181",
      "0  0  0  0  9802.36  23098.1  80318.2  168123  260050  249021  153699  69134.6  15860.2  0  0  0  0  0  0  0  0  0  6603.17  16854.7  22242.6  17002.5  6384.9  0  0  0  0  0  0  0  0  3259.21  45522.7  136253  256874  378108  384887  264149  143498  38861.2  0  0  0  0  0  0  0  0  0  9568.38  16779.6  25703.4  34804.3  36903.4  27626.5  13210.8  0  0  0  0  0  0  0  0  6020.72  19418.9  41247.7  87139.4  101517  51696.3  31958.5  13406.6  0  0  0  0  0  0  0  0  8887.19  32368.8  88172.5  150448  183012  138562  83560.8  34576.6  9382.31  0  0  0  0  0  0  0  0  6136.98  17078.9  37706.1  99369.4  120669  89079.4  48058.7  16632.9  5690.8  0  0  0  0  0  0  0  0  13659  36722.7  21354.1  19439.5  43622.3  141202  361101  593217  725619  549023  320363  106084  18987.1  0  0  0  0  0  0  0  0  0  7044.94  21287  31346.9  27932.1  15042.7  0  0  0  0  0  0  0  0  12545.5  66956  196850  483967  796603  1.00996e+006  800685  478608  175846  31025.8  0  0  0  21565.5  116573  248949  372585  340360  208008  89705.4  16994.2  0  0  0  0  0  0  0  0  0  0  20664.3  76813.8  211847  360938  474556  391964  238310  96484.5  13402.4  0  0  15903.2  18823.3  38109.2  78987.2  115813  103941  60973.3  21474.4  8379.21  0  0  0  0  0  0  0  0  5010.87  39835  145701  261216  355012  297678  181623  70393.1  19551.4  9556.91  0  0  0  0  0  0  0  0  13098.9  30137.5  82208.8  121291  126226  84746  41315  13074.1  0  0  0  0  0  0  0  0  7583.31  24991.6  42441.5  47113.5  37361.7  22733.3  11295.4  0  0  15445.3  25939.6  29374.9  24399.7  16278.2  8806.05  0  0  0  0  0  0  0  0  13501.6  32925.8  78379.3  112170  101026  58511.2  22918.4  7815.47  0  0  0  0  0  0  0  0  0  16485.2  87297.2  250447  436618  588792  489043  298868  118211  35326.5  17949.5  28044.3  49970.6  30360.5  12383.3  0  0  0  0  0  0  0  0  12935.3  27576.7  33616.7  27724.5  17214.9  8642.67  0  0  0  0  0  0  0  0  4327.09  28941.4  100849  182836  253955  223430  137468  54432.1  7270.05  0  0  0  0  0  11368.6  20920.1  27685.4  29939.4  25376  15654.1  0  0  0  0  26913.6  134469  249526  300649  223246  136273  126863  259141  410598  488277  350133  183857  33436.7  0  0  0  0  0",
      "307.706 308.212 308.672 308.712 308.849 309.169 309.182 309.503 309.674 310.828 311.133 311.17",
      "260050 384887 183012 120669 725619 1.00996e+006 372585 474556 355012 588792 253955 488277"},

    { "507.723  507.726  507.729  507.731  507.734  507.737  507.74  507.742  507.745  507.748  507.75  507.753  507.756  507.758  507.761  507.764  508.228  508.231  508.234  508.236  508.239  508.242  508.245  508.247  508.25  508.253  508.255  508.258  508.261  508.264  510.229  510.231  510.234  510.237  510.24  510.242  510.245  510.248  510.251  510.253  510.256  510.259  510.262  510.264",
      "0  0  0  0  20993.6  79292.2  151677  219202  191318  115566  45767.5  12062.2  0  0  0  0  0  0  0  0  10042.1  24206  34397.5  33192  22528.5  10434.2  0  0  0  0  0  0  0  0  9028.83  22351.6  35166.6  38509.2  29599.8  14844.1  0  0  0  0",
      "507.742 508.245 510.248",
      "219202 34397.5 38509.2"},
 
};

const size_t testDataSize = sizeof(testData) / sizeof(TestData);


vector<double> parseDoubleArray(const string& doubleArray)
{
    vector<double> doubleVector;
    vector<string> tokens;
    bal::split(tokens, doubleArray, bal::is_space(), bal::token_compress_on);
    if (!tokens.empty() && !tokens[0].empty())
        for (size_t i=0; i < tokens.size(); ++i)
            doubleVector.push_back(lexical_cast<double>(tokens[i]));
    return doubleVector;
}


void test()
{
    for (size_t i=0; i < testDataSize; ++i)
    {
        const TestData& data = testData[i];
        
        vector<double> xRaw = parseDoubleArray(data.xRaw);
        vector<double> yRaw = parseDoubleArray(data.yRaw);
        vector<double> target_xPeakValues = parseDoubleArray(data.xPeakValues);
        vector<double> target_yPeakValues = parseDoubleArray(data.yPeakValues);

        // sanity checks
        unit_assert(xRaw.size() == yRaw.size());
        unit_assert(target_xPeakValues.size() == target_yPeakValues.size());

        CwtPeakDetector peakDetector(1.0,0,0.01);
        vector<double> xPeakValues, yPeakValues;
        peakDetector.detect(xRaw, yRaw, xPeakValues, yPeakValues);

        unit_assert(xPeakValues.size() == target_xPeakValues.size());

        for (size_t j=0; j < xPeakValues.size(); ++j)
        {
            unit_assert_equal(xPeakValues[j], target_xPeakValues[j], 1e-5);
            unit_assert_equal(yPeakValues[j], target_yPeakValues[j], 1e-5);
        }
    }
}


int main(int argc, char* argv[])
{
    TEST_PROLOG(argc, argv)

    try
    {
        if (argc>1 && !strcmp(argv[1],"-v")) os_ = &cout;
        test();
    }
    catch (exception& e)
    {
        TEST_FAILED(e.what())
    }
    catch (...)
    {
        TEST_FAILED("Caught unknown exception.")
    }

    TEST_EPILOG
}
