/***************************************************************************
 *   Copyright (C) 2007 by Anistratov Oleg                                 *
 *   ower86@gmail.com                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation;                         *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 ***************************************************************************/
#include "messagefilter.h"

#include "filtrationrule.h"
#include "message.h"

MessageFilter::MessageFilter()
{
}

MessageFilter::~MessageFilter()
{
}

bool MessageFilter::isGoodMessage(Message* msg)
{
  foreach(FiltrationRule* fr, m_whiteRules)
    if(fr->activated() && fr->checkMessage(msg))
      return true;

  return false;
}

bool MessageFilter::isBadMessage(Message* msg)
{
  foreach(FiltrationRule* fr, m_blackRules)
    if(fr->activated() && fr->checkMessage(msg))
      return true;

  return false;
}

bool MessageFilter::validateMessage(Message * msg, bool blacklist)
{
  return (blacklist ? !isBadMessage(msg) : isGoodMessage(msg));
}

void MessageFilter::save(QSettings* settings) const
{
  int i = 0;

  settings->setValue("BlackRulesNumber", m_blackRules.size());
  settings->setValue("WhiteRulesNumber", m_whiteRules.size());

  settings->beginGroup("BlackRules");

  foreach(FiltrationRule* fr, m_blackRules)
  {
    settings->beginGroup(QString("Rule%1").arg(i++));
    fr->save(settings);
    settings->endGroup();
  }

  settings->endGroup();

  settings->beginGroup("WhiteRules");

  foreach(FiltrationRule* fr, m_whiteRules)
  {
    settings->beginGroup(QString("Rule%1").arg(i++));
    fr->save(settings);
    settings->endGroup();
  }

  settings->endGroup();
}

void MessageFilter::load(QSettings* settings)
{
  int black_rules_num;
  int white_rules_num;
  FiltrationRule* fr;

  black_rules_num = settings->value("BlackRulesNumber").toInt();
  white_rules_num = settings->value("WhiteRulesNumber").toInt();

  settings->beginGroup("BlackRules");

  for(int i = 0; i < black_rules_num; i++)
  {
    fr = new FiltrationRule;

    settings->beginGroup(QString("Rule%1").arg(i));
    fr->load(settings);
    settings->endGroup();

    m_blackRules.append(fr);
  }

  settings->endGroup();

  settings->beginGroup("WhiteRules");

  for(int i = 0; i < white_rules_num; i++)
  {
    fr = new FiltrationRule;

    settings->beginGroup(QString("Rule%1").arg(i));
    fr->load(settings);
    settings->endGroup();

    m_whiteRules.append(fr);
  }

  settings->endGroup();
}

void MessageFilter::removeRule(FiltrationRule* rule)
{
  m_whiteRules.removeAll(rule);
  m_blackRules.removeAll(rule);

  delete rule;
}
