// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_VIEWS_MUS_VIEWS_AURA_MUS_TEST_SUITE_H_
#define UI_VIEWS_MUS_VIEWS_AURA_MUS_TEST_SUITE_H_

#include <memory>

#include "base/macros.h"
#include "ui/views/views_test_suite.h"

namespace views {

class ServiceManagerConnection;

class ViewsAuraMusTestSuite : public ViewsTestSuite {
 public:
  ViewsAuraMusTestSuite(int argc, char** argv);
  ~ViewsAuraMusTestSuite() override;

 private:
  // ViewsTestSuite:
  void Initialize() override;
  void Shutdown() override;

  std::unique_ptr<ServiceManagerConnection> service_manager_connections_;

  DISALLOW_COPY_AND_ASSIGN(ViewsAuraMusTestSuite);
};

}  // namespace views

#endif  // UI_VIEWS_MUS_VIEWS_AURA_MUS_TEST_SUITE_H_
