/*
 * QuteCom, a voice over Internet phone
 * Copyright (C) 2010 Mbdsys
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "QtVoicemailSettings.h"

#include "ui_VoicemailSettings.h"

#include <model/config/ConfigManager.h>
#include <model/config/Config.h>
#include <model/profile/UserProfile.h>
#include <model/profile/UserProfileHandler.h>

#include <control/CQuteCom.h>
#include <control/profile/CUserProfileHandler.h>

#include <qtutil/SafeConnect.h>
#include <util/Logger.h>
#include <util/SafeDelete.h>
#include <util/StringList.h>

#include <QtGui/QtGui>

QtVoicemailSettings::QtVoicemailSettings(CQuteCom & cQuteCom, QWidget * parent)
	: QWidget(parent),
	_cQuteCom(cQuteCom) {

	_ui = new Ui::VoicemailSettings();
	_ui->setupUi(this);

	readConfig();
}

QtVoicemailSettings::~QtVoicemailSettings() {
	OWSAFE_DELETE(_ui);
}

QString QtVoicemailSettings::getName() const {
	return tr("Voicemail");
}

QString QtVoicemailSettings::getTitle() const {
	return tr("Voicemail Settings");
}

QString QtVoicemailSettings::getIconName() const {
	return "voicemail";
}

void QtVoicemailSettings::saveConfig() {
	UserProfile * userprofile = _cQuteCom.getCUserProfileHandler().getUserProfileHandler().getCurrentUserProfile();
	if (userprofile) {
		SipAccount * sipaccount = userprofile->getSipAccount();
		if (sipaccount) {
			sipaccount->setVoicemailNumber(std::string(_ui->voicemailNumber->text().toUtf8()));
		}
	}
}

void QtVoicemailSettings::readConfig() {
	std::string number = "123";

	UserProfile * userprofile = _cQuteCom.getCUserProfileHandler().getUserProfileHandler().getCurrentUserProfile();
	if (userprofile) {
		SipAccount * sipaccount = userprofile->getSipAccount();
		if (sipaccount) {
			number = sipaccount->getVoicemailNumber();
		}
	} else {
		setEnabled(false);
	}

	_ui->voicemailNumber->setText(QString::fromUtf8(number.c_str()));
}
