/*   Theorur - A GUI for Ogg/Theora streaming
 *   Copyright (C) 2006-2009 Rafael Diniz <rafael@riseup.net>
 *
 *   This file is part of Theorur.
 *
 *   Theorur is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   Theorur is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with Theorur.  If not, see <http://www.gnu.org/licenses/>.
 *
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <gtk/gtk.h>
#include <libintl.h>
#include <locale.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <sys/mman.h>
#include <fcntl.h>
#include <dirent.h>


#ifndef __GLOBAL_H__
#include "global.h"
#endif

/* some defines */
#ifndef __CONSTANTS_H__
#include "constants.h"
#endif

#ifndef __INTERFACE_H__
#include "interface.h"
#endif

#ifndef __TOOLTIPS_H__
#include "tooltips.h"
#endif

int main( int  argc, char *argv[], char *envp[]) {
  DIR *directory;
  char *foo;
  char bar[256], path[256];
  char locale[16];
  int i = 0, fd;

  if (!gtk_init_check (&argc, &argv)) {
    fprintf(stderr, "Display cannot be initialized, wait for the curses interface :-P\n");
    exit (-1);
  }

  if (envp[i] == NULL) {
    fprintf(stderr, "hummmm, Environment variables not found?\n");
    exit(-1);
  }
  

  /* Sets the shared area                               */
  /* 00 means streaming stopped, don't update label    */
  /* 01 means streaming stopped, update label          */
  /* 10 means streaming started, don't update label    */
  /* 11 means streaming started, update label          */
  shared_area = mmap (0, 3, PROT_READ | PROT_WRITE, MAP_SHARED | MAP_ANON, -1, 0);
  sprintf ((char *) shared_area, "00"); 

  /* sets the auto reconnect flag */
  reconnect_flag = 0;

  /* get the user HOME */
  strcpy(home, getenv("HOME"));

  /* if not exists, create the config directory */
  strcat(home,"/.theorur");
  if ( !(directory = opendir(home)) ) {
    if (mkdir(home, S_IRWXU ))
      fprintf(stderr, "Error: %s cannot be created\n", home);
  }
  else
    closedir(directory);

  /* sets the location of the configuration files */
  strcpy (theorur_cfg, home);
  strcat (theorur_cfg, "/theorur.cfg");
  strcpy (theorur_temp, home);
  strcat (theorur_temp, "/theorur.temp");

  /* the fifo for the debug window of darkice */
  unlink(theorur_temp);
  if(mkfifo(theorur_temp, S_IRWXU )) 
    fprintf(stderr, "error creating the fifo at %s\n", theorur_temp);
  theorur_output_fd = open (theorur_temp, O_RDONLY | O_NONBLOCK);
  
  /* internacionalization stuff */
  setlocale (LC_ALL, "");

  strcpy(locale, INTLPREFIX);
  strcat(locale, "/share/locale");

  bindtextdomain ("theorur", locale);
  textdomain ("theorur");
  
  /* check if dvgrab, ffmpeg2theora and oggfwd exists in path */
  strcpy (path, getenv("PATH"));

  i = 0;
  while ( sscanf(path+i, "%[^:]:", bar) != -1){
    i = i + strlen(bar) + 1;
    if ( (fd = open(strcat(bar,"/dvgrab"), O_RDONLY)) != -1){
      printf("dvgrab found!\n");
      close (fd);
      goto out1;
    }
  }
 out1: if (!i) {theorurcmds_not_found(); exit(-1);}
  
  i = 0;
  while ( sscanf(path+i, "%[^:]:", bar) != -1){
    i = i + strlen(bar) + 1;
    if ( (fd = open(strcat(bar,"/ffmpeg2theora"), O_RDONLY)) != -1){
      printf("ffmpeg2theora found!\n"); 
      close (fd);
      goto out2;
    }
  }
  out2: if (!i) {theorurcmds_not_found(); exit(-1);}
 
  i = 0;
  while ( sscanf(path+i, "%[^:]:", bar) != -1){
    i = i + strlen(bar) + 1;
    if ( (fd = open(strcat(bar,"/oggfwd"), O_RDONLY)) != -1){
      printf("oggfwd found!\n");
      close (fd);
      goto out3;
    }
  }
  out3: if (!i) {theorurcmds_not_found(); exit(-1);}

  
  /* Now the GTK+ stuff ...  */

  g_timeout_add (1000, (GSourceFunc) status_loop, 0); /* status_loop() updates the streaming status */
  
  window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  button_start = gtk_button_new_with_label ( gettext("Start Streaming") );
  button_stop = gtk_button_new_with_label ( gettext("Stop Streaming") );
  button_detail = gtk_button_new_with_label ( gettext("Show Details") );
  show_detail = 0;
  label_status = gtk_label_new ( gettext("Streaming Status: Stopped"));
  table = gtk_table_new (2, 1, FALSE);
  vbox = gtk_vbox_new (FALSE, 0); /* packs the menu_bar and the table */


  /* main window stuff */
  gtk_window_set_title (GTK_WINDOW (window), "Theorur");
  gtk_widget_set_size_request (GTK_WIDGET (window), SIZE_X, SIZE_Y); 
  gtk_container_set_border_width (GTK_CONTAINER (window), 0);


  /* sets up the upper menu stuff */
  menu_bar = gtk_menu_bar_new();  

  menu_file = gtk_menu_new();
  menu_item_file = gtk_menu_item_new_with_label ( gettext("File") );
  menu_item_open = gtk_menu_item_new_with_label ( gettext("Open Configuration") );
  menu_item_save = gtk_menu_item_new_with_label ( gettext("Save Configuration") );
  menu_item_quit_nd = gtk_menu_item_new_with_label ( gettext("Quit and don't stop streaming") );
  menu_item_quit = gtk_menu_item_new_with_label ( gettext("Quit") ); 
  gtk_menu_shell_append (GTK_MENU_SHELL (menu_file), menu_item_open);
  gtk_menu_shell_append (GTK_MENU_SHELL (menu_file), menu_item_save);
  gtk_menu_shell_append (GTK_MENU_SHELL (menu_file), menu_item_quit_nd);
  gtk_menu_shell_append (GTK_MENU_SHELL (menu_file), menu_item_quit);
  gtk_menu_item_set_submenu (GTK_MENU_ITEM (menu_item_file), menu_file);
  gtk_menu_bar_append ( GTK_MENU_BAR (menu_bar), menu_item_file );
  
  menu_help = gtk_menu_new();
  menu_item_help = gtk_menu_item_new_with_label ( gettext("Help") );
  menu_item_about = gtk_menu_item_new_with_label ( gettext("About") );
  gtk_menu_shell_append (GTK_MENU_SHELL (menu_help), menu_item_about);
  gtk_menu_item_set_submenu (GTK_MENU_ITEM (menu_item_help), menu_help);
  gtk_menu_bar_append ( GTK_MENU_BAR (menu_bar), menu_item_help );

  gtk_box_pack_start (GTK_BOX (vbox), menu_bar, FALSE, FALSE, 0);

  /* sets up the about dialog */
 
  sprintf(bar, gettext("Theorur version: %s\nSoftware written by Rafael Diniz\nLicense: GNU Public License v3"),VERSION);
  dialog_about = gtk_dialog_new ();
  label_about = gtk_label_new ( bar );
  button_about = gtk_button_new_with_label ( gettext("Close"));
  gtk_window_set_title(GTK_WINDOW (dialog_about), gettext("About Theorur"));
  gtk_widget_set_size_request (GTK_WIDGET (dialog_about), 350, 200); 
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog_about)->action_area), button_about, TRUE, TRUE, 0);
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog_about)->vbox), label_about, TRUE, TRUE, 0);

  /* sets up the exit window */
  dialog_theorurkill = gtk_dialog_new ();
  label_theorurkill = gtk_label_new (gettext("Streaming is running.\nDo you want to kill the streaming?\n"));
  button_yes_theorurkill = gtk_button_new_with_label (gettext("Yes"));
  button_no_theorurkill = gtk_button_new_with_label (gettext("No"));

  gtk_window_set_title(GTK_WINDOW (dialog_theorurkill), gettext("Streaming is running"));
  gtk_widget_set_size_request (GTK_WIDGET (dialog_theorurkill), 300, 200); 
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog_theorurkill)->action_area), button_yes_theorurkill, TRUE, TRUE, 0);
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog_theorurkill)->action_area), button_no_theorurkill, TRUE, TRUE, 0);
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog_theorurkill)->vbox), label_theorurkill, TRUE, TRUE, 0);
  
  g_signal_connect_swapped (G_OBJECT (dialog_theorurkill), "delete_event",G_CALLBACK (gtk_widget_hide), dialog_theorurkill);
  g_signal_connect (G_OBJECT (button_yes_theorurkill), "clicked",G_CALLBACK (delete_event), NULL);
  g_signal_connect (G_OBJECT (button_no_theorurkill), "clicked",G_CALLBACK (delete_event_nd), NULL);

  /* sets up the file selectors */
  file_open = gtk_file_selection_new ( gettext("Open File") );
  file_save = gtk_file_selection_new ( gettext("Save File") );
  file_localdump_enc = gtk_file_selection_new ( gettext("Local Dump File (Encoded)") );
  file_localdump_raw = gtk_file_selection_new ( gettext("Local Dump File (Raw)") );

  /* our checkbuttons */
  checkbutton_adddate = gtk_check_button_new_with_label ( gettext ("Add date to local dump filename? "));
  checkbutton_reconnect = gtk_check_button_new_with_label ( gettext ("Automatically reconnect? "));

  /* sets up the notebook stuff */
  notebook = gtk_notebook_new ();
  gtk_notebook_set_tab_pos ( GTK_NOTEBOOK (notebook), GTK_POS_TOP );

  table_server = gtk_table_new (1, 1, FALSE);
  table_av = gtk_table_new (1, 1, FALSE);
  table_description = gtk_table_new (1, 1, FALSE);

  label_notebook_server = gtk_label_new ( gettext("Server Options"));
  label_notebook_av = gtk_label_new ( gettext("Audio/Video Options"));
  label_notebook_description = gtk_label_new ( gettext("Streaming Description"));
  
  gtk_notebook_insert_page ( GTK_NOTEBOOK (notebook), table_server, label_notebook_server, 1);
  gtk_notebook_insert_page ( GTK_NOTEBOOK (notebook), table_av, label_notebook_av, 2);
  gtk_notebook_insert_page ( GTK_NOTEBOOK (notebook), table_description, label_notebook_description, 3);


  /* Server Options Widgets */
  label_server = gtk_label_new ( gettext("Server: "));
  entry_server = gtk_entry_new ();
  label_port = gtk_label_new ( gettext("Port: "));
  entry_port = gtk_entry_new ();
  label_mountpoint = gtk_label_new ( gettext("Mount Point: "));
  entry_mountpoint = gtk_entry_new ();
  label_pass = gtk_label_new ( gettext("Password: "));
  entry_pass = gtk_entry_new ();
  gtk_entry_set_visibility (GTK_ENTRY(entry_pass), FALSE);

  button_localdump_enc = gtk_button_new_with_label ( gettext("Local Dump File (Encoded)"));
  button_localdump_raw = gtk_button_new_with_label ( gettext("Local Dump File (Raw)"));
  entry_localdump_enc = gtk_entry_new ();
  entry_localdump_raw = gtk_entry_new ();
  
  
  /* End Server Options Widgets */

  /* Audio/Video Options Widgets */
  label_input = gtk_label_new ( gettext("Input Type: "));
  combo_input = gtk_combo_new ();
  glist_input = NULL;
  glist_input = g_list_append (glist_input, gettext("V4L - analog input"));
  glist_input = g_list_append (glist_input, gettext("IEEE1394 - digital input"));
  gtk_combo_set_popdown_strings (GTK_COMBO (combo_input), glist_input);
  gtk_entry_set_text ( GTK_ENTRY(GTK_COMBO(combo_input)->entry), gettext("IEEE1394 - digital input"));

  label_asamplerate = gtk_label_new ( gettext("Audio SampleRate: "));
  combo_asamplerate = gtk_combo_new ();
  glist_asamplerate = NULL;
  glist_asamplerate = g_list_append (glist_asamplerate, "8000");
  glist_asamplerate = g_list_append (glist_asamplerate, "11025");
  glist_asamplerate = g_list_append (glist_asamplerate, "22050");
  glist_asamplerate = g_list_append (glist_asamplerate, "44100");
  glist_asamplerate = g_list_append (glist_asamplerate, "48000");
  glist_asamplerate = g_list_append (glist_asamplerate, "96000");
  gtk_combo_set_popdown_strings (GTK_COMBO (combo_asamplerate), glist_asamplerate);
  gtk_entry_set_text ( GTK_ENTRY(GTK_COMBO(combo_asamplerate)->entry), "22050");

  label_vsize = gtk_label_new ( gettext("Video Size: "));
  combo_vsize = gtk_combo_new ();
  glist_vsize = NULL;
  /* not anymore, because of v4l incapabily to try a videosize when you don't provide one */
  /*  glist_vsize = g_list_append (glist_vsize, gettext("don't change")); */
  glist_vsize = g_list_append (glist_vsize, "720x480");
  glist_vsize = g_list_append (glist_vsize, "720x576");
  glist_vsize = g_list_append (glist_vsize, "360x240");

  glist_vsize = g_list_append (glist_vsize, "64x48");
  glist_vsize = g_list_append (glist_vsize, "128x96");
  glist_vsize = g_list_append (glist_vsize, "160x128");
  glist_vsize = g_list_append (glist_vsize, "192x160");
  glist_vsize = g_list_append (glist_vsize, "256x192");
  glist_vsize = g_list_append (glist_vsize, "320x240");


  glist_vsize = g_list_append (glist_vsize, "384x288");
  glist_vsize = g_list_append (glist_vsize, "448x336");
  glist_vsize = g_list_append (glist_vsize, "512x384");  
  glist_vsize = g_list_append (glist_vsize, "640x480");
  glist_vsize = g_list_append (glist_vsize, "800x600");
  glist_vsize = g_list_append (glist_vsize, "1024x768");

  glist_vsize = g_list_append (glist_vsize, "64x36");
  glist_vsize = g_list_append (glist_vsize, "128x72");
  glist_vsize = g_list_append (glist_vsize, "192x108");
  glist_vsize = g_list_append (glist_vsize, "256x144");
  
  glist_vsize = g_list_append (glist_vsize, "512x288");
  glist_vsize = g_list_append (glist_vsize, "640x360");
  
  glist_vsize = g_list_append (glist_vsize, "800x450");
  glist_vsize = g_list_append (glist_vsize, "1024x576");

  gtk_combo_set_popdown_strings (GTK_COMBO (combo_vsize), glist_vsize);
  gtk_entry_set_text ( GTK_ENTRY(GTK_COMBO(combo_vsize)->entry), "320x240");

  label_achannel = gtk_label_new ( gettext("Number of audio channels: "));
  combo_achannel = gtk_combo_new ();
  glist_achannel = NULL;
  glist_achannel = g_list_append (glist_achannel, "2 - Stereo");
  glist_achannel = g_list_append (glist_achannel, "1 - Mono");
  gtk_combo_set_popdown_strings (GTK_COMBO (combo_achannel), glist_achannel);
  gtk_entry_set_text ( GTK_ENTRY(GTK_COMBO(combo_achannel)->entry), "1 - Mono");

  label_vquality = gtk_label_new ( gettext("Video Quality: "));
  combo_vquality = gtk_combo_new ();  
  glist_vquality = NULL;
  glist_vquality = g_list_append (glist_vquality, "0");
  glist_vquality = g_list_append (glist_vquality, "1");
  glist_vquality = g_list_append (glist_vquality, "2");
  glist_vquality = g_list_append (glist_vquality, "3");
  glist_vquality = g_list_append (glist_vquality, "4");
  glist_vquality = g_list_append (glist_vquality, "5");
  glist_vquality = g_list_append (glist_vquality, "6");
  glist_vquality = g_list_append (glist_vquality, "7");
  glist_vquality = g_list_append (glist_vquality, "8");
  glist_vquality = g_list_append (glist_vquality, "9");
  glist_vquality = g_list_append (glist_vquality, "10");
  gtk_combo_set_popdown_strings (GTK_COMBO (combo_vquality), glist_vquality);
  gtk_entry_set_text ( GTK_ENTRY(GTK_COMBO(combo_vquality)->entry), "2");


  label_aquality = gtk_label_new ( gettext("Audio Quality: "));
  combo_aquality = gtk_combo_new ();  
  glist_aquality = NULL;

  glist_aquality = g_list_append (glist_aquality, "-2");
  glist_aquality = g_list_append (glist_aquality, "-1");
  glist_aquality = g_list_append (glist_aquality, "0");
  glist_aquality = g_list_append (glist_aquality, "1");
  glist_aquality = g_list_append (glist_aquality, "2");
  glist_aquality = g_list_append (glist_aquality, "3");
  glist_aquality = g_list_append (glist_aquality, "4");
  glist_aquality = g_list_append (glist_aquality, "5");
  glist_aquality = g_list_append (glist_aquality, "6");
  glist_aquality = g_list_append (glist_aquality, "7");
  glist_aquality = g_list_append (glist_aquality, "8");
  glist_aquality = g_list_append (glist_aquality, "9");
  glist_aquality = g_list_append (glist_aquality, "10");
  gtk_combo_set_popdown_strings (GTK_COMBO (combo_aquality), glist_aquality);
  gtk_entry_set_text ( GTK_ENTRY(GTK_COMBO(combo_aquality)->entry), "0");
  

  label_vfps = gtk_label_new ( gettext("Video FPS: "));
  combo_vfps = gtk_combo_new ();
  glist_vfps = NULL;
  glist_vfps = g_list_append (glist_vfps, gettext("don't change"));
  glist_vfps = g_list_append (glist_vfps, "1");
  glist_vfps = g_list_append (glist_vfps, "2");
  glist_vfps = g_list_append (glist_vfps, "3");
  glist_vfps = g_list_append (glist_vfps, "4");
  glist_vfps = g_list_append (glist_vfps, "5");
  glist_vfps = g_list_append (glist_vfps, "6");
  glist_vfps = g_list_append (glist_vfps, "7");
  glist_vfps = g_list_append (glist_vfps, "8");
  glist_vfps = g_list_append (glist_vfps, "9");
  glist_vfps = g_list_append (glist_vfps, "10");
  glist_vfps = g_list_append (glist_vfps, "11");
  glist_vfps = g_list_append (glist_vfps, "12");
  glist_vfps = g_list_append (glist_vfps, "13");
  glist_vfps = g_list_append (glist_vfps, "14");
  glist_vfps = g_list_append (glist_vfps, "15");
  glist_vfps = g_list_append (glist_vfps, "16");
  glist_vfps = g_list_append (glist_vfps, "17");
  glist_vfps = g_list_append (glist_vfps, "18");
  glist_vfps = g_list_append (glist_vfps, "19");
  glist_vfps = g_list_append (glist_vfps, "20");
  glist_vfps = g_list_append (glist_vfps, "21");
  glist_vfps = g_list_append (glist_vfps, "22");
  glist_vfps = g_list_append (glist_vfps, "23");
  glist_vfps = g_list_append (glist_vfps, "24");
  glist_vfps = g_list_append (glist_vfps, "25");
  glist_vfps = g_list_append (glist_vfps, "26");
  glist_vfps = g_list_append (glist_vfps, "27");
  glist_vfps = g_list_append (glist_vfps, "28");
  glist_vfps = g_list_append (glist_vfps, "29");
  glist_vfps = g_list_append (glist_vfps, "30");
  gtk_combo_set_popdown_strings (GTK_COMBO (combo_vfps), glist_vfps);
  gtk_entry_set_text ( GTK_ENTRY(GTK_COMBO(combo_vfps)->entry), "15");

  label_v4ldevice = gtk_label_new ( gettext ("V4L Device Input: "));
  combo_v4ldevice = gtk_combo_new ();
  glist_v4ldevice = NULL;
  glist_v4ldevice = g_list_append (glist_v4ldevice, "/dev/video");
  glist_v4ldevice = g_list_append (glist_v4ldevice, "/dev/video0");
  glist_v4ldevice = g_list_append (glist_v4ldevice, "/dev/video1");
  glist_v4ldevice = g_list_append (glist_v4ldevice, "/dev/video2");
  glist_v4ldevice = g_list_append (glist_v4ldevice, "/dev/v4l/video0");
  glist_v4ldevice = g_list_append (glist_v4ldevice, "/dev/v4l/video1");
  glist_v4ldevice = g_list_append (glist_v4ldevice, "/dev/v4l/video2");
  gtk_combo_set_popdown_strings (GTK_COMBO (combo_v4ldevice), glist_v4ldevice);
  gtk_entry_set_text ( GTK_ENTRY(GTK_COMBO(combo_v4ldevice)->entry), "/dev/video");  

  label_adevice = gtk_label_new ( gettext ("Analog Audio Device Input: "));
  combo_adevice = gtk_combo_new ();
  glist_adevice = NULL;
  glist_adevice = g_list_append (glist_adevice, "/dev/dsp");
  glist_adevice = g_list_append (glist_adevice, "/dev/dsp0");
  glist_adevice = g_list_append (glist_adevice, "/dev/dsp1");
  glist_adevice = g_list_append (glist_adevice, "/dev/dsp3");
  gtk_combo_set_popdown_strings (GTK_COMBO (combo_adevice), glist_adevice);
  gtk_entry_set_text ( GTK_ENTRY(GTK_COMBO(combo_adevice)->entry), "/dev/dsp");  

  /* End Audio/Video Options Widgets */
  
  /* configuration widgets stuff - label + entry */
  label_streamname = gtk_label_new ( gettext("Streaming Name: "));
  entry_streamname = gtk_entry_new ();
  label_url = gtk_label_new ( gettext("URL: "));
  entry_url = gtk_entry_new ();
  label_description = gtk_label_new ( gettext("Description: "));
  entry_description = gtk_entry_new ();
  label_genre = gtk_label_new ( gettext("Genre: "));
  entry_genre = gtk_entry_new ();
  
  /* configuration widgets stuff - label + combo box */

  
  label_public = gtk_label_new ( gettext("Public: "));
  combo_public = gtk_combo_new ();
  glist_public = NULL;
  glist_public = g_list_append (glist_public, gettext("yes"));
  glist_public = g_list_append (glist_public, gettext("no"));
  gtk_combo_set_popdown_strings (GTK_COMBO (combo_public), glist_public);


  /* text view stuff */
  tag = gtk_text_tag_new ("");
  tag_table = gtk_text_tag_table_new();
  gtk_text_tag_table_add(tag_table, tag);
  buffer = gtk_text_buffer_new(tag_table);
  foo = gettext("Theorur - A graphical user interface for theora streaming\nThe Revolution will be streamed!");
  gtk_text_buffer_set_text(buffer, foo,strlen(foo));
  text = gtk_text_view_new_with_buffer (buffer);
  gtk_text_view_set_editable(GTK_TEXT_VIEW (text), FALSE);    

  /* scroll for the textview widget */
  scroll_text = gtk_scrolled_window_new (NULL, NULL);
  gtk_scrolled_window_set_policy ( GTK_SCROLLED_WINDOW (scroll_text), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
  gtk_container_add (GTK_CONTAINER (scroll_text), text);


  /* the magic :-) */
  gtk_box_pack_end (GTK_BOX (vbox), table, TRUE, TRUE, 5);
  gtk_container_add (GTK_CONTAINER (window), vbox);


  /* set the widgets tooltips */
  set_all_tooltips();
  

  g_signal_connect (G_OBJECT (window), "delete_event",G_CALLBACK (main_quit), NULL);
  
  g_signal_connect_swapped (G_OBJECT (dialog_about), "delete_event",G_CALLBACK (gtk_widget_hide), dialog_about);
  g_signal_connect_swapped (G_OBJECT (button_about), "clicked",G_CALLBACK (gtk_widget_hide), dialog_about);

  g_signal_connect (G_OBJECT (button_start), "clicked", G_CALLBACK (theorur_start), NULL);
  g_signal_connect (G_OBJECT (button_stop), "clicked", G_CALLBACK (theorur_stop), NULL);
  g_signal_connect (G_OBJECT (button_detail), "clicked", G_CALLBACK (theorur_detail), NULL);
  
  g_signal_connect_swapped (G_OBJECT (menu_item_open), "activate", G_CALLBACK (gtk_widget_show), file_open);
  g_signal_connect_swapped (G_OBJECT (menu_item_save), "activate", G_CALLBACK (gtk_widget_show), file_save);
  g_signal_connect (G_OBJECT (menu_item_quit), "activate", G_CALLBACK (main_quit), NULL);
  g_signal_connect (G_OBJECT (menu_item_quit_nd), "activate", G_CALLBACK (delete_event_nd), NULL);
  g_signal_connect (G_OBJECT (menu_item_about), "activate", G_CALLBACK (theorur_about), NULL);
  
  g_signal_connect_swapped (G_OBJECT (button_localdump_enc), "clicked", G_CALLBACK (gtk_widget_show), file_localdump_enc);
  g_signal_connect_swapped (G_OBJECT (button_localdump_raw), "clicked", G_CALLBACK (gtk_widget_show), file_localdump_raw);


  g_signal_connect ( G_OBJECT (GTK_FILE_SELECTION (file_open)->ok_button), "clicked", G_CALLBACK (theorur_put_in_box), NULL);
  g_signal_connect_swapped ( G_OBJECT (GTK_FILE_SELECTION (file_open)->cancel_button), "clicked", G_CALLBACK (gtk_widget_hide), file_open);
  g_signal_connect_swapped ( G_OBJECT (file_open), "delete_event", G_CALLBACK (gtk_widget_hide), file_open);

  g_signal_connect ( G_OBJECT (GTK_FILE_SELECTION (file_save)->ok_button), "clicked", G_CALLBACK (theorur_write_config), NULL);
  g_signal_connect_swapped ( G_OBJECT (GTK_FILE_SELECTION (file_save)->cancel_button), "clicked", G_CALLBACK (gtk_widget_hide), file_save);
  g_signal_connect_swapped ( G_OBJECT (file_save), "delete_event", G_CALLBACK (gtk_widget_hide), file_save);

  g_signal_connect ( G_OBJECT (GTK_FILE_SELECTION (file_localdump_enc)->ok_button), "clicked", G_CALLBACK (theorur_localdump_enc), NULL);
  g_signal_connect_swapped ( G_OBJECT (GTK_FILE_SELECTION (file_localdump_enc)->cancel_button), "clicked", G_CALLBACK (gtk_widget_hide), file_localdump_enc);
  g_signal_connect_swapped ( G_OBJECT (file_localdump_enc), "delete_event", G_CALLBACK (gtk_widget_hide), file_localdump_enc);

  g_signal_connect ( G_OBJECT (GTK_FILE_SELECTION (file_localdump_raw)->ok_button), "clicked", G_CALLBACK (theorur_localdump_raw), NULL);
  g_signal_connect_swapped ( G_OBJECT (GTK_FILE_SELECTION (file_localdump_raw)->cancel_button), "clicked", G_CALLBACK (gtk_widget_hide), file_localdump_raw);
  g_signal_connect_swapped ( G_OBJECT (file_localdump_raw), "delete_event", G_CALLBACK (gtk_widget_hide), file_localdump_raw);
  
  /* pack the notebook, the buttons and textview widgets into the main table */
  gtk_table_attach (GTK_TABLE (table), notebook, 0, SIZE_X, 0, 400, (GTK_FILL | GTK_SHRINK | GTK_EXPAND), (GTK_FILL | GTK_SHRINK), 5, 5);
  gtk_table_attach (GTK_TABLE (table), button_start, 0,  SIZE_X/2,  401,  430, (GTK_SHRINK | GTK_FILL), (GTK_SHRINK | GTK_FILL), 45, 5);
  gtk_table_attach (GTK_TABLE (table), button_stop,  SIZE_X/2+1, SIZE_X, 401,  430, (GTK_SHRINK | GTK_FILL), (GTK_SHRINK | GTK_FILL), 45, 5);
  gtk_table_attach (GTK_TABLE (table), scroll_text, 0, SIZE_X, 431, 560, (GTK_FILL | GTK_SHRINK | GTK_EXPAND), (GTK_FILL | GTK_SHRINK | GTK_EXPAND), 5, 5); 
  gtk_table_attach (GTK_TABLE (table), label_status, 0, 3*SIZE_X/5, 561, 570, (GTK_FILL | GTK_SHRINK), (GTK_FILL | GTK_SHRINK ), 0, 3);  
  gtk_table_attach (GTK_TABLE (table), button_detail, 3*SIZE_X/5+1, SIZE_X, 561, 570, (GTK_FILL | GTK_SHRINK), (GTK_FILL | GTK_SHRINK), 10, 3);  



  /* server notebook tab */
  gtk_table_attach (GTK_TABLE (table_server), label_server, 0, SIZE_X/2, 0,  25, (GTK_FILL | GTK_SHRINK), (GTK_FILL | GTK_SHRINK), 0, 5);
  gtk_table_attach (GTK_TABLE (table_server), entry_server, SIZE_X/2+1, SIZE_X, 0,  25, (GTK_FILL |  GTK_SHRINK | GTK_EXPAND),(GTK_FILL | GTK_SHRINK), 10, 5);
  
  gtk_table_attach (GTK_TABLE (table_server), label_port,  0,  SIZE_X/2,   26,  50, (GTK_FILL |  GTK_SHRINK),(GTK_FILL | GTK_SHRINK), 0, 5);
  gtk_table_attach (GTK_TABLE (table_server), entry_port, SIZE_X/2+1, SIZE_X,   26,  50, (GTK_FILL |  GTK_SHRINK | GTK_EXPAND),(GTK_FILL | GTK_SHRINK), 10, 5);
  
  gtk_table_attach (GTK_TABLE (table_server), label_mountpoint, 0, SIZE_X/2, 51, 75, (GTK_FILL |  GTK_SHRINK),(GTK_FILL | GTK_SHRINK), 0, 5);
  gtk_table_attach (GTK_TABLE (table_server), entry_mountpoint, SIZE_X/2+1, SIZE_X, 51, 75, (GTK_FILL |  GTK_SHRINK | GTK_EXPAND),(GTK_FILL | GTK_SHRINK), 10, 5);
  
  gtk_table_attach (GTK_TABLE (table_server), label_pass, 0, SIZE_X/2, 76, 100, (GTK_FILL |  GTK_SHRINK),(GTK_FILL | GTK_SHRINK), 0, 5);
  gtk_table_attach (GTK_TABLE (table_server), entry_pass, SIZE_X/2+1, SIZE_X, 76, 100, (GTK_FILL |  GTK_SHRINK | GTK_EXPAND),(GTK_FILL | GTK_SHRINK), 10, 5);

  gtk_table_attach (GTK_TABLE (table_server), button_localdump_enc, 0, SIZE_X/2, 101, 125, (GTK_FILL |  GTK_SHRINK),(GTK_FILL | GTK_SHRINK), 0, 5);
  gtk_table_attach (GTK_TABLE (table_server), entry_localdump_enc, SIZE_X/2+1, SIZE_X, 101, 125, (GTK_FILL |  GTK_SHRINK | GTK_EXPAND),(GTK_FILL | GTK_SHRINK), 10, 5);

  gtk_table_attach (GTK_TABLE (table_server), button_localdump_raw, 0, SIZE_X/2, 126, 150, (GTK_FILL |  GTK_SHRINK),(GTK_FILL | GTK_SHRINK), 0, 5);
  gtk_table_attach (GTK_TABLE (table_server), entry_localdump_raw, SIZE_X/2+1, SIZE_X, 126, 150, (GTK_FILL |  GTK_SHRINK | GTK_EXPAND),(GTK_FILL | GTK_SHRINK), 10, 5);
  
  gtk_table_attach (GTK_TABLE (table_server), checkbutton_adddate, 0, SIZE_X, 151,  175, (GTK_FILL |  GTK_SHRINK),(GTK_FILL | GTK_SHRINK), 0, 5);

  gtk_table_attach (GTK_TABLE (table_server), checkbutton_reconnect, 0, SIZE_X, 176,  200, (GTK_FILL |  GTK_SHRINK),(GTK_FILL | GTK_SHRINK), 0, 5);


  /* audio/video notebook tab */
  gtk_table_attach (GTK_TABLE (table_av), label_input, 0, SIZE_X/2, 0,  25, (GTK_FILL |  GTK_SHRINK),(GTK_FILL | GTK_SHRINK), 0, 5);
  gtk_table_attach (GTK_TABLE (table_av), combo_input, SIZE_X/2+1, SIZE_X, 0,  25, (GTK_FILL |  GTK_SHRINK | GTK_EXPAND),(GTK_FILL | GTK_SHRINK), 10, 5);
  
  gtk_table_attach (GTK_TABLE (table_av), label_aquality, 0, SIZE_X/2, 26,  50, (GTK_FILL |  GTK_SHRINK),(GTK_FILL | GTK_SHRINK), 0, 5);
  gtk_table_attach (GTK_TABLE (table_av), combo_aquality, SIZE_X/2+1, SIZE_X, 26,  50, (GTK_FILL |  GTK_SHRINK | GTK_EXPAND),(GTK_FILL | GTK_SHRINK), 10, 5);
  
  gtk_table_attach (GTK_TABLE (table_av), label_asamplerate, 0, SIZE_X/2, 51, 75, (GTK_FILL |  GTK_SHRINK),(GTK_FILL | GTK_SHRINK), 0, 5);
  gtk_table_attach (GTK_TABLE (table_av), combo_asamplerate, SIZE_X/2+1, SIZE_X, 51, 75, (GTK_FILL |  GTK_SHRINK | GTK_EXPAND),(GTK_FILL | GTK_SHRINK), 10, 5);

  gtk_table_attach (GTK_TABLE (table_av), label_achannel, 0, SIZE_X/2, 76, 100, (GTK_FILL |  GTK_SHRINK),(GTK_FILL | GTK_SHRINK), 0, 5);
  gtk_table_attach (GTK_TABLE (table_av), combo_achannel, SIZE_X/2+1, SIZE_X, 76, 100, (GTK_FILL |  GTK_SHRINK | GTK_EXPAND),(GTK_FILL | GTK_SHRINK), 10, 5);

  gtk_table_attach (GTK_TABLE (table_av), label_vquality, 0, SIZE_X/2, 101, 125, (GTK_FILL |  GTK_SHRINK),(GTK_FILL | GTK_SHRINK), 0, 5);
  gtk_table_attach (GTK_TABLE (table_av), combo_vquality, SIZE_X/2+1, SIZE_X, 101, 125, (GTK_FILL |  GTK_SHRINK | GTK_EXPAND),(GTK_FILL | GTK_SHRINK), 10, 5);

  gtk_table_attach (GTK_TABLE (table_av), label_vfps, 0, SIZE_X/2, 126, 150, (GTK_FILL |  GTK_SHRINK),(GTK_FILL | GTK_SHRINK), 0, 5);
  gtk_table_attach (GTK_TABLE (table_av), combo_vfps, SIZE_X/2+1, SIZE_X, 126, 150, (GTK_FILL |  GTK_SHRINK | GTK_EXPAND),(GTK_FILL | GTK_SHRINK), 10, 5);

  gtk_table_attach (GTK_TABLE (table_av), label_vsize, 0, SIZE_X/2, 176, 200, (GTK_FILL |  GTK_SHRINK),(GTK_FILL | GTK_SHRINK), 0, 5);
  gtk_table_attach (GTK_TABLE (table_av), combo_vsize, SIZE_X/2+1, SIZE_X, 176, 200, (GTK_FILL |  GTK_SHRINK | GTK_EXPAND),(GTK_FILL | GTK_SHRINK), 10, 5);

  gtk_table_attach (GTK_TABLE (table_av), label_v4ldevice, 0, SIZE_X/2, 201, 225, (GTK_FILL |  GTK_SHRINK),(GTK_FILL | GTK_SHRINK), 0, 5);
  gtk_table_attach (GTK_TABLE (table_av), combo_v4ldevice, SIZE_X/2+1, SIZE_X, 201, 225, (GTK_FILL |  GTK_SHRINK | GTK_EXPAND),(GTK_FILL | GTK_SHRINK), 10, 5);

  gtk_table_attach (GTK_TABLE (table_av), label_adevice, 0, SIZE_X/2, 226, 250, (GTK_FILL |  GTK_SHRINK),(GTK_FILL | GTK_SHRINK), 0, 5);
  gtk_table_attach (GTK_TABLE (table_av), combo_adevice, SIZE_X/2+1, SIZE_X, 226, 250, (GTK_FILL |  GTK_SHRINK | GTK_EXPAND),(GTK_FILL | GTK_SHRINK), 10, 5);


  /* description notebook tab */
  gtk_table_attach (GTK_TABLE (table_description), label_streamname, 0, SIZE_X/2, 0, 25, (GTK_FILL |  GTK_SHRINK),(GTK_FILL | GTK_SHRINK), 0, 5);
  gtk_table_attach (GTK_TABLE (table_description), entry_streamname, SIZE_X/2+1, SIZE_X, 0, 25, (GTK_FILL |  GTK_SHRINK | GTK_EXPAND),(GTK_FILL | GTK_SHRINK), 10, 5);
  
  gtk_table_attach (GTK_TABLE (table_description), label_description, 0, SIZE_X/2, 26, 50, (GTK_FILL |  GTK_SHRINK),(GTK_FILL | GTK_SHRINK), 0, 5);
  gtk_table_attach (GTK_TABLE (table_description), entry_description, SIZE_X/2+1, SIZE_X, 26, 50, (GTK_FILL |  GTK_SHRINK | GTK_EXPAND),(GTK_FILL | GTK_SHRINK), 10, 5);
  
  gtk_table_attach (GTK_TABLE (table_description), label_url, 0, SIZE_X/2, 51,  75, (GTK_FILL |  GTK_SHRINK),(GTK_FILL | GTK_SHRINK), 0, 5);
  gtk_table_attach (GTK_TABLE (table_description), entry_url, SIZE_X/2+1, SIZE_X, 51,  75, (GTK_FILL |  GTK_SHRINK | GTK_EXPAND),(GTK_FILL | GTK_SHRINK), 10, 5);
  
  gtk_table_attach (GTK_TABLE (table_description), label_genre, 0, SIZE_X/2, 76,  100, (GTK_FILL |  GTK_SHRINK),(GTK_FILL | GTK_SHRINK), 0, 5);
  gtk_table_attach (GTK_TABLE (table_description), entry_genre, SIZE_X/2+1, SIZE_X, 76,  100, (GTK_FILL |  GTK_SHRINK | GTK_EXPAND),(GTK_FILL | GTK_SHRINK), 10, 5);
  
  gtk_table_attach (GTK_TABLE (table_description), label_public, 0, SIZE_X/2, 101,  125, (GTK_FILL |  GTK_SHRINK), (GTK_FILL | GTK_SHRINK), 0, 5);
  gtk_table_attach (GTK_TABLE (table_description), combo_public, SIZE_X/2+1, SIZE_X, 101, 125, (GTK_FILL |  GTK_SHRINK | GTK_EXPAND),(GTK_FILL | GTK_SHRINK), 10, 5);
  

  
  /* show all widgets */ 
  gtk_widget_show (button_start);
  gtk_widget_show (button_stop);
  gtk_widget_show (button_detail);
  gtk_widget_show (label_status);

  gtk_widget_show (label_about);
  gtk_widget_show (button_about);
  
  gtk_widget_show (label_server);
  gtk_widget_show (entry_server);
  
  gtk_widget_show (label_port);
  gtk_widget_show (entry_port);
  
  gtk_widget_show (label_mountpoint);
  gtk_widget_show (entry_mountpoint);

  gtk_widget_show (label_pass);
  gtk_widget_show (entry_pass);

  gtk_widget_show (button_localdump_enc);
  gtk_widget_show (entry_localdump_enc);

  gtk_widget_show (button_localdump_raw);
  gtk_widget_show (entry_localdump_raw);

  gtk_widget_show (checkbutton_adddate);
  gtk_widget_show (checkbutton_reconnect);

  gtk_widget_show (label_input);
  gtk_widget_show (combo_input);
  
  gtk_widget_show (label_aquality);
  gtk_widget_show (combo_aquality);
  
  gtk_widget_show (label_asamplerate);
  gtk_widget_show (combo_asamplerate);

  gtk_widget_show (label_achannel);
  gtk_widget_show (combo_achannel);

  gtk_widget_show (label_vquality);
  gtk_widget_show (combo_vquality);

  gtk_widget_show (label_vfps);
  gtk_widget_show (combo_vfps);

  gtk_widget_show (label_vsize);
  gtk_widget_show (combo_vsize);

  gtk_widget_show (label_v4ldevice);
  gtk_widget_show (combo_v4ldevice);

  gtk_widget_show (label_adevice);
  gtk_widget_show (combo_adevice);

  gtk_widget_show (label_streamname);
  gtk_widget_show (entry_streamname);
  
  gtk_widget_show (label_description);
  gtk_widget_show (entry_description);
  
  gtk_widget_show (label_url);
  gtk_widget_show (entry_url);
  
  gtk_widget_show (label_genre);
  gtk_widget_show (entry_genre);
    
  gtk_widget_show (label_public);
  gtk_widget_show (combo_public);
 
  gtk_widget_show (table_server);
  gtk_widget_show (table_av);
  gtk_widget_show (table_description);
  
  gtk_widget_show (label_notebook_server);
  gtk_widget_show (label_notebook_av);
  gtk_widget_show (label_notebook_description);

  gtk_widget_show (notebook);

  gtk_widget_show (menu_bar);
  gtk_widget_show (menu_item_file);
  gtk_widget_show (menu_item_open);
  gtk_widget_show (menu_item_save);
  gtk_widget_show (menu_item_quit);
  gtk_widget_show (menu_item_quit_nd);
  gtk_widget_show (menu_item_help);
  gtk_widget_show (menu_item_about);

  gtk_widget_show (table);

  gtk_widget_show (vbox);
  
  gtk_widget_show (window);
  
  gtk_main ();

  close (theorur_output_fd);

  return 0;
}
