/*
 * ===========================
 * VDK Builder
 * Version 0.1
 * Revision 0.0
 * November 1998
 * ===========================
 *
 * Copyright (C) 1998,1999 Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * Based on VDK Library
 * Copyright (C) 1998, Mario Motta
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 */
#ifndef _vdkbuilder_h
#define _vdkbuilder_h
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#if USE_XDB
#include <vdkxdb2/vdkxdb.h>
#include <vdkxdb2/vdkxtable.h>
#endif

#if HAVE_GNOME
#include <vdk/vdkgnomeapp.h>
#endif

#include <vdk/vdk.h>
#include <vdkb2/vdkb_types.h>
#include <vdkb2/vdkb_logo.h>
#include <vdkb2/vdkb_editor.h>
#include <vdkb2/vdkb_prjman.h>
#include <vdkb2/vdkb_ide_def.h>
#include <vdkb2/vdkb_maker.h>
#include <vdkb2/vdkb_plugin.h>
#include <vdk/panelbar.h>
#include <vdkb2/vdkb_frmlist.h>
#include <vdkb2/vdkb_compodb.h>
#include <vdkb2/vdkb_lru.h>
#include <sys/types.h>

/*
AUTOMA STATES
*/

enum
{
automa_error = -1,
automa_end = 0,
automa_init,
automa_editor_on,
automa_editor_off,
automa_prjman_on,
automa_prjman_off,
automa_edit_form_on,
automa_edit_form_off
};
// not more used
#define MAIN_PROGRESS_BLOCK 30
/*
drag and drop sources table
contains:
object: drag source widget
classid: drag source widget class id
used to set OperationalState.action_target
to the proper id as is done by pressing
a widget toolbar button
*/
class DnDBuilderEntry
{
 public:
  VDKObject* object;
  int classid;
  DnDBuilderEntry(VDKObject* object = NULL, int classid = -1):
    object(object),classid(classid) {}
  ~DnDBuilderEntry() {}
  bool operator == (DnDBuilderEntry& entry)
  { return object == entry.object; }
};
/*
completions, code templates and hints
*/
typedef VDKValueList<DnDBuilderEntry> DnDBuilderList;
typedef VDKValueListIterator<DnDBuilderEntry> DnDBuilderListIterator;
typedef VDKValueList<VDKString> TokenList;
typedef VDKValueListIterator<VDKString> TokenListIterator;
/*
 hint class
*/
class VDKHint
{
 public:
  VDKString key,hint;
  
  VDKHint(): key((char*) ""),hint((char*) "") { }
  
  VDKHint(char* k, char* h): key(k),hint(h) { }
  ~VDKHint()  {  }
  VDKHint(VDKHint& h) { key = h.key; hint = h.hint;  }
  VDKHint& operator=(VDKHint& h)
  { key = h.key; hint = h.hint; return *this;
  }
  bool operator==(VDKHint& h)  
  { 
    return key == h.key; 
  }
  bool operator<(VDKHint& h)  
    { 
      return key < h.key; 
    }
};

typedef VDKBtree<VDKHint> HintBTree;

//////////////////////////////////
// VDKBUILDER MAIN FORM
/////////////////////////////////

typedef VDKArray<VDKMenuItem*> LRUItemsArray;

class VDKBMainForm: public VDKForm
{
 private:
  VDKBLogo *logo;
  //VDKTimer *timer;
  VDKPoint _defSize;
  // for mozilla
   pid_t  mozpid;
   int mozstatus;
  // members
 protected:
  // main menu stuff
  VDKMenubar   *menubar;
  VDKMenuItem  *file_menu;
  VDKMenuItem  *new_item,*open_item,*reopen_item,
    *save_item,*saveall_item,*quit_item;
  // an array of last recently used projects menu items
  LRUItemsArray lru_items;
  LRUManager* lrumanager;
  VDKMenuItem  *newform_item,
    *newunit_item,*newprj_item;
  VDKMenu      *newformmenu,*reopenmenu;
  VDKMenuItem  *newformdefault_item,
    *newformscrolled_item,* newformpaned_item;
  VDKMenuItem  *openfile_item,
    *openunit_item,*openprj_item;
  VDKMenuItem *edit_menu;
  VDKMenuItem *search_menu,
    *search_item,*repeat_search_item,*replace_item;
  VDKMenuItem *view_menu;
  VDKMenuItem *viewunits_item, *viewforms_item;
  VDKMenuItem *prj_menu;
  VDKMenuItem *prjmake_item,
    *prjmakeclean_item,
    *prjoptions_item,
    *prjdebug_item;
  VDKMenuItem *compo_menu,*edhint_item;
  VDKMenuItem *tools_menu,*envset_item,*exec_item,*xdb_menuitem;
#if USE_XDB
  VDKMenu *xdb_menu;
  VDKMenuItem  *xdb_opentables;
#endif
  VDKMenuItem *ac_menu;
  VDKMenuItem *ac_autogen,*ac_make,*ac_makeclean,
    *ac_makedist,*ac_makedistclean;
  VDKMenuItem *help_menu;
  VDKMenuItem *help_index,*help_vdk,*help_about;

  // VDKToolbar  *toolbar1;
  VDKHLButton *unitlist_nb,*toggle_nb,*formlist_nb,*runprj_nb;
  VDKHLButton *nb_array1[5];
  // VDKToolbar  *toolbar;
  VDKHLButton *newprj_nb, *newunit_nb, *newform_nb, 
    *loadprj_nb, *loadfile_nb, *saveprj_nb,*savefile_nb;
  VDKHLButton *nb_array[8];

  // VDKCustomButton *reset,*emacs;
  VDKHLButton *reset,*emacs;
  VDKNotebook *widget_folder;
  //  VDKToolbar *text_widgets_bar, *button_widgets_bar,
  //  *containers_widgets_bar, *misc_widgets_bar,*plugin_widgets_bar;
  VDKHLButtonBar *text_widgets_bar, *button_widgets_bar,
    *containers_widgets_bar, *misc_widgets_bar,*plugin_widgets_bar;
#if USE_XDB
  // VDKToolbar *xdb_widgets_bar;
  VDKHLButtonBar *xdb_widgets_bar;
#endif
#if HAVE_GNOME
  //  VDKToolbar  *gnome_widgets_bar;
  VDKHLBUttonBar  *gnome_widgets_bar;
#endif
  // subsystems
  VDKBEditor *editor;
  VDKBProjectManager *prjman;
  VDKBMaker *maker;
  VDKBFormListForm* formlistform;
  // member functions
 protected:
 void MakeMainMenu();
 VDKBox* MakeToolBox();
 // VDKToolbar* MakeContainerWidgetFolder();
 VDKHLButtonBar* MakeContainerWidgetFolder();
 // VDKToolbar* MakeButtonsWidgetFolder();
 VDKHLButtonBar* MakeButtonsWidgetFolder();
 //  VDKToolbar* MakeTextWidgetFolder();
 VDKHLButtonBar* MakeTextWidgetFolder();
 // VDKToolbar* MakeMiscWidgetFolder();
 VDKHLButtonBar* MakeMiscWidgetFolder();
 // VDKToolbar* MakePluginWidgetFolder();
 VDKHLButtonBar* MakePluginWidgetFolder();
#if USE_XDB
 // VDKToolbar* MakeXdbWidgetFolder();
 VDKHLButtonBar* MakeXdbWidgetFolder();
#endif
#if HAVE_GNOME
 //VDKToolbar* MakeGnomeWidgetFolder();
 VDKHLButtonBar* MakeGnomeWidgetFolder();
#endif
 VDKString ToBeToggled; // form/unit to be toggled
 // disabled for now
 // VDKToolbar* MakeDlgWidgetFolder();
 bool ContinueSetup(VDKObject*);
 void OnShow(VDKForm* sender);
 void OnMove(VDKForm* sender);
 void OnResize(VDKForm* sender,VDKPoint& p);
 void OnFormActivate(VDKForm* sender, bool in_out);
 // response functions
 bool Quit(VDKObject*);
 bool About(VDKObject*);
 bool HandleToolbar(VDKObject*);
 bool HandleToolbar1(VDKObject*);
 bool HandleContainersWidgetsBar(VDKObject*);
 bool HandleButtonsWidgetsBar(VDKObject*);
 bool HandleTextWidgetsBar(VDKObject*);
 bool HandleAllWidgetsBar(VDKObject*);
 bool CanClose();
 bool NewUnit(VDKObject*);
 bool NewForm(VDKObject*);
 bool OpenFile(VDKObject*);
 bool OnReopenMenu(VDKObject*);
 bool SaveProject(VDKObject*);
 bool FileSave(VDKObject*);
 bool OpenProject(VDKObject*);
 bool ProjectOptions(VDKObject*);
 bool Search(VDKObject*);
 bool RepeatSearch(VDKObject*);
 bool ReplaceText(VDKObject*);
 bool SetBuilderEnvironment(VDKObject*);
 void OnIconize(VDKForm*);
 void OnRestore(VDKForm*);
 bool RunDebugger(VDKObject*);
 bool RunGrep(VDKObject* sender);
 bool OpenHintsEditor(VDKObject* sender);
 bool ViewForms(VDKObject* sender);
 /* emacs support as external editor */
 bool CallEmacsServer(VDKObject*);
 /* in vdkb_acsupport.cc */
 bool AcAutogen(VDKObject* sender);
 bool AcMake(VDKObject* sender);
 bool AcMakeClean(VDKObject* sender);
 bool AcMakeDist(VDKObject* sender);
 bool AcMakeDistclean(VDKObject* sender);
 bool VDKBHelp(VDKObject*);
 /* xdb support */
#if USE_XDB
 bool OnOpenXdbTables(VDKObject* sender);
#endif
 //
 bool BrowseCompoDb(VDKObject* sender);
 //
 void CallMaker(char * args[], char* pth,int output);
 /*
   editor completions, code templates and hints
 */
  bool LoadTokens();
  bool SaveTokens();
  bool LoadHints();
public:
  VDKBMainForm(VDKApplication* , gchar* );
  ~VDKBMainForm();
  void Setup();
  void OnChildClosing(VDKForm* child);
  void Automa(int state = automa_end);
  VDKBEditor* MakeEditor();
  VDKBEditor* Editor() { return editor; }
  LRUManager* LruManager() { return lrumanager; }
  bool NewProject(VDKObject*);
  VDKBProjectManager * PrjManager() { return prjman; }
  VDKBFormListForm* Formlistform() { return formlistform; }
  bool Reset(VDKObject*);
  // VDKToolbar* Toolbar1() { return toolbar1; }
  void EnableToggleFormUnit(bool active, char* file);
  bool Make(VDKObject*);
  void RunExecutable();
#if HAVE_GNOME
  void EnableGnomeWidgets(bool flag);	
#endif
  // for Mozilla
  bool RunMozilla(VDKObject*, char* html);
  bool MozillaMourn(VDKObject*);
  int MozillaPid() {return mozpid;}
  void MozillaPid(int p) {mozpid=p;}
  int MozillaStatus() {return mozstatus;}
  void MozillaStatus(int p) {mozstatus=p;}
  static void MozillaReaper(int);
  void LoadEditorWithErrors(VDKBStringList* list);
  void UpdateLRU();
  bool OnLRUTimer(VDKObject* sender);
DECLARE_SIGNAL_MAP(VDKBMainForm);
DECLARE_SIGNAL_LIST(VDKBMainForm);
};
///////////////////////////////////////
#if HAVE_GNOME
class VDKBuilder: public VDKGnomeApplication
#else
class VDKBuilder: public VDKApplication
#endif
{
 protected:
    VDKBPluginList plugin_list;
 public:
#if USE_XDB
    VDKXDatabase* theXdb;
#endif
    VDKString user_home,user_cwd;
  //
  static VDKBDefaults ideDefaults;
  VDKBuilder(int* argc, char** argv, char* rc = NULL);
  ~VDKBuilder();
  void Setup();
  VDKBPluginList& PluginList() { return plugin_list; }
};
#endif
