/*
 * ===========================
 * VDK Builder
 * Version 0.1
 * Revision 0.0
 * November 1998
 * ===========================
 *
 * Copyright (C) 1998,1999 Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * Based on VDK Library 
 * Copyright (C) 1998, Mario Motta
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 */
#ifndef _vdkb_unit_
#define _vdkb_unit_
#include <vdk/vdkstring.h>
#include <vdk/vdkprops.h>

/*
unit types
*/
enum {
  source_unit = 0,
  object_unit,
  staticlib_unit,
  project_unit,
  c_source_unit,
  form_unit,
  header_unit,
  unknow_type
};

enum { prj_never_saved, prj_unsaved, prj_saved };

////////////////// VDKBUnit class /////////////
class VDKBUnit
{
  
 public:
  //
  __rwproperty(VDKBUnit,int) Status;
  VDKBUnit(char* name, int status );
  VDKBUnit(char* name, int type, int status);
  ~VDKBUnit();
  char* ShortName();
  char* Name(char* name = NULL);
  char* Header();
  char* Source();
  char* Dfm();
  char* DfmHeader();
  char* Gui();
  char* GuiSource();
  bool operator==(VDKBUnit& u)
    { return name == u.name; }
  int Type() { return type; }
  bool IsSource()
    {
      return 
	type == source_unit || 
	type == project_unit || 
	type == c_source_unit;
    }
  bool IsForm()
    {
      return type == form_unit;
    }
 protected:
  VDKString name;
  int type;
};


#endif
