/*
 * ===========================
 * VDK Builder
 * Version 0.1
 * Revision 0.0
 * January 1999
 * ===========================
 *
 * Copyright (C) 1998,1999 Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * Based on VDK Library
 * Copyright (C) 1998, Mario Motta
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 */
#include <vdkb2/vdkb_prjopt.h>

//static char buff[512];
extern char*
ExtractWord(char* src,char* tgt,char* key1,char* key2);
extern char *
ExtractSection (char *buffer, char *section_begin, char* section_end);
static char *avoid = "\"\r\n\t";
/*
 */
VDKBProjectOptions::VDKBProjectOptions(int type):
  type(type),
  c_compiler("gcc"),
  cc_compiler("g++"),
  link("g++"),
  defines("-DNONE"),
  includes("-I./"),
  debugger(""),
  runargs(""),
  package(""),
  version("0.0.1"),
  nls_support("no")

{
  switch(type)
    {
    case vdk_project:
#if USE_XDB
      c_flags = "-g -Wall `vdkxdb-config-2 --cflags`";
      libs = "`vdkxdb-config-2 --libs`";
#else
      c_flags = "-g -Wall `vdk-config-2 --cflags`";
      libs = "`vdk-config-2 --libs`";
#endif
      
      break;
    case vdk_gnome_project:
#if USE_XDB
      c_flags = "-g -Wall `vdkxdb-config-2 --cflags`";
      libs = "`vdkxdb-config-2 --libs`";
#else
      c_flags = "-g -Wall `vdk-config-2 --cflags`";
      libs = "`vdk-config-2 --libs`";
#endif
      defines = "-DHAVE_GNOME";
      break;      
    default:
      c_flags = "-g -Wall";
      break;
    }
}
/*
 */
VDKBProjectOptions::~VDKBProjectOptions()
{
}
/*
 */
bool
VDKBProjectOptions::Save()
{
  FILE* fp = fopen(filename,"w+");
  if(!fp)
    return false;
  // compilers section
  fprintf(fp,"/*\n!!! PLEASE DO NOT EDIT THIS FILE !! (or edit at your own risk)\n");
  fprintf(fp,"Let VDKBuilder do the job for you\n*/\n");
  fprintf(fp,"%s%s%s%s%s%s%s%s\n",
	  COMPILERS_SECTION, C_COMPILER, (char*) c_compiler,
	  END_KEY,  CC_COMPILER, (char*) cc_compiler, END_KEY, END_SECTION);
  // link section
  fprintf(fp,"%s%s%s%s%s\n",
	  LINK_SECTION, LINK, (char*) link, END_KEY, END_SECTION);
  // c flags section
  fprintf(fp,"%s%s%s%s%s\n",
	  C_FLAGS_SECTION, C_FLAGS, (char*) c_flags, END_KEY, END_SECTION);
  // define section
  fprintf(fp,"%s%s%s%s%s\n",
	  DEFINES_SECTION, DEFINES, (char*) defines, END_KEY, END_SECTION);
// include section
  fprintf(fp,"%s%s%s%s%s\n",
	  INCLUDES_SECTION, INCLUDES, (char*) includes, END_KEY, END_SECTION);
// libs section
  fprintf(fp,"%s%s%s%s%s\n",
	  LIBS_SECTION, LIBS, (char*) libs, END_KEY, END_SECTION);
// debugger section
  fprintf(fp,"%s%s%s%s%s\n",
	  DEBUGGER_SECTION, DEBUGGER, (char*) debugger, END_KEY, END_SECTION);
// program section
  fprintf(fp,"%s%s%s%s%s\n",
	  PROGRAM_SECTION, RUNARGS, (char*) runargs, END_KEY, END_SECTION);
// package section
  fprintf(fp,"%s\n%s%s%s\n",
	  PACKAGE_SECTION, 
	  PKG_NAME, package.isNull() ? "" : (char*) package,
	  END_KEY);
  fprintf(fp,"%s%s%s\n",
	  PKG_VERSION, version.isNull() ? "" :(char*) version, 
	  END_KEY);
  fprintf(fp,"%s%s%s%s\n",
	  NLS_SUPPORT, nls_support.isNull() ? "no" : (char*) nls_support, 
	  END_KEY, END_SECTION);
// developer section
  fprintf(fp,"%s\n%s%s%s\n",
	  DEVELOPER_SECTION, 
	  AUTHOR, author.isNull() ? "" : (char*) author,
	  END_KEY);
  fprintf(fp,"%s%s%s\n",
	  EMAIL, email.isNull() ? "" :(char*) email, 
	  END_KEY);
  fprintf(fp,"%s%s%s%s\n",
	  GPLD, gpld ? "yes" : "no", 
	  END_KEY, END_SECTION);

  fclose(fp);
  return true;
}
/*
 */
bool
VDKBProjectOptions::Load()
{
  char* buff,*p,*section;
  char *key = new char[512];
  struct stat info;
char* file = (char*) filename;
stat(file,&info);
FILE* fp = fopen(file,"r");
if(fp)
  {
    int c;
    buff = p = new char[info.st_size+1];
    while( (c = fgetc(fp)) != EOF)
      {
      if (!strchr (avoid, c))
	*p++ = (char) c;
      }
    *p = '\0';
    fclose(fp);
  }
else
  return false;

if((section = ExtractSection(buff,COMPILERS_SECTION,END_SECTION)))
  {
    if(ExtractWord(section,key,C_COMPILER,END_KEY))
      c_compiler = key;
    if(ExtractWord(section,key,CC_COMPILER,END_KEY))
      cc_compiler = key;
    delete[] section;
  }

if((section = ExtractSection(buff,LINK_SECTION,END_SECTION)))
  {
    if(ExtractWord(section,key,LINK,END_KEY))
      link = key;
    delete[] section;
  }

if((section = ExtractSection(buff,C_FLAGS_SECTION,END_SECTION)))
  {
    if(ExtractWord(section,key,C_FLAGS,END_KEY))
      c_flags = key;
    delete[] section;
  }

if((section = ExtractSection(buff,DEFINES_SECTION,END_SECTION)))
  {
    if(ExtractWord(section,key,DEFINES,END_KEY))
      defines = key;
    delete[] section;
  }

if((section = ExtractSection(buff,INCLUDES_SECTION,END_SECTION)))
  {
    if(ExtractWord(section,key,INCLUDES,END_KEY))
      includes = key;
    delete[] section;
  }

if((section = ExtractSection(buff,LIBS_SECTION,END_SECTION)))
  {
    if(ExtractWord(section,key,LIBS,END_KEY))
      libs = key;
    delete[] section;
  }

if((section = ExtractSection(buff,DEBUGGER_SECTION,END_SECTION)))
  {
    if(ExtractWord(section,key,DEBUGGER,END_KEY))
      debugger = key;
    delete[] section;
  }
if((section = ExtractSection(buff,PROGRAM_SECTION,END_SECTION)))
  {
    if(ExtractWord(section,key,RUNARGS,END_KEY))
      runargs = key;
    delete[] section;
  }
if((section = ExtractSection(buff,PACKAGE_SECTION,END_SECTION)))
  {
    if(ExtractWord(section,key,PKG_NAME,END_KEY))
      package = key;
    if(ExtractWord(section,key,PKG_VERSION,END_KEY))
      version = key;
    if(ExtractWord(section,key,NLS_SUPPORT,END_KEY))
      nls_support = key;
    delete[] section;
  }

if((section = ExtractSection(buff,DEVELOPER_SECTION,END_SECTION)))
  {
    if(ExtractWord(section,key,AUTHOR,END_KEY))
      author = key;
    if(ExtractWord(section,key,EMAIL,END_KEY))
      email = key;
    if(ExtractWord(section,key,GPLD,END_KEY))
      gpld = !strcmp(key,"yes");
    delete[] section;
  }

// finished
delete[] buff;
delete[] key;
return true;
}

#if USE_XDB
#define XDB_ACTIVE "active:"
bool 
SaveXdbOptions(VDKXDatabase* db, char* filename)
{
  VDKString fname = filename;
  TableList* tlist = NULL;
  FILE* fp = NULL;
  if(!db)
    return false;
  else
    {
      fname += ".prj.xdb";
      fp = fopen((char*) fname,"w+");
      tlist = db->TList();
    }
  if(!fp || !tlist)
    return false;
  // loops into xdb
  TableListIterator lt(*tlist);
  for(;lt;lt++)
    {
      // header
      fprintf(fp,"%s\n",XDB_SECTION);
      VDKXTable* table = lt.current();
      IndexList* ilist = table->NdxList();
      char* name = (char*) table->Name();
      fprintf(fp,"%s%s%s\n",XDB_TABLE_OPEN,name,END_KEY);
      fprintf(fp,"%s%s%s\n",XDB_ACTIVE,
	      table->Active ? "yes" : "no",
	      END_KEY);
      IndexListIterator li(*ilist);
      for(;li;li++)
	{
	  VDKXTableIndex* index = li.current();
	  char* name = (char*) index->Name();
	  fprintf(fp,"%s%s%s\n",XDB_INDEX_OPEN,name,END_KEY);
	}
      // footer
      fprintf(fp,"%s\n",END_SECTION);
    }
  fclose(fp);
  return true;
}

/*
 */
bool LoadXdbOptions(VDKXDatabase* db, char* filename)
{
  VDKString file = filename;
  FILE* fp = NULL;
  char* buff,*p,*section;
  char *sec_key = NULL;
  char *ndx_key = NULL;
  char* act_key = NULL;
  struct stat info;
  if(!db)
    return false;
  else
    file += ".prj.xdb";
  sec_key = new char[256];
  ndx_key = new char[256];
  act_key = new char[32];
  stat(file,&info);
  fp = fopen(file,"r");
  if(fp)
  {
    int c;
    buff = p = new char[info.st_size+1];
    while( (c = fgetc(fp)) != EOF)
      {
      if (!strchr (avoid, c))
	*p++ = (char) c;
      }
    *p = '\0';
    fclose(fp);
  }
  else
    return false;
  // scans
  char* sec_pt = buff;
  // gets an xdb section
  while((section = ExtractSection(sec_pt,XDB_SECTION,END_SECTION)))
      {
	char* table = ExtractWord(section,sec_key,XDB_TABLE_OPEN,END_KEY);
	bool active = false;
	if(ExtractWord(section,act_key,XDB_ACTIVE,END_KEY))
	  active = !strcmp(act_key,"yes");
	else
	  *act_key = '\0';
	if(table)
	  {
	    // adds table to xdb
	    VDKXTable *dbtable = new VDKXTable(db,table);
	    dbtable->Open();
	    dbtable->Active = active;
	    // move forward pointer
	    char* ndx_pt = section + strlen(XDB_TABLE_OPEN) +
	      strlen(table)+ strlen(END_KEY);
	    if(*act_key)
	      ndx_pt += strlen(XDB_ACTIVE) + strlen(act_key)+ strlen(END_KEY);
	    while(ExtractWord(ndx_pt,ndx_key,XDB_INDEX_OPEN,END_KEY))
	      {
		// adds index to table and opens it
		VDKXTableIndex *index = new VDKXTableIndex(dbtable,ndx_key);
		index->Open();
		// move forward pointer
		ndx_pt += (strlen(XDB_INDEX_OPEN) + strlen(ndx_key) +
			   strlen(END_KEY));
	      }
	    sec_pt += strlen(section) + strlen(XDB_SECTION) +
	      strlen(END_SECTION); 
	  }
	delete[] section;
      }
  // finished
  delete[] buff;
  delete[] sec_key;
  delete[] ndx_key;
  delete[] act_key;
  return true;
}
#endif





