/* Copyright (C) 2013-2016, The Regents of The University of Michigan.
All rights reserved.

This software was developed in the APRIL Robotics Lab under the
direction of Edwin Olson, ebolson@umich.edu. This software may be
available under alternative licensing terms; contact the address above.

An unlimited license is granted to use, adapt, modify, or embed the 2D
barcodes into any medium.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice, this
   list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

The views and conclusions contained in the software and documentation are those
of the authors and should not be interpreted as representing official policies,
either expressed or implied, of the Regents of The University of Michigan.
*/
#include <stdlib.h>
#include "apriltag.h"

apriltag_family_t *tag36artoolkit_create()
{
    apriltag_family_t *tf = calloc(1, sizeof(apriltag_family_t));
#ifdef WINRT
    tf->name = _strdup("artoolkit");
#else
    tf->name = strdup("artoolkit");
#endif
    tf->black_border = 1;
    tf->d = 6;
    tf->h = 7; // not sure.
    tf->ncodes = 512;
    tf->codes = calloc(512, sizeof(uint64_t));

    tf->codes[0] = 0x0006dc269c27UL;
    tf->codes[1] = 0x0006d4229e26UL;
    tf->codes[2] = 0x0006cc2e9825UL;
    tf->codes[3] = 0x0006c42a9a24UL;
    tf->codes[4] = 0x0006fc369423UL;
    tf->codes[5] = 0x0006f4329622UL;
    tf->codes[6] = 0x0006ec3e9021UL;
    tf->codes[7] = 0x0006e43a9220UL;
    tf->codes[8] = 0x00069c068c2fUL;
    tf->codes[9] = 0x000694028e2eUL;
    tf->codes[10] = 0x00068c0e882dUL;
    tf->codes[11] = 0x0006840a8a2cUL;
    tf->codes[12] = 0x0006bc16842bUL;
    tf->codes[13] = 0x0006b412862aUL;
    tf->codes[14] = 0x0006ac1e8029UL;
    tf->codes[15] = 0x0006a41a8228UL;
    tf->codes[16] = 0x00065c66bc37UL;
    tf->codes[17] = 0x00065462be36UL;
    tf->codes[18] = 0x00064c6eb835UL;
    tf->codes[19] = 0x0006446aba34UL;
    tf->codes[20] = 0x00067c76b433UL;
    tf->codes[21] = 0x00067472b632UL;
    tf->codes[22] = 0x00066c7eb031UL;
    tf->codes[23] = 0x0006647ab230UL;
    tf->codes[24] = 0x00061c46ac3fUL;
    tf->codes[25] = 0x00061442ae3eUL;
    tf->codes[26] = 0x00060c4ea83dUL;
    tf->codes[27] = 0x0006044aaa3cUL;
    tf->codes[28] = 0x00063c56a43bUL;
    tf->codes[29] = 0x00063452a63aUL;
    tf->codes[30] = 0x00062c5ea039UL;
    tf->codes[31] = 0x0006245aa238UL;
    tf->codes[32] = 0x0007dca6dc07UL;
    tf->codes[33] = 0x0007d4a2de06UL;
    tf->codes[34] = 0x0007ccaed805UL;
    tf->codes[35] = 0x0007c4aada04UL;
    tf->codes[36] = 0x0007fcb6d403UL;
    tf->codes[37] = 0x0007f4b2d602UL;
    tf->codes[38] = 0x0007ecbed001UL;
    tf->codes[39] = 0x0007e4bad200UL;
    tf->codes[40] = 0x00079c86cc0fUL;
    tf->codes[41] = 0x00079482ce0eUL;
    tf->codes[42] = 0x00078c8ec80dUL;
    tf->codes[43] = 0x0007848aca0cUL;
    tf->codes[44] = 0x0007bc96c40bUL;
    tf->codes[45] = 0x0007b492c60aUL;
    tf->codes[46] = 0x0007ac9ec009UL;
    tf->codes[47] = 0x0007a49ac208UL;
    tf->codes[48] = 0x00075ce6fc17UL;
    tf->codes[49] = 0x000754e2fe16UL;
    tf->codes[50] = 0x00074ceef815UL;
    tf->codes[51] = 0x000744eafa14UL;
    tf->codes[52] = 0x00077cf6f413UL;
    tf->codes[53] = 0x000774f2f612UL;
    tf->codes[54] = 0x00076cfef011UL;
    tf->codes[55] = 0x000764faf210UL;
    tf->codes[56] = 0x00071cc6ec1fUL;
    tf->codes[57] = 0x000714c2ee1eUL;
    tf->codes[58] = 0x00070ccee81dUL;
    tf->codes[59] = 0x000704caea1cUL;
    tf->codes[60] = 0x00073cd6e41bUL;
    tf->codes[61] = 0x000734d2e61aUL;
    tf->codes[62] = 0x00072cdee019UL;
    tf->codes[63] = 0x000724dae218UL;
    tf->codes[64] = 0x0004dd261c67UL;
    tf->codes[65] = 0x0004d5221e66UL;
    tf->codes[66] = 0x0004cd2e1865UL;
    tf->codes[67] = 0x0004c52a1a64UL;
    tf->codes[68] = 0x0004fd361463UL;
    tf->codes[69] = 0x0004f5321662UL;
    tf->codes[70] = 0x0004ed3e1061UL;
    tf->codes[71] = 0x0004e53a1260UL;
    tf->codes[72] = 0x00049d060c6fUL;
    tf->codes[73] = 0x000495020e6eUL;
    tf->codes[74] = 0x00048d0e086dUL;
    tf->codes[75] = 0x0004850a0a6cUL;
    tf->codes[76] = 0x0004bd16046bUL;
    tf->codes[77] = 0x0004b512066aUL;
    tf->codes[78] = 0x0004ad1e0069UL;
    tf->codes[79] = 0x0004a51a0268UL;
    tf->codes[80] = 0x00045d663c77UL;
    tf->codes[81] = 0x000455623e76UL;
    tf->codes[82] = 0x00044d6e3875UL;
    tf->codes[83] = 0x0004456a3a74UL;
    tf->codes[84] = 0x00047d763473UL;
    tf->codes[85] = 0x000475723672UL;
    tf->codes[86] = 0x00046d7e3071UL;
    tf->codes[87] = 0x0004657a3270UL;
    tf->codes[88] = 0x00041d462c7fUL;
    tf->codes[89] = 0x000415422e7eUL;
    tf->codes[90] = 0x00040d4e287dUL;
    tf->codes[91] = 0x0004054a2a7cUL;
    tf->codes[92] = 0x00043d56247bUL;
    tf->codes[93] = 0x00043552267aUL;
    tf->codes[94] = 0x00042d5e2079UL;
    tf->codes[95] = 0x0004255a2278UL;
    tf->codes[96] = 0x0005dda65c47UL;
    tf->codes[97] = 0x0005d5a25e46UL;
    tf->codes[98] = 0x0005cdae5845UL;
    tf->codes[99] = 0x0005c5aa5a44UL;
    tf->codes[100] = 0x0005fdb65443UL;
    tf->codes[101] = 0x0005f5b25642UL;
    tf->codes[102] = 0x0005edbe5041UL;
    tf->codes[103] = 0x0005e5ba5240UL;
    tf->codes[104] = 0x00059d864c4fUL;
    tf->codes[105] = 0x000595824e4eUL;
    tf->codes[106] = 0x00058d8e484dUL;
    tf->codes[107] = 0x0005858a4a4cUL;
    tf->codes[108] = 0x0005bd96444bUL;
    tf->codes[109] = 0x0005b592464aUL;
    tf->codes[110] = 0x0005ad9e4049UL;
    tf->codes[111] = 0x0005a59a4248UL;
    tf->codes[112] = 0x00055de67c57UL;
    tf->codes[113] = 0x000555e27e56UL;
    tf->codes[114] = 0x00054dee7855UL;
    tf->codes[115] = 0x000545ea7a54UL;
    tf->codes[116] = 0x00057df67453UL;
    tf->codes[117] = 0x000575f27652UL;
    tf->codes[118] = 0x00056dfe7051UL;
    tf->codes[119] = 0x000565fa7250UL;
    tf->codes[120] = 0x00051dc66c5fUL;
    tf->codes[121] = 0x000515c26e5eUL;
    tf->codes[122] = 0x00050dce685dUL;
    tf->codes[123] = 0x000505ca6a5cUL;
    tf->codes[124] = 0x00053dd6645bUL;
    tf->codes[125] = 0x000535d2665aUL;
    tf->codes[126] = 0x00052dde6059UL;
    tf->codes[127] = 0x000525da6258UL;
    tf->codes[128] = 0x0002de279ca7UL;
    tf->codes[129] = 0x0002d6239ea6UL;
    tf->codes[130] = 0x0002ce2f98a5UL;
    tf->codes[131] = 0x0002c62b9aa4UL;
    tf->codes[132] = 0x0002fe3794a3UL;
    tf->codes[133] = 0x0002f63396a2UL;
    tf->codes[134] = 0x0002ee3f90a1UL;
    tf->codes[135] = 0x0002e63b92a0UL;
    tf->codes[136] = 0x00029e078cafUL;
    tf->codes[137] = 0x000296038eaeUL;
    tf->codes[138] = 0x00028e0f88adUL;
    tf->codes[139] = 0x0002860b8aacUL;
    tf->codes[140] = 0x0002be1784abUL;
    tf->codes[141] = 0x0002b61386aaUL;
    tf->codes[142] = 0x0002ae1f80a9UL;
    tf->codes[143] = 0x0002a61b82a8UL;
    tf->codes[144] = 0x00025e67bcb7UL;
    tf->codes[145] = 0x00025663beb6UL;
    tf->codes[146] = 0x00024e6fb8b5UL;
    tf->codes[147] = 0x0002466bbab4UL;
    tf->codes[148] = 0x00027e77b4b3UL;
    tf->codes[149] = 0x00027673b6b2UL;
    tf->codes[150] = 0x00026e7fb0b1UL;
    tf->codes[151] = 0x0002667bb2b0UL;
    tf->codes[152] = 0x00021e47acbfUL;
    tf->codes[153] = 0x00021643aebeUL;
    tf->codes[154] = 0x00020e4fa8bdUL;
    tf->codes[155] = 0x0002064baabcUL;
    tf->codes[156] = 0x00023e57a4bbUL;
    tf->codes[157] = 0x00023653a6baUL;
    tf->codes[158] = 0x00022e5fa0b9UL;
    tf->codes[159] = 0x0002265ba2b8UL;
    tf->codes[160] = 0x0003dea7dc87UL;
    tf->codes[161] = 0x0003d6a3de86UL;
    tf->codes[162] = 0x0003ceafd885UL;
    tf->codes[163] = 0x0003c6abda84UL;
    tf->codes[164] = 0x0003feb7d483UL;
    tf->codes[165] = 0x0003f6b3d682UL;
    tf->codes[166] = 0x0003eebfd081UL;
    tf->codes[167] = 0x0003e6bbd280UL;
    tf->codes[168] = 0x00039e87cc8fUL;
    tf->codes[169] = 0x00039683ce8eUL;
    tf->codes[170] = 0x00038e8fc88dUL;
    tf->codes[171] = 0x0003868bca8cUL;
    tf->codes[172] = 0x0003be97c48bUL;
    tf->codes[173] = 0x0003b693c68aUL;
    tf->codes[174] = 0x0003ae9fc089UL;
    tf->codes[175] = 0x0003a69bc288UL;
    tf->codes[176] = 0x00035ee7fc97UL;
    tf->codes[177] = 0x000356e3fe96UL;
    tf->codes[178] = 0x00034eeff895UL;
    tf->codes[179] = 0x000346ebfa94UL;
    tf->codes[180] = 0x00037ef7f493UL;
    tf->codes[181] = 0x000376f3f692UL;
    tf->codes[182] = 0x00036efff091UL;
    tf->codes[183] = 0x000366fbf290UL;
    tf->codes[184] = 0x00031ec7ec9fUL;
    tf->codes[185] = 0x000316c3ee9eUL;
    tf->codes[186] = 0x00030ecfe89dUL;
    tf->codes[187] = 0x000306cbea9cUL;
    tf->codes[188] = 0x00033ed7e49bUL;
    tf->codes[189] = 0x000336d3e69aUL;
    tf->codes[190] = 0x00032edfe099UL;
    tf->codes[191] = 0x000326dbe298UL;
    tf->codes[192] = 0x0000df271ce7UL;
    tf->codes[193] = 0x0000d7231ee6UL;
    tf->codes[194] = 0x0000cf2f18e5UL;
    tf->codes[195] = 0x0000c72b1ae4UL;
    tf->codes[196] = 0x0000ff3714e3UL;
    tf->codes[197] = 0x0000f73316e2UL;
    tf->codes[198] = 0x0000ef3f10e1UL;
    tf->codes[199] = 0x0000e73b12e0UL;
    tf->codes[200] = 0x00009f070cefUL;
    tf->codes[201] = 0x000097030eeeUL;
    tf->codes[202] = 0x00008f0f08edUL;
    tf->codes[203] = 0x0000870b0aecUL;
    tf->codes[204] = 0x0000bf1704ebUL;
    tf->codes[205] = 0x0000b71306eaUL;
    tf->codes[206] = 0x0000af1f00e9UL;
    tf->codes[207] = 0x0000a71b02e8UL;
    tf->codes[208] = 0x00005f673cf7UL;
    tf->codes[209] = 0x000057633ef6UL;
    tf->codes[210] = 0x00004f6f38f5UL;
    tf->codes[211] = 0x0000476b3af4UL;
    tf->codes[212] = 0x00007f7734f3UL;
    tf->codes[213] = 0x0000777336f2UL;
    tf->codes[214] = 0x00006f7f30f1UL;
    tf->codes[215] = 0x0000677b32f0UL;
    tf->codes[216] = 0x00001f472cffUL;
    tf->codes[217] = 0x000017432efeUL;
    tf->codes[218] = 0x00000f4f28fdUL;
    tf->codes[219] = 0x0000074b2afcUL;
    tf->codes[220] = 0x00003f5724fbUL;
    tf->codes[221] = 0x0000375326faUL;
    tf->codes[222] = 0x00002f5f20f9UL;
    tf->codes[223] = 0x0000275b22f8UL;
    tf->codes[224] = 0x0001dfa75cc7UL;
    tf->codes[225] = 0x0001d7a35ec6UL;
    tf->codes[226] = 0x0001cfaf58c5UL;
    tf->codes[227] = 0x0001c7ab5ac4UL;
    tf->codes[228] = 0x0001ffb754c3UL;
    tf->codes[229] = 0x0001f7b356c2UL;
    tf->codes[230] = 0x0001efbf50c1UL;
    tf->codes[231] = 0x0001e7bb52c0UL;
    tf->codes[232] = 0x00019f874ccfUL;
    tf->codes[233] = 0x000197834eceUL;
    tf->codes[234] = 0x00018f8f48cdUL;
    tf->codes[235] = 0x0001878b4accUL;
    tf->codes[236] = 0x0001bf9744cbUL;
    tf->codes[237] = 0x0001b79346caUL;
    tf->codes[238] = 0x0001af9f40c9UL;
    tf->codes[239] = 0x0001a79b42c8UL;
    tf->codes[240] = 0x00015fe77cd7UL;
    tf->codes[241] = 0x000157e37ed6UL;
    tf->codes[242] = 0x00014fef78d5UL;
    tf->codes[243] = 0x000147eb7ad4UL;
    tf->codes[244] = 0x00017ff774d3UL;
    tf->codes[245] = 0x000177f376d2UL;
    tf->codes[246] = 0x00016fff70d1UL;
    tf->codes[247] = 0x000167fb72d0UL;
    tf->codes[248] = 0x00011fc76cdfUL;
    tf->codes[249] = 0x000117c36edeUL;
    tf->codes[250] = 0x00010fcf68ddUL;
    tf->codes[251] = 0x000107cb6adcUL;
    tf->codes[252] = 0x00013fd764dbUL;
    tf->codes[253] = 0x000137d366daUL;
    tf->codes[254] = 0x00012fdf60d9UL;
    tf->codes[255] = 0x000127db62d8UL;
    tf->codes[256] = 0x000ed8249d27UL;
    tf->codes[257] = 0x000ed0209f26UL;
    tf->codes[258] = 0x000ec82c9925UL;
    tf->codes[259] = 0x000ec0289b24UL;
    tf->codes[260] = 0x000ef8349523UL;
    tf->codes[261] = 0x000ef0309722UL;
    tf->codes[262] = 0x000ee83c9121UL;
    tf->codes[263] = 0x000ee0389320UL;
    tf->codes[264] = 0x000e98048d2fUL;
    tf->codes[265] = 0x000e90008f2eUL;
    tf->codes[266] = 0x000e880c892dUL;
    tf->codes[267] = 0x000e80088b2cUL;
    tf->codes[268] = 0x000eb814852bUL;
    tf->codes[269] = 0x000eb010872aUL;
    tf->codes[270] = 0x000ea81c8129UL;
    tf->codes[271] = 0x000ea0188328UL;
    tf->codes[272] = 0x000e5864bd37UL;
    tf->codes[273] = 0x000e5060bf36UL;
    tf->codes[274] = 0x000e486cb935UL;
    tf->codes[275] = 0x000e4068bb34UL;
    tf->codes[276] = 0x000e7874b533UL;
    tf->codes[277] = 0x000e7070b732UL;
    tf->codes[278] = 0x000e687cb131UL;
    tf->codes[279] = 0x000e6078b330UL;
    tf->codes[280] = 0x000e1844ad3fUL;
    tf->codes[281] = 0x000e1040af3eUL;
    tf->codes[282] = 0x000e084ca93dUL;
    tf->codes[283] = 0x000e0048ab3cUL;
    tf->codes[284] = 0x000e3854a53bUL;
    tf->codes[285] = 0x000e3050a73aUL;
    tf->codes[286] = 0x000e285ca139UL;
    tf->codes[287] = 0x000e2058a338UL;
    tf->codes[288] = 0x000fd8a4dd07UL;
    tf->codes[289] = 0x000fd0a0df06UL;
    tf->codes[290] = 0x000fc8acd905UL;
    tf->codes[291] = 0x000fc0a8db04UL;
    tf->codes[292] = 0x000ff8b4d503UL;
    tf->codes[293] = 0x000ff0b0d702UL;
    tf->codes[294] = 0x000fe8bcd101UL;
    tf->codes[295] = 0x000fe0b8d300UL;
    tf->codes[296] = 0x000f9884cd0fUL;
    tf->codes[297] = 0x000f9080cf0eUL;
    tf->codes[298] = 0x000f888cc90dUL;
    tf->codes[299] = 0x000f8088cb0cUL;
    tf->codes[300] = 0x000fb894c50bUL;
    tf->codes[301] = 0x000fb090c70aUL;
    tf->codes[302] = 0x000fa89cc109UL;
    tf->codes[303] = 0x000fa098c308UL;
    tf->codes[304] = 0x000f58e4fd17UL;
    tf->codes[305] = 0x000f50e0ff16UL;
    tf->codes[306] = 0x000f48ecf915UL;
    tf->codes[307] = 0x000f40e8fb14UL;
    tf->codes[308] = 0x000f78f4f513UL;
    tf->codes[309] = 0x000f70f0f712UL;
    tf->codes[310] = 0x000f68fcf111UL;
    tf->codes[311] = 0x000f60f8f310UL;
    tf->codes[312] = 0x000f18c4ed1fUL;
    tf->codes[313] = 0x000f10c0ef1eUL;
    tf->codes[314] = 0x000f08cce91dUL;
    tf->codes[315] = 0x000f00c8eb1cUL;
    tf->codes[316] = 0x000f38d4e51bUL;
    tf->codes[317] = 0x000f30d0e71aUL;
    tf->codes[318] = 0x000f28dce119UL;
    tf->codes[319] = 0x000f20d8e318UL;
    tf->codes[320] = 0x000cd9241d67UL;
    tf->codes[321] = 0x000cd1201f66UL;
    tf->codes[322] = 0x000cc92c1965UL;
    tf->codes[323] = 0x000cc1281b64UL;
    tf->codes[324] = 0x000cf9341563UL;
    tf->codes[325] = 0x000cf1301762UL;
    tf->codes[326] = 0x000ce93c1161UL;
    tf->codes[327] = 0x000ce1381360UL;
    tf->codes[328] = 0x000c99040d6fUL;
    tf->codes[329] = 0x000c91000f6eUL;
    tf->codes[330] = 0x000c890c096dUL;
    tf->codes[331] = 0x000c81080b6cUL;
    tf->codes[332] = 0x000cb914056bUL;
    tf->codes[333] = 0x000cb110076aUL;
    tf->codes[334] = 0x000ca91c0169UL;
    tf->codes[335] = 0x000ca1180368UL;
    tf->codes[336] = 0x000c59643d77UL;
    tf->codes[337] = 0x000c51603f76UL;
    tf->codes[338] = 0x000c496c3975UL;
    tf->codes[339] = 0x000c41683b74UL;
    tf->codes[340] = 0x000c79743573UL;
    tf->codes[341] = 0x000c71703772UL;
    tf->codes[342] = 0x000c697c3171UL;
    tf->codes[343] = 0x000c61783370UL;
    tf->codes[344] = 0x000c19442d7fUL;
    tf->codes[345] = 0x000c11402f7eUL;
    tf->codes[346] = 0x000c094c297dUL;
    tf->codes[347] = 0x000c01482b7cUL;
    tf->codes[348] = 0x000c3954257bUL;
    tf->codes[349] = 0x000c3150277aUL;
    tf->codes[350] = 0x000c295c2179UL;
    tf->codes[351] = 0x000c21582378UL;
    tf->codes[352] = 0x000dd9a45d47UL;
    tf->codes[353] = 0x000dd1a05f46UL;
    tf->codes[354] = 0x000dc9ac5945UL;
    tf->codes[355] = 0x000dc1a85b44UL;
    tf->codes[356] = 0x000df9b45543UL;
    tf->codes[357] = 0x000df1b05742UL;
    tf->codes[358] = 0x000de9bc5141UL;
    tf->codes[359] = 0x000de1b85340UL;
    tf->codes[360] = 0x000d99844d4fUL;
    tf->codes[361] = 0x000d91804f4eUL;
    tf->codes[362] = 0x000d898c494dUL;
    tf->codes[363] = 0x000d81884b4cUL;
    tf->codes[364] = 0x000db994454bUL;
    tf->codes[365] = 0x000db190474aUL;
    tf->codes[366] = 0x000da99c4149UL;
    tf->codes[367] = 0x000da1984348UL;
    tf->codes[368] = 0x000d59e47d57UL;
    tf->codes[369] = 0x000d51e07f56UL;
    tf->codes[370] = 0x000d49ec7955UL;
    tf->codes[371] = 0x000d41e87b54UL;
    tf->codes[372] = 0x000d79f47553UL;
    tf->codes[373] = 0x000d71f07752UL;
    tf->codes[374] = 0x000d69fc7151UL;
    tf->codes[375] = 0x000d61f87350UL;
    tf->codes[376] = 0x000d19c46d5fUL;
    tf->codes[377] = 0x000d11c06f5eUL;
    tf->codes[378] = 0x000d09cc695dUL;
    tf->codes[379] = 0x000d01c86b5cUL;
    tf->codes[380] = 0x000d39d4655bUL;
    tf->codes[381] = 0x000d31d0675aUL;
    tf->codes[382] = 0x000d29dc6159UL;
    tf->codes[383] = 0x000d21d86358UL;
    tf->codes[384] = 0x000ada259da7UL;
    tf->codes[385] = 0x000ad2219fa6UL;
    tf->codes[386] = 0x000aca2d99a5UL;
    tf->codes[387] = 0x000ac2299ba4UL;
    tf->codes[388] = 0x000afa3595a3UL;
    tf->codes[389] = 0x000af23197a2UL;
    tf->codes[390] = 0x000aea3d91a1UL;
    tf->codes[391] = 0x000ae23993a0UL;
    tf->codes[392] = 0x000a9a058dafUL;
    tf->codes[393] = 0x000a92018faeUL;
    tf->codes[394] = 0x000a8a0d89adUL;
    tf->codes[395] = 0x000a82098bacUL;
    tf->codes[396] = 0x000aba1585abUL;
    tf->codes[397] = 0x000ab21187aaUL;
    tf->codes[398] = 0x000aaa1d81a9UL;
    tf->codes[399] = 0x000aa21983a8UL;
    tf->codes[400] = 0x000a5a65bdb7UL;
    tf->codes[401] = 0x000a5261bfb6UL;
    tf->codes[402] = 0x000a4a6db9b5UL;
    tf->codes[403] = 0x000a4269bbb4UL;
    tf->codes[404] = 0x000a7a75b5b3UL;
    tf->codes[405] = 0x000a7271b7b2UL;
    tf->codes[406] = 0x000a6a7db1b1UL;
    tf->codes[407] = 0x000a6279b3b0UL;
    tf->codes[408] = 0x000a1a45adbfUL;
    tf->codes[409] = 0x000a1241afbeUL;
    tf->codes[410] = 0x000a0a4da9bdUL;
    tf->codes[411] = 0x000a0249abbcUL;
    tf->codes[412] = 0x000a3a55a5bbUL;
    tf->codes[413] = 0x000a3251a7baUL;
    tf->codes[414] = 0x000a2a5da1b9UL;
    tf->codes[415] = 0x000a2259a3b8UL;
    tf->codes[416] = 0x000bdaa5dd87UL;
    tf->codes[417] = 0x000bd2a1df86UL;
    tf->codes[418] = 0x000bcaadd985UL;
    tf->codes[419] = 0x000bc2a9db84UL;
    tf->codes[420] = 0x000bfab5d583UL;
    tf->codes[421] = 0x000bf2b1d782UL;
    tf->codes[422] = 0x000beabdd181UL;
    tf->codes[423] = 0x000be2b9d380UL;
    tf->codes[424] = 0x000b9a85cd8fUL;
    tf->codes[425] = 0x000b9281cf8eUL;
    tf->codes[426] = 0x000b8a8dc98dUL;
    tf->codes[427] = 0x000b8289cb8cUL;
    tf->codes[428] = 0x000bba95c58bUL;
    tf->codes[429] = 0x000bb291c78aUL;
    tf->codes[430] = 0x000baa9dc189UL;
    tf->codes[431] = 0x000ba299c388UL;
    tf->codes[432] = 0x000b5ae5fd97UL;
    tf->codes[433] = 0x000b52e1ff96UL;
    tf->codes[434] = 0x000b4aedf995UL;
    tf->codes[435] = 0x000b42e9fb94UL;
    tf->codes[436] = 0x000b7af5f593UL;
    tf->codes[437] = 0x000b72f1f792UL;
    tf->codes[438] = 0x000b6afdf191UL;
    tf->codes[439] = 0x000b62f9f390UL;
    tf->codes[440] = 0x000b1ac5ed9fUL;
    tf->codes[441] = 0x000b12c1ef9eUL;
    tf->codes[442] = 0x000b0acde99dUL;
    tf->codes[443] = 0x000b02c9eb9cUL;
    tf->codes[444] = 0x000b3ad5e59bUL;
    tf->codes[445] = 0x000b32d1e79aUL;
    tf->codes[446] = 0x000b2adde199UL;
    tf->codes[447] = 0x000b22d9e398UL;
    tf->codes[448] = 0x0008db251de7UL;
    tf->codes[449] = 0x0008d3211fe6UL;
    tf->codes[450] = 0x0008cb2d19e5UL;
    tf->codes[451] = 0x0008c3291be4UL;
    tf->codes[452] = 0x0008fb3515e3UL;
    tf->codes[453] = 0x0008f33117e2UL;
    tf->codes[454] = 0x0008eb3d11e1UL;
    tf->codes[455] = 0x0008e33913e0UL;
    tf->codes[456] = 0x00089b050defUL;
    tf->codes[457] = 0x000893010feeUL;
    tf->codes[458] = 0x00088b0d09edUL;
    tf->codes[459] = 0x000883090becUL;
    tf->codes[460] = 0x0008bb1505ebUL;
    tf->codes[461] = 0x0008b31107eaUL;
    tf->codes[462] = 0x0008ab1d01e9UL;
    tf->codes[463] = 0x0008a31903e8UL;
    tf->codes[464] = 0x00085b653df7UL;
    tf->codes[465] = 0x000853613ff6UL;
    tf->codes[466] = 0x00084b6d39f5UL;
    tf->codes[467] = 0x000843693bf4UL;
    tf->codes[468] = 0x00087b7535f3UL;
    tf->codes[469] = 0x0008737137f2UL;
    tf->codes[470] = 0x00086b7d31f1UL;
    tf->codes[471] = 0x0008637933f0UL;
    tf->codes[472] = 0x00081b452dffUL;
    tf->codes[473] = 0x000813412ffeUL;
    tf->codes[474] = 0x00080b4d29fdUL;
    tf->codes[475] = 0x000803492bfcUL;
    tf->codes[476] = 0x00083b5525fbUL;
    tf->codes[477] = 0x0008335127faUL;
    tf->codes[478] = 0x00082b5d21f9UL;
    tf->codes[479] = 0x0008235923f8UL;
    tf->codes[480] = 0x0009dba55dc7UL;
    tf->codes[481] = 0x0009d3a15fc6UL;
    tf->codes[482] = 0x0009cbad59c5UL;
    tf->codes[483] = 0x0009c3a95bc4UL;
    tf->codes[484] = 0x0009fbb555c3UL;
    tf->codes[485] = 0x0009f3b157c2UL;
    tf->codes[486] = 0x0009ebbd51c1UL;
    tf->codes[487] = 0x0009e3b953c0UL;
    tf->codes[488] = 0x00099b854dcfUL;
    tf->codes[489] = 0x000993814fceUL;
    tf->codes[490] = 0x00098b8d49cdUL;
    tf->codes[491] = 0x000983894bccUL;
    tf->codes[492] = 0x0009bb9545cbUL;
    tf->codes[493] = 0x0009b39147caUL;
    tf->codes[494] = 0x0009ab9d41c9UL;
    tf->codes[495] = 0x0009a39943c8UL;
    tf->codes[496] = 0x00095be57dd7UL;
    tf->codes[497] = 0x000953e17fd6UL;
    tf->codes[498] = 0x00094bed79d5UL;
    tf->codes[499] = 0x000943e97bd4UL;
    tf->codes[500] = 0x00097bf575d3UL;
    tf->codes[501] = 0x000973f177d2UL;
    tf->codes[502] = 0x00096bfd71d1UL;
    tf->codes[503] = 0x000963f973d0UL;
    tf->codes[504] = 0x00091bc56ddfUL;
    tf->codes[505] = 0x000913c16fdeUL;
    tf->codes[506] = 0x00090bcd69ddUL;
    tf->codes[507] = 0x000903c96bdcUL;
    tf->codes[508] = 0x00093bd565dbUL;
    tf->codes[509] = 0x000933d167daUL;
    tf->codes[510] = 0x00092bdd61d9UL;
    tf->codes[511] = 0x000923d963d8UL;

    return tf;
}

void tag36artoolkit_destroy(apriltag_family_t *tf)
{
    free(tf->name);
    free(tf->codes);
    free(tf);
}
