/*****************************************************************************\
  dj970_maps.cpp : Color maps for DJ970

  Copyright (c) 1996 - 2001UL, Hewlett-Packard Co.
  All rights reserved.

  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions
  are met:
  1. Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
  2. Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.
  3. Neither the name of Hewlett-Packard nor the names of its
     contributors may be used to endorse or promote products derived
     from this software without specific prior written permission.

  THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR IMPLIED
  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
  MERCHANTABILITY AND FITNESS FOR A PARTICAR PURPOSE ARE DISCLAIMED.  IN
  NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
  TO, PATENT INFRINGEMENT; PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
  OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
  ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
\*****************************************************************************/

#include "CommonDefinitions.h"

// 600x600x1, K    - Plain, Normal, Grey

uint32_t ulMapGRAY_K_6x6x1[] =
{
    255UL, 238UL, 218UL, 204UL, 189UL, 181UL, 171UL, 161UL, 154UL,
    178UL, 168UL, 161UL, 153UL, 148UL, 141UL, 136UL, 130UL, 127UL,
    140UL, 133UL, 129UL, 124UL, 121UL, 116UL, 113UL, 109UL, 106UL,
    115UL, 112UL, 108UL, 104UL, 101UL,  97UL,  95UL,  91UL,  89UL,
     96UL,  94UL,  90UL,  88UL,  85UL,  82UL,  79UL,  77UL,  74UL,
     81UL,  78UL,  76UL,  73UL,  71UL,  69UL,  66UL,  65UL,  62UL,
     67UL,  66UL,  63UL,  62UL,  59UL,  57UL,  55UL,  54UL,  51UL,
     56UL,  55UL,  52UL,  51UL,  49UL,  47UL,  45UL,  44UL,  42UL,
     47UL,  45UL,  43UL,  41UL,  40UL,  38UL,  37UL,  35UL,  33UL,
    209UL, 191UL, 184UL, 173UL, 166UL, 156UL, 151UL, 144UL, 140UL,
    154UL, 149UL, 143UL, 138UL, 132UL, 128UL, 123UL, 120UL, 115UL,
    127UL, 122UL, 119UL, 114UL, 111UL, 107UL, 104UL, 100UL,  96UL,
    106UL, 102UL,  99UL,  95UL,  93UL,  90UL,  87UL,  84UL,  81UL,
     89UL,  85UL,  83UL,  80UL,  78UL,  75UL,  73UL,  70UL,  68UL,
     74UL,  71UL,  69UL,  67UL,  65UL,  63UL,  61UL,  59UL,  57UL,
     62UL,  60UL,  58UL,  56UL,  54UL,  52UL,  50UL,  48UL,  47UL,
     51UL,  50UL,  48UL,  46UL,  44UL,  43UL,  41UL,  39UL,  38UL,
     42UL,  40UL,  38UL,  37UL,  35UL,  34UL,  32UL,  31UL,  29UL,
    176UL, 168UL, 159UL, 153UL, 146UL, 141UL, 135UL, 130UL, 125UL,
    140UL, 133UL, 129UL, 124UL, 121UL, 116UL, 113UL, 109UL, 106UL,
    115UL, 112UL, 108UL, 104UL, 101UL,  97UL,  95UL,  91UL,  89UL,
     96UL,  94UL,  90UL,  88UL,  85UL,  82UL,  79UL,  77UL,  74UL,
     81UL,  78UL,  76UL,  73UL,  71UL,  69UL,  66UL,  65UL,  62UL,
     67UL,  66UL,  63UL,  62UL,  59UL,  57UL,  55UL,  54UL,  51UL,
     56UL,  55UL,  52UL,  51UL,  49UL,  47UL,  45UL,  44UL,  42UL,
     47UL,  45UL,  43UL,  41UL,  40UL,  38UL,  37UL,  35UL,  33UL,
     38UL,  36UL,  34UL,  32UL,  31UL,  29UL,  28UL,  26UL,  25UL,
    153UL, 148UL, 143UL, 136UL, 132UL, 127UL, 122UL, 119UL, 114UL,
    125UL, 122UL, 118UL, 114UL, 110UL, 107UL, 103UL, 100UL,  96UL,
    105UL, 102UL,  98UL,  95UL,  92UL,  90UL,  86UL,  84UL,  81UL,
     88UL,  85UL,  83UL,  80UL,  77UL,  75UL,  72UL,  70UL,  67UL,
     74UL,  71UL,  69UL,  67UL,  65UL,  63UL,  61UL,  59UL,  57UL,
     62UL,  60UL,  58UL,  56UL,  54UL,  52UL,  50UL,  48UL,  47UL,
     51UL,  49UL,  48UL,  46UL,  44UL,  42UL,  41UL,  39UL,  38UL,
     42UL,  40UL,  38UL,  37UL,  35UL,  33UL,  32UL,  30UL,  29UL,
     33UL,  31UL,  30UL,  28UL,  27UL,  25UL,  24UL,  22UL,  21UL,
    138UL, 132UL, 128UL, 123UL, 120UL, 115UL, 112UL, 108UL, 105UL,
    115UL, 111UL, 108UL, 104UL, 101UL,  97UL,  95UL,  91UL,  89UL,
     96UL,  93UL,  90UL,  87UL,  85UL,  81UL,  79UL,  76UL,  74UL,
     81UL,  78UL,  76UL,  73UL,  71UL,  68UL,  66UL,  64UL,  62UL,
     67UL,  66UL,  63UL,  62UL,  59UL,  57UL,  55UL,  53UL,  51UL,
     56UL,  55UL,  52UL,  51UL,  49UL,  47UL,  45UL,  44UL,  42UL,
     46UL,  45UL,  43UL,  41UL,  39UL,  38UL,  36UL,  35UL,  33UL,
     37UL,  36UL,  34UL,  32UL,  31UL,  29UL,  28UL,  26UL,  25UL,
     28UL,  27UL,  26UL,  24UL,  22UL,  21UL,  19UL,  18UL,  16UL,
    124UL, 121UL, 116UL, 113UL, 109UL, 106UL, 102UL,  99UL,  95UL,
    105UL, 102UL,  98UL,  95UL,  92UL,  90UL,  86UL,  83UL,  81UL,
     88UL,  85UL,  82UL,  80UL,  77UL,  75UL,  72UL,  70UL,  67UL,
     73UL,  71UL,  69UL,  67UL,  65UL,  63UL,  60UL,  59UL,  56UL,
     62UL,  60UL,  57UL,  56UL,  54UL,  52UL,  50UL,  48UL,  46UL,
     51UL,  49UL,  48UL,  46UL,  44UL,  42UL,  40UL,  39UL,  37UL,
     42UL,  40UL,  38UL,  37UL,  35UL,  33UL,  32UL,  30UL,  29UL,
     33UL,  31UL,  30UL,  28UL,  27UL,  25UL,  24UL,  22UL,  21UL,
     25UL,  23UL,  22UL,  20UL,  19UL,  17UL,  16UL,  14UL,  12UL,
    114UL, 110UL, 107UL, 103UL, 100UL,  96UL,  94UL,  90UL,  88UL,
     95UL,  93UL,  90UL,  87UL,  84UL,  81UL,  78UL,  76UL,  73UL,
     81UL,  78UL,  76UL,  73UL,  71UL,  68UL,  66UL,  64UL,  62UL,
     67UL,  65UL,  63UL,  61UL,  59UL,  57UL,  55UL,  53UL,  51UL,
     56UL,  54UL,  52UL,  50UL,  49UL,  47UL,  45UL,  43UL,  42UL,
     46UL,  44UL,  43UL,  41UL,  39UL,  38UL,  36UL,  34UL,  33UL,
     37UL,  36UL,  34UL,  32UL,  31UL,  29UL,  28UL,  26UL,  25UL,
     28UL,  27UL,  25UL,  24UL,  22UL,  21UL,  19UL,  18UL,  16UL,
     20UL,  19UL,  17UL,  16UL,  14UL,  13UL,  11UL,  10UL,   8UL,
    104UL, 101UL,  97UL,  95UL,  91UL,  89UL,  85UL,  83UL,  80UL,
     88UL,  85UL,  82UL,  79UL,  77UL,  74UL,  72UL,  69UL,  67UL,
     73UL,  71UL,  69UL,  66UL,  65UL,  62UL,  60UL,  58UL,  56UL,
     62UL,  60UL,  57UL,  56UL,  54UL,  52UL,  50UL,  48UL,  46UL,
     51UL,  49UL,  47UL,  46UL,  44UL,  42UL,  40UL,  39UL,  37UL,
     41UL,  40UL,  38UL,  37UL,  35UL,  33UL,  31UL,  30UL,  28UL,
     32UL,  31UL,  29UL,  28UL,  26UL,  25UL,  23UL,  22UL,  20UL,
     25UL,  23UL,  22UL,  20UL,  19UL,  17UL,  16UL,  14UL,  12UL,
     16UL,  15UL,  13UL,  12UL,  10UL,   9UL,   7UL,   6UL,   4UL,
     95UL,  92UL,  90UL,  86UL,  84UL,  81UL,  78UL,  76UL,  73UL,
     80UL,  78UL,  75UL,  73UL,  70UL,  68UL,  66UL,  64UL,  62UL,
     67UL,  65UL,  63UL,  61UL,  59UL,  57UL,  55UL,  53UL,  51UL,
     56UL,  54UL,  52UL,  50UL,  48UL,  47UL,  45UL,  43UL,  41UL,
     46UL,  44UL,  43UL,  41UL,  39UL,  38UL,  36UL,  34UL,  33UL,
     37UL,  35UL,  34UL,  32UL,  31UL,  29UL,  28UL,  26UL,  25UL,
     28UL,  27UL,  25UL,  24UL,  22UL,  21UL,  19UL,  18UL,  16UL,
     20UL,  19UL,  17UL,  16UL,  14UL,  12UL,  11UL,   9UL,   8UL,
     12UL,  11UL,   9UL,   8UL,   6UL,   5UL,   3UL,   2UL,   0UL
};

uint32_t ulMapDJ970_KCMY[ 9*9*9 ]=
{
 673723135UL,   26007371UL,    9756717UL,   10020638UL,   10022677UL,   10153743UL, 
  10285066UL,   10416133UL,    9169408UL, 3405886809UL,      59743UL,   23980849UL, 
   9366812UL,   10153744UL,   10285066UL,   10153990UL,   10087424UL,    9169408UL, 
3858807091UL, 2197868343UL,      60220UL,    4714015UL,    7270155UL,    8646656UL, 
   8579328UL,    8382208UL,    7791360UL, 3875584801UL, 3187785766UL, 1660999718UL, 
     60710UL,   36498447UL,    4646144UL,    5166848UL,    5624832UL,    5886976UL, 
3875585303UL, 3573661210UL, 2667629594UL, 1208016666UL,  319808529UL,  304931585UL, 
   3000832UL,    3652608UL,    4176384UL, 3892820492UL, 3758145040UL, 3187721745UL, 
2197869329UL,  939582223UL,  387244805UL,  152818688UL,    2341120UL,    2927872UL, 
3909859588UL, 3892624647UL, 3472998923UL, 2835401737UL, 1728109064UL,  957341698UL, 
 336716032UL,    1099008UL,    1944832UL, 3909661952UL, 3909269763UL, 3741368579UL, 
3238053891UL, 2516635904UL, 1375786499UL,  688380160UL,      56064UL,    1031168UL, 
3925912832UL, 3909136896UL, 3691033856UL, 3355490816UL, 2717957120UL, 1778432512UL, 
 973126144UL,  436259072UL,      54784UL, 3183805035UL,   13972558UL,   11965228UL, 
  11449373UL,   10995222UL,   27643922UL,   27514893UL,   27451400UL,    9560832UL, 
4015155266UL, 1835890539UL,  211079218UL,   26991389UL,   27255056UL,   27321354UL, 
  10087171UL,    9168128UL,    8249088UL, 3928464674UL, 3004413502UL,  809093171UL, 
 308797461UL,  109046276UL,    8512768UL,    8118528UL,    7658752UL,    7133184UL, 
3910708498UL, 3523329062UL, 2165818909UL,  993775120UL,  575525632UL,    4378368UL, 
   5164288UL,    5623040UL,    5753856UL, 3910513160UL, 3892624145UL, 2919613972UL, 
1730004745UL,  892520192UL,  288014592UL,    2864640UL,    3649536UL,    4240640UL, 
3910120707UL, 3892689928UL, 3305161995UL, 2349777670UL, 1276887296UL,  505330688UL, 
 119058688UL,    2204416UL,    2859264UL, 3909923840UL, 3909138435UL, 3523263488UL, 
2802367488UL, 1661777152UL,  823047168UL,  252687104UL,     958464UL,    1873408UL, 
3925912576UL, 3691030016UL, 3338708224UL, 2801837312UL, 1912644608UL, 1057007104UL, 
 520136448UL,   84257792UL,     956928UL, 3724581888UL, 3506475520UL, 3254817536UL, 
2852164608UL, 2214631936UL, 1493213184UL,  855680256UL,  385919744UL,      44544UL, 
3805020222UL,  904134721UL,   14429742UL,   12876059UL,   12034579UL,   11580943UL, 
  11387914UL,   11128584UL,   10082048UL, 3935974696UL, 2377526339UL,  381966891UL, 
  12422935UL,   11841035UL,   11517956UL,   10734848UL,    9752576UL,    8441856UL, 
4017191173UL, 3663951909UL, 2509611275UL, 1100725504UL,  226741760UL,    7917824UL, 
   7590144UL,    7129856UL,    6668800UL, 3980299776UL, 3895762190UL, 3075845379UL, 
1583263232UL,  559065856UL,    4698880UL,    5421824UL,    5684224UL,    5618176UL, 
3961691136UL, 3927877891UL, 3375083778UL, 1932502272UL,  875864832UL,  271360256UL, 
   3056128UL,    3909376UL,    4369408UL, 3943867136UL, 3926765056UL, 3474239744UL, 
2300093184UL, 1176083200UL,  538810368UL,  102274048UL,    2199808UL,    2921984UL, 
3943081472UL, 3791692800UL, 3305152000UL, 2433193984UL, 1443467776UL,  738889472UL, 
 286100736UL,     886016UL,    1737216UL, 3875577088UL, 3439363584UL, 3120596736UL, 
2516616704UL, 1660978688UL,  973113088UL,  453019136UL,      33280UL,     883456UL, 
3573581056UL, 3271587328UL, 2986374144UL, 2499834880UL, 1862301440UL, 1291876864UL, 
 805339648UL,  352355328UL,      33792UL, 3838771235UL, 2229010470UL,  233504809UL, 
  14755610UL,   13525519UL,   12553738UL,   12035848UL,   11647238UL,   10798848UL, 
3904054036UL, 3200782122UL, 1003559969UL,  131218706UL,   13266692UL,   12162304UL, 
  11511808UL,   10859264UL,   10009088UL, 4002237696UL, 3801629204UL, 2762892800UL, 
1152083712UL,  194999040UL,    9931776UL,    9608448UL,    8889856UL,    7842560UL, 
4098708736UL, 3999230464UL, 3127209220UL, 1583244288UL,  609975040UL,    5149696UL, 
   5547520UL,    5679872UL,    5548032UL, 4062537728UL, 3978851584UL, 3106761472UL, 
1882548992UL,  926511360UL,  288454400UL,    3375616UL,    4101120UL,    4364800UL, 
4027612672UL, 3943597056UL, 3222631168UL, 2132504320UL, 1159557120UL,  538996992UL, 
 102461696UL,    2389760UL,    2982400UL, 3942679808UL, 3707795968UL, 3120589824UL, 
2315808768UL, 1393257984UL,  722234368UL,  286157568UL,     944384UL,    1797120UL, 
3741350656UL, 3321914624UL, 2952815360UL, 2365613824UL, 1543530240UL,  922772736UL, 
 436233472UL,      24832UL,     812032UL, 3472911104UL, 3137363200UL, 2785040896UL, 
2281724672UL, 1660967680UL, 1157651968UL,  738222592UL,  335569664UL,      25088UL, 
3838836756UL, 2899836951UL, 1189412888UL,   15597591UL,   15015690UL,   13914373UL, 
  13007875UL,   12360194UL,   11578624UL, 3904642310UL, 3503097879UL, 1725237778UL, 
 601694217UL,   81081089UL,   12932864UL,   12089088UL,   11308032UL,   10787840UL, 
3969395712UL, 3853397762UL, 2779723008UL, 1269511680UL,  346766080UL,   10637312UL, 
  10185984UL,    9666560UL,    8948992UL, 4099617792UL, 3882433280UL, 2875668992UL, 
1617574912UL,  661537024UL,    6703360UL,    7300096UL,    7436032UL,    6914048UL, 
4163778304UL, 3945872896UL, 3107536896UL, 1966948864UL, 1061110784UL,  322653952UL, 
   3824896UL,    4420096UL,    4553728UL, 4128524288UL, 3977595904UL, 3122152448UL, 
2082292736UL, 1176585984UL,  589516032UL,  102715136UL,    2579200UL,    3172608UL, 
4110440960UL, 3674230016UL, 3037153536UL, 2181711872UL, 1376668672UL,  739200512UL, 
 269504512UL,    1134336UL,    1922048UL, 3741342208UL, 3254799360UL, 2835367936UL, 
2197833216UL, 1442859008UL,  889211648UL,  419449600UL,      18688UL,     806144UL, 
3422573824UL, 3019917824UL, 2650817792UL, 2113946880UL, 1560299264UL, 1107315200UL, 
 721439488UL,  352341248UL,      18944UL, 3855353864UL, 3235184653UL, 2011168781UL, 
 585826314UL,   15468551UL,   15145472UL,   14304000UL,   13461760UL,   12749312UL, 
3904640001UL, 3671001096UL, 2463697669UL,  936907522UL,  232003840UL,   13181952UL, 
  12534272UL,   11886336UL,   11237120UL, 3969652992UL, 3853391872UL, 2846693888UL, 
1353390848UL,  481238528UL,   11084800UL,   10895616UL,   10377216UL,    9660928UL, 
4083424768UL, 3815579136UL, 2825527296UL, 1634542080UL,  779232256UL,  158607360UL, 
   7945472UL,    8147200UL,    7757824UL, 4164428544UL, 3694667008UL, 2822513920UL, 
1849763328UL,  994387968UL,  340339456UL,    4929536UL,    5655808UL,    5724672UL, 
4212793856UL, 3894158848UL, 3072403712UL, 2082810624UL, 1227304192UL,  656878080UL, 
 103167232UL,    2900736UL,    3494144UL, 4178063104UL, 3825806848UL, 3087739904UL, 
2181901824UL, 1326395392UL,  772944896UL,  303183104UL,    1259264UL,    1982976UL, 
3909106176UL, 3372233216UL, 2818584576UL, 2147495936UL, 1392521216UL,  855650816UL, 
 419443712UL,      13824UL,     866560UL, 3456122368UL, 2969581568UL, 2566927616UL, 
2080388096UL, 1543517440UL, 1073755648UL,  687880192UL,  352335872UL,      14080UL, 
3872000258UL, 3453223175UL, 2648440837UL, 1290141699UL,  351076352UL,   15534080UL, 
  15339776UL,   14169344UL,   13785600UL, 3904572160UL, 3754754051UL, 2832334848UL, 
1288699904UL,  348979200UL,   13175552UL,   12851712UL,   12399616UL,   12079104UL, 
3953003520UL, 3853125120UL, 2745171968UL, 1453786624UL,  581568768UL,   10881536UL, 
  11214080UL,   11089152UL,   10570240UL, 4067102464UL, 3798797824UL, 2825456896UL, 
1651314176UL,  829624320UL,  259723520UL,    8330240UL,    8729344UL,    8537344UL, 
4047377920UL, 3577419008UL, 2789151744UL, 1816335616UL, 1011291392UL,  458102272UL, 
   5183744UL,    6041600UL,    6308608UL, 4011989504UL, 3542227456UL, 2720208896UL, 
1898452992UL, 1160452096UL,  623843328UL,  120593408UL,    3680768UL,    4209152UL, 
4245624064UL, 3792771584UL, 3021019392UL, 2182355712UL, 1360403712UL,  823598848UL, 
 404232704UL,    1582080UL,    2240256UL, 4110425088UL, 3539998976UL, 2902464768UL, 
2181044736UL, 1375738624UL,  805313280UL,  436216064UL,       8448UL,     927744UL, 
3674220288UL, 3103794176UL, 2617254912UL, 2046829824UL, 1476404480UL, 1023419648UL, 
 654321408UL,  335554304UL,       9472UL, 3888645121UL, 3637772291UL, 3050897410UL, 
1977745408UL,  854196224UL,  233701376UL,   15400960UL,   15141632UL,   14494464UL, 
3904438272UL, 3653238784UL, 2864578560UL, 1774321664UL,  801570816UL,  214433792UL, 
  12977920UL,   12849664UL,   12658944UL, 3969646592UL, 3667853312UL, 2795241472UL, 
1721892864UL,  849870848UL,  229179392UL,   11142912UL,   11343104UL,   11282688UL, 
3983212544UL, 3664314368UL, 2808545280UL, 1684733952UL,  913440768UL,  309854208UL, 
   8390144UL,    9180672UL,    9251072UL, 3980331008UL, 3476751616UL, 2688155648UL, 
1715404800UL,  943915008UL,  491520000UL,    5373952UL,    6166016UL,    6760704UL, 
3794145024UL, 3324185600UL, 2619672832UL, 1831471360UL, 1127024896UL,  607127808UL, 
 204802304UL,    3871744UL,    4531200UL, 3944157696UL, 3440643840UL, 2736000256UL, 
1897270272UL, 1226312704UL,  739838976UL,  320604672UL,    2035968UL,    2694912UL, 
4161145600UL, 3607497728UL, 2936343552UL, 2164657152UL, 1443302912UL,  872877824UL, 
 503845120UL,  185273344UL,    1055488UL, 3976205056UL, 3305115904UL, 2701136384UL, 
2080379648UL, 1509954816UL,  989861120UL,  587207936UL,  318772992UL,       5888UL, 
3738435584UL, 3621060608UL, 3218210816UL, 2497183744UL, 1441071104UL,  720044032UL, 
 300810240UL,   15728640UL,   15728640UL, 3904307200UL, 3434151936UL, 2914320384UL, 
2176581632UL, 1287979008UL,  633995264UL,  248250368UL,   13500416UL,   13565952UL, 
3852009472UL, 3348234240UL, 2727608320UL, 1973157888UL, 1252327424UL,  631963648UL, 
 229507072UL,   11468800UL,   11730944UL, 3664314368UL, 3261333504UL, 2691235840UL, 
1852768256UL, 1215758336UL,  662568960UL,  226820096UL,    9175040UL,    9830400UL, 
3611230208UL, 3158245376UL, 2588082176UL, 1850212352UL, 1179516928UL,  710082560UL, 
 274202624UL,    6160384UL,    7208960UL, 3659857920UL, 3173384192UL, 2502492160UL, 
1798111232UL, 1160839168UL,  691208192UL,  322306048UL,    3932160UL,    4849664UL, 
3507486720UL, 3037790208UL, 2467561472UL, 1763115008UL, 1159331840UL,  706412544UL, 
 354287616UL,    2293760UL,    3080192UL, 3741581312UL, 3288662016UL, 2667970560UL, 
1896284160UL, 1225261056UL,  755564544UL,  436928512UL,  118423552UL,    1572864UL, 
4278190080UL, 3472883712UL, 2818572288UL, 2097152000UL, 1493172224UL, 1006632960UL, 
 620756992UL,  335544320UL,          0UL, 
 };

uint32_t ulMapDJ970_KCMY_3x3x2[ 9*9*9 ]=
{
1920105215UL,   60881733UL,   10551078UL,   10288922UL,   10223378UL,    9895694UL, 
   9895690UL,   10157829UL,   10157824UL, 4278246736UL,      65363UL,    8388394UL, 
   9895705UL,    9961232UL,    9895691UL,   10092296UL,   10092292UL,   10157824UL, 
4278966312UL, 2818631985UL,      65334UL,    6291229UL,    8257294UL,    9109254UL, 
  10223360UL,    9699072UL,    9633536UL, 4279751190UL, 3791969570UL, 2231430434UL, 
     65318UL,    4259603UL,    6553347UL,    7533568UL,    7859712UL,    8055296UL, 
4280339978UL, 4278246676UL, 3187729943UL, 1761669401UL,      65305UL,    2883338UL, 
   5041408UL,    6084608UL,    6608128UL, 4280732161UL, 4278246669UL, 3674398992UL, 
2717968655UL, 1459680272UL,      65295UL,    2095363UL,    4183808UL,    5098496UL, 
4279552258UL, 4279162627UL, 4043431433UL, 3271615752UL, 2315316489UL, 1191245065UL, 
  50396937UL,    1828864UL,    3525632UL, 4278830848UL, 4278767360UL, 4278245632UL, 
3707822336UL, 2936072195UL, 1996549891UL, 1006696195UL,      65283UL,    1759488UL, 
4278237952UL, 4278239744UL, 4110469632UL, 3674263296UL, 3254835200UL, 2516638720UL, 
1644223744UL,  822144768UL,      65280UL, 3706389867UL,   16138823UL,   64936234UL, 
  31323927UL,   46595346UL,   11992843UL,   11337480UL,   11337476UL,   11009792UL, 
4287273261UL, 2189593947UL,   10813229UL,   10747673UL,   10485519UL,   10354441UL, 
  10485509UL,   10551040UL,    9696256UL, 4283283480UL, 3641890107UL,  657252153UL, 
  57604636UL,    9109259UL,    9961219UL,   10026752UL,    9697280UL,    9039360UL, 
4282106121UL, 4278900765UL, 2517100065UL,  774168097UL,  172879376UL,    6747648UL, 
   7727616UL,    8054272UL,    8052992UL, 4281516545UL, 4279293453UL, 3355501844UL, 
1946870037UL,  858381071UL,  524541952UL,    5101568UL,    6082560UL,    6672640UL, 
4280532992UL, 4279293187UL, 3791773706UL, 2869551879UL, 1813699845UL,  858380291UL, 
 237622272UL,    3917568UL,    4964864UL, 4279354112UL, 4278767104UL, 4110473728UL, 
3238059010UL, 2383206400UL, 1477891328UL,  555275008UL,    1492992UL,    3324672UL, 
4278238464UL, 4127243776UL, 3774923264UL, 3288384512UL, 2634073344UL, 1828767744UL, 
1057475328UL,  235392768UL,    1556736UL, 4060131584UL, 3808472320UL, 3607147264UL, 
3288380928UL, 2835396864UL, 2248196352UL, 1543555072UL,  738249984UL,      53504UL, 
4293787704UL, 1291452479UL,   16138023UL,   15184662UL,   31578384UL,   81393413UL, 
  13827840UL,   12910336UL,   12451584UL, 4289880862UL, 2848079424UL,  350061354UL, 
  15058449UL,   31451141UL,   13826304UL,   12645632UL,   11464192UL,   10412032UL, 
4287139584UL, 4085422877UL, 2307494948UL,  949800976UL,  243856386UL,   11138816UL, 
  10219520UL,    9627136UL,    9099264UL, 4283998720UL, 4283741450UL, 3058153496UL, 
1515567640UL,  863227650UL,    7657728UL,    7984896UL,    8181248UL,    8114944UL, 
4281773568UL, 4281907968UL, 3677079305UL, 2284831499UL, 1380369157UL,  541837568UL, 
   5425152UL,    6342912UL,    6867712UL, 4280267008UL, 4279876608UL, 3960655874UL, 
2955134465UL, 1932051456UL,  976142592UL,  220970752UL,    3979520UL,    5159424UL, 
4278957056UL, 4278237696UL, 3909141504UL, 3104358144UL, 2248981760UL, 1393737472UL, 
 538294784UL,    1487616UL,    3124736UL, 4278235392UL, 3842025984UL, 3556814592UL, 
3103830272UL, 2449519104UL, 1744877056UL,  906016512UL,  184595968UL,    1420032UL, 
3858801664UL, 3573587456UL, 3372261376UL, 3053494784UL, 2550178816UL, 2046863616UL, 
1459663360UL,  687911936UL,      46080UL, 4293006619UL, 2918449187UL,  385744936UL, 
  16266776UL,   15374604UL,   15057667UL,   14802432UL,   13559552UL,   12314112UL, 
4290923277UL, 3957592103UL, 1138761255UL,   65824019UL,   15312642UL,   14534144UL, 
  13619968UL,   12637696UL,   11522816UL, 4288179200UL, 4205668878UL, 2611569687UL, 
1085699858UL,  281126656UL,   12303104UL,   11913216UL,   11258880UL,   10340864UL, 
4284640000UL, 4285956864UL, 3430714118UL, 2273809152UL, 1166453760UL,  158907392UL, 
   8504832UL,    8439808UL,    8242176UL, 4282089728UL, 4282552576UL, 3679493632UL, 
2690162944UL, 1633461760UL,  593078528UL,    5944320UL,    6732288UL,    7060992UL, 
4280325632UL, 4280196864UL, 3760366848UL, 2922292736UL, 1966187520UL, 1060480256UL, 
 221423360UL,    4368640UL,    5419008UL, 4278886144UL, 4278231296UL, 3640696832UL, 
3037701120UL, 2215879936UL, 1410704128UL,  555196416UL,    1612800UL,    3251456UL, 
4144013056UL, 3707802624UL, 3422590208UL, 3019938304UL, 2348850176UL, 1694539520UL, 
 889233152UL,  117479424UL,    1348608UL, 3724579328UL, 3489696256UL, 3238037760UL, 
2936048896UL, 2449510400UL, 1946194432UL, 1426102272UL,  671127808UL,      38400UL, 
4292615945UL, 3538944278UL, 1878523928UL,   16647962UL,   16330251UL,   15566339UL, 
  15249664UL,   14403072UL,   13421824UL, 4291180801UL, 4192668434UL, 2246838038UL, 
 300881686UL,   15948544UL,   14715392UL,   13937152UL,   13417472UL,   12435712UL, 
4288825344UL, 4290465028UL, 3149939976UL, 1539196173UL,  566847232UL,   12748032UL, 
  12625408UL,   12235776UL,   11384576UL, 4285617152UL, 4286734080UL, 3499386880UL, 
2459265792UL, 1251635200UL,    9927936UL,   10459904UL,   10332672UL,    9743872UL, 
4282666752UL, 4283392256UL, 3663424256UL, 2774692096UL, 1768518144UL,  677610240UL, 
   6394880UL,    7054848UL,    7318016UL, 4280575744UL, 4280643328UL, 3727324416UL, 
2872342272UL, 2034007040UL, 1128235264UL,  221938944UL,    4887040UL,    5742080UL, 
4279073024UL, 4278680832UL, 3658120448UL, 2953870080UL, 2216328960UL, 1461486080UL, 
 572294144UL,    1934592UL,    3508992UL, 4177559808UL, 3674241536UL, 3389028608UL, 
2969598464UL, 2332065024UL, 1644199424UL,  906002688UL,  100695040UL,    1343744UL, 
3623910656UL, 3389027840UL, 3187700736UL, 2868933888UL, 2399172864UL, 1895856384UL, 
1409318144UL,  721453312UL,      31488UL, 4292222976UL, 3807248909UL, 2700345356UL, 
1123745804UL,   16649227UL,   16458243UL,   15757824UL,   14785024UL,   14070272UL, 
4291175424UL, 4226027779UL, 2918383626UL, 1374620934UL,  149889537UL,   15090688UL, 
  14184960UL,   13537792UL,   13018880UL, 4289341696UL, 4290521088UL, 3418891777UL, 
2093493248UL,  818557952UL,   12993536UL,   12742912UL,   12553984UL,   12099840UL, 
4286263808UL, 4287051264UL, 3516152576UL, 2476228608UL, 1453212416UL,  279005696UL, 
  11037952UL,   11176704UL,   10721280UL, 4283579648UL, 4284171008UL, 3479586560UL, 
2708098048UL, 1836011264UL,  745689856UL,    7758592UL,    8617728UL,    8556032UL, 
4281153280UL, 4281287936UL, 3694545408UL, 2940162048UL, 2084918528UL, 1280070144UL, 
 272982784UL,    5076224UL,    5998080UL, 4279454720UL, 4279259648UL, 3725808896UL, 
2971096832UL, 2182895616UL, 1495424512UL,  572678912UL,    2319872UL,    3764992UL, 
4278214400UL, 3791674880UL, 3372244224UL, 2936036864UL, 2248170496UL, 1694983168UL, 
 956720384UL,  134242816UL,    1533952UL, 3590350336UL, 3321914112UL, 3070255360UL, 
2785042688UL, 2365612800UL, 1862296832UL, 1342203392UL,  704669696UL,      25856UL, 
4291827200UL, 4075356422UL, 3169976325UL, 1945632774UL,  687669253UL,   16583939UL, 
  16521216UL,   15293952UL,   14517248UL, 4291105792UL, 4292675840UL, 3371237376UL, 
2012151808UL,  518586368UL,   14882304UL,   14496000UL,   13786624UL,   13270528UL, 
4289664512UL, 4290514432UL, 3401449472UL, 2277968128UL, 1086852608UL,   12849920UL, 
  12990464UL,   12804096UL,   12418048UL, 4286978560UL, 4287764224UL, 3516273920UL, 
2509903872UL, 1537153536UL,  480517632UL,   11220480UL,   11492864UL,   11368960UL, 
4284163072UL, 4284490240UL, 3496419840UL, 2674729984UL, 1853040384UL,  947398912UL, 
   8007680UL,    9067008UL,    9532416UL, 4281739776UL, 4080544256UL, 3460114944UL, 
2756127744UL, 2051878400UL, 1330721024UL,  307443200UL,    6114816UL,    6907392UL, 
4280034048UL, 4279839488UL, 3625659648UL, 2988454144UL, 2200187648UL, 1512519168UL, 
 757936384UL,    2835968UL,    3889408UL, 4278596864UL, 4110431232UL, 3523228928UL, 
2969581056UL, 2214606592UL, 1644575744UL,  990659584UL,  168445440UL,    1592576UL, 
3741336832UL, 3389014784UL, 3070247936UL, 2684372480UL, 2298497024UL, 1828735232UL, 
1308642048UL,  654330624UL,      18688UL, 4291628544UL, 4142202880UL, 3521970176UL, 
2599682048UL, 1492779008UL,  519897088UL,   16647424UL,   16584704UL,   15289088UL, 
4291037184UL, 4292280320UL, 3470589952UL, 2547843072UL, 1457520640UL,  400424960UL, 
  14290176UL,   14098176UL,   13913088UL, 4290119424UL, 4290772992UL, 3418161152UL, 
2562785280UL, 1589903360UL,  465960960UL,   12979712UL,   13051136UL,   12865024UL, 
4287367168UL, 4287889408UL, 3466067968UL, 2593718272UL, 1738539008UL,  648085504UL, 
  11012608UL,   11610112UL,   11619840UL, 4284484864UL, 4200728320UL, 3462989312UL, 
2658206976UL, 1869940480UL, 1065027840UL,  159320576UL,    9054208UL,    9850624UL, 
4282193152UL, 4013691648UL, 3376549632UL, 2722828032UL, 2001735680UL, 1347621120UL, 
 441979392UL,    6366208UL,    7227392UL, 4280294400UL, 3961395456UL, 3374322944UL, 
2737181952UL, 2100040960UL, 1479611904UL,  724834048UL,    3612160UL,    4536832UL, 
4278915328UL, 4060550400UL, 3506902272UL, 2970228736UL, 2349537536UL, 1661868800UL, 
 974068992UL,  336860416UL,    1912576UL, 4076872192UL, 3456115200UL, 3087016704UL, 
2717918464UL, 2248157440UL, 1778395648UL, 1207970048UL,  587213824UL,      11264UL, 
4293459968UL, 4293787648UL, 3773825024UL, 3035824128UL, 2096562176UL, 1308229632UL, 
 587005952UL,  167641088UL,   16711680UL, 4291035136UL, 4022730752UL, 3469869056UL, 
2882797568UL, 2027487232UL, 1222443008UL,  501022720UL,   14483456UL,   14548992UL, 
4290314240UL, 3903848448UL, 3350659072UL, 2797404160UL, 2059468800UL, 1204027392UL, 
 449183744UL,   13041664UL,   13172736UL, 4153344000UL, 3733913600UL, 3348496384UL, 
2761687040UL, 2091122688UL, 1319567360UL,  480903168UL,   11468800UL,   11927552UL, 
4066770944UL, 3630759936UL, 3295608832UL, 2725773312UL, 2054881280UL, 1417740288UL, 
 562233344UL,    9109504UL,    9961472UL, 4282449920UL, 3762421760UL, 3242786816UL, 
2639265792UL, 2052587520UL, 1448804352UL,  710868992UL,    6488064UL,    7405568UL, 
3944218624UL, 3592290304UL, 3206742016UL, 2636906496UL, 2066808832UL, 1479868416UL, 
 792133632UL,  121372672UL,    5046272UL, 3976200192UL, 3590324224UL, 3238330368UL, 
2752118784UL, 2114846720UL, 1527906304UL,  924123136UL,  253296640UL,    2490368UL, 
4278190080UL, 3657433088UL, 3254779904UL, 2818572288UL, 2298478592UL, 1795162112UL, 
1224736768UL,  603979776UL,          0UL, 
};

uint32_t ulMapDJ970_Gossimer_Normal_KCMY[ 9*9*9 ]=
{
3351632640UL, 2545805056UL, 1604580608UL,  982710016UL,  646379776UL,  343603456UL,
 158529792UL,    6945024UL,    6813952UL, 3951407872UL, 2543246848UL, 1821825536UL,
 831126272UL,  343537920UL,  124843776UL,    7010048UL,    6877440UL,    6744832UL,
4116689152UL, 3446196736UL, 1835912448UL, 1097779456UL,  358863872UL,    6018304UL,
   6540544UL,    6671616UL,    6540544UL, 4114591232UL, 3947086592UL, 2706096640UL,
1246349568UL,  642302976UL,   88260864UL,    4829952UL,    5157376UL,    5486336UL,
4113345536UL, 4012686592UL, 3056777984UL, 2050081024UL,  774753024UL,  321766912UL,
   3256832UL,    3842560UL,    4103936UL, 4078807808UL, 4011636480UL, 3273701888UL,
2468656896UL, 1478476800UL,  471453696UL,  119390720UL,    2794752UL,    3315712UL,
4044531456UL, 3977294592UL, 3440555776UL, 2736304384UL, 1981330432UL, 1058195456UL,
 269210368UL,    1292544UL,    2399232UL, 4043809792UL, 4010257408UL, 3523850240UL,
2920197120UL, 2316414208UL, 1561376000UL,  755485440UL,   67163392UL,    1289728UL,
4076903680UL, 3808468480UL, 3355482880UL, 2801832704UL, 2231406080UL, 1644203776UL,
 973118720UL,  503365376UL,      52224UL, 3737164032UL, 2414321408UL, 1121105152UL,
 398182656UL,   10607872UL,    9496320UL,    8778496UL,    8189184UL,    7534336UL,
4186805760UL, 2711663104UL, 1990112000UL,  932235520UL,  259776768UL,    7268608UL,
   7200256UL,    7262976UL,    7131136UL, 4284259072UL, 3379471616UL, 2272503552UL,
1232382720UL,  476953088UL,    6603008UL,    6668544UL,    6668544UL,    6603008UL,
4181368832UL, 3544622848UL, 2588713472UL, 1515038208UL,  726378240UL,  155625728UL,
   4893184UL,    5352704UL,    5616128UL, 4146372864UL, 3643516160UL, 2838601728UL,
1983029248UL,  942842368UL,  372285696UL,    3185664UL,    3708672UL,    4102912UL,
4078215424UL, 3625492992UL, 2971507968UL, 2250283520UL, 1327471872UL,  572432640UL,
 119381248UL,    2527232UL,    3116032UL, 4077560320UL, 3591085568UL, 3071252992UL,
2417071872UL, 1712559872UL,  907058432UL,  269459456UL,    1217536UL,    2132736UL,
3909131008UL, 3489699072UL, 3104084992UL, 2533790208UL, 1980273152UL, 1225363968UL,
 621190144UL,   84188672UL,    1216512UL, 3808465920UL, 3489697792UL, 3187708160UL,
2684391424UL, 2164296704UL, 1526761984UL,  889228800UL,  436248832UL,      41472UL,
3888412160UL, 2631563008UL, 1339844864UL,  399216128UL,   12100096UL,   11121664UL,
  10141696UL,    9358592UL,    8706304UL, 4288117504UL, 3064168704UL, 1990820352UL,
 866487552UL,  194746368UL,    9742592UL,    9155328UL,    8567040UL,    7978496UL,
4283521280UL, 3295969024UL, 2122091008UL, 1283034880UL,  527473920UL,    6596864UL,
   6729984UL,    6664960UL,    6533120UL, 4281826048UL, 3309666560UL, 2538505728UL,
1548781824UL,  760188160UL,  189371392UL,    5151488UL,    5611520UL,    5678080UL,
4213410304UL, 3358230016UL, 2721155072UL, 1899202560UL,  942770944UL,  372280320UL,
   3181056UL,    3837440UL,    4297984UL, 4178808320UL, 3373696768UL, 2820442112UL,
2132706816UL, 1260291584UL,  555582720UL,  119309056UL,    2457344UL,    3047168UL,
4144468480UL, 3356133376UL, 2869659136UL, 2265809920UL, 1544454656UL,  839746048UL,
 286032640UL,    1145600UL,    1996544UL, 3724577792UL, 3288368128UL, 2902491904UL,
2415952896UL, 1795457536UL, 1090879232UL,  536904448UL,      32512UL,    1079296UL,
3623913216UL, 3271589888UL, 2952823040UL, 2550170112UL, 2046853376UL, 1409318144UL,
 855670016UL,  385908992UL,      33024UL, 4022356992UL, 2848934912UL, 1741574400UL,
 785336320UL,   96562432UL,   11963136UL,   11181056UL,   10266368UL,    9745408UL,
3952694016UL, 3047315456UL, 2124831488UL, 1118330368UL,  279145472UL,   10388224UL,
  10130432UL,    9477376UL,    8823808UL, 3698415872UL, 3094960896UL, 2306760192UL,
1317233152UL,  478374400UL,    8419328UL,    8620800UL,    8230144UL,    7575808UL,
3980742912UL, 3243072512UL, 2522111232UL, 1532650496UL,  777415680UL,  206535168UL,
   5343744UL,    5608192UL,    5673984UL, 4112867840UL, 3257688320UL, 2586796288UL,
1848993280UL,  942958336UL,  389311232UL,    3436800UL,    4030208UL,    4491264UL,
3776212736UL, 3222759424UL, 2652464384UL, 2048813056UL, 1209952000UL,  572352512UL,
 119302144UL,    2517504UL,    3175424UL, 3725097216UL, 3238620416UL, 2735302912UL,
2232314624UL, 1477339648UL,  806250496UL,  286025472UL,    1074432UL,    1925888UL,
3556800512UL, 3170921472UL, 2768267776UL, 2298505984UL, 1694526208UL, 1023436544UL,
 486565120UL,      25344UL,     942080UL, 3523246080UL, 3154144256UL, 2768267520UL,
2449501184UL, 1929407744UL, 1342204672UL,  822110208UL,  369124864UL,      25088UL,
3853987072UL, 2982686464UL, 1925853696UL, 1086862848UL,  482881792UL,   12473344UL,
  11761664UL,   11045632UL,   10327808UL, 3751359232UL, 3013686272UL, 2175154176UL,
1252473600UL,  581385472UL,   10571776UL,   10383616UL,    9994752UL,    9538816UL,
3598006528UL, 3061594880UL, 2306948352UL, 1417953024UL,  663175168UL,    8604416UL,
   8939776UL,    8944640UL,    8487936UL, 3444522240UL, 2991799808UL, 2388213760UL,
1616724224UL,  794837760UL,  157239296UL,    6774528UL,    7172608UL,    6912768UL,
3727570688UL, 3224452352UL, 2603892480UL, 1849180416UL,  943210752UL,  406407936UL,
   3626496UL,    4221696UL,    4617216UL, 3944104960UL, 3222881024UL, 2602189824UL,
1914520832UL, 1210140672UL,  555829248UL,  102779648UL,    2774528UL,    3368192UL,
3674886912UL, 3121236992UL, 2617854208UL, 2047559936UL, 1410354176UL,  789596672UL,
 252594688UL,    1199104UL,    1987072UL, 3556793856UL, 3019919872UL, 2617265408UL,
2164280320UL, 1610829824UL,  973098240UL,  453003008UL,      17664UL,     870912UL,
3405800448UL, 2969589504UL, 2583711744UL, 2248167424UL, 1845515776UL, 1224758016UL,
 788548864UL,  369117440UL,      17920UL, 3853850880UL, 3166837248UL, 2160729088UL,
1154162432UL,  634003968UL,  281551360UL,   12468992UL,   11757312UL,   11107840UL,
3751353344UL, 3013417984UL, 2242060288UL, 1302799360UL,  682108160UL,  245901568UL,
  10699008UL,   10313728UL,    9991424UL, 3547931136UL, 3061719808UL, 2307073024UL,
1502029568UL,  763963648UL,  210446848UL,    9125632UL,    9198336UL,    8874752UL,
3344049664UL, 2991990528UL, 2371627008UL, 1616849408UL,  878914048UL,  291843072UL,
   7027712UL,    7558144UL,    7430656UL, 3291884288UL, 2939562496UL, 2402888192UL,
1748839168UL, 1044458240UL,  423701760UL,    4338432UL,    5130240UL,    5461504UL,
3592299776UL, 3206424576UL, 2652908032UL, 1965239296UL, 1227173120UL,  606350080UL,
 136721408UL,    2834176UL,    3428096UL, 3876401152UL, 3188534784UL, 2668441344UL,
2014130176UL, 1309618176UL,  789721856UL,  286339840UL,    1390080UL,    2113280UL,
3640670976UL, 3036689664UL, 2566927616UL, 2046833664UL, 1409298944UL,  923022848UL,
 486749440UL,      12288UL,     931584UL, 3405793024UL, 2852142592UL, 2466265856UL,
2063612160UL, 1644181760UL, 1157643008UL,  721434880UL,  352335104UL,      12800UL,
3987999744UL, 3401780224UL, 2396064512UL, 1154878464UL,  534122240UL,  282268160UL,
 147724544UL,   12662272UL,   12212480UL, 3818458624UL, 3080457472UL, 2342653696UL,
1453723904UL,  732500736UL,  346625536UL,  111680000UL,   10827008UL,   10572288UL,
3581678080UL, 3045069056UL, 2307002624UL, 1552356096UL,  797578496UL,  294393344UL,
   9181952UL,    9450752UL,    9325824UL, 3361150464UL, 2975405056UL, 2371752960UL,
1617040896UL,  929437440UL,  359143424UL,    7150336UL,    7681280UL,    7817472UL,
3224967680UL, 2872645632UL, 2386302976UL, 1715476736UL, 1010964992UL,  507779584UL,
   4462592UL,    5385984UL,    5849088UL, 3240369152UL, 2921536256UL, 2401573376UL,
1781013248UL, 1126898432UL,  640489728UL,  153951232UL,    3352576UL,    3880448UL,
3574798336UL, 3172014080UL, 2668698112UL, 2048072448UL, 1309940736UL,  806690048UL,
 370547200UL,    1647616UL,    2174976UL, 3909426944UL, 3171098112UL, 2634029824UL,
2046827520UL, 1358961920UL,  805313536UL,  470098432UL,   67379200UL,    1058560UL,
3590335232UL, 2986354688UL, 2449483776UL, 1979721472UL, 1493182464UL, 1006642944UL,
 654321408UL,  318776832UL,       8704UL, 3987800832UL, 3619946496UL, 2714828800UL,
1507524608UL,  517931008UL,   15269888UL,   14616064UL,   14289920UL,   13314816UL,
4086891520UL, 3113877504UL, 2493448192UL, 1671757824UL,  833356800UL,  397215232UL,
 162334976UL,   95030784UL,   11413760UL, 3648980480UL, 3078684672UL, 2340487168UL,
1669857280UL,  915145984UL,  395183616UL,   93193728UL,    9506816UL,    9906688UL,
3394963456UL, 2992572160UL, 2405631488UL, 1667565056UL,  979961344UL,  443287296UL,
  74319872UL,    7738368UL,    8203264UL, 3275492352UL, 2856061440UL, 2352875520UL,
1681983488UL, 1011025920UL,  558237952UL,  122291968UL,    5444608UL,    6105344UL,
3223916800UL, 2804420096UL, 2317945600UL, 1730874112UL, 1110248192UL,  640617216UL,
 170920704UL,    3543808UL,    4006912UL, 3340243200UL, 2971012864UL, 2467696128UL,
1813449984UL, 1159269376UL,  739904512UL,  320604416UL,    1970176UL,    2497792UL,
3809020416UL, 3188197632UL, 2684815360UL, 2080836608UL, 1426525440UL,  872877568UL,
 503779072UL,  168364800UL,    1186048UL, 4143977472UL, 3238007296UL, 2650804992UL,
2080379904UL, 1526732288UL,  973084160UL,  587207680UL,  318772992UL,       5376UL,
3954376704UL, 3888250880UL, 3167879168UL, 2145189888UL,  988348416UL,  385548288UL,
  67043328UL,   16711680UL,   16711680UL, 4086824960UL, 3197632512UL, 2778791936UL,
2192244736UL, 1286864896UL,  616235008UL,  331153408UL,  213843968UL,   12386304UL,
3716153344UL, 3045064704UL, 2491613184UL, 2005532672UL, 1284505600UL,  630456320UL,
 311754752UL,  144048128UL,    9895936UL, 3412131840UL, 2975989760UL, 2422538240UL,
1852440576UL, 1215168512UL,  661782528UL,  259260416UL,    7733248UL,    8060928UL,
3225354240UL, 2856255488UL, 2369912832UL, 1766260736UL, 1145700352UL,  692912128UL,
 256901120UL,    5570560UL,    6160384UL, 3324510208UL, 2854879232UL, 2284584960UL,
1731067904UL, 1110507520UL,  674299904UL,  322174976UL,    3604480UL,    4194304UL,
3323068416UL, 2819948544UL, 2283274240UL, 1696202752UL, 1109131264UL,  723320832UL,
 371130368UL,    2162688UL,    2686976UL, 3624140800UL, 3121086464UL, 2533883904UL,
1913192448UL, 1208614912UL,  738918400UL,  470614016UL,  152109056UL,    1441792UL,
4244635648UL, 3053453312UL, 2600468480UL, 2097152000UL, 1543503872UL, 1006632960UL,
 587202560UL,  301989888UL,          0
};

uint32_t ulMapDJ970_Draft_KCMY[ 9*9*9 ]=
{
1802205183UL,   22740362UL,    5832524UL,    5635892UL,    5570340UL,    5308188UL,
   5308180UL,    5504778UL,    5504768UL, 4278239136UL,      65446UL,    4194132UL,
   5308210UL,    5373728UL,    5308182UL,    5504784UL,    5504776UL,    5504768UL,
4278498896UL, 1862336354UL,      65388UL,    2621242UL,    4128540UL,    4718348UL,
   5570304UL,    5177088UL,    5111552UL, 4278758188UL, 4278317636UL, 1291910980UL,
     65356UL,    1638182UL,    2817798UL,    3866368UL,    4325120UL,    4652288UL,
4279018260UL, 4278239016UL, 2717974318UL,  872480562UL,      65330UL,    1113876UL,
   2162432UL,    3407616UL,    4128512UL, 4279147522UL, 4278239002UL, 4009819936UL,
1778450206UL,  604045088UL,      65310UL,     851206UL,    2227968UL,    3079936UL,
4278688260UL, 4278563846UL, 4278244882UL, 2936078096UL, 1375797010UL,  469827346UL,
  16842514UL,     851712UL,    2096896UL, 4278425088UL, 4278428928UL, 4278237184UL,
4093705984UL, 2097217286UL, 1073806598UL,  385941254UL,      65286UL,     917248UL,
4278222592UL, 4278226176UL, 4278232832UL, 4244692736UL, 3288399616UL, 1812004608UL,
 922812160UL,  335609088UL,      65280UL, 3724477142UL,   16718478UL,   33550676UL,
  13303598UL,    9830180UL,    7798550UL,    6553360UL,    6553352UL,    6160128UL,
4282864474UL, 2206438326UL,    6029146UL,    5963570UL,    5766942UL,    5701394UL,
   5766922UL,    5832448UL,    5570304UL, 4280056368UL, 4278842230UL,  320208754UL,
  20249912UL,    4718358UL,    5373702UL,    5439232UL,    5439232UL,    5308160UL,
4279667474UL, 4278433338UL, 1644429122UL,  370278210UL,   69271328UL,    3145472UL,
   4324608UL,    4783872UL,    5046016UL, 4279405826UL, 4278628890UL, 3137404712UL,
1174732586UL,  420805918UL,  237043456UL,    2686720UL,    3735296UL,    4390656UL,
4279077120UL, 4278628358UL, 4278253844UL, 2047147790UL, 1091370762UL,  437649158UL,
 118947584UL,    2490112UL,    3342080UL, 4278619648UL, 4278428416UL, 4278241024UL,
3120627460UL, 1745288960UL,  822869760UL,  302907136UL,     917248UL,    2490112UL,
4278223616UL, 4278226432UL, 4278235904UL, 4278255360UL, 2499870464UL, 1392574208UL,
 637861632UL,  134545152UL,    1048320UL, 4278220544UL, 4278222592UL, 4278230528UL,
4278243072UL, 3170957056UL, 2097217280UL, 1040252672UL,  419495680UL,      65280UL,
4292804720UL,  503119998UL,   16718158UL,   16746540UL,   16771616UL,   29556490UL,
  11271936UL,    9502464UL,    8650496UL, 4285475388UL, 2885626240UL,  167729236UL,
  16758306UL,   15335178UL,   11664640UL,    9699072UL,    7732992UL,    7339776UL,
4282796800UL, 4282866746UL, 2374868552UL,  528613152UL,   88866564UL,    6618880UL,
   6225664UL,    6225664UL,    6618880UL, 4280441088UL, 4280251412UL, 3962958640UL,
1195375408UL,  492044036UL,    5046016UL,    5504768UL,    5766912UL,    5832448UL,
4279527168UL, 4279598848UL, 4246063890UL, 2082471702UL,  909049610UL,  321847040UL,
   3407616UL,    4390656UL,    4914944UL, 4278938880UL, 4278812928UL, 4278698244UL,
3071737090UL, 1595604736UL,  656408320UL,  153026304UL,    3012352UL,    3865344UL,
4278481408UL, 4278222336UL, 4278233856UL, 3892707072UL, 2215182080UL,  973930240UL,
 403700480UL,    1106176UL,    2346496UL, 4278217984UL, 4278220032UL, 4278228992UL,
4144027904UL, 2600525056UL, 1543564288UL,  671150080UL,  134278144UL,    1032960UL,
4278218496UL, 4278221824UL, 4278227200UL, 3959468800UL, 2751510016UL, 1996537088UL,
1107352832UL,  503374848UL,      58368UL, 4291364662UL, 1845428294UL,  150929488UL,
  16717104UL,   16605464UL,   16756486UL,   16774656UL,   12975872UL,   10223360UL,
4287437850UL, 4293789518UL,  553586254UL,   33501734UL,   16739844UL,   16761856UL,
  15924992UL,   12844800UL,   10157824UL, 4283576576UL, 4251463964UL, 2830980654UL,
 820802084UL,  184527360UL,   16776960UL,   12779264UL,   10223360UL,    9240320UL,
4280889344UL, 4281876992UL, 4284576524UL, 2324339712UL,  864667136UL,  108199680UL,
   7339264UL,    7077632UL,    7143168UL, 4279648512UL, 4279782656UL, 4247287040UL,
2957291776UL, 1363851520UL,  440777984UL,    4711424UL,    5896960UL,    6094592UL,
4278996992UL, 4278933248UL, 4279268864UL, 3458382080UL, 1864676864UL,  791131904UL,
 153467392UL,    3259648UL,    4052224UL, 4278408960UL, 4278212864UL, 4278221056UL,
3893081600UL, 2249111296UL, 1057993728UL,  403812352UL,    1223168UL,    2403072UL,
4278213632UL, 4278216960UL, 4278222592UL, 3825248000UL, 2449517056UL, 1459662336UL,
 654355968UL,   83928064UL,    1023488UL, 4278216192UL, 4278217984UL, 4278223104UL,
3523252992UL, 2600507392UL, 1845533440UL, 1057006592UL,  503358720UL,      41216UL,
4290644754UL, 3221159980UL,  905904176UL,   16712244UL,   16584982UL,   16731654UL,
  16744960UL,   16631808UL,   16514816UL, 4287894786UL, 4258923556UL, 1325335340UL,
 134023468UL,   16721664UL,   16735232UL,   16747264UL,   16764416UL,   15793920UL,
4284029696UL, 4286520328UL, 3976146960UL, 1174352154UL,  352274944UL,   16742912UL,
  16755456UL,   16507904UL,   13299712UL, 4281671424UL, 4282459904UL, 4286072320UL,
2610913280UL,  933718016UL,   10648320UL,   11446272UL,   11255552UL,   10407424UL,
4279835904UL, 4280101120UL, 4281418240UL, 3075696896UL, 1566403328UL,  508855296UL,
   5348864UL,    6338816UL,    6733568UL, 4279053568UL, 4279055104UL, 4279519488UL,
3274142208UL, 1965914624UL,  841974016UL,  153847552UL,    3644160UL,    4369664UL,
4278467328UL, 4278337024UL, 4278539264UL, 3574364160UL, 2249424384UL, 1108706048UL,
 420840960UL,    1410816UL,    2592768UL, 4244652800UL, 4244656128UL, 4278214656UL,
3640686336UL, 2415950592UL, 1392540928UL,  671121664UL,   67140096UL,    1016064UL,
4278212096UL, 4278213632UL, 4278216960UL, 3271585536UL, 2516612352UL, 1761637632UL,
1056996096UL,  536903936UL,      30720UL, 4289858560UL, 3841916954UL, 1610547224UL,
 436011032UL,   16712726UL,   16583942UL,   16727040UL,   16738816UL,   16751872UL,
4287892736UL, 4258334214UL, 1862205460UL,  587007244UL,   66915842UL,   16719616UL,
  16730624UL,   16742400UL,   16621568UL, 4284419840UL, 4286648064UL, 4294186498UL,
1727994624UL,  503258880UL,   16591616UL,   16736000UL,   16747776UL,   15970560UL,
4282126848UL, 4282717184UL, 4285997312UL, 2628005888UL, 1101869568UL,  212940544UL,
  12346112UL,   12554240UL,   11838464UL, 4280161792UL, 4280555776UL, 4282656768UL,
2975807744UL, 1667644160UL,  560676352UL,    7427072UL,    8683008UL,    8623360UL,
4279243776UL, 4279310592UL, 4279969024UL, 3526310912UL, 2050178816UL,  960052480UL,
 204690432UL,    3763968UL,    4753664UL, 4278656000UL, 4278590976UL, 4278790400UL,
3641786880UL, 2199208960UL, 1159286016UL,  421090304UL,    1726720UL,    2780160UL,
4278200064UL, 4278202368UL, 4278205952UL, 3523235072UL, 2298497536UL, 1459967488UL,
 704927488UL,  100684544UL,    1137664UL, 4278206208UL, 4244654080UL, 4026552576UL,
3103805696UL, 2466272256UL, 1711298304UL, 1006655744UL,  520117248UL,      22272UL,
4289136640UL, 4293591052UL, 2399076362UL,  973013004UL,  268369930UL,   16712710UL,
  16713984UL,   16723200UL,   16734464UL, 4287760128UL, 4290708224UL, 2835283968UL,
1090322432UL,  234815488UL,   16714240UL,   16717824UL,   16726272UL,   16737792UL,
4285073408UL, 4286645504UL, 4292411392UL, 1979647232UL,  687802368UL,   16714752UL,
  16589824UL,   16729856UL,   16741888UL, 4282648832UL, 4283238400UL, 4286122752UL,
2678526464UL, 1219367680UL,  364254720UL,   12789760UL,   13782272UL,   13268736UL,
4280552704UL, 4280814592UL, 4282716928UL, 2925730560UL, 1701584128UL,  712252928UL,
   7808000UL,    9389824UL,   10055168UL, 4279504640UL, 4279636224UL, 4280489984UL,
3056935168UL, 2000232960UL,  993797120UL,  222177280UL,    4930048UL,    6117632UL,
4278848768UL, 4278784000UL, 4279113472UL, 3709346816UL, 2216371712UL, 1193093120UL,
 555820032UL,    2110464UL,    2901248UL, 4278326016UL, 4278195200UL, 4278197504UL,
3640666112UL, 2248157440UL, 1392782592UL,  738800384UL,  117912576UL,    1194240UL,
4278198528UL, 4278200576UL, 4026544896UL, 2952803328UL, 2365601280UL, 1660958208UL,
 973092864UL,  486553600UL,      13824UL, 4288742656UL, 4292608000UL, 3254714368UL,
1526661120UL,  603783168UL,  201261056UL,   16711936UL,   16713216UL,   16720128UL,
4287628032UL, 4289986560UL, 3640590336UL, 1828651008UL,  721354752UL,  201261056UL,
  16713216UL,   16715776UL,   16722176UL, 4285923840UL, 4287168512UL, 4292018176UL,
2533294080UL, 1140785152UL,  301793280UL,   16582912UL,   16717568UL,   16724736UL,
4282974976UL, 4283367424UL, 4286513152UL, 2812608512UL, 1521483776UL,  481361920UL,
  12322560UL,   14228992UL,   14236160UL, 4280812544UL, 4247454208UL, 4282909440UL,
2909340416UL, 1718551808UL,  796395008UL,  108922624UL,    9379328UL,   10566400UL,
4279633664UL, 4246276096UL, 4280813824UL, 3006794496UL, 1916537856UL, 1010699264UL,
 323226880UL,    5315328UL,    6632960UL, 4278979072UL, 4279044608UL, 4279438592UL,
3021737728UL, 2065764096UL, 1143214080UL,  539431168UL,    2692608UL,    3353344UL,
4278453760UL, 4278323200UL, 4278389504UL, 3641119232UL, 2450002432UL, 1409946624UL,
 722146560UL,  252645120UL,    1385216UL, 4278193408UL, 4278194944UL, 4076870144UL,
3003128576UL, 2298486272UL, 1593843456UL,  905977344UL,  436216064UL,       8448UL,
4292214784UL, 4292804608UL, 3707699200UL, 2097086464UL, 1090453504UL,  503119872UL,
 218038272UL,   67043328UL,   16711680UL, 4287627264UL, 4255580160UL, 4076797952UL,
2399076352UL, 1358888960UL,  603914240UL,  251592704UL,   16711680UL,   16711680UL,
4286316544UL, 4286578688UL, 4291493888UL, 3019833344UL, 1845428224UL,  788463616UL,
 285016064UL,   16711680UL,   16711680UL, 4283367424UL, 4284678144UL, 4287102976UL,
3064594432UL, 2058747904UL,  985268224UL,  364838912UL,   13762560UL,   15466496UL,
4281401344UL, 4282449920UL, 4284088320UL, 3010723840UL, 2004353024UL, 1065418752UL,
 411303936UL,    9437184UL,   10747904UL, 4279762944UL, 4280221696UL, 4281466880UL,
2872836096UL, 2000945152UL, 1095237632UL,  525205504UL,    5505024UL,    6881280UL,
4278845440UL, 4279238656UL, 4279762944UL, 2871066624UL, 2015625216UL, 1143406592UL,
 589889536UL,   86835200UL,    3735552UL, 4278190080UL, 4278190080UL, 4278386688UL,
3053912064UL, 2097807360UL, 1208811520UL,  688848896UL,  185729024UL,    1835008UL,
4278190080UL, 4278190080UL, 4278190080UL, 3154116608UL, 2365587456UL, 1610612736UL,
 905969664UL,  452984832UL,          0UL,
};


