package dns

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator 0.17.0.0
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.

import (
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/to"
	"net/http"
)

// HtpStatusCode enumerates the values for htp status code.
type HtpStatusCode string

const (
	// Accepted specifies the accepted state for htp status code.
	Accepted HtpStatusCode = "Accepted"
	// Ambiguous specifies the ambiguous state for htp status code.
	Ambiguous HtpStatusCode = "Ambiguous"
	// BadGateway specifies the bad gateway state for htp status code.
	BadGateway HtpStatusCode = "BadGateway"
	// BadRequest specifies the bad request state for htp status code.
	BadRequest HtpStatusCode = "BadRequest"
	// Conflict specifies the conflict state for htp status code.
	Conflict HtpStatusCode = "Conflict"
	// Continue specifies the continue state for htp status code.
	Continue HtpStatusCode = "Continue"
	// Created specifies the created state for htp status code.
	Created HtpStatusCode = "Created"
	// ExpectationFailed specifies the expectation failed state for htp status
	// code.
	ExpectationFailed HtpStatusCode = "ExpectationFailed"
	// Forbidden specifies the forbidden state for htp status code.
	Forbidden HtpStatusCode = "Forbidden"
	// Found specifies the found state for htp status code.
	Found HtpStatusCode = "Found"
	// GatewayTimeout specifies the gateway timeout state for htp status code.
	GatewayTimeout HtpStatusCode = "GatewayTimeout"
	// Gone specifies the gone state for htp status code.
	Gone HtpStatusCode = "Gone"
	// HTTPVersionNotSupported specifies the http version not supported state
	// for htp status code.
	HTTPVersionNotSupported HtpStatusCode = "HttpVersionNotSupported"
	// InternalServerError specifies the internal server error state for htp
	// status code.
	InternalServerError HtpStatusCode = "InternalServerError"
	// LengthRequired specifies the length required state for htp status code.
	LengthRequired HtpStatusCode = "LengthRequired"
	// MethodNotAllowed specifies the method not allowed state for htp status
	// code.
	MethodNotAllowed HtpStatusCode = "MethodNotAllowed"
	// Moved specifies the moved state for htp status code.
	Moved HtpStatusCode = "Moved"
	// MovedPermanently specifies the moved permanently state for htp status
	// code.
	MovedPermanently HtpStatusCode = "MovedPermanently"
	// MultipleChoices specifies the multiple choices state for htp status
	// code.
	MultipleChoices HtpStatusCode = "MultipleChoices"
	// NoContent specifies the no content state for htp status code.
	NoContent HtpStatusCode = "NoContent"
	// NonAuthoritativeInformation specifies the non authoritative information
	// state for htp status code.
	NonAuthoritativeInformation HtpStatusCode = "NonAuthoritativeInformation"
	// NotAcceptable specifies the not acceptable state for htp status code.
	NotAcceptable HtpStatusCode = "NotAcceptable"
	// NotFound specifies the not found state for htp status code.
	NotFound HtpStatusCode = "NotFound"
	// NotImplemented specifies the not implemented state for htp status code.
	NotImplemented HtpStatusCode = "NotImplemented"
	// NotModified specifies the not modified state for htp status code.
	NotModified HtpStatusCode = "NotModified"
	// OK specifies the ok state for htp status code.
	OK HtpStatusCode = "OK"
	// PartialContent specifies the partial content state for htp status code.
	PartialContent HtpStatusCode = "PartialContent"
	// PaymentRequired specifies the payment required state for htp status
	// code.
	PaymentRequired HtpStatusCode = "PaymentRequired"
	// PreconditionFailed specifies the precondition failed state for htp
	// status code.
	PreconditionFailed HtpStatusCode = "PreconditionFailed"
	// ProxyAuthenticationRequired specifies the proxy authentication required
	// state for htp status code.
	ProxyAuthenticationRequired HtpStatusCode = "ProxyAuthenticationRequired"
	// Redirect specifies the redirect state for htp status code.
	Redirect HtpStatusCode = "Redirect"
	// RedirectKeepVerb specifies the redirect keep verb state for htp status
	// code.
	RedirectKeepVerb HtpStatusCode = "RedirectKeepVerb"
	// RedirectMethod specifies the redirect method state for htp status code.
	RedirectMethod HtpStatusCode = "RedirectMethod"
	// RequestedRangeNotSatisfiable specifies the requested range not
	// satisfiable state for htp status code.
	RequestedRangeNotSatisfiable HtpStatusCode = "RequestedRangeNotSatisfiable"
	// RequestEntityTooLarge specifies the request entity too large state for
	// htp status code.
	RequestEntityTooLarge HtpStatusCode = "RequestEntityTooLarge"
	// RequestTimeout specifies the request timeout state for htp status code.
	RequestTimeout HtpStatusCode = "RequestTimeout"
	// RequestURITooLong specifies the request uri too long state for htp
	// status code.
	RequestURITooLong HtpStatusCode = "RequestUriTooLong"
	// ResetContent specifies the reset content state for htp status code.
	ResetContent HtpStatusCode = "ResetContent"
	// SeeOther specifies the see other state for htp status code.
	SeeOther HtpStatusCode = "SeeOther"
	// ServiceUnavailable specifies the service unavailable state for htp
	// status code.
	ServiceUnavailable HtpStatusCode = "ServiceUnavailable"
	// SwitchingProtocols specifies the switching protocols state for htp
	// status code.
	SwitchingProtocols HtpStatusCode = "SwitchingProtocols"
	// TemporaryRedirect specifies the temporary redirect state for htp status
	// code.
	TemporaryRedirect HtpStatusCode = "TemporaryRedirect"
	// Unauthorized specifies the unauthorized state for htp status code.
	Unauthorized HtpStatusCode = "Unauthorized"
	// UnsupportedMediaType specifies the unsupported media type state for htp
	// status code.
	UnsupportedMediaType HtpStatusCode = "UnsupportedMediaType"
	// Unused specifies the unused state for htp status code.
	Unused HtpStatusCode = "Unused"
	// UpgradeRequired specifies the upgrade required state for htp status
	// code.
	UpgradeRequired HtpStatusCode = "UpgradeRequired"
	// UseProxy specifies the use proxy state for htp status code.
	UseProxy HtpStatusCode = "UseProxy"
)

// OperationStatus enumerates the values for operation status.
type OperationStatus string

const (
	// Failed specifies the failed state for operation status.
	Failed OperationStatus = "Failed"
	// InProgress specifies the in progress state for operation status.
	InProgress OperationStatus = "InProgress"
	// Succeeded specifies the succeeded state for operation status.
	Succeeded OperationStatus = "Succeeded"
)

// RecordType enumerates the values for record type.
type RecordType string

const (
	// A specifies the a state for record type.
	A RecordType = "A"
	// AAAA specifies the aaaa state for record type.
	AAAA RecordType = "AAAA"
	// CNAME specifies the cname state for record type.
	CNAME RecordType = "CNAME"
	// MX specifies the mx state for record type.
	MX RecordType = "MX"
	// NS specifies the ns state for record type.
	NS RecordType = "NS"
	// PTR specifies the ptr state for record type.
	PTR RecordType = "PTR"
	// SOA specifies the soa state for record type.
	SOA RecordType = "SOA"
	// SRV specifies the srv state for record type.
	SRV RecordType = "SRV"
	// TXT specifies the txt state for record type.
	TXT RecordType = "TXT"
)

// AaaaRecord is an AAAA record.
type AaaaRecord struct {
	Ipv6Address *string `json:"ipv6Address,omitempty"`
}

// ARecord is an A record.
type ARecord struct {
	Ipv4Address *string `json:"ipv4Address,omitempty"`
}

// CloudError is
type CloudError struct {
	Error *CloudErrorBody `json:"error,omitempty"`
}

// CloudErrorBody is
type CloudErrorBody struct {
	Code    *string           `json:"code,omitempty"`
	Message *string           `json:"message,omitempty"`
	Target  *string           `json:"target,omitempty"`
	Details *[]CloudErrorBody `json:"details,omitempty"`
}

// CnameRecord is a CNAME record.
type CnameRecord struct {
	Cname *string `json:"cname,omitempty"`
}

// MxRecord is an MX record.
type MxRecord struct {
	Preference *int32  `json:"preference,omitempty"`
	Exchange   *string `json:"exchange,omitempty"`
}

// NsRecord is an NS record.
type NsRecord struct {
	Nsdname *string `json:"nsdname,omitempty"`
}

// PtrRecord is a PTR record.
type PtrRecord struct {
	Ptrdname *string `json:"ptrdname,omitempty"`
}

// RecordSet is describes a DNS RecordSet (a set of DNS records with the same
// name and type).
type RecordSet struct {
	autorest.Response `json:"-"`
	ID                *string              `json:"id,omitempty"`
	Name              *string              `json:"name,omitempty"`
	Type              *string              `json:"type,omitempty"`
	Etag              *string              `json:"etag,omitempty"`
	Properties        *RecordSetProperties `json:"properties,omitempty"`
}

// RecordSetListResult is the response to a RecordSet List operation.
type RecordSetListResult struct {
	autorest.Response `json:"-"`
	Value             *[]RecordSet `json:"value,omitempty"`
	NextLink          *string      `json:"nextLink,omitempty"`
}

// RecordSetListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client RecordSetListResult) RecordSetListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// RecordSetProperties is represents the properties of the records in the
// RecordSet.
type RecordSetProperties struct {
	Metadata    *map[string]*string `json:"metadata,omitempty"`
	TTL         *int64              `json:"TTL,omitempty"`
	ARecords    *[]ARecord          `json:"ARecords,omitempty"`
	AAAARecords *[]AaaaRecord       `json:"AAAARecords,omitempty"`
	MXRecords   *[]MxRecord         `json:"MXRecords,omitempty"`
	NSRecords   *[]NsRecord         `json:"NSRecords,omitempty"`
	PTRRecords  *[]PtrRecord        `json:"PTRRecords,omitempty"`
	SRVRecords  *[]SrvRecord        `json:"SRVRecords,omitempty"`
	TXTRecords  *[]TxtRecord        `json:"TXTRecords,omitempty"`
	CNAMERecord *CnameRecord        `json:"CNAMERecord,omitempty"`
	SOARecord   *SoaRecord          `json:"SOARecord,omitempty"`
}

// RecordSetUpdateParameters is parameters supplied to update a RecordSet.
type RecordSetUpdateParameters struct {
	RecordSet *RecordSet `json:"RecordSet,omitempty"`
}

// Resource is
type Resource struct {
	ID       *string             `json:"id,omitempty"`
	Name     *string             `json:"name,omitempty"`
	Type     *string             `json:"type,omitempty"`
	Location *string             `json:"location,omitempty"`
	Tags     *map[string]*string `json:"tags,omitempty"`
}

// SoaRecord is an SOA record.
type SoaRecord struct {
	Host         *string `json:"host,omitempty"`
	Email        *string `json:"email,omitempty"`
	SerialNumber *int64  `json:"serialNumber,omitempty"`
	RefreshTime  *int64  `json:"refreshTime,omitempty"`
	RetryTime    *int64  `json:"retryTime,omitempty"`
	ExpireTime   *int64  `json:"expireTime,omitempty"`
	MinimumTTL   *int64  `json:"minimumTTL,omitempty"`
}

// SrvRecord is an SRV record.
type SrvRecord struct {
	Priority *int32  `json:"priority,omitempty"`
	Weight   *int32  `json:"weight,omitempty"`
	Port     *int32  `json:"port,omitempty"`
	Target   *string `json:"target,omitempty"`
}

// SubResource is
type SubResource struct {
	ID *string `json:"id,omitempty"`
}

// TxtRecord is a TXT record.
type TxtRecord struct {
	Value *[]string `json:"value,omitempty"`
}

// Zone is describes a DNS zone.
type Zone struct {
	autorest.Response `json:"-"`
	ID                *string             `json:"id,omitempty"`
	Name              *string             `json:"name,omitempty"`
	Type              *string             `json:"type,omitempty"`
	Location          *string             `json:"location,omitempty"`
	Tags              *map[string]*string `json:"tags,omitempty"`
	Etag              *string             `json:"etag,omitempty"`
	Properties        *ZoneProperties     `json:"properties,omitempty"`
}

// ZoneDeleteResult is the response to a Zone Delete operation.
type ZoneDeleteResult struct {
	autorest.Response   `json:"-"`
	AzureAsyncOperation *string         `json:"azureAsyncOperation,omitempty"`
	Status              OperationStatus `json:"status,omitempty"`
	StatusCode          HtpStatusCode   `json:"statusCode,omitempty"`
	RequestID           *string         `json:"requestId,omitempty"`
}

// ZoneListResult is the response to a Zone List or ListAll operation.
type ZoneListResult struct {
	autorest.Response `json:"-"`
	Value             *[]Zone `json:"value,omitempty"`
	NextLink          *string `json:"nextLink,omitempty"`
}

// ZoneListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client ZoneListResult) ZoneListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// ZoneProperties is represents the properties of the zone.
type ZoneProperties struct {
	MaxNumberOfRecordSets *int64    `json:"maxNumberOfRecordSets,omitempty"`
	NumberOfRecordSets    *int64    `json:"numberOfRecordSets,omitempty"`
	NameServers           *[]string `json:"nameServers,omitempty"`
}
