; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=i686-unknown -mattr=+sse2 | FileCheck %s --check-prefix=X86
; RUN: llc < %s -mtriple=x86_64-unknown -mattr=+avx | FileCheck %s --check-prefix=X64

; These tests just check that the plumbing is in place for @llvm.bswap. The
; actual output is massive at the moment as llvm.bswap is not yet legal.

declare i32 @llvm.bswap.i32(i32) readnone
declare i32 @llvm.bswap.v4i32(i32) readnone

; fold (bswap undef) -> undef
define i32 @test_undef() nounwind {
; X86-LABEL: test_undef:
; X86:       # %bb.0:
; X86-NEXT:    retl
;
; X64-LABEL: test_undef:
; X64:       # %bb.0:
; X64-NEXT:    retq
  %b = call i32 @llvm.bswap.i32(i32 undef)
  ret i32 %b
}

; fold (bswap (bswap x)) -> x
define i32 @test_bswap_bswap(i32 %a0) nounwind {
; X86-LABEL: test_bswap_bswap:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    retl
;
; X64-LABEL: test_bswap_bswap:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    retq
  %b = call i32 @llvm.bswap.i32(i32 %a0)
  %c = call i32 @llvm.bswap.i32(i32 %b)
  ret i32 %c
}

define i32 @test_demandedbits_bswap(i32 %a0) nounwind {
; X86-LABEL: test_demandedbits_bswap:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    bswapl %eax
; X86-NEXT:    andl $-65536, %eax # imm = 0xFFFF0000
; X86-NEXT:    retl
;
; X64-LABEL: test_demandedbits_bswap:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    bswapl %eax
; X64-NEXT:    andl $-65536, %eax # imm = 0xFFFF0000
; X64-NEXT:    retq
  %b = or i32 %a0, 4278190080
  %c = call i32 @llvm.bswap.i32(i32 %b)
  %d = and i32 %c, 4294901760
  ret i32 %d
}

define void @demand_one_loaded_byte(i64* %xp, i32* %yp) {
; X86-LABEL: demand_one_loaded_byte:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movb 4(%ecx), %cl
; X86-NEXT:    movb %cl, (%eax)
; X86-NEXT:    retl
;
; X64-LABEL: demand_one_loaded_byte:
; X64:       # %bb.0:
; X64-NEXT:    movb 4(%rdi), %al
; X64-NEXT:    movb %al, (%rsi)
; X64-NEXT:    retq
  %x = load i64, i64* %xp, align 8
  %x_zzzz7654 = lshr i64 %x, 32
  %x_z7654zzz = shl nuw nsw i64 %x_zzzz7654, 24
  %x_4zzz = trunc i64 %x_z7654zzz to i32
  %y = load i32, i32* %yp, align 4
  %y_321z = and i32 %y, -256
  %x_zzz4 = call i32 @llvm.bswap.i32(i32 %x_4zzz)
  %r = or i32 %x_zzz4, %y_321z
  store i32 %r, i32* %yp, align 4
  ret void
}
