# RUN: llvm-mc  %s -triple=mipsel-unknown-linux -mcpu=mips32r2 -show-encoding | FileCheck %s


  .text
text_label:

  add $4, -0x80000000
# CHECK: lui    $1, 32768               # encoding: [0x00,0x80,0x01,0x3c]
# CHECK: add    $4, $4, $1              # encoding: [0x20,0x20,0x81,0x00]
  add $4, -0x8001
# CHECK: lui    $1, 65535               # encoding: [0xff,0xff,0x01,0x3c]
# CHECK: ori    $1, $1, 32767           # encoding: [0xff,0x7f,0x21,0x34]
# CHECK: add    $4, $4, $1              # encoding: [0x20,0x20,0x81,0x00]
  add $4, -0x8000
# CHECK: addi   $4, $4, -32768          # encoding: [0x00,0x80,0x84,0x20]
  add $4, 0
# CHECK: addi   $4, $4, 0               # encoding: [0x00,0x00,0x84,0x20]
  add $4, 0xFFFF
# CHECK: ori    $1, $zero, 65535        # encoding: [0xff,0xff,0x01,0x34]
# CHECK: add    $4, $4, $1              # encoding: [0x20,0x20,0x81,0x00]
  add $4, 0x10000
# CHECK: lui    $1, 1                   # encoding: [0x01,0x00,0x01,0x3c]
# CHECK: add    $4, $4, $1              # encoding: [0x20,0x20,0x81,0x00]
  add $4, 0xFFFFFFFF
# CHECK: addi   $4, $4, -1              # encoding: [0xff,0xff,0x84,0x20]

  add $4, $5, -0x80000000
# CHECK: lui    $4, 32768               # encoding: [0x00,0x80,0x04,0x3c]
# CHECK: add    $4, $4, $5              # encoding: [0x20,0x20,0x85,0x00]
  add $4, $5, -0x8001
# CHECK: lui    $4, 65535               # encoding: [0xff,0xff,0x04,0x3c]
# CHECK: ori    $4, $4, 32767           # encoding: [0xff,0x7f,0x84,0x34]
# CHECK: add    $4, $4, $5              # encoding: [0x20,0x20,0x85,0x00]
  add $4, $5, -0x8000
# CHECK: addi   $4, $5, -32768          # encoding: [0x00,0x80,0xa4,0x20]
  add $4, $5, 0
# CHECK: addi   $4, $5, 0               # encoding: [0x00,0x00,0xa4,0x20]
  add $4, $5, 0xFFFF
# CHECK: ori    $4, $zero, 65535        # encoding: [0xff,0xff,0x04,0x34]
# CHECK: add    $4, $4, $5              # encoding: [0x20,0x20,0x85,0x00]
  add $4, $5, 0x10000
# CHECK: lui    $4, 1                   # encoding: [0x01,0x00,0x04,0x3c]
# CHECK: add    $4, $4, $5              # encoding: [0x20,0x20,0x85,0x00]
  add $4, $5, 0xFFFFFFFF
# CHECK: addi   $4, $5, -1              # encoding: [0xff,0xff,0xa4,0x20]

  addu $4, -0x80000000
# CHECK: lui    $1, 32768               # encoding: [0x00,0x80,0x01,0x3c]
# CHECK: addu   $4, $4, $1              # encoding: [0x21,0x20,0x81,0x00]
  addu $4, -0x8001
# CHECK: lui    $1, 65535               # encoding: [0xff,0xff,0x01,0x3c]
# CHECK: ori    $1, $1, 32767           # encoding: [0xff,0x7f,0x21,0x34]
# CHECK: addu   $4, $4, $1              # encoding: [0x21,0x20,0x81,0x00]
  addu $4, -0x8000
# CHECK: addiu  $4, $4, -32768          # encoding: [0x00,0x80,0x84,0x24]
  addu $4, 0
# CHECK: addiu  $4, $4, 0               # encoding: [0x00,0x00,0x84,0x24]
  addu $4, 0xFFFF
# CHECK: ori    $1, $zero, 65535        # encoding: [0xff,0xff,0x01,0x34]
# CHECK: addu   $4, $4, $1              # encoding: [0x21,0x20,0x81,0x00]
  addu $4, 0x10000
# CHECK: lui    $1, 1                   # encoding: [0x01,0x00,0x01,0x3c]
# CHECK: addu   $4, $4, $1              # encoding: [0x21,0x20,0x81,0x00]
  addu $4, 0xFFFFFFFF
# CHECK: addiu  $4, $4, -1              # encoding: [0xff,0xff,0x84,0x24]

  addu $4, $5, -0x80000000
# CHECK: lui    $4, 32768               # encoding: [0x00,0x80,0x04,0x3c]
# CHECK: addu   $4, $4, $5              # encoding: [0x21,0x20,0x85,0x00]
  addu $4, $5, -0x8001
# CHECK: lui    $4, 65535               # encoding: [0xff,0xff,0x04,0x3c]
# CHECK: ori    $4, $4, 32767           # encoding: [0xff,0x7f,0x84,0x34]
# CHECK: addu   $4, $4, $5              # encoding: [0x21,0x20,0x85,0x00]
  addu $4, $5, -0x8000
# CHECK: addiu  $4, $5, -32768          # encoding: [0x00,0x80,0xa4,0x24]
  addu $4, $5, 0
# CHECK: addiu  $4, $5, 0               # encoding: [0x00,0x00,0xa4,0x24]
  addu $4, $5, 0xFFFF
# CHECK: ori    $4, $zero, 65535        # encoding: [0xff,0xff,0x04,0x34]
# CHECK: addu   $4, $4, $5              # encoding: [0x21,0x20,0x85,0x00]
  addu $4, $5, 0x10000
# CHECK: lui    $4, 1                   # encoding: [0x01,0x00,0x04,0x3c]
# CHECK: addu   $4, $4, $5              # encoding: [0x21,0x20,0x85,0x00]
  addu $4, $5, 0xFFFFFFFF
# CHECK: addiu  $4, $5, -1              # encoding: [0xff,0xff,0xa4,0x24]

  and $4, -0x80000000
# CHECK: lui    $1, 32768               # encoding: [0x00,0x80,0x01,0x3c]
# CHECK: and    $4, $4, $1              # encoding: [0x24,0x20,0x81,0x00]
  and $4, -0x8001
# CHECK: lui    $1, 65535               # encoding: [0xff,0xff,0x01,0x3c]
# CHECK: ori    $1, $1, 32767           # encoding: [0xff,0x7f,0x21,0x34]
# CHECK: and    $4, $4, $1              # encoding: [0x24,0x20,0x81,0x00]
  and $4, -0x8000
# CHECK: addiu  $1, $zero, -32768       # encoding: [0x00,0x80,0x01,0x24]
  and $4, 0
# CHECK: andi   $4, $4, 0               # encoding: [0x00,0x00,0x84,0x30]
  and $4, 0xFFFF
# CHECK: andi   $4, $4, 65535           # encoding: [0xff,0xff,0x84,0x30]
  and $4, 0x10000
# CHECK: lui    $1, 1                   # encoding: [0x01,0x00,0x01,0x3c]
# CHECK: and    $4, $4, $1              # encoding: [0x24,0x20,0x81,0x00]
  and $4, 0xFFFFFFFF
# CHECK: addiu  $1, $zero, -1           # encoding: [0xff,0xff,0x01,0x24]
# CHECK: and    $4, $4, $1              # encoding: [0x24,0x20,0x81,0x00]

  and $4, $5, -0x80000000
# CHECK: lui    $4, 32768               # encoding: [0x00,0x80,0x04,0x3c]
# CHECK: and    $4, $4, $5              # encoding: [0x24,0x20,0x85,0x00]
  and $4, $5, -0x8001
# CHECK: lui    $4, 65535               # encoding: [0xff,0xff,0x04,0x3c]
# CHECK: ori    $4, $4, 32767           # encoding: [0xff,0x7f,0x84,0x34]
# CHECK: and    $4, $4, $5              # encoding: [0x24,0x20,0x85,0x00]
  and $4, $5, -0x8000
# CHECK: addiu  $4, $zero, -32768       # encoding: [0x00,0x80,0x04,0x24]
# CHECK: and    $4, $4, $5              # encoding: [0x24,0x20,0x85,0x00]
  and $4, $5, 0
# CHECK: andi   $4, $5, 0               # encoding: [0x00,0x00,0xa4,0x30]
  and $4, $5, 0xFFFF
# CHECK: andi   $4, $5, 65535           # encoding: [0xff,0xff,0xa4,0x30]
  and $4, $5, 0x10000
# CHECK: lui    $4, 1                   # encoding: [0x01,0x00,0x04,0x3c]
# CHECK: and    $4, $4, $5              # encoding: [0x24,0x20,0x85,0x00]
  and $4, $5, 0xFFFFFFFF
# CHECK: addiu  $4, $zero, -1           # encoding: [0xff,0xff,0x04,0x24]
# CHECK: and    $4, $4, $5              # encoding: [0x24,0x20,0x85,0x00]

  nor $4, $5, 0
# CHECK: addiu  $4, $zero, 0            # encoding: [0x00,0x00,0x04,0x24]
# CHECK: nor    $4, $4, $5              # encoding: [0x27,0x20,0x85,0x00]
  nor $4, $5, 1
# CHECK: addiu  $4, $zero, 1            # encoding: [0x01,0x00,0x04,0x24]
# CHECK: nor    $4, $4, $5              # encoding: [0x27,0x20,0x85,0x00]
  nor $4, $5, 0x8000
# CHECK: ori    $4, $zero, 32768        # encoding: [0x00,0x80,0x04,0x34]
# CHECK: nor    $4, $4, $5              # encoding: [0x27,0x20,0x85,0x00]
  nor $4, $5, -0x8000
# CHECK: addiu  $4, $zero, -32768       # encoding: [0x00,0x80,0x04,0x24]
# CHECK: nor    $4, $4, $5              # encoding: [0x27,0x20,0x85,0x00]
  nor $4, $5, 0x10000
# CHECK: lui    $4, 1                   # encoding: [0x01,0x00,0x04,0x3c]
# CHECK: nor    $4, $4, $5              # encoding: [0x27,0x20,0x85,0x00]
  nor $4, $5, 0x1a5a5
# CHECK: lui    $4, 1                   # encoding: [0x01,0x00,0x04,0x3c]
# CHECK: ori    $4, $4, 42405           # encoding: [0xa5,0xa5,0x84,0x34]
# CHECK: nor    $4, $4, $5              # encoding: [0x27,0x20,0x85,0x00]

  or $4, -0x80000000
# CHECK: lui    $1, 32768               # encoding: [0x00,0x80,0x01,0x3c]
# CHECK: or     $4, $4, $1              # encoding: [0x25,0x20,0x81,0x00]
  or $4, -0x8001
# CHECK: lui    $1, 65535               # encoding: [0xff,0xff,0x01,0x3c]
# CHECK: ori    $1, $1, 32767           # encoding: [0xff,0x7f,0x21,0x34]
# CHECK: or     $4, $4, $1              # encoding: [0x25,0x20,0x81,0x00]
  or $4, -0x8000
# CHECK: addiu  $1, $zero, -32768       # encoding: [0x00,0x80,0x01,0x24]
# CHECK: or     $4, $4, $1              # encoding: [0x25,0x20,0x81,0x00]
  or $4, 0
# CHECK: ori    $4, $4, 0               # encoding: [0x00,0x00,0x84,0x34]
  or $4, 0xFFFF
# CHECK: ori    $4, $4, 65535           # encoding: [0xff,0xff,0x84,0x34]
  or $4, 0x10000
# CHECK: lui    $1, 1                   # encoding: [0x01,0x00,0x01,0x3c]
# CHECK: or     $4, $4, $1              # encoding: [0x25,0x20,0x81,0x00]
  or $4, 0xFFFFFFFF
# CHECK: addiu  $1, $zero, -1           # encoding: [0xff,0xff,0x01,0x24]
# CHECK: or     $4, $4, $1              # encoding: [0x25,0x20,0x81,0x00]

  or $4, $5, -0x80000000
# CHECK: lui    $4, 32768               # encoding: [0x00,0x80,0x04,0x3c]
# CHECK: or     $4, $4, $5              # encoding: [0x25,0x20,0x85,0x00]
  or $4, $5, -0x8001
# CHECK: lui    $4, 65535               # encoding: [0xff,0xff,0x04,0x3c]
# CHECK: ori    $4, $4, 32767           # encoding: [0xff,0x7f,0x84,0x34]
# CHECK: or     $4, $4, $5              # encoding: [0x25,0x20,0x85,0x00]
  or $4, $5, -0x8000
# CHECK: addiu  $4, $zero, -32768       # encoding: [0x00,0x80,0x04,0x24]
# CHECK: or     $4, $4, $5              # encoding: [0x25,0x20,0x85,0x00]
  or $4, $5, 0
# CHECK: ori    $4, $5, 0               # encoding: [0x00,0x00,0xa4,0x34]
  or $4, $5, 0xFFFF
# CHECK: ori    $4, $5, 65535           # encoding: [0xff,0xff,0xa4,0x34]
  or $4, $5, 0x10000
# CHECK: lui    $4, 1                   # encoding: [0x01,0x00,0x04,0x3c]
# CHECK: or     $4, $4, $5              # encoding: [0x25,0x20,0x85,0x00]
  or $4, $5, 0xFFFFFFFF
# CHECK: addiu  $4, $zero, -1           # encoding: [0xff,0xff,0x04,0x24]
# CHECK: or     $4, $4, $5              # encoding: [0x25,0x20,0x85,0x00]

  slt $4, $5, -0x80000000
# CHECK: lui    $4, 32768               # encoding: [0x00,0x80,0x04,0x3c]
# CHECK: slt    $4, $4, $5              # encoding: [0x2a,0x20,0x85,0x00]
  slt $4, $5, -0x8001
# CHECK: lui    $4, 65535               # encoding: [0xff,0xff,0x04,0x3c]
# CHECK: ori    $4, $4, 32767           # encoding: [0xff,0x7f,0x84,0x34]
# CHECK: slt    $4, $4, $5              # encoding: [0x2a,0x20,0x85,0x00]
  slt $4, $5, -0x8000
# CHECK: slti   $4, $5, -32768          # encoding: [0x00,0x80,0xa4,0x28]
  slt $4, $5, 0
# CHECK: slti   $4, $5, 0               # encoding: [0x00,0x00,0xa4,0x28]
  slt $4, $5, 0xFFFF
# CHECK: ori    $4, $zero, 65535        # encoding: [0xff,0xff,0x04,0x34]
  slt $4, $5, 0x10000
# CHECK: lui    $4, 1                   # encoding: [0x01,0x00,0x04,0x3c]
# CHECK: slt    $4, $4, $5              # encoding: [0x2a,0x20,0x85,0x00]
  slt $4, $5, 0xFFFFFFFF
# CHECK: slti   $4, $5, -1              # encoding: [0xff,0xff,0xa4,0x28]

  sltu $4, $5, -0x80000000
# CHECK: lui    $4, 32768               # encoding: [0x00,0x80,0x04,0x3c]
# CHECK: sltu   $4, $4, $5              # encoding: [0x2b,0x20,0x85,0x00]
  sltu $4, $5, -0x8001
# CHECK: lui    $4, 65535               # encoding: [0xff,0xff,0x04,0x3c]
# CHECK: ori    $4, $4, 32767           # encoding: [0xff,0x7f,0x84,0x34]
# CHECK: sltu   $4, $4, $5              # encoding: [0x2b,0x20,0x85,0x00]
  sltu $4, $5, -0x8000
# CHECK: sltiu  $4, $5, -32768          # encoding: [0x00,0x80,0xa4,0x2c]
  sltu $4, $5, 0
# CHECK: sltiu  $4, $5, 0               # encoding: [0x00,0x00,0xa4,0x2c]
  sltu $4, $5, 0xFFFF
# CHECK: ori    $4, $zero, 65535        # encoding: [0xff,0xff,0x04,0x34]
  sltu $4, $5, 0x10000
# CHECK: lui    $4, 1                   # encoding: [0x01,0x00,0x04,0x3c]
# CHECK: sltu   $4, $4, $5              # encoding: [0x2b,0x20,0x85,0x00]
  sltu $4, $5, 0xFFFFFFFF
# CHECK: sltiu  $4, $5, -1              # encoding: [0xff,0xff,0xa4,0x2c]

  xor $4, -0x80000000
# CHECK: lui    $1, 32768               # encoding: [0x00,0x80,0x01,0x3c]
# CHECK: xor    $4, $4, $1              # encoding: [0x26,0x20,0x81,0x00]
  xor $4, -0x8001
# CHECK: lui    $1, 65535               # encoding: [0xff,0xff,0x01,0x3c]
# CHECK: ori    $1, $1, 32767           # encoding: [0xff,0x7f,0x21,0x34]
# CHECK: xor    $4, $4, $1              # encoding: [0x26,0x20,0x81,0x00]
  xor $4, -0x8000
# CHECK: addiu  $1, $zero, -32768       # encoding: [0x00,0x80,0x01,0x24]
  xor $4, 0
# CHECK: xori   $4, $4, 0               # encoding: [0x00,0x00,0x84,0x38]
  xor $4, 0xFFFF
# CHECK: xori   $4, $4, 65535           # encoding: [0xff,0xff,0x84,0x38]
  xor $4, 0x10000
# CHECK: lui    $1, 1                   # encoding: [0x01,0x00,0x01,0x3c]
# CHECK: xor    $4, $4, $1              # encoding: [0x26,0x20,0x81,0x00]
  xor $4, 0xFFFFFFFF
# CHECK: addiu  $1, $zero, -1           # encoding: [0xff,0xff,0x01,0x24]
# CHECK: xor    $4, $4, $1              # encoding: [0x26,0x20,0x81,0x00]

  xor $4, $5, -0x80000000
# CHECK: lui    $4, 32768               # encoding: [0x00,0x80,0x04,0x3c]
# CHECK: xor    $4, $4, $5              # encoding: [0x26,0x20,0x85,0x00]
  xor $4, $5, -0x8001
# CHECK: lui    $4, 65535               # encoding: [0xff,0xff,0x04,0x3c]
# CHECK: ori    $4, $4, 32767           # encoding: [0xff,0x7f,0x84,0x34]
# CHECK: xor    $4, $4, $5              # encoding: [0x26,0x20,0x85,0x00]
  xor $4, $5, -0x8000
# CHECK: addiu  $4, $zero, -32768       # encoding: [0x00,0x80,0x04,0x24]
# CHECK: xor $4, $4, $5                 # encoding: [0x26,0x20,0x85,0x00]
  xor $4, $5, 0
# CHECK: xori   $4, $5, 0               # encoding: [0x00,0x00,0xa4,0x38]
  xor $4, $5, 0xFFFF
# CHECK: xori   $4, $5, 65535           # encoding: [0xff,0xff,0xa4,0x38]
  xor $4, $5, 0x10000
# CHECK: lui    $4, 1                   # encoding: [0x01,0x00,0x04,0x3c]
# CHECK: xor    $4, $4, $5              # encoding: [0x26,0x20,0x85,0x00]
  xor $4, $5, 0xFFFFFFFF
# CHECK: addiu  $4, $zero, -1           # encoding: [0xff,0xff,0x04,0x24]
# CHECK: xor    $4, $4, $5              # encoding: [0x26,0x20,0x85,0x00]
