; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+fma,-fma4 -show-mc-encoding | FileCheck %s --check-prefix=CHECK --check-prefix=CHECK-FMA
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512vl,-fma4 -show-mc-encoding | FileCheck %s --check-prefix=CHECK --check-prefix=CHECK-AVX512VL
; RUN: llc < %s -mtriple=x86_64-pc-windows -mattr=+fma,-fma4 -show-mc-encoding | FileCheck %s --check-prefix=CHECK --check-prefix=CHECK-FMA-WIN

; NOTE: This should use IR equivalent to what is generated by clang/test/CodeGen/fma-builtins.c

define <4 x float> @test_mm_fmadd_ps(<4 x float> %a, <4 x float> %b, <4 x float> %c) {
; CHECK-FMA-LABEL: test_mm_fmadd_ps:
; CHECK-FMA:       # %bb.0: # %entry
; CHECK-FMA-NEXT:    vfmadd213ps %xmm2, %xmm1, %xmm0 # encoding: [0xc4,0xe2,0x71,0xa8,0xc2]
; CHECK-FMA-NEXT:    # xmm0 = (xmm1 * xmm0) + xmm2
; CHECK-FMA-NEXT:    retq # encoding: [0xc3]
;
; CHECK-AVX512VL-LABEL: test_mm_fmadd_ps:
; CHECK-AVX512VL:       # %bb.0: # %entry
; CHECK-AVX512VL-NEXT:    vfmadd213ps %xmm2, %xmm1, %xmm0 # EVEX TO VEX Compression encoding: [0xc4,0xe2,0x71,0xa8,0xc2]
; CHECK-AVX512VL-NEXT:    # xmm0 = (xmm1 * xmm0) + xmm2
; CHECK-AVX512VL-NEXT:    retq # encoding: [0xc3]
;
; CHECK-FMA-WIN-LABEL: test_mm_fmadd_ps:
; CHECK-FMA-WIN:       # %bb.0: # %entry
; CHECK-FMA-WIN-NEXT:    vmovaps (%rcx), %xmm1 # encoding: [0xc5,0xf8,0x28,0x09]
; CHECK-FMA-WIN-NEXT:    vmovaps (%rdx), %xmm0 # encoding: [0xc5,0xf8,0x28,0x02]
; CHECK-FMA-WIN-NEXT:    vfmadd213ps (%r8), %xmm1, %xmm0 # encoding: [0xc4,0xc2,0x71,0xa8,0x00]
; CHECK-FMA-WIN-NEXT:    # xmm0 = (xmm1 * xmm0) + mem
; CHECK-FMA-WIN-NEXT:    retq # encoding: [0xc3]
entry:
  %0 = tail call <4 x float> @llvm.fma.v4f32(<4 x float> %a, <4 x float> %b, <4 x float> %c) #2
  ret <4 x float> %0
}

define <2 x double> @test_mm_fmadd_pd(<2 x double> %a, <2 x double> %b, <2 x double> %c) {
; CHECK-FMA-LABEL: test_mm_fmadd_pd:
; CHECK-FMA:       # %bb.0: # %entry
; CHECK-FMA-NEXT:    vfmadd213pd %xmm2, %xmm1, %xmm0 # encoding: [0xc4,0xe2,0xf1,0xa8,0xc2]
; CHECK-FMA-NEXT:    # xmm0 = (xmm1 * xmm0) + xmm2
; CHECK-FMA-NEXT:    retq # encoding: [0xc3]
;
; CHECK-AVX512VL-LABEL: test_mm_fmadd_pd:
; CHECK-AVX512VL:       # %bb.0: # %entry
; CHECK-AVX512VL-NEXT:    vfmadd213pd %xmm2, %xmm1, %xmm0 # EVEX TO VEX Compression encoding: [0xc4,0xe2,0xf1,0xa8,0xc2]
; CHECK-AVX512VL-NEXT:    # xmm0 = (xmm1 * xmm0) + xmm2
; CHECK-AVX512VL-NEXT:    retq # encoding: [0xc3]
;
; CHECK-FMA-WIN-LABEL: test_mm_fmadd_pd:
; CHECK-FMA-WIN:       # %bb.0: # %entry
; CHECK-FMA-WIN-NEXT:    vmovapd (%rcx), %xmm1 # encoding: [0xc5,0xf9,0x28,0x09]
; CHECK-FMA-WIN-NEXT:    vmovapd (%rdx), %xmm0 # encoding: [0xc5,0xf9,0x28,0x02]
; CHECK-FMA-WIN-NEXT:    vfmadd213pd (%r8), %xmm1, %xmm0 # encoding: [0xc4,0xc2,0xf1,0xa8,0x00]
; CHECK-FMA-WIN-NEXT:    # xmm0 = (xmm1 * xmm0) + mem
; CHECK-FMA-WIN-NEXT:    retq # encoding: [0xc3]
entry:
  %0 = tail call <2 x double> @llvm.fma.v2f64(<2 x double> %a, <2 x double> %b, <2 x double> %c) #2
  ret <2 x double> %0
}

define <4 x float> @test_mm_fmadd_ss(<4 x float> %a, <4 x float> %b, <4 x float> %c) {
; CHECK-FMA-LABEL: test_mm_fmadd_ss:
; CHECK-FMA:       # %bb.0: # %entry
; CHECK-FMA-NEXT:    vfmadd213ss %xmm2, %xmm1, %xmm0 # encoding: [0xc4,0xe2,0x71,0xa9,0xc2]
; CHECK-FMA-NEXT:    # xmm0 = (xmm1 * xmm0) + xmm2
; CHECK-FMA-NEXT:    retq # encoding: [0xc3]
;
; CHECK-AVX512VL-LABEL: test_mm_fmadd_ss:
; CHECK-AVX512VL:       # %bb.0: # %entry
; CHECK-AVX512VL-NEXT:    vfmadd213ss %xmm2, %xmm1, %xmm0 # EVEX TO VEX Compression encoding: [0xc4,0xe2,0x71,0xa9,0xc2]
; CHECK-AVX512VL-NEXT:    # xmm0 = (xmm1 * xmm0) + xmm2
; CHECK-AVX512VL-NEXT:    retq # encoding: [0xc3]
;
; CHECK-FMA-WIN-LABEL: test_mm_fmadd_ss:
; CHECK-FMA-WIN:       # %bb.0: # %entry
; CHECK-FMA-WIN-NEXT:    vmovaps (%rcx), %xmm0 # encoding: [0xc5,0xf8,0x28,0x01]
; CHECK-FMA-WIN-NEXT:    vmovss (%r8), %xmm1 # encoding: [0xc4,0xc1,0x7a,0x10,0x08]
; CHECK-FMA-WIN-NEXT:    # xmm1 = mem[0],zero,zero,zero
; CHECK-FMA-WIN-NEXT:    vfmadd132ss (%rdx), %xmm1, %xmm0 # encoding: [0xc4,0xe2,0x71,0x99,0x02]
; CHECK-FMA-WIN-NEXT:    # xmm0 = (xmm0 * mem) + xmm1
; CHECK-FMA-WIN-NEXT:    retq # encoding: [0xc3]
entry:
  %0 = extractelement <4 x float> %a, i64 0
  %1 = extractelement <4 x float> %b, i64 0
  %2 = extractelement <4 x float> %c, i64 0
  %3 = tail call float @llvm.fma.f32(float %0, float %1, float %2) #2
  %4 = insertelement <4 x float> %a, float %3, i64 0
  ret <4 x float> %4
}

define <2 x double> @test_mm_fmadd_sd(<2 x double> %a, <2 x double> %b, <2 x double> %c) {
; CHECK-FMA-LABEL: test_mm_fmadd_sd:
; CHECK-FMA:       # %bb.0: # %entry
; CHECK-FMA-NEXT:    vfmadd213sd %xmm2, %xmm1, %xmm0 # encoding: [0xc4,0xe2,0xf1,0xa9,0xc2]
; CHECK-FMA-NEXT:    # xmm0 = (xmm1 * xmm0) + xmm2
; CHECK-FMA-NEXT:    retq # encoding: [0xc3]
;
; CHECK-AVX512VL-LABEL: test_mm_fmadd_sd:
; CHECK-AVX512VL:       # %bb.0: # %entry
; CHECK-AVX512VL-NEXT:    vfmadd213sd %xmm2, %xmm1, %xmm0 # EVEX TO VEX Compression encoding: [0xc4,0xe2,0xf1,0xa9,0xc2]
; CHECK-AVX512VL-NEXT:    # xmm0 = (xmm1 * xmm0) + xmm2
; CHECK-AVX512VL-NEXT:    retq # encoding: [0xc3]
;
; CHECK-FMA-WIN-LABEL: test_mm_fmadd_sd:
; CHECK-FMA-WIN:       # %bb.0: # %entry
; CHECK-FMA-WIN-NEXT:    vmovapd (%rcx), %xmm0 # encoding: [0xc5,0xf9,0x28,0x01]
; CHECK-FMA-WIN-NEXT:    vmovsd (%r8), %xmm1 # encoding: [0xc4,0xc1,0x7b,0x10,0x08]
; CHECK-FMA-WIN-NEXT:    # xmm1 = mem[0],zero
; CHECK-FMA-WIN-NEXT:    vfmadd132sd (%rdx), %xmm1, %xmm0 # encoding: [0xc4,0xe2,0xf1,0x99,0x02]
; CHECK-FMA-WIN-NEXT:    # xmm0 = (xmm0 * mem) + xmm1
; CHECK-FMA-WIN-NEXT:    retq # encoding: [0xc3]
entry:
  %0 = extractelement <2 x double> %a, i64 0
  %1 = extractelement <2 x double> %b, i64 0
  %2 = extractelement <2 x double> %c, i64 0
  %3 = tail call double @llvm.fma.f64(double %0, double %1, double %2) #2
  %4 = insertelement <2 x double> %a, double %3, i64 0
  ret <2 x double> %4
}

define <4 x float> @test_mm_fmsub_ps(<4 x float> %a, <4 x float> %b, <4 x float> %c) {
; CHECK-FMA-LABEL: test_mm_fmsub_ps:
; CHECK-FMA:       # %bb.0: # %entry
; CHECK-FMA-NEXT:    vfmsub213ps %xmm2, %xmm1, %xmm0 # encoding: [0xc4,0xe2,0x71,0xaa,0xc2]
; CHECK-FMA-NEXT:    # xmm0 = (xmm1 * xmm0) - xmm2
; CHECK-FMA-NEXT:    retq # encoding: [0xc3]
;
; CHECK-AVX512VL-LABEL: test_mm_fmsub_ps:
; CHECK-AVX512VL:       # %bb.0: # %entry
; CHECK-AVX512VL-NEXT:    vfmsub213ps %xmm2, %xmm1, %xmm0 # EVEX TO VEX Compression encoding: [0xc4,0xe2,0x71,0xaa,0xc2]
; CHECK-AVX512VL-NEXT:    # xmm0 = (xmm1 * xmm0) - xmm2
; CHECK-AVX512VL-NEXT:    retq # encoding: [0xc3]
;
; CHECK-FMA-WIN-LABEL: test_mm_fmsub_ps:
; CHECK-FMA-WIN:       # %bb.0: # %entry
; CHECK-FMA-WIN-NEXT:    vmovaps (%rcx), %xmm1 # encoding: [0xc5,0xf8,0x28,0x09]
; CHECK-FMA-WIN-NEXT:    vmovaps (%rdx), %xmm0 # encoding: [0xc5,0xf8,0x28,0x02]
; CHECK-FMA-WIN-NEXT:    vfmsub213ps (%r8), %xmm1, %xmm0 # encoding: [0xc4,0xc2,0x71,0xaa,0x00]
; CHECK-FMA-WIN-NEXT:    # xmm0 = (xmm1 * xmm0) - mem
; CHECK-FMA-WIN-NEXT:    retq # encoding: [0xc3]
entry:
  %sub.i = fsub <4 x float> <float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00>, %c
  %0 = tail call <4 x float> @llvm.fma.v4f32(<4 x float> %a, <4 x float> %b, <4 x float> %sub.i) #2
  ret <4 x float> %0
}

define <2 x double> @test_mm_fmsub_pd(<2 x double> %a, <2 x double> %b, <2 x double> %c) {
; CHECK-FMA-LABEL: test_mm_fmsub_pd:
; CHECK-FMA:       # %bb.0: # %entry
; CHECK-FMA-NEXT:    vfmsub213pd %xmm2, %xmm1, %xmm0 # encoding: [0xc4,0xe2,0xf1,0xaa,0xc2]
; CHECK-FMA-NEXT:    # xmm0 = (xmm1 * xmm0) - xmm2
; CHECK-FMA-NEXT:    retq # encoding: [0xc3]
;
; CHECK-AVX512VL-LABEL: test_mm_fmsub_pd:
; CHECK-AVX512VL:       # %bb.0: # %entry
; CHECK-AVX512VL-NEXT:    vfmsub213pd %xmm2, %xmm1, %xmm0 # EVEX TO VEX Compression encoding: [0xc4,0xe2,0xf1,0xaa,0xc2]
; CHECK-AVX512VL-NEXT:    # xmm0 = (xmm1 * xmm0) - xmm2
; CHECK-AVX512VL-NEXT:    retq # encoding: [0xc3]
;
; CHECK-FMA-WIN-LABEL: test_mm_fmsub_pd:
; CHECK-FMA-WIN:       # %bb.0: # %entry
; CHECK-FMA-WIN-NEXT:    vmovapd (%rcx), %xmm1 # encoding: [0xc5,0xf9,0x28,0x09]
; CHECK-FMA-WIN-NEXT:    vmovapd (%rdx), %xmm0 # encoding: [0xc5,0xf9,0x28,0x02]
; CHECK-FMA-WIN-NEXT:    vfmsub213pd (%r8), %xmm1, %xmm0 # encoding: [0xc4,0xc2,0xf1,0xaa,0x00]
; CHECK-FMA-WIN-NEXT:    # xmm0 = (xmm1 * xmm0) - mem
; CHECK-FMA-WIN-NEXT:    retq # encoding: [0xc3]
entry:
  %sub.i = fsub <2 x double> <double -0.000000e+00, double -0.000000e+00>, %c
  %0 = tail call <2 x double> @llvm.fma.v2f64(<2 x double> %a, <2 x double> %b, <2 x double> %sub.i) #2
  ret <2 x double> %0
}

define <4 x float> @test_mm_fmsub_ss(<4 x float> %a, <4 x float> %b, <4 x float> %c) {
; CHECK-FMA-LABEL: test_mm_fmsub_ss:
; CHECK-FMA:       # %bb.0: # %entry
; CHECK-FMA-NEXT:    vfmsub213ss %xmm2, %xmm1, %xmm0 # encoding: [0xc4,0xe2,0x71,0xab,0xc2]
; CHECK-FMA-NEXT:    # xmm0 = (xmm1 * xmm0) - xmm2
; CHECK-FMA-NEXT:    retq # encoding: [0xc3]
;
; CHECK-AVX512VL-LABEL: test_mm_fmsub_ss:
; CHECK-AVX512VL:       # %bb.0: # %entry
; CHECK-AVX512VL-NEXT:    vfmsub213ss %xmm2, %xmm1, %xmm0 # EVEX TO VEX Compression encoding: [0xc4,0xe2,0x71,0xab,0xc2]
; CHECK-AVX512VL-NEXT:    # xmm0 = (xmm1 * xmm0) - xmm2
; CHECK-AVX512VL-NEXT:    retq # encoding: [0xc3]
;
; CHECK-FMA-WIN-LABEL: test_mm_fmsub_ss:
; CHECK-FMA-WIN:       # %bb.0: # %entry
; CHECK-FMA-WIN-NEXT:    vmovaps (%rcx), %xmm0 # encoding: [0xc5,0xf8,0x28,0x01]
; CHECK-FMA-WIN-NEXT:    vmovss (%r8), %xmm1 # encoding: [0xc4,0xc1,0x7a,0x10,0x08]
; CHECK-FMA-WIN-NEXT:    # xmm1 = mem[0],zero,zero,zero
; CHECK-FMA-WIN-NEXT:    vfmsub132ss (%rdx), %xmm1, %xmm0 # encoding: [0xc4,0xe2,0x71,0x9b,0x02]
; CHECK-FMA-WIN-NEXT:    # xmm0 = (xmm0 * mem) - xmm1
; CHECK-FMA-WIN-NEXT:    retq # encoding: [0xc3]
entry:
  %0 = extractelement <4 x float> %a, i64 0
  %1 = extractelement <4 x float> %b, i64 0
  %.rhs.i = extractelement <4 x float> %c, i64 0
  %2 = fsub float -0.000000e+00, %.rhs.i
  %3 = tail call float @llvm.fma.f32(float %0, float %1, float %2) #2
  %4 = insertelement <4 x float> %a, float %3, i64 0
  ret <4 x float> %4
}

define <2 x double> @test_mm_fmsub_sd(<2 x double> %a, <2 x double> %b, <2 x double> %c) {
; CHECK-FMA-LABEL: test_mm_fmsub_sd:
; CHECK-FMA:       # %bb.0: # %entry
; CHECK-FMA-NEXT:    vfmsub213sd %xmm2, %xmm1, %xmm0 # encoding: [0xc4,0xe2,0xf1,0xab,0xc2]
; CHECK-FMA-NEXT:    # xmm0 = (xmm1 * xmm0) - xmm2
; CHECK-FMA-NEXT:    retq # encoding: [0xc3]
;
; CHECK-AVX512VL-LABEL: test_mm_fmsub_sd:
; CHECK-AVX512VL:       # %bb.0: # %entry
; CHECK-AVX512VL-NEXT:    vfmsub213sd %xmm2, %xmm1, %xmm0 # EVEX TO VEX Compression encoding: [0xc4,0xe2,0xf1,0xab,0xc2]
; CHECK-AVX512VL-NEXT:    # xmm0 = (xmm1 * xmm0) - xmm2
; CHECK-AVX512VL-NEXT:    retq # encoding: [0xc3]
;
; CHECK-FMA-WIN-LABEL: test_mm_fmsub_sd:
; CHECK-FMA-WIN:       # %bb.0: # %entry
; CHECK-FMA-WIN-NEXT:    vmovapd (%rcx), %xmm0 # encoding: [0xc5,0xf9,0x28,0x01]
; CHECK-FMA-WIN-NEXT:    vmovsd (%r8), %xmm1 # encoding: [0xc4,0xc1,0x7b,0x10,0x08]
; CHECK-FMA-WIN-NEXT:    # xmm1 = mem[0],zero
; CHECK-FMA-WIN-NEXT:    vfmsub132sd (%rdx), %xmm1, %xmm0 # encoding: [0xc4,0xe2,0xf1,0x9b,0x02]
; CHECK-FMA-WIN-NEXT:    # xmm0 = (xmm0 * mem) - xmm1
; CHECK-FMA-WIN-NEXT:    retq # encoding: [0xc3]
entry:
  %0 = extractelement <2 x double> %a, i64 0
  %1 = extractelement <2 x double> %b, i64 0
  %.rhs.i = extractelement <2 x double> %c, i64 0
  %2 = fsub double -0.000000e+00, %.rhs.i
  %3 = tail call double @llvm.fma.f64(double %0, double %1, double %2) #2
  %4 = insertelement <2 x double> %a, double %3, i64 0
  ret <2 x double> %4
}

define <4 x float> @test_mm_fnmadd_ps(<4 x float> %a, <4 x float> %b, <4 x float> %c) {
; CHECK-FMA-LABEL: test_mm_fnmadd_ps:
; CHECK-FMA:       # %bb.0: # %entry
; CHECK-FMA-NEXT:    vfnmadd213ps %xmm2, %xmm1, %xmm0 # encoding: [0xc4,0xe2,0x71,0xac,0xc2]
; CHECK-FMA-NEXT:    # xmm0 = -(xmm1 * xmm0) + xmm2
; CHECK-FMA-NEXT:    retq # encoding: [0xc3]
;
; CHECK-AVX512VL-LABEL: test_mm_fnmadd_ps:
; CHECK-AVX512VL:       # %bb.0: # %entry
; CHECK-AVX512VL-NEXT:    vfnmadd213ps %xmm2, %xmm1, %xmm0 # EVEX TO VEX Compression encoding: [0xc4,0xe2,0x71,0xac,0xc2]
; CHECK-AVX512VL-NEXT:    # xmm0 = -(xmm1 * xmm0) + xmm2
; CHECK-AVX512VL-NEXT:    retq # encoding: [0xc3]
;
; CHECK-FMA-WIN-LABEL: test_mm_fnmadd_ps:
; CHECK-FMA-WIN:       # %bb.0: # %entry
; CHECK-FMA-WIN-NEXT:    vmovaps (%rcx), %xmm1 # encoding: [0xc5,0xf8,0x28,0x09]
; CHECK-FMA-WIN-NEXT:    vmovaps (%rdx), %xmm0 # encoding: [0xc5,0xf8,0x28,0x02]
; CHECK-FMA-WIN-NEXT:    vfnmadd213ps (%r8), %xmm1, %xmm0 # encoding: [0xc4,0xc2,0x71,0xac,0x00]
; CHECK-FMA-WIN-NEXT:    # xmm0 = -(xmm1 * xmm0) + mem
; CHECK-FMA-WIN-NEXT:    retq # encoding: [0xc3]
entry:
  %sub.i = fsub <4 x float> <float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00>, %a
  %0 = tail call <4 x float> @llvm.fma.v4f32(<4 x float> %sub.i, <4 x float> %b, <4 x float> %c) #2
  ret <4 x float> %0
}

define <2 x double> @test_mm_fnmadd_pd(<2 x double> %a, <2 x double> %b, <2 x double> %c) {
; CHECK-FMA-LABEL: test_mm_fnmadd_pd:
; CHECK-FMA:       # %bb.0: # %entry
; CHECK-FMA-NEXT:    vfnmadd213pd %xmm2, %xmm1, %xmm0 # encoding: [0xc4,0xe2,0xf1,0xac,0xc2]
; CHECK-FMA-NEXT:    # xmm0 = -(xmm1 * xmm0) + xmm2
; CHECK-FMA-NEXT:    retq # encoding: [0xc3]
;
; CHECK-AVX512VL-LABEL: test_mm_fnmadd_pd:
; CHECK-AVX512VL:       # %bb.0: # %entry
; CHECK-AVX512VL-NEXT:    vfnmadd213pd %xmm2, %xmm1, %xmm0 # EVEX TO VEX Compression encoding: [0xc4,0xe2,0xf1,0xac,0xc2]
; CHECK-AVX512VL-NEXT:    # xmm0 = -(xmm1 * xmm0) + xmm2
; CHECK-AVX512VL-NEXT:    retq # encoding: [0xc3]
;
; CHECK-FMA-WIN-LABEL: test_mm_fnmadd_pd:
; CHECK-FMA-WIN:       # %bb.0: # %entry
; CHECK-FMA-WIN-NEXT:    vmovapd (%rcx), %xmm1 # encoding: [0xc5,0xf9,0x28,0x09]
; CHECK-FMA-WIN-NEXT:    vmovapd (%rdx), %xmm0 # encoding: [0xc5,0xf9,0x28,0x02]
; CHECK-FMA-WIN-NEXT:    vfnmadd213pd (%r8), %xmm1, %xmm0 # encoding: [0xc4,0xc2,0xf1,0xac,0x00]
; CHECK-FMA-WIN-NEXT:    # xmm0 = -(xmm1 * xmm0) + mem
; CHECK-FMA-WIN-NEXT:    retq # encoding: [0xc3]
entry:
  %sub.i = fsub <2 x double> <double -0.000000e+00, double -0.000000e+00>, %a
  %0 = tail call <2 x double> @llvm.fma.v2f64(<2 x double> %sub.i, <2 x double> %b, <2 x double> %c) #2
  ret <2 x double> %0
}

define <4 x float> @test_mm_fnmadd_ss(<4 x float> %a, <4 x float> %b, <4 x float> %c) {
; CHECK-FMA-LABEL: test_mm_fnmadd_ss:
; CHECK-FMA:       # %bb.0: # %entry
; CHECK-FMA-NEXT:    vfnmadd213ss %xmm2, %xmm1, %xmm0 # encoding: [0xc4,0xe2,0x71,0xad,0xc2]
; CHECK-FMA-NEXT:    # xmm0 = -(xmm1 * xmm0) + xmm2
; CHECK-FMA-NEXT:    retq # encoding: [0xc3]
;
; CHECK-AVX512VL-LABEL: test_mm_fnmadd_ss:
; CHECK-AVX512VL:       # %bb.0: # %entry
; CHECK-AVX512VL-NEXT:    vfnmadd213ss %xmm2, %xmm1, %xmm0 # EVEX TO VEX Compression encoding: [0xc4,0xe2,0x71,0xad,0xc2]
; CHECK-AVX512VL-NEXT:    # xmm0 = -(xmm1 * xmm0) + xmm2
; CHECK-AVX512VL-NEXT:    retq # encoding: [0xc3]
;
; CHECK-FMA-WIN-LABEL: test_mm_fnmadd_ss:
; CHECK-FMA-WIN:       # %bb.0: # %entry
; CHECK-FMA-WIN-NEXT:    vmovaps (%rcx), %xmm0 # encoding: [0xc5,0xf8,0x28,0x01]
; CHECK-FMA-WIN-NEXT:    vmovss (%r8), %xmm1 # encoding: [0xc4,0xc1,0x7a,0x10,0x08]
; CHECK-FMA-WIN-NEXT:    # xmm1 = mem[0],zero,zero,zero
; CHECK-FMA-WIN-NEXT:    vfnmadd132ss (%rdx), %xmm1, %xmm0 # encoding: [0xc4,0xe2,0x71,0x9d,0x02]
; CHECK-FMA-WIN-NEXT:    # xmm0 = -(xmm0 * mem) + xmm1
; CHECK-FMA-WIN-NEXT:    retq # encoding: [0xc3]
entry:
  %0 = extractelement <4 x float> %a, i64 0
  %.rhs.i = extractelement <4 x float> %b, i64 0
  %1 = fsub float -0.000000e+00, %.rhs.i
  %2 = extractelement <4 x float> %c, i64 0
  %3 = tail call float @llvm.fma.f32(float %0, float %1, float %2) #2
  %4 = insertelement <4 x float> %a, float %3, i64 0
  ret <4 x float> %4
}

define <2 x double> @test_mm_fnmadd_sd(<2 x double> %a, <2 x double> %b, <2 x double> %c) {
; CHECK-FMA-LABEL: test_mm_fnmadd_sd:
; CHECK-FMA:       # %bb.0: # %entry
; CHECK-FMA-NEXT:    vfnmadd213sd %xmm2, %xmm1, %xmm0 # encoding: [0xc4,0xe2,0xf1,0xad,0xc2]
; CHECK-FMA-NEXT:    # xmm0 = -(xmm1 * xmm0) + xmm2
; CHECK-FMA-NEXT:    retq # encoding: [0xc3]
;
; CHECK-AVX512VL-LABEL: test_mm_fnmadd_sd:
; CHECK-AVX512VL:       # %bb.0: # %entry
; CHECK-AVX512VL-NEXT:    vfnmadd213sd %xmm2, %xmm1, %xmm0 # EVEX TO VEX Compression encoding: [0xc4,0xe2,0xf1,0xad,0xc2]
; CHECK-AVX512VL-NEXT:    # xmm0 = -(xmm1 * xmm0) + xmm2
; CHECK-AVX512VL-NEXT:    retq # encoding: [0xc3]
;
; CHECK-FMA-WIN-LABEL: test_mm_fnmadd_sd:
; CHECK-FMA-WIN:       # %bb.0: # %entry
; CHECK-FMA-WIN-NEXT:    vmovapd (%rcx), %xmm0 # encoding: [0xc5,0xf9,0x28,0x01]
; CHECK-FMA-WIN-NEXT:    vmovsd (%r8), %xmm1 # encoding: [0xc4,0xc1,0x7b,0x10,0x08]
; CHECK-FMA-WIN-NEXT:    # xmm1 = mem[0],zero
; CHECK-FMA-WIN-NEXT:    vfnmadd132sd (%rdx), %xmm1, %xmm0 # encoding: [0xc4,0xe2,0xf1,0x9d,0x02]
; CHECK-FMA-WIN-NEXT:    # xmm0 = -(xmm0 * mem) + xmm1
; CHECK-FMA-WIN-NEXT:    retq # encoding: [0xc3]
entry:
  %0 = extractelement <2 x double> %a, i64 0
  %.rhs.i = extractelement <2 x double> %b, i64 0
  %1 = fsub double -0.000000e+00, %.rhs.i
  %2 = extractelement <2 x double> %c, i64 0
  %3 = tail call double @llvm.fma.f64(double %0, double %1, double %2) #2
  %4 = insertelement <2 x double> %a, double %3, i64 0
  ret <2 x double> %4
}

define <4 x float> @test_mm_fnmsub_ps(<4 x float> %a, <4 x float> %b, <4 x float> %c) {
; CHECK-FMA-LABEL: test_mm_fnmsub_ps:
; CHECK-FMA:       # %bb.0: # %entry
; CHECK-FMA-NEXT:    vfnmsub213ps %xmm2, %xmm1, %xmm0 # encoding: [0xc4,0xe2,0x71,0xae,0xc2]
; CHECK-FMA-NEXT:    # xmm0 = -(xmm1 * xmm0) - xmm2
; CHECK-FMA-NEXT:    retq # encoding: [0xc3]
;
; CHECK-AVX512VL-LABEL: test_mm_fnmsub_ps:
; CHECK-AVX512VL:       # %bb.0: # %entry
; CHECK-AVX512VL-NEXT:    vfnmsub213ps %xmm2, %xmm1, %xmm0 # EVEX TO VEX Compression encoding: [0xc4,0xe2,0x71,0xae,0xc2]
; CHECK-AVX512VL-NEXT:    # xmm0 = -(xmm1 * xmm0) - xmm2
; CHECK-AVX512VL-NEXT:    retq # encoding: [0xc3]
;
; CHECK-FMA-WIN-LABEL: test_mm_fnmsub_ps:
; CHECK-FMA-WIN:       # %bb.0: # %entry
; CHECK-FMA-WIN-NEXT:    vmovaps (%rcx), %xmm1 # encoding: [0xc5,0xf8,0x28,0x09]
; CHECK-FMA-WIN-NEXT:    vmovaps (%rdx), %xmm0 # encoding: [0xc5,0xf8,0x28,0x02]
; CHECK-FMA-WIN-NEXT:    vfnmsub213ps (%r8), %xmm1, %xmm0 # encoding: [0xc4,0xc2,0x71,0xae,0x00]
; CHECK-FMA-WIN-NEXT:    # xmm0 = -(xmm1 * xmm0) - mem
; CHECK-FMA-WIN-NEXT:    retq # encoding: [0xc3]
entry:
  %sub.i = fsub <4 x float> <float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00>, %a
  %sub1.i = fsub <4 x float> <float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00>, %c
  %0 = tail call <4 x float> @llvm.fma.v4f32(<4 x float> %sub.i, <4 x float> %b, <4 x float> %sub1.i) #2
  ret <4 x float> %0
}

define <2 x double> @test_mm_fnmsub_pd(<2 x double> %a, <2 x double> %b, <2 x double> %c) {
; CHECK-FMA-LABEL: test_mm_fnmsub_pd:
; CHECK-FMA:       # %bb.0: # %entry
; CHECK-FMA-NEXT:    vfnmsub213pd %xmm2, %xmm1, %xmm0 # encoding: [0xc4,0xe2,0xf1,0xae,0xc2]
; CHECK-FMA-NEXT:    # xmm0 = -(xmm1 * xmm0) - xmm2
; CHECK-FMA-NEXT:    retq # encoding: [0xc3]
;
; CHECK-AVX512VL-LABEL: test_mm_fnmsub_pd:
; CHECK-AVX512VL:       # %bb.0: # %entry
; CHECK-AVX512VL-NEXT:    vfnmsub213pd %xmm2, %xmm1, %xmm0 # EVEX TO VEX Compression encoding: [0xc4,0xe2,0xf1,0xae,0xc2]
; CHECK-AVX512VL-NEXT:    # xmm0 = -(xmm1 * xmm0) - xmm2
; CHECK-AVX512VL-NEXT:    retq # encoding: [0xc3]
;
; CHECK-FMA-WIN-LABEL: test_mm_fnmsub_pd:
; CHECK-FMA-WIN:       # %bb.0: # %entry
; CHECK-FMA-WIN-NEXT:    vmovapd (%rcx), %xmm1 # encoding: [0xc5,0xf9,0x28,0x09]
; CHECK-FMA-WIN-NEXT:    vmovapd (%rdx), %xmm0 # encoding: [0xc5,0xf9,0x28,0x02]
; CHECK-FMA-WIN-NEXT:    vfnmsub213pd (%r8), %xmm1, %xmm0 # encoding: [0xc4,0xc2,0xf1,0xae,0x00]
; CHECK-FMA-WIN-NEXT:    # xmm0 = -(xmm1 * xmm0) - mem
; CHECK-FMA-WIN-NEXT:    retq # encoding: [0xc3]
entry:
  %sub.i = fsub <2 x double> <double -0.000000e+00, double -0.000000e+00>, %a
  %sub1.i = fsub <2 x double> <double -0.000000e+00, double -0.000000e+00>, %c
  %0 = tail call <2 x double> @llvm.fma.v2f64(<2 x double> %sub.i, <2 x double> %b, <2 x double> %sub1.i) #2
  ret <2 x double> %0
}

define <4 x float> @test_mm_fnmsub_ss(<4 x float> %a, <4 x float> %b, <4 x float> %c) {
; CHECK-FMA-LABEL: test_mm_fnmsub_ss:
; CHECK-FMA:       # %bb.0: # %entry
; CHECK-FMA-NEXT:    vfnmsub213ss %xmm2, %xmm1, %xmm0 # encoding: [0xc4,0xe2,0x71,0xaf,0xc2]
; CHECK-FMA-NEXT:    # xmm0 = -(xmm1 * xmm0) - xmm2
; CHECK-FMA-NEXT:    retq # encoding: [0xc3]
;
; CHECK-AVX512VL-LABEL: test_mm_fnmsub_ss:
; CHECK-AVX512VL:       # %bb.0: # %entry
; CHECK-AVX512VL-NEXT:    vfnmsub213ss %xmm2, %xmm1, %xmm0 # EVEX TO VEX Compression encoding: [0xc4,0xe2,0x71,0xaf,0xc2]
; CHECK-AVX512VL-NEXT:    # xmm0 = -(xmm1 * xmm0) - xmm2
; CHECK-AVX512VL-NEXT:    retq # encoding: [0xc3]
;
; CHECK-FMA-WIN-LABEL: test_mm_fnmsub_ss:
; CHECK-FMA-WIN:       # %bb.0: # %entry
; CHECK-FMA-WIN-NEXT:    vmovaps (%rcx), %xmm0 # encoding: [0xc5,0xf8,0x28,0x01]
; CHECK-FMA-WIN-NEXT:    vmovss (%r8), %xmm1 # encoding: [0xc4,0xc1,0x7a,0x10,0x08]
; CHECK-FMA-WIN-NEXT:    # xmm1 = mem[0],zero,zero,zero
; CHECK-FMA-WIN-NEXT:    vfnmsub132ss (%rdx), %xmm1, %xmm0 # encoding: [0xc4,0xe2,0x71,0x9f,0x02]
; CHECK-FMA-WIN-NEXT:    # xmm0 = -(xmm0 * mem) - xmm1
; CHECK-FMA-WIN-NEXT:    retq # encoding: [0xc3]
entry:
  %0 = extractelement <4 x float> %a, i64 0
  %.rhs.i = extractelement <4 x float> %b, i64 0
  %1 = fsub float -0.000000e+00, %.rhs.i
  %.rhs2.i = extractelement <4 x float> %c, i64 0
  %2 = fsub float -0.000000e+00, %.rhs2.i
  %3 = tail call float @llvm.fma.f32(float %0, float %1, float %2) #2
  %4 = insertelement <4 x float> %a, float %3, i64 0
  ret <4 x float> %4
}

define <2 x double> @test_mm_fnmsub_sd(<2 x double> %a, <2 x double> %b, <2 x double> %c) {
; CHECK-FMA-LABEL: test_mm_fnmsub_sd:
; CHECK-FMA:       # %bb.0: # %entry
; CHECK-FMA-NEXT:    vfnmsub213sd %xmm2, %xmm1, %xmm0 # encoding: [0xc4,0xe2,0xf1,0xaf,0xc2]
; CHECK-FMA-NEXT:    # xmm0 = -(xmm1 * xmm0) - xmm2
; CHECK-FMA-NEXT:    retq # encoding: [0xc3]
;
; CHECK-AVX512VL-LABEL: test_mm_fnmsub_sd:
; CHECK-AVX512VL:       # %bb.0: # %entry
; CHECK-AVX512VL-NEXT:    vfnmsub213sd %xmm2, %xmm1, %xmm0 # EVEX TO VEX Compression encoding: [0xc4,0xe2,0xf1,0xaf,0xc2]
; CHECK-AVX512VL-NEXT:    # xmm0 = -(xmm1 * xmm0) - xmm2
; CHECK-AVX512VL-NEXT:    retq # encoding: [0xc3]
;
; CHECK-FMA-WIN-LABEL: test_mm_fnmsub_sd:
; CHECK-FMA-WIN:       # %bb.0: # %entry
; CHECK-FMA-WIN-NEXT:    vmovapd (%rcx), %xmm0 # encoding: [0xc5,0xf9,0x28,0x01]
; CHECK-FMA-WIN-NEXT:    vmovsd (%r8), %xmm1 # encoding: [0xc4,0xc1,0x7b,0x10,0x08]
; CHECK-FMA-WIN-NEXT:    # xmm1 = mem[0],zero
; CHECK-FMA-WIN-NEXT:    vfnmsub132sd (%rdx), %xmm1, %xmm0 # encoding: [0xc4,0xe2,0xf1,0x9f,0x02]
; CHECK-FMA-WIN-NEXT:    # xmm0 = -(xmm0 * mem) - xmm1
; CHECK-FMA-WIN-NEXT:    retq # encoding: [0xc3]
entry:
  %0 = extractelement <2 x double> %a, i64 0
  %.rhs.i = extractelement <2 x double> %b, i64 0
  %1 = fsub double -0.000000e+00, %.rhs.i
  %.rhs2.i = extractelement <2 x double> %c, i64 0
  %2 = fsub double -0.000000e+00, %.rhs2.i
  %3 = tail call double @llvm.fma.f64(double %0, double %1, double %2) #2
  %4 = insertelement <2 x double> %a, double %3, i64 0
  ret <2 x double> %4
}

define <4 x float> @test_mm_fmaddsub_ps(<4 x float> %a, <4 x float> %b, <4 x float> %c) {
; CHECK-FMA-LABEL: test_mm_fmaddsub_ps:
; CHECK-FMA:       # %bb.0: # %entry
; CHECK-FMA-NEXT:    vfmaddsub213ps %xmm2, %xmm1, %xmm0 # encoding: [0xc4,0xe2,0x71,0xa6,0xc2]
; CHECK-FMA-NEXT:    # xmm0 = (xmm1 * xmm0) +/- xmm2
; CHECK-FMA-NEXT:    retq # encoding: [0xc3]
;
; CHECK-AVX512VL-LABEL: test_mm_fmaddsub_ps:
; CHECK-AVX512VL:       # %bb.0: # %entry
; CHECK-AVX512VL-NEXT:    vfmaddsub213ps %xmm2, %xmm1, %xmm0 # EVEX TO VEX Compression encoding: [0xc4,0xe2,0x71,0xa6,0xc2]
; CHECK-AVX512VL-NEXT:    # xmm0 = (xmm1 * xmm0) +/- xmm2
; CHECK-AVX512VL-NEXT:    retq # encoding: [0xc3]
;
; CHECK-FMA-WIN-LABEL: test_mm_fmaddsub_ps:
; CHECK-FMA-WIN:       # %bb.0: # %entry
; CHECK-FMA-WIN-NEXT:    vmovaps (%rcx), %xmm1 # encoding: [0xc5,0xf8,0x28,0x09]
; CHECK-FMA-WIN-NEXT:    vmovaps (%rdx), %xmm0 # encoding: [0xc5,0xf8,0x28,0x02]
; CHECK-FMA-WIN-NEXT:    vfmaddsub213ps (%r8), %xmm1, %xmm0 # encoding: [0xc4,0xc2,0x71,0xa6,0x00]
; CHECK-FMA-WIN-NEXT:    # xmm0 = (xmm1 * xmm0) +/- mem
; CHECK-FMA-WIN-NEXT:    retq # encoding: [0xc3]
entry:
  %0 = tail call <4 x float> @llvm.fma.v4f32(<4 x float> %a, <4 x float> %b, <4 x float> %c) #2
  %1 = fsub <4 x float> <float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00>, %c
  %2 = tail call <4 x float> @llvm.fma.v4f32(<4 x float> %a, <4 x float> %b, <4 x float> %1) #2
  %3 = shufflevector <4 x float> %2, <4 x float> %0, <4 x i32> <i32 0, i32 5, i32 2, i32 7>
  ret <4 x float> %3
}

define <2 x double> @test_mm_fmaddsub_pd(<2 x double> %a, <2 x double> %b, <2 x double> %c) {
; CHECK-FMA-LABEL: test_mm_fmaddsub_pd:
; CHECK-FMA:       # %bb.0: # %entry
; CHECK-FMA-NEXT:    vfmaddsub213pd %xmm2, %xmm1, %xmm0 # encoding: [0xc4,0xe2,0xf1,0xa6,0xc2]
; CHECK-FMA-NEXT:    # xmm0 = (xmm1 * xmm0) +/- xmm2
; CHECK-FMA-NEXT:    retq # encoding: [0xc3]
;
; CHECK-AVX512VL-LABEL: test_mm_fmaddsub_pd:
; CHECK-AVX512VL:       # %bb.0: # %entry
; CHECK-AVX512VL-NEXT:    vfmaddsub213pd %xmm2, %xmm1, %xmm0 # EVEX TO VEX Compression encoding: [0xc4,0xe2,0xf1,0xa6,0xc2]
; CHECK-AVX512VL-NEXT:    # xmm0 = (xmm1 * xmm0) +/- xmm2
; CHECK-AVX512VL-NEXT:    retq # encoding: [0xc3]
;
; CHECK-FMA-WIN-LABEL: test_mm_fmaddsub_pd:
; CHECK-FMA-WIN:       # %bb.0: # %entry
; CHECK-FMA-WIN-NEXT:    vmovapd (%rcx), %xmm1 # encoding: [0xc5,0xf9,0x28,0x09]
; CHECK-FMA-WIN-NEXT:    vmovapd (%rdx), %xmm0 # encoding: [0xc5,0xf9,0x28,0x02]
; CHECK-FMA-WIN-NEXT:    vfmaddsub213pd (%r8), %xmm1, %xmm0 # encoding: [0xc4,0xc2,0xf1,0xa6,0x00]
; CHECK-FMA-WIN-NEXT:    # xmm0 = (xmm1 * xmm0) +/- mem
; CHECK-FMA-WIN-NEXT:    retq # encoding: [0xc3]
entry:
  %0 = tail call <2 x double> @llvm.fma.v2f64(<2 x double> %a, <2 x double> %b, <2 x double> %c) #2
  %1 = fsub <2 x double> <double -0.000000e+00, double -0.000000e+00>, %c
  %2 = tail call <2 x double> @llvm.fma.v2f64(<2 x double> %a, <2 x double> %b, <2 x double> %1) #2
  %3 = shufflevector <2 x double> %2, <2 x double> %0, <2 x i32> <i32 0, i32 3>
  ret <2 x double> %3
}

define <4 x float> @test_mm_fmsubadd_ps(<4 x float> %a, <4 x float> %b, <4 x float> %c) {
; CHECK-FMA-LABEL: test_mm_fmsubadd_ps:
; CHECK-FMA:       # %bb.0: # %entry
; CHECK-FMA-NEXT:    vfmsubadd213ps %xmm2, %xmm1, %xmm0 # encoding: [0xc4,0xe2,0x71,0xa7,0xc2]
; CHECK-FMA-NEXT:    # xmm0 = (xmm1 * xmm0) -/+ xmm2
; CHECK-FMA-NEXT:    retq # encoding: [0xc3]
;
; CHECK-AVX512VL-LABEL: test_mm_fmsubadd_ps:
; CHECK-AVX512VL:       # %bb.0: # %entry
; CHECK-AVX512VL-NEXT:    vfmsubadd213ps %xmm2, %xmm1, %xmm0 # EVEX TO VEX Compression encoding: [0xc4,0xe2,0x71,0xa7,0xc2]
; CHECK-AVX512VL-NEXT:    # xmm0 = (xmm1 * xmm0) -/+ xmm2
; CHECK-AVX512VL-NEXT:    retq # encoding: [0xc3]
;
; CHECK-FMA-WIN-LABEL: test_mm_fmsubadd_ps:
; CHECK-FMA-WIN:       # %bb.0: # %entry
; CHECK-FMA-WIN-NEXT:    vmovaps (%rcx), %xmm1 # encoding: [0xc5,0xf8,0x28,0x09]
; CHECK-FMA-WIN-NEXT:    vmovaps (%rdx), %xmm0 # encoding: [0xc5,0xf8,0x28,0x02]
; CHECK-FMA-WIN-NEXT:    vfmsubadd213ps (%r8), %xmm1, %xmm0 # encoding: [0xc4,0xc2,0x71,0xa7,0x00]
; CHECK-FMA-WIN-NEXT:    # xmm0 = (xmm1 * xmm0) -/+ mem
; CHECK-FMA-WIN-NEXT:    retq # encoding: [0xc3]
entry:
  %sub.i = fsub <4 x float> <float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00>, %c
  %0 = tail call <4 x float> @llvm.fma.v4f32(<4 x float> %a, <4 x float> %b, <4 x float> %sub.i) #2
  %1 = tail call <4 x float> @llvm.fma.v4f32(<4 x float> %a, <4 x float> %b, <4 x float> %c) #2
  %2 = shufflevector <4 x float> %1, <4 x float> %0, <4 x i32> <i32 0, i32 5, i32 2, i32 7>
  ret <4 x float> %2
}

define <2 x double> @test_mm_fmsubadd_pd(<2 x double> %a, <2 x double> %b, <2 x double> %c) {
; CHECK-FMA-LABEL: test_mm_fmsubadd_pd:
; CHECK-FMA:       # %bb.0: # %entry
; CHECK-FMA-NEXT:    vfmsubadd213pd %xmm2, %xmm1, %xmm0 # encoding: [0xc4,0xe2,0xf1,0xa7,0xc2]
; CHECK-FMA-NEXT:    # xmm0 = (xmm1 * xmm0) -/+ xmm2
; CHECK-FMA-NEXT:    retq # encoding: [0xc3]
;
; CHECK-AVX512VL-LABEL: test_mm_fmsubadd_pd:
; CHECK-AVX512VL:       # %bb.0: # %entry
; CHECK-AVX512VL-NEXT:    vfmsubadd213pd %xmm2, %xmm1, %xmm0 # EVEX TO VEX Compression encoding: [0xc4,0xe2,0xf1,0xa7,0xc2]
; CHECK-AVX512VL-NEXT:    # xmm0 = (xmm1 * xmm0) -/+ xmm2
; CHECK-AVX512VL-NEXT:    retq # encoding: [0xc3]
;
; CHECK-FMA-WIN-LABEL: test_mm_fmsubadd_pd:
; CHECK-FMA-WIN:       # %bb.0: # %entry
; CHECK-FMA-WIN-NEXT:    vmovapd (%rcx), %xmm1 # encoding: [0xc5,0xf9,0x28,0x09]
; CHECK-FMA-WIN-NEXT:    vmovapd (%rdx), %xmm0 # encoding: [0xc5,0xf9,0x28,0x02]
; CHECK-FMA-WIN-NEXT:    vfmsubadd213pd (%r8), %xmm1, %xmm0 # encoding: [0xc4,0xc2,0xf1,0xa7,0x00]
; CHECK-FMA-WIN-NEXT:    # xmm0 = (xmm1 * xmm0) -/+ mem
; CHECK-FMA-WIN-NEXT:    retq # encoding: [0xc3]
entry:
  %sub.i = fsub <2 x double> <double -0.000000e+00, double -0.000000e+00>, %c
  %0 = tail call <2 x double> @llvm.fma.v2f64(<2 x double> %a, <2 x double> %b, <2 x double> %sub.i) #2
  %1 = tail call <2 x double> @llvm.fma.v2f64(<2 x double> %a, <2 x double> %b, <2 x double> %c) #2
  %2 = shufflevector <2 x double> %1, <2 x double> %0, <2 x i32> <i32 0, i32 3>
  ret <2 x double> %2
}

define <8 x float> @test_mm256_fmadd_ps(<8 x float> %a, <8 x float> %b, <8 x float> %c) {
; CHECK-FMA-LABEL: test_mm256_fmadd_ps:
; CHECK-FMA:       # %bb.0: # %entry
; CHECK-FMA-NEXT:    vfmadd213ps %ymm2, %ymm1, %ymm0 # encoding: [0xc4,0xe2,0x75,0xa8,0xc2]
; CHECK-FMA-NEXT:    # ymm0 = (ymm1 * ymm0) + ymm2
; CHECK-FMA-NEXT:    retq # encoding: [0xc3]
;
; CHECK-AVX512VL-LABEL: test_mm256_fmadd_ps:
; CHECK-AVX512VL:       # %bb.0: # %entry
; CHECK-AVX512VL-NEXT:    vfmadd213ps %ymm2, %ymm1, %ymm0 # EVEX TO VEX Compression encoding: [0xc4,0xe2,0x75,0xa8,0xc2]
; CHECK-AVX512VL-NEXT:    # ymm0 = (ymm1 * ymm0) + ymm2
; CHECK-AVX512VL-NEXT:    retq # encoding: [0xc3]
;
; CHECK-FMA-WIN-LABEL: test_mm256_fmadd_ps:
; CHECK-FMA-WIN:       # %bb.0: # %entry
; CHECK-FMA-WIN-NEXT:    vmovaps (%rcx), %ymm1 # encoding: [0xc5,0xfc,0x28,0x09]
; CHECK-FMA-WIN-NEXT:    vmovaps (%rdx), %ymm0 # encoding: [0xc5,0xfc,0x28,0x02]
; CHECK-FMA-WIN-NEXT:    vfmadd213ps (%r8), %ymm1, %ymm0 # encoding: [0xc4,0xc2,0x75,0xa8,0x00]
; CHECK-FMA-WIN-NEXT:    # ymm0 = (ymm1 * ymm0) + mem
; CHECK-FMA-WIN-NEXT:    retq # encoding: [0xc3]
entry:
  %0 = tail call <8 x float> @llvm.fma.v8f32(<8 x float> %a, <8 x float> %b, <8 x float> %c) #2
  ret <8 x float> %0
}

define <4 x double> @test_mm256_fmadd_pd(<4 x double> %a, <4 x double> %b, <4 x double> %c) {
; CHECK-FMA-LABEL: test_mm256_fmadd_pd:
; CHECK-FMA:       # %bb.0: # %entry
; CHECK-FMA-NEXT:    vfmadd213pd %ymm2, %ymm1, %ymm0 # encoding: [0xc4,0xe2,0xf5,0xa8,0xc2]
; CHECK-FMA-NEXT:    # ymm0 = (ymm1 * ymm0) + ymm2
; CHECK-FMA-NEXT:    retq # encoding: [0xc3]
;
; CHECK-AVX512VL-LABEL: test_mm256_fmadd_pd:
; CHECK-AVX512VL:       # %bb.0: # %entry
; CHECK-AVX512VL-NEXT:    vfmadd213pd %ymm2, %ymm1, %ymm0 # EVEX TO VEX Compression encoding: [0xc4,0xe2,0xf5,0xa8,0xc2]
; CHECK-AVX512VL-NEXT:    # ymm0 = (ymm1 * ymm0) + ymm2
; CHECK-AVX512VL-NEXT:    retq # encoding: [0xc3]
;
; CHECK-FMA-WIN-LABEL: test_mm256_fmadd_pd:
; CHECK-FMA-WIN:       # %bb.0: # %entry
; CHECK-FMA-WIN-NEXT:    vmovapd (%rcx), %ymm1 # encoding: [0xc5,0xfd,0x28,0x09]
; CHECK-FMA-WIN-NEXT:    vmovapd (%rdx), %ymm0 # encoding: [0xc5,0xfd,0x28,0x02]
; CHECK-FMA-WIN-NEXT:    vfmadd213pd (%r8), %ymm1, %ymm0 # encoding: [0xc4,0xc2,0xf5,0xa8,0x00]
; CHECK-FMA-WIN-NEXT:    # ymm0 = (ymm1 * ymm0) + mem
; CHECK-FMA-WIN-NEXT:    retq # encoding: [0xc3]
entry:
  %0 = tail call <4 x double> @llvm.fma.v4f64(<4 x double> %a, <4 x double> %b, <4 x double> %c) #2
  ret <4 x double> %0
}

define <8 x float> @test_mm256_fmsub_ps(<8 x float> %a, <8 x float> %b, <8 x float> %c) {
; CHECK-FMA-LABEL: test_mm256_fmsub_ps:
; CHECK-FMA:       # %bb.0: # %entry
; CHECK-FMA-NEXT:    vfmsub213ps %ymm2, %ymm1, %ymm0 # encoding: [0xc4,0xe2,0x75,0xaa,0xc2]
; CHECK-FMA-NEXT:    # ymm0 = (ymm1 * ymm0) - ymm2
; CHECK-FMA-NEXT:    retq # encoding: [0xc3]
;
; CHECK-AVX512VL-LABEL: test_mm256_fmsub_ps:
; CHECK-AVX512VL:       # %bb.0: # %entry
; CHECK-AVX512VL-NEXT:    vfmsub213ps %ymm2, %ymm1, %ymm0 # EVEX TO VEX Compression encoding: [0xc4,0xe2,0x75,0xaa,0xc2]
; CHECK-AVX512VL-NEXT:    # ymm0 = (ymm1 * ymm0) - ymm2
; CHECK-AVX512VL-NEXT:    retq # encoding: [0xc3]
;
; CHECK-FMA-WIN-LABEL: test_mm256_fmsub_ps:
; CHECK-FMA-WIN:       # %bb.0: # %entry
; CHECK-FMA-WIN-NEXT:    vmovaps (%rcx), %ymm1 # encoding: [0xc5,0xfc,0x28,0x09]
; CHECK-FMA-WIN-NEXT:    vmovaps (%rdx), %ymm0 # encoding: [0xc5,0xfc,0x28,0x02]
; CHECK-FMA-WIN-NEXT:    vfmsub213ps (%r8), %ymm1, %ymm0 # encoding: [0xc4,0xc2,0x75,0xaa,0x00]
; CHECK-FMA-WIN-NEXT:    # ymm0 = (ymm1 * ymm0) - mem
; CHECK-FMA-WIN-NEXT:    retq # encoding: [0xc3]
entry:
  %sub.i = fsub <8 x float> <float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00>, %c
  %0 = tail call <8 x float> @llvm.fma.v8f32(<8 x float> %a, <8 x float> %b, <8 x float> %sub.i) #2
  ret <8 x float> %0
}

define <4 x double> @test_mm256_fmsub_pd(<4 x double> %a, <4 x double> %b, <4 x double> %c) {
; CHECK-FMA-LABEL: test_mm256_fmsub_pd:
; CHECK-FMA:       # %bb.0: # %entry
; CHECK-FMA-NEXT:    vfmsub213pd %ymm2, %ymm1, %ymm0 # encoding: [0xc4,0xe2,0xf5,0xaa,0xc2]
; CHECK-FMA-NEXT:    # ymm0 = (ymm1 * ymm0) - ymm2
; CHECK-FMA-NEXT:    retq # encoding: [0xc3]
;
; CHECK-AVX512VL-LABEL: test_mm256_fmsub_pd:
; CHECK-AVX512VL:       # %bb.0: # %entry
; CHECK-AVX512VL-NEXT:    vfmsub213pd %ymm2, %ymm1, %ymm0 # EVEX TO VEX Compression encoding: [0xc4,0xe2,0xf5,0xaa,0xc2]
; CHECK-AVX512VL-NEXT:    # ymm0 = (ymm1 * ymm0) - ymm2
; CHECK-AVX512VL-NEXT:    retq # encoding: [0xc3]
;
; CHECK-FMA-WIN-LABEL: test_mm256_fmsub_pd:
; CHECK-FMA-WIN:       # %bb.0: # %entry
; CHECK-FMA-WIN-NEXT:    vmovapd (%rcx), %ymm1 # encoding: [0xc5,0xfd,0x28,0x09]
; CHECK-FMA-WIN-NEXT:    vmovapd (%rdx), %ymm0 # encoding: [0xc5,0xfd,0x28,0x02]
; CHECK-FMA-WIN-NEXT:    vfmsub213pd (%r8), %ymm1, %ymm0 # encoding: [0xc4,0xc2,0xf5,0xaa,0x00]
; CHECK-FMA-WIN-NEXT:    # ymm0 = (ymm1 * ymm0) - mem
; CHECK-FMA-WIN-NEXT:    retq # encoding: [0xc3]
entry:
  %sub.i = fsub <4 x double> <double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00>, %c
  %0 = tail call <4 x double> @llvm.fma.v4f64(<4 x double> %a, <4 x double> %b, <4 x double> %sub.i) #2
  ret <4 x double> %0
}

define <8 x float> @test_mm256_fnmadd_ps(<8 x float> %a, <8 x float> %b, <8 x float> %c) {
; CHECK-FMA-LABEL: test_mm256_fnmadd_ps:
; CHECK-FMA:       # %bb.0: # %entry
; CHECK-FMA-NEXT:    vfnmadd213ps %ymm2, %ymm1, %ymm0 # encoding: [0xc4,0xe2,0x75,0xac,0xc2]
; CHECK-FMA-NEXT:    # ymm0 = -(ymm1 * ymm0) + ymm2
; CHECK-FMA-NEXT:    retq # encoding: [0xc3]
;
; CHECK-AVX512VL-LABEL: test_mm256_fnmadd_ps:
; CHECK-AVX512VL:       # %bb.0: # %entry
; CHECK-AVX512VL-NEXT:    vfnmadd213ps %ymm2, %ymm1, %ymm0 # EVEX TO VEX Compression encoding: [0xc4,0xe2,0x75,0xac,0xc2]
; CHECK-AVX512VL-NEXT:    # ymm0 = -(ymm1 * ymm0) + ymm2
; CHECK-AVX512VL-NEXT:    retq # encoding: [0xc3]
;
; CHECK-FMA-WIN-LABEL: test_mm256_fnmadd_ps:
; CHECK-FMA-WIN:       # %bb.0: # %entry
; CHECK-FMA-WIN-NEXT:    vmovaps (%rcx), %ymm1 # encoding: [0xc5,0xfc,0x28,0x09]
; CHECK-FMA-WIN-NEXT:    vmovaps (%rdx), %ymm0 # encoding: [0xc5,0xfc,0x28,0x02]
; CHECK-FMA-WIN-NEXT:    vfnmadd213ps (%r8), %ymm1, %ymm0 # encoding: [0xc4,0xc2,0x75,0xac,0x00]
; CHECK-FMA-WIN-NEXT:    # ymm0 = -(ymm1 * ymm0) + mem
; CHECK-FMA-WIN-NEXT:    retq # encoding: [0xc3]
entry:
  %sub.i = fsub <8 x float> <float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00>, %a
  %0 = tail call <8 x float> @llvm.fma.v8f32(<8 x float> %sub.i, <8 x float> %b, <8 x float> %c) #2
  ret <8 x float> %0
}

define <4 x double> @test_mm256_fnmadd_pd(<4 x double> %a, <4 x double> %b, <4 x double> %c) {
; CHECK-FMA-LABEL: test_mm256_fnmadd_pd:
; CHECK-FMA:       # %bb.0: # %entry
; CHECK-FMA-NEXT:    vfnmadd213pd %ymm2, %ymm1, %ymm0 # encoding: [0xc4,0xe2,0xf5,0xac,0xc2]
; CHECK-FMA-NEXT:    # ymm0 = -(ymm1 * ymm0) + ymm2
; CHECK-FMA-NEXT:    retq # encoding: [0xc3]
;
; CHECK-AVX512VL-LABEL: test_mm256_fnmadd_pd:
; CHECK-AVX512VL:       # %bb.0: # %entry
; CHECK-AVX512VL-NEXT:    vfnmadd213pd %ymm2, %ymm1, %ymm0 # EVEX TO VEX Compression encoding: [0xc4,0xe2,0xf5,0xac,0xc2]
; CHECK-AVX512VL-NEXT:    # ymm0 = -(ymm1 * ymm0) + ymm2
; CHECK-AVX512VL-NEXT:    retq # encoding: [0xc3]
;
; CHECK-FMA-WIN-LABEL: test_mm256_fnmadd_pd:
; CHECK-FMA-WIN:       # %bb.0: # %entry
; CHECK-FMA-WIN-NEXT:    vmovapd (%rcx), %ymm1 # encoding: [0xc5,0xfd,0x28,0x09]
; CHECK-FMA-WIN-NEXT:    vmovapd (%rdx), %ymm0 # encoding: [0xc5,0xfd,0x28,0x02]
; CHECK-FMA-WIN-NEXT:    vfnmadd213pd (%r8), %ymm1, %ymm0 # encoding: [0xc4,0xc2,0xf5,0xac,0x00]
; CHECK-FMA-WIN-NEXT:    # ymm0 = -(ymm1 * ymm0) + mem
; CHECK-FMA-WIN-NEXT:    retq # encoding: [0xc3]
entry:
  %sub.i = fsub <4 x double> <double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00>, %a
  %0 = tail call <4 x double> @llvm.fma.v4f64(<4 x double> %sub.i, <4 x double> %b, <4 x double> %c) #2
  ret <4 x double> %0
}

define <8 x float> @test_mm256_fnmsub_ps(<8 x float> %a, <8 x float> %b, <8 x float> %c) {
; CHECK-FMA-LABEL: test_mm256_fnmsub_ps:
; CHECK-FMA:       # %bb.0: # %entry
; CHECK-FMA-NEXT:    vfnmsub213ps %ymm2, %ymm1, %ymm0 # encoding: [0xc4,0xe2,0x75,0xae,0xc2]
; CHECK-FMA-NEXT:    # ymm0 = -(ymm1 * ymm0) - ymm2
; CHECK-FMA-NEXT:    retq # encoding: [0xc3]
;
; CHECK-AVX512VL-LABEL: test_mm256_fnmsub_ps:
; CHECK-AVX512VL:       # %bb.0: # %entry
; CHECK-AVX512VL-NEXT:    vfnmsub213ps %ymm2, %ymm1, %ymm0 # EVEX TO VEX Compression encoding: [0xc4,0xe2,0x75,0xae,0xc2]
; CHECK-AVX512VL-NEXT:    # ymm0 = -(ymm1 * ymm0) - ymm2
; CHECK-AVX512VL-NEXT:    retq # encoding: [0xc3]
;
; CHECK-FMA-WIN-LABEL: test_mm256_fnmsub_ps:
; CHECK-FMA-WIN:       # %bb.0: # %entry
; CHECK-FMA-WIN-NEXT:    vmovaps (%rcx), %ymm1 # encoding: [0xc5,0xfc,0x28,0x09]
; CHECK-FMA-WIN-NEXT:    vmovaps (%rdx), %ymm0 # encoding: [0xc5,0xfc,0x28,0x02]
; CHECK-FMA-WIN-NEXT:    vfnmsub213ps (%r8), %ymm1, %ymm0 # encoding: [0xc4,0xc2,0x75,0xae,0x00]
; CHECK-FMA-WIN-NEXT:    # ymm0 = -(ymm1 * ymm0) - mem
; CHECK-FMA-WIN-NEXT:    retq # encoding: [0xc3]
entry:
  %sub.i = fsub <8 x float> <float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00>, %a
  %sub1.i = fsub <8 x float> <float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00>, %c
  %0 = tail call <8 x float> @llvm.fma.v8f32(<8 x float> %sub.i, <8 x float> %b, <8 x float> %sub1.i) #2
  ret <8 x float> %0
}

define <4 x double> @test_mm256_fnmsub_pd(<4 x double> %a, <4 x double> %b, <4 x double> %c) {
; CHECK-FMA-LABEL: test_mm256_fnmsub_pd:
; CHECK-FMA:       # %bb.0: # %entry
; CHECK-FMA-NEXT:    vfnmsub213pd %ymm2, %ymm1, %ymm0 # encoding: [0xc4,0xe2,0xf5,0xae,0xc2]
; CHECK-FMA-NEXT:    # ymm0 = -(ymm1 * ymm0) - ymm2
; CHECK-FMA-NEXT:    retq # encoding: [0xc3]
;
; CHECK-AVX512VL-LABEL: test_mm256_fnmsub_pd:
; CHECK-AVX512VL:       # %bb.0: # %entry
; CHECK-AVX512VL-NEXT:    vfnmsub213pd %ymm2, %ymm1, %ymm0 # EVEX TO VEX Compression encoding: [0xc4,0xe2,0xf5,0xae,0xc2]
; CHECK-AVX512VL-NEXT:    # ymm0 = -(ymm1 * ymm0) - ymm2
; CHECK-AVX512VL-NEXT:    retq # encoding: [0xc3]
;
; CHECK-FMA-WIN-LABEL: test_mm256_fnmsub_pd:
; CHECK-FMA-WIN:       # %bb.0: # %entry
; CHECK-FMA-WIN-NEXT:    vmovapd (%rcx), %ymm1 # encoding: [0xc5,0xfd,0x28,0x09]
; CHECK-FMA-WIN-NEXT:    vmovapd (%rdx), %ymm0 # encoding: [0xc5,0xfd,0x28,0x02]
; CHECK-FMA-WIN-NEXT:    vfnmsub213pd (%r8), %ymm1, %ymm0 # encoding: [0xc4,0xc2,0xf5,0xae,0x00]
; CHECK-FMA-WIN-NEXT:    # ymm0 = -(ymm1 * ymm0) - mem
; CHECK-FMA-WIN-NEXT:    retq # encoding: [0xc3]
entry:
  %sub.i = fsub <4 x double> <double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00>, %a
  %sub1.i = fsub <4 x double> <double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00>, %c
  %0 = tail call <4 x double> @llvm.fma.v4f64(<4 x double> %sub.i, <4 x double> %b, <4 x double> %sub1.i) #2
  ret <4 x double> %0
}

define <8 x float> @test_mm256_fmaddsub_ps(<8 x float> %a, <8 x float> %b, <8 x float> %c) {
; CHECK-FMA-LABEL: test_mm256_fmaddsub_ps:
; CHECK-FMA:       # %bb.0: # %entry
; CHECK-FMA-NEXT:    vfmaddsub213ps %ymm2, %ymm1, %ymm0 # encoding: [0xc4,0xe2,0x75,0xa6,0xc2]
; CHECK-FMA-NEXT:    # ymm0 = (ymm1 * ymm0) +/- ymm2
; CHECK-FMA-NEXT:    retq # encoding: [0xc3]
;
; CHECK-AVX512VL-LABEL: test_mm256_fmaddsub_ps:
; CHECK-AVX512VL:       # %bb.0: # %entry
; CHECK-AVX512VL-NEXT:    vfmaddsub213ps %ymm2, %ymm1, %ymm0 # EVEX TO VEX Compression encoding: [0xc4,0xe2,0x75,0xa6,0xc2]
; CHECK-AVX512VL-NEXT:    # ymm0 = (ymm1 * ymm0) +/- ymm2
; CHECK-AVX512VL-NEXT:    retq # encoding: [0xc3]
;
; CHECK-FMA-WIN-LABEL: test_mm256_fmaddsub_ps:
; CHECK-FMA-WIN:       # %bb.0: # %entry
; CHECK-FMA-WIN-NEXT:    vmovaps (%rcx), %ymm1 # encoding: [0xc5,0xfc,0x28,0x09]
; CHECK-FMA-WIN-NEXT:    vmovaps (%rdx), %ymm0 # encoding: [0xc5,0xfc,0x28,0x02]
; CHECK-FMA-WIN-NEXT:    vfmaddsub213ps (%r8), %ymm1, %ymm0 # encoding: [0xc4,0xc2,0x75,0xa6,0x00]
; CHECK-FMA-WIN-NEXT:    # ymm0 = (ymm1 * ymm0) +/- mem
; CHECK-FMA-WIN-NEXT:    retq # encoding: [0xc3]
entry:
  %0 = tail call <8 x float> @llvm.fma.v8f32(<8 x float> %a, <8 x float> %b, <8 x float> %c) #2
  %1 = fsub <8 x float> <float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00>, %c
  %2 = tail call <8 x float> @llvm.fma.v8f32(<8 x float> %a, <8 x float> %b, <8 x float> %1) #2
  %3 = shufflevector <8 x float> %2, <8 x float> %0, <8 x i32> <i32 0, i32 9, i32 2, i32 11, i32 4, i32 13, i32 6, i32 15>
  ret <8 x float> %3
}

define <4 x double> @test_mm256_fmaddsub_pd(<4 x double> %a, <4 x double> %b, <4 x double> %c) {
; CHECK-FMA-LABEL: test_mm256_fmaddsub_pd:
; CHECK-FMA:       # %bb.0: # %entry
; CHECK-FMA-NEXT:    vfmaddsub213pd %ymm2, %ymm1, %ymm0 # encoding: [0xc4,0xe2,0xf5,0xa6,0xc2]
; CHECK-FMA-NEXT:    # ymm0 = (ymm1 * ymm0) +/- ymm2
; CHECK-FMA-NEXT:    retq # encoding: [0xc3]
;
; CHECK-AVX512VL-LABEL: test_mm256_fmaddsub_pd:
; CHECK-AVX512VL:       # %bb.0: # %entry
; CHECK-AVX512VL-NEXT:    vfmaddsub213pd %ymm2, %ymm1, %ymm0 # EVEX TO VEX Compression encoding: [0xc4,0xe2,0xf5,0xa6,0xc2]
; CHECK-AVX512VL-NEXT:    # ymm0 = (ymm1 * ymm0) +/- ymm2
; CHECK-AVX512VL-NEXT:    retq # encoding: [0xc3]
;
; CHECK-FMA-WIN-LABEL: test_mm256_fmaddsub_pd:
; CHECK-FMA-WIN:       # %bb.0: # %entry
; CHECK-FMA-WIN-NEXT:    vmovapd (%rcx), %ymm1 # encoding: [0xc5,0xfd,0x28,0x09]
; CHECK-FMA-WIN-NEXT:    vmovapd (%rdx), %ymm0 # encoding: [0xc5,0xfd,0x28,0x02]
; CHECK-FMA-WIN-NEXT:    vfmaddsub213pd (%r8), %ymm1, %ymm0 # encoding: [0xc4,0xc2,0xf5,0xa6,0x00]
; CHECK-FMA-WIN-NEXT:    # ymm0 = (ymm1 * ymm0) +/- mem
; CHECK-FMA-WIN-NEXT:    retq # encoding: [0xc3]
entry:
  %0 = tail call <4 x double> @llvm.fma.v4f64(<4 x double> %a, <4 x double> %b, <4 x double> %c) #2
  %1 = fsub <4 x double> <double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00>, %c
  %2 = tail call <4 x double> @llvm.fma.v4f64(<4 x double> %a, <4 x double> %b, <4 x double> %1) #2
  %3 = shufflevector <4 x double> %2, <4 x double> %0, <4 x i32> <i32 0, i32 5, i32 2, i32 7>
  ret <4 x double> %3
}

define <8 x float> @test_mm256_fmsubadd_ps(<8 x float> %a, <8 x float> %b, <8 x float> %c) {
; CHECK-FMA-LABEL: test_mm256_fmsubadd_ps:
; CHECK-FMA:       # %bb.0: # %entry
; CHECK-FMA-NEXT:    vfmsubadd213ps %ymm2, %ymm1, %ymm0 # encoding: [0xc4,0xe2,0x75,0xa7,0xc2]
; CHECK-FMA-NEXT:    # ymm0 = (ymm1 * ymm0) -/+ ymm2
; CHECK-FMA-NEXT:    retq # encoding: [0xc3]
;
; CHECK-AVX512VL-LABEL: test_mm256_fmsubadd_ps:
; CHECK-AVX512VL:       # %bb.0: # %entry
; CHECK-AVX512VL-NEXT:    vfmsubadd213ps %ymm2, %ymm1, %ymm0 # EVEX TO VEX Compression encoding: [0xc4,0xe2,0x75,0xa7,0xc2]
; CHECK-AVX512VL-NEXT:    # ymm0 = (ymm1 * ymm0) -/+ ymm2
; CHECK-AVX512VL-NEXT:    retq # encoding: [0xc3]
;
; CHECK-FMA-WIN-LABEL: test_mm256_fmsubadd_ps:
; CHECK-FMA-WIN:       # %bb.0: # %entry
; CHECK-FMA-WIN-NEXT:    vmovaps (%rcx), %ymm1 # encoding: [0xc5,0xfc,0x28,0x09]
; CHECK-FMA-WIN-NEXT:    vmovaps (%rdx), %ymm0 # encoding: [0xc5,0xfc,0x28,0x02]
; CHECK-FMA-WIN-NEXT:    vfmsubadd213ps (%r8), %ymm1, %ymm0 # encoding: [0xc4,0xc2,0x75,0xa7,0x00]
; CHECK-FMA-WIN-NEXT:    # ymm0 = (ymm1 * ymm0) -/+ mem
; CHECK-FMA-WIN-NEXT:    retq # encoding: [0xc3]
entry:
  %sub.i = fsub <8 x float> <float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00>, %c
  %0 = tail call <8 x float> @llvm.fma.v8f32(<8 x float> %a, <8 x float> %b, <8 x float> %sub.i) #2
  %1 = tail call <8 x float> @llvm.fma.v8f32(<8 x float> %a, <8 x float> %b, <8 x float> %c) #2
  %2 = shufflevector <8 x float> %1, <8 x float> %0, <8 x i32> <i32 0, i32 9, i32 2, i32 11, i32 4, i32 13, i32 6, i32 15>
  ret <8 x float> %2
}

define <4 x double> @test_mm256_fmsubadd_pd(<4 x double> %a, <4 x double> %b, <4 x double> %c) {
; CHECK-FMA-LABEL: test_mm256_fmsubadd_pd:
; CHECK-FMA:       # %bb.0: # %entry
; CHECK-FMA-NEXT:    vfmsubadd213pd %ymm2, %ymm1, %ymm0 # encoding: [0xc4,0xe2,0xf5,0xa7,0xc2]
; CHECK-FMA-NEXT:    # ymm0 = (ymm1 * ymm0) -/+ ymm2
; CHECK-FMA-NEXT:    retq # encoding: [0xc3]
;
; CHECK-AVX512VL-LABEL: test_mm256_fmsubadd_pd:
; CHECK-AVX512VL:       # %bb.0: # %entry
; CHECK-AVX512VL-NEXT:    vfmsubadd213pd %ymm2, %ymm1, %ymm0 # EVEX TO VEX Compression encoding: [0xc4,0xe2,0xf5,0xa7,0xc2]
; CHECK-AVX512VL-NEXT:    # ymm0 = (ymm1 * ymm0) -/+ ymm2
; CHECK-AVX512VL-NEXT:    retq # encoding: [0xc3]
;
; CHECK-FMA-WIN-LABEL: test_mm256_fmsubadd_pd:
; CHECK-FMA-WIN:       # %bb.0: # %entry
; CHECK-FMA-WIN-NEXT:    vmovapd (%rcx), %ymm1 # encoding: [0xc5,0xfd,0x28,0x09]
; CHECK-FMA-WIN-NEXT:    vmovapd (%rdx), %ymm0 # encoding: [0xc5,0xfd,0x28,0x02]
; CHECK-FMA-WIN-NEXT:    vfmsubadd213pd (%r8), %ymm1, %ymm0 # encoding: [0xc4,0xc2,0xf5,0xa7,0x00]
; CHECK-FMA-WIN-NEXT:    # ymm0 = (ymm1 * ymm0) -/+ mem
; CHECK-FMA-WIN-NEXT:    retq # encoding: [0xc3]
entry:
  %sub.i = fsub <4 x double> <double -0.000000e+00, double -0.000000e+00, double -0.000000e+00, double -0.000000e+00>, %c
  %0 = tail call <4 x double> @llvm.fma.v4f64(<4 x double> %a, <4 x double> %b, <4 x double> %sub.i) #2
  %1 = tail call <4 x double> @llvm.fma.v4f64(<4 x double> %a, <4 x double> %b, <4 x double> %c) #2
  %2 = shufflevector <4 x double> %1, <4 x double> %0, <4 x i32> <i32 0, i32 5, i32 2, i32 7>
  ret <4 x double> %2
}

declare <4 x float> @llvm.fma.v4f32(<4 x float>, <4 x float>, <4 x float>) #1
declare <2 x double> @llvm.fma.v2f64(<2 x double>, <2 x double>, <2 x double>) #1
declare float @llvm.fma.f32(float, float, float) #1
declare double @llvm.fma.f64(double, double, double) #1
declare <8 x float> @llvm.fma.v8f32(<8 x float>, <8 x float>, <8 x float>) #1
declare <4 x double> @llvm.fma.v4f64(<4 x double>, <4 x double>, <4 x double>) #1
