/*
 * Decompiled with CFR 0.152.
 */
package com.github.andrewoma.dexx.collection;

import com.github.andrewoma.dexx.collection.ConsList;
import com.github.andrewoma.dexx.collection.ConsListIterator;
import com.github.andrewoma.dexx.collection.LinkedList;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class Cons<E>
extends ConsList<E> {
    private E head;
    private ConsList<E> tail;

    Cons(E head, ConsList<E> tail) {
        this.head = head;
        this.tail = tail;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    @Nullable
    public E first() {
        return this.head;
    }

    @Override
    @NotNull
    public ConsList<E> tail() {
        return this.tail;
    }

    @Override
    @NotNull
    public ConsList<E> set(int i, E elem) {
        ArrayList before = new ArrayList(i);
        ConsListIterator iterator = (ConsListIterator)this.iterator();
        for (int count = 0; count < i && iterator.hasNext(); ++count) {
            before.add(iterator.next());
        }
        if (!iterator.hasNext()) {
            throw new IndexOutOfBoundsException(String.valueOf(i));
        }
        iterator.next();
        LinkedList result = iterator.current;
        result = ((ConsList)result).prepend((Object)elem);
        for (int index = before.size() - 1; index >= 0; --index) {
            result = ((ConsList)result).prepend(before.get(index));
        }
        return result;
    }

    @Override
    @NotNull
    public ConsList<E> append(E elem) {
        ArrayList current = new ArrayList();
        for (Object e : this) {
            current.add(e);
        }
        LinkedList result = Cons.empty();
        result = ((ConsList)result).append((Object)elem);
        for (int i = current.size() - 1; i >= 0; --i) {
            result = ((ConsList)result).prepend(current.get(i));
        }
        return result;
    }

    @Override
    @NotNull
    public ConsList<E> drop(int number) {
        ConsListIterator iterator = (ConsListIterator)this.iterator();
        for (int count = 0; count < number && iterator.hasNext(); ++count) {
            iterator.next();
        }
        return iterator.current;
    }

    @Override
    @NotNull
    public ConsList<E> take(int number) {
        ArrayList top = new ArrayList(Math.max(0, number));
        ConsListIterator iterator = (ConsListIterator)this.iterator();
        for (int count = 0; count < number && iterator.hasNext(); ++count) {
            top.add(iterator.next());
        }
        LinkedList result = Cons.empty();
        for (int i = top.size() - 1; i >= 0; --i) {
            result = result.prepend(top.get(i));
        }
        return result;
    }

    @Override
    @NotNull
    public ConsList<E> range(int from, boolean fromInclusive, int to, boolean toInclusive) {
        from = fromInclusive ? from : from + 1;
        to = toInclusive ? to + 1 : to;
        return ((ConsList)this.drop(from)).take(to - from);
    }

    @Override
    public E get(int i) {
        int count = 0;
        for (Object e : this) {
            if (i != count++) continue;
            return e;
        }
        throw new IndexOutOfBoundsException(String.valueOf(i));
    }

    @Override
    @Nullable
    public E last() {
        E last = null;
        for (Object e : this) {
            last = e;
        }
        return last;
    }
}

