/*
 * unity-webapps-presence-manager.c
 * Copyright (C) Canonical LTD 2011
 *
 * Author: Robert Carr <racarr@canonical.com>
 * 
 unity-webapps is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * unity-webapps is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.";
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gstdio.h>
#include <gio/gio.h>

#include "unity-webapps-presence-manager.h"

#include "../unity-webapps-debug.h"

struct _UnityWebappsPresenceManagerPrivate {
  gpointer fill;
};


enum {
  PRESENCE_CHANGED,
  LAST_SIGNAL
};

static guint signals[LAST_SIGNAL] = { 0 };

G_DEFINE_ABSTRACT_TYPE(UnityWebappsPresenceManager, unity_webapps_presence_manager, G_TYPE_OBJECT)

#define UNITY_WEBAPPS_PRESENCE_MANAGER_GET_PRIVATE(object) (G_TYPE_INSTANCE_GET_PRIVATE ((object), UNITY_WEBAPPS_TYPE_PRESENCE_MANAGER, UnityWebappsPresenceManagerPrivate))

static void
unity_webapps_presence_manager_class_init (UnityWebappsPresenceManagerClass *klass)
{
  GObjectClass *object_class = G_OBJECT_CLASS (klass);
  
  g_type_class_add_private (object_class, sizeof(UnityWebappsPresenceManagerPrivate));
  
  signals[PRESENCE_CHANGED] = g_signal_new ("presence-changed",
					    UNITY_WEBAPPS_TYPE_PRESENCE_MANAGER,
					    G_SIGNAL_RUN_LAST,
					    0,
					    NULL,
					    NULL,
					    NULL,
					    G_TYPE_NONE,
					    2,
					    G_TYPE_STRING,
					    G_TYPE_STRING);
}

static void
unity_webapps_presence_manager_init (UnityWebappsPresenceManager *manager)
{
  manager->priv = UNITY_WEBAPPS_PRESENCE_MANAGER_GET_PRIVATE (manager);
}

gboolean
unity_webapps_presence_manager_get_presence (UnityWebappsPresenceManager *manager,
					     gchar **status, 
					     gchar **message)
{
  return UNITY_WEBAPPS_PRESENCE_MANAGER_GET_CLASS (manager)->get_presence (manager, status, message);
}
