#include <stdlib.h>
#include <stdio.h>

#include "unity-webapps-service.h"
#include "unity-webapps-context.h"

#include "uwa-test-client.h"

#define ICON_URL "http://www.ubuntu.com/sites/www.ubuntu.com/files/active/02_ubuntu/U_homepage/picto-desktop.png"

static GMainLoop *mainloop = NULL;

static void
context_ready (UnityWebappsContext *context, gpointer user_data)
{
  unity_webapps_music_player_init (context, "Test player");
  
  
  unity_webapps_music_player_set_can_go_next (context, TRUE);
  g_assert (unity_webapps_music_player_get_can_go_next (context) == TRUE);
  unity_webapps_music_player_set_can_go_next (context, FALSE);
  g_assert (unity_webapps_music_player_get_can_go_next (context) == FALSE);

  unity_webapps_music_player_set_can_go_previous (context, TRUE);
  g_assert (unity_webapps_music_player_get_can_go_previous (context) == TRUE);
  unity_webapps_music_player_set_can_go_previous (context, FALSE);
  g_assert (unity_webapps_music_player_get_can_go_previous (context) == FALSE);

  unity_webapps_music_player_set_can_play (context, TRUE);
  g_assert (unity_webapps_music_player_get_can_play (context) == TRUE);
  unity_webapps_music_player_set_can_play (context, FALSE);
  g_assert (unity_webapps_music_player_get_can_play (context) == FALSE);

  unity_webapps_music_player_set_can_pause (context, TRUE);
  g_assert (unity_webapps_music_player_get_can_pause (context) == TRUE);
  unity_webapps_music_player_set_can_pause (context, FALSE);
  g_assert (unity_webapps_music_player_get_can_pause (context) == FALSE);
  
  unity_webapps_music_player_set_playback_state (context, 0);
  
  printf("Verified music player properties \n");
  

  uwa_emit_test_finished ();
}

gint
main (gint argc, gchar **argv)
{
  UnityWebappsService *service;
  
  g_type_init ();
  
  service = unity_webapps_service_new ();
  
  unity_webapps_context_new (service, "Test", "test.ts", ICON_URL, NULL, context_ready, NULL);
  
  mainloop = g_main_loop_new (NULL, FALSE);
  
  g_main_loop_run (mainloop);
  
  return 0;  
}
