/* This file is autogenerated by sid_tables.py from sid.h. Do not edit directly. */

/*
 * Copyright 2015 Advanced Micro Devices, Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * on the rights to use, copy, modify, merge, publish, distribute, sub
 * license, and/or sell copies of the Software, and to permit persons to whom
 * the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHOR(S) AND/OR THEIR SUPPLIERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
 * OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
 * USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 */

#ifndef SID_TABLES_H
#define SID_TABLES_H

struct si_field {
        unsigned name_offset;
        unsigned mask;
        unsigned num_values;
        unsigned values_offset; /* offset into sid_strings_offsets */
};

struct si_reg {
        unsigned name_offset;
        unsigned offset;
        unsigned num_fields;
        unsigned fields_offset;
};

struct si_packet3 {
        unsigned name_offset;
        unsigned op;
};

static const struct si_packet3 packet3_table[] = {
	{0, PKT3_NOP},
	{4, PKT3_SET_BASE},
	{13, PKT3_CLEAR_STATE},
	{25, PKT3_INDEX_BUFFER_SIZE},
	{43, PKT3_DISPATCH_DIRECT},
	{59, PKT3_DISPATCH_INDIRECT},
	{77, PKT3_OCCLUSION_QUERY},
	{93, PKT3_SET_PREDICATION},
	{109, PKT3_COND_EXEC},
	{119, PKT3_PRED_EXEC},
	{129, PKT3_DRAW_INDIRECT},
	{143, PKT3_DRAW_INDEX_INDIRECT},
	{163, PKT3_INDEX_BASE},
	{174, PKT3_DRAW_INDEX_2},
	{187, PKT3_CONTEXT_CONTROL},
	{203, PKT3_INDEX_TYPE},
	{214, PKT3_DRAW_INDIRECT_MULTI},
	{234, PKT3_DRAW_INDEX_AUTO},
	{250, PKT3_DRAW_INDEX_IMMD},
	{266, PKT3_NUM_INSTANCES},
	{280, PKT3_DRAW_INDEX_MULTI_AUTO},
	{302, PKT3_INDIRECT_BUFFER_SI},
	{321, PKT3_INDIRECT_BUFFER_CONST},
	{343, PKT3_STRMOUT_BUFFER_UPDATE},
	{365, PKT3_DRAW_INDEX_OFFSET_2},
	{385, PKT3_WRITE_DATA},
	{396, PKT3_DRAW_INDEX_INDIRECT_MULTI},
	{422, PKT3_MEM_SEMAPHORE},
	{436, PKT3_MPEG_INDEX},
	{447, PKT3_WAIT_REG_MEM},
	{460, PKT3_MEM_WRITE},
	{470, PKT3_INDIRECT_BUFFER_CIK},
	{490, PKT3_COPY_DATA},
	{500, PKT3_PFP_SYNC_ME},
	{512, PKT3_SURFACE_SYNC},
	{525, PKT3_ME_INITIALIZE},
	{539, PKT3_COND_WRITE},
	{550, PKT3_EVENT_WRITE},
	{562, PKT3_EVENT_WRITE_EOP},
	{578, PKT3_RELEASE_MEM},
	{590, PKT3_ONE_REG_WRITE},
	{604, PKT3_ACQUIRE_MEM},
	{616, PKT3_SET_CONFIG_REG},
	{631, PKT3_SET_CONTEXT_REG},
	{647, PKT3_SET_SH_REG},
	{658, PKT3_SET_SH_REG_OFFSET},
	{676, PKT3_SET_UCONFIG_REG},
	{692, PKT3_LOAD_CONST_RAM},
	{707, PKT3_WRITE_CONST_RAM},
	{723, PKT3_DUMP_CONST_RAM},
	{738, PKT3_INCREMENT_CE_COUNTER},
	{759, PKT3_INCREMENT_DE_COUNTER},
	{780, PKT3_WAIT_ON_CE_COUNTER},
	{799, PKT3_IT_OPCODE_C},
	{811, PKT3_CP_DMA},
	{818, PKT3_DMA_DATA},
};

static const struct si_reg sid_reg_table[] = {
	{827, R_2C3_DRAW_INDEX_LOC, 2, 0},
	{195, R_370_CONTROL, 4, 2},
	{842, R_371_DST_ADDR_LO},
	{854, R_372_DST_ADDR_HI},
	{866, R_3F0_IB_BASE_LO},
	{877, R_3F1_IB_BASE_HI},
	{195, R_3F2_CONTROL, 3, 6},
	{888, R_410_CP_DMA_WORD0, 1, 9},
	{901, R_411_CP_DMA_WORD1, 5, 10},
	{914, R_412_CP_DMA_WORD2, 1, 15},
	{927, R_413_CP_DMA_WORD3, 1, 16},
	{940, R_414_COMMAND, 11, 17},
	{948, R_500_DMA_DATA_WORD0, 4, 28},
	{963, R_501_SRC_ADDR_LO},
	{975, R_502_SRC_ADDR_HI},
	{842, R_503_DST_ADDR_LO},
	{854, R_504_DST_ADDR_HI},
	{987, R_000E4C_SRBM_STATUS2, 21, 32},
	{1000, R_000E50_SRBM_STATUS, 20, 53},
	{1012, R_000E54_SRBM_STATUS3, 16, 73},
	{1025, R_00D034_SDMA0_STATUS_REG, 29, 89},
	{1042, R_00D834_SDMA1_STATUS_REG, 29, 89},
	{1059, R_008008_GRBM_STATUS2, 18, 118},
	{1072, R_008010_GRBM_STATUS, 24, 136},
	{1084, R_00802C_GRBM_GFX_INDEX, 6, 160},
	{1099, R_0084FC_CP_STRMOUT_CNTL, 1, 166},
	{1115, R_0085F0_CP_COHER_CNTL, 19, 167},
	{1129, R_0085F4_CP_COHER_SIZE},
	{1143, R_0085F8_CP_COHER_BASE},
	{1157, R_008014_GRBM_STATUS_SE0, 11, 186},
	{1173, R_008018_GRBM_STATUS_SE1, 11, 197},
	{1189, R_008038_GRBM_STATUS_SE2, 11, 208},
	{1205, R_00803C_GRBM_STATUS_SE3, 11, 219},
	{1099, R_0300FC_CP_STRMOUT_CNTL, 1, 230},
	{1221, R_0301E4_CP_COHER_BASE_HI, 1, 231},
	{1238, R_0301EC_CP_COHER_START_DELAY, 1, 232},
	{1115, R_0301F0_CP_COHER_CNTL, 27, 233},
	{1129, R_0301F4_CP_COHER_SIZE},
	{1143, R_0301F8_CP_COHER_BASE},
	{1259, R_0301FC_CP_COHER_STATUS, 4, 260},
	{1275, R_008210_CP_CPC_STATUS, 15, 264},
	{1289, R_008214_CP_CPC_BUSY_STAT, 28, 279},
	{1306, R_008218_CP_CPC_STALLED_STAT1, 14, 307},
	{1327, R_00821C_CP_CPF_STATUS, 21, 321},
	{1341, R_008220_CP_CPF_BUSY_STAT, 31, 342},
	{1358, R_008224_CP_CPF_STALLED_STAT1, 9, 373},
	{1379, R_030230_CP_COHER_SIZE_HI, 1, 382},
	{1396, R_0088B0_VGT_VTX_VECT_EJECT_REG, 1, 383},
	{1419, R_0088C4_VGT_CACHE_INVALIDATION, 3, 384},
	{1442, R_0088C8_VGT_ESGS_RING_SIZE},
	{1461, R_0088CC_VGT_GSVS_RING_SIZE},
	{1480, R_0088D4_VGT_GS_VERTEX_REUSE, 1, 387},
	{1500, R_008958_VGT_PRIMITIVE_TYPE, 1, 388},
	{1519, R_00895C_VGT_INDEX_TYPE, 1, 389},
	{1534, R_008960_VGT_STRMOUT_BUFFER_FILLED_SIZE_0},
	{1567, R_008964_VGT_STRMOUT_BUFFER_FILLED_SIZE_1},
	{1600, R_008968_VGT_STRMOUT_BUFFER_FILLED_SIZE_2},
	{1633, R_00896C_VGT_STRMOUT_BUFFER_FILLED_SIZE_3},
	{1666, R_008970_VGT_NUM_INDICES},
	{1682, R_008974_VGT_NUM_INSTANCES},
	{1700, R_008988_VGT_TF_RING_SIZE, 1, 390},
	{1717, R_0089B0_VGT_HS_OFFCHIP_PARAM, 1, 391},
	{1738, R_0089B8_VGT_TF_MEMORY_BASE},
	{1757, R_008A14_PA_CL_ENHANCE, 4, 392},
	{1771, R_008A60_PA_SU_LINE_STIPPLE_VALUE, 1, 396},
	{1796, R_008B10_PA_SC_LINE_STIPPLE_STATE, 2, 397},
	{1821, R_008670_CP_STALLED_STAT3, 19, 399},
	{1838, R_008674_CP_STALLED_STAT1, 16, 418},
	{1855, R_008678_CP_STALLED_STAT2, 29, 434},
	{1872, R_008680_CP_STAT, 23, 463},
	{1084, R_030800_GRBM_GFX_INDEX, 6, 486},
	{1442, R_030900_VGT_ESGS_RING_SIZE},
	{1461, R_030904_VGT_GSVS_RING_SIZE},
	{1500, R_030908_VGT_PRIMITIVE_TYPE, 1, 492},
	{1519, R_03090C_VGT_INDEX_TYPE, 1, 493},
	{1534, R_030910_VGT_STRMOUT_BUFFER_FILLED_SIZE_0},
	{1567, R_030914_VGT_STRMOUT_BUFFER_FILLED_SIZE_1},
	{1600, R_030918_VGT_STRMOUT_BUFFER_FILLED_SIZE_2},
	{1633, R_03091C_VGT_STRMOUT_BUFFER_FILLED_SIZE_3},
	{1666, R_030930_VGT_NUM_INDICES},
	{1682, R_030934_VGT_NUM_INSTANCES},
	{1700, R_030938_VGT_TF_RING_SIZE, 1, 494},
	{1717, R_03093C_VGT_HS_OFFCHIP_PARAM, 2, 495},
	{1738, R_030940_VGT_TF_MEMORY_BASE},
	{1771, R_030A00_PA_SU_LINE_STIPPLE_VALUE, 1, 497},
	{1796, R_030A04_PA_SC_LINE_STIPPLE_STATE, 2, 498},
	{1880, R_030A10_PA_SC_SCREEN_EXTENT_MIN_0, 2, 500},
	{1906, R_030A14_PA_SC_SCREEN_EXTENT_MAX_0, 2, 502},
	{1932, R_030A18_PA_SC_SCREEN_EXTENT_MIN_1, 2, 504},
	{1958, R_030A2C_PA_SC_SCREEN_EXTENT_MAX_1, 2, 506},
	{1984, R_008BF0_PA_SC_ENHANCE, 9, 508},
	{1998, R_008C08_SQC_CACHES, 2, 517},
	{1998, R_030D20_SQC_CACHES, 3, 519},
	{2009, R_008C0C_SQ_RANDOM_WAVE_PRI, 3, 522},
	{2028, R_008DFC_SQ_EXP_0, 6, 525},
	{2037, R_030E00_TA_CS_BC_BASE_ADDR},
	{2056, R_030E04_TA_CS_BC_BASE_ADDR_HI, 1, 531},
	{2078, R_030F00_DB_OCCLUSION_COUNT0_LOW},
	{2102, R_030F04_DB_OCCLUSION_COUNT0_HI, 1, 532},
	{2125, R_008F00_SQ_BUF_RSRC_WORD0},
	{2143, R_008F04_SQ_BUF_RSRC_WORD1, 4, 533},
	{2161, R_030F08_DB_OCCLUSION_COUNT1_LOW},
	{2185, R_008F08_SQ_BUF_RSRC_WORD2},
	{2203, R_030F0C_DB_OCCLUSION_COUNT1_HI, 1, 537},
	{2226, R_008F0C_SQ_BUF_RSRC_WORD3, 14, 538},
	{2244, R_030F10_DB_OCCLUSION_COUNT2_LOW},
	{2268, R_008F10_SQ_IMG_RSRC_WORD0},
	{2286, R_030F14_DB_OCCLUSION_COUNT2_HI, 1, 552},
	{2309, R_008F14_SQ_IMG_RSRC_WORD1, 5, 553},
	{2327, R_030F18_DB_OCCLUSION_COUNT3_LOW},
	{2351, R_008F18_SQ_IMG_RSRC_WORD2, 4, 558},
	{2369, R_030F1C_DB_OCCLUSION_COUNT3_HI, 1, 562},
	{2392, R_008F1C_SQ_IMG_RSRC_WORD3, 11, 563},
	{2410, R_008F20_SQ_IMG_RSRC_WORD4, 2, 574},
	{2428, R_008F24_SQ_IMG_RSRC_WORD5, 2, 576},
	{2446, R_008F28_SQ_IMG_RSRC_WORD6, 8, 578},
	{2464, R_008F2C_SQ_IMG_RSRC_WORD7},
	{2482, R_008F30_SQ_IMG_SAMP_WORD0, 14, 586},
	{2500, R_008F34_SQ_IMG_SAMP_WORD1, 4, 600},
	{2518, R_008F38_SQ_IMG_SAMP_WORD2, 10, 604},
	{2536, R_008F3C_SQ_IMG_SAMP_WORD3, 3, 614},
	{2554, R_0090DC_SPI_DYN_GPR_LOCK_EN, 5, 617},
	{2574, R_0090E0_SPI_STATIC_THREAD_MGMT_1, 2, 622},
	{2599, R_0090E4_SPI_STATIC_THREAD_MGMT_2, 2, 624},
	{2624, R_0090E8_SPI_STATIC_THREAD_MGMT_3, 1, 626},
	{2649, R_0090EC_SPI_PS_MAX_WAVE_ID, 1, 627},
	{2649, R_0090E8_SPI_PS_MAX_WAVE_ID, 1, 628},
	{2668, R_0090F0_SPI_ARB_PRIORITY, 3, 629},
	{2668, R_00C700_SPI_ARB_PRIORITY, 8, 632},
	{2685, R_0090F4_SPI_ARB_CYCLES_0, 2, 640},
	{2702, R_0090F8_SPI_ARB_CYCLES_1, 1, 642},
	{2719, R_008F40_SQ_FLAT_SCRATCH_WORD0, 1, 643},
	{2741, R_008F44_SQ_FLAT_SCRATCH_WORD1, 1, 644},
	{2763, R_030FF8_DB_ZPASS_COUNT_LOW},
	{2782, R_030FFC_DB_ZPASS_COUNT_HI, 1, 645},
	{2800, R_009100_SPI_CONFIG_CNTL, 5, 646},
	{2816, R_00913C_SPI_CONFIG_CNTL_1, 5, 651},
	{2834, R_00936C_SPI_RESOURCE_RESERVE_CU_AB_0, 12, 656},
	{2037, R_00950C_TA_CS_BC_BASE_ADDR},
	{2863, R_009858_DB_SUBTILE_CONTROL, 10, 668},
	{2882, R_0098F8_GB_ADDR_CONFIG, 9, 678},
	{2897, R_009910_GB_TILE_MODE0, 10, 687},
	{2911, R_009914_GB_TILE_MODE1, 10, 687},
	{2925, R_009918_GB_TILE_MODE2, 10, 687},
	{2939, R_00991C_GB_TILE_MODE3, 10, 687},
	{2953, R_009920_GB_TILE_MODE4, 10, 687},
	{2967, R_009924_GB_TILE_MODE5, 10, 687},
	{2981, R_009928_GB_TILE_MODE6, 10, 687},
	{2995, R_00992C_GB_TILE_MODE7, 10, 687},
	{3009, R_009930_GB_TILE_MODE8, 10, 687},
	{3023, R_009934_GB_TILE_MODE9, 10, 687},
	{3037, R_009938_GB_TILE_MODE10, 10, 687},
	{3052, R_00993C_GB_TILE_MODE11, 10, 687},
	{3067, R_009940_GB_TILE_MODE12, 10, 687},
	{3082, R_009944_GB_TILE_MODE13, 10, 687},
	{3097, R_009948_GB_TILE_MODE14, 10, 687},
	{3112, R_00994C_GB_TILE_MODE15, 10, 687},
	{3127, R_009950_GB_TILE_MODE16, 10, 687},
	{3142, R_009954_GB_TILE_MODE17, 10, 687},
	{3157, R_009958_GB_TILE_MODE18, 10, 687},
	{3172, R_00995C_GB_TILE_MODE19, 10, 687},
	{3187, R_009960_GB_TILE_MODE20, 10, 687},
	{3202, R_009964_GB_TILE_MODE21, 10, 687},
	{3217, R_009968_GB_TILE_MODE22, 10, 687},
	{3232, R_00996C_GB_TILE_MODE23, 10, 687},
	{3247, R_009970_GB_TILE_MODE24, 10, 687},
	{3262, R_009974_GB_TILE_MODE25, 10, 687},
	{3277, R_009978_GB_TILE_MODE26, 10, 687},
	{3292, R_00997C_GB_TILE_MODE27, 10, 687},
	{3307, R_009980_GB_TILE_MODE28, 10, 687},
	{3322, R_009984_GB_TILE_MODE29, 10, 687},
	{3337, R_009988_GB_TILE_MODE30, 10, 687},
	{3352, R_00998C_GB_TILE_MODE31, 10, 687},
	{3367, R_009990_GB_MACROTILE_MODE0, 4, 697},
	{3386, R_009994_GB_MACROTILE_MODE1, 4, 697},
	{3405, R_009998_GB_MACROTILE_MODE2, 4, 697},
	{3424, R_00999C_GB_MACROTILE_MODE3, 4, 697},
	{3443, R_0099A0_GB_MACROTILE_MODE4, 4, 697},
	{3462, R_0099A4_GB_MACROTILE_MODE5, 4, 697},
	{3481, R_0099A8_GB_MACROTILE_MODE6, 4, 697},
	{3500, R_0099AC_GB_MACROTILE_MODE7, 4, 697},
	{3519, R_0099B0_GB_MACROTILE_MODE8, 4, 697},
	{3538, R_0099B4_GB_MACROTILE_MODE9, 4, 697},
	{3557, R_0099B8_GB_MACROTILE_MODE10, 4, 697},
	{3577, R_0099BC_GB_MACROTILE_MODE11, 4, 697},
	{3597, R_0099C0_GB_MACROTILE_MODE12, 4, 697},
	{3617, R_0099C4_GB_MACROTILE_MODE13, 4, 697},
	{3637, R_0099C8_GB_MACROTILE_MODE14, 4, 697},
	{3657, R_0099CC_GB_MACROTILE_MODE15, 4, 697},
	{3677, R_00B000_SPI_SHADER_TBA_LO_PS},
	{3698, R_00B004_SPI_SHADER_TBA_HI_PS, 1, 701},
	{3719, R_00B008_SPI_SHADER_TMA_LO_PS},
	{3740, R_00B00C_SPI_SHADER_TMA_HI_PS, 1, 702},
	{3761, R_00B01C_SPI_SHADER_PGM_RSRC3_PS, 3, 703},
	{3785, R_00B020_SPI_SHADER_PGM_LO_PS},
	{3806, R_00B024_SPI_SHADER_PGM_HI_PS, 1, 706},
	{3827, R_00B028_SPI_SHADER_PGM_RSRC1_PS, 11, 707},
	{3851, R_00B02C_SPI_SHADER_PGM_RSRC2_PS, 7, 718},
	{3875, R_00B030_SPI_SHADER_USER_DATA_PS_0},
	{3901, R_00B034_SPI_SHADER_USER_DATA_PS_1},
	{3927, R_00B038_SPI_SHADER_USER_DATA_PS_2},
	{3953, R_00B03C_SPI_SHADER_USER_DATA_PS_3},
	{3979, R_00B040_SPI_SHADER_USER_DATA_PS_4},
	{4005, R_00B044_SPI_SHADER_USER_DATA_PS_5},
	{4031, R_00B048_SPI_SHADER_USER_DATA_PS_6},
	{4057, R_00B04C_SPI_SHADER_USER_DATA_PS_7},
	{4083, R_00B050_SPI_SHADER_USER_DATA_PS_8},
	{4109, R_00B054_SPI_SHADER_USER_DATA_PS_9},
	{4135, R_00B058_SPI_SHADER_USER_DATA_PS_10},
	{4162, R_00B05C_SPI_SHADER_USER_DATA_PS_11},
	{4189, R_00B060_SPI_SHADER_USER_DATA_PS_12},
	{4216, R_00B064_SPI_SHADER_USER_DATA_PS_13},
	{4243, R_00B068_SPI_SHADER_USER_DATA_PS_14},
	{4270, R_00B06C_SPI_SHADER_USER_DATA_PS_15},
	{4297, R_00B100_SPI_SHADER_TBA_LO_VS},
	{4318, R_00B104_SPI_SHADER_TBA_HI_VS, 1, 725},
	{4339, R_00B108_SPI_SHADER_TMA_LO_VS},
	{4360, R_00B10C_SPI_SHADER_TMA_HI_VS, 1, 726},
	{4381, R_00B118_SPI_SHADER_PGM_RSRC3_VS, 3, 727},
	{4405, R_00B11C_SPI_SHADER_LATE_ALLOC_VS, 1, 730},
	{4430, R_00B120_SPI_SHADER_PGM_LO_VS},
	{4451, R_00B124_SPI_SHADER_PGM_HI_VS, 1, 731},
	{4472, R_00B128_SPI_SHADER_PGM_RSRC1_VS, 12, 732},
	{4496, R_00B12C_SPI_SHADER_PGM_RSRC2_VS, 12, 744},
	{4520, R_00B130_SPI_SHADER_USER_DATA_VS_0},
	{4546, R_00B134_SPI_SHADER_USER_DATA_VS_1},
	{4572, R_00B138_SPI_SHADER_USER_DATA_VS_2},
	{4598, R_00B13C_SPI_SHADER_USER_DATA_VS_3},
	{4624, R_00B140_SPI_SHADER_USER_DATA_VS_4},
	{4650, R_00B144_SPI_SHADER_USER_DATA_VS_5},
	{4676, R_00B148_SPI_SHADER_USER_DATA_VS_6},
	{4702, R_00B14C_SPI_SHADER_USER_DATA_VS_7},
	{4728, R_00B150_SPI_SHADER_USER_DATA_VS_8},
	{4754, R_00B154_SPI_SHADER_USER_DATA_VS_9},
	{4780, R_00B158_SPI_SHADER_USER_DATA_VS_10},
	{4807, R_00B15C_SPI_SHADER_USER_DATA_VS_11},
	{4834, R_00B160_SPI_SHADER_USER_DATA_VS_12},
	{4861, R_00B164_SPI_SHADER_USER_DATA_VS_13},
	{4888, R_00B168_SPI_SHADER_USER_DATA_VS_14},
	{4915, R_00B16C_SPI_SHADER_USER_DATA_VS_15},
	{4942, R_00B200_SPI_SHADER_TBA_LO_GS},
	{4963, R_00B204_SPI_SHADER_TBA_HI_GS, 1, 756},
	{4984, R_00B208_SPI_SHADER_TMA_LO_GS},
	{5005, R_00B20C_SPI_SHADER_TMA_HI_GS, 1, 757},
	{5026, R_00B21C_SPI_SHADER_PGM_RSRC3_GS, 4, 758},
	{5050, R_00B220_SPI_SHADER_PGM_LO_GS},
	{5071, R_00B224_SPI_SHADER_PGM_HI_GS, 1, 762},
	{5092, R_00B228_SPI_SHADER_PGM_RSRC1_GS, 11, 763},
	{5116, R_00B22C_SPI_SHADER_PGM_RSRC2_GS, 5, 774},
	{5140, R_00B230_SPI_SHADER_USER_DATA_GS_0},
	{5166, R_00B234_SPI_SHADER_USER_DATA_GS_1},
	{5192, R_00B238_SPI_SHADER_USER_DATA_GS_2},
	{5218, R_00B23C_SPI_SHADER_USER_DATA_GS_3},
	{5244, R_00B240_SPI_SHADER_USER_DATA_GS_4},
	{5270, R_00B244_SPI_SHADER_USER_DATA_GS_5},
	{5296, R_00B248_SPI_SHADER_USER_DATA_GS_6},
	{5322, R_00B24C_SPI_SHADER_USER_DATA_GS_7},
	{5348, R_00B250_SPI_SHADER_USER_DATA_GS_8},
	{5374, R_00B254_SPI_SHADER_USER_DATA_GS_9},
	{5400, R_00B258_SPI_SHADER_USER_DATA_GS_10},
	{5427, R_00B25C_SPI_SHADER_USER_DATA_GS_11},
	{5454, R_00B260_SPI_SHADER_USER_DATA_GS_12},
	{5481, R_00B264_SPI_SHADER_USER_DATA_GS_13},
	{5508, R_00B268_SPI_SHADER_USER_DATA_GS_14},
	{5535, R_00B26C_SPI_SHADER_USER_DATA_GS_15},
	{5562, R_00B300_SPI_SHADER_TBA_LO_ES},
	{5583, R_00B304_SPI_SHADER_TBA_HI_ES, 1, 779},
	{5604, R_00B308_SPI_SHADER_TMA_LO_ES},
	{5625, R_00B30C_SPI_SHADER_TMA_HI_ES, 1, 780},
	{5646, R_00B31C_SPI_SHADER_PGM_RSRC3_ES, 4, 781},
	{5670, R_00B320_SPI_SHADER_PGM_LO_ES},
	{5691, R_00B324_SPI_SHADER_PGM_HI_ES, 1, 785},
	{5712, R_00B328_SPI_SHADER_PGM_RSRC1_ES, 12, 786},
	{5736, R_00B32C_SPI_SHADER_PGM_RSRC2_ES, 7, 798},
	{5760, R_00B330_SPI_SHADER_USER_DATA_ES_0},
	{5786, R_00B334_SPI_SHADER_USER_DATA_ES_1},
	{5812, R_00B338_SPI_SHADER_USER_DATA_ES_2},
	{5838, R_00B33C_SPI_SHADER_USER_DATA_ES_3},
	{5864, R_00B340_SPI_SHADER_USER_DATA_ES_4},
	{5890, R_00B344_SPI_SHADER_USER_DATA_ES_5},
	{5916, R_00B348_SPI_SHADER_USER_DATA_ES_6},
	{5942, R_00B34C_SPI_SHADER_USER_DATA_ES_7},
	{5968, R_00B350_SPI_SHADER_USER_DATA_ES_8},
	{5994, R_00B354_SPI_SHADER_USER_DATA_ES_9},
	{6020, R_00B358_SPI_SHADER_USER_DATA_ES_10},
	{6047, R_00B35C_SPI_SHADER_USER_DATA_ES_11},
	{6074, R_00B360_SPI_SHADER_USER_DATA_ES_12},
	{6101, R_00B364_SPI_SHADER_USER_DATA_ES_13},
	{6128, R_00B368_SPI_SHADER_USER_DATA_ES_14},
	{6155, R_00B36C_SPI_SHADER_USER_DATA_ES_15},
	{6182, R_00B400_SPI_SHADER_TBA_LO_HS},
	{6203, R_00B404_SPI_SHADER_TBA_HI_HS, 1, 805},
	{6224, R_00B408_SPI_SHADER_TMA_LO_HS},
	{6245, R_00B40C_SPI_SHADER_TMA_HI_HS, 1, 806},
	{6266, R_00B41C_SPI_SHADER_PGM_RSRC3_HS, 3, 807},
	{6290, R_00B420_SPI_SHADER_PGM_LO_HS},
	{6311, R_00B424_SPI_SHADER_PGM_HI_HS, 1, 810},
	{6332, R_00B428_SPI_SHADER_PGM_RSRC1_HS, 10, 811},
	{6356, R_00B42C_SPI_SHADER_PGM_RSRC2_HS, 7, 821},
	{6380, R_00B430_SPI_SHADER_USER_DATA_HS_0},
	{6406, R_00B434_SPI_SHADER_USER_DATA_HS_1},
	{6432, R_00B438_SPI_SHADER_USER_DATA_HS_2},
	{6458, R_00B43C_SPI_SHADER_USER_DATA_HS_3},
	{6484, R_00B440_SPI_SHADER_USER_DATA_HS_4},
	{6510, R_00B444_SPI_SHADER_USER_DATA_HS_5},
	{6536, R_00B448_SPI_SHADER_USER_DATA_HS_6},
	{6562, R_00B44C_SPI_SHADER_USER_DATA_HS_7},
	{6588, R_00B450_SPI_SHADER_USER_DATA_HS_8},
	{6614, R_00B454_SPI_SHADER_USER_DATA_HS_9},
	{6640, R_00B458_SPI_SHADER_USER_DATA_HS_10},
	{6667, R_00B45C_SPI_SHADER_USER_DATA_HS_11},
	{6694, R_00B460_SPI_SHADER_USER_DATA_HS_12},
	{6721, R_00B464_SPI_SHADER_USER_DATA_HS_13},
	{6748, R_00B468_SPI_SHADER_USER_DATA_HS_14},
	{6775, R_00B46C_SPI_SHADER_USER_DATA_HS_15},
	{6802, R_00B500_SPI_SHADER_TBA_LO_LS},
	{6823, R_00B504_SPI_SHADER_TBA_HI_LS, 1, 828},
	{6844, R_00B508_SPI_SHADER_TMA_LO_LS},
	{6865, R_00B50C_SPI_SHADER_TMA_HI_LS, 1, 829},
	{6886, R_00B51C_SPI_SHADER_PGM_RSRC3_LS, 4, 830},
	{6910, R_00B520_SPI_SHADER_PGM_LO_LS},
	{6931, R_00B524_SPI_SHADER_PGM_HI_LS, 1, 834},
	{6952, R_00B528_SPI_SHADER_PGM_RSRC1_LS, 11, 835},
	{6976, R_00B52C_SPI_SHADER_PGM_RSRC2_LS, 6, 846},
	{7000, R_00B530_SPI_SHADER_USER_DATA_LS_0},
	{7026, R_00B534_SPI_SHADER_USER_DATA_LS_1},
	{7052, R_00B538_SPI_SHADER_USER_DATA_LS_2},
	{7078, R_00B53C_SPI_SHADER_USER_DATA_LS_3},
	{7104, R_00B540_SPI_SHADER_USER_DATA_LS_4},
	{7130, R_00B544_SPI_SHADER_USER_DATA_LS_5},
	{7156, R_00B548_SPI_SHADER_USER_DATA_LS_6},
	{7182, R_00B54C_SPI_SHADER_USER_DATA_LS_7},
	{7208, R_00B550_SPI_SHADER_USER_DATA_LS_8},
	{7234, R_00B554_SPI_SHADER_USER_DATA_LS_9},
	{7260, R_00B558_SPI_SHADER_USER_DATA_LS_10},
	{7287, R_00B55C_SPI_SHADER_USER_DATA_LS_11},
	{7314, R_00B560_SPI_SHADER_USER_DATA_LS_12},
	{7341, R_00B564_SPI_SHADER_USER_DATA_LS_13},
	{7368, R_00B568_SPI_SHADER_USER_DATA_LS_14},
	{7395, R_00B56C_SPI_SHADER_USER_DATA_LS_15},
	{7422, R_00B800_COMPUTE_DISPATCH_INITIATOR, 12, 852},
	{7449, R_00B804_COMPUTE_DIM_X},
	{7463, R_00B808_COMPUTE_DIM_Y},
	{7477, R_00B80C_COMPUTE_DIM_Z},
	{7491, R_00B810_COMPUTE_START_X},
	{7507, R_00B814_COMPUTE_START_Y},
	{7523, R_00B818_COMPUTE_START_Z},
	{7539, R_00B81C_COMPUTE_NUM_THREAD_X, 2, 864},
	{7560, R_00B820_COMPUTE_NUM_THREAD_Y, 2, 866},
	{7581, R_00B824_COMPUTE_NUM_THREAD_Z, 2, 868},
	{7602, R_00B82C_COMPUTE_MAX_WAVE_ID, 1, 870},
	{7622, R_00B828_COMPUTE_PIPELINESTAT_ENABLE, 1, 871},
	{7650, R_00B82C_COMPUTE_PERFCOUNT_ENABLE, 1, 872},
	{7675, R_00B830_COMPUTE_PGM_LO},
	{7690, R_00B834_COMPUTE_PGM_HI, 2, 873},
	{7705, R_00B838_COMPUTE_TBA_LO},
	{7720, R_00B83C_COMPUTE_TBA_HI, 1, 875},
	{7735, R_00B840_COMPUTE_TMA_LO},
	{7750, R_00B844_COMPUTE_TMA_HI, 1, 876},
	{7765, R_00B848_COMPUTE_PGM_RSRC1, 10, 877},
	{7783, R_00B84C_COMPUTE_PGM_RSRC2, 11, 887},
	{7801, R_00B850_COMPUTE_VMID, 1, 898},
	{7814, R_00B854_COMPUTE_RESOURCE_LIMITS, 7, 899},
	{7838, R_00B858_COMPUTE_STATIC_THREAD_MGMT_SE0, 2, 906},
	{7869, R_00B85C_COMPUTE_STATIC_THREAD_MGMT_SE1, 2, 908},
	{7900, R_00B860_COMPUTE_TMPRING_SIZE, 2, 910},
	{7921, R_00B864_COMPUTE_STATIC_THREAD_MGMT_SE2, 2, 912},
	{7952, R_00B868_COMPUTE_STATIC_THREAD_MGMT_SE3, 2, 914},
	{7983, R_00B86C_COMPUTE_RESTART_X},
	{8001, R_00B870_COMPUTE_RESTART_Y},
	{8019, R_00B874_COMPUTE_RESTART_Z},
	{8037, R_00B87C_COMPUTE_MISC_RESERVED, 5, 916},
	{8059, R_00B880_COMPUTE_DISPATCH_ID},
	{8079, R_00B884_COMPUTE_THREADGROUP_ID},
	{8102, R_00B888_COMPUTE_RELAUNCH, 3, 921},
	{8119, R_00B88C_COMPUTE_WAVE_RESTORE_ADDR_LO},
	{8148, R_00B890_COMPUTE_WAVE_RESTORE_ADDR_HI, 1, 924},
	{8177, R_00B894_COMPUTE_WAVE_RESTORE_CONTROL, 2, 925},
	{8206, R_00B900_COMPUTE_USER_DATA_0},
	{8226, R_00B904_COMPUTE_USER_DATA_1},
	{8246, R_00B908_COMPUTE_USER_DATA_2},
	{8266, R_00B90C_COMPUTE_USER_DATA_3},
	{8286, R_00B910_COMPUTE_USER_DATA_4},
	{8306, R_00B914_COMPUTE_USER_DATA_5},
	{8326, R_00B918_COMPUTE_USER_DATA_6},
	{8346, R_00B91C_COMPUTE_USER_DATA_7},
	{8366, R_00B920_COMPUTE_USER_DATA_8},
	{8386, R_00B924_COMPUTE_USER_DATA_9},
	{8406, R_00B928_COMPUTE_USER_DATA_10},
	{8427, R_00B92C_COMPUTE_USER_DATA_11},
	{8448, R_00B930_COMPUTE_USER_DATA_12},
	{8469, R_00B934_COMPUTE_USER_DATA_13},
	{8490, R_00B938_COMPUTE_USER_DATA_14},
	{8511, R_00B93C_COMPUTE_USER_DATA_15},
	{8532, R_00B9FC_COMPUTE_NOWHERE},
	{8548, R_034000_CPG_PERFCOUNTER1_LO},
	{8568, R_034004_CPG_PERFCOUNTER1_HI},
	{8588, R_034008_CPG_PERFCOUNTER0_LO},
	{8608, R_03400C_CPG_PERFCOUNTER0_HI},
	{8628, R_034010_CPC_PERFCOUNTER1_LO},
	{8648, R_034014_CPC_PERFCOUNTER1_HI},
	{8668, R_034018_CPC_PERFCOUNTER0_LO},
	{8688, R_03401C_CPC_PERFCOUNTER0_HI},
	{8708, R_034020_CPF_PERFCOUNTER1_LO},
	{8728, R_034024_CPF_PERFCOUNTER1_HI},
	{8748, R_034028_CPF_PERFCOUNTER0_LO},
	{8768, R_03402C_CPF_PERFCOUNTER0_HI},
	{8788, R_034100_GRBM_PERFCOUNTER0_LO},
	{8809, R_034104_GRBM_PERFCOUNTER0_HI},
	{8830, R_03410C_GRBM_PERFCOUNTER1_LO},
	{8851, R_034110_GRBM_PERFCOUNTER1_HI},
	{8872, R_034114_GRBM_SE0_PERFCOUNTER_LO},
	{8896, R_034118_GRBM_SE0_PERFCOUNTER_HI},
	{8920, R_03411C_GRBM_SE1_PERFCOUNTER_LO},
	{8944, R_034120_GRBM_SE1_PERFCOUNTER_HI},
	{8968, R_034124_GRBM_SE2_PERFCOUNTER_LO},
	{8992, R_034128_GRBM_SE2_PERFCOUNTER_HI},
	{9016, R_03412C_GRBM_SE3_PERFCOUNTER_LO},
	{9040, R_034130_GRBM_SE3_PERFCOUNTER_HI},
	{9064, R_034200_WD_PERFCOUNTER0_LO},
	{9083, R_034204_WD_PERFCOUNTER0_HI},
	{9102, R_034208_WD_PERFCOUNTER1_LO},
	{9121, R_03420C_WD_PERFCOUNTER1_HI},
	{9140, R_034210_WD_PERFCOUNTER2_LO},
	{9159, R_034214_WD_PERFCOUNTER2_HI},
	{9178, R_034218_WD_PERFCOUNTER3_LO},
	{9197, R_03421C_WD_PERFCOUNTER3_HI},
	{9216, R_034220_IA_PERFCOUNTER0_LO},
	{9235, R_034224_IA_PERFCOUNTER0_HI},
	{9254, R_034228_IA_PERFCOUNTER1_LO},
	{9273, R_03422C_IA_PERFCOUNTER1_HI},
	{9292, R_034230_IA_PERFCOUNTER2_LO},
	{9311, R_034234_IA_PERFCOUNTER2_HI},
	{9330, R_034238_IA_PERFCOUNTER3_LO},
	{9349, R_03423C_IA_PERFCOUNTER3_HI},
	{9368, R_034240_VGT_PERFCOUNTER0_LO},
	{9388, R_034244_VGT_PERFCOUNTER0_HI},
	{9408, R_034248_VGT_PERFCOUNTER1_LO},
	{9428, R_03424C_VGT_PERFCOUNTER1_HI},
	{9448, R_034250_VGT_PERFCOUNTER2_LO},
	{9468, R_034254_VGT_PERFCOUNTER2_HI},
	{9488, R_034258_VGT_PERFCOUNTER3_LO},
	{9508, R_03425C_VGT_PERFCOUNTER3_HI},
	{9528, R_034400_PA_SU_PERFCOUNTER0_LO},
	{9550, R_034404_PA_SU_PERFCOUNTER0_HI, 1, 927},
	{9572, R_034408_PA_SU_PERFCOUNTER1_LO},
	{9594, R_03440C_PA_SU_PERFCOUNTER1_HI, 1, 927},
	{9616, R_034410_PA_SU_PERFCOUNTER2_LO},
	{9638, R_034414_PA_SU_PERFCOUNTER2_HI, 1, 927},
	{9660, R_034418_PA_SU_PERFCOUNTER3_LO},
	{9682, R_03441C_PA_SU_PERFCOUNTER3_HI, 1, 927},
	{9704, R_034500_PA_SC_PERFCOUNTER0_LO},
	{9726, R_034504_PA_SC_PERFCOUNTER0_HI},
	{9748, R_034508_PA_SC_PERFCOUNTER1_LO},
	{9770, R_03450C_PA_SC_PERFCOUNTER1_HI},
	{9792, R_034510_PA_SC_PERFCOUNTER2_LO},
	{9814, R_034514_PA_SC_PERFCOUNTER2_HI},
	{9836, R_034518_PA_SC_PERFCOUNTER3_LO},
	{9858, R_03451C_PA_SC_PERFCOUNTER3_HI},
	{9880, R_034520_PA_SC_PERFCOUNTER4_LO},
	{9902, R_034524_PA_SC_PERFCOUNTER4_HI},
	{9924, R_034528_PA_SC_PERFCOUNTER5_LO},
	{9946, R_03452C_PA_SC_PERFCOUNTER5_HI},
	{9968, R_034530_PA_SC_PERFCOUNTER6_LO},
	{9990, R_034534_PA_SC_PERFCOUNTER6_HI},
	{10012, R_034538_PA_SC_PERFCOUNTER7_LO},
	{10034, R_03453C_PA_SC_PERFCOUNTER7_HI},
	{10056, R_034600_SPI_PERFCOUNTER0_HI},
	{10076, R_034604_SPI_PERFCOUNTER0_LO},
	{10096, R_034608_SPI_PERFCOUNTER1_HI},
	{10116, R_03460C_SPI_PERFCOUNTER1_LO},
	{10136, R_034610_SPI_PERFCOUNTER2_HI},
	{10156, R_034614_SPI_PERFCOUNTER2_LO},
	{10176, R_034618_SPI_PERFCOUNTER3_HI},
	{10196, R_03461C_SPI_PERFCOUNTER3_LO},
	{10216, R_034620_SPI_PERFCOUNTER4_HI},
	{10236, R_034624_SPI_PERFCOUNTER4_LO},
	{10256, R_034628_SPI_PERFCOUNTER5_HI},
	{10276, R_03462C_SPI_PERFCOUNTER5_LO},
	{10296, R_034700_SQ_PERFCOUNTER0_LO},
	{10315, R_034704_SQ_PERFCOUNTER0_HI},
	{10334, R_034708_SQ_PERFCOUNTER1_LO},
	{10353, R_03470C_SQ_PERFCOUNTER1_HI},
	{10372, R_034710_SQ_PERFCOUNTER2_LO},
	{10391, R_034714_SQ_PERFCOUNTER2_HI},
	{10410, R_034718_SQ_PERFCOUNTER3_LO},
	{10429, R_03471C_SQ_PERFCOUNTER3_HI},
	{10448, R_034720_SQ_PERFCOUNTER4_LO},
	{10467, R_034724_SQ_PERFCOUNTER4_HI},
	{10486, R_034728_SQ_PERFCOUNTER5_LO},
	{10505, R_03472C_SQ_PERFCOUNTER5_HI},
	{10524, R_034730_SQ_PERFCOUNTER6_LO},
	{10543, R_034734_SQ_PERFCOUNTER6_HI},
	{10562, R_034738_SQ_PERFCOUNTER7_LO},
	{10581, R_03473C_SQ_PERFCOUNTER7_HI},
	{10600, R_034740_SQ_PERFCOUNTER8_LO},
	{10619, R_034744_SQ_PERFCOUNTER8_HI},
	{10638, R_034748_SQ_PERFCOUNTER9_LO},
	{10657, R_03474C_SQ_PERFCOUNTER9_HI},
	{10676, R_034750_SQ_PERFCOUNTER10_LO},
	{10696, R_034754_SQ_PERFCOUNTER10_HI},
	{10716, R_034758_SQ_PERFCOUNTER11_LO},
	{10736, R_03475C_SQ_PERFCOUNTER11_HI},
	{10756, R_034760_SQ_PERFCOUNTER12_LO},
	{10776, R_034764_SQ_PERFCOUNTER12_HI},
	{10796, R_034768_SQ_PERFCOUNTER13_LO},
	{10816, R_03476C_SQ_PERFCOUNTER13_HI},
	{10836, R_034770_SQ_PERFCOUNTER14_LO},
	{10856, R_034774_SQ_PERFCOUNTER14_HI},
	{10876, R_034778_SQ_PERFCOUNTER15_LO},
	{10896, R_03477C_SQ_PERFCOUNTER15_HI},
	{10916, R_034900_SX_PERFCOUNTER0_LO},
	{10935, R_034904_SX_PERFCOUNTER0_HI},
	{10954, R_034908_SX_PERFCOUNTER1_LO},
	{10973, R_03490C_SX_PERFCOUNTER1_HI},
	{10992, R_034910_SX_PERFCOUNTER2_LO},
	{11011, R_034914_SX_PERFCOUNTER2_HI},
	{11030, R_034918_SX_PERFCOUNTER3_LO},
	{11049, R_03491C_SX_PERFCOUNTER3_HI},
	{11068, R_034A00_GDS_PERFCOUNTER0_LO},
	{11088, R_034A04_GDS_PERFCOUNTER0_HI},
	{11108, R_034A08_GDS_PERFCOUNTER1_LO},
	{11128, R_034A0C_GDS_PERFCOUNTER1_HI},
	{11148, R_034A10_GDS_PERFCOUNTER2_LO},
	{11168, R_034A14_GDS_PERFCOUNTER2_HI},
	{11188, R_034A18_GDS_PERFCOUNTER3_LO},
	{11208, R_034A1C_GDS_PERFCOUNTER3_HI},
	{11228, R_034B00_TA_PERFCOUNTER0_LO},
	{11247, R_034B04_TA_PERFCOUNTER0_HI},
	{11266, R_034B08_TA_PERFCOUNTER1_LO},
	{11285, R_034B0C_TA_PERFCOUNTER1_HI},
	{11304, R_034C00_TD_PERFCOUNTER0_LO},
	{11323, R_034C04_TD_PERFCOUNTER0_HI},
	{11342, R_034C08_TD_PERFCOUNTER1_LO},
	{11361, R_034C0C_TD_PERFCOUNTER1_HI},
	{11380, R_034D00_TCP_PERFCOUNTER0_LO},
	{11400, R_034D04_TCP_PERFCOUNTER0_HI},
	{11420, R_034D08_TCP_PERFCOUNTER1_LO},
	{11440, R_034D0C_TCP_PERFCOUNTER1_HI},
	{11460, R_034D10_TCP_PERFCOUNTER2_LO},
	{11480, R_034D14_TCP_PERFCOUNTER2_HI},
	{11500, R_034D18_TCP_PERFCOUNTER3_LO},
	{11520, R_034D1C_TCP_PERFCOUNTER3_HI},
	{11540, R_034E00_TCC_PERFCOUNTER0_LO},
	{11560, R_034E04_TCC_PERFCOUNTER0_HI},
	{11580, R_034E08_TCC_PERFCOUNTER1_LO},
	{11600, R_034E0C_TCC_PERFCOUNTER1_HI},
	{11620, R_034E10_TCC_PERFCOUNTER2_LO},
	{11640, R_034E14_TCC_PERFCOUNTER2_HI},
	{11660, R_034E18_TCC_PERFCOUNTER3_LO},
	{11680, R_034E1C_TCC_PERFCOUNTER3_HI},
	{11700, R_034E40_TCA_PERFCOUNTER0_LO},
	{11720, R_034E44_TCA_PERFCOUNTER0_HI},
	{11740, R_034E48_TCA_PERFCOUNTER1_LO},
	{11760, R_034E4C_TCA_PERFCOUNTER1_HI},
	{11780, R_034E50_TCA_PERFCOUNTER2_LO},
	{11800, R_034E54_TCA_PERFCOUNTER2_HI},
	{11820, R_034E58_TCA_PERFCOUNTER3_LO},
	{11840, R_034E5C_TCA_PERFCOUNTER3_HI},
	{11860, R_035018_CB_PERFCOUNTER0_LO},
	{11879, R_03501C_CB_PERFCOUNTER0_HI},
	{11898, R_035020_CB_PERFCOUNTER1_LO},
	{11917, R_035024_CB_PERFCOUNTER1_HI},
	{11936, R_035028_CB_PERFCOUNTER2_LO},
	{11955, R_03502C_CB_PERFCOUNTER2_HI},
	{11974, R_035030_CB_PERFCOUNTER3_LO},
	{11993, R_035034_CB_PERFCOUNTER3_HI},
	{12012, R_035100_DB_PERFCOUNTER0_LO},
	{12031, R_035104_DB_PERFCOUNTER0_HI},
	{12050, R_035108_DB_PERFCOUNTER1_LO},
	{12069, R_03510C_DB_PERFCOUNTER1_HI},
	{12088, R_035110_DB_PERFCOUNTER2_LO},
	{12107, R_035114_DB_PERFCOUNTER2_HI},
	{12126, R_035118_DB_PERFCOUNTER3_LO},
	{12145, R_03511C_DB_PERFCOUNTER3_HI},
	{12164, R_035200_RLC_PERFCOUNTER0_LO},
	{12184, R_035204_RLC_PERFCOUNTER0_HI},
	{12204, R_035208_RLC_PERFCOUNTER1_LO},
	{12224, R_03520C_RLC_PERFCOUNTER1_HI},
	{12244, R_036000_CPG_PERFCOUNTER1_SELECT, 3, 928},
	{12268, R_036004_CPG_PERFCOUNTER0_SELECT1, 2, 931},
	{12293, R_036008_CPG_PERFCOUNTER0_SELECT, 3, 928},
	{12317, R_03600C_CPC_PERFCOUNTER1_SELECT, 3, 933},
	{12341, R_036010_CPC_PERFCOUNTER0_SELECT1, 2, 936},
	{12366, R_036014_CPF_PERFCOUNTER1_SELECT, 3, 938},
	{12390, R_036018_CPF_PERFCOUNTER0_SELECT1, 2, 941},
	{12415, R_03601C_CPF_PERFCOUNTER0_SELECT, 3, 938},
	{12439, R_036020_CP_PERFMON_CNTL, 4, 943},
	{12455, R_036024_CPC_PERFCOUNTER0_SELECT, 3, 933},
	{12479, R_036100_GRBM_PERFCOUNTER0_SELECT, 19, 947},
	{12504, R_036104_GRBM_PERFCOUNTER1_SELECT, 19, 947},
	{12529, R_036108_GRBM_SE0_PERFCOUNTER_SELECT, 12, 966},
	{12557, R_03610C_GRBM_SE1_PERFCOUNTER_SELECT, 12, 978},
	{12585, R_036110_GRBM_SE2_PERFCOUNTER_SELECT, 12, 990},
	{12613, R_036114_GRBM_SE3_PERFCOUNTER_SELECT, 12, 1002},
	{12641, R_036200_WD_PERFCOUNTER0_SELECT, 2, 1014},
	{12664, R_036204_WD_PERFCOUNTER1_SELECT, 2, 1014},
	{12687, R_036208_WD_PERFCOUNTER2_SELECT, 2, 1014},
	{12710, R_03620C_WD_PERFCOUNTER3_SELECT, 2, 1014},
	{12733, R_036210_IA_PERFCOUNTER0_SELECT, 5, 1016},
	{12756, R_036214_IA_PERFCOUNTER1_SELECT, 5, 1016},
	{12779, R_036218_IA_PERFCOUNTER2_SELECT, 5, 1016},
	{12802, R_03621C_IA_PERFCOUNTER3_SELECT, 5, 1016},
	{12825, R_036220_IA_PERFCOUNTER0_SELECT1, 4, 1021},
	{12849, R_036230_VGT_PERFCOUNTER0_SELECT, 5, 1025},
	{12873, R_036234_VGT_PERFCOUNTER1_SELECT, 5, 1025},
	{12897, R_036238_VGT_PERFCOUNTER2_SELECT, 5, 1025},
	{12921, R_03623C_VGT_PERFCOUNTER3_SELECT, 5, 1025},
	{12945, R_036240_VGT_PERFCOUNTER0_SELECT1, 4, 1030},
	{12970, R_036244_VGT_PERFCOUNTER1_SELECT1},
	{12995, R_036250_VGT_PERFCOUNTER_SEID_MASK, 1, 1034},
	{13021, R_036400_PA_SU_PERFCOUNTER0_SELECT, 3, 1035},
	{13047, R_036404_PA_SU_PERFCOUNTER0_SELECT1, 2, 1038},
	{13074, R_036408_PA_SU_PERFCOUNTER1_SELECT, 3, 1035},
	{13100, R_03640C_PA_SU_PERFCOUNTER1_SELECT1},
	{13127, R_036410_PA_SU_PERFCOUNTER2_SELECT, 3, 1035},
	{13153, R_036414_PA_SU_PERFCOUNTER3_SELECT, 3, 1035},
	{13179, R_036500_PA_SC_PERFCOUNTER0_SELECT, 3, 1040},
	{13205, R_036504_PA_SC_PERFCOUNTER0_SELECT1, 2, 1043},
	{13232, R_036508_PA_SC_PERFCOUNTER1_SELECT, 3, 1040},
	{13258, R_03650C_PA_SC_PERFCOUNTER2_SELECT, 3, 1040},
	{13284, R_036510_PA_SC_PERFCOUNTER3_SELECT, 3, 1040},
	{13310, R_036514_PA_SC_PERFCOUNTER4_SELECT, 3, 1040},
	{13336, R_036518_PA_SC_PERFCOUNTER5_SELECT, 3, 1040},
	{13362, R_03651C_PA_SC_PERFCOUNTER6_SELECT, 3, 1040},
	{13388, R_036520_PA_SC_PERFCOUNTER7_SELECT, 3, 1040},
	{13414, R_036600_SPI_PERFCOUNTER0_SELECT, 3, 1045},
	{13438, R_036604_SPI_PERFCOUNTER1_SELECT, 3, 1045},
	{13462, R_036608_SPI_PERFCOUNTER2_SELECT, 3, 1045},
	{13486, R_03660C_SPI_PERFCOUNTER3_SELECT, 3, 1045},
	{13510, R_036610_SPI_PERFCOUNTER0_SELECT1, 2, 1048},
	{13535, R_036614_SPI_PERFCOUNTER1_SELECT1},
	{13560, R_036618_SPI_PERFCOUNTER2_SELECT1},
	{13585, R_03661C_SPI_PERFCOUNTER3_SELECT1},
	{13610, R_036620_SPI_PERFCOUNTER4_SELECT, 3, 1045},
	{13634, R_036624_SPI_PERFCOUNTER5_SELECT, 3, 1045},
	{13658, R_036628_SPI_PERFCOUNTER_BINS, 8, 1050},
	{13679, R_036700_SQ_PERFCOUNTER0_SELECT, 6, 1058},
	{13702, R_036704_SQ_PERFCOUNTER1_SELECT, 6, 1058},
	{13725, R_036708_SQ_PERFCOUNTER2_SELECT, 6, 1058},
	{13748, R_03670C_SQ_PERFCOUNTER3_SELECT, 6, 1058},
	{13771, R_036710_SQ_PERFCOUNTER4_SELECT, 6, 1058},
	{13794, R_036714_SQ_PERFCOUNTER5_SELECT, 6, 1058},
	{13817, R_036718_SQ_PERFCOUNTER6_SELECT, 6, 1058},
	{13840, R_03671C_SQ_PERFCOUNTER7_SELECT, 6, 1058},
	{13863, R_036720_SQ_PERFCOUNTER8_SELECT, 6, 1058},
	{13886, R_036724_SQ_PERFCOUNTER9_SELECT, 6, 1058},
	{13909, R_036728_SQ_PERFCOUNTER10_SELECT, 6, 1058},
	{13933, R_03672C_SQ_PERFCOUNTER11_SELECT, 6, 1058},
	{13957, R_036730_SQ_PERFCOUNTER12_SELECT, 6, 1058},
	{13981, R_036734_SQ_PERFCOUNTER13_SELECT, 6, 1058},
	{14005, R_036738_SQ_PERFCOUNTER14_SELECT, 6, 1058},
	{14029, R_03673C_SQ_PERFCOUNTER15_SELECT, 6, 1058},
	{14053, R_036780_SQ_PERFCOUNTER_CTRL, 9, 1064},
	{14073, R_036784_SQ_PERFCOUNTER_MASK, 2, 1073},
	{14093, R_036788_SQ_PERFCOUNTER_CTRL2, 1, 1075},
	{14114, R_036900_SX_PERFCOUNTER0_SELECT, 3, 1076},
	{14137, R_036904_SX_PERFCOUNTER1_SELECT, 3, 1076},
	{14160, R_036908_SX_PERFCOUNTER2_SELECT, 3, 1076},
	{14183, R_03690C_SX_PERFCOUNTER3_SELECT, 3, 1076},
	{14206, R_036910_SX_PERFCOUNTER0_SELECT1, 2, 1079},
	{14230, R_036914_SX_PERFCOUNTER1_SELECT1},
	{14254, R_036A00_GDS_PERFCOUNTER0_SELECT, 3, 1081},
	{14278, R_036A04_GDS_PERFCOUNTER1_SELECT, 3, 1081},
	{14302, R_036A08_GDS_PERFCOUNTER2_SELECT, 3, 1081},
	{14326, R_036A0C_GDS_PERFCOUNTER3_SELECT, 3, 1081},
	{14350, R_036A10_GDS_PERFCOUNTER0_SELECT1, 2, 1084},
	{14375, R_036B00_TA_PERFCOUNTER0_SELECT, 5, 1086},
	{14398, R_036B04_TA_PERFCOUNTER0_SELECT1, 4, 1091},
	{14422, R_036B08_TA_PERFCOUNTER1_SELECT, 5, 1086},
	{14445, R_036C00_TD_PERFCOUNTER0_SELECT, 5, 1095},
	{14468, R_036C04_TD_PERFCOUNTER0_SELECT1, 4, 1100},
	{14492, R_036C08_TD_PERFCOUNTER1_SELECT, 5, 1095},
	{14515, R_036D00_TCP_PERFCOUNTER0_SELECT, 5, 1104},
	{14539, R_036D04_TCP_PERFCOUNTER0_SELECT1, 4, 1109},
	{14564, R_036D08_TCP_PERFCOUNTER1_SELECT, 5, 1104},
	{14588, R_036D0C_TCP_PERFCOUNTER1_SELECT1},
	{14613, R_036D10_TCP_PERFCOUNTER2_SELECT, 5, 1104},
	{14637, R_036D14_TCP_PERFCOUNTER3_SELECT, 5, 1104},
	{14661, R_036E00_TCC_PERFCOUNTER0_SELECT, 5, 1113},
	{14685, R_036E04_TCC_PERFCOUNTER0_SELECT1, 4, 1118},
	{14710, R_036E08_TCC_PERFCOUNTER1_SELECT, 5, 1113},
	{14734, R_036E0C_TCC_PERFCOUNTER1_SELECT1},
	{14759, R_036E10_TCC_PERFCOUNTER2_SELECT, 5, 1113},
	{14783, R_036E14_TCC_PERFCOUNTER3_SELECT, 5, 1113},
	{14807, R_036E40_TCA_PERFCOUNTER0_SELECT, 5, 1122},
	{14831, R_036E44_TCA_PERFCOUNTER0_SELECT1, 4, 1127},
	{14856, R_036E48_TCA_PERFCOUNTER1_SELECT, 5, 1122},
	{14880, R_036E4C_TCA_PERFCOUNTER1_SELECT1},
	{14905, R_036E50_TCA_PERFCOUNTER2_SELECT, 5, 1122},
	{14929, R_036E54_TCA_PERFCOUNTER3_SELECT, 5, 1122},
	{14953, R_037000_CB_PERFCOUNTER_FILTER, 12, 1131},
	{14975, R_037004_CB_PERFCOUNTER0_SELECT, 5, 1143},
	{14998, R_037008_CB_PERFCOUNTER0_SELECT1, 4, 1148},
	{15022, R_03700C_CB_PERFCOUNTER1_SELECT, 5, 1143},
	{15045, R_037010_CB_PERFCOUNTER2_SELECT, 5, 1143},
	{15068, R_037014_CB_PERFCOUNTER3_SELECT, 5, 1143},
	{15091, R_037100_DB_PERFCOUNTER0_SELECT, 5, 1152},
	{15114, R_037104_DB_PERFCOUNTER0_SELECT1, 4, 1157},
	{15138, R_037108_DB_PERFCOUNTER1_SELECT, 5, 1152},
	{15161, R_03710C_DB_PERFCOUNTER1_SELECT1},
	{15185, R_037110_DB_PERFCOUNTER2_SELECT, 5, 1152},
	{15208, R_037118_DB_PERFCOUNTER3_SELECT, 5, 1152},
	{15231, R_028000_DB_RENDER_CONTROL, 10, 1161},
	{15249, R_028004_DB_COUNT_CONTROL, 9, 1171},
	{15266, R_028008_DB_DEPTH_VIEW, 4, 1180},
	{15280, R_02800C_DB_RENDER_OVERRIDE, 23, 1184},
	{15299, R_028010_DB_RENDER_OVERRIDE2, 15, 1207},
	{15319, R_028014_DB_HTILE_DATA_BASE},
	{15338, R_028020_DB_DEPTH_BOUNDS_MIN},
	{15358, R_028024_DB_DEPTH_BOUNDS_MAX},
	{15378, R_028028_DB_STENCIL_CLEAR, 1, 1222},
	{15395, R_02802C_DB_DEPTH_CLEAR},
	{15410, R_028030_PA_SC_SCREEN_SCISSOR_TL, 2, 1223},
	{15434, R_028034_PA_SC_SCREEN_SCISSOR_BR, 2, 1225},
	{15458, R_02803C_DB_DEPTH_INFO, 7, 1227},
	{15472, R_028040_DB_Z_INFO, 10, 1234},
	{15482, R_028044_DB_STENCIL_INFO, 6, 1244},
	{15498, R_028048_DB_Z_READ_BASE},
	{15513, R_02804C_DB_STENCIL_READ_BASE},
	{15534, R_028050_DB_Z_WRITE_BASE},
	{15550, R_028054_DB_STENCIL_WRITE_BASE},
	{15572, R_028058_DB_DEPTH_SIZE, 2, 1250},
	{15586, R_02805C_DB_DEPTH_SLICE, 1, 1252},
	{15601, R_028080_TA_BC_BASE_ADDR},
	{15617, R_028084_TA_BC_BASE_ADDR_HI, 1, 1253},
	{15636, R_0281E8_COHER_DEST_BASE_HI_0},
	{15657, R_0281EC_COHER_DEST_BASE_HI_1},
	{15678, R_0281F0_COHER_DEST_BASE_HI_2},
	{15699, R_0281F4_COHER_DEST_BASE_HI_3},
	{15720, R_0281F8_COHER_DEST_BASE_2},
	{15738, R_0281FC_COHER_DEST_BASE_3},
	{15756, R_028200_PA_SC_WINDOW_OFFSET, 2, 1254},
	{15776, R_028204_PA_SC_WINDOW_SCISSOR_TL, 3, 1256},
	{15800, R_028208_PA_SC_WINDOW_SCISSOR_BR, 2, 1259},
	{15824, R_02820C_PA_SC_CLIPRECT_RULE, 1, 1261},
	{15844, R_028210_PA_SC_CLIPRECT_0_TL, 2, 1262},
	{15864, R_028214_PA_SC_CLIPRECT_0_BR, 2, 1264},
	{15884, R_028218_PA_SC_CLIPRECT_1_TL, 2, 1262},
	{15904, R_02821C_PA_SC_CLIPRECT_1_BR, 2, 1264},
	{15924, R_028220_PA_SC_CLIPRECT_2_TL, 2, 1262},
	{15944, R_028224_PA_SC_CLIPRECT_2_BR, 2, 1264},
	{15964, R_028228_PA_SC_CLIPRECT_3_TL, 2, 1262},
	{15984, R_02822C_PA_SC_CLIPRECT_3_BR, 2, 1264},
	{16004, R_028230_PA_SC_EDGERULE, 7, 1266},
	{16019, R_028234_PA_SU_HARDWARE_SCREEN_OFFSET, 2, 1273},
	{16048, R_028238_CB_TARGET_MASK, 8, 1275},
	{16063, R_02823C_CB_SHADER_MASK, 8, 1283},
	{16078, R_028240_PA_SC_GENERIC_SCISSOR_TL, 3, 1291},
	{16103, R_028244_PA_SC_GENERIC_SCISSOR_BR, 2, 1294},
	{16128, R_028248_COHER_DEST_BASE_0},
	{16146, R_02824C_COHER_DEST_BASE_1},
	{16164, R_028250_PA_SC_VPORT_SCISSOR_0_TL, 3, 1296},
	{16189, R_028254_PA_SC_VPORT_SCISSOR_0_BR, 2, 1299},
	{16214, R_028258_PA_SC_VPORT_SCISSOR_1_TL, 3, 1296},
	{16239, R_02825C_PA_SC_VPORT_SCISSOR_1_BR, 2, 1299},
	{16264, R_028260_PA_SC_VPORT_SCISSOR_2_TL, 3, 1296},
	{16289, R_028264_PA_SC_VPORT_SCISSOR_2_BR, 2, 1299},
	{16314, R_028268_PA_SC_VPORT_SCISSOR_3_TL, 3, 1296},
	{16339, R_02826C_PA_SC_VPORT_SCISSOR_3_BR, 2, 1299},
	{16364, R_028270_PA_SC_VPORT_SCISSOR_4_TL, 3, 1296},
	{16389, R_028274_PA_SC_VPORT_SCISSOR_4_BR, 2, 1299},
	{16414, R_028278_PA_SC_VPORT_SCISSOR_5_TL, 3, 1296},
	{16439, R_02827C_PA_SC_VPORT_SCISSOR_5_BR, 2, 1299},
	{16464, R_028280_PA_SC_VPORT_SCISSOR_6_TL, 3, 1296},
	{16489, R_028284_PA_SC_VPORT_SCISSOR_6_BR, 2, 1299},
	{16514, R_028288_PA_SC_VPORT_SCISSOR_7_TL, 3, 1296},
	{16539, R_02828C_PA_SC_VPORT_SCISSOR_7_BR, 2, 1299},
	{16564, R_028290_PA_SC_VPORT_SCISSOR_8_TL, 3, 1296},
	{16589, R_028294_PA_SC_VPORT_SCISSOR_8_BR, 2, 1299},
	{16614, R_028298_PA_SC_VPORT_SCISSOR_9_TL, 3, 1296},
	{16639, R_02829C_PA_SC_VPORT_SCISSOR_9_BR, 2, 1299},
	{16664, R_0282A0_PA_SC_VPORT_SCISSOR_10_TL, 3, 1296},
	{16690, R_0282A4_PA_SC_VPORT_SCISSOR_10_BR, 2, 1299},
	{16716, R_0282A8_PA_SC_VPORT_SCISSOR_11_TL, 3, 1296},
	{16742, R_0282AC_PA_SC_VPORT_SCISSOR_11_BR, 2, 1299},
	{16768, R_0282B0_PA_SC_VPORT_SCISSOR_12_TL, 3, 1296},
	{16794, R_0282B4_PA_SC_VPORT_SCISSOR_12_BR, 2, 1299},
	{16820, R_0282B8_PA_SC_VPORT_SCISSOR_13_TL, 3, 1296},
	{16846, R_0282BC_PA_SC_VPORT_SCISSOR_13_BR, 2, 1299},
	{16872, R_0282C0_PA_SC_VPORT_SCISSOR_14_TL, 3, 1296},
	{16898, R_0282C4_PA_SC_VPORT_SCISSOR_14_BR, 2, 1299},
	{16924, R_0282C8_PA_SC_VPORT_SCISSOR_15_TL, 3, 1296},
	{16950, R_0282CC_PA_SC_VPORT_SCISSOR_15_BR, 2, 1299},
	{16976, R_0282D0_PA_SC_VPORT_ZMIN_0},
	{16995, R_0282D4_PA_SC_VPORT_ZMAX_0},
	{17014, R_0282D8_PA_SC_VPORT_ZMIN_1},
	{17033, R_0282DC_PA_SC_VPORT_ZMAX_1},
	{17052, R_0282E0_PA_SC_VPORT_ZMIN_2},
	{17071, R_0282E4_PA_SC_VPORT_ZMAX_2},
	{17090, R_0282E8_PA_SC_VPORT_ZMIN_3},
	{17109, R_0282EC_PA_SC_VPORT_ZMAX_3},
	{17128, R_0282F0_PA_SC_VPORT_ZMIN_4},
	{17147, R_0282F4_PA_SC_VPORT_ZMAX_4},
	{17166, R_0282F8_PA_SC_VPORT_ZMIN_5},
	{17185, R_0282FC_PA_SC_VPORT_ZMAX_5},
	{17204, R_028300_PA_SC_VPORT_ZMIN_6},
	{17223, R_028304_PA_SC_VPORT_ZMAX_6},
	{17242, R_028308_PA_SC_VPORT_ZMIN_7},
	{17261, R_02830C_PA_SC_VPORT_ZMAX_7},
	{17280, R_028310_PA_SC_VPORT_ZMIN_8},
	{17299, R_028314_PA_SC_VPORT_ZMAX_8},
	{17318, R_028318_PA_SC_VPORT_ZMIN_9},
	{17337, R_02831C_PA_SC_VPORT_ZMAX_9},
	{17356, R_028320_PA_SC_VPORT_ZMIN_10},
	{17376, R_028324_PA_SC_VPORT_ZMAX_10},
	{17396, R_028328_PA_SC_VPORT_ZMIN_11},
	{17416, R_02832C_PA_SC_VPORT_ZMAX_11},
	{17436, R_028330_PA_SC_VPORT_ZMIN_12},
	{17456, R_028334_PA_SC_VPORT_ZMAX_12},
	{17476, R_028338_PA_SC_VPORT_ZMIN_13},
	{17496, R_02833C_PA_SC_VPORT_ZMAX_13},
	{17516, R_028340_PA_SC_VPORT_ZMIN_14},
	{17536, R_028344_PA_SC_VPORT_ZMAX_14},
	{17556, R_028348_PA_SC_VPORT_ZMIN_15},
	{17576, R_02834C_PA_SC_VPORT_ZMAX_15},
	{17596, R_028350_PA_SC_RASTER_CONFIG, 15, 1301},
	{17616, R_028354_PA_SC_RASTER_CONFIG_1, 3, 1316},
	{17638, R_028358_PA_SC_SCREEN_EXTENT_CONTROL, 2, 1319},
	{17666, R_028400_VGT_MAX_VTX_INDX},
	{17683, R_028404_VGT_MIN_VTX_INDX},
	{17700, R_028408_VGT_INDX_OFFSET},
	{17716, R_02840C_VGT_MULTI_PRIM_IB_RESET_INDX},
	{17745, R_028414_CB_BLEND_RED},
	{17758, R_028418_CB_BLEND_GREEN},
	{17773, R_02841C_CB_BLEND_BLUE},
	{17787, R_028420_CB_BLEND_ALPHA},
	{17802, R_028424_CB_DCC_CONTROL, 3, 1321},
	{17817, R_02842C_DB_STENCIL_CONTROL, 6, 1324},
	{17836, R_028430_DB_STENCILREFMASK, 4, 1330},
	{17854, R_028434_DB_STENCILREFMASK_BF, 4, 1334},
	{17875, R_02843C_PA_CL_VPORT_XSCALE},
	{17894, R_028440_PA_CL_VPORT_XOFFSET},
	{17914, R_028444_PA_CL_VPORT_YSCALE},
	{17933, R_028448_PA_CL_VPORT_YOFFSET},
	{17953, R_02844C_PA_CL_VPORT_ZSCALE},
	{17972, R_028450_PA_CL_VPORT_ZOFFSET},
	{17992, R_028454_PA_CL_VPORT_XSCALE_1},
	{18013, R_028458_PA_CL_VPORT_XOFFSET_1},
	{18035, R_02845C_PA_CL_VPORT_YSCALE_1},
	{18056, R_028460_PA_CL_VPORT_YOFFSET_1},
	{18078, R_028464_PA_CL_VPORT_ZSCALE_1},
	{18099, R_028468_PA_CL_VPORT_ZOFFSET_1},
	{18121, R_02846C_PA_CL_VPORT_XSCALE_2},
	{18142, R_028470_PA_CL_VPORT_XOFFSET_2},
	{18164, R_028474_PA_CL_VPORT_YSCALE_2},
	{18185, R_028478_PA_CL_VPORT_YOFFSET_2},
	{18207, R_02847C_PA_CL_VPORT_ZSCALE_2},
	{18228, R_028480_PA_CL_VPORT_ZOFFSET_2},
	{18250, R_028484_PA_CL_VPORT_XSCALE_3},
	{18271, R_028488_PA_CL_VPORT_XOFFSET_3},
	{18293, R_02848C_PA_CL_VPORT_YSCALE_3},
	{18314, R_028490_PA_CL_VPORT_YOFFSET_3},
	{18336, R_028494_PA_CL_VPORT_ZSCALE_3},
	{18357, R_028498_PA_CL_VPORT_ZOFFSET_3},
	{18379, R_02849C_PA_CL_VPORT_XSCALE_4},
	{18400, R_0284A0_PA_CL_VPORT_XOFFSET_4},
	{18422, R_0284A4_PA_CL_VPORT_YSCALE_4},
	{18443, R_0284A8_PA_CL_VPORT_YOFFSET_4},
	{18465, R_0284AC_PA_CL_VPORT_ZSCALE_4},
	{18486, R_0284B0_PA_CL_VPORT_ZOFFSET_4},
	{18508, R_0284B4_PA_CL_VPORT_XSCALE_5},
	{18529, R_0284B8_PA_CL_VPORT_XOFFSET_5},
	{18551, R_0284BC_PA_CL_VPORT_YSCALE_5},
	{18572, R_0284C0_PA_CL_VPORT_YOFFSET_5},
	{18594, R_0284C4_PA_CL_VPORT_ZSCALE_5},
	{18615, R_0284C8_PA_CL_VPORT_ZOFFSET_5},
	{18637, R_0284CC_PA_CL_VPORT_XSCALE_6},
	{18658, R_0284D0_PA_CL_VPORT_XOFFSET_6},
	{18680, R_0284D4_PA_CL_VPORT_YSCALE_6},
	{18701, R_0284D8_PA_CL_VPORT_YOFFSET_6},
	{18723, R_0284DC_PA_CL_VPORT_ZSCALE_6},
	{18744, R_0284E0_PA_CL_VPORT_ZOFFSET_6},
	{18766, R_0284E4_PA_CL_VPORT_XSCALE_7},
	{18787, R_0284E8_PA_CL_VPORT_XOFFSET_7},
	{18809, R_0284EC_PA_CL_VPORT_YSCALE_7},
	{18830, R_0284F0_PA_CL_VPORT_YOFFSET_7},
	{18852, R_0284F4_PA_CL_VPORT_ZSCALE_7},
	{18873, R_0284F8_PA_CL_VPORT_ZOFFSET_7},
	{18895, R_0284FC_PA_CL_VPORT_XSCALE_8},
	{18916, R_028500_PA_CL_VPORT_XOFFSET_8},
	{18938, R_028504_PA_CL_VPORT_YSCALE_8},
	{18959, R_028508_PA_CL_VPORT_YOFFSET_8},
	{18981, R_02850C_PA_CL_VPORT_ZSCALE_8},
	{19002, R_028510_PA_CL_VPORT_ZOFFSET_8},
	{19024, R_028514_PA_CL_VPORT_XSCALE_9},
	{19045, R_028518_PA_CL_VPORT_XOFFSET_9},
	{19067, R_02851C_PA_CL_VPORT_YSCALE_9},
	{19088, R_028520_PA_CL_VPORT_YOFFSET_9},
	{19110, R_028524_PA_CL_VPORT_ZSCALE_9},
	{19131, R_028528_PA_CL_VPORT_ZOFFSET_9},
	{19153, R_02852C_PA_CL_VPORT_XSCALE_10},
	{19175, R_028530_PA_CL_VPORT_XOFFSET_10},
	{19198, R_028534_PA_CL_VPORT_YSCALE_10},
	{19220, R_028538_PA_CL_VPORT_YOFFSET_10},
	{19243, R_02853C_PA_CL_VPORT_ZSCALE_10},
	{19265, R_028540_PA_CL_VPORT_ZOFFSET_10},
	{19288, R_028544_PA_CL_VPORT_XSCALE_11},
	{19310, R_028548_PA_CL_VPORT_XOFFSET_11},
	{19333, R_02854C_PA_CL_VPORT_YSCALE_11},
	{19355, R_028550_PA_CL_VPORT_YOFFSET_11},
	{19378, R_028554_PA_CL_VPORT_ZSCALE_11},
	{19400, R_028558_PA_CL_VPORT_ZOFFSET_11},
	{19423, R_02855C_PA_CL_VPORT_XSCALE_12},
	{19445, R_028560_PA_CL_VPORT_XOFFSET_12},
	{19468, R_028564_PA_CL_VPORT_YSCALE_12},
	{19490, R_028568_PA_CL_VPORT_YOFFSET_12},
	{19513, R_02856C_PA_CL_VPORT_ZSCALE_12},
	{19535, R_028570_PA_CL_VPORT_ZOFFSET_12},
	{19558, R_028574_PA_CL_VPORT_XSCALE_13},
	{19580, R_028578_PA_CL_VPORT_XOFFSET_13},
	{19603, R_02857C_PA_CL_VPORT_YSCALE_13},
	{19625, R_028580_PA_CL_VPORT_YOFFSET_13},
	{19648, R_028584_PA_CL_VPORT_ZSCALE_13},
	{19670, R_028588_PA_CL_VPORT_ZOFFSET_13},
	{19693, R_02858C_PA_CL_VPORT_XSCALE_14},
	{19715, R_028590_PA_CL_VPORT_XOFFSET_14},
	{19738, R_028594_PA_CL_VPORT_YSCALE_14},
	{19760, R_028598_PA_CL_VPORT_YOFFSET_14},
	{19783, R_02859C_PA_CL_VPORT_ZSCALE_14},
	{19805, R_0285A0_PA_CL_VPORT_ZOFFSET_14},
	{19828, R_0285A4_PA_CL_VPORT_XSCALE_15},
	{19850, R_0285A8_PA_CL_VPORT_XOFFSET_15},
	{19873, R_0285AC_PA_CL_VPORT_YSCALE_15},
	{19895, R_0285B0_PA_CL_VPORT_YOFFSET_15},
	{19918, R_0285B4_PA_CL_VPORT_ZSCALE_15},
	{19940, R_0285B8_PA_CL_VPORT_ZOFFSET_15},
	{19963, R_0285BC_PA_CL_UCP_0_X},
	{19977, R_0285C0_PA_CL_UCP_0_Y},
	{19991, R_0285C4_PA_CL_UCP_0_Z},
	{20005, R_0285C8_PA_CL_UCP_0_W},
	{20019, R_0285CC_PA_CL_UCP_1_X},
	{20033, R_0285D0_PA_CL_UCP_1_Y},
	{20047, R_0285D4_PA_CL_UCP_1_Z},
	{20061, R_0285D8_PA_CL_UCP_1_W},
	{20075, R_0285DC_PA_CL_UCP_2_X},
	{20089, R_0285E0_PA_CL_UCP_2_Y},
	{20103, R_0285E4_PA_CL_UCP_2_Z},
	{20117, R_0285E8_PA_CL_UCP_2_W},
	{20131, R_0285EC_PA_CL_UCP_3_X},
	{20145, R_0285F0_PA_CL_UCP_3_Y},
	{20159, R_0285F4_PA_CL_UCP_3_Z},
	{20173, R_0285F8_PA_CL_UCP_3_W},
	{20187, R_0285FC_PA_CL_UCP_4_X},
	{20201, R_028600_PA_CL_UCP_4_Y},
	{20215, R_028604_PA_CL_UCP_4_Z},
	{20229, R_028608_PA_CL_UCP_4_W},
	{20243, R_02860C_PA_CL_UCP_5_X},
	{20257, R_028610_PA_CL_UCP_5_Y},
	{20271, R_028614_PA_CL_UCP_5_Z},
	{20285, R_028618_PA_CL_UCP_5_W},
	{20299, R_028644_SPI_PS_INPUT_CNTL_0, 12, 1338},
	{20319, R_028648_SPI_PS_INPUT_CNTL_1, 12, 1338},
	{20339, R_02864C_SPI_PS_INPUT_CNTL_2, 12, 1338},
	{20359, R_028650_SPI_PS_INPUT_CNTL_3, 12, 1338},
	{20379, R_028654_SPI_PS_INPUT_CNTL_4, 12, 1338},
	{20399, R_028658_SPI_PS_INPUT_CNTL_5, 12, 1338},
	{20419, R_02865C_SPI_PS_INPUT_CNTL_6, 12, 1338},
	{20439, R_028660_SPI_PS_INPUT_CNTL_7, 12, 1338},
	{20459, R_028664_SPI_PS_INPUT_CNTL_8, 12, 1338},
	{20479, R_028668_SPI_PS_INPUT_CNTL_9, 12, 1338},
	{20499, R_02866C_SPI_PS_INPUT_CNTL_10, 12, 1338},
	{20520, R_028670_SPI_PS_INPUT_CNTL_11, 12, 1338},
	{20541, R_028674_SPI_PS_INPUT_CNTL_12, 12, 1338},
	{20562, R_028678_SPI_PS_INPUT_CNTL_13, 12, 1338},
	{20583, R_02867C_SPI_PS_INPUT_CNTL_14, 12, 1338},
	{20604, R_028680_SPI_PS_INPUT_CNTL_15, 12, 1338},
	{20625, R_028684_SPI_PS_INPUT_CNTL_16, 12, 1338},
	{20646, R_028688_SPI_PS_INPUT_CNTL_17, 12, 1338},
	{20667, R_02868C_SPI_PS_INPUT_CNTL_18, 12, 1338},
	{20688, R_028690_SPI_PS_INPUT_CNTL_19, 12, 1338},
	{20709, R_028694_SPI_PS_INPUT_CNTL_20, 12, 1338},
	{20730, R_028698_SPI_PS_INPUT_CNTL_21, 12, 1338},
	{20751, R_02869C_SPI_PS_INPUT_CNTL_22, 12, 1338},
	{20772, R_0286A0_SPI_PS_INPUT_CNTL_23, 12, 1338},
	{20793, R_0286A4_SPI_PS_INPUT_CNTL_24, 12, 1338},
	{20814, R_0286A8_SPI_PS_INPUT_CNTL_25, 12, 1338},
	{20835, R_0286AC_SPI_PS_INPUT_CNTL_26, 12, 1338},
	{20856, R_0286B0_SPI_PS_INPUT_CNTL_27, 12, 1338},
	{20877, R_0286B4_SPI_PS_INPUT_CNTL_28, 12, 1338},
	{20898, R_0286B8_SPI_PS_INPUT_CNTL_29, 12, 1338},
	{20919, R_0286BC_SPI_PS_INPUT_CNTL_30, 12, 1338},
	{20940, R_0286C0_SPI_PS_INPUT_CNTL_31, 12, 1338},
	{20961, R_0286C4_SPI_VS_OUT_CONFIG, 4, 1350},
	{20979, R_0286CC_SPI_PS_INPUT_ENA, 16, 1354},
	{20996, R_0286D0_SPI_PS_INPUT_ADDR, 16, 1370},
	{21014, R_0286D4_SPI_INTERP_CONTROL_0, 7, 1386},
	{21035, R_0286D8_SPI_PS_IN_CONTROL, 5, 1393},
	{21053, R_0286E0_SPI_BARYC_CNTL, 7, 1398},
	{21068, R_0286E8_SPI_TMPRING_SIZE, 2, 1405},
	{21085, R_028704_SPI_WAVE_MGMT_1, 5, 1407},
	{21101, R_028708_SPI_WAVE_MGMT_2, 1, 1412},
	{21117, R_02870C_SPI_SHADER_POS_FORMAT, 4, 1413},
	{21139, R_028710_SPI_SHADER_Z_FORMAT, 1, 1417},
	{21159, R_028714_SPI_SHADER_COL_FORMAT, 8, 1418},
	{21181, R_028754_SX_PS_DOWNCONVERT, 8, 1426},
	{21199, R_028758_SX_BLEND_OPT_EPSILON, 8, 1434},
	{21220, R_02875C_SX_BLEND_OPT_CONTROL, 17, 1442},
	{21241, R_028760_SX_MRT0_BLEND_OPT, 6, 1459},
	{21259, R_028764_SX_MRT1_BLEND_OPT, 6, 1465},
	{21277, R_028768_SX_MRT2_BLEND_OPT, 6, 1471},
	{21295, R_02876C_SX_MRT3_BLEND_OPT, 6, 1477},
	{21313, R_028770_SX_MRT4_BLEND_OPT, 6, 1483},
	{21331, R_028774_SX_MRT5_BLEND_OPT, 6, 1489},
	{21349, R_028778_SX_MRT6_BLEND_OPT, 6, 1495},
	{21367, R_02877C_SX_MRT7_BLEND_OPT, 6, 1501},
	{21385, R_028780_CB_BLEND0_CONTROL, 9, 1507},
	{21403, R_028784_CB_BLEND1_CONTROL, 9, 1507},
	{21421, R_028788_CB_BLEND2_CONTROL, 9, 1507},
	{21439, R_02878C_CB_BLEND3_CONTROL, 9, 1507},
	{21457, R_028790_CB_BLEND4_CONTROL, 9, 1507},
	{21475, R_028794_CB_BLEND5_CONTROL, 9, 1507},
	{21493, R_028798_CB_BLEND6_CONTROL, 9, 1507},
	{21511, R_02879C_CB_BLEND7_CONTROL, 9, 1507},
	{21529, R_0287CC_CS_COPY_STATE, 1, 1516},
	{21543, R_0287D4_PA_CL_POINT_X_RAD},
	{21561, R_0287D8_PA_CL_POINT_Y_RAD},
	{21579, R_0287DC_PA_CL_POINT_SIZE},
	{21596, R_0287E0_PA_CL_POINT_CULL_RAD},
	{21617, R_0287E4_VGT_DMA_BASE_HI, 1, 1517},
	{21633, R_0287E8_VGT_DMA_BASE},
	{21646, R_0287F0_VGT_DRAW_INITIATOR, 4, 1518},
	{21665, R_0287F4_VGT_IMMED_DATA},
	{21680, R_0287F8_VGT_EVENT_ADDRESS_REG, 1, 1522},
	{21702, R_028800_DB_DEPTH_CONTROL, 10, 1523},
	{21719, R_028804_DB_EQAA, 12, 1533},
	{21727, R_028808_CB_COLOR_CONTROL, 4, 1545},
	{21744, R_02880C_DB_SHADER_CONTROL, 13, 1549},
	{21762, R_028810_PA_CL_CLIP_CNTL, 19, 1562},
	{21778, R_028814_PA_SU_SC_MODE_CNTL, 13, 1581},
	{21797, R_028818_PA_CL_VTE_CNTL, 9, 1594},
	{21812, R_02881C_PA_CL_VS_OUT_CNTL, 27, 1603},
	{21830, R_028820_PA_CL_NANINF_CNTL, 16, 1630},
	{21848, R_028824_PA_SU_LINE_STIPPLE_CNTL, 4, 1646},
	{21872, R_028828_PA_SU_LINE_STIPPLE_SCALE},
	{21897, R_02882C_PA_SU_PRIM_FILTER_CNTL, 11, 1650},
	{21920, R_028830_PA_SU_SMALL_PRIM_FILTER_CNTL, 5, 1661},
	{21949, R_028A00_PA_SU_POINT_SIZE, 2, 1666},
	{21966, R_028A04_PA_SU_POINT_MINMAX, 2, 1668},
	{21985, R_028A08_PA_SU_LINE_CNTL, 1, 1670},
	{22001, R_028A0C_PA_SC_LINE_STIPPLE, 4, 1671},
	{22020, R_028A10_VGT_OUTPUT_PATH_CNTL, 1, 1675},
	{22041, R_028A14_VGT_HOS_CNTL, 1, 1676},
	{22054, R_028A18_VGT_HOS_MAX_TESS_LEVEL},
	{22077, R_028A1C_VGT_HOS_MIN_TESS_LEVEL},
	{22100, R_028A20_VGT_HOS_REUSE_DEPTH, 1, 1677},
	{22120, R_028A24_VGT_GROUP_PRIM_TYPE, 4, 1678},
	{22140, R_028A28_VGT_GROUP_FIRST_DECR, 1, 1682},
	{22161, R_028A2C_VGT_GROUP_DECR, 1, 1683},
	{22176, R_028A30_VGT_GROUP_VECT_0_CNTL, 6, 1684},
	{22198, R_028A34_VGT_GROUP_VECT_1_CNTL, 6, 1690},
	{22220, R_028A38_VGT_GROUP_VECT_0_FMT_CNTL, 8, 1696},
	{22246, R_028A3C_VGT_GROUP_VECT_1_FMT_CNTL, 8, 1704},
	{22272, R_028A40_VGT_GS_MODE, 15, 1712},
	{22284, R_028A44_VGT_GS_ONCHIP_CNTL, 2, 1727},
	{22303, R_028A48_PA_SC_MODE_CNTL_0, 4, 1729},
	{22321, R_028A4C_PA_SC_MODE_CNTL_1, 24, 1733},
	{22339, R_028A50_VGT_ENHANCE},
	{22351, R_028A54_VGT_GS_PER_ES, 1, 1757},
	{22365, R_028A58_VGT_ES_PER_GS, 1, 1758},
	{22379, R_028A5C_VGT_GS_PER_VS, 1, 1759},
	{22393, R_028A60_VGT_GSVS_RING_OFFSET_1, 1, 1760},
	{22416, R_028A64_VGT_GSVS_RING_OFFSET_2, 1, 1761},
	{22439, R_028A68_VGT_GSVS_RING_OFFSET_3, 1, 1762},
	{22462, R_028A6C_VGT_GS_OUT_PRIM_TYPE, 5, 1763},
	{22483, R_028A70_IA_ENHANCE},
	{22494, R_028A74_VGT_DMA_SIZE},
	{22507, R_028A78_VGT_DMA_MAX_SIZE},
	{22524, R_028A7C_VGT_DMA_INDEX_TYPE, 9, 1768},
	{22543, R_028A80_WD_ENHANCE},
	{22554, R_028A84_VGT_PRIMITIVEID_EN, 2, 1777},
	{22573, R_028A88_VGT_DMA_NUM_INSTANCES},
	{22595, R_028A8C_VGT_PRIMITIVEID_RESET},
	{22617, R_028A90_VGT_EVENT_INITIATOR, 3, 1779},
	{22637, R_028A94_VGT_MULTI_PRIM_IB_RESET_EN, 1, 1782},
	{22664, R_028AA0_VGT_INSTANCE_STEP_RATE_0},
	{22689, R_028AA4_VGT_INSTANCE_STEP_RATE_1},
	{22714, R_028AA8_IA_MULTI_VGT_PARAM, 7, 1783},
	{22733, R_028AAC_VGT_ESGS_RING_ITEMSIZE, 1, 1790},
	{22756, R_028AB0_VGT_GSVS_RING_ITEMSIZE, 1, 1791},
	{22779, R_028AB4_VGT_REUSE_OFF, 1, 1792},
	{22793, R_028AB8_VGT_VTX_CNT_EN, 1, 1793},
	{22808, R_028ABC_DB_HTILE_SURFACE, 8, 1794},
	{22825, R_028AC0_DB_SRESULTS_COMPARE_STATE0, 4, 1802},
	{22852, R_028AC4_DB_SRESULTS_COMPARE_STATE1, 4, 1806},
	{22879, R_028AC8_DB_PRELOAD_CONTROL, 4, 1810},
	{22898, R_028AD0_VGT_STRMOUT_BUFFER_SIZE_0},
	{22924, R_028AD4_VGT_STRMOUT_VTX_STRIDE_0, 1, 1814},
	{22949, R_028ADC_VGT_STRMOUT_BUFFER_OFFSET_0},
	{22977, R_028AE0_VGT_STRMOUT_BUFFER_SIZE_1},
	{23003, R_028AE4_VGT_STRMOUT_VTX_STRIDE_1, 1, 1815},
	{23028, R_028AEC_VGT_STRMOUT_BUFFER_OFFSET_1},
	{23056, R_028AF0_VGT_STRMOUT_BUFFER_SIZE_2},
	{23082, R_028AF4_VGT_STRMOUT_VTX_STRIDE_2, 1, 1816},
	{23107, R_028AFC_VGT_STRMOUT_BUFFER_OFFSET_2},
	{23135, R_028B00_VGT_STRMOUT_BUFFER_SIZE_3},
	{23161, R_028B04_VGT_STRMOUT_VTX_STRIDE_3, 1, 1817},
	{23186, R_028B0C_VGT_STRMOUT_BUFFER_OFFSET_3},
	{23214, R_028B28_VGT_STRMOUT_DRAW_OPAQUE_OFFSET},
	{23245, R_028B2C_VGT_STRMOUT_DRAW_OPAQUE_BUFFER_FILLED_SIZE},
	{23288, R_028B30_VGT_STRMOUT_DRAW_OPAQUE_VERTEX_STRIDE, 1, 1818},
	{23326, R_028B38_VGT_GS_MAX_VERT_OUT, 1, 1819},
	{23346, R_028B50_VGT_TESS_DISTRIBUTION, 5, 1820},
	{23368, R_028B54_VGT_SHADER_STAGES_EN, 10, 1825},
	{23389, R_028B58_VGT_LS_HS_CONFIG, 3, 1835},
	{23406, R_028B5C_VGT_GS_VERT_ITEMSIZE, 1, 1838},
	{23427, R_028B60_VGT_GS_VERT_ITEMSIZE_1, 1, 1839},
	{23450, R_028B64_VGT_GS_VERT_ITEMSIZE_2, 1, 1840},
	{23473, R_028B68_VGT_GS_VERT_ITEMSIZE_3, 1, 1841},
	{23496, R_028B6C_VGT_TF_PARAM, 11, 1842},
	{23509, R_028B70_DB_ALPHA_TO_MASK, 6, 1853},
	{23526, R_028B74_VGT_DISPATCH_DRAW_INDEX},
	{23550, R_028B78_PA_SU_POLY_OFFSET_DB_FMT_CNTL, 2, 1859},
	{23580, R_028B7C_PA_SU_POLY_OFFSET_CLAMP},
	{23604, R_028B80_PA_SU_POLY_OFFSET_FRONT_SCALE},
	{23634, R_028B84_PA_SU_POLY_OFFSET_FRONT_OFFSET},
	{23665, R_028B88_PA_SU_POLY_OFFSET_BACK_SCALE},
	{23694, R_028B8C_PA_SU_POLY_OFFSET_BACK_OFFSET},
	{23724, R_028B90_VGT_GS_INSTANCE_CNT, 2, 1861},
	{23744, R_028B94_VGT_STRMOUT_CONFIG, 7, 1863},
	{23763, R_028B98_VGT_STRMOUT_BUFFER_CONFIG, 4, 1870},
	{23789, R_028BD4_PA_SC_CENTROID_PRIORITY_0, 8, 1874},
	{23815, R_028BD8_PA_SC_CENTROID_PRIORITY_1, 8, 1882},
	{23841, R_028BDC_PA_SC_LINE_CNTL, 4, 1890},
	{23857, R_028BE0_PA_SC_AA_CONFIG, 5, 1894},
	{23873, R_028BE4_PA_SU_VTX_CNTL, 3, 1899},
	{23888, R_028BE8_PA_CL_GB_VERT_CLIP_ADJ},
	{23911, R_028BEC_PA_CL_GB_VERT_DISC_ADJ},
	{23934, R_028BF0_PA_CL_GB_HORZ_CLIP_ADJ},
	{23957, R_028BF4_PA_CL_GB_HORZ_DISC_ADJ},
	{23980, R_028BF8_PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_0, 8, 1902},
	{24014, R_028BFC_PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_1, 8, 1910},
	{24048, R_028C00_PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_2, 8, 1918},
	{24082, R_028C04_PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_3, 8, 1926},
	{24116, R_028C08_PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_0, 8, 1934},
	{24150, R_028C0C_PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_1, 8, 1942},
	{24184, R_028C10_PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_2, 8, 1950},
	{24218, R_028C14_PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_3, 8, 1958},
	{24252, R_028C18_PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_0, 8, 1966},
	{24286, R_028C1C_PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_1, 8, 1974},
	{24320, R_028C20_PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_2, 8, 1982},
	{24354, R_028C24_PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_3, 8, 1990},
	{24388, R_028C28_PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_0, 8, 1998},
	{24422, R_028C2C_PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_1, 8, 2006},
	{24456, R_028C30_PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_2, 8, 2014},
	{24490, R_028C34_PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_3, 8, 2022},
	{24524, R_028C38_PA_SC_AA_MASK_X0Y0_X1Y0, 2, 2030},
	{24548, R_028C3C_PA_SC_AA_MASK_X0Y1_X1Y1, 2, 2032},
	{24572, R_028C40_PA_SC_SHADER_CONTROL, 1, 2034},
	{24593, R_028C58_VGT_VERTEX_REUSE_BLOCK_CNTL, 1, 2035},
	{24621, R_028C5C_VGT_OUT_DEALLOC_CNTL, 1, 2036},
	{24642, R_028C60_CB_COLOR0_BASE},
	{24657, R_028C64_CB_COLOR0_PITCH, 2, 2037},
	{24673, R_028C68_CB_COLOR0_SLICE, 1, 2039},
	{24689, R_028C6C_CB_COLOR0_VIEW, 2, 2040},
	{24704, R_028C70_CB_COLOR0_INFO, 18, 2042},
	{24719, R_028C74_CB_COLOR0_ATTRIB, 6, 2060},
	{24736, R_028C78_CB_COLOR0_DCC_CONTROL, 9, 2066},
	{24758, R_028C7C_CB_COLOR0_CMASK},
	{24774, R_028C80_CB_COLOR0_CMASK_SLICE, 1, 2075},
	{24796, R_028C84_CB_COLOR0_FMASK},
	{24812, R_028C88_CB_COLOR0_FMASK_SLICE, 1, 2076},
	{24834, R_028C8C_CB_COLOR0_CLEAR_WORD0},
	{24856, R_028C90_CB_COLOR0_CLEAR_WORD1},
	{24878, R_028C94_CB_COLOR0_DCC_BASE},
	{24897, R_028C9C_CB_COLOR1_BASE},
	{24912, R_028CA0_CB_COLOR1_PITCH, 2, 2037},
	{24928, R_028CA4_CB_COLOR1_SLICE, 1, 2039},
	{24944, R_028CA8_CB_COLOR1_VIEW, 2, 2040},
	{24959, R_028CAC_CB_COLOR1_INFO, 18, 2042},
	{24974, R_028CB0_CB_COLOR1_ATTRIB, 6, 2060},
	{24991, R_028CB4_CB_COLOR1_DCC_CONTROL, 9, 2066},
	{25013, R_028CB8_CB_COLOR1_CMASK},
	{25029, R_028CBC_CB_COLOR1_CMASK_SLICE, 1, 2075},
	{25051, R_028CC0_CB_COLOR1_FMASK},
	{25067, R_028CC4_CB_COLOR1_FMASK_SLICE, 1, 2076},
	{25089, R_028CC8_CB_COLOR1_CLEAR_WORD0},
	{25111, R_028CCC_CB_COLOR1_CLEAR_WORD1},
	{25133, R_028CD0_CB_COLOR1_DCC_BASE},
	{25152, R_028CD8_CB_COLOR2_BASE},
	{25167, R_028CDC_CB_COLOR2_PITCH, 2, 2037},
	{25183, R_028CE0_CB_COLOR2_SLICE, 1, 2039},
	{25199, R_028CE4_CB_COLOR2_VIEW, 2, 2040},
	{25214, R_028CE8_CB_COLOR2_INFO, 18, 2042},
	{25229, R_028CEC_CB_COLOR2_ATTRIB, 6, 2060},
	{25246, R_028CF0_CB_COLOR2_DCC_CONTROL, 9, 2066},
	{25268, R_028CF4_CB_COLOR2_CMASK},
	{25284, R_028CF8_CB_COLOR2_CMASK_SLICE, 1, 2075},
	{25306, R_028CFC_CB_COLOR2_FMASK},
	{25322, R_028D00_CB_COLOR2_FMASK_SLICE, 1, 2076},
	{25344, R_028D04_CB_COLOR2_CLEAR_WORD0},
	{25366, R_028D08_CB_COLOR2_CLEAR_WORD1},
	{25388, R_028D0C_CB_COLOR2_DCC_BASE},
	{25407, R_028D14_CB_COLOR3_BASE},
	{25422, R_028D18_CB_COLOR3_PITCH, 2, 2037},
	{25438, R_028D1C_CB_COLOR3_SLICE, 1, 2039},
	{25454, R_028D20_CB_COLOR3_VIEW, 2, 2040},
	{25469, R_028D24_CB_COLOR3_INFO, 18, 2042},
	{25484, R_028D28_CB_COLOR3_ATTRIB, 6, 2060},
	{25501, R_028D2C_CB_COLOR3_DCC_CONTROL, 9, 2066},
	{25523, R_028D30_CB_COLOR3_CMASK},
	{25539, R_028D34_CB_COLOR3_CMASK_SLICE, 1, 2075},
	{25561, R_028D38_CB_COLOR3_FMASK},
	{25577, R_028D3C_CB_COLOR3_FMASK_SLICE, 1, 2076},
	{25599, R_028D40_CB_COLOR3_CLEAR_WORD0},
	{25621, R_028D44_CB_COLOR3_CLEAR_WORD1},
	{25643, R_028D48_CB_COLOR3_DCC_BASE},
	{25662, R_028D50_CB_COLOR4_BASE},
	{25677, R_028D54_CB_COLOR4_PITCH, 2, 2037},
	{25693, R_028D58_CB_COLOR4_SLICE, 1, 2039},
	{25709, R_028D5C_CB_COLOR4_VIEW, 2, 2040},
	{25724, R_028D60_CB_COLOR4_INFO, 18, 2042},
	{25739, R_028D64_CB_COLOR4_ATTRIB, 6, 2060},
	{25756, R_028D68_CB_COLOR4_DCC_CONTROL, 9, 2066},
	{25778, R_028D6C_CB_COLOR4_CMASK},
	{25794, R_028D70_CB_COLOR4_CMASK_SLICE, 1, 2075},
	{25816, R_028D74_CB_COLOR4_FMASK},
	{25832, R_028D78_CB_COLOR4_FMASK_SLICE, 1, 2076},
	{25854, R_028D7C_CB_COLOR4_CLEAR_WORD0},
	{25876, R_028D80_CB_COLOR4_CLEAR_WORD1},
	{25898, R_028D84_CB_COLOR4_DCC_BASE},
	{25917, R_028D8C_CB_COLOR5_BASE},
	{25932, R_028D90_CB_COLOR5_PITCH, 2, 2037},
	{25948, R_028D94_CB_COLOR5_SLICE, 1, 2039},
	{25964, R_028D98_CB_COLOR5_VIEW, 2, 2040},
	{25979, R_028D9C_CB_COLOR5_INFO, 18, 2042},
	{25994, R_028DA0_CB_COLOR5_ATTRIB, 6, 2060},
	{26011, R_028DA4_CB_COLOR5_DCC_CONTROL, 9, 2066},
	{26033, R_028DA8_CB_COLOR5_CMASK},
	{26049, R_028DAC_CB_COLOR5_CMASK_SLICE, 1, 2075},
	{26071, R_028DB0_CB_COLOR5_FMASK},
	{26087, R_028DB4_CB_COLOR5_FMASK_SLICE, 1, 2076},
	{26109, R_028DB8_CB_COLOR5_CLEAR_WORD0},
	{26131, R_028DBC_CB_COLOR5_CLEAR_WORD1},
	{26153, R_028DC0_CB_COLOR5_DCC_BASE},
	{26172, R_028DC8_CB_COLOR6_BASE},
	{26187, R_028DCC_CB_COLOR6_PITCH, 2, 2037},
	{26203, R_028DD0_CB_COLOR6_SLICE, 1, 2039},
	{26219, R_028DD4_CB_COLOR6_VIEW, 2, 2040},
	{26234, R_028DD8_CB_COLOR6_INFO, 18, 2042},
	{26249, R_028DDC_CB_COLOR6_ATTRIB, 6, 2060},
	{26266, R_028DE0_CB_COLOR6_DCC_CONTROL, 9, 2066},
	{26288, R_028DE4_CB_COLOR6_CMASK},
	{26304, R_028DE8_CB_COLOR6_CMASK_SLICE, 1, 2075},
	{26326, R_028DEC_CB_COLOR6_FMASK},
	{26342, R_028DF0_CB_COLOR6_FMASK_SLICE, 1, 2076},
	{26364, R_028DF4_CB_COLOR6_CLEAR_WORD0},
	{26386, R_028DF8_CB_COLOR6_CLEAR_WORD1},
	{26408, R_028DFC_CB_COLOR6_DCC_BASE},
	{26427, R_028E04_CB_COLOR7_BASE},
	{26442, R_028E08_CB_COLOR7_PITCH, 2, 2037},
	{26458, R_028E0C_CB_COLOR7_SLICE, 1, 2039},
	{26474, R_028E10_CB_COLOR7_VIEW, 2, 2040},
	{26489, R_028E14_CB_COLOR7_INFO, 18, 2042},
	{26504, R_028E18_CB_COLOR7_ATTRIB, 6, 2060},
	{26521, R_028E1C_CB_COLOR7_DCC_CONTROL, 9, 2066},
	{26543, R_028E20_CB_COLOR7_CMASK},
	{26559, R_028E24_CB_COLOR7_CMASK_SLICE, 1, 2075},
	{26581, R_028E28_CB_COLOR7_FMASK},
	{26597, R_028E2C_CB_COLOR7_FMASK_SLICE, 1, 2076},
	{26619, R_028E30_CB_COLOR7_CLEAR_WORD0},
	{26641, R_028E34_CB_COLOR7_CLEAR_WORD1},
	{26663, R_028E38_CB_COLOR7_DCC_BASE},
};

static const struct si_reg gfx9d_reg_table[] = {
	{1059, R_008008_GRBM_STATUS2, 25, 2077},
	{1072, R_008010_GRBM_STATUS, 24, 2102},
	{1157, R_008014_GRBM_STATUS_SE0, 12, 2126},
	{1173, R_008018_GRBM_STATUS_SE1, 12, 2138},
	{1189, R_008038_GRBM_STATUS_SE2, 12, 2150},
	{1205, R_00803C_GRBM_STATUS_SE3, 12, 2162},
	{1115, R_0301F0_CP_COHER_CNTL, 13, 2174},
	{1259, R_0301FC_CP_COHER_STATUS, 2, 2187},
	{1275, R_008210_CP_CPC_STATUS, 16, 2189},
	{1306, R_008218_CP_CPC_STALLED_STAT1, 14, 2205},
	{1327, R_00821C_CP_CPF_STATUS, 21, 2219},
	{1358, R_008224_CP_CPF_STALLED_STAT1, 11, 2240},
	{1821, R_008670_CP_STALLED_STAT3, 19, 2251},
	{1872, R_008680_CP_STAT, 22, 2270},
	{1500, R_030908_VGT_PRIMITIVE_TYPE, 1, 2292},
	{1519, R_03090C_VGT_INDEX_TYPE, 2, 2293},
	{17666, R_030920_VGT_MAX_VTX_INDX},
	{17683, R_030924_VGT_MIN_VTX_INDX},
	{17700, R_030928_VGT_INDX_OFFSET},
	{22637, R_03092C_VGT_MULTI_PRIM_IB_RESET_EN, 2, 2295},
	{1717, R_03093C_VGT_HS_OFFCHIP_PARAM, 2, 2297},
	{26682, R_030944_VGT_TF_MEMORY_BASE_HI, 1, 2299},
	{26704, R_030948_WD_POS_BUF_BASE},
	{26720, R_03094C_WD_POS_BUF_BASE_HI, 1, 2300},
	{26739, R_030950_WD_CNTL_SB_BUF_BASE},
	{26759, R_030954_WD_CNTL_SB_BUF_BASE_HI, 1, 2301},
	{26782, R_030958_WD_INDEX_BUF_BASE},
	{26800, R_03095C_WD_INDEX_BUF_BASE_HI, 1, 2302},
	{22714, R_030960_IA_MULTI_VGT_PARAM, 9, 2303},
	{26821, R_030964_VGT_OBJECT_ID},
	{26835, R_030968_VGT_INSTANCE_BASE_ID},
	{1998, R_030D20_SQC_CACHES, 6, 2312},
	{26856, R_030D24_SQC_WRITEBACK, 2, 2318},
	{26870, R_030E08_TA_GRAD_ADJ_UCONFIG, 4, 2320},
	{2226, R_008F0C_SQ_BUF_RSRC_WORD3, 12, 2324},
	{2309, R_008F14_SQ_IMG_RSRC_WORD1, 9, 2336},
	{2351, R_008F18_SQ_IMG_RSRC_WORD2, 3, 558},
	{2392, R_008F1C_SQ_IMG_RSRC_WORD3, 8, 2345},
	{2410, R_008F20_SQ_IMG_RSRC_WORD4, 3, 2353},
	{2428, R_008F24_SQ_IMG_RSRC_WORD5, 7, 2356},
	{2518, R_008F38_SQ_IMG_SAMP_WORD2, 10, 2363},
	{2536, R_008F3C_SQ_IMG_SAMP_WORD3, 3, 2373},
	{2800, R_031100_SPI_CONFIG_CNTL, 9, 2376},
	{2816, R_031104_SPI_CONFIG_CNTL_1, 11, 2385},
	{26890, R_031108_SPI_CONFIG_CNTL_2, 2, 2396},
	{2882, R_0098F8_GB_ADDR_CONFIG, 13, 2398},
	{2897, R_009910_GB_TILE_MODE0, 5, 2411},
	{2911, R_009914_GB_TILE_MODE1, 5, 2411},
	{2925, R_009918_GB_TILE_MODE2, 5, 2411},
	{2939, R_00991C_GB_TILE_MODE3, 5, 2411},
	{2953, R_009920_GB_TILE_MODE4, 5, 2411},
	{2967, R_009924_GB_TILE_MODE5, 5, 2411},
	{2981, R_009928_GB_TILE_MODE6, 5, 2411},
	{2995, R_00992C_GB_TILE_MODE7, 5, 2411},
	{3009, R_009930_GB_TILE_MODE8, 5, 2411},
	{3023, R_009934_GB_TILE_MODE9, 5, 2411},
	{3037, R_009938_GB_TILE_MODE10, 5, 2411},
	{3052, R_00993C_GB_TILE_MODE11, 5, 2411},
	{3067, R_009940_GB_TILE_MODE12, 5, 2411},
	{3082, R_009944_GB_TILE_MODE13, 5, 2411},
	{3097, R_009948_GB_TILE_MODE14, 5, 2411},
	{3112, R_00994C_GB_TILE_MODE15, 5, 2411},
	{3127, R_009950_GB_TILE_MODE16, 5, 2411},
	{3142, R_009954_GB_TILE_MODE17, 5, 2411},
	{3157, R_009958_GB_TILE_MODE18, 5, 2411},
	{3172, R_00995C_GB_TILE_MODE19, 5, 2411},
	{3187, R_009960_GB_TILE_MODE20, 5, 2411},
	{3202, R_009964_GB_TILE_MODE21, 5, 2411},
	{3217, R_009968_GB_TILE_MODE22, 5, 2411},
	{3232, R_00996C_GB_TILE_MODE23, 5, 2411},
	{3247, R_009970_GB_TILE_MODE24, 5, 2411},
	{3262, R_009974_GB_TILE_MODE25, 5, 2411},
	{3277, R_009978_GB_TILE_MODE26, 5, 2411},
	{3292, R_00997C_GB_TILE_MODE27, 5, 2411},
	{3307, R_009980_GB_TILE_MODE28, 5, 2411},
	{3322, R_009984_GB_TILE_MODE29, 5, 2411},
	{3337, R_009988_GB_TILE_MODE30, 5, 2411},
	{3352, R_00998C_GB_TILE_MODE31, 5, 2411},
	{3761, R_00B01C_SPI_SHADER_PGM_RSRC3_PS, 4, 2416},
	{3827, R_00B028_SPI_SHADER_PGM_RSRC1_PS, 11, 2420},
	{3851, R_00B02C_SPI_SHADER_PGM_RSRC2_PS, 10, 2431},
	{26908, R_00B070_SPI_SHADER_USER_DATA_PS_16},
	{26935, R_00B074_SPI_SHADER_USER_DATA_PS_17},
	{26962, R_00B078_SPI_SHADER_USER_DATA_PS_18},
	{26989, R_00B07C_SPI_SHADER_USER_DATA_PS_19},
	{27016, R_00B080_SPI_SHADER_USER_DATA_PS_20},
	{27043, R_00B084_SPI_SHADER_USER_DATA_PS_21},
	{27070, R_00B088_SPI_SHADER_USER_DATA_PS_22},
	{27097, R_00B08C_SPI_SHADER_USER_DATA_PS_23},
	{27124, R_00B090_SPI_SHADER_USER_DATA_PS_24},
	{27151, R_00B094_SPI_SHADER_USER_DATA_PS_25},
	{27178, R_00B098_SPI_SHADER_USER_DATA_PS_26},
	{27205, R_00B09C_SPI_SHADER_USER_DATA_PS_27},
	{27232, R_00B0A0_SPI_SHADER_USER_DATA_PS_28},
	{27259, R_00B0A4_SPI_SHADER_USER_DATA_PS_29},
	{27286, R_00B0A8_SPI_SHADER_USER_DATA_PS_30},
	{27313, R_00B0AC_SPI_SHADER_USER_DATA_PS_31},
	{4381, R_00B118_SPI_SHADER_PGM_RSRC3_VS, 4, 2441},
	{4472, R_00B128_SPI_SHADER_PGM_RSRC1_VS, 12, 2445},
	{4496, R_00B12C_SPI_SHADER_PGM_RSRC2_VS, 14, 2457},
	{27340, R_00B170_SPI_SHADER_USER_DATA_VS_16},
	{27367, R_00B174_SPI_SHADER_USER_DATA_VS_17},
	{27394, R_00B178_SPI_SHADER_USER_DATA_VS_18},
	{27421, R_00B17C_SPI_SHADER_USER_DATA_VS_19},
	{27448, R_00B180_SPI_SHADER_USER_DATA_VS_20},
	{27475, R_00B184_SPI_SHADER_USER_DATA_VS_21},
	{27502, R_00B188_SPI_SHADER_USER_DATA_VS_22},
	{27529, R_00B18C_SPI_SHADER_USER_DATA_VS_23},
	{27556, R_00B190_SPI_SHADER_USER_DATA_VS_24},
	{27583, R_00B194_SPI_SHADER_USER_DATA_VS_25},
	{27610, R_00B198_SPI_SHADER_USER_DATA_VS_26},
	{27637, R_00B19C_SPI_SHADER_USER_DATA_VS_27},
	{27664, R_00B1A0_SPI_SHADER_USER_DATA_VS_28},
	{27691, R_00B1A4_SPI_SHADER_USER_DATA_VS_29},
	{27718, R_00B1A8_SPI_SHADER_USER_DATA_VS_30},
	{27745, R_00B1AC_SPI_SHADER_USER_DATA_VS_31},
	{27772, R_00B1F0_SPI_SHADER_PGM_RSRC2_GS_VS, 9, 2471},
	{27799, R_00B204_SPI_SHADER_PGM_RSRC4_GS, 2, 2480},
	{27823, R_00B208_SPI_SHADER_USER_DATA_ADDR_LO_GS},
	{27855, R_00B20C_SPI_SHADER_USER_DATA_ADDR_HI_GS},
	{5670, R_00B210_SPI_SHADER_PGM_LO_ES},
	{5691, R_00B214_SPI_SHADER_PGM_HI_ES, 1, 2482},
	{5026, R_00B21C_SPI_SHADER_PGM_RSRC3_GS, 4, 2483},
	{5092, R_00B228_SPI_SHADER_PGM_RSRC1_GS, 12, 2487},
	{5116, R_00B22C_SPI_SHADER_PGM_RSRC2_GS, 9, 2499},
	{27887, R_00B370_SPI_SHADER_USER_DATA_ES_16},
	{27914, R_00B374_SPI_SHADER_USER_DATA_ES_17},
	{27941, R_00B378_SPI_SHADER_USER_DATA_ES_18},
	{27968, R_00B37C_SPI_SHADER_USER_DATA_ES_19},
	{27995, R_00B380_SPI_SHADER_USER_DATA_ES_20},
	{28022, R_00B384_SPI_SHADER_USER_DATA_ES_21},
	{28049, R_00B388_SPI_SHADER_USER_DATA_ES_22},
	{28076, R_00B38C_SPI_SHADER_USER_DATA_ES_23},
	{28103, R_00B390_SPI_SHADER_USER_DATA_ES_24},
	{28130, R_00B394_SPI_SHADER_USER_DATA_ES_25},
	{28157, R_00B398_SPI_SHADER_USER_DATA_ES_26},
	{28184, R_00B39C_SPI_SHADER_USER_DATA_ES_27},
	{28211, R_00B3A0_SPI_SHADER_USER_DATA_ES_28},
	{28238, R_00B3A4_SPI_SHADER_USER_DATA_ES_29},
	{28265, R_00B3A8_SPI_SHADER_USER_DATA_ES_30},
	{28292, R_00B3AC_SPI_SHADER_USER_DATA_ES_31},
	{28319, R_00B404_SPI_SHADER_PGM_RSRC4_HS, 1, 2508},
	{28343, R_00B408_SPI_SHADER_USER_DATA_ADDR_LO_HS},
	{28375, R_00B40C_SPI_SHADER_USER_DATA_ADDR_HI_HS},
	{6910, R_00B410_SPI_SHADER_PGM_LO_LS},
	{6931, R_00B414_SPI_SHADER_PGM_HI_LS, 1, 2509},
	{6266, R_00B41C_SPI_SHADER_PGM_RSRC3_HS, 4, 2510},
	{6332, R_00B428_SPI_SHADER_PGM_RSRC1_HS, 11, 2514},
	{6356, R_00B42C_SPI_SHADER_PGM_RSRC2_HS, 7, 2525},
	{7000, R_00B430_SPI_SHADER_USER_DATA_LS_0},
	{7026, R_00B434_SPI_SHADER_USER_DATA_LS_1},
	{7052, R_00B438_SPI_SHADER_USER_DATA_LS_2},
	{7078, R_00B43C_SPI_SHADER_USER_DATA_LS_3},
	{7104, R_00B440_SPI_SHADER_USER_DATA_LS_4},
	{7130, R_00B444_SPI_SHADER_USER_DATA_LS_5},
	{7156, R_00B448_SPI_SHADER_USER_DATA_LS_6},
	{7182, R_00B44C_SPI_SHADER_USER_DATA_LS_7},
	{7208, R_00B450_SPI_SHADER_USER_DATA_LS_8},
	{7234, R_00B454_SPI_SHADER_USER_DATA_LS_9},
	{7260, R_00B458_SPI_SHADER_USER_DATA_LS_10},
	{7287, R_00B45C_SPI_SHADER_USER_DATA_LS_11},
	{7314, R_00B460_SPI_SHADER_USER_DATA_LS_12},
	{7341, R_00B464_SPI_SHADER_USER_DATA_LS_13},
	{7368, R_00B468_SPI_SHADER_USER_DATA_LS_14},
	{7395, R_00B46C_SPI_SHADER_USER_DATA_LS_15},
	{28407, R_00B470_SPI_SHADER_USER_DATA_LS_16},
	{28434, R_00B474_SPI_SHADER_USER_DATA_LS_17},
	{28461, R_00B478_SPI_SHADER_USER_DATA_LS_18},
	{28488, R_00B47C_SPI_SHADER_USER_DATA_LS_19},
	{28515, R_00B480_SPI_SHADER_USER_DATA_LS_20},
	{28542, R_00B484_SPI_SHADER_USER_DATA_LS_21},
	{28569, R_00B488_SPI_SHADER_USER_DATA_LS_22},
	{28596, R_00B48C_SPI_SHADER_USER_DATA_LS_23},
	{28623, R_00B490_SPI_SHADER_USER_DATA_LS_24},
	{28650, R_00B494_SPI_SHADER_USER_DATA_LS_25},
	{28677, R_00B498_SPI_SHADER_USER_DATA_LS_26},
	{28704, R_00B49C_SPI_SHADER_USER_DATA_LS_27},
	{28731, R_00B4A0_SPI_SHADER_USER_DATA_LS_28},
	{28758, R_00B4A4_SPI_SHADER_USER_DATA_LS_29},
	{28785, R_00B4A8_SPI_SHADER_USER_DATA_LS_30},
	{28812, R_00B4AC_SPI_SHADER_USER_DATA_LS_31},
	{28839, R_00B530_SPI_SHADER_USER_DATA_COMMON_0},
	{28869, R_00B534_SPI_SHADER_USER_DATA_COMMON_1},
	{28899, R_00B538_SPI_SHADER_USER_DATA_COMMON_2},
	{28929, R_00B53C_SPI_SHADER_USER_DATA_COMMON_3},
	{28959, R_00B540_SPI_SHADER_USER_DATA_COMMON_4},
	{28989, R_00B544_SPI_SHADER_USER_DATA_COMMON_5},
	{29019, R_00B548_SPI_SHADER_USER_DATA_COMMON_6},
	{29049, R_00B54C_SPI_SHADER_USER_DATA_COMMON_7},
	{29079, R_00B550_SPI_SHADER_USER_DATA_COMMON_8},
	{29109, R_00B554_SPI_SHADER_USER_DATA_COMMON_9},
	{29139, R_00B558_SPI_SHADER_USER_DATA_COMMON_10},
	{29170, R_00B55C_SPI_SHADER_USER_DATA_COMMON_11},
	{29201, R_00B560_SPI_SHADER_USER_DATA_COMMON_12},
	{29232, R_00B564_SPI_SHADER_USER_DATA_COMMON_13},
	{29263, R_00B568_SPI_SHADER_USER_DATA_COMMON_14},
	{29294, R_00B56C_SPI_SHADER_USER_DATA_COMMON_15},
	{29325, R_00B570_SPI_SHADER_USER_DATA_COMMON_16},
	{29356, R_00B574_SPI_SHADER_USER_DATA_COMMON_17},
	{29387, R_00B578_SPI_SHADER_USER_DATA_COMMON_18},
	{29418, R_00B57C_SPI_SHADER_USER_DATA_COMMON_19},
	{29449, R_00B580_SPI_SHADER_USER_DATA_COMMON_20},
	{29480, R_00B584_SPI_SHADER_USER_DATA_COMMON_21},
	{29511, R_00B588_SPI_SHADER_USER_DATA_COMMON_22},
	{29542, R_00B58C_SPI_SHADER_USER_DATA_COMMON_23},
	{29573, R_00B590_SPI_SHADER_USER_DATA_COMMON_24},
	{29604, R_00B594_SPI_SHADER_USER_DATA_COMMON_25},
	{29635, R_00B598_SPI_SHADER_USER_DATA_COMMON_26},
	{29666, R_00B59C_SPI_SHADER_USER_DATA_COMMON_27},
	{29697, R_00B5A0_SPI_SHADER_USER_DATA_COMMON_28},
	{29728, R_00B5A4_SPI_SHADER_USER_DATA_COMMON_29},
	{29759, R_00B5A8_SPI_SHADER_USER_DATA_COMMON_30},
	{29790, R_00B5AC_SPI_SHADER_USER_DATA_COMMON_31},
	{7422, R_00B800_COMPUTE_DISPATCH_INITIATOR, 11, 2532},
	{7690, R_00B834_COMPUTE_PGM_HI, 1, 873},
	{29821, R_00B838_COMPUTE_DISPATCH_PKT_ADDR_LO},
	{29850, R_00B83C_COMPUTE_DISPATCH_PKT_ADDR_HI, 1, 875},
	{29879, R_00B840_COMPUTE_DISPATCH_SCRATCH_BASE_LO},
	{29912, R_00B844_COMPUTE_DISPATCH_SCRATCH_BASE_HI, 1, 876},
	{7765, R_00B848_COMPUTE_PGM_RSRC1, 11, 2543},
	{7783, R_00B84C_COMPUTE_PGM_RSRC2, 12, 2554},
	{7814, R_00B854_COMPUTE_RESOURCE_LIMITS, 7, 2566},
	{29945, R_034030_CPF_LATENCY_STATS_DATA},
	{29968, R_034034_CPG_LATENCY_STATS_DATA},
	{29991, R_034038_CPC_LATENCY_STATS_DATA},
	{12244, R_036000_CPG_PERFCOUNTER1_SELECT, 5, 2573},
	{12268, R_036004_CPG_PERFCOUNTER0_SELECT1, 4, 2578},
	{12293, R_036008_CPG_PERFCOUNTER0_SELECT, 5, 2573},
	{12317, R_03600C_CPC_PERFCOUNTER1_SELECT, 5, 2582},
	{12341, R_036010_CPC_PERFCOUNTER0_SELECT1, 4, 2587},
	{12366, R_036014_CPF_PERFCOUNTER1_SELECT, 5, 2591},
	{12390, R_036018_CPF_PERFCOUNTER0_SELECT1, 4, 2596},
	{12415, R_03601C_CPF_PERFCOUNTER0_SELECT, 5, 2591},
	{12455, R_036024_CPC_PERFCOUNTER0_SELECT, 5, 2582},
	{30014, R_036028_CPF_TC_PERF_COUNTER_WINDOW_SELECT, 3, 2600},
	{30048, R_03602C_CPG_TC_PERF_COUNTER_WINDOW_SELECT, 3, 2603},
	{30082, R_036030_CPF_LATENCY_STATS_SELECT, 3, 2606},
	{30107, R_036034_CPG_LATENCY_STATS_SELECT, 3, 2609},
	{30132, R_036038_CPC_LATENCY_STATS_SELECT, 3, 2612},
	{12479, R_036100_GRBM_PERFCOUNTER0_SELECT, 22, 2615},
	{12504, R_036104_GRBM_PERFCOUNTER1_SELECT, 22, 2615},
	{12529, R_036108_GRBM_SE0_PERFCOUNTER_SELECT, 13, 2637},
	{12557, R_03610C_GRBM_SE1_PERFCOUNTER_SELECT, 13, 2650},
	{12585, R_036110_GRBM_SE2_PERFCOUNTER_SELECT, 13, 2663},
	{12613, R_036114_GRBM_SE3_PERFCOUNTER_SELECT, 13, 2676},
	{13414, R_036600_SPI_PERFCOUNTER0_SELECT, 5, 2689},
	{13438, R_036604_SPI_PERFCOUNTER1_SELECT, 5, 2689},
	{13462, R_036608_SPI_PERFCOUNTER2_SELECT, 5, 2689},
	{13486, R_03660C_SPI_PERFCOUNTER3_SELECT, 5, 2689},
	{13510, R_036610_SPI_PERFCOUNTER0_SELECT1, 4, 2694},
	{13610, R_036620_SPI_PERFCOUNTER4_SELECT, 5, 2689},
	{13634, R_036624_SPI_PERFCOUNTER5_SELECT, 5, 2689},
	{15266, R_028008_DB_DEPTH_VIEW, 5, 2698},
	{15299, R_028010_DB_RENDER_OVERRIDE2, 16, 2703},
	{30157, R_028018_DB_HTILE_DATA_BASE_HI, 1, 2719},
	{15572, R_02801C_DB_DEPTH_SIZE, 2, 2720},
	{15472, R_028038_DB_Z_INFO, 13, 2722},
	{15482, R_02803C_DB_STENCIL_INFO, 8, 2735},
	{15498, R_028040_DB_Z_READ_BASE},
	{30179, R_028044_DB_Z_READ_BASE_HI, 1, 2743},
	{15513, R_028048_DB_STENCIL_READ_BASE},
	{30197, R_02804C_DB_STENCIL_READ_BASE_HI, 1, 2744},
	{30221, R_028054_DB_Z_WRITE_BASE_HI, 1, 2745},
	{15550, R_028058_DB_STENCIL_WRITE_BASE},
	{30240, R_02805C_DB_STENCIL_WRITE_BASE_HI, 1, 2746},
	{30265, R_028060_DB_DFSM_CONTROL, 3, 2747},
	{30281, R_028064_DB_RENDER_FILTER, 1, 2750},
	{30298, R_028068_DB_Z_INFO2, 1, 2751},
	{30309, R_02806C_DB_STENCIL_INFO2, 1, 2752},
	{15636, R_0281E8_COHER_DEST_BASE_HI_0, 1, 2753},
	{15657, R_0281EC_COHER_DEST_BASE_HI_1, 1, 2754},
	{15678, R_0281F0_COHER_DEST_BASE_HI_2, 1, 2755},
	{15699, R_0281F4_COHER_DEST_BASE_HI_3, 1, 2756},
	{17596, R_028350_PA_SC_RASTER_CONFIG, 15, 2757},
	{17616, R_028354_PA_SC_RASTER_CONFIG_1, 3, 2772},
	{30326, R_02835C_PA_SC_TILE_STEERING_OVERRIDE, 4, 2775},
	{30355, R_028360_CP_PERFMON_CNTX_CNTL, 1, 2779},
	{30376, R_0283A0_PA_SC_RIGHT_VERT_GRID, 4, 2780},
	{30398, R_0283A4_PA_SC_LEFT_VERT_GRID, 4, 2784},
	{30419, R_0283A8_PA_SC_HORIZ_GRID, 4, 2788},
	{30436, R_0283AC_PA_SC_FOV_WINDOW_LR, 4, 2792},
	{30456, R_0283B0_PA_SC_FOV_WINDOW_TB, 2, 2796},
	{20961, R_0286C4_SPI_VS_OUT_CONFIG, 2, 1350},
	{21035, R_0286D8_SPI_PS_IN_CONTROL, 5, 2798},
	{30476, R_0287A0_CB_MRT0_EPITCH, 1, 2803},
	{30491, R_0287A4_CB_MRT1_EPITCH, 1, 2804},
	{30506, R_0287A8_CB_MRT2_EPITCH, 1, 2805},
	{30521, R_0287AC_CB_MRT3_EPITCH, 1, 2806},
	{30536, R_0287B0_CB_MRT4_EPITCH, 1, 2807},
	{30551, R_0287B4_CB_MRT5_EPITCH, 1, 2808},
	{30566, R_0287B8_CB_MRT6_EPITCH, 1, 2809},
	{30581, R_0287BC_CB_MRT7_EPITCH, 1, 2810},
	{21617, R_0287E4_VGT_DMA_BASE_HI, 1, 2811},
	{21646, R_0287F0_VGT_DRAW_INITIATOR, 8, 2812},
	{21744, R_02880C_DB_SHADER_CONTROL, 16, 2820},
	{21778, R_028814_PA_SU_SC_MODE_CNTL, 15, 2836},
	{21797, R_028818_PA_CL_VTE_CNTL, 10, 2851},
	{21812, R_02881C_PA_CL_VS_OUT_CNTL, 28, 2861},
	{21920, R_028830_PA_SU_SMALL_PRIM_FILTER_CNTL, 6, 2889},
	{30596, R_028834_PA_CL_OBJPRIM_ID_CNTL, 3, 2895},
	{30618, R_028838_PA_CL_NGG_CNTL, 2, 2898},
	{30633, R_02883C_PA_SU_OVER_RASTERIZATION_CNTL, 5, 2900},
	{22272, R_028A40_VGT_GS_MODE, 15, 2905},
	{22284, R_028A44_VGT_GS_ONCHIP_CNTL, 3, 2920},
	{22303, R_028A48_PA_SC_MODE_CNTL_0, 7, 2923},
	{22524, R_028A7C_VGT_DMA_INDEX_TYPE, 7, 2930},
	{22554, R_028A84_VGT_PRIMITIVEID_EN, 3, 2937},
	{22617, R_028A90_VGT_EVENT_INITIATOR, 3, 2940},
	{30663, R_028A94_VGT_GS_MAX_PRIMS_PER_SUBGROUP, 1, 2943},
	{30693, R_028A98_VGT_DRAW_PAYLOAD_CNTL, 4, 2944},
	{30715, R_028A9C_VGT_INDEX_PAYLOAD_CNTL, 1, 2948},
	{22808, R_028ABC_DB_HTILE_SURFACE, 8, 2949},
	{23368, R_028B54_VGT_SHADER_STAGES_EN, 13, 2957},
	{23496, R_028B6C_VGT_TF_PARAM, 8, 2970},
	{23744, R_028B94_VGT_STRMOUT_CONFIG, 8, 2978},
	{30738, R_028B9C_VGT_DMA_EVENT_INITIATOR, 3, 2986},
	{23857, R_028BE0_PA_SC_AA_CONFIG, 6, 2989},
	{24572, R_028C40_PA_SC_SHADER_CONTROL, 3, 2995},
	{30762, R_028C44_PA_SC_BINNER_CNTL_0, 10, 2998},
	{30782, R_028C48_PA_SC_BINNER_CNTL_1, 2, 3008},
	{30802, R_028C4C_PA_SC_CONSERVATIVE_RASTERIZATION_CNTL, 18, 3010},
	{30840, R_028C50_PA_SC_NGG_MODE_CNTL, 1, 3028},
	{30860, R_028C64_CB_COLOR0_BASE_EXT, 1, 3029},
	{30879, R_028C68_CB_COLOR0_ATTRIB2, 3, 3030},
	{24689, R_028C6C_CB_COLOR0_VIEW, 3, 3033},
	{24704, R_028C70_CB_COLOR0_INFO, 16, 3036},
	{24719, R_028C74_CB_COLOR0_ATTRIB, 10, 3052},
	{30897, R_028C80_CB_COLOR0_CMASK_BASE_EXT, 1, 3062},
	{30922, R_028C88_CB_COLOR0_FMASK_BASE_EXT, 1, 3063},
	{30947, R_028C98_CB_COLOR0_DCC_BASE_EXT, 1, 3064},
	{30970, R_028CA0_CB_COLOR1_BASE_EXT, 1, 3029},
	{30989, R_028CA4_CB_COLOR1_ATTRIB2},
	{24944, R_028CA8_CB_COLOR1_VIEW, 3, 3033},
	{24959, R_028CAC_CB_COLOR1_INFO, 16, 3036},
	{24974, R_028CB0_CB_COLOR1_ATTRIB, 10, 3052},
	{31007, R_028CBC_CB_COLOR1_CMASK_BASE_EXT, 1, 3062},
	{31032, R_028CC4_CB_COLOR1_FMASK_BASE_EXT, 1, 3063},
	{31057, R_028CD4_CB_COLOR1_DCC_BASE_EXT, 1, 3064},
	{31080, R_028CDC_CB_COLOR2_BASE_EXT, 1, 3029},
	{31099, R_028CE0_CB_COLOR2_ATTRIB2},
	{25199, R_028CE4_CB_COLOR2_VIEW, 3, 3033},
	{25214, R_028CE8_CB_COLOR2_INFO, 16, 3036},
	{25229, R_028CEC_CB_COLOR2_ATTRIB, 10, 3052},
	{31117, R_028CF8_CB_COLOR2_CMASK_BASE_EXT, 1, 3062},
	{31142, R_028D00_CB_COLOR2_FMASK_BASE_EXT, 1, 3063},
	{31167, R_028D10_CB_COLOR2_DCC_BASE_EXT, 1, 3064},
	{31190, R_028D18_CB_COLOR3_BASE_EXT, 1, 3029},
	{31209, R_028D1C_CB_COLOR3_ATTRIB2},
	{25454, R_028D20_CB_COLOR3_VIEW, 3, 3033},
	{25469, R_028D24_CB_COLOR3_INFO, 16, 3036},
	{25484, R_028D28_CB_COLOR3_ATTRIB, 10, 3052},
	{31227, R_028D34_CB_COLOR3_CMASK_BASE_EXT, 1, 3062},
	{31252, R_028D3C_CB_COLOR3_FMASK_BASE_EXT, 1, 3063},
	{31277, R_028D4C_CB_COLOR3_DCC_BASE_EXT, 1, 3064},
	{31300, R_028D54_CB_COLOR4_BASE_EXT, 1, 3029},
	{31319, R_028D58_CB_COLOR4_ATTRIB2},
	{25709, R_028D5C_CB_COLOR4_VIEW, 3, 3033},
	{25724, R_028D60_CB_COLOR4_INFO, 16, 3036},
	{25739, R_028D64_CB_COLOR4_ATTRIB, 10, 3052},
	{31337, R_028D70_CB_COLOR4_CMASK_BASE_EXT, 1, 3062},
	{31362, R_028D78_CB_COLOR4_FMASK_BASE_EXT, 1, 3063},
	{31387, R_028D88_CB_COLOR4_DCC_BASE_EXT, 1, 3064},
	{31410, R_028D90_CB_COLOR5_BASE_EXT, 1, 3029},
	{31429, R_028D94_CB_COLOR5_ATTRIB2},
	{25964, R_028D98_CB_COLOR5_VIEW, 3, 3033},
	{25979, R_028D9C_CB_COLOR5_INFO, 16, 3036},
	{25994, R_028DA0_CB_COLOR5_ATTRIB, 10, 3052},
	{31447, R_028DAC_CB_COLOR5_CMASK_BASE_EXT, 1, 3062},
	{31472, R_028DB4_CB_COLOR5_FMASK_BASE_EXT, 1, 3063},
	{31497, R_028DC4_CB_COLOR5_DCC_BASE_EXT, 1, 3064},
	{31520, R_028DCC_CB_COLOR6_BASE_EXT, 1, 3029},
	{31539, R_028DD0_CB_COLOR6_ATTRIB2},
	{26219, R_028DD4_CB_COLOR6_VIEW, 3, 3033},
	{26234, R_028DD8_CB_COLOR6_INFO, 16, 3036},
	{26249, R_028DDC_CB_COLOR6_ATTRIB, 10, 3052},
	{31557, R_028DE8_CB_COLOR6_CMASK_BASE_EXT, 1, 3062},
	{31582, R_028DF0_CB_COLOR6_FMASK_BASE_EXT, 1, 3063},
	{31607, R_028E00_CB_COLOR6_DCC_BASE_EXT, 1, 3064},
	{31630, R_028E08_CB_COLOR7_BASE_EXT, 1, 3029},
	{31649, R_028E0C_CB_COLOR7_ATTRIB2},
	{26474, R_028E10_CB_COLOR7_VIEW, 3, 3033},
	{26489, R_028E14_CB_COLOR7_INFO, 16, 3036},
	{26504, R_028E18_CB_COLOR7_ATTRIB, 10, 3052},
	{31667, R_028E24_CB_COLOR7_CMASK_BASE_EXT, 1, 3062},
	{31692, R_028E2C_CB_COLOR7_FMASK_BASE_EXT, 1, 3063},
	{31717, R_028E3C_CB_COLOR7_DCC_BASE_EXT, 1, 3064},
};

static const struct si_field sid_fields_table[] = {
	/* 0 */
	{31740, S_2C3_COUNT_INDIRECT_ENABLE(~0u)},
	{31762, S_2C3_DRAW_INDEX_ENABLE(~0u)},
	/* 2 */
	{31784, S_370_ENGINE_SEL(~0u), 4, 0},
	{31795, S_370_WR_CONFIRM(~0u)},
	{31806, S_370_WR_ONE_ADDR(~0u)},
	{31870, S_370_DST_SEL(~0u), 6, 4},
	/* 6 */
	{31878, S_3F2_IB_SIZE(~0u)},
	{31886, S_3F2_CHAIN(~0u)},
	{31892, S_3F2_VALID(~0u)},
	/* 9 */
	{963, S_410_SRC_ADDR_LO(~0u)},
	/* 10 */
	{31898, S_411_CP_SYNC(~0u)},
	{31930, S_411_SRC_SEL(~0u), 4, 10},
	{31938, S_411_ENGINE(~0u), 2, 0},
	{31969, S_411_DSL_SEL(~0u), 4, 14},
	{975, S_411_SRC_ADDR_HI(~0u)},
	/* 15 */
	{842, S_412_DST_ADDR_LO(~0u)},
	/* 16 */
	{854, S_413_DST_ADDR_HI(~0u)},
	/* 17 */
	{31977, S_414_BYTE_COUNT_GFX6(~0u)},
	{31993, S_414_BYTE_COUNT_GFX9(~0u)},
	{32009, S_414_DISABLE_WR_CONFIRM_GFX6(~0u)},
	{32062, S_414_SRC_SWAP(~0u), 4, 18},
	{32071, S_414_DST_SWAP(~0u), 4, 18},
	{32087, S_414_SAS(~0u), 2, 22},
	{32091, S_414_DAS(~0u), 2, 22},
	{32118, S_414_SAIC(~0u), 2, 24},
	{32123, S_414_DAIC(~0u), 2, 24},
	{32128, S_414_RAW_WAIT(~0u)},
	{32137, S_414_DISABLE_WR_CONFIRM_GFX9(~0u)},
	/* 28 */
	{31898, S_500_CP_SYNC(~0u)},
	{31930, S_500_SRC_SEL(~0u), 4, 10},
	{31969, S_500_DSL_SEL(~0u), 4, 14},
	{31938, S_500_ENGINE(~0u), 2, 0},
	/* 32 */
	{32161, S_000E4C_SDMA_RQ_PENDING(~0u)},
	{32177, S_000E4C_TST_RQ_PENDING(~0u)},
	{32192, S_000E4C_SDMA1_RQ_PENDING(~0u)},
	{32209, S_000E4C_VCE0_RQ_PENDING(~0u)},
	{32225, S_000E4C_VP8_BUSY(~0u)},
	{32234, S_000E4C_SDMA_BUSY(~0u)},
	{32244, S_000E4C_SDMA1_BUSY(~0u)},
	{32255, S_000E4C_VCE0_BUSY(~0u)},
	{32265, S_000E4C_XDMA_BUSY(~0u)},
	{32275, S_000E4C_CHUB_BUSY(~0u)},
	{32285, S_000E4C_SDMA2_BUSY(~0u)},
	{32296, S_000E4C_SDMA3_BUSY(~0u)},
	{32307, S_000E4C_SAMSCP_BUSY(~0u)},
	{32319, S_000E4C_ISP_BUSY(~0u)},
	{32328, S_000E4C_VCE1_BUSY(~0u)},
	{32338, S_000E4C_ODE_BUSY(~0u)},
	{32347, S_000E4C_SDMA2_RQ_PENDING(~0u)},
	{32364, S_000E4C_SDMA3_RQ_PENDING(~0u)},
	{32381, S_000E4C_SAMSCP_RQ_PENDING(~0u)},
	{32399, S_000E4C_ISP_RQ_PENDING(~0u)},
	{32414, S_000E4C_VCE1_RQ_PENDING(~0u)},
	/* 53 */
	{32430, S_000E50_UVD_RQ_PENDING(~0u)},
	{32445, S_000E50_SAMMSP_RQ_PENDING(~0u)},
	{32463, S_000E50_ACP_RQ_PENDING(~0u)},
	{32478, S_000E50_SMU_RQ_PENDING(~0u)},
	{32493, S_000E50_GRBM_RQ_PENDING(~0u)},
	{32509, S_000E50_HI_RQ_PENDING(~0u)},
	{32523, S_000E50_VMC_BUSY(~0u)},
	{32532, S_000E50_MCB_BUSY(~0u)},
	{32541, S_000E50_MCB_NON_DISPLAY_BUSY(~0u)},
	{32562, S_000E50_MCC_BUSY(~0u)},
	{32571, S_000E50_MCD_BUSY(~0u)},
	{32580, S_000E50_VMC1_BUSY(~0u)},
	{32590, S_000E50_SEM_BUSY(~0u)},
	{32599, S_000E50_ACP_BUSY(~0u)},
	{32608, S_000E50_IH_BUSY(~0u)},
	{32616, S_000E50_UVD_BUSY(~0u)},
	{32625, S_000E50_SAMMSP_BUSY(~0u)},
	{32637, S_000E50_GCATCL2_BUSY(~0u)},
	{32650, S_000E50_OSATCL2_BUSY(~0u)},
	{32663, S_000E50_BIF_BUSY(~0u)},
	/* 73 */
	{32672, S_000E54_MCC0_BUSY(~0u)},
	{32682, S_000E54_MCC1_BUSY(~0u)},
	{32692, S_000E54_MCC2_BUSY(~0u)},
	{32702, S_000E54_MCC3_BUSY(~0u)},
	{32712, S_000E54_MCC4_BUSY(~0u)},
	{32722, S_000E54_MCC5_BUSY(~0u)},
	{32732, S_000E54_MCC6_BUSY(~0u)},
	{32742, S_000E54_MCC7_BUSY(~0u)},
	{32752, S_000E54_MCD0_BUSY(~0u)},
	{32762, S_000E54_MCD1_BUSY(~0u)},
	{32772, S_000E54_MCD2_BUSY(~0u)},
	{32782, S_000E54_MCD3_BUSY(~0u)},
	{32792, S_000E54_MCD4_BUSY(~0u)},
	{32802, S_000E54_MCD5_BUSY(~0u)},
	{32812, S_000E54_MCD6_BUSY(~0u)},
	{32822, S_000E54_MCD7_BUSY(~0u)},
	/* 89 */
	{32832, S_00D034_IDLE(~0u)},
	{32837, S_00D034_REG_IDLE(~0u)},
	{32846, S_00D034_RB_EMPTY(~0u)},
	{32855, S_00D034_RB_FULL(~0u)},
	{32863, S_00D034_RB_CMD_IDLE(~0u)},
	{32875, S_00D034_RB_CMD_FULL(~0u)},
	{32887, S_00D034_IB_CMD_IDLE(~0u)},
	{32899, S_00D034_IB_CMD_FULL(~0u)},
	{32911, S_00D034_BLOCK_IDLE(~0u)},
	{32922, S_00D034_INSIDE_IB(~0u)},
	{32932, S_00D034_EX_IDLE(~0u)},
	{32940, S_00D034_EX_IDLE_POLL_TIMER_EXPIRE(~0u)},
	{32966, S_00D034_PACKET_READY(~0u)},
	{32979, S_00D034_MC_WR_IDLE(~0u)},
	{32990, S_00D034_SRBM_IDLE(~0u)},
	{33000, S_00D034_CONTEXT_EMPTY(~0u)},
	{33014, S_00D034_DELTA_RPTR_FULL(~0u)},
	{33030, S_00D034_RB_MC_RREQ_IDLE(~0u)},
	{33046, S_00D034_IB_MC_RREQ_IDLE(~0u)},
	{33062, S_00D034_MC_RD_IDLE(~0u)},
	{33073, S_00D034_DELTA_RPTR_EMPTY(~0u)},
	{33090, S_00D034_MC_RD_RET_STALL(~0u)},
	{33106, S_00D034_MC_RD_NO_POLL_IDLE(~0u)},
	{33125, S_00D034_PREV_CMD_IDLE(~0u)},
	{33139, S_00D034_SEM_IDLE(~0u)},
	{33148, S_00D034_SEM_REQ_STALL(~0u)},
	{33162, S_00D034_SEM_RESP_STATE(~0u)},
	{33177, S_00D034_INT_IDLE(~0u)},
	{33186, S_00D034_INT_REQ_STALL(~0u)},
	/* 118 */
	{33200, S_008008_ME0PIPE1_CMDFIFO_AVAIL(~0u)},
	{33223, S_008008_ME0PIPE1_CF_RQ_PENDING(~0u)},
	{33246, S_008008_ME0PIPE1_PF_RQ_PENDING(~0u)},
	{33269, S_008008_ME1PIPE0_RQ_PENDING(~0u)},
	{33289, S_008008_ME1PIPE1_RQ_PENDING(~0u)},
	{33309, S_008008_ME1PIPE2_RQ_PENDING(~0u)},
	{33329, S_008008_ME1PIPE3_RQ_PENDING(~0u)},
	{33349, S_008008_ME2PIPE0_RQ_PENDING(~0u)},
	{33369, S_008008_ME2PIPE1_RQ_PENDING(~0u)},
	{33389, S_008008_ME2PIPE2_RQ_PENDING(~0u)},
	{33409, S_008008_ME2PIPE3_RQ_PENDING(~0u)},
	{33429, S_008008_RLC_RQ_PENDING(~0u)},
	{33444, S_008008_RLC_BUSY(~0u)},
	{33453, S_008008_TC_BUSY(~0u)},
	{33461, S_008008_TCC_CC_RESIDENT(~0u)},
	{33477, S_008008_CPF_BUSY(~0u)},
	{33486, S_008008_CPC_BUSY(~0u)},
	{33495, S_008008_CPG_BUSY(~0u)},
	/* 136 */
	{33504, S_008010_ME0PIPE0_CMDFIFO_AVAIL(~0u)},
	{33527, S_008010_SRBM_RQ_PENDING(~0u)},
	{33543, S_008010_ME0PIPE0_CF_RQ_PENDING(~0u)},
	{33566, S_008010_ME0PIPE0_PF_RQ_PENDING(~0u)},
	{33589, S_008010_GDS_DMA_RQ_PENDING(~0u)},
	{33608, S_008010_DB_CLEAN(~0u)},
	{33617, S_008010_CB_CLEAN(~0u)},
	{33626, S_008010_TA_BUSY(~0u)},
	{33634, S_008010_GDS_BUSY(~0u)},
	{33643, S_008010_WD_BUSY_NO_DMA(~0u)},
	{33658, S_008010_VGT_BUSY(~0u)},
	{33667, S_008010_IA_BUSY_NO_DMA(~0u)},
	{33682, S_008010_IA_BUSY(~0u)},
	{33690, S_008010_SX_BUSY(~0u)},
	{33698, S_008010_WD_BUSY(~0u)},
	{33706, S_008010_SPI_BUSY(~0u)},
	{33715, S_008010_BCI_BUSY(~0u)},
	{33724, S_008010_SC_BUSY(~0u)},
	{33732, S_008010_PA_BUSY(~0u)},
	{33740, S_008010_DB_BUSY(~0u)},
	{33748, S_008010_CP_COHERENCY_BUSY(~0u)},
	{32311, S_008010_CP_BUSY(~0u)},
	{32533, S_008010_CB_BUSY(~0u)},
	{33766, S_008010_GUI_ACTIVE(~0u)},
	/* 160 */
	{33777, S_00802C_INSTANCE_INDEX(~0u)},
	{33792, S_00802C_SH_INDEX(~0u)},
	{33801, S_00802C_SE_INDEX(~0u)},
	{33810, S_00802C_SH_BROADCAST_WRITES(~0u)},
	{33830, S_00802C_INSTANCE_BROADCAST_WRITES(~0u)},
	{33856, S_00802C_SE_BROADCAST_WRITES(~0u)},
	/* 166 */
	{33876, S_0084FC_OFFSET_UPDATE_DONE(~0u)},
	/* 167 */
	{33895, S_0085F0_DEST_BASE_0_ENA(~0u)},
	{33911, S_0085F0_DEST_BASE_1_ENA(~0u)},
	{33927, S_0085F0_CB0_DEST_BASE_ENA(~0u)},
	{33945, S_0085F0_CB1_DEST_BASE_ENA(~0u)},
	{33963, S_0085F0_CB2_DEST_BASE_ENA(~0u)},
	{33981, S_0085F0_CB3_DEST_BASE_ENA(~0u)},
	{33999, S_0085F0_CB4_DEST_BASE_ENA(~0u)},
	{34017, S_0085F0_CB5_DEST_BASE_ENA(~0u)},
	{34035, S_0085F0_CB6_DEST_BASE_ENA(~0u)},
	{34053, S_0085F0_CB7_DEST_BASE_ENA(~0u)},
	{34071, S_0085F0_DB_DEST_BASE_ENA(~0u)},
	{34088, S_0085F0_DEST_BASE_2_ENA(~0u)},
	{34104, S_0085F0_DEST_BASE_3_ENA(~0u)},
	{34120, S_0085F0_TCL1_ACTION_ENA(~0u)},
	{34136, S_0085F0_TC_ACTION_ENA(~0u)},
	{34150, S_0085F0_CB_ACTION_ENA(~0u)},
	{34164, S_0085F0_DB_ACTION_ENA(~0u)},
	{34178, S_0085F0_SH_KCACHE_ACTION_ENA(~0u)},
	{34199, S_0085F0_SH_ICACHE_ACTION_ENA(~0u)},
	/* 186 */
	{33608, S_008014_DB_CLEAN(~0u)},
	{33617, S_008014_CB_CLEAN(~0u)},
	{33715, S_008014_BCI_BUSY(~0u)},
	{33658, S_008014_VGT_BUSY(~0u)},
	{33732, S_008014_PA_BUSY(~0u)},
	{33626, S_008014_TA_BUSY(~0u)},
	{33690, S_008014_SX_BUSY(~0u)},
	{33706, S_008014_SPI_BUSY(~0u)},
	{33724, S_008014_SC_BUSY(~0u)},
	{33740, S_008014_DB_BUSY(~0u)},
	{32533, S_008014_CB_BUSY(~0u)},
	/* 197 */
	{33608, S_008018_DB_CLEAN(~0u)},
	{33617, S_008018_CB_CLEAN(~0u)},
	{33715, S_008018_BCI_BUSY(~0u)},
	{33658, S_008018_VGT_BUSY(~0u)},
	{33732, S_008018_PA_BUSY(~0u)},
	{33626, S_008018_TA_BUSY(~0u)},
	{33690, S_008018_SX_BUSY(~0u)},
	{33706, S_008018_SPI_BUSY(~0u)},
	{33724, S_008018_SC_BUSY(~0u)},
	{33740, S_008018_DB_BUSY(~0u)},
	{32533, S_008018_CB_BUSY(~0u)},
	/* 208 */
	{33608, S_008038_DB_CLEAN(~0u)},
	{33617, S_008038_CB_CLEAN(~0u)},
	{33715, S_008038_BCI_BUSY(~0u)},
	{33658, S_008038_VGT_BUSY(~0u)},
	{33732, S_008038_PA_BUSY(~0u)},
	{33626, S_008038_TA_BUSY(~0u)},
	{33690, S_008038_SX_BUSY(~0u)},
	{33706, S_008038_SPI_BUSY(~0u)},
	{33724, S_008038_SC_BUSY(~0u)},
	{33740, S_008038_DB_BUSY(~0u)},
	{32533, S_008038_CB_BUSY(~0u)},
	/* 219 */
	{33608, S_00803C_DB_CLEAN(~0u)},
	{33617, S_00803C_CB_CLEAN(~0u)},
	{33715, S_00803C_BCI_BUSY(~0u)},
	{33658, S_00803C_VGT_BUSY(~0u)},
	{33732, S_00803C_PA_BUSY(~0u)},
	{33626, S_00803C_TA_BUSY(~0u)},
	{33690, S_00803C_SX_BUSY(~0u)},
	{33706, S_00803C_SPI_BUSY(~0u)},
	{33724, S_00803C_SC_BUSY(~0u)},
	{33740, S_00803C_DB_BUSY(~0u)},
	{32533, S_00803C_CB_BUSY(~0u)},
	/* 230 */
	{33876, S_0300FC_OFFSET_UPDATE_DONE(~0u)},
	/* 231 */
	{34220, S_0301E4_COHER_BASE_HI_256B(~0u)},
	/* 232 */
	{34239, S_0301EC_START_DELAY_COUNT(~0u)},
	/* 233 */
	{33895, S_0301F0_DEST_BASE_0_ENA(~0u)},
	{33911, S_0301F0_DEST_BASE_1_ENA(~0u)},
	{34257, S_0301F0_TC_SD_ACTION_ENA(~0u)},
	{34274, S_0301F0_TC_NC_ACTION_ENA(~0u)},
	{33927, S_0301F0_CB0_DEST_BASE_ENA(~0u)},
	{33945, S_0301F0_CB1_DEST_BASE_ENA(~0u)},
	{33963, S_0301F0_CB2_DEST_BASE_ENA(~0u)},
	{33981, S_0301F0_CB3_DEST_BASE_ENA(~0u)},
	{33999, S_0301F0_CB4_DEST_BASE_ENA(~0u)},
	{34017, S_0301F0_CB5_DEST_BASE_ENA(~0u)},
	{34035, S_0301F0_CB6_DEST_BASE_ENA(~0u)},
	{34053, S_0301F0_CB7_DEST_BASE_ENA(~0u)},
	{34071, S_0301F0_DB_DEST_BASE_ENA(~0u)},
	{34291, S_0301F0_TCL1_VOL_ACTION_ENA(~0u)},
	{34311, S_0301F0_TC_VOL_ACTION_ENA(~0u)},
	{34329, S_0301F0_TC_WB_ACTION_ENA(~0u)},
	{34088, S_0301F0_DEST_BASE_2_ENA(~0u)},
	{34104, S_0301F0_DEST_BASE_3_ENA(~0u)},
	{34120, S_0301F0_TCL1_ACTION_ENA(~0u)},
	{34136, S_0301F0_TC_ACTION_ENA(~0u)},
	{34150, S_0301F0_CB_ACTION_ENA(~0u)},
	{34164, S_0301F0_DB_ACTION_ENA(~0u)},
	{34178, S_0301F0_SH_KCACHE_ACTION_ENA(~0u)},
	{34346, S_0301F0_SH_KCACHE_VOL_ACTION_ENA(~0u)},
	{34199, S_0301F0_SH_ICACHE_ACTION_ENA(~0u)},
	{34371, S_0301F0_SH_KCACHE_WB_ACTION_ENA(~0u)},
	{34395, S_0301F0_SH_SD_ACTION_ENA(~0u)},
	/* 260 */
	{34412, S_0301FC_MATCHING_GFX_CNTX(~0u)},
	{34430, S_0301FC_MEID(~0u)},
	{34435, S_0301FC_PHASE1_STATUS(~0u)},
	{1005, S_0301FC_STATUS(~0u)},
	/* 264 */
	{34449, S_008210_MEC1_BUSY(~0u)},
	{34459, S_008210_MEC2_BUSY(~0u)},
	{34469, S_008210_DC0_BUSY(~0u)},
	{34478, S_008210_DC1_BUSY(~0u)},
	{34487, S_008210_RCIU1_BUSY(~0u)},
	{34498, S_008210_RCIU2_BUSY(~0u)},
	{34509, S_008210_ROQ1_BUSY(~0u)},
	{34519, S_008210_ROQ2_BUSY(~0u)},
	{34529, S_008210_TCIU_BUSY(~0u)},
	{34539, S_008210_SCRATCH_RAM_BUSY(~0u)},
	{34556, S_008210_QU_BUSY(~0u)},
	{34564, S_008210_ATCL2IU_BUSY(~0u)},
	{34577, S_008210_CPG_CPC_BUSY(~0u)},
	{34590, S_008210_CPF_CPC_BUSY(~0u)},
	{33486, S_008210_CPC_BUSY(~0u)},
	/* 279 */
	{34603, S_008214_MEC1_LOAD_BUSY(~0u)},
	{34618, S_008214_MEC1_SEMAPOHRE_BUSY(~0u)},
	{34638, S_008214_MEC1_MUTEX_BUSY(~0u)},
	{34654, S_008214_MEC1_MESSAGE_BUSY(~0u)},
	{34672, S_008214_MEC1_EOP_QUEUE_BUSY(~0u)},
	{34692, S_008214_MEC1_IQ_QUEUE_BUSY(~0u)},
	{34711, S_008214_MEC1_IB_QUEUE_BUSY(~0u)},
	{34730, S_008214_MEC1_TC_BUSY(~0u)},
	{34743, S_008214_MEC1_DMA_BUSY(~0u)},
	{34757, S_008214_MEC1_PARTIAL_FLUSH_BUSY(~0u)},
	{34781, S_008214_MEC1_PIPE0_BUSY(~0u)},
	{34797, S_008214_MEC1_PIPE1_BUSY(~0u)},
	{34813, S_008214_MEC1_PIPE2_BUSY(~0u)},
	{34829, S_008214_MEC1_PIPE3_BUSY(~0u)},
	{34845, S_008214_MEC2_LOAD_BUSY(~0u)},
	{34860, S_008214_MEC2_SEMAPOHRE_BUSY(~0u)},
	{34880, S_008214_MEC2_MUTEX_BUSY(~0u)},
	{34896, S_008214_MEC2_MESSAGE_BUSY(~0u)},
	{34914, S_008214_MEC2_EOP_QUEUE_BUSY(~0u)},
	{34934, S_008214_MEC2_IQ_QUEUE_BUSY(~0u)},
	{34953, S_008214_MEC2_IB_QUEUE_BUSY(~0u)},
	{34972, S_008214_MEC2_TC_BUSY(~0u)},
	{34985, S_008214_MEC2_DMA_BUSY(~0u)},
	{34999, S_008214_MEC2_PARTIAL_FLUSH_BUSY(~0u)},
	{35023, S_008214_MEC2_PIPE0_BUSY(~0u)},
	{35039, S_008214_MEC2_PIPE1_BUSY(~0u)},
	{35055, S_008214_MEC2_PIPE2_BUSY(~0u)},
	{35071, S_008214_MEC2_PIPE3_BUSY(~0u)},
	/* 307 */
	{35087, S_008218_RCIU_TX_FREE_STALL(~0u)},
	{35106, S_008218_RCIU_PRIV_VIOLATION(~0u)},
	{35126, S_008218_TCIU_TX_FREE_STALL(~0u)},
	{35145, S_008218_MEC1_DECODING_PACKET(~0u)},
	{35166, S_008218_MEC1_WAIT_ON_RCIU(~0u)},
	{35184, S_008218_MEC1_WAIT_ON_RCIU_READ(~0u)},
	{35207, S_008218_MEC1_WAIT_ON_ROQ_DATA(~0u)},
	{35229, S_008218_MEC2_DECODING_PACKET(~0u)},
	{35250, S_008218_MEC2_WAIT_ON_RCIU(~0u)},
	{35268, S_008218_MEC2_WAIT_ON_RCIU_READ(~0u)},
	{35291, S_008218_MEC2_WAIT_ON_ROQ_DATA(~0u)},
	{35313, S_008218_ATCL2IU_WAITING_ON_FREE(~0u)},
	{35337, S_008218_ATCL2IU_WAITING_ON_TAGS(~0u)},
	{35361, S_008218_ATCL1_WAITING_ON_TRANS(~0u)},
	/* 321 */
	{35384, S_00821C_POST_WPTR_GFX_BUSY(~0u)},
	{35403, S_00821C_CSF_BUSY(~0u)},
	{35412, S_00821C_ROQ_ALIGN_BUSY(~0u)},
	{35427, S_00821C_ROQ_RING_BUSY(~0u)},
	{35441, S_00821C_ROQ_INDIRECT1_BUSY(~0u)},
	{35460, S_00821C_ROQ_INDIRECT2_BUSY(~0u)},
	{35479, S_00821C_ROQ_STATE_BUSY(~0u)},
	{35494, S_00821C_ROQ_CE_RING_BUSY(~0u)},
	{35511, S_00821C_ROQ_CE_INDIRECT1_BUSY(~0u)},
	{35533, S_00821C_ROQ_CE_INDIRECT2_BUSY(~0u)},
	{35555, S_00821C_SEMAPHORE_BUSY(~0u)},
	{35570, S_00821C_INTERRUPT_BUSY(~0u)},
	{34529, S_00821C_TCIU_BUSY(~0u)},
	{35585, S_00821C_HQD_BUSY(~0u)},
	{35594, S_00821C_PRT_BUSY(~0u)},
	{34564, S_00821C_ATCL2IU_BUSY(~0u)},
	{35603, S_00821C_CPF_GFX_BUSY(~0u)},
	{35616, S_00821C_CPF_CMP_BUSY(~0u)},
	{35629, S_00821C_GRBM_CPF_STAT_BUSY(~0u)},
	{35648, S_00821C_CPC_CPF_BUSY(~0u)},
	{33477, S_00821C_CPF_BUSY(~0u)},
	/* 342 */
	{35661, S_008220_REG_BUS_FIFO_BUSY(~0u)},
	{35679, S_008220_CSF_RING_BUSY(~0u)},
	{35693, S_008220_CSF_INDIRECT1_BUSY(~0u)},
	{35712, S_008220_CSF_INDIRECT2_BUSY(~0u)},
	{35731, S_008220_CSF_STATE_BUSY(~0u)},
	{35746, S_008220_CSF_CE_INDR1_BUSY(~0u)},
	{35764, S_008220_CSF_CE_INDR2_BUSY(~0u)},
	{35782, S_008220_CSF_ARBITER_BUSY(~0u)},
	{35799, S_008220_CSF_INPUT_BUSY(~0u)},
	{35814, S_008220_OUTSTANDING_READ_TAGS(~0u)},
	{35836, S_008220_HPD_PROCESSING_EOP_BUSY(~0u)},
	{35860, S_008220_HQD_DISPATCH_BUSY(~0u)},
	{35878, S_008220_HQD_IQ_TIMER_BUSY(~0u)},
	{35896, S_008220_HQD_DMA_OFFLOAD_BUSY(~0u)},
	{35917, S_008220_HQD_WAIT_SEMAPHORE_BUSY(~0u)},
	{35941, S_008220_HQD_SIGNAL_SEMAPHORE_BUSY(~0u)},
	{35967, S_008220_HQD_MESSAGE_BUSY(~0u)},
	{35984, S_008220_HQD_PQ_FETCHER_BUSY(~0u)},
	{36004, S_008220_HQD_IB_FETCHER_BUSY(~0u)},
	{36024, S_008220_HQD_IQ_FETCHER_BUSY(~0u)},
	{36044, S_008220_HQD_EOP_FETCHER_BUSY(~0u)},
	{36065, S_008220_HQD_CONSUMED_RPTR_BUSY(~0u)},
	{36088, S_008220_HQD_FETCHER_ARB_BUSY(~0u)},
	{36109, S_008220_HQD_ROQ_ALIGN_BUSY(~0u)},
	{36128, S_008220_HQD_ROQ_EOP_BUSY(~0u)},
	{36145, S_008220_HQD_ROQ_IQ_BUSY(~0u)},
	{36161, S_008220_HQD_ROQ_PQ_BUSY(~0u)},
	{36177, S_008220_HQD_ROQ_IB_BUSY(~0u)},
	{36193, S_008220_HQD_WPTR_POLL_BUSY(~0u)},
	{36212, S_008220_HQD_PQ_BUSY(~0u)},
	{36224, S_008220_HQD_IB_BUSY(~0u)},
	/* 373 */
	{36236, S_008224_RING_FETCHING_DATA(~0u)},
	{36255, S_008224_INDR1_FETCHING_DATA(~0u)},
	{36275, S_008224_INDR2_FETCHING_DATA(~0u)},
	{36295, S_008224_STATE_FETCHING_DATA(~0u)},
	{36315, S_008224_TCIU_WAITING_ON_FREE(~0u)},
	{36336, S_008224_TCIU_WAITING_ON_TAGS(~0u)},
	{35313, S_008224_ATCL2IU_WAITING_ON_FREE(~0u)},
	{35337, S_008224_ATCL2IU_WAITING_ON_TAGS(~0u)},
	{35361, S_008224_ATCL1_WAITING_ON_TRANS(~0u)},
	/* 382 */
	{36357, S_030230_COHER_SIZE_HI_256B(~0u)},
	/* 383 */
	{36376, S_0088B0_PRIM_COUNT(~0u)},
	/* 384 */
	{36387, S_0088C4_VS_NO_EXTRA_BUFFER(~0u)},
	{36406, S_0088C4_STREAMOUT_FULL_FLUSH(~0u)},
	{36427, S_0088C4_ES_LIMIT(~0u)},
	/* 387 */
	{36436, S_0088D4_VERT_REUSE(~0u)},
	/* 388 */
	{22130, S_008958_PRIM_TYPE(~0u), 29, 26},
	/* 389 */
	{203, S_00895C_INDEX_TYPE(~0u), 2, 55},
	/* 390 */
	{38, S_008988_SIZE(~0u)},
	/* 391 */
	{37005, S_0089B0_OFFCHIP_BUFFERING(~0u)},
	/* 392 */
	{37023, S_008A14_CLIP_VTX_REORDER_ENA(~0u)},
	{37044, S_008A14_NUM_CLIP_SEQ(~0u)},
	{37057, S_008A14_CLIPPED_PRIM_SEQ_STALL(~0u)},
	{37080, S_008A14_VE_NAN_PROC_DISABLE(~0u)},
	/* 396 */
	{1777, S_008A60_LINE_STIPPLE_VALUE(~0u)},
	/* 397 */
	{37100, S_008B10_CURRENT_PTR(~0u)},
	{37112, S_008B10_CURRENT_COUNT(~0u)},
	/* 399 */
	{37126, S_008670_CE_TO_CSF_NOT_RDY_TO_RCV(~0u)},
	{37151, S_008670_CE_TO_RAM_INIT_FETCHER_NOT_RDY_TO_RCV(~0u)},
	{37189, S_008670_CE_WAITING_ON_DATA_FROM_RAM_INIT_FETCHER(~0u)},
	{37230, S_008670_CE_TO_RAM_INIT_NOT_RDY(~0u)},
	{37253, S_008670_CE_TO_RAM_DUMP_NOT_RDY(~0u)},
	{37276, S_008670_CE_TO_RAM_WRITE_NOT_RDY(~0u)},
	{37300, S_008670_CE_TO_INC_FIFO_NOT_RDY_TO_RCV(~0u)},
	{37330, S_008670_CE_TO_WR_FIFO_NOT_RDY_TO_RCV(~0u)},
	{37359, S_008670_CE_WAITING_ON_BUFFER_DATA(~0u)},
	{37385, S_008670_CE_WAITING_ON_CE_BUFFER_FLAG(~0u)},
	{37414, S_008670_CE_WAITING_ON_DE_COUNTER(~0u)},
	{37439, S_008670_CE_WAITING_ON_DE_COUNTER_UNDERFLOW(~0u)},
	{36315, S_008670_TCIU_WAITING_ON_FREE(~0u)},
	{36336, S_008670_TCIU_WAITING_ON_TAGS(~0u)},
	{37474, S_008670_CE_STALLED_ON_TC_WR_CONFIRM(~0u)},
	{37502, S_008670_CE_STALLED_ON_ATOMIC_RTN_DATA(~0u)},
	{35313, S_008670_ATCL2IU_WAITING_ON_FREE(~0u)},
	{35337, S_008670_ATCL2IU_WAITING_ON_TAGS(~0u)},
	{35361, S_008670_ATCL1_WAITING_ON_TRANS(~0u)},
	/* 418 */
	{37532, S_008674_RBIU_TO_DMA_NOT_RDY_TO_RCV(~0u)},
	{37559, S_008674_RBIU_TO_SEM_NOT_RDY_TO_RCV(~0u)},
	{37586, S_008674_RBIU_TO_MEMWR_NOT_RDY_TO_RCV(~0u)},
	{37615, S_008674_ME_HAS_ACTIVE_CE_BUFFER_FLAG(~0u)},
	{37644, S_008674_ME_HAS_ACTIVE_DE_BUFFER_FLAG(~0u)},
	{37673, S_008674_ME_STALLED_ON_TC_WR_CONFIRM(~0u)},
	{37701, S_008674_ME_STALLED_ON_ATOMIC_RTN_DATA(~0u)},
	{37731, S_008674_ME_WAITING_ON_TC_READ_DATA(~0u)},
	{37758, S_008674_ME_WAITING_ON_REG_READ_DATA(~0u)},
	{37786, S_008674_RCIU_WAITING_ON_GDS_FREE(~0u)},
	{37811, S_008674_RCIU_WAITING_ON_GRBM_FREE(~0u)},
	{37837, S_008674_RCIU_WAITING_ON_VGT_FREE(~0u)},
	{37862, S_008674_RCIU_STALLED_ON_ME_READ(~0u)},
	{37886, S_008674_RCIU_STALLED_ON_DMA_READ(~0u)},
	{37911, S_008674_RCIU_STALLED_ON_APPEND_READ(~0u)},
	{37939, S_008674_RCIU_HALTED_BY_REG_VIOLATION(~0u)},
	/* 434 */
	{37968, S_008678_PFP_TO_CSF_NOT_RDY_TO_RCV(~0u)},
	{37994, S_008678_PFP_TO_MEQ_NOT_RDY_TO_RCV(~0u)},
	{38020, S_008678_PFP_TO_RCIU_NOT_RDY_TO_RCV(~0u)},
	{38047, S_008678_PFP_TO_VGT_WRITES_PENDING(~0u)},
	{38073, S_008678_PFP_RCIU_READ_PENDING(~0u)},
	{38095, S_008678_PFP_WAITING_ON_BUFFER_DATA(~0u)},
	{38122, S_008678_ME_WAIT_ON_CE_COUNTER(~0u)},
	{38144, S_008678_ME_WAIT_ON_AVAIL_BUFFER(~0u)},
	{38168, S_008678_GFX_CNTX_NOT_AVAIL_TO_ME(~0u)},
	{38193, S_008678_ME_RCIU_NOT_RDY_TO_RCV(~0u)},
	{38216, S_008678_ME_TO_CONST_NOT_RDY_TO_RCV(~0u)},
	{38243, S_008678_ME_WAITING_DATA_FROM_PFP(~0u)},
	{38268, S_008678_ME_WAITING_ON_PARTIAL_FLUSH(~0u)},
	{38296, S_008678_MEQ_TO_ME_NOT_RDY_TO_RCV(~0u)},
	{38321, S_008678_STQ_TO_ME_NOT_RDY_TO_RCV(~0u)},
	{38346, S_008678_ME_WAITING_DATA_FROM_STQ(~0u)},
	{38371, S_008678_PFP_STALLED_ON_TC_WR_CONFIRM(~0u)},
	{38400, S_008678_PFP_STALLED_ON_ATOMIC_RTN_DATA(~0u)},
	{38431, S_008678_EOPD_FIFO_NEEDS_SC_EOP_DONE(~0u)},
	{38459, S_008678_EOPD_FIFO_NEEDS_WR_CONFIRM(~0u)},
	{38486, S_008678_STRMO_WR_OF_PRIM_DATA_PENDING(~0u)},
	{38516, S_008678_PIPE_STATS_WR_DATA_PENDING(~0u)},
	{38543, S_008678_APPEND_RDY_WAIT_ON_CS_DONE(~0u)},
	{38570, S_008678_APPEND_RDY_WAIT_ON_PS_DONE(~0u)},
	{38597, S_008678_APPEND_WAIT_ON_WR_CONFIRM(~0u)},
	{38623, S_008678_APPEND_ACTIVE_PARTITION(~0u)},
	{38647, S_008678_APPEND_WAITING_TO_SEND_MEMWRITE(~0u)},
	{38679, S_008678_SURF_SYNC_NEEDS_IDLE_CNTXS(~0u)},
	{38706, S_008678_SURF_SYNC_NEEDS_ALL_CLEAN(~0u)},
	/* 463 */
	{35427, S_008680_ROQ_RING_BUSY(~0u)},
	{35441, S_008680_ROQ_INDIRECT1_BUSY(~0u)},
	{35460, S_008680_ROQ_INDIRECT2_BUSY(~0u)},
	{35479, S_008680_ROQ_STATE_BUSY(~0u)},
	{38732, S_008680_DC_BUSY(~0u)},
	{34564, S_008680_ATCL2IU_BUSY(~0u)},
	{38740, S_008680_PFP_BUSY(~0u)},
	{38749, S_008680_MEQ_BUSY(~0u)},
	{38758, S_008680_ME_BUSY(~0u)},
	{38766, S_008680_QUERY_BUSY(~0u)},
	{35555, S_008680_SEMAPHORE_BUSY(~0u)},
	{35570, S_008680_INTERRUPT_BUSY(~0u)},
	{38777, S_008680_SURFACE_SYNC_BUSY(~0u)},
	{32235, S_008680_DMA_BUSY(~0u)},
	{38795, S_008680_RCIU_BUSY(~0u)},
	{34539, S_008680_SCRATCH_RAM_BUSY(~0u)},
	{38805, S_008680_CPC_CPG_BUSY(~0u)},
	{38818, S_008680_CE_BUSY(~0u)},
	{34529, S_008680_TCIU_BUSY(~0u)},
	{35494, S_008680_ROQ_CE_RING_BUSY(~0u)},
	{35511, S_008680_ROQ_CE_INDIRECT1_BUSY(~0u)},
	{35533, S_008680_ROQ_CE_INDIRECT2_BUSY(~0u)},
	{32311, S_008680_CP_BUSY(~0u)},
	/* 486 */
	{33777, S_030800_INSTANCE_INDEX(~0u)},
	{33792, S_030800_SH_INDEX(~0u)},
	{33801, S_030800_SE_INDEX(~0u)},
	{33810, S_030800_SH_BROADCAST_WRITES(~0u)},
	{33830, S_030800_INSTANCE_BROADCAST_WRITES(~0u)},
	{33856, S_030800_SE_BROADCAST_WRITES(~0u)},
	/* 492 */
	{22130, S_030908_PRIM_TYPE(~0u), 29, 57},
	/* 493 */
	{203, S_03090C_INDEX_TYPE(~0u), 2, 55},
	/* 494 */
	{38, S_030938_SIZE(~0u)},
	/* 495 */
	{37005, S_03093C_OFFCHIP_BUFFERING(~0u)},
	{38874, S_03093C_OFFCHIP_GRANULARITY(~0u), 4, 86},
	/* 497 */
	{1777, S_030A00_LINE_STIPPLE_VALUE(~0u)},
	/* 498 */
	{37100, S_030A04_CURRENT_PTR(~0u)},
	{37112, S_030A04_CURRENT_COUNT(~0u)},
	/* 500 */
	{445, S_030A10_X(~0u)},
	{91, S_030A10_Y(~0u)},
	/* 502 */
	{445, S_030A14_X(~0u)},
	{91, S_030A14_Y(~0u)},
	/* 504 */
	{445, S_030A18_X(~0u)},
	{91, S_030A18_Y(~0u)},
	/* 506 */
	{445, S_030A2C_X(~0u)},
	{91, S_030A2C_Y(~0u)},
	/* 508 */
	{38894, S_008BF0_ENABLE_PA_SC_OUT_OF_ORDER(~0u)},
	{38920, S_008BF0_DISABLE_SC_DB_TILE_FIX(~0u)},
	{38943, S_008BF0_DISABLE_AA_MASK_FULL_FIX(~0u)},
	{38968, S_008BF0_ENABLE_1XMSAA_SAMPLE_LOCATIONS(~0u)},
	{38999, S_008BF0_ENABLE_1XMSAA_SAMPLE_LOC_CENTROID(~0u)},
	{39033, S_008BF0_DISABLE_SCISSOR_FIX(~0u)},
	{39053, S_008BF0_DISABLE_PW_BUBBLE_COLLAPSE(~0u)},
	{39080, S_008BF0_SEND_UNLIT_STILES_TO_PACKER(~0u)},
	{39108, S_008BF0_DISABLE_DUALGRAD_PERF_OPTIMIZATION(~0u)},
	/* 517 */
	{39143, S_008C08_INST_INVALIDATE(~0u)},
	{39159, S_008C08_DATA_INVALIDATE(~0u)},
	/* 519 */
	{39143, S_030D20_INST_INVALIDATE(~0u)},
	{39159, S_030D20_DATA_INVALIDATE(~0u)},
	{39175, S_030D20_INVALIDATE_VOLATILE(~0u)},
	/* 522 */
	{39195, S_008C0C_RET(~0u)},
	{39199, S_008C0C_RUI(~0u)},
	{39203, S_008C0C_RNG(~0u)},
	/* 525 */
	{2571, S_008DFC_EN(~0u)},
	{39266, S_008DFC_TGT(~0u), 33, 90},
	{39270, S_008DFC_COMPR(~0u)},
	{33890, S_008DFC_DONE(~0u)},
	{39276, S_008DFC_VM(~0u)},
	{39296, S_008DFC_ENCODING(~0u), 63, 123},
	/* 531 */
	{39305, S_030E04_ADDRESS(~0u)},
	/* 532 */
	{2791, S_030F04_COUNT_HI(~0u)},
	/* 533 */
	{39313, S_008F04_BASE_ADDRESS_HI(~0u)},
	{23319, S_008F04_STRIDE(~0u)},
	{39329, S_008F04_CACHE_SWIZZLE(~0u)},
	{39343, S_008F04_SWIZZLE_ENABLE(~0u)},
	/* 537 */
	{2791, S_030F0C_COUNT_HI(~0u)},
	/* 538 */
	{39448, S_008F0C_DST_SEL_X(~0u), 8, 186},
	{39458, S_008F0C_DST_SEL_Y(~0u), 8, 186},
	{39468, S_008F0C_DST_SEL_Z(~0u), 8, 186},
	{39478, S_008F0C_DST_SEL_W(~0u), 8, 186},
	{39662, S_008F0C_NUM_FORMAT(~0u), 8, 194},
	{40054, S_008F0C_DATA_FORMAT(~0u), 16, 202},
	{40066, S_008F0C_ELEMENT_SIZE(~0u)},
	{40079, S_008F0C_INDEX_STRIDE(~0u)},
	{40092, S_008F0C_ADD_TID_ENABLE(~0u)},
	{40107, S_008F0C_ATC(~0u)},
	{40111, S_008F0C_HASH_ENABLE(~0u)},
	{40123, S_008F0C_HEAP(~0u)},
	{40128, S_008F0C_MTYPE(~0u)},
	{209, S_008F0C_TYPE(~0u), 4, 218},
	/* 552 */
	{2791, S_030F14_COUNT_HI(~0u)},
	/* 553 */
	{39313, S_008F14_BASE_ADDRESS_HI(~0u)},
	{40203, S_008F14_MIN_LOD(~0u)},
	{41836, S_008F14_DATA_FORMAT_GFX6(~0u), 64, 222},
	{42220, S_008F14_NUM_FORMAT_GFX6(~0u), 16, 286},
	{40128, S_008F14_MTYPE(~0u)},
	/* 558 */
	{42236, S_008F18_WIDTH(~0u)},
	{42242, S_008F18_HEIGHT(~0u)},
	{42249, S_008F18_PERF_MOD(~0u)},
	{42258, S_008F18_INTERLACED(~0u)},
	/* 562 */
	{2791, S_030F1C_COUNT_HI(~0u)},
	/* 563 */
	{39448, S_008F1C_DST_SEL_X(~0u), 8, 186},
	{39458, S_008F1C_DST_SEL_Y(~0u), 8, 186},
	{39468, S_008F1C_DST_SEL_Z(~0u), 8, 186},
	{39478, S_008F1C_DST_SEL_W(~0u), 8, 186},
	{42269, S_008F1C_BASE_LEVEL(~0u)},
	{42280, S_008F1C_LAST_LEVEL(~0u)},
	{42291, S_008F1C_TILING_INDEX(~0u)},
	{42304, S_008F1C_POW2_PAD(~0u)},
	{40128, S_008F1C_MTYPE(~0u)},
	{40107, S_008F1C_ATC(~0u)},
	{209, S_008F1C_TYPE(~0u), 16, 302},
	/* 574 */
	{22114, S_008F20_DEPTH(~0u)},
	{42615, S_008F20_PITCH_GFX6(~0u)},
	/* 576 */
	{42626, S_008F24_BASE_ARRAY(~0u)},
	{42637, S_008F24_LAST_ARRAY(~0u)},
	/* 578 */
	{42648, S_008F28_MIN_LOD_WARN(~0u)},
	{42661, S_008F28_COUNTER_BANK_ID(~0u)},
	{42677, S_008F28_LOD_HDW_CNT_EN(~0u)},
	{42692, S_008F28_COMPRESSION_EN(~0u)},
	{42707, S_008F28_ALPHA_IS_ON_MSB(~0u)},
	{42723, S_008F28_COLOR_TRANSFORM(~0u)},
	{42739, S_008F28_LOST_ALPHA_BITS(~0u)},
	{42755, S_008F28_LOST_COLOR_BITS(~0u)},
	/* 586 */
	{42953, S_008F30_CLAMP_X(~0u), 8, 318},
	{42961, S_008F30_CLAMP_Y(~0u), 8, 318},
	{42969, S_008F30_CLAMP_Z(~0u), 8, 318},
	{42977, S_008F30_MAX_ANISO_RATIO(~0u)},
	{43225, S_008F30_DEPTH_COMPARE_FUNC(~0u), 8, 326},
	{43244, S_008F30_FORCE_UNNORMALIZED(~0u)},
	{43263, S_008F30_ANISO_THRESHOLD(~0u)},
	{43279, S_008F30_MC_COORD_TRUNC(~0u)},
	{43294, S_008F30_FORCE_DEGAMMA(~0u)},
	{43308, S_008F30_ANISO_BIAS(~0u)},
	{43319, S_008F30_TRUNC_COORD(~0u)},
	{43331, S_008F30_DISABLE_CUBE_WRAP(~0u)},
	{43349, S_008F30_FILTER_MODE(~0u)},
	{43361, S_008F30_COMPAT_MODE(~0u)},
	/* 600 */
	{40203, S_008F34_MIN_LOD(~0u)},
	{43373, S_008F34_MAX_LOD(~0u)},
	{43381, S_008F34_PERF_MIP(~0u)},
	{43390, S_008F34_PERF_Z(~0u)},
	/* 604 */
	{43397, S_008F38_LOD_BIAS(~0u)},
	{43406, S_008F38_LOD_BIAS_SEC(~0u)},
	{43468, S_008F38_XY_MAG_FILTER(~0u), 2, 334},
	{43543, S_008F38_XY_MIN_FILTER(~0u), 4, 336},
	{43623, S_008F38_Z_FILTER(~0u), 3, 340},
	{43632, S_008F38_MIP_FILTER(~0u), 3, 340},
	{43643, S_008F38_MIP_POINT_PRECLAMP(~0u)},
	{43662, S_008F38_DISABLE_LSB_CEIL(~0u)},
	{43679, S_008F38_FILTER_PREC_FIX(~0u)},
	{43695, S_008F38_ANISO_OVERRIDE(~0u)},
	/* 614 */
	{43710, S_008F3C_BORDER_COLOR_PTR(~0u)},
	{43727, S_008F3C_UPGRADED_DEPTH(~0u)},
	{43869, S_008F3C_BORDER_COLOR_TYPE(~0u), 4, 343},
	/* 617 */
	{43887, S_0090DC_VS_LOW_THRESHOLD(~0u)},
	{43904, S_0090DC_GS_LOW_THRESHOLD(~0u)},
	{43921, S_0090DC_ES_LOW_THRESHOLD(~0u)},
	{43938, S_0090DC_HS_LOW_THRESHOLD(~0u)},
	{43955, S_0090DC_LS_LOW_THRESHOLD(~0u)},
	/* 622 */
	{43972, S_0090E0_PS_CU_EN(~0u)},
	{43981, S_0090E0_VS_CU_EN(~0u)},
	/* 624 */
	{43990, S_0090E4_GS_CU_EN(~0u)},
	{43999, S_0090E4_ES_CU_EN(~0u)},
	/* 626 */
	{44008, S_0090E8_LSHS_CU_EN(~0u)},
	/* 627 */
	{2656, S_0090EC_MAX_WAVE_ID(~0u)},
	/* 628 */
	{2656, S_0090E8_MAX_WAVE_ID(~0u)},
	/* 629 */
	{44024, S_0090F0_RING_ORDER_TS0(~0u), 1, 347},
	{44039, S_0090F0_RING_ORDER_TS1(~0u)},
	{44054, S_0090F0_RING_ORDER_TS2(~0u)},
	/* 632 */
	{44069, S_00C700_PIPE_ORDER_TS0(~0u)},
	{44084, S_00C700_PIPE_ORDER_TS1(~0u)},
	{44099, S_00C700_PIPE_ORDER_TS2(~0u)},
	{44114, S_00C700_PIPE_ORDER_TS3(~0u)},
	{44129, S_00C700_TS0_DUR_MULT(~0u)},
	{44142, S_00C700_TS1_DUR_MULT(~0u)},
	{44155, S_00C700_TS2_DUR_MULT(~0u)},
	{44168, S_00C700_TS3_DUR_MULT(~0u)},
	/* 640 */
	{44181, S_0090F4_TS0_DURATION(~0u)},
	{44194, S_0090F4_TS1_DURATION(~0u)},
	/* 642 */
	{44207, S_0090F8_TS2_DURATION(~0u)},
	/* 643 */
	{38, S_008F40_SIZE(~0u)},
	/* 644 */
	{669, S_008F44_OFFSET(~0u)},
	/* 645 */
	{2791, S_030FFC_COUNT_HI(~0u)},
	/* 646 */
	{44220, S_009100_GPR_WRITE_PRIORITY(~0u)},
	{44239, S_009100_EXP_PRIORITY_ORDER(~0u)},
	{44258, S_009100_ENABLE_SQG_TOP_EVENTS(~0u)},
	{44280, S_009100_ENABLE_SQG_BOP_EVENTS(~0u)},
	{44302, S_009100_RSRC_MGMT_RESET(~0u)},
	/* 651 */
	{44571, S_00913C_VTX_DONE_DELAY(~0u), 16, 348},
	{44586, S_00913C_INTERP_ONE_PRIM_PER_ROW(~0u)},
	{44610, S_00913C_PC_LIMIT_ENABLE(~0u)},
	{44626, S_00913C_PC_LIMIT_STRICT(~0u)},
	{44642, S_00913C_PC_LIMIT_SIZE(~0u)},
	/* 656 */
	{44656, S_00936C_TYPE_A(~0u)},
	{44663, S_00936C_VGPR_A(~0u)},
	{44670, S_00936C_SGPR_A(~0u)},
	{44677, S_00936C_LDS_A(~0u)},
	{44683, S_00936C_WAVES_A(~0u)},
	{44691, S_00936C_EN_A(~0u)},
	{44696, S_00936C_TYPE_B(~0u)},
	{44703, S_00936C_VGPR_B(~0u)},
	{44710, S_00936C_SGPR_B(~0u)},
	{44717, S_00936C_LDS_B(~0u)},
	{44723, S_00936C_WAVES_B(~0u)},
	{44731, S_00936C_EN_B(~0u)},
	/* 668 */
	{44736, S_009858_MSAA1_X(~0u)},
	{44744, S_009858_MSAA1_Y(~0u)},
	{44752, S_009858_MSAA2_X(~0u)},
	{44760, S_009858_MSAA2_Y(~0u)},
	{44768, S_009858_MSAA4_X(~0u)},
	{44776, S_009858_MSAA4_Y(~0u)},
	{44784, S_009858_MSAA8_X(~0u)},
	{44792, S_009858_MSAA8_Y(~0u)},
	{44800, S_009858_MSAA16_X(~0u)},
	{44809, S_009858_MSAA16_Y(~0u)},
	/* 678 */
	{44818, S_0098F8_NUM_PIPES(~0u)},
	{44828, S_0098F8_PIPE_INTERLEAVE_SIZE_GFX6(~0u)},
	{44854, S_0098F8_BANK_INTERLEAVE_SIZE(~0u)},
	{44875, S_0098F8_NUM_SHADER_ENGINES_GFX6(~0u)},
	{44899, S_0098F8_SHADER_ENGINE_TILE_SIZE(~0u)},
	{44923, S_0098F8_NUM_GPUS_GFX6(~0u)},
	{44937, S_0098F8_MULTI_GPU_TILE_SIZE(~0u)},
	{44957, S_0098F8_ROW_SIZE(~0u)},
	{44966, S_0098F8_NUM_LOWER_PIPES(~0u)},
	/* 687 */
	{45099, S_009910_MICRO_TILE_MODE(~0u), 4, 364},
	{45344, S_009910_ARRAY_MODE(~0u), 16, 368},
	{45706, S_009910_PIPE_CONFIG(~0u), 15, 384},
	{45896, S_009910_TILE_SPLIT(~0u), 7, 399},
	{45999, S_009910_BANK_WIDTH(~0u), 4, 406},
	{46106, S_009910_BANK_HEIGHT(~0u), 4, 410},
	{46218, S_009910_MACRO_TILE_ASPECT(~0u), 4, 414},
	{46305, S_009910_NUM_BANKS(~0u), 4, 418},
	{46346, S_009910_MICRO_TILE_MODE_NEW(~0u), 4, 422},
	{46366, S_009910_SAMPLE_SPLIT(~0u)},
	/* 697 */
	{45999, S_009990_BANK_WIDTH(~0u)},
	{46106, S_009990_BANK_HEIGHT(~0u)},
	{46218, S_009990_MACRO_TILE_ASPECT(~0u)},
	{46305, S_009990_NUM_BANKS(~0u)},
	/* 701 */
	{46379, S_00B004_MEM_BASE(~0u)},
	/* 702 */
	{46379, S_00B00C_MEM_BASE(~0u)},
	/* 703 */
	{43975, S_00B01C_CU_EN(~0u)},
	{46388, S_00B01C_WAVE_LIMIT(~0u)},
	{46399, S_00B01C_LOCK_LOW_THRESHOLD(~0u)},
	/* 706 */
	{46379, S_00B024_MEM_BASE(~0u)},
	/* 707 */
	{46418, S_00B028_VGPRS(~0u)},
	{46424, S_00B028_SGPRS(~0u)},
	{2676, S_00B028_PRIORITY(~0u)},
	{46473, S_00B028_FLOAT_MODE(~0u), 241, 426},
	{46484, S_00B028_PRIV(~0u)},
	{46489, S_00B028_DX10_CLAMP(~0u)},
	{46500, S_00B028_DEBUG_MODE(~0u)},
	{46511, S_00B028_IEEE_MODE(~0u)},
	{46521, S_00B028_CU_GROUP_DISABLE(~0u)},
	{46538, S_00B028_CACHE_CTL(~0u)},
	{46548, S_00B028_CDBG_USER(~0u)},
	/* 718 */
	{46558, S_00B02C_SCRATCH_EN(~0u)},
	{46569, S_00B02C_USER_SGPR(~0u)},
	{46579, S_00B02C_TRAP_PRESENT(~0u)},
	{46592, S_00B02C_WAVE_CNT_EN(~0u)},
	{46604, S_00B02C_EXTRA_LDS_SIZE(~0u)},
	{46619, S_00B02C_EXCP_EN_SI(~0u)},
	{46630, S_00B02C_EXCP_EN(~0u)},
	/* 725 */
	{46379, S_00B104_MEM_BASE(~0u)},
	/* 726 */
	{46379, S_00B10C_MEM_BASE(~0u)},
	/* 727 */
	{43975, S_00B118_CU_EN(~0u)},
	{46388, S_00B118_WAVE_LIMIT(~0u)},
	{46399, S_00B118_LOCK_LOW_THRESHOLD(~0u)},
	/* 730 */
	{36430, S_00B11C_LIMIT(~0u)},
	/* 731 */
	{46379, S_00B124_MEM_BASE(~0u)},
	/* 732 */
	{46418, S_00B128_VGPRS(~0u)},
	{46424, S_00B128_SGPRS(~0u)},
	{2676, S_00B128_PRIORITY(~0u)},
	{46473, S_00B128_FLOAT_MODE(~0u)},
	{46484, S_00B128_PRIV(~0u)},
	{46489, S_00B128_DX10_CLAMP(~0u)},
	{46500, S_00B128_DEBUG_MODE(~0u)},
	{46511, S_00B128_IEEE_MODE(~0u)},
	{46638, S_00B128_VGPR_COMP_CNT(~0u)},
	{46652, S_00B128_CU_GROUP_ENABLE(~0u)},
	{46538, S_00B128_CACHE_CTL(~0u)},
	{46548, S_00B128_CDBG_USER(~0u)},
	/* 744 */
	{46558, S_00B12C_SCRATCH_EN(~0u)},
	{46569, S_00B12C_USER_SGPR(~0u)},
	{46579, S_00B12C_TRAP_PRESENT(~0u)},
	{46668, S_00B12C_OC_LDS_EN(~0u)},
	{46678, S_00B12C_SO_BASE0_EN(~0u)},
	{46690, S_00B12C_SO_BASE1_EN(~0u)},
	{46702, S_00B12C_SO_BASE2_EN(~0u)},
	{46714, S_00B12C_SO_BASE3_EN(~0u)},
	{46726, S_00B12C_SO_EN(~0u)},
	{46619, S_00B12C_EXCP_EN_SI(~0u)},
	{46630, S_00B12C_EXCP_EN(~0u)},
	{46732, S_00B12C_DISPATCH_DRAW_EN(~0u)},
	/* 756 */
	{46379, S_00B204_MEM_BASE(~0u)},
	/* 757 */
	{46379, S_00B20C_MEM_BASE(~0u)},
	/* 758 */
	{43975, S_00B21C_CU_EN(~0u)},
	{46388, S_00B21C_WAVE_LIMIT(~0u)},
	{46399, S_00B21C_LOCK_LOW_THRESHOLD(~0u)},
	{46749, S_00B21C_GROUP_FIFO_DEPTH(~0u)},
	/* 762 */
	{46379, S_00B224_MEM_BASE(~0u)},
	/* 763 */
	{46418, S_00B228_VGPRS(~0u)},
	{46424, S_00B228_SGPRS(~0u)},
	{2676, S_00B228_PRIORITY(~0u)},
	{46473, S_00B228_FLOAT_MODE(~0u)},
	{46484, S_00B228_PRIV(~0u)},
	{46489, S_00B228_DX10_CLAMP(~0u)},
	{46500, S_00B228_DEBUG_MODE(~0u)},
	{46511, S_00B228_IEEE_MODE(~0u)},
	{46652, S_00B228_CU_GROUP_ENABLE(~0u)},
	{46538, S_00B228_CACHE_CTL(~0u)},
	{46548, S_00B228_CDBG_USER(~0u)},
	/* 774 */
	{46558, S_00B22C_SCRATCH_EN(~0u)},
	{46569, S_00B22C_USER_SGPR(~0u)},
	{46579, S_00B22C_TRAP_PRESENT(~0u)},
	{46619, S_00B22C_EXCP_EN_SI(~0u)},
	{46630, S_00B22C_EXCP_EN(~0u)},
	/* 779 */
	{46379, S_00B304_MEM_BASE(~0u)},
	/* 780 */
	{46379, S_00B30C_MEM_BASE(~0u)},
	/* 781 */
	{43975, S_00B31C_CU_EN(~0u)},
	{46388, S_00B31C_WAVE_LIMIT(~0u)},
	{46399, S_00B31C_LOCK_LOW_THRESHOLD(~0u)},
	{46749, S_00B31C_GROUP_FIFO_DEPTH(~0u)},
	/* 785 */
	{46379, S_00B324_MEM_BASE(~0u)},
	/* 786 */
	{46418, S_00B328_VGPRS(~0u)},
	{46424, S_00B328_SGPRS(~0u)},
	{2676, S_00B328_PRIORITY(~0u)},
	{46473, S_00B328_FLOAT_MODE(~0u)},
	{46484, S_00B328_PRIV(~0u)},
	{46489, S_00B328_DX10_CLAMP(~0u)},
	{46500, S_00B328_DEBUG_MODE(~0u)},
	{46511, S_00B328_IEEE_MODE(~0u)},
	{46638, S_00B328_VGPR_COMP_CNT(~0u)},
	{46652, S_00B328_CU_GROUP_ENABLE(~0u)},
	{46538, S_00B328_CACHE_CTL(~0u)},
	{46548, S_00B328_CDBG_USER(~0u)},
	/* 798 */
	{46558, S_00B32C_SCRATCH_EN(~0u)},
	{46569, S_00B32C_USER_SGPR(~0u)},
	{46579, S_00B32C_TRAP_PRESENT(~0u)},
	{46668, S_00B32C_OC_LDS_EN(~0u)},
	{46619, S_00B32C_EXCP_EN_SI(~0u)},
	{46630, S_00B32C_EXCP_EN(~0u)},
	{46610, S_00B32C_LDS_SIZE(~0u)},
	/* 805 */
	{46379, S_00B404_MEM_BASE(~0u)},
	/* 806 */
	{46379, S_00B40C_MEM_BASE(~0u)},
	/* 807 */
	{46388, S_00B41C_WAVE_LIMIT(~0u)},
	{46399, S_00B41C_LOCK_LOW_THRESHOLD(~0u)},
	{46749, S_00B41C_GROUP_FIFO_DEPTH(~0u)},
	/* 810 */
	{46379, S_00B424_MEM_BASE(~0u)},
	/* 811 */
	{46418, S_00B428_VGPRS(~0u)},
	{46424, S_00B428_SGPRS(~0u)},
	{2676, S_00B428_PRIORITY(~0u)},
	{46473, S_00B428_FLOAT_MODE(~0u)},
	{46484, S_00B428_PRIV(~0u)},
	{46489, S_00B428_DX10_CLAMP(~0u)},
	{46500, S_00B428_DEBUG_MODE(~0u)},
	{46511, S_00B428_IEEE_MODE(~0u)},
	{46538, S_00B428_CACHE_CTL(~0u)},
	{46548, S_00B428_CDBG_USER(~0u)},
	/* 821 */
	{46558, S_00B42C_SCRATCH_EN(~0u)},
	{46569, S_00B42C_USER_SGPR(~0u)},
	{46579, S_00B42C_TRAP_PRESENT(~0u)},
	{46668, S_00B42C_OC_LDS_EN(~0u)},
	{46766, S_00B42C_TG_SIZE_EN(~0u)},
	{46619, S_00B42C_EXCP_EN_SI(~0u)},
	{46777, S_00B42C_EXCP_EN_CIK_VI(~0u)},
	/* 828 */
	{46379, S_00B504_MEM_BASE(~0u)},
	/* 829 */
	{46379, S_00B50C_MEM_BASE(~0u)},
	/* 830 */
	{43975, S_00B51C_CU_EN(~0u)},
	{46388, S_00B51C_WAVE_LIMIT(~0u)},
	{46399, S_00B51C_LOCK_LOW_THRESHOLD(~0u)},
	{46749, S_00B51C_GROUP_FIFO_DEPTH(~0u)},
	/* 834 */
	{46379, S_00B524_MEM_BASE(~0u)},
	/* 835 */
	{46418, S_00B528_VGPRS(~0u)},
	{46424, S_00B528_SGPRS(~0u)},
	{2676, S_00B528_PRIORITY(~0u)},
	{46473, S_00B528_FLOAT_MODE(~0u)},
	{46484, S_00B528_PRIV(~0u)},
	{46489, S_00B528_DX10_CLAMP(~0u)},
	{46500, S_00B528_DEBUG_MODE(~0u)},
	{46511, S_00B528_IEEE_MODE(~0u)},
	{46638, S_00B528_VGPR_COMP_CNT(~0u)},
	{46538, S_00B528_CACHE_CTL(~0u)},
	{46548, S_00B528_CDBG_USER(~0u)},
	/* 846 */
	{46558, S_00B52C_SCRATCH_EN(~0u)},
	{46569, S_00B52C_USER_SGPR(~0u)},
	{46579, S_00B52C_TRAP_PRESENT(~0u)},
	{46610, S_00B52C_LDS_SIZE(~0u)},
	{46619, S_00B52C_EXCP_EN_SI(~0u)},
	{46630, S_00B52C_EXCP_EN(~0u)},
	/* 852 */
	{46792, S_00B800_COMPUTE_SHADER_EN(~0u)},
	{46810, S_00B800_PARTIAL_TG_EN(~0u)},
	{46824, S_00B800_FORCE_START_AT_000(~0u)},
	{46843, S_00B800_ORDERED_APPEND_ENBL(~0u)},
	{46863, S_00B800_ORDERED_APPEND_MODE(~0u)},
	{46883, S_00B800_USE_THREAD_DIMENSIONS(~0u)},
	{46905, S_00B800_ORDER_MODE(~0u)},
	{46916, S_00B800_DISPATCH_CACHE_CNTL(~0u)},
	{46936, S_00B800_SCALAR_L1_INV_VOL(~0u)},
	{46954, S_00B800_VECTOR_L1_INV_VOL(~0u)},
	{46972, S_00B800_DATA_ATC(~0u)},
	{46981, S_00B800_RESTORE(~0u)},
	/* 864 */
	{46989, S_00B81C_NUM_THREAD_FULL(~0u)},
	{47005, S_00B81C_NUM_THREAD_PARTIAL(~0u)},
	/* 866 */
	{46989, S_00B820_NUM_THREAD_FULL(~0u)},
	{47005, S_00B820_NUM_THREAD_PARTIAL(~0u)},
	/* 868 */
	{46989, S_00B824_NUM_THREAD_FULL(~0u)},
	{47005, S_00B824_NUM_THREAD_PARTIAL(~0u)},
	/* 870 */
	{2656, S_00B82C_MAX_WAVE_ID(~0u)},
	/* 871 */
	{7630, S_00B828_PIPELINESTAT_ENABLE(~0u)},
	/* 872 */
	{7658, S_00B82C_PERFCOUNT_ENABLE(~0u)},
	/* 873 */
	{391, S_00B834_DATA(~0u)},
	{47024, S_00B834_INST_ATC(~0u)},
	/* 875 */
	{391, S_00B83C_DATA(~0u)},
	/* 876 */
	{391, S_00B844_DATA(~0u)},
	/* 877 */
	{46418, S_00B848_VGPRS(~0u)},
	{46424, S_00B848_SGPRS(~0u)},
	{2676, S_00B848_PRIORITY(~0u)},
	{46473, S_00B848_FLOAT_MODE(~0u)},
	{46484, S_00B848_PRIV(~0u)},
	{46489, S_00B848_DX10_CLAMP(~0u)},
	{46500, S_00B848_DEBUG_MODE(~0u)},
	{46511, S_00B848_IEEE_MODE(~0u)},
	{47033, S_00B848_BULKY(~0u)},
	{46548, S_00B848_CDBG_USER(~0u)},
	/* 887 */
	{46558, S_00B84C_SCRATCH_EN(~0u)},
	{46569, S_00B84C_USER_SGPR(~0u)},
	{46579, S_00B84C_TRAP_PRESENT(~0u)},
	{47039, S_00B84C_TGID_X_EN(~0u)},
	{47049, S_00B84C_TGID_Y_EN(~0u)},
	{47059, S_00B84C_TGID_Z_EN(~0u)},
	{46766, S_00B84C_TG_SIZE_EN(~0u)},
	{47069, S_00B84C_TIDIG_COMP_CNT(~0u)},
	{47084, S_00B84C_EXCP_EN_MSB(~0u)},
	{46610, S_00B84C_LDS_SIZE(~0u)},
	{46630, S_00B84C_EXCP_EN(~0u)},
	/* 898 */
	{391, S_00B850_DATA(~0u)},
	/* 899 */
	{47096, S_00B854_WAVES_PER_SH_SI(~0u)},
	{47112, S_00B854_WAVES_PER_SH(~0u)},
	{47125, S_00B854_TG_PER_CU(~0u)},
	{47135, S_00B854_LOCK_THRESHOLD(~0u)},
	{47150, S_00B854_SIMD_DEST_CNTL(~0u)},
	{47165, S_00B854_FORCE_SIMD_DIST(~0u)},
	{47181, S_00B854_CU_GROUP_COUNT(~0u)},
	/* 906 */
	{47196, S_00B858_SH0_CU_EN(~0u)},
	{47206, S_00B858_SH1_CU_EN(~0u)},
	/* 908 */
	{47196, S_00B85C_SH0_CU_EN(~0u)},
	{47206, S_00B85C_SH1_CU_EN(~0u)},
	/* 910 */
	{47216, S_00B860_WAVES(~0u)},
	{47222, S_00B860_WAVESIZE(~0u)},
	/* 912 */
	{47196, S_00B864_SH0_CU_EN(~0u)},
	{47206, S_00B864_SH1_CU_EN(~0u)},
	/* 914 */
	{47196, S_00B868_SH0_CU_EN(~0u)},
	{47206, S_00B868_SH1_CU_EN(~0u)},
	/* 916 */
	{47231, S_00B87C_SEND_SEID(~0u)},
	{45427, S_00B87C_RESERVED2(~0u)},
	{47241, S_00B87C_RESERVED3(~0u)},
	{47251, S_00B87C_RESERVED4(~0u)},
	{47261, S_00B87C_WAVE_ID_BASE(~0u)},
	/* 921 */
	{47274, S_00B888_PAYLOAD(~0u)},
	{47282, S_00B888_IS_EVENT(~0u)},
	{47291, S_00B888_IS_STATE(~0u)},
	/* 924 */
	{2051, S_00B890_ADDR(~0u)},
	/* 925 */
	{40107, S_00B894_ATC(~0u)},
	{40128, S_00B894_MTYPE(~0u)},
	/* 927 */
	{8905, S_034404_PERFCOUNTER_HI(~0u)},
	/* 928 */
	{47300, S_036008_PERF_SEL(~0u)},
	{47309, S_036008_PERF_SEL1(~0u)},
	{47319, S_036008_CNTR_MODE(~0u)},
	/* 931 */
	{47329, S_036004_PERF_SEL2(~0u)},
	{47339, S_036004_PERF_SEL3(~0u)},
	/* 933 */
	{47300, S_036024_PERF_SEL(~0u)},
	{47309, S_036024_PERF_SEL1(~0u)},
	{47319, S_036024_CNTR_MODE(~0u)},
	/* 936 */
	{47329, S_036010_PERF_SEL2(~0u)},
	{47339, S_036010_PERF_SEL3(~0u)},
	/* 938 */
	{47300, S_03601C_PERF_SEL(~0u)},
	{47309, S_03601C_PERF_SEL1(~0u)},
	{47319, S_03601C_CNTR_MODE(~0u)},
	/* 941 */
	{47329, S_036018_PERF_SEL2(~0u)},
	{47339, S_036018_PERF_SEL3(~0u)},
	/* 943 */
	{47396, S_036020_PERFMON_STATE(~0u), 3, 667},
	{47410, S_036020_SPM_PERFMON_STATE(~0u)},
	{47428, S_036020_PERFMON_ENABLE_MODE(~0u)},
	{47448, S_036020_PERFMON_SAMPLE_ENABLE(~0u)},
	/* 947 */
	{47300, S_036100_PERF_SEL(~0u)},
	{47470, S_036100_DB_CLEAN_USER_DEFINED_MASK(~0u)},
	{47497, S_036100_CB_CLEAN_USER_DEFINED_MASK(~0u)},
	{47524, S_036100_VGT_BUSY_USER_DEFINED_MASK(~0u)},
	{47551, S_036100_TA_BUSY_USER_DEFINED_MASK(~0u)},
	{47577, S_036100_SX_BUSY_USER_DEFINED_MASK(~0u)},
	{47603, S_036100_SPI_BUSY_USER_DEFINED_MASK(~0u)},
	{47630, S_036100_SC_BUSY_USER_DEFINED_MASK(~0u)},
	{47656, S_036100_PA_BUSY_USER_DEFINED_MASK(~0u)},
	{47682, S_036100_GRBM_BUSY_USER_DEFINED_MASK(~0u)},
	{47710, S_036100_DB_BUSY_USER_DEFINED_MASK(~0u)},
	{47736, S_036100_CB_BUSY_USER_DEFINED_MASK(~0u)},
	{47762, S_036100_CP_BUSY_USER_DEFINED_MASK(~0u)},
	{47788, S_036100_IA_BUSY_USER_DEFINED_MASK(~0u)},
	{47814, S_036100_GDS_BUSY_USER_DEFINED_MASK(~0u)},
	{47841, S_036100_BCI_BUSY_USER_DEFINED_MASK(~0u)},
	{47868, S_036100_RLC_BUSY_USER_DEFINED_MASK(~0u)},
	{47895, S_036100_TC_BUSY_USER_DEFINED_MASK(~0u)},
	{47921, S_036100_WD_BUSY_USER_DEFINED_MASK(~0u)},
	/* 966 */
	{47300, S_036108_PERF_SEL(~0u)},
	{47470, S_036108_DB_CLEAN_USER_DEFINED_MASK(~0u)},
	{47497, S_036108_CB_CLEAN_USER_DEFINED_MASK(~0u)},
	{47551, S_036108_TA_BUSY_USER_DEFINED_MASK(~0u)},
	{47577, S_036108_SX_BUSY_USER_DEFINED_MASK(~0u)},
	{47603, S_036108_SPI_BUSY_USER_DEFINED_MASK(~0u)},
	{47630, S_036108_SC_BUSY_USER_DEFINED_MASK(~0u)},
	{47710, S_036108_DB_BUSY_USER_DEFINED_MASK(~0u)},
	{47736, S_036108_CB_BUSY_USER_DEFINED_MASK(~0u)},
	{47524, S_036108_VGT_BUSY_USER_DEFINED_MASK(~0u)},
	{47656, S_036108_PA_BUSY_USER_DEFINED_MASK(~0u)},
	{47841, S_036108_BCI_BUSY_USER_DEFINED_MASK(~0u)},
	/* 978 */
	{47300, S_03610C_PERF_SEL(~0u)},
	{47470, S_03610C_DB_CLEAN_USER_DEFINED_MASK(~0u)},
	{47497, S_03610C_CB_CLEAN_USER_DEFINED_MASK(~0u)},
	{47551, S_03610C_TA_BUSY_USER_DEFINED_MASK(~0u)},
	{47577, S_03610C_SX_BUSY_USER_DEFINED_MASK(~0u)},
	{47603, S_03610C_SPI_BUSY_USER_DEFINED_MASK(~0u)},
	{47630, S_03610C_SC_BUSY_USER_DEFINED_MASK(~0u)},
	{47710, S_03610C_DB_BUSY_USER_DEFINED_MASK(~0u)},
	{47736, S_03610C_CB_BUSY_USER_DEFINED_MASK(~0u)},
	{47524, S_03610C_VGT_BUSY_USER_DEFINED_MASK(~0u)},
	{47656, S_03610C_PA_BUSY_USER_DEFINED_MASK(~0u)},
	{47841, S_03610C_BCI_BUSY_USER_DEFINED_MASK(~0u)},
	/* 990 */
	{47300, S_036110_PERF_SEL(~0u)},
	{47470, S_036110_DB_CLEAN_USER_DEFINED_MASK(~0u)},
	{47497, S_036110_CB_CLEAN_USER_DEFINED_MASK(~0u)},
	{47551, S_036110_TA_BUSY_USER_DEFINED_MASK(~0u)},
	{47577, S_036110_SX_BUSY_USER_DEFINED_MASK(~0u)},
	{47603, S_036110_SPI_BUSY_USER_DEFINED_MASK(~0u)},
	{47630, S_036110_SC_BUSY_USER_DEFINED_MASK(~0u)},
	{47710, S_036110_DB_BUSY_USER_DEFINED_MASK(~0u)},
	{47736, S_036110_CB_BUSY_USER_DEFINED_MASK(~0u)},
	{47524, S_036110_VGT_BUSY_USER_DEFINED_MASK(~0u)},
	{47656, S_036110_PA_BUSY_USER_DEFINED_MASK(~0u)},
	{47841, S_036110_BCI_BUSY_USER_DEFINED_MASK(~0u)},
	/* 1002 */
	{47300, S_036114_PERF_SEL(~0u)},
	{47470, S_036114_DB_CLEAN_USER_DEFINED_MASK(~0u)},
	{47497, S_036114_CB_CLEAN_USER_DEFINED_MASK(~0u)},
	{47551, S_036114_TA_BUSY_USER_DEFINED_MASK(~0u)},
	{47577, S_036114_SX_BUSY_USER_DEFINED_MASK(~0u)},
	{47603, S_036114_SPI_BUSY_USER_DEFINED_MASK(~0u)},
	{47630, S_036114_SC_BUSY_USER_DEFINED_MASK(~0u)},
	{47710, S_036114_DB_BUSY_USER_DEFINED_MASK(~0u)},
	{47736, S_036114_CB_BUSY_USER_DEFINED_MASK(~0u)},
	{47524, S_036114_VGT_BUSY_USER_DEFINED_MASK(~0u)},
	{47656, S_036114_PA_BUSY_USER_DEFINED_MASK(~0u)},
	{47841, S_036114_BCI_BUSY_USER_DEFINED_MASK(~0u)},
	/* 1014 */
	{47300, S_036200_PERF_SEL(~0u)},
	{47947, S_036200_PERF_MODE(~0u)},
	/* 1016 */
	{47300, S_036210_PERF_SEL(~0u)},
	{47309, S_036210_PERF_SEL1(~0u)},
	{47319, S_036210_CNTR_MODE(~0u)},
	{47957, S_036210_PERF_MODE1(~0u)},
	{47947, S_036210_PERF_MODE(~0u)},
	/* 1021 */
	{47329, S_036220_PERF_SEL2(~0u)},
	{47339, S_036220_PERF_SEL3(~0u)},
	{47968, S_036220_PERF_MODE3(~0u)},
	{47979, S_036220_PERF_MODE2(~0u)},
	/* 1025 */
	{47300, S_036230_PERF_SEL(~0u)},
	{47309, S_036230_PERF_SEL1(~0u)},
	{47319, S_036230_CNTR_MODE(~0u)},
	{47957, S_036230_PERF_MODE1(~0u)},
	{47947, S_036230_PERF_MODE(~0u)},
	/* 1030 */
	{47329, S_036240_PERF_SEL2(~0u)},
	{47339, S_036240_PERF_SEL3(~0u)},
	{47968, S_036240_PERF_MODE3(~0u)},
	{47979, S_036240_PERF_MODE2(~0u)},
	/* 1034 */
	{47990, S_036250_PERF_SEID_IGNORE_MASK(~0u)},
	/* 1035 */
	{47300, S_036400_PERF_SEL(~0u)},
	{47309, S_036400_PERF_SEL1(~0u)},
	{47319, S_036400_CNTR_MODE(~0u)},
	/* 1038 */
	{47329, S_036404_PERF_SEL2(~0u)},
	{47339, S_036404_PERF_SEL3(~0u)},
	/* 1040 */
	{47300, S_036500_PERF_SEL(~0u)},
	{47309, S_036500_PERF_SEL1(~0u)},
	{47319, S_036500_CNTR_MODE(~0u)},
	/* 1043 */
	{47329, S_036504_PERF_SEL2(~0u)},
	{47339, S_036504_PERF_SEL3(~0u)},
	/* 1045 */
	{47300, S_036600_PERF_SEL(~0u)},
	{47309, S_036600_PERF_SEL1(~0u)},
	{47319, S_036600_CNTR_MODE(~0u)},
	/* 1048 */
	{47329, S_036610_PERF_SEL2(~0u)},
	{47339, S_036610_PERF_SEL3(~0u)},
	/* 1050 */
	{48012, S_036628_BIN0_MIN(~0u)},
	{48021, S_036628_BIN0_MAX(~0u)},
	{48030, S_036628_BIN1_MIN(~0u)},
	{48039, S_036628_BIN1_MAX(~0u)},
	{48048, S_036628_BIN2_MIN(~0u)},
	{48057, S_036628_BIN2_MAX(~0u)},
	{48066, S_036628_BIN3_MIN(~0u)},
	{48075, S_036628_BIN3_MAX(~0u)},
	/* 1058 */
	{47300, S_036700_PERF_SEL(~0u)},
	{48084, S_036700_SQC_BANK_MASK(~0u)},
	{48098, S_036700_SQC_CLIENT_MASK(~0u)},
	{48114, S_036700_SPM_MODE(~0u)},
	{48123, S_036700_SIMD_MASK(~0u)},
	{47947, S_036700_PERF_MODE(~0u)},
	/* 1064 */
	{48133, S_036780_PS_EN(~0u)},
	{48139, S_036780_VS_EN(~0u)},
	{48145, S_036780_GS_EN(~0u)},
	{23383, S_036780_ES_EN(~0u)},
	{48151, S_036780_HS_EN(~0u)},
	{48157, S_036780_LS_EN(~0u)},
	{48163, S_036780_CS_EN(~0u)},
	{48169, S_036780_CNTR_RATE(~0u)},
	{48179, S_036780_DISABLE_FLUSH(~0u)},
	/* 1073 */
	{48193, S_036784_SH0_MASK(~0u)},
	{48202, S_036784_SH1_MASK(~0u)},
	/* 1075 */
	{48211, S_036788_FORCE_EN(~0u)},
	/* 1076 */
	{12538, S_036900_PERFCOUNTER_SELECT(~0u)},
	{48220, S_036900_PERFCOUNTER_SELECT1(~0u)},
	{47319, S_036900_CNTR_MODE(~0u)},
	/* 1079 */
	{48240, S_036910_PERFCOUNTER_SELECT2(~0u)},
	{48260, S_036910_PERFCOUNTER_SELECT3(~0u)},
	/* 1081 */
	{12538, S_036A00_PERFCOUNTER_SELECT(~0u)},
	{48220, S_036A00_PERFCOUNTER_SELECT1(~0u)},
	{47319, S_036A00_CNTR_MODE(~0u)},
	/* 1084 */
	{48240, S_036A10_PERFCOUNTER_SELECT2(~0u)},
	{48260, S_036A10_PERFCOUNTER_SELECT3(~0u)},
	/* 1086 */
	{47300, S_036B00_PERF_SEL(~0u)},
	{47309, S_036B00_PERF_SEL1(~0u)},
	{47319, S_036B00_CNTR_MODE(~0u)},
	{47957, S_036B00_PERF_MODE1(~0u)},
	{47947, S_036B00_PERF_MODE(~0u)},
	/* 1091 */
	{47329, S_036B04_PERF_SEL2(~0u)},
	{47339, S_036B04_PERF_SEL3(~0u)},
	{47968, S_036B04_PERF_MODE3(~0u)},
	{47979, S_036B04_PERF_MODE2(~0u)},
	/* 1095 */
	{47300, S_036C00_PERF_SEL(~0u)},
	{47309, S_036C00_PERF_SEL1(~0u)},
	{47319, S_036C00_CNTR_MODE(~0u)},
	{47957, S_036C00_PERF_MODE1(~0u)},
	{47947, S_036C00_PERF_MODE(~0u)},
	/* 1100 */
	{47329, S_036C04_PERF_SEL2(~0u)},
	{47339, S_036C04_PERF_SEL3(~0u)},
	{47968, S_036C04_PERF_MODE3(~0u)},
	{47979, S_036C04_PERF_MODE2(~0u)},
	/* 1104 */
	{47300, S_036D00_PERF_SEL(~0u)},
	{47309, S_036D00_PERF_SEL1(~0u)},
	{47319, S_036D00_CNTR_MODE(~0u)},
	{47957, S_036D00_PERF_MODE1(~0u)},
	{47947, S_036D00_PERF_MODE(~0u)},
	/* 1109 */
	{47329, S_036D04_PERF_SEL2(~0u)},
	{47339, S_036D04_PERF_SEL3(~0u)},
	{47968, S_036D04_PERF_MODE3(~0u)},
	{47979, S_036D04_PERF_MODE2(~0u)},
	/* 1113 */
	{47300, S_036E00_PERF_SEL(~0u)},
	{47309, S_036E00_PERF_SEL1(~0u)},
	{47319, S_036E00_CNTR_MODE(~0u)},
	{47957, S_036E00_PERF_MODE1(~0u)},
	{47947, S_036E00_PERF_MODE(~0u)},
	/* 1118 */
	{47329, S_036E04_PERF_SEL2(~0u)},
	{47339, S_036E04_PERF_SEL3(~0u)},
	{47979, S_036E04_PERF_MODE2(~0u)},
	{47968, S_036E04_PERF_MODE3(~0u)},
	/* 1122 */
	{47300, S_036E40_PERF_SEL(~0u)},
	{47309, S_036E40_PERF_SEL1(~0u)},
	{47319, S_036E40_CNTR_MODE(~0u)},
	{47957, S_036E40_PERF_MODE1(~0u)},
	{47947, S_036E40_PERF_MODE(~0u)},
	/* 1127 */
	{47329, S_036E44_PERF_SEL2(~0u)},
	{47339, S_036E44_PERF_SEL3(~0u)},
	{47979, S_036E44_PERF_MODE2(~0u)},
	{47968, S_036E44_PERF_MODE3(~0u)},
	/* 1131 */
	{48280, S_037000_OP_FILTER_ENABLE(~0u)},
	{48297, S_037000_OP_FILTER_SEL(~0u)},
	{48311, S_037000_FORMAT_FILTER_ENABLE(~0u)},
	{48332, S_037000_FORMAT_FILTER_SEL(~0u)},
	{48350, S_037000_CLEAR_FILTER_ENABLE(~0u)},
	{48370, S_037000_CLEAR_FILTER_SEL(~0u)},
	{48387, S_037000_MRT_FILTER_ENABLE(~0u)},
	{48405, S_037000_MRT_FILTER_SEL(~0u)},
	{48420, S_037000_NUM_SAMPLES_FILTER_ENABLE(~0u)},
	{48446, S_037000_NUM_SAMPLES_FILTER_SEL(~0u)},
	{48469, S_037000_NUM_FRAGMENTS_FILTER_ENABLE(~0u)},
	{48497, S_037000_NUM_FRAGMENTS_FILTER_SEL(~0u)},
	/* 1143 */
	{47300, S_037004_PERF_SEL(~0u)},
	{47309, S_037004_PERF_SEL1(~0u)},
	{47319, S_037004_CNTR_MODE(~0u)},
	{47957, S_037004_PERF_MODE1(~0u)},
	{47947, S_037004_PERF_MODE(~0u)},
	/* 1148 */
	{47329, S_037008_PERF_SEL2(~0u)},
	{47339, S_037008_PERF_SEL3(~0u)},
	{47968, S_037008_PERF_MODE3(~0u)},
	{47979, S_037008_PERF_MODE2(~0u)},
	/* 1152 */
	{47300, S_037100_PERF_SEL(~0u)},
	{47309, S_037100_PERF_SEL1(~0u)},
	{47319, S_037100_CNTR_MODE(~0u)},
	{47957, S_037100_PERF_MODE1(~0u)},
	{47947, S_037100_PERF_MODE(~0u)},
	/* 1157 */
	{47329, S_037104_PERF_SEL2(~0u)},
	{47339, S_037104_PERF_SEL3(~0u)},
	{47968, S_037104_PERF_MODE3(~0u)},
	{47979, S_037104_PERF_MODE2(~0u)},
	/* 1161 */
	{48522, S_028000_DEPTH_CLEAR_ENABLE(~0u)},
	{48541, S_028000_STENCIL_CLEAR_ENABLE(~0u)},
	{48562, S_028000_DEPTH_COPY(~0u)},
	{48573, S_028000_STENCIL_COPY(~0u)},
	{48586, S_028000_RESUMMARIZE_ENABLE(~0u)},
	{48605, S_028000_STENCIL_COMPRESS_DISABLE(~0u)},
	{48630, S_028000_DEPTH_COMPRESS_DISABLE(~0u)},
	{48653, S_028000_COPY_CENTROID(~0u)},
	{48667, S_028000_COPY_SAMPLE(~0u)},
	{48679, S_028000_DECOMPRESS_ENABLE(~0u)},
	/* 1171 */
	{48697, S_028004_ZPASS_INCREMENT_DISABLE(~0u)},
	{48721, S_028004_PERFECT_ZPASS_COUNTS(~0u)},
	{48742, S_028004_SAMPLE_RATE(~0u)},
	{48754, S_028004_ZPASS_ENABLE(~0u)},
	{48767, S_028004_ZFAIL_ENABLE(~0u)},
	{48780, S_028004_SFAIL_ENABLE(~0u)},
	{48793, S_028004_DBFAIL_ENABLE(~0u)},
	{48807, S_028004_SLICE_EVEN_ENABLE(~0u)},
	{48825, S_028004_SLICE_ODD_ENABLE(~0u)},
	/* 1180 */
	{48842, S_028008_SLICE_START(~0u)},
	{48854, S_028008_SLICE_MAX(~0u)},
	{48864, S_028008_Z_READ_ONLY(~0u)},
	{48876, S_028008_STENCIL_READ_ONLY(~0u)},
	/* 1184 */
	{48946, S_02800C_FORCE_HIZ_ENABLE(~0u), 4, 670},
	{48963, S_02800C_FORCE_HIS_ENABLE0(~0u), 4, 670},
	{48981, S_02800C_FORCE_HIS_ENABLE1(~0u), 4, 670},
	{48999, S_02800C_FORCE_SHADER_Z_ORDER(~0u)},
	{49020, S_02800C_FAST_Z_DISABLE(~0u)},
	{49035, S_02800C_FAST_STENCIL_DISABLE(~0u)},
	{49056, S_02800C_NOOP_CULL_DISABLE(~0u)},
	{49074, S_02800C_FORCE_COLOR_KILL(~0u)},
	{49091, S_02800C_FORCE_Z_READ(~0u)},
	{49104, S_02800C_FORCE_STENCIL_READ(~0u)},
	{49123, S_02800C_FORCE_FULL_Z_RANGE(~0u), 4, 670},
	{49142, S_02800C_FORCE_QC_SMASK_CONFLICT(~0u)},
	{49166, S_02800C_DISABLE_VIEWPORT_CLAMP(~0u)},
	{49189, S_02800C_IGNORE_SC_ZRANGE(~0u)},
	{49206, S_02800C_DISABLE_FULLY_COVERED(~0u)},
	{49291, S_02800C_FORCE_Z_LIMIT_SUMM(~0u), 4, 674},
	{49310, S_02800C_MAX_TILES_IN_DTT(~0u)},
	{49327, S_02800C_DISABLE_TILE_RATE_TILES(~0u)},
	{49351, S_02800C_FORCE_Z_DIRTY(~0u)},
	{49365, S_02800C_FORCE_STENCIL_DIRTY(~0u)},
	{49385, S_02800C_FORCE_Z_VALID(~0u)},
	{49399, S_02800C_FORCE_STENCIL_VALID(~0u)},
	{49419, S_02800C_PRESERVE_COMPRESSION(~0u)},
	/* 1207 */
	{49493, S_028010_PARTIAL_SQUAD_LAUNCH_CONTROL(~0u), 4, 678},
	{49522, S_028010_PARTIAL_SQUAD_LAUNCH_COUNTDOWN(~0u)},
	{49553, S_028010_DISABLE_ZMASK_EXPCLEAR_OPTIMIZATION(~0u)},
	{49589, S_028010_DISABLE_SMEM_EXPCLEAR_OPTIMIZATION(~0u)},
	{49624, S_028010_DISABLE_COLOR_ON_VALIDATION(~0u)},
	{49652, S_028010_DECOMPRESS_Z_ON_FLUSH(~0u)},
	{49674, S_028010_DISABLE_REG_SNOOP(~0u)},
	{49692, S_028010_DEPTH_BOUNDS_HIER_DEPTH_DISABLE(~0u)},
	{49724, S_028010_SEPARATE_HIZS_FUNC_ENABLE(~0u)},
	{49750, S_028010_HIZ_ZFUNC(~0u)},
	{49760, S_028010_HIS_SFUNC_FF(~0u)},
	{49773, S_028010_HIS_SFUNC_BF(~0u)},
	{49786, S_028010_PRESERVE_ZRANGE(~0u)},
	{49802, S_028010_PRESERVE_SRESULTS(~0u)},
	{49820, S_028010_DISABLE_FAST_PASS(~0u)},
	/* 1222 */
	{15389, S_028028_CLEAR(~0u)},
	/* 1223 */
	{49838, S_028030_TL_X(~0u)},
	{49843, S_028030_TL_Y(~0u)},
	/* 1225 */
	{49848, S_028034_BR_X(~0u)},
	{49853, S_028034_BR_Y(~0u)},
	/* 1227 */
	{49858, S_02803C_ADDR5_SWIZZLE_MASK(~0u)},
	{45344, S_02803C_ARRAY_MODE(~0u), 7, 682},
	{45706, S_02803C_PIPE_CONFIG(~0u), 18, 689},
	{45999, S_02803C_BANK_WIDTH(~0u), 4, 406},
	{46106, S_02803C_BANK_HEIGHT(~0u), 4, 410},
	{46218, S_02803C_MACRO_TILE_ASPECT(~0u), 4, 414},
	{46305, S_02803C_NUM_BANKS(~0u), 4, 418},
	/* 1234 */
	{21132, S_028040_FORMAT(~0u), 4, 707},
	{50010, S_028040_NUM_SAMPLES(~0u)},
	{45896, S_028040_TILE_SPLIT(~0u), 7, 399},
	{50022, S_028040_TILE_MODE_INDEX(~0u)},
	{50038, S_028040_DECOMPRESS_ON_N_ZPLANES(~0u)},
	{50062, S_028040_ALLOW_EXPCLEAR(~0u)},
	{50077, S_028040_READ_SIZE(~0u)},
	{50087, S_028040_TILE_SURFACE_ENABLE(~0u)},
	{50107, S_028040_CLEAR_DISALLOWED(~0u)},
	{50124, S_028040_ZRANGE_PRECISION(~0u)},
	/* 1244 */
	{21132, S_028044_FORMAT(~0u), 2, 711},
	{45896, S_028044_TILE_SPLIT(~0u), 7, 399},
	{50022, S_028044_TILE_MODE_INDEX(~0u)},
	{50062, S_028044_ALLOW_EXPCLEAR(~0u)},
	{50167, S_028044_TILE_STENCIL_DISABLE(~0u)},
	{50107, S_028044_CLEAR_DISALLOWED(~0u)},
	/* 1250 */
	{50188, S_028058_PITCH_TILE_MAX(~0u)},
	{50203, S_028058_HEIGHT_TILE_MAX(~0u)},
	/* 1252 */
	{50219, S_02805C_SLICE_TILE_MAX(~0u)},
	/* 1253 */
	{39305, S_028084_ADDRESS(~0u)},
	/* 1254 */
	{50234, S_028200_WINDOW_X_OFFSET(~0u)},
	{50250, S_028200_WINDOW_Y_OFFSET(~0u)},
	/* 1256 */
	{49838, S_028204_TL_X(~0u)},
	{49843, S_028204_TL_Y(~0u)},
	{50266, S_028204_WINDOW_OFFSET_DISABLE(~0u)},
	/* 1259 */
	{49848, S_028208_BR_X(~0u)},
	{49853, S_028208_BR_Y(~0u)},
	/* 1261 */
	{50288, S_02820C_CLIP_RULE(~0u)},
	/* 1262 */
	{49838, S_028210_TL_X(~0u)},
	{49843, S_028210_TL_Y(~0u)},
	/* 1264 */
	{49848, S_028214_BR_X(~0u)},
	{49853, S_028214_BR_Y(~0u)},
	/* 1266 */
	{50298, S_028230_ER_TRI(~0u)},
	{43433, S_028230_ER_POINT(~0u)},
	{50305, S_028230_ER_RECT(~0u)},
	{50313, S_028230_ER_LINE_LR(~0u)},
	{50324, S_028230_ER_LINE_RL(~0u)},
	{50335, S_028230_ER_LINE_TB(~0u)},
	{50346, S_028230_ER_LINE_BT(~0u)},
	/* 1273 */
	{50357, S_028234_HW_SCREEN_OFFSET_X(~0u)},
	{50376, S_028234_HW_SCREEN_OFFSET_Y(~0u)},
	/* 1275 */
	{50395, S_028238_TARGET0_ENABLE(~0u)},
	{50410, S_028238_TARGET1_ENABLE(~0u)},
	{50425, S_028238_TARGET2_ENABLE(~0u)},
	{50440, S_028238_TARGET3_ENABLE(~0u)},
	{50455, S_028238_TARGET4_ENABLE(~0u)},
	{50470, S_028238_TARGET5_ENABLE(~0u)},
	{50485, S_028238_TARGET6_ENABLE(~0u)},
	{50500, S_028238_TARGET7_ENABLE(~0u)},
	/* 1283 */
	{50515, S_02823C_OUTPUT0_ENABLE(~0u)},
	{50530, S_02823C_OUTPUT1_ENABLE(~0u)},
	{50545, S_02823C_OUTPUT2_ENABLE(~0u)},
	{50560, S_02823C_OUTPUT3_ENABLE(~0u)},
	{50575, S_02823C_OUTPUT4_ENABLE(~0u)},
	{50590, S_02823C_OUTPUT5_ENABLE(~0u)},
	{50605, S_02823C_OUTPUT6_ENABLE(~0u)},
	{50620, S_02823C_OUTPUT7_ENABLE(~0u)},
	/* 1291 */
	{49838, S_028240_TL_X(~0u)},
	{49843, S_028240_TL_Y(~0u)},
	{50266, S_028240_WINDOW_OFFSET_DISABLE(~0u)},
	/* 1294 */
	{49848, S_028244_BR_X(~0u)},
	{49853, S_028244_BR_Y(~0u)},
	/* 1296 */
	{49838, S_028250_TL_X(~0u)},
	{49843, S_028250_TL_Y(~0u)},
	{50266, S_028250_WINDOW_OFFSET_DISABLE(~0u)},
	/* 1299 */
	{49848, S_028254_BR_X(~0u)},
	{49853, S_028254_BR_Y(~0u)},
	/* 1301 */
	{50727, S_028350_RB_MAP_PKR0(~0u), 4, 713},
	{50739, S_028350_RB_MAP_PKR1(~0u), 4, 713},
	{50851, S_028350_RB_XSEL2(~0u), 4, 717},
	{50860, S_028350_RB_XSEL(~0u)},
	{50868, S_028350_RB_YSEL(~0u)},
	{50972, S_028350_PKR_MAP(~0u), 4, 721},
	{51080, S_028350_PKR_XSEL(~0u), 4, 725},
	{51189, S_028350_PKR_YSEL(~0u), 4, 729},
	{51302, S_028350_PKR_XSEL2(~0u), 4, 733},
	{51404, S_028350_SC_MAP(~0u), 4, 737},
	{51550, S_028350_SC_XSEL(~0u), 4, 741},
	{51697, S_028350_SC_YSEL(~0u), 4, 745},
	{51797, S_028350_SE_MAP(~0u), 4, 749},
	{51943, S_028350_SE_XSEL_GFX6(~0u), 4, 753},
	{52095, S_028350_SE_YSEL_GFX6(~0u), 4, 757},
	/* 1316 */
	{52220, S_028354_SE_PAIR_MAP(~0u), 4, 761},
	{52391, S_028354_SE_PAIR_XSEL_GFX6(~0u), 4, 765},
	{52568, S_028354_SE_PAIR_YSEL_GFX6(~0u), 4, 769},
	/* 1319 */
	{48807, S_028358_SLICE_EVEN_ENABLE(~0u)},
	{48825, S_028358_SLICE_ODD_ENABLE(~0u)},
	/* 1321 */
	{52586, S_028424_OVERWRITE_COMBINER_DISABLE(~0u)},
	{52613, S_028424_OVERWRITE_COMBINER_MRT_SHARING_DISABLE(~0u)},
	{52652, S_028424_OVERWRITE_COMBINER_WATERMARK(~0u)},
	/* 1324 */
	{52918, S_02842C_STENCILFAIL(~0u), 16, 773},
	{52930, S_02842C_STENCILZPASS(~0u), 16, 773},
	{52943, S_02842C_STENCILZFAIL(~0u), 16, 773},
	{52956, S_02842C_STENCILFAIL_BF(~0u), 16, 773},
	{52971, S_02842C_STENCILZPASS_BF(~0u), 16, 773},
	{52987, S_02842C_STENCILZFAIL_BF(~0u), 16, 773},
	/* 1330 */
	{53003, S_028430_STENCILTESTVAL(~0u)},
	{53018, S_028430_STENCILMASK(~0u)},
	{53030, S_028430_STENCILWRITEMASK(~0u)},
	{53047, S_028430_STENCILOPVAL(~0u)},
	/* 1334 */
	{53060, S_028434_STENCILTESTVAL_BF(~0u)},
	{53078, S_028434_STENCILMASK_BF(~0u)},
	{53093, S_028434_STENCILWRITEMASK_BF(~0u)},
	{53113, S_028434_STENCILOPVAL_BF(~0u)},
	/* 1338 */
	{669, S_028644_OFFSET(~0u)},
	{53136, S_028644_DEFAULT_VAL(~0u), 1, 789},
	{53148, S_028644_FLAT_SHADE(~0u)},
	{53159, S_028644_CYL_WRAP(~0u)},
	{53168, S_028644_PT_SPRITE_TEX(~0u)},
	{53182, S_028644_DUP(~0u)},
	{53186, S_028644_FP16_INTERP_MODE(~0u)},
	{53203, S_028644_USE_DEFAULT_ATTR1(~0u)},
	{53221, S_028644_DEFAULT_VAL_ATTR1(~0u)},
	{53239, S_028644_PT_SPRITE_TEX_ATTR1(~0u)},
	{53259, S_028644_ATTR0_VALID(~0u)},
	{53271, S_028644_ATTR1_VALID(~0u)},
	/* 1350 */
	{53283, S_0286C4_VS_EXPORT_COUNT(~0u)},
	{53299, S_0286C4_VS_HALF_PACK(~0u)},
	{53312, S_0286C4_VS_EXPORTS_FOG(~0u)},
	{53327, S_0286C4_VS_OUT_FOG_VEC_ADDR(~0u)},
	/* 1354 */
	{53347, S_0286CC_PERSP_SAMPLE_ENA(~0u)},
	{53364, S_0286CC_PERSP_CENTER_ENA(~0u)},
	{53381, S_0286CC_PERSP_CENTROID_ENA(~0u)},
	{53400, S_0286CC_PERSP_PULL_MODEL_ENA(~0u)},
	{53421, S_0286CC_LINEAR_SAMPLE_ENA(~0u)},
	{53439, S_0286CC_LINEAR_CENTER_ENA(~0u)},
	{53457, S_0286CC_LINEAR_CENTROID_ENA(~0u)},
	{53477, S_0286CC_LINE_STIPPLE_TEX_ENA(~0u)},
	{53498, S_0286CC_POS_X_FLOAT_ENA(~0u)},
	{53514, S_0286CC_POS_Y_FLOAT_ENA(~0u)},
	{53530, S_0286CC_POS_Z_FLOAT_ENA(~0u)},
	{53546, S_0286CC_POS_W_FLOAT_ENA(~0u)},
	{53562, S_0286CC_FRONT_FACE_ENA(~0u)},
	{53577, S_0286CC_ANCILLARY_ENA(~0u)},
	{53591, S_0286CC_SAMPLE_COVERAGE_ENA(~0u)},
	{53611, S_0286CC_POS_FIXED_PT_ENA(~0u)},
	/* 1370 */
	{53347, S_0286D0_PERSP_SAMPLE_ENA(~0u)},
	{53364, S_0286D0_PERSP_CENTER_ENA(~0u)},
	{53381, S_0286D0_PERSP_CENTROID_ENA(~0u)},
	{53400, S_0286D0_PERSP_PULL_MODEL_ENA(~0u)},
	{53421, S_0286D0_LINEAR_SAMPLE_ENA(~0u)},
	{53439, S_0286D0_LINEAR_CENTER_ENA(~0u)},
	{53457, S_0286D0_LINEAR_CENTROID_ENA(~0u)},
	{53477, S_0286D0_LINE_STIPPLE_TEX_ENA(~0u)},
	{53498, S_0286D0_POS_X_FLOAT_ENA(~0u)},
	{53514, S_0286D0_POS_Y_FLOAT_ENA(~0u)},
	{53530, S_0286D0_POS_Z_FLOAT_ENA(~0u)},
	{53546, S_0286D0_POS_W_FLOAT_ENA(~0u)},
	{53562, S_0286D0_FRONT_FACE_ENA(~0u)},
	{53577, S_0286D0_ANCILLARY_ENA(~0u)},
	{53591, S_0286D0_SAMPLE_COVERAGE_ENA(~0u)},
	{53611, S_0286D0_POS_FIXED_PT_ENA(~0u)},
	/* 1386 */
	{53628, S_0286D4_FLAT_SHADE_ENA(~0u)},
	{53643, S_0286D4_PNT_SPRITE_ENA(~0u)},
	{53766, S_0286D4_PNT_SPRITE_OVRD_X(~0u), 5, 790},
	{53784, S_0286D4_PNT_SPRITE_OVRD_Y(~0u), 5, 790},
	{53802, S_0286D4_PNT_SPRITE_OVRD_Z(~0u), 5, 790},
	{53820, S_0286D4_PNT_SPRITE_OVRD_W(~0u), 5, 790},
	{53838, S_0286D4_PNT_SPRITE_TOP_1(~0u)},
	/* 1393 */
	{53855, S_0286D8_NUM_INTERP(~0u)},
	{53866, S_0286D8_PARAM_GEN(~0u)},
	{53876, S_0286D8_FOG_ADDR(~0u)},
	{53885, S_0286D8_BC_OPTIMIZE_DISABLE(~0u)},
	{53905, S_0286D8_PASS_FOG_THROUGH_PS(~0u)},
	/* 1398 */
	{53925, S_0286E0_PERSP_CENTER_CNTL(~0u)},
	{53943, S_0286E0_PERSP_CENTROID_CNTL(~0u)},
	{53963, S_0286E0_LINEAR_CENTER_CNTL(~0u)},
	{53982, S_0286E0_LINEAR_CENTROID_CNTL(~0u)},
	{54052, S_0286E0_POS_FLOAT_LOCATION(~0u), 1, 795},
	{54071, S_0286E0_POS_FLOAT_ULC(~0u)},
	{54085, S_0286E0_FRONT_FACE_ALL_BITS(~0u)},
	/* 1405 */
	{47216, S_0286E8_WAVES(~0u)},
	{47222, S_0286E8_WAVESIZE(~0u)},
	/* 1407 */
	{54105, S_028704_NUM_PS_WAVES(~0u)},
	{54118, S_028704_NUM_VS_WAVES(~0u)},
	{54131, S_028704_NUM_GS_WAVES(~0u)},
	{54144, S_028704_NUM_ES_WAVES(~0u)},
	{54157, S_028704_NUM_HS_WAVES(~0u)},
	/* 1412 */
	{54170, S_028708_NUM_LS_WAVES(~0u)},
	/* 1413 */
	{54271, S_02870C_POS0_EXPORT_FORMAT(~0u), 5, 796},
	{54290, S_02870C_POS1_EXPORT_FORMAT(~0u), 5, 796},
	{54309, S_02870C_POS2_EXPORT_FORMAT(~0u), 5, 796},
	{54328, S_02870C_POS3_EXPORT_FORMAT(~0u), 5, 796},
	/* 1417 */
	{54547, S_028710_Z_EXPORT_FORMAT(~0u), 10, 801},
	/* 1418 */
	{54563, S_028714_COL0_EXPORT_FORMAT(~0u), 10, 801},
	{54582, S_028714_COL1_EXPORT_FORMAT(~0u), 10, 801},
	{54601, S_028714_COL2_EXPORT_FORMAT(~0u), 10, 801},
	{54620, S_028714_COL3_EXPORT_FORMAT(~0u), 10, 801},
	{54639, S_028714_COL4_EXPORT_FORMAT(~0u), 10, 801},
	{54658, S_028714_COL5_EXPORT_FORMAT(~0u), 10, 801},
	{54677, S_028714_COL6_EXPORT_FORMAT(~0u), 10, 801},
	{54696, S_028714_COL7_EXPORT_FORMAT(~0u), 10, 801},
	/* 1426 */
	{54950, S_028754_MRT0(~0u), 11, 811},
	{54955, S_028754_MRT1(~0u)},
	{54960, S_028754_MRT2(~0u)},
	{54965, S_028754_MRT3(~0u)},
	{54970, S_028754_MRT4(~0u)},
	{54975, S_028754_MRT5(~0u)},
	{54980, S_028754_MRT6(~0u)},
	{54985, S_028754_MRT7(~0u)},
	/* 1434 */
	{55070, S_028758_MRT0_EPSILON(~0u), 16, 822},
	{55083, S_028758_MRT1_EPSILON(~0u)},
	{55096, S_028758_MRT2_EPSILON(~0u)},
	{55109, S_028758_MRT3_EPSILON(~0u)},
	{55122, S_028758_MRT4_EPSILON(~0u)},
	{55135, S_028758_MRT5_EPSILON(~0u)},
	{55148, S_028758_MRT6_EPSILON(~0u)},
	{55161, S_028758_MRT7_EPSILON(~0u)},
	/* 1442 */
	{55174, S_02875C_MRT0_COLOR_OPT_DISABLE(~0u)},
	{55197, S_02875C_MRT0_ALPHA_OPT_DISABLE(~0u)},
	{55220, S_02875C_MRT1_COLOR_OPT_DISABLE(~0u)},
	{55243, S_02875C_MRT1_ALPHA_OPT_DISABLE(~0u)},
	{55266, S_02875C_MRT2_COLOR_OPT_DISABLE(~0u)},
	{55289, S_02875C_MRT2_ALPHA_OPT_DISABLE(~0u)},
	{55312, S_02875C_MRT3_COLOR_OPT_DISABLE(~0u)},
	{55335, S_02875C_MRT3_ALPHA_OPT_DISABLE(~0u)},
	{55358, S_02875C_MRT4_COLOR_OPT_DISABLE(~0u)},
	{55381, S_02875C_MRT4_ALPHA_OPT_DISABLE(~0u)},
	{55404, S_02875C_MRT5_COLOR_OPT_DISABLE(~0u)},
	{55427, S_02875C_MRT5_ALPHA_OPT_DISABLE(~0u)},
	{55450, S_02875C_MRT6_COLOR_OPT_DISABLE(~0u)},
	{55473, S_02875C_MRT6_ALPHA_OPT_DISABLE(~0u)},
	{55496, S_02875C_MRT7_COLOR_OPT_DISABLE(~0u)},
	{55519, S_02875C_MRT7_ALPHA_OPT_DISABLE(~0u)},
	{55542, S_02875C_PIXEN_ZERO_OPT_DISABLE(~0u)},
	/* 1459 */
	{55833, S_028760_COLOR_SRC_OPT(~0u), 8, 838},
	{55847, S_028760_COLOR_DST_OPT(~0u)},
	{55995, S_028760_COLOR_COMB_FCN(~0u), 8, 846},
	{56010, S_028760_ALPHA_SRC_OPT(~0u)},
	{56024, S_028760_ALPHA_DST_OPT(~0u)},
	{56038, S_028760_ALPHA_COMB_FCN(~0u)},
	/* 1465 */
	{55833, S_028764_COLOR_SRC_OPT(~0u)},
	{55847, S_028764_COLOR_DST_OPT(~0u)},
	{55995, S_028764_COLOR_COMB_FCN(~0u)},
	{56010, S_028764_ALPHA_SRC_OPT(~0u)},
	{56024, S_028764_ALPHA_DST_OPT(~0u)},
	{56038, S_028764_ALPHA_COMB_FCN(~0u)},
	/* 1471 */
	{55833, S_028768_COLOR_SRC_OPT(~0u)},
	{55847, S_028768_COLOR_DST_OPT(~0u)},
	{55995, S_028768_COLOR_COMB_FCN(~0u)},
	{56010, S_028768_ALPHA_SRC_OPT(~0u)},
	{56024, S_028768_ALPHA_DST_OPT(~0u)},
	{56038, S_028768_ALPHA_COMB_FCN(~0u)},
	/* 1477 */
	{55833, S_02876C_COLOR_SRC_OPT(~0u)},
	{55847, S_02876C_COLOR_DST_OPT(~0u)},
	{55995, S_02876C_COLOR_COMB_FCN(~0u)},
	{56010, S_02876C_ALPHA_SRC_OPT(~0u)},
	{56024, S_02876C_ALPHA_DST_OPT(~0u)},
	{56038, S_02876C_ALPHA_COMB_FCN(~0u)},
	/* 1483 */
	{55833, S_028770_COLOR_SRC_OPT(~0u)},
	{55847, S_028770_COLOR_DST_OPT(~0u)},
	{55995, S_028770_COLOR_COMB_FCN(~0u)},
	{56010, S_028770_ALPHA_SRC_OPT(~0u)},
	{56024, S_028770_ALPHA_DST_OPT(~0u)},
	{56038, S_028770_ALPHA_COMB_FCN(~0u)},
	/* 1489 */
	{55833, S_028774_COLOR_SRC_OPT(~0u)},
	{55847, S_028774_COLOR_DST_OPT(~0u)},
	{55995, S_028774_COLOR_COMB_FCN(~0u)},
	{56010, S_028774_ALPHA_SRC_OPT(~0u)},
	{56024, S_028774_ALPHA_DST_OPT(~0u)},
	{56038, S_028774_ALPHA_COMB_FCN(~0u)},
	/* 1495 */
	{55833, S_028778_COLOR_SRC_OPT(~0u)},
	{55847, S_028778_COLOR_DST_OPT(~0u)},
	{55995, S_028778_COLOR_COMB_FCN(~0u)},
	{56010, S_028778_ALPHA_SRC_OPT(~0u)},
	{56024, S_028778_ALPHA_DST_OPT(~0u)},
	{56038, S_028778_ALPHA_COMB_FCN(~0u)},
	/* 1501 */
	{55833, S_02877C_COLOR_SRC_OPT(~0u)},
	{55847, S_02877C_COLOR_DST_OPT(~0u)},
	{55995, S_02877C_COLOR_COMB_FCN(~0u)},
	{56010, S_02877C_ALPHA_SRC_OPT(~0u)},
	{56024, S_02877C_ALPHA_DST_OPT(~0u)},
	{56038, S_02877C_ALPHA_COMB_FCN(~0u)},
	/* 1507 */
	{56447, S_028780_COLOR_SRCBLEND(~0u), 21, 854},
	{55995, S_028780_COLOR_COMB_FCN(~0u), 5, 875},
	{56552, S_028780_COLOR_DESTBLEND(~0u), 21, 854},
	{56568, S_028780_ALPHA_SRCBLEND(~0u), 21, 854},
	{56038, S_028780_ALPHA_COMB_FCN(~0u), 5, 875},
	{56583, S_028780_ALPHA_DESTBLEND(~0u), 21, 854},
	{56599, S_028780_SEPARATE_ALPHA_BLEND(~0u)},
	{7643, S_028780_ENABLE(~0u)},
	{56620, S_028780_DISABLE_ROP3(~0u)},
	/* 1516 */
	{56633, S_0287CC_SRC_STATE_ID(~0u)},
	/* 1517 */
	{56646, S_0287E4_BASE_ADDR_GFX6(~0u)},
	/* 1518 */
	{56739, S_0287F0_SOURCE_SELECT(~0u), 4, 880},
	{56785, S_0287F0_MAJOR_MODE(~0u), 2, 884},
	{56796, S_0287F0_NOT_EOP(~0u)},
	{56804, S_0287F0_USE_OPAQUE(~0u)},
	/* 1522 */
	{56815, S_0287F8_ADDRESS_LOW(~0u)},
	/* 1523 */
	{56827, S_028800_STENCIL_ENABLE(~0u)},
	{48954, S_028800_Z_ENABLE(~0u)},
	{56842, S_028800_Z_WRITE_ENABLE(~0u)},
	{56857, S_028800_DEPTH_BOUNDS_ENABLE(~0u)},
	{49754, S_028800_ZFUNC(~0u), 8, 886},
	{56972, S_028800_BACKFACE_ENABLE(~0u)},
	{57075, S_028800_STENCILFUNC(~0u), 8, 894},
	{57087, S_028800_STENCILFUNC_BF(~0u), 8, 894},
	{57102, S_028800_ENABLE_COLOR_WRITES_ON_DEPTH_FAIL(~0u)},
	{57136, S_028800_DISABLE_COLOR_WRITES_ON_DEPTH_PASS(~0u)},
	/* 1533 */
	{57171, S_028804_MAX_ANCHOR_SAMPLES(~0u)},
	{57190, S_028804_PS_ITER_SAMPLES(~0u)},
	{57206, S_028804_MASK_EXPORT_NUM_SAMPLES(~0u)},
	{57230, S_028804_ALPHA_TO_MASK_NUM_SAMPLES(~0u)},
	{57256, S_028804_HIGH_QUALITY_INTERSECTIONS(~0u)},
	{57283, S_028804_INCOHERENT_EQAA_READS(~0u)},
	{57305, S_028804_INTERPOLATE_COMP_Z(~0u)},
	{57324, S_028804_INTERPOLATE_SRC_Z(~0u)},
	{57342, S_028804_STATIC_ANCHOR_ASSOCIATIONS(~0u)},
	{57369, S_028804_ALPHA_TO_MASK_EQAA_DISABLE(~0u)},
	{57396, S_028804_OVERRASTERIZATION_AMOUNT(~0u)},
	{57421, S_028804_ENABLE_POSTZ_OVERRASTERIZATION(~0u)},
	/* 1545 */
	{57452, S_028808_DISABLE_DUAL_QUAD(~0u)},
	{57470, S_028808_DEGAMMA_ENABLE(~0u)},
	{22279, S_028808_MODE(~0u), 7, 902},
	{56628, S_028808_ROP3(~0u), 256, 909},
	/* 1549 */
	{57775, S_02880C_Z_EXPORT_ENABLE(~0u)},
	{57791, S_02880C_STENCIL_TEST_VAL_EXPORT_ENABLE(~0u)},
	{57822, S_02880C_STENCIL_OP_VAL_EXPORT_ENABLE(~0u)},
	{49012, S_02880C_Z_ORDER(~0u), 4, 1165},
	{57901, S_02880C_KILL_ENABLE(~0u)},
	{57913, S_02880C_COVERAGE_TO_MASK_ENABLE(~0u)},
	{57937, S_02880C_MASK_EXPORT_ENABLE(~0u)},
	{57956, S_02880C_EXEC_ON_HIER_FAIL(~0u)},
	{57974, S_02880C_EXEC_ON_NOOP(~0u)},
	{57987, S_02880C_ALPHA_TO_MASK_DISABLE(~0u)},
	{58009, S_02880C_DEPTH_BEFORE_SHADER(~0u)},
	{58099, S_02880C_CONSERVATIVE_Z_EXPORT(~0u), 4, 1169},
	{58121, S_02880C_DUAL_QUAD_DISABLE(~0u)},
	/* 1562 */
	{58139, S_028810_UCP_ENA_0(~0u)},
	{58149, S_028810_UCP_ENA_1(~0u)},
	{58159, S_028810_UCP_ENA_2(~0u)},
	{58169, S_028810_UCP_ENA_3(~0u)},
	{58179, S_028810_UCP_ENA_4(~0u)},
	{58189, S_028810_UCP_ENA_5(~0u)},
	{58199, S_028810_PS_UCP_Y_SCALE_NEG(~0u)},
	{58218, S_028810_PS_UCP_MODE(~0u)},
	{58230, S_028810_CLIP_DISABLE(~0u)},
	{58243, S_028810_UCP_CULL_ONLY_ENA(~0u)},
	{58261, S_028810_BOUNDARY_EDGE_FLAG_ENA(~0u)},
	{58284, S_028810_DX_CLIP_SPACE_DEF(~0u)},
	{58302, S_028810_DIS_CLIP_ERR_DETECT(~0u)},
	{58322, S_028810_VTX_KILL_OR(~0u)},
	{58334, S_028810_DX_RASTERIZATION_KILL(~0u)},
	{58356, S_028810_DX_LINEAR_ATTR_CLIP_ENA(~0u)},
	{58380, S_028810_VTE_VPORT_PROVOKE_DISABLE(~0u)},
	{58406, S_028810_ZCLIP_NEAR_DISABLE(~0u)},
	{58425, S_028810_ZCLIP_FAR_DISABLE(~0u)},
	/* 1581 */
	{58443, S_028814_CULL_FRONT(~0u)},
	{58454, S_028814_CULL_BACK(~0u)},
	{22820, S_028814_FACE(~0u)},
	{58474, S_028814_POLY_MODE(~0u), 2, 1173},
	{58540, S_028814_POLYMODE_FRONT_PTYPE(~0u), 3, 1175},
	{58561, S_028814_POLYMODE_BACK_PTYPE(~0u), 3, 1175},
	{58581, S_028814_POLY_OFFSET_FRONT_ENABLE(~0u)},
	{58606, S_028814_POLY_OFFSET_BACK_ENABLE(~0u)},
	{58630, S_028814_POLY_OFFSET_PARA_ENABLE(~0u)},
	{58654, S_028814_VTX_WINDOW_OFFSET_ENABLE(~0u)},
	{58679, S_028814_PROVOKING_VTX_LAST(~0u)},
	{58698, S_028814_PERSP_CORR_DIS(~0u)},
	{58713, S_028814_MULTI_PRIM_IB_ENA(~0u)},
	/* 1594 */
	{58731, S_028818_VPORT_X_SCALE_ENA(~0u)},
	{58749, S_028818_VPORT_X_OFFSET_ENA(~0u)},
	{58768, S_028818_VPORT_Y_SCALE_ENA(~0u)},
	{58786, S_028818_VPORT_Y_OFFSET_ENA(~0u)},
	{58805, S_028818_VPORT_Z_SCALE_ENA(~0u)},
	{58823, S_028818_VPORT_Z_OFFSET_ENA(~0u)},
	{58842, S_028818_VTX_XY_FMT(~0u)},
	{58853, S_028818_VTX_Z_FMT(~0u)},
	{58863, S_028818_VTX_W0_FMT(~0u)},
	/* 1603 */
	{58874, S_02881C_CLIP_DIST_ENA_0(~0u)},
	{58890, S_02881C_CLIP_DIST_ENA_1(~0u)},
	{58906, S_02881C_CLIP_DIST_ENA_2(~0u)},
	{58922, S_02881C_CLIP_DIST_ENA_3(~0u)},
	{58938, S_02881C_CLIP_DIST_ENA_4(~0u)},
	{58954, S_02881C_CLIP_DIST_ENA_5(~0u)},
	{58970, S_02881C_CLIP_DIST_ENA_6(~0u)},
	{58986, S_02881C_CLIP_DIST_ENA_7(~0u)},
	{59002, S_02881C_CULL_DIST_ENA_0(~0u)},
	{59018, S_02881C_CULL_DIST_ENA_1(~0u)},
	{59034, S_02881C_CULL_DIST_ENA_2(~0u)},
	{59050, S_02881C_CULL_DIST_ENA_3(~0u)},
	{59066, S_02881C_CULL_DIST_ENA_4(~0u)},
	{59082, S_02881C_CULL_DIST_ENA_5(~0u)},
	{59098, S_02881C_CULL_DIST_ENA_6(~0u)},
	{59114, S_02881C_CULL_DIST_ENA_7(~0u)},
	{59130, S_02881C_USE_VTX_POINT_SIZE(~0u)},
	{59149, S_02881C_USE_VTX_EDGE_FLAG(~0u)},
	{59167, S_02881C_USE_VTX_RENDER_TARGET_INDX(~0u)},
	{59194, S_02881C_USE_VTX_VIEWPORT_INDX(~0u)},
	{59216, S_02881C_USE_VTX_KILL_FLAG(~0u)},
	{59234, S_02881C_VS_OUT_MISC_VEC_ENA(~0u)},
	{59254, S_02881C_VS_OUT_CCDIST0_VEC_ENA(~0u)},
	{59277, S_02881C_VS_OUT_CCDIST1_VEC_ENA(~0u)},
	{59300, S_02881C_VS_OUT_MISC_SIDE_BUS_ENA(~0u)},
	{59325, S_02881C_USE_VTX_GS_CUT_FLAG(~0u)},
	{59345, S_02881C_USE_VTX_LINE_WIDTH(~0u)},
	/* 1630 */
	{59364, S_028820_VTE_XY_INF_DISCARD(~0u)},
	{59383, S_028820_VTE_Z_INF_DISCARD(~0u)},
	{59401, S_028820_VTE_W_INF_DISCARD(~0u)},
	{59419, S_028820_VTE_0XNANINF_IS_0(~0u)},
	{59437, S_028820_VTE_XY_NAN_RETAIN(~0u)},
	{59455, S_028820_VTE_Z_NAN_RETAIN(~0u)},
	{59472, S_028820_VTE_W_NAN_RETAIN(~0u)},
	{59489, S_028820_VTE_W_RECIP_NAN_IS_0(~0u)},
	{59510, S_028820_VS_XY_NAN_TO_INF(~0u)},
	{59527, S_028820_VS_XY_INF_RETAIN(~0u)},
	{59544, S_028820_VS_Z_NAN_TO_INF(~0u)},
	{59560, S_028820_VS_Z_INF_RETAIN(~0u)},
	{59576, S_028820_VS_W_NAN_TO_INF(~0u)},
	{59592, S_028820_VS_W_INF_RETAIN(~0u)},
	{59608, S_028820_VS_CLIP_DIST_INF_DISCARD(~0u)},
	{59633, S_028820_VTE_NO_OUTPUT_NEG_0(~0u)},
	/* 1646 */
	{59653, S_028824_LINE_STIPPLE_RESET(~0u)},
	{59672, S_028824_EXPAND_FULL_LENGTH(~0u)},
	{59691, S_028824_FRACTIONAL_ACCUM(~0u)},
	{59708, S_028824_DIAMOND_ADJUST(~0u)},
	/* 1650 */
	{59723, S_02882C_TRIANGLE_FILTER_DISABLE(~0u)},
	{59747, S_02882C_LINE_FILTER_DISABLE(~0u)},
	{59767, S_02882C_POINT_FILTER_DISABLE(~0u)},
	{59788, S_02882C_RECTANGLE_FILTER_DISABLE(~0u)},
	{59813, S_02882C_TRIANGLE_EXPAND_ENA(~0u)},
	{59833, S_02882C_LINE_EXPAND_ENA(~0u)},
	{59849, S_02882C_POINT_EXPAND_ENA(~0u)},
	{59866, S_02882C_RECTANGLE_EXPAND_ENA(~0u)},
	{59887, S_02882C_PRIM_EXPAND_CONSTANT(~0u)},
	{59908, S_02882C_XMAX_RIGHT_EXCLUSION(~0u)},
	{59929, S_02882C_YMAX_BOTTOM_EXCLUSION(~0u)},
	/* 1661 */
	{59951, S_028830_SMALL_PRIM_FILTER_ENABLE(~0u)},
	{59723, S_028830_TRIANGLE_FILTER_DISABLE(~0u)},
	{59747, S_028830_LINE_FILTER_DISABLE(~0u)},
	{59767, S_028830_POINT_FILTER_DISABLE(~0u)},
	{59788, S_028830_RECTANGLE_FILTER_DISABLE(~0u)},
	/* 1666 */
	{42242, S_028A00_HEIGHT(~0u)},
	{42236, S_028A00_WIDTH(~0u)},
	/* 1668 */
	{59976, S_028A04_MIN_SIZE(~0u)},
	{22515, S_028A04_MAX_SIZE(~0u)},
	/* 1670 */
	{42236, S_028A08_WIDTH(~0u)},
	/* 1671 */
	{59985, S_028A0C_LINE_PATTERN(~0u)},
	{59998, S_028A0C_REPEAT_COUNT(~0u)},
	{60011, S_028A0C_PATTERN_BIT_ORDER(~0u)},
	{60029, S_028A0C_AUTO_RESET_CNTL(~0u)},
	/* 1675 */
	{60150, S_028A10_PATH_SELECT(~0u), 5, 1178},
	/* 1676 */
	{60162, S_028A14_TESS_MODE(~0u)},
	/* 1677 */
	{22108, S_028A20_REUSE_DEPTH(~0u)},
	/* 1678 */
	{22130, S_028A24_PRIM_TYPE(~0u), 18, 1183},
	{60527, S_028A24_RETAIN_ORDER(~0u)},
	{60540, S_028A24_RETAIN_QUADS(~0u)},
	{60621, S_028A24_PRIM_ORDER(~0u), 5, 1201},
	/* 1682 */
	{22150, S_028A28_FIRST_DECR(~0u)},
	/* 1683 */
	{22156, S_028A2C_DECR(~0u)},
	/* 1684 */
	{60632, S_028A30_COMP_X_EN(~0u)},
	{60642, S_028A30_COMP_Y_EN(~0u)},
	{60652, S_028A30_COMP_Z_EN(~0u)},
	{60662, S_028A30_COMP_W_EN(~0u)},
	{23319, S_028A30_STRIDE(~0u)},
	{60672, S_028A30_SHIFT(~0u)},
	/* 1690 */
	{60632, S_028A34_COMP_X_EN(~0u)},
	{60642, S_028A34_COMP_Y_EN(~0u)},
	{60652, S_028A34_COMP_Z_EN(~0u)},
	{60662, S_028A34_COMP_W_EN(~0u)},
	{23319, S_028A34_STRIDE(~0u)},
	{60672, S_028A34_SHIFT(~0u)},
	/* 1696 */
	{60837, S_028A38_X_CONV(~0u), 9, 1206},
	{17707, S_028A38_X_OFFSET(~0u)},
	{60844, S_028A38_Y_CONV(~0u), 9, 1206},
	{50257, S_028A38_Y_OFFSET(~0u)},
	{60851, S_028A38_Z_CONV(~0u), 9, 1206},
	{60858, S_028A38_Z_OFFSET(~0u)},
	{60867, S_028A38_W_CONV(~0u), 9, 1206},
	{15767, S_028A38_W_OFFSET(~0u)},
	/* 1704 */
	{60837, S_028A3C_X_CONV(~0u), 9, 1206},
	{17707, S_028A3C_X_OFFSET(~0u)},
	{60844, S_028A3C_Y_CONV(~0u), 9, 1206},
	{50257, S_028A3C_Y_OFFSET(~0u)},
	{60851, S_028A3C_Z_CONV(~0u), 9, 1206},
	{60858, S_028A3C_Z_OFFSET(~0u)},
	{60867, S_028A3C_W_CONV(~0u), 9, 1206},
	{15767, S_028A3C_W_OFFSET(~0u)},
	/* 1712 */
	{22279, S_028A40_MODE(~0u), 6, 1215},
	{39383, S_028A40_RESERVED_0(~0u)},
	{60992, S_028A40_CUT_MODE(~0u), 4, 1221},
	{39401, S_028A40_RESERVED_1(~0u)},
	{61001, S_028A40_GS_C_PACK_EN(~0u)},
	{61014, S_028A40_RESERVED_2(~0u)},
	{61025, S_028A40_ES_PASSTHRU(~0u)},
	{61037, S_028A40_COMPUTE_MODE(~0u)},
	{61050, S_028A40_FAST_COMPUTE_MODE(~0u)},
	{61068, S_028A40_ELEMENT_INFO_EN(~0u)},
	{61084, S_028A40_PARTIAL_THD_AT_EOI(~0u)},
	{61103, S_028A40_SUPPRESS_CUTS(~0u)},
	{61117, S_028A40_ES_WRITE_OPTIMIZE(~0u)},
	{61135, S_028A40_GS_WRITE_OPTIMIZE(~0u)},
	{61186, S_028A40_ONCHIP(~0u), 4, 1225},
	/* 1727 */
	{61193, S_028A44_ES_VERTS_PER_SUBGRP(~0u)},
	{61213, S_028A44_GS_PRIMS_PER_SUBGRP(~0u)},
	/* 1729 */
	{61233, S_028A48_MSAA_ENABLE(~0u)},
	{61245, S_028A48_VPORT_SCISSOR_ENABLE(~0u)},
	{61266, S_028A48_LINE_STIPPLE_ENABLE(~0u)},
	{61286, S_028A48_SEND_UNLIT_STILES_TO_PKR(~0u)},
	/* 1733 */
	{61311, S_028A4C_WALK_SIZE(~0u)},
	{61321, S_028A4C_WALK_ALIGNMENT(~0u)},
	{61336, S_028A4C_WALK_ALIGN8_PRIM_FITS_ST(~0u)},
	{61361, S_028A4C_WALK_FENCE_ENABLE(~0u)},
	{61379, S_028A4C_WALK_FENCE_SIZE(~0u)},
	{61395, S_028A4C_SUPERTILE_WALK_ORDER_ENABLE(~0u)},
	{61400, S_028A4C_TILE_WALK_ORDER_ENABLE(~0u)},
	{61423, S_028A4C_TILE_COVER_DISABLE(~0u)},
	{61442, S_028A4C_TILE_COVER_NO_SCISSOR(~0u)},
	{61464, S_028A4C_ZMM_LINE_EXTENT(~0u)},
	{61480, S_028A4C_ZMM_LINE_OFFSET(~0u)},
	{61496, S_028A4C_ZMM_RECT_EXTENT(~0u)},
	{61512, S_028A4C_KILL_PIX_POST_HI_Z(~0u)},
	{61531, S_028A4C_KILL_PIX_POST_DETAIL_MASK(~0u)},
	{61557, S_028A4C_PS_ITER_SAMPLE(~0u)},
	{61572, S_028A4C_MULTI_SHADER_ENGINE_PRIM_DISCARD_ENABLE(~0u)},
	{61612, S_028A4C_MULTI_GPU_SUPERTILE_ENABLE(~0u)},
	{61639, S_028A4C_GPU_ID_OVERRIDE_ENABLE(~0u)},
	{61662, S_028A4C_GPU_ID_OVERRIDE(~0u)},
	{61678, S_028A4C_MULTI_GPU_PRIM_DISCARD_ENABLE(~0u)},
	{61708, S_028A4C_FORCE_EOV_CNTDWN_ENABLE(~0u)},
	{61732, S_028A4C_FORCE_EOV_REZ_ENABLE(~0u)},
	{61753, S_028A4C_OUT_OF_ORDER_PRIMITIVE_ENABLE(~0u)},
	{61783, S_028A4C_OUT_OF_ORDER_WATER_MARK(~0u)},
	/* 1757 */
	{22355, S_028A54_GS_PER_ES(~0u)},
	/* 1758 */
	{22369, S_028A58_ES_PER_GS(~0u)},
	/* 1759 */
	{22383, S_028A5C_GS_PER_VS(~0u)},
	/* 1760 */
	{669, S_028A60_OFFSET(~0u)},
	/* 1761 */
	{669, S_028A64_OFFSET(~0u)},
	/* 1762 */
	{669, S_028A68_OFFSET(~0u)},
	/* 1763 */
	{61875, S_028A6C_OUTPRIM_TYPE(~0u), 3, 1229},
	{61888, S_028A6C_OUTPRIM_TYPE_1(~0u)},
	{61903, S_028A6C_OUTPRIM_TYPE_2(~0u)},
	{61918, S_028A6C_OUTPRIM_TYPE_3(~0u)},
	{61933, S_028A6C_UNIQUE_TYPE_PER_STREAM(~0u)},
	/* 1768 */
	{203, S_028A7C_INDEX_TYPE(~0u), 3, 1232},
	{62070, S_028A7C_SWAP_MODE(~0u), 4, 1235},
	{62131, S_028A7C_BUF_TYPE(~0u), 3, 1239},
	{62173, S_028A7C_RDREQ_POLICY_CIK(~0u), 2, 1242},
	{62190, S_028A7C_RDREQ_POLICY(~0u)},
	{40107, S_028A7C_ATC(~0u)},
	{56796, S_028A7C_NOT_EOP(~0u)},
	{62203, S_028A7C_REQ_PATH(~0u)},
	{40128, S_028A7C_MTYPE(~0u)},
	/* 1777 */
	{22558, S_028A84_PRIMITIVEID_EN(~0u)},
	{62212, S_028A84_DISABLE_RESET_ON_EOI(~0u)},
	/* 1779 */
	{63168, S_028A90_EVENT_TYPE(~0u), 59, 1244},
	{63179, S_028A90_ADDRESS_HI_GFX6(~0u)},
	{63195, S_028A90_EXTENDED_EVENT(~0u)},
	/* 1782 */
	{22655, S_028A94_RESET_EN(~0u)},
	/* 1783 */
	{63210, S_028AA8_PRIMGROUP_SIZE(~0u)},
	{63225, S_028AA8_PARTIAL_VS_WAVE_ON(~0u)},
	{63244, S_028AA8_SWITCH_ON_EOP(~0u)},
	{63258, S_028AA8_PARTIAL_ES_WAVE_ON(~0u)},
	{63277, S_028AA8_SWITCH_ON_EOI(~0u)},
	{63291, S_028AA8_WD_SWITCH_ON_EOP(~0u)},
	{63308, S_028AA8_MAX_PRIMGRP_IN_WAVE(~0u)},
	/* 1790 */
	{22747, S_028AAC_ITEMSIZE(~0u)},
	/* 1791 */
	{22747, S_028AB0_ITEMSIZE(~0u)},
	/* 1792 */
	{22783, S_028AB4_REUSE_OFF(~0u)},
	/* 1793 */
	{22797, S_028AB8_VTX_CNT_EN(~0u)},
	/* 1794 */
	{43461, S_028ABC_LINEAR(~0u)},
	{63328, S_028ABC_FULL_CACHE(~0u)},
	{63339, S_028ABC_HTILE_USES_PRELOAD_WIN(~0u)},
	{63362, S_028ABC_PRELOAD(~0u)},
	{63370, S_028ABC_PREFETCH_WIDTH(~0u)},
	{63385, S_028ABC_PREFETCH_HEIGHT(~0u)},
	{63401, S_028ABC_DST_OUTSIDE_ZERO_TO_ONE(~0u)},
	{63425, S_028ABC_TC_COMPATIBLE(~0u)},
	/* 1802 */
	{63439, S_028AC0_COMPAREFUNC0(~0u), 8, 894},
	{63452, S_028AC0_COMPAREVALUE0(~0u)},
	{63466, S_028AC0_COMPAREMASK0(~0u)},
	{48973, S_028AC0_ENABLE0(~0u)},
	/* 1806 */
	{63479, S_028AC4_COMPAREFUNC1(~0u), 8, 894},
	{63492, S_028AC4_COMPAREVALUE1(~0u)},
	{63506, S_028AC4_COMPAREMASK1(~0u)},
	{48991, S_028AC4_ENABLE1(~0u)},
	/* 1810 */
	{7499, S_028AC8_START_X(~0u)},
	{7515, S_028AC8_START_Y(~0u)},
	{63519, S_028AC8_MAX_X(~0u)},
	{63525, S_028AC8_MAX_Y(~0u)},
	/* 1814 */
	{23319, S_028AD4_STRIDE(~0u)},
	/* 1815 */
	{23319, S_028AE4_STRIDE(~0u)},
	/* 1816 */
	{23319, S_028AF4_STRIDE(~0u)},
	/* 1817 */
	{23319, S_028B04_STRIDE(~0u)},
	/* 1818 */
	{23312, S_028B30_VERTEX_STRIDE(~0u)},
	/* 1819 */
	{23333, S_028B38_MAX_VERT_OUT(~0u)},
	/* 1820 */
	{63531, S_028B50_ACCUM_ISOLINE(~0u)},
	{63545, S_028B50_ACCUM_TRI(~0u)},
	{63555, S_028B50_ACCUM_QUAD(~0u)},
	{63566, S_028B50_DONUT_SPLIT(~0u)},
	{63578, S_028B50_TRAP_SPLIT(~0u)},
	/* 1825 */
	{48157, S_028B54_LS_EN(~0u), 3, 1303},
	{48151, S_028B54_HS_EN(~0u)},
	{23383, S_028B54_ES_EN(~0u), 3, 1306},
	{48145, S_028B54_GS_EN(~0u)},
	{48139, S_028B54_VS_EN(~0u), 3, 1309},
	{63712, S_028B54_DYNAMIC_HS(~0u)},
	{46732, S_028B54_DISPATCH_DRAW_EN(~0u)},
	{63723, S_028B54_DIS_DEALLOC_ACCUM_0(~0u)},
	{63743, S_028B54_DIS_DEALLOC_ACCUM_1(~0u)},
	{63763, S_028B54_VS_WAVE_ID_EN(~0u)},
	/* 1835 */
	{63777, S_028B58_NUM_PATCHES(~0u)},
	{63789, S_028B58_HS_NUM_INPUT_CP(~0u)},
	{63805, S_028B58_HS_NUM_OUTPUT_CP(~0u)},
	/* 1838 */
	{22747, S_028B5C_ITEMSIZE(~0u)},
	/* 1839 */
	{22747, S_028B60_ITEMSIZE(~0u)},
	/* 1840 */
	{22747, S_028B64_ITEMSIZE(~0u)},
	/* 1841 */
	{22747, S_028B68_ITEMSIZE(~0u)},
	/* 1842 */
	{209, S_028B6C_TYPE(~0u), 3, 1312},
	{63911, S_028B6C_PARTITIONING(~0u), 4, 1315},
	{63988, S_028B6C_TOPOLOGY(~0u), 4, 1319},
	{63997, S_028B6C_RESERVED_REDUC_AXIS(~0u)},
	{64017, S_028B6C_DEPRECATED(~0u)},
	{64028, S_028B6C_NUM_DS_WAVES_PER_SIMD(~0u)},
	{64050, S_028B6C_DISABLE_DONUTS(~0u)},
	{62173, S_028B6C_RDREQ_POLICY_CIK(~0u), 3, 1323},
	{62190, S_028B6C_RDREQ_POLICY(~0u)},
	{64189, S_028B6C_DISTRIBUTION_MODE(~0u), 4, 1326},
	{40128, S_028B6C_MTYPE(~0u)},
	/* 1853 */
	{64207, S_028B70_ALPHA_TO_MASK_ENABLE(~0u)},
	{64228, S_028B70_ALPHA_TO_MASK_OFFSET0(~0u)},
	{64250, S_028B70_ALPHA_TO_MASK_OFFSET1(~0u)},
	{64272, S_028B70_ALPHA_TO_MASK_OFFSET2(~0u)},
	{64294, S_028B70_ALPHA_TO_MASK_OFFSET3(~0u)},
	{64316, S_028B70_OFFSET_ROUND(~0u)},
	/* 1859 */
	{64329, S_028B78_POLY_OFFSET_NEG_NUM_DB_BITS(~0u)},
	{64357, S_028B78_POLY_OFFSET_DB_IS_FLOAT_FMT(~0u)},
	/* 1861 */
	{7643, S_028B90_ENABLE(~0u)},
	{23740, S_028B90_CNT(~0u)},
	/* 1863 */
	{64385, S_028B94_STREAMOUT_0_EN(~0u)},
	{64400, S_028B94_STREAMOUT_1_EN(~0u)},
	{64415, S_028B94_STREAMOUT_2_EN(~0u)},
	{64430, S_028B94_STREAMOUT_3_EN(~0u)},
	{64445, S_028B94_RAST_STREAM(~0u)},
	{64457, S_028B94_RAST_STREAM_MASK(~0u)},
	{64474, S_028B94_USE_RAST_STREAM_MASK(~0u)},
	/* 1870 */
	{64495, S_028B98_STREAM_0_BUFFER_EN(~0u)},
	{64514, S_028B98_STREAM_1_BUFFER_EN(~0u)},
	{64533, S_028B98_STREAM_2_BUFFER_EN(~0u)},
	{64552, S_028B98_STREAM_3_BUFFER_EN(~0u)},
	/* 1874 */
	{64571, S_028BD4_DISTANCE_0(~0u)},
	{64582, S_028BD4_DISTANCE_1(~0u)},
	{64593, S_028BD4_DISTANCE_2(~0u)},
	{64604, S_028BD4_DISTANCE_3(~0u)},
	{64615, S_028BD4_DISTANCE_4(~0u)},
	{64626, S_028BD4_DISTANCE_5(~0u)},
	{64637, S_028BD4_DISTANCE_6(~0u)},
	{64648, S_028BD4_DISTANCE_7(~0u)},
	/* 1882 */
	{64659, S_028BD8_DISTANCE_8(~0u)},
	{64670, S_028BD8_DISTANCE_9(~0u)},
	{64681, S_028BD8_DISTANCE_10(~0u)},
	{64693, S_028BD8_DISTANCE_11(~0u)},
	{64705, S_028BD8_DISTANCE_12(~0u)},
	{64717, S_028BD8_DISTANCE_13(~0u)},
	{64729, S_028BD8_DISTANCE_14(~0u)},
	{64741, S_028BD8_DISTANCE_15(~0u)},
	/* 1890 */
	{64753, S_028BDC_EXPAND_LINE_WIDTH(~0u)},
	{64771, S_028BDC_LAST_PIXEL(~0u)},
	{64782, S_028BDC_PERPENDICULAR_ENDCAP_ENA(~0u)},
	{64807, S_028BDC_DX10_DIAMOND_TEST_ENA(~0u)},
	/* 1894 */
	{64829, S_028BE0_MSAA_NUM_SAMPLES(~0u)},
	{64846, S_028BE0_AA_MASK_CENTROID_DTMN(~0u)},
	{64868, S_028BE0_MAX_SAMPLE_DIST(~0u)},
	{64884, S_028BE0_MSAA_EXPOSED_SAMPLES(~0u)},
	{64905, S_028BE0_DETAIL_TO_EXPOSED_MODE(~0u)},
	/* 1899 */
	{64928, S_028BE4_PIX_CENTER(~0u)},
	{64989, S_028BE4_ROUND_MODE(~0u), 4, 1330},
	{65205, S_028BE4_QUANT_MODE(~0u), 8, 1334},
	/* 1902 */
	{65216, S_028BF8_S0_X(~0u)},
	{65221, S_028BF8_S0_Y(~0u)},
	{65226, S_028BF8_S1_X(~0u)},
	{65231, S_028BF8_S1_Y(~0u)},
	{65236, S_028BF8_S2_X(~0u)},
	{65241, S_028BF8_S2_Y(~0u)},
	{65246, S_028BF8_S3_X(~0u)},
	{65251, S_028BF8_S3_Y(~0u)},
	/* 1910 */
	{65256, S_028BFC_S4_X(~0u)},
	{65261, S_028BFC_S4_Y(~0u)},
	{65266, S_028BFC_S5_X(~0u)},
	{65271, S_028BFC_S5_Y(~0u)},
	{65276, S_028BFC_S6_X(~0u)},
	{65281, S_028BFC_S6_Y(~0u)},
	{65286, S_028BFC_S7_X(~0u)},
	{65291, S_028BFC_S7_Y(~0u)},
	/* 1918 */
	{65296, S_028C00_S8_X(~0u)},
	{65301, S_028C00_S8_Y(~0u)},
	{65306, S_028C00_S9_X(~0u)},
	{65311, S_028C00_S9_Y(~0u)},
	{65316, S_028C00_S10_X(~0u)},
	{65322, S_028C00_S10_Y(~0u)},
	{65328, S_028C00_S11_X(~0u)},
	{65334, S_028C00_S11_Y(~0u)},
	/* 1926 */
	{65340, S_028C04_S12_X(~0u)},
	{65346, S_028C04_S12_Y(~0u)},
	{65352, S_028C04_S13_X(~0u)},
	{65358, S_028C04_S13_Y(~0u)},
	{65364, S_028C04_S14_X(~0u)},
	{65370, S_028C04_S14_Y(~0u)},
	{65376, S_028C04_S15_X(~0u)},
	{65382, S_028C04_S15_Y(~0u)},
	/* 1934 */
	{65216, S_028C08_S0_X(~0u)},
	{65221, S_028C08_S0_Y(~0u)},
	{65226, S_028C08_S1_X(~0u)},
	{65231, S_028C08_S1_Y(~0u)},
	{65236, S_028C08_S2_X(~0u)},
	{65241, S_028C08_S2_Y(~0u)},
	{65246, S_028C08_S3_X(~0u)},
	{65251, S_028C08_S3_Y(~0u)},
	/* 1942 */
	{65256, S_028C0C_S4_X(~0u)},
	{65261, S_028C0C_S4_Y(~0u)},
	{65266, S_028C0C_S5_X(~0u)},
	{65271, S_028C0C_S5_Y(~0u)},
	{65276, S_028C0C_S6_X(~0u)},
	{65281, S_028C0C_S6_Y(~0u)},
	{65286, S_028C0C_S7_X(~0u)},
	{65291, S_028C0C_S7_Y(~0u)},
	/* 1950 */
	{65296, S_028C10_S8_X(~0u)},
	{65301, S_028C10_S8_Y(~0u)},
	{65306, S_028C10_S9_X(~0u)},
	{65311, S_028C10_S9_Y(~0u)},
	{65316, S_028C10_S10_X(~0u)},
	{65322, S_028C10_S10_Y(~0u)},
	{65328, S_028C10_S11_X(~0u)},
	{65334, S_028C10_S11_Y(~0u)},
	/* 1958 */
	{65340, S_028C14_S12_X(~0u)},
	{65346, S_028C14_S12_Y(~0u)},
	{65352, S_028C14_S13_X(~0u)},
	{65358, S_028C14_S13_Y(~0u)},
	{65364, S_028C14_S14_X(~0u)},
	{65370, S_028C14_S14_Y(~0u)},
	{65376, S_028C14_S15_X(~0u)},
	{65382, S_028C14_S15_Y(~0u)},
	/* 1966 */
	{65216, S_028C18_S0_X(~0u)},
	{65221, S_028C18_S0_Y(~0u)},
	{65226, S_028C18_S1_X(~0u)},
	{65231, S_028C18_S1_Y(~0u)},
	{65236, S_028C18_S2_X(~0u)},
	{65241, S_028C18_S2_Y(~0u)},
	{65246, S_028C18_S3_X(~0u)},
	{65251, S_028C18_S3_Y(~0u)},
	/* 1974 */
	{65256, S_028C1C_S4_X(~0u)},
	{65261, S_028C1C_S4_Y(~0u)},
	{65266, S_028C1C_S5_X(~0u)},
	{65271, S_028C1C_S5_Y(~0u)},
	{65276, S_028C1C_S6_X(~0u)},
	{65281, S_028C1C_S6_Y(~0u)},
	{65286, S_028C1C_S7_X(~0u)},
	{65291, S_028C1C_S7_Y(~0u)},
	/* 1982 */
	{65296, S_028C20_S8_X(~0u)},
	{65301, S_028C20_S8_Y(~0u)},
	{65306, S_028C20_S9_X(~0u)},
	{65311, S_028C20_S9_Y(~0u)},
	{65316, S_028C20_S10_X(~0u)},
	{65322, S_028C20_S10_Y(~0u)},
	{65328, S_028C20_S11_X(~0u)},
	{65334, S_028C20_S11_Y(~0u)},
	/* 1990 */
	{65340, S_028C24_S12_X(~0u)},
	{65346, S_028C24_S12_Y(~0u)},
	{65352, S_028C24_S13_X(~0u)},
	{65358, S_028C24_S13_Y(~0u)},
	{65364, S_028C24_S14_X(~0u)},
	{65370, S_028C24_S14_Y(~0u)},
	{65376, S_028C24_S15_X(~0u)},
	{65382, S_028C24_S15_Y(~0u)},
	/* 1998 */
	{65216, S_028C28_S0_X(~0u)},
	{65221, S_028C28_S0_Y(~0u)},
	{65226, S_028C28_S1_X(~0u)},
	{65231, S_028C28_S1_Y(~0u)},
	{65236, S_028C28_S2_X(~0u)},
	{65241, S_028C28_S2_Y(~0u)},
	{65246, S_028C28_S3_X(~0u)},
	{65251, S_028C28_S3_Y(~0u)},
	/* 2006 */
	{65256, S_028C2C_S4_X(~0u)},
	{65261, S_028C2C_S4_Y(~0u)},
	{65266, S_028C2C_S5_X(~0u)},
	{65271, S_028C2C_S5_Y(~0u)},
	{65276, S_028C2C_S6_X(~0u)},
	{65281, S_028C2C_S6_Y(~0u)},
	{65286, S_028C2C_S7_X(~0u)},
	{65291, S_028C2C_S7_Y(~0u)},
	/* 2014 */
	{65296, S_028C30_S8_X(~0u)},
	{65301, S_028C30_S8_Y(~0u)},
	{65306, S_028C30_S9_X(~0u)},
	{65311, S_028C30_S9_Y(~0u)},
	{65316, S_028C30_S10_X(~0u)},
	{65322, S_028C30_S10_Y(~0u)},
	{65328, S_028C30_S11_X(~0u)},
	{65334, S_028C30_S11_Y(~0u)},
	/* 2022 */
	{65340, S_028C34_S12_X(~0u)},
	{65346, S_028C34_S12_Y(~0u)},
	{65352, S_028C34_S13_X(~0u)},
	{65358, S_028C34_S13_Y(~0u)},
	{65364, S_028C34_S14_X(~0u)},
	{65370, S_028C34_S14_Y(~0u)},
	{65376, S_028C34_S15_X(~0u)},
	{65382, S_028C34_S15_Y(~0u)},
	/* 2030 */
	{65388, S_028C38_AA_MASK_X0Y0(~0u)},
	{65401, S_028C38_AA_MASK_X1Y0(~0u)},
	/* 2032 */
	{65414, S_028C3C_AA_MASK_X0Y1(~0u)},
	{65427, S_028C3C_AA_MASK_X1Y1(~0u)},
	/* 2034 */
	{65440, S_028C40_REALIGN_DQUADS_AFTER_N_WAVES(~0u)},
	/* 2035 */
	{65469, S_028C58_VTX_REUSE_DEPTH(~0u)},
	/* 2036 */
	{65485, S_028C5C_DEALLOC_DIST(~0u)},
	/* 2037 */
	{50194, S_028C64_TILE_MAX(~0u)},
	{65498, S_028C64_FMASK_TILE_MAX(~0u)},
	/* 2039 */
	{50194, S_028C68_TILE_MAX(~0u)},
	/* 2040 */
	{48842, S_028C6C_SLICE_START(~0u)},
	{48854, S_028C6C_SLICE_MAX(~0u)},
	/* 2042 */
	{65564, S_028C70_ENDIAN(~0u), 4, 1342},
	{21132, S_028C70_FORMAT(~0u), 23, 1346},
	{45121, S_028C70_LINEAR_GENERAL(~0u)},
	{65931, S_028C70_NUMBER_TYPE(~0u), 8, 1369},
	{65987, S_028C70_COMP_SWAP(~0u), 4, 1377},
	{57519, S_028C70_FAST_CLEAR(~0u)},
	{49428, S_028C70_COMPRESSION(~0u)},
	{65997, S_028C70_BLEND_CLAMP(~0u)},
	{66009, S_028C70_BLEND_BYPASS(~0u)},
	{66022, S_028C70_SIMPLE_FLOAT(~0u)},
	{64989, S_028C70_ROUND_MODE(~0u)},
	{66035, S_028C70_CMASK_IS_LINEAR(~0u)},
	{66262, S_028C70_BLEND_OPT_DONT_RD_DST(~0u), 8, 1381},
	{66284, S_028C70_BLEND_OPT_DISCARD_PIXEL(~0u), 8, 1381},
	{66308, S_028C70_FMASK_COMPRESSION_DISABLE(~0u)},
	{66334, S_028C70_FMASK_COMPRESS_1FRAG_ONLY(~0u)},
	{66360, S_028C70_DCC_ENABLE(~0u)},
	{66371, S_028C70_CMASK_ADDR_TYPE(~0u)},
	/* 2060 */
	{50022, S_028C74_TILE_MODE_INDEX(~0u)},
	{66387, S_028C74_FMASK_TILE_MODE_INDEX(~0u)},
	{66409, S_028C74_FMASK_BANK_HEIGHT(~0u)},
	{50010, S_028C74_NUM_SAMPLES(~0u)},
	{66427, S_028C74_NUM_FRAGMENTS(~0u)},
	{66441, S_028C74_FORCE_DST_ALPHA_1(~0u)},
	/* 2066 */
	{52586, S_028C78_OVERWRITE_COMBINER_DISABLE(~0u)},
	{66459, S_028C78_KEY_CLEAR_ENABLE(~0u)},
	{66535, S_028C78_MAX_UNCOMPRESSED_BLOCK_SIZE(~0u), 3, 1389},
	{66601, S_028C78_MIN_COMPRESSED_BLOCK_SIZE(~0u), 2, 1392},
	{66627, S_028C78_MAX_COMPRESSED_BLOCK_SIZE(~0u)},
	{42723, S_028C78_COLOR_TRANSFORM(~0u)},
	{66653, S_028C78_INDEPENDENT_64B_BLOCKS(~0u)},
	{66676, S_028C78_LOSSY_RGB_PRECISION(~0u)},
	{66696, S_028C78_LOSSY_ALPHA_PRECISION(~0u)},
	/* 2075 */
	{50194, S_028C80_TILE_MAX(~0u)},
	/* 2076 */
	{50194, S_028C88_TILE_MAX(~0u)},
	/* 2077 */
	{33200, S_008008_ME0PIPE1_CMDFIFO_AVAIL(~0u)},
	{33223, S_008008_ME0PIPE1_CF_RQ_PENDING(~0u)},
	{33246, S_008008_ME0PIPE1_PF_RQ_PENDING(~0u)},
	{33269, S_008008_ME1PIPE0_RQ_PENDING(~0u)},
	{33289, S_008008_ME1PIPE1_RQ_PENDING(~0u)},
	{33309, S_008008_ME1PIPE2_RQ_PENDING(~0u)},
	{33329, S_008008_ME1PIPE3_RQ_PENDING(~0u)},
	{33349, S_008008_ME2PIPE0_RQ_PENDING(~0u)},
	{33369, S_008008_ME2PIPE1_RQ_PENDING(~0u)},
	{33389, S_008008_ME2PIPE2_RQ_PENDING(~0u)},
	{33409, S_008008_ME2PIPE3_RQ_PENDING(~0u)},
	{33429, S_008008_RLC_RQ_PENDING(~0u)},
	{66718, S_008008_UTCL2_BUSY(~0u)},
	{66729, S_008008_EA_BUSY(~0u)},
	{66737, S_008008_RMI_BUSY(~0u)},
	{66746, S_008008_UTCL2_RQ_PENDING(~0u)},
	{66763, S_008008_CPF_RQ_PENDING(~0u)},
	{66778, S_008008_EA_LINK_BUSY(~0u)},
	{33444, S_008008_RLC_BUSY(~0u)},
	{33453, S_008008_TC_BUSY(~0u)},
	{33461, S_008008_TCC_CC_RESIDENT(~0u)},
	{33477, S_008008_CPF_BUSY(~0u)},
	{33486, S_008008_CPC_BUSY(~0u)},
	{33495, S_008008_CPG_BUSY(~0u)},
	{66791, S_008008_CPAXI_BUSY(~0u)},
	/* 2102 */
	{33504, S_008010_ME0PIPE0_CMDFIFO_AVAIL(~0u)},
	{66802, S_008010_RSMU_RQ_PENDING(~0u)},
	{33543, S_008010_ME0PIPE0_CF_RQ_PENDING(~0u)},
	{33566, S_008010_ME0PIPE0_PF_RQ_PENDING(~0u)},
	{33589, S_008010_GDS_DMA_RQ_PENDING(~0u)},
	{33608, S_008010_DB_CLEAN(~0u)},
	{33617, S_008010_CB_CLEAN(~0u)},
	{33626, S_008010_TA_BUSY(~0u)},
	{33634, S_008010_GDS_BUSY(~0u)},
	{33643, S_008010_WD_BUSY_NO_DMA(~0u)},
	{33658, S_008010_VGT_BUSY(~0u)},
	{33667, S_008010_IA_BUSY_NO_DMA(~0u)},
	{33682, S_008010_IA_BUSY(~0u)},
	{33690, S_008010_SX_BUSY(~0u)},
	{33698, S_008010_WD_BUSY(~0u)},
	{33706, S_008010_SPI_BUSY(~0u)},
	{33715, S_008010_BCI_BUSY(~0u)},
	{33724, S_008010_SC_BUSY(~0u)},
	{33732, S_008010_PA_BUSY(~0u)},
	{33740, S_008010_DB_BUSY(~0u)},
	{33748, S_008010_CP_COHERENCY_BUSY(~0u)},
	{32311, S_008010_CP_BUSY(~0u)},
	{32533, S_008010_CB_BUSY(~0u)},
	{33766, S_008010_GUI_ACTIVE(~0u)},
	/* 2126 */
	{33608, S_008014_DB_CLEAN(~0u)},
	{33617, S_008014_CB_CLEAN(~0u)},
	{66737, S_008014_RMI_BUSY(~0u)},
	{33715, S_008014_BCI_BUSY(~0u)},
	{33658, S_008014_VGT_BUSY(~0u)},
	{33732, S_008014_PA_BUSY(~0u)},
	{33626, S_008014_TA_BUSY(~0u)},
	{33690, S_008014_SX_BUSY(~0u)},
	{33706, S_008014_SPI_BUSY(~0u)},
	{33724, S_008014_SC_BUSY(~0u)},
	{33740, S_008014_DB_BUSY(~0u)},
	{32533, S_008014_CB_BUSY(~0u)},
	/* 2138 */
	{33608, S_008018_DB_CLEAN(~0u)},
	{33617, S_008018_CB_CLEAN(~0u)},
	{66737, S_008018_RMI_BUSY(~0u)},
	{33715, S_008018_BCI_BUSY(~0u)},
	{33658, S_008018_VGT_BUSY(~0u)},
	{33732, S_008018_PA_BUSY(~0u)},
	{33626, S_008018_TA_BUSY(~0u)},
	{33690, S_008018_SX_BUSY(~0u)},
	{33706, S_008018_SPI_BUSY(~0u)},
	{33724, S_008018_SC_BUSY(~0u)},
	{33740, S_008018_DB_BUSY(~0u)},
	{32533, S_008018_CB_BUSY(~0u)},
	/* 2150 */
	{33608, S_008038_DB_CLEAN(~0u)},
	{33617, S_008038_CB_CLEAN(~0u)},
	{66737, S_008038_RMI_BUSY(~0u)},
	{33715, S_008038_BCI_BUSY(~0u)},
	{33658, S_008038_VGT_BUSY(~0u)},
	{33732, S_008038_PA_BUSY(~0u)},
	{33626, S_008038_TA_BUSY(~0u)},
	{33690, S_008038_SX_BUSY(~0u)},
	{33706, S_008038_SPI_BUSY(~0u)},
	{33724, S_008038_SC_BUSY(~0u)},
	{33740, S_008038_DB_BUSY(~0u)},
	{32533, S_008038_CB_BUSY(~0u)},
	/* 2162 */
	{33608, S_00803C_DB_CLEAN(~0u)},
	{33617, S_00803C_CB_CLEAN(~0u)},
	{66737, S_00803C_RMI_BUSY(~0u)},
	{33715, S_00803C_BCI_BUSY(~0u)},
	{33658, S_00803C_VGT_BUSY(~0u)},
	{33732, S_00803C_PA_BUSY(~0u)},
	{33626, S_00803C_TA_BUSY(~0u)},
	{33690, S_00803C_SX_BUSY(~0u)},
	{33706, S_00803C_SPI_BUSY(~0u)},
	{33724, S_00803C_SC_BUSY(~0u)},
	{33740, S_00803C_DB_BUSY(~0u)},
	{32533, S_00803C_CB_BUSY(~0u)},
	/* 2174 */
	{34274, S_0301F0_TC_NC_ACTION_ENA(~0u)},
	{66818, S_0301F0_TC_WC_ACTION_ENA(~0u)},
	{66835, S_0301F0_TC_INV_METADATA_ACTION_ENA(~0u)},
	{34291, S_0301F0_TCL1_VOL_ACTION_ENA(~0u)},
	{34329, S_0301F0_TC_WB_ACTION_ENA(~0u)},
	{34120, S_0301F0_TCL1_ACTION_ENA(~0u)},
	{34136, S_0301F0_TC_ACTION_ENA(~0u)},
	{34150, S_0301F0_CB_ACTION_ENA(~0u)},
	{34164, S_0301F0_DB_ACTION_ENA(~0u)},
	{34178, S_0301F0_SH_KCACHE_ACTION_ENA(~0u)},
	{34346, S_0301F0_SH_KCACHE_VOL_ACTION_ENA(~0u)},
	{34199, S_0301F0_SH_ICACHE_ACTION_ENA(~0u)},
	{34371, S_0301F0_SH_KCACHE_WB_ACTION_ENA(~0u)},
	/* 2187 */
	{34430, S_0301FC_MEID(~0u)},
	{1005, S_0301FC_STATUS(~0u)},
	/* 2189 */
	{34449, S_008210_MEC1_BUSY(~0u)},
	{34459, S_008210_MEC2_BUSY(~0u)},
	{34469, S_008210_DC0_BUSY(~0u)},
	{34478, S_008210_DC1_BUSY(~0u)},
	{34487, S_008210_RCIU1_BUSY(~0u)},
	{34498, S_008210_RCIU2_BUSY(~0u)},
	{34509, S_008210_ROQ1_BUSY(~0u)},
	{34519, S_008210_ROQ2_BUSY(~0u)},
	{34529, S_008210_TCIU_BUSY(~0u)},
	{34539, S_008210_SCRATCH_RAM_BUSY(~0u)},
	{34556, S_008210_QU_BUSY(~0u)},
	{66862, S_008210_UTCL2IU_BUSY(~0u)},
	{66875, S_008210_SAVE_RESTORE_BUSY(~0u)},
	{34577, S_008210_CPG_CPC_BUSY(~0u)},
	{34590, S_008210_CPF_CPC_BUSY(~0u)},
	{33486, S_008210_CPC_BUSY(~0u)},
	/* 2205 */
	{35087, S_008218_RCIU_TX_FREE_STALL(~0u)},
	{35106, S_008218_RCIU_PRIV_VIOLATION(~0u)},
	{35126, S_008218_TCIU_TX_FREE_STALL(~0u)},
	{35145, S_008218_MEC1_DECODING_PACKET(~0u)},
	{35166, S_008218_MEC1_WAIT_ON_RCIU(~0u)},
	{35184, S_008218_MEC1_WAIT_ON_RCIU_READ(~0u)},
	{35207, S_008218_MEC1_WAIT_ON_ROQ_DATA(~0u)},
	{35229, S_008218_MEC2_DECODING_PACKET(~0u)},
	{35250, S_008218_MEC2_WAIT_ON_RCIU(~0u)},
	{35268, S_008218_MEC2_WAIT_ON_RCIU_READ(~0u)},
	{35291, S_008218_MEC2_WAIT_ON_ROQ_DATA(~0u)},
	{66893, S_008218_UTCL2IU_WAITING_ON_FREE(~0u)},
	{66917, S_008218_UTCL2IU_WAITING_ON_TAGS(~0u)},
	{66941, S_008218_UTCL1_WAITING_ON_TRANS(~0u)},
	/* 2219 */
	{35384, S_00821C_POST_WPTR_GFX_BUSY(~0u)},
	{35403, S_00821C_CSF_BUSY(~0u)},
	{35412, S_00821C_ROQ_ALIGN_BUSY(~0u)},
	{35427, S_00821C_ROQ_RING_BUSY(~0u)},
	{35441, S_00821C_ROQ_INDIRECT1_BUSY(~0u)},
	{35460, S_00821C_ROQ_INDIRECT2_BUSY(~0u)},
	{35479, S_00821C_ROQ_STATE_BUSY(~0u)},
	{35494, S_00821C_ROQ_CE_RING_BUSY(~0u)},
	{35511, S_00821C_ROQ_CE_INDIRECT1_BUSY(~0u)},
	{35533, S_00821C_ROQ_CE_INDIRECT2_BUSY(~0u)},
	{35555, S_00821C_SEMAPHORE_BUSY(~0u)},
	{35570, S_00821C_INTERRUPT_BUSY(~0u)},
	{34529, S_00821C_TCIU_BUSY(~0u)},
	{35585, S_00821C_HQD_BUSY(~0u)},
	{35594, S_00821C_PRT_BUSY(~0u)},
	{66862, S_00821C_UTCL2IU_BUSY(~0u)},
	{35603, S_00821C_CPF_GFX_BUSY(~0u)},
	{35616, S_00821C_CPF_CMP_BUSY(~0u)},
	{35629, S_00821C_GRBM_CPF_STAT_BUSY(~0u)},
	{35648, S_00821C_CPC_CPF_BUSY(~0u)},
	{33477, S_00821C_CPF_BUSY(~0u)},
	/* 2240 */
	{36236, S_008224_RING_FETCHING_DATA(~0u)},
	{36255, S_008224_INDR1_FETCHING_DATA(~0u)},
	{36275, S_008224_INDR2_FETCHING_DATA(~0u)},
	{36295, S_008224_STATE_FETCHING_DATA(~0u)},
	{36315, S_008224_TCIU_WAITING_ON_FREE(~0u)},
	{36336, S_008224_TCIU_WAITING_ON_TAGS(~0u)},
	{66893, S_008224_UTCL2IU_WAITING_ON_FREE(~0u)},
	{66917, S_008224_UTCL2IU_WAITING_ON_TAGS(~0u)},
	{66964, S_008224_GFX_UTCL1_WAITING_ON_TRANS(~0u)},
	{66991, S_008224_CMP_UTCL1_WAITING_ON_TRANS(~0u)},
	{67018, S_008224_RCIU_WAITING_ON_FREE(~0u)},
	/* 2251 */
	{37126, S_008670_CE_TO_CSF_NOT_RDY_TO_RCV(~0u)},
	{37151, S_008670_CE_TO_RAM_INIT_FETCHER_NOT_RDY_TO_RCV(~0u)},
	{37189, S_008670_CE_WAITING_ON_DATA_FROM_RAM_INIT_FETCHER(~0u)},
	{37230, S_008670_CE_TO_RAM_INIT_NOT_RDY(~0u)},
	{37253, S_008670_CE_TO_RAM_DUMP_NOT_RDY(~0u)},
	{37276, S_008670_CE_TO_RAM_WRITE_NOT_RDY(~0u)},
	{37300, S_008670_CE_TO_INC_FIFO_NOT_RDY_TO_RCV(~0u)},
	{37330, S_008670_CE_TO_WR_FIFO_NOT_RDY_TO_RCV(~0u)},
	{37359, S_008670_CE_WAITING_ON_BUFFER_DATA(~0u)},
	{37385, S_008670_CE_WAITING_ON_CE_BUFFER_FLAG(~0u)},
	{37414, S_008670_CE_WAITING_ON_DE_COUNTER(~0u)},
	{37439, S_008670_CE_WAITING_ON_DE_COUNTER_UNDERFLOW(~0u)},
	{36315, S_008670_TCIU_WAITING_ON_FREE(~0u)},
	{36336, S_008670_TCIU_WAITING_ON_TAGS(~0u)},
	{37474, S_008670_CE_STALLED_ON_TC_WR_CONFIRM(~0u)},
	{37502, S_008670_CE_STALLED_ON_ATOMIC_RTN_DATA(~0u)},
	{66893, S_008670_UTCL2IU_WAITING_ON_FREE(~0u)},
	{66917, S_008670_UTCL2IU_WAITING_ON_TAGS(~0u)},
	{66941, S_008670_UTCL1_WAITING_ON_TRANS(~0u)},
	/* 2270 */
	{35427, S_008680_ROQ_RING_BUSY(~0u)},
	{35441, S_008680_ROQ_INDIRECT1_BUSY(~0u)},
	{35460, S_008680_ROQ_INDIRECT2_BUSY(~0u)},
	{35479, S_008680_ROQ_STATE_BUSY(~0u)},
	{38732, S_008680_DC_BUSY(~0u)},
	{66862, S_008680_UTCL2IU_BUSY(~0u)},
	{38740, S_008680_PFP_BUSY(~0u)},
	{38749, S_008680_MEQ_BUSY(~0u)},
	{38758, S_008680_ME_BUSY(~0u)},
	{38766, S_008680_QUERY_BUSY(~0u)},
	{35555, S_008680_SEMAPHORE_BUSY(~0u)},
	{35570, S_008680_INTERRUPT_BUSY(~0u)},
	{38777, S_008680_SURFACE_SYNC_BUSY(~0u)},
	{32235, S_008680_DMA_BUSY(~0u)},
	{38795, S_008680_RCIU_BUSY(~0u)},
	{34539, S_008680_SCRATCH_RAM_BUSY(~0u)},
	{38818, S_008680_CE_BUSY(~0u)},
	{34529, S_008680_TCIU_BUSY(~0u)},
	{35494, S_008680_ROQ_CE_RING_BUSY(~0u)},
	{35511, S_008680_ROQ_CE_INDIRECT1_BUSY(~0u)},
	{35533, S_008680_ROQ_CE_INDIRECT2_BUSY(~0u)},
	{32311, S_008680_CP_BUSY(~0u)},
	/* 2292 */
	{22130, S_030908_PRIM_TYPE(~0u), 29, 26},
	/* 2293 */
	{203, S_03090C_INDEX_TYPE(~0u), 2, 55},
	{67039, S_03090C_PRIMGEN_EN(~0u)},
	/* 2295 */
	{22655, S_03092C_RESET_EN(~0u)},
	{67050, S_03092C_MATCH_ALL_BITS(~0u)},
	/* 2297 */
	{37005, S_03093C_OFFCHIP_BUFFERING(~0u)},
	{38874, S_03093C_OFFCHIP_GRANULARITY(~0u)},
	/* 2299 */
	{880, S_030944_BASE_HI(~0u)},
	/* 2300 */
	{880, S_03094C_BASE_HI(~0u)},
	/* 2301 */
	{880, S_030954_BASE_HI(~0u)},
	/* 2302 */
	{880, S_03095C_BASE_HI(~0u)},
	/* 2303 */
	{63210, S_030960_PRIMGROUP_SIZE(~0u)},
	{63225, S_030960_PARTIAL_VS_WAVE_ON(~0u)},
	{63244, S_030960_SWITCH_ON_EOP(~0u)},
	{63258, S_030960_PARTIAL_ES_WAVE_ON(~0u)},
	{63277, S_030960_SWITCH_ON_EOI(~0u)},
	{63291, S_030960_WD_SWITCH_ON_EOP(~0u)},
	{67065, S_030960_EN_INST_OPT_BASIC(~0u)},
	{67083, S_030960_EN_INST_OPT_ADV(~0u)},
	{67099, S_030960_HW_USE_ONLY(~0u)},
	/* 2312 */
	{67111, S_030D20_TARGET_INST(~0u)},
	{67123, S_030D20_TARGET_DATA(~0u)},
	{39148, S_030D20_INVALIDATE(~0u)},
	{26860, S_030D20_WRITEBACK(~0u)},
	{46950, S_030D20_VOL(~0u)},
	{67135, S_030D20_COMPLETE(~0u)},
	/* 2318 */
	{67144, S_030D24_DWB(~0u)},
	{49359, S_030D24_DIRTY(~0u)},
	/* 2320 */
	{67148, S_030E08_GRAD_ADJ_0(~0u)},
	{67159, S_030E08_GRAD_ADJ_1(~0u)},
	{67170, S_030E08_GRAD_ADJ_2(~0u)},
	{67181, S_030E08_GRAD_ADJ_3(~0u)},
	/* 2324 */
	{39448, S_008F0C_DST_SEL_X(~0u), 8, 186},
	{39458, S_008F0C_DST_SEL_Y(~0u), 8, 186},
	{39468, S_008F0C_DST_SEL_Z(~0u), 8, 186},
	{39478, S_008F0C_DST_SEL_W(~0u), 8, 186},
	{39662, S_008F0C_NUM_FORMAT(~0u), 8, 194},
	{40054, S_008F0C_DATA_FORMAT(~0u), 16, 202},
	{67192, S_008F0C_USER_VM_ENABLE(~0u)},
	{67207, S_008F0C_USER_VM_MODE(~0u)},
	{40079, S_008F0C_INDEX_STRIDE(~0u)},
	{40092, S_008F0C_ADD_TID_ENABLE(~0u)},
	{60841, S_008F0C_NV(~0u)},
	{209, S_008F0C_TYPE(~0u), 4, 218},
	/* 2336 */
	{39313, S_008F14_BASE_ADDRESS_HI(~0u)},
	{40203, S_008F14_MIN_LOD(~0u)},
	{67792, S_008F14_DATA_FORMAT_GFX9(~0u), 64, 1394},
	{67885, S_008F14_NUM_FORMAT_GFX9(~0u), 11, 1458},
	{68120, S_008F14_NUM_FORMAT_FMASK(~0u), 13, 1469},
	{68370, S_008F14_NUM_FORMAT_ASTC_2D(~0u), 14, 1482},
	{68569, S_008F14_NUM_FORMAT_ASTC_3D(~0u), 10, 1496},
	{60841, S_008F14_NV(~0u)},
	{68588, S_008F14_META_DIRECT(~0u)},
	/* 2345 */
	{39448, S_008F1C_DST_SEL_X(~0u), 8, 186},
	{39458, S_008F1C_DST_SEL_Y(~0u), 8, 186},
	{39468, S_008F1C_DST_SEL_Z(~0u), 8, 186},
	{39478, S_008F1C_DST_SEL_W(~0u), 8, 186},
	{42269, S_008F1C_BASE_LEVEL(~0u)},
	{42280, S_008F1C_LAST_LEVEL(~0u)},
	{68600, S_008F1C_SW_MODE(~0u)},
	{209, S_008F1C_TYPE(~0u), 16, 302},
	/* 2353 */
	{22114, S_008F20_DEPTH(~0u)},
	{68608, S_008F20_PITCH_GFX9(~0u)},
	{68715, S_008F20_BC_SWIZZLE(~0u), 6, 1506},
	/* 2356 */
	{42626, S_008F24_BASE_ARRAY(~0u)},
	{68726, S_008F24_ARRAY_PITCH(~0u)},
	{68738, S_008F24_META_DATA_ADDRESS(~0u)},
	{68756, S_008F24_META_LINEAR(~0u)},
	{68768, S_008F24_META_PIPE_ALIGNED(~0u)},
	{68786, S_008F24_META_RB_ALIGNED(~0u)},
	{68802, S_008F24_MAX_MIP(~0u)},
	/* 2363 */
	{43397, S_008F38_LOD_BIAS(~0u)},
	{43406, S_008F38_LOD_BIAS_SEC(~0u)},
	{43468, S_008F38_XY_MAG_FILTER(~0u), 2, 334},
	{43543, S_008F38_XY_MIN_FILTER(~0u), 4, 336},
	{43623, S_008F38_Z_FILTER(~0u), 3, 340},
	{43632, S_008F38_MIP_FILTER(~0u), 3, 340},
	{43643, S_008F38_MIP_POINT_PRECLAMP(~0u)},
	{68810, S_008F38_BLEND_ZERO_PRT(~0u)},
	{43679, S_008F38_FILTER_PREC_FIX(~0u)},
	{43695, S_008F38_ANISO_OVERRIDE(~0u)},
	/* 2373 */
	{43710, S_008F3C_BORDER_COLOR_PTR(~0u)},
	{68825, S_008F3C_SKIP_DEGAMMA(~0u)},
	{43869, S_008F3C_BORDER_COLOR_TYPE(~0u), 4, 343},
	/* 2376 */
	{44220, S_031100_GPR_WRITE_PRIORITY(~0u)},
	{44239, S_031100_EXP_PRIORITY_ORDER(~0u)},
	{44258, S_031100_ENABLE_SQG_TOP_EVENTS(~0u)},
	{44280, S_031100_ENABLE_SQG_BOP_EVENTS(~0u)},
	{44302, S_031100_RSRC_MGMT_RESET(~0u)},
	{68838, S_031100_TTRACE_STALL_ALL(~0u)},
	{68855, S_031100_ALLOC_ARB_LRU_ENA(~0u)},
	{68873, S_031100_EXP_ARB_LRU_ENA(~0u)},
	{68889, S_031100_PS_PKR_PRIORITY_CNTL(~0u)},
	/* 2385 */
	{44571, S_031104_VTX_DONE_DELAY(~0u), 16, 348},
	{44586, S_031104_INTERP_ONE_PRIM_PER_ROW(~0u)},
	{68910, S_031104_BATON_RESET_DISABLE(~0u)},
	{44610, S_031104_PC_LIMIT_ENABLE(~0u)},
	{44626, S_031104_PC_LIMIT_STRICT(~0u)},
	{68930, S_031104_CRC_SIMD_ID_WADDR_DISABLE(~0u)},
	{68956, S_031104_LBPW_CU_CHK_MODE(~0u)},
	{68973, S_031104_LBPW_CU_CHK_CNT(~0u)},
	{68989, S_031104_CSC_PWR_SAVE_DISABLE(~0u)},
	{69010, S_031104_CSG_PWR_SAVE_DISABLE(~0u)},
	{44642, S_031104_PC_LIMIT_SIZE(~0u)},
	/* 2396 */
	{69031, S_031108_CONTEXT_SAVE_WAIT_GDS_REQUEST_CYCLE_OVHD(~0u)},
	{69072, S_031108_CONTEXT_SAVE_WAIT_GDS_GRANT_CYCLE_OVHD(~0u)},
	/* 2398 */
	{44818, S_0098F8_NUM_PIPES(~0u)},
	{69111, S_0098F8_PIPE_INTERLEAVE_SIZE_GFX9(~0u)},
	{69137, S_0098F8_MAX_COMPRESSED_FRAGS(~0u)},
	{44854, S_0098F8_BANK_INTERLEAVE_SIZE(~0u)},
	{46305, S_0098F8_NUM_BANKS(~0u)},
	{44899, S_0098F8_SHADER_ENGINE_TILE_SIZE(~0u)},
	{69158, S_0098F8_NUM_SHADER_ENGINES_GFX9(~0u)},
	{69182, S_0098F8_NUM_GPUS_GFX9(~0u)},
	{44937, S_0098F8_MULTI_GPU_TILE_SIZE(~0u)},
	{69196, S_0098F8_NUM_RB_PER_SE(~0u)},
	{44957, S_0098F8_ROW_SIZE(~0u)},
	{44966, S_0098F8_NUM_LOWER_PIPES(~0u)},
	{69210, S_0098F8_SE_ENABLE(~0u)},
	/* 2411 */
	{45344, S_009910_ARRAY_MODE(~0u), 16, 368},
	{45706, S_009910_PIPE_CONFIG(~0u), 15, 384},
	{45896, S_009910_TILE_SPLIT(~0u), 7, 399},
	{46346, S_009910_MICRO_TILE_MODE_NEW(~0u), 4, 422},
	{46366, S_009910_SAMPLE_SPLIT(~0u)},
	/* 2416 */
	{43975, S_00B01C_CU_EN(~0u)},
	{46388, S_00B01C_WAVE_LIMIT(~0u)},
	{46399, S_00B01C_LOCK_LOW_THRESHOLD(~0u)},
	{69220, S_00B01C_SIMD_DISABLE(~0u)},
	/* 2420 */
	{46418, S_00B028_VGPRS(~0u)},
	{46424, S_00B028_SGPRS(~0u)},
	{2676, S_00B028_PRIORITY(~0u)},
	{46473, S_00B028_FLOAT_MODE(~0u), 241, 426},
	{46484, S_00B028_PRIV(~0u)},
	{46489, S_00B028_DX10_CLAMP(~0u)},
	{46500, S_00B028_DEBUG_MODE(~0u)},
	{46511, S_00B028_IEEE_MODE(~0u)},
	{46521, S_00B028_CU_GROUP_DISABLE(~0u)},
	{46548, S_00B028_CDBG_USER(~0u)},
	{69233, S_00B028_FP16_OVFL(~0u)},
	/* 2431 */
	{46558, S_00B02C_SCRATCH_EN(~0u)},
	{46569, S_00B02C_USER_SGPR(~0u)},
	{46579, S_00B02C_TRAP_PRESENT(~0u)},
	{46592, S_00B02C_WAVE_CNT_EN(~0u)},
	{46604, S_00B02C_EXTRA_LDS_SIZE(~0u)},
	{46630, S_00B02C_EXCP_EN(~0u)},
	{69243, S_00B02C_LOAD_COLLISION_WAVEID(~0u)},
	{69265, S_00B02C_LOAD_INTRAWAVE_COLLISION(~0u)},
	{69290, S_00B02C_SKIP_USGPR0(~0u)},
	{69302, S_00B02C_USER_SGPR_MSB(~0u)},
	/* 2441 */
	{43975, S_00B118_CU_EN(~0u)},
	{46388, S_00B118_WAVE_LIMIT(~0u)},
	{46399, S_00B118_LOCK_LOW_THRESHOLD(~0u)},
	{69220, S_00B118_SIMD_DISABLE(~0u)},
	/* 2445 */
	{46418, S_00B128_VGPRS(~0u)},
	{46424, S_00B128_SGPRS(~0u)},
	{2676, S_00B128_PRIORITY(~0u)},
	{46473, S_00B128_FLOAT_MODE(~0u)},
	{46484, S_00B128_PRIV(~0u)},
	{46489, S_00B128_DX10_CLAMP(~0u)},
	{46500, S_00B128_DEBUG_MODE(~0u)},
	{46511, S_00B128_IEEE_MODE(~0u)},
	{46638, S_00B128_VGPR_COMP_CNT(~0u)},
	{46652, S_00B128_CU_GROUP_ENABLE(~0u)},
	{46548, S_00B128_CDBG_USER(~0u)},
	{69233, S_00B128_FP16_OVFL(~0u)},
	/* 2457 */
	{46558, S_00B12C_SCRATCH_EN(~0u)},
	{46569, S_00B12C_USER_SGPR(~0u)},
	{46579, S_00B12C_TRAP_PRESENT(~0u)},
	{46668, S_00B12C_OC_LDS_EN(~0u)},
	{46678, S_00B12C_SO_BASE0_EN(~0u)},
	{46690, S_00B12C_SO_BASE1_EN(~0u)},
	{46702, S_00B12C_SO_BASE2_EN(~0u)},
	{46714, S_00B12C_SO_BASE3_EN(~0u)},
	{46726, S_00B12C_SO_EN(~0u)},
	{46630, S_00B12C_EXCP_EN(~0u)},
	{69316, S_00B12C_PC_BASE_EN(~0u)},
	{46732, S_00B12C_DISPATCH_DRAW_EN(~0u)},
	{69290, S_00B12C_SKIP_USGPR0(~0u)},
	{69302, S_00B12C_USER_SGPR_MSB(~0u)},
	/* 2471 */
	{46558, S_00B1F0_SCRATCH_EN(~0u)},
	{46569, S_00B1F0_USER_SGPR(~0u)},
	{46579, S_00B1F0_TRAP_PRESENT(~0u)},
	{46630, S_00B1F0_EXCP_EN(~0u)},
	{46638, S_00B1F0_VGPR_COMP_CNT(~0u)},
	{46668, S_00B1F0_OC_LDS_EN(~0u)},
	{46610, S_00B1F0_LDS_SIZE(~0u)},
	{69290, S_00B1F0_SKIP_USGPR0(~0u)},
	{69302, S_00B1F0_USER_SGPR_MSB(~0u)},
	/* 2480 */
	{46749, S_00B204_GROUP_FIFO_DEPTH(~0u)},
	{69327, S_00B204_SPI_SHADER_LATE_ALLOC_GS(~0u)},
	/* 2482 */
	{46379, S_00B214_MEM_BASE(~0u)},
	/* 2483 */
	{43975, S_00B21C_CU_EN(~0u)},
	{46388, S_00B21C_WAVE_LIMIT(~0u)},
	{46399, S_00B21C_LOCK_LOW_THRESHOLD(~0u)},
	{69220, S_00B21C_SIMD_DISABLE(~0u)},
	/* 2487 */
	{46418, S_00B228_VGPRS(~0u)},
	{46424, S_00B228_SGPRS(~0u)},
	{2676, S_00B228_PRIORITY(~0u)},
	{46473, S_00B228_FLOAT_MODE(~0u)},
	{46484, S_00B228_PRIV(~0u)},
	{46489, S_00B228_DX10_CLAMP(~0u)},
	{46500, S_00B228_DEBUG_MODE(~0u)},
	{46511, S_00B228_IEEE_MODE(~0u)},
	{46652, S_00B228_CU_GROUP_ENABLE(~0u)},
	{46548, S_00B228_CDBG_USER(~0u)},
	{69352, S_00B228_GS_VGPR_COMP_CNT(~0u)},
	{69233, S_00B228_FP16_OVFL(~0u)},
	/* 2499 */
	{46558, S_00B22C_SCRATCH_EN(~0u)},
	{46569, S_00B22C_USER_SGPR(~0u)},
	{46579, S_00B22C_TRAP_PRESENT(~0u)},
	{46630, S_00B22C_EXCP_EN(~0u)},
	{69369, S_00B22C_ES_VGPR_COMP_CNT(~0u)},
	{46668, S_00B22C_OC_LDS_EN(~0u)},
	{46610, S_00B22C_LDS_SIZE(~0u)},
	{69290, S_00B22C_SKIP_USGPR0(~0u)},
	{69302, S_00B22C_USER_SGPR_MSB(~0u)},
	/* 2508 */
	{46749, S_00B404_GROUP_FIFO_DEPTH(~0u)},
	/* 2509 */
	{46379, S_00B414_MEM_BASE(~0u)},
	/* 2510 */
	{46388, S_00B41C_WAVE_LIMIT(~0u)},
	{46399, S_00B41C_LOCK_LOW_THRESHOLD(~0u)},
	{69220, S_00B41C_SIMD_DISABLE(~0u)},
	{43975, S_00B41C_CU_EN(~0u)},
	/* 2514 */
	{46418, S_00B428_VGPRS(~0u)},
	{46424, S_00B428_SGPRS(~0u)},
	{2676, S_00B428_PRIORITY(~0u)},
	{46473, S_00B428_FLOAT_MODE(~0u)},
	{46484, S_00B428_PRIV(~0u)},
	{46489, S_00B428_DX10_CLAMP(~0u)},
	{46500, S_00B428_DEBUG_MODE(~0u)},
	{46511, S_00B428_IEEE_MODE(~0u)},
	{46548, S_00B428_CDBG_USER(~0u)},
	{69386, S_00B428_LS_VGPR_COMP_CNT(~0u)},
	{69233, S_00B428_FP16_OVFL(~0u)},
	/* 2525 */
	{46558, S_00B42C_SCRATCH_EN(~0u)},
	{46569, S_00B42C_USER_SGPR(~0u)},
	{46579, S_00B42C_TRAP_PRESENT(~0u)},
	{46630, S_00B42C_EXCP_EN(~0u)},
	{46610, S_00B42C_LDS_SIZE(~0u)},
	{69290, S_00B42C_SKIP_USGPR0(~0u)},
	{69302, S_00B42C_USER_SGPR_MSB(~0u)},
	/* 2532 */
	{46792, S_00B800_COMPUTE_SHADER_EN(~0u)},
	{46810, S_00B800_PARTIAL_TG_EN(~0u)},
	{46824, S_00B800_FORCE_START_AT_000(~0u)},
	{46843, S_00B800_ORDERED_APPEND_ENBL(~0u)},
	{46863, S_00B800_ORDERED_APPEND_MODE(~0u)},
	{46883, S_00B800_USE_THREAD_DIMENSIONS(~0u)},
	{46905, S_00B800_ORDER_MODE(~0u)},
	{46936, S_00B800_SCALAR_L1_INV_VOL(~0u)},
	{46954, S_00B800_VECTOR_L1_INV_VOL(~0u)},
	{8050, S_00B800_RESERVED(~0u)},
	{46981, S_00B800_RESTORE(~0u)},
	/* 2543 */
	{46418, S_00B848_VGPRS(~0u)},
	{46424, S_00B848_SGPRS(~0u)},
	{2676, S_00B848_PRIORITY(~0u)},
	{46473, S_00B848_FLOAT_MODE(~0u)},
	{46484, S_00B848_PRIV(~0u)},
	{46489, S_00B848_DX10_CLAMP(~0u)},
	{46500, S_00B848_DEBUG_MODE(~0u)},
	{46511, S_00B848_IEEE_MODE(~0u)},
	{47033, S_00B848_BULKY(~0u)},
	{46548, S_00B848_CDBG_USER(~0u)},
	{69233, S_00B848_FP16_OVFL(~0u)},
	/* 2554 */
	{46558, S_00B84C_SCRATCH_EN(~0u)},
	{46569, S_00B84C_USER_SGPR(~0u)},
	{46579, S_00B84C_TRAP_PRESENT(~0u)},
	{47039, S_00B84C_TGID_X_EN(~0u)},
	{47049, S_00B84C_TGID_Y_EN(~0u)},
	{47059, S_00B84C_TGID_Z_EN(~0u)},
	{46766, S_00B84C_TG_SIZE_EN(~0u)},
	{47069, S_00B84C_TIDIG_COMP_CNT(~0u)},
	{47084, S_00B84C_EXCP_EN_MSB(~0u)},
	{46610, S_00B84C_LDS_SIZE(~0u)},
	{46630, S_00B84C_EXCP_EN(~0u)},
	{69290, S_00B84C_SKIP_USGPR0(~0u)},
	/* 2566 */
	{47112, S_00B854_WAVES_PER_SH(~0u)},
	{47125, S_00B854_TG_PER_CU(~0u)},
	{47135, S_00B854_LOCK_THRESHOLD(~0u)},
	{47150, S_00B854_SIMD_DEST_CNTL(~0u)},
	{47165, S_00B854_FORCE_SIMD_DIST(~0u)},
	{47181, S_00B854_CU_GROUP_COUNT(~0u)},
	{69220, S_00B854_SIMD_DISABLE(~0u)},
	/* 2573 */
	{69403, S_036008_CNTR_SEL0(~0u)},
	{69413, S_036008_CNTR_SEL1(~0u)},
	{48114, S_036008_SPM_MODE(~0u)},
	{69423, S_036008_CNTR_MODE1(~0u)},
	{69434, S_036008_CNTR_MODE0(~0u)},
	/* 2578 */
	{69445, S_036004_CNTR_SEL2(~0u)},
	{69455, S_036004_CNTR_SEL3(~0u)},
	{69465, S_036004_CNTR_MODE3(~0u)},
	{69476, S_036004_CNTR_MODE2(~0u)},
	/* 2582 */
	{69403, S_036024_CNTR_SEL0(~0u)},
	{69413, S_036024_CNTR_SEL1(~0u)},
	{48114, S_036024_SPM_MODE(~0u)},
	{69423, S_036024_CNTR_MODE1(~0u)},
	{69434, S_036024_CNTR_MODE0(~0u)},
	/* 2587 */
	{69445, S_036010_CNTR_SEL2(~0u)},
	{69455, S_036010_CNTR_SEL3(~0u)},
	{69465, S_036010_CNTR_MODE3(~0u)},
	{69476, S_036010_CNTR_MODE2(~0u)},
	/* 2591 */
	{69403, S_03601C_CNTR_SEL0(~0u)},
	{69413, S_03601C_CNTR_SEL1(~0u)},
	{48114, S_03601C_SPM_MODE(~0u)},
	{69423, S_03601C_CNTR_MODE1(~0u)},
	{69434, S_03601C_CNTR_MODE0(~0u)},
	/* 2596 */
	{69445, S_036018_CNTR_SEL2(~0u)},
	{69455, S_036018_CNTR_SEL3(~0u)},
	{69465, S_036018_CNTR_MODE3(~0u)},
	{69476, S_036018_CNTR_MODE2(~0u)},
	/* 2600 */
	{441, S_036028_INDEX(~0u)},
	{43218, S_036028_ALWAYS(~0u)},
	{7643, S_036028_ENABLE(~0u)},
	/* 2603 */
	{441, S_03602C_INDEX(~0u)},
	{43218, S_03602C_ALWAYS(~0u)},
	{7643, S_03602C_ENABLE(~0u)},
	/* 2606 */
	{441, S_036030_INDEX(~0u)},
	{15389, S_036030_CLEAR(~0u)},
	{7643, S_036030_ENABLE(~0u)},
	/* 2609 */
	{441, S_036034_INDEX(~0u)},
	{15389, S_036034_CLEAR(~0u)},
	{7643, S_036034_ENABLE(~0u)},
	/* 2612 */
	{441, S_036038_INDEX(~0u)},
	{15389, S_036038_CLEAR(~0u)},
	{7643, S_036038_ENABLE(~0u)},
	/* 2615 */
	{47300, S_036100_PERF_SEL(~0u)},
	{47470, S_036100_DB_CLEAN_USER_DEFINED_MASK(~0u)},
	{47497, S_036100_CB_CLEAN_USER_DEFINED_MASK(~0u)},
	{47524, S_036100_VGT_BUSY_USER_DEFINED_MASK(~0u)},
	{47551, S_036100_TA_BUSY_USER_DEFINED_MASK(~0u)},
	{47577, S_036100_SX_BUSY_USER_DEFINED_MASK(~0u)},
	{47603, S_036100_SPI_BUSY_USER_DEFINED_MASK(~0u)},
	{47630, S_036100_SC_BUSY_USER_DEFINED_MASK(~0u)},
	{47656, S_036100_PA_BUSY_USER_DEFINED_MASK(~0u)},
	{47682, S_036100_GRBM_BUSY_USER_DEFINED_MASK(~0u)},
	{47710, S_036100_DB_BUSY_USER_DEFINED_MASK(~0u)},
	{47736, S_036100_CB_BUSY_USER_DEFINED_MASK(~0u)},
	{47762, S_036100_CP_BUSY_USER_DEFINED_MASK(~0u)},
	{47788, S_036100_IA_BUSY_USER_DEFINED_MASK(~0u)},
	{47814, S_036100_GDS_BUSY_USER_DEFINED_MASK(~0u)},
	{47841, S_036100_BCI_BUSY_USER_DEFINED_MASK(~0u)},
	{47868, S_036100_RLC_BUSY_USER_DEFINED_MASK(~0u)},
	{47895, S_036100_TC_BUSY_USER_DEFINED_MASK(~0u)},
	{47921, S_036100_WD_BUSY_USER_DEFINED_MASK(~0u)},
	{69487, S_036100_UTCL2_BUSY_USER_DEFINED_MASK(~0u)},
	{69516, S_036100_EA_BUSY_USER_DEFINED_MASK(~0u)},
	{69542, S_036100_RMI_BUSY_USER_DEFINED_MASK(~0u)},
	/* 2637 */
	{47300, S_036108_PERF_SEL(~0u)},
	{47470, S_036108_DB_CLEAN_USER_DEFINED_MASK(~0u)},
	{47497, S_036108_CB_CLEAN_USER_DEFINED_MASK(~0u)},
	{47551, S_036108_TA_BUSY_USER_DEFINED_MASK(~0u)},
	{47577, S_036108_SX_BUSY_USER_DEFINED_MASK(~0u)},
	{47603, S_036108_SPI_BUSY_USER_DEFINED_MASK(~0u)},
	{47630, S_036108_SC_BUSY_USER_DEFINED_MASK(~0u)},
	{47710, S_036108_DB_BUSY_USER_DEFINED_MASK(~0u)},
	{47736, S_036108_CB_BUSY_USER_DEFINED_MASK(~0u)},
	{47524, S_036108_VGT_BUSY_USER_DEFINED_MASK(~0u)},
	{47656, S_036108_PA_BUSY_USER_DEFINED_MASK(~0u)},
	{47841, S_036108_BCI_BUSY_USER_DEFINED_MASK(~0u)},
	{69542, S_036108_RMI_BUSY_USER_DEFINED_MASK(~0u)},
	/* 2650 */
	{47300, S_03610C_PERF_SEL(~0u)},
	{47470, S_03610C_DB_CLEAN_USER_DEFINED_MASK(~0u)},
	{47497, S_03610C_CB_CLEAN_USER_DEFINED_MASK(~0u)},
	{47551, S_03610C_TA_BUSY_USER_DEFINED_MASK(~0u)},
	{47577, S_03610C_SX_BUSY_USER_DEFINED_MASK(~0u)},
	{47603, S_03610C_SPI_BUSY_USER_DEFINED_MASK(~0u)},
	{47630, S_03610C_SC_BUSY_USER_DEFINED_MASK(~0u)},
	{47710, S_03610C_DB_BUSY_USER_DEFINED_MASK(~0u)},
	{47736, S_03610C_CB_BUSY_USER_DEFINED_MASK(~0u)},
	{47524, S_03610C_VGT_BUSY_USER_DEFINED_MASK(~0u)},
	{47656, S_03610C_PA_BUSY_USER_DEFINED_MASK(~0u)},
	{47841, S_03610C_BCI_BUSY_USER_DEFINED_MASK(~0u)},
	{69542, S_03610C_RMI_BUSY_USER_DEFINED_MASK(~0u)},
	/* 2663 */
	{47300, S_036110_PERF_SEL(~0u)},
	{47470, S_036110_DB_CLEAN_USER_DEFINED_MASK(~0u)},
	{47497, S_036110_CB_CLEAN_USER_DEFINED_MASK(~0u)},
	{47551, S_036110_TA_BUSY_USER_DEFINED_MASK(~0u)},
	{47577, S_036110_SX_BUSY_USER_DEFINED_MASK(~0u)},
	{47603, S_036110_SPI_BUSY_USER_DEFINED_MASK(~0u)},
	{47630, S_036110_SC_BUSY_USER_DEFINED_MASK(~0u)},
	{47710, S_036110_DB_BUSY_USER_DEFINED_MASK(~0u)},
	{47736, S_036110_CB_BUSY_USER_DEFINED_MASK(~0u)},
	{47524, S_036110_VGT_BUSY_USER_DEFINED_MASK(~0u)},
	{47656, S_036110_PA_BUSY_USER_DEFINED_MASK(~0u)},
	{47841, S_036110_BCI_BUSY_USER_DEFINED_MASK(~0u)},
	{69542, S_036110_RMI_BUSY_USER_DEFINED_MASK(~0u)},
	/* 2676 */
	{47300, S_036114_PERF_SEL(~0u)},
	{47470, S_036114_DB_CLEAN_USER_DEFINED_MASK(~0u)},
	{47497, S_036114_CB_CLEAN_USER_DEFINED_MASK(~0u)},
	{47551, S_036114_TA_BUSY_USER_DEFINED_MASK(~0u)},
	{47577, S_036114_SX_BUSY_USER_DEFINED_MASK(~0u)},
	{47603, S_036114_SPI_BUSY_USER_DEFINED_MASK(~0u)},
	{47630, S_036114_SC_BUSY_USER_DEFINED_MASK(~0u)},
	{47710, S_036114_DB_BUSY_USER_DEFINED_MASK(~0u)},
	{47736, S_036114_CB_BUSY_USER_DEFINED_MASK(~0u)},
	{47524, S_036114_VGT_BUSY_USER_DEFINED_MASK(~0u)},
	{47656, S_036114_PA_BUSY_USER_DEFINED_MASK(~0u)},
	{47841, S_036114_BCI_BUSY_USER_DEFINED_MASK(~0u)},
	{69542, S_036114_RMI_BUSY_USER_DEFINED_MASK(~0u)},
	/* 2689 */
	{47300, S_036600_PERF_SEL(~0u)},
	{47309, S_036600_PERF_SEL1(~0u)},
	{47319, S_036600_CNTR_MODE(~0u)},
	{47957, S_036600_PERF_MODE1(~0u)},
	{47947, S_036600_PERF_MODE(~0u)},
	/* 2694 */
	{47329, S_036610_PERF_SEL2(~0u)},
	{47339, S_036610_PERF_SEL3(~0u)},
	{47968, S_036610_PERF_MODE3(~0u)},
	{47979, S_036610_PERF_MODE2(~0u)},
	/* 2698 */
	{48842, S_028008_SLICE_START(~0u)},
	{48854, S_028008_SLICE_MAX(~0u)},
	{48864, S_028008_Z_READ_ONLY(~0u)},
	{48876, S_028008_STENCIL_READ_ONLY(~0u)},
	{69569, S_028008_MIPID(~0u)},
	/* 2703 */
	{49493, S_028010_PARTIAL_SQUAD_LAUNCH_CONTROL(~0u), 4, 678},
	{49522, S_028010_PARTIAL_SQUAD_LAUNCH_COUNTDOWN(~0u)},
	{49553, S_028010_DISABLE_ZMASK_EXPCLEAR_OPTIMIZATION(~0u)},
	{49589, S_028010_DISABLE_SMEM_EXPCLEAR_OPTIMIZATION(~0u)},
	{49624, S_028010_DISABLE_COLOR_ON_VALIDATION(~0u)},
	{49652, S_028010_DECOMPRESS_Z_ON_FLUSH(~0u)},
	{49674, S_028010_DISABLE_REG_SNOOP(~0u)},
	{49692, S_028010_DEPTH_BOUNDS_HIER_DEPTH_DISABLE(~0u)},
	{49724, S_028010_SEPARATE_HIZS_FUNC_ENABLE(~0u)},
	{49750, S_028010_HIZ_ZFUNC(~0u)},
	{49760, S_028010_HIS_SFUNC_FF(~0u)},
	{49773, S_028010_HIS_SFUNC_BF(~0u)},
	{49786, S_028010_PRESERVE_ZRANGE(~0u)},
	{49802, S_028010_PRESERVE_SRESULTS(~0u)},
	{49820, S_028010_DISABLE_FAST_PASS(~0u)},
	{69575, S_028010_ALLOW_PARTIAL_RES_HIER_KILL(~0u)},
	/* 2719 */
	{880, S_028018_BASE_HI(~0u)},
	/* 2720 */
	{69603, S_02801C_X_MAX(~0u)},
	{69609, S_02801C_Y_MAX(~0u)},
	/* 2722 */
	{21132, S_028038_FORMAT(~0u), 4, 707},
	{50010, S_028038_NUM_SAMPLES(~0u)},
	{68600, S_028038_SW_MODE(~0u)},
	{69615, S_028038_PARTIALLY_RESIDENT(~0u)},
	{69634, S_028038_FAULT_BEHAVIOR(~0u)},
	{69649, S_028038_ITERATE_FLUSH(~0u)},
	{69663, S_028038_MAXMIP(~0u)},
	{50038, S_028038_DECOMPRESS_ON_N_ZPLANES(~0u)},
	{50062, S_028038_ALLOW_EXPCLEAR(~0u)},
	{50077, S_028038_READ_SIZE(~0u)},
	{50087, S_028038_TILE_SURFACE_ENABLE(~0u)},
	{50107, S_028038_CLEAR_DISALLOWED(~0u)},
	{50124, S_028038_ZRANGE_PRECISION(~0u)},
	/* 2735 */
	{21132, S_02803C_FORMAT(~0u), 2, 711},
	{68600, S_02803C_SW_MODE(~0u)},
	{69615, S_02803C_PARTIALLY_RESIDENT(~0u)},
	{69634, S_02803C_FAULT_BEHAVIOR(~0u)},
	{69649, S_02803C_ITERATE_FLUSH(~0u)},
	{50062, S_02803C_ALLOW_EXPCLEAR(~0u)},
	{50167, S_02803C_TILE_STENCIL_DISABLE(~0u)},
	{50107, S_02803C_CLEAR_DISALLOWED(~0u)},
	/* 2743 */
	{880, S_028044_BASE_HI(~0u)},
	/* 2744 */
	{880, S_02804C_BASE_HI(~0u)},
	/* 2745 */
	{880, S_028054_BASE_HI(~0u)},
	/* 2746 */
	{880, S_02805C_BASE_HI(~0u)},
	/* 2747 */
	{69679, S_028060_PUNCHOUT_MODE(~0u), 4, 1512},
	{69693, S_028060_POPS_DRAIN_PS_ON_OVERLAP(~0u)},
	{69718, S_028060_DISALLOW_OVERFLOW(~0u)},
	/* 2750 */
	{69736, S_028064_PS_INVOKE_MASK(~0u)},
	/* 2751 */
	{30484, S_028068_EPITCH(~0u)},
	/* 2752 */
	{30484, S_02806C_EPITCH(~0u)},
	/* 2753 */
	{69751, S_0281E8_DEST_BASE_HI_256B(~0u)},
	/* 2754 */
	{69751, S_0281EC_DEST_BASE_HI_256B(~0u)},
	/* 2755 */
	{69751, S_0281F0_DEST_BASE_HI_256B(~0u)},
	/* 2756 */
	{69751, S_0281F4_DEST_BASE_HI_256B(~0u)},
	/* 2757 */
	{50727, S_028350_RB_MAP_PKR0(~0u), 4, 713},
	{50739, S_028350_RB_MAP_PKR1(~0u), 4, 713},
	{50851, S_028350_RB_XSEL2(~0u), 4, 717},
	{50860, S_028350_RB_XSEL(~0u)},
	{50868, S_028350_RB_YSEL(~0u)},
	{50972, S_028350_PKR_MAP(~0u), 4, 721},
	{51080, S_028350_PKR_XSEL(~0u), 4, 725},
	{51189, S_028350_PKR_YSEL(~0u), 4, 729},
	{51302, S_028350_PKR_XSEL2(~0u), 4, 733},
	{51404, S_028350_SC_MAP(~0u), 4, 737},
	{51550, S_028350_SC_XSEL(~0u), 4, 741},
	{51697, S_028350_SC_YSEL(~0u), 4, 745},
	{51797, S_028350_SE_MAP(~0u), 4, 749},
	{69769, S_028350_SE_XSEL_GFX9(~0u)},
	{69782, S_028350_SE_YSEL_GFX9(~0u)},
	/* 2772 */
	{52220, S_028354_SE_PAIR_MAP(~0u), 4, 761},
	{69795, S_028354_SE_PAIR_XSEL_GFX9(~0u)},
	{69813, S_028354_SE_PAIR_YSEL_GFX9(~0u)},
	/* 2775 */
	{7643, S_02835C_ENABLE(~0u)},
	{69831, S_02835C_NUM_SE(~0u)},
	{69196, S_02835C_NUM_RB_PER_SE(~0u)},
	{69838, S_02835C_DISABLE_SRBSL_DB_OPTIMIZED_PACKING(~0u)},
	/* 2779 */
	{69873, S_028360_PERFMON_ENABLE(~0u)},
	/* 2780 */
	{69888, S_0283A0_LEFT_QTR(~0u)},
	{69897, S_0283A0_LEFT_HALF(~0u)},
	{69907, S_0283A0_RIGHT_HALF(~0u)},
	{69918, S_0283A0_RIGHT_QTR(~0u)},
	/* 2784 */
	{69888, S_0283A4_LEFT_QTR(~0u)},
	{69897, S_0283A4_LEFT_HALF(~0u)},
	{69907, S_0283A4_RIGHT_HALF(~0u)},
	{69918, S_0283A4_RIGHT_QTR(~0u)},
	/* 2788 */
	{69928, S_0283A8_TOP_QTR(~0u)},
	{69936, S_0283A8_TOP_HALF(~0u)},
	{69945, S_0283A8_BOT_HALF(~0u)},
	{69954, S_0283A8_BOT_QTR(~0u)},
	/* 2792 */
	{69962, S_0283AC_LEFT_EYE_FOV_LEFT(~0u)},
	{69980, S_0283AC_LEFT_EYE_FOV_RIGHT(~0u)},
	{69999, S_0283AC_RIGHT_EYE_FOV_LEFT(~0u)},
	{70018, S_0283AC_RIGHT_EYE_FOV_RIGHT(~0u)},
	/* 2796 */
	{70038, S_0283B0_FOV_TOP(~0u)},
	{70046, S_0283B0_FOV_BOT(~0u)},
	/* 2798 */
	{53855, S_0286D8_NUM_INTERP(~0u)},
	{53866, S_0286D8_PARAM_GEN(~0u)},
	{70054, S_0286D8_OFFCHIP_PARAM_EN(~0u)},
	{70071, S_0286D8_LATE_PC_DEALLOC(~0u)},
	{53885, S_0286D8_BC_OPTIMIZE_DISABLE(~0u)},
	/* 2803 */
	{30484, S_0287A0_EPITCH(~0u)},
	/* 2804 */
	{30484, S_0287A4_EPITCH(~0u)},
	/* 2805 */
	{30484, S_0287A8_EPITCH(~0u)},
	/* 2806 */
	{30484, S_0287AC_EPITCH(~0u)},
	/* 2807 */
	{30484, S_0287B0_EPITCH(~0u)},
	/* 2808 */
	{30484, S_0287B4_EPITCH(~0u)},
	/* 2809 */
	{30484, S_0287B8_EPITCH(~0u)},
	/* 2810 */
	{30484, S_0287BC_EPITCH(~0u)},
	/* 2811 */
	{70087, S_0287E4_BASE_ADDR_GFX9(~0u)},
	/* 2812 */
	{56739, S_0287F0_SOURCE_SELECT(~0u), 4, 880},
	{56785, S_0287F0_MAJOR_MODE(~0u), 2, 884},
	{70102, S_0287F0_SPRITE_EN_R6XX(~0u)},
	{56796, S_0287F0_NOT_EOP(~0u)},
	{56804, S_0287F0_USE_OPAQUE(~0u)},
	{70117, S_0287F0_UNROLLED_INST(~0u)},
	{70131, S_0287F0_GRBM_SKEW_NO_DEC(~0u)},
	{70148, S_0287F0_REG_RT_INDEX(~0u)},
	/* 2820 */
	{57775, S_02880C_Z_EXPORT_ENABLE(~0u)},
	{57791, S_02880C_STENCIL_TEST_VAL_EXPORT_ENABLE(~0u)},
	{57822, S_02880C_STENCIL_OP_VAL_EXPORT_ENABLE(~0u)},
	{49012, S_02880C_Z_ORDER(~0u), 4, 1165},
	{57901, S_02880C_KILL_ENABLE(~0u)},
	{57913, S_02880C_COVERAGE_TO_MASK_ENABLE(~0u)},
	{57937, S_02880C_MASK_EXPORT_ENABLE(~0u)},
	{57956, S_02880C_EXEC_ON_HIER_FAIL(~0u)},
	{57974, S_02880C_EXEC_ON_NOOP(~0u)},
	{57987, S_02880C_ALPHA_TO_MASK_DISABLE(~0u)},
	{58009, S_02880C_DEPTH_BEFORE_SHADER(~0u)},
	{58099, S_02880C_CONSERVATIVE_Z_EXPORT(~0u), 4, 1169},
	{58121, S_02880C_DUAL_QUAD_DISABLE(~0u)},
	{70161, S_02880C_PRIMITIVE_ORDERED_PIXEL_SHADER(~0u)},
	{70192, S_02880C_EXEC_IF_OVERLAPPED(~0u)},
	{70211, S_02880C_POPS_OVERLAP_NUM_SAMPLES(~0u)},
	/* 2836 */
	{58443, S_028814_CULL_FRONT(~0u)},
	{58454, S_028814_CULL_BACK(~0u)},
	{22820, S_028814_FACE(~0u)},
	{58474, S_028814_POLY_MODE(~0u), 2, 1173},
	{58540, S_028814_POLYMODE_FRONT_PTYPE(~0u), 3, 1175},
	{58561, S_028814_POLYMODE_BACK_PTYPE(~0u), 3, 1175},
	{58581, S_028814_POLY_OFFSET_FRONT_ENABLE(~0u)},
	{58606, S_028814_POLY_OFFSET_BACK_ENABLE(~0u)},
	{58630, S_028814_POLY_OFFSET_PARA_ENABLE(~0u)},
	{58654, S_028814_VTX_WINDOW_OFFSET_ENABLE(~0u)},
	{58679, S_028814_PROVOKING_VTX_LAST(~0u)},
	{58698, S_028814_PERSP_CORR_DIS(~0u)},
	{58713, S_028814_MULTI_PRIM_IB_ENA(~0u)},
	{70236, S_028814_RIGHT_TRIANGLE_ALTERNATE_GRADIENT_REF(~0u)},
	{70274, S_028814_NEW_QUAD_DECOMPOSITION(~0u)},
	/* 2851 */
	{58731, S_028818_VPORT_X_SCALE_ENA(~0u)},
	{58749, S_028818_VPORT_X_OFFSET_ENA(~0u)},
	{58768, S_028818_VPORT_Y_SCALE_ENA(~0u)},
	{58786, S_028818_VPORT_Y_OFFSET_ENA(~0u)},
	{58805, S_028818_VPORT_Z_SCALE_ENA(~0u)},
	{58823, S_028818_VPORT_Z_OFFSET_ENA(~0u)},
	{58842, S_028818_VTX_XY_FMT(~0u)},
	{58853, S_028818_VTX_Z_FMT(~0u)},
	{58863, S_028818_VTX_W0_FMT(~0u)},
	{70297, S_028818_PERFCOUNTER_REF(~0u)},
	/* 2861 */
	{58874, S_02881C_CLIP_DIST_ENA_0(~0u)},
	{58890, S_02881C_CLIP_DIST_ENA_1(~0u)},
	{58906, S_02881C_CLIP_DIST_ENA_2(~0u)},
	{58922, S_02881C_CLIP_DIST_ENA_3(~0u)},
	{58938, S_02881C_CLIP_DIST_ENA_4(~0u)},
	{58954, S_02881C_CLIP_DIST_ENA_5(~0u)},
	{58970, S_02881C_CLIP_DIST_ENA_6(~0u)},
	{58986, S_02881C_CLIP_DIST_ENA_7(~0u)},
	{59002, S_02881C_CULL_DIST_ENA_0(~0u)},
	{59018, S_02881C_CULL_DIST_ENA_1(~0u)},
	{59034, S_02881C_CULL_DIST_ENA_2(~0u)},
	{59050, S_02881C_CULL_DIST_ENA_3(~0u)},
	{59066, S_02881C_CULL_DIST_ENA_4(~0u)},
	{59082, S_02881C_CULL_DIST_ENA_5(~0u)},
	{59098, S_02881C_CULL_DIST_ENA_6(~0u)},
	{59114, S_02881C_CULL_DIST_ENA_7(~0u)},
	{59130, S_02881C_USE_VTX_POINT_SIZE(~0u)},
	{59149, S_02881C_USE_VTX_EDGE_FLAG(~0u)},
	{59167, S_02881C_USE_VTX_RENDER_TARGET_INDX(~0u)},
	{59194, S_02881C_USE_VTX_VIEWPORT_INDX(~0u)},
	{59216, S_02881C_USE_VTX_KILL_FLAG(~0u)},
	{59234, S_02881C_VS_OUT_MISC_VEC_ENA(~0u)},
	{59254, S_02881C_VS_OUT_CCDIST0_VEC_ENA(~0u)},
	{59277, S_02881C_VS_OUT_CCDIST1_VEC_ENA(~0u)},
	{59300, S_02881C_VS_OUT_MISC_SIDE_BUS_ENA(~0u)},
	{59325, S_02881C_USE_VTX_GS_CUT_FLAG(~0u)},
	{59345, S_02881C_USE_VTX_LINE_WIDTH(~0u)},
	{70313, S_02881C_USE_VTX_SHD_OBJPRIM_ID(~0u)},
	/* 2889 */
	{59951, S_028830_SMALL_PRIM_FILTER_ENABLE(~0u)},
	{59723, S_028830_TRIANGLE_FILTER_DISABLE(~0u)},
	{59747, S_028830_LINE_FILTER_DISABLE(~0u)},
	{59767, S_028830_POINT_FILTER_DISABLE(~0u)},
	{59788, S_028830_RECTANGLE_FILTER_DISABLE(~0u)},
	{70336, S_028830_SRBSL_ENABLE(~0u)},
	/* 2895 */
	{70349, S_028834_OBJ_ID_SEL(~0u)},
	{70360, S_028834_ADD_PIPED_PRIM_ID(~0u)},
	{70378, S_028834_EN_32BIT_OBJPRIMID(~0u)},
	/* 2898 */
	{70397, S_028838_VERTEX_REUSE_OFF(~0u)},
	{70414, S_028838_INDEX_BUF_EDGE_FLAG_ENA(~0u)},
	/* 2900 */
	{70438, S_02883C_DISCARD_0_AREA_TRIANGLES(~0u)},
	{70463, S_02883C_DISCARD_0_AREA_LINES(~0u)},
	{70484, S_02883C_DISCARD_0_AREA_POINTS(~0u)},
	{70506, S_02883C_DISCARD_0_AREA_RECTANGLES(~0u)},
	{70532, S_02883C_USE_PROVOKING_ZW(~0u)},
	/* 2905 */
	{22279, S_028A40_MODE(~0u), 6, 1215},
	{39383, S_028A40_RESERVED_0(~0u)},
	{60992, S_028A40_CUT_MODE(~0u), 4, 1221},
	{39401, S_028A40_RESERVED_1(~0u)},
	{61001, S_028A40_GS_C_PACK_EN(~0u)},
	{61014, S_028A40_RESERVED_2(~0u)},
	{61025, S_028A40_ES_PASSTHRU(~0u)},
	{70549, S_028A40_RESERVED_3(~0u)},
	{70560, S_028A40_RESERVED_4(~0u)},
	{70571, S_028A40_RESERVED_5(~0u)},
	{61084, S_028A40_PARTIAL_THD_AT_EOI(~0u)},
	{61103, S_028A40_SUPPRESS_CUTS(~0u)},
	{61117, S_028A40_ES_WRITE_OPTIMIZE(~0u)},
	{61135, S_028A40_GS_WRITE_OPTIMIZE(~0u)},
	{61186, S_028A40_ONCHIP(~0u), 4, 1225},
	/* 2920 */
	{61193, S_028A44_ES_VERTS_PER_SUBGRP(~0u)},
	{61213, S_028A44_GS_PRIMS_PER_SUBGRP(~0u)},
	{70582, S_028A44_GS_INST_PRIMS_IN_SUBGRP(~0u)},
	/* 2923 */
	{61233, S_028A48_MSAA_ENABLE(~0u)},
	{61245, S_028A48_VPORT_SCISSOR_ENABLE(~0u)},
	{61266, S_028A48_LINE_STIPPLE_ENABLE(~0u)},
	{61286, S_028A48_SEND_UNLIT_STILES_TO_PKR(~0u)},
	{70606, S_028A48_SCALE_LINE_WIDTH_PAD(~0u)},
	{70627, S_028A48_ALTERNATE_RBS_PER_TILE(~0u)},
	{70650, S_028A48_COARSE_TILE_STARTS_ON_EVEN_RB(~0u)},
	/* 2930 */
	{203, S_028A7C_INDEX_TYPE(~0u), 3, 1232},
	{62070, S_028A7C_SWAP_MODE(~0u), 4, 1235},
	{62131, S_028A7C_BUF_TYPE(~0u), 3, 1239},
	{62190, S_028A7C_RDREQ_POLICY(~0u)},
	{67039, S_028A7C_PRIMGEN_EN(~0u)},
	{56796, S_028A7C_NOT_EOP(~0u)},
	{62203, S_028A7C_REQ_PATH(~0u)},
	/* 2937 */
	{22558, S_028A84_PRIMITIVEID_EN(~0u)},
	{62212, S_028A84_DISABLE_RESET_ON_EOI(~0u)},
	{70680, S_028A84_NGG_DISABLE_PROVOK_REUSE(~0u)},
	/* 2940 */
	{63168, S_028A90_EVENT_TYPE(~0u), 63, 1516},
	{70805, S_028A90_ADDRESS_HI_GFX9(~0u)},
	{63195, S_028A90_EXTENDED_EVENT(~0u)},
	/* 2943 */
	{30670, S_028A94_MAX_PRIMS_PER_SUBGROUP(~0u)},
	/* 2944 */
	{70821, S_028A98_OBJPRIM_ID_EN(~0u)},
	{70835, S_028A98_EN_REG_RT_INDEX(~0u)},
	{70851, S_028A98_EN_PIPELINE_PRIMID(~0u)},
	{70870, S_028A98_OBJECT_ID_INST_EN(~0u)},
	/* 2948 */
	{70888, S_028A9C_COMPOUND_INDEX_EN(~0u)},
	/* 2949 */
	{63328, S_028ABC_FULL_CACHE(~0u)},
	{63339, S_028ABC_HTILE_USES_PRELOAD_WIN(~0u)},
	{63362, S_028ABC_PRELOAD(~0u)},
	{63370, S_028ABC_PREFETCH_WIDTH(~0u)},
	{63385, S_028ABC_PREFETCH_HEIGHT(~0u)},
	{63401, S_028ABC_DST_OUTSIDE_ZERO_TO_ONE(~0u)},
	{68773, S_028ABC_PIPE_ALIGNED(~0u)},
	{68791, S_028ABC_RB_ALIGNED(~0u)},
	/* 2957 */
	{48157, S_028B54_LS_EN(~0u), 3, 1303},
	{48151, S_028B54_HS_EN(~0u)},
	{23383, S_028B54_ES_EN(~0u), 3, 1306},
	{48145, S_028B54_GS_EN(~0u)},
	{48139, S_028B54_VS_EN(~0u), 3, 1309},
	{46732, S_028B54_DISPATCH_DRAW_EN(~0u)},
	{63723, S_028B54_DIS_DEALLOC_ACCUM_0(~0u)},
	{63743, S_028B54_DIS_DEALLOC_ACCUM_1(~0u)},
	{63763, S_028B54_VS_WAVE_ID_EN(~0u)},
	{67039, S_028B54_PRIMGEN_EN(~0u)},
	{70906, S_028B54_ORDERED_ID_MODE(~0u)},
	{63308, S_028B54_MAX_PRIMGRP_IN_WAVE(~0u)},
	{70922, S_028B54_GS_FAST_LAUNCH(~0u)},
	/* 2970 */
	{209, S_028B6C_TYPE(~0u), 3, 1312},
	{63911, S_028B6C_PARTITIONING(~0u), 4, 1315},
	{63988, S_028B6C_TOPOLOGY(~0u), 4, 1319},
	{63997, S_028B6C_RESERVED_REDUC_AXIS(~0u)},
	{64017, S_028B6C_DEPRECATED(~0u)},
	{64050, S_028B6C_DISABLE_DONUTS(~0u)},
	{62190, S_028B6C_RDREQ_POLICY(~0u)},
	{64189, S_028B6C_DISTRIBUTION_MODE(~0u), 4, 1326},
	/* 2978 */
	{64385, S_028B94_STREAMOUT_0_EN(~0u)},
	{64400, S_028B94_STREAMOUT_1_EN(~0u)},
	{64415, S_028B94_STREAMOUT_2_EN(~0u)},
	{64430, S_028B94_STREAMOUT_3_EN(~0u)},
	{64445, S_028B94_RAST_STREAM(~0u)},
	{70937, S_028B94_EN_PRIMS_NEEDED_CNT(~0u)},
	{64457, S_028B94_RAST_STREAM_MASK(~0u)},
	{64474, S_028B94_USE_RAST_STREAM_MASK(~0u)},
	/* 2986 */
	{63168, S_028B9C_EVENT_TYPE(~0u)},
	{39318, S_028B9C_ADDRESS_HI(~0u)},
	{63195, S_028B9C_EXTENDED_EVENT(~0u)},
	/* 2989 */
	{64829, S_028BE0_MSAA_NUM_SAMPLES(~0u)},
	{64846, S_028BE0_AA_MASK_CENTROID_DTMN(~0u)},
	{64868, S_028BE0_MAX_SAMPLE_DIST(~0u)},
	{64884, S_028BE0_MSAA_EXPOSED_SAMPLES(~0u)},
	{64905, S_028BE0_DETAIL_TO_EXPOSED_MODE(~0u)},
	{70957, S_028BE0_COVERAGE_TO_SHADER_SELECT(~0u)},
	/* 2995 */
	{65440, S_028C40_REALIGN_DQUADS_AFTER_N_WAVES(~0u)},
	{69243, S_028C40_LOAD_COLLISION_WAVEID(~0u)},
	{69265, S_028C40_LOAD_INTRAWAVE_COLLISION(~0u)},
	/* 2998 */
	{71073, S_028C44_BINNING_MODE(~0u), 4, 1579},
	{71086, S_028C44_BIN_SIZE_X(~0u)},
	{71097, S_028C44_BIN_SIZE_Y(~0u)},
	{71108, S_028C44_BIN_SIZE_X_EXTEND(~0u)},
	{71126, S_028C44_BIN_SIZE_Y_EXTEND(~0u)},
	{71144, S_028C44_CONTEXT_STATES_PER_BIN(~0u)},
	{71167, S_028C44_PERSISTENT_STATES_PER_BIN(~0u)},
	{71193, S_028C44_DISABLE_START_OF_PRIM(~0u)},
	{71215, S_028C44_FPOVS_PER_BATCH(~0u)},
	{71231, S_028C44_OPTIMAL_BIN_SELECTION(~0u)},
	/* 3008 */
	{71253, S_028C48_MAX_ALLOC_COUNT(~0u)},
	{71269, S_028C48_MAX_PRIM_PER_BATCH(~0u)},
	/* 3010 */
	{71288, S_028C4C_OVER_RAST_ENABLE(~0u)},
	{71305, S_028C4C_OVER_RAST_SAMPLE_SELECT(~0u)},
	{71329, S_028C4C_UNDER_RAST_ENABLE(~0u)},
	{71347, S_028C4C_UNDER_RAST_SAMPLE_SELECT(~0u)},
	{71372, S_028C4C_PBB_UNCERTAINTY_REGION_ENABLE(~0u)},
	{71402, S_028C4C_ZMM_TRI_EXTENT(~0u)},
	{71417, S_028C4C_ZMM_TRI_OFFSET(~0u)},
	{71432, S_028C4C_OVERRIDE_OVER_RAST_INNER_TO_NORMAL(~0u)},
	{71467, S_028C4C_OVERRIDE_UNDER_RAST_INNER_TO_NORMAL(~0u)},
	{71503, S_028C4C_DEGENERATE_OVERRIDE_INNER_TO_NORMAL_DISABLE(~0u)},
	{71547, S_028C4C_UNCERTAINTY_REGION_MODE(~0u)},
	{71571, S_028C4C_OUTER_UNCERTAINTY_EDGERULE_OVERRIDE(~0u)},
	{71607, S_028C4C_INNER_UNCERTAINTY_EDGERULE_OVERRIDE(~0u)},
	{71643, S_028C4C_NULL_SQUAD_AA_MASK_ENABLE(~0u)},
	{71669, S_028C4C_COVERAGE_AA_MASK_ENABLE(~0u)},
	{71693, S_028C4C_PREZ_AA_MASK_ENABLE(~0u)},
	{71713, S_028C4C_POSTZ_AA_MASK_ENABLE(~0u)},
	{71734, S_028C4C_CENTROID_SAMPLE_OVERRIDE(~0u)},
	/* 3028 */
	{71759, S_028C50_MAX_DEALLOCS_IN_WAVE(~0u)},
	/* 3029 */
	{71780, S_028C64_BASE_256B(~0u)},
	/* 3030 */
	{71790, S_028C68_MIP0_HEIGHT(~0u)},
	{71802, S_028C68_MIP0_WIDTH(~0u)},
	{68802, S_028C68_MAX_MIP(~0u)},
	/* 3033 */
	{48842, S_028C6C_SLICE_START(~0u)},
	{48854, S_028C6C_SLICE_MAX(~0u)},
	{71813, S_028C6C_MIP_LEVEL(~0u)},
	/* 3036 */
	{65564, S_028C70_ENDIAN(~0u), 4, 1342},
	{21132, S_028C70_FORMAT(~0u), 23, 1346},
	{65931, S_028C70_NUMBER_TYPE(~0u), 8, 1369},
	{65987, S_028C70_COMP_SWAP(~0u), 4, 1377},
	{57519, S_028C70_FAST_CLEAR(~0u)},
	{49428, S_028C70_COMPRESSION(~0u)},
	{65997, S_028C70_BLEND_CLAMP(~0u)},
	{66009, S_028C70_BLEND_BYPASS(~0u)},
	{66022, S_028C70_SIMPLE_FLOAT(~0u)},
	{64989, S_028C70_ROUND_MODE(~0u)},
	{66262, S_028C70_BLEND_OPT_DONT_RD_DST(~0u), 8, 1381},
	{66284, S_028C70_BLEND_OPT_DISCARD_PIXEL(~0u), 8, 1381},
	{66308, S_028C70_FMASK_COMPRESSION_DISABLE(~0u)},
	{66334, S_028C70_FMASK_COMPRESS_1FRAG_ONLY(~0u)},
	{66360, S_028C70_DCC_ENABLE(~0u)},
	{66371, S_028C70_CMASK_ADDR_TYPE(~0u)},
	/* 3052 */
	{71823, S_028C74_MIP0_DEPTH(~0u)},
	{68756, S_028C74_META_LINEAR(~0u)},
	{50010, S_028C74_NUM_SAMPLES(~0u)},
	{66427, S_028C74_NUM_FRAGMENTS(~0u)},
	{66441, S_028C74_FORCE_DST_ALPHA_1(~0u)},
	{71834, S_028C74_COLOR_SW_MODE(~0u)},
	{71848, S_028C74_FMASK_SW_MODE(~0u)},
	{71862, S_028C74_RESOURCE_TYPE(~0u), 4, 1583},
	{68791, S_028C74_RB_ALIGNED(~0u)},
	{68773, S_028C74_PIPE_ALIGNED(~0u)},
	/* 3062 */
	{71780, S_028C80_BASE_256B(~0u)},
	/* 3063 */
	{71780, S_028C88_BASE_256B(~0u)},
	/* 3064 */
	{71780, S_028C98_BASE_256B(~0u)},
};

static const char sid_strings[] =
	"NOP\0" /* 0 */
	"SET_BASE\0" /* 4 */
	"CLEAR_STATE\0" /* 13 */
	"INDEX_BUFFER_SIZE\0" /* 25, 38 */
	"DISPATCH_DIRECT\0" /* 43 */
	"DISPATCH_INDIRECT\0" /* 59 */
	"OCCLUSION_QUERY\0" /* 91, 77 */
	"SET_PREDICATION\0" /* 93 */
	"COND_EXEC\0" /* 109 */
	"PRED_EXEC\0" /* 119 */
	"DRAW_INDIRECT\0" /* 129 */
	"DRAW_INDEX_INDIRECT\0" /* 143 */
	"INDEX_BASE\0" /* 163 */
	"DRAW_INDEX_2\0" /* 174 */
	"CONTEXT_CONTROL\0" /* 187, 195 */
	"INDEX_TYPE\0" /* 209, 203 */
	"DRAW_INDIRECT_MULTI\0" /* 214 */
	"DRAW_INDEX_AUTO\0" /* 234, 245 */
	"DRAW_INDEX_IMMD\0" /* 250 */
	"NUM_INSTANCES\0" /* 266 */
	"DRAW_INDEX_MULTI_AUTO\0" /* 280 */
	"INDIRECT_BUFFER_SI\0" /* 302 */
	"INDIRECT_BUFFER_CONST\0" /* 321 */
	"STRMOUT_BUFFER_UPDATE\0" /* 343 */
	"DRAW_INDEX_OFFSET_2\0" /* 365 */
	"WRITE_DATA\0" /* 385, 391 */
	"DRAW_INDEX_INDIRECT_MULTI\0" /* 396 */
	"MEM_SEMAPHORE\0" /* 422 */
	"MPEG_INDEX\0" /* 441, 436, 445 */
	"WAIT_REG_MEM\0" /* 447 */
	"MEM_WRITE\0" /* 460 */
	"INDIRECT_BUFFER_CIK\0" /* 470 */
	"COPY_DATA\0" /* 490 */
	"PFP_SYNC_ME\0" /* 500, 509 */
	"SURFACE_SYNC\0" /* 512 */
	"ME_INITIALIZE\0" /* 525 */
	"COND_WRITE\0" /* 539 */
	"EVENT_WRITE\0" /* 550 */
	"EVENT_WRITE_EOP\0" /* 562 */
	"RELEASE_MEM\0" /* 578 */
	"ONE_REG_WRITE\0" /* 590 */
	"ACQUIRE_MEM\0" /* 604 */
	"SET_CONFIG_REG\0" /* 616 */
	"SET_CONTEXT_REG\0" /* 631 */
	"SET_SH_REG\0" /* 647 */
	"SET_SH_REG_OFFSET\0" /* 658, 669 */
	"SET_UCONFIG_REG\0" /* 676 */
	"LOAD_CONST_RAM\0" /* 692 */
	"WRITE_CONST_RAM\0" /* 707 */
	"DUMP_CONST_RAM\0" /* 723 */
	"INCREMENT_CE_COUNTER\0" /* 738 */
	"INCREMENT_DE_COUNTER\0" /* 759 */
	"WAIT_ON_CE_COUNTER\0" /* 780 */
	"IT_OPCODE_C\0" /* 799 */
	"CP_DMA\0" /* 811 */
	"DMA_DATA\0" /* 818 */
	"DRAW_INDEX_LOC\0" /* 827 */
	"DST_ADDR_LO\0" /* 842 */
	"DST_ADDR_HI\0" /* 854 */
	"IB_BASE_LO\0" /* 866 */
	"IB_BASE_HI\0" /* 880, 877 */
	"CP_DMA_WORD0\0" /* 888 */
	"CP_DMA_WORD1\0" /* 901 */
	"CP_DMA_WORD2\0" /* 914 */
	"CP_DMA_WORD3\0" /* 927 */
	"COMMAND\0" /* 940 */
	"DMA_DATA_WORD0\0" /* 948 */
	"SRC_ADDR_LO\0" /* 963 */
	"SRC_ADDR_HI\0" /* 975 */
	"SRBM_STATUS2\0" /* 987 */
	"SRBM_STATUS\0" /* 1000, 1005 */
	"SRBM_STATUS3\0" /* 1012 */
	"SDMA0_STATUS_REG\0" /* 1025 */
	"SDMA1_STATUS_REG\0" /* 1042 */
	"GRBM_STATUS2\0" /* 1059 */
	"GRBM_STATUS\0" /* 1072 */
	"GRBM_GFX_INDEX\0" /* 1084 */
	"CP_STRMOUT_CNTL\0" /* 1099 */
	"CP_COHER_CNTL\0" /* 1115 */
	"CP_COHER_SIZE\0" /* 1129 */
	"CP_COHER_BASE\0" /* 1143 */
	"GRBM_STATUS_SE0\0" /* 1157 */
	"GRBM_STATUS_SE1\0" /* 1173 */
	"GRBM_STATUS_SE2\0" /* 1189 */
	"GRBM_STATUS_SE3\0" /* 1205 */
	"CP_COHER_BASE_HI\0" /* 1221 */
	"CP_COHER_START_DELAY\0" /* 1238 */
	"CP_COHER_STATUS\0" /* 1259 */
	"CP_CPC_STATUS\0" /* 1275 */
	"CP_CPC_BUSY_STAT\0" /* 1289 */
	"CP_CPC_STALLED_STAT1\0" /* 1306 */
	"CP_CPF_STATUS\0" /* 1327 */
	"CP_CPF_BUSY_STAT\0" /* 1341 */
	"CP_CPF_STALLED_STAT1\0" /* 1358 */
	"CP_COHER_SIZE_HI\0" /* 1379 */
	"VGT_VTX_VECT_EJECT_REG\0" /* 1396 */
	"VGT_CACHE_INVALIDATION\0" /* 1419 */
	"VGT_ESGS_RING_SIZE\0" /* 1442 */
	"VGT_GSVS_RING_SIZE\0" /* 1461 */
	"VGT_GS_VERTEX_REUSE\0" /* 1480 */
	"VGT_PRIMITIVE_TYPE\0" /* 1500 */
	"VGT_INDEX_TYPE\0" /* 1519 */
	"VGT_STRMOUT_BUFFER_FILLED_SIZE_0\0" /* 1534 */
	"VGT_STRMOUT_BUFFER_FILLED_SIZE_1\0" /* 1567 */
	"VGT_STRMOUT_BUFFER_FILLED_SIZE_2\0" /* 1600 */
	"VGT_STRMOUT_BUFFER_FILLED_SIZE_3\0" /* 1633 */
	"VGT_NUM_INDICES\0" /* 1666 */
	"VGT_NUM_INSTANCES\0" /* 1682 */
	"VGT_TF_RING_SIZE\0" /* 1700 */
	"VGT_HS_OFFCHIP_PARAM\0" /* 1717 */
	"VGT_TF_MEMORY_BASE\0" /* 1738 */
	"PA_CL_ENHANCE\0" /* 1768, 1757 */
	"PA_SU_LINE_STIPPLE_VALUE\0" /* 1777, 1771 */
	"PA_SC_LINE_STIPPLE_STATE\0" /* 1796 */
	"CP_STALLED_STAT3\0" /* 1821 */
	"CP_STALLED_STAT1\0" /* 1838 */
	"CP_STALLED_STAT2\0" /* 1855 */
	"CP_STAT\0" /* 1872 */
	"PA_SC_SCREEN_EXTENT_MIN_0\0" /* 1880 */
	"PA_SC_SCREEN_EXTENT_MAX_0\0" /* 1906 */
	"PA_SC_SCREEN_EXTENT_MIN_1\0" /* 1932 */
	"PA_SC_SCREEN_EXTENT_MAX_1\0" /* 1958 */
	"PA_SC_ENHANCE\0" /* 1984 */
	"SQC_CACHES\0" /* 1998 */
	"SQ_RANDOM_WAVE_PRI\0" /* 2009 */
	"SQ_EXP_0\0" /* 2028 */
	"TA_CS_BC_BASE_ADDR\0" /* 2051, 2037 */
	"TA_CS_BC_BASE_ADDR_HI\0" /* 2056 */
	"DB_OCCLUSION_COUNT0_LOW\0" /* 2078 */
	"DB_OCCLUSION_COUNT0_HI\0" /* 2102 */
	"SQ_BUF_RSRC_WORD0\0" /* 2125 */
	"SQ_BUF_RSRC_WORD1\0" /* 2143 */
	"DB_OCCLUSION_COUNT1_LOW\0" /* 2161 */
	"SQ_BUF_RSRC_WORD2\0" /* 2185 */
	"DB_OCCLUSION_COUNT1_HI\0" /* 2203 */
	"SQ_BUF_RSRC_WORD3\0" /* 2226 */
	"DB_OCCLUSION_COUNT2_LOW\0" /* 2244 */
	"SQ_IMG_RSRC_WORD0\0" /* 2268 */
	"DB_OCCLUSION_COUNT2_HI\0" /* 2286 */
	"SQ_IMG_RSRC_WORD1\0" /* 2309 */
	"DB_OCCLUSION_COUNT3_LOW\0" /* 2327 */
	"SQ_IMG_RSRC_WORD2\0" /* 2351 */
	"DB_OCCLUSION_COUNT3_HI\0" /* 2369 */
	"SQ_IMG_RSRC_WORD3\0" /* 2392 */
	"SQ_IMG_RSRC_WORD4\0" /* 2410 */
	"SQ_IMG_RSRC_WORD5\0" /* 2428 */
	"SQ_IMG_RSRC_WORD6\0" /* 2446 */
	"SQ_IMG_RSRC_WORD7\0" /* 2464 */
	"SQ_IMG_SAMP_WORD0\0" /* 2482 */
	"SQ_IMG_SAMP_WORD1\0" /* 2500 */
	"SQ_IMG_SAMP_WORD2\0" /* 2518 */
	"SQ_IMG_SAMP_WORD3\0" /* 2536 */
	"SPI_DYN_GPR_LOCK_EN\0" /* 2554, 2571 */
	"SPI_STATIC_THREAD_MGMT_1\0" /* 2574 */
	"SPI_STATIC_THREAD_MGMT_2\0" /* 2599 */
	"SPI_STATIC_THREAD_MGMT_3\0" /* 2624 */
	"SPI_PS_MAX_WAVE_ID\0" /* 2656, 2649 */
	"SPI_ARB_PRIORITY\0" /* 2676, 2668 */
	"SPI_ARB_CYCLES_0\0" /* 2685 */
	"SPI_ARB_CYCLES_1\0" /* 2702 */
	"SQ_FLAT_SCRATCH_WORD0\0" /* 2719 */
	"SQ_FLAT_SCRATCH_WORD1\0" /* 2741 */
	"DB_ZPASS_COUNT_LOW\0" /* 2763 */
	"DB_ZPASS_COUNT_HI\0" /* 2782, 2791 */
	"SPI_CONFIG_CNTL\0" /* 2800 */
	"SPI_CONFIG_CNTL_1\0" /* 2816 */
	"SPI_RESOURCE_RESERVE_CU_AB_0\0" /* 2834 */
	"DB_SUBTILE_CONTROL\0" /* 2863 */
	"GB_ADDR_CONFIG\0" /* 2882 */
	"GB_TILE_MODE0\0" /* 2897 */
	"GB_TILE_MODE1\0" /* 2911 */
	"GB_TILE_MODE2\0" /* 2925 */
	"GB_TILE_MODE3\0" /* 2939 */
	"GB_TILE_MODE4\0" /* 2953 */
	"GB_TILE_MODE5\0" /* 2967 */
	"GB_TILE_MODE6\0" /* 2981 */
	"GB_TILE_MODE7\0" /* 2995 */
	"GB_TILE_MODE8\0" /* 3009 */
	"GB_TILE_MODE9\0" /* 3023 */
	"GB_TILE_MODE10\0" /* 3037 */
	"GB_TILE_MODE11\0" /* 3052 */
	"GB_TILE_MODE12\0" /* 3067 */
	"GB_TILE_MODE13\0" /* 3082 */
	"GB_TILE_MODE14\0" /* 3097 */
	"GB_TILE_MODE15\0" /* 3112 */
	"GB_TILE_MODE16\0" /* 3127 */
	"GB_TILE_MODE17\0" /* 3142 */
	"GB_TILE_MODE18\0" /* 3157 */
	"GB_TILE_MODE19\0" /* 3172 */
	"GB_TILE_MODE20\0" /* 3187 */
	"GB_TILE_MODE21\0" /* 3202 */
	"GB_TILE_MODE22\0" /* 3217 */
	"GB_TILE_MODE23\0" /* 3232 */
	"GB_TILE_MODE24\0" /* 3247 */
	"GB_TILE_MODE25\0" /* 3262 */
	"GB_TILE_MODE26\0" /* 3277 */
	"GB_TILE_MODE27\0" /* 3292 */
	"GB_TILE_MODE28\0" /* 3307 */
	"GB_TILE_MODE29\0" /* 3322 */
	"GB_TILE_MODE30\0" /* 3337 */
	"GB_TILE_MODE31\0" /* 3352 */
	"GB_MACROTILE_MODE0\0" /* 3367 */
	"GB_MACROTILE_MODE1\0" /* 3386 */
	"GB_MACROTILE_MODE2\0" /* 3405 */
	"GB_MACROTILE_MODE3\0" /* 3424 */
	"GB_MACROTILE_MODE4\0" /* 3443 */
	"GB_MACROTILE_MODE5\0" /* 3462 */
	"GB_MACROTILE_MODE6\0" /* 3481 */
	"GB_MACROTILE_MODE7\0" /* 3500 */
	"GB_MACROTILE_MODE8\0" /* 3519 */
	"GB_MACROTILE_MODE9\0" /* 3538 */
	"GB_MACROTILE_MODE10\0" /* 3557 */
	"GB_MACROTILE_MODE11\0" /* 3577 */
	"GB_MACROTILE_MODE12\0" /* 3597 */
	"GB_MACROTILE_MODE13\0" /* 3617 */
	"GB_MACROTILE_MODE14\0" /* 3637 */
	"GB_MACROTILE_MODE15\0" /* 3657 */
	"SPI_SHADER_TBA_LO_PS\0" /* 3677 */
	"SPI_SHADER_TBA_HI_PS\0" /* 3698 */
	"SPI_SHADER_TMA_LO_PS\0" /* 3719 */
	"SPI_SHADER_TMA_HI_PS\0" /* 3740 */
	"SPI_SHADER_PGM_RSRC3_PS\0" /* 3761 */
	"SPI_SHADER_PGM_LO_PS\0" /* 3785 */
	"SPI_SHADER_PGM_HI_PS\0" /* 3806 */
	"SPI_SHADER_PGM_RSRC1_PS\0" /* 3827 */
	"SPI_SHADER_PGM_RSRC2_PS\0" /* 3851 */
	"SPI_SHADER_USER_DATA_PS_0\0" /* 3875 */
	"SPI_SHADER_USER_DATA_PS_1\0" /* 3901 */
	"SPI_SHADER_USER_DATA_PS_2\0" /* 3927 */
	"SPI_SHADER_USER_DATA_PS_3\0" /* 3953 */
	"SPI_SHADER_USER_DATA_PS_4\0" /* 3979 */
	"SPI_SHADER_USER_DATA_PS_5\0" /* 4005 */
	"SPI_SHADER_USER_DATA_PS_6\0" /* 4031 */
	"SPI_SHADER_USER_DATA_PS_7\0" /* 4057 */
	"SPI_SHADER_USER_DATA_PS_8\0" /* 4083 */
	"SPI_SHADER_USER_DATA_PS_9\0" /* 4109 */
	"SPI_SHADER_USER_DATA_PS_10\0" /* 4135 */
	"SPI_SHADER_USER_DATA_PS_11\0" /* 4162 */
	"SPI_SHADER_USER_DATA_PS_12\0" /* 4189 */
	"SPI_SHADER_USER_DATA_PS_13\0" /* 4216 */
	"SPI_SHADER_USER_DATA_PS_14\0" /* 4243 */
	"SPI_SHADER_USER_DATA_PS_15\0" /* 4270 */
	"SPI_SHADER_TBA_LO_VS\0" /* 4297 */
	"SPI_SHADER_TBA_HI_VS\0" /* 4318 */
	"SPI_SHADER_TMA_LO_VS\0" /* 4339 */
	"SPI_SHADER_TMA_HI_VS\0" /* 4360 */
	"SPI_SHADER_PGM_RSRC3_VS\0" /* 4381 */
	"SPI_SHADER_LATE_ALLOC_VS\0" /* 4405 */
	"SPI_SHADER_PGM_LO_VS\0" /* 4430 */
	"SPI_SHADER_PGM_HI_VS\0" /* 4451 */
	"SPI_SHADER_PGM_RSRC1_VS\0" /* 4472 */
	"SPI_SHADER_PGM_RSRC2_VS\0" /* 4496 */
	"SPI_SHADER_USER_DATA_VS_0\0" /* 4520 */
	"SPI_SHADER_USER_DATA_VS_1\0" /* 4546 */
	"SPI_SHADER_USER_DATA_VS_2\0" /* 4572 */
	"SPI_SHADER_USER_DATA_VS_3\0" /* 4598 */
	"SPI_SHADER_USER_DATA_VS_4\0" /* 4624 */
	"SPI_SHADER_USER_DATA_VS_5\0" /* 4650 */
	"SPI_SHADER_USER_DATA_VS_6\0" /* 4676 */
	"SPI_SHADER_USER_DATA_VS_7\0" /* 4702 */
	"SPI_SHADER_USER_DATA_VS_8\0" /* 4728 */
	"SPI_SHADER_USER_DATA_VS_9\0" /* 4754 */
	"SPI_SHADER_USER_DATA_VS_10\0" /* 4780 */
	"SPI_SHADER_USER_DATA_VS_11\0" /* 4807 */
	"SPI_SHADER_USER_DATA_VS_12\0" /* 4834 */
	"SPI_SHADER_USER_DATA_VS_13\0" /* 4861 */
	"SPI_SHADER_USER_DATA_VS_14\0" /* 4888 */
	"SPI_SHADER_USER_DATA_VS_15\0" /* 4915 */
	"SPI_SHADER_TBA_LO_GS\0" /* 4942 */
	"SPI_SHADER_TBA_HI_GS\0" /* 4963 */
	"SPI_SHADER_TMA_LO_GS\0" /* 4984 */
	"SPI_SHADER_TMA_HI_GS\0" /* 5005 */
	"SPI_SHADER_PGM_RSRC3_GS\0" /* 5026 */
	"SPI_SHADER_PGM_LO_GS\0" /* 5050 */
	"SPI_SHADER_PGM_HI_GS\0" /* 5071 */
	"SPI_SHADER_PGM_RSRC1_GS\0" /* 5092 */
	"SPI_SHADER_PGM_RSRC2_GS\0" /* 5116 */
	"SPI_SHADER_USER_DATA_GS_0\0" /* 5140 */
	"SPI_SHADER_USER_DATA_GS_1\0" /* 5166 */
	"SPI_SHADER_USER_DATA_GS_2\0" /* 5192 */
	"SPI_SHADER_USER_DATA_GS_3\0" /* 5218 */
	"SPI_SHADER_USER_DATA_GS_4\0" /* 5244 */
	"SPI_SHADER_USER_DATA_GS_5\0" /* 5270 */
	"SPI_SHADER_USER_DATA_GS_6\0" /* 5296 */
	"SPI_SHADER_USER_DATA_GS_7\0" /* 5322 */
	"SPI_SHADER_USER_DATA_GS_8\0" /* 5348 */
	"SPI_SHADER_USER_DATA_GS_9\0" /* 5374 */
	"SPI_SHADER_USER_DATA_GS_10\0" /* 5400 */
	"SPI_SHADER_USER_DATA_GS_11\0" /* 5427 */
	"SPI_SHADER_USER_DATA_GS_12\0" /* 5454 */
	"SPI_SHADER_USER_DATA_GS_13\0" /* 5481 */
	"SPI_SHADER_USER_DATA_GS_14\0" /* 5508 */
	"SPI_SHADER_USER_DATA_GS_15\0" /* 5535 */
	"SPI_SHADER_TBA_LO_ES\0" /* 5562 */
	"SPI_SHADER_TBA_HI_ES\0" /* 5583 */
	"SPI_SHADER_TMA_LO_ES\0" /* 5604 */
	"SPI_SHADER_TMA_HI_ES\0" /* 5625 */
	"SPI_SHADER_PGM_RSRC3_ES\0" /* 5646 */
	"SPI_SHADER_PGM_LO_ES\0" /* 5670 */
	"SPI_SHADER_PGM_HI_ES\0" /* 5691 */
	"SPI_SHADER_PGM_RSRC1_ES\0" /* 5712 */
	"SPI_SHADER_PGM_RSRC2_ES\0" /* 5736 */
	"SPI_SHADER_USER_DATA_ES_0\0" /* 5760 */
	"SPI_SHADER_USER_DATA_ES_1\0" /* 5786 */
	"SPI_SHADER_USER_DATA_ES_2\0" /* 5812 */
	"SPI_SHADER_USER_DATA_ES_3\0" /* 5838 */
	"SPI_SHADER_USER_DATA_ES_4\0" /* 5864 */
	"SPI_SHADER_USER_DATA_ES_5\0" /* 5890 */
	"SPI_SHADER_USER_DATA_ES_6\0" /* 5916 */
	"SPI_SHADER_USER_DATA_ES_7\0" /* 5942 */
	"SPI_SHADER_USER_DATA_ES_8\0" /* 5968 */
	"SPI_SHADER_USER_DATA_ES_9\0" /* 5994 */
	"SPI_SHADER_USER_DATA_ES_10\0" /* 6020 */
	"SPI_SHADER_USER_DATA_ES_11\0" /* 6047 */
	"SPI_SHADER_USER_DATA_ES_12\0" /* 6074 */
	"SPI_SHADER_USER_DATA_ES_13\0" /* 6101 */
	"SPI_SHADER_USER_DATA_ES_14\0" /* 6128 */
	"SPI_SHADER_USER_DATA_ES_15\0" /* 6155 */
	"SPI_SHADER_TBA_LO_HS\0" /* 6182 */
	"SPI_SHADER_TBA_HI_HS\0" /* 6203 */
	"SPI_SHADER_TMA_LO_HS\0" /* 6224 */
	"SPI_SHADER_TMA_HI_HS\0" /* 6245 */
	"SPI_SHADER_PGM_RSRC3_HS\0" /* 6266 */
	"SPI_SHADER_PGM_LO_HS\0" /* 6290 */
	"SPI_SHADER_PGM_HI_HS\0" /* 6311 */
	"SPI_SHADER_PGM_RSRC1_HS\0" /* 6332 */
	"SPI_SHADER_PGM_RSRC2_HS\0" /* 6356 */
	"SPI_SHADER_USER_DATA_HS_0\0" /* 6380 */
	"SPI_SHADER_USER_DATA_HS_1\0" /* 6406 */
	"SPI_SHADER_USER_DATA_HS_2\0" /* 6432 */
	"SPI_SHADER_USER_DATA_HS_3\0" /* 6458 */
	"SPI_SHADER_USER_DATA_HS_4\0" /* 6484 */
	"SPI_SHADER_USER_DATA_HS_5\0" /* 6510 */
	"SPI_SHADER_USER_DATA_HS_6\0" /* 6536 */
	"SPI_SHADER_USER_DATA_HS_7\0" /* 6562 */
	"SPI_SHADER_USER_DATA_HS_8\0" /* 6588 */
	"SPI_SHADER_USER_DATA_HS_9\0" /* 6614 */
	"SPI_SHADER_USER_DATA_HS_10\0" /* 6640 */
	"SPI_SHADER_USER_DATA_HS_11\0" /* 6667 */
	"SPI_SHADER_USER_DATA_HS_12\0" /* 6694 */
	"SPI_SHADER_USER_DATA_HS_13\0" /* 6721 */
	"SPI_SHADER_USER_DATA_HS_14\0" /* 6748 */
	"SPI_SHADER_USER_DATA_HS_15\0" /* 6775 */
	"SPI_SHADER_TBA_LO_LS\0" /* 6802 */
	"SPI_SHADER_TBA_HI_LS\0" /* 6823 */
	"SPI_SHADER_TMA_LO_LS\0" /* 6844 */
	"SPI_SHADER_TMA_HI_LS\0" /* 6865 */
	"SPI_SHADER_PGM_RSRC3_LS\0" /* 6886 */
	"SPI_SHADER_PGM_LO_LS\0" /* 6910 */
	"SPI_SHADER_PGM_HI_LS\0" /* 6931 */
	"SPI_SHADER_PGM_RSRC1_LS\0" /* 6952 */
	"SPI_SHADER_PGM_RSRC2_LS\0" /* 6976 */
	"SPI_SHADER_USER_DATA_LS_0\0" /* 7000 */
	"SPI_SHADER_USER_DATA_LS_1\0" /* 7026 */
	"SPI_SHADER_USER_DATA_LS_2\0" /* 7052 */
	"SPI_SHADER_USER_DATA_LS_3\0" /* 7078 */
	"SPI_SHADER_USER_DATA_LS_4\0" /* 7104 */
	"SPI_SHADER_USER_DATA_LS_5\0" /* 7130 */
	"SPI_SHADER_USER_DATA_LS_6\0" /* 7156 */
	"SPI_SHADER_USER_DATA_LS_7\0" /* 7182 */
	"SPI_SHADER_USER_DATA_LS_8\0" /* 7208 */
	"SPI_SHADER_USER_DATA_LS_9\0" /* 7234 */
	"SPI_SHADER_USER_DATA_LS_10\0" /* 7260 */
	"SPI_SHADER_USER_DATA_LS_11\0" /* 7287 */
	"SPI_SHADER_USER_DATA_LS_12\0" /* 7314 */
	"SPI_SHADER_USER_DATA_LS_13\0" /* 7341 */
	"SPI_SHADER_USER_DATA_LS_14\0" /* 7368 */
	"SPI_SHADER_USER_DATA_LS_15\0" /* 7395 */
	"COMPUTE_DISPATCH_INITIATOR\0" /* 7422 */
	"COMPUTE_DIM_X\0" /* 7449 */
	"COMPUTE_DIM_Y\0" /* 7463 */
	"COMPUTE_DIM_Z\0" /* 7477 */
	"COMPUTE_START_X\0" /* 7499, 7491 */
	"COMPUTE_START_Y\0" /* 7515, 7507 */
	"COMPUTE_START_Z\0" /* 7523 */
	"COMPUTE_NUM_THREAD_X\0" /* 7539 */
	"COMPUTE_NUM_THREAD_Y\0" /* 7560 */
	"COMPUTE_NUM_THREAD_Z\0" /* 7581 */
	"COMPUTE_MAX_WAVE_ID\0" /* 7602 */
	"COMPUTE_PIPELINESTAT_ENABLE\0" /* 7643, 7630, 7622 */
	"COMPUTE_PERFCOUNT_ENABLE\0" /* 7650, 7658 */
	"COMPUTE_PGM_LO\0" /* 7675 */
	"COMPUTE_PGM_HI\0" /* 7690 */
	"COMPUTE_TBA_LO\0" /* 7705 */
	"COMPUTE_TBA_HI\0" /* 7720 */
	"COMPUTE_TMA_LO\0" /* 7735 */
	"COMPUTE_TMA_HI\0" /* 7750 */
	"COMPUTE_PGM_RSRC1\0" /* 7765 */
	"COMPUTE_PGM_RSRC2\0" /* 7783 */
	"COMPUTE_VMID\0" /* 7801 */
	"COMPUTE_RESOURCE_LIMITS\0" /* 7814 */
	"COMPUTE_STATIC_THREAD_MGMT_SE0\0" /* 7838 */
	"COMPUTE_STATIC_THREAD_MGMT_SE1\0" /* 7869 */
	"COMPUTE_TMPRING_SIZE\0" /* 7900 */
	"COMPUTE_STATIC_THREAD_MGMT_SE2\0" /* 7921 */
	"COMPUTE_STATIC_THREAD_MGMT_SE3\0" /* 7952 */
	"COMPUTE_RESTART_X\0" /* 7983 */
	"COMPUTE_RESTART_Y\0" /* 8001 */
	"COMPUTE_RESTART_Z\0" /* 8019 */
	"COMPUTE_MISC_RESERVED\0" /* 8050, 8037 */
	"COMPUTE_DISPATCH_ID\0" /* 8059 */
	"COMPUTE_THREADGROUP_ID\0" /* 8079 */
	"COMPUTE_RELAUNCH\0" /* 8102 */
	"COMPUTE_WAVE_RESTORE_ADDR_LO\0" /* 8119 */
	"COMPUTE_WAVE_RESTORE_ADDR_HI\0" /* 8148 */
	"COMPUTE_WAVE_RESTORE_CONTROL\0" /* 8177 */
	"COMPUTE_USER_DATA_0\0" /* 8206 */
	"COMPUTE_USER_DATA_1\0" /* 8226 */
	"COMPUTE_USER_DATA_2\0" /* 8246 */
	"COMPUTE_USER_DATA_3\0" /* 8266 */
	"COMPUTE_USER_DATA_4\0" /* 8286 */
	"COMPUTE_USER_DATA_5\0" /* 8306 */
	"COMPUTE_USER_DATA_6\0" /* 8326 */
	"COMPUTE_USER_DATA_7\0" /* 8346 */
	"COMPUTE_USER_DATA_8\0" /* 8366 */
	"COMPUTE_USER_DATA_9\0" /* 8386 */
	"COMPUTE_USER_DATA_10\0" /* 8406 */
	"COMPUTE_USER_DATA_11\0" /* 8427 */
	"COMPUTE_USER_DATA_12\0" /* 8448 */
	"COMPUTE_USER_DATA_13\0" /* 8469 */
	"COMPUTE_USER_DATA_14\0" /* 8490 */
	"COMPUTE_USER_DATA_15\0" /* 8511 */
	"COMPUTE_NOWHERE\0" /* 8540, 8532 */
	"CPG_PERFCOUNTER1_LO\0" /* 8548 */
	"CPG_PERFCOUNTER1_HI\0" /* 8568 */
	"CPG_PERFCOUNTER0_LO\0" /* 8588 */
	"CPG_PERFCOUNTER0_HI\0" /* 8608 */
	"CPC_PERFCOUNTER1_LO\0" /* 8628 */
	"CPC_PERFCOUNTER1_HI\0" /* 8648 */
	"CPC_PERFCOUNTER0_LO\0" /* 8668 */
	"CPC_PERFCOUNTER0_HI\0" /* 8688 */
	"CPF_PERFCOUNTER1_LO\0" /* 8708 */
	"CPF_PERFCOUNTER1_HI\0" /* 8728 */
	"CPF_PERFCOUNTER0_LO\0" /* 8748 */
	"CPF_PERFCOUNTER0_HI\0" /* 8768 */
	"GRBM_PERFCOUNTER0_LO\0" /* 8788 */
	"GRBM_PERFCOUNTER0_HI\0" /* 8809 */
	"GRBM_PERFCOUNTER1_LO\0" /* 8830 */
	"GRBM_PERFCOUNTER1_HI\0" /* 8851 */
	"GRBM_SE0_PERFCOUNTER_LO\0" /* 8872 */
	"GRBM_SE0_PERFCOUNTER_HI\0" /* 8896, 8905 */
	"GRBM_SE1_PERFCOUNTER_LO\0" /* 8920 */
	"GRBM_SE1_PERFCOUNTER_HI\0" /* 8944 */
	"GRBM_SE2_PERFCOUNTER_LO\0" /* 8968 */
	"GRBM_SE2_PERFCOUNTER_HI\0" /* 8992 */
	"GRBM_SE3_PERFCOUNTER_LO\0" /* 9016 */
	"GRBM_SE3_PERFCOUNTER_HI\0" /* 9040 */
	"WD_PERFCOUNTER0_LO\0" /* 9064 */
	"WD_PERFCOUNTER0_HI\0" /* 9083 */
	"WD_PERFCOUNTER1_LO\0" /* 9102 */
	"WD_PERFCOUNTER1_HI\0" /* 9121 */
	"WD_PERFCOUNTER2_LO\0" /* 9140 */
	"WD_PERFCOUNTER2_HI\0" /* 9159 */
	"WD_PERFCOUNTER3_LO\0" /* 9178 */
	"WD_PERFCOUNTER3_HI\0" /* 9197 */
	"IA_PERFCOUNTER0_LO\0" /* 9216 */
	"IA_PERFCOUNTER0_HI\0" /* 9235 */
	"IA_PERFCOUNTER1_LO\0" /* 9254 */
	"IA_PERFCOUNTER1_HI\0" /* 9273 */
	"IA_PERFCOUNTER2_LO\0" /* 9292 */
	"IA_PERFCOUNTER2_HI\0" /* 9311 */
	"IA_PERFCOUNTER3_LO\0" /* 9330 */
	"IA_PERFCOUNTER3_HI\0" /* 9349 */
	"VGT_PERFCOUNTER0_LO\0" /* 9368 */
	"VGT_PERFCOUNTER0_HI\0" /* 9388 */
	"VGT_PERFCOUNTER1_LO\0" /* 9408 */
	"VGT_PERFCOUNTER1_HI\0" /* 9428 */
	"VGT_PERFCOUNTER2_LO\0" /* 9448 */
	"VGT_PERFCOUNTER2_HI\0" /* 9468 */
	"VGT_PERFCOUNTER3_LO\0" /* 9488 */
	"VGT_PERFCOUNTER3_HI\0" /* 9508 */
	"PA_SU_PERFCOUNTER0_LO\0" /* 9528 */
	"PA_SU_PERFCOUNTER0_HI\0" /* 9550 */
	"PA_SU_PERFCOUNTER1_LO\0" /* 9572 */
	"PA_SU_PERFCOUNTER1_HI\0" /* 9594 */
	"PA_SU_PERFCOUNTER2_LO\0" /* 9616 */
	"PA_SU_PERFCOUNTER2_HI\0" /* 9638 */
	"PA_SU_PERFCOUNTER3_LO\0" /* 9660 */
	"PA_SU_PERFCOUNTER3_HI\0" /* 9682 */
	"PA_SC_PERFCOUNTER0_LO\0" /* 9704 */
	"PA_SC_PERFCOUNTER0_HI\0" /* 9726 */
	"PA_SC_PERFCOUNTER1_LO\0" /* 9748 */
	"PA_SC_PERFCOUNTER1_HI\0" /* 9770 */
	"PA_SC_PERFCOUNTER2_LO\0" /* 9792 */
	"PA_SC_PERFCOUNTER2_HI\0" /* 9814 */
	"PA_SC_PERFCOUNTER3_LO\0" /* 9836 */
	"PA_SC_PERFCOUNTER3_HI\0" /* 9858 */
	"PA_SC_PERFCOUNTER4_LO\0" /* 9880 */
	"PA_SC_PERFCOUNTER4_HI\0" /* 9902 */
	"PA_SC_PERFCOUNTER5_LO\0" /* 9924 */
	"PA_SC_PERFCOUNTER5_HI\0" /* 9946 */
	"PA_SC_PERFCOUNTER6_LO\0" /* 9968 */
	"PA_SC_PERFCOUNTER6_HI\0" /* 9990 */
	"PA_SC_PERFCOUNTER7_LO\0" /* 10012 */
	"PA_SC_PERFCOUNTER7_HI\0" /* 10034 */
	"SPI_PERFCOUNTER0_HI\0" /* 10056 */
	"SPI_PERFCOUNTER0_LO\0" /* 10076 */
	"SPI_PERFCOUNTER1_HI\0" /* 10096 */
	"SPI_PERFCOUNTER1_LO\0" /* 10116 */
	"SPI_PERFCOUNTER2_HI\0" /* 10136 */
	"SPI_PERFCOUNTER2_LO\0" /* 10156 */
	"SPI_PERFCOUNTER3_HI\0" /* 10176 */
	"SPI_PERFCOUNTER3_LO\0" /* 10196 */
	"SPI_PERFCOUNTER4_HI\0" /* 10216 */
	"SPI_PERFCOUNTER4_LO\0" /* 10236 */
	"SPI_PERFCOUNTER5_HI\0" /* 10256 */
	"SPI_PERFCOUNTER5_LO\0" /* 10276 */
	"SQ_PERFCOUNTER0_LO\0" /* 10296 */
	"SQ_PERFCOUNTER0_HI\0" /* 10315 */
	"SQ_PERFCOUNTER1_LO\0" /* 10334 */
	"SQ_PERFCOUNTER1_HI\0" /* 10353 */
	"SQ_PERFCOUNTER2_LO\0" /* 10372 */
	"SQ_PERFCOUNTER2_HI\0" /* 10391 */
	"SQ_PERFCOUNTER3_LO\0" /* 10410 */
	"SQ_PERFCOUNTER3_HI\0" /* 10429 */
	"SQ_PERFCOUNTER4_LO\0" /* 10448 */
	"SQ_PERFCOUNTER4_HI\0" /* 10467 */
	"SQ_PERFCOUNTER5_LO\0" /* 10486 */
	"SQ_PERFCOUNTER5_HI\0" /* 10505 */
	"SQ_PERFCOUNTER6_LO\0" /* 10524 */
	"SQ_PERFCOUNTER6_HI\0" /* 10543 */
	"SQ_PERFCOUNTER7_LO\0" /* 10562 */
	"SQ_PERFCOUNTER7_HI\0" /* 10581 */
	"SQ_PERFCOUNTER8_LO\0" /* 10600 */
	"SQ_PERFCOUNTER8_HI\0" /* 10619 */
	"SQ_PERFCOUNTER9_LO\0" /* 10638 */
	"SQ_PERFCOUNTER9_HI\0" /* 10657 */
	"SQ_PERFCOUNTER10_LO\0" /* 10676 */
	"SQ_PERFCOUNTER10_HI\0" /* 10696 */
	"SQ_PERFCOUNTER11_LO\0" /* 10716 */
	"SQ_PERFCOUNTER11_HI\0" /* 10736 */
	"SQ_PERFCOUNTER12_LO\0" /* 10756 */
	"SQ_PERFCOUNTER12_HI\0" /* 10776 */
	"SQ_PERFCOUNTER13_LO\0" /* 10796 */
	"SQ_PERFCOUNTER13_HI\0" /* 10816 */
	"SQ_PERFCOUNTER14_LO\0" /* 10836 */
	"SQ_PERFCOUNTER14_HI\0" /* 10856 */
	"SQ_PERFCOUNTER15_LO\0" /* 10876 */
	"SQ_PERFCOUNTER15_HI\0" /* 10896 */
	"SX_PERFCOUNTER0_LO\0" /* 10916 */
	"SX_PERFCOUNTER0_HI\0" /* 10935 */
	"SX_PERFCOUNTER1_LO\0" /* 10954 */
	"SX_PERFCOUNTER1_HI\0" /* 10973 */
	"SX_PERFCOUNTER2_LO\0" /* 10992 */
	"SX_PERFCOUNTER2_HI\0" /* 11011 */
	"SX_PERFCOUNTER3_LO\0" /* 11030 */
	"SX_PERFCOUNTER3_HI\0" /* 11049 */
	"GDS_PERFCOUNTER0_LO\0" /* 11068 */
	"GDS_PERFCOUNTER0_HI\0" /* 11088 */
	"GDS_PERFCOUNTER1_LO\0" /* 11108 */
	"GDS_PERFCOUNTER1_HI\0" /* 11128 */
	"GDS_PERFCOUNTER2_LO\0" /* 11148 */
	"GDS_PERFCOUNTER2_HI\0" /* 11168 */
	"GDS_PERFCOUNTER3_LO\0" /* 11188 */
	"GDS_PERFCOUNTER3_HI\0" /* 11208 */
	"TA_PERFCOUNTER0_LO\0" /* 11228 */
	"TA_PERFCOUNTER0_HI\0" /* 11247 */
	"TA_PERFCOUNTER1_LO\0" /* 11266 */
	"TA_PERFCOUNTER1_HI\0" /* 11285 */
	"TD_PERFCOUNTER0_LO\0" /* 11304 */
	"TD_PERFCOUNTER0_HI\0" /* 11323 */
	"TD_PERFCOUNTER1_LO\0" /* 11342 */
	"TD_PERFCOUNTER1_HI\0" /* 11361 */
	"TCP_PERFCOUNTER0_LO\0" /* 11380 */
	"TCP_PERFCOUNTER0_HI\0" /* 11400 */
	"TCP_PERFCOUNTER1_LO\0" /* 11420 */
	"TCP_PERFCOUNTER1_HI\0" /* 11440 */
	"TCP_PERFCOUNTER2_LO\0" /* 11460 */
	"TCP_PERFCOUNTER2_HI\0" /* 11480 */
	"TCP_PERFCOUNTER3_LO\0" /* 11500 */
	"TCP_PERFCOUNTER3_HI\0" /* 11520 */
	"TCC_PERFCOUNTER0_LO\0" /* 11540 */
	"TCC_PERFCOUNTER0_HI\0" /* 11560 */
	"TCC_PERFCOUNTER1_LO\0" /* 11580 */
	"TCC_PERFCOUNTER1_HI\0" /* 11600 */
	"TCC_PERFCOUNTER2_LO\0" /* 11620 */
	"TCC_PERFCOUNTER2_HI\0" /* 11640 */
	"TCC_PERFCOUNTER3_LO\0" /* 11660 */
	"TCC_PERFCOUNTER3_HI\0" /* 11680 */
	"TCA_PERFCOUNTER0_LO\0" /* 11700 */
	"TCA_PERFCOUNTER0_HI\0" /* 11720 */
	"TCA_PERFCOUNTER1_LO\0" /* 11740 */
	"TCA_PERFCOUNTER1_HI\0" /* 11760 */
	"TCA_PERFCOUNTER2_LO\0" /* 11780 */
	"TCA_PERFCOUNTER2_HI\0" /* 11800 */
	"TCA_PERFCOUNTER3_LO\0" /* 11820 */
	"TCA_PERFCOUNTER3_HI\0" /* 11840 */
	"CB_PERFCOUNTER0_LO\0" /* 11860 */
	"CB_PERFCOUNTER0_HI\0" /* 11879 */
	"CB_PERFCOUNTER1_LO\0" /* 11898 */
	"CB_PERFCOUNTER1_HI\0" /* 11917 */
	"CB_PERFCOUNTER2_LO\0" /* 11936 */
	"CB_PERFCOUNTER2_HI\0" /* 11955 */
	"CB_PERFCOUNTER3_LO\0" /* 11974 */
	"CB_PERFCOUNTER3_HI\0" /* 11993 */
	"DB_PERFCOUNTER0_LO\0" /* 12012 */
	"DB_PERFCOUNTER0_HI\0" /* 12031 */
	"DB_PERFCOUNTER1_LO\0" /* 12050 */
	"DB_PERFCOUNTER1_HI\0" /* 12069 */
	"DB_PERFCOUNTER2_LO\0" /* 12088 */
	"DB_PERFCOUNTER2_HI\0" /* 12107 */
	"DB_PERFCOUNTER3_LO\0" /* 12126 */
	"DB_PERFCOUNTER3_HI\0" /* 12145 */
	"RLC_PERFCOUNTER0_LO\0" /* 12164 */
	"RLC_PERFCOUNTER0_HI\0" /* 12184 */
	"RLC_PERFCOUNTER1_LO\0" /* 12204 */
	"RLC_PERFCOUNTER1_HI\0" /* 12224 */
	"CPG_PERFCOUNTER1_SELECT\0" /* 12244 */
	"CPG_PERFCOUNTER0_SELECT1\0" /* 12268 */
	"CPG_PERFCOUNTER0_SELECT\0" /* 12293 */
	"CPC_PERFCOUNTER1_SELECT\0" /* 12317 */
	"CPC_PERFCOUNTER0_SELECT1\0" /* 12341 */
	"CPF_PERFCOUNTER1_SELECT\0" /* 12366 */
	"CPF_PERFCOUNTER0_SELECT1\0" /* 12390 */
	"CPF_PERFCOUNTER0_SELECT\0" /* 12415 */
	"CP_PERFMON_CNTL\0" /* 12439 */
	"CPC_PERFCOUNTER0_SELECT\0" /* 12455 */
	"GRBM_PERFCOUNTER0_SELECT\0" /* 12479 */
	"GRBM_PERFCOUNTER1_SELECT\0" /* 12504 */
	"GRBM_SE0_PERFCOUNTER_SELECT\0" /* 12529, 12538 */
	"GRBM_SE1_PERFCOUNTER_SELECT\0" /* 12557 */
	"GRBM_SE2_PERFCOUNTER_SELECT\0" /* 12585 */
	"GRBM_SE3_PERFCOUNTER_SELECT\0" /* 12613 */
	"WD_PERFCOUNTER0_SELECT\0" /* 12641 */
	"WD_PERFCOUNTER1_SELECT\0" /* 12664 */
	"WD_PERFCOUNTER2_SELECT\0" /* 12687 */
	"WD_PERFCOUNTER3_SELECT\0" /* 12710 */
	"IA_PERFCOUNTER0_SELECT\0" /* 12733 */
	"IA_PERFCOUNTER1_SELECT\0" /* 12756 */
	"IA_PERFCOUNTER2_SELECT\0" /* 12779 */
	"IA_PERFCOUNTER3_SELECT\0" /* 12802 */
	"IA_PERFCOUNTER0_SELECT1\0" /* 12825 */
	"VGT_PERFCOUNTER0_SELECT\0" /* 12849 */
	"VGT_PERFCOUNTER1_SELECT\0" /* 12873 */
	"VGT_PERFCOUNTER2_SELECT\0" /* 12897 */
	"VGT_PERFCOUNTER3_SELECT\0" /* 12921 */
	"VGT_PERFCOUNTER0_SELECT1\0" /* 12945 */
	"VGT_PERFCOUNTER1_SELECT1\0" /* 12970 */
	"VGT_PERFCOUNTER_SEID_MASK\0" /* 12995 */
	"PA_SU_PERFCOUNTER0_SELECT\0" /* 13021 */
	"PA_SU_PERFCOUNTER0_SELECT1\0" /* 13047 */
	"PA_SU_PERFCOUNTER1_SELECT\0" /* 13074 */
	"PA_SU_PERFCOUNTER1_SELECT1\0" /* 13100 */
	"PA_SU_PERFCOUNTER2_SELECT\0" /* 13127 */
	"PA_SU_PERFCOUNTER3_SELECT\0" /* 13153 */
	"PA_SC_PERFCOUNTER0_SELECT\0" /* 13179 */
	"PA_SC_PERFCOUNTER0_SELECT1\0" /* 13205 */
	"PA_SC_PERFCOUNTER1_SELECT\0" /* 13232 */
	"PA_SC_PERFCOUNTER2_SELECT\0" /* 13258 */
	"PA_SC_PERFCOUNTER3_SELECT\0" /* 13284 */
	"PA_SC_PERFCOUNTER4_SELECT\0" /* 13310 */
	"PA_SC_PERFCOUNTER5_SELECT\0" /* 13336 */
	"PA_SC_PERFCOUNTER6_SELECT\0" /* 13362 */
	"PA_SC_PERFCOUNTER7_SELECT\0" /* 13388 */
	"SPI_PERFCOUNTER0_SELECT\0" /* 13414 */
	"SPI_PERFCOUNTER1_SELECT\0" /* 13438 */
	"SPI_PERFCOUNTER2_SELECT\0" /* 13462 */
	"SPI_PERFCOUNTER3_SELECT\0" /* 13486 */
	"SPI_PERFCOUNTER0_SELECT1\0" /* 13510 */
	"SPI_PERFCOUNTER1_SELECT1\0" /* 13535 */
	"SPI_PERFCOUNTER2_SELECT1\0" /* 13560 */
	"SPI_PERFCOUNTER3_SELECT1\0" /* 13585 */
	"SPI_PERFCOUNTER4_SELECT\0" /* 13610 */
	"SPI_PERFCOUNTER5_SELECT\0" /* 13634 */
	"SPI_PERFCOUNTER_BINS\0" /* 13658 */
	"SQ_PERFCOUNTER0_SELECT\0" /* 13679 */
	"SQ_PERFCOUNTER1_SELECT\0" /* 13702 */
	"SQ_PERFCOUNTER2_SELECT\0" /* 13725 */
	"SQ_PERFCOUNTER3_SELECT\0" /* 13748 */
	"SQ_PERFCOUNTER4_SELECT\0" /* 13771 */
	"SQ_PERFCOUNTER5_SELECT\0" /* 13794 */
	"SQ_PERFCOUNTER6_SELECT\0" /* 13817 */
	"SQ_PERFCOUNTER7_SELECT\0" /* 13840 */
	"SQ_PERFCOUNTER8_SELECT\0" /* 13863 */
	"SQ_PERFCOUNTER9_SELECT\0" /* 13886 */
	"SQ_PERFCOUNTER10_SELECT\0" /* 13909 */
	"SQ_PERFCOUNTER11_SELECT\0" /* 13933 */
	"SQ_PERFCOUNTER12_SELECT\0" /* 13957 */
	"SQ_PERFCOUNTER13_SELECT\0" /* 13981 */
	"SQ_PERFCOUNTER14_SELECT\0" /* 14005 */
	"SQ_PERFCOUNTER15_SELECT\0" /* 14029 */
	"SQ_PERFCOUNTER_CTRL\0" /* 14053 */
	"SQ_PERFCOUNTER_MASK\0" /* 14073 */
	"SQ_PERFCOUNTER_CTRL2\0" /* 14093 */
	"SX_PERFCOUNTER0_SELECT\0" /* 14114 */
	"SX_PERFCOUNTER1_SELECT\0" /* 14137 */
	"SX_PERFCOUNTER2_SELECT\0" /* 14160 */
	"SX_PERFCOUNTER3_SELECT\0" /* 14183 */
	"SX_PERFCOUNTER0_SELECT1\0" /* 14206 */
	"SX_PERFCOUNTER1_SELECT1\0" /* 14230 */
	"GDS_PERFCOUNTER0_SELECT\0" /* 14254 */
	"GDS_PERFCOUNTER1_SELECT\0" /* 14278 */
	"GDS_PERFCOUNTER2_SELECT\0" /* 14302 */
	"GDS_PERFCOUNTER3_SELECT\0" /* 14326 */
	"GDS_PERFCOUNTER0_SELECT1\0" /* 14350 */
	"TA_PERFCOUNTER0_SELECT\0" /* 14375 */
	"TA_PERFCOUNTER0_SELECT1\0" /* 14398 */
	"TA_PERFCOUNTER1_SELECT\0" /* 14422 */
	"TD_PERFCOUNTER0_SELECT\0" /* 14445 */
	"TD_PERFCOUNTER0_SELECT1\0" /* 14468 */
	"TD_PERFCOUNTER1_SELECT\0" /* 14492 */
	"TCP_PERFCOUNTER0_SELECT\0" /* 14515 */
	"TCP_PERFCOUNTER0_SELECT1\0" /* 14539 */
	"TCP_PERFCOUNTER1_SELECT\0" /* 14564 */
	"TCP_PERFCOUNTER1_SELECT1\0" /* 14588 */
	"TCP_PERFCOUNTER2_SELECT\0" /* 14613 */
	"TCP_PERFCOUNTER3_SELECT\0" /* 14637 */
	"TCC_PERFCOUNTER0_SELECT\0" /* 14661 */
	"TCC_PERFCOUNTER0_SELECT1\0" /* 14685 */
	"TCC_PERFCOUNTER1_SELECT\0" /* 14710 */
	"TCC_PERFCOUNTER1_SELECT1\0" /* 14734 */
	"TCC_PERFCOUNTER2_SELECT\0" /* 14759 */
	"TCC_PERFCOUNTER3_SELECT\0" /* 14783 */
	"TCA_PERFCOUNTER0_SELECT\0" /* 14807 */
	"TCA_PERFCOUNTER0_SELECT1\0" /* 14831 */
	"TCA_PERFCOUNTER1_SELECT\0" /* 14856 */
	"TCA_PERFCOUNTER1_SELECT1\0" /* 14880 */
	"TCA_PERFCOUNTER2_SELECT\0" /* 14905 */
	"TCA_PERFCOUNTER3_SELECT\0" /* 14929 */
	"CB_PERFCOUNTER_FILTER\0" /* 14953 */
	"CB_PERFCOUNTER0_SELECT\0" /* 14975 */
	"CB_PERFCOUNTER0_SELECT1\0" /* 14998 */
	"CB_PERFCOUNTER1_SELECT\0" /* 15022 */
	"CB_PERFCOUNTER2_SELECT\0" /* 15045 */
	"CB_PERFCOUNTER3_SELECT\0" /* 15068 */
	"DB_PERFCOUNTER0_SELECT\0" /* 15091 */
	"DB_PERFCOUNTER0_SELECT1\0" /* 15114 */
	"DB_PERFCOUNTER1_SELECT\0" /* 15138 */
	"DB_PERFCOUNTER1_SELECT1\0" /* 15161 */
	"DB_PERFCOUNTER2_SELECT\0" /* 15185 */
	"DB_PERFCOUNTER3_SELECT\0" /* 15208 */
	"DB_RENDER_CONTROL\0" /* 15231 */
	"DB_COUNT_CONTROL\0" /* 15249 */
	"DB_DEPTH_VIEW\0" /* 15266 */
	"DB_RENDER_OVERRIDE\0" /* 15280, 15296 */
	"DB_RENDER_OVERRIDE2\0" /* 15299 */
	"DB_HTILE_DATA_BASE\0" /* 15319 */
	"DB_DEPTH_BOUNDS_MIN\0" /* 15338 */
	"DB_DEPTH_BOUNDS_MAX\0" /* 15358 */
	"DB_STENCIL_CLEAR\0" /* 15378, 15389 */
	"DB_DEPTH_CLEAR\0" /* 15395 */
	"PA_SC_SCREEN_SCISSOR_TL\0" /* 15410 */
	"PA_SC_SCREEN_SCISSOR_BR\0" /* 15434 */
	"DB_DEPTH_INFO\0" /* 15458 */
	"DB_Z_INFO\0" /* 15472 */
	"DB_STENCIL_INFO\0" /* 15482 */
	"DB_Z_READ_BASE\0" /* 15498 */
	"DB_STENCIL_READ_BASE\0" /* 15513 */
	"DB_Z_WRITE_BASE\0" /* 15534 */
	"DB_STENCIL_WRITE_BASE\0" /* 15550 */
	"DB_DEPTH_SIZE\0" /* 15572 */
	"DB_DEPTH_SLICE\0" /* 15586 */
	"TA_BC_BASE_ADDR\0" /* 15601 */
	"TA_BC_BASE_ADDR_HI\0" /* 15617 */
	"COHER_DEST_BASE_HI_0\0" /* 15636 */
	"COHER_DEST_BASE_HI_1\0" /* 15657 */
	"COHER_DEST_BASE_HI_2\0" /* 15678 */
	"COHER_DEST_BASE_HI_3\0" /* 15699 */
	"COHER_DEST_BASE_2\0" /* 15720 */
	"COHER_DEST_BASE_3\0" /* 15738 */
	"PA_SC_WINDOW_OFFSET\0" /* 15756, 15767 */
	"PA_SC_WINDOW_SCISSOR_TL\0" /* 15776 */
	"PA_SC_WINDOW_SCISSOR_BR\0" /* 15800 */
	"PA_SC_CLIPRECT_RULE\0" /* 15824 */
	"PA_SC_CLIPRECT_0_TL\0" /* 15844 */
	"PA_SC_CLIPRECT_0_BR\0" /* 15864 */
	"PA_SC_CLIPRECT_1_TL\0" /* 15884 */
	"PA_SC_CLIPRECT_1_BR\0" /* 15904 */
	"PA_SC_CLIPRECT_2_TL\0" /* 15924 */
	"PA_SC_CLIPRECT_2_BR\0" /* 15944 */
	"PA_SC_CLIPRECT_3_TL\0" /* 15964 */
	"PA_SC_CLIPRECT_3_BR\0" /* 15984 */
	"PA_SC_EDGERULE\0" /* 16004 */
	"PA_SU_HARDWARE_SCREEN_OFFSET\0" /* 16019 */
	"CB_TARGET_MASK\0" /* 16048 */
	"CB_SHADER_MASK\0" /* 16063 */
	"PA_SC_GENERIC_SCISSOR_TL\0" /* 16078 */
	"PA_SC_GENERIC_SCISSOR_BR\0" /* 16103 */
	"COHER_DEST_BASE_0\0" /* 16128 */
	"COHER_DEST_BASE_1\0" /* 16146 */
	"PA_SC_VPORT_SCISSOR_0_TL\0" /* 16164 */
	"PA_SC_VPORT_SCISSOR_0_BR\0" /* 16189 */
	"PA_SC_VPORT_SCISSOR_1_TL\0" /* 16214 */
	"PA_SC_VPORT_SCISSOR_1_BR\0" /* 16239 */
	"PA_SC_VPORT_SCISSOR_2_TL\0" /* 16264 */
	"PA_SC_VPORT_SCISSOR_2_BR\0" /* 16289 */
	"PA_SC_VPORT_SCISSOR_3_TL\0" /* 16314 */
	"PA_SC_VPORT_SCISSOR_3_BR\0" /* 16339 */
	"PA_SC_VPORT_SCISSOR_4_TL\0" /* 16364 */
	"PA_SC_VPORT_SCISSOR_4_BR\0" /* 16389 */
	"PA_SC_VPORT_SCISSOR_5_TL\0" /* 16414 */
	"PA_SC_VPORT_SCISSOR_5_BR\0" /* 16439 */
	"PA_SC_VPORT_SCISSOR_6_TL\0" /* 16464 */
	"PA_SC_VPORT_SCISSOR_6_BR\0" /* 16489 */
	"PA_SC_VPORT_SCISSOR_7_TL\0" /* 16514 */
	"PA_SC_VPORT_SCISSOR_7_BR\0" /* 16539 */
	"PA_SC_VPORT_SCISSOR_8_TL\0" /* 16564 */
	"PA_SC_VPORT_SCISSOR_8_BR\0" /* 16589 */
	"PA_SC_VPORT_SCISSOR_9_TL\0" /* 16614 */
	"PA_SC_VPORT_SCISSOR_9_BR\0" /* 16639 */
	"PA_SC_VPORT_SCISSOR_10_TL\0" /* 16664 */
	"PA_SC_VPORT_SCISSOR_10_BR\0" /* 16690 */
	"PA_SC_VPORT_SCISSOR_11_TL\0" /* 16716 */
	"PA_SC_VPORT_SCISSOR_11_BR\0" /* 16742 */
	"PA_SC_VPORT_SCISSOR_12_TL\0" /* 16768 */
	"PA_SC_VPORT_SCISSOR_12_BR\0" /* 16794 */
	"PA_SC_VPORT_SCISSOR_13_TL\0" /* 16820 */
	"PA_SC_VPORT_SCISSOR_13_BR\0" /* 16846 */
	"PA_SC_VPORT_SCISSOR_14_TL\0" /* 16872 */
	"PA_SC_VPORT_SCISSOR_14_BR\0" /* 16898 */
	"PA_SC_VPORT_SCISSOR_15_TL\0" /* 16924 */
	"PA_SC_VPORT_SCISSOR_15_BR\0" /* 16950 */
	"PA_SC_VPORT_ZMIN_0\0" /* 16976 */
	"PA_SC_VPORT_ZMAX_0\0" /* 16995 */
	"PA_SC_VPORT_ZMIN_1\0" /* 17014 */
	"PA_SC_VPORT_ZMAX_1\0" /* 17033 */
	"PA_SC_VPORT_ZMIN_2\0" /* 17052 */
	"PA_SC_VPORT_ZMAX_2\0" /* 17071 */
	"PA_SC_VPORT_ZMIN_3\0" /* 17090 */
	"PA_SC_VPORT_ZMAX_3\0" /* 17109 */
	"PA_SC_VPORT_ZMIN_4\0" /* 17128 */
	"PA_SC_VPORT_ZMAX_4\0" /* 17147 */
	"PA_SC_VPORT_ZMIN_5\0" /* 17166 */
	"PA_SC_VPORT_ZMAX_5\0" /* 17185 */
	"PA_SC_VPORT_ZMIN_6\0" /* 17204 */
	"PA_SC_VPORT_ZMAX_6\0" /* 17223 */
	"PA_SC_VPORT_ZMIN_7\0" /* 17242 */
	"PA_SC_VPORT_ZMAX_7\0" /* 17261 */
	"PA_SC_VPORT_ZMIN_8\0" /* 17280 */
	"PA_SC_VPORT_ZMAX_8\0" /* 17299 */
	"PA_SC_VPORT_ZMIN_9\0" /* 17318 */
	"PA_SC_VPORT_ZMAX_9\0" /* 17337 */
	"PA_SC_VPORT_ZMIN_10\0" /* 17356 */
	"PA_SC_VPORT_ZMAX_10\0" /* 17376 */
	"PA_SC_VPORT_ZMIN_11\0" /* 17396 */
	"PA_SC_VPORT_ZMAX_11\0" /* 17416 */
	"PA_SC_VPORT_ZMIN_12\0" /* 17436 */
	"PA_SC_VPORT_ZMAX_12\0" /* 17456 */
	"PA_SC_VPORT_ZMIN_13\0" /* 17476 */
	"PA_SC_VPORT_ZMAX_13\0" /* 17496 */
	"PA_SC_VPORT_ZMIN_14\0" /* 17516 */
	"PA_SC_VPORT_ZMAX_14\0" /* 17536 */
	"PA_SC_VPORT_ZMIN_15\0" /* 17556 */
	"PA_SC_VPORT_ZMAX_15\0" /* 17576 */
	"PA_SC_RASTER_CONFIG\0" /* 17596 */
	"PA_SC_RASTER_CONFIG_1\0" /* 17616 */
	"PA_SC_SCREEN_EXTENT_CONTROL\0" /* 17638 */
	"VGT_MAX_VTX_INDX\0" /* 17666 */
	"VGT_MIN_VTX_INDX\0" /* 17683 */
	"VGT_INDX_OFFSET\0" /* 17707, 17700 */
	"VGT_MULTI_PRIM_IB_RESET_INDX\0" /* 17716 */
	"CB_BLEND_RED\0" /* 17745 */
	"CB_BLEND_GREEN\0" /* 17758 */
	"CB_BLEND_BLUE\0" /* 17773 */
	"CB_BLEND_ALPHA\0" /* 17787 */
	"CB_DCC_CONTROL\0" /* 17802 */
	"DB_STENCIL_CONTROL\0" /* 17817 */
	"DB_STENCILREFMASK\0" /* 17836 */
	"DB_STENCILREFMASK_BF\0" /* 17854 */
	"PA_CL_VPORT_XSCALE\0" /* 17875 */
	"PA_CL_VPORT_XOFFSET\0" /* 17894 */
	"PA_CL_VPORT_YSCALE\0" /* 17914 */
	"PA_CL_VPORT_YOFFSET\0" /* 17933 */
	"PA_CL_VPORT_ZSCALE\0" /* 17953 */
	"PA_CL_VPORT_ZOFFSET\0" /* 17972 */
	"PA_CL_VPORT_XSCALE_1\0" /* 17992 */
	"PA_CL_VPORT_XOFFSET_1\0" /* 18013 */
	"PA_CL_VPORT_YSCALE_1\0" /* 18035 */
	"PA_CL_VPORT_YOFFSET_1\0" /* 18056 */
	"PA_CL_VPORT_ZSCALE_1\0" /* 18078 */
	"PA_CL_VPORT_ZOFFSET_1\0" /* 18099 */
	"PA_CL_VPORT_XSCALE_2\0" /* 18121 */
	"PA_CL_VPORT_XOFFSET_2\0" /* 18142 */
	"PA_CL_VPORT_YSCALE_2\0" /* 18164 */
	"PA_CL_VPORT_YOFFSET_2\0" /* 18185 */
	"PA_CL_VPORT_ZSCALE_2\0" /* 18207 */
	"PA_CL_VPORT_ZOFFSET_2\0" /* 18228 */
	"PA_CL_VPORT_XSCALE_3\0" /* 18250 */
	"PA_CL_VPORT_XOFFSET_3\0" /* 18271 */
	"PA_CL_VPORT_YSCALE_3\0" /* 18293 */
	"PA_CL_VPORT_YOFFSET_3\0" /* 18314 */
	"PA_CL_VPORT_ZSCALE_3\0" /* 18336 */
	"PA_CL_VPORT_ZOFFSET_3\0" /* 18357 */
	"PA_CL_VPORT_XSCALE_4\0" /* 18379 */
	"PA_CL_VPORT_XOFFSET_4\0" /* 18400 */
	"PA_CL_VPORT_YSCALE_4\0" /* 18422 */
	"PA_CL_VPORT_YOFFSET_4\0" /* 18443 */
	"PA_CL_VPORT_ZSCALE_4\0" /* 18465 */
	"PA_CL_VPORT_ZOFFSET_4\0" /* 18486 */
	"PA_CL_VPORT_XSCALE_5\0" /* 18508 */
	"PA_CL_VPORT_XOFFSET_5\0" /* 18529 */
	"PA_CL_VPORT_YSCALE_5\0" /* 18551 */
	"PA_CL_VPORT_YOFFSET_5\0" /* 18572 */
	"PA_CL_VPORT_ZSCALE_5\0" /* 18594 */
	"PA_CL_VPORT_ZOFFSET_5\0" /* 18615 */
	"PA_CL_VPORT_XSCALE_6\0" /* 18637 */
	"PA_CL_VPORT_XOFFSET_6\0" /* 18658 */
	"PA_CL_VPORT_YSCALE_6\0" /* 18680 */
	"PA_CL_VPORT_YOFFSET_6\0" /* 18701 */
	"PA_CL_VPORT_ZSCALE_6\0" /* 18723 */
	"PA_CL_VPORT_ZOFFSET_6\0" /* 18744 */
	"PA_CL_VPORT_XSCALE_7\0" /* 18766 */
	"PA_CL_VPORT_XOFFSET_7\0" /* 18787 */
	"PA_CL_VPORT_YSCALE_7\0" /* 18809 */
	"PA_CL_VPORT_YOFFSET_7\0" /* 18830 */
	"PA_CL_VPORT_ZSCALE_7\0" /* 18852 */
	"PA_CL_VPORT_ZOFFSET_7\0" /* 18873 */
	"PA_CL_VPORT_XSCALE_8\0" /* 18895 */
	"PA_CL_VPORT_XOFFSET_8\0" /* 18916 */
	"PA_CL_VPORT_YSCALE_8\0" /* 18938 */
	"PA_CL_VPORT_YOFFSET_8\0" /* 18959 */
	"PA_CL_VPORT_ZSCALE_8\0" /* 18981 */
	"PA_CL_VPORT_ZOFFSET_8\0" /* 19002 */
	"PA_CL_VPORT_XSCALE_9\0" /* 19024 */
	"PA_CL_VPORT_XOFFSET_9\0" /* 19045 */
	"PA_CL_VPORT_YSCALE_9\0" /* 19067 */
	"PA_CL_VPORT_YOFFSET_9\0" /* 19088 */
	"PA_CL_VPORT_ZSCALE_9\0" /* 19110 */
	"PA_CL_VPORT_ZOFFSET_9\0" /* 19131 */
	"PA_CL_VPORT_XSCALE_10\0" /* 19153 */
	"PA_CL_VPORT_XOFFSET_10\0" /* 19175 */
	"PA_CL_VPORT_YSCALE_10\0" /* 19198 */
	"PA_CL_VPORT_YOFFSET_10\0" /* 19220 */
	"PA_CL_VPORT_ZSCALE_10\0" /* 19243 */
	"PA_CL_VPORT_ZOFFSET_10\0" /* 19265 */
	"PA_CL_VPORT_XSCALE_11\0" /* 19288 */
	"PA_CL_VPORT_XOFFSET_11\0" /* 19310 */
	"PA_CL_VPORT_YSCALE_11\0" /* 19333 */
	"PA_CL_VPORT_YOFFSET_11\0" /* 19355 */
	"PA_CL_VPORT_ZSCALE_11\0" /* 19378 */
	"PA_CL_VPORT_ZOFFSET_11\0" /* 19400 */
	"PA_CL_VPORT_XSCALE_12\0" /* 19423 */
	"PA_CL_VPORT_XOFFSET_12\0" /* 19445 */
	"PA_CL_VPORT_YSCALE_12\0" /* 19468 */
	"PA_CL_VPORT_YOFFSET_12\0" /* 19490 */
	"PA_CL_VPORT_ZSCALE_12\0" /* 19513 */
	"PA_CL_VPORT_ZOFFSET_12\0" /* 19535 */
	"PA_CL_VPORT_XSCALE_13\0" /* 19558 */
	"PA_CL_VPORT_XOFFSET_13\0" /* 19580 */
	"PA_CL_VPORT_YSCALE_13\0" /* 19603 */
	"PA_CL_VPORT_YOFFSET_13\0" /* 19625 */
	"PA_CL_VPORT_ZSCALE_13\0" /* 19648 */
	"PA_CL_VPORT_ZOFFSET_13\0" /* 19670 */
	"PA_CL_VPORT_XSCALE_14\0" /* 19693 */
	"PA_CL_VPORT_XOFFSET_14\0" /* 19715 */
	"PA_CL_VPORT_YSCALE_14\0" /* 19738 */
	"PA_CL_VPORT_YOFFSET_14\0" /* 19760 */
	"PA_CL_VPORT_ZSCALE_14\0" /* 19783 */
	"PA_CL_VPORT_ZOFFSET_14\0" /* 19805 */
	"PA_CL_VPORT_XSCALE_15\0" /* 19828 */
	"PA_CL_VPORT_XOFFSET_15\0" /* 19850 */
	"PA_CL_VPORT_YSCALE_15\0" /* 19873 */
	"PA_CL_VPORT_YOFFSET_15\0" /* 19895 */
	"PA_CL_VPORT_ZSCALE_15\0" /* 19918 */
	"PA_CL_VPORT_ZOFFSET_15\0" /* 19940 */
	"PA_CL_UCP_0_X\0" /* 19963 */
	"PA_CL_UCP_0_Y\0" /* 19977 */
	"PA_CL_UCP_0_Z\0" /* 19991 */
	"PA_CL_UCP_0_W\0" /* 20005 */
	"PA_CL_UCP_1_X\0" /* 20019 */
	"PA_CL_UCP_1_Y\0" /* 20033 */
	"PA_CL_UCP_1_Z\0" /* 20047 */
	"PA_CL_UCP_1_W\0" /* 20061 */
	"PA_CL_UCP_2_X\0" /* 20075 */
	"PA_CL_UCP_2_Y\0" /* 20089 */
	"PA_CL_UCP_2_Z\0" /* 20103 */
	"PA_CL_UCP_2_W\0" /* 20117 */
	"PA_CL_UCP_3_X\0" /* 20131 */
	"PA_CL_UCP_3_Y\0" /* 20145 */
	"PA_CL_UCP_3_Z\0" /* 20159 */
	"PA_CL_UCP_3_W\0" /* 20173 */
	"PA_CL_UCP_4_X\0" /* 20187 */
	"PA_CL_UCP_4_Y\0" /* 20201 */
	"PA_CL_UCP_4_Z\0" /* 20215 */
	"PA_CL_UCP_4_W\0" /* 20229 */
	"PA_CL_UCP_5_X\0" /* 20243 */
	"PA_CL_UCP_5_Y\0" /* 20257 */
	"PA_CL_UCP_5_Z\0" /* 20271 */
	"PA_CL_UCP_5_W\0" /* 20285 */
	"SPI_PS_INPUT_CNTL_0\0" /* 20299 */
	"SPI_PS_INPUT_CNTL_1\0" /* 20319 */
	"SPI_PS_INPUT_CNTL_2\0" /* 20339 */
	"SPI_PS_INPUT_CNTL_3\0" /* 20359 */
	"SPI_PS_INPUT_CNTL_4\0" /* 20379 */
	"SPI_PS_INPUT_CNTL_5\0" /* 20399 */
	"SPI_PS_INPUT_CNTL_6\0" /* 20419 */
	"SPI_PS_INPUT_CNTL_7\0" /* 20439 */
	"SPI_PS_INPUT_CNTL_8\0" /* 20459 */
	"SPI_PS_INPUT_CNTL_9\0" /* 20479 */
	"SPI_PS_INPUT_CNTL_10\0" /* 20499 */
	"SPI_PS_INPUT_CNTL_11\0" /* 20520 */
	"SPI_PS_INPUT_CNTL_12\0" /* 20541 */
	"SPI_PS_INPUT_CNTL_13\0" /* 20562 */
	"SPI_PS_INPUT_CNTL_14\0" /* 20583 */
	"SPI_PS_INPUT_CNTL_15\0" /* 20604 */
	"SPI_PS_INPUT_CNTL_16\0" /* 20625 */
	"SPI_PS_INPUT_CNTL_17\0" /* 20646 */
	"SPI_PS_INPUT_CNTL_18\0" /* 20667 */
	"SPI_PS_INPUT_CNTL_19\0" /* 20688 */
	"SPI_PS_INPUT_CNTL_20\0" /* 20709 */
	"SPI_PS_INPUT_CNTL_21\0" /* 20730 */
	"SPI_PS_INPUT_CNTL_22\0" /* 20751 */
	"SPI_PS_INPUT_CNTL_23\0" /* 20772 */
	"SPI_PS_INPUT_CNTL_24\0" /* 20793 */
	"SPI_PS_INPUT_CNTL_25\0" /* 20814 */
	"SPI_PS_INPUT_CNTL_26\0" /* 20835 */
	"SPI_PS_INPUT_CNTL_27\0" /* 20856 */
	"SPI_PS_INPUT_CNTL_28\0" /* 20877 */
	"SPI_PS_INPUT_CNTL_29\0" /* 20898 */
	"SPI_PS_INPUT_CNTL_30\0" /* 20919 */
	"SPI_PS_INPUT_CNTL_31\0" /* 20940 */
	"SPI_VS_OUT_CONFIG\0" /* 20961 */
	"SPI_PS_INPUT_ENA\0" /* 20979 */
	"SPI_PS_INPUT_ADDR\0" /* 20996 */
	"SPI_INTERP_CONTROL_0\0" /* 21014 */
	"SPI_PS_IN_CONTROL\0" /* 21035 */
	"SPI_BARYC_CNTL\0" /* 21053 */
	"SPI_TMPRING_SIZE\0" /* 21068 */
	"SPI_WAVE_MGMT_1\0" /* 21085 */
	"SPI_WAVE_MGMT_2\0" /* 21101 */
	"SPI_SHADER_POS_FORMAT\0" /* 21132, 21117 */
	"SPI_SHADER_Z_FORMAT\0" /* 21139 */
	"SPI_SHADER_COL_FORMAT\0" /* 21159 */
	"SX_PS_DOWNCONVERT\0" /* 21181 */
	"SX_BLEND_OPT_EPSILON\0" /* 21199 */
	"SX_BLEND_OPT_CONTROL\0" /* 21220 */
	"SX_MRT0_BLEND_OPT\0" /* 21241 */
	"SX_MRT1_BLEND_OPT\0" /* 21259 */
	"SX_MRT2_BLEND_OPT\0" /* 21277 */
	"SX_MRT3_BLEND_OPT\0" /* 21295 */
	"SX_MRT4_BLEND_OPT\0" /* 21313 */
	"SX_MRT5_BLEND_OPT\0" /* 21331 */
	"SX_MRT6_BLEND_OPT\0" /* 21349 */
	"SX_MRT7_BLEND_OPT\0" /* 21367 */
	"CB_BLEND0_CONTROL\0" /* 21385 */
	"CB_BLEND1_CONTROL\0" /* 21403 */
	"CB_BLEND2_CONTROL\0" /* 21421 */
	"CB_BLEND3_CONTROL\0" /* 21439 */
	"CB_BLEND4_CONTROL\0" /* 21457 */
	"CB_BLEND5_CONTROL\0" /* 21475 */
	"CB_BLEND6_CONTROL\0" /* 21493 */
	"CB_BLEND7_CONTROL\0" /* 21511 */
	"CS_COPY_STATE\0" /* 21529 */
	"PA_CL_POINT_X_RAD\0" /* 21543 */
	"PA_CL_POINT_Y_RAD\0" /* 21561 */
	"PA_CL_POINT_SIZE\0" /* 21579 */
	"PA_CL_POINT_CULL_RAD\0" /* 21596 */
	"VGT_DMA_BASE_HI\0" /* 21617 */
	"VGT_DMA_BASE\0" /* 21633 */
	"VGT_DRAW_INITIATOR\0" /* 21646 */
	"VGT_IMMED_DATA\0" /* 21665 */
	"VGT_EVENT_ADDRESS_REG\0" /* 21680 */
	"DB_DEPTH_CONTROL\0" /* 21702 */
	"DB_EQAA\0" /* 21719 */
	"CB_COLOR_CONTROL\0" /* 21727 */
	"DB_SHADER_CONTROL\0" /* 21744 */
	"PA_CL_CLIP_CNTL\0" /* 21762 */
	"PA_SU_SC_MODE_CNTL\0" /* 21778 */
	"PA_CL_VTE_CNTL\0" /* 21797 */
	"PA_CL_VS_OUT_CNTL\0" /* 21812 */
	"PA_CL_NANINF_CNTL\0" /* 21830 */
	"PA_SU_LINE_STIPPLE_CNTL\0" /* 21848 */
	"PA_SU_LINE_STIPPLE_SCALE\0" /* 21872 */
	"PA_SU_PRIM_FILTER_CNTL\0" /* 21897 */
	"PA_SU_SMALL_PRIM_FILTER_CNTL\0" /* 21920 */
	"PA_SU_POINT_SIZE\0" /* 21949 */
	"PA_SU_POINT_MINMAX\0" /* 21966 */
	"PA_SU_LINE_CNTL\0" /* 21985 */
	"PA_SC_LINE_STIPPLE\0" /* 22001 */
	"VGT_OUTPUT_PATH_CNTL\0" /* 22020 */
	"VGT_HOS_CNTL\0" /* 22041 */
	"VGT_HOS_MAX_TESS_LEVEL\0" /* 22054 */
	"VGT_HOS_MIN_TESS_LEVEL\0" /* 22077 */
	"VGT_HOS_REUSE_DEPTH\0" /* 22108, 22114, 22100 */
	"VGT_GROUP_PRIM_TYPE\0" /* 22120, 22130 */
	"VGT_GROUP_FIRST_DECR\0" /* 22156, 22140, 22150 */
	"VGT_GROUP_DECR\0" /* 22161 */
	"VGT_GROUP_VECT_0_CNTL\0" /* 22176 */
	"VGT_GROUP_VECT_1_CNTL\0" /* 22198 */
	"VGT_GROUP_VECT_0_FMT_CNTL\0" /* 22220 */
	"VGT_GROUP_VECT_1_FMT_CNTL\0" /* 22246 */
	"VGT_GS_MODE\0" /* 22272, 22279 */
	"VGT_GS_ONCHIP_CNTL\0" /* 22284 */
	"PA_SC_MODE_CNTL_0\0" /* 22303 */
	"PA_SC_MODE_CNTL_1\0" /* 22321 */
	"VGT_ENHANCE\0" /* 22339 */
	"VGT_GS_PER_ES\0" /* 22355, 22351 */
	"VGT_ES_PER_GS\0" /* 22369, 22365 */
	"VGT_GS_PER_VS\0" /* 22379, 22383 */
	"VGT_GSVS_RING_OFFSET_1\0" /* 22393 */
	"VGT_GSVS_RING_OFFSET_2\0" /* 22416 */
	"VGT_GSVS_RING_OFFSET_3\0" /* 22439 */
	"VGT_GS_OUT_PRIM_TYPE\0" /* 22462 */
	"IA_ENHANCE\0" /* 22483 */
	"VGT_DMA_SIZE\0" /* 22494 */
	"VGT_DMA_MAX_SIZE\0" /* 22507, 22515 */
	"VGT_DMA_INDEX_TYPE\0" /* 22524 */
	"WD_ENHANCE\0" /* 22543 */
	"VGT_PRIMITIVEID_EN\0" /* 22554, 22558 */
	"VGT_DMA_NUM_INSTANCES\0" /* 22573 */
	"VGT_PRIMITIVEID_RESET\0" /* 22595 */
	"VGT_EVENT_INITIATOR\0" /* 22617 */
	"VGT_MULTI_PRIM_IB_RESET_EN\0" /* 22637, 22655 */
	"VGT_INSTANCE_STEP_RATE_0\0" /* 22664 */
	"VGT_INSTANCE_STEP_RATE_1\0" /* 22689 */
	"IA_MULTI_VGT_PARAM\0" /* 22714 */
	"VGT_ESGS_RING_ITEMSIZE\0" /* 22747, 22733 */
	"VGT_GSVS_RING_ITEMSIZE\0" /* 22756 */
	"VGT_REUSE_OFF\0" /* 22779, 22783 */
	"VGT_VTX_CNT_EN\0" /* 22793, 22797 */
	"DB_HTILE_SURFACE\0" /* 22808, 22820 */
	"DB_SRESULTS_COMPARE_STATE0\0" /* 22825 */
	"DB_SRESULTS_COMPARE_STATE1\0" /* 22852 */
	"DB_PRELOAD_CONTROL\0" /* 22879 */
	"VGT_STRMOUT_BUFFER_SIZE_0\0" /* 22898 */
	"VGT_STRMOUT_VTX_STRIDE_0\0" /* 22924 */
	"VGT_STRMOUT_BUFFER_OFFSET_0\0" /* 22949 */
	"VGT_STRMOUT_BUFFER_SIZE_1\0" /* 22977 */
	"VGT_STRMOUT_VTX_STRIDE_1\0" /* 23003 */
	"VGT_STRMOUT_BUFFER_OFFSET_1\0" /* 23028 */
	"VGT_STRMOUT_BUFFER_SIZE_2\0" /* 23056 */
	"VGT_STRMOUT_VTX_STRIDE_2\0" /* 23082 */
	"VGT_STRMOUT_BUFFER_OFFSET_2\0" /* 23107 */
	"VGT_STRMOUT_BUFFER_SIZE_3\0" /* 23135 */
	"VGT_STRMOUT_VTX_STRIDE_3\0" /* 23161 */
	"VGT_STRMOUT_BUFFER_OFFSET_3\0" /* 23186 */
	"VGT_STRMOUT_DRAW_OPAQUE_OFFSET\0" /* 23214 */
	"VGT_STRMOUT_DRAW_OPAQUE_BUFFER_FILLED_SIZE\0" /* 23245 */
	"VGT_STRMOUT_DRAW_OPAQUE_VERTEX_STRIDE\0" /* 23288, 23312, 23319 */
	"VGT_GS_MAX_VERT_OUT\0" /* 23333, 23326 */
	"VGT_TESS_DISTRIBUTION\0" /* 23346 */
	"VGT_SHADER_STAGES_EN\0" /* 23368, 23383 */
	"VGT_LS_HS_CONFIG\0" /* 23389 */
	"VGT_GS_VERT_ITEMSIZE\0" /* 23406 */
	"VGT_GS_VERT_ITEMSIZE_1\0" /* 23427 */
	"VGT_GS_VERT_ITEMSIZE_2\0" /* 23450 */
	"VGT_GS_VERT_ITEMSIZE_3\0" /* 23473 */
	"VGT_TF_PARAM\0" /* 23496 */
	"DB_ALPHA_TO_MASK\0" /* 23509 */
	"VGT_DISPATCH_DRAW_INDEX\0" /* 23526 */
	"PA_SU_POLY_OFFSET_DB_FMT_CNTL\0" /* 23550 */
	"PA_SU_POLY_OFFSET_CLAMP\0" /* 23580 */
	"PA_SU_POLY_OFFSET_FRONT_SCALE\0" /* 23604 */
	"PA_SU_POLY_OFFSET_FRONT_OFFSET\0" /* 23634 */
	"PA_SU_POLY_OFFSET_BACK_SCALE\0" /* 23665 */
	"PA_SU_POLY_OFFSET_BACK_OFFSET\0" /* 23694 */
	"VGT_GS_INSTANCE_CNT\0" /* 23740, 23724 */
	"VGT_STRMOUT_CONFIG\0" /* 23744 */
	"VGT_STRMOUT_BUFFER_CONFIG\0" /* 23763 */
	"PA_SC_CENTROID_PRIORITY_0\0" /* 23789 */
	"PA_SC_CENTROID_PRIORITY_1\0" /* 23815 */
	"PA_SC_LINE_CNTL\0" /* 23841 */
	"PA_SC_AA_CONFIG\0" /* 23857 */
	"PA_SU_VTX_CNTL\0" /* 23873 */
	"PA_CL_GB_VERT_CLIP_ADJ\0" /* 23888 */
	"PA_CL_GB_VERT_DISC_ADJ\0" /* 23911 */
	"PA_CL_GB_HORZ_CLIP_ADJ\0" /* 23934 */
	"PA_CL_GB_HORZ_DISC_ADJ\0" /* 23957 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_0\0" /* 23980 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_1\0" /* 24014 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_2\0" /* 24048 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_3\0" /* 24082 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_0\0" /* 24116 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_1\0" /* 24150 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_2\0" /* 24184 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_3\0" /* 24218 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_0\0" /* 24252 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_1\0" /* 24286 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_2\0" /* 24320 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_3\0" /* 24354 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_0\0" /* 24388 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_1\0" /* 24422 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_2\0" /* 24456 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_3\0" /* 24490 */
	"PA_SC_AA_MASK_X0Y0_X1Y0\0" /* 24524 */
	"PA_SC_AA_MASK_X0Y1_X1Y1\0" /* 24548 */
	"PA_SC_SHADER_CONTROL\0" /* 24572 */
	"VGT_VERTEX_REUSE_BLOCK_CNTL\0" /* 24593 */
	"VGT_OUT_DEALLOC_CNTL\0" /* 24621 */
	"CB_COLOR0_BASE\0" /* 24642 */
	"CB_COLOR0_PITCH\0" /* 24657 */
	"CB_COLOR0_SLICE\0" /* 24673 */
	"CB_COLOR0_VIEW\0" /* 24689 */
	"CB_COLOR0_INFO\0" /* 24704 */
	"CB_COLOR0_ATTRIB\0" /* 24719 */
	"CB_COLOR0_DCC_CONTROL\0" /* 24736 */
	"CB_COLOR0_CMASK\0" /* 24758 */
	"CB_COLOR0_CMASK_SLICE\0" /* 24774 */
	"CB_COLOR0_FMASK\0" /* 24796 */
	"CB_COLOR0_FMASK_SLICE\0" /* 24812 */
	"CB_COLOR0_CLEAR_WORD0\0" /* 24834 */
	"CB_COLOR0_CLEAR_WORD1\0" /* 24856 */
	"CB_COLOR0_DCC_BASE\0" /* 24878 */
	"CB_COLOR1_BASE\0" /* 24897 */
	"CB_COLOR1_PITCH\0" /* 24912 */
	"CB_COLOR1_SLICE\0" /* 24928 */
	"CB_COLOR1_VIEW\0" /* 24944 */
	"CB_COLOR1_INFO\0" /* 24959 */
	"CB_COLOR1_ATTRIB\0" /* 24974 */
	"CB_COLOR1_DCC_CONTROL\0" /* 24991 */
	"CB_COLOR1_CMASK\0" /* 25013 */
	"CB_COLOR1_CMASK_SLICE\0" /* 25029 */
	"CB_COLOR1_FMASK\0" /* 25051 */
	"CB_COLOR1_FMASK_SLICE\0" /* 25067 */
	"CB_COLOR1_CLEAR_WORD0\0" /* 25089 */
	"CB_COLOR1_CLEAR_WORD1\0" /* 25111 */
	"CB_COLOR1_DCC_BASE\0" /* 25133 */
	"CB_COLOR2_BASE\0" /* 25152 */
	"CB_COLOR2_PITCH\0" /* 25167 */
	"CB_COLOR2_SLICE\0" /* 25183 */
	"CB_COLOR2_VIEW\0" /* 25199 */
	"CB_COLOR2_INFO\0" /* 25214 */
	"CB_COLOR2_ATTRIB\0" /* 25229 */
	"CB_COLOR2_DCC_CONTROL\0" /* 25246 */
	"CB_COLOR2_CMASK\0" /* 25268 */
	"CB_COLOR2_CMASK_SLICE\0" /* 25284 */
	"CB_COLOR2_FMASK\0" /* 25306 */
	"CB_COLOR2_FMASK_SLICE\0" /* 25322 */
	"CB_COLOR2_CLEAR_WORD0\0" /* 25344 */
	"CB_COLOR2_CLEAR_WORD1\0" /* 25366 */
	"CB_COLOR2_DCC_BASE\0" /* 25388 */
	"CB_COLOR3_BASE\0" /* 25407 */
	"CB_COLOR3_PITCH\0" /* 25422 */
	"CB_COLOR3_SLICE\0" /* 25438 */
	"CB_COLOR3_VIEW\0" /* 25454 */
	"CB_COLOR3_INFO\0" /* 25469 */
	"CB_COLOR3_ATTRIB\0" /* 25484 */
	"CB_COLOR3_DCC_CONTROL\0" /* 25501 */
	"CB_COLOR3_CMASK\0" /* 25523 */
	"CB_COLOR3_CMASK_SLICE\0" /* 25539 */
	"CB_COLOR3_FMASK\0" /* 25561 */
	"CB_COLOR3_FMASK_SLICE\0" /* 25577 */
	"CB_COLOR3_CLEAR_WORD0\0" /* 25599 */
	"CB_COLOR3_CLEAR_WORD1\0" /* 25621 */
	"CB_COLOR3_DCC_BASE\0" /* 25643 */
	"CB_COLOR4_BASE\0" /* 25662 */
	"CB_COLOR4_PITCH\0" /* 25677 */
	"CB_COLOR4_SLICE\0" /* 25693 */
	"CB_COLOR4_VIEW\0" /* 25709 */
	"CB_COLOR4_INFO\0" /* 25724 */
	"CB_COLOR4_ATTRIB\0" /* 25739 */
	"CB_COLOR4_DCC_CONTROL\0" /* 25756 */
	"CB_COLOR4_CMASK\0" /* 25778 */
	"CB_COLOR4_CMASK_SLICE\0" /* 25794 */
	"CB_COLOR4_FMASK\0" /* 25816 */
	"CB_COLOR4_FMASK_SLICE\0" /* 25832 */
	"CB_COLOR4_CLEAR_WORD0\0" /* 25854 */
	"CB_COLOR4_CLEAR_WORD1\0" /* 25876 */
	"CB_COLOR4_DCC_BASE\0" /* 25898 */
	"CB_COLOR5_BASE\0" /* 25917 */
	"CB_COLOR5_PITCH\0" /* 25932 */
	"CB_COLOR5_SLICE\0" /* 25948 */
	"CB_COLOR5_VIEW\0" /* 25964 */
	"CB_COLOR5_INFO\0" /* 25979 */
	"CB_COLOR5_ATTRIB\0" /* 25994 */
	"CB_COLOR5_DCC_CONTROL\0" /* 26011 */
	"CB_COLOR5_CMASK\0" /* 26033 */
	"CB_COLOR5_CMASK_SLICE\0" /* 26049 */
	"CB_COLOR5_FMASK\0" /* 26071 */
	"CB_COLOR5_FMASK_SLICE\0" /* 26087 */
	"CB_COLOR5_CLEAR_WORD0\0" /* 26109 */
	"CB_COLOR5_CLEAR_WORD1\0" /* 26131 */
	"CB_COLOR5_DCC_BASE\0" /* 26153 */
	"CB_COLOR6_BASE\0" /* 26172 */
	"CB_COLOR6_PITCH\0" /* 26187 */
	"CB_COLOR6_SLICE\0" /* 26203 */
	"CB_COLOR6_VIEW\0" /* 26219 */
	"CB_COLOR6_INFO\0" /* 26234 */
	"CB_COLOR6_ATTRIB\0" /* 26249 */
	"CB_COLOR6_DCC_CONTROL\0" /* 26266 */
	"CB_COLOR6_CMASK\0" /* 26288 */
	"CB_COLOR6_CMASK_SLICE\0" /* 26304 */
	"CB_COLOR6_FMASK\0" /* 26326 */
	"CB_COLOR6_FMASK_SLICE\0" /* 26342 */
	"CB_COLOR6_CLEAR_WORD0\0" /* 26364 */
	"CB_COLOR6_CLEAR_WORD1\0" /* 26386 */
	"CB_COLOR6_DCC_BASE\0" /* 26408 */
	"CB_COLOR7_BASE\0" /* 26427 */
	"CB_COLOR7_PITCH\0" /* 26442 */
	"CB_COLOR7_SLICE\0" /* 26458 */
	"CB_COLOR7_VIEW\0" /* 26474 */
	"CB_COLOR7_INFO\0" /* 26489 */
	"CB_COLOR7_ATTRIB\0" /* 26504 */
	"CB_COLOR7_DCC_CONTROL\0" /* 26521 */
	"CB_COLOR7_CMASK\0" /* 26543 */
	"CB_COLOR7_CMASK_SLICE\0" /* 26559 */
	"CB_COLOR7_FMASK\0" /* 26581 */
	"CB_COLOR7_FMASK_SLICE\0" /* 26597 */
	"CB_COLOR7_CLEAR_WORD0\0" /* 26619 */
	"CB_COLOR7_CLEAR_WORD1\0" /* 26641 */
	"CB_COLOR7_DCC_BASE\0" /* 26663 */
	"VGT_TF_MEMORY_BASE_HI\0" /* 26682 */
	"WD_POS_BUF_BASE\0" /* 26704 */
	"WD_POS_BUF_BASE_HI\0" /* 26720 */
	"WD_CNTL_SB_BUF_BASE\0" /* 26739 */
	"WD_CNTL_SB_BUF_BASE_HI\0" /* 26759 */
	"WD_INDEX_BUF_BASE\0" /* 26782 */
	"WD_INDEX_BUF_BASE_HI\0" /* 26800 */
	"VGT_OBJECT_ID\0" /* 26821 */
	"VGT_INSTANCE_BASE_ID\0" /* 26835 */
	"SQC_WRITEBACK\0" /* 26856, 26860 */
	"TA_GRAD_ADJ_UCONFIG\0" /* 26870 */
	"SPI_CONFIG_CNTL_2\0" /* 26890 */
	"SPI_SHADER_USER_DATA_PS_16\0" /* 26908 */
	"SPI_SHADER_USER_DATA_PS_17\0" /* 26935 */
	"SPI_SHADER_USER_DATA_PS_18\0" /* 26962 */
	"SPI_SHADER_USER_DATA_PS_19\0" /* 26989 */
	"SPI_SHADER_USER_DATA_PS_20\0" /* 27016 */
	"SPI_SHADER_USER_DATA_PS_21\0" /* 27043 */
	"SPI_SHADER_USER_DATA_PS_22\0" /* 27070 */
	"SPI_SHADER_USER_DATA_PS_23\0" /* 27097 */
	"SPI_SHADER_USER_DATA_PS_24\0" /* 27124 */
	"SPI_SHADER_USER_DATA_PS_25\0" /* 27151 */
	"SPI_SHADER_USER_DATA_PS_26\0" /* 27178 */
	"SPI_SHADER_USER_DATA_PS_27\0" /* 27205 */
	"SPI_SHADER_USER_DATA_PS_28\0" /* 27232 */
	"SPI_SHADER_USER_DATA_PS_29\0" /* 27259 */
	"SPI_SHADER_USER_DATA_PS_30\0" /* 27286 */
	"SPI_SHADER_USER_DATA_PS_31\0" /* 27313 */
	"SPI_SHADER_USER_DATA_VS_16\0" /* 27340 */
	"SPI_SHADER_USER_DATA_VS_17\0" /* 27367 */
	"SPI_SHADER_USER_DATA_VS_18\0" /* 27394 */
	"SPI_SHADER_USER_DATA_VS_19\0" /* 27421 */
	"SPI_SHADER_USER_DATA_VS_20\0" /* 27448 */
	"SPI_SHADER_USER_DATA_VS_21\0" /* 27475 */
	"SPI_SHADER_USER_DATA_VS_22\0" /* 27502 */
	"SPI_SHADER_USER_DATA_VS_23\0" /* 27529 */
	"SPI_SHADER_USER_DATA_VS_24\0" /* 27556 */
	"SPI_SHADER_USER_DATA_VS_25\0" /* 27583 */
	"SPI_SHADER_USER_DATA_VS_26\0" /* 27610 */
	"SPI_SHADER_USER_DATA_VS_27\0" /* 27637 */
	"SPI_SHADER_USER_DATA_VS_28\0" /* 27664 */
	"SPI_SHADER_USER_DATA_VS_29\0" /* 27691 */
	"SPI_SHADER_USER_DATA_VS_30\0" /* 27718 */
	"SPI_SHADER_USER_DATA_VS_31\0" /* 27745 */
	"SPI_SHADER_PGM_RSRC2_GS_VS\0" /* 27772 */
	"SPI_SHADER_PGM_RSRC4_GS\0" /* 27799 */
	"SPI_SHADER_USER_DATA_ADDR_LO_GS\0" /* 27823 */
	"SPI_SHADER_USER_DATA_ADDR_HI_GS\0" /* 27855 */
	"SPI_SHADER_USER_DATA_ES_16\0" /* 27887 */
	"SPI_SHADER_USER_DATA_ES_17\0" /* 27914 */
	"SPI_SHADER_USER_DATA_ES_18\0" /* 27941 */
	"SPI_SHADER_USER_DATA_ES_19\0" /* 27968 */
	"SPI_SHADER_USER_DATA_ES_20\0" /* 27995 */
	"SPI_SHADER_USER_DATA_ES_21\0" /* 28022 */
	"SPI_SHADER_USER_DATA_ES_22\0" /* 28049 */
	"SPI_SHADER_USER_DATA_ES_23\0" /* 28076 */
	"SPI_SHADER_USER_DATA_ES_24\0" /* 28103 */
	"SPI_SHADER_USER_DATA_ES_25\0" /* 28130 */
	"SPI_SHADER_USER_DATA_ES_26\0" /* 28157 */
	"SPI_SHADER_USER_DATA_ES_27\0" /* 28184 */
	"SPI_SHADER_USER_DATA_ES_28\0" /* 28211 */
	"SPI_SHADER_USER_DATA_ES_29\0" /* 28238 */
	"SPI_SHADER_USER_DATA_ES_30\0" /* 28265 */
	"SPI_SHADER_USER_DATA_ES_31\0" /* 28292 */
	"SPI_SHADER_PGM_RSRC4_HS\0" /* 28319 */
	"SPI_SHADER_USER_DATA_ADDR_LO_HS\0" /* 28343 */
	"SPI_SHADER_USER_DATA_ADDR_HI_HS\0" /* 28375 */
	"SPI_SHADER_USER_DATA_LS_16\0" /* 28407 */
	"SPI_SHADER_USER_DATA_LS_17\0" /* 28434 */
	"SPI_SHADER_USER_DATA_LS_18\0" /* 28461 */
	"SPI_SHADER_USER_DATA_LS_19\0" /* 28488 */
	"SPI_SHADER_USER_DATA_LS_20\0" /* 28515 */
	"SPI_SHADER_USER_DATA_LS_21\0" /* 28542 */
	"SPI_SHADER_USER_DATA_LS_22\0" /* 28569 */
	"SPI_SHADER_USER_DATA_LS_23\0" /* 28596 */
	"SPI_SHADER_USER_DATA_LS_24\0" /* 28623 */
	"SPI_SHADER_USER_DATA_LS_25\0" /* 28650 */
	"SPI_SHADER_USER_DATA_LS_26\0" /* 28677 */
	"SPI_SHADER_USER_DATA_LS_27\0" /* 28704 */
	"SPI_SHADER_USER_DATA_LS_28\0" /* 28731 */
	"SPI_SHADER_USER_DATA_LS_29\0" /* 28758 */
	"SPI_SHADER_USER_DATA_LS_30\0" /* 28785 */
	"SPI_SHADER_USER_DATA_LS_31\0" /* 28812 */
	"SPI_SHADER_USER_DATA_COMMON_0\0" /* 28839 */
	"SPI_SHADER_USER_DATA_COMMON_1\0" /* 28869 */
	"SPI_SHADER_USER_DATA_COMMON_2\0" /* 28899 */
	"SPI_SHADER_USER_DATA_COMMON_3\0" /* 28929 */
	"SPI_SHADER_USER_DATA_COMMON_4\0" /* 28959 */
	"SPI_SHADER_USER_DATA_COMMON_5\0" /* 28989 */
	"SPI_SHADER_USER_DATA_COMMON_6\0" /* 29019 */
	"SPI_SHADER_USER_DATA_COMMON_7\0" /* 29049 */
	"SPI_SHADER_USER_DATA_COMMON_8\0" /* 29079 */
	"SPI_SHADER_USER_DATA_COMMON_9\0" /* 29109 */
	"SPI_SHADER_USER_DATA_COMMON_10\0" /* 29139 */
	"SPI_SHADER_USER_DATA_COMMON_11\0" /* 29170 */
	"SPI_SHADER_USER_DATA_COMMON_12\0" /* 29201 */
	"SPI_SHADER_USER_DATA_COMMON_13\0" /* 29232 */
	"SPI_SHADER_USER_DATA_COMMON_14\0" /* 29263 */
	"SPI_SHADER_USER_DATA_COMMON_15\0" /* 29294 */
	"SPI_SHADER_USER_DATA_COMMON_16\0" /* 29325 */
	"SPI_SHADER_USER_DATA_COMMON_17\0" /* 29356 */
	"SPI_SHADER_USER_DATA_COMMON_18\0" /* 29387 */
	"SPI_SHADER_USER_DATA_COMMON_19\0" /* 29418 */
	"SPI_SHADER_USER_DATA_COMMON_20\0" /* 29449 */
	"SPI_SHADER_USER_DATA_COMMON_21\0" /* 29480 */
	"SPI_SHADER_USER_DATA_COMMON_22\0" /* 29511 */
	"SPI_SHADER_USER_DATA_COMMON_23\0" /* 29542 */
	"SPI_SHADER_USER_DATA_COMMON_24\0" /* 29573 */
	"SPI_SHADER_USER_DATA_COMMON_25\0" /* 29604 */
	"SPI_SHADER_USER_DATA_COMMON_26\0" /* 29635 */
	"SPI_SHADER_USER_DATA_COMMON_27\0" /* 29666 */
	"SPI_SHADER_USER_DATA_COMMON_28\0" /* 29697 */
	"SPI_SHADER_USER_DATA_COMMON_29\0" /* 29728 */
	"SPI_SHADER_USER_DATA_COMMON_30\0" /* 29759 */
	"SPI_SHADER_USER_DATA_COMMON_31\0" /* 29790 */
	"COMPUTE_DISPATCH_PKT_ADDR_LO\0" /* 29821 */
	"COMPUTE_DISPATCH_PKT_ADDR_HI\0" /* 29850 */
	"COMPUTE_DISPATCH_SCRATCH_BASE_LO\0" /* 29879 */
	"COMPUTE_DISPATCH_SCRATCH_BASE_HI\0" /* 29912 */
	"CPF_LATENCY_STATS_DATA\0" /* 29945 */
	"CPG_LATENCY_STATS_DATA\0" /* 29968 */
	"CPC_LATENCY_STATS_DATA\0" /* 29991 */
	"CPF_TC_PERF_COUNTER_WINDOW_SELECT\0" /* 30014 */
	"CPG_TC_PERF_COUNTER_WINDOW_SELECT\0" /* 30048 */
	"CPF_LATENCY_STATS_SELECT\0" /* 30082 */
	"CPG_LATENCY_STATS_SELECT\0" /* 30107 */
	"CPC_LATENCY_STATS_SELECT\0" /* 30132 */
	"DB_HTILE_DATA_BASE_HI\0" /* 30157 */
	"DB_Z_READ_BASE_HI\0" /* 30179 */
	"DB_STENCIL_READ_BASE_HI\0" /* 30197 */
	"DB_Z_WRITE_BASE_HI\0" /* 30221 */
	"DB_STENCIL_WRITE_BASE_HI\0" /* 30240 */
	"DB_DFSM_CONTROL\0" /* 30265 */
	"DB_RENDER_FILTER\0" /* 30281 */
	"DB_Z_INFO2\0" /* 30298 */
	"DB_STENCIL_INFO2\0" /* 30309 */
	"PA_SC_TILE_STEERING_OVERRIDE\0" /* 30326 */
	"CP_PERFMON_CNTX_CNTL\0" /* 30355 */
	"PA_SC_RIGHT_VERT_GRID\0" /* 30376 */
	"PA_SC_LEFT_VERT_GRID\0" /* 30398 */
	"PA_SC_HORIZ_GRID\0" /* 30419 */
	"PA_SC_FOV_WINDOW_LR\0" /* 30436 */
	"PA_SC_FOV_WINDOW_TB\0" /* 30456 */
	"CB_MRT0_EPITCH\0" /* 30484, 30476 */
	"CB_MRT1_EPITCH\0" /* 30491 */
	"CB_MRT2_EPITCH\0" /* 30506 */
	"CB_MRT3_EPITCH\0" /* 30521 */
	"CB_MRT4_EPITCH\0" /* 30536 */
	"CB_MRT5_EPITCH\0" /* 30551 */
	"CB_MRT6_EPITCH\0" /* 30566 */
	"CB_MRT7_EPITCH\0" /* 30581 */
	"PA_CL_OBJPRIM_ID_CNTL\0" /* 30596 */
	"PA_CL_NGG_CNTL\0" /* 30618 */
	"PA_SU_OVER_RASTERIZATION_CNTL\0" /* 30633 */
	"VGT_GS_MAX_PRIMS_PER_SUBGROUP\0" /* 30670, 30663 */
	"VGT_DRAW_PAYLOAD_CNTL\0" /* 30693 */
	"VGT_INDEX_PAYLOAD_CNTL\0" /* 30715 */
	"VGT_DMA_EVENT_INITIATOR\0" /* 30738 */
	"PA_SC_BINNER_CNTL_0\0" /* 30762 */
	"PA_SC_BINNER_CNTL_1\0" /* 30782 */
	"PA_SC_CONSERVATIVE_RASTERIZATION_CNTL\0" /* 30802 */
	"PA_SC_NGG_MODE_CNTL\0" /* 30840 */
	"CB_COLOR0_BASE_EXT\0" /* 30860 */
	"CB_COLOR0_ATTRIB2\0" /* 30879 */
	"CB_COLOR0_CMASK_BASE_EXT\0" /* 30897 */
	"CB_COLOR0_FMASK_BASE_EXT\0" /* 30922 */
	"CB_COLOR0_DCC_BASE_EXT\0" /* 30947 */
	"CB_COLOR1_BASE_EXT\0" /* 30970 */
	"CB_COLOR1_ATTRIB2\0" /* 30989 */
	"CB_COLOR1_CMASK_BASE_EXT\0" /* 31007 */
	"CB_COLOR1_FMASK_BASE_EXT\0" /* 31032 */
	"CB_COLOR1_DCC_BASE_EXT\0" /* 31057 */
	"CB_COLOR2_BASE_EXT\0" /* 31080 */
	"CB_COLOR2_ATTRIB2\0" /* 31099 */
	"CB_COLOR2_CMASK_BASE_EXT\0" /* 31117 */
	"CB_COLOR2_FMASK_BASE_EXT\0" /* 31142 */
	"CB_COLOR2_DCC_BASE_EXT\0" /* 31167 */
	"CB_COLOR3_BASE_EXT\0" /* 31190 */
	"CB_COLOR3_ATTRIB2\0" /* 31209 */
	"CB_COLOR3_CMASK_BASE_EXT\0" /* 31227 */
	"CB_COLOR3_FMASK_BASE_EXT\0" /* 31252 */
	"CB_COLOR3_DCC_BASE_EXT\0" /* 31277 */
	"CB_COLOR4_BASE_EXT\0" /* 31300 */
	"CB_COLOR4_ATTRIB2\0" /* 31319 */
	"CB_COLOR4_CMASK_BASE_EXT\0" /* 31337 */
	"CB_COLOR4_FMASK_BASE_EXT\0" /* 31362 */
	"CB_COLOR4_DCC_BASE_EXT\0" /* 31387 */
	"CB_COLOR5_BASE_EXT\0" /* 31410 */
	"CB_COLOR5_ATTRIB2\0" /* 31429 */
	"CB_COLOR5_CMASK_BASE_EXT\0" /* 31447 */
	"CB_COLOR5_FMASK_BASE_EXT\0" /* 31472 */
	"CB_COLOR5_DCC_BASE_EXT\0" /* 31497 */
	"CB_COLOR6_BASE_EXT\0" /* 31520 */
	"CB_COLOR6_ATTRIB2\0" /* 31539 */
	"CB_COLOR6_CMASK_BASE_EXT\0" /* 31557 */
	"CB_COLOR6_FMASK_BASE_EXT\0" /* 31582 */
	"CB_COLOR6_DCC_BASE_EXT\0" /* 31607 */
	"CB_COLOR7_BASE_EXT\0" /* 31630 */
	"CB_COLOR7_ATTRIB2\0" /* 31649 */
	"CB_COLOR7_CMASK_BASE_EXT\0" /* 31667 */
	"CB_COLOR7_FMASK_BASE_EXT\0" /* 31692 */
	"CB_COLOR7_DCC_BASE_EXT\0" /* 31717 */
	"COUNT_INDIRECT_ENABLE\0" /* 31740 */
	"DRAW_INDEX_ENABLE\0" /* 31762 */
	"PFP\0" /* 31780 */
	"ENGINE_SEL\0" /* 31784 */
	"WR_CONFIRM\0" /* 31795 */
	"WR_ONE_ADDR\0" /* 31806 */
	"MEM_MAPPED_REGISTER\0" /* 31818, 31829 */
	"MEMORY_SYNC\0" /* 31838 */
	"TC_L2\0" /* 31850 */
	"GDS\0" /* 31856 */
	"MEM_ASYNC\0" /* 31860 */
	"DST_SEL\0" /* 31870 */
	"IB_SIZE\0" /* 31878 */
	"CHAIN\0" /* 31886 */
	"VALID\0" /* 31892 */
	"CP_SYNC\0" /* 31898 */
	"SRC_ADDR\0" /* 31906 */
	"SRC_ADDR_TC_L2\0" /* 31915 */
	"SRC_SEL\0" /* 31930 */
	"ENGINE\0" /* 31938 */
	"DST_ADDR\0" /* 31945 */
	"DST_ADDR_TC_L2\0" /* 31954 */
	"DSL_SEL\0" /* 31969 */
	"BYTE_COUNT_GFX6\0" /* 31977 */
	"BYTE_COUNT_GFX9\0" /* 31993 */
	"DISABLE_WR_CONFIRM_GFX6\0" /* 32009 */
	"NONE\0" /* 32033 */
	"8_IN_16\0" /* 32038 */
	"8_IN_32\0" /* 32046 */
	"8_IN_64\0" /* 32054 */
	"SRC_SWAP\0" /* 32062 */
	"DST_SWAP\0" /* 32071 */
	"MEMORY\0" /* 32080 */
	"SAS\0" /* 32087 */
	"DAS\0" /* 32091 */
	"INCREMENT\0" /* 32095 */
	"NO_INCREMENT\0" /* 32105 */
	"SAIC\0" /* 32118 */
	"DAIC\0" /* 32123 */
	"RAW_WAIT\0" /* 32128 */
	"DISABLE_WR_CONFIRM_GFX9\0" /* 32137 */
	"SDMA_RQ_PENDING\0" /* 32161 */
	"TST_RQ_PENDING\0" /* 32177 */
	"SDMA1_RQ_PENDING\0" /* 32192 */
	"VCE0_RQ_PENDING\0" /* 32209 */
	"VP8_BUSY\0" /* 32225 */
	"SDMA_BUSY\0" /* 32234, 32235 */
	"SDMA1_BUSY\0" /* 32244 */
	"VCE0_BUSY\0" /* 32255 */
	"XDMA_BUSY\0" /* 32265 */
	"CHUB_BUSY\0" /* 32275 */
	"SDMA2_BUSY\0" /* 32285 */
	"SDMA3_BUSY\0" /* 32296 */
	"SAMSCP_BUSY\0" /* 32307, 32311 */
	"ISP_BUSY\0" /* 32319 */
	"VCE1_BUSY\0" /* 32328 */
	"ODE_BUSY\0" /* 32338 */
	"SDMA2_RQ_PENDING\0" /* 32347 */
	"SDMA3_RQ_PENDING\0" /* 32364 */
	"SAMSCP_RQ_PENDING\0" /* 32381 */
	"ISP_RQ_PENDING\0" /* 32399 */
	"VCE1_RQ_PENDING\0" /* 32414 */
	"UVD_RQ_PENDING\0" /* 32430 */
	"SAMMSP_RQ_PENDING\0" /* 32445 */
	"ACP_RQ_PENDING\0" /* 32463 */
	"SMU_RQ_PENDING\0" /* 32478 */
	"GRBM_RQ_PENDING\0" /* 32493 */
	"HI_RQ_PENDING\0" /* 32509 */
	"VMC_BUSY\0" /* 32523 */
	"MCB_BUSY\0" /* 32532, 32533 */
	"MCB_NON_DISPLAY_BUSY\0" /* 32541 */
	"MCC_BUSY\0" /* 32562 */
	"MCD_BUSY\0" /* 32571 */
	"VMC1_BUSY\0" /* 32580 */
	"SEM_BUSY\0" /* 32590 */
	"ACP_BUSY\0" /* 32599 */
	"IH_BUSY\0" /* 32608 */
	"UVD_BUSY\0" /* 32616 */
	"SAMMSP_BUSY\0" /* 32625 */
	"GCATCL2_BUSY\0" /* 32637 */
	"OSATCL2_BUSY\0" /* 32650 */
	"BIF_BUSY\0" /* 32663 */
	"MCC0_BUSY\0" /* 32672 */
	"MCC1_BUSY\0" /* 32682 */
	"MCC2_BUSY\0" /* 32692 */
	"MCC3_BUSY\0" /* 32702 */
	"MCC4_BUSY\0" /* 32712 */
	"MCC5_BUSY\0" /* 32722 */
	"MCC6_BUSY\0" /* 32732 */
	"MCC7_BUSY\0" /* 32742 */
	"MCD0_BUSY\0" /* 32752 */
	"MCD1_BUSY\0" /* 32762 */
	"MCD2_BUSY\0" /* 32772 */
	"MCD3_BUSY\0" /* 32782 */
	"MCD4_BUSY\0" /* 32792 */
	"MCD5_BUSY\0" /* 32802 */
	"MCD6_BUSY\0" /* 32812 */
	"MCD7_BUSY\0" /* 32822 */
	"IDLE\0" /* 32832 */
	"REG_IDLE\0" /* 32837 */
	"RB_EMPTY\0" /* 32846 */
	"RB_FULL\0" /* 32855 */
	"RB_CMD_IDLE\0" /* 32863 */
	"RB_CMD_FULL\0" /* 32875 */
	"IB_CMD_IDLE\0" /* 32887 */
	"IB_CMD_FULL\0" /* 32899 */
	"BLOCK_IDLE\0" /* 32911 */
	"INSIDE_IB\0" /* 32922 */
	"EX_IDLE\0" /* 32932 */
	"EX_IDLE_POLL_TIMER_EXPIRE\0" /* 32940 */
	"PACKET_READY\0" /* 32966 */
	"MC_WR_IDLE\0" /* 32979 */
	"SRBM_IDLE\0" /* 32990 */
	"CONTEXT_EMPTY\0" /* 33000 */
	"DELTA_RPTR_FULL\0" /* 33014 */
	"RB_MC_RREQ_IDLE\0" /* 33030 */
	"IB_MC_RREQ_IDLE\0" /* 33046 */
	"MC_RD_IDLE\0" /* 33062 */
	"DELTA_RPTR_EMPTY\0" /* 33073 */
	"MC_RD_RET_STALL\0" /* 33090 */
	"MC_RD_NO_POLL_IDLE\0" /* 33106 */
	"PREV_CMD_IDLE\0" /* 33125 */
	"SEM_IDLE\0" /* 33139 */
	"SEM_REQ_STALL\0" /* 33148 */
	"SEM_RESP_STATE\0" /* 33162 */
	"INT_IDLE\0" /* 33177 */
	"INT_REQ_STALL\0" /* 33186 */
	"ME0PIPE1_CMDFIFO_AVAIL\0" /* 33200 */
	"ME0PIPE1_CF_RQ_PENDING\0" /* 33223 */
	"ME0PIPE1_PF_RQ_PENDING\0" /* 33246 */
	"ME1PIPE0_RQ_PENDING\0" /* 33269 */
	"ME1PIPE1_RQ_PENDING\0" /* 33289 */
	"ME1PIPE2_RQ_PENDING\0" /* 33309 */
	"ME1PIPE3_RQ_PENDING\0" /* 33329 */
	"ME2PIPE0_RQ_PENDING\0" /* 33349 */
	"ME2PIPE1_RQ_PENDING\0" /* 33369 */
	"ME2PIPE2_RQ_PENDING\0" /* 33389 */
	"ME2PIPE3_RQ_PENDING\0" /* 33409 */
	"RLC_RQ_PENDING\0" /* 33429 */
	"RLC_BUSY\0" /* 33444 */
	"TC_BUSY\0" /* 33453 */
	"TCC_CC_RESIDENT\0" /* 33461 */
	"CPF_BUSY\0" /* 33477 */
	"CPC_BUSY\0" /* 33486 */
	"CPG_BUSY\0" /* 33495 */
	"ME0PIPE0_CMDFIFO_AVAIL\0" /* 33504 */
	"SRBM_RQ_PENDING\0" /* 33527 */
	"ME0PIPE0_CF_RQ_PENDING\0" /* 33543 */
	"ME0PIPE0_PF_RQ_PENDING\0" /* 33566 */
	"GDS_DMA_RQ_PENDING\0" /* 33589 */
	"DB_CLEAN\0" /* 33608 */
	"CB_CLEAN\0" /* 33617 */
	"TA_BUSY\0" /* 33626 */
	"GDS_BUSY\0" /* 33634 */
	"WD_BUSY_NO_DMA\0" /* 33643 */
	"VGT_BUSY\0" /* 33658 */
	"IA_BUSY_NO_DMA\0" /* 33667 */
	"IA_BUSY\0" /* 33682 */
	"SX_BUSY\0" /* 33690 */
	"WD_BUSY\0" /* 33698 */
	"SPI_BUSY\0" /* 33706 */
	"BCI_BUSY\0" /* 33715 */
	"SC_BUSY\0" /* 33724 */
	"PA_BUSY\0" /* 33732 */
	"DB_BUSY\0" /* 33740 */
	"CP_COHERENCY_BUSY\0" /* 33748 */
	"GUI_ACTIVE\0" /* 33766 */
	"INSTANCE_INDEX\0" /* 33777 */
	"SH_INDEX\0" /* 33792 */
	"SE_INDEX\0" /* 33801 */
	"SH_BROADCAST_WRITES\0" /* 33810 */
	"INSTANCE_BROADCAST_WRITES\0" /* 33830 */
	"SE_BROADCAST_WRITES\0" /* 33856 */
	"OFFSET_UPDATE_DONE\0" /* 33890, 33876 */
	"DEST_BASE_0_ENA\0" /* 33895 */
	"DEST_BASE_1_ENA\0" /* 33911 */
	"CB0_DEST_BASE_ENA\0" /* 33927 */
	"CB1_DEST_BASE_ENA\0" /* 33945 */
	"CB2_DEST_BASE_ENA\0" /* 33963 */
	"CB3_DEST_BASE_ENA\0" /* 33981 */
	"CB4_DEST_BASE_ENA\0" /* 33999 */
	"CB5_DEST_BASE_ENA\0" /* 34017 */
	"CB6_DEST_BASE_ENA\0" /* 34035 */
	"CB7_DEST_BASE_ENA\0" /* 34053 */
	"DB_DEST_BASE_ENA\0" /* 34071 */
	"DEST_BASE_2_ENA\0" /* 34088 */
	"DEST_BASE_3_ENA\0" /* 34104 */
	"TCL1_ACTION_ENA\0" /* 34120 */
	"TC_ACTION_ENA\0" /* 34136 */
	"CB_ACTION_ENA\0" /* 34150 */
	"DB_ACTION_ENA\0" /* 34164 */
	"SH_KCACHE_ACTION_ENA\0" /* 34178 */
	"SH_ICACHE_ACTION_ENA\0" /* 34199 */
	"COHER_BASE_HI_256B\0" /* 34220 */
	"START_DELAY_COUNT\0" /* 34239 */
	"TC_SD_ACTION_ENA\0" /* 34257 */
	"TC_NC_ACTION_ENA\0" /* 34274 */
	"TCL1_VOL_ACTION_ENA\0" /* 34291 */
	"TC_VOL_ACTION_ENA\0" /* 34311 */
	"TC_WB_ACTION_ENA\0" /* 34329 */
	"SH_KCACHE_VOL_ACTION_ENA\0" /* 34346 */
	"SH_KCACHE_WB_ACTION_ENA\0" /* 34371 */
	"SH_SD_ACTION_ENA\0" /* 34395 */
	"MATCHING_GFX_CNTX\0" /* 34412 */
	"MEID\0" /* 34430 */
	"PHASE1_STATUS\0" /* 34435 */
	"MEC1_BUSY\0" /* 34449 */
	"MEC2_BUSY\0" /* 34459 */
	"DC0_BUSY\0" /* 34469 */
	"DC1_BUSY\0" /* 34478 */
	"RCIU1_BUSY\0" /* 34487 */
	"RCIU2_BUSY\0" /* 34498 */
	"ROQ1_BUSY\0" /* 34509 */
	"ROQ2_BUSY\0" /* 34519 */
	"TCIU_BUSY\0" /* 34529 */
	"SCRATCH_RAM_BUSY\0" /* 34539 */
	"QU_BUSY\0" /* 34556 */
	"ATCL2IU_BUSY\0" /* 34564 */
	"CPG_CPC_BUSY\0" /* 34577 */
	"CPF_CPC_BUSY\0" /* 34590 */
	"MEC1_LOAD_BUSY\0" /* 34603 */
	"MEC1_SEMAPOHRE_BUSY\0" /* 34618 */
	"MEC1_MUTEX_BUSY\0" /* 34638 */
	"MEC1_MESSAGE_BUSY\0" /* 34654 */
	"MEC1_EOP_QUEUE_BUSY\0" /* 34672 */
	"MEC1_IQ_QUEUE_BUSY\0" /* 34692 */
	"MEC1_IB_QUEUE_BUSY\0" /* 34711 */
	"MEC1_TC_BUSY\0" /* 34730 */
	"MEC1_DMA_BUSY\0" /* 34743 */
	"MEC1_PARTIAL_FLUSH_BUSY\0" /* 34757 */
	"MEC1_PIPE0_BUSY\0" /* 34781 */
	"MEC1_PIPE1_BUSY\0" /* 34797 */
	"MEC1_PIPE2_BUSY\0" /* 34813 */
	"MEC1_PIPE3_BUSY\0" /* 34829 */
	"MEC2_LOAD_BUSY\0" /* 34845 */
	"MEC2_SEMAPOHRE_BUSY\0" /* 34860 */
	"MEC2_MUTEX_BUSY\0" /* 34880 */
	"MEC2_MESSAGE_BUSY\0" /* 34896 */
	"MEC2_EOP_QUEUE_BUSY\0" /* 34914 */
	"MEC2_IQ_QUEUE_BUSY\0" /* 34934 */
	"MEC2_IB_QUEUE_BUSY\0" /* 34953 */
	"MEC2_TC_BUSY\0" /* 34972 */
	"MEC2_DMA_BUSY\0" /* 34985 */
	"MEC2_PARTIAL_FLUSH_BUSY\0" /* 34999 */
	"MEC2_PIPE0_BUSY\0" /* 35023 */
	"MEC2_PIPE1_BUSY\0" /* 35039 */
	"MEC2_PIPE2_BUSY\0" /* 35055 */
	"MEC2_PIPE3_BUSY\0" /* 35071 */
	"RCIU_TX_FREE_STALL\0" /* 35087 */
	"RCIU_PRIV_VIOLATION\0" /* 35106 */
	"TCIU_TX_FREE_STALL\0" /* 35126 */
	"MEC1_DECODING_PACKET\0" /* 35145 */
	"MEC1_WAIT_ON_RCIU\0" /* 35166 */
	"MEC1_WAIT_ON_RCIU_READ\0" /* 35184 */
	"MEC1_WAIT_ON_ROQ_DATA\0" /* 35207 */
	"MEC2_DECODING_PACKET\0" /* 35229 */
	"MEC2_WAIT_ON_RCIU\0" /* 35250 */
	"MEC2_WAIT_ON_RCIU_READ\0" /* 35268 */
	"MEC2_WAIT_ON_ROQ_DATA\0" /* 35291 */
	"ATCL2IU_WAITING_ON_FREE\0" /* 35313 */
	"ATCL2IU_WAITING_ON_TAGS\0" /* 35337 */
	"ATCL1_WAITING_ON_TRANS\0" /* 35361 */
	"POST_WPTR_GFX_BUSY\0" /* 35384 */
	"CSF_BUSY\0" /* 35403 */
	"ROQ_ALIGN_BUSY\0" /* 35412 */
	"ROQ_RING_BUSY\0" /* 35427 */
	"ROQ_INDIRECT1_BUSY\0" /* 35441 */
	"ROQ_INDIRECT2_BUSY\0" /* 35460 */
	"ROQ_STATE_BUSY\0" /* 35479 */
	"ROQ_CE_RING_BUSY\0" /* 35494 */
	"ROQ_CE_INDIRECT1_BUSY\0" /* 35511 */
	"ROQ_CE_INDIRECT2_BUSY\0" /* 35533 */
	"SEMAPHORE_BUSY\0" /* 35555 */
	"INTERRUPT_BUSY\0" /* 35570 */
	"HQD_BUSY\0" /* 35585 */
	"PRT_BUSY\0" /* 35594 */
	"CPF_GFX_BUSY\0" /* 35603 */
	"CPF_CMP_BUSY\0" /* 35616 */
	"GRBM_CPF_STAT_BUSY\0" /* 35629 */
	"CPC_CPF_BUSY\0" /* 35648 */
	"REG_BUS_FIFO_BUSY\0" /* 35661 */
	"CSF_RING_BUSY\0" /* 35679 */
	"CSF_INDIRECT1_BUSY\0" /* 35693 */
	"CSF_INDIRECT2_BUSY\0" /* 35712 */
	"CSF_STATE_BUSY\0" /* 35731 */
	"CSF_CE_INDR1_BUSY\0" /* 35746 */
	"CSF_CE_INDR2_BUSY\0" /* 35764 */
	"CSF_ARBITER_BUSY\0" /* 35782 */
	"CSF_INPUT_BUSY\0" /* 35799 */
	"OUTSTANDING_READ_TAGS\0" /* 35814 */
	"HPD_PROCESSING_EOP_BUSY\0" /* 35836 */
	"HQD_DISPATCH_BUSY\0" /* 35860 */
	"HQD_IQ_TIMER_BUSY\0" /* 35878 */
	"HQD_DMA_OFFLOAD_BUSY\0" /* 35896 */
	"HQD_WAIT_SEMAPHORE_BUSY\0" /* 35917 */
	"HQD_SIGNAL_SEMAPHORE_BUSY\0" /* 35941 */
	"HQD_MESSAGE_BUSY\0" /* 35967 */
	"HQD_PQ_FETCHER_BUSY\0" /* 35984 */
	"HQD_IB_FETCHER_BUSY\0" /* 36004 */
	"HQD_IQ_FETCHER_BUSY\0" /* 36024 */
	"HQD_EOP_FETCHER_BUSY\0" /* 36044 */
	"HQD_CONSUMED_RPTR_BUSY\0" /* 36065 */
	"HQD_FETCHER_ARB_BUSY\0" /* 36088 */
	"HQD_ROQ_ALIGN_BUSY\0" /* 36109 */
	"HQD_ROQ_EOP_BUSY\0" /* 36128 */
	"HQD_ROQ_IQ_BUSY\0" /* 36145 */
	"HQD_ROQ_PQ_BUSY\0" /* 36161 */
	"HQD_ROQ_IB_BUSY\0" /* 36177 */
	"HQD_WPTR_POLL_BUSY\0" /* 36193 */
	"HQD_PQ_BUSY\0" /* 36212 */
	"HQD_IB_BUSY\0" /* 36224 */
	"RING_FETCHING_DATA\0" /* 36236 */
	"INDR1_FETCHING_DATA\0" /* 36255 */
	"INDR2_FETCHING_DATA\0" /* 36275 */
	"STATE_FETCHING_DATA\0" /* 36295 */
	"TCIU_WAITING_ON_FREE\0" /* 36315 */
	"TCIU_WAITING_ON_TAGS\0" /* 36336 */
	"COHER_SIZE_HI_256B\0" /* 36357 */
	"PRIM_COUNT\0" /* 36376 */
	"VS_NO_EXTRA_BUFFER\0" /* 36387 */
	"STREAMOUT_FULL_FLUSH\0" /* 36406 */
	"ES_LIMIT\0" /* 36427, 36430 */
	"VERT_REUSE\0" /* 36436 */
	"DI_PT_NONE\0" /* 36447 */
	"DI_PT_POINTLIST\0" /* 36458 */
	"DI_PT_LINELIST\0" /* 36474 */
	"DI_PT_LINESTRIP\0" /* 36489 */
	"DI_PT_TRILIST\0" /* 36505 */
	"DI_PT_TRIFAN\0" /* 36519 */
	"DI_PT_TRISTRIP\0" /* 36532 */
	"DI_PT_UNUSED_0\0" /* 36547 */
	"DI_PT_UNUSED_1\0" /* 36562 */
	"DI_PT_PATCH\0" /* 36577 */
	"DI_PT_LINELIST_ADJ\0" /* 36589 */
	"DI_PT_LINESTRIP_ADJ\0" /* 36608 */
	"DI_PT_TRILIST_ADJ\0" /* 36628 */
	"DI_PT_TRISTRIP_ADJ\0" /* 36646 */
	"DI_PT_UNUSED_3\0" /* 36665 */
	"DI_PT_UNUSED_4\0" /* 36680 */
	"DI_PT_TRI_WITH_WFLAGS\0" /* 36695 */
	"DI_PT_RECTLIST\0" /* 36717 */
	"DI_PT_LINELOOP\0" /* 36732 */
	"DI_PT_QUADLIST\0" /* 36747 */
	"DI_PT_QUADSTRIP\0" /* 36762 */
	"DI_PT_POLYGON\0" /* 36778 */
	"DI_PT_2D_COPY_RECT_LIST_V0\0" /* 36792 */
	"DI_PT_2D_COPY_RECT_LIST_V1\0" /* 36819 */
	"DI_PT_2D_COPY_RECT_LIST_V2\0" /* 36846 */
	"DI_PT_2D_COPY_RECT_LIST_V3\0" /* 36873 */
	"DI_PT_2D_FILL_RECT_LIST\0" /* 36900 */
	"DI_PT_2D_LINE_STRIP\0" /* 36924 */
	"DI_PT_2D_TRI_STRIP\0" /* 36944 */
	"DI_INDEX_SIZE_16_BIT\0" /* 36963 */
	"DI_INDEX_SIZE_32_BIT\0" /* 36984 */
	"OFFCHIP_BUFFERING\0" /* 37005 */
	"CLIP_VTX_REORDER_ENA\0" /* 37023 */
	"NUM_CLIP_SEQ\0" /* 37044 */
	"CLIPPED_PRIM_SEQ_STALL\0" /* 37057 */
	"VE_NAN_PROC_DISABLE\0" /* 37080 */
	"CURRENT_PTR\0" /* 37100 */
	"CURRENT_COUNT\0" /* 37112 */
	"CE_TO_CSF_NOT_RDY_TO_RCV\0" /* 37126 */
	"CE_TO_RAM_INIT_FETCHER_NOT_RDY_TO_RCV\0" /* 37151 */
	"CE_WAITING_ON_DATA_FROM_RAM_INIT_FETCHER\0" /* 37189 */
	"CE_TO_RAM_INIT_NOT_RDY\0" /* 37230 */
	"CE_TO_RAM_DUMP_NOT_RDY\0" /* 37253 */
	"CE_TO_RAM_WRITE_NOT_RDY\0" /* 37276 */
	"CE_TO_INC_FIFO_NOT_RDY_TO_RCV\0" /* 37300 */
	"CE_TO_WR_FIFO_NOT_RDY_TO_RCV\0" /* 37330 */
	"CE_WAITING_ON_BUFFER_DATA\0" /* 37359 */
	"CE_WAITING_ON_CE_BUFFER_FLAG\0" /* 37385 */
	"CE_WAITING_ON_DE_COUNTER\0" /* 37414 */
	"CE_WAITING_ON_DE_COUNTER_UNDERFLOW\0" /* 37439 */
	"CE_STALLED_ON_TC_WR_CONFIRM\0" /* 37474 */
	"CE_STALLED_ON_ATOMIC_RTN_DATA\0" /* 37502 */
	"RBIU_TO_DMA_NOT_RDY_TO_RCV\0" /* 37532 */
	"RBIU_TO_SEM_NOT_RDY_TO_RCV\0" /* 37559 */
	"RBIU_TO_MEMWR_NOT_RDY_TO_RCV\0" /* 37586 */
	"ME_HAS_ACTIVE_CE_BUFFER_FLAG\0" /* 37615 */
	"ME_HAS_ACTIVE_DE_BUFFER_FLAG\0" /* 37644 */
	"ME_STALLED_ON_TC_WR_CONFIRM\0" /* 37673 */
	"ME_STALLED_ON_ATOMIC_RTN_DATA\0" /* 37701 */
	"ME_WAITING_ON_TC_READ_DATA\0" /* 37731 */
	"ME_WAITING_ON_REG_READ_DATA\0" /* 37758 */
	"RCIU_WAITING_ON_GDS_FREE\0" /* 37786 */
	"RCIU_WAITING_ON_GRBM_FREE\0" /* 37811 */
	"RCIU_WAITING_ON_VGT_FREE\0" /* 37837 */
	"RCIU_STALLED_ON_ME_READ\0" /* 37862 */
	"RCIU_STALLED_ON_DMA_READ\0" /* 37886 */
	"RCIU_STALLED_ON_APPEND_READ\0" /* 37911 */
	"RCIU_HALTED_BY_REG_VIOLATION\0" /* 37939 */
	"PFP_TO_CSF_NOT_RDY_TO_RCV\0" /* 37968 */
	"PFP_TO_MEQ_NOT_RDY_TO_RCV\0" /* 37994 */
	"PFP_TO_RCIU_NOT_RDY_TO_RCV\0" /* 38020 */
	"PFP_TO_VGT_WRITES_PENDING\0" /* 38047 */
	"PFP_RCIU_READ_PENDING\0" /* 38073 */
	"PFP_WAITING_ON_BUFFER_DATA\0" /* 38095 */
	"ME_WAIT_ON_CE_COUNTER\0" /* 38122 */
	"ME_WAIT_ON_AVAIL_BUFFER\0" /* 38144 */
	"GFX_CNTX_NOT_AVAIL_TO_ME\0" /* 38168 */
	"ME_RCIU_NOT_RDY_TO_RCV\0" /* 38193 */
	"ME_TO_CONST_NOT_RDY_TO_RCV\0" /* 38216 */
	"ME_WAITING_DATA_FROM_PFP\0" /* 38243 */
	"ME_WAITING_ON_PARTIAL_FLUSH\0" /* 38268 */
	"MEQ_TO_ME_NOT_RDY_TO_RCV\0" /* 38296 */
	"STQ_TO_ME_NOT_RDY_TO_RCV\0" /* 38321 */
	"ME_WAITING_DATA_FROM_STQ\0" /* 38346 */
	"PFP_STALLED_ON_TC_WR_CONFIRM\0" /* 38371 */
	"PFP_STALLED_ON_ATOMIC_RTN_DATA\0" /* 38400 */
	"EOPD_FIFO_NEEDS_SC_EOP_DONE\0" /* 38431 */
	"EOPD_FIFO_NEEDS_WR_CONFIRM\0" /* 38459 */
	"STRMO_WR_OF_PRIM_DATA_PENDING\0" /* 38486 */
	"PIPE_STATS_WR_DATA_PENDING\0" /* 38516 */
	"APPEND_RDY_WAIT_ON_CS_DONE\0" /* 38562, 38543 */
	"APPEND_RDY_WAIT_ON_PS_DONE\0" /* 38570, 38589 */
	"APPEND_WAIT_ON_WR_CONFIRM\0" /* 38597 */
	"APPEND_ACTIVE_PARTITION\0" /* 38623 */
	"APPEND_WAITING_TO_SEND_MEMWRITE\0" /* 38647 */
	"SURF_SYNC_NEEDS_IDLE_CNTXS\0" /* 38679 */
	"SURF_SYNC_NEEDS_ALL_CLEAN\0" /* 38706 */
	"DC_BUSY\0" /* 38732 */
	"PFP_BUSY\0" /* 38740 */
	"MEQ_BUSY\0" /* 38749 */
	"ME_BUSY\0" /* 38758 */
	"QUERY_BUSY\0" /* 38766 */
	"SURFACE_SYNC_BUSY\0" /* 38777 */
	"RCIU_BUSY\0" /* 38795 */
	"CPC_CPG_BUSY\0" /* 38805 */
	"CE_BUSY\0" /* 38818 */
	"X_8K_DWORDS\0" /* 38826 */
	"X_4K_DWORDS\0" /* 38838 */
	"X_2K_DWORDS\0" /* 38850 */
	"X_1K_DWORDS\0" /* 38862 */
	"OFFCHIP_GRANULARITY\0" /* 38874 */
	"ENABLE_PA_SC_OUT_OF_ORDER\0" /* 38894 */
	"DISABLE_SC_DB_TILE_FIX\0" /* 38920 */
	"DISABLE_AA_MASK_FULL_FIX\0" /* 38943 */
	"ENABLE_1XMSAA_SAMPLE_LOCATIONS\0" /* 38968 */
	"ENABLE_1XMSAA_SAMPLE_LOC_CENTROID\0" /* 38999 */
	"DISABLE_SCISSOR_FIX\0" /* 39033 */
	"DISABLE_PW_BUBBLE_COLLAPSE\0" /* 39053 */
	"SEND_UNLIT_STILES_TO_PACKER\0" /* 39080 */
	"DISABLE_DUALGRAD_PERF_OPTIMIZATION\0" /* 39108 */
	"INST_INVALIDATE\0" /* 39148, 39143 */
	"DATA_INVALIDATE\0" /* 39159 */
	"INVALIDATE_VOLATILE\0" /* 39175 */
	"RET\0" /* 39195 */
	"RUI\0" /* 39199 */
	"RNG\0" /* 39203 */
	"SQ_EXP_MRT\0" /* 39207 */
	"SQ_EXP_MRTZ\0" /* 39218 */
	"SQ_EXP_NULL\0" /* 39230 */
	"SQ_EXP_POS\0" /* 39242 */
	"SQ_EXP_PARAM\0" /* 39253 */
	"TGT\0" /* 39266 */
	"COMPR\0" /* 39270 */
	"VM\0" /* 39276 */
	"SQ_ENC_EXP_FIELD\0" /* 39279 */
	"ENCODING\0" /* 39296 */
	"ADDRESS\0" /* 39305 */
	"BASE_ADDRESS_HI\0" /* 39313, 39318 */
	"CACHE_SWIZZLE\0" /* 39329 */
	"SWIZZLE_ENABLE\0" /* 39343 */
	"SQ_SEL_0\0" /* 39358 */
	"SQ_SEL_1\0" /* 39367 */
	"SQ_SEL_RESERVED_0\0" /* 39376, 39383 */
	"SQ_SEL_RESERVED_1\0" /* 39401, 39394 */
	"SQ_SEL_X\0" /* 39412 */
	"SQ_SEL_Y\0" /* 39421 */
	"SQ_SEL_Z\0" /* 39430 */
	"SQ_SEL_W\0" /* 39439 */
	"DST_SEL_X\0" /* 39448 */
	"DST_SEL_Y\0" /* 39458 */
	"DST_SEL_Z\0" /* 39468 */
	"DST_SEL_W\0" /* 39478 */
	"BUF_NUM_FORMAT_UNORM\0" /* 39488 */
	"BUF_NUM_FORMAT_SNORM\0" /* 39509 */
	"BUF_NUM_FORMAT_USCALED\0" /* 39530 */
	"BUF_NUM_FORMAT_SSCALED\0" /* 39553 */
	"BUF_NUM_FORMAT_UINT\0" /* 39576 */
	"BUF_NUM_FORMAT_SINT\0" /* 39596 */
	"BUF_NUM_FORMAT_SNORM_OGL\0" /* 39616 */
	"BUF_NUM_FORMAT_FLOAT\0" /* 39641 */
	"NUM_FORMAT\0" /* 39662 */
	"BUF_DATA_FORMAT_INVALID\0" /* 39673 */
	"BUF_DATA_FORMAT_8\0" /* 39697 */
	"BUF_DATA_FORMAT_16\0" /* 39715 */
	"BUF_DATA_FORMAT_8_8\0" /* 39734 */
	"BUF_DATA_FORMAT_32\0" /* 39754 */
	"BUF_DATA_FORMAT_16_16\0" /* 39773 */
	"BUF_DATA_FORMAT_10_11_11\0" /* 39795 */
	"BUF_DATA_FORMAT_11_11_10\0" /* 39820 */
	"BUF_DATA_FORMAT_10_10_10_2\0" /* 39845 */
	"BUF_DATA_FORMAT_2_10_10_10\0" /* 39872 */
	"BUF_DATA_FORMAT_8_8_8_8\0" /* 39899 */
	"BUF_DATA_FORMAT_32_32\0" /* 39923 */
	"BUF_DATA_FORMAT_16_16_16_16\0" /* 39945 */
	"BUF_DATA_FORMAT_32_32_32\0" /* 39973 */
	"BUF_DATA_FORMAT_32_32_32_32\0" /* 39998 */
	"BUF_DATA_FORMAT_RESERVED_15\0" /* 40026 */
	"DATA_FORMAT\0" /* 40054 */
	"ELEMENT_SIZE\0" /* 40066 */
	"INDEX_STRIDE\0" /* 40079 */
	"ADD_TID_ENABLE\0" /* 40092 */
	"ATC\0" /* 40107 */
	"HASH_ENABLE\0" /* 40111 */
	"HEAP\0" /* 40123 */
	"MTYPE\0" /* 40128 */
	"SQ_RSRC_BUF\0" /* 40134 */
	"SQ_RSRC_BUF_RSVD_1\0" /* 40146 */
	"SQ_RSRC_BUF_RSVD_2\0" /* 40165 */
	"SQ_RSRC_BUF_RSVD_3\0" /* 40184 */
	"MIN_LOD\0" /* 40203 */
	"IMG_DATA_FORMAT_INVALID\0" /* 40211 */
	"IMG_DATA_FORMAT_8\0" /* 40235 */
	"IMG_DATA_FORMAT_16\0" /* 40253 */
	"IMG_DATA_FORMAT_8_8\0" /* 40272 */
	"IMG_DATA_FORMAT_32\0" /* 40292 */
	"IMG_DATA_FORMAT_16_16\0" /* 40311 */
	"IMG_DATA_FORMAT_10_11_11\0" /* 40333 */
	"IMG_DATA_FORMAT_11_11_10\0" /* 40358 */
	"IMG_DATA_FORMAT_10_10_10_2\0" /* 40383 */
	"IMG_DATA_FORMAT_2_10_10_10\0" /* 40410 */
	"IMG_DATA_FORMAT_8_8_8_8\0" /* 40437 */
	"IMG_DATA_FORMAT_32_32\0" /* 40461 */
	"IMG_DATA_FORMAT_16_16_16_16\0" /* 40483 */
	"IMG_DATA_FORMAT_32_32_32\0" /* 40511 */
	"IMG_DATA_FORMAT_32_32_32_32\0" /* 40536 */
	"IMG_DATA_FORMAT_RESERVED_15\0" /* 40564 */
	"IMG_DATA_FORMAT_5_6_5\0" /* 40592 */
	"IMG_DATA_FORMAT_1_5_5_5\0" /* 40614 */
	"IMG_DATA_FORMAT_5_5_5_1\0" /* 40638 */
	"IMG_DATA_FORMAT_4_4_4_4\0" /* 40662 */
	"IMG_DATA_FORMAT_8_24\0" /* 40686 */
	"IMG_DATA_FORMAT_24_8\0" /* 40707 */
	"IMG_DATA_FORMAT_X24_8_32\0" /* 40728 */
	"IMG_DATA_FORMAT_8_AS_8_8_8_8\0" /* 40753 */
	"IMG_DATA_FORMAT_ETC2_RGB\0" /* 40782 */
	"IMG_DATA_FORMAT_ETC2_RGBA\0" /* 40807 */
	"IMG_DATA_FORMAT_ETC2_R\0" /* 40833 */
	"IMG_DATA_FORMAT_ETC2_RG\0" /* 40856 */
	"IMG_DATA_FORMAT_ETC2_RGBA1\0" /* 40880 */
	"IMG_DATA_FORMAT_RESERVED_29\0" /* 40907 */
	"IMG_DATA_FORMAT_RESERVED_30\0" /* 40935 */
	"IMG_DATA_FORMAT_RESERVED_31\0" /* 40963 */
	"IMG_DATA_FORMAT_GB_GR\0" /* 40991 */
	"IMG_DATA_FORMAT_BG_RG\0" /* 41013 */
	"IMG_DATA_FORMAT_5_9_9_9\0" /* 41035 */
	"IMG_DATA_FORMAT_BC1\0" /* 41059 */
	"IMG_DATA_FORMAT_BC2\0" /* 41079 */
	"IMG_DATA_FORMAT_BC3\0" /* 41099 */
	"IMG_DATA_FORMAT_BC4\0" /* 41119 */
	"IMG_DATA_FORMAT_BC5\0" /* 41139 */
	"IMG_DATA_FORMAT_BC6\0" /* 41159 */
	"IMG_DATA_FORMAT_BC7\0" /* 41179 */
	"IMG_DATA_FORMAT_16_AS_16_16_16_16_GFX6\0" /* 41199 */
	"IMG_DATA_FORMAT_16_AS_32_32_32_32_GFX6\0" /* 41238 */
	"IMG_DATA_FORMAT_FMASK8_S2_F1\0" /* 41277 */
	"IMG_DATA_FORMAT_FMASK8_S4_F1\0" /* 41306 */
	"IMG_DATA_FORMAT_FMASK8_S8_F1\0" /* 41335 */
	"IMG_DATA_FORMAT_FMASK8_S2_F2\0" /* 41364 */
	"IMG_DATA_FORMAT_FMASK8_S4_F2\0" /* 41393 */
	"IMG_DATA_FORMAT_FMASK8_S4_F4\0" /* 41422 */
	"IMG_DATA_FORMAT_FMASK16_S16_F1\0" /* 41451 */
	"IMG_DATA_FORMAT_FMASK16_S8_F2\0" /* 41482 */
	"IMG_DATA_FORMAT_FMASK32_S16_F2\0" /* 41512 */
	"IMG_DATA_FORMAT_FMASK32_S8_F4\0" /* 41543 */
	"IMG_DATA_FORMAT_FMASK32_S8_F8\0" /* 41573 */
	"IMG_DATA_FORMAT_FMASK64_S16_F4\0" /* 41603 */
	"IMG_DATA_FORMAT_FMASK64_S16_F8\0" /* 41634 */
	"IMG_DATA_FORMAT_4_4\0" /* 41665 */
	"IMG_DATA_FORMAT_6_5_5\0" /* 41685 */
	"IMG_DATA_FORMAT_1\0" /* 41707 */
	"IMG_DATA_FORMAT_1_REVERSED\0" /* 41725 */
	"IMG_DATA_FORMAT_32_AS_8\0" /* 41752 */
	"IMG_DATA_FORMAT_32_AS_8_8\0" /* 41776 */
	"IMG_DATA_FORMAT_32_AS_32_32_32_32\0" /* 41802 */
	"DATA_FORMAT_GFX6\0" /* 41836 */
	"IMG_NUM_FORMAT_UNORM\0" /* 41853 */
	"IMG_NUM_FORMAT_SNORM\0" /* 41874 */
	"IMG_NUM_FORMAT_USCALED\0" /* 41895 */
	"IMG_NUM_FORMAT_SSCALED\0" /* 41918 */
	"IMG_NUM_FORMAT_UINT\0" /* 41941 */
	"IMG_NUM_FORMAT_SINT\0" /* 41961 */
	"IMG_NUM_FORMAT_SNORM_OGL\0" /* 41981 */
	"IMG_NUM_FORMAT_FLOAT\0" /* 42006 */
	"IMG_NUM_FORMAT_RESERVED_8\0" /* 42027 */
	"IMG_NUM_FORMAT_SRGB\0" /* 42053 */
	"IMG_NUM_FORMAT_UBNORM\0" /* 42073 */
	"IMG_NUM_FORMAT_UBNORM_OGL\0" /* 42095 */
	"IMG_NUM_FORMAT_UBINT\0" /* 42121 */
	"IMG_NUM_FORMAT_UBSCALED\0" /* 42142 */
	"IMG_NUM_FORMAT_RESERVED_14\0" /* 42166 */
	"IMG_NUM_FORMAT_RESERVED_15\0" /* 42193 */
	"NUM_FORMAT_GFX6\0" /* 42220 */
	"WIDTH\0" /* 42236 */
	"HEIGHT\0" /* 42242 */
	"PERF_MOD\0" /* 42249 */
	"INTERLACED\0" /* 42258 */
	"BASE_LEVEL\0" /* 42269 */
	"LAST_LEVEL\0" /* 42280 */
	"TILING_INDEX\0" /* 42291 */
	"POW2_PAD\0" /* 42304 */
	"SQ_RSRC_IMG_RSVD_0\0" /* 42313 */
	"SQ_RSRC_IMG_RSVD_1\0" /* 42332 */
	"SQ_RSRC_IMG_RSVD_2\0" /* 42351 */
	"SQ_RSRC_IMG_RSVD_3\0" /* 42370 */
	"SQ_RSRC_IMG_RSVD_4\0" /* 42389 */
	"SQ_RSRC_IMG_RSVD_5\0" /* 42408 */
	"SQ_RSRC_IMG_RSVD_6\0" /* 42427 */
	"SQ_RSRC_IMG_RSVD_7\0" /* 42446 */
	"SQ_RSRC_IMG_1D\0" /* 42465, 42477 */
	"SQ_RSRC_IMG_2D\0" /* 42480, 42492 */
	"SQ_RSRC_IMG_3D\0" /* 42507, 42495 */
	"SQ_RSRC_IMG_CUBE\0" /* 42510 */
	"SQ_RSRC_IMG_1D_ARRAY\0" /* 42527 */
	"SQ_RSRC_IMG_2D_ARRAY\0" /* 42548 */
	"SQ_RSRC_IMG_2D_MSAA\0" /* 42569 */
	"SQ_RSRC_IMG_2D_MSAA_ARRAY\0" /* 42589 */
	"PITCH_GFX6\0" /* 42615 */
	"BASE_ARRAY\0" /* 42626 */
	"LAST_ARRAY\0" /* 42637 */
	"MIN_LOD_WARN\0" /* 42648 */
	"COUNTER_BANK_ID\0" /* 42661 */
	"LOD_HDW_CNT_EN\0" /* 42677 */
	"COMPRESSION_EN\0" /* 42692 */
	"ALPHA_IS_ON_MSB\0" /* 42707 */
	"COLOR_TRANSFORM\0" /* 42723 */
	"LOST_ALPHA_BITS\0" /* 42739 */
	"LOST_COLOR_BITS\0" /* 42755 */
	"SQ_TEX_WRAP\0" /* 42771 */
	"SQ_TEX_MIRROR\0" /* 42783 */
	"SQ_TEX_CLAMP_LAST_TEXEL\0" /* 42797 */
	"SQ_TEX_MIRROR_ONCE_LAST_TEXEL\0" /* 42821 */
	"SQ_TEX_CLAMP_HALF_BORDER\0" /* 42851 */
	"SQ_TEX_MIRROR_ONCE_HALF_BORDER\0" /* 42876 */
	"SQ_TEX_CLAMP_BORDER\0" /* 42907 */
	"SQ_TEX_MIRROR_ONCE_BORDER\0" /* 42927 */
	"CLAMP_X\0" /* 42953 */
	"CLAMP_Y\0" /* 42961 */
	"CLAMP_Z\0" /* 42969 */
	"MAX_ANISO_RATIO\0" /* 42977 */
	"SQ_TEX_DEPTH_COMPARE_NEVER\0" /* 42993 */
	"SQ_TEX_DEPTH_COMPARE_LESS\0" /* 43020 */
	"SQ_TEX_DEPTH_COMPARE_EQUAL\0" /* 43046 */
	"SQ_TEX_DEPTH_COMPARE_LESSEQUAL\0" /* 43073 */
	"SQ_TEX_DEPTH_COMPARE_GREATER\0" /* 43104 */
	"SQ_TEX_DEPTH_COMPARE_NOTEQUAL\0" /* 43133 */
	"SQ_TEX_DEPTH_COMPARE_GREATEREQUAL\0" /* 43163 */
	"SQ_TEX_DEPTH_COMPARE_ALWAYS\0" /* 43218, 43197 */
	"DEPTH_COMPARE_FUNC\0" /* 43225 */
	"FORCE_UNNORMALIZED\0" /* 43244 */
	"ANISO_THRESHOLD\0" /* 43263 */
	"MC_COORD_TRUNC\0" /* 43279 */
	"FORCE_DEGAMMA\0" /* 43294 */
	"ANISO_BIAS\0" /* 43308 */
	"TRUNC_COORD\0" /* 43319 */
	"DISABLE_CUBE_WRAP\0" /* 43331 */
	"FILTER_MODE\0" /* 43349 */
	"COMPAT_MODE\0" /* 43361 */
	"MAX_LOD\0" /* 43373 */
	"PERF_MIP\0" /* 43381 */
	"PERF_Z\0" /* 43390 */
	"LOD_BIAS\0" /* 43397 */
	"LOD_BIAS_SEC\0" /* 43406 */
	"SQ_TEX_XY_FILTER_POINT\0" /* 43433, 43419 */
	"SQ_TEX_XY_FILTER_BILINEAR\0" /* 43442, 43461 */
	"XY_MAG_FILTER\0" /* 43468 */
	"SQ_TEX_XY_FILTER_ANISO_POINT\0" /* 43482 */
	"SQ_TEX_XY_FILTER_ANISO_BILINEAR\0" /* 43511 */
	"XY_MIN_FILTER\0" /* 43543 */
	"SQ_TEX_Z_FILTER_NONE\0" /* 43557 */
	"SQ_TEX_Z_FILTER_POINT\0" /* 43578 */
	"SQ_TEX_Z_FILTER_LINEAR\0" /* 43600 */
	"Z_FILTER\0" /* 43623 */
	"MIP_FILTER\0" /* 43632 */
	"MIP_POINT_PRECLAMP\0" /* 43643 */
	"DISABLE_LSB_CEIL\0" /* 43662 */
	"FILTER_PREC_FIX\0" /* 43679 */
	"ANISO_OVERRIDE\0" /* 43695 */
	"BORDER_COLOR_PTR\0" /* 43710 */
	"UPGRADED_DEPTH\0" /* 43727 */
	"SQ_TEX_BORDER_COLOR_TRANS_BLACK\0" /* 43742 */
	"SQ_TEX_BORDER_COLOR_OPAQUE_BLACK\0" /* 43774 */
	"SQ_TEX_BORDER_COLOR_OPAQUE_WHITE\0" /* 43807 */
	"SQ_TEX_BORDER_COLOR_REGISTER\0" /* 43840 */
	"BORDER_COLOR_TYPE\0" /* 43869 */
	"VS_LOW_THRESHOLD\0" /* 43887 */
	"GS_LOW_THRESHOLD\0" /* 43904 */
	"ES_LOW_THRESHOLD\0" /* 43921 */
	"HS_LOW_THRESHOLD\0" /* 43938 */
	"LS_LOW_THRESHOLD\0" /* 43955 */
	"PS_CU_EN\0" /* 43972, 43975 */
	"VS_CU_EN\0" /* 43981 */
	"GS_CU_EN\0" /* 43990 */
	"ES_CU_EN\0" /* 43999 */
	"LSHS_CU_EN\0" /* 44008 */
	"X_R0\0" /* 44019 */
	"RING_ORDER_TS0\0" /* 44024 */
	"RING_ORDER_TS1\0" /* 44039 */
	"RING_ORDER_TS2\0" /* 44054 */
	"PIPE_ORDER_TS0\0" /* 44069 */
	"PIPE_ORDER_TS1\0" /* 44084 */
	"PIPE_ORDER_TS2\0" /* 44099 */
	"PIPE_ORDER_TS3\0" /* 44114 */
	"TS0_DUR_MULT\0" /* 44129 */
	"TS1_DUR_MULT\0" /* 44142 */
	"TS2_DUR_MULT\0" /* 44155 */
	"TS3_DUR_MULT\0" /* 44168 */
	"TS0_DURATION\0" /* 44181 */
	"TS1_DURATION\0" /* 44194 */
	"TS2_DURATION\0" /* 44207 */
	"GPR_WRITE_PRIORITY\0" /* 44220 */
	"EXP_PRIORITY_ORDER\0" /* 44239 */
	"ENABLE_SQG_TOP_EVENTS\0" /* 44258 */
	"ENABLE_SQG_BOP_EVENTS\0" /* 44280 */
	"RSRC_MGMT_RESET\0" /* 44302 */
	"X_DELAY_14_CLKS\0" /* 44318 */
	"X_DELAY_16_CLKS\0" /* 44334 */
	"X_DELAY_18_CLKS\0" /* 44350 */
	"X_DELAY_20_CLKS\0" /* 44366 */
	"X_DELAY_22_CLKS\0" /* 44382 */
	"X_DELAY_24_CLKS\0" /* 44398 */
	"X_DELAY_26_CLKS\0" /* 44414 */
	"X_DELAY_28_CLKS\0" /* 44430 */
	"X_DELAY_30_CLKS\0" /* 44446 */
	"X_DELAY_32_CLKS\0" /* 44462 */
	"X_DELAY_34_CLKS\0" /* 44478 */
	"X_DELAY_4_CLKS\0" /* 44494 */
	"X_DELAY_6_CLKS\0" /* 44509 */
	"X_DELAY_8_CLKS\0" /* 44524 */
	"X_DELAY_10_CLKS\0" /* 44539 */
	"X_DELAY_12_CLKS\0" /* 44555 */
	"VTX_DONE_DELAY\0" /* 44571 */
	"INTERP_ONE_PRIM_PER_ROW\0" /* 44586 */
	"PC_LIMIT_ENABLE\0" /* 44610 */
	"PC_LIMIT_STRICT\0" /* 44626 */
	"PC_LIMIT_SIZE\0" /* 44642 */
	"TYPE_A\0" /* 44656 */
	"VGPR_A\0" /* 44663 */
	"SGPR_A\0" /* 44670 */
	"LDS_A\0" /* 44677 */
	"WAVES_A\0" /* 44683 */
	"EN_A\0" /* 44691 */
	"TYPE_B\0" /* 44696 */
	"VGPR_B\0" /* 44703 */
	"SGPR_B\0" /* 44710 */
	"LDS_B\0" /* 44717 */
	"WAVES_B\0" /* 44723 */
	"EN_B\0" /* 44731 */
	"MSAA1_X\0" /* 44736 */
	"MSAA1_Y\0" /* 44744 */
	"MSAA2_X\0" /* 44752 */
	"MSAA2_Y\0" /* 44760 */
	"MSAA4_X\0" /* 44768 */
	"MSAA4_Y\0" /* 44776 */
	"MSAA8_X\0" /* 44784 */
	"MSAA8_Y\0" /* 44792 */
	"MSAA16_X\0" /* 44800 */
	"MSAA16_Y\0" /* 44809 */
	"NUM_PIPES\0" /* 44818 */
	"PIPE_INTERLEAVE_SIZE_GFX6\0" /* 44828 */
	"BANK_INTERLEAVE_SIZE\0" /* 44854 */
	"NUM_SHADER_ENGINES_GFX6\0" /* 44875 */
	"SHADER_ENGINE_TILE_SIZE\0" /* 44899 */
	"NUM_GPUS_GFX6\0" /* 44923 */
	"MULTI_GPU_TILE_SIZE\0" /* 44937 */
	"ROW_SIZE\0" /* 44957 */
	"NUM_LOWER_PIPES\0" /* 44966 */
	"ADDR_SURF_DISPLAY_MICRO_TILING\0" /* 44982 */
	"ADDR_SURF_THIN_MICRO_TILING\0" /* 45013 */
	"ADDR_SURF_DEPTH_MICRO_TILING\0" /* 45041 */
	"ADDR_SURF_THICK_MICRO_TILING\0" /* 45070 */
	"MICRO_TILE_MODE\0" /* 45099 */
	"ARRAY_LINEAR_GENERAL\0" /* 45121, 45115 */
	"ARRAY_LINEAR_ALIGNED\0" /* 45136 */
	"ARRAY_1D_TILED_THIN1\0" /* 45157 */
	"ARRAY_1D_TILED_THICK\0" /* 45178 */
	"ARRAY_2D_TILED_THIN1\0" /* 45199 */
	"ARRAY_2D_TILED_THICK\0" /* 45220 */
	"ARRAY_2D_TILED_XTHICK\0" /* 45241 */
	"ARRAY_3D_TILED_THIN1\0" /* 45263 */
	"ARRAY_3D_TILED_THICK\0" /* 45284 */
	"ARRAY_3D_TILED_XTHICK\0" /* 45305 */
	"ARRAY_POWER_SAVE\0" /* 45327 */
	"ARRAY_MODE\0" /* 45344 */
	"ADDR_SURF_P2\0" /* 45355 */
	"ADDR_SURF_P2_RESERVED0\0" /* 45368 */
	"ADDR_SURF_P2_RESERVED1\0" /* 45391 */
	"ADDR_SURF_P2_RESERVED2\0" /* 45427, 45414 */
	"X_ADDR_SURF_P4_8X16\0" /* 45437 */
	"X_ADDR_SURF_P4_16X16\0" /* 45457 */
	"X_ADDR_SURF_P4_16X32\0" /* 45478 */
	"X_ADDR_SURF_P4_32X32\0" /* 45499 */
	"X_ADDR_SURF_P8_16X16_8X16\0" /* 45520 */
	"X_ADDR_SURF_P8_16X32_8X16\0" /* 45546 */
	"X_ADDR_SURF_P8_32X32_8X16\0" /* 45572 */
	"X_ADDR_SURF_P8_16X32_16X16\0" /* 45598 */
	"X_ADDR_SURF_P8_32X32_16X16\0" /* 45625 */
	"X_ADDR_SURF_P8_32X32_16X32\0" /* 45652 */
	"X_ADDR_SURF_P8_32X64_32X32\0" /* 45679 */
	"PIPE_CONFIG\0" /* 45706 */
	"ADDR_SURF_TILE_SPLIT_64B\0" /* 45718 */
	"ADDR_SURF_TILE_SPLIT_128B\0" /* 45743 */
	"ADDR_SURF_TILE_SPLIT_256B\0" /* 45769 */
	"ADDR_SURF_TILE_SPLIT_512B\0" /* 45795 */
	"ADDR_SURF_TILE_SPLIT_1KB\0" /* 45821 */
	"ADDR_SURF_TILE_SPLIT_2KB\0" /* 45846 */
	"ADDR_SURF_TILE_SPLIT_4KB\0" /* 45871 */
	"TILE_SPLIT\0" /* 45896 */
	"ADDR_SURF_BANK_WIDTH_1\0" /* 45907 */
	"ADDR_SURF_BANK_WIDTH_2\0" /* 45930 */
	"ADDR_SURF_BANK_WIDTH_4\0" /* 45953 */
	"ADDR_SURF_BANK_WIDTH_8\0" /* 45976 */
	"BANK_WIDTH\0" /* 45999 */
	"ADDR_SURF_BANK_HEIGHT_1\0" /* 46010 */
	"ADDR_SURF_BANK_HEIGHT_2\0" /* 46034 */
	"ADDR_SURF_BANK_HEIGHT_4\0" /* 46058 */
	"ADDR_SURF_BANK_HEIGHT_8\0" /* 46082 */
	"BANK_HEIGHT\0" /* 46106 */
	"ADDR_SURF_MACRO_ASPECT_1\0" /* 46118 */
	"ADDR_SURF_MACRO_ASPECT_2\0" /* 46143 */
	"ADDR_SURF_MACRO_ASPECT_4\0" /* 46168 */
	"ADDR_SURF_MACRO_ASPECT_8\0" /* 46193 */
	"MACRO_TILE_ASPECT\0" /* 46218 */
	"ADDR_SURF_2_BANK\0" /* 46236 */
	"ADDR_SURF_4_BANK\0" /* 46253 */
	"ADDR_SURF_8_BANK\0" /* 46270 */
	"ADDR_SURF_16_BANK\0" /* 46287 */
	"NUM_BANKS\0" /* 46305 */
	"ADDR_SURF_ROTATED_MICRO_TILING\0" /* 46315 */
	"MICRO_TILE_MODE_NEW\0" /* 46346 */
	"SAMPLE_SPLIT\0" /* 46366 */
	"MEM_BASE\0" /* 46379 */
	"WAVE_LIMIT\0" /* 46388 */
	"LOCK_LOW_THRESHOLD\0" /* 46399 */
	"VGPRS\0" /* 46418 */
	"SGPRS\0" /* 46424 */
	"FP_32_DENORMS\0" /* 46430 */
	"FP_64_DENORMS\0" /* 46444 */
	"FP_ALL_DENORMS\0" /* 46458 */
	"FLOAT_MODE\0" /* 46473 */
	"PRIV\0" /* 46484 */
	"DX10_CLAMP\0" /* 46489 */
	"DEBUG_MODE\0" /* 46500 */
	"IEEE_MODE\0" /* 46511 */
	"CU_GROUP_DISABLE\0" /* 46521 */
	"CACHE_CTL\0" /* 46538 */
	"CDBG_USER\0" /* 46548 */
	"SCRATCH_EN\0" /* 46558 */
	"USER_SGPR\0" /* 46569 */
	"TRAP_PRESENT\0" /* 46579 */
	"WAVE_CNT_EN\0" /* 46592 */
	"EXTRA_LDS_SIZE\0" /* 46610, 46604 */
	"EXCP_EN_SI\0" /* 46619 */
	"EXCP_EN\0" /* 46630 */
	"VGPR_COMP_CNT\0" /* 46638 */
	"CU_GROUP_ENABLE\0" /* 46652 */
	"OC_LDS_EN\0" /* 46668 */
	"SO_BASE0_EN\0" /* 46678 */
	"SO_BASE1_EN\0" /* 46690 */
	"SO_BASE2_EN\0" /* 46702 */
	"SO_BASE3_EN\0" /* 46714 */
	"SO_EN\0" /* 46726 */
	"DISPATCH_DRAW_EN\0" /* 46732 */
	"GROUP_FIFO_DEPTH\0" /* 46749 */
	"TG_SIZE_EN\0" /* 46766 */
	"EXCP_EN_CIK_VI\0" /* 46777 */
	"COMPUTE_SHADER_EN\0" /* 46792 */
	"PARTIAL_TG_EN\0" /* 46810 */
	"FORCE_START_AT_000\0" /* 46824 */
	"ORDERED_APPEND_ENBL\0" /* 46843 */
	"ORDERED_APPEND_MODE\0" /* 46863 */
	"USE_THREAD_DIMENSIONS\0" /* 46883 */
	"ORDER_MODE\0" /* 46905 */
	"DISPATCH_CACHE_CNTL\0" /* 46916 */
	"SCALAR_L1_INV_VOL\0" /* 46936, 46950 */
	"VECTOR_L1_INV_VOL\0" /* 46954 */
	"DATA_ATC\0" /* 46972 */
	"RESTORE\0" /* 46981 */
	"NUM_THREAD_FULL\0" /* 46989 */
	"NUM_THREAD_PARTIAL\0" /* 47005 */
	"INST_ATC\0" /* 47024 */
	"BULKY\0" /* 47033 */
	"TGID_X_EN\0" /* 47039 */
	"TGID_Y_EN\0" /* 47049 */
	"TGID_Z_EN\0" /* 47059 */
	"TIDIG_COMP_CNT\0" /* 47069 */
	"EXCP_EN_MSB\0" /* 47084 */
	"WAVES_PER_SH_SI\0" /* 47096 */
	"WAVES_PER_SH\0" /* 47112 */
	"TG_PER_CU\0" /* 47125 */
	"LOCK_THRESHOLD\0" /* 47135 */
	"SIMD_DEST_CNTL\0" /* 47150 */
	"FORCE_SIMD_DIST\0" /* 47165 */
	"CU_GROUP_COUNT\0" /* 47181 */
	"SH0_CU_EN\0" /* 47196 */
	"SH1_CU_EN\0" /* 47206 */
	"WAVES\0" /* 47216 */
	"WAVESIZE\0" /* 47222 */
	"SEND_SEID\0" /* 47231 */
	"RESERVED3\0" /* 47241 */
	"RESERVED4\0" /* 47251 */
	"WAVE_ID_BASE\0" /* 47261 */
	"PAYLOAD\0" /* 47274 */
	"IS_EVENT\0" /* 47282 */
	"IS_STATE\0" /* 47291 */
	"PERF_SEL\0" /* 47300 */
	"PERF_SEL1\0" /* 47309 */
	"CNTR_MODE\0" /* 47319 */
	"PERF_SEL2\0" /* 47329 */
	"PERF_SEL3\0" /* 47339 */
	"DISABLE_AND_RESET\0" /* 47349 */
	"START_COUNTING\0" /* 47367 */
	"STOP_COUNTING\0" /* 47382 */
	"PERFMON_STATE\0" /* 47396 */
	"SPM_PERFMON_STATE\0" /* 47410 */
	"PERFMON_ENABLE_MODE\0" /* 47428 */
	"PERFMON_SAMPLE_ENABLE\0" /* 47448 */
	"DB_CLEAN_USER_DEFINED_MASK\0" /* 47470 */
	"CB_CLEAN_USER_DEFINED_MASK\0" /* 47497 */
	"VGT_BUSY_USER_DEFINED_MASK\0" /* 47524 */
	"TA_BUSY_USER_DEFINED_MASK\0" /* 47551 */
	"SX_BUSY_USER_DEFINED_MASK\0" /* 47577 */
	"SPI_BUSY_USER_DEFINED_MASK\0" /* 47603 */
	"SC_BUSY_USER_DEFINED_MASK\0" /* 47630 */
	"PA_BUSY_USER_DEFINED_MASK\0" /* 47656 */
	"GRBM_BUSY_USER_DEFINED_MASK\0" /* 47682 */
	"DB_BUSY_USER_DEFINED_MASK\0" /* 47710 */
	"CB_BUSY_USER_DEFINED_MASK\0" /* 47736 */
	"CP_BUSY_USER_DEFINED_MASK\0" /* 47762 */
	"IA_BUSY_USER_DEFINED_MASK\0" /* 47788 */
	"GDS_BUSY_USER_DEFINED_MASK\0" /* 47814 */
	"BCI_BUSY_USER_DEFINED_MASK\0" /* 47841 */
	"RLC_BUSY_USER_DEFINED_MASK\0" /* 47868 */
	"TC_BUSY_USER_DEFINED_MASK\0" /* 47895 */
	"WD_BUSY_USER_DEFINED_MASK\0" /* 47921 */
	"PERF_MODE\0" /* 47947 */
	"PERF_MODE1\0" /* 47957 */
	"PERF_MODE3\0" /* 47968 */
	"PERF_MODE2\0" /* 47979 */
	"PERF_SEID_IGNORE_MASK\0" /* 47990 */
	"BIN0_MIN\0" /* 48012 */
	"BIN0_MAX\0" /* 48021 */
	"BIN1_MIN\0" /* 48030 */
	"BIN1_MAX\0" /* 48039 */
	"BIN2_MIN\0" /* 48048 */
	"BIN2_MAX\0" /* 48057 */
	"BIN3_MIN\0" /* 48066 */
	"BIN3_MAX\0" /* 48075 */
	"SQC_BANK_MASK\0" /* 48084 */
	"SQC_CLIENT_MASK\0" /* 48098 */
	"SPM_MODE\0" /* 48114 */
	"SIMD_MASK\0" /* 48123 */
	"PS_EN\0" /* 48133 */
	"VS_EN\0" /* 48139 */
	"GS_EN\0" /* 48145 */
	"HS_EN\0" /* 48151 */
	"LS_EN\0" /* 48157 */
	"CS_EN\0" /* 48163 */
	"CNTR_RATE\0" /* 48169 */
	"DISABLE_FLUSH\0" /* 48179 */
	"SH0_MASK\0" /* 48193 */
	"SH1_MASK\0" /* 48202 */
	"FORCE_EN\0" /* 48211 */
	"PERFCOUNTER_SELECT1\0" /* 48220 */
	"PERFCOUNTER_SELECT2\0" /* 48240 */
	"PERFCOUNTER_SELECT3\0" /* 48260 */
	"OP_FILTER_ENABLE\0" /* 48280 */
	"OP_FILTER_SEL\0" /* 48297 */
	"FORMAT_FILTER_ENABLE\0" /* 48311 */
	"FORMAT_FILTER_SEL\0" /* 48332 */
	"CLEAR_FILTER_ENABLE\0" /* 48350 */
	"CLEAR_FILTER_SEL\0" /* 48370 */
	"MRT_FILTER_ENABLE\0" /* 48387 */
	"MRT_FILTER_SEL\0" /* 48405 */
	"NUM_SAMPLES_FILTER_ENABLE\0" /* 48420 */
	"NUM_SAMPLES_FILTER_SEL\0" /* 48446 */
	"NUM_FRAGMENTS_FILTER_ENABLE\0" /* 48469 */
	"NUM_FRAGMENTS_FILTER_SEL\0" /* 48497 */
	"DEPTH_CLEAR_ENABLE\0" /* 48522 */
	"STENCIL_CLEAR_ENABLE\0" /* 48541 */
	"DEPTH_COPY\0" /* 48562 */
	"STENCIL_COPY\0" /* 48573 */
	"RESUMMARIZE_ENABLE\0" /* 48586 */
	"STENCIL_COMPRESS_DISABLE\0" /* 48605 */
	"DEPTH_COMPRESS_DISABLE\0" /* 48630 */
	"COPY_CENTROID\0" /* 48653 */
	"COPY_SAMPLE\0" /* 48667 */
	"DECOMPRESS_ENABLE\0" /* 48679 */
	"ZPASS_INCREMENT_DISABLE\0" /* 48697 */
	"PERFECT_ZPASS_COUNTS\0" /* 48721 */
	"SAMPLE_RATE\0" /* 48742 */
	"ZPASS_ENABLE\0" /* 48754 */
	"ZFAIL_ENABLE\0" /* 48767 */
	"SFAIL_ENABLE\0" /* 48780 */
	"DBFAIL_ENABLE\0" /* 48793 */
	"SLICE_EVEN_ENABLE\0" /* 48807 */
	"SLICE_ODD_ENABLE\0" /* 48825 */
	"SLICE_START\0" /* 48842 */
	"SLICE_MAX\0" /* 48854 */
	"Z_READ_ONLY\0" /* 48864 */
	"STENCIL_READ_ONLY\0" /* 48876 */
	"FORCE_OFF\0" /* 48894 */
	"FORCE_ENABLE\0" /* 48904 */
	"FORCE_DISABLE\0" /* 48917 */
	"FORCE_RESERVED\0" /* 48931 */
	"FORCE_HIZ_ENABLE\0" /* 48946, 48954 */
	"FORCE_HIS_ENABLE0\0" /* 48963, 48973 */
	"FORCE_HIS_ENABLE1\0" /* 48981, 48991 */
	"FORCE_SHADER_Z_ORDER\0" /* 49012, 48999 */
	"FAST_Z_DISABLE\0" /* 49020 */
	"FAST_STENCIL_DISABLE\0" /* 49035 */
	"NOOP_CULL_DISABLE\0" /* 49056 */
	"FORCE_COLOR_KILL\0" /* 49074 */
	"FORCE_Z_READ\0" /* 49091 */
	"FORCE_STENCIL_READ\0" /* 49104 */
	"FORCE_FULL_Z_RANGE\0" /* 49123 */
	"FORCE_QC_SMASK_CONFLICT\0" /* 49142 */
	"DISABLE_VIEWPORT_CLAMP\0" /* 49166 */
	"IGNORE_SC_ZRANGE\0" /* 49189 */
	"DISABLE_FULLY_COVERED\0" /* 49206 */
	"FORCE_SUMM_OFF\0" /* 49228 */
	"FORCE_SUMM_MINZ\0" /* 49243 */
	"FORCE_SUMM_MAXZ\0" /* 49259 */
	"FORCE_SUMM_BOTH\0" /* 49275 */
	"FORCE_Z_LIMIT_SUMM\0" /* 49291 */
	"MAX_TILES_IN_DTT\0" /* 49310 */
	"DISABLE_TILE_RATE_TILES\0" /* 49327 */
	"FORCE_Z_DIRTY\0" /* 49359, 49351 */
	"FORCE_STENCIL_DIRTY\0" /* 49365 */
	"FORCE_Z_VALID\0" /* 49385 */
	"FORCE_STENCIL_VALID\0" /* 49399 */
	"PRESERVE_COMPRESSION\0" /* 49419, 49428 */
	"PSLC_AUTO\0" /* 49440 */
	"PSLC_ON_HANG_ONLY\0" /* 49450 */
	"PSLC_ASAP\0" /* 49468 */
	"PSLC_COUNTDOWN\0" /* 49478 */
	"PARTIAL_SQUAD_LAUNCH_CONTROL\0" /* 49493 */
	"PARTIAL_SQUAD_LAUNCH_COUNTDOWN\0" /* 49522 */
	"DISABLE_ZMASK_EXPCLEAR_OPTIMIZATION\0" /* 49553 */
	"DISABLE_SMEM_EXPCLEAR_OPTIMIZATION\0" /* 49589 */
	"DISABLE_COLOR_ON_VALIDATION\0" /* 49624 */
	"DECOMPRESS_Z_ON_FLUSH\0" /* 49652 */
	"DISABLE_REG_SNOOP\0" /* 49674 */
	"DEPTH_BOUNDS_HIER_DEPTH_DISABLE\0" /* 49692 */
	"SEPARATE_HIZS_FUNC_ENABLE\0" /* 49724 */
	"HIZ_ZFUNC\0" /* 49754, 49750 */
	"HIS_SFUNC_FF\0" /* 49760 */
	"HIS_SFUNC_BF\0" /* 49773 */
	"PRESERVE_ZRANGE\0" /* 49786 */
	"PRESERVE_SRESULTS\0" /* 49802 */
	"DISABLE_FAST_PASS\0" /* 49820 */
	"TL_X\0" /* 49838 */
	"TL_Y\0" /* 49843 */
	"BR_X\0" /* 49848 */
	"BR_Y\0" /* 49853 */
	"ADDR5_SWIZZLE_MASK\0" /* 49858 */
	"ARRAY_PRT_TILED_THIN1\0" /* 49877 */
	"ARRAY_PRT_2D_TILED_THIN1\0" /* 49899 */
	"X_ADDR_SURF_P16_32X32_8X16\0" /* 49924 */
	"X_ADDR_SURF_P16_32X32_16X16\0" /* 49951 */
	"Z_INVALID\0" /* 49979 */
	"Z_16\0" /* 49989 */
	"Z_24\0" /* 49994 */
	"Z_32_FLOAT\0" /* 49999 */
	"NUM_SAMPLES\0" /* 50010 */
	"TILE_MODE_INDEX\0" /* 50022 */
	"DECOMPRESS_ON_N_ZPLANES\0" /* 50038 */
	"ALLOW_EXPCLEAR\0" /* 50062 */
	"READ_SIZE\0" /* 50077 */
	"TILE_SURFACE_ENABLE\0" /* 50087 */
	"CLEAR_DISALLOWED\0" /* 50107 */
	"ZRANGE_PRECISION\0" /* 50124 */
	"STENCIL_INVALID\0" /* 50141 */
	"STENCIL_8\0" /* 50157 */
	"TILE_STENCIL_DISABLE\0" /* 50167 */
	"PITCH_TILE_MAX\0" /* 50194, 50188 */
	"HEIGHT_TILE_MAX\0" /* 50203 */
	"SLICE_TILE_MAX\0" /* 50219 */
	"WINDOW_X_OFFSET\0" /* 50234 */
	"WINDOW_Y_OFFSET\0" /* 50257, 50250 */
	"WINDOW_OFFSET_DISABLE\0" /* 50266 */
	"CLIP_RULE\0" /* 50288 */
	"ER_TRI\0" /* 50298 */
	"ER_RECT\0" /* 50305 */
	"ER_LINE_LR\0" /* 50313 */
	"ER_LINE_RL\0" /* 50324 */
	"ER_LINE_TB\0" /* 50335 */
	"ER_LINE_BT\0" /* 50346 */
	"HW_SCREEN_OFFSET_X\0" /* 50357 */
	"HW_SCREEN_OFFSET_Y\0" /* 50376 */
	"TARGET0_ENABLE\0" /* 50395 */
	"TARGET1_ENABLE\0" /* 50410 */
	"TARGET2_ENABLE\0" /* 50425 */
	"TARGET3_ENABLE\0" /* 50440 */
	"TARGET4_ENABLE\0" /* 50455 */
	"TARGET5_ENABLE\0" /* 50470 */
	"TARGET6_ENABLE\0" /* 50485 */
	"TARGET7_ENABLE\0" /* 50500 */
	"OUTPUT0_ENABLE\0" /* 50515 */
	"OUTPUT1_ENABLE\0" /* 50530 */
	"OUTPUT2_ENABLE\0" /* 50545 */
	"OUTPUT3_ENABLE\0" /* 50560 */
	"OUTPUT4_ENABLE\0" /* 50575 */
	"OUTPUT5_ENABLE\0" /* 50590 */
	"OUTPUT6_ENABLE\0" /* 50605 */
	"OUTPUT7_ENABLE\0" /* 50620 */
	"RASTER_CONFIG_RB_MAP_0\0" /* 50635 */
	"RASTER_CONFIG_RB_MAP_1\0" /* 50658 */
	"RASTER_CONFIG_RB_MAP_2\0" /* 50681 */
	"RASTER_CONFIG_RB_MAP_3\0" /* 50704 */
	"RB_MAP_PKR0\0" /* 50727 */
	"RB_MAP_PKR1\0" /* 50739 */
	"RASTER_CONFIG_RB_XSEL2_0\0" /* 50751 */
	"RASTER_CONFIG_RB_XSEL2_1\0" /* 50776 */
	"RASTER_CONFIG_RB_XSEL2_2\0" /* 50801 */
	"RASTER_CONFIG_RB_XSEL2_3\0" /* 50826 */
	"RB_XSEL2\0" /* 50851 */
	"RB_XSEL\0" /* 50860 */
	"RB_YSEL\0" /* 50868 */
	"RASTER_CONFIG_PKR_MAP_0\0" /* 50876 */
	"RASTER_CONFIG_PKR_MAP_1\0" /* 50900 */
	"RASTER_CONFIG_PKR_MAP_2\0" /* 50924 */
	"RASTER_CONFIG_PKR_MAP_3\0" /* 50948 */
	"PKR_MAP\0" /* 50972 */
	"RASTER_CONFIG_PKR_XSEL_0\0" /* 50980 */
	"RASTER_CONFIG_PKR_XSEL_1\0" /* 51005 */
	"RASTER_CONFIG_PKR_XSEL_2\0" /* 51030 */
	"RASTER_CONFIG_PKR_XSEL_3\0" /* 51055 */
	"PKR_XSEL\0" /* 51080 */
	"RASTER_CONFIG_PKR_YSEL_0\0" /* 51089 */
	"RASTER_CONFIG_PKR_YSEL_1\0" /* 51114 */
	"RASTER_CONFIG_PKR_YSEL_2\0" /* 51139 */
	"RASTER_CONFIG_PKR_YSEL_3\0" /* 51164 */
	"PKR_YSEL\0" /* 51189 */
	"RASTER_CONFIG_PKR_XSEL2_0\0" /* 51198 */
	"RASTER_CONFIG_PKR_XSEL2_1\0" /* 51224 */
	"RASTER_CONFIG_PKR_XSEL2_2\0" /* 51250 */
	"RASTER_CONFIG_PKR_XSEL2_3\0" /* 51276 */
	"PKR_XSEL2\0" /* 51302 */
	"RASTER_CONFIG_SC_MAP_0\0" /* 51312 */
	"RASTER_CONFIG_SC_MAP_1\0" /* 51335 */
	"RASTER_CONFIG_SC_MAP_2\0" /* 51358 */
	"RASTER_CONFIG_SC_MAP_3\0" /* 51381 */
	"SC_MAP\0" /* 51404 */
	"RASTER_CONFIG_SC_XSEL_8_WIDE_TILE\0" /* 51411 */
	"RASTER_CONFIG_SC_XSEL_16_WIDE_TILE\0" /* 51445 */
	"RASTER_CONFIG_SC_XSEL_32_WIDE_TILE\0" /* 51480 */
	"RASTER_CONFIG_SC_XSEL_64_WIDE_TILE\0" /* 51515 */
	"SC_XSEL\0" /* 51550 */
	"RASTER_CONFIG_SC_YSEL_8_WIDE_TILE\0" /* 51558 */
	"RASTER_CONFIG_SC_YSEL_16_WIDE_TILE\0" /* 51592 */
	"RASTER_CONFIG_SC_YSEL_32_WIDE_TILE\0" /* 51627 */
	"RASTER_CONFIG_SC_YSEL_64_WIDE_TILE\0" /* 51662 */
	"SC_YSEL\0" /* 51697 */
	"RASTER_CONFIG_SE_MAP_0\0" /* 51705 */
	"RASTER_CONFIG_SE_MAP_1\0" /* 51728 */
	"RASTER_CONFIG_SE_MAP_2\0" /* 51751 */
	"RASTER_CONFIG_SE_MAP_3\0" /* 51774 */
	"SE_MAP\0" /* 51797 */
	"RASTER_CONFIG_SE_XSEL_8_WIDE_TILE\0" /* 51804 */
	"RASTER_CONFIG_SE_XSEL_16_WIDE_TILE\0" /* 51838 */
	"RASTER_CONFIG_SE_XSEL_32_WIDE_TILE\0" /* 51873 */
	"RASTER_CONFIG_SE_XSEL_64_WIDE_TILE\0" /* 51908 */
	"SE_XSEL_GFX6\0" /* 51943 */
	"RASTER_CONFIG_SE_YSEL_8_WIDE_TILE\0" /* 51956 */
	"RASTER_CONFIG_SE_YSEL_16_WIDE_TILE\0" /* 51990 */
	"RASTER_CONFIG_SE_YSEL_32_WIDE_TILE\0" /* 52025 */
	"RASTER_CONFIG_SE_YSEL_64_WIDE_TILE\0" /* 52060 */
	"SE_YSEL_GFX6\0" /* 52095 */
	"RASTER_CONFIG_SE_PAIR_MAP_0\0" /* 52108 */
	"RASTER_CONFIG_SE_PAIR_MAP_1\0" /* 52136 */
	"RASTER_CONFIG_SE_PAIR_MAP_2\0" /* 52164 */
	"RASTER_CONFIG_SE_PAIR_MAP_3\0" /* 52192 */
	"SE_PAIR_MAP\0" /* 52220 */
	"RASTER_CONFIG_SE_PAIR_XSEL_8_WIDE_TILE\0" /* 52232 */
	"RASTER_CONFIG_SE_PAIR_XSEL_16_WIDE_TILE\0" /* 52271 */
	"RASTER_CONFIG_SE_PAIR_XSEL_32_WIDE_TILE\0" /* 52311 */
	"RASTER_CONFIG_SE_PAIR_XSEL_64_WIDE_TILE\0" /* 52351 */
	"SE_PAIR_XSEL_GFX6\0" /* 52391 */
	"RASTER_CONFIG_SE_PAIR_YSEL_8_WIDE_TILE\0" /* 52409 */
	"RASTER_CONFIG_SE_PAIR_YSEL_16_WIDE_TILE\0" /* 52448 */
	"RASTER_CONFIG_SE_PAIR_YSEL_32_WIDE_TILE\0" /* 52488 */
	"RASTER_CONFIG_SE_PAIR_YSEL_64_WIDE_TILE\0" /* 52528 */
	"SE_PAIR_YSEL_GFX6\0" /* 52568 */
	"OVERWRITE_COMBINER_DISABLE\0" /* 52586 */
	"OVERWRITE_COMBINER_MRT_SHARING_DISABLE\0" /* 52613 */
	"OVERWRITE_COMBINER_WATERMARK\0" /* 52652 */
	"STENCIL_KEEP\0" /* 52681 */
	"STENCIL_ZERO\0" /* 52694 */
	"STENCIL_ONES\0" /* 52707 */
	"STENCIL_REPLACE_TEST\0" /* 52720 */
	"STENCIL_REPLACE_OP\0" /* 52741 */
	"STENCIL_ADD_CLAMP\0" /* 52760 */
	"STENCIL_SUB_CLAMP\0" /* 52778 */
	"STENCIL_INVERT\0" /* 52796 */
	"STENCIL_ADD_WRAP\0" /* 52811 */
	"STENCIL_SUB_WRAP\0" /* 52828 */
	"STENCIL_AND\0" /* 52845 */
	"STENCIL_OR\0" /* 52857 */
	"STENCIL_XOR\0" /* 52868 */
	"STENCIL_NAND\0" /* 52880 */
	"STENCIL_NOR\0" /* 52893 */
	"STENCIL_XNOR\0" /* 52905 */
	"STENCILFAIL\0" /* 52918 */
	"STENCILZPASS\0" /* 52930 */
	"STENCILZFAIL\0" /* 52943 */
	"STENCILFAIL_BF\0" /* 52956 */
	"STENCILZPASS_BF\0" /* 52971 */
	"STENCILZFAIL_BF\0" /* 52987 */
	"STENCILTESTVAL\0" /* 53003 */
	"STENCILMASK\0" /* 53018 */
	"STENCILWRITEMASK\0" /* 53030 */
	"STENCILOPVAL\0" /* 53047 */
	"STENCILTESTVAL_BF\0" /* 53060 */
	"STENCILMASK_BF\0" /* 53078 */
	"STENCILWRITEMASK_BF\0" /* 53093 */
	"STENCILOPVAL_BF\0" /* 53113 */
	"X_0_0F\0" /* 53129 */
	"DEFAULT_VAL\0" /* 53136 */
	"FLAT_SHADE\0" /* 53148 */
	"CYL_WRAP\0" /* 53159 */
	"PT_SPRITE_TEX\0" /* 53168 */
	"DUP\0" /* 53182 */
	"FP16_INTERP_MODE\0" /* 53186 */
	"USE_DEFAULT_ATTR1\0" /* 53203 */
	"DEFAULT_VAL_ATTR1\0" /* 53221 */
	"PT_SPRITE_TEX_ATTR1\0" /* 53239 */
	"ATTR0_VALID\0" /* 53259 */
	"ATTR1_VALID\0" /* 53271 */
	"VS_EXPORT_COUNT\0" /* 53283 */
	"VS_HALF_PACK\0" /* 53299 */
	"VS_EXPORTS_FOG\0" /* 53312 */
	"VS_OUT_FOG_VEC_ADDR\0" /* 53327 */
	"PERSP_SAMPLE_ENA\0" /* 53347 */
	"PERSP_CENTER_ENA\0" /* 53364 */
	"PERSP_CENTROID_ENA\0" /* 53381 */
	"PERSP_PULL_MODEL_ENA\0" /* 53400 */
	"LINEAR_SAMPLE_ENA\0" /* 53421 */
	"LINEAR_CENTER_ENA\0" /* 53439 */
	"LINEAR_CENTROID_ENA\0" /* 53457 */
	"LINE_STIPPLE_TEX_ENA\0" /* 53477 */
	"POS_X_FLOAT_ENA\0" /* 53498 */
	"POS_Y_FLOAT_ENA\0" /* 53514 */
	"POS_Z_FLOAT_ENA\0" /* 53530 */
	"POS_W_FLOAT_ENA\0" /* 53546 */
	"FRONT_FACE_ENA\0" /* 53562 */
	"ANCILLARY_ENA\0" /* 53577 */
	"SAMPLE_COVERAGE_ENA\0" /* 53591 */
	"POS_FIXED_PT_ENA\0" /* 53611 */
	"FLAT_SHADE_ENA\0" /* 53628 */
	"PNT_SPRITE_ENA\0" /* 53643 */
	"SPI_PNT_SPRITE_SEL_0\0" /* 53658 */
	"SPI_PNT_SPRITE_SEL_1\0" /* 53679 */
	"SPI_PNT_SPRITE_SEL_S\0" /* 53700 */
	"SPI_PNT_SPRITE_SEL_T\0" /* 53721 */
	"SPI_PNT_SPRITE_SEL_NONE\0" /* 53742 */
	"PNT_SPRITE_OVRD_X\0" /* 53766 */
	"PNT_SPRITE_OVRD_Y\0" /* 53784 */
	"PNT_SPRITE_OVRD_Z\0" /* 53802 */
	"PNT_SPRITE_OVRD_W\0" /* 53820 */
	"PNT_SPRITE_TOP_1\0" /* 53838 */
	"NUM_INTERP\0" /* 53855 */
	"PARAM_GEN\0" /* 53866 */
	"FOG_ADDR\0" /* 53876 */
	"BC_OPTIMIZE_DISABLE\0" /* 53885 */
	"PASS_FOG_THROUGH_PS\0" /* 53905 */
	"PERSP_CENTER_CNTL\0" /* 53925 */
	"PERSP_CENTROID_CNTL\0" /* 53943 */
	"LINEAR_CENTER_CNTL\0" /* 53963 */
	"LINEAR_CENTROID_CNTL\0" /* 53982 */
	"X_CALCULATE_PER_PIXEL_FLOATING_POINT_POSITION_AT\0" /* 54003 */
	"POS_FLOAT_LOCATION\0" /* 54052 */
	"POS_FLOAT_ULC\0" /* 54071 */
	"FRONT_FACE_ALL_BITS\0" /* 54085 */
	"NUM_PS_WAVES\0" /* 54105 */
	"NUM_VS_WAVES\0" /* 54118 */
	"NUM_GS_WAVES\0" /* 54131 */
	"NUM_ES_WAVES\0" /* 54144 */
	"NUM_HS_WAVES\0" /* 54157 */
	"NUM_LS_WAVES\0" /* 54170 */
	"SPI_SHADER_NONE\0" /* 54183 */
	"SPI_SHADER_1COMP\0" /* 54199 */
	"SPI_SHADER_2COMP\0" /* 54216 */
	"SPI_SHADER_4COMPRESS\0" /* 54233 */
	"SPI_SHADER_4COMP\0" /* 54254 */
	"POS0_EXPORT_FORMAT\0" /* 54271 */
	"POS1_EXPORT_FORMAT\0" /* 54290 */
	"POS2_EXPORT_FORMAT\0" /* 54309 */
	"POS3_EXPORT_FORMAT\0" /* 54328 */
	"SPI_SHADER_ZERO\0" /* 54347 */
	"SPI_SHADER_32_R\0" /* 54363 */
	"SPI_SHADER_32_GR\0" /* 54379 */
	"SPI_SHADER_32_AR\0" /* 54396 */
	"SPI_SHADER_FP16_ABGR\0" /* 54413 */
	"SPI_SHADER_UNORM16_ABGR\0" /* 54434 */
	"SPI_SHADER_SNORM16_ABGR\0" /* 54458 */
	"SPI_SHADER_UINT16_ABGR\0" /* 54482 */
	"SPI_SHADER_SINT16_ABGR\0" /* 54505 */
	"SPI_SHADER_32_ABGR\0" /* 54528 */
	"Z_EXPORT_FORMAT\0" /* 54547 */
	"COL0_EXPORT_FORMAT\0" /* 54563 */
	"COL1_EXPORT_FORMAT\0" /* 54582 */
	"COL2_EXPORT_FORMAT\0" /* 54601 */
	"COL3_EXPORT_FORMAT\0" /* 54620 */
	"COL4_EXPORT_FORMAT\0" /* 54639 */
	"COL5_EXPORT_FORMAT\0" /* 54658 */
	"COL6_EXPORT_FORMAT\0" /* 54677 */
	"COL7_EXPORT_FORMAT\0" /* 54696 */
	"SX_RT_EXPORT_NO_CONVERSION\0" /* 54715 */
	"SX_RT_EXPORT_32_R\0" /* 54742 */
	"SX_RT_EXPORT_32_A\0" /* 54760 */
	"SX_RT_EXPORT_10_11_11\0" /* 54778 */
	"SX_RT_EXPORT_2_10_10_10\0" /* 54800 */
	"SX_RT_EXPORT_8_8_8_8\0" /* 54824 */
	"SX_RT_EXPORT_5_6_5\0" /* 54845 */
	"SX_RT_EXPORT_1_5_5_5\0" /* 54864 */
	"SX_RT_EXPORT_4_4_4_4\0" /* 54885 */
	"SX_RT_EXPORT_16_16_GR\0" /* 54906 */
	"SX_RT_EXPORT_16_16_AR\0" /* 54928 */
	"MRT0\0" /* 54950 */
	"MRT1\0" /* 54955 */
	"MRT2\0" /* 54960 */
	"MRT3\0" /* 54965 */
	"MRT4\0" /* 54970 */
	"MRT5\0" /* 54975 */
	"MRT6\0" /* 54980 */
	"MRT7\0" /* 54985 */
	"EXACT\0" /* 54990 */
	"11BIT_FORMAT\0" /* 54996 */
	"10BIT_FORMAT\0" /* 55009 */
	"8BIT_FORMAT\0" /* 55022 */
	"6BIT_FORMAT\0" /* 55034 */
	"5BIT_FORMAT\0" /* 55046 */
	"4BIT_FORMAT\0" /* 55058 */
	"MRT0_EPSILON\0" /* 55070 */
	"MRT1_EPSILON\0" /* 55083 */
	"MRT2_EPSILON\0" /* 55096 */
	"MRT3_EPSILON\0" /* 55109 */
	"MRT4_EPSILON\0" /* 55122 */
	"MRT5_EPSILON\0" /* 55135 */
	"MRT6_EPSILON\0" /* 55148 */
	"MRT7_EPSILON\0" /* 55161 */
	"MRT0_COLOR_OPT_DISABLE\0" /* 55174 */
	"MRT0_ALPHA_OPT_DISABLE\0" /* 55197 */
	"MRT1_COLOR_OPT_DISABLE\0" /* 55220 */
	"MRT1_ALPHA_OPT_DISABLE\0" /* 55243 */
	"MRT2_COLOR_OPT_DISABLE\0" /* 55266 */
	"MRT2_ALPHA_OPT_DISABLE\0" /* 55289 */
	"MRT3_COLOR_OPT_DISABLE\0" /* 55312 */
	"MRT3_ALPHA_OPT_DISABLE\0" /* 55335 */
	"MRT4_COLOR_OPT_DISABLE\0" /* 55358 */
	"MRT4_ALPHA_OPT_DISABLE\0" /* 55381 */
	"MRT5_COLOR_OPT_DISABLE\0" /* 55404 */
	"MRT5_ALPHA_OPT_DISABLE\0" /* 55427 */
	"MRT6_COLOR_OPT_DISABLE\0" /* 55450 */
	"MRT6_ALPHA_OPT_DISABLE\0" /* 55473 */
	"MRT7_COLOR_OPT_DISABLE\0" /* 55496 */
	"MRT7_ALPHA_OPT_DISABLE\0" /* 55519 */
	"PIXEN_ZERO_OPT_DISABLE\0" /* 55542 */
	"BLEND_OPT_PRESERVE_NONE_IGNORE_ALL\0" /* 55565 */
	"BLEND_OPT_PRESERVE_ALL_IGNORE_NONE\0" /* 55600 */
	"BLEND_OPT_PRESERVE_C1_IGNORE_C0\0" /* 55635 */
	"BLEND_OPT_PRESERVE_C0_IGNORE_C1\0" /* 55667 */
	"BLEND_OPT_PRESERVE_A1_IGNORE_A0\0" /* 55699 */
	"BLEND_OPT_PRESERVE_A0_IGNORE_A1\0" /* 55731 */
	"BLEND_OPT_PRESERVE_NONE_IGNORE_A0\0" /* 55763 */
	"BLEND_OPT_PRESERVE_NONE_IGNORE_NONE\0" /* 55797 */
	"COLOR_SRC_OPT\0" /* 55833 */
	"COLOR_DST_OPT\0" /* 55847 */
	"OPT_COMB_NONE\0" /* 55861 */
	"OPT_COMB_ADD\0" /* 55875 */
	"OPT_COMB_SUBTRACT\0" /* 55888 */
	"OPT_COMB_MIN\0" /* 55906 */
	"OPT_COMB_MAX\0" /* 55919 */
	"OPT_COMB_REVSUBTRACT\0" /* 55932 */
	"OPT_COMB_BLEND_DISABLED\0" /* 55953 */
	"OPT_COMB_SAFE_ADD\0" /* 55977 */
	"COLOR_COMB_FCN\0" /* 55995 */
	"ALPHA_SRC_OPT\0" /* 56010 */
	"ALPHA_DST_OPT\0" /* 56024 */
	"ALPHA_COMB_FCN\0" /* 56038 */
	"BLEND_ZERO\0" /* 56053 */
	"BLEND_ONE\0" /* 56064 */
	"BLEND_SRC_COLOR\0" /* 56074 */
	"BLEND_ONE_MINUS_SRC_COLOR\0" /* 56090 */
	"BLEND_SRC_ALPHA\0" /* 56116 */
	"BLEND_ONE_MINUS_SRC_ALPHA\0" /* 56132 */
	"BLEND_DST_ALPHA\0" /* 56158 */
	"BLEND_ONE_MINUS_DST_ALPHA\0" /* 56174 */
	"BLEND_DST_COLOR\0" /* 56200 */
	"BLEND_ONE_MINUS_DST_COLOR\0" /* 56216 */
	"BLEND_SRC_ALPHA_SATURATE\0" /* 56242 */
	"BLEND_CONSTANT_COLOR\0" /* 56267 */
	"BLEND_ONE_MINUS_CONSTANT_COLOR\0" /* 56288 */
	"BLEND_SRC1_COLOR\0" /* 56319 */
	"BLEND_INV_SRC1_COLOR\0" /* 56336 */
	"BLEND_SRC1_ALPHA\0" /* 56357 */
	"BLEND_INV_SRC1_ALPHA\0" /* 56374 */
	"BLEND_CONSTANT_ALPHA\0" /* 56395 */
	"BLEND_ONE_MINUS_CONSTANT_ALPHA\0" /* 56416 */
	"COLOR_SRCBLEND\0" /* 56447 */
	"COMB_DST_PLUS_SRC\0" /* 56462 */
	"COMB_SRC_MINUS_DST\0" /* 56480 */
	"COMB_MIN_DST_SRC\0" /* 56499 */
	"COMB_MAX_DST_SRC\0" /* 56516 */
	"COMB_DST_MINUS_SRC\0" /* 56533 */
	"COLOR_DESTBLEND\0" /* 56552 */
	"ALPHA_SRCBLEND\0" /* 56568 */
	"ALPHA_DESTBLEND\0" /* 56583 */
	"SEPARATE_ALPHA_BLEND\0" /* 56599 */
	"DISABLE_ROP3\0" /* 56628, 56620 */
	"SRC_STATE_ID\0" /* 56633 */
	"BASE_ADDR_GFX6\0" /* 56646 */
	"DI_SRC_SEL_DMA\0" /* 56661 */
	"DI_SRC_SEL_IMMEDIATE\0" /* 56676 */
	"DI_SRC_SEL_AUTO_INDEX\0" /* 56697 */
	"DI_SRC_SEL_RESERVED\0" /* 56719 */
	"SOURCE_SELECT\0" /* 56739 */
	"DI_MAJOR_MODE_0\0" /* 56753 */
	"DI_MAJOR_MODE_1\0" /* 56769 */
	"MAJOR_MODE\0" /* 56785 */
	"NOT_EOP\0" /* 56796 */
	"USE_OPAQUE\0" /* 56804 */
	"ADDRESS_LOW\0" /* 56815 */
	"STENCIL_ENABLE\0" /* 56827 */
	"Z_WRITE_ENABLE\0" /* 56842 */
	"DEPTH_BOUNDS_ENABLE\0" /* 56857 */
	"FRAG_NEVER\0" /* 56877 */
	"FRAG_LESS\0" /* 56888 */
	"FRAG_EQUAL\0" /* 56898 */
	"FRAG_LEQUAL\0" /* 56909 */
	"FRAG_GREATER\0" /* 56921 */
	"FRAG_NOTEQUAL\0" /* 56934 */
	"FRAG_GEQUAL\0" /* 56948 */
	"FRAG_ALWAYS\0" /* 56960 */
	"BACKFACE_ENABLE\0" /* 56972 */
	"REF_NEVER\0" /* 56988 */
	"REF_LESS\0" /* 56998 */
	"REF_EQUAL\0" /* 57007 */
	"REF_LEQUAL\0" /* 57017 */
	"REF_GREATER\0" /* 57028 */
	"REF_NOTEQUAL\0" /* 57040 */
	"REF_GEQUAL\0" /* 57053 */
	"REF_ALWAYS\0" /* 57064 */
	"STENCILFUNC\0" /* 57075 */
	"STENCILFUNC_BF\0" /* 57087 */
	"ENABLE_COLOR_WRITES_ON_DEPTH_FAIL\0" /* 57102 */
	"DISABLE_COLOR_WRITES_ON_DEPTH_PASS\0" /* 57136 */
	"MAX_ANCHOR_SAMPLES\0" /* 57171 */
	"PS_ITER_SAMPLES\0" /* 57190 */
	"MASK_EXPORT_NUM_SAMPLES\0" /* 57206 */
	"ALPHA_TO_MASK_NUM_SAMPLES\0" /* 57230 */
	"HIGH_QUALITY_INTERSECTIONS\0" /* 57256 */
	"INCOHERENT_EQAA_READS\0" /* 57283 */
	"INTERPOLATE_COMP_Z\0" /* 57305 */
	"INTERPOLATE_SRC_Z\0" /* 57324 */
	"STATIC_ANCHOR_ASSOCIATIONS\0" /* 57342 */
	"ALPHA_TO_MASK_EQAA_DISABLE\0" /* 57369 */
	"OVERRASTERIZATION_AMOUNT\0" /* 57396 */
	"ENABLE_POSTZ_OVERRASTERIZATION\0" /* 57421 */
	"DISABLE_DUAL_QUAD\0" /* 57452 */
	"DEGAMMA_ENABLE\0" /* 57470 */
	"CB_DISABLE\0" /* 57485 */
	"CB_NORMAL\0" /* 57496 */
	"CB_ELIMINATE_FAST_CLEAR\0" /* 57506, 57519 */
	"CB_RESOLVE\0" /* 57530 */
	"CB_FMASK_DECOMPRESS\0" /* 57541 */
	"CB_DCC_DECOMPRESS\0" /* 57561 */
	"X_0X00\0" /* 57579 */
	"X_0X05\0" /* 57586 */
	"X_0X0A\0" /* 57593 */
	"X_0X0F\0" /* 57600 */
	"X_0X11\0" /* 57607 */
	"X_0X22\0" /* 57614 */
	"X_0X33\0" /* 57621 */
	"X_0X44\0" /* 57628 */
	"X_0X50\0" /* 57635 */
	"X_0X55\0" /* 57642 */
	"X_0X5A\0" /* 57649 */
	"X_0X5F\0" /* 57656 */
	"X_0X66\0" /* 57663 */
	"X_0X77\0" /* 57670 */
	"X_0X88\0" /* 57677 */
	"X_0X99\0" /* 57684 */
	"X_0XA0\0" /* 57691 */
	"X_0XA5\0" /* 57698 */
	"X_0XAA\0" /* 57705 */
	"X_0XAF\0" /* 57712 */
	"X_0XBB\0" /* 57719 */
	"X_0XCC\0" /* 57726 */
	"X_0XDD\0" /* 57733 */
	"X_0XEE\0" /* 57740 */
	"X_0XF0\0" /* 57747 */
	"X_0XF5\0" /* 57754 */
	"X_0XFA\0" /* 57761 */
	"X_0XFF\0" /* 57768 */
	"Z_EXPORT_ENABLE\0" /* 57775 */
	"STENCIL_TEST_VAL_EXPORT_ENABLE\0" /* 57791 */
	"STENCIL_OP_VAL_EXPORT_ENABLE\0" /* 57822 */
	"LATE_Z\0" /* 57851 */
	"EARLY_Z_THEN_LATE_Z\0" /* 57858 */
	"RE_Z\0" /* 57878 */
	"EARLY_Z_THEN_RE_Z\0" /* 57883 */
	"KILL_ENABLE\0" /* 57901 */
	"COVERAGE_TO_MASK_ENABLE\0" /* 57913 */
	"MASK_EXPORT_ENABLE\0" /* 57937 */
	"EXEC_ON_HIER_FAIL\0" /* 57956 */
	"EXEC_ON_NOOP\0" /* 57974 */
	"ALPHA_TO_MASK_DISABLE\0" /* 57987 */
	"DEPTH_BEFORE_SHADER\0" /* 58009 */
	"EXPORT_ANY_Z\0" /* 58029 */
	"EXPORT_LESS_THAN_Z\0" /* 58042 */
	"EXPORT_GREATER_THAN_Z\0" /* 58061 */
	"EXPORT_RESERVED\0" /* 58083 */
	"CONSERVATIVE_Z_EXPORT\0" /* 58099 */
	"DUAL_QUAD_DISABLE\0" /* 58121 */
	"UCP_ENA_0\0" /* 58139 */
	"UCP_ENA_1\0" /* 58149 */
	"UCP_ENA_2\0" /* 58159 */
	"UCP_ENA_3\0" /* 58169 */
	"UCP_ENA_4\0" /* 58179 */
	"UCP_ENA_5\0" /* 58189 */
	"PS_UCP_Y_SCALE_NEG\0" /* 58199 */
	"PS_UCP_MODE\0" /* 58218 */
	"CLIP_DISABLE\0" /* 58230 */
	"UCP_CULL_ONLY_ENA\0" /* 58243 */
	"BOUNDARY_EDGE_FLAG_ENA\0" /* 58261 */
	"DX_CLIP_SPACE_DEF\0" /* 58284 */
	"DIS_CLIP_ERR_DETECT\0" /* 58302 */
	"VTX_KILL_OR\0" /* 58322 */
	"DX_RASTERIZATION_KILL\0" /* 58334 */
	"DX_LINEAR_ATTR_CLIP_ENA\0" /* 58356 */
	"VTE_VPORT_PROVOKE_DISABLE\0" /* 58380 */
	"ZCLIP_NEAR_DISABLE\0" /* 58406 */
	"ZCLIP_FAR_DISABLE\0" /* 58425 */
	"CULL_FRONT\0" /* 58443 */
	"CULL_BACK\0" /* 58454 */
	"X_DISABLE_POLY_MODE\0" /* 58464, 58474 */
	"X_DUAL_MODE\0" /* 58484 */
	"X_DRAW_POINTS\0" /* 58496 */
	"X_DRAW_LINES\0" /* 58510 */
	"X_DRAW_TRIANGLES\0" /* 58523 */
	"POLYMODE_FRONT_PTYPE\0" /* 58540 */
	"POLYMODE_BACK_PTYPE\0" /* 58561 */
	"POLY_OFFSET_FRONT_ENABLE\0" /* 58581 */
	"POLY_OFFSET_BACK_ENABLE\0" /* 58606 */
	"POLY_OFFSET_PARA_ENABLE\0" /* 58630 */
	"VTX_WINDOW_OFFSET_ENABLE\0" /* 58654 */
	"PROVOKING_VTX_LAST\0" /* 58679 */
	"PERSP_CORR_DIS\0" /* 58698 */
	"MULTI_PRIM_IB_ENA\0" /* 58713 */
	"VPORT_X_SCALE_ENA\0" /* 58731 */
	"VPORT_X_OFFSET_ENA\0" /* 58749 */
	"VPORT_Y_SCALE_ENA\0" /* 58768 */
	"VPORT_Y_OFFSET_ENA\0" /* 58786 */
	"VPORT_Z_SCALE_ENA\0" /* 58805 */
	"VPORT_Z_OFFSET_ENA\0" /* 58823 */
	"VTX_XY_FMT\0" /* 58842 */
	"VTX_Z_FMT\0" /* 58853 */
	"VTX_W0_FMT\0" /* 58863 */
	"CLIP_DIST_ENA_0\0" /* 58874 */
	"CLIP_DIST_ENA_1\0" /* 58890 */
	"CLIP_DIST_ENA_2\0" /* 58906 */
	"CLIP_DIST_ENA_3\0" /* 58922 */
	"CLIP_DIST_ENA_4\0" /* 58938 */
	"CLIP_DIST_ENA_5\0" /* 58954 */
	"CLIP_DIST_ENA_6\0" /* 58970 */
	"CLIP_DIST_ENA_7\0" /* 58986 */
	"CULL_DIST_ENA_0\0" /* 59002 */
	"CULL_DIST_ENA_1\0" /* 59018 */
	"CULL_DIST_ENA_2\0" /* 59034 */
	"CULL_DIST_ENA_3\0" /* 59050 */
	"CULL_DIST_ENA_4\0" /* 59066 */
	"CULL_DIST_ENA_5\0" /* 59082 */
	"CULL_DIST_ENA_6\0" /* 59098 */
	"CULL_DIST_ENA_7\0" /* 59114 */
	"USE_VTX_POINT_SIZE\0" /* 59130 */
	"USE_VTX_EDGE_FLAG\0" /* 59149 */
	"USE_VTX_RENDER_TARGET_INDX\0" /* 59167 */
	"USE_VTX_VIEWPORT_INDX\0" /* 59194 */
	"USE_VTX_KILL_FLAG\0" /* 59216 */
	"VS_OUT_MISC_VEC_ENA\0" /* 59234 */
	"VS_OUT_CCDIST0_VEC_ENA\0" /* 59254 */
	"VS_OUT_CCDIST1_VEC_ENA\0" /* 59277 */
	"VS_OUT_MISC_SIDE_BUS_ENA\0" /* 59300 */
	"USE_VTX_GS_CUT_FLAG\0" /* 59325 */
	"USE_VTX_LINE_WIDTH\0" /* 59345 */
	"VTE_XY_INF_DISCARD\0" /* 59364 */
	"VTE_Z_INF_DISCARD\0" /* 59383 */
	"VTE_W_INF_DISCARD\0" /* 59401 */
	"VTE_0XNANINF_IS_0\0" /* 59419 */
	"VTE_XY_NAN_RETAIN\0" /* 59437 */
	"VTE_Z_NAN_RETAIN\0" /* 59455 */
	"VTE_W_NAN_RETAIN\0" /* 59472 */
	"VTE_W_RECIP_NAN_IS_0\0" /* 59489 */
	"VS_XY_NAN_TO_INF\0" /* 59510 */
	"VS_XY_INF_RETAIN\0" /* 59527 */
	"VS_Z_NAN_TO_INF\0" /* 59544 */
	"VS_Z_INF_RETAIN\0" /* 59560 */
	"VS_W_NAN_TO_INF\0" /* 59576 */
	"VS_W_INF_RETAIN\0" /* 59592 */
	"VS_CLIP_DIST_INF_DISCARD\0" /* 59608 */
	"VTE_NO_OUTPUT_NEG_0\0" /* 59633 */
	"LINE_STIPPLE_RESET\0" /* 59653 */
	"EXPAND_FULL_LENGTH\0" /* 59672 */
	"FRACTIONAL_ACCUM\0" /* 59691 */
	"DIAMOND_ADJUST\0" /* 59708 */
	"TRIANGLE_FILTER_DISABLE\0" /* 59723 */
	"LINE_FILTER_DISABLE\0" /* 59747 */
	"POINT_FILTER_DISABLE\0" /* 59767 */
	"RECTANGLE_FILTER_DISABLE\0" /* 59788 */
	"TRIANGLE_EXPAND_ENA\0" /* 59813 */
	"LINE_EXPAND_ENA\0" /* 59833 */
	"POINT_EXPAND_ENA\0" /* 59849 */
	"RECTANGLE_EXPAND_ENA\0" /* 59866 */
	"PRIM_EXPAND_CONSTANT\0" /* 59887 */
	"XMAX_RIGHT_EXCLUSION\0" /* 59908 */
	"YMAX_BOTTOM_EXCLUSION\0" /* 59929 */
	"SMALL_PRIM_FILTER_ENABLE\0" /* 59951 */
	"MIN_SIZE\0" /* 59976 */
	"LINE_PATTERN\0" /* 59985 */
	"REPEAT_COUNT\0" /* 59998 */
	"PATTERN_BIT_ORDER\0" /* 60011 */
	"AUTO_RESET_CNTL\0" /* 60029 */
	"VGT_OUTPATH_VTX_REUSE\0" /* 60045 */
	"VGT_OUTPATH_TESS_EN\0" /* 60067 */
	"VGT_OUTPATH_PASSTHRU\0" /* 60087 */
	"VGT_OUTPATH_GS_BLOCK\0" /* 60108 */
	"VGT_OUTPATH_HS_BLOCK\0" /* 60129 */
	"PATH_SELECT\0" /* 60150 */
	"TESS_MODE\0" /* 60162 */
	"VGT_GRP_3D_POINT\0" /* 60172 */
	"VGT_GRP_3D_LINE\0" /* 60189 */
	"VGT_GRP_3D_TRI\0" /* 60205 */
	"VGT_GRP_3D_RECT\0" /* 60220 */
	"VGT_GRP_3D_QUAD\0" /* 60236 */
	"VGT_GRP_2D_COPY_RECT_V0\0" /* 60252 */
	"VGT_GRP_2D_COPY_RECT_V1\0" /* 60276 */
	"VGT_GRP_2D_COPY_RECT_V2\0" /* 60300 */
	"VGT_GRP_2D_COPY_RECT_V3\0" /* 60324 */
	"VGT_GRP_2D_FILL_RECT\0" /* 60348 */
	"VGT_GRP_2D_LINE\0" /* 60369 */
	"VGT_GRP_2D_TRI\0" /* 60385 */
	"VGT_GRP_PRIM_INDEX_LINE\0" /* 60400 */
	"VGT_GRP_PRIM_INDEX_TRI\0" /* 60424 */
	"VGT_GRP_PRIM_INDEX_QUAD\0" /* 60447 */
	"VGT_GRP_3D_LINE_ADJ\0" /* 60471 */
	"VGT_GRP_3D_TRI_ADJ\0" /* 60491 */
	"VGT_GRP_3D_PATCH\0" /* 60510 */
	"RETAIN_ORDER\0" /* 60527 */
	"RETAIN_QUADS\0" /* 60540 */
	"VGT_GRP_LIST\0" /* 60553 */
	"VGT_GRP_STRIP\0" /* 60566 */
	"VGT_GRP_FAN\0" /* 60580 */
	"VGT_GRP_LOOP\0" /* 60592 */
	"VGT_GRP_POLYGON\0" /* 60605 */
	"PRIM_ORDER\0" /* 60621 */
	"COMP_X_EN\0" /* 60632 */
	"COMP_Y_EN\0" /* 60642 */
	"COMP_Z_EN\0" /* 60652 */
	"COMP_W_EN\0" /* 60662 */
	"SHIFT\0" /* 60672 */
	"VGT_GRP_INDEX_16\0" /* 60678 */
	"VGT_GRP_INDEX_32\0" /* 60695 */
	"VGT_GRP_UINT_16\0" /* 60712 */
	"VGT_GRP_UINT_32\0" /* 60728 */
	"VGT_GRP_SINT_16\0" /* 60744 */
	"VGT_GRP_SINT_32\0" /* 60760 */
	"VGT_GRP_FLOAT_32\0" /* 60776 */
	"VGT_GRP_AUTO_PRIM\0" /* 60793 */
	"VGT_GRP_FIX_1_23_TO_FLOAT\0" /* 60811 */
	"X_CONV\0" /* 60841, 60837 */
	"Y_CONV\0" /* 60844 */
	"Z_CONV\0" /* 60851 */
	"Z_OFFSET\0" /* 60858 */
	"W_CONV\0" /* 60867 */
	"GS_OFF\0" /* 60874 */
	"GS_SCENARIO_A\0" /* 60881 */
	"GS_SCENARIO_B\0" /* 60895 */
	"GS_SCENARIO_G\0" /* 60909 */
	"GS_SCENARIO_C\0" /* 60923 */
	"SPRITE_EN\0" /* 60937 */
	"GS_CUT_1024\0" /* 60947 */
	"GS_CUT_512\0" /* 60959 */
	"GS_CUT_256\0" /* 60970 */
	"GS_CUT_128\0" /* 60981 */
	"CUT_MODE\0" /* 60992 */
	"GS_C_PACK_EN\0" /* 61001 */
	"RESERVED_2\0" /* 61014 */
	"ES_PASSTHRU\0" /* 61025 */
	"COMPUTE_MODE\0" /* 61037 */
	"FAST_COMPUTE_MODE\0" /* 61050 */
	"ELEMENT_INFO_EN\0" /* 61068 */
	"PARTIAL_THD_AT_EOI\0" /* 61084 */
	"SUPPRESS_CUTS\0" /* 61103 */
	"ES_WRITE_OPTIMIZE\0" /* 61117 */
	"GS_WRITE_OPTIMIZE\0" /* 61135 */
	"X_0_OFFCHIP_GS\0" /* 61153 */
	"X_3_ES_AND_GS_ARE_ONCHIP\0" /* 61168, 61186 */
	"ES_VERTS_PER_SUBGRP\0" /* 61193 */
	"GS_PRIMS_PER_SUBGRP\0" /* 61213 */
	"MSAA_ENABLE\0" /* 61233 */
	"VPORT_SCISSOR_ENABLE\0" /* 61245 */
	"LINE_STIPPLE_ENABLE\0" /* 61266 */
	"SEND_UNLIT_STILES_TO_PKR\0" /* 61286 */
	"WALK_SIZE\0" /* 61311 */
	"WALK_ALIGNMENT\0" /* 61321 */
	"WALK_ALIGN8_PRIM_FITS_ST\0" /* 61336 */
	"WALK_FENCE_ENABLE\0" /* 61361 */
	"WALK_FENCE_SIZE\0" /* 61379 */
	"SUPERTILE_WALK_ORDER_ENABLE\0" /* 61400, 61395 */
	"TILE_COVER_DISABLE\0" /* 61423 */
	"TILE_COVER_NO_SCISSOR\0" /* 61442 */
	"ZMM_LINE_EXTENT\0" /* 61464 */
	"ZMM_LINE_OFFSET\0" /* 61480 */
	"ZMM_RECT_EXTENT\0" /* 61496 */
	"KILL_PIX_POST_HI_Z\0" /* 61512 */
	"KILL_PIX_POST_DETAIL_MASK\0" /* 61531 */
	"PS_ITER_SAMPLE\0" /* 61557 */
	"MULTI_SHADER_ENGINE_PRIM_DISCARD_ENABLE\0" /* 61572 */
	"MULTI_GPU_SUPERTILE_ENABLE\0" /* 61612 */
	"GPU_ID_OVERRIDE_ENABLE\0" /* 61639 */
	"GPU_ID_OVERRIDE\0" /* 61662 */
	"MULTI_GPU_PRIM_DISCARD_ENABLE\0" /* 61678 */
	"FORCE_EOV_CNTDWN_ENABLE\0" /* 61708 */
	"FORCE_EOV_REZ_ENABLE\0" /* 61732 */
	"OUT_OF_ORDER_PRIMITIVE_ENABLE\0" /* 61753 */
	"OUT_OF_ORDER_WATER_MARK\0" /* 61783 */
	"OUTPRIM_TYPE_POINTLIST\0" /* 61807 */
	"OUTPRIM_TYPE_LINESTRIP\0" /* 61830 */
	"OUTPRIM_TYPE_TRISTRIP\0" /* 61853 */
	"OUTPRIM_TYPE\0" /* 61875 */
	"OUTPRIM_TYPE_1\0" /* 61888 */
	"OUTPRIM_TYPE_2\0" /* 61903 */
	"OUTPRIM_TYPE_3\0" /* 61918 */
	"UNIQUE_TYPE_PER_STREAM\0" /* 61933 */
	"VGT_INDEX_16\0" /* 61956 */
	"VGT_INDEX_32\0" /* 61969 */
	"VGT_INDEX_8\0" /* 61982 */
	"VGT_DMA_SWAP_NONE\0" /* 61994 */
	"VGT_DMA_SWAP_16_BIT\0" /* 62012 */
	"VGT_DMA_SWAP_32_BIT\0" /* 62032 */
	"VGT_DMA_SWAP_WORD\0" /* 62052 */
	"SWAP_MODE\0" /* 62070 */
	"VGT_DMA_BUF_MEM\0" /* 62080 */
	"VGT_DMA_BUF_RING\0" /* 62096 */
	"VGT_DMA_BUF_SETUP\0" /* 62113 */
	"BUF_TYPE\0" /* 62131 */
	"VGT_POLICY_LRU\0" /* 62140 */
	"VGT_POLICY_STREAM\0" /* 62155 */
	"RDREQ_POLICY_CIK\0" /* 62173 */
	"RDREQ_POLICY\0" /* 62190 */
	"REQ_PATH\0" /* 62203 */
	"DISABLE_RESET_ON_EOI\0" /* 62212 */
	"SAMPLE_STREAMOUTSTATS1\0" /* 62233 */
	"SAMPLE_STREAMOUTSTATS2\0" /* 62256 */
	"SAMPLE_STREAMOUTSTATS3\0" /* 62279 */
	"CACHE_FLUSH_TS\0" /* 62302 */
	"CONTEXT_DONE\0" /* 62317 */
	"CACHE_FLUSH\0" /* 62330 */
	"CS_PARTIAL_FLUSH\0" /* 62342 */
	"VGT_STREAMOUT_SYNC\0" /* 62359 */
	"VGT_STREAMOUT_RESET\0" /* 62378 */
	"END_OF_PIPE_INCR_DE\0" /* 62398 */
	"END_OF_PIPE_IB_END\0" /* 62418 */
	"RST_PIX_CNT\0" /* 62437 */
	"VS_PARTIAL_FLUSH\0" /* 62449 */
	"PS_PARTIAL_FLUSH\0" /* 62466 */
	"FLUSH_HS_OUTPUT\0" /* 62483 */
	"FLUSH_LS_OUTPUT\0" /* 62499 */
	"CACHE_FLUSH_AND_INV_TS_EVENT\0" /* 62515 */
	"ZPASS_DONE\0" /* 62544 */
	"CACHE_FLUSH_AND_INV_EVENT\0" /* 62555 */
	"PERFCOUNTER_START\0" /* 62581 */
	"PERFCOUNTER_STOP\0" /* 62599 */
	"PIPELINESTAT_START\0" /* 62616 */
	"PIPELINESTAT_STOP\0" /* 62635 */
	"PERFCOUNTER_SAMPLE\0" /* 62653 */
	"FLUSH_ES_OUTPUT\0" /* 62672 */
	"FLUSH_GS_OUTPUT\0" /* 62688 */
	"SAMPLE_PIPELINESTAT\0" /* 62704 */
	"SO_VGTSTREAMOUT_FLUSH\0" /* 62724 */
	"SAMPLE_STREAMOUTSTATS\0" /* 62746 */
	"RESET_VTX_CNT\0" /* 62768 */
	"BLOCK_CONTEXT_DONE\0" /* 62782 */
	"CS_CONTEXT_DONE\0" /* 62801 */
	"VGT_FLUSH\0" /* 62817 */
	"SC_SEND_DB_VPZ\0" /* 62827 */
	"BOTTOM_OF_PIPE_TS\0" /* 62842 */
	"DB_CACHE_FLUSH_AND_INV\0" /* 62860 */
	"FLUSH_AND_INV_DB_DATA_TS\0" /* 62883 */
	"FLUSH_AND_INV_DB_META\0" /* 62908 */
	"FLUSH_AND_INV_CB_DATA_TS\0" /* 62930 */
	"FLUSH_AND_INV_CB_META\0" /* 62955 */
	"FLUSH_AND_INV_CB_PIXEL_DATA\0" /* 62977 */
	"THREAD_TRACE_START\0" /* 63005 */
	"THREAD_TRACE_STOP\0" /* 63024 */
	"THREAD_TRACE_MARKER\0" /* 63042 */
	"THREAD_TRACE_FLUSH\0" /* 63062 */
	"THREAD_TRACE_FINISH\0" /* 63081 */
	"PIXEL_PIPE_STAT_CONTROL\0" /* 63101 */
	"PIXEL_PIPE_STAT_DUMP\0" /* 63125 */
	"PIXEL_PIPE_STAT_RESET\0" /* 63146 */
	"EVENT_TYPE\0" /* 63168 */
	"ADDRESS_HI_GFX6\0" /* 63179 */
	"EXTENDED_EVENT\0" /* 63195 */
	"PRIMGROUP_SIZE\0" /* 63210 */
	"PARTIAL_VS_WAVE_ON\0" /* 63225 */
	"SWITCH_ON_EOP\0" /* 63244 */
	"PARTIAL_ES_WAVE_ON\0" /* 63258 */
	"SWITCH_ON_EOI\0" /* 63277 */
	"WD_SWITCH_ON_EOP\0" /* 63291 */
	"MAX_PRIMGRP_IN_WAVE\0" /* 63308 */
	"FULL_CACHE\0" /* 63328 */
	"HTILE_USES_PRELOAD_WIN\0" /* 63339 */
	"PRELOAD\0" /* 63362 */
	"PREFETCH_WIDTH\0" /* 63370 */
	"PREFETCH_HEIGHT\0" /* 63385 */
	"DST_OUTSIDE_ZERO_TO_ONE\0" /* 63401 */
	"TC_COMPATIBLE\0" /* 63425 */
	"COMPAREFUNC0\0" /* 63439 */
	"COMPAREVALUE0\0" /* 63452 */
	"COMPAREMASK0\0" /* 63466 */
	"COMPAREFUNC1\0" /* 63479 */
	"COMPAREVALUE1\0" /* 63492 */
	"COMPAREMASK1\0" /* 63506 */
	"MAX_X\0" /* 63519 */
	"MAX_Y\0" /* 63525 */
	"ACCUM_ISOLINE\0" /* 63531 */
	"ACCUM_TRI\0" /* 63545 */
	"ACCUM_QUAD\0" /* 63555 */
	"DONUT_SPLIT\0" /* 63566 */
	"TRAP_SPLIT\0" /* 63578 */
	"LS_STAGE_OFF\0" /* 63589 */
	"LS_STAGE_ON\0" /* 63602 */
	"CS_STAGE_ON\0" /* 63614 */
	"ES_STAGE_OFF\0" /* 63626 */
	"ES_STAGE_DS\0" /* 63639 */
	"ES_STAGE_REAL\0" /* 63651 */
	"VS_STAGE_REAL\0" /* 63665 */
	"VS_STAGE_DS\0" /* 63679 */
	"VS_STAGE_COPY_SHADER\0" /* 63691 */
	"DYNAMIC_HS\0" /* 63712 */
	"DIS_DEALLOC_ACCUM_0\0" /* 63723 */
	"DIS_DEALLOC_ACCUM_1\0" /* 63743 */
	"VS_WAVE_ID_EN\0" /* 63763 */
	"NUM_PATCHES\0" /* 63777 */
	"HS_NUM_INPUT_CP\0" /* 63789 */
	"HS_NUM_OUTPUT_CP\0" /* 63805 */
	"TESS_ISOLINE\0" /* 63822 */
	"TESS_TRIANGLE\0" /* 63835 */
	"TESS_QUAD\0" /* 63849 */
	"PART_INTEGER\0" /* 63859 */
	"PART_POW2\0" /* 63872 */
	"PART_FRAC_ODD\0" /* 63882 */
	"PART_FRAC_EVEN\0" /* 63896 */
	"PARTITIONING\0" /* 63911 */
	"OUTPUT_POINT\0" /* 63924 */
	"OUTPUT_LINE\0" /* 63937 */
	"OUTPUT_TRIANGLE_CW\0" /* 63949 */
	"OUTPUT_TRIANGLE_CCW\0" /* 63968 */
	"TOPOLOGY\0" /* 63988 */
	"RESERVED_REDUC_AXIS\0" /* 63997 */
	"DEPRECATED\0" /* 64017 */
	"NUM_DS_WAVES_PER_SIMD\0" /* 64028 */
	"DISABLE_DONUTS\0" /* 64050 */
	"VGT_POLICY_BYPASS\0" /* 64065 */
	"DISTRIBUTION_MODE_NO_DIST\0" /* 64083 */
	"DISTRIBUTION_MODE_PATCHES\0" /* 64109 */
	"DISTRIBUTION_MODE_DONUTS\0" /* 64135 */
	"DISTRIBUTION_MODE_TRAPEZOIDS\0" /* 64160 */
	"DISTRIBUTION_MODE\0" /* 64189 */
	"ALPHA_TO_MASK_ENABLE\0" /* 64207 */
	"ALPHA_TO_MASK_OFFSET0\0" /* 64228 */
	"ALPHA_TO_MASK_OFFSET1\0" /* 64250 */
	"ALPHA_TO_MASK_OFFSET2\0" /* 64272 */
	"ALPHA_TO_MASK_OFFSET3\0" /* 64294 */
	"OFFSET_ROUND\0" /* 64316 */
	"POLY_OFFSET_NEG_NUM_DB_BITS\0" /* 64329 */
	"POLY_OFFSET_DB_IS_FLOAT_FMT\0" /* 64357 */
	"STREAMOUT_0_EN\0" /* 64385 */
	"STREAMOUT_1_EN\0" /* 64400 */
	"STREAMOUT_2_EN\0" /* 64415 */
	"STREAMOUT_3_EN\0" /* 64430 */
	"RAST_STREAM\0" /* 64445 */
	"RAST_STREAM_MASK\0" /* 64457 */
	"USE_RAST_STREAM_MASK\0" /* 64474 */
	"STREAM_0_BUFFER_EN\0" /* 64495 */
	"STREAM_1_BUFFER_EN\0" /* 64514 */
	"STREAM_2_BUFFER_EN\0" /* 64533 */
	"STREAM_3_BUFFER_EN\0" /* 64552 */
	"DISTANCE_0\0" /* 64571 */
	"DISTANCE_1\0" /* 64582 */
	"DISTANCE_2\0" /* 64593 */
	"DISTANCE_3\0" /* 64604 */
	"DISTANCE_4\0" /* 64615 */
	"DISTANCE_5\0" /* 64626 */
	"DISTANCE_6\0" /* 64637 */
	"DISTANCE_7\0" /* 64648 */
	"DISTANCE_8\0" /* 64659 */
	"DISTANCE_9\0" /* 64670 */
	"DISTANCE_10\0" /* 64681 */
	"DISTANCE_11\0" /* 64693 */
	"DISTANCE_12\0" /* 64705 */
	"DISTANCE_13\0" /* 64717 */
	"DISTANCE_14\0" /* 64729 */
	"DISTANCE_15\0" /* 64741 */
	"EXPAND_LINE_WIDTH\0" /* 64753 */
	"LAST_PIXEL\0" /* 64771 */
	"PERPENDICULAR_ENDCAP_ENA\0" /* 64782 */
	"DX10_DIAMOND_TEST_ENA\0" /* 64807 */
	"MSAA_NUM_SAMPLES\0" /* 64829 */
	"AA_MASK_CENTROID_DTMN\0" /* 64846 */
	"MAX_SAMPLE_DIST\0" /* 64868 */
	"MSAA_EXPOSED_SAMPLES\0" /* 64884 */
	"DETAIL_TO_EXPOSED_MODE\0" /* 64905 */
	"PIX_CENTER\0" /* 64928 */
	"X_TRUNCATE\0" /* 64939 */
	"X_ROUND\0" /* 64950 */
	"X_ROUND_TO_EVEN\0" /* 64958 */
	"X_ROUND_TO_ODD\0" /* 64974 */
	"ROUND_MODE\0" /* 64989 */
	"X_16_8_FIXED_POINT_1_16TH\0" /* 65000 */
	"X_16_8_FIXED_POINT_1_8TH\0" /* 65026 */
	"X_16_8_FIXED_POINT_1_4TH\0" /* 65051 */
	"X_16_8_FIXED_POINT_1_2\0" /* 65076 */
	"X_16_8_FIXED_POINT_1\0" /* 65099 */
	"X_16_8_FIXED_POINT_1_256TH\0" /* 65120 */
	"X_14_10_FIXED_POINT_1_1024TH\0" /* 65147 */
	"X_12_12_FIXED_POINT_1_4096TH\0" /* 65176 */
	"QUANT_MODE\0" /* 65205 */
	"S0_X\0" /* 65216 */
	"S0_Y\0" /* 65221 */
	"S1_X\0" /* 65226 */
	"S1_Y\0" /* 65231 */
	"S2_X\0" /* 65236 */
	"S2_Y\0" /* 65241 */
	"S3_X\0" /* 65246 */
	"S3_Y\0" /* 65251 */
	"S4_X\0" /* 65256 */
	"S4_Y\0" /* 65261 */
	"S5_X\0" /* 65266 */
	"S5_Y\0" /* 65271 */
	"S6_X\0" /* 65276 */
	"S6_Y\0" /* 65281 */
	"S7_X\0" /* 65286 */
	"S7_Y\0" /* 65291 */
	"S8_X\0" /* 65296 */
	"S8_Y\0" /* 65301 */
	"S9_X\0" /* 65306 */
	"S9_Y\0" /* 65311 */
	"S10_X\0" /* 65316 */
	"S10_Y\0" /* 65322 */
	"S11_X\0" /* 65328 */
	"S11_Y\0" /* 65334 */
	"S12_X\0" /* 65340 */
	"S12_Y\0" /* 65346 */
	"S13_X\0" /* 65352 */
	"S13_Y\0" /* 65358 */
	"S14_X\0" /* 65364 */
	"S14_Y\0" /* 65370 */
	"S15_X\0" /* 65376 */
	"S15_Y\0" /* 65382 */
	"AA_MASK_X0Y0\0" /* 65388 */
	"AA_MASK_X1Y0\0" /* 65401 */
	"AA_MASK_X0Y1\0" /* 65414 */
	"AA_MASK_X1Y1\0" /* 65427 */
	"REALIGN_DQUADS_AFTER_N_WAVES\0" /* 65440 */
	"VTX_REUSE_DEPTH\0" /* 65469 */
	"DEALLOC_DIST\0" /* 65485 */
	"FMASK_TILE_MAX\0" /* 65498 */
	"ENDIAN_NONE\0" /* 65513 */
	"ENDIAN_8IN16\0" /* 65525 */
	"ENDIAN_8IN32\0" /* 65538 */
	"ENDIAN_8IN64\0" /* 65551 */
	"ENDIAN\0" /* 65564 */
	"COLOR_INVALID\0" /* 65571 */
	"COLOR_8\0" /* 65585 */
	"COLOR_16\0" /* 65593 */
	"COLOR_8_8\0" /* 65602 */
	"COLOR_32\0" /* 65612 */
	"COLOR_16_16\0" /* 65621 */
	"COLOR_10_11_11\0" /* 65633 */
	"COLOR_11_11_10\0" /* 65648 */
	"COLOR_10_10_10_2\0" /* 65663 */
	"COLOR_2_10_10_10\0" /* 65680 */
	"COLOR_8_8_8_8\0" /* 65697 */
	"COLOR_32_32\0" /* 65711 */
	"COLOR_16_16_16_16\0" /* 65723 */
	"COLOR_32_32_32_32\0" /* 65741 */
	"COLOR_5_6_5\0" /* 65759 */
	"COLOR_1_5_5_5\0" /* 65771 */
	"COLOR_5_5_5_1\0" /* 65785 */
	"COLOR_4_4_4_4\0" /* 65799 */
	"COLOR_8_24\0" /* 65813 */
	"COLOR_24_8\0" /* 65824 */
	"COLOR_X24_8_32_FLOAT\0" /* 65835 */
	"NUMBER_UNORM\0" /* 65856 */
	"NUMBER_SNORM\0" /* 65869 */
	"NUMBER_UINT\0" /* 65882 */
	"NUMBER_SINT\0" /* 65894 */
	"NUMBER_SRGB\0" /* 65906 */
	"NUMBER_FLOAT\0" /* 65918 */
	"NUMBER_TYPE\0" /* 65931 */
	"SWAP_STD\0" /* 65943 */
	"SWAP_ALT\0" /* 65952 */
	"SWAP_STD_REV\0" /* 65961 */
	"SWAP_ALT_REV\0" /* 65974 */
	"COMP_SWAP\0" /* 65987 */
	"BLEND_CLAMP\0" /* 65997 */
	"BLEND_BYPASS\0" /* 66009 */
	"SIMPLE_FLOAT\0" /* 66022 */
	"CMASK_IS_LINEAR\0" /* 66035 */
	"FORCE_OPT_AUTO\0" /* 66051 */
	"FORCE_OPT_DISABLE\0" /* 66066 */
	"FORCE_OPT_ENABLE_IF_SRC_A_0\0" /* 66084 */
	"FORCE_OPT_ENABLE_IF_SRC_RGB_0\0" /* 66112 */
	"FORCE_OPT_ENABLE_IF_SRC_ARGB_0\0" /* 66142 */
	"FORCE_OPT_ENABLE_IF_SRC_A_1\0" /* 66173 */
	"FORCE_OPT_ENABLE_IF_SRC_RGB_1\0" /* 66201 */
	"FORCE_OPT_ENABLE_IF_SRC_ARGB_1\0" /* 66231 */
	"BLEND_OPT_DONT_RD_DST\0" /* 66262 */
	"BLEND_OPT_DISCARD_PIXEL\0" /* 66284 */
	"FMASK_COMPRESSION_DISABLE\0" /* 66308 */
	"FMASK_COMPRESS_1FRAG_ONLY\0" /* 66334 */
	"DCC_ENABLE\0" /* 66360 */
	"CMASK_ADDR_TYPE\0" /* 66371 */
	"FMASK_TILE_MODE_INDEX\0" /* 66387 */
	"FMASK_BANK_HEIGHT\0" /* 66409 */
	"NUM_FRAGMENTS\0" /* 66427 */
	"FORCE_DST_ALPHA_1\0" /* 66441 */
	"KEY_CLEAR_ENABLE\0" /* 66459 */
	"MAX_BLOCK_SIZE_64B\0" /* 66476 */
	"MAX_BLOCK_SIZE_128B\0" /* 66495 */
	"MAX_BLOCK_SIZE_256B\0" /* 66515 */
	"MAX_UNCOMPRESSED_BLOCK_SIZE\0" /* 66535 */
	"MIN_BLOCK_SIZE_32B\0" /* 66563 */
	"MIN_BLOCK_SIZE_64B\0" /* 66582 */
	"MIN_COMPRESSED_BLOCK_SIZE\0" /* 66601 */
	"MAX_COMPRESSED_BLOCK_SIZE\0" /* 66627 */
	"INDEPENDENT_64B_BLOCKS\0" /* 66653 */
	"LOSSY_RGB_PRECISION\0" /* 66676 */
	"LOSSY_ALPHA_PRECISION\0" /* 66696 */
	"UTCL2_BUSY\0" /* 66718 */
	"EA_BUSY\0" /* 66729 */
	"RMI_BUSY\0" /* 66737 */
	"UTCL2_RQ_PENDING\0" /* 66746 */
	"CPF_RQ_PENDING\0" /* 66763 */
	"EA_LINK_BUSY\0" /* 66778 */
	"CPAXI_BUSY\0" /* 66791 */
	"RSMU_RQ_PENDING\0" /* 66802 */
	"TC_WC_ACTION_ENA\0" /* 66818 */
	"TC_INV_METADATA_ACTION_ENA\0" /* 66835 */
	"UTCL2IU_BUSY\0" /* 66862 */
	"SAVE_RESTORE_BUSY\0" /* 66875 */
	"UTCL2IU_WAITING_ON_FREE\0" /* 66893 */
	"UTCL2IU_WAITING_ON_TAGS\0" /* 66917 */
	"UTCL1_WAITING_ON_TRANS\0" /* 66941 */
	"GFX_UTCL1_WAITING_ON_TRANS\0" /* 66964 */
	"CMP_UTCL1_WAITING_ON_TRANS\0" /* 66991 */
	"RCIU_WAITING_ON_FREE\0" /* 67018 */
	"PRIMGEN_EN\0" /* 67039 */
	"MATCH_ALL_BITS\0" /* 67050 */
	"EN_INST_OPT_BASIC\0" /* 67065 */
	"EN_INST_OPT_ADV\0" /* 67083 */
	"HW_USE_ONLY\0" /* 67099 */
	"TARGET_INST\0" /* 67111 */
	"TARGET_DATA\0" /* 67123 */
	"COMPLETE\0" /* 67135 */
	"DWB\0" /* 67144 */
	"GRAD_ADJ_0\0" /* 67148 */
	"GRAD_ADJ_1\0" /* 67159 */
	"GRAD_ADJ_2\0" /* 67170 */
	"GRAD_ADJ_3\0" /* 67181 */
	"USER_VM_ENABLE\0" /* 67192 */
	"USER_VM_MODE\0" /* 67207 */
	"IMG_DATA_FORMAT_6E4\0" /* 67220 */
	"IMG_DATA_FORMAT_16_AS_32_32\0" /* 67240 */
	"IMG_DATA_FORMAT_16_AS_16_16_16_16_GFX9\0" /* 67268 */
	"IMG_DATA_FORMAT_16_AS_32_32_32_32_GFX9\0" /* 67307 */
	"IMG_DATA_FORMAT_FMASK\0" /* 67346 */
	"IMG_DATA_FORMAT_ASTC_2D_LDR\0" /* 67368 */
	"IMG_DATA_FORMAT_ASTC_2D_HDR\0" /* 67396 */
	"IMG_DATA_FORMAT_ASTC_2D_LDR_SRGB\0" /* 67424 */
	"IMG_DATA_FORMAT_ASTC_3D_LDR\0" /* 67457 */
	"IMG_DATA_FORMAT_ASTC_3D_HDR\0" /* 67485 */
	"IMG_DATA_FORMAT_ASTC_3D_LDR_SRGB\0" /* 67513 */
	"IMG_DATA_FORMAT_N_IN_16\0" /* 67546 */
	"IMG_DATA_FORMAT_N_IN_16_16\0" /* 67570 */
	"IMG_DATA_FORMAT_N_IN_16_16_16_16\0" /* 67597 */
	"IMG_DATA_FORMAT_N_IN_16_AS_16_16_16_16\0" /* 67630 */
	"IMG_DATA_FORMAT_RESERVED_56\0" /* 67669 */
	"IMG_DATA_FORMAT_S8_16\0" /* 67697 */
	"IMG_DATA_FORMAT_S8_32\0" /* 67719 */
	"IMG_DATA_FORMAT_8_AS_32\0" /* 67741 */
	"IMG_DATA_FORMAT_8_AS_32_32\0" /* 67765 */
	"DATA_FORMAT_GFX9\0" /* 67792 */
	"IMG_NUM_FORMAT_RESERVED_6\0" /* 67809 */
	"IMG_NUM_FORMAT_METADATA\0" /* 67835 */
	"IMG_NUM_FORMAT_UNORM_UINT\0" /* 67859 */
	"NUM_FORMAT_GFX9\0" /* 67885 */
	"IMG_FMASK_8_2_1\0" /* 67901 */
	"IMG_FMASK_8_4_1\0" /* 67917 */
	"IMG_FMASK_8_8_1\0" /* 67933 */
	"IMG_FMASK_8_2_2\0" /* 67949 */
	"IMG_FMASK_8_4_2\0" /* 67965 */
	"IMG_FMASK_8_4_4\0" /* 67981 */
	"IMG_FMASK_16_16_1\0" /* 67997 */
	"IMG_FMASK_16_8_2\0" /* 68015 */
	"IMG_FMASK_32_16_2\0" /* 68032 */
	"IMG_FMASK_32_8_4\0" /* 68050 */
	"IMG_FMASK_32_8_8\0" /* 68067 */
	"IMG_FMASK_64_16_4\0" /* 68084 */
	"IMG_FMASK_64_16_8\0" /* 68102 */
	"NUM_FORMAT_FMASK\0" /* 68120 */
	"IMG_ASTC_2D_4x4\0" /* 68137 */
	"IMG_ASTC_2D_5x4\0" /* 68153 */
	"IMG_ASTC_2D_5x5\0" /* 68169 */
	"IMG_ASTC_2D_6x5\0" /* 68185 */
	"IMG_ASTC_2D_6x6\0" /* 68201 */
	"IMG_ASTC_2D_8x5\0" /* 68217 */
	"IMG_ASTC_2D_8x6\0" /* 68233 */
	"IMG_ASTC_2D_8x8\0" /* 68249 */
	"IMG_ASTC_2D_10x5\0" /* 68265 */
	"IMG_ASTC_2D_10x6\0" /* 68282 */
	"IMG_ASTC_2D_10x8\0" /* 68299 */
	"IMG_ASTC_2D_10x10\0" /* 68316 */
	"IMG_ASTC_2D_12x10\0" /* 68334 */
	"IMG_ASTC_2D_12x12\0" /* 68352 */
	"NUM_FORMAT_ASTC_2D\0" /* 68370 */
	"IMG_ASTC_3D_3x3x3\0" /* 68389 */
	"IMG_ASTC_3D_4x3x3\0" /* 68407 */
	"IMG_ASTC_3D_4x4x3\0" /* 68425 */
	"IMG_ASTC_3D_4x4x4\0" /* 68443 */
	"IMG_ASTC_3D_5x4x4\0" /* 68461 */
	"IMG_ASTC_3D_5x5x4\0" /* 68479 */
	"IMG_ASTC_3D_5x5x5\0" /* 68497 */
	"IMG_ASTC_3D_6x5x5\0" /* 68515 */
	"IMG_ASTC_3D_6x6x5\0" /* 68533 */
	"IMG_ASTC_3D_6x6x6\0" /* 68551 */
	"NUM_FORMAT_ASTC_3D\0" /* 68569 */
	"META_DIRECT\0" /* 68588 */
	"SW_MODE\0" /* 68600 */
	"PITCH_GFX9\0" /* 68608 */
	"BC_SWIZZLE_XYZW\0" /* 68619 */
	"BC_SWIZZLE_XWYZ\0" /* 68635 */
	"BC_SWIZZLE_WZYX\0" /* 68651 */
	"BC_SWIZZLE_WXYZ\0" /* 68667 */
	"BC_SWIZZLE_ZYXW\0" /* 68683 */
	"BC_SWIZZLE_YXWZ\0" /* 68699 */
	"BC_SWIZZLE\0" /* 68715 */
	"ARRAY_PITCH\0" /* 68726 */
	"META_DATA_ADDRESS\0" /* 68738 */
	"META_LINEAR\0" /* 68756 */
	"META_PIPE_ALIGNED\0" /* 68768, 68773 */
	"META_RB_ALIGNED\0" /* 68786, 68791 */
	"MAX_MIP\0" /* 68802 */
	"BLEND_ZERO_PRT\0" /* 68810 */
	"SKIP_DEGAMMA\0" /* 68825 */
	"TTRACE_STALL_ALL\0" /* 68838 */
	"ALLOC_ARB_LRU_ENA\0" /* 68855 */
	"EXP_ARB_LRU_ENA\0" /* 68873 */
	"PS_PKR_PRIORITY_CNTL\0" /* 68889 */
	"BATON_RESET_DISABLE\0" /* 68910 */
	"CRC_SIMD_ID_WADDR_DISABLE\0" /* 68930 */
	"LBPW_CU_CHK_MODE\0" /* 68956 */
	"LBPW_CU_CHK_CNT\0" /* 68973 */
	"CSC_PWR_SAVE_DISABLE\0" /* 68989 */
	"CSG_PWR_SAVE_DISABLE\0" /* 69010 */
	"CONTEXT_SAVE_WAIT_GDS_REQUEST_CYCLE_OVHD\0" /* 69031 */
	"CONTEXT_SAVE_WAIT_GDS_GRANT_CYCLE_OVHD\0" /* 69072 */
	"PIPE_INTERLEAVE_SIZE_GFX9\0" /* 69111 */
	"MAX_COMPRESSED_FRAGS\0" /* 69137 */
	"NUM_SHADER_ENGINES_GFX9\0" /* 69158 */
	"NUM_GPUS_GFX9\0" /* 69182 */
	"NUM_RB_PER_SE\0" /* 69196 */
	"SE_ENABLE\0" /* 69210 */
	"SIMD_DISABLE\0" /* 69220 */
	"FP16_OVFL\0" /* 69233 */
	"LOAD_COLLISION_WAVEID\0" /* 69243 */
	"LOAD_INTRAWAVE_COLLISION\0" /* 69265 */
	"SKIP_USGPR0\0" /* 69290 */
	"USER_SGPR_MSB\0" /* 69302 */
	"PC_BASE_EN\0" /* 69316 */
	"SPI_SHADER_LATE_ALLOC_GS\0" /* 69327 */
	"GS_VGPR_COMP_CNT\0" /* 69352 */
	"ES_VGPR_COMP_CNT\0" /* 69369 */
	"LS_VGPR_COMP_CNT\0" /* 69386 */
	"CNTR_SEL0\0" /* 69403 */
	"CNTR_SEL1\0" /* 69413 */
	"CNTR_MODE1\0" /* 69423 */
	"CNTR_MODE0\0" /* 69434 */
	"CNTR_SEL2\0" /* 69445 */
	"CNTR_SEL3\0" /* 69455 */
	"CNTR_MODE3\0" /* 69465 */
	"CNTR_MODE2\0" /* 69476 */
	"UTCL2_BUSY_USER_DEFINED_MASK\0" /* 69487 */
	"EA_BUSY_USER_DEFINED_MASK\0" /* 69516 */
	"RMI_BUSY_USER_DEFINED_MASK\0" /* 69542 */
	"MIPID\0" /* 69569 */
	"ALLOW_PARTIAL_RES_HIER_KILL\0" /* 69575 */
	"X_MAX\0" /* 69603 */
	"Y_MAX\0" /* 69609 */
	"PARTIALLY_RESIDENT\0" /* 69615 */
	"FAULT_BEHAVIOR\0" /* 69634 */
	"ITERATE_FLUSH\0" /* 69649 */
	"MAXMIP\0" /* 69663 */
	"FORCE_ON\0" /* 69670 */
	"PUNCHOUT_MODE\0" /* 69679 */
	"POPS_DRAIN_PS_ON_OVERLAP\0" /* 69693 */
	"DISALLOW_OVERFLOW\0" /* 69718 */
	"PS_INVOKE_MASK\0" /* 69736 */
	"DEST_BASE_HI_256B\0" /* 69751 */
	"SE_XSEL_GFX9\0" /* 69769 */
	"SE_YSEL_GFX9\0" /* 69782 */
	"SE_PAIR_XSEL_GFX9\0" /* 69795 */
	"SE_PAIR_YSEL_GFX9\0" /* 69813 */
	"NUM_SE\0" /* 69831 */
	"DISABLE_SRBSL_DB_OPTIMIZED_PACKING\0" /* 69838 */
	"PERFMON_ENABLE\0" /* 69873 */
	"LEFT_QTR\0" /* 69888 */
	"LEFT_HALF\0" /* 69897 */
	"RIGHT_HALF\0" /* 69907 */
	"RIGHT_QTR\0" /* 69918 */
	"TOP_QTR\0" /* 69928 */
	"TOP_HALF\0" /* 69936 */
	"BOT_HALF\0" /* 69945 */
	"BOT_QTR\0" /* 69954 */
	"LEFT_EYE_FOV_LEFT\0" /* 69962 */
	"LEFT_EYE_FOV_RIGHT\0" /* 69980 */
	"RIGHT_EYE_FOV_LEFT\0" /* 69999 */
	"RIGHT_EYE_FOV_RIGHT\0" /* 70018 */
	"FOV_TOP\0" /* 70038 */
	"FOV_BOT\0" /* 70046 */
	"OFFCHIP_PARAM_EN\0" /* 70054 */
	"LATE_PC_DEALLOC\0" /* 70071 */
	"BASE_ADDR_GFX9\0" /* 70087 */
	"SPRITE_EN_R6XX\0" /* 70102 */
	"UNROLLED_INST\0" /* 70117 */
	"GRBM_SKEW_NO_DEC\0" /* 70131 */
	"REG_RT_INDEX\0" /* 70148 */
	"PRIMITIVE_ORDERED_PIXEL_SHADER\0" /* 70161 */
	"EXEC_IF_OVERLAPPED\0" /* 70192 */
	"POPS_OVERLAP_NUM_SAMPLES\0" /* 70211 */
	"RIGHT_TRIANGLE_ALTERNATE_GRADIENT_REF\0" /* 70236 */
	"NEW_QUAD_DECOMPOSITION\0" /* 70274 */
	"PERFCOUNTER_REF\0" /* 70297 */
	"USE_VTX_SHD_OBJPRIM_ID\0" /* 70313 */
	"SRBSL_ENABLE\0" /* 70336 */
	"OBJ_ID_SEL\0" /* 70349 */
	"ADD_PIPED_PRIM_ID\0" /* 70360 */
	"EN_32BIT_OBJPRIMID\0" /* 70378 */
	"VERTEX_REUSE_OFF\0" /* 70397 */
	"INDEX_BUF_EDGE_FLAG_ENA\0" /* 70414 */
	"DISCARD_0_AREA_TRIANGLES\0" /* 70438 */
	"DISCARD_0_AREA_LINES\0" /* 70463 */
	"DISCARD_0_AREA_POINTS\0" /* 70484 */
	"DISCARD_0_AREA_RECTANGLES\0" /* 70506 */
	"USE_PROVOKING_ZW\0" /* 70532 */
	"RESERVED_3\0" /* 70549 */
	"RESERVED_4\0" /* 70560 */
	"RESERVED_5\0" /* 70571 */
	"GS_INST_PRIMS_IN_SUBGRP\0" /* 70582 */
	"SCALE_LINE_WIDTH_PAD\0" /* 70606 */
	"ALTERNATE_RBS_PER_TILE\0" /* 70627 */
	"COARSE_TILE_STARTS_ON_EVEN_RB\0" /* 70650 */
	"NGG_DISABLE_PROVOK_REUSE\0" /* 70680 */
	"BREAK_BATCH\0" /* 70705 */
	"FLUSH_DFSM\0" /* 70717 */
	"RESET_TO_LOWEST_VGT\0" /* 70728 */
	"TGID_ROLLOVER\0" /* 70748 */
	"ENABLE_NGG_PIPELINE\0" /* 70762 */
	"ENABLE_LEGACY_PIPELINE\0" /* 70782 */
	"ADDRESS_HI_GFX9\0" /* 70805 */
	"OBJPRIM_ID_EN\0" /* 70821 */
	"EN_REG_RT_INDEX\0" /* 70835 */
	"EN_PIPELINE_PRIMID\0" /* 70851 */
	"OBJECT_ID_INST_EN\0" /* 70870 */
	"COMPOUND_INDEX_EN\0" /* 70888 */
	"ORDERED_ID_MODE\0" /* 70906 */
	"GS_FAST_LAUNCH\0" /* 70922 */
	"EN_PRIMS_NEEDED_CNT\0" /* 70937 */
	"COVERAGE_TO_SHADER_SELECT\0" /* 70957 */
	"BINNING_ALLOWED\0" /* 70983 */
	"FORCE_BINNING_ON\0" /* 70999 */
	"DISABLE_BINNING_USE_NEW_SC\0" /* 71016 */
	"DISABLE_BINNING_USE_LEGACY_SC\0" /* 71043 */
	"BINNING_MODE\0" /* 71073 */
	"BIN_SIZE_X\0" /* 71086 */
	"BIN_SIZE_Y\0" /* 71097 */
	"BIN_SIZE_X_EXTEND\0" /* 71108 */
	"BIN_SIZE_Y_EXTEND\0" /* 71126 */
	"CONTEXT_STATES_PER_BIN\0" /* 71144 */
	"PERSISTENT_STATES_PER_BIN\0" /* 71167 */
	"DISABLE_START_OF_PRIM\0" /* 71193 */
	"FPOVS_PER_BATCH\0" /* 71215 */
	"OPTIMAL_BIN_SELECTION\0" /* 71231 */
	"MAX_ALLOC_COUNT\0" /* 71253 */
	"MAX_PRIM_PER_BATCH\0" /* 71269 */
	"OVER_RAST_ENABLE\0" /* 71288 */
	"OVER_RAST_SAMPLE_SELECT\0" /* 71305 */
	"UNDER_RAST_ENABLE\0" /* 71329 */
	"UNDER_RAST_SAMPLE_SELECT\0" /* 71347 */
	"PBB_UNCERTAINTY_REGION_ENABLE\0" /* 71372 */
	"ZMM_TRI_EXTENT\0" /* 71402 */
	"ZMM_TRI_OFFSET\0" /* 71417 */
	"OVERRIDE_OVER_RAST_INNER_TO_NORMAL\0" /* 71432 */
	"OVERRIDE_UNDER_RAST_INNER_TO_NORMAL\0" /* 71467 */
	"DEGENERATE_OVERRIDE_INNER_TO_NORMAL_DISABLE\0" /* 71503 */
	"UNCERTAINTY_REGION_MODE\0" /* 71547 */
	"OUTER_UNCERTAINTY_EDGERULE_OVERRIDE\0" /* 71571 */
	"INNER_UNCERTAINTY_EDGERULE_OVERRIDE\0" /* 71607 */
	"NULL_SQUAD_AA_MASK_ENABLE\0" /* 71643 */
	"COVERAGE_AA_MASK_ENABLE\0" /* 71669 */
	"PREZ_AA_MASK_ENABLE\0" /* 71693 */
	"POSTZ_AA_MASK_ENABLE\0" /* 71713 */
	"CENTROID_SAMPLE_OVERRIDE\0" /* 71734 */
	"MAX_DEALLOCS_IN_WAVE\0" /* 71759 */
	"BASE_256B\0" /* 71780 */
	"MIP0_HEIGHT\0" /* 71790 */
	"MIP0_WIDTH\0" /* 71802 */
	"MIP_LEVEL\0" /* 71813 */
	"MIP0_DEPTH\0" /* 71823 */
	"COLOR_SW_MODE\0" /* 71834 */
	"FMASK_SW_MODE\0" /* 71848 */
	"RESOURCE_TYPE\0" /* 71862 */;

static const int sid_strings_offsets[] = {
	/* 0 */ 509, 31780, 1768, 15296,
	/* 4 */ 31818, 31838, 31850, 31856, 8050, 31860,
	/* 10 */ 31906, 31856, 391, 31915,
	/* 14 */ 31945, 31856, 8540, 31954,
	/* 18 */ 32033, 32038, 32046, 32054,
	/* 22 */ 32080, 31829,
	/* 24 */ 32095, 32105,
	/* 26 */ 36447, 36458, 36474, 36489, 36505, 36519, 36532, 36547, 36562, 36577, 36589, 36608, 36628, 36646, 36665, 36680, 36695, 36717, 36732, 36747, 36762, 36778, 36792, 36819, 36846, 36873, 36900, 36924, 36944,
	/* 55 */ 36963, 36984,
	/* 57 */ 36447, 36458, 36474, 36489, 36505, 36519, 36532, -1, -1, 36577, 36589, 36608, 36628, 36646, -1, -1, 36695, 36717, 36732, 36747, 36762, 36778, 36792, 36819, 36846, 36873, 36900, 36924, 36944,
	/* 86 */ 38826, 38838, 38850, 38862,
	/* 90 */ 39207, -1, -1, -1, -1, -1, -1, -1, 39218, 39230, -1, -1, 39242, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 39253,
	/* 123 */ -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 39279,
	/* 186 */ 39358, 39367, 39376, 39394, 39412, 39421, 39430, 39439,
	/* 194 */ 39488, 39509, 39530, 39553, 39576, 39596, 39616, 39641,
	/* 202 */ 39673, 39697, 39715, 39734, 39754, 39773, 39795, 39820, 39845, 39872, 39899, 39923, 39945, 39973, 39998, 40026,
	/* 218 */ 40134, 40146, 40165, 40184,
	/* 222 */ 40211, 40235, 40253, 40272, 40292, 40311, 40333, 40358, 40383, 40410, 40437, 40461, 40483, 40511, 40536, 40564, 40592, 40614, 40638, 40662, 40686, 40707, 40728, 40753, 40782, 40807, 40833, 40856, 40880, 40907, 40935, 40963, 40991, 41013, 41035, 41059, 41079, 41099, 41119, 41139, 41159, 41179, 41199, 41238, 41277, 41306, 41335, 41364, 41393, 41422, 41451, 41482, 41512, 41543, 41573, 41603, 41634, 41665, 41685, 41707, 41725, 41752, 41776, 41802,
	/* 286 */ 41853, 41874, 41895, 41918, 41941, 41961, 41981, 42006, 42027, 42053, 42073, 42095, 42121, 42142, 42166, 42193,
	/* 302 */ 42313, 42332, 42351, 42370, 42389, 42408, 42427, 42446, 42465, 42480, 42495, 42510, 42527, 42548, 42569, 42589,
	/* 318 */ 42771, 42783, 42797, 42821, 42851, 42876, 42907, 42927,
	/* 326 */ 42993, 43020, 43046, 43073, 43104, 43133, 43163, 43197,
	/* 334 */ 43419, 43442,
	/* 336 */ 43419, 43442, 43482, 43511,
	/* 340 */ 43557, 43578, 43600,
	/* 343 */ 43742, 43774, 43807, 43840,
	/* 347 */ 44019,
	/* 348 */ 44318, 44334, 44350, 44366, 44382, 44398, 44414, 44430, 44446, 44462, 44478, 44494, 44509, 44524, 44539, 44555,
	/* 364 */ 44982, 45013, 45041, 45070,
	/* 368 */ 45115, 45136, 45157, 45178, 45199, -1, -1, 45220, 45241, -1, -1, -1, 45263, 45284, 45305, 45327,
	/* 384 */ 45355, 45368, 45391, 45414, 45437, 45457, 45478, 45499, 45520, 45546, 45572, 45598, 45625, 45652, 45679,
	/* 399 */ 45718, 45743, 45769, 45795, 45821, 45846, 45871,
	/* 406 */ 45907, 45930, 45953, 45976,
	/* 410 */ 46010, 46034, 46058, 46082,
	/* 414 */ 46118, 46143, 46168, 46193,
	/* 418 */ 46236, 46253, 46270, 46287,
	/* 422 */ 44982, 45013, 45041, 46315,
	/* 426 */ -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 46430, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 46444, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 46458,
	/* 667 */ 47349, 47367, 47382,
	/* 670 */ 48894, 48904, 48917, 48931,
	/* 674 */ 49228, 49243, 49259, 49275,
	/* 678 */ 49440, 49450, 49468, 49478,
	/* 682 */ 45115, 45136, 45157, -1, 45199, 49877, 49899,
	/* 689 */ 45355, -1, -1, -1, 45437, 45457, 45478, 45499, 45520, 45546, 45572, 45598, 45625, 45652, 45679, -1, 49924, 49951,
	/* 707 */ 49979, 49989, 49994, 49999,
	/* 711 */ 50141, 50157,
	/* 713 */ 50635, 50658, 50681, 50704,
	/* 717 */ 50751, 50776, 50801, 50826,
	/* 721 */ 50876, 50900, 50924, 50948,
	/* 725 */ 50980, 51005, 51030, 51055,
	/* 729 */ 51089, 51114, 51139, 51164,
	/* 733 */ 51198, 51224, 51250, 51276,
	/* 737 */ 51312, 51335, 51358, 51381,
	/* 741 */ 51411, 51445, 51480, 51515,
	/* 745 */ 51558, 51592, 51627, 51662,
	/* 749 */ 51705, 51728, 51751, 51774,
	/* 753 */ 51804, 51838, 51873, 51908,
	/* 757 */ 51956, 51990, 52025, 52060,
	/* 761 */ 52108, 52136, 52164, 52192,
	/* 765 */ 52232, 52271, 52311, 52351,
	/* 769 */ 52409, 52448, 52488, 52528,
	/* 773 */ 52681, 52694, 52707, 52720, 52741, 52760, 52778, 52796, 52811, 52828, 52845, 52857, 52868, 52880, 52893, 52905,
	/* 789 */ 53129,
	/* 790 */ 53658, 53679, 53700, 53721, 53742,
	/* 795 */ 54003,
	/* 796 */ 54183, 54199, 54216, 54233, 54254,
	/* 801 */ 54347, 54363, 54379, 54396, 54413, 54434, 54458, 54482, 54505, 54528,
	/* 811 */ 54715, 54742, 54760, 54778, 54800, 54824, 54845, 54864, 54885, 54906, 54928,
	/* 822 */ 54990, 54996, -1, 55009, -1, -1, -1, 55022, -1, -1, -1, 55034, -1, 55046, -1, 55058,
	/* 838 */ 55565, 55600, 55635, 55667, 55699, 55731, 55763, 55797,
	/* 846 */ 55861, 55875, 55888, 55906, 55919, 55932, 55953, 55977,
	/* 854 */ 56053, 56064, 56074, 56090, 56116, 56132, 56158, 56174, 56200, 56216, 56242, -1, -1, 56267, 56288, 56319, 56336, 56357, 56374, 56395, 56416,
	/* 875 */ 56462, 56480, 56499, 56516, 56533,
	/* 880 */ 56661, 56676, 56697, 56719,
	/* 884 */ 56753, 56769,
	/* 886 */ 56877, 56888, 56898, 56909, 56921, 56934, 56948, 56960,
	/* 894 */ 56988, 56998, 57007, 57017, 57028, 57040, 57053, 57064,
	/* 902 */ 57485, 57496, 57506, 57530, -1, 57541, 57561,
	/* 909 */ 57579, -1, -1, -1, -1, 57586, -1, -1, -1, -1, 57593, -1, -1, -1, -1, 57600, -1, 57607, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 57614, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 57621, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 57628, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 57635, -1, -1, -1, -1, 57642, -1, -1, -1, -1, 57649, -1, -1, -1, -1, 57656, -1, -1, -1, -1, -1, -1, 57663, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 57670, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 57677, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 57684, -1, -1, -1, -1, -1, -1, 57691, -1, -1, -1, -1, 57698, -1, -1, -1, -1, 57705, -1, -1, -1, -1, 57712, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 57719, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 57726, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 57733, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 57740, -1, 57747, -1, -1, -1, -1, 57754, -1, -1, -1, -1, 57761, -1, -1, -1, -1, 57768,
	/* 1165 */ 57851, 57858, 57878, 57883,
	/* 1169 */ 58029, 58042, 58061, 58083,
	/* 1173 */ 58464, 58484,
	/* 1175 */ 58496, 58510, 58523,
	/* 1178 */ 60045, 60067, 60087, 60108, 60129,
	/* 1183 */ 60172, 60189, 60205, 60220, 60236, 60252, 60276, 60300, 60324, 60348, 60369, 60385, 60400, 60424, 60447, 60471, 60491, 60510,
	/* 1201 */ 60553, 60566, 60580, 60592, 60605,
	/* 1206 */ 60678, 60695, 60712, 60728, 60744, 60760, 60776, 60793, 60811,
	/* 1215 */ 60874, 60881, 60895, 60909, 60923, 60937,
	/* 1221 */ 60947, 60959, 60970, 60981,
	/* 1225 */ 61153, -1, -1, 61168,
	/* 1229 */ 61807, 61830, 61853,
	/* 1232 */ 61956, 61969, 61982,
	/* 1235 */ 61994, 62012, 62032, 62052,
	/* 1239 */ 62080, 62096, 62113,
	/* 1242 */ 62140, 62155,
	/* 1244 */ -1, 62233, 62256, 62279, 62302, 62317, 62330, 62342, 62359, -1, 62378, 62398, 62418, 62437, -1, 62449, 62466, 62483, 62499, -1, 62515, 62544, 62555, 62581, 62599, 62616, 62635, 62653, 62672, 62688, 62704, 62724, 62746, 62768, 62782, 62801, 62817, -1, -1, 62827, 62842, -1, 62860, 62883, 62908, 62930, 62955, 38562, 38589, 62977, -1, 63005, 63024, 63042, 63062, 63081, 63101, 63125, 63146,
	/* 1303 */ 63589, 63602, 63614,
	/* 1306 */ 63626, 63639, 63651,
	/* 1309 */ 63665, 63679, 63691,
	/* 1312 */ 63822, 63835, 63849,
	/* 1315 */ 63859, 63872, 63882, 63896,
	/* 1319 */ 63924, 63937, 63949, 63968,
	/* 1323 */ 62140, 62155, 64065,
	/* 1326 */ 64083, 64109, 64135, 64160,
	/* 1330 */ 64939, 64950, 64958, 64974,
	/* 1334 */ 65000, 65026, 65051, 65076, 65099, 65120, 65147, 65176,
	/* 1342 */ 65513, 65525, 65538, 65551,
	/* 1346 */ 65571, 65585, 65593, 65602, 65612, 65621, 65633, 65648, 65663, 65680, 65697, 65711, 65723, -1, 65741, -1, 65759, 65771, 65785, 65799, 65813, 65824, 65835,
	/* 1369 */ 65856, 65869, -1, -1, 65882, 65894, 65906, 65918,
	/* 1377 */ 65943, 65952, 65961, 65974,
	/* 1381 */ 66051, 66066, 66084, 66112, 66142, 66173, 66201, 66231,
	/* 1389 */ 66476, 66495, 66515,
	/* 1392 */ 66563, 66582,
	/* 1394 */ 40211, 40235, 40253, 40272, 40292, 40311, 40333, 40358, 40383, 40410, 40437, 40461, 40483, 40511, 40536, 40564, 40592, 40614, 40638, 40662, 40686, 40707, 40728, 40753, 40782, 40807, 40833, 40856, 40880, 40907, 40935, 67220, 40991, 41013, 41035, 41059, 41079, 41099, 41119, 41139, 41159, 41179, 67240, 67268, 67307, 67346, 67368, 67396, 67424, 67457, 67485, 67513, 67546, 67570, 67597, 67630, 67669, 41665, 41685, 67697, 67719, 67741, 67765, 41802,
	/* 1458 */ 41853, 41874, 41895, 41918, 41941, 41961, 67809, 42006, 67835, 42053, 67859,
	/* 1469 */ 67901, 67917, 67933, 67949, 67965, 67981, 67997, 68015, 68032, 68050, 68067, 68084, 68102,
	/* 1482 */ 68137, 68153, 68169, 68185, 68201, 68217, 68233, 68249, 68265, 68282, 68299, 68316, 68334, 68352,
	/* 1496 */ 68389, 68407, 68425, 68443, 68461, 68479, 68497, 68515, 68533, 68551,
	/* 1506 */ 68619, 68635, 68651, 68667, 68683, 68699,
	/* 1512 */ 245, 69670, 48894, 8050,
	/* 1516 */ -1, 62233, 62256, 62279, 62302, 62317, 62330, 62342, 62359, -1, 62378, 62398, 62418, 62437, 70705, 62449, 62466, 62483, 70717, 70728, 62515, 62544, 62555, 62581, 62599, 62616, 62635, 62653, -1, -1, 62704, 62724, 62746, 62768, 62782, 62801, 62817, 70748, -1, 62827, 62842, -1, 62860, 62883, 62908, 62930, 62955, 38562, 38589, 62977, -1, 63005, 63024, 63042, 63062, 63081, 63101, 63125, 63146, -1, -1, 70762, 70782,
	/* 1579 */ 70983, 70999, 71016, 71043,
	/* 1583 */ 42477, 42492, 42507, 8050,
};

#endif
