/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.contrib;

import java.awt.Point;
import org.jhotdraw.contrib.PolygonFigure;
import org.jhotdraw.figures.PolyLineHandle;
import org.jhotdraw.framework.DrawingView;
import org.jhotdraw.framework.FigureEnumeration;
import org.jhotdraw.framework.Locator;
import org.jhotdraw.standard.AbstractHandle;
import org.jhotdraw.standard.SingleFigureEnumerator;
import org.jhotdraw.util.Undoable;

public class PolygonHandle
extends AbstractHandle {
    private Locator fLocator;
    private int fIndex;

    public PolygonHandle(PolygonFigure polygonFigure, Locator locator, int n) {
        super(polygonFigure);
        this.fLocator = locator;
        this.fIndex = n;
    }

    public void invokeStart(int n, int n2, DrawingView drawingView) {
        this.setUndoActivity(this.createUndoActivity(drawingView, this.fIndex));
        this.getUndoActivity().setAffectedFigures(new SingleFigureEnumerator(this.owner()));
        ((UndoActivity)this.getUndoActivity()).setOldPoint(new Point(n, n2));
    }

    public void invokeStep(int n, int n2, int n3, int n4, DrawingView drawingView) {
        int n5 = ((PolyLineHandle.UndoActivity)this.getUndoActivity()).getPointIndex();
        this.myOwner().setPointAt(new Point(n, n2), n5);
    }

    public void invokeEnd(int n, int n2, int n3, int n4, DrawingView drawingView) {
        this.myOwner().smoothPoints();
        if (n == n3 && n2 == n4) {
            this.setUndoActivity(null);
        }
    }

    public Point locate() {
        return this.fLocator.locate(this.owner());
    }

    private PolygonFigure myOwner() {
        return (PolygonFigure)this.owner();
    }

    protected Undoable createUndoActivity(DrawingView drawingView, int n) {
        return new UndoActivity(drawingView, n);
    }

    public static class UndoActivity
    extends PolyLineHandle.UndoActivity {
        public UndoActivity(DrawingView drawingView, int n) {
            super(drawingView, n);
        }

        protected boolean movePointToOldLocation() {
            FigureEnumeration figureEnumeration = this.getAffectedFigures();
            if (!figureEnumeration.hasNextFigure()) {
                return false;
            }
            PolygonFigure polygonFigure = (PolygonFigure)figureEnumeration.nextFigure();
            Point point = polygonFigure.pointAt(this.getPointIndex());
            polygonFigure.setPointAt(this.getOldPoint(), this.getPointIndex());
            polygonFigure.smoothPoints();
            this.setOldPoint(point);
            return true;
        }
    }
}

