/* Copyright 2021 Mozilla Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// ./test/core/simd/simd_i16x8_sat_arith.wast

// ./test/core/simd/simd_i16x8_sat_arith.wast:4
let $0 = instantiate(`(module
  (func (export "i16x8.add_sat_s") (param v128 v128) (result v128) (i16x8.add_sat_s (local.get 0) (local.get 1)))
  (func (export "i16x8.add_sat_u") (param v128 v128) (result v128) (i16x8.add_sat_u (local.get 0) (local.get 1)))
  (func (export "i16x8.sub_sat_s") (param v128 v128) (result v128) (i16x8.sub_sat_s (local.get 0) (local.get 1)))
  (func (export "i16x8.sub_sat_u") (param v128 v128) (result v128) (i16x8.sub_sat_u (local.get 0) (local.get 1)))
)`);

// ./test/core/simd/simd_i16x8_sat_arith.wast:13
assert_return(
  () =>
    invoke($0, `i16x8.add_sat_s`, [
      i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
      i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:16
assert_return(
  () =>
    invoke($0, `i16x8.add_sat_s`, [
      i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
      i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
    ]),
  [i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:19
assert_return(
  () =>
    invoke($0, `i16x8.add_sat_s`, [
      i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
      i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
    ]),
  [i16x8([0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:22
assert_return(
  () =>
    invoke($0, `i16x8.add_sat_s`, [
      i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:25
assert_return(
  () =>
    invoke($0, `i16x8.add_sat_s`, [
      i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:28
assert_return(
  () =>
    invoke($0, `i16x8.add_sat_s`, [
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    ]),
  [i16x8([0xfffe, 0xfffe, 0xfffe, 0xfffe, 0xfffe, 0xfffe, 0xfffe, 0xfffe])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:31
assert_return(
  () =>
    invoke($0, `i16x8.add_sat_s`, [
      i16x8([0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff]),
      i16x8([0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000]),
    ]),
  [i16x8([0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:34
assert_return(
  () =>
    invoke($0, `i16x8.add_sat_s`, [
      i16x8([0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000]),
      i16x8([0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000]),
    ]),
  [i16x8([0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:37
assert_return(
  () =>
    invoke($0, `i16x8.add_sat_s`, [
      i16x8([0xc001, 0xc001, 0xc001, 0xc001, 0xc001, 0xc001, 0xc001, 0xc001]),
      i16x8([0xc000, 0xc000, 0xc000, 0xc000, 0xc000, 0xc000, 0xc000, 0xc000]),
    ]),
  [i16x8([0x8001, 0x8001, 0x8001, 0x8001, 0x8001, 0x8001, 0x8001, 0x8001])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:40
assert_return(
  () =>
    invoke($0, `i16x8.add_sat_s`, [
      i16x8([0xc000, 0xc000, 0xc000, 0xc000, 0xc000, 0xc000, 0xc000, 0xc000]),
      i16x8([0xc000, 0xc000, 0xc000, 0xc000, 0xc000, 0xc000, 0xc000, 0xc000]),
    ]),
  [i16x8([0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:43
assert_return(
  () =>
    invoke($0, `i16x8.add_sat_s`, [
      i16x8([0xbfff, 0xbfff, 0xbfff, 0xbfff, 0xbfff, 0xbfff, 0xbfff, 0xbfff]),
      i16x8([0xc000, 0xc000, 0xc000, 0xc000, 0xc000, 0xc000, 0xc000, 0xc000]),
    ]),
  [i16x8([0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:46
assert_return(
  () =>
    invoke($0, `i16x8.add_sat_s`, [
      i16x8([0x7ffd, 0x7ffd, 0x7ffd, 0x7ffd, 0x7ffd, 0x7ffd, 0x7ffd, 0x7ffd]),
      i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
    ]),
  [i16x8([0x7ffe, 0x7ffe, 0x7ffe, 0x7ffe, 0x7ffe, 0x7ffe, 0x7ffe, 0x7ffe])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:49
assert_return(
  () =>
    invoke($0, `i16x8.add_sat_s`, [
      i16x8([0x7ffe, 0x7ffe, 0x7ffe, 0x7ffe, 0x7ffe, 0x7ffe, 0x7ffe, 0x7ffe]),
      i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
    ]),
  [i16x8([0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:52
assert_return(
  () =>
    invoke($0, `i16x8.add_sat_s`, [
      i16x8([0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000]),
      i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
    ]),
  [i16x8([0x8001, 0x8001, 0x8001, 0x8001, 0x8001, 0x8001, 0x8001, 0x8001])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:55
assert_return(
  () =>
    invoke($0, `i16x8.add_sat_s`, [
      i16x8([0x8002, 0x8002, 0x8002, 0x8002, 0x8002, 0x8002, 0x8002, 0x8002]),
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    ]),
  [i16x8([0x8001, 0x8001, 0x8001, 0x8001, 0x8001, 0x8001, 0x8001, 0x8001])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:58
assert_return(
  () =>
    invoke($0, `i16x8.add_sat_s`, [
      i16x8([0x8001, 0x8001, 0x8001, 0x8001, 0x8001, 0x8001, 0x8001, 0x8001]),
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    ]),
  [i16x8([0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:61
assert_return(
  () =>
    invoke($0, `i16x8.add_sat_s`, [
      i16x8([0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000]),
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    ]),
  [i16x8([0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:64
assert_return(
  () =>
    invoke($0, `i16x8.add_sat_s`, [
      i16x8([0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff]),
      i16x8([0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff]),
    ]),
  [i16x8([0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:67
assert_return(
  () =>
    invoke($0, `i16x8.add_sat_s`, [
      i16x8([0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000]),
      i16x8([0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000]),
    ]),
  [i16x8([0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:70
assert_return(
  () =>
    invoke($0, `i16x8.add_sat_s`, [
      i16x8([0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000]),
      i16x8([0x8001, 0x8001, 0x8001, 0x8001, 0x8001, 0x8001, 0x8001, 0x8001]),
    ]),
  [i16x8([0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:73
assert_return(
  () =>
    invoke($0, `i16x8.add_sat_s`, [
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
      i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:76
assert_return(
  () =>
    invoke($0, `i16x8.add_sat_s`, [
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
      i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
    ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:79
assert_return(
  () =>
    invoke($0, `i16x8.add_sat_s`, [
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    ]),
  [i16x8([0xfffe, 0xfffe, 0xfffe, 0xfffe, 0xfffe, 0xfffe, 0xfffe, 0xfffe])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:82
assert_return(
  () =>
    invoke($0, `i16x8.add_sat_s`, [
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
      i16x8([0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff]),
    ]),
  [i16x8([0x7ffe, 0x7ffe, 0x7ffe, 0x7ffe, 0x7ffe, 0x7ffe, 0x7ffe, 0x7ffe])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:85
assert_return(
  () =>
    invoke($0, `i16x8.add_sat_s`, [
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
      i16x8([0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000]),
    ]),
  [i16x8([0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:88
assert_return(
  () =>
    invoke($0, `i16x8.add_sat_s`, [
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    ]),
  [i16x8([0xfffe, 0xfffe, 0xfffe, 0xfffe, 0xfffe, 0xfffe, 0xfffe, 0xfffe])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:91
assert_return(
  () =>
    invoke($0, `i16x8.add_sat_s`, [
      i16x8([0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff]),
      i16x8([0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000]),
    ]),
  [i16x8([0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:94
assert_return(
  () =>
    invoke($0, `i16x8.add_sat_s`, [
      i16x8([0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000]),
      i16x8([0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000]),
    ]),
  [i16x8([0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:97
assert_return(
  () =>
    invoke($0, `i16x8.add_sat_s`, [
      i16x8([0xc001, 0xc001, 0xc001, 0xc001, 0xc001, 0xc001, 0xc001, 0xc001]),
      i16x8([0xc000, 0xc000, 0xc000, 0xc000, 0xc000, 0xc000, 0xc000, 0xc000]),
    ]),
  [i16x8([0x8001, 0x8001, 0x8001, 0x8001, 0x8001, 0x8001, 0x8001, 0x8001])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:100
assert_return(
  () =>
    invoke($0, `i16x8.add_sat_s`, [
      i16x8([0xc000, 0xc000, 0xc000, 0xc000, 0xc000, 0xc000, 0xc000, 0xc000]),
      i16x8([0xc000, 0xc000, 0xc000, 0xc000, 0xc000, 0xc000, 0xc000, 0xc000]),
    ]),
  [i16x8([0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:103
assert_return(
  () =>
    invoke($0, `i16x8.add_sat_s`, [
      i16x8([0xc000, 0xc000, 0xc000, 0xc000, 0xc000, 0xc000, 0xc000, 0xc000]),
      i16x8([0xbfff, 0xbfff, 0xbfff, 0xbfff, 0xbfff, 0xbfff, 0xbfff, 0xbfff]),
    ]),
  [i16x8([0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:106
assert_return(
  () =>
    invoke($0, `i16x8.add_sat_s`, [
      i16x8([0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff]),
      i16x8([0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff]),
    ]),
  [i16x8([0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:109
assert_return(
  () =>
    invoke($0, `i16x8.add_sat_s`, [
      i16x8([0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff]),
      i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
    ]),
  [i16x8([0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:112
assert_return(
  () =>
    invoke($0, `i16x8.add_sat_s`, [
      i16x8([0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000]),
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    ]),
  [i16x8([0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:115
assert_return(
  () =>
    invoke($0, `i16x8.add_sat_s`, [
      i16x8([0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff]),
      i16x8([0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000]),
    ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:118
assert_return(
  () =>
    invoke($0, `i16x8.add_sat_s`, [
      i16x8([0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000]),
      i16x8([0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000]),
    ]),
  [i16x8([0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:121
assert_return(
  () =>
    invoke($0, `i16x8.add_sat_s`, [
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
      i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
    ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:124
assert_return(
  () =>
    invoke($0, `i16x8.add_sat_s`, [
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    ]),
  [i16x8([0xfffe, 0xfffe, 0xfffe, 0xfffe, 0xfffe, 0xfffe, 0xfffe, 0xfffe])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:127
assert_return(
  () =>
    invoke($0, `i16x8.add_sat_s`, [
      i16x8([0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x80,
        0x0,
        0x0,
        0x0,
        0x80,
        0x0,
        0x0,
        0x0,
        0x80,
        0x0,
        0x0,
        0x0,
        0x80,
      ]),
    ]),
  [i16x8([0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:130
assert_return(
  () =>
    invoke($0, `i16x8.add_sat_s`, [
      i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [i16x8([0x1, 0x7f81, 0x1, 0x7f81, 0x1, 0x7f81, 0x1, 0x7f81])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:133
assert_return(
  () =>
    invoke($0, `i16x8.add_sat_s`, [
      i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [i16x8([0x1, 0xff81, 0x1, 0xff81, 0x1, 0xff81, 0x1, 0xff81])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:136
assert_return(
  () =>
    invoke($0, `i16x8.add_sat_s`, [
      i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [i16x8([0x1, 0x7fc1, 0x1, 0x7fc1, 0x1, 0x7fc1, 0x1, 0x7fc1])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:139
assert_return(
  () =>
    invoke($0, `i16x8.add_sat_s`, [
      i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [i16x8([0x1, 0xffc1, 0x1, 0xffc1, 0x1, 0xffc1, 0x1, 0xffc1])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:142
assert_return(
  () =>
    invoke($0, `i16x8.add_sat_s`, [
      i16x8([0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7]),
      i16x8([0x0, 0xffff, 0xfffe, 0xfffd, 0xfffc, 0xfffb, 0xfffa, 0xfff9]),
    ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:145
assert_return(
  () =>
    invoke($0, `i16x8.add_sat_s`, [
      i16x8([0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7]),
      i16x8([0x0, 0x2, 0x4, 0x6, 0x8, 0xa, 0xc, 0xe]),
    ]),
  [i16x8([0x0, 0x3, 0x6, 0x9, 0xc, 0xf, 0x12, 0x15])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:148
assert_return(
  () =>
    invoke($0, `i16x8.add_sat_s`, [
      i16x8([0x3039, 0x3039, 0x3039, 0x3039, 0x3039, 0x3039, 0x3039, 0x3039]),
      i16x8([0x7d7b, 0x7d7b, 0x7d7b, 0x7d7b, 0x7d7b, 0x7d7b, 0x7d7b, 0x7d7b]),
    ]),
  [i16x8([0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:151
assert_return(
  () =>
    invoke($0, `i16x8.add_sat_s`, [
      i16x8([0x3039, 0x3039, 0x3039, 0x3039, 0x3039, 0x3039, 0x3039, 0x3039]),
      i16x8([0xddd5, 0xddd5, 0xddd5, 0xddd5, 0xddd5, 0xddd5, 0xddd5, 0xddd5]),
    ]),
  [i16x8([0xe0e, 0xe0e, 0xe0e, 0xe0e, 0xe0e, 0xe0e, 0xe0e, 0xe0e])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:154
assert_return(
  () =>
    invoke($0, `i16x8.add_sat_s`, [
      i16x8([0x1234, 0x1234, 0x1234, 0x1234, 0x1234, 0x1234, 0x1234, 0x1234]),
      i16x8([0x5678, 0x5678, 0x5678, 0x5678, 0x5678, 0x5678, 0x5678, 0x5678]),
    ]),
  [i16x8([0x68ac, 0x68ac, 0x68ac, 0x68ac, 0x68ac, 0x68ac, 0x68ac, 0x68ac])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:157
assert_return(
  () =>
    invoke($0, `i16x8.add_sat_s`, [
      i16x8([0x90ab, 0x90ab, 0x90ab, 0x90ab, 0x90ab, 0x90ab, 0x90ab, 0x90ab]),
      i16x8([0xcdef, 0xcdef, 0xcdef, 0xcdef, 0xcdef, 0xcdef, 0xcdef, 0xcdef]),
    ]),
  [i16x8([0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:162
assert_return(
  () =>
    invoke($0, `i16x8.add_sat_u`, [
      i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
      i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:165
assert_return(
  () =>
    invoke($0, `i16x8.add_sat_u`, [
      i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
      i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
    ]),
  [i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:168
assert_return(
  () =>
    invoke($0, `i16x8.add_sat_u`, [
      i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
      i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
    ]),
  [i16x8([0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:171
assert_return(
  () =>
    invoke($0, `i16x8.add_sat_u`, [
      i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:174
assert_return(
  () =>
    invoke($0, `i16x8.add_sat_u`, [
      i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:177
assert_return(
  () =>
    invoke($0, `i16x8.add_sat_u`, [
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:180
assert_return(
  () =>
    invoke($0, `i16x8.add_sat_u`, [
      i16x8([0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff]),
      i16x8([0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000]),
    ]),
  [i16x8([0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:183
assert_return(
  () =>
    invoke($0, `i16x8.add_sat_u`, [
      i16x8([0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000]),
      i16x8([0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000]),
    ]),
  [i16x8([0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:186
assert_return(
  () =>
    invoke($0, `i16x8.add_sat_u`, [
      i16x8([0xc001, 0xc001, 0xc001, 0xc001, 0xc001, 0xc001, 0xc001, 0xc001]),
      i16x8([0xc000, 0xc000, 0xc000, 0xc000, 0xc000, 0xc000, 0xc000, 0xc000]),
    ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:189
assert_return(
  () =>
    invoke($0, `i16x8.add_sat_u`, [
      i16x8([0xc000, 0xc000, 0xc000, 0xc000, 0xc000, 0xc000, 0xc000, 0xc000]),
      i16x8([0xc000, 0xc000, 0xc000, 0xc000, 0xc000, 0xc000, 0xc000, 0xc000]),
    ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:192
assert_return(
  () =>
    invoke($0, `i16x8.add_sat_u`, [
      i16x8([0xbfff, 0xbfff, 0xbfff, 0xbfff, 0xbfff, 0xbfff, 0xbfff, 0xbfff]),
      i16x8([0xc000, 0xc000, 0xc000, 0xc000, 0xc000, 0xc000, 0xc000, 0xc000]),
    ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:195
assert_return(
  () =>
    invoke($0, `i16x8.add_sat_u`, [
      i16x8([0x7ffd, 0x7ffd, 0x7ffd, 0x7ffd, 0x7ffd, 0x7ffd, 0x7ffd, 0x7ffd]),
      i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
    ]),
  [i16x8([0x7ffe, 0x7ffe, 0x7ffe, 0x7ffe, 0x7ffe, 0x7ffe, 0x7ffe, 0x7ffe])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:198
assert_return(
  () =>
    invoke($0, `i16x8.add_sat_u`, [
      i16x8([0x7ffe, 0x7ffe, 0x7ffe, 0x7ffe, 0x7ffe, 0x7ffe, 0x7ffe, 0x7ffe]),
      i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
    ]),
  [i16x8([0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:201
assert_return(
  () =>
    invoke($0, `i16x8.add_sat_u`, [
      i16x8([0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000]),
      i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
    ]),
  [i16x8([0x8001, 0x8001, 0x8001, 0x8001, 0x8001, 0x8001, 0x8001, 0x8001])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:204
assert_return(
  () =>
    invoke($0, `i16x8.add_sat_u`, [
      i16x8([0x8002, 0x8002, 0x8002, 0x8002, 0x8002, 0x8002, 0x8002, 0x8002]),
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:207
assert_return(
  () =>
    invoke($0, `i16x8.add_sat_u`, [
      i16x8([0x8001, 0x8001, 0x8001, 0x8001, 0x8001, 0x8001, 0x8001, 0x8001]),
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:210
assert_return(
  () =>
    invoke($0, `i16x8.add_sat_u`, [
      i16x8([0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000]),
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:213
assert_return(
  () =>
    invoke($0, `i16x8.add_sat_u`, [
      i16x8([0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff]),
      i16x8([0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff]),
    ]),
  [i16x8([0xfffe, 0xfffe, 0xfffe, 0xfffe, 0xfffe, 0xfffe, 0xfffe, 0xfffe])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:216
assert_return(
  () =>
    invoke($0, `i16x8.add_sat_u`, [
      i16x8([0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000]),
      i16x8([0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000]),
    ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:219
assert_return(
  () =>
    invoke($0, `i16x8.add_sat_u`, [
      i16x8([0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000]),
      i16x8([0x8001, 0x8001, 0x8001, 0x8001, 0x8001, 0x8001, 0x8001, 0x8001]),
    ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:222
assert_return(
  () =>
    invoke($0, `i16x8.add_sat_u`, [
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
      i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:225
assert_return(
  () =>
    invoke($0, `i16x8.add_sat_u`, [
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
      i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
    ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:228
assert_return(
  () =>
    invoke($0, `i16x8.add_sat_u`, [
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:231
assert_return(
  () =>
    invoke($0, `i16x8.add_sat_u`, [
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
      i16x8([0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff]),
    ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:234
assert_return(
  () =>
    invoke($0, `i16x8.add_sat_u`, [
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
      i16x8([0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000]),
    ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:237
assert_return(
  () =>
    invoke($0, `i16x8.add_sat_u`, [
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:240
assert_return(
  () =>
    invoke($0, `i16x8.add_sat_u`, [
      i16x8([0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff]),
      i16x8([0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000]),
    ]),
  [i16x8([0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:243
assert_return(
  () =>
    invoke($0, `i16x8.add_sat_u`, [
      i16x8([0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000]),
      i16x8([0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000]),
    ]),
  [i16x8([0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:246
assert_return(
  () =>
    invoke($0, `i16x8.add_sat_u`, [
      i16x8([0xc001, 0xc001, 0xc001, 0xc001, 0xc001, 0xc001, 0xc001, 0xc001]),
      i16x8([0xc000, 0xc000, 0xc000, 0xc000, 0xc000, 0xc000, 0xc000, 0xc000]),
    ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:249
assert_return(
  () =>
    invoke($0, `i16x8.add_sat_u`, [
      i16x8([0xc000, 0xc000, 0xc000, 0xc000, 0xc000, 0xc000, 0xc000, 0xc000]),
      i16x8([0xc000, 0xc000, 0xc000, 0xc000, 0xc000, 0xc000, 0xc000, 0xc000]),
    ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:252
assert_return(
  () =>
    invoke($0, `i16x8.add_sat_u`, [
      i16x8([0xc000, 0xc000, 0xc000, 0xc000, 0xc000, 0xc000, 0xc000, 0xc000]),
      i16x8([0xbfff, 0xbfff, 0xbfff, 0xbfff, 0xbfff, 0xbfff, 0xbfff, 0xbfff]),
    ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:255
assert_return(
  () =>
    invoke($0, `i16x8.add_sat_u`, [
      i16x8([0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff]),
      i16x8([0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff]),
    ]),
  [i16x8([0xfffe, 0xfffe, 0xfffe, 0xfffe, 0xfffe, 0xfffe, 0xfffe, 0xfffe])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:258
assert_return(
  () =>
    invoke($0, `i16x8.add_sat_u`, [
      i16x8([0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff]),
      i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
    ]),
  [i16x8([0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:261
assert_return(
  () =>
    invoke($0, `i16x8.add_sat_u`, [
      i16x8([0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000]),
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:264
assert_return(
  () =>
    invoke($0, `i16x8.add_sat_u`, [
      i16x8([0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff]),
      i16x8([0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000]),
    ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:267
assert_return(
  () =>
    invoke($0, `i16x8.add_sat_u`, [
      i16x8([0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000]),
      i16x8([0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000]),
    ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:270
assert_return(
  () =>
    invoke($0, `i16x8.add_sat_u`, [
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
      i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
    ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:273
assert_return(
  () =>
    invoke($0, `i16x8.add_sat_u`, [
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:276
assert_return(
  () =>
    invoke($0, `i16x8.add_sat_u`, [
      i16x8([0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x80,
        0x0,
        0x0,
        0x0,
        0x80,
        0x0,
        0x0,
        0x0,
        0x80,
        0x0,
        0x0,
        0x0,
        0x80,
      ]),
    ]),
  [i16x8([0x8000, 0xffff, 0x8000, 0xffff, 0x8000, 0xffff, 0x8000, 0xffff])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:279
assert_return(
  () =>
    invoke($0, `i16x8.add_sat_u`, [
      i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [i16x8([0x1, 0x7f81, 0x1, 0x7f81, 0x1, 0x7f81, 0x1, 0x7f81])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:282
assert_return(
  () =>
    invoke($0, `i16x8.add_sat_u`, [
      i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [i16x8([0x1, 0xff81, 0x1, 0xff81, 0x1, 0xff81, 0x1, 0xff81])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:285
assert_return(
  () =>
    invoke($0, `i16x8.add_sat_u`, [
      i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [i16x8([0x1, 0x7fc1, 0x1, 0x7fc1, 0x1, 0x7fc1, 0x1, 0x7fc1])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:288
assert_return(
  () =>
    invoke($0, `i16x8.add_sat_u`, [
      i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [i16x8([0x1, 0x7fc1, 0x1, 0x7fc1, 0x1, 0x7fc1, 0x1, 0x7fc1])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:291
assert_return(
  () =>
    invoke($0, `i16x8.add_sat_u`, [
      i16x8([0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7]),
      i16x8([0x0, 0xffff, 0xfffe, 0xfffd, 0xfffc, 0xfffb, 0xfffa, 0xfff9]),
    ]),
  [i16x8([0x0, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:294
assert_return(
  () =>
    invoke($0, `i16x8.add_sat_u`, [
      i16x8([0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7]),
      i16x8([0x0, 0x2, 0x4, 0x6, 0x8, 0xa, 0xc, 0xe]),
    ]),
  [i16x8([0x0, 0x3, 0x6, 0x9, 0xc, 0xf, 0x12, 0x15])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:297
assert_return(
  () =>
    invoke($0, `i16x8.add_sat_u`, [
      i16x8([0x3039, 0x3039, 0x3039, 0x3039, 0x3039, 0x3039, 0x3039, 0x3039]),
      i16x8([0xddd5, 0xddd5, 0xddd5, 0xddd5, 0xddd5, 0xddd5, 0xddd5, 0xddd5]),
    ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:300
assert_return(
  () =>
    invoke($0, `i16x8.add_sat_u`, [
      i16x8([0x3039, 0x3039, 0x3039, 0x3039, 0x3039, 0x3039, 0x3039, 0x3039]),
      i16x8([0xcfc7, 0xcfc7, 0xcfc7, 0xcfc7, 0xcfc7, 0xcfc7, 0xcfc7, 0xcfc7]),
    ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:303
assert_return(
  () =>
    invoke($0, `i16x8.add_sat_u`, [
      i16x8([0x1234, 0x1234, 0x1234, 0x1234, 0x1234, 0x1234, 0x1234, 0x1234]),
      i16x8([0x5678, 0x5678, 0x5678, 0x5678, 0x5678, 0x5678, 0x5678, 0x5678]),
    ]),
  [i16x8([0x68ac, 0x68ac, 0x68ac, 0x68ac, 0x68ac, 0x68ac, 0x68ac, 0x68ac])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:306
assert_return(
  () =>
    invoke($0, `i16x8.add_sat_u`, [
      i16x8([0x90ab, 0x90ab, 0x90ab, 0x90ab, 0x90ab, 0x90ab, 0x90ab, 0x90ab]),
      i16x8([0xcdef, 0xcdef, 0xcdef, 0xcdef, 0xcdef, 0xcdef, 0xcdef, 0xcdef]),
    ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:311
assert_return(
  () =>
    invoke($0, `i16x8.sub_sat_s`, [
      i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
      i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:314
assert_return(
  () =>
    invoke($0, `i16x8.sub_sat_s`, [
      i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
      i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
    ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:317
assert_return(
  () =>
    invoke($0, `i16x8.sub_sat_s`, [
      i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
      i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
    ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:320
assert_return(
  () =>
    invoke($0, `i16x8.sub_sat_s`, [
      i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    ]),
  [i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:323
assert_return(
  () =>
    invoke($0, `i16x8.sub_sat_s`, [
      i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    ]),
  [i16x8([0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:326
assert_return(
  () =>
    invoke($0, `i16x8.sub_sat_s`, [
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:329
assert_return(
  () =>
    invoke($0, `i16x8.sub_sat_s`, [
      i16x8([0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff]),
      i16x8([0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000]),
    ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:332
assert_return(
  () =>
    invoke($0, `i16x8.sub_sat_s`, [
      i16x8([0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000]),
      i16x8([0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000]),
    ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:335
assert_return(
  () =>
    invoke($0, `i16x8.sub_sat_s`, [
      i16x8([0xc001, 0xc001, 0xc001, 0xc001, 0xc001, 0xc001, 0xc001, 0xc001]),
      i16x8([0xc000, 0xc000, 0xc000, 0xc000, 0xc000, 0xc000, 0xc000, 0xc000]),
    ]),
  [i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:338
assert_return(
  () =>
    invoke($0, `i16x8.sub_sat_s`, [
      i16x8([0xc000, 0xc000, 0xc000, 0xc000, 0xc000, 0xc000, 0xc000, 0xc000]),
      i16x8([0xc000, 0xc000, 0xc000, 0xc000, 0xc000, 0xc000, 0xc000, 0xc000]),
    ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:341
assert_return(
  () =>
    invoke($0, `i16x8.sub_sat_s`, [
      i16x8([0xbfff, 0xbfff, 0xbfff, 0xbfff, 0xbfff, 0xbfff, 0xbfff, 0xbfff]),
      i16x8([0xc000, 0xc000, 0xc000, 0xc000, 0xc000, 0xc000, 0xc000, 0xc000]),
    ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:344
assert_return(
  () =>
    invoke($0, `i16x8.sub_sat_s`, [
      i16x8([0x7ffd, 0x7ffd, 0x7ffd, 0x7ffd, 0x7ffd, 0x7ffd, 0x7ffd, 0x7ffd]),
      i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
    ]),
  [i16x8([0x7ffc, 0x7ffc, 0x7ffc, 0x7ffc, 0x7ffc, 0x7ffc, 0x7ffc, 0x7ffc])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:347
assert_return(
  () =>
    invoke($0, `i16x8.sub_sat_s`, [
      i16x8([0x7ffe, 0x7ffe, 0x7ffe, 0x7ffe, 0x7ffe, 0x7ffe, 0x7ffe, 0x7ffe]),
      i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
    ]),
  [i16x8([0x7ffd, 0x7ffd, 0x7ffd, 0x7ffd, 0x7ffd, 0x7ffd, 0x7ffd, 0x7ffd])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:350
assert_return(
  () =>
    invoke($0, `i16x8.sub_sat_s`, [
      i16x8([0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000]),
      i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
    ]),
  [i16x8([0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:353
assert_return(
  () =>
    invoke($0, `i16x8.sub_sat_s`, [
      i16x8([0x8002, 0x8002, 0x8002, 0x8002, 0x8002, 0x8002, 0x8002, 0x8002]),
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    ]),
  [i16x8([0x8003, 0x8003, 0x8003, 0x8003, 0x8003, 0x8003, 0x8003, 0x8003])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:356
assert_return(
  () =>
    invoke($0, `i16x8.sub_sat_s`, [
      i16x8([0x8001, 0x8001, 0x8001, 0x8001, 0x8001, 0x8001, 0x8001, 0x8001]),
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    ]),
  [i16x8([0x8002, 0x8002, 0x8002, 0x8002, 0x8002, 0x8002, 0x8002, 0x8002])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:359
assert_return(
  () =>
    invoke($0, `i16x8.sub_sat_s`, [
      i16x8([0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000]),
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    ]),
  [i16x8([0x8001, 0x8001, 0x8001, 0x8001, 0x8001, 0x8001, 0x8001, 0x8001])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:362
assert_return(
  () =>
    invoke($0, `i16x8.sub_sat_s`, [
      i16x8([0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff]),
      i16x8([0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff]),
    ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:365
assert_return(
  () =>
    invoke($0, `i16x8.sub_sat_s`, [
      i16x8([0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000]),
      i16x8([0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000]),
    ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:368
assert_return(
  () =>
    invoke($0, `i16x8.sub_sat_s`, [
      i16x8([0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000]),
      i16x8([0x8001, 0x8001, 0x8001, 0x8001, 0x8001, 0x8001, 0x8001, 0x8001]),
    ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:371
assert_return(
  () =>
    invoke($0, `i16x8.sub_sat_s`, [
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
      i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:374
assert_return(
  () =>
    invoke($0, `i16x8.sub_sat_s`, [
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
      i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
    ]),
  [i16x8([0xfffe, 0xfffe, 0xfffe, 0xfffe, 0xfffe, 0xfffe, 0xfffe, 0xfffe])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:377
assert_return(
  () =>
    invoke($0, `i16x8.sub_sat_s`, [
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:380
assert_return(
  () =>
    invoke($0, `i16x8.sub_sat_s`, [
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
      i16x8([0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff]),
    ]),
  [i16x8([0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:383
assert_return(
  () =>
    invoke($0, `i16x8.sub_sat_s`, [
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
      i16x8([0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000]),
    ]),
  [i16x8([0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:386
assert_return(
  () =>
    invoke($0, `i16x8.sub_sat_s`, [
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:389
assert_return(
  () =>
    invoke($0, `i16x8.sub_sat_s`, [
      i16x8([0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff]),
      i16x8([0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000]),
    ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:392
assert_return(
  () =>
    invoke($0, `i16x8.sub_sat_s`, [
      i16x8([0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000]),
      i16x8([0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000]),
    ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:395
assert_return(
  () =>
    invoke($0, `i16x8.sub_sat_s`, [
      i16x8([0xc001, 0xc001, 0xc001, 0xc001, 0xc001, 0xc001, 0xc001, 0xc001]),
      i16x8([0xc000, 0xc000, 0xc000, 0xc000, 0xc000, 0xc000, 0xc000, 0xc000]),
    ]),
  [i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:398
assert_return(
  () =>
    invoke($0, `i16x8.sub_sat_s`, [
      i16x8([0xc000, 0xc000, 0xc000, 0xc000, 0xc000, 0xc000, 0xc000, 0xc000]),
      i16x8([0xc000, 0xc000, 0xc000, 0xc000, 0xc000, 0xc000, 0xc000, 0xc000]),
    ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:401
assert_return(
  () =>
    invoke($0, `i16x8.sub_sat_s`, [
      i16x8([0xc000, 0xc000, 0xc000, 0xc000, 0xc000, 0xc000, 0xc000, 0xc000]),
      i16x8([0xbfff, 0xbfff, 0xbfff, 0xbfff, 0xbfff, 0xbfff, 0xbfff, 0xbfff]),
    ]),
  [i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:404
assert_return(
  () =>
    invoke($0, `i16x8.sub_sat_s`, [
      i16x8([0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff]),
      i16x8([0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff]),
    ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:407
assert_return(
  () =>
    invoke($0, `i16x8.sub_sat_s`, [
      i16x8([0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff]),
      i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
    ]),
  [i16x8([0x7ffe, 0x7ffe, 0x7ffe, 0x7ffe, 0x7ffe, 0x7ffe, 0x7ffe, 0x7ffe])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:410
assert_return(
  () =>
    invoke($0, `i16x8.sub_sat_s`, [
      i16x8([0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000]),
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    ]),
  [i16x8([0x8001, 0x8001, 0x8001, 0x8001, 0x8001, 0x8001, 0x8001, 0x8001])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:413
assert_return(
  () =>
    invoke($0, `i16x8.sub_sat_s`, [
      i16x8([0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff]),
      i16x8([0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000]),
    ]),
  [i16x8([0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:416
assert_return(
  () =>
    invoke($0, `i16x8.sub_sat_s`, [
      i16x8([0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000]),
      i16x8([0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000]),
    ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:419
assert_return(
  () =>
    invoke($0, `i16x8.sub_sat_s`, [
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
      i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
    ]),
  [i16x8([0xfffe, 0xfffe, 0xfffe, 0xfffe, 0xfffe, 0xfffe, 0xfffe, 0xfffe])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:422
assert_return(
  () =>
    invoke($0, `i16x8.sub_sat_s`, [
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:425
assert_return(
  () =>
    invoke($0, `i16x8.sub_sat_s`, [
      i16x8([0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x80,
        0x0,
        0x0,
        0x0,
        0x80,
        0x0,
        0x0,
        0x0,
        0x80,
        0x0,
        0x0,
        0x0,
        0x80,
      ]),
    ]),
  [i16x8([0x8000, 0x0, 0x8000, 0x0, 0x8000, 0x0, 0x8000, 0x0])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:428
assert_return(
  () =>
    invoke($0, `i16x8.sub_sat_s`, [
      i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [i16x8([0x1, 0x8081, 0x1, 0x8081, 0x1, 0x8081, 0x1, 0x8081])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:431
assert_return(
  () =>
    invoke($0, `i16x8.sub_sat_s`, [
      i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [i16x8([0x1, 0x81, 0x1, 0x81, 0x1, 0x81, 0x1, 0x81])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:434
assert_return(
  () =>
    invoke($0, `i16x8.sub_sat_s`, [
      i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [i16x8([0x1, 0x8041, 0x1, 0x8041, 0x1, 0x8041, 0x1, 0x8041])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:437
assert_return(
  () =>
    invoke($0, `i16x8.sub_sat_s`, [
      i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [i16x8([0x1, 0x41, 0x1, 0x41, 0x1, 0x41, 0x1, 0x41])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:440
assert_return(
  () =>
    invoke($0, `i16x8.sub_sat_s`, [
      i16x8([0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7]),
      i16x8([0x0, 0xffff, 0xfffe, 0xfffd, 0xfffc, 0xfffb, 0xfffa, 0xfff9]),
    ]),
  [i16x8([0x0, 0x2, 0x4, 0x6, 0x8, 0xa, 0xc, 0xe])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:443
assert_return(
  () =>
    invoke($0, `i16x8.sub_sat_s`, [
      i16x8([0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7]),
      i16x8([0x0, 0x2, 0x4, 0x6, 0x8, 0xa, 0xc, 0xe]),
    ]),
  [i16x8([0x0, 0xffff, 0xfffe, 0xfffd, 0xfffc, 0xfffb, 0xfffa, 0xfff9])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:446
assert_return(
  () =>
    invoke($0, `i16x8.sub_sat_s`, [
      i16x8([0x3039, 0x3039, 0x3039, 0x3039, 0x3039, 0x3039, 0x3039, 0x3039]),
      i16x8([0xddd5, 0xddd5, 0xddd5, 0xddd5, 0xddd5, 0xddd5, 0xddd5, 0xddd5]),
    ]),
  [i16x8([0x5264, 0x5264, 0x5264, 0x5264, 0x5264, 0x5264, 0x5264, 0x5264])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:449
assert_return(
  () =>
    invoke($0, `i16x8.sub_sat_s`, [
      i16x8([0x3039, 0x3039, 0x3039, 0x3039, 0x3039, 0x3039, 0x3039, 0x3039]),
      i16x8([0xcfc7, 0xcfc7, 0xcfc7, 0xcfc7, 0xcfc7, 0xcfc7, 0xcfc7, 0xcfc7]),
    ]),
  [i16x8([0x6072, 0x6072, 0x6072, 0x6072, 0x6072, 0x6072, 0x6072, 0x6072])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:452
assert_return(
  () =>
    invoke($0, `i16x8.sub_sat_s`, [
      i16x8([0x1234, 0x1234, 0x1234, 0x1234, 0x1234, 0x1234, 0x1234, 0x1234]),
      i16x8([0x5678, 0x5678, 0x5678, 0x5678, 0x5678, 0x5678, 0x5678, 0x5678]),
    ]),
  [i16x8([0xbbbc, 0xbbbc, 0xbbbc, 0xbbbc, 0xbbbc, 0xbbbc, 0xbbbc, 0xbbbc])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:455
assert_return(
  () =>
    invoke($0, `i16x8.sub_sat_s`, [
      i16x8([0x90ab, 0x90ab, 0x90ab, 0x90ab, 0x90ab, 0x90ab, 0x90ab, 0x90ab]),
      i16x8([0xedcc, 0xedcc, 0xedcc, 0xedcc, 0xedcc, 0xedcc, 0xedcc, 0xedcc]),
    ]),
  [i16x8([0xa2df, 0xa2df, 0xa2df, 0xa2df, 0xa2df, 0xa2df, 0xa2df, 0xa2df])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:460
assert_return(
  () =>
    invoke($0, `i16x8.sub_sat_u`, [
      i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
      i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:463
assert_return(
  () =>
    invoke($0, `i16x8.sub_sat_u`, [
      i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
      i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
    ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:466
assert_return(
  () =>
    invoke($0, `i16x8.sub_sat_u`, [
      i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
      i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
    ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:469
assert_return(
  () =>
    invoke($0, `i16x8.sub_sat_u`, [
      i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:472
assert_return(
  () =>
    invoke($0, `i16x8.sub_sat_u`, [
      i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:475
assert_return(
  () =>
    invoke($0, `i16x8.sub_sat_u`, [
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:478
assert_return(
  () =>
    invoke($0, `i16x8.sub_sat_u`, [
      i16x8([0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff]),
      i16x8([0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000]),
    ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:481
assert_return(
  () =>
    invoke($0, `i16x8.sub_sat_u`, [
      i16x8([0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000]),
      i16x8([0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000]),
    ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:484
assert_return(
  () =>
    invoke($0, `i16x8.sub_sat_u`, [
      i16x8([0xc001, 0xc001, 0xc001, 0xc001, 0xc001, 0xc001, 0xc001, 0xc001]),
      i16x8([0xc000, 0xc000, 0xc000, 0xc000, 0xc000, 0xc000, 0xc000, 0xc000]),
    ]),
  [i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:487
assert_return(
  () =>
    invoke($0, `i16x8.sub_sat_u`, [
      i16x8([0xc000, 0xc000, 0xc000, 0xc000, 0xc000, 0xc000, 0xc000, 0xc000]),
      i16x8([0xc000, 0xc000, 0xc000, 0xc000, 0xc000, 0xc000, 0xc000, 0xc000]),
    ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:490
assert_return(
  () =>
    invoke($0, `i16x8.sub_sat_u`, [
      i16x8([0xbfff, 0xbfff, 0xbfff, 0xbfff, 0xbfff, 0xbfff, 0xbfff, 0xbfff]),
      i16x8([0xc000, 0xc000, 0xc000, 0xc000, 0xc000, 0xc000, 0xc000, 0xc000]),
    ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:493
assert_return(
  () =>
    invoke($0, `i16x8.sub_sat_u`, [
      i16x8([0x7ffd, 0x7ffd, 0x7ffd, 0x7ffd, 0x7ffd, 0x7ffd, 0x7ffd, 0x7ffd]),
      i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
    ]),
  [i16x8([0x7ffc, 0x7ffc, 0x7ffc, 0x7ffc, 0x7ffc, 0x7ffc, 0x7ffc, 0x7ffc])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:496
assert_return(
  () =>
    invoke($0, `i16x8.sub_sat_u`, [
      i16x8([0x7ffe, 0x7ffe, 0x7ffe, 0x7ffe, 0x7ffe, 0x7ffe, 0x7ffe, 0x7ffe]),
      i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
    ]),
  [i16x8([0x7ffd, 0x7ffd, 0x7ffd, 0x7ffd, 0x7ffd, 0x7ffd, 0x7ffd, 0x7ffd])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:499
assert_return(
  () =>
    invoke($0, `i16x8.sub_sat_u`, [
      i16x8([0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000]),
      i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
    ]),
  [i16x8([0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:502
assert_return(
  () =>
    invoke($0, `i16x8.sub_sat_u`, [
      i16x8([0x8002, 0x8002, 0x8002, 0x8002, 0x8002, 0x8002, 0x8002, 0x8002]),
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:505
assert_return(
  () =>
    invoke($0, `i16x8.sub_sat_u`, [
      i16x8([0x8001, 0x8001, 0x8001, 0x8001, 0x8001, 0x8001, 0x8001, 0x8001]),
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:508
assert_return(
  () =>
    invoke($0, `i16x8.sub_sat_u`, [
      i16x8([0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000]),
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:511
assert_return(
  () =>
    invoke($0, `i16x8.sub_sat_u`, [
      i16x8([0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff]),
      i16x8([0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff]),
    ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:514
assert_return(
  () =>
    invoke($0, `i16x8.sub_sat_u`, [
      i16x8([0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000]),
      i16x8([0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000]),
    ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:517
assert_return(
  () =>
    invoke($0, `i16x8.sub_sat_u`, [
      i16x8([0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000]),
      i16x8([0x8001, 0x8001, 0x8001, 0x8001, 0x8001, 0x8001, 0x8001, 0x8001]),
    ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:520
assert_return(
  () =>
    invoke($0, `i16x8.sub_sat_u`, [
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
      i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
    ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:523
assert_return(
  () =>
    invoke($0, `i16x8.sub_sat_u`, [
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
      i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
    ]),
  [i16x8([0xfffe, 0xfffe, 0xfffe, 0xfffe, 0xfffe, 0xfffe, 0xfffe, 0xfffe])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:526
assert_return(
  () =>
    invoke($0, `i16x8.sub_sat_u`, [
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:529
assert_return(
  () =>
    invoke($0, `i16x8.sub_sat_u`, [
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
      i16x8([0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff]),
    ]),
  [i16x8([0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:532
assert_return(
  () =>
    invoke($0, `i16x8.sub_sat_u`, [
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
      i16x8([0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000]),
    ]),
  [i16x8([0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:535
assert_return(
  () =>
    invoke($0, `i16x8.sub_sat_u`, [
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:538
assert_return(
  () =>
    invoke($0, `i16x8.sub_sat_u`, [
      i16x8([0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff]),
      i16x8([0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000]),
    ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:541
assert_return(
  () =>
    invoke($0, `i16x8.sub_sat_u`, [
      i16x8([0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000]),
      i16x8([0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000]),
    ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:544
assert_return(
  () =>
    invoke($0, `i16x8.sub_sat_u`, [
      i16x8([0xc001, 0xc001, 0xc001, 0xc001, 0xc001, 0xc001, 0xc001, 0xc001]),
      i16x8([0xc000, 0xc000, 0xc000, 0xc000, 0xc000, 0xc000, 0xc000, 0xc000]),
    ]),
  [i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:547
assert_return(
  () =>
    invoke($0, `i16x8.sub_sat_u`, [
      i16x8([0xc000, 0xc000, 0xc000, 0xc000, 0xc000, 0xc000, 0xc000, 0xc000]),
      i16x8([0xc000, 0xc000, 0xc000, 0xc000, 0xc000, 0xc000, 0xc000, 0xc000]),
    ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:550
assert_return(
  () =>
    invoke($0, `i16x8.sub_sat_u`, [
      i16x8([0xc000, 0xc000, 0xc000, 0xc000, 0xc000, 0xc000, 0xc000, 0xc000]),
      i16x8([0xbfff, 0xbfff, 0xbfff, 0xbfff, 0xbfff, 0xbfff, 0xbfff, 0xbfff]),
    ]),
  [i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:553
assert_return(
  () =>
    invoke($0, `i16x8.sub_sat_u`, [
      i16x8([0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff]),
      i16x8([0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff]),
    ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:556
assert_return(
  () =>
    invoke($0, `i16x8.sub_sat_u`, [
      i16x8([0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff]),
      i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
    ]),
  [i16x8([0x7ffe, 0x7ffe, 0x7ffe, 0x7ffe, 0x7ffe, 0x7ffe, 0x7ffe, 0x7ffe])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:559
assert_return(
  () =>
    invoke($0, `i16x8.sub_sat_u`, [
      i16x8([0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000]),
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:562
assert_return(
  () =>
    invoke($0, `i16x8.sub_sat_u`, [
      i16x8([0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff]),
      i16x8([0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000]),
    ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:565
assert_return(
  () =>
    invoke($0, `i16x8.sub_sat_u`, [
      i16x8([0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000]),
      i16x8([0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000]),
    ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:568
assert_return(
  () =>
    invoke($0, `i16x8.sub_sat_u`, [
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
      i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
    ]),
  [i16x8([0xfffe, 0xfffe, 0xfffe, 0xfffe, 0xfffe, 0xfffe, 0xfffe, 0xfffe])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:571
assert_return(
  () =>
    invoke($0, `i16x8.sub_sat_u`, [
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
    ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:574
assert_return(
  () =>
    invoke($0, `i16x8.sub_sat_u`, [
      i16x8([0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000]),
      bytes("v128", [
        0x0,
        0x0,
        0x0,
        0x80,
        0x0,
        0x0,
        0x0,
        0x80,
        0x0,
        0x0,
        0x0,
        0x80,
        0x0,
        0x0,
        0x0,
        0x80,
      ]),
    ]),
  [i16x8([0x8000, 0x0, 0x8000, 0x0, 0x8000, 0x0, 0x8000, 0x0])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:577
assert_return(
  () =>
    invoke($0, `i16x8.sub_sat_u`, [
      i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
      f32x4([Infinity, Infinity, Infinity, Infinity]),
    ]),
  [i16x8([0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:580
assert_return(
  () =>
    invoke($0, `i16x8.sub_sat_u`, [
      i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
      f32x4([-Infinity, -Infinity, -Infinity, -Infinity]),
    ]),
  [i16x8([0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:583
assert_return(
  () =>
    invoke($0, `i16x8.sub_sat_u`, [
      i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
        0x0,
        0x0,
        0xc0,
        0x7f,
      ]),
    ]),
  [i16x8([0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:586
assert_return(
  () =>
    invoke($0, `i16x8.sub_sat_u`, [
      i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
      bytes("v128", [
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
        0x0,
        0x0,
        0xc0,
        0xff,
      ]),
    ]),
  [i16x8([0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:589
assert_return(
  () =>
    invoke($0, `i16x8.sub_sat_u`, [
      i16x8([0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7]),
      i16x8([0x0, 0xffff, 0xfffe, 0xfffd, 0xfffc, 0xfffb, 0xfffa, 0xfff9]),
    ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:592
assert_return(
  () =>
    invoke($0, `i16x8.sub_sat_u`, [
      i16x8([0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7]),
      i16x8([0x0, 0x2, 0x4, 0x6, 0x8, 0xa, 0xc, 0xe]),
    ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:595
assert_return(
  () =>
    invoke($0, `i16x8.sub_sat_u`, [
      i16x8([0x3039, 0x3039, 0x3039, 0x3039, 0x3039, 0x3039, 0x3039, 0x3039]),
      i16x8([0xddd5, 0xddd5, 0xddd5, 0xddd5, 0xddd5, 0xddd5, 0xddd5, 0xddd5]),
    ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:598
assert_return(
  () =>
    invoke($0, `i16x8.sub_sat_u`, [
      i16x8([0xddd5, 0xddd5, 0xddd5, 0xddd5, 0xddd5, 0xddd5, 0xddd5, 0xddd5]),
      i16x8([0xcfc7, 0xcfc7, 0xcfc7, 0xcfc7, 0xcfc7, 0xcfc7, 0xcfc7, 0xcfc7]),
    ]),
  [i16x8([0xe0e, 0xe0e, 0xe0e, 0xe0e, 0xe0e, 0xe0e, 0xe0e, 0xe0e])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:601
assert_return(
  () =>
    invoke($0, `i16x8.sub_sat_u`, [
      i16x8([0x1234, 0x1234, 0x1234, 0x1234, 0x1234, 0x1234, 0x1234, 0x1234]),
      i16x8([0xa988, 0xa988, 0xa988, 0xa988, 0xa988, 0xa988, 0xa988, 0xa988]),
    ]),
  [i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:604
assert_return(
  () =>
    invoke($0, `i16x8.sub_sat_u`, [
      i16x8([0xcdef, 0xcdef, 0xcdef, 0xcdef, 0xcdef, 0xcdef, 0xcdef, 0xcdef]),
      i16x8([0x90ab, 0x90ab, 0x90ab, 0x90ab, 0x90ab, 0x90ab, 0x90ab, 0x90ab]),
    ]),
  [i16x8([0x3d44, 0x3d44, 0x3d44, 0x3d44, 0x3d44, 0x3d44, 0x3d44, 0x3d44])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:609
assert_malformed(
  () =>
    instantiate(
      `(func (result v128) (i16x8.add_sat (v128.const i16x8 1 1 1 1 1 1 1 1) (v128.const i16x8 2 2 2 2 2 2 2 2))) `,
    ),
  `unknown operator`,
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:612
assert_malformed(
  () =>
    instantiate(
      `(func (result v128) (i16x8.sub_sat (v128.const i16x8 1 1 1 1 1 1 1 1) (v128.const i16x8 2 2 2 2 2 2 2 2))) `,
    ),
  `unknown operator`,
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:615
assert_malformed(
  () =>
    instantiate(
      `(func (result v128) (i16x8.mul_sat (v128.const i16x8 1 1 1 1 1 1 1 1) (v128.const i16x8 2 2 2 2 2 2 2 2))) `,
    ),
  `unknown operator`,
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:618
assert_malformed(
  () =>
    instantiate(
      `(func (result v128) (i16x8.div_sat (v128.const i16x8 1 1 1 1 1 1 1 1) (v128.const i16x8 2 2 2 2 2 2 2 2))) `,
    ),
  `unknown operator`,
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:623
assert_invalid(
  () =>
    instantiate(
      `(module (func (result v128) (i16x8.add_sat_s (i32.const 0) (f32.const 0.0))))`,
    ),
  `type mismatch`,
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:624
assert_invalid(
  () =>
    instantiate(
      `(module (func (result v128) (i16x8.add_sat_u (i32.const 0) (f32.const 0.0))))`,
    ),
  `type mismatch`,
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:625
assert_invalid(
  () =>
    instantiate(
      `(module (func (result v128) (i16x8.sub_sat_s (i32.const 0) (f32.const 0.0))))`,
    ),
  `type mismatch`,
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:626
assert_invalid(
  () =>
    instantiate(
      `(module (func (result v128) (i16x8.sub_sat_u (i32.const 0) (f32.const 0.0))))`,
    ),
  `type mismatch`,
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:630
assert_invalid(() =>
  instantiate(`(module
    (func $$i16x8.add_sat_s-1st-arg-empty (result v128)
      (i16x8.add_sat_s (v128.const i16x8 0 0 0 0 0 0 0 0))
    )
  )`), `type mismatch`);

// ./test/core/simd/simd_i16x8_sat_arith.wast:638
assert_invalid(() =>
  instantiate(`(module
    (func $$i16x8.add_sat_s-arg-empty (result v128)
      (i16x8.add_sat_s)
    )
  )`), `type mismatch`);

// ./test/core/simd/simd_i16x8_sat_arith.wast:646
assert_invalid(() =>
  instantiate(`(module
    (func $$i16x8.add_sat_u-1st-arg-empty (result v128)
      (i16x8.add_sat_u (v128.const i16x8 0 0 0 0 0 0 0 0))
    )
  )`), `type mismatch`);

// ./test/core/simd/simd_i16x8_sat_arith.wast:654
assert_invalid(() =>
  instantiate(`(module
    (func $$i16x8.add_sat_u-arg-empty (result v128)
      (i16x8.add_sat_u)
    )
  )`), `type mismatch`);

// ./test/core/simd/simd_i16x8_sat_arith.wast:662
assert_invalid(() =>
  instantiate(`(module
    (func $$i16x8.sub_sat_s-1st-arg-empty (result v128)
      (i16x8.sub_sat_s (v128.const i16x8 0 0 0 0 0 0 0 0))
    )
  )`), `type mismatch`);

// ./test/core/simd/simd_i16x8_sat_arith.wast:670
assert_invalid(() =>
  instantiate(`(module
    (func $$i16x8.sub_sat_s-arg-empty (result v128)
      (i16x8.sub_sat_s)
    )
  )`), `type mismatch`);

// ./test/core/simd/simd_i16x8_sat_arith.wast:678
assert_invalid(() =>
  instantiate(`(module
    (func $$i16x8.sub_sat_u-1st-arg-empty (result v128)
      (i16x8.sub_sat_u (v128.const i16x8 0 0 0 0 0 0 0 0))
    )
  )`), `type mismatch`);

// ./test/core/simd/simd_i16x8_sat_arith.wast:686
assert_invalid(() =>
  instantiate(`(module
    (func $$i16x8.sub_sat_u-arg-empty (result v128)
      (i16x8.sub_sat_u)
    )
  )`), `type mismatch`);

// ./test/core/simd/simd_i16x8_sat_arith.wast:696
let $1 = instantiate(`(module
  (func (export "sat-add_s-sub_s") (param v128 v128 v128) (result v128)
    (i16x8.add_sat_s (i16x8.sub_sat_s (local.get 0) (local.get 1))(local.get 2)))
  (func (export "sat-add_s-sub_u") (param v128 v128 v128) (result v128)
    (i16x8.add_sat_s (i16x8.sub_sat_u (local.get 0) (local.get 1))(local.get 2)))
  (func (export "sat-add_u-sub_s") (param v128 v128 v128) (result v128)
    (i16x8.add_sat_u (i16x8.sub_sat_s (local.get 0) (local.get 1))(local.get 2)))
  (func (export "sat-add_u-sub_u") (param v128 v128 v128) (result v128)
    (i16x8.add_sat_u (i16x8.sub_sat_u (local.get 0) (local.get 1))(local.get 2)))
  (func (export "sat-add_s-neg") (param v128 v128) (result v128)
    (i16x8.add_sat_s (i16x8.neg (local.get 0)) (local.get 1)))
  (func (export "sat-add_u-neg") (param v128 v128) (result v128)
    (i16x8.add_sat_u (i16x8.neg (local.get 0)) (local.get 1)))
  (func (export "sat-sub_s-neg") (param v128 v128) (result v128)
    (i16x8.sub_sat_s (i16x8.neg (local.get 0)) (local.get 1)))
  (func (export "sat-sub_u-neg") (param v128 v128) (result v128)
    (i16x8.sub_sat_u (i16x8.neg (local.get 0)) (local.get 1)))
)`);

// ./test/core/simd/simd_i16x8_sat_arith.wast:715
assert_return(
  () =>
    invoke($1, `sat-add_s-sub_s`, [
      i16x8([0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000, 0x4000]),
      i16x8([0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff]),
      i16x8([0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000]),
    ]),
  [i16x8([0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:719
assert_return(
  () =>
    invoke($1, `sat-add_s-sub_u`, [
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
      i16x8([0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000]),
      i16x8([0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000]),
    ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:723
assert_return(
  () =>
    invoke($1, `sat-add_u-sub_s`, [
      i16x8([0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff]),
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
      i16x8([0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff]),
    ]),
  [i16x8([0xfffe, 0xfffe, 0xfffe, 0xfffe, 0xfffe, 0xfffe, 0xfffe, 0xfffe])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:727
assert_return(
  () =>
    invoke($1, `sat-add_u-sub_u`, [
      i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff]),
      i16x8([0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0]),
      i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1]),
    ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:731
assert_return(
  () =>
    invoke($1, `sat-add_s-neg`, [
      i16x8([0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000]),
      i16x8([0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff]),
    ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:734
assert_return(
  () =>
    invoke($1, `sat-add_u-neg`, [
      i16x8([0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff]),
      i16x8([0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000]),
    ]),
  [i16x8([0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff, 0xffff])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:737
assert_return(
  () =>
    invoke($1, `sat-sub_s-neg`, [
      i16x8([0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000]),
      i16x8([0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff]),
    ]),
  [i16x8([0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000])],
);

// ./test/core/simd/simd_i16x8_sat_arith.wast:740
assert_return(
  () =>
    invoke($1, `sat-sub_u-neg`, [
      i16x8([0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff, 0x7fff]),
      i16x8([0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000, 0x8000]),
    ]),
  [i16x8([0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1])],
);
