// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "net/quic/crypto/scoped_evp_aead_ctx.h"

namespace net {

ScopedEVPAEADCtx::ScopedEVPAEADCtx() {
  ctx_.aead = NULL;
}

ScopedEVPAEADCtx::~ScopedEVPAEADCtx() {
  if (ctx_.aead != NULL) {
    EVP_AEAD_CTX_cleanup(&ctx_);
  }
}

EVP_AEAD_CTX* ScopedEVPAEADCtx::get() {
  return &ctx_;
}

}  // namespace net
