/* PhotoTable.c generated by valac 0.40.4, the Vala compiler
 * generated from PhotoTable.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */


#include <glib.h>
#include <glib-object.h>
#include <string.h>
#include <stdlib.h>
#include <time.h>
#include <gee.h>
#include "shotwell-graphics-processor.h"
#include <sqlite3.h>
#include <gio/gio.h>
#include <gobject/gvaluecollector.h>


#define TYPE_PHOTO_ID (photo_id_get_type ())
typedef struct _PhotoID PhotoID;

#define TYPE_IMPORT_ID (import_id_get_type ())
typedef struct _ImportID ImportID;

#define TYPE_PHOTO_ROW (photo_row_get_type ())
#define PHOTO_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_ROW, PhotoRow))
#define PHOTO_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_ROW, PhotoRowClass))
#define IS_PHOTO_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_ROW))
#define IS_PHOTO_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_ROW))
#define PHOTO_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_ROW, PhotoRowClass))

typedef struct _PhotoRow PhotoRow;
typedef struct _PhotoRowClass PhotoRowClass;
typedef struct _PhotoRowPrivate PhotoRowPrivate;

#define TYPE_BACKING_PHOTO_ROW (backing_photo_row_get_type ())
#define BACKING_PHOTO_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BACKING_PHOTO_ROW, BackingPhotoRow))
#define BACKING_PHOTO_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BACKING_PHOTO_ROW, BackingPhotoRowClass))
#define IS_BACKING_PHOTO_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BACKING_PHOTO_ROW))
#define IS_BACKING_PHOTO_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BACKING_PHOTO_ROW))
#define BACKING_PHOTO_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BACKING_PHOTO_ROW, BackingPhotoRowClass))

typedef struct _BackingPhotoRow BackingPhotoRow;
typedef struct _BackingPhotoRowClass BackingPhotoRowClass;

#define TYPE_EVENT_ID (event_id_get_type ())
typedef struct _EventID EventID;

#define TYPE_ORIENTATION (orientation_get_type ())

#define TYPE_RATING (rating_get_type ())

#define TYPE_BACKING_PHOTO_ID (backing_photo_id_get_type ())
typedef struct _BackingPhotoID BackingPhotoID;

#define TYPE_RAW_DEVELOPER (raw_developer_get_type ())
#define _backing_photo_row_unref0(var) ((var == NULL) ? NULL : (var = (backing_photo_row_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _ParamSpecPhotoRow ParamSpecPhotoRow;

#define TYPE_DATABASE_TABLE (database_table_get_type ())
#define DATABASE_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATABASE_TABLE, DatabaseTable))
#define DATABASE_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATABASE_TABLE, DatabaseTableClass))
#define IS_DATABASE_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATABASE_TABLE))
#define IS_DATABASE_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATABASE_TABLE))
#define DATABASE_TABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATABASE_TABLE, DatabaseTableClass))

typedef struct _DatabaseTable DatabaseTable;
typedef struct _DatabaseTableClass DatabaseTableClass;
typedef struct _DatabaseTablePrivate DatabaseTablePrivate;

#define TYPE_PHOTO_TABLE (photo_table_get_type ())
#define PHOTO_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_TABLE, PhotoTable))
#define PHOTO_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_TABLE, PhotoTableClass))
#define IS_PHOTO_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_TABLE))
#define IS_PHOTO_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_TABLE))
#define PHOTO_TABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_TABLE, PhotoTableClass))

typedef struct _PhotoTable PhotoTable;
typedef struct _PhotoTableClass PhotoTableClass;
typedef struct _PhotoTablePrivate PhotoTablePrivate;
#define _sqlite3_finalize0(var) ((var == NULL) ? NULL : (var = (sqlite3_finalize (var), NULL)))
#define _database_table_unref0(var) ((var == NULL) ? NULL : (var = (database_table_unref (var), NULL)))
typedef struct _BackingPhotoRowPrivate BackingPhotoRowPrivate;

#define TYPE_PHOTO_FILE_FORMAT (photo_file_format_get_type ())

#define TYPE_DIMENSIONS (dimensions_get_type ())
typedef struct _Dimensions Dimensions;
#define _photo_row_unref0(var) ((var == NULL) ? NULL : (var = (photo_row_unref (var), NULL)))
#define _g_key_file_unref0(var) ((var == NULL) ? NULL : (var = (g_key_file_unref (var), NULL)))
#define _key_value_map_unref0(var) ((var == NULL) ? NULL : (var = (key_value_map_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _ParamSpecBackingPhotoRow ParamSpecBackingPhotoRow;

#define TYPE_BACKING_PHOTO_TABLE (backing_photo_table_get_type ())
#define BACKING_PHOTO_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BACKING_PHOTO_TABLE, BackingPhotoTable))
#define BACKING_PHOTO_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BACKING_PHOTO_TABLE, BackingPhotoTableClass))
#define IS_BACKING_PHOTO_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BACKING_PHOTO_TABLE))
#define IS_BACKING_PHOTO_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BACKING_PHOTO_TABLE))
#define BACKING_PHOTO_TABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BACKING_PHOTO_TABLE, BackingPhotoTableClass))

typedef struct _BackingPhotoTable BackingPhotoTable;
typedef struct _BackingPhotoTableClass BackingPhotoTableClass;
typedef struct _BackingPhotoTablePrivate BackingPhotoTablePrivate;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _PhotoID {
	gint64 id;
};

struct _ImportID {
	gint64 id;
};

struct _EventID {
	gint64 id;
};

typedef enum  {
	ORIENTATION_MIN = 1,
	ORIENTATION_TOP_LEFT = 1,
	ORIENTATION_TOP_RIGHT = 2,
	ORIENTATION_BOTTOM_RIGHT = 3,
	ORIENTATION_BOTTOM_LEFT = 4,
	ORIENTATION_LEFT_TOP = 5,
	ORIENTATION_RIGHT_TOP = 6,
	ORIENTATION_RIGHT_BOTTOM = 7,
	ORIENTATION_LEFT_BOTTOM = 8,
	ORIENTATION_MAX = 8
} Orientation;

typedef enum  {
	RATING_REJECTED = -1,
	RATING_UNRATED = 0,
	RATING_ONE = 1,
	RATING_TWO = 2,
	RATING_THREE = 3,
	RATING_FOUR = 4,
	RATING_FIVE = 5
} Rating;

struct _BackingPhotoID {
	gint64 id;
};

typedef enum  {
	RAW_DEVELOPER_SHOTWELL = 0,
	RAW_DEVELOPER_CAMERA,
	RAW_DEVELOPER_EMBEDDED
} RawDeveloper;

struct _PhotoRow {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PhotoRowPrivate * priv;
	PhotoID photo_id;
	BackingPhotoRow* master;
	time_t exposure_time;
	ImportID import_id;
	EventID event_id;
	Orientation orientation;
	GeeHashMap* transformations;
	gchar* md5;
	gchar* thumbnail_md5;
	gchar* exif_md5;
	time_t time_created;
	guint64 flags;
	Rating rating;
	gchar* title;
	gchar* comment;
	gchar* backlinks;
	time_t time_reimported;
	BackingPhotoID editable_id;
	gboolean metadata_dirty;
	RawDeveloper developer;
	BackingPhotoID* development_ids;
	gint development_ids_length1;
};

struct _PhotoRowClass {
	GTypeClass parent_class;
	void (*finalize) (PhotoRow *self);
};

struct _ParamSpecPhotoRow {
	GParamSpec parent_instance;
};

struct _DatabaseTable {
	GTypeInstance parent_instance;
	volatile int ref_count;
	DatabaseTablePrivate * priv;
	gchar* table_name;
};

struct _DatabaseTableClass {
	GTypeClass parent_class;
	void (*finalize) (DatabaseTable *self);
};

struct _PhotoTable {
	DatabaseTable parent_instance;
	PhotoTablePrivate * priv;
};

struct _PhotoTableClass {
	DatabaseTableClass parent_class;
};

typedef enum  {
	PHOTO_FILE_FORMAT_JFIF,
	PHOTO_FILE_FORMAT_RAW,
	PHOTO_FILE_FORMAT_PNG,
	PHOTO_FILE_FORMAT_TIFF,
	PHOTO_FILE_FORMAT_BMP,
	PHOTO_FILE_FORMAT_UNKNOWN
} PhotoFileFormat;

struct _Dimensions {
	gint width;
	gint height;
};

struct _BackingPhotoRow {
	GTypeInstance parent_instance;
	volatile int ref_count;
	BackingPhotoRowPrivate * priv;
	BackingPhotoID id;
	time_t time_created;
	gchar* filepath;
	gint64 filesize;
	time_t timestamp;
	PhotoFileFormat file_format;
	Dimensions dim;
	Orientation original_orientation;
};

struct _BackingPhotoRowClass {
	GTypeClass parent_class;
	void (*finalize) (BackingPhotoRow *self);
};

typedef enum  {
	DATABASE_ERROR_ERROR,
	DATABASE_ERROR_BACKING,
	DATABASE_ERROR_MEMORY,
	DATABASE_ERROR_ABORT,
	DATABASE_ERROR_LIMITS,
	DATABASE_ERROR_TYPESPEC
} DatabaseError;
#define DATABASE_ERROR database_error_quark ()
struct _ParamSpecBackingPhotoRow {
	GParamSpec parent_instance;
};

struct _BackingPhotoTable {
	DatabaseTable parent_instance;
	BackingPhotoTablePrivate * priv;
};

struct _BackingPhotoTableClass {
	DatabaseTableClass parent_class;
};


static gpointer photo_row_parent_class = NULL;
static gpointer photo_table_parent_class = NULL;
static PhotoTable* photo_table_instance;
static PhotoTable* photo_table_instance = NULL;
extern sqlite3* database_table_db;
static gpointer backing_photo_row_parent_class = NULL;
static gpointer backing_photo_table_parent_class = NULL;
static BackingPhotoTable* backing_photo_table_instance;
static BackingPhotoTable* backing_photo_table_instance = NULL;

GType photo_id_get_type (void) G_GNUC_CONST;
PhotoID* photo_id_dup (const PhotoID* self);
void photo_id_free (PhotoID* self);
#define PHOTO_ID_INVALID ((gint64) -1)
void photo_id_init (PhotoID *self,
                    gint64 id);
gboolean photo_id_is_invalid (PhotoID *self);
gboolean photo_id_is_valid (PhotoID *self);
guint photo_id_hash (PhotoID *self);
guint int64_hash (gint64* n);
gboolean photo_id_equal (void* a,
                         void* b);
gchar* photo_id_upgrade_photo_id_to_source_id (PhotoID* photo_id);
#define PHOTO_TYPENAME "thumb"
GType import_id_get_type (void) G_GNUC_CONST;
ImportID* import_id_dup (const ImportID* self);
void import_id_free (ImportID* self);
#define IMPORT_ID_INVALID ((gint64) 0)
void import_id_init (ImportID *self,
                     gint64 id);
void import_id_generate (ImportID* result);
gboolean import_id_is_invalid (ImportID *self);
gboolean import_id_is_valid (ImportID *self);
gint import_id_compare_func (ImportID* a,
                             ImportID* b);
gint64 import_id_comparator (void* a,
                             void* b);
gpointer photo_row_ref (gpointer instance);
void photo_row_unref (gpointer instance);
GParamSpec* param_spec_photo_row (const gchar* name,
                                  const gchar* nick,
                                  const gchar* blurb,
                                  GType object_type,
                                  GParamFlags flags);
void value_set_photo_row (GValue* value,
                          gpointer v_object);
void value_take_photo_row (GValue* value,
                           gpointer v_object);
gpointer value_get_photo_row (const GValue* value);
GType photo_row_get_type (void) G_GNUC_CONST;
gpointer backing_photo_row_ref (gpointer instance);
void backing_photo_row_unref (gpointer instance);
GParamSpec* param_spec_backing_photo_row (const gchar* name,
                                          const gchar* nick,
                                          const gchar* blurb,
                                          GType object_type,
                                          GParamFlags flags);
void value_set_backing_photo_row (GValue* value,
                                  gpointer v_object);
void value_take_backing_photo_row (GValue* value,
                                   gpointer v_object);
gpointer value_get_backing_photo_row (const GValue* value);
GType backing_photo_row_get_type (void) G_GNUC_CONST;
GType event_id_get_type (void) G_GNUC_CONST;
EventID* event_id_dup (const EventID* self);
void event_id_free (EventID* self);
GType orientation_get_type (void) G_GNUC_CONST;
GType rating_get_type (void) G_GNUC_CONST;
GType backing_photo_id_get_type (void) G_GNUC_CONST;
BackingPhotoID* backing_photo_id_dup (const BackingPhotoID* self);
void backing_photo_id_free (BackingPhotoID* self);
GType raw_developer_get_type (void) G_GNUC_CONST;
PhotoRow* photo_row_new (void);
PhotoRow* photo_row_construct (GType object_type);
BackingPhotoRow* backing_photo_row_new (void);
BackingPhotoRow* backing_photo_row_construct (GType object_type);
#define BACKING_PHOTO_ID_INVALID ((gint64) -1)
void backing_photo_id_init (BackingPhotoID *self,
                            gint64 id);
RawDeveloper* raw_developer_as_array (int* result_length1);
static void photo_row_finalize (PhotoRow * obj);
gpointer database_table_ref (gpointer instance);
void database_table_unref (gpointer instance);
GParamSpec* param_spec_database_table (const gchar* name,
                                       const gchar* nick,
                                       const gchar* blurb,
                                       GType object_type,
                                       GParamFlags flags);
void value_set_database_table (GValue* value,
                               gpointer v_object);
void value_take_database_table (GValue* value,
                                gpointer v_object);
gpointer value_get_database_table (const GValue* value);
GType database_table_get_type (void) G_GNUC_CONST;
GType photo_table_get_type (void) G_GNUC_CONST;
static PhotoTable* photo_table_new (void);
static PhotoTable* photo_table_construct (GType object_type);
DatabaseTable* database_table_construct (GType object_type);
void database_table_fatal (const gchar* op,
                           gint res);
void database_table_warning (const gchar* op,
                             gint res);
void database_table_set_table_name (DatabaseTable* self,
                                    const gchar* table_name);
PhotoTable* photo_table_get_instance (void);
void photo_table_add (PhotoTable* self,
                      PhotoRow* photo_row,
                      PhotoID* result);
gulong now_sec (void);
GType photo_file_format_get_type (void) G_GNUC_CONST;
GType dimensions_get_type (void) G_GNUC_CONST;
Dimensions* dimensions_dup (const Dimensions* self);
void dimensions_free (Dimensions* self);
#define EVENT_ID_INVALID ((gint64) -1)
gint photo_file_format_serialize (PhotoFileFormat self);
gint rating_serialize (Rating self);
gchar* raw_developer_to_string (RawDeveloper self);
void event_id_init (EventID *self,
                    gint64 id);
GQuark database_error_quark (void);
void photo_table_reimport (PhotoTable* self,
                           PhotoRow* row,
                           GError** error);
void database_table_throw_error (const gchar* method,
                                 gint res,
                                 GError** error);
gboolean photo_table_master_exif_updated (PhotoTable* self,
                                          PhotoID* photoID,
                                          gint64 filesize,
                                          glong timestamp,
                                          const gchar* md5,
                                          const gchar* exif_md5,
                                          const gchar* thumbnail_md5,
                                          PhotoRow* row);
static void photo_table_validate_orientation (PhotoTable* self,
                                       PhotoRow* row);
gboolean photo_table_set_orientation (PhotoTable* self,
                                      PhotoID* photo_id,
                                      Orientation orientation);
PhotoRow* photo_table_get_row (PhotoTable* self,
                               PhotoID* photo_id);
void dimensions_init (Dimensions *self,
                      gint width,
                      gint height);
GeeHashMap* photo_table_marshall_all_transformations (const gchar* trans);
Rating rating_unserialize (gint value);
PhotoFileFormat photo_file_format_unserialize (gint value);
RawDeveloper raw_developer_from_string (const gchar* value);
GeeArrayList* photo_table_get_all (PhotoTable* self);
void photo_table_duplicate (PhotoTable* self,
                            PhotoID* photo_id,
                            const gchar* new_filename,
                            BackingPhotoID* editable_id,
                            BackingPhotoID* develop_shotwell,
                            BackingPhotoID* develop_camera_id,
                            BackingPhotoID* develop_embedded_id,
                            PhotoID* result);
gchar* photo_table_unmarshall_all_transformations (GeeHashMap* transformations);
gboolean photo_table_set_title (PhotoTable* self,
                                PhotoID* photo_id,
                                const gchar* new_title);
gboolean database_table_update_text_by_id (DatabaseTable* self,
                                           gint64 id,
                                           const gchar* column,
                                           const gchar* text);
gboolean photo_table_set_comment (PhotoTable* self,
                                  PhotoID* photo_id,
                                  const gchar* new_comment);
void photo_table_set_filepath (PhotoTable* self,
                               PhotoID* photo_id,
                               const gchar* filepath,
                               GError** error);
void database_table_update_text_by_id_2 (DatabaseTable* self,
                                         gint64 id,
                                         const gchar* column,
                                         const gchar* text,
                                         GError** error);
void photo_table_update_timestamp (PhotoTable* self,
                                   PhotoID* photo_id,
                                   time_t timestamp,
                                   GError** error);
void database_table_update_int64_by_id_2 (DatabaseTable* self,
                                          gint64 id,
                                          const gchar* column,
                                          gint64 value,
                                          GError** error);
gboolean photo_table_set_exposure_time (PhotoTable* self,
                                        PhotoID* photo_id,
                                        time_t time);
gboolean database_table_update_int64_by_id (DatabaseTable* self,
                                            gint64 id,
                                            const gchar* column,
                                            gint64 value);
void photo_table_set_import_id (PhotoTable* self,
                                PhotoID* photo_id,
                                ImportID* import_id,
                                GError** error);
gboolean photo_table_remove_by_file (PhotoTable* self,
                                     GFile* file);
void photo_table_remove (PhotoTable* self,
                         PhotoID* photo_id,
                         GError** error);
void database_table_delete_by_id (DatabaseTable* self,
                                  gint64 id,
                                  GError** error);
GeeArrayList* photo_table_get_photos (PhotoTable* self);
gboolean database_table_update_int_by_id (DatabaseTable* self,
                                          gint64 id,
                                          const gchar* column,
                                          gint value);
gboolean photo_table_replace_flags (PhotoTable* self,
                                    PhotoID* photo_id,
                                    guint64 flags);
gboolean photo_table_set_rating (PhotoTable* self,
                                 PhotoID* photo_id,
                                 Rating rating);
gint photo_table_get_event_photo_count (PhotoTable* self,
                                        EventID* event_id);
GeeArrayList* photo_table_get_event_source_ids (PhotoTable* self,
                                                EventID* event_id);
gboolean photo_table_event_has_photos (PhotoTable* self,
                                       EventID* event_id);
gboolean photo_table_drop_event (PhotoTable* self,
                                 EventID* event_id);
gboolean photo_table_set_event (PhotoTable* self,
                                PhotoID* photo_id,
                                EventID* event_id);
static gchar* photo_table_get_raw_transformations (PhotoTable* self,
                                            PhotoID* photo_id);
gboolean database_table_select_by_id (DatabaseTable* self,
                                      gint64 id,
                                      const gchar* columns,
                                      sqlite3_stmt* * stmt);
static gboolean photo_table_set_raw_transformations (PhotoTable* self,
                                              PhotoID* photo_id,
                                              const gchar* trans);
gboolean photo_table_set_transformation_state (PhotoTable* self,
                                               PhotoID* photo_id,
                                               Orientation orientation,
                                               GeeHashMap* transformations);
gboolean photo_table_set_transformation (PhotoTable* self,
                                         PhotoID* photo_id,
                                         KeyValueMap* map);
gboolean photo_table_remove_transformation (PhotoTable* self,
                                            PhotoID* photo_id,
                                            const gchar* object);
gboolean photo_table_remove_all_transformations (PhotoTable* self,
                                                 PhotoID* photo_id);
static sqlite3_stmt* photo_table_get_duplicate_stmt (PhotoTable* self,
                                              GFile* file,
                                              const gchar* thumbnail_md5,
                                              const gchar* md5,
                                              PhotoFileFormat file_format);
gboolean photo_table_has_duplicate (PhotoTable* self,
                                    GFile* file,
                                    const gchar* thumbnail_md5,
                                    const gchar* md5,
                                    PhotoFileFormat file_format);
PhotoID* photo_table_get_duplicate_ids (PhotoTable* self,
                                        GFile* file,
                                        const gchar* thumbnail_md5,
                                        const gchar* md5,
                                        PhotoFileFormat file_format,
                                        int* result_length1);
static void _vala_array_add2 (PhotoID* * array,
                       int* length,
                       int* size,
                       const PhotoID* value);
void photo_table_update_backlinks (PhotoTable* self,
                                   PhotoID* photo_id,
                                   const gchar* backlinks,
                                   GError** error);
void photo_table_attach_editable (PhotoTable* self,
                                  PhotoRow* row,
                                  BackingPhotoID* editable_id,
                                  GError** error);
void photo_table_detach_editable (PhotoTable* self,
                                  PhotoRow* row,
                                  GError** error);
void photo_table_set_metadata_dirty (PhotoTable* self,
                                     PhotoID* photo_id,
                                     gboolean dirty,
                                     GError** error);
void database_table_update_int_by_id_2 (DatabaseTable* self,
                                        gint64 id,
                                        const gchar* column,
                                        gint value,
                                        GError** error);
void photo_table_update_raw_development (PhotoTable* self,
                                         PhotoRow* row,
                                         RawDeveloper rd,
                                         BackingPhotoID* backing_photo_id,
                                         GError** error);
void photo_table_remove_development (PhotoTable* self,
                                     PhotoRow* row,
                                     RawDeveloper rd,
                                     GError** error);
static void photo_table_finalize (DatabaseTable * obj);
gboolean backing_photo_id_is_invalid (BackingPhotoID *self);
gboolean backing_photo_id_is_valid (BackingPhotoID *self);
gboolean backing_photo_row_matches_file_info (BackingPhotoRow* self,
                                              GFileInfo* info);
gboolean backing_photo_row_is_touched (BackingPhotoRow* self,
                                       GFileInfo* info);
void backing_photo_row_copy_from (BackingPhotoRow* self,
                                  BackingPhotoRow* from);
static void backing_photo_row_finalize (BackingPhotoRow * obj);
GType backing_photo_table_get_type (void) G_GNUC_CONST;
static BackingPhotoTable* backing_photo_table_new (void);
static BackingPhotoTable* backing_photo_table_construct (GType object_type);
BackingPhotoTable* backing_photo_table_get_instance (void);
void backing_photo_table_add (BackingPhotoTable* self,
                              BackingPhotoRow* state,
                              GError** error);
BackingPhotoRow* backing_photo_table_fetch (BackingPhotoTable* self,
                                            BackingPhotoID* id,
                                            GError** error);
void backing_photo_table_update (BackingPhotoTable* self,
                                 BackingPhotoRow* row,
                                 GError** error);
void backing_photo_table_update_attributes (BackingPhotoTable* self,
                                            BackingPhotoID* id,
                                            time_t timestamp,
                                            gint64 filesize,
                                            GError** error);
void backing_photo_table_remove (BackingPhotoTable* self,
                                 BackingPhotoID* backing_id,
                                 GError** error);
void backing_photo_table_set_filepath (BackingPhotoTable* self,
                                       BackingPhotoID* id,
                                       const gchar* filepath,
                                       GError** error);
void backing_photo_table_update_timestamp (BackingPhotoTable* self,
                                           BackingPhotoID* id,
                                           time_t timestamp,
                                           GError** error);
static void backing_photo_table_finalize (DatabaseTable * obj);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);


void
photo_id_init (PhotoID *self,
               gint64 id)
{
#line 12 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	memset (self, 0, sizeof (PhotoID));
#line 13 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	(*self).id = id;
#line 629 "PhotoTable.c"
}


gboolean
photo_id_is_invalid (PhotoID *self)
{
	gboolean result = FALSE;
	gint64 _tmp0_;
#line 17 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp0_ = (*self).id;
#line 17 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	result = _tmp0_ == PHOTO_ID_INVALID;
#line 17 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	return result;
#line 644 "PhotoTable.c"
}


gboolean
photo_id_is_valid (PhotoID *self)
{
	gboolean result = FALSE;
	gint64 _tmp0_;
#line 21 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp0_ = (*self).id;
#line 21 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	result = _tmp0_ != PHOTO_ID_INVALID;
#line 21 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	return result;
#line 659 "PhotoTable.c"
}


guint
photo_id_hash (PhotoID *self)
{
	guint result = 0U;
	gint64 _tmp0_;
#line 25 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp0_ = (*self).id;
#line 25 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	result = int64_hash (&_tmp0_);
#line 25 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	return result;
#line 674 "PhotoTable.c"
}


gboolean
photo_id_equal (void* a,
                void* b)
{
	gboolean result = FALSE;
	gint64 _tmp0_;
	gint64 _tmp1_;
#line 29 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp0_ = (*((PhotoID*) a)).id;
#line 29 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp1_ = (*((PhotoID*) b)).id;
#line 29 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	result = _tmp0_ == _tmp1_;
#line 29 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	return result;
#line 693 "PhotoTable.c"
}


gchar*
photo_id_upgrade_photo_id_to_source_id (PhotoID* photo_id)
{
	gchar* result = NULL;
	PhotoID _tmp0_;
	gint64 _tmp1_;
	gchar* _tmp2_;
#line 32 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_val_if_fail (photo_id != NULL, NULL);
#line 33 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp0_ = *photo_id;
#line 33 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp1_ = _tmp0_.id;
#line 33 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp2_ = g_strdup_printf ("%s%016" G_GINT64_MODIFIER "x", PHOTO_TYPENAME, _tmp1_);
#line 33 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	result = _tmp2_;
#line 33 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	return result;
#line 716 "PhotoTable.c"
}


PhotoID*
photo_id_dup (const PhotoID* self)
{
	PhotoID* dup;
#line 7 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	dup = g_new0 (PhotoID, 1);
#line 7 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	memcpy (dup, self, sizeof (PhotoID));
#line 7 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	return dup;
#line 730 "PhotoTable.c"
}


void
photo_id_free (PhotoID* self)
{
#line 7 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_free (self);
#line 739 "PhotoTable.c"
}


GType
photo_id_get_type (void)
{
	static volatile gsize photo_id_type_id__volatile = 0;
	if (g_once_init_enter (&photo_id_type_id__volatile)) {
		GType photo_id_type_id;
		photo_id_type_id = g_boxed_type_register_static ("PhotoID", (GBoxedCopyFunc) photo_id_dup, (GBoxedFreeFunc) photo_id_free);
		g_once_init_leave (&photo_id_type_id__volatile, photo_id_type_id);
	}
	return photo_id_type_id__volatile;
}


void
import_id_init (ImportID *self,
                gint64 id)
{
#line 42 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	memset (self, 0, sizeof (ImportID));
#line 43 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	(*self).id = id;
#line 764 "PhotoTable.c"
}


void
import_id_generate (ImportID* result)
{
	GTimeVal timestamp = {0};
	gint64 id = 0LL;
	GTimeVal _tmp0_;
	glong _tmp1_;
	ImportID _tmp2_ = {0};
#line 47 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_get_current_time (&timestamp);
#line 48 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_get_current_time (&timestamp);
#line 49 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp0_ = timestamp;
#line 49 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp1_ = _tmp0_.tv_sec;
#line 49 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	id = (gint64) _tmp1_;
#line 51 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	import_id_init (&_tmp2_, id);
#line 51 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	*result = _tmp2_;
#line 51 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	return;
#line 792 "PhotoTable.c"
}


gboolean
import_id_is_invalid (ImportID *self)
{
	gboolean result = FALSE;
	gint64 _tmp0_;
#line 55 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp0_ = (*self).id;
#line 55 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	result = _tmp0_ == IMPORT_ID_INVALID;
#line 55 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	return result;
#line 807 "PhotoTable.c"
}


gboolean
import_id_is_valid (ImportID *self)
{
	gboolean result = FALSE;
	gint64 _tmp0_;
#line 59 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp0_ = (*self).id;
#line 59 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	result = _tmp0_ != IMPORT_ID_INVALID;
#line 59 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	return result;
#line 822 "PhotoTable.c"
}


gint
import_id_compare_func (ImportID* a,
                        ImportID* b)
{
	gint result = 0;
	gboolean _tmp0_ = FALSE;
	gint64 _tmp1_;
	gint64 _tmp2_;
#line 63 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (a != NULL) {
#line 63 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp0_ = b != NULL;
#line 838 "PhotoTable.c"
	} else {
#line 63 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp0_ = FALSE;
#line 842 "PhotoTable.c"
	}
#line 63 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp0_, "a != null && b != null");
#line 64 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp1_ = (*a).id;
#line 64 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp2_ = (*b).id;
#line 64 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	result = (gint) (_tmp1_ - _tmp2_);
#line 64 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	return result;
#line 854 "PhotoTable.c"
}


gint64
import_id_comparator (void* a,
                      void* b)
{
	gint64 result = 0LL;
	gint64 _tmp0_;
	gint64 _tmp1_;
#line 68 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp0_ = (*((ImportID*) a)).id;
#line 68 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp1_ = (*((ImportID*) b)).id;
#line 68 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	result = _tmp0_ - _tmp1_;
#line 68 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	return result;
#line 873 "PhotoTable.c"
}


ImportID*
import_id_dup (const ImportID* self)
{
	ImportID* dup;
#line 37 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	dup = g_new0 (ImportID, 1);
#line 37 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	memcpy (dup, self, sizeof (ImportID));
#line 37 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	return dup;
#line 887 "PhotoTable.c"
}


void
import_id_free (ImportID* self)
{
#line 37 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_free (self);
#line 896 "PhotoTable.c"
}


GType
import_id_get_type (void)
{
	static volatile gsize import_id_type_id__volatile = 0;
	if (g_once_init_enter (&import_id_type_id__volatile)) {
		GType import_id_type_id;
		import_id_type_id = g_boxed_type_register_static ("ImportID", (GBoxedCopyFunc) import_id_dup, (GBoxedFreeFunc) import_id_free);
		g_once_init_leave (&import_id_type_id__volatile, import_id_type_id);
	}
	return import_id_type_id__volatile;
}


PhotoRow*
photo_row_construct (GType object_type)
{
	PhotoRow* self = NULL;
	BackingPhotoRow* _tmp0_;
	gint _tmp1_;
	RawDeveloper* _tmp2_;
	RawDeveloper* _tmp3_;
	gint _tmp3__length1;
	BackingPhotoID* _tmp4_;
	gint _tmp5_;
	RawDeveloper* _tmp6_;
#line 100 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	self = (PhotoRow*) g_type_create_instance (object_type);
#line 101 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp0_ = backing_photo_row_new ();
#line 101 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_backing_photo_row_unref0 (self->master);
#line 101 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	self->master = _tmp0_;
#line 102 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	backing_photo_id_init (&self->editable_id, BACKING_PHOTO_ID_INVALID);
#line 103 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp2_ = raw_developer_as_array (&_tmp1_);
#line 103 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp3_ = _tmp2_;
#line 103 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp3__length1 = _tmp1_;
#line 103 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp4_ = g_new0 (BackingPhotoID, _tmp1_);
#line 103 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	self->development_ids = (g_free (self->development_ids), NULL);
#line 103 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	self->development_ids = _tmp4_;
#line 103 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	self->development_ids_length1 = _tmp1_;
#line 103 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp3_ = (g_free (_tmp3_), NULL);
#line 104 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp6_ = raw_developer_as_array (&_tmp5_);
#line 953 "PhotoTable.c"
	{
		RawDeveloper* d_collection = NULL;
		gint d_collection_length1 = 0;
		gint _d_collection_size_ = 0;
		gint d_it = 0;
#line 104 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		d_collection = _tmp6_;
#line 104 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		d_collection_length1 = _tmp5_;
#line 104 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		for (d_it = 0; d_it < _tmp5_; d_it = d_it + 1) {
#line 965 "PhotoTable.c"
			RawDeveloper d = 0;
#line 104 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			d = d_collection[d_it];
#line 969 "PhotoTable.c"
			{
				BackingPhotoID* _tmp7_;
				gint _tmp7__length1;
				RawDeveloper _tmp8_;
				BackingPhotoID _tmp9_ = {0};
				BackingPhotoID _tmp10_;
#line 105 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				_tmp7_ = self->development_ids;
#line 105 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				_tmp7__length1 = self->development_ids_length1;
#line 105 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				_tmp8_ = d;
#line 105 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				backing_photo_id_init (&_tmp9_, BACKING_PHOTO_ID_INVALID);
#line 105 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				_tmp7_[_tmp8_] = _tmp9_;
#line 105 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				_tmp10_ = _tmp7_[_tmp8_];
#line 988 "PhotoTable.c"
			}
		}
#line 104 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		d_collection = (g_free (d_collection), NULL);
#line 993 "PhotoTable.c"
	}
#line 100 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	return self;
#line 997 "PhotoTable.c"
}


PhotoRow*
photo_row_new (void)
{
#line 100 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	return photo_row_construct (TYPE_PHOTO_ROW);
#line 1006 "PhotoTable.c"
}


static void
value_photo_row_init (GValue* value)
{
#line 72 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	value->data[0].v_pointer = NULL;
#line 1015 "PhotoTable.c"
}


static void
value_photo_row_free_value (GValue* value)
{
#line 72 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (value->data[0].v_pointer) {
#line 72 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		photo_row_unref (value->data[0].v_pointer);
#line 1026 "PhotoTable.c"
	}
}


static void
value_photo_row_copy_value (const GValue* src_value,
                            GValue* dest_value)
{
#line 72 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (src_value->data[0].v_pointer) {
#line 72 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		dest_value->data[0].v_pointer = photo_row_ref (src_value->data[0].v_pointer);
#line 1039 "PhotoTable.c"
	} else {
#line 72 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		dest_value->data[0].v_pointer = NULL;
#line 1043 "PhotoTable.c"
	}
}


static gpointer
value_photo_row_peek_pointer (const GValue* value)
{
#line 72 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	return value->data[0].v_pointer;
#line 1053 "PhotoTable.c"
}


static gchar*
value_photo_row_collect_value (GValue* value,
                               guint n_collect_values,
                               GTypeCValue* collect_values,
                               guint collect_flags)
{
#line 72 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (collect_values[0].v_pointer) {
#line 1065 "PhotoTable.c"
		PhotoRow * object;
		object = collect_values[0].v_pointer;
#line 72 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		if (object->parent_instance.g_class == NULL) {
#line 72 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1072 "PhotoTable.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 72 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1076 "PhotoTable.c"
		}
#line 72 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		value->data[0].v_pointer = photo_row_ref (object);
#line 1080 "PhotoTable.c"
	} else {
#line 72 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		value->data[0].v_pointer = NULL;
#line 1084 "PhotoTable.c"
	}
#line 72 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	return NULL;
#line 1088 "PhotoTable.c"
}


static gchar*
value_photo_row_lcopy_value (const GValue* value,
                             guint n_collect_values,
                             GTypeCValue* collect_values,
                             guint collect_flags)
{
	PhotoRow ** object_p;
	object_p = collect_values[0].v_pointer;
#line 72 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (!object_p) {
#line 72 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 1104 "PhotoTable.c"
	}
#line 72 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (!value->data[0].v_pointer) {
#line 72 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		*object_p = NULL;
#line 1110 "PhotoTable.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 72 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		*object_p = value->data[0].v_pointer;
#line 1114 "PhotoTable.c"
	} else {
#line 72 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		*object_p = photo_row_ref (value->data[0].v_pointer);
#line 1118 "PhotoTable.c"
	}
#line 72 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	return NULL;
#line 1122 "PhotoTable.c"
}


GParamSpec*
param_spec_photo_row (const gchar* name,
                      const gchar* nick,
                      const gchar* blurb,
                      GType object_type,
                      GParamFlags flags)
{
	ParamSpecPhotoRow* spec;
#line 72 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_PHOTO_ROW), NULL);
#line 72 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 72 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 72 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	return G_PARAM_SPEC (spec);
#line 1142 "PhotoTable.c"
}


gpointer
value_get_photo_row (const GValue* value)
{
#line 72 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PHOTO_ROW), NULL);
#line 72 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	return value->data[0].v_pointer;
#line 1153 "PhotoTable.c"
}


void
value_set_photo_row (GValue* value,
                     gpointer v_object)
{
	PhotoRow * old;
#line 72 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PHOTO_ROW));
#line 72 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	old = value->data[0].v_pointer;
#line 72 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (v_object) {
#line 72 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PHOTO_ROW));
#line 72 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 72 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		value->data[0].v_pointer = v_object;
#line 72 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		photo_row_ref (value->data[0].v_pointer);
#line 1176 "PhotoTable.c"
	} else {
#line 72 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		value->data[0].v_pointer = NULL;
#line 1180 "PhotoTable.c"
	}
#line 72 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (old) {
#line 72 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		photo_row_unref (old);
#line 1186 "PhotoTable.c"
	}
}


void
value_take_photo_row (GValue* value,
                      gpointer v_object)
{
	PhotoRow * old;
#line 72 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PHOTO_ROW));
#line 72 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	old = value->data[0].v_pointer;
#line 72 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (v_object) {
#line 72 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PHOTO_ROW));
#line 72 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 72 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		value->data[0].v_pointer = v_object;
#line 1208 "PhotoTable.c"
	} else {
#line 72 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		value->data[0].v_pointer = NULL;
#line 1212 "PhotoTable.c"
	}
#line 72 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (old) {
#line 72 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		photo_row_unref (old);
#line 1218 "PhotoTable.c"
	}
}


static void
photo_row_class_init (PhotoRowClass * klass)
{
#line 72 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	photo_row_parent_class = g_type_class_peek_parent (klass);
#line 72 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	((PhotoRowClass *) klass)->finalize = photo_row_finalize;
#line 1230 "PhotoTable.c"
}


static void
photo_row_instance_init (PhotoRow * self)
{
#line 72 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	self->ref_count = 1;
#line 1239 "PhotoTable.c"
}


static void
photo_row_finalize (PhotoRow * obj)
{
	PhotoRow * self;
#line 72 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PHOTO_ROW, PhotoRow);
#line 72 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_signal_handlers_destroy (self);
#line 74 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_backing_photo_row_unref0 (self->master);
#line 79 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_g_object_unref0 (self->transformations);
#line 80 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_g_free0 (self->md5);
#line 81 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_g_free0 (self->thumbnail_md5);
#line 82 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_g_free0 (self->exif_md5);
#line 86 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_g_free0 (self->title);
#line 87 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_g_free0 (self->comment);
#line 88 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_g_free0 (self->backlinks);
#line 97 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	self->development_ids = (g_free (self->development_ids), NULL);
#line 1269 "PhotoTable.c"
}


GType
photo_row_get_type (void)
{
	static volatile gsize photo_row_type_id__volatile = 0;
	if (g_once_init_enter (&photo_row_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_photo_row_init, value_photo_row_free_value, value_photo_row_copy_value, value_photo_row_peek_pointer, "p", value_photo_row_collect_value, "p", value_photo_row_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (PhotoRowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) photo_row_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PhotoRow), 0, (GInstanceInitFunc) photo_row_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType photo_row_type_id;
		photo_row_type_id = g_type_register_fundamental (g_type_fundamental_next (), "PhotoRow", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&photo_row_type_id__volatile, photo_row_type_id);
	}
	return photo_row_type_id__volatile;
}


gpointer
photo_row_ref (gpointer instance)
{
	PhotoRow * self;
	self = instance;
#line 72 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_atomic_int_inc (&self->ref_count);
#line 72 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	return instance;
#line 1298 "PhotoTable.c"
}


void
photo_row_unref (gpointer instance)
{
	PhotoRow * self;
	self = instance;
#line 72 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 72 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		PHOTO_ROW_GET_CLASS (self)->finalize (self);
#line 72 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 1313 "PhotoTable.c"
	}
}


static PhotoTable*
photo_table_construct (GType object_type)
{
	PhotoTable* self = NULL;
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_;
	sqlite3_stmt* _tmp1_ = NULL;
	gint _tmp2_;
	gint _tmp3_;
	sqlite3_stmt* _tmp4_;
	gint _tmp5_;
	sqlite3_stmt* stmt2 = NULL;
	gint res2 = 0;
	sqlite3* _tmp7_;
	sqlite3_stmt* _tmp8_ = NULL;
	gint _tmp9_;
	gint _tmp10_;
	sqlite3_stmt* _tmp11_;
	gint _tmp12_;
	sqlite3* _tmp14_;
	sqlite3_stmt* _tmp15_ = NULL;
	gint _tmp16_;
	gint _tmp17_;
	sqlite3_stmt* _tmp18_;
	gint _tmp19_;
	sqlite3* _tmp21_;
	sqlite3_stmt* _tmp22_ = NULL;
	gint _tmp23_;
	gint _tmp24_;
	sqlite3_stmt* _tmp25_;
	gint _tmp26_;
	sqlite3* _tmp28_;
	sqlite3_stmt* _tmp29_ = NULL;
	gint _tmp30_;
	gint _tmp31_;
	sqlite3_stmt* _tmp32_;
	gint _tmp33_;
	sqlite3* _tmp35_;
	sqlite3_stmt* _tmp36_ = NULL;
	gint _tmp37_;
	gint _tmp38_;
	sqlite3_stmt* _tmp39_;
	gint _tmp40_;
#line 112 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	self = (PhotoTable*) database_table_construct (object_type);
#line 114 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp0_ = database_table_db;
#line 114 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp2_ = sqlite3_prepare_v2 (_tmp0_, "CREATE TABLE IF NOT EXISTS PhotoTable (" "id INTEGER PRIMARY KEY, " "filename TEXT UNIQUE NOT NULL, " "width INTEGER, " "height INTEGER, " "filesize INTEGER, " "timestamp INTEGER, " "exposure_time INTEGER, " "orientation INTEGER, " "original_orientation INTEGER, " "import_id INTEGER, " "event_id INTEGER, " "transformations TEXT, " "md5 TEXT, " "thumbnail_md5 TEXT, " "exif_md5 TEXT, " "time_created INTEGER, " "flags INTEGER DEFAULT 0, " "rating INTEGER DEFAULT 0, " "file_format INTEGER DEFAULT 0, " "title TEXT, " "backlinks TEXT, " "time_reimported INTEGER, " "editable_id INTEGER DEFAULT -1, " "metadata_dirty INTEGER DEFAULT 0, " "developer TEXT, " "develop_shotwell_id INTEGER DEFAULT -1, " "develop_camera_id INTEGER DEFAULT -1, " "develop_embedded_id INTEGER DEFAULT -1, " "comment TEXT" ")", -1, &_tmp1_, NULL);
#line 114 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_sqlite3_finalize0 (stmt);
#line 114 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	stmt = _tmp1_;
#line 114 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp2_;
#line 145 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp3_ = res;
#line 145 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp3_ == SQLITE_OK, "res == Sqlite.OK");
#line 147 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp4_ = stmt;
#line 147 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = sqlite3_step (_tmp4_);
#line 148 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp5_ = res;
#line 148 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (_tmp5_ != SQLITE_DONE) {
#line 1386 "PhotoTable.c"
		gint _tmp6_;
#line 149 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp6_ = res;
#line 149 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		database_table_fatal ("create photo table", _tmp6_);
#line 1392 "PhotoTable.c"
	}
#line 153 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp7_ = database_table_db;
#line 153 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp9_ = sqlite3_prepare_v2 (_tmp7_, "CREATE INDEX IF NOT EXISTS PhotoEventIDIndex ON PhotoTable (event_id)", -1, &_tmp8_, NULL);
#line 153 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_sqlite3_finalize0 (stmt2);
#line 153 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	stmt2 = _tmp8_;
#line 153 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res2 = _tmp9_;
#line 155 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp10_ = res2;
#line 155 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp10_ == SQLITE_OK, "res2 == Sqlite.OK");
#line 157 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp11_ = stmt2;
#line 157 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res2 = sqlite3_step (_tmp11_);
#line 158 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp12_ = res2;
#line 158 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (_tmp12_ != SQLITE_DONE) {
#line 1416 "PhotoTable.c"
		gint _tmp13_;
#line 159 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp13_ = res2;
#line 159 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		database_table_fatal ("create photo table", _tmp13_);
#line 1422 "PhotoTable.c"
	}
#line 165 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp14_ = database_table_db;
#line 165 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp16_ = sqlite3_prepare_v2 (_tmp14_, "DROP INDEX IF EXISTS PhotoTableMD5Format", -1, &_tmp15_, NULL);
#line 165 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_sqlite3_finalize0 (stmt);
#line 165 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	stmt = _tmp15_;
#line 165 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp16_;
#line 166 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp17_ = res;
#line 166 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp17_ == SQLITE_OK, "res == Sqlite.OK");
#line 167 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp18_ = stmt;
#line 167 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = sqlite3_step (_tmp18_);
#line 168 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp19_ = res;
#line 168 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (_tmp19_ != SQLITE_DONE) {
#line 1446 "PhotoTable.c"
		gint _tmp20_;
#line 169 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp20_ = res;
#line 169 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		database_table_warning ("Failed to drop old PhotoTable index", _tmp20_);
#line 1452 "PhotoTable.c"
	}
#line 172 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp21_ = database_table_db;
#line 172 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp23_ = sqlite3_prepare_v2 (_tmp21_, "CREATE INDEX IF NOT EXISTS PhotoTableMD5FormatV2 on PhotoTable(md5, fi" \
"le_format)", -1, &_tmp22_, NULL);
#line 172 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_sqlite3_finalize0 (stmt);
#line 172 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	stmt = _tmp22_;
#line 172 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp23_;
#line 173 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp24_ = res;
#line 173 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp24_ == SQLITE_OK, "res == Sqlite.OK");
#line 174 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp25_ = stmt;
#line 174 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = sqlite3_step (_tmp25_);
#line 175 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp26_ = res;
#line 175 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (_tmp26_ != SQLITE_DONE) {
#line 1476 "PhotoTable.c"
		gint _tmp27_;
#line 176 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp27_ = res;
#line 176 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		database_table_warning ("Failed to create index on md5 and file_format", _tmp27_);
#line 1482 "PhotoTable.c"
	}
#line 180 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp28_ = database_table_db;
#line 180 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp30_ = sqlite3_prepare_v2 (_tmp28_, "CREATE INDEX IF NOT EXISTS PhotoTableThumbnailMD5Format on PhotoTable(" \
"thumbnail_md5, file_format)", -1, &_tmp29_, NULL);
#line 180 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_sqlite3_finalize0 (stmt);
#line 180 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	stmt = _tmp29_;
#line 180 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp30_;
#line 181 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp31_ = res;
#line 181 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp31_ == SQLITE_OK, "res == Sqlite.OK");
#line 182 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp32_ = stmt;
#line 182 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = sqlite3_step (_tmp32_);
#line 183 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp33_ = res;
#line 183 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (_tmp33_ != SQLITE_DONE) {
#line 1506 "PhotoTable.c"
		gint _tmp34_;
#line 184 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp34_ = res;
#line 184 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		database_table_warning ("Failed to create index on md5 and file_format", _tmp34_);
#line 1512 "PhotoTable.c"
	}
#line 188 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp35_ = database_table_db;
#line 188 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp37_ = sqlite3_prepare_v2 (_tmp35_, "CREATE INDEX IF NOT EXISTS PhotoTableThumbnailMD5MD5 on PhotoTable(thu" \
"mbnail_md5, md5)", -1, &_tmp36_, NULL);
#line 188 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_sqlite3_finalize0 (stmt);
#line 188 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	stmt = _tmp36_;
#line 188 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp37_;
#line 189 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp38_ = res;
#line 189 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp38_ == SQLITE_OK, "res == Sqlite.OK");
#line 190 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp39_ = stmt;
#line 190 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = sqlite3_step (_tmp39_);
#line 191 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp40_ = res;
#line 191 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (_tmp40_ != SQLITE_DONE) {
#line 1536 "PhotoTable.c"
		gint _tmp41_;
#line 192 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp41_ = res;
#line 192 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		database_table_warning ("Failed to create index on thumbnail_md5 and md5", _tmp41_);
#line 1542 "PhotoTable.c"
	}
#line 195 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	database_table_set_table_name (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_TABLE, DatabaseTable), "PhotoTable");
#line 112 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_sqlite3_finalize0 (stmt2);
#line 112 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_sqlite3_finalize0 (stmt);
#line 112 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	return self;
#line 1552 "PhotoTable.c"
}


static PhotoTable*
photo_table_new (void)
{
#line 112 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	return photo_table_construct (TYPE_PHOTO_TABLE);
#line 1561 "PhotoTable.c"
}


static gpointer
_database_table_ref0 (gpointer self)
{
#line 202 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	return self ? database_table_ref (self) : NULL;
#line 1570 "PhotoTable.c"
}


PhotoTable*
photo_table_get_instance (void)
{
	PhotoTable* result = NULL;
	PhotoTable* _tmp0_;
	PhotoTable* _tmp2_;
	PhotoTable* _tmp3_;
#line 199 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp0_ = photo_table_instance;
#line 199 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (_tmp0_ == NULL) {
#line 1585 "PhotoTable.c"
		PhotoTable* _tmp1_;
#line 200 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp1_ = photo_table_new ();
#line 200 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_database_table_unref0 (photo_table_instance);
#line 200 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		photo_table_instance = _tmp1_;
#line 1593 "PhotoTable.c"
	}
#line 202 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp2_ = photo_table_instance;
#line 202 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp3_ = _database_table_ref0 (_tmp2_);
#line 202 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	result = _tmp3_;
#line 202 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	return result;
#line 1603 "PhotoTable.c"
}


void
photo_table_add (PhotoTable* self,
                 PhotoRow* photo_row,
                 PhotoID* result)
{
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_;
	sqlite3_stmt* _tmp1_ = NULL;
	gint _tmp2_;
	gint _tmp3_;
	gulong time_created = 0UL;
	sqlite3_stmt* _tmp4_;
	BackingPhotoRow* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	GDestroyNotify _tmp8_;
	gint _tmp9_;
	sqlite3_stmt* _tmp10_;
	BackingPhotoRow* _tmp11_;
	Dimensions _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	sqlite3_stmt* _tmp15_;
	BackingPhotoRow* _tmp16_;
	Dimensions _tmp17_;
	gint _tmp18_;
	gint _tmp19_;
	sqlite3_stmt* _tmp20_;
	BackingPhotoRow* _tmp21_;
	gint64 _tmp22_;
	gint _tmp23_;
	sqlite3_stmt* _tmp24_;
	BackingPhotoRow* _tmp25_;
	time_t _tmp26_;
	gint _tmp27_;
	sqlite3_stmt* _tmp28_;
	time_t _tmp29_;
	gint _tmp30_;
	sqlite3_stmt* _tmp31_;
	BackingPhotoRow* _tmp32_;
	Orientation _tmp33_;
	gint _tmp34_;
	sqlite3_stmt* _tmp35_;
	BackingPhotoRow* _tmp36_;
	Orientation _tmp37_;
	gint _tmp38_;
	sqlite3_stmt* _tmp39_;
	ImportID _tmp40_;
	gint64 _tmp41_;
	gint _tmp42_;
	sqlite3_stmt* _tmp43_;
	gint _tmp44_;
	sqlite3_stmt* _tmp45_;
	const gchar* _tmp46_;
	gchar* _tmp47_;
	GDestroyNotify _tmp48_;
	gint _tmp49_;
	sqlite3_stmt* _tmp50_;
	const gchar* _tmp51_;
	gchar* _tmp52_;
	GDestroyNotify _tmp53_;
	gint _tmp54_;
	sqlite3_stmt* _tmp55_;
	const gchar* _tmp56_;
	gchar* _tmp57_;
	GDestroyNotify _tmp58_;
	gint _tmp59_;
	sqlite3_stmt* _tmp60_;
	gulong _tmp61_;
	gint _tmp62_;
	sqlite3_stmt* _tmp63_;
	BackingPhotoRow* _tmp64_;
	PhotoFileFormat _tmp65_;
	gint _tmp66_;
	sqlite3_stmt* _tmp67_;
	const gchar* _tmp68_;
	gchar* _tmp69_;
	GDestroyNotify _tmp70_;
	gint _tmp71_;
	sqlite3_stmt* _tmp72_;
	Rating _tmp73_;
	gint _tmp74_;
	sqlite3_stmt* _tmp75_;
	gint _tmp76_;
	sqlite3_stmt* _tmp77_;
	RawDeveloper _tmp78_;
	gchar* _tmp79_;
	GDestroyNotify _tmp80_;
	gint _tmp81_;
	sqlite3_stmt* _tmp82_;
	const gchar* _tmp83_;
	gchar* _tmp84_;
	GDestroyNotify _tmp85_;
	gint _tmp86_;
	sqlite3_stmt* _tmp87_;
	gint _tmp88_;
	sqlite3* _tmp92_;
	BackingPhotoRow* _tmp93_;
	Orientation _tmp94_;
	gulong _tmp95_;
	PhotoID _tmp96_;
#line 207 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_if_fail (IS_PHOTO_TABLE (self));
#line 207 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_if_fail (IS_PHOTO_ROW (photo_row));
#line 209 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp0_ = database_table_db;
#line 209 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp2_ = sqlite3_prepare_v2 (_tmp0_, "INSERT INTO PhotoTable (filename, width, height, filesize, timestamp, " \
"exposure_time, " "orientation, original_orientation, import_id, event_id, md5, thumbnail" \
"_md5, " "exif_md5, time_created, file_format, title, rating, editable_id, devel" \
"oper, comment) " "VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)", -1, &_tmp1_, NULL);
#line 209 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_sqlite3_finalize0 (stmt);
#line 209 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	stmt = _tmp1_;
#line 209 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp2_;
#line 215 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp3_ = res;
#line 215 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp3_ == SQLITE_OK, "res == Sqlite.OK");
#line 217 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	time_created = now_sec ();
#line 219 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp4_ = stmt;
#line 219 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp5_ = photo_row->master;
#line 219 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp6_ = _tmp5_->filepath;
#line 219 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp7_ = g_strdup (_tmp6_);
#line 219 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp8_ = g_free;
#line 219 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = sqlite3_bind_text (_tmp4_, 1, _tmp7_, -1, _tmp8_);
#line 220 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp9_ = res;
#line 220 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp9_ == SQLITE_OK, "res == Sqlite.OK");
#line 221 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp10_ = stmt;
#line 221 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp11_ = photo_row->master;
#line 221 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp12_ = _tmp11_->dim;
#line 221 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp13_ = _tmp12_.width;
#line 221 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = sqlite3_bind_int (_tmp10_, 2, _tmp13_);
#line 222 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp14_ = res;
#line 222 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp14_ == SQLITE_OK, "res == Sqlite.OK");
#line 223 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp15_ = stmt;
#line 223 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp16_ = photo_row->master;
#line 223 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp17_ = _tmp16_->dim;
#line 223 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp18_ = _tmp17_.height;
#line 223 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = sqlite3_bind_int (_tmp15_, 3, _tmp18_);
#line 224 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp19_ = res;
#line 224 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp19_ == SQLITE_OK, "res == Sqlite.OK");
#line 225 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp20_ = stmt;
#line 225 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp21_ = photo_row->master;
#line 225 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp22_ = _tmp21_->filesize;
#line 225 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = sqlite3_bind_int64 (_tmp20_, 4, _tmp22_);
#line 226 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp23_ = res;
#line 226 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp23_ == SQLITE_OK, "res == Sqlite.OK");
#line 227 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp24_ = stmt;
#line 227 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp25_ = photo_row->master;
#line 227 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp26_ = _tmp25_->timestamp;
#line 227 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = sqlite3_bind_int64 (_tmp24_, 5, (gint64) _tmp26_);
#line 228 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp27_ = res;
#line 228 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp27_ == SQLITE_OK, "res == Sqlite.OK");
#line 229 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp28_ = stmt;
#line 229 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp29_ = photo_row->exposure_time;
#line 229 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = sqlite3_bind_int64 (_tmp28_, 6, (gint64) _tmp29_);
#line 230 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp30_ = res;
#line 230 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp30_ == SQLITE_OK, "res == Sqlite.OK");
#line 231 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp31_ = stmt;
#line 231 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp32_ = photo_row->master;
#line 231 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp33_ = _tmp32_->original_orientation;
#line 231 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = sqlite3_bind_int (_tmp31_, 7, (gint) _tmp33_);
#line 232 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp34_ = res;
#line 232 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp34_ == SQLITE_OK, "res == Sqlite.OK");
#line 233 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp35_ = stmt;
#line 233 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp36_ = photo_row->master;
#line 233 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp37_ = _tmp36_->original_orientation;
#line 233 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = sqlite3_bind_int (_tmp35_, 8, (gint) _tmp37_);
#line 234 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp38_ = res;
#line 234 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp38_ == SQLITE_OK, "res == Sqlite.OK");
#line 235 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp39_ = stmt;
#line 235 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp40_ = photo_row->import_id;
#line 235 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp41_ = _tmp40_.id;
#line 235 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = sqlite3_bind_int64 (_tmp39_, 9, _tmp41_);
#line 236 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp42_ = res;
#line 236 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp42_ == SQLITE_OK, "res == Sqlite.OK");
#line 237 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp43_ = stmt;
#line 237 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = sqlite3_bind_int64 (_tmp43_, 10, EVENT_ID_INVALID);
#line 238 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp44_ = res;
#line 238 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp44_ == SQLITE_OK, "res == Sqlite.OK");
#line 239 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp45_ = stmt;
#line 239 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp46_ = photo_row->md5;
#line 239 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp47_ = g_strdup (_tmp46_);
#line 239 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp48_ = g_free;
#line 239 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = sqlite3_bind_text (_tmp45_, 11, _tmp47_, -1, _tmp48_);
#line 240 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp49_ = res;
#line 240 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp49_ == SQLITE_OK, "res == Sqlite.OK");
#line 241 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp50_ = stmt;
#line 241 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp51_ = photo_row->thumbnail_md5;
#line 241 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp52_ = g_strdup (_tmp51_);
#line 241 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp53_ = g_free;
#line 241 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = sqlite3_bind_text (_tmp50_, 12, _tmp52_, -1, _tmp53_);
#line 242 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp54_ = res;
#line 242 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp54_ == SQLITE_OK, "res == Sqlite.OK");
#line 243 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp55_ = stmt;
#line 243 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp56_ = photo_row->exif_md5;
#line 243 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp57_ = g_strdup (_tmp56_);
#line 243 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp58_ = g_free;
#line 243 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = sqlite3_bind_text (_tmp55_, 13, _tmp57_, -1, _tmp58_);
#line 244 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp59_ = res;
#line 244 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp59_ == SQLITE_OK, "res == Sqlite.OK");
#line 245 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp60_ = stmt;
#line 245 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp61_ = time_created;
#line 245 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = sqlite3_bind_int64 (_tmp60_, 14, (gint64) _tmp61_);
#line 246 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp62_ = res;
#line 246 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp62_ == SQLITE_OK, "res == Sqlite.OK");
#line 247 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp63_ = stmt;
#line 247 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp64_ = photo_row->master;
#line 247 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp65_ = _tmp64_->file_format;
#line 247 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = sqlite3_bind_int (_tmp63_, 15, photo_file_format_serialize (_tmp65_));
#line 248 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp66_ = res;
#line 248 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp66_ == SQLITE_OK, "res == Sqlite.OK");
#line 249 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp67_ = stmt;
#line 249 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp68_ = photo_row->title;
#line 249 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp69_ = g_strdup (_tmp68_);
#line 249 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp70_ = g_free;
#line 249 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = sqlite3_bind_text (_tmp67_, 16, _tmp69_, -1, _tmp70_);
#line 250 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp71_ = res;
#line 250 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp71_ == SQLITE_OK, "res == Sqlite.OK");
#line 251 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp72_ = stmt;
#line 251 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp73_ = photo_row->rating;
#line 251 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = sqlite3_bind_int64 (_tmp72_, 17, (gint64) rating_serialize (_tmp73_));
#line 252 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp74_ = res;
#line 252 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp74_ == SQLITE_OK, "res == Sqlite.OK");
#line 253 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp75_ = stmt;
#line 253 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = sqlite3_bind_int64 (_tmp75_, 18, BACKING_PHOTO_ID_INVALID);
#line 254 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp76_ = res;
#line 254 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp76_ == SQLITE_OK, "res == Sqlite.OK");
#line 255 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp77_ = stmt;
#line 255 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp78_ = photo_row->developer;
#line 255 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp79_ = raw_developer_to_string (_tmp78_);
#line 255 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp80_ = g_free;
#line 255 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = sqlite3_bind_text (_tmp77_, 19, _tmp79_, -1, _tmp80_);
#line 256 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp81_ = res;
#line 256 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp81_ == SQLITE_OK, "res == Sqlite.OK");
#line 257 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp82_ = stmt;
#line 257 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp83_ = photo_row->comment;
#line 257 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp84_ = g_strdup (_tmp83_);
#line 257 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp85_ = g_free;
#line 257 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = sqlite3_bind_text (_tmp82_, 20, _tmp84_, -1, _tmp85_);
#line 258 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp86_ = res;
#line 258 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp86_ == SQLITE_OK, "res == Sqlite.OK");
#line 260 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp87_ = stmt;
#line 260 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = sqlite3_step (_tmp87_);
#line 261 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp88_ = res;
#line 261 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (_tmp88_ != SQLITE_DONE) {
#line 1983 "PhotoTable.c"
		gint _tmp89_;
		PhotoID _tmp91_ = {0};
#line 262 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp89_ = res;
#line 262 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		if (_tmp89_ != SQLITE_CONSTRAINT) {
#line 1990 "PhotoTable.c"
			gint _tmp90_;
#line 263 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_tmp90_ = res;
#line 263 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			database_table_fatal ("add_photo", _tmp90_);
#line 1996 "PhotoTable.c"
		}
#line 265 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		photo_id_init (&_tmp91_, PHOTO_ID_INVALID);
#line 265 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		*result = _tmp91_;
#line 265 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_sqlite3_finalize0 (stmt);
#line 265 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		return;
#line 2006 "PhotoTable.c"
	}
#line 269 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp92_ = database_table_db;
#line 269 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	photo_id_init (&photo_row->photo_id, sqlite3_last_insert_rowid (_tmp92_));
#line 270 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp93_ = photo_row->master;
#line 270 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp94_ = _tmp93_->original_orientation;
#line 270 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	photo_row->orientation = _tmp94_;
#line 271 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	event_id_init (&photo_row->event_id, EVENT_ID_INVALID);
#line 272 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp95_ = time_created;
#line 272 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	photo_row->time_created = (time_t) _tmp95_;
#line 273 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	photo_row->flags = (guint64) 0;
#line 275 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp96_ = photo_row->photo_id;
#line 275 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	*result = _tmp96_;
#line 275 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_sqlite3_finalize0 (stmt);
#line 275 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	return;
#line 2034 "PhotoTable.c"
}


void
photo_table_reimport (PhotoTable* self,
                      PhotoRow* row,
                      GError** error)
{
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_;
	sqlite3_stmt* _tmp1_ = NULL;
	gint _tmp2_;
	gint _tmp3_;
	time_t time_reimported = 0;
	sqlite3_stmt* _tmp4_;
	BackingPhotoRow* _tmp5_;
	Dimensions _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	sqlite3_stmt* _tmp9_;
	BackingPhotoRow* _tmp10_;
	Dimensions _tmp11_;
	gint _tmp12_;
	gint _tmp13_;
	sqlite3_stmt* _tmp14_;
	BackingPhotoRow* _tmp15_;
	gint64 _tmp16_;
	gint _tmp17_;
	sqlite3_stmt* _tmp18_;
	BackingPhotoRow* _tmp19_;
	time_t _tmp20_;
	gint _tmp21_;
	sqlite3_stmt* _tmp22_;
	time_t _tmp23_;
	gint _tmp24_;
	sqlite3_stmt* _tmp25_;
	BackingPhotoRow* _tmp26_;
	Orientation _tmp27_;
	gint _tmp28_;
	sqlite3_stmt* _tmp29_;
	BackingPhotoRow* _tmp30_;
	Orientation _tmp31_;
	gint _tmp32_;
	sqlite3_stmt* _tmp33_;
	const gchar* _tmp34_;
	gchar* _tmp35_;
	GDestroyNotify _tmp36_;
	gint _tmp37_;
	sqlite3_stmt* _tmp38_;
	const gchar* _tmp39_;
	gchar* _tmp40_;
	GDestroyNotify _tmp41_;
	gint _tmp42_;
	sqlite3_stmt* _tmp43_;
	const gchar* _tmp44_;
	gchar* _tmp45_;
	GDestroyNotify _tmp46_;
	gint _tmp47_;
	sqlite3_stmt* _tmp48_;
	BackingPhotoRow* _tmp49_;
	PhotoFileFormat _tmp50_;
	gint _tmp51_;
	sqlite3_stmt* _tmp52_;
	const gchar* _tmp53_;
	gchar* _tmp54_;
	GDestroyNotify _tmp55_;
	gint _tmp56_;
	sqlite3_stmt* _tmp57_;
	time_t _tmp58_;
	gint _tmp59_;
	sqlite3_stmt* _tmp60_;
	PhotoID _tmp61_;
	gint64 _tmp62_;
	gint _tmp63_;
	sqlite3_stmt* _tmp64_;
	gint _tmp65_;
	time_t _tmp67_;
	BackingPhotoRow* _tmp68_;
	Orientation _tmp69_;
	GError * _inner_error_ = NULL;
#line 283 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_if_fail (IS_PHOTO_TABLE (self));
#line 283 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_if_fail (IS_PHOTO_ROW (row));
#line 285 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp0_ = database_table_db;
#line 285 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp2_ = sqlite3_prepare_v2 (_tmp0_, "UPDATE PhotoTable SET width = ?, height = ?, filesize = ?, timestamp =" \
" ?, " "exposure_time = ?, orientation = ?, original_orientation = ?, md5 = ?," \
" " "exif_md5 = ?, thumbnail_md5 = ?, file_format = ?, title = ?, time_reim" \
"ported = ? " "WHERE id = ?", -1, &_tmp1_, NULL);
#line 285 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_sqlite3_finalize0 (stmt);
#line 285 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	stmt = _tmp1_;
#line 285 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp2_;
#line 290 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp3_ = res;
#line 290 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp3_ == SQLITE_OK, "res == Sqlite.OK");
#line 292 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	time_reimported = (time_t) now_sec ();
#line 294 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp4_ = stmt;
#line 294 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp5_ = row->master;
#line 294 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp6_ = _tmp5_->dim;
#line 294 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp7_ = _tmp6_.width;
#line 294 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = sqlite3_bind_int (_tmp4_, 1, _tmp7_);
#line 295 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp8_ = res;
#line 295 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp8_ == SQLITE_OK, "res == Sqlite.OK");
#line 296 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp9_ = stmt;
#line 296 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp10_ = row->master;
#line 296 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp11_ = _tmp10_->dim;
#line 296 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp12_ = _tmp11_.height;
#line 296 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = sqlite3_bind_int (_tmp9_, 2, _tmp12_);
#line 297 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp13_ = res;
#line 297 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp13_ == SQLITE_OK, "res == Sqlite.OK");
#line 298 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp14_ = stmt;
#line 298 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp15_ = row->master;
#line 298 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp16_ = _tmp15_->filesize;
#line 298 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = sqlite3_bind_int64 (_tmp14_, 3, _tmp16_);
#line 299 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp17_ = res;
#line 299 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp17_ == SQLITE_OK, "res == Sqlite.OK");
#line 300 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp18_ = stmt;
#line 300 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp19_ = row->master;
#line 300 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp20_ = _tmp19_->timestamp;
#line 300 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = sqlite3_bind_int64 (_tmp18_, 4, (gint64) _tmp20_);
#line 301 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp21_ = res;
#line 301 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp21_ == SQLITE_OK, "res == Sqlite.OK");
#line 302 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp22_ = stmt;
#line 302 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp23_ = row->exposure_time;
#line 302 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = sqlite3_bind_int64 (_tmp22_, 5, (gint64) _tmp23_);
#line 303 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp24_ = res;
#line 303 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp24_ == SQLITE_OK, "res == Sqlite.OK");
#line 304 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp25_ = stmt;
#line 304 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp26_ = row->master;
#line 304 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp27_ = _tmp26_->original_orientation;
#line 304 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = sqlite3_bind_int (_tmp25_, 6, (gint) _tmp27_);
#line 305 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp28_ = res;
#line 305 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp28_ == SQLITE_OK, "res == Sqlite.OK");
#line 306 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp29_ = stmt;
#line 306 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp30_ = row->master;
#line 306 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp31_ = _tmp30_->original_orientation;
#line 306 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = sqlite3_bind_int (_tmp29_, 7, (gint) _tmp31_);
#line 307 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp32_ = res;
#line 307 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp32_ == SQLITE_OK, "res == Sqlite.OK");
#line 308 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp33_ = stmt;
#line 308 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp34_ = row->md5;
#line 308 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp35_ = g_strdup (_tmp34_);
#line 308 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp36_ = g_free;
#line 308 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = sqlite3_bind_text (_tmp33_, 8, _tmp35_, -1, _tmp36_);
#line 309 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp37_ = res;
#line 309 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp37_ == SQLITE_OK, "res == Sqlite.OK");
#line 310 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp38_ = stmt;
#line 310 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp39_ = row->exif_md5;
#line 310 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp40_ = g_strdup (_tmp39_);
#line 310 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp41_ = g_free;
#line 310 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = sqlite3_bind_text (_tmp38_, 9, _tmp40_, -1, _tmp41_);
#line 311 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp42_ = res;
#line 311 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp42_ == SQLITE_OK, "res == Sqlite.OK");
#line 312 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp43_ = stmt;
#line 312 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp44_ = row->thumbnail_md5;
#line 312 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp45_ = g_strdup (_tmp44_);
#line 312 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp46_ = g_free;
#line 312 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = sqlite3_bind_text (_tmp43_, 10, _tmp45_, -1, _tmp46_);
#line 313 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp47_ = res;
#line 313 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp47_ == SQLITE_OK, "res == Sqlite.OK");
#line 314 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp48_ = stmt;
#line 314 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp49_ = row->master;
#line 314 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp50_ = _tmp49_->file_format;
#line 314 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = sqlite3_bind_int (_tmp48_, 11, photo_file_format_serialize (_tmp50_));
#line 315 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp51_ = res;
#line 315 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp51_ == SQLITE_OK, "res == Sqlite.OK");
#line 316 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp52_ = stmt;
#line 316 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp53_ = row->title;
#line 316 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp54_ = g_strdup (_tmp53_);
#line 316 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp55_ = g_free;
#line 316 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = sqlite3_bind_text (_tmp52_, 12, _tmp54_, -1, _tmp55_);
#line 317 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp56_ = res;
#line 317 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp56_ == SQLITE_OK, "res == Sqlite.OK");
#line 318 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp57_ = stmt;
#line 318 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp58_ = time_reimported;
#line 318 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = sqlite3_bind_int64 (_tmp57_, 13, (gint64) _tmp58_);
#line 319 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp59_ = res;
#line 319 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp59_ == SQLITE_OK, "res == Sqlite.OK");
#line 320 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp60_ = stmt;
#line 320 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp61_ = row->photo_id;
#line 320 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp62_ = _tmp61_.id;
#line 320 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = sqlite3_bind_int64 (_tmp60_, 14, _tmp62_);
#line 321 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp63_ = res;
#line 321 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp63_ == SQLITE_OK, "res == Sqlite.OK");
#line 323 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp64_ = stmt;
#line 323 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = sqlite3_step (_tmp64_);
#line 324 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp65_ = res;
#line 324 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (_tmp65_ != SQLITE_DONE) {
#line 2320 "PhotoTable.c"
		gint _tmp66_;
#line 325 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp66_ = res;
#line 325 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		database_table_throw_error ("PhotoTable.reimport_master", _tmp66_, &_inner_error_);
#line 325 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 325 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			if (_inner_error_->domain == DATABASE_ERROR) {
#line 325 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				g_propagate_error (error, _inner_error_);
#line 325 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				_sqlite3_finalize0 (stmt);
#line 325 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				return;
#line 2336 "PhotoTable.c"
			} else {
#line 325 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				_sqlite3_finalize0 (stmt);
#line 325 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 325 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				g_clear_error (&_inner_error_);
#line 325 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				return;
#line 2346 "PhotoTable.c"
			}
		}
	}
#line 327 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp67_ = time_reimported;
#line 327 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	row->time_reimported = _tmp67_;
#line 328 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp68_ = row->master;
#line 328 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp69_ = _tmp68_->original_orientation;
#line 328 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	row->orientation = _tmp69_;
#line 283 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_sqlite3_finalize0 (stmt);
#line 2362 "PhotoTable.c"
}


gboolean
photo_table_master_exif_updated (PhotoTable* self,
                                 PhotoID* photoID,
                                 gint64 filesize,
                                 glong timestamp,
                                 const gchar* md5,
                                 const gchar* exif_md5,
                                 const gchar* thumbnail_md5,
                                 PhotoRow* row)
{
	gboolean result = FALSE;
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_;
	sqlite3_stmt* _tmp1_ = NULL;
	gint _tmp2_;
	gint _tmp3_;
	sqlite3_stmt* _tmp4_;
	gint _tmp5_;
	sqlite3_stmt* _tmp6_;
	gint _tmp7_;
	sqlite3_stmt* _tmp8_;
	gchar* _tmp9_;
	GDestroyNotify _tmp10_;
	gint _tmp11_;
	sqlite3_stmt* _tmp12_;
	gchar* _tmp13_;
	GDestroyNotify _tmp14_;
	gint _tmp15_;
	sqlite3_stmt* _tmp16_;
	gchar* _tmp17_;
	GDestroyNotify _tmp18_;
	gint _tmp19_;
	sqlite3_stmt* _tmp20_;
	PhotoID _tmp21_;
	gint64 _tmp22_;
	gint _tmp23_;
	sqlite3_stmt* _tmp24_;
	gint _tmp25_;
	BackingPhotoRow* _tmp28_;
	BackingPhotoRow* _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
#line 331 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_val_if_fail (IS_PHOTO_TABLE (self), FALSE);
#line 331 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_val_if_fail (photoID != NULL, FALSE);
#line 331 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_val_if_fail (md5 != NULL, FALSE);
#line 331 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_val_if_fail (IS_PHOTO_ROW (row), FALSE);
#line 334 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp0_ = database_table_db;
#line 334 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp2_ = sqlite3_prepare_v2 (_tmp0_, "UPDATE PhotoTable SET filesize = ?, timestamp = ?, md5 = ?, exif_md5 =" \
" ?," "thumbnail_md5 =? WHERE id = ?", -1, &_tmp1_, NULL);
#line 334 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_sqlite3_finalize0 (stmt);
#line 334 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	stmt = _tmp1_;
#line 334 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp2_;
#line 337 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp3_ = res;
#line 337 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp3_ == SQLITE_OK, "res == Sqlite.OK");
#line 339 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp4_ = stmt;
#line 339 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = sqlite3_bind_int64 (_tmp4_, 1, filesize);
#line 340 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp5_ = res;
#line 340 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp5_ == SQLITE_OK, "res == Sqlite.OK");
#line 341 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp6_ = stmt;
#line 341 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = sqlite3_bind_int64 (_tmp6_, 2, (gint64) timestamp);
#line 342 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp7_ = res;
#line 342 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp7_ == SQLITE_OK, "res == Sqlite.OK");
#line 343 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp8_ = stmt;
#line 343 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp9_ = g_strdup (md5);
#line 343 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp10_ = g_free;
#line 343 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = sqlite3_bind_text (_tmp8_, 3, _tmp9_, -1, _tmp10_);
#line 344 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp11_ = res;
#line 344 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp11_ == SQLITE_OK, "res == Sqlite.OK");
#line 345 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp12_ = stmt;
#line 345 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp13_ = g_strdup (exif_md5);
#line 345 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp14_ = g_free;
#line 345 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = sqlite3_bind_text (_tmp12_, 4, _tmp13_, -1, _tmp14_);
#line 346 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp15_ = res;
#line 346 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp15_ == SQLITE_OK, "res == Sqlite.OK");
#line 347 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp16_ = stmt;
#line 347 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp17_ = g_strdup (thumbnail_md5);
#line 347 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp18_ = g_free;
#line 347 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = sqlite3_bind_text (_tmp16_, 5, _tmp17_, -1, _tmp18_);
#line 348 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp19_ = res;
#line 348 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp19_ == SQLITE_OK, "res == Sqlite.OK");
#line 349 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp20_ = stmt;
#line 349 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp21_ = *photoID;
#line 349 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp22_ = _tmp21_.id;
#line 349 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = sqlite3_bind_int64 (_tmp20_, 6, _tmp22_);
#line 350 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp23_ = res;
#line 350 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp23_ == SQLITE_OK, "res == Sqlite.OK");
#line 352 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp24_ = stmt;
#line 352 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = sqlite3_step (_tmp24_);
#line 353 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp25_ = res;
#line 353 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (_tmp25_ != SQLITE_DONE) {
#line 2504 "PhotoTable.c"
		gint _tmp26_;
#line 354 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp26_ = res;
#line 354 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		if (_tmp26_ != SQLITE_CONSTRAINT) {
#line 2510 "PhotoTable.c"
			gint _tmp27_;
#line 355 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_tmp27_ = res;
#line 355 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			database_table_fatal ("write_update_photo", _tmp27_);
#line 2516 "PhotoTable.c"
		}
#line 357 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		result = FALSE;
#line 357 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_sqlite3_finalize0 (stmt);
#line 357 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		return result;
#line 2524 "PhotoTable.c"
	}
#line 360 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp28_ = row->master;
#line 360 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp28_->filesize = filesize;
#line 361 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp29_ = row->master;
#line 361 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp29_->timestamp = (time_t) timestamp;
#line 362 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp30_ = g_strdup (md5);
#line 362 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_g_free0 (row->md5);
#line 362 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	row->md5 = _tmp30_;
#line 363 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp31_ = g_strdup (exif_md5);
#line 363 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_g_free0 (row->exif_md5);
#line 363 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	row->exif_md5 = _tmp31_;
#line 364 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp32_ = g_strdup (thumbnail_md5);
#line 364 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_g_free0 (row->thumbnail_md5);
#line 364 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	row->thumbnail_md5 = _tmp32_;
#line 366 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	result = TRUE;
#line 366 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_sqlite3_finalize0 (stmt);
#line 366 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	return result;
#line 2558 "PhotoTable.c"
}


static void
photo_table_validate_orientation (PhotoTable* self,
                                  PhotoRow* row)
{
	gboolean _tmp0_ = FALSE;
	Orientation _tmp1_;
#line 377 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_if_fail (IS_PHOTO_TABLE (self));
#line 377 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_if_fail (IS_PHOTO_ROW (row));
#line 378 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp1_ = row->orientation;
#line 378 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (_tmp1_ < ORIENTATION_MIN) {
#line 378 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp0_ = TRUE;
#line 2578 "PhotoTable.c"
	} else {
		Orientation _tmp2_;
#line 379 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp2_ = row->orientation;
#line 379 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp0_ = _tmp2_ > ORIENTATION_MAX;
#line 2585 "PhotoTable.c"
	}
#line 378 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (_tmp0_) {
#line 2589 "PhotoTable.c"
		PhotoID _tmp3_;
#line 381 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp3_ = row->photo_id;
#line 381 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		photo_table_set_orientation (self, &_tmp3_, ORIENTATION_MIN);
#line 382 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		row->orientation = ORIENTATION_MIN;
#line 2597 "PhotoTable.c"
	}
}


PhotoRow*
photo_table_get_row (PhotoTable* self,
                     PhotoID* photo_id)
{
	PhotoRow* result = NULL;
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_;
	sqlite3_stmt* _tmp1_ = NULL;
	gint _tmp2_;
	gint _tmp3_;
	sqlite3_stmt* _tmp4_;
	PhotoID _tmp5_;
	gint64 _tmp6_;
	gint _tmp7_;
	sqlite3_stmt* _tmp8_;
	PhotoRow* row = NULL;
	PhotoRow* _tmp9_;
	PhotoRow* _tmp10_;
	PhotoID _tmp11_;
	PhotoRow* _tmp12_;
	BackingPhotoRow* _tmp13_;
	sqlite3_stmt* _tmp14_;
	const gchar* _tmp15_;
	gchar* _tmp16_;
	PhotoRow* _tmp17_;
	BackingPhotoRow* _tmp18_;
	sqlite3_stmt* _tmp19_;
	sqlite3_stmt* _tmp20_;
	PhotoRow* _tmp21_;
	BackingPhotoRow* _tmp22_;
	sqlite3_stmt* _tmp23_;
	PhotoRow* _tmp24_;
	BackingPhotoRow* _tmp25_;
	sqlite3_stmt* _tmp26_;
	PhotoRow* _tmp27_;
	sqlite3_stmt* _tmp28_;
	PhotoRow* _tmp29_;
	sqlite3_stmt* _tmp30_;
	PhotoRow* _tmp31_;
	BackingPhotoRow* _tmp32_;
	sqlite3_stmt* _tmp33_;
	PhotoRow* _tmp34_;
	sqlite3_stmt* _tmp35_;
	PhotoRow* _tmp36_;
	sqlite3_stmt* _tmp37_;
	PhotoRow* _tmp38_;
	sqlite3_stmt* _tmp39_;
	const gchar* _tmp40_;
	GeeHashMap* _tmp41_;
	PhotoRow* _tmp42_;
	sqlite3_stmt* _tmp43_;
	const gchar* _tmp44_;
	gchar* _tmp45_;
	PhotoRow* _tmp46_;
	sqlite3_stmt* _tmp47_;
	const gchar* _tmp48_;
	gchar* _tmp49_;
	PhotoRow* _tmp50_;
	sqlite3_stmt* _tmp51_;
	const gchar* _tmp52_;
	gchar* _tmp53_;
	PhotoRow* _tmp54_;
	sqlite3_stmt* _tmp55_;
	PhotoRow* _tmp56_;
	sqlite3_stmt* _tmp57_;
	PhotoRow* _tmp58_;
	sqlite3_stmt* _tmp59_;
	PhotoRow* _tmp60_;
	BackingPhotoRow* _tmp61_;
	sqlite3_stmt* _tmp62_;
	PhotoRow* _tmp63_;
	sqlite3_stmt* _tmp64_;
	const gchar* _tmp65_;
	gchar* _tmp66_;
	PhotoRow* _tmp67_;
	sqlite3_stmt* _tmp68_;
	const gchar* _tmp69_;
	gchar* _tmp70_;
	PhotoRow* _tmp71_;
	sqlite3_stmt* _tmp72_;
	PhotoRow* _tmp73_;
	sqlite3_stmt* _tmp74_;
	PhotoRow* _tmp75_;
	sqlite3_stmt* _tmp76_;
	RawDeveloper _tmp77_ = 0;
	sqlite3_stmt* _tmp78_;
	const gchar* _tmp79_;
	PhotoRow* _tmp82_;
	PhotoRow* _tmp83_;
	BackingPhotoID* _tmp84_;
	gint _tmp84__length1;
	sqlite3_stmt* _tmp85_;
	BackingPhotoID _tmp86_ = {0};
	BackingPhotoID _tmp87_;
	PhotoRow* _tmp88_;
	BackingPhotoID* _tmp89_;
	gint _tmp89__length1;
	sqlite3_stmt* _tmp90_;
	BackingPhotoID _tmp91_ = {0};
	BackingPhotoID _tmp92_;
	PhotoRow* _tmp93_;
	BackingPhotoID* _tmp94_;
	gint _tmp94__length1;
	sqlite3_stmt* _tmp95_;
	BackingPhotoID _tmp96_ = {0};
	BackingPhotoID _tmp97_;
	PhotoRow* _tmp98_;
	sqlite3_stmt* _tmp99_;
	const gchar* _tmp100_;
	gchar* _tmp101_;
#line 386 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_val_if_fail (IS_PHOTO_TABLE (self), NULL);
#line 386 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_val_if_fail (photo_id != NULL, NULL);
#line 388 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp0_ = database_table_db;
#line 388 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp2_ = sqlite3_prepare_v2 (_tmp0_, "SELECT filename, width, height, filesize, timestamp, exposure_time, or" \
"ientation, " "original_orientation, import_id, event_id, transformations, md5, thumb" \
"nail_md5, " "exif_md5, time_created, flags, rating, file_format, title, backlinks, " "time_reimported, editable_id, metadata_dirty, developer, develop_shotw" \
"ell_id, " "develop_camera_id, develop_embedded_id, comment " "FROM PhotoTable WHERE id=?", -1, &_tmp1_, NULL);
#line 388 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_sqlite3_finalize0 (stmt);
#line 388 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	stmt = _tmp1_;
#line 388 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp2_;
#line 396 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp3_ = res;
#line 396 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp3_ == SQLITE_OK, "res == Sqlite.OK");
#line 398 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp4_ = stmt;
#line 398 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp5_ = *photo_id;
#line 398 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp6_ = _tmp5_.id;
#line 398 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = sqlite3_bind_int64 (_tmp4_, 1, _tmp6_);
#line 399 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp7_ = res;
#line 399 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp7_ == SQLITE_OK, "res == Sqlite.OK");
#line 401 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp8_ = stmt;
#line 401 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (sqlite3_step (_tmp8_) != SQLITE_ROW) {
#line 402 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		result = NULL;
#line 402 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_sqlite3_finalize0 (stmt);
#line 402 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		return result;
#line 2753 "PhotoTable.c"
	}
#line 404 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp9_ = photo_row_new ();
#line 404 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	row = _tmp9_;
#line 405 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp10_ = row;
#line 405 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp11_ = *photo_id;
#line 405 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp10_->photo_id = _tmp11_;
#line 406 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp12_ = row;
#line 406 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp13_ = _tmp12_->master;
#line 406 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp14_ = stmt;
#line 406 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp15_ = sqlite3_column_text (_tmp14_, 0);
#line 406 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp16_ = g_strdup (_tmp15_);
#line 406 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_g_free0 (_tmp13_->filepath);
#line 406 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp13_->filepath = _tmp16_;
#line 407 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp17_ = row;
#line 407 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp18_ = _tmp17_->master;
#line 407 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp19_ = stmt;
#line 407 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp20_ = stmt;
#line 407 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	dimensions_init (&_tmp18_->dim, sqlite3_column_int (_tmp19_, 1), sqlite3_column_int (_tmp20_, 2));
#line 408 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp21_ = row;
#line 408 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp22_ = _tmp21_->master;
#line 408 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp23_ = stmt;
#line 408 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp22_->filesize = sqlite3_column_int64 (_tmp23_, 3);
#line 409 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp24_ = row;
#line 409 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp25_ = _tmp24_->master;
#line 409 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp26_ = stmt;
#line 409 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp25_->timestamp = (time_t) sqlite3_column_int64 (_tmp26_, 4);
#line 410 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp27_ = row;
#line 410 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp28_ = stmt;
#line 410 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp27_->exposure_time = (time_t) sqlite3_column_int64 (_tmp28_, 5);
#line 411 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp29_ = row;
#line 411 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp30_ = stmt;
#line 411 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp29_->orientation = (Orientation) sqlite3_column_int (_tmp30_, 6);
#line 412 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp31_ = row;
#line 412 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp32_ = _tmp31_->master;
#line 412 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp33_ = stmt;
#line 412 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp32_->original_orientation = (Orientation) sqlite3_column_int (_tmp33_, 7);
#line 413 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp34_ = row;
#line 413 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp35_ = stmt;
#line 413 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp34_->import_id.id = sqlite3_column_int64 (_tmp35_, 8);
#line 414 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp36_ = row;
#line 414 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp37_ = stmt;
#line 414 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp36_->event_id.id = sqlite3_column_int64 (_tmp37_, 9);
#line 415 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp38_ = row;
#line 415 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp39_ = stmt;
#line 415 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp40_ = sqlite3_column_text (_tmp39_, 10);
#line 415 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp41_ = photo_table_marshall_all_transformations (_tmp40_);
#line 415 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_g_object_unref0 (_tmp38_->transformations);
#line 415 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp38_->transformations = _tmp41_;
#line 416 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp42_ = row;
#line 416 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp43_ = stmt;
#line 416 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp44_ = sqlite3_column_text (_tmp43_, 11);
#line 416 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp45_ = g_strdup (_tmp44_);
#line 416 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_g_free0 (_tmp42_->md5);
#line 416 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp42_->md5 = _tmp45_;
#line 417 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp46_ = row;
#line 417 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp47_ = stmt;
#line 417 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp48_ = sqlite3_column_text (_tmp47_, 12);
#line 417 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp49_ = g_strdup (_tmp48_);
#line 417 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_g_free0 (_tmp46_->thumbnail_md5);
#line 417 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp46_->thumbnail_md5 = _tmp49_;
#line 418 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp50_ = row;
#line 418 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp51_ = stmt;
#line 418 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp52_ = sqlite3_column_text (_tmp51_, 13);
#line 418 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp53_ = g_strdup (_tmp52_);
#line 418 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_g_free0 (_tmp50_->exif_md5);
#line 418 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp50_->exif_md5 = _tmp53_;
#line 419 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp54_ = row;
#line 419 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp55_ = stmt;
#line 419 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp54_->time_created = (time_t) sqlite3_column_int64 (_tmp55_, 14);
#line 420 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp56_ = row;
#line 420 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp57_ = stmt;
#line 420 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp56_->flags = (guint64) sqlite3_column_int64 (_tmp57_, 15);
#line 421 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp58_ = row;
#line 421 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp59_ = stmt;
#line 421 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp58_->rating = rating_unserialize (sqlite3_column_int (_tmp59_, 16));
#line 422 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp60_ = row;
#line 422 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp61_ = _tmp60_->master;
#line 422 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp62_ = stmt;
#line 422 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp61_->file_format = photo_file_format_unserialize (sqlite3_column_int (_tmp62_, 17));
#line 423 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp63_ = row;
#line 423 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp64_ = stmt;
#line 423 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp65_ = sqlite3_column_text (_tmp64_, 18);
#line 423 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp66_ = g_strdup (_tmp65_);
#line 423 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_g_free0 (_tmp63_->title);
#line 423 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp63_->title = _tmp66_;
#line 424 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp67_ = row;
#line 424 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp68_ = stmt;
#line 424 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp69_ = sqlite3_column_text (_tmp68_, 19);
#line 424 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp70_ = g_strdup (_tmp69_);
#line 424 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_g_free0 (_tmp67_->backlinks);
#line 424 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp67_->backlinks = _tmp70_;
#line 425 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp71_ = row;
#line 425 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp72_ = stmt;
#line 425 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp71_->time_reimported = (time_t) sqlite3_column_int64 (_tmp72_, 20);
#line 426 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp73_ = row;
#line 426 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp74_ = stmt;
#line 426 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	backing_photo_id_init (&_tmp73_->editable_id, sqlite3_column_int64 (_tmp74_, 21));
#line 427 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp75_ = row;
#line 427 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp76_ = stmt;
#line 427 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp75_->metadata_dirty = sqlite3_column_int (_tmp76_, 22) != 0;
#line 428 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp78_ = stmt;
#line 428 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp79_ = sqlite3_column_text (_tmp78_, 23);
#line 428 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (_tmp79_ != NULL) {
#line 2959 "PhotoTable.c"
		sqlite3_stmt* _tmp80_;
		const gchar* _tmp81_;
#line 428 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp80_ = stmt;
#line 428 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp81_ = sqlite3_column_text (_tmp80_, 23);
#line 428 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp77_ = raw_developer_from_string (_tmp81_);
#line 2968 "PhotoTable.c"
	} else {
#line 429 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp77_ = RAW_DEVELOPER_CAMERA;
#line 2972 "PhotoTable.c"
	}
#line 428 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp82_ = row;
#line 428 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp82_->developer = _tmp77_;
#line 430 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp83_ = row;
#line 430 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp84_ = _tmp83_->development_ids;
#line 430 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp84__length1 = _tmp83_->development_ids_length1;
#line 430 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp85_ = stmt;
#line 430 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	backing_photo_id_init (&_tmp86_, sqlite3_column_int64 (_tmp85_, 24));
#line 430 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp84_[RAW_DEVELOPER_SHOTWELL] = _tmp86_;
#line 430 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp87_ = _tmp84_[RAW_DEVELOPER_SHOTWELL];
#line 431 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp88_ = row;
#line 431 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp89_ = _tmp88_->development_ids;
#line 431 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp89__length1 = _tmp88_->development_ids_length1;
#line 431 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp90_ = stmt;
#line 431 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	backing_photo_id_init (&_tmp91_, sqlite3_column_int64 (_tmp90_, 25));
#line 431 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp89_[RAW_DEVELOPER_CAMERA] = _tmp91_;
#line 431 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp92_ = _tmp89_[RAW_DEVELOPER_CAMERA];
#line 432 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp93_ = row;
#line 432 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp94_ = _tmp93_->development_ids;
#line 432 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp94__length1 = _tmp93_->development_ids_length1;
#line 432 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp95_ = stmt;
#line 432 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	backing_photo_id_init (&_tmp96_, sqlite3_column_int64 (_tmp95_, 26));
#line 432 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp94_[RAW_DEVELOPER_EMBEDDED] = _tmp96_;
#line 432 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp97_ = _tmp94_[RAW_DEVELOPER_EMBEDDED];
#line 433 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp98_ = row;
#line 433 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp99_ = stmt;
#line 433 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp100_ = sqlite3_column_text (_tmp99_, 27);
#line 433 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp101_ = g_strdup (_tmp100_);
#line 433 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_g_free0 (_tmp98_->comment);
#line 433 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp98_->comment = _tmp101_;
#line 435 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	result = row;
#line 435 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_sqlite3_finalize0 (stmt);
#line 435 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	return result;
#line 3038 "PhotoTable.c"
}


GeeArrayList*
photo_table_get_all (PhotoTable* self)
{
	GeeArrayList* result = NULL;
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_;
	sqlite3_stmt* _tmp1_ = NULL;
	gint _tmp2_;
	gint _tmp3_;
	GeeArrayList* all = NULL;
	GeeArrayList* _tmp4_;
#line 438 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_val_if_fail (IS_PHOTO_TABLE (self), NULL);
#line 440 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp0_ = database_table_db;
#line 440 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp2_ = sqlite3_prepare_v2 (_tmp0_, "SELECT id, filename, width, height, filesize, timestamp, exposure_time" \
", orientation, " "original_orientation, import_id, event_id, transformations, md5, thumb" \
"nail_md5, " "exif_md5, time_created, flags, rating, file_format, title, backlinks, " \
"time_reimported, " "editable_id, metadata_dirty, developer, develop_shotwell_id, develop_c" \
"amera_id, " "develop_embedded_id, comment FROM PhotoTable", -1, &_tmp1_, NULL);
#line 440 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_sqlite3_finalize0 (stmt);
#line 440 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	stmt = _tmp1_;
#line 440 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp2_;
#line 447 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp3_ = res;
#line 447 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp3_ == SQLITE_OK, "res == Sqlite.OK");
#line 449 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp4_ = gee_array_list_new (TYPE_PHOTO_ROW, (GBoxedCopyFunc) photo_row_ref, (GDestroyNotify) photo_row_unref, NULL, NULL, NULL);
#line 449 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	all = _tmp4_;
#line 451 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	while (TRUE) {
#line 3076 "PhotoTable.c"
		sqlite3_stmt* _tmp5_;
		gint _tmp6_;
		PhotoRow* row = NULL;
		PhotoRow* _tmp7_;
		PhotoRow* _tmp8_;
		sqlite3_stmt* _tmp9_;
		PhotoRow* _tmp10_;
		BackingPhotoRow* _tmp11_;
		sqlite3_stmt* _tmp12_;
		const gchar* _tmp13_;
		gchar* _tmp14_;
		PhotoRow* _tmp15_;
		BackingPhotoRow* _tmp16_;
		sqlite3_stmt* _tmp17_;
		sqlite3_stmt* _tmp18_;
		PhotoRow* _tmp19_;
		BackingPhotoRow* _tmp20_;
		sqlite3_stmt* _tmp21_;
		PhotoRow* _tmp22_;
		BackingPhotoRow* _tmp23_;
		sqlite3_stmt* _tmp24_;
		PhotoRow* _tmp25_;
		sqlite3_stmt* _tmp26_;
		PhotoRow* _tmp27_;
		sqlite3_stmt* _tmp28_;
		PhotoRow* _tmp29_;
		BackingPhotoRow* _tmp30_;
		sqlite3_stmt* _tmp31_;
		PhotoRow* _tmp32_;
		sqlite3_stmt* _tmp33_;
		PhotoRow* _tmp34_;
		sqlite3_stmt* _tmp35_;
		PhotoRow* _tmp36_;
		sqlite3_stmt* _tmp37_;
		const gchar* _tmp38_;
		GeeHashMap* _tmp39_;
		PhotoRow* _tmp40_;
		sqlite3_stmt* _tmp41_;
		const gchar* _tmp42_;
		gchar* _tmp43_;
		PhotoRow* _tmp44_;
		sqlite3_stmt* _tmp45_;
		const gchar* _tmp46_;
		gchar* _tmp47_;
		PhotoRow* _tmp48_;
		sqlite3_stmt* _tmp49_;
		const gchar* _tmp50_;
		gchar* _tmp51_;
		PhotoRow* _tmp52_;
		sqlite3_stmt* _tmp53_;
		PhotoRow* _tmp54_;
		sqlite3_stmt* _tmp55_;
		PhotoRow* _tmp56_;
		sqlite3_stmt* _tmp57_;
		PhotoRow* _tmp58_;
		BackingPhotoRow* _tmp59_;
		sqlite3_stmt* _tmp60_;
		PhotoRow* _tmp61_;
		sqlite3_stmt* _tmp62_;
		const gchar* _tmp63_;
		gchar* _tmp64_;
		PhotoRow* _tmp65_;
		sqlite3_stmt* _tmp66_;
		const gchar* _tmp67_;
		gchar* _tmp68_;
		PhotoRow* _tmp69_;
		sqlite3_stmt* _tmp70_;
		PhotoRow* _tmp71_;
		sqlite3_stmt* _tmp72_;
		PhotoRow* _tmp73_;
		sqlite3_stmt* _tmp74_;
		RawDeveloper _tmp75_ = 0;
		sqlite3_stmt* _tmp76_;
		const gchar* _tmp77_;
		PhotoRow* _tmp80_;
		PhotoRow* _tmp81_;
		BackingPhotoID* _tmp82_;
		gint _tmp82__length1;
		sqlite3_stmt* _tmp83_;
		BackingPhotoID _tmp84_ = {0};
		BackingPhotoID _tmp85_;
		PhotoRow* _tmp86_;
		BackingPhotoID* _tmp87_;
		gint _tmp87__length1;
		sqlite3_stmt* _tmp88_;
		BackingPhotoID _tmp89_ = {0};
		BackingPhotoID _tmp90_;
		PhotoRow* _tmp91_;
		BackingPhotoID* _tmp92_;
		gint _tmp92__length1;
		sqlite3_stmt* _tmp93_;
		BackingPhotoID _tmp94_ = {0};
		BackingPhotoID _tmp95_;
		PhotoRow* _tmp96_;
		sqlite3_stmt* _tmp97_;
		const gchar* _tmp98_;
		gchar* _tmp99_;
		PhotoRow* _tmp100_;
		GeeArrayList* _tmp101_;
		PhotoRow* _tmp102_;
#line 451 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp5_ = stmt;
#line 451 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		res = sqlite3_step (_tmp5_);
#line 451 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp6_ = res;
#line 451 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		if (!(_tmp6_ == SQLITE_ROW)) {
#line 451 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			break;
#line 3187 "PhotoTable.c"
		}
#line 452 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp7_ = photo_row_new ();
#line 452 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		row = _tmp7_;
#line 453 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp8_ = row;
#line 453 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp9_ = stmt;
#line 453 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp8_->photo_id.id = sqlite3_column_int64 (_tmp9_, 0);
#line 454 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp10_ = row;
#line 454 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp11_ = _tmp10_->master;
#line 454 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp12_ = stmt;
#line 454 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp13_ = sqlite3_column_text (_tmp12_, 1);
#line 454 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp14_ = g_strdup (_tmp13_);
#line 454 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_g_free0 (_tmp11_->filepath);
#line 454 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp11_->filepath = _tmp14_;
#line 455 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp15_ = row;
#line 455 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp16_ = _tmp15_->master;
#line 455 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp17_ = stmt;
#line 455 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp18_ = stmt;
#line 455 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		dimensions_init (&_tmp16_->dim, sqlite3_column_int (_tmp17_, 2), sqlite3_column_int (_tmp18_, 3));
#line 456 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp19_ = row;
#line 456 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp20_ = _tmp19_->master;
#line 456 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp21_ = stmt;
#line 456 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp20_->filesize = sqlite3_column_int64 (_tmp21_, 4);
#line 457 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp22_ = row;
#line 457 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp23_ = _tmp22_->master;
#line 457 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp24_ = stmt;
#line 457 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp23_->timestamp = (time_t) sqlite3_column_int64 (_tmp24_, 5);
#line 458 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp25_ = row;
#line 458 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp26_ = stmt;
#line 458 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp25_->exposure_time = (time_t) sqlite3_column_int64 (_tmp26_, 6);
#line 459 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp27_ = row;
#line 459 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp28_ = stmt;
#line 459 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp27_->orientation = (Orientation) sqlite3_column_int (_tmp28_, 7);
#line 460 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp29_ = row;
#line 460 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp30_ = _tmp29_->master;
#line 460 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp31_ = stmt;
#line 460 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp30_->original_orientation = (Orientation) sqlite3_column_int (_tmp31_, 8);
#line 461 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp32_ = row;
#line 461 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp33_ = stmt;
#line 461 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp32_->import_id.id = sqlite3_column_int64 (_tmp33_, 9);
#line 462 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp34_ = row;
#line 462 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp35_ = stmt;
#line 462 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp34_->event_id.id = sqlite3_column_int64 (_tmp35_, 10);
#line 463 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp36_ = row;
#line 463 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp37_ = stmt;
#line 463 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp38_ = sqlite3_column_text (_tmp37_, 11);
#line 463 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp39_ = photo_table_marshall_all_transformations (_tmp38_);
#line 463 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_g_object_unref0 (_tmp36_->transformations);
#line 463 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp36_->transformations = _tmp39_;
#line 464 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp40_ = row;
#line 464 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp41_ = stmt;
#line 464 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp42_ = sqlite3_column_text (_tmp41_, 12);
#line 464 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp43_ = g_strdup (_tmp42_);
#line 464 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_g_free0 (_tmp40_->md5);
#line 464 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp40_->md5 = _tmp43_;
#line 465 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp44_ = row;
#line 465 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp45_ = stmt;
#line 465 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp46_ = sqlite3_column_text (_tmp45_, 13);
#line 465 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp47_ = g_strdup (_tmp46_);
#line 465 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_g_free0 (_tmp44_->thumbnail_md5);
#line 465 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp44_->thumbnail_md5 = _tmp47_;
#line 466 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp48_ = row;
#line 466 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp49_ = stmt;
#line 466 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp50_ = sqlite3_column_text (_tmp49_, 14);
#line 466 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp51_ = g_strdup (_tmp50_);
#line 466 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_g_free0 (_tmp48_->exif_md5);
#line 466 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp48_->exif_md5 = _tmp51_;
#line 467 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp52_ = row;
#line 467 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp53_ = stmt;
#line 467 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp52_->time_created = (time_t) sqlite3_column_int64 (_tmp53_, 15);
#line 468 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp54_ = row;
#line 468 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp55_ = stmt;
#line 468 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp54_->flags = (guint64) sqlite3_column_int64 (_tmp55_, 16);
#line 469 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp56_ = row;
#line 469 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp57_ = stmt;
#line 469 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp56_->rating = rating_unserialize (sqlite3_column_int (_tmp57_, 17));
#line 470 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp58_ = row;
#line 470 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp59_ = _tmp58_->master;
#line 470 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp60_ = stmt;
#line 470 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp59_->file_format = photo_file_format_unserialize (sqlite3_column_int (_tmp60_, 18));
#line 471 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp61_ = row;
#line 471 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp62_ = stmt;
#line 471 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp63_ = sqlite3_column_text (_tmp62_, 19);
#line 471 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp64_ = g_strdup (_tmp63_);
#line 471 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_g_free0 (_tmp61_->title);
#line 471 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp61_->title = _tmp64_;
#line 472 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp65_ = row;
#line 472 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp66_ = stmt;
#line 472 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp67_ = sqlite3_column_text (_tmp66_, 20);
#line 472 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp68_ = g_strdup (_tmp67_);
#line 472 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_g_free0 (_tmp65_->backlinks);
#line 472 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp65_->backlinks = _tmp68_;
#line 473 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp69_ = row;
#line 473 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp70_ = stmt;
#line 473 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp69_->time_reimported = (time_t) sqlite3_column_int64 (_tmp70_, 21);
#line 474 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp71_ = row;
#line 474 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp72_ = stmt;
#line 474 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		backing_photo_id_init (&_tmp71_->editable_id, sqlite3_column_int64 (_tmp72_, 22));
#line 475 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp73_ = row;
#line 475 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp74_ = stmt;
#line 475 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp73_->metadata_dirty = sqlite3_column_int (_tmp74_, 23) != 0;
#line 476 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp76_ = stmt;
#line 476 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp77_ = sqlite3_column_text (_tmp76_, 24);
#line 476 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		if (_tmp77_ != NULL) {
#line 3393 "PhotoTable.c"
			sqlite3_stmt* _tmp78_;
			const gchar* _tmp79_;
#line 476 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_tmp78_ = stmt;
#line 476 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_tmp79_ = sqlite3_column_text (_tmp78_, 24);
#line 476 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_tmp75_ = raw_developer_from_string (_tmp79_);
#line 3402 "PhotoTable.c"
		} else {
#line 477 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_tmp75_ = RAW_DEVELOPER_CAMERA;
#line 3406 "PhotoTable.c"
		}
#line 476 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp80_ = row;
#line 476 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp80_->developer = _tmp75_;
#line 478 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp81_ = row;
#line 478 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp82_ = _tmp81_->development_ids;
#line 478 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp82__length1 = _tmp81_->development_ids_length1;
#line 478 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp83_ = stmt;
#line 478 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		backing_photo_id_init (&_tmp84_, sqlite3_column_int64 (_tmp83_, 25));
#line 478 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp82_[RAW_DEVELOPER_SHOTWELL] = _tmp84_;
#line 478 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp85_ = _tmp82_[RAW_DEVELOPER_SHOTWELL];
#line 479 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp86_ = row;
#line 479 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp87_ = _tmp86_->development_ids;
#line 479 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp87__length1 = _tmp86_->development_ids_length1;
#line 479 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp88_ = stmt;
#line 479 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		backing_photo_id_init (&_tmp89_, sqlite3_column_int64 (_tmp88_, 26));
#line 479 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp87_[RAW_DEVELOPER_CAMERA] = _tmp89_;
#line 479 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp90_ = _tmp87_[RAW_DEVELOPER_CAMERA];
#line 480 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp91_ = row;
#line 480 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp92_ = _tmp91_->development_ids;
#line 480 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp92__length1 = _tmp91_->development_ids_length1;
#line 480 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp93_ = stmt;
#line 480 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		backing_photo_id_init (&_tmp94_, sqlite3_column_int64 (_tmp93_, 27));
#line 480 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp92_[RAW_DEVELOPER_EMBEDDED] = _tmp94_;
#line 480 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp95_ = _tmp92_[RAW_DEVELOPER_EMBEDDED];
#line 481 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp96_ = row;
#line 481 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp97_ = stmt;
#line 481 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp98_ = sqlite3_column_text (_tmp97_, 28);
#line 481 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp99_ = g_strdup (_tmp98_);
#line 481 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_g_free0 (_tmp96_->comment);
#line 481 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp96_->comment = _tmp99_;
#line 483 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp100_ = row;
#line 483 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		photo_table_validate_orientation (self, _tmp100_);
#line 485 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp101_ = all;
#line 485 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp102_ = row;
#line 485 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp101_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp102_);
#line 451 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_photo_row_unref0 (row);
#line 3478 "PhotoTable.c"
	}
#line 488 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	result = all;
#line 488 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_sqlite3_finalize0 (stmt);
#line 488 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	return result;
#line 3486 "PhotoTable.c"
}


void
photo_table_duplicate (PhotoTable* self,
                       PhotoID* photo_id,
                       const gchar* new_filename,
                       BackingPhotoID* editable_id,
                       BackingPhotoID* develop_shotwell,
                       BackingPhotoID* develop_camera_id,
                       BackingPhotoID* develop_embedded_id,
                       PhotoID* result)
{
	PhotoRow* original = NULL;
	PhotoID _tmp0_;
	PhotoRow* _tmp1_;
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp2_;
	sqlite3_stmt* _tmp3_ = NULL;
	gint _tmp4_;
	gint _tmp5_;
	sqlite3_stmt* _tmp6_;
	gchar* _tmp7_;
	GDestroyNotify _tmp8_;
	gint _tmp9_;
	sqlite3_stmt* _tmp10_;
	PhotoRow* _tmp11_;
	BackingPhotoRow* _tmp12_;
	Dimensions _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
	sqlite3_stmt* _tmp16_;
	PhotoRow* _tmp17_;
	BackingPhotoRow* _tmp18_;
	Dimensions _tmp19_;
	gint _tmp20_;
	gint _tmp21_;
	sqlite3_stmt* _tmp22_;
	PhotoRow* _tmp23_;
	BackingPhotoRow* _tmp24_;
	gint64 _tmp25_;
	gint _tmp26_;
	sqlite3_stmt* _tmp27_;
	PhotoRow* _tmp28_;
	BackingPhotoRow* _tmp29_;
	time_t _tmp30_;
	gint _tmp31_;
	sqlite3_stmt* _tmp32_;
	PhotoRow* _tmp33_;
	time_t _tmp34_;
	gint _tmp35_;
	sqlite3_stmt* _tmp36_;
	PhotoRow* _tmp37_;
	Orientation _tmp38_;
	gint _tmp39_;
	sqlite3_stmt* _tmp40_;
	PhotoRow* _tmp41_;
	BackingPhotoRow* _tmp42_;
	Orientation _tmp43_;
	gint _tmp44_;
	sqlite3_stmt* _tmp45_;
	PhotoRow* _tmp46_;
	ImportID _tmp47_;
	gint64 _tmp48_;
	gint _tmp49_;
	sqlite3_stmt* _tmp50_;
	PhotoRow* _tmp51_;
	EventID _tmp52_;
	gint64 _tmp53_;
	gint _tmp54_;
	sqlite3_stmt* _tmp55_;
	PhotoRow* _tmp56_;
	GeeHashMap* _tmp57_;
	gchar* _tmp58_;
	GDestroyNotify _tmp59_;
	gint _tmp60_;
	sqlite3_stmt* _tmp61_;
	PhotoRow* _tmp62_;
	const gchar* _tmp63_;
	gchar* _tmp64_;
	GDestroyNotify _tmp65_;
	gint _tmp66_;
	sqlite3_stmt* _tmp67_;
	PhotoRow* _tmp68_;
	const gchar* _tmp69_;
	gchar* _tmp70_;
	GDestroyNotify _tmp71_;
	gint _tmp72_;
	sqlite3_stmt* _tmp73_;
	PhotoRow* _tmp74_;
	const gchar* _tmp75_;
	gchar* _tmp76_;
	GDestroyNotify _tmp77_;
	gint _tmp78_;
	sqlite3_stmt* _tmp79_;
	gint _tmp80_;
	sqlite3_stmt* _tmp81_;
	PhotoRow* _tmp82_;
	guint64 _tmp83_;
	gint _tmp84_;
	sqlite3_stmt* _tmp85_;
	PhotoRow* _tmp86_;
	Rating _tmp87_;
	gint _tmp88_;
	sqlite3_stmt* _tmp89_;
	PhotoRow* _tmp90_;
	BackingPhotoRow* _tmp91_;
	PhotoFileFormat _tmp92_;
	gint _tmp93_;
	sqlite3_stmt* _tmp94_;
	PhotoRow* _tmp95_;
	const gchar* _tmp96_;
	gchar* _tmp97_;
	GDestroyNotify _tmp98_;
	gint _tmp99_;
	sqlite3_stmt* _tmp100_;
	BackingPhotoID _tmp101_;
	gint64 _tmp102_;
	gint _tmp103_;
	sqlite3_stmt* _tmp104_;
	PhotoRow* _tmp105_;
	RawDeveloper _tmp106_;
	gchar* _tmp107_;
	GDestroyNotify _tmp108_;
	gint _tmp109_;
	sqlite3_stmt* _tmp110_;
	BackingPhotoID _tmp111_;
	gint64 _tmp112_;
	gint _tmp113_;
	sqlite3_stmt* _tmp114_;
	BackingPhotoID _tmp115_;
	gint64 _tmp116_;
	gint _tmp117_;
	sqlite3_stmt* _tmp118_;
	BackingPhotoID _tmp119_;
	gint64 _tmp120_;
	gint _tmp121_;
	sqlite3_stmt* _tmp122_;
	PhotoRow* _tmp123_;
	const gchar* _tmp124_;
	gchar* _tmp125_;
	GDestroyNotify _tmp126_;
	gint _tmp127_;
	sqlite3_stmt* _tmp128_;
	gint _tmp129_;
	sqlite3* _tmp133_;
	PhotoID _tmp134_ = {0};
#line 493 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_if_fail (IS_PHOTO_TABLE (self));
#line 493 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_if_fail (photo_id != NULL);
#line 493 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_if_fail (new_filename != NULL);
#line 493 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_if_fail (editable_id != NULL);
#line 493 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_if_fail (develop_shotwell != NULL);
#line 493 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_if_fail (develop_camera_id != NULL);
#line 493 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_if_fail (develop_embedded_id != NULL);
#line 497 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp0_ = *photo_id;
#line 497 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp1_ = photo_table_get_row (self, &_tmp0_);
#line 497 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	original = _tmp1_;
#line 500 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp2_ = database_table_db;
#line 500 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp4_ = sqlite3_prepare_v2 (_tmp2_, "INSERT INTO PhotoTable (filename, width, height, filesize, " "timestamp, exposure_time, orientation, original_orientation, import_id" \
", event_id, " "transformations, md5, thumbnail_md5, exif_md5, time_created, flags, ra" \
"ting, " "file_format, title, editable_id, developer, develop_shotwell_id, devel" \
"op_camera_id, " "develop_embedded_id, comment) " "VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?," \
" ?, ?, ?, ?)", -1, &_tmp3_, NULL);
#line 500 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_sqlite3_finalize0 (stmt);
#line 500 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	stmt = _tmp3_;
#line 500 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp4_;
#line 507 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp5_ = res;
#line 507 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp5_ == SQLITE_OK, "res == Sqlite.OK");
#line 509 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp6_ = stmt;
#line 509 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp7_ = g_strdup (new_filename);
#line 509 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp8_ = g_free;
#line 509 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = sqlite3_bind_text (_tmp6_, 1, _tmp7_, -1, _tmp8_);
#line 510 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp9_ = res;
#line 510 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp9_ == SQLITE_OK, "res == Sqlite.OK");
#line 511 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp10_ = stmt;
#line 511 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp11_ = original;
#line 511 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp12_ = _tmp11_->master;
#line 511 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp13_ = _tmp12_->dim;
#line 511 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp14_ = _tmp13_.width;
#line 511 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = sqlite3_bind_int (_tmp10_, 2, _tmp14_);
#line 512 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp15_ = res;
#line 512 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp15_ == SQLITE_OK, "res == Sqlite.OK");
#line 513 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp16_ = stmt;
#line 513 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp17_ = original;
#line 513 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp18_ = _tmp17_->master;
#line 513 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp19_ = _tmp18_->dim;
#line 513 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp20_ = _tmp19_.height;
#line 513 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = sqlite3_bind_int (_tmp16_, 3, _tmp20_);
#line 514 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp21_ = res;
#line 514 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp21_ == SQLITE_OK, "res == Sqlite.OK");
#line 515 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp22_ = stmt;
#line 515 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp23_ = original;
#line 515 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp24_ = _tmp23_->master;
#line 515 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp25_ = _tmp24_->filesize;
#line 515 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = sqlite3_bind_int64 (_tmp22_, 4, _tmp25_);
#line 516 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp26_ = res;
#line 516 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp26_ == SQLITE_OK, "res == Sqlite.OK");
#line 517 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp27_ = stmt;
#line 517 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp28_ = original;
#line 517 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp29_ = _tmp28_->master;
#line 517 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp30_ = _tmp29_->timestamp;
#line 517 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = sqlite3_bind_int64 (_tmp27_, 5, (gint64) _tmp30_);
#line 518 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp31_ = res;
#line 518 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp31_ == SQLITE_OK, "res == Sqlite.OK");
#line 519 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp32_ = stmt;
#line 519 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp33_ = original;
#line 519 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp34_ = _tmp33_->exposure_time;
#line 519 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = sqlite3_bind_int64 (_tmp32_, 6, (gint64) _tmp34_);
#line 520 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp35_ = res;
#line 520 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp35_ == SQLITE_OK, "res == Sqlite.OK");
#line 521 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp36_ = stmt;
#line 521 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp37_ = original;
#line 521 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp38_ = _tmp37_->orientation;
#line 521 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = sqlite3_bind_int (_tmp36_, 7, (gint) _tmp38_);
#line 522 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp39_ = res;
#line 522 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp39_ == SQLITE_OK, "res == Sqlite.OK");
#line 523 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp40_ = stmt;
#line 523 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp41_ = original;
#line 523 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp42_ = _tmp41_->master;
#line 523 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp43_ = _tmp42_->original_orientation;
#line 523 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = sqlite3_bind_int (_tmp40_, 8, (gint) _tmp43_);
#line 524 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp44_ = res;
#line 524 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp44_ == SQLITE_OK, "res == Sqlite.OK");
#line 525 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp45_ = stmt;
#line 525 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp46_ = original;
#line 525 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp47_ = _tmp46_->import_id;
#line 525 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp48_ = _tmp47_.id;
#line 525 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = sqlite3_bind_int64 (_tmp45_, 9, _tmp48_);
#line 526 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp49_ = res;
#line 526 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp49_ == SQLITE_OK, "res == Sqlite.OK");
#line 527 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp50_ = stmt;
#line 527 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp51_ = original;
#line 527 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp52_ = _tmp51_->event_id;
#line 527 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp53_ = _tmp52_.id;
#line 527 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = sqlite3_bind_int64 (_tmp50_, 10, _tmp53_);
#line 528 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp54_ = res;
#line 528 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp54_ == SQLITE_OK, "res == Sqlite.OK");
#line 529 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp55_ = stmt;
#line 529 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp56_ = original;
#line 529 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp57_ = _tmp56_->transformations;
#line 529 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp58_ = photo_table_unmarshall_all_transformations (_tmp57_);
#line 529 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp59_ = g_free;
#line 529 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = sqlite3_bind_text (_tmp55_, 11, _tmp58_, -1, _tmp59_);
#line 530 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp60_ = res;
#line 530 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp60_ == SQLITE_OK, "res == Sqlite.OK");
#line 531 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp61_ = stmt;
#line 531 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp62_ = original;
#line 531 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp63_ = _tmp62_->md5;
#line 531 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp64_ = g_strdup (_tmp63_);
#line 531 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp65_ = g_free;
#line 531 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = sqlite3_bind_text (_tmp61_, 12, _tmp64_, -1, _tmp65_);
#line 532 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp66_ = res;
#line 532 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp66_ == SQLITE_OK, "res == Sqlite.OK");
#line 533 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp67_ = stmt;
#line 533 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp68_ = original;
#line 533 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp69_ = _tmp68_->thumbnail_md5;
#line 533 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp70_ = g_strdup (_tmp69_);
#line 533 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp71_ = g_free;
#line 533 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = sqlite3_bind_text (_tmp67_, 13, _tmp70_, -1, _tmp71_);
#line 534 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp72_ = res;
#line 534 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp72_ == SQLITE_OK, "res == Sqlite.OK");
#line 535 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp73_ = stmt;
#line 535 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp74_ = original;
#line 535 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp75_ = _tmp74_->exif_md5;
#line 535 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp76_ = g_strdup (_tmp75_);
#line 535 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp77_ = g_free;
#line 535 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = sqlite3_bind_text (_tmp73_, 14, _tmp76_, -1, _tmp77_);
#line 536 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp78_ = res;
#line 536 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp78_ == SQLITE_OK, "res == Sqlite.OK");
#line 537 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp79_ = stmt;
#line 537 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = sqlite3_bind_int64 (_tmp79_, 15, (gint64) now_sec ());
#line 538 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp80_ = res;
#line 538 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp80_ == SQLITE_OK, "res == Sqlite.OK");
#line 539 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp81_ = stmt;
#line 539 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp82_ = original;
#line 539 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp83_ = _tmp82_->flags;
#line 539 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = sqlite3_bind_int64 (_tmp81_, 16, (gint64) _tmp83_);
#line 540 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp84_ = res;
#line 540 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp84_ == SQLITE_OK, "res == Sqlite.OK");
#line 541 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp85_ = stmt;
#line 541 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp86_ = original;
#line 541 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp87_ = _tmp86_->rating;
#line 541 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = sqlite3_bind_int64 (_tmp85_, 17, (gint64) rating_serialize (_tmp87_));
#line 542 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp88_ = res;
#line 542 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp88_ == SQLITE_OK, "res == Sqlite.OK");
#line 543 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp89_ = stmt;
#line 543 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp90_ = original;
#line 543 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp91_ = _tmp90_->master;
#line 543 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp92_ = _tmp91_->file_format;
#line 543 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = sqlite3_bind_int (_tmp89_, 18, photo_file_format_serialize (_tmp92_));
#line 544 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp93_ = res;
#line 544 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp93_ == SQLITE_OK, "res == Sqlite.OK");
#line 545 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp94_ = stmt;
#line 545 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp95_ = original;
#line 545 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp96_ = _tmp95_->title;
#line 545 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp97_ = g_strdup (_tmp96_);
#line 545 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp98_ = g_free;
#line 545 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = sqlite3_bind_text (_tmp94_, 19, _tmp97_, -1, _tmp98_);
#line 546 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp99_ = res;
#line 546 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp99_ == SQLITE_OK, "res == Sqlite.OK");
#line 547 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp100_ = stmt;
#line 547 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp101_ = *editable_id;
#line 547 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp102_ = _tmp101_.id;
#line 547 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = sqlite3_bind_int64 (_tmp100_, 20, _tmp102_);
#line 548 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp103_ = res;
#line 548 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp103_ == SQLITE_OK, "res == Sqlite.OK");
#line 550 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp104_ = stmt;
#line 550 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp105_ = original;
#line 550 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp106_ = _tmp105_->developer;
#line 550 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp107_ = raw_developer_to_string (_tmp106_);
#line 550 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp108_ = g_free;
#line 550 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = sqlite3_bind_text (_tmp104_, 21, _tmp107_, -1, _tmp108_);
#line 551 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp109_ = res;
#line 551 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp109_ == SQLITE_OK, "res == Sqlite.OK");
#line 552 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp110_ = stmt;
#line 552 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp111_ = *develop_shotwell;
#line 552 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp112_ = _tmp111_.id;
#line 552 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = sqlite3_bind_int64 (_tmp110_, 22, _tmp112_);
#line 553 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp113_ = res;
#line 553 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp113_ == SQLITE_OK, "res == Sqlite.OK");
#line 554 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp114_ = stmt;
#line 554 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp115_ = *develop_camera_id;
#line 554 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp116_ = _tmp115_.id;
#line 554 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = sqlite3_bind_int64 (_tmp114_, 23, _tmp116_);
#line 555 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp117_ = res;
#line 555 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp117_ == SQLITE_OK, "res == Sqlite.OK");
#line 556 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp118_ = stmt;
#line 556 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp119_ = *develop_embedded_id;
#line 556 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp120_ = _tmp119_.id;
#line 556 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = sqlite3_bind_int64 (_tmp118_, 24, _tmp120_);
#line 557 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp121_ = res;
#line 557 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp121_ == SQLITE_OK, "res == Sqlite.OK");
#line 558 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp122_ = stmt;
#line 558 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp123_ = original;
#line 558 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp124_ = _tmp123_->comment;
#line 558 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp125_ = g_strdup (_tmp124_);
#line 558 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp126_ = g_free;
#line 558 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = sqlite3_bind_text (_tmp122_, 25, _tmp125_, -1, _tmp126_);
#line 559 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp127_ = res;
#line 559 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp127_ == SQLITE_OK, "res == Sqlite.OK");
#line 561 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp128_ = stmt;
#line 561 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = sqlite3_step (_tmp128_);
#line 562 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp129_ = res;
#line 562 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (_tmp129_ != SQLITE_DONE) {
#line 4021 "PhotoTable.c"
		gint _tmp130_;
		PhotoID _tmp132_ = {0};
#line 563 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp130_ = res;
#line 563 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		if (_tmp130_ != SQLITE_CONSTRAINT) {
#line 4028 "PhotoTable.c"
			gint _tmp131_;
#line 564 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_tmp131_ = res;
#line 564 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			database_table_fatal ("duplicate", _tmp131_);
#line 4034 "PhotoTable.c"
		}
#line 566 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		photo_id_init (&_tmp132_, PHOTO_ID_INVALID);
#line 566 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		*result = _tmp132_;
#line 566 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_sqlite3_finalize0 (stmt);
#line 566 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_photo_row_unref0 (original);
#line 566 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		return;
#line 4046 "PhotoTable.c"
	}
#line 569 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp133_ = database_table_db;
#line 569 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	photo_id_init (&_tmp134_, sqlite3_last_insert_rowid (_tmp133_));
#line 569 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	*result = _tmp134_;
#line 569 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_sqlite3_finalize0 (stmt);
#line 569 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_photo_row_unref0 (original);
#line 569 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	return;
#line 4060 "PhotoTable.c"
}


gboolean
photo_table_set_title (PhotoTable* self,
                       PhotoID* photo_id,
                       const gchar* new_title)
{
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	PhotoID _tmp1_;
	gint64 _tmp2_;
#line 572 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_val_if_fail (IS_PHOTO_TABLE (self), FALSE);
#line 572 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_val_if_fail (photo_id != NULL, FALSE);
#line 573 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (new_title != NULL) {
#line 573 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp0_ = new_title;
#line 4081 "PhotoTable.c"
	} else {
#line 573 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp0_ = "";
#line 4085 "PhotoTable.c"
	}
#line 573 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp1_ = *photo_id;
#line 573 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp2_ = _tmp1_.id;
#line 573 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	result = database_table_update_text_by_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_TABLE, DatabaseTable), _tmp2_, "title", _tmp0_);
#line 573 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	return result;
#line 4095 "PhotoTable.c"
}


gboolean
photo_table_set_comment (PhotoTable* self,
                         PhotoID* photo_id,
                         const gchar* new_comment)
{
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	PhotoID _tmp1_;
	gint64 _tmp2_;
#line 576 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_val_if_fail (IS_PHOTO_TABLE (self), FALSE);
#line 576 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_val_if_fail (photo_id != NULL, FALSE);
#line 577 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (new_comment != NULL) {
#line 577 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp0_ = new_comment;
#line 4116 "PhotoTable.c"
	} else {
#line 577 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp0_ = "";
#line 4120 "PhotoTable.c"
	}
#line 577 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp1_ = *photo_id;
#line 577 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp2_ = _tmp1_.id;
#line 577 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	result = database_table_update_text_by_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_TABLE, DatabaseTable), _tmp2_, "comment", _tmp0_);
#line 577 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	return result;
#line 4130 "PhotoTable.c"
}


void
photo_table_set_filepath (PhotoTable* self,
                          PhotoID* photo_id,
                          const gchar* filepath,
                          GError** error)
{
	PhotoID _tmp0_;
	gint64 _tmp1_;
	GError * _inner_error_ = NULL;
#line 580 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_if_fail (IS_PHOTO_TABLE (self));
#line 580 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_if_fail (photo_id != NULL);
#line 580 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_if_fail (filepath != NULL);
#line 581 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp0_ = *photo_id;
#line 581 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp1_ = _tmp0_.id;
#line 581 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	database_table_update_text_by_id_2 (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_TABLE, DatabaseTable), _tmp1_, "filename", filepath, &_inner_error_);
#line 581 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 581 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		if (_inner_error_->domain == DATABASE_ERROR) {
#line 581 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			g_propagate_error (error, _inner_error_);
#line 581 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			return;
#line 4163 "PhotoTable.c"
		} else {
#line 581 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 581 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			g_clear_error (&_inner_error_);
#line 581 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			return;
#line 4171 "PhotoTable.c"
		}
	}
}


void
photo_table_update_timestamp (PhotoTable* self,
                              PhotoID* photo_id,
                              time_t timestamp,
                              GError** error)
{
	PhotoID _tmp0_;
	gint64 _tmp1_;
	GError * _inner_error_ = NULL;
#line 584 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_if_fail (IS_PHOTO_TABLE (self));
#line 584 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_if_fail (photo_id != NULL);
#line 585 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp0_ = *photo_id;
#line 585 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp1_ = _tmp0_.id;
#line 585 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	database_table_update_int64_by_id_2 (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_TABLE, DatabaseTable), _tmp1_, "timestamp", (gint64) timestamp, &_inner_error_);
#line 585 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 585 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		if (_inner_error_->domain == DATABASE_ERROR) {
#line 585 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			g_propagate_error (error, _inner_error_);
#line 585 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			return;
#line 4204 "PhotoTable.c"
		} else {
#line 585 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 585 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			g_clear_error (&_inner_error_);
#line 585 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			return;
#line 4212 "PhotoTable.c"
		}
	}
}


gboolean
photo_table_set_exposure_time (PhotoTable* self,
                               PhotoID* photo_id,
                               time_t time)
{
	gboolean result = FALSE;
	PhotoID _tmp0_;
	gint64 _tmp1_;
#line 588 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_val_if_fail (IS_PHOTO_TABLE (self), FALSE);
#line 588 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_val_if_fail (photo_id != NULL, FALSE);
#line 589 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp0_ = *photo_id;
#line 589 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp1_ = _tmp0_.id;
#line 589 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	result = database_table_update_int64_by_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_TABLE, DatabaseTable), _tmp1_, "exposure_time", (gint64) time);
#line 589 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	return result;
#line 4238 "PhotoTable.c"
}


void
photo_table_set_import_id (PhotoTable* self,
                           PhotoID* photo_id,
                           ImportID* import_id,
                           GError** error)
{
	PhotoID _tmp0_;
	gint64 _tmp1_;
	ImportID _tmp2_;
	gint64 _tmp3_;
	GError * _inner_error_ = NULL;
#line 592 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_if_fail (IS_PHOTO_TABLE (self));
#line 592 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_if_fail (photo_id != NULL);
#line 592 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_if_fail (import_id != NULL);
#line 593 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp0_ = *photo_id;
#line 593 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp1_ = _tmp0_.id;
#line 593 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp2_ = *import_id;
#line 593 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp3_ = _tmp2_.id;
#line 593 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	database_table_update_int64_by_id_2 (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_TABLE, DatabaseTable), _tmp1_, "import_id", _tmp3_, &_inner_error_);
#line 593 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 593 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		if (_inner_error_->domain == DATABASE_ERROR) {
#line 593 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			g_propagate_error (error, _inner_error_);
#line 593 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			return;
#line 4277 "PhotoTable.c"
		} else {
#line 593 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 593 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			g_clear_error (&_inner_error_);
#line 593 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			return;
#line 4285 "PhotoTable.c"
		}
	}
}


gboolean
photo_table_remove_by_file (PhotoTable* self,
                            GFile* file)
{
	gboolean result = FALSE;
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_;
	sqlite3_stmt* _tmp1_ = NULL;
	gint _tmp2_;
	gint _tmp3_;
	sqlite3_stmt* _tmp4_;
	gchar* _tmp5_;
	GDestroyNotify _tmp6_;
	gint _tmp7_;
	sqlite3_stmt* _tmp8_;
	gint _tmp9_;
#line 596 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_val_if_fail (IS_PHOTO_TABLE (self), FALSE);
#line 596 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_val_if_fail (G_IS_FILE (file), FALSE);
#line 598 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp0_ = database_table_db;
#line 598 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp2_ = sqlite3_prepare_v2 (_tmp0_, "DELETE FROM PhotoTable WHERE filename=?", -1, &_tmp1_, NULL);
#line 598 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_sqlite3_finalize0 (stmt);
#line 598 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	stmt = _tmp1_;
#line 598 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp2_;
#line 599 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp3_ = res;
#line 599 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp3_ == SQLITE_OK, "res == Sqlite.OK");
#line 601 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp4_ = stmt;
#line 601 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp5_ = g_file_get_path (file);
#line 601 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp6_ = g_free;
#line 601 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = sqlite3_bind_text (_tmp4_, 1, _tmp5_, -1, _tmp6_);
#line 602 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp7_ = res;
#line 602 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp7_ == SQLITE_OK, "res == Sqlite.OK");
#line 604 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp8_ = stmt;
#line 604 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = sqlite3_step (_tmp8_);
#line 605 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp9_ = res;
#line 605 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (_tmp9_ != SQLITE_DONE) {
#line 4346 "PhotoTable.c"
		gint _tmp10_;
#line 606 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp10_ = res;
#line 606 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		database_table_warning ("remove", _tmp10_);
#line 608 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		result = FALSE;
#line 608 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_sqlite3_finalize0 (stmt);
#line 608 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		return result;
#line 4358 "PhotoTable.c"
	}
#line 611 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	result = TRUE;
#line 611 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_sqlite3_finalize0 (stmt);
#line 611 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	return result;
#line 4366 "PhotoTable.c"
}


void
photo_table_remove (PhotoTable* self,
                    PhotoID* photo_id,
                    GError** error)
{
	PhotoID _tmp0_;
	gint64 _tmp1_;
	GError * _inner_error_ = NULL;
#line 614 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_if_fail (IS_PHOTO_TABLE (self));
#line 614 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_if_fail (photo_id != NULL);
#line 615 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp0_ = *photo_id;
#line 615 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp1_ = _tmp0_.id;
#line 615 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	database_table_delete_by_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_TABLE, DatabaseTable), _tmp1_, &_inner_error_);
#line 615 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 615 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		if (_inner_error_->domain == DATABASE_ERROR) {
#line 615 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			g_propagate_error (error, _inner_error_);
#line 615 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			return;
#line 4396 "PhotoTable.c"
		} else {
#line 615 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 615 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			g_clear_error (&_inner_error_);
#line 615 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			return;
#line 4404 "PhotoTable.c"
		}
	}
}


GeeArrayList*
photo_table_get_photos (PhotoTable* self)
{
	GeeArrayList* result = NULL;
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_;
	sqlite3_stmt* _tmp1_ = NULL;
	gint _tmp2_;
	gint _tmp3_;
	GeeArrayList* photo_ids = NULL;
	GeeArrayList* _tmp4_;
#line 618 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_val_if_fail (IS_PHOTO_TABLE (self), NULL);
#line 620 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp0_ = database_table_db;
#line 620 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp2_ = sqlite3_prepare_v2 (_tmp0_, "SELECT id FROM PhotoTable", -1, &_tmp1_, NULL);
#line 620 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_sqlite3_finalize0 (stmt);
#line 620 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	stmt = _tmp1_;
#line 620 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp2_;
#line 621 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp3_ = res;
#line 621 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp3_ == SQLITE_OK, "res == Sqlite.OK");
#line 623 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp4_ = gee_array_list_new (TYPE_PHOTO_ID, (GBoxedCopyFunc) photo_id_dup, (GDestroyNotify) photo_id_free, NULL, NULL, NULL);
#line 623 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	photo_ids = _tmp4_;
#line 4442 "PhotoTable.c"
	{
		gboolean _tmp5_ = FALSE;
#line 624 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp5_ = TRUE;
#line 624 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		while (TRUE) {
#line 4449 "PhotoTable.c"
			sqlite3_stmt* _tmp6_;
			gint _tmp7_;
			GeeArrayList* _tmp10_;
			sqlite3_stmt* _tmp11_;
			PhotoID _tmp12_ = {0};
#line 624 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			if (!_tmp5_) {
#line 4457 "PhotoTable.c"
			}
#line 624 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_tmp5_ = FALSE;
#line 625 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_tmp6_ = stmt;
#line 625 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			res = sqlite3_step (_tmp6_);
#line 626 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_tmp7_ = res;
#line 626 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			if (_tmp7_ == SQLITE_DONE) {
#line 627 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				break;
#line 4471 "PhotoTable.c"
			} else {
				gint _tmp8_;
#line 628 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				_tmp8_ = res;
#line 628 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				if (_tmp8_ != SQLITE_ROW) {
#line 4478 "PhotoTable.c"
					gint _tmp9_;
#line 629 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
					_tmp9_ = res;
#line 629 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
					database_table_fatal ("get_photos", _tmp9_);
#line 631 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
					break;
#line 4486 "PhotoTable.c"
				}
			}
#line 634 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_tmp10_ = photo_ids;
#line 634 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_tmp11_ = stmt;
#line 634 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			photo_id_init (&_tmp12_, sqlite3_column_int64 (_tmp11_, 0));
#line 634 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), &_tmp12_);
#line 4497 "PhotoTable.c"
		}
	}
#line 637 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	result = photo_ids;
#line 637 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_sqlite3_finalize0 (stmt);
#line 637 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	return result;
#line 4506 "PhotoTable.c"
}


gboolean
photo_table_set_orientation (PhotoTable* self,
                             PhotoID* photo_id,
                             Orientation orientation)
{
	gboolean result = FALSE;
	PhotoID _tmp0_;
	gint64 _tmp1_;
#line 640 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_val_if_fail (IS_PHOTO_TABLE (self), FALSE);
#line 640 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_val_if_fail (photo_id != NULL, FALSE);
#line 641 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp0_ = *photo_id;
#line 641 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp1_ = _tmp0_.id;
#line 641 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	result = database_table_update_int_by_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_TABLE, DatabaseTable), _tmp1_, "orientation", (gint) orientation);
#line 641 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	return result;
#line 4530 "PhotoTable.c"
}


gboolean
photo_table_replace_flags (PhotoTable* self,
                           PhotoID* photo_id,
                           guint64 flags)
{
	gboolean result = FALSE;
	PhotoID _tmp0_;
	gint64 _tmp1_;
#line 644 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_val_if_fail (IS_PHOTO_TABLE (self), FALSE);
#line 644 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_val_if_fail (photo_id != NULL, FALSE);
#line 645 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp0_ = *photo_id;
#line 645 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp1_ = _tmp0_.id;
#line 645 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	result = database_table_update_int64_by_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_TABLE, DatabaseTable), _tmp1_, "flags", (gint64) flags);
#line 645 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	return result;
#line 4554 "PhotoTable.c"
}


gboolean
photo_table_set_rating (PhotoTable* self,
                        PhotoID* photo_id,
                        Rating rating)
{
	gboolean result = FALSE;
	PhotoID _tmp0_;
	gint64 _tmp1_;
#line 648 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_val_if_fail (IS_PHOTO_TABLE (self), FALSE);
#line 648 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_val_if_fail (photo_id != NULL, FALSE);
#line 649 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp0_ = *photo_id;
#line 649 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp1_ = _tmp0_.id;
#line 649 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	result = database_table_update_int_by_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_TABLE, DatabaseTable), _tmp1_, "rating", rating_serialize (rating));
#line 649 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	return result;
#line 4578 "PhotoTable.c"
}


gint
photo_table_get_event_photo_count (PhotoTable* self,
                                   EventID* event_id)
{
	gint result = 0;
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_;
	sqlite3_stmt* _tmp1_ = NULL;
	gint _tmp2_;
	gint _tmp3_;
	sqlite3_stmt* _tmp4_;
	EventID _tmp5_;
	gint64 _tmp6_;
	gint _tmp7_;
	gint count = 0;
#line 652 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_val_if_fail (IS_PHOTO_TABLE (self), 0);
#line 652 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_val_if_fail (event_id != NULL, 0);
#line 654 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp0_ = database_table_db;
#line 654 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp2_ = sqlite3_prepare_v2 (_tmp0_, "SELECT id FROM PhotoTable WHERE event_id = ?", -1, &_tmp1_, NULL);
#line 654 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_sqlite3_finalize0 (stmt);
#line 654 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	stmt = _tmp1_;
#line 654 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp2_;
#line 655 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp3_ = res;
#line 655 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp3_ == SQLITE_OK, "res == Sqlite.OK");
#line 657 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp4_ = stmt;
#line 657 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp5_ = *event_id;
#line 657 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp6_ = _tmp5_.id;
#line 657 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = sqlite3_bind_int64 (_tmp4_, 1, _tmp6_);
#line 658 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp7_ = res;
#line 658 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp7_ == SQLITE_OK, "res == Sqlite.OK");
#line 660 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	count = 0;
#line 4630 "PhotoTable.c"
	{
		gboolean _tmp8_ = FALSE;
#line 661 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp8_ = TRUE;
#line 661 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		while (TRUE) {
#line 4637 "PhotoTable.c"
			sqlite3_stmt* _tmp9_;
			gint _tmp10_;
			gint _tmp13_;
#line 661 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			if (!_tmp8_) {
#line 4643 "PhotoTable.c"
			}
#line 661 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_tmp8_ = FALSE;
#line 662 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_tmp9_ = stmt;
#line 662 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			res = sqlite3_step (_tmp9_);
#line 663 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_tmp10_ = res;
#line 663 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			if (_tmp10_ == SQLITE_DONE) {
#line 664 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				break;
#line 4657 "PhotoTable.c"
			} else {
				gint _tmp11_;
#line 665 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				_tmp11_ = res;
#line 665 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				if (_tmp11_ != SQLITE_ROW) {
#line 4664 "PhotoTable.c"
					gint _tmp12_;
#line 666 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
					_tmp12_ = res;
#line 666 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
					database_table_fatal ("get_event_photo_count", _tmp12_);
#line 668 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
					break;
#line 4672 "PhotoTable.c"
				}
			}
#line 671 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_tmp13_ = count;
#line 671 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			count = _tmp13_ + 1;
#line 4679 "PhotoTable.c"
		}
	}
#line 674 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	result = count;
#line 674 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_sqlite3_finalize0 (stmt);
#line 674 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	return result;
#line 4688 "PhotoTable.c"
}


GeeArrayList*
photo_table_get_event_source_ids (PhotoTable* self,
                                  EventID* event_id)
{
	GeeArrayList* result = NULL;
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_;
	sqlite3_stmt* _tmp1_ = NULL;
	gint _tmp2_;
	gint _tmp3_;
	sqlite3_stmt* _tmp4_;
	EventID _tmp5_;
	gint64 _tmp6_;
	gint _tmp7_;
	GeeArrayList* _result_ = NULL;
	GeeArrayList* _tmp8_;
#line 677 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_val_if_fail (IS_PHOTO_TABLE (self), NULL);
#line 677 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_val_if_fail (event_id != NULL, NULL);
#line 679 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp0_ = database_table_db;
#line 679 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp2_ = sqlite3_prepare_v2 (_tmp0_, "SELECT id FROM PhotoTable WHERE event_id = ?", -1, &_tmp1_, NULL);
#line 679 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_sqlite3_finalize0 (stmt);
#line 679 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	stmt = _tmp1_;
#line 679 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp2_;
#line 680 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp3_ = res;
#line 680 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp3_ == SQLITE_OK, "res == Sqlite.OK");
#line 682 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp4_ = stmt;
#line 682 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp5_ = *event_id;
#line 682 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp6_ = _tmp5_.id;
#line 682 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = sqlite3_bind_int64 (_tmp4_, 1, _tmp6_);
#line 683 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp7_ = res;
#line 683 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp7_ == SQLITE_OK, "res == Sqlite.OK");
#line 685 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp8_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
#line 685 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_result_ = _tmp8_;
#line 4743 "PhotoTable.c"
	{
		gboolean _tmp9_ = FALSE;
#line 686 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp9_ = TRUE;
#line 686 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		while (TRUE) {
#line 4750 "PhotoTable.c"
			sqlite3_stmt* _tmp10_;
			gint _tmp11_;
			GeeArrayList* _tmp14_;
			sqlite3_stmt* _tmp15_;
			PhotoID _tmp16_ = {0};
			gchar* _tmp17_;
			gchar* _tmp18_;
#line 686 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			if (!_tmp9_) {
#line 4760 "PhotoTable.c"
			}
#line 686 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_tmp9_ = FALSE;
#line 687 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_tmp10_ = stmt;
#line 687 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			res = sqlite3_step (_tmp10_);
#line 688 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_tmp11_ = res;
#line 688 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			if (_tmp11_ == SQLITE_DONE) {
#line 689 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				break;
#line 4774 "PhotoTable.c"
			} else {
				gint _tmp12_;
#line 690 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				_tmp12_ = res;
#line 690 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				if (_tmp12_ != SQLITE_ROW) {
#line 4781 "PhotoTable.c"
					gint _tmp13_;
#line 691 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
					_tmp13_ = res;
#line 691 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
					database_table_fatal ("get_event_source_ids", _tmp13_);
#line 693 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
					break;
#line 4789 "PhotoTable.c"
				}
			}
#line 696 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_tmp14_ = _result_;
#line 696 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_tmp15_ = stmt;
#line 696 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			photo_id_init (&_tmp16_, sqlite3_column_int64 (_tmp15_, 0));
#line 696 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_tmp17_ = photo_id_upgrade_photo_id_to_source_id (&_tmp16_);
#line 696 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_tmp18_ = _tmp17_;
#line 696 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp18_);
#line 696 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_g_free0 (_tmp18_);
#line 4806 "PhotoTable.c"
		}
	}
#line 699 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	result = _result_;
#line 699 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_sqlite3_finalize0 (stmt);
#line 699 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	return result;
#line 4815 "PhotoTable.c"
}


gboolean
photo_table_event_has_photos (PhotoTable* self,
                              EventID* event_id)
{
	gboolean result = FALSE;
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_;
	sqlite3_stmt* _tmp1_ = NULL;
	gint _tmp2_;
	gint _tmp3_;
	sqlite3_stmt* _tmp4_;
	EventID _tmp5_;
	gint64 _tmp6_;
	gint _tmp7_;
	sqlite3_stmt* _tmp8_;
	gint _tmp9_;
#line 702 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_val_if_fail (IS_PHOTO_TABLE (self), FALSE);
#line 702 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_val_if_fail (event_id != NULL, FALSE);
#line 704 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp0_ = database_table_db;
#line 704 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp2_ = sqlite3_prepare_v2 (_tmp0_, "SELECT id FROM PhotoTable WHERE event_id = ? LIMIT 1", -1, &_tmp1_, NULL);
#line 704 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_sqlite3_finalize0 (stmt);
#line 704 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	stmt = _tmp1_;
#line 704 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp2_;
#line 705 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp3_ = res;
#line 705 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp3_ == SQLITE_OK, "res == Sqlite.OK");
#line 707 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp4_ = stmt;
#line 707 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp5_ = *event_id;
#line 707 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp6_ = _tmp5_.id;
#line 707 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = sqlite3_bind_int64 (_tmp4_, 1, _tmp6_);
#line 708 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp7_ = res;
#line 708 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp7_ == SQLITE_OK, "res == Sqlite.OK");
#line 710 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp8_ = stmt;
#line 710 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = sqlite3_step (_tmp8_);
#line 711 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp9_ = res;
#line 711 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (_tmp9_ == SQLITE_DONE) {
#line 712 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		result = FALSE;
#line 712 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_sqlite3_finalize0 (stmt);
#line 712 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		return result;
#line 4880 "PhotoTable.c"
	} else {
		gint _tmp10_;
#line 713 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp10_ = res;
#line 713 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		if (_tmp10_ != SQLITE_ROW) {
#line 4887 "PhotoTable.c"
			gint _tmp11_;
#line 714 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_tmp11_ = res;
#line 714 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			database_table_fatal ("event_has_photos", _tmp11_);
#line 716 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			result = FALSE;
#line 716 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_sqlite3_finalize0 (stmt);
#line 716 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			return result;
#line 4899 "PhotoTable.c"
		}
	}
#line 719 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	result = TRUE;
#line 719 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_sqlite3_finalize0 (stmt);
#line 719 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	return result;
#line 4908 "PhotoTable.c"
}


gboolean
photo_table_drop_event (PhotoTable* self,
                        EventID* event_id)
{
	gboolean result = FALSE;
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_;
	sqlite3_stmt* _tmp1_ = NULL;
	gint _tmp2_;
	gint _tmp3_;
	sqlite3_stmt* _tmp4_;
	gint _tmp5_;
	sqlite3_stmt* _tmp6_;
	EventID _tmp7_;
	gint64 _tmp8_;
	gint _tmp9_;
	sqlite3_stmt* _tmp10_;
	gint _tmp11_;
#line 722 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_val_if_fail (IS_PHOTO_TABLE (self), FALSE);
#line 722 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_val_if_fail (event_id != NULL, FALSE);
#line 724 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp0_ = database_table_db;
#line 724 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp2_ = sqlite3_prepare_v2 (_tmp0_, "UPDATE PhotoTable SET event_id = ? WHERE event_id = ?", -1, &_tmp1_, NULL);
#line 724 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_sqlite3_finalize0 (stmt);
#line 724 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	stmt = _tmp1_;
#line 724 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp2_;
#line 725 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp3_ = res;
#line 725 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp3_ == SQLITE_OK, "res == Sqlite.OK");
#line 727 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp4_ = stmt;
#line 727 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = sqlite3_bind_int64 (_tmp4_, 1, EVENT_ID_INVALID);
#line 728 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp5_ = res;
#line 728 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp5_ == SQLITE_OK, "res == Sqlite.OK");
#line 729 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp6_ = stmt;
#line 729 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp7_ = *event_id;
#line 729 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp8_ = _tmp7_.id;
#line 729 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = sqlite3_bind_int64 (_tmp6_, 2, _tmp8_);
#line 730 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp9_ = res;
#line 730 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp9_ == SQLITE_OK, "res == Sqlite.OK");
#line 732 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp10_ = stmt;
#line 732 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = sqlite3_step (_tmp10_);
#line 733 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp11_ = res;
#line 733 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (_tmp11_ != SQLITE_DONE) {
#line 4977 "PhotoTable.c"
		gint _tmp12_;
#line 734 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp12_ = res;
#line 734 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		database_table_fatal ("drop_event", _tmp12_);
#line 736 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		result = FALSE;
#line 736 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_sqlite3_finalize0 (stmt);
#line 736 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		return result;
#line 4989 "PhotoTable.c"
	}
#line 739 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	result = TRUE;
#line 739 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_sqlite3_finalize0 (stmt);
#line 739 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	return result;
#line 4997 "PhotoTable.c"
}


gboolean
photo_table_set_event (PhotoTable* self,
                       PhotoID* photo_id,
                       EventID* event_id)
{
	gboolean result = FALSE;
	PhotoID _tmp0_;
	gint64 _tmp1_;
	EventID _tmp2_;
	gint64 _tmp3_;
#line 742 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_val_if_fail (IS_PHOTO_TABLE (self), FALSE);
#line 742 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_val_if_fail (photo_id != NULL, FALSE);
#line 742 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_val_if_fail (event_id != NULL, FALSE);
#line 743 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp0_ = *photo_id;
#line 743 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp1_ = _tmp0_.id;
#line 743 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp2_ = *event_id;
#line 743 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp3_ = _tmp2_.id;
#line 743 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	result = database_table_update_int64_by_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_TABLE, DatabaseTable), _tmp1_, "event_id", _tmp3_);
#line 743 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	return result;
#line 5029 "PhotoTable.c"
}


static gchar*
photo_table_get_raw_transformations (PhotoTable* self,
                                     PhotoID* photo_id)
{
	gchar* result = NULL;
	sqlite3_stmt* stmt = NULL;
	PhotoID _tmp0_;
	gint64 _tmp1_;
	sqlite3_stmt* _tmp2_ = NULL;
	gboolean _tmp3_;
	gchar* trans = NULL;
	sqlite3_stmt* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gboolean _tmp7_ = FALSE;
	const gchar* _tmp8_;
#line 746 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_val_if_fail (IS_PHOTO_TABLE (self), NULL);
#line 746 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_val_if_fail (photo_id != NULL, NULL);
#line 748 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp0_ = *photo_id;
#line 748 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp1_ = _tmp0_.id;
#line 748 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp3_ = database_table_select_by_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_TABLE, DatabaseTable), _tmp1_, "transformations", &_tmp2_);
#line 748 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_sqlite3_finalize0 (stmt);
#line 748 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	stmt = _tmp2_;
#line 748 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (!_tmp3_) {
#line 749 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		result = NULL;
#line 749 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_sqlite3_finalize0 (stmt);
#line 749 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		return result;
#line 5071 "PhotoTable.c"
	}
#line 751 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp4_ = stmt;
#line 751 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp5_ = sqlite3_column_text (_tmp4_, 0);
#line 751 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp6_ = g_strdup (_tmp5_);
#line 751 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	trans = _tmp6_;
#line 752 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp8_ = trans;
#line 752 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (_tmp8_ == NULL) {
#line 752 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp7_ = TRUE;
#line 5087 "PhotoTable.c"
	} else {
		const gchar* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
#line 752 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp9_ = trans;
#line 752 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp10_ = strlen (_tmp9_);
#line 752 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp11_ = _tmp10_;
#line 752 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp7_ = _tmp11_ == 0;
#line 5100 "PhotoTable.c"
	}
#line 752 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (_tmp7_) {
#line 753 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		result = NULL;
#line 753 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_g_free0 (trans);
#line 753 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_sqlite3_finalize0 (stmt);
#line 753 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		return result;
#line 5112 "PhotoTable.c"
	}
#line 755 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	result = trans;
#line 755 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_sqlite3_finalize0 (stmt);
#line 755 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	return result;
#line 5120 "PhotoTable.c"
}


static gboolean
photo_table_set_raw_transformations (PhotoTable* self,
                                     PhotoID* photo_id,
                                     const gchar* trans)
{
	gboolean result = FALSE;
	PhotoID _tmp0_;
	gint64 _tmp1_;
#line 758 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_val_if_fail (IS_PHOTO_TABLE (self), FALSE);
#line 758 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_val_if_fail (photo_id != NULL, FALSE);
#line 758 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_val_if_fail (trans != NULL, FALSE);
#line 759 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp0_ = *photo_id;
#line 759 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp1_ = _tmp0_.id;
#line 759 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	result = database_table_update_text_by_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_TABLE, DatabaseTable), _tmp1_, "transformations", trans);
#line 759 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	return result;
#line 5146 "PhotoTable.c"
}


gboolean
photo_table_set_transformation_state (PhotoTable* self,
                                      PhotoID* photo_id,
                                      Orientation orientation,
                                      GeeHashMap* transformations)
{
	gboolean result = FALSE;
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_;
	sqlite3_stmt* _tmp1_ = NULL;
	gint _tmp2_;
	gint _tmp3_;
	sqlite3_stmt* _tmp4_;
	gint _tmp5_;
	sqlite3_stmt* _tmp6_;
	gchar* _tmp7_;
	GDestroyNotify _tmp8_;
	gint _tmp9_;
	sqlite3_stmt* _tmp10_;
	PhotoID _tmp11_;
	gint64 _tmp12_;
	gint _tmp13_;
	sqlite3_stmt* _tmp14_;
	gint _tmp15_;
#line 762 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_val_if_fail (IS_PHOTO_TABLE (self), FALSE);
#line 762 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_val_if_fail (photo_id != NULL, FALSE);
#line 762 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_val_if_fail ((transformations == NULL) || GEE_IS_HASH_MAP (transformations), FALSE);
#line 765 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp0_ = database_table_db;
#line 765 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp2_ = sqlite3_prepare_v2 (_tmp0_, "UPDATE PhotoTable SET orientation = ?, transformations = ? WHERE id = " \
"?", -1, &_tmp1_, NULL);
#line 765 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_sqlite3_finalize0 (stmt);
#line 765 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	stmt = _tmp1_;
#line 765 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp2_;
#line 767 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp3_ = res;
#line 767 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp3_ == SQLITE_OK, "res == Sqlite.OK");
#line 769 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp4_ = stmt;
#line 769 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = sqlite3_bind_int (_tmp4_, 1, (gint) orientation);
#line 770 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp5_ = res;
#line 770 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp5_ == SQLITE_OK, "res == Sqlite.OK");
#line 771 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp6_ = stmt;
#line 771 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp7_ = photo_table_unmarshall_all_transformations (transformations);
#line 771 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp8_ = g_free;
#line 771 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = sqlite3_bind_text (_tmp6_, 2, _tmp7_, -1, _tmp8_);
#line 772 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp9_ = res;
#line 772 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp9_ == SQLITE_OK, "res == Sqlite.OK");
#line 773 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp10_ = stmt;
#line 773 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp11_ = *photo_id;
#line 773 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp12_ = _tmp11_.id;
#line 773 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = sqlite3_bind_int64 (_tmp10_, 3, _tmp12_);
#line 774 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp13_ = res;
#line 774 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp13_ == SQLITE_OK, "res == Sqlite.OK");
#line 776 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp14_ = stmt;
#line 776 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = sqlite3_step (_tmp14_);
#line 777 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp15_ = res;
#line 777 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (_tmp15_ != SQLITE_DONE) {
#line 5235 "PhotoTable.c"
		gint _tmp16_;
#line 778 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp16_ = res;
#line 778 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		database_table_fatal ("set_transformation_state", _tmp16_);
#line 780 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		result = FALSE;
#line 780 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_sqlite3_finalize0 (stmt);
#line 780 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		return result;
#line 5247 "PhotoTable.c"
	}
#line 783 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	result = TRUE;
#line 783 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_sqlite3_finalize0 (stmt);
#line 783 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	return result;
#line 5255 "PhotoTable.c"
}


GeeHashMap*
photo_table_marshall_all_transformations (const gchar* trans)
{
	GeeHashMap* result = NULL;
	gboolean _tmp0_ = FALSE;
	GError * _inner_error_ = NULL;
#line 787 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (trans == NULL) {
#line 787 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp0_ = TRUE;
#line 5269 "PhotoTable.c"
	} else {
		gint _tmp1_;
		gint _tmp2_;
#line 787 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp1_ = strlen (trans);
#line 787 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp2_ = _tmp1_;
#line 787 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp0_ = _tmp2_ == 0;
#line 5279 "PhotoTable.c"
	}
#line 787 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (_tmp0_) {
#line 788 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		result = NULL;
#line 788 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		return result;
#line 5287 "PhotoTable.c"
	}
	{
		GKeyFile* keyfile = NULL;
		GKeyFile* _tmp3_;
		gboolean _tmp4_ = FALSE;
		GKeyFile* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		GeeHashMap* map = NULL;
		GeeHashMap* _tmp8_;
		gchar** objects = NULL;
		GKeyFile* _tmp9_;
		gsize _tmp10_;
		gchar** _tmp11_;
		gint objects_length1;
		gint _objects_size_;
		gchar** _tmp12_;
		gint _tmp12__length1;
#line 791 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp3_ = g_key_file_new ();
#line 791 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		keyfile = _tmp3_;
#line 792 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp5_ = keyfile;
#line 792 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp6_ = strlen (trans);
#line 792 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp7_ = _tmp6_;
#line 792 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp4_ = g_key_file_load_from_data (_tmp5_, trans, (gsize) _tmp7_, G_KEY_FILE_NONE, &_inner_error_);
#line 792 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 792 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_g_key_file_unref0 (keyfile);
#line 5322 "PhotoTable.c"
			goto __catch17_g_error;
		}
#line 792 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		if (!_tmp4_) {
#line 793 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			result = NULL;
#line 793 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_g_key_file_unref0 (keyfile);
#line 793 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			return result;
#line 5333 "PhotoTable.c"
		}
#line 795 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp8_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, TYPE_KEY_VALUE_MAP, (GBoxedCopyFunc) key_value_map_ref, (GDestroyNotify) key_value_map_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 795 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		map = _tmp8_;
#line 797 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp9_ = keyfile;
#line 797 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp11_ = g_key_file_get_groups (_tmp9_, &_tmp10_);
#line 797 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		objects = _tmp11_;
#line 797 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		objects_length1 = _tmp10_;
#line 797 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_objects_size_ = objects_length1;
#line 798 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp12_ = objects;
#line 798 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp12__length1 = objects_length1;
#line 5353 "PhotoTable.c"
		{
			gchar** object_collection = NULL;
			gint object_collection_length1 = 0;
			gint _object_collection_size_ = 0;
			gint object_it = 0;
#line 798 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			object_collection = _tmp12_;
#line 798 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			object_collection_length1 = _tmp12__length1;
#line 798 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			for (object_it = 0; object_it < _tmp12__length1; object_it = object_it + 1) {
#line 5365 "PhotoTable.c"
				gchar* _tmp13_;
				gchar* object = NULL;
#line 798 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				_tmp13_ = g_strdup (object_collection[object_it]);
#line 798 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				object = _tmp13_;
#line 5372 "PhotoTable.c"
				{
					gchar** keys = NULL;
					GKeyFile* _tmp14_;
					const gchar* _tmp15_;
					gsize _tmp16_;
					gchar** _tmp17_;
					gint keys_length1;
					gint _keys_size_;
					gboolean _tmp18_ = FALSE;
					gchar** _tmp19_;
					gint _tmp19__length1;
					KeyValueMap* key_map = NULL;
					const gchar* _tmp21_;
					KeyValueMap* _tmp22_;
					GeeHashMap* _tmp38_;
					const gchar* _tmp39_;
					KeyValueMap* _tmp40_;
#line 799 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
					_tmp14_ = keyfile;
#line 799 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
					_tmp15_ = object;
#line 799 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
					_tmp17_ = g_key_file_get_keys (_tmp14_, _tmp15_, &_tmp16_, &_inner_error_);
#line 799 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
					keys = _tmp17_;
#line 799 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
					keys_length1 = _tmp16_;
#line 799 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
					_keys_size_ = keys_length1;
#line 799 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 799 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
						_g_free0 (object);
#line 799 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
						objects = (_vala_array_free (objects, objects_length1, (GDestroyNotify) g_free), NULL);
#line 799 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
						_g_object_unref0 (map);
#line 799 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
						_g_key_file_unref0 (keyfile);
#line 5412 "PhotoTable.c"
						goto __catch17_g_error;
					}
#line 800 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
					_tmp19_ = keys;
#line 800 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
					_tmp19__length1 = keys_length1;
#line 800 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
					if (_tmp19_ == NULL) {
#line 800 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
						_tmp18_ = TRUE;
#line 5423 "PhotoTable.c"
					} else {
						gchar** _tmp20_;
						gint _tmp20__length1;
#line 800 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
						_tmp20_ = keys;
#line 800 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
						_tmp20__length1 = keys_length1;
#line 800 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
						_tmp18_ = _tmp20__length1 == 0;
#line 5433 "PhotoTable.c"
					}
#line 800 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
					if (_tmp18_) {
#line 801 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
						keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
#line 801 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
						_g_free0 (object);
#line 801 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
						continue;
#line 5443 "PhotoTable.c"
					}
#line 803 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
					_tmp21_ = object;
#line 803 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
					_tmp22_ = key_value_map_new (_tmp21_);
#line 803 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
					key_map = _tmp22_;
#line 5451 "PhotoTable.c"
					{
						gint ctr = 0;
#line 804 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
						ctr = 0;
#line 5456 "PhotoTable.c"
						{
							gboolean _tmp23_ = FALSE;
#line 804 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
							_tmp23_ = TRUE;
#line 804 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
							while (TRUE) {
#line 5463 "PhotoTable.c"
								gint _tmp25_;
								gchar** _tmp26_;
								gint _tmp26__length1;
								gchar* _tmp27_ = NULL;
								GKeyFile* _tmp28_;
								const gchar* _tmp29_;
								gchar** _tmp30_;
								gint _tmp30__length1;
								gint _tmp31_;
								const gchar* _tmp32_;
								gchar* _tmp33_;
								KeyValueMap* _tmp34_;
								gchar** _tmp35_;
								gint _tmp35__length1;
								gint _tmp36_;
								const gchar* _tmp37_;
#line 804 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
								if (!_tmp23_) {
#line 5482 "PhotoTable.c"
									gint _tmp24_;
#line 804 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
									_tmp24_ = ctr;
#line 804 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
									ctr = _tmp24_ + 1;
#line 5488 "PhotoTable.c"
								}
#line 804 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
								_tmp23_ = FALSE;
#line 804 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
								_tmp25_ = ctr;
#line 804 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
								_tmp26_ = keys;
#line 804 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
								_tmp26__length1 = keys_length1;
#line 804 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
								if (!(_tmp25_ < _tmp26__length1)) {
#line 804 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
									break;
#line 5502 "PhotoTable.c"
								}
#line 805 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
								_tmp28_ = keyfile;
#line 805 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
								_tmp29_ = object;
#line 805 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
								_tmp30_ = keys;
#line 805 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
								_tmp30__length1 = keys_length1;
#line 805 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
								_tmp31_ = ctr;
#line 805 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
								_tmp32_ = _tmp30_[_tmp31_];
#line 805 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
								_tmp33_ = g_key_file_get_string (_tmp28_, _tmp29_, _tmp32_, &_inner_error_);
#line 805 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
								_tmp27_ = _tmp33_;
#line 805 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
								if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 805 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
									_key_value_map_unref0 (key_map);
#line 805 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
									keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
#line 805 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
									_g_free0 (object);
#line 805 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
									objects = (_vala_array_free (objects, objects_length1, (GDestroyNotify) g_free), NULL);
#line 805 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
									_g_object_unref0 (map);
#line 805 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
									_g_key_file_unref0 (keyfile);
#line 5534 "PhotoTable.c"
									goto __catch17_g_error;
								}
#line 805 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
								_tmp34_ = key_map;
#line 805 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
								_tmp35_ = keys;
#line 805 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
								_tmp35__length1 = keys_length1;
#line 805 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
								_tmp36_ = ctr;
#line 805 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
								_tmp37_ = _tmp35_[_tmp36_];
#line 805 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
								key_value_map_set_string (_tmp34_, _tmp37_, _tmp27_);
#line 804 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
								_g_free0 (_tmp27_);
#line 5551 "PhotoTable.c"
							}
						}
					}
#line 807 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
					_tmp38_ = map;
#line 807 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
					_tmp39_ = object;
#line 807 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
					_tmp40_ = key_map;
#line 807 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
					gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp38_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp39_, _tmp40_);
#line 798 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
					_key_value_map_unref0 (key_map);
#line 798 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
					keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
#line 798 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
					_g_free0 (object);
#line 5569 "PhotoTable.c"
				}
			}
		}
#line 810 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		result = map;
#line 810 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		objects = (_vala_array_free (objects, objects_length1, (GDestroyNotify) g_free), NULL);
#line 810 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_g_key_file_unref0 (keyfile);
#line 810 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		return result;
#line 5581 "PhotoTable.c"
	}
	goto __finally17;
	__catch17_g_error:
	{
		GError* err = NULL;
		const gchar* _tmp41_;
#line 790 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		err = _inner_error_;
#line 790 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_inner_error_ = NULL;
#line 812 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp41_ = err->message;
#line 812 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		g_error ("PhotoTable.vala:812: %s", _tmp41_);
#line 790 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_g_error_free0 (err);
#line 5598 "PhotoTable.c"
	}
	__finally17:
#line 790 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 790 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_clear_error (&_inner_error_);
#line 790 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	return NULL;
#line 5607 "PhotoTable.c"
}


gchar*
photo_table_unmarshall_all_transformations (GeeHashMap* transformations)
{
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	GKeyFile* keyfile = NULL;
	GKeyFile* _tmp6_;
	gsize length = 0UL;
	gchar* unmarshalled = NULL;
	GKeyFile* _tmp33_;
	gsize _tmp34_ = 0UL;
	gchar* _tmp35_;
	const gchar* _tmp36_;
	const gchar* _tmp37_;
	gint _tmp38_;
	gint _tmp39_;
#line 816 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_val_if_fail ((transformations == NULL) || GEE_IS_HASH_MAP (transformations), NULL);
#line 817 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (transformations == NULL) {
#line 817 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp0_ = TRUE;
#line 5633 "PhotoTable.c"
	} else {
		GeeSet* _tmp1_;
		GeeSet* _tmp2_;
		GeeSet* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
#line 817 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp1_ = gee_abstract_map_get_keys (G_TYPE_CHECK_INSTANCE_CAST (transformations, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap));
#line 817 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp2_ = _tmp1_;
#line 817 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp3_ = _tmp2_;
#line 817 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp4_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_COLLECTION, GeeCollection));
#line 817 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp5_ = _tmp4_;
#line 817 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp0_ = _tmp5_ == 0;
#line 817 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_g_object_unref0 (_tmp3_);
#line 5654 "PhotoTable.c"
	}
#line 817 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (_tmp0_) {
#line 818 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		result = NULL;
#line 818 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		return result;
#line 5662 "PhotoTable.c"
	}
#line 820 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp6_ = g_key_file_new ();
#line 820 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	keyfile = _tmp6_;
#line 5668 "PhotoTable.c"
	{
		GeeIterator* _object_it = NULL;
		GeeSet* _tmp7_;
		GeeSet* _tmp8_;
		GeeSet* _tmp9_;
		GeeIterator* _tmp10_;
		GeeIterator* _tmp11_;
#line 822 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp7_ = gee_abstract_map_get_keys (G_TYPE_CHECK_INSTANCE_CAST (transformations, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap));
#line 822 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp8_ = _tmp7_;
#line 822 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp9_ = _tmp8_;
#line 822 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp10_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, GEE_TYPE_ITERABLE, GeeIterable));
#line 822 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp11_ = _tmp10_;
#line 822 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_g_object_unref0 (_tmp9_);
#line 822 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_object_it = _tmp11_;
#line 822 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		while (TRUE) {
#line 5692 "PhotoTable.c"
			GeeIterator* _tmp12_;
			gchar* object = NULL;
			GeeIterator* _tmp13_;
			gpointer _tmp14_;
			KeyValueMap* map = NULL;
			const gchar* _tmp15_;
			gpointer _tmp16_;
#line 822 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_tmp12_ = _object_it;
#line 822 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			if (!gee_iterator_next (_tmp12_)) {
#line 822 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				break;
#line 5706 "PhotoTable.c"
			}
#line 822 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_tmp13_ = _object_it;
#line 822 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_tmp14_ = gee_iterator_get (_tmp13_);
#line 822 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			object = (gchar*) _tmp14_;
#line 823 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_tmp15_ = object;
#line 823 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_tmp16_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (transformations, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp15_);
#line 823 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			map = (KeyValueMap*) _tmp16_;
#line 5720 "PhotoTable.c"
			{
				GeeIterator* _key_it = NULL;
				KeyValueMap* _tmp17_;
				GeeSet* _tmp18_;
				GeeSet* _tmp19_;
				GeeIterator* _tmp20_;
				GeeIterator* _tmp21_;
#line 825 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				_tmp17_ = map;
#line 825 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				_tmp18_ = key_value_map_get_keys (_tmp17_);
#line 825 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				_tmp19_ = _tmp18_;
#line 825 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				_tmp20_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, GEE_TYPE_ITERABLE, GeeIterable));
#line 825 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				_tmp21_ = _tmp20_;
#line 825 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				_g_object_unref0 (_tmp19_);
#line 825 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				_key_it = _tmp21_;
#line 825 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				while (TRUE) {
#line 5744 "PhotoTable.c"
					GeeIterator* _tmp22_;
					gchar* key = NULL;
					GeeIterator* _tmp23_;
					gpointer _tmp24_;
					gchar* value = NULL;
					KeyValueMap* _tmp25_;
					const gchar* _tmp26_;
					gchar* _tmp27_;
					const gchar* _tmp28_;
					GKeyFile* _tmp29_;
					const gchar* _tmp30_;
					const gchar* _tmp31_;
					const gchar* _tmp32_;
#line 825 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
					_tmp22_ = _key_it;
#line 825 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
					if (!gee_iterator_next (_tmp22_)) {
#line 825 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
						break;
#line 5764 "PhotoTable.c"
					}
#line 825 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
					_tmp23_ = _key_it;
#line 825 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
					_tmp24_ = gee_iterator_get (_tmp23_);
#line 825 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
					key = (gchar*) _tmp24_;
#line 826 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
					_tmp25_ = map;
#line 826 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
					_tmp26_ = key;
#line 826 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
					_tmp27_ = key_value_map_get_string (_tmp25_, _tmp26_, NULL);
#line 826 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
					value = _tmp27_;
#line 827 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
					_tmp28_ = value;
#line 827 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
					_vala_assert (_tmp28_ != NULL, "value != null");
#line 829 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
					_tmp29_ = keyfile;
#line 829 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
					_tmp30_ = object;
#line 829 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
					_tmp31_ = key;
#line 829 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
					_tmp32_ = value;
#line 829 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
					g_key_file_set_string (_tmp29_, _tmp30_, _tmp31_, _tmp32_);
#line 825 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
					_g_free0 (value);
#line 825 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
					_g_free0 (key);
#line 5798 "PhotoTable.c"
				}
#line 825 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				_g_object_unref0 (_key_it);
#line 5802 "PhotoTable.c"
			}
#line 822 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_key_value_map_unref0 (map);
#line 822 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_g_free0 (object);
#line 5808 "PhotoTable.c"
		}
#line 822 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_g_object_unref0 (_object_it);
#line 5812 "PhotoTable.c"
	}
#line 834 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp33_ = keyfile;
#line 834 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp35_ = g_key_file_to_data (_tmp33_, &_tmp34_, NULL);
#line 834 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	length = _tmp34_;
#line 834 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	unmarshalled = _tmp35_;
#line 835 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp36_ = unmarshalled;
#line 835 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp36_ != NULL, "unmarshalled != null");
#line 836 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp37_ = unmarshalled;
#line 836 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp38_ = strlen (_tmp37_);
#line 836 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp39_ = _tmp38_;
#line 836 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp39_ > 0, "unmarshalled.length > 0");
#line 838 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	result = unmarshalled;
#line 838 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_g_key_file_unref0 (keyfile);
#line 838 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	return result;
#line 5840 "PhotoTable.c"
}


gboolean
photo_table_set_transformation (PhotoTable* self,
                                PhotoID* photo_id,
                                KeyValueMap* map)
{
	gboolean result = FALSE;
	gchar* trans = NULL;
	PhotoID _tmp0_;
	gchar* _tmp1_;
	PhotoID _tmp33_;
	const gchar* _tmp34_;
	GError * _inner_error_ = NULL;
#line 841 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_val_if_fail (IS_PHOTO_TABLE (self), FALSE);
#line 841 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_val_if_fail (photo_id != NULL, FALSE);
#line 841 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_val_if_fail (IS_KEY_VALUE_MAP (map), FALSE);
#line 842 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp0_ = *photo_id;
#line 842 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp1_ = photo_table_get_raw_transformations (self, &_tmp0_);
#line 842 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	trans = _tmp1_;
#line 5868 "PhotoTable.c"
	{
		GKeyFile* keyfile = NULL;
		GKeyFile* _tmp2_;
		const gchar* _tmp3_;
		GeeSet* keys = NULL;
		GeeSet* _tmp10_;
		gsize length = 0UL;
		GKeyFile* _tmp24_;
		gsize _tmp25_ = 0UL;
		gchar* _tmp26_;
		const gchar* _tmp27_;
		const gchar* _tmp28_;
		gint _tmp29_;
		gint _tmp30_;
#line 845 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp2_ = g_key_file_new ();
#line 845 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		keyfile = _tmp2_;
#line 846 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp3_ = trans;
#line 846 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		if (_tmp3_ != NULL) {
#line 5891 "PhotoTable.c"
			gboolean _tmp4_ = FALSE;
			GKeyFile* _tmp5_;
			const gchar* _tmp6_;
			const gchar* _tmp7_;
			gint _tmp8_;
			gint _tmp9_;
#line 847 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_tmp5_ = keyfile;
#line 847 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_tmp6_ = trans;
#line 847 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_tmp7_ = trans;
#line 847 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_tmp8_ = strlen (_tmp7_);
#line 847 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_tmp9_ = _tmp8_;
#line 847 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_tmp4_ = g_key_file_load_from_data (_tmp5_, _tmp6_, (gsize) _tmp9_, G_KEY_FILE_NONE, &_inner_error_);
#line 847 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 847 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				_g_key_file_unref0 (keyfile);
#line 5914 "PhotoTable.c"
				goto __catch18_g_error;
			}
#line 847 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			if (!_tmp4_) {
#line 848 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				result = FALSE;
#line 848 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				_g_key_file_unref0 (keyfile);
#line 848 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				_g_free0 (trans);
#line 848 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				return result;
#line 5927 "PhotoTable.c"
			}
		}
#line 851 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp10_ = key_value_map_get_keys (map);
#line 851 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		keys = _tmp10_;
#line 5934 "PhotoTable.c"
		{
			GeeIterator* _key_it = NULL;
			GeeSet* _tmp11_;
			GeeIterator* _tmp12_;
#line 852 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_tmp11_ = keys;
#line 852 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_tmp12_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, GEE_TYPE_ITERABLE, GeeIterable));
#line 852 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_key_it = _tmp12_;
#line 852 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			while (TRUE) {
#line 5947 "PhotoTable.c"
				GeeIterator* _tmp13_;
				gchar* key = NULL;
				GeeIterator* _tmp14_;
				gpointer _tmp15_;
				gchar* value = NULL;
				const gchar* _tmp16_;
				gchar* _tmp17_;
				const gchar* _tmp18_;
				GKeyFile* _tmp19_;
				gchar* _tmp20_;
				gchar* _tmp21_;
				const gchar* _tmp22_;
				const gchar* _tmp23_;
#line 852 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				_tmp13_ = _key_it;
#line 852 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				if (!gee_iterator_next (_tmp13_)) {
#line 852 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
					break;
#line 5967 "PhotoTable.c"
				}
#line 852 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				_tmp14_ = _key_it;
#line 852 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				_tmp15_ = gee_iterator_get (_tmp14_);
#line 852 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				key = (gchar*) _tmp15_;
#line 853 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				_tmp16_ = key;
#line 853 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				_tmp17_ = key_value_map_get_string (map, _tmp16_, NULL);
#line 853 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				value = _tmp17_;
#line 854 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				_tmp18_ = value;
#line 854 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				_vala_assert (_tmp18_ != NULL, "value != null");
#line 856 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				_tmp19_ = keyfile;
#line 856 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				_tmp20_ = key_value_map_get_group (map);
#line 856 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				_tmp21_ = _tmp20_;
#line 856 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				_tmp22_ = key;
#line 856 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				_tmp23_ = value;
#line 856 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				g_key_file_set_string (_tmp19_, _tmp21_, _tmp22_, _tmp23_);
#line 856 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				_g_free0 (_tmp21_);
#line 852 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				_g_free0 (value);
#line 852 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				_g_free0 (key);
#line 6003 "PhotoTable.c"
			}
#line 852 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_g_object_unref0 (_key_it);
#line 6007 "PhotoTable.c"
		}
#line 860 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp24_ = keyfile;
#line 860 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp26_ = g_key_file_to_data (_tmp24_, &_tmp25_, NULL);
#line 860 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		length = _tmp25_;
#line 860 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_g_free0 (trans);
#line 860 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		trans = _tmp26_;
#line 861 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp27_ = trans;
#line 861 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_vala_assert (_tmp27_ != NULL, "trans != null");
#line 862 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp28_ = trans;
#line 862 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp29_ = strlen (_tmp28_);
#line 862 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp30_ = _tmp29_;
#line 862 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_vala_assert (_tmp30_ > 0, "trans.length > 0");
#line 844 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_g_object_unref0 (keys);
#line 844 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_g_key_file_unref0 (keyfile);
#line 6035 "PhotoTable.c"
	}
	goto __finally18;
	__catch18_g_error:
	{
		GError* err = NULL;
		const gchar* _tmp31_;
#line 844 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		err = _inner_error_;
#line 844 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_inner_error_ = NULL;
#line 864 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp31_ = err->message;
#line 864 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		g_error ("PhotoTable.vala:864: %s", _tmp31_);
#line 844 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_g_error_free0 (err);
#line 6052 "PhotoTable.c"
	}
	__finally18:
#line 844 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 6057 "PhotoTable.c"
		gboolean _tmp32_ = FALSE;
#line 844 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_g_free0 (trans);
#line 844 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 844 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		g_clear_error (&_inner_error_);
#line 844 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		return _tmp32_;
#line 6067 "PhotoTable.c"
	}
#line 867 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp33_ = *photo_id;
#line 867 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp34_ = trans;
#line 867 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	result = photo_table_set_raw_transformations (self, &_tmp33_, _tmp34_);
#line 867 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_g_free0 (trans);
#line 867 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	return result;
#line 6079 "PhotoTable.c"
}


gboolean
photo_table_remove_transformation (PhotoTable* self,
                                   PhotoID* photo_id,
                                   const gchar* object)
{
	gboolean result = FALSE;
	gchar* trans = NULL;
	PhotoID _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	PhotoID _tmp18_;
	const gchar* _tmp19_;
	GError * _inner_error_ = NULL;
#line 870 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_val_if_fail (IS_PHOTO_TABLE (self), FALSE);
#line 870 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_val_if_fail (photo_id != NULL, FALSE);
#line 870 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_val_if_fail (object != NULL, FALSE);
#line 871 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp0_ = *photo_id;
#line 871 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp1_ = photo_table_get_raw_transformations (self, &_tmp0_);
#line 871 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	trans = _tmp1_;
#line 872 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp2_ = trans;
#line 872 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (_tmp2_ == NULL) {
#line 873 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		result = TRUE;
#line 873 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_g_free0 (trans);
#line 873 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		return result;
#line 6118 "PhotoTable.c"
	}
	{
		GKeyFile* keyfile = NULL;
		GKeyFile* _tmp3_;
		gboolean _tmp4_ = FALSE;
		GKeyFile* _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		GKeyFile* _tmp10_;
		GKeyFile* _tmp11_;
		gsize length = 0UL;
		GKeyFile* _tmp12_;
		gsize _tmp13_ = 0UL;
		gchar* _tmp14_;
		const gchar* _tmp15_;
#line 876 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp3_ = g_key_file_new ();
#line 876 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		keyfile = _tmp3_;
#line 877 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp5_ = keyfile;
#line 877 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp6_ = trans;
#line 877 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp7_ = trans;
#line 877 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp8_ = strlen (_tmp7_);
#line 877 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp9_ = _tmp8_;
#line 877 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp4_ = g_key_file_load_from_data (_tmp5_, _tmp6_, (gsize) _tmp9_, G_KEY_FILE_NONE, &_inner_error_);
#line 877 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 877 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_g_key_file_unref0 (keyfile);
#line 6156 "PhotoTable.c"
			goto __catch19_g_error;
		}
#line 877 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		if (!_tmp4_) {
#line 878 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			result = FALSE;
#line 878 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_g_key_file_unref0 (keyfile);
#line 878 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_g_free0 (trans);
#line 878 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			return result;
#line 6169 "PhotoTable.c"
		}
#line 880 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp10_ = keyfile;
#line 880 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		if (!g_key_file_has_group (_tmp10_, object)) {
#line 881 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			result = TRUE;
#line 881 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_g_key_file_unref0 (keyfile);
#line 881 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_g_free0 (trans);
#line 881 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			return result;
#line 6183 "PhotoTable.c"
		}
#line 883 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp11_ = keyfile;
#line 883 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		g_key_file_remove_group (_tmp11_, object, &_inner_error_);
#line 883 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 883 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_g_key_file_unref0 (keyfile);
#line 6193 "PhotoTable.c"
			goto __catch19_g_error;
		}
#line 886 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp12_ = keyfile;
#line 886 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp14_ = g_key_file_to_data (_tmp12_, &_tmp13_, NULL);
#line 886 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		length = _tmp13_;
#line 886 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_g_free0 (trans);
#line 886 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		trans = _tmp14_;
#line 887 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp15_ = trans;
#line 887 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_vala_assert (_tmp15_ != NULL, "trans != null");
#line 875 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_g_key_file_unref0 (keyfile);
#line 6212 "PhotoTable.c"
	}
	goto __finally19;
	__catch19_g_error:
	{
		GError* err = NULL;
		const gchar* _tmp16_;
#line 875 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		err = _inner_error_;
#line 875 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_inner_error_ = NULL;
#line 889 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp16_ = err->message;
#line 889 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		g_error ("PhotoTable.vala:889: %s", _tmp16_);
#line 875 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_g_error_free0 (err);
#line 6229 "PhotoTable.c"
	}
	__finally19:
#line 875 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 6234 "PhotoTable.c"
		gboolean _tmp17_ = FALSE;
#line 875 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_g_free0 (trans);
#line 875 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 875 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		g_clear_error (&_inner_error_);
#line 875 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		return _tmp17_;
#line 6244 "PhotoTable.c"
	}
#line 892 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp18_ = *photo_id;
#line 892 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp19_ = trans;
#line 892 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	result = photo_table_set_raw_transformations (self, &_tmp18_, _tmp19_);
#line 892 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_g_free0 (trans);
#line 892 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	return result;
#line 6256 "PhotoTable.c"
}


gboolean
photo_table_remove_all_transformations (PhotoTable* self,
                                        PhotoID* photo_id)
{
	gboolean result = FALSE;
	PhotoID _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean _tmp3_;
	PhotoID _tmp4_;
	gint64 _tmp5_;
#line 895 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_val_if_fail (IS_PHOTO_TABLE (self), FALSE);
#line 895 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_val_if_fail (photo_id != NULL, FALSE);
#line 896 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp0_ = *photo_id;
#line 896 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp1_ = photo_table_get_raw_transformations (self, &_tmp0_);
#line 896 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp2_ = _tmp1_;
#line 896 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp3_ = _tmp2_ == NULL;
#line 896 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_g_free0 (_tmp2_);
#line 896 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (_tmp3_) {
#line 897 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		result = FALSE;
#line 897 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		return result;
#line 6291 "PhotoTable.c"
	}
#line 899 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp4_ = *photo_id;
#line 899 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp5_ = _tmp4_.id;
#line 899 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	result = database_table_update_text_by_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_TABLE, DatabaseTable), _tmp5_, "transformations", "");
#line 899 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	return result;
#line 6301 "PhotoTable.c"
}


static sqlite3_stmt*
photo_table_get_duplicate_stmt (PhotoTable* self,
                                GFile* file,
                                const gchar* thumbnail_md5,
                                const gchar* md5,
                                PhotoFileFormat file_format)
{
	sqlite3_stmt* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gchar* sql = NULL;
	gchar* _tmp2_;
	gboolean first = FALSE;
	gboolean _tmp5_ = FALSE;
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp23_;
	const gchar* _tmp24_;
	sqlite3_stmt* _tmp25_ = NULL;
	gint _tmp26_;
	gint _tmp27_;
	gint col = 0;
	gboolean _tmp43_ = FALSE;
	gboolean _tmp44_ = FALSE;
#line 904 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_val_if_fail (IS_PHOTO_TABLE (self), NULL);
#line 904 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_val_if_fail ((file == NULL) || G_IS_FILE (file), NULL);
#line 906 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (file != NULL) {
#line 906 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp1_ = TRUE;
#line 6337 "PhotoTable.c"
	} else {
#line 906 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp1_ = thumbnail_md5 != NULL;
#line 6341 "PhotoTable.c"
	}
#line 906 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (_tmp1_) {
#line 906 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp0_ = TRUE;
#line 6347 "PhotoTable.c"
	} else {
#line 906 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp0_ = md5 != NULL;
#line 6351 "PhotoTable.c"
	}
#line 906 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp0_, "file != null || thumbnail_md5 != null || md5 != null");
#line 908 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp2_ = g_strdup ("SELECT id FROM PhotoTable WHERE");
#line 908 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	sql = _tmp2_;
#line 909 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	first = TRUE;
#line 911 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (file != NULL) {
#line 6363 "PhotoTable.c"
		const gchar* _tmp3_;
		gchar* _tmp4_;
#line 912 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp3_ = sql;
#line 912 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp4_ = g_strconcat (_tmp3_, " filename=?", NULL);
#line 912 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_g_free0 (sql);
#line 912 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		sql = _tmp4_;
#line 913 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		first = FALSE;
#line 6376 "PhotoTable.c"
	}
#line 916 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (thumbnail_md5 != NULL) {
#line 916 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp5_ = TRUE;
#line 6382 "PhotoTable.c"
	} else {
#line 916 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp5_ = md5 != NULL;
#line 6386 "PhotoTable.c"
	}
#line 916 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (_tmp5_) {
#line 6390 "PhotoTable.c"
		gboolean _tmp6_;
		const gchar* _tmp17_;
		gchar* _tmp18_;
		const gchar* _tmp21_;
		gchar* _tmp22_;
#line 917 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp6_ = first;
#line 917 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		if (_tmp6_) {
#line 6400 "PhotoTable.c"
			const gchar* _tmp7_;
			gchar* _tmp8_;
#line 918 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_tmp7_ = sql;
#line 918 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_tmp8_ = g_strconcat (_tmp7_, " ((", NULL);
#line 918 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_g_free0 (sql);
#line 918 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			sql = _tmp8_;
#line 6411 "PhotoTable.c"
		} else {
			const gchar* _tmp9_;
			gchar* _tmp10_;
#line 920 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_tmp9_ = sql;
#line 920 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_tmp10_ = g_strconcat (_tmp9_, " OR ((", NULL);
#line 920 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_g_free0 (sql);
#line 920 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			sql = _tmp10_;
#line 6423 "PhotoTable.c"
		}
#line 921 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		first = FALSE;
#line 923 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		if (md5 != NULL) {
#line 6429 "PhotoTable.c"
			const gchar* _tmp11_;
			gchar* _tmp12_;
#line 924 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_tmp11_ = sql;
#line 924 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_tmp12_ = g_strconcat (_tmp11_, " md5=?", NULL);
#line 924 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_g_free0 (sql);
#line 924 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			sql = _tmp12_;
#line 6440 "PhotoTable.c"
		}
#line 927 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		if (thumbnail_md5 != NULL) {
#line 928 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			if (md5 == NULL) {
#line 6446 "PhotoTable.c"
				const gchar* _tmp13_;
				gchar* _tmp14_;
#line 929 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				_tmp13_ = sql;
#line 929 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				_tmp14_ = g_strconcat (_tmp13_, " thumbnail_md5=?", NULL);
#line 929 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				_g_free0 (sql);
#line 929 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				sql = _tmp14_;
#line 6457 "PhotoTable.c"
			} else {
				const gchar* _tmp15_;
				gchar* _tmp16_;
#line 931 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				_tmp15_ = sql;
#line 931 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				_tmp16_ = g_strconcat (_tmp15_, " OR (md5 IS NULL AND thumbnail_md5=?)", NULL);
#line 931 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				_g_free0 (sql);
#line 931 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				sql = _tmp16_;
#line 6469 "PhotoTable.c"
			}
		}
#line 934 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp17_ = sql;
#line 934 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp18_ = g_strconcat (_tmp17_, ")", NULL);
#line 934 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_g_free0 (sql);
#line 934 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		sql = _tmp18_;
#line 936 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		if (file_format != PHOTO_FILE_FORMAT_UNKNOWN) {
#line 6482 "PhotoTable.c"
			const gchar* _tmp19_;
			gchar* _tmp20_;
#line 937 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_tmp19_ = sql;
#line 937 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_tmp20_ = g_strconcat (_tmp19_, " AND file_format=?", NULL);
#line 937 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_g_free0 (sql);
#line 937 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			sql = _tmp20_;
#line 6493 "PhotoTable.c"
		}
#line 939 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp21_ = sql;
#line 939 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp22_ = g_strconcat (_tmp21_, ")", NULL);
#line 939 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_g_free0 (sql);
#line 939 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		sql = _tmp22_;
#line 6503 "PhotoTable.c"
	}
#line 943 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp23_ = database_table_db;
#line 943 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp24_ = sql;
#line 943 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp26_ = sqlite3_prepare_v2 (_tmp23_, _tmp24_, -1, &_tmp25_, NULL);
#line 943 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_sqlite3_finalize0 (stmt);
#line 943 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	stmt = _tmp25_;
#line 943 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp26_;
#line 944 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp27_ = res;
#line 944 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp27_ == SQLITE_OK, "res == Sqlite.OK");
#line 946 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	col = 1;
#line 948 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (file != NULL) {
#line 6525 "PhotoTable.c"
		sqlite3_stmt* _tmp28_;
		gint _tmp29_;
		gchar* _tmp30_;
		GDestroyNotify _tmp31_;
		gint _tmp32_;
#line 949 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp28_ = stmt;
#line 949 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp29_ = col;
#line 949 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		col = _tmp29_ + 1;
#line 949 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp30_ = g_file_get_path (file);
#line 949 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp31_ = g_free;
#line 949 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		res = sqlite3_bind_text (_tmp28_, _tmp29_, _tmp30_, -1, _tmp31_);
#line 950 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp32_ = res;
#line 950 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_vala_assert (_tmp32_ == SQLITE_OK, "res == Sqlite.OK");
#line 6547 "PhotoTable.c"
	}
#line 953 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (thumbnail_md5 != NULL) {
#line 6551 "PhotoTable.c"
		sqlite3_stmt* _tmp33_;
		gint _tmp34_;
		gchar* _tmp35_;
		GDestroyNotify _tmp36_;
		gint _tmp37_;
#line 954 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp33_ = stmt;
#line 954 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp34_ = col;
#line 954 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		col = _tmp34_ + 1;
#line 954 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp35_ = g_strdup (thumbnail_md5);
#line 954 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp36_ = g_free;
#line 954 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		res = sqlite3_bind_text (_tmp33_, _tmp34_, _tmp35_, -1, _tmp36_);
#line 955 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp37_ = res;
#line 955 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_vala_assert (_tmp37_ == SQLITE_OK, "res == Sqlite.OK");
#line 6573 "PhotoTable.c"
	}
#line 958 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (md5 != NULL) {
#line 6577 "PhotoTable.c"
		sqlite3_stmt* _tmp38_;
		gint _tmp39_;
		gchar* _tmp40_;
		GDestroyNotify _tmp41_;
		gint _tmp42_;
#line 959 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp38_ = stmt;
#line 959 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp39_ = col;
#line 959 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		col = _tmp39_ + 1;
#line 959 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp40_ = g_strdup (md5);
#line 959 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp41_ = g_free;
#line 959 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		res = sqlite3_bind_text (_tmp38_, _tmp39_, _tmp40_, -1, _tmp41_);
#line 960 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp42_ = res;
#line 960 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_vala_assert (_tmp42_ == SQLITE_OK, "res == Sqlite.OK");
#line 6599 "PhotoTable.c"
	}
#line 963 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (thumbnail_md5 != NULL) {
#line 963 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp44_ = TRUE;
#line 6605 "PhotoTable.c"
	} else {
#line 963 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp44_ = md5 != NULL;
#line 6609 "PhotoTable.c"
	}
#line 963 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (_tmp44_) {
#line 963 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp43_ = file_format != PHOTO_FILE_FORMAT_UNKNOWN;
#line 6615 "PhotoTable.c"
	} else {
#line 963 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp43_ = FALSE;
#line 6619 "PhotoTable.c"
	}
#line 963 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (_tmp43_) {
#line 6623 "PhotoTable.c"
		sqlite3_stmt* _tmp45_;
		gint _tmp46_;
		gint _tmp47_;
#line 964 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp45_ = stmt;
#line 964 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp46_ = col;
#line 964 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		col = _tmp46_ + 1;
#line 964 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		res = sqlite3_bind_int (_tmp45_, _tmp46_, photo_file_format_serialize (file_format));
#line 965 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp47_ = res;
#line 965 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_vala_assert (_tmp47_ == SQLITE_OK, "res == Sqlite.OK");
#line 6639 "PhotoTable.c"
	}
#line 968 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	result = stmt;
#line 968 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_g_free0 (sql);
#line 968 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	return result;
#line 6647 "PhotoTable.c"
}


gboolean
photo_table_has_duplicate (PhotoTable* self,
                           GFile* file,
                           const gchar* thumbnail_md5,
                           const gchar* md5,
                           PhotoFileFormat file_format)
{
	gboolean result = FALSE;
	sqlite3_stmt* stmt = NULL;
	sqlite3_stmt* _tmp0_;
	gint res = 0;
	sqlite3_stmt* _tmp1_;
	gint _tmp2_;
#line 971 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_val_if_fail (IS_PHOTO_TABLE (self), FALSE);
#line 971 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_val_if_fail ((file == NULL) || G_IS_FILE (file), FALSE);
#line 972 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp0_ = photo_table_get_duplicate_stmt (self, file, thumbnail_md5, md5, file_format);
#line 972 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	stmt = _tmp0_;
#line 973 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp1_ = stmt;
#line 973 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = sqlite3_step (_tmp1_);
#line 975 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp2_ = res;
#line 975 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (_tmp2_ == SQLITE_DONE) {
#line 977 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		result = FALSE;
#line 977 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_sqlite3_finalize0 (stmt);
#line 977 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		return result;
#line 6686 "PhotoTable.c"
	} else {
		gint _tmp3_;
#line 978 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp3_ = res;
#line 978 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		if (_tmp3_ == SQLITE_ROW) {
#line 980 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			result = TRUE;
#line 980 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_sqlite3_finalize0 (stmt);
#line 980 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			return result;
#line 6699 "PhotoTable.c"
		} else {
			gint _tmp4_;
#line 982 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_tmp4_ = res;
#line 982 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			database_table_fatal ("has_duplicate", _tmp4_);
#line 984 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			result = FALSE;
#line 984 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_sqlite3_finalize0 (stmt);
#line 984 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			return result;
#line 6712 "PhotoTable.c"
		}
	}
#line 971 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_sqlite3_finalize0 (stmt);
#line 6717 "PhotoTable.c"
}


static void
_vala_array_add2 (PhotoID* * array,
                  int* length,
                  int* size,
                  const PhotoID* value)
{
#line 996 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if ((*length) == (*size)) {
#line 996 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 996 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		*array = g_renew (PhotoID, *array, *size);
#line 6733 "PhotoTable.c"
	}
#line 996 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	(*array)[(*length)++] = *value;
#line 6737 "PhotoTable.c"
}


PhotoID*
photo_table_get_duplicate_ids (PhotoTable* self,
                               GFile* file,
                               const gchar* thumbnail_md5,
                               const gchar* md5,
                               PhotoFileFormat file_format,
                               int* result_length1)
{
	PhotoID* result = NULL;
	sqlite3_stmt* stmt = NULL;
	sqlite3_stmt* _tmp0_;
	PhotoID* ids = NULL;
	PhotoID* _tmp1_;
	gint ids_length1;
	gint _ids_size_;
	gint res = 0;
	sqlite3_stmt* _tmp2_;
	PhotoID* _tmp8_;
	gint _tmp8__length1;
#line 988 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_val_if_fail (IS_PHOTO_TABLE (self), NULL);
#line 988 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_val_if_fail ((file == NULL) || G_IS_FILE (file), NULL);
#line 990 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp0_ = photo_table_get_duplicate_stmt (self, file, thumbnail_md5, md5, file_format);
#line 990 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	stmt = _tmp0_;
#line 992 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp1_ = g_new0 (PhotoID, 0);
#line 992 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	ids = _tmp1_;
#line 992 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	ids_length1 = 0;
#line 992 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_ids_size_ = ids_length1;
#line 994 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp2_ = stmt;
#line 994 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = sqlite3_step (_tmp2_);
#line 995 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	while (TRUE) {
#line 6782 "PhotoTable.c"
		gint _tmp3_;
		PhotoID* _tmp4_;
		gint _tmp4__length1;
		sqlite3_stmt* _tmp5_;
		PhotoID _tmp6_ = {0};
		sqlite3_stmt* _tmp7_;
#line 995 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp3_ = res;
#line 995 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		if (!(_tmp3_ == SQLITE_ROW)) {
#line 995 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			break;
#line 6795 "PhotoTable.c"
		}
#line 996 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp4_ = ids;
#line 996 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp4__length1 = ids_length1;
#line 996 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp5_ = stmt;
#line 996 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		photo_id_init (&_tmp6_, sqlite3_column_int64 (_tmp5_, 0));
#line 996 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_vala_array_add2 (&ids, &ids_length1, &_ids_size_, &_tmp6_);
#line 997 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp7_ = stmt;
#line 997 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		res = sqlite3_step (_tmp7_);
#line 6811 "PhotoTable.c"
	}
#line 1000 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp8_ = ids;
#line 1000 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp8__length1 = ids_length1;
#line 1000 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (result_length1) {
#line 1000 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		*result_length1 = _tmp8__length1;
#line 6821 "PhotoTable.c"
	}
#line 1000 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	result = _tmp8_;
#line 1000 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_sqlite3_finalize0 (stmt);
#line 1000 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	return result;
#line 6829 "PhotoTable.c"
}


void
photo_table_update_backlinks (PhotoTable* self,
                              PhotoID* photo_id,
                              const gchar* backlinks,
                              GError** error)
{
	const gchar* _tmp0_ = NULL;
	PhotoID _tmp1_;
	gint64 _tmp2_;
	GError * _inner_error_ = NULL;
#line 1003 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_if_fail (IS_PHOTO_TABLE (self));
#line 1003 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_if_fail (photo_id != NULL);
#line 1004 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (backlinks != NULL) {
#line 1004 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp0_ = backlinks;
#line 6851 "PhotoTable.c"
	} else {
#line 1004 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp0_ = "";
#line 6855 "PhotoTable.c"
	}
#line 1004 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp1_ = *photo_id;
#line 1004 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp2_ = _tmp1_.id;
#line 1004 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	database_table_update_text_by_id_2 (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_TABLE, DatabaseTable), _tmp2_, "backlinks", _tmp0_, &_inner_error_);
#line 1004 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1004 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		if (_inner_error_->domain == DATABASE_ERROR) {
#line 1004 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			g_propagate_error (error, _inner_error_);
#line 1004 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			return;
#line 6871 "PhotoTable.c"
		} else {
#line 1004 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1004 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			g_clear_error (&_inner_error_);
#line 1004 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			return;
#line 6879 "PhotoTable.c"
		}
	}
}


void
photo_table_attach_editable (PhotoTable* self,
                             PhotoRow* row,
                             BackingPhotoID* editable_id,
                             GError** error)
{
	PhotoID _tmp0_;
	gint64 _tmp1_;
	BackingPhotoID _tmp2_;
	gint64 _tmp3_;
	BackingPhotoID _tmp4_;
	GError * _inner_error_ = NULL;
#line 1007 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_if_fail (IS_PHOTO_TABLE (self));
#line 1007 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_if_fail (IS_PHOTO_ROW (row));
#line 1007 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_if_fail (editable_id != NULL);
#line 1008 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp0_ = row->photo_id;
#line 1008 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp1_ = _tmp0_.id;
#line 1008 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp2_ = *editable_id;
#line 1008 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp3_ = _tmp2_.id;
#line 1008 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	database_table_update_int64_by_id_2 (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_TABLE, DatabaseTable), _tmp1_, "editable_id", _tmp3_, &_inner_error_);
#line 1008 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1008 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		if (_inner_error_->domain == DATABASE_ERROR) {
#line 1008 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			g_propagate_error (error, _inner_error_);
#line 1008 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			return;
#line 6921 "PhotoTable.c"
		} else {
#line 1008 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1008 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			g_clear_error (&_inner_error_);
#line 1008 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			return;
#line 6929 "PhotoTable.c"
		}
	}
#line 1010 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp4_ = *editable_id;
#line 1010 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	row->editable_id = _tmp4_;
#line 6936 "PhotoTable.c"
}


void
photo_table_detach_editable (PhotoTable* self,
                             PhotoRow* row,
                             GError** error)
{
	PhotoID _tmp0_;
	gint64 _tmp1_;
	GError * _inner_error_ = NULL;
#line 1013 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_if_fail (IS_PHOTO_TABLE (self));
#line 1013 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_if_fail (IS_PHOTO_ROW (row));
#line 1014 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp0_ = row->photo_id;
#line 1014 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp1_ = _tmp0_.id;
#line 1014 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	database_table_update_int64_by_id_2 (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_TABLE, DatabaseTable), _tmp1_, "editable_id", BACKING_PHOTO_ID_INVALID, &_inner_error_);
#line 1014 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1014 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		if (_inner_error_->domain == DATABASE_ERROR) {
#line 1014 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			g_propagate_error (error, _inner_error_);
#line 1014 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			return;
#line 6966 "PhotoTable.c"
		} else {
#line 1014 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1014 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			g_clear_error (&_inner_error_);
#line 1014 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			return;
#line 6974 "PhotoTable.c"
		}
	}
#line 1016 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	backing_photo_id_init (&row->editable_id, BACKING_PHOTO_ID_INVALID);
#line 6979 "PhotoTable.c"
}


void
photo_table_set_metadata_dirty (PhotoTable* self,
                                PhotoID* photo_id,
                                gboolean dirty,
                                GError** error)
{
	gint _tmp0_ = 0;
	PhotoID _tmp1_;
	gint64 _tmp2_;
	GError * _inner_error_ = NULL;
#line 1019 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_if_fail (IS_PHOTO_TABLE (self));
#line 1019 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_if_fail (photo_id != NULL);
#line 1020 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (dirty) {
#line 1020 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp0_ = 1;
#line 7001 "PhotoTable.c"
	} else {
#line 1020 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp0_ = 0;
#line 7005 "PhotoTable.c"
	}
#line 1020 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp1_ = *photo_id;
#line 1020 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp2_ = _tmp1_.id;
#line 1020 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	database_table_update_int_by_id_2 (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_TABLE, DatabaseTable), _tmp2_, "metadata_dirty", _tmp0_, &_inner_error_);
#line 1020 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1020 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		if (_inner_error_->domain == DATABASE_ERROR) {
#line 1020 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			g_propagate_error (error, _inner_error_);
#line 1020 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			return;
#line 7021 "PhotoTable.c"
		} else {
#line 1020 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1020 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			g_clear_error (&_inner_error_);
#line 1020 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			return;
#line 7029 "PhotoTable.c"
		}
	}
}


void
photo_table_update_raw_development (PhotoTable* self,
                                    PhotoRow* row,
                                    RawDeveloper rd,
                                    BackingPhotoID* backing_photo_id,
                                    GError** error)
{
	gchar* col = NULL;
	BackingPhotoID* _tmp3_;
	gint _tmp3__length1;
	BackingPhotoID _tmp4_;
	BackingPhotoID _tmp5_;
	PhotoID _tmp6_;
	gint64 _tmp7_;
	const gchar* _tmp8_;
	BackingPhotoID _tmp9_;
	gint64 _tmp10_;
	BackingPhotoID _tmp11_;
	gint64 _tmp12_;
	GError * _inner_error_ = NULL;
#line 1023 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_if_fail (IS_PHOTO_TABLE (self));
#line 1023 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_if_fail (IS_PHOTO_ROW (row));
#line 1023 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_if_fail (backing_photo_id != NULL);
#line 1027 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	switch (rd) {
#line 1027 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		case RAW_DEVELOPER_SHOTWELL:
#line 7065 "PhotoTable.c"
		{
			gchar* _tmp0_;
#line 1029 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_tmp0_ = g_strdup ("develop_shotwell_id");
#line 1029 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_g_free0 (col);
#line 1029 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			col = _tmp0_;
#line 1030 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			break;
#line 7076 "PhotoTable.c"
		}
#line 1027 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		case RAW_DEVELOPER_CAMERA:
#line 7080 "PhotoTable.c"
		{
			gchar* _tmp1_;
#line 1033 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_tmp1_ = g_strdup ("develop_camera_id");
#line 1033 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_g_free0 (col);
#line 1033 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			col = _tmp1_;
#line 1034 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			break;
#line 7091 "PhotoTable.c"
		}
#line 1027 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		case RAW_DEVELOPER_EMBEDDED:
#line 7095 "PhotoTable.c"
		{
			gchar* _tmp2_;
#line 1037 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_tmp2_ = g_strdup ("develop_embedded_id");
#line 1037 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_g_free0 (col);
#line 1037 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			col = _tmp2_;
#line 1038 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			break;
#line 7106 "PhotoTable.c"
		}
		default:
		{
#line 1041 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			g_assert_not_reached ();
#line 7112 "PhotoTable.c"
		}
	}
#line 1044 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp3_ = row->development_ids;
#line 1044 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp3__length1 = row->development_ids_length1;
#line 1044 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp4_ = *backing_photo_id;
#line 1044 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp3_[rd] = _tmp4_;
#line 1044 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp5_ = _tmp3_[rd];
#line 1045 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp6_ = row->photo_id;
#line 1045 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp7_ = _tmp6_.id;
#line 1045 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp8_ = col;
#line 1045 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp9_ = *backing_photo_id;
#line 1045 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp10_ = _tmp9_.id;
#line 1045 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	database_table_update_int64_by_id_2 (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_TABLE, DatabaseTable), _tmp7_, _tmp8_, _tmp10_, &_inner_error_);
#line 1045 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1045 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		if (_inner_error_->domain == DATABASE_ERROR) {
#line 1045 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			g_propagate_error (error, _inner_error_);
#line 1045 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_g_free0 (col);
#line 1045 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			return;
#line 7147 "PhotoTable.c"
		} else {
#line 1045 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_g_free0 (col);
#line 1045 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1045 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			g_clear_error (&_inner_error_);
#line 1045 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			return;
#line 7157 "PhotoTable.c"
		}
	}
#line 1047 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp11_ = *backing_photo_id;
#line 1047 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp12_ = _tmp11_.id;
#line 1047 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (_tmp12_ != BACKING_PHOTO_ID_INVALID) {
#line 7166 "PhotoTable.c"
		PhotoID _tmp13_;
		gint64 _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
#line 1048 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp13_ = row->photo_id;
#line 1048 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp14_ = _tmp13_.id;
#line 1048 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp15_ = raw_developer_to_string (rd);
#line 1048 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp16_ = _tmp15_;
#line 1048 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		database_table_update_text_by_id_2 (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_TABLE, DatabaseTable), _tmp14_, "developer", _tmp16_, &_inner_error_);
#line 1048 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_g_free0 (_tmp16_);
#line 1048 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1048 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			if (_inner_error_->domain == DATABASE_ERROR) {
#line 1048 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				g_propagate_error (error, _inner_error_);
#line 1048 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				_g_free0 (col);
#line 1048 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				return;
#line 7193 "PhotoTable.c"
			} else {
#line 1048 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				_g_free0 (col);
#line 1048 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1048 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				g_clear_error (&_inner_error_);
#line 1048 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				return;
#line 7203 "PhotoTable.c"
			}
		}
	}
#line 1023 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_g_free0 (col);
#line 7209 "PhotoTable.c"
}


void
photo_table_remove_development (PhotoTable* self,
                                PhotoRow* row,
                                RawDeveloper rd,
                                GError** error)
{
	BackingPhotoID _tmp0_ = {0};
	GError * _inner_error_ = NULL;
#line 1051 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_if_fail (IS_PHOTO_TABLE (self));
#line 1051 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_if_fail (IS_PHOTO_ROW (row));
#line 1052 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	backing_photo_id_init (&_tmp0_, BACKING_PHOTO_ID_INVALID);
#line 1052 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	photo_table_update_raw_development (self, row, rd, &_tmp0_, &_inner_error_);
#line 1052 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1052 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		if (_inner_error_->domain == DATABASE_ERROR) {
#line 1052 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			g_propagate_error (error, _inner_error_);
#line 1052 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			return;
#line 7237 "PhotoTable.c"
		} else {
#line 1052 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1052 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			g_clear_error (&_inner_error_);
#line 1052 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			return;
#line 7245 "PhotoTable.c"
		}
	}
}


static void
photo_table_class_init (PhotoTableClass * klass)
{
#line 109 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	photo_table_parent_class = g_type_class_peek_parent (klass);
#line 109 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	((DatabaseTableClass *) klass)->finalize = photo_table_finalize;
#line 7258 "PhotoTable.c"
}


static void
photo_table_instance_init (PhotoTable * self)
{
}


static void
photo_table_finalize (DatabaseTable * obj)
{
	PhotoTable * self;
#line 109 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PHOTO_TABLE, PhotoTable);
#line 109 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	DATABASE_TABLE_CLASS (photo_table_parent_class)->finalize (obj);
#line 7276 "PhotoTable.c"
}


GType
photo_table_get_type (void)
{
	static volatile gsize photo_table_type_id__volatile = 0;
	if (g_once_init_enter (&photo_table_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PhotoTableClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) photo_table_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PhotoTable), 0, (GInstanceInitFunc) photo_table_instance_init, NULL };
		GType photo_table_type_id;
		photo_table_type_id = g_type_register_static (TYPE_DATABASE_TABLE, "PhotoTable", &g_define_type_info, 0);
		g_once_init_leave (&photo_table_type_id__volatile, photo_table_type_id);
	}
	return photo_table_type_id__volatile;
}


void
backing_photo_id_init (BackingPhotoID *self,
                       gint64 id)
{
#line 1072 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	memset (self, 0, sizeof (BackingPhotoID));
#line 1073 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	(*self).id = id;
#line 7302 "PhotoTable.c"
}


gboolean
backing_photo_id_is_invalid (BackingPhotoID *self)
{
	gboolean result = FALSE;
	gint64 _tmp0_;
#line 1077 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp0_ = (*self).id;
#line 1077 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	result = _tmp0_ == BACKING_PHOTO_ID_INVALID;
#line 1077 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	return result;
#line 7317 "PhotoTable.c"
}


gboolean
backing_photo_id_is_valid (BackingPhotoID *self)
{
	gboolean result = FALSE;
	gint64 _tmp0_;
#line 1081 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp0_ = (*self).id;
#line 1081 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	result = _tmp0_ != BACKING_PHOTO_ID_INVALID;
#line 1081 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	return result;
#line 7332 "PhotoTable.c"
}


BackingPhotoID*
backing_photo_id_dup (const BackingPhotoID* self)
{
	BackingPhotoID* dup;
#line 1067 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	dup = g_new0 (BackingPhotoID, 1);
#line 1067 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	memcpy (dup, self, sizeof (BackingPhotoID));
#line 1067 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	return dup;
#line 7346 "PhotoTable.c"
}


void
backing_photo_id_free (BackingPhotoID* self)
{
#line 1067 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_free (self);
#line 7355 "PhotoTable.c"
}


GType
backing_photo_id_get_type (void)
{
	static volatile gsize backing_photo_id_type_id__volatile = 0;
	if (g_once_init_enter (&backing_photo_id_type_id__volatile)) {
		GType backing_photo_id_type_id;
		backing_photo_id_type_id = g_boxed_type_register_static ("BackingPhotoID", (GBoxedCopyFunc) backing_photo_id_dup, (GBoxedFreeFunc) backing_photo_id_free);
		g_once_init_leave (&backing_photo_id_type_id__volatile, backing_photo_id_type_id);
	}
	return backing_photo_id_type_id__volatile;
}


gboolean
backing_photo_row_matches_file_info (BackingPhotoRow* self,
                                     GFileInfo* info)
{
	gboolean result = FALSE;
	gint64 _tmp0_;
	time_t _tmp1_;
	GTimeVal _tmp2_ = {0};
	glong _tmp3_;
#line 1095 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_val_if_fail (IS_BACKING_PHOTO_ROW (self), FALSE);
#line 1095 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_val_if_fail (G_IS_FILE_INFO (info), FALSE);
#line 1096 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp0_ = self->filesize;
#line 1096 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (_tmp0_ != g_file_info_get_size (info)) {
#line 1097 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		result = FALSE;
#line 1097 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		return result;
#line 7393 "PhotoTable.c"
	}
#line 1099 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp1_ = self->timestamp;
#line 1099 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_file_info_get_modification_time (info, &_tmp2_);
#line 1099 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp3_ = _tmp2_.tv_sec;
#line 1099 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	result = _tmp1_ == ((time_t) _tmp3_);
#line 1099 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	return result;
#line 7405 "PhotoTable.c"
}


gboolean
backing_photo_row_is_touched (BackingPhotoRow* self,
                              GFileInfo* info)
{
	gboolean result = FALSE;
	gint64 _tmp0_;
	time_t _tmp1_;
	GTimeVal _tmp2_ = {0};
	glong _tmp3_;
#line 1102 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_val_if_fail (IS_BACKING_PHOTO_ROW (self), FALSE);
#line 1102 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_val_if_fail (G_IS_FILE_INFO (info), FALSE);
#line 1103 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp0_ = self->filesize;
#line 1103 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (_tmp0_ != g_file_info_get_size (info)) {
#line 1104 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		result = FALSE;
#line 1104 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		return result;
#line 7430 "PhotoTable.c"
	}
#line 1106 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp1_ = self->timestamp;
#line 1106 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_file_info_get_modification_time (info, &_tmp2_);
#line 1106 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp3_ = _tmp2_.tv_sec;
#line 1106 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	result = _tmp1_ != ((time_t) _tmp3_);
#line 1106 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	return result;
#line 7442 "PhotoTable.c"
}


void
backing_photo_row_copy_from (BackingPhotoRow* self,
                             BackingPhotoRow* from)
{
	BackingPhotoID _tmp0_;
	time_t _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gint64 _tmp4_;
	time_t _tmp5_;
	PhotoFileFormat _tmp6_;
	Dimensions _tmp7_;
	Orientation _tmp8_;
#line 1110 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_if_fail (IS_BACKING_PHOTO_ROW (self));
#line 1110 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_if_fail (IS_BACKING_PHOTO_ROW (from));
#line 1111 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp0_ = from->id;
#line 1111 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	self->id = _tmp0_;
#line 1112 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp1_ = from->time_created;
#line 1112 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	self->time_created = _tmp1_;
#line 1113 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp2_ = from->filepath;
#line 1113 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp3_ = g_strdup (_tmp2_);
#line 1113 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_g_free0 (self->filepath);
#line 1113 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	self->filepath = _tmp3_;
#line 1114 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp4_ = from->filesize;
#line 1114 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	self->filesize = _tmp4_;
#line 1115 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp5_ = from->timestamp;
#line 1115 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	self->timestamp = _tmp5_;
#line 1116 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp6_ = from->file_format;
#line 1116 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	self->file_format = _tmp6_;
#line 1117 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp7_ = from->dim;
#line 1117 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	self->dim = _tmp7_;
#line 1118 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp8_ = from->original_orientation;
#line 1118 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	self->original_orientation = _tmp8_;
#line 7499 "PhotoTable.c"
}


BackingPhotoRow*
backing_photo_row_construct (GType object_type)
{
	BackingPhotoRow* self = NULL;
#line 1085 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	self = (BackingPhotoRow*) g_type_create_instance (object_type);
#line 1085 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	return self;
#line 7511 "PhotoTable.c"
}


BackingPhotoRow*
backing_photo_row_new (void)
{
#line 1085 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	return backing_photo_row_construct (TYPE_BACKING_PHOTO_ROW);
#line 7520 "PhotoTable.c"
}


static void
value_backing_photo_row_init (GValue* value)
{
#line 1085 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	value->data[0].v_pointer = NULL;
#line 7529 "PhotoTable.c"
}


static void
value_backing_photo_row_free_value (GValue* value)
{
#line 1085 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (value->data[0].v_pointer) {
#line 1085 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		backing_photo_row_unref (value->data[0].v_pointer);
#line 7540 "PhotoTable.c"
	}
}


static void
value_backing_photo_row_copy_value (const GValue* src_value,
                                    GValue* dest_value)
{
#line 1085 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (src_value->data[0].v_pointer) {
#line 1085 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		dest_value->data[0].v_pointer = backing_photo_row_ref (src_value->data[0].v_pointer);
#line 7553 "PhotoTable.c"
	} else {
#line 1085 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		dest_value->data[0].v_pointer = NULL;
#line 7557 "PhotoTable.c"
	}
}


static gpointer
value_backing_photo_row_peek_pointer (const GValue* value)
{
#line 1085 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	return value->data[0].v_pointer;
#line 7567 "PhotoTable.c"
}


static gchar*
value_backing_photo_row_collect_value (GValue* value,
                                       guint n_collect_values,
                                       GTypeCValue* collect_values,
                                       guint collect_flags)
{
#line 1085 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (collect_values[0].v_pointer) {
#line 7579 "PhotoTable.c"
		BackingPhotoRow * object;
		object = collect_values[0].v_pointer;
#line 1085 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		if (object->parent_instance.g_class == NULL) {
#line 1085 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 7586 "PhotoTable.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 1085 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 7590 "PhotoTable.c"
		}
#line 1085 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		value->data[0].v_pointer = backing_photo_row_ref (object);
#line 7594 "PhotoTable.c"
	} else {
#line 1085 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		value->data[0].v_pointer = NULL;
#line 7598 "PhotoTable.c"
	}
#line 1085 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	return NULL;
#line 7602 "PhotoTable.c"
}


static gchar*
value_backing_photo_row_lcopy_value (const GValue* value,
                                     guint n_collect_values,
                                     GTypeCValue* collect_values,
                                     guint collect_flags)
{
	BackingPhotoRow ** object_p;
	object_p = collect_values[0].v_pointer;
#line 1085 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (!object_p) {
#line 1085 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 7618 "PhotoTable.c"
	}
#line 1085 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (!value->data[0].v_pointer) {
#line 1085 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		*object_p = NULL;
#line 7624 "PhotoTable.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 1085 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		*object_p = value->data[0].v_pointer;
#line 7628 "PhotoTable.c"
	} else {
#line 1085 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		*object_p = backing_photo_row_ref (value->data[0].v_pointer);
#line 7632 "PhotoTable.c"
	}
#line 1085 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	return NULL;
#line 7636 "PhotoTable.c"
}


GParamSpec*
param_spec_backing_photo_row (const gchar* name,
                              const gchar* nick,
                              const gchar* blurb,
                              GType object_type,
                              GParamFlags flags)
{
	ParamSpecBackingPhotoRow* spec;
#line 1085 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_BACKING_PHOTO_ROW), NULL);
#line 1085 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 1085 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 1085 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	return G_PARAM_SPEC (spec);
#line 7656 "PhotoTable.c"
}


gpointer
value_get_backing_photo_row (const GValue* value)
{
#line 1085 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_BACKING_PHOTO_ROW), NULL);
#line 1085 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	return value->data[0].v_pointer;
#line 7667 "PhotoTable.c"
}


void
value_set_backing_photo_row (GValue* value,
                             gpointer v_object)
{
	BackingPhotoRow * old;
#line 1085 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_BACKING_PHOTO_ROW));
#line 1085 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	old = value->data[0].v_pointer;
#line 1085 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (v_object) {
#line 1085 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_BACKING_PHOTO_ROW));
#line 1085 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 1085 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		value->data[0].v_pointer = v_object;
#line 1085 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		backing_photo_row_ref (value->data[0].v_pointer);
#line 7690 "PhotoTable.c"
	} else {
#line 1085 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		value->data[0].v_pointer = NULL;
#line 7694 "PhotoTable.c"
	}
#line 1085 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (old) {
#line 1085 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		backing_photo_row_unref (old);
#line 7700 "PhotoTable.c"
	}
}


void
value_take_backing_photo_row (GValue* value,
                              gpointer v_object)
{
	BackingPhotoRow * old;
#line 1085 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_BACKING_PHOTO_ROW));
#line 1085 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	old = value->data[0].v_pointer;
#line 1085 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (v_object) {
#line 1085 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_BACKING_PHOTO_ROW));
#line 1085 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 1085 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		value->data[0].v_pointer = v_object;
#line 7722 "PhotoTable.c"
	} else {
#line 1085 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		value->data[0].v_pointer = NULL;
#line 7726 "PhotoTable.c"
	}
#line 1085 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (old) {
#line 1085 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		backing_photo_row_unref (old);
#line 7732 "PhotoTable.c"
	}
}


static void
backing_photo_row_class_init (BackingPhotoRowClass * klass)
{
#line 1085 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	backing_photo_row_parent_class = g_type_class_peek_parent (klass);
#line 1085 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	((BackingPhotoRowClass *) klass)->finalize = backing_photo_row_finalize;
#line 7744 "PhotoTable.c"
}


static void
backing_photo_row_instance_init (BackingPhotoRow * self)
{
#line 1088 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	self->filepath = NULL;
#line 1085 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	self->ref_count = 1;
#line 7755 "PhotoTable.c"
}


static void
backing_photo_row_finalize (BackingPhotoRow * obj)
{
	BackingPhotoRow * self;
#line 1085 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_BACKING_PHOTO_ROW, BackingPhotoRow);
#line 1085 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_signal_handlers_destroy (self);
#line 1088 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_g_free0 (self->filepath);
#line 7769 "PhotoTable.c"
}


GType
backing_photo_row_get_type (void)
{
	static volatile gsize backing_photo_row_type_id__volatile = 0;
	if (g_once_init_enter (&backing_photo_row_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_backing_photo_row_init, value_backing_photo_row_free_value, value_backing_photo_row_copy_value, value_backing_photo_row_peek_pointer, "p", value_backing_photo_row_collect_value, "p", value_backing_photo_row_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (BackingPhotoRowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) backing_photo_row_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BackingPhotoRow), 0, (GInstanceInitFunc) backing_photo_row_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType backing_photo_row_type_id;
		backing_photo_row_type_id = g_type_register_fundamental (g_type_fundamental_next (), "BackingPhotoRow", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&backing_photo_row_type_id__volatile, backing_photo_row_type_id);
	}
	return backing_photo_row_type_id__volatile;
}


gpointer
backing_photo_row_ref (gpointer instance)
{
	BackingPhotoRow * self;
	self = instance;
#line 1085 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_atomic_int_inc (&self->ref_count);
#line 1085 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	return instance;
#line 7798 "PhotoTable.c"
}


void
backing_photo_row_unref (gpointer instance)
{
	BackingPhotoRow * self;
	self = instance;
#line 1085 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 1085 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		BACKING_PHOTO_ROW_GET_CLASS (self)->finalize (self);
#line 1085 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 7813 "PhotoTable.c"
	}
}


static BackingPhotoTable*
backing_photo_table_construct (GType object_type)
{
	BackingPhotoTable* self = NULL;
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_;
	sqlite3_stmt* _tmp1_ = NULL;
	gint _tmp2_;
	gint _tmp3_;
	sqlite3_stmt* _tmp4_;
	gint _tmp5_;
#line 1125 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	self = (BackingPhotoTable*) database_table_construct (object_type);
#line 1126 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	database_table_set_table_name (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_TABLE, DatabaseTable), "BackingPhotoTable");
#line 1129 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp0_ = database_table_db;
#line 1129 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp2_ = sqlite3_prepare_v2 (_tmp0_, "CREATE TABLE IF NOT EXISTS " "BackingPhotoTable " "(" "id INTEGER PRIMARY KEY, " "filepath TEXT UNIQUE NOT NULL, " "timestamp INTEGER, " "filesize INTEGER, " "width INTEGER, " "height INTEGER, " "original_orientation INTEGER, " "file_format INTEGER, " "time_created INTEGER " ")", -1, &_tmp1_, NULL);
#line 1129 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_sqlite3_finalize0 (stmt);
#line 1129 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	stmt = _tmp1_;
#line 1129 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp2_;
#line 1142 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp3_ = res;
#line 1142 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp3_ == SQLITE_OK, "res == Sqlite.OK");
#line 1144 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp4_ = stmt;
#line 1144 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = sqlite3_step (_tmp4_);
#line 1145 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp5_ = res;
#line 1145 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (_tmp5_ != SQLITE_DONE) {
#line 7856 "PhotoTable.c"
		gint _tmp6_;
#line 1146 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp6_ = res;
#line 1146 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		database_table_fatal ("create PhotoBackingTable", _tmp6_);
#line 7862 "PhotoTable.c"
	}
#line 1125 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_sqlite3_finalize0 (stmt);
#line 1125 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	return self;
#line 7868 "PhotoTable.c"
}


static BackingPhotoTable*
backing_photo_table_new (void)
{
#line 1125 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	return backing_photo_table_construct (TYPE_BACKING_PHOTO_TABLE);
#line 7877 "PhotoTable.c"
}


BackingPhotoTable*
backing_photo_table_get_instance (void)
{
	BackingPhotoTable* result = NULL;
	BackingPhotoTable* _tmp0_;
	BackingPhotoTable* _tmp2_;
	BackingPhotoTable* _tmp3_;
#line 1150 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp0_ = backing_photo_table_instance;
#line 1150 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (_tmp0_ == NULL) {
#line 7892 "PhotoTable.c"
		BackingPhotoTable* _tmp1_;
#line 1151 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp1_ = backing_photo_table_new ();
#line 1151 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_database_table_unref0 (backing_photo_table_instance);
#line 1151 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		backing_photo_table_instance = _tmp1_;
#line 7900 "PhotoTable.c"
	}
#line 1153 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp2_ = backing_photo_table_instance;
#line 1153 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp3_ = _database_table_ref0 (_tmp2_);
#line 1153 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	result = _tmp3_;
#line 1153 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	return result;
#line 7910 "PhotoTable.c"
}


void
backing_photo_table_add (BackingPhotoTable* self,
                         BackingPhotoRow* state,
                         GError** error)
{
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_;
	sqlite3_stmt* _tmp1_ = NULL;
	gint _tmp2_;
	gint _tmp3_;
	time_t time_created = 0;
	sqlite3_stmt* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	GDestroyNotify _tmp7_;
	gint _tmp8_;
	sqlite3_stmt* _tmp9_;
	time_t _tmp10_;
	gint _tmp11_;
	sqlite3_stmt* _tmp12_;
	gint64 _tmp13_;
	gint _tmp14_;
	sqlite3_stmt* _tmp15_;
	Dimensions _tmp16_;
	gint _tmp17_;
	gint _tmp18_;
	sqlite3_stmt* _tmp19_;
	Dimensions _tmp20_;
	gint _tmp21_;
	gint _tmp22_;
	sqlite3_stmt* _tmp23_;
	Orientation _tmp24_;
	gint _tmp25_;
	sqlite3_stmt* _tmp26_;
	PhotoFileFormat _tmp27_;
	gint _tmp28_;
	sqlite3_stmt* _tmp29_;
	time_t _tmp30_;
	gint _tmp31_;
	sqlite3_stmt* _tmp32_;
	gint _tmp33_;
	sqlite3* _tmp35_;
	time_t _tmp36_;
	GError * _inner_error_ = NULL;
#line 1156 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_if_fail (IS_BACKING_PHOTO_TABLE (self));
#line 1156 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_if_fail (IS_BACKING_PHOTO_ROW (state));
#line 1158 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp0_ = database_table_db;
#line 1158 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp2_ = sqlite3_prepare_v2 (_tmp0_, "INSERT INTO BackingPhotoTable " "(filepath, timestamp, filesize, width, height, original_orientation, " "file_format, time_created) " "VALUES (?, ?, ?, ?, ?, ?, ?, ?)", -1, &_tmp1_, NULL);
#line 1158 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_sqlite3_finalize0 (stmt);
#line 1158 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	stmt = _tmp1_;
#line 1158 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp2_;
#line 1163 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp3_ = res;
#line 1163 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp3_ == SQLITE_OK, "res == Sqlite.OK");
#line 1165 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	time_created = (time_t) now_sec ();
#line 1167 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp4_ = stmt;
#line 1167 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp5_ = state->filepath;
#line 1167 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp6_ = g_strdup (_tmp5_);
#line 1167 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp7_ = g_free;
#line 1167 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = sqlite3_bind_text (_tmp4_, 1, _tmp6_, -1, _tmp7_);
#line 1168 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp8_ = res;
#line 1168 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp8_ == SQLITE_OK, "res == Sqlite.OK");
#line 1169 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp9_ = stmt;
#line 1169 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp10_ = state->timestamp;
#line 1169 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = sqlite3_bind_int64 (_tmp9_, 2, (gint64) _tmp10_);
#line 1170 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp11_ = res;
#line 1170 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp11_ == SQLITE_OK, "res == Sqlite.OK");
#line 1171 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp12_ = stmt;
#line 1171 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp13_ = state->filesize;
#line 1171 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = sqlite3_bind_int64 (_tmp12_, 3, _tmp13_);
#line 1172 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp14_ = res;
#line 1172 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp14_ == SQLITE_OK, "res == Sqlite.OK");
#line 1173 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp15_ = stmt;
#line 1173 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp16_ = state->dim;
#line 1173 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp17_ = _tmp16_.width;
#line 1173 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = sqlite3_bind_int (_tmp15_, 4, _tmp17_);
#line 1174 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp18_ = res;
#line 1174 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp18_ == SQLITE_OK, "res == Sqlite.OK");
#line 1175 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp19_ = stmt;
#line 1175 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp20_ = state->dim;
#line 1175 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp21_ = _tmp20_.height;
#line 1175 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = sqlite3_bind_int (_tmp19_, 5, _tmp21_);
#line 1176 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp22_ = res;
#line 1176 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp22_ == SQLITE_OK, "res == Sqlite.OK");
#line 1177 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp23_ = stmt;
#line 1177 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp24_ = state->original_orientation;
#line 1177 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = sqlite3_bind_int (_tmp23_, 6, (gint) _tmp24_);
#line 1178 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp25_ = res;
#line 1178 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp25_ == SQLITE_OK, "res == Sqlite.OK");
#line 1179 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp26_ = stmt;
#line 1179 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp27_ = state->file_format;
#line 1179 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = sqlite3_bind_int (_tmp26_, 7, photo_file_format_serialize (_tmp27_));
#line 1180 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp28_ = res;
#line 1180 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp28_ == SQLITE_OK, "res == Sqlite.OK");
#line 1181 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp29_ = stmt;
#line 1181 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp30_ = time_created;
#line 1181 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = sqlite3_bind_int64 (_tmp29_, 8, (gint64) _tmp30_);
#line 1182 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp31_ = res;
#line 1182 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp31_ == SQLITE_OK, "res == Sqlite.OK");
#line 1184 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp32_ = stmt;
#line 1184 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = sqlite3_step (_tmp32_);
#line 1185 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp33_ = res;
#line 1185 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (_tmp33_ != SQLITE_DONE) {
#line 8075 "PhotoTable.c"
		gint _tmp34_;
#line 1186 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp34_ = res;
#line 1186 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		database_table_throw_error ("PhotoBackingTable.add", _tmp34_, &_inner_error_);
#line 1186 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1186 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			if (_inner_error_->domain == DATABASE_ERROR) {
#line 1186 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				g_propagate_error (error, _inner_error_);
#line 1186 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				_sqlite3_finalize0 (stmt);
#line 1186 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				return;
#line 8091 "PhotoTable.c"
			} else {
#line 1186 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				_sqlite3_finalize0 (stmt);
#line 1186 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1186 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				g_clear_error (&_inner_error_);
#line 1186 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				return;
#line 8101 "PhotoTable.c"
			}
		}
	}
#line 1188 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp35_ = database_table_db;
#line 1188 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	backing_photo_id_init (&state->id, sqlite3_last_insert_rowid (_tmp35_));
#line 1189 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp36_ = time_created;
#line 1189 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	state->time_created = _tmp36_;
#line 1156 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_sqlite3_finalize0 (stmt);
#line 8115 "PhotoTable.c"
}


BackingPhotoRow*
backing_photo_table_fetch (BackingPhotoTable* self,
                           BackingPhotoID* id,
                           GError** error)
{
	BackingPhotoRow* result = NULL;
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_;
	sqlite3_stmt* _tmp1_ = NULL;
	gint _tmp2_;
	gint _tmp3_;
	sqlite3_stmt* _tmp4_;
	BackingPhotoID _tmp5_;
	gint64 _tmp6_;
	gint _tmp7_;
	sqlite3_stmt* _tmp8_;
	gint _tmp9_;
	BackingPhotoRow* row = NULL;
	BackingPhotoRow* _tmp12_;
	BackingPhotoRow* _tmp13_;
	BackingPhotoID _tmp14_;
	BackingPhotoRow* _tmp15_;
	sqlite3_stmt* _tmp16_;
	const gchar* _tmp17_;
	gchar* _tmp18_;
	BackingPhotoRow* _tmp19_;
	sqlite3_stmt* _tmp20_;
	BackingPhotoRow* _tmp21_;
	sqlite3_stmt* _tmp22_;
	BackingPhotoRow* _tmp23_;
	sqlite3_stmt* _tmp24_;
	sqlite3_stmt* _tmp25_;
	BackingPhotoRow* _tmp26_;
	sqlite3_stmt* _tmp27_;
	BackingPhotoRow* _tmp28_;
	sqlite3_stmt* _tmp29_;
	BackingPhotoRow* _tmp30_;
	sqlite3_stmt* _tmp31_;
	GError * _inner_error_ = NULL;
#line 1192 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_val_if_fail (IS_BACKING_PHOTO_TABLE (self), NULL);
#line 1192 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_val_if_fail (id != NULL, NULL);
#line 1194 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp0_ = database_table_db;
#line 1194 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp2_ = sqlite3_prepare_v2 (_tmp0_, "SELECT filepath, timestamp, filesize, width, height, " "original_orientation, file_format, time_created FROM BackingPhotoTable" \
" WHERE id=?", -1, &_tmp1_, NULL);
#line 1194 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_sqlite3_finalize0 (stmt);
#line 1194 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	stmt = _tmp1_;
#line 1194 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp2_;
#line 1197 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp3_ = res;
#line 1197 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp3_ == SQLITE_OK, "res == Sqlite.OK");
#line 1199 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp4_ = stmt;
#line 1199 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp5_ = *id;
#line 1199 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp6_ = _tmp5_.id;
#line 1199 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = sqlite3_bind_int64 (_tmp4_, 1, _tmp6_);
#line 1200 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp7_ = res;
#line 1200 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp7_ == SQLITE_OK, "res == Sqlite.OK");
#line 1202 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp8_ = stmt;
#line 1202 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = sqlite3_step (_tmp8_);
#line 1203 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp9_ = res;
#line 1203 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (_tmp9_ == SQLITE_DONE) {
#line 1204 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		result = NULL;
#line 1204 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_sqlite3_finalize0 (stmt);
#line 1204 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		return result;
#line 8203 "PhotoTable.c"
	} else {
		gint _tmp10_;
#line 1205 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp10_ = res;
#line 1205 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		if (_tmp10_ != SQLITE_ROW) {
#line 8210 "PhotoTable.c"
			gint _tmp11_;
#line 1206 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			_tmp11_ = res;
#line 1206 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			database_table_throw_error ("BackingPhotoTable.fetch_for_photo", _tmp11_, &_inner_error_);
#line 1206 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1206 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				if (_inner_error_->domain == DATABASE_ERROR) {
#line 1206 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
					g_propagate_error (error, _inner_error_);
#line 1206 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
					_sqlite3_finalize0 (stmt);
#line 1206 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
					return NULL;
#line 8226 "PhotoTable.c"
				} else {
#line 1206 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
					_sqlite3_finalize0 (stmt);
#line 1206 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1206 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
					g_clear_error (&_inner_error_);
#line 1206 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
					return NULL;
#line 8236 "PhotoTable.c"
				}
			}
		}
	}
#line 1208 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp12_ = backing_photo_row_new ();
#line 1208 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	row = _tmp12_;
#line 1209 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp13_ = row;
#line 1209 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp14_ = *id;
#line 1209 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp13_->id = _tmp14_;
#line 1210 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp15_ = row;
#line 1210 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp16_ = stmt;
#line 1210 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp17_ = sqlite3_column_text (_tmp16_, 0);
#line 1210 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp18_ = g_strdup (_tmp17_);
#line 1210 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_g_free0 (_tmp15_->filepath);
#line 1210 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp15_->filepath = _tmp18_;
#line 1211 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp19_ = row;
#line 1211 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp20_ = stmt;
#line 1211 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp19_->timestamp = (time_t) sqlite3_column_int64 (_tmp20_, 1);
#line 1212 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp21_ = row;
#line 1212 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp22_ = stmt;
#line 1212 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp21_->filesize = sqlite3_column_int64 (_tmp22_, 2);
#line 1213 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp23_ = row;
#line 1213 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp24_ = stmt;
#line 1213 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp25_ = stmt;
#line 1213 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	dimensions_init (&_tmp23_->dim, sqlite3_column_int (_tmp24_, 3), sqlite3_column_int (_tmp25_, 4));
#line 1214 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp26_ = row;
#line 1214 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp27_ = stmt;
#line 1214 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp26_->original_orientation = (Orientation) sqlite3_column_int (_tmp27_, 5);
#line 1215 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp28_ = row;
#line 1215 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp29_ = stmt;
#line 1215 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp28_->file_format = photo_file_format_unserialize (sqlite3_column_int (_tmp29_, 6));
#line 1216 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp30_ = row;
#line 1216 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp31_ = stmt;
#line 1216 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp30_->time_created = (time_t) sqlite3_column_int64 (_tmp31_, 7);
#line 1218 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	result = row;
#line 1218 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_sqlite3_finalize0 (stmt);
#line 1218 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	return result;
#line 8307 "PhotoTable.c"
}


void
backing_photo_table_update (BackingPhotoTable* self,
                            BackingPhotoRow* row,
                            GError** error)
{
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_;
	sqlite3_stmt* _tmp1_ = NULL;
	gint _tmp2_;
	gint _tmp3_;
	sqlite3_stmt* _tmp4_;
	time_t _tmp5_;
	gint _tmp6_;
	sqlite3_stmt* _tmp7_;
	gint64 _tmp8_;
	gint _tmp9_;
	sqlite3_stmt* _tmp10_;
	Dimensions _tmp11_;
	gint _tmp12_;
	gint _tmp13_;
	sqlite3_stmt* _tmp14_;
	Dimensions _tmp15_;
	gint _tmp16_;
	gint _tmp17_;
	sqlite3_stmt* _tmp18_;
	Orientation _tmp19_;
	gint _tmp20_;
	sqlite3_stmt* _tmp21_;
	PhotoFileFormat _tmp22_;
	gint _tmp23_;
	sqlite3_stmt* _tmp24_;
	BackingPhotoID _tmp25_;
	gint64 _tmp26_;
	gint _tmp27_;
	sqlite3_stmt* _tmp28_;
	gint _tmp29_;
	GError * _inner_error_ = NULL;
#line 1222 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_if_fail (IS_BACKING_PHOTO_TABLE (self));
#line 1222 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_if_fail (IS_BACKING_PHOTO_ROW (row));
#line 1224 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp0_ = database_table_db;
#line 1224 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp2_ = sqlite3_prepare_v2 (_tmp0_, "UPDATE BackingPhotoTable SET timestamp=?, filesize=?, " "width=?, height=?, original_orientation=?, file_format=? " "WHERE id=?", -1, &_tmp1_, NULL);
#line 1224 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_sqlite3_finalize0 (stmt);
#line 1224 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	stmt = _tmp1_;
#line 1224 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp2_;
#line 1228 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp3_ = res;
#line 1228 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp3_ == SQLITE_OK, "res == Sqlite.OK");
#line 1230 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp4_ = stmt;
#line 1230 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp5_ = row->timestamp;
#line 1230 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = sqlite3_bind_int64 (_tmp4_, 1, (gint64) _tmp5_);
#line 1231 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp6_ = res;
#line 1231 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp6_ == SQLITE_OK, "res == Sqlite.OK");
#line 1232 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp7_ = stmt;
#line 1232 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp8_ = row->filesize;
#line 1232 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = sqlite3_bind_int64 (_tmp7_, 2, _tmp8_);
#line 1233 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp9_ = res;
#line 1233 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp9_ == SQLITE_OK, "res == Sqlite.OK");
#line 1234 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp10_ = stmt;
#line 1234 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp11_ = row->dim;
#line 1234 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp12_ = _tmp11_.width;
#line 1234 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = sqlite3_bind_int (_tmp10_, 3, _tmp12_);
#line 1235 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp13_ = res;
#line 1235 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp13_ == SQLITE_OK, "res == Sqlite.OK");
#line 1236 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp14_ = stmt;
#line 1236 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp15_ = row->dim;
#line 1236 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp16_ = _tmp15_.height;
#line 1236 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = sqlite3_bind_int (_tmp14_, 4, _tmp16_);
#line 1237 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp17_ = res;
#line 1237 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp17_ == SQLITE_OK, "res == Sqlite.OK");
#line 1238 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp18_ = stmt;
#line 1238 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp19_ = row->original_orientation;
#line 1238 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = sqlite3_bind_int (_tmp18_, 5, (gint) _tmp19_);
#line 1239 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp20_ = res;
#line 1239 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp20_ == SQLITE_OK, "res == Sqlite.OK");
#line 1240 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp21_ = stmt;
#line 1240 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp22_ = row->file_format;
#line 1240 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = sqlite3_bind_int (_tmp21_, 6, photo_file_format_serialize (_tmp22_));
#line 1241 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp23_ = res;
#line 1241 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp23_ == SQLITE_OK, "res == Sqlite.OK");
#line 1242 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp24_ = stmt;
#line 1242 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp25_ = row->id;
#line 1242 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp26_ = _tmp25_.id;
#line 1242 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = sqlite3_bind_int64 (_tmp24_, 7, _tmp26_);
#line 1243 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp27_ = res;
#line 1243 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp27_ == SQLITE_OK, "res == Sqlite.OK");
#line 1245 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp28_ = stmt;
#line 1245 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = sqlite3_step (_tmp28_);
#line 1246 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp29_ = res;
#line 1246 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (_tmp29_ != SQLITE_DONE) {
#line 8451 "PhotoTable.c"
		gint _tmp30_;
#line 1247 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp30_ = res;
#line 1247 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		database_table_throw_error ("BackingPhotoTable.update", _tmp30_, &_inner_error_);
#line 1247 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1247 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			if (_inner_error_->domain == DATABASE_ERROR) {
#line 1247 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				g_propagate_error (error, _inner_error_);
#line 1247 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				_sqlite3_finalize0 (stmt);
#line 1247 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				return;
#line 8467 "PhotoTable.c"
			} else {
#line 1247 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				_sqlite3_finalize0 (stmt);
#line 1247 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1247 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				g_clear_error (&_inner_error_);
#line 1247 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				return;
#line 8477 "PhotoTable.c"
			}
		}
	}
#line 1222 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_sqlite3_finalize0 (stmt);
#line 8483 "PhotoTable.c"
}


void
backing_photo_table_update_attributes (BackingPhotoTable* self,
                                       BackingPhotoID* id,
                                       time_t timestamp,
                                       gint64 filesize,
                                       GError** error)
{
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_;
	sqlite3_stmt* _tmp1_ = NULL;
	gint _tmp2_;
	gint _tmp3_;
	sqlite3_stmt* _tmp4_;
	gint _tmp5_;
	sqlite3_stmt* _tmp6_;
	gint _tmp7_;
	sqlite3_stmt* _tmp8_;
	BackingPhotoID _tmp9_;
	gint64 _tmp10_;
	gint _tmp11_;
	sqlite3_stmt* _tmp12_;
	gint _tmp13_;
	GError * _inner_error_ = NULL;
#line 1250 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_if_fail (IS_BACKING_PHOTO_TABLE (self));
#line 1250 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_if_fail (id != NULL);
#line 1252 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp0_ = database_table_db;
#line 1252 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp2_ = sqlite3_prepare_v2 (_tmp0_, "UPDATE BackingPhotoTable SET timestamp=?, filesize=? WHERE id=?", -1, &_tmp1_, NULL);
#line 1252 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_sqlite3_finalize0 (stmt);
#line 1252 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	stmt = _tmp1_;
#line 1252 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = _tmp2_;
#line 1254 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp3_ = res;
#line 1254 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp3_ == SQLITE_OK, "res == Sqlite.OK");
#line 1256 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp4_ = stmt;
#line 1256 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = sqlite3_bind_int64 (_tmp4_, 1, (gint64) timestamp);
#line 1257 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp5_ = res;
#line 1257 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp5_ == SQLITE_OK, "res == Sqlite.OK");
#line 1258 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp6_ = stmt;
#line 1258 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = sqlite3_bind_int64 (_tmp6_, 2, filesize);
#line 1259 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp7_ = res;
#line 1259 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp7_ == SQLITE_OK, "res == Sqlite.OK");
#line 1260 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp8_ = stmt;
#line 1260 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp9_ = *id;
#line 1260 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp10_ = _tmp9_.id;
#line 1260 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = sqlite3_bind_int64 (_tmp8_, 3, _tmp10_);
#line 1261 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp11_ = res;
#line 1261 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_vala_assert (_tmp11_ == SQLITE_OK, "res == Sqlite.OK");
#line 1263 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp12_ = stmt;
#line 1263 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	res = sqlite3_step (_tmp12_);
#line 1264 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp13_ = res;
#line 1264 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (_tmp13_ != SQLITE_DONE) {
#line 8565 "PhotoTable.c"
		gint _tmp14_;
#line 1265 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		_tmp14_ = res;
#line 1265 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		database_table_throw_error ("BackingPhotoTable.update_attributes", _tmp14_, &_inner_error_);
#line 1265 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1265 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			if (_inner_error_->domain == DATABASE_ERROR) {
#line 1265 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				g_propagate_error (error, _inner_error_);
#line 1265 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				_sqlite3_finalize0 (stmt);
#line 1265 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				return;
#line 8581 "PhotoTable.c"
			} else {
#line 1265 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				_sqlite3_finalize0 (stmt);
#line 1265 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1265 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				g_clear_error (&_inner_error_);
#line 1265 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
				return;
#line 8591 "PhotoTable.c"
			}
		}
	}
#line 1250 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_sqlite3_finalize0 (stmt);
#line 8597 "PhotoTable.c"
}


void
backing_photo_table_remove (BackingPhotoTable* self,
                            BackingPhotoID* backing_id,
                            GError** error)
{
	BackingPhotoID _tmp0_;
	gint64 _tmp1_;
	GError * _inner_error_ = NULL;
#line 1268 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_if_fail (IS_BACKING_PHOTO_TABLE (self));
#line 1268 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_if_fail (backing_id != NULL);
#line 1269 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp0_ = *backing_id;
#line 1269 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp1_ = _tmp0_.id;
#line 1269 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	database_table_delete_by_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_TABLE, DatabaseTable), _tmp1_, &_inner_error_);
#line 1269 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1269 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		if (_inner_error_->domain == DATABASE_ERROR) {
#line 1269 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			g_propagate_error (error, _inner_error_);
#line 1269 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			return;
#line 8627 "PhotoTable.c"
		} else {
#line 1269 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1269 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			g_clear_error (&_inner_error_);
#line 1269 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			return;
#line 8635 "PhotoTable.c"
		}
	}
}


void
backing_photo_table_set_filepath (BackingPhotoTable* self,
                                  BackingPhotoID* id,
                                  const gchar* filepath,
                                  GError** error)
{
	BackingPhotoID _tmp0_;
	gint64 _tmp1_;
	GError * _inner_error_ = NULL;
#line 1272 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_if_fail (IS_BACKING_PHOTO_TABLE (self));
#line 1272 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_if_fail (id != NULL);
#line 1272 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_if_fail (filepath != NULL);
#line 1273 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp0_ = *id;
#line 1273 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp1_ = _tmp0_.id;
#line 1273 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	database_table_update_text_by_id_2 (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_TABLE, DatabaseTable), _tmp1_, "filepath", filepath, &_inner_error_);
#line 1273 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1273 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		if (_inner_error_->domain == DATABASE_ERROR) {
#line 1273 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			g_propagate_error (error, _inner_error_);
#line 1273 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			return;
#line 8670 "PhotoTable.c"
		} else {
#line 1273 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1273 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			g_clear_error (&_inner_error_);
#line 1273 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			return;
#line 8678 "PhotoTable.c"
		}
	}
}


void
backing_photo_table_update_timestamp (BackingPhotoTable* self,
                                      BackingPhotoID* id,
                                      time_t timestamp,
                                      GError** error)
{
	BackingPhotoID _tmp0_;
	gint64 _tmp1_;
	GError * _inner_error_ = NULL;
#line 1276 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_if_fail (IS_BACKING_PHOTO_TABLE (self));
#line 1276 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	g_return_if_fail (id != NULL);
#line 1277 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp0_ = *id;
#line 1277 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	_tmp1_ = _tmp0_.id;
#line 1277 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	database_table_update_int64_by_id_2 (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_TABLE, DatabaseTable), _tmp1_, "timestamp", (gint64) timestamp, &_inner_error_);
#line 1277 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1277 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
		if (_inner_error_->domain == DATABASE_ERROR) {
#line 1277 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			g_propagate_error (error, _inner_error_);
#line 1277 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			return;
#line 8711 "PhotoTable.c"
		} else {
#line 1277 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1277 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			g_clear_error (&_inner_error_);
#line 1277 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
			return;
#line 8719 "PhotoTable.c"
		}
	}
}


static void
backing_photo_table_class_init (BackingPhotoTableClass * klass)
{
#line 1122 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	backing_photo_table_parent_class = g_type_class_peek_parent (klass);
#line 1122 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	((DatabaseTableClass *) klass)->finalize = backing_photo_table_finalize;
#line 8732 "PhotoTable.c"
}


static void
backing_photo_table_instance_init (BackingPhotoTable * self)
{
}


static void
backing_photo_table_finalize (DatabaseTable * obj)
{
	BackingPhotoTable * self;
#line 1122 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_BACKING_PHOTO_TABLE, BackingPhotoTable);
#line 1122 "/home/jens/Source/shotwell/src/db/PhotoTable.vala"
	DATABASE_TABLE_CLASS (backing_photo_table_parent_class)->finalize (obj);
#line 8750 "PhotoTable.c"
}


GType
backing_photo_table_get_type (void)
{
	static volatile gsize backing_photo_table_type_id__volatile = 0;
	if (g_once_init_enter (&backing_photo_table_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BackingPhotoTableClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) backing_photo_table_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BackingPhotoTable), 0, (GInstanceInitFunc) backing_photo_table_instance_init, NULL };
		GType backing_photo_table_type_id;
		backing_photo_table_type_id = g_type_register_static (TYPE_DATABASE_TABLE, "BackingPhotoTable", &g_define_type_info, 0);
		g_once_init_leave (&backing_photo_table_type_id__volatile, backing_photo_table_type_id);
	}
	return backing_photo_table_type_id__volatile;
}


static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



