/* APIGlue.c generated by valac 0.40.4, the Vala compiler
 * generated from APIGlue.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */


#include <glib.h>
#include <glib-object.h>
#include "shotwell-plugin-dev-1.0.h"
#include <gio/gio.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>


#define PUBLISHING_GLUE_TYPE_MEDIA_SOURCE_PUBLISHABLE_WRAPPER (publishing_glue_media_source_publishable_wrapper_get_type ())
#define PUBLISHING_GLUE_MEDIA_SOURCE_PUBLISHABLE_WRAPPER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PUBLISHING_GLUE_TYPE_MEDIA_SOURCE_PUBLISHABLE_WRAPPER, PublishingGlueMediaSourcePublishableWrapper))
#define PUBLISHING_GLUE_MEDIA_SOURCE_PUBLISHABLE_WRAPPER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PUBLISHING_GLUE_TYPE_MEDIA_SOURCE_PUBLISHABLE_WRAPPER, PublishingGlueMediaSourcePublishableWrapperClass))
#define PUBLISHING_GLUE_IS_MEDIA_SOURCE_PUBLISHABLE_WRAPPER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PUBLISHING_GLUE_TYPE_MEDIA_SOURCE_PUBLISHABLE_WRAPPER))
#define PUBLISHING_GLUE_IS_MEDIA_SOURCE_PUBLISHABLE_WRAPPER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PUBLISHING_GLUE_TYPE_MEDIA_SOURCE_PUBLISHABLE_WRAPPER))
#define PUBLISHING_GLUE_MEDIA_SOURCE_PUBLISHABLE_WRAPPER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PUBLISHING_GLUE_TYPE_MEDIA_SOURCE_PUBLISHABLE_WRAPPER, PublishingGlueMediaSourcePublishableWrapperClass))

typedef struct _PublishingGlueMediaSourcePublishableWrapper PublishingGlueMediaSourcePublishableWrapper;
typedef struct _PublishingGlueMediaSourcePublishableWrapperClass PublishingGlueMediaSourcePublishableWrapperClass;
typedef struct _PublishingGlueMediaSourcePublishableWrapperPrivate PublishingGlueMediaSourcePublishableWrapperPrivate;

#define TYPE_DATA_OBJECT (data_object_get_type ())
#define DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_OBJECT, DataObject))
#define DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_OBJECT, DataObjectClass))
#define IS_DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_OBJECT))
#define IS_DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_OBJECT))
#define DATA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_OBJECT, DataObjectClass))

typedef struct _DataObject DataObject;
typedef struct _DataObjectClass DataObjectClass;

#define TYPE_DATA_SOURCE (data_source_get_type ())
#define DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_SOURCE, DataSource))
#define DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_SOURCE, DataSourceClass))
#define IS_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_SOURCE))
#define IS_DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_SOURCE))
#define DATA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_SOURCE, DataSourceClass))

typedef struct _DataSource DataSource;
typedef struct _DataSourceClass DataSourceClass;

#define TYPE_THUMBNAIL_SOURCE (thumbnail_source_get_type ())
#define THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSource))
#define THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))
#define IS_THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THUMBNAIL_SOURCE))
#define IS_THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THUMBNAIL_SOURCE))
#define THUMBNAIL_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))

typedef struct _ThumbnailSource ThumbnailSource;
typedef struct _ThumbnailSourceClass ThumbnailSourceClass;

#define TYPE_MEDIA_SOURCE (media_source_get_type ())
#define MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_SOURCE, MediaSource))
#define MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_SOURCE, MediaSourceClass))
#define IS_MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_SOURCE))
#define IS_MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_SOURCE))
#define MEDIA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_SOURCE, MediaSourceClass))

typedef struct _MediaSource MediaSource;
typedef struct _MediaSourceClass MediaSourceClass;
enum  {
	PUBLISHING_GLUE_MEDIA_SOURCE_PUBLISHABLE_WRAPPER_0_PROPERTY,
	PUBLISHING_GLUE_MEDIA_SOURCE_PUBLISHABLE_WRAPPER_NUM_PROPERTIES
};
static GParamSpec* publishing_glue_media_source_publishable_wrapper_properties[PUBLISHING_GLUE_MEDIA_SOURCE_PUBLISHABLE_WRAPPER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_EVENT_SOURCE (event_source_get_type ())
#define EVENT_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EVENT_SOURCE, EventSource))
#define EVENT_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EVENT_SOURCE, EventSourceClass))
#define IS_EVENT_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EVENT_SOURCE))
#define IS_EVENT_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EVENT_SOURCE))
#define EVENT_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EVENT_SOURCE, EventSourceClass))

typedef struct _EventSource EventSource;
typedef struct _EventSourceClass EventSourceClass;

#define TYPE_EVENT (event_get_type ())
#define EVENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EVENT, Event))
#define EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EVENT, EventClass))
#define IS_EVENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EVENT))
#define IS_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EVENT))
#define EVENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EVENT, EventClass))

typedef struct _Event Event;
typedef struct _EventClass EventClass;

#define TYPE_PHOTO_SOURCE (photo_source_get_type ())
#define PHOTO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_SOURCE, PhotoSource))
#define PHOTO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_SOURCE, PhotoSourceClass))
#define IS_PHOTO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_SOURCE))
#define IS_PHOTO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_SOURCE))
#define PHOTO_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_SOURCE, PhotoSourceClass))

typedef struct _PhotoSource PhotoSource;
typedef struct _PhotoSourceClass PhotoSourceClass;

#define TYPE_PHOTO (photo_get_type ())
#define PHOTO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO, Photo))
#define PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO, PhotoClass))
#define IS_PHOTO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO))
#define IS_PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO))
#define PHOTO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO, PhotoClass))

typedef struct _Photo Photo;
typedef struct _PhotoClass PhotoClass;

#define TYPE_LIBRARY_PHOTO (library_photo_get_type ())
#define LIBRARY_PHOTO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LIBRARY_PHOTO, LibraryPhoto))
#define LIBRARY_PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LIBRARY_PHOTO, LibraryPhotoClass))
#define IS_LIBRARY_PHOTO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LIBRARY_PHOTO))
#define IS_LIBRARY_PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LIBRARY_PHOTO))
#define LIBRARY_PHOTO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LIBRARY_PHOTO, LibraryPhotoClass))

typedef struct _LibraryPhoto LibraryPhoto;
typedef struct _LibraryPhotoClass LibraryPhotoClass;

#define TYPE_SCALING (scaling_get_type ())

#define TYPE_SCALE_CONSTRAINT (scale_constraint_get_type ())

#define TYPE_DIMENSIONS (dimensions_get_type ())
typedef struct _Dimensions Dimensions;
typedef struct _Scaling Scaling;

#define JPEG_TYPE_QUALITY (jpeg_quality_get_type ())

#define TYPE_PHOTO_FILE_FORMAT (photo_file_format_get_type ())

#define TYPE_VIDEO_SOURCE (video_source_get_type ())
#define VIDEO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIDEO_SOURCE, VideoSource))
#define VIDEO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIDEO_SOURCE, VideoSourceClass))
#define IS_VIDEO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIDEO_SOURCE))
#define IS_VIDEO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIDEO_SOURCE))
#define VIDEO_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIDEO_SOURCE, VideoSourceClass))

typedef struct _VideoSource VideoSource;
typedef struct _VideoSourceClass VideoSourceClass;

#define TYPE_VIDEO (video_get_type ())
#define VIDEO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIDEO, Video))
#define VIDEO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIDEO, VideoClass))
#define IS_VIDEO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIDEO))
#define IS_VIDEO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIDEO))
#define VIDEO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIDEO, VideoClass))

typedef struct _Video Video;
typedef struct _VideoClass VideoClass;

#define TYPE_TAG (tag_get_type ())
#define TAG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TAG, Tag))
#define TAG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TAG, TagClass))
#define IS_TAG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TAG))
#define IS_TAG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TAG))
#define TAG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TAG, TagClass))

typedef struct _Tag Tag;
typedef struct _TagClass TagClass;

#define TYPE_DATA_COLLECTION (data_collection_get_type ())
#define DATA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_COLLECTION, DataCollection))
#define DATA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_COLLECTION, DataCollectionClass))
#define IS_DATA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_COLLECTION))
#define IS_DATA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_COLLECTION))
#define DATA_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_COLLECTION, DataCollectionClass))

typedef struct _DataCollection DataCollection;
typedef struct _DataCollectionClass DataCollectionClass;

#define TYPE_SOURCE_COLLECTION (source_collection_get_type ())
#define SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SOURCE_COLLECTION, SourceCollection))
#define SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SOURCE_COLLECTION, SourceCollectionClass))
#define IS_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SOURCE_COLLECTION))
#define IS_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SOURCE_COLLECTION))
#define SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SOURCE_COLLECTION, SourceCollectionClass))

typedef struct _SourceCollection SourceCollection;
typedef struct _SourceCollectionClass SourceCollectionClass;

#define TYPE_DATABASE_SOURCE_COLLECTION (database_source_collection_get_type ())
#define DATABASE_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollection))
#define DATABASE_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollectionClass))
#define IS_DATABASE_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATABASE_SOURCE_COLLECTION))
#define IS_DATABASE_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATABASE_SOURCE_COLLECTION))
#define DATABASE_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollectionClass))

typedef struct _DatabaseSourceCollection DatabaseSourceCollection;
typedef struct _DatabaseSourceCollectionClass DatabaseSourceCollectionClass;

#define TYPE_CONTAINER_SOURCE_COLLECTION (container_source_collection_get_type ())
#define CONTAINER_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONTAINER_SOURCE_COLLECTION, ContainerSourceCollection))
#define CONTAINER_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONTAINER_SOURCE_COLLECTION, ContainerSourceCollectionClass))
#define IS_CONTAINER_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONTAINER_SOURCE_COLLECTION))
#define IS_CONTAINER_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONTAINER_SOURCE_COLLECTION))
#define CONTAINER_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONTAINER_SOURCE_COLLECTION, ContainerSourceCollectionClass))

typedef struct _ContainerSourceCollection ContainerSourceCollection;
typedef struct _ContainerSourceCollectionClass ContainerSourceCollectionClass;

#define TYPE_TAG_SOURCE_COLLECTION (tag_source_collection_get_type ())
#define TAG_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TAG_SOURCE_COLLECTION, TagSourceCollection))
#define TAG_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TAG_SOURCE_COLLECTION, TagSourceCollectionClass))
#define IS_TAG_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TAG_SOURCE_COLLECTION))
#define IS_TAG_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TAG_SOURCE_COLLECTION))
#define TAG_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TAG_SOURCE_COLLECTION, TagSourceCollectionClass))

typedef struct _TagSourceCollection TagSourceCollection;
typedef struct _TagSourceCollectionClass TagSourceCollectionClass;

struct _PublishingGlueMediaSourcePublishableWrapper {
	GObject parent_instance;
	PublishingGlueMediaSourcePublishableWrapperPrivate * priv;
};

struct _PublishingGlueMediaSourcePublishableWrapperClass {
	GObjectClass parent_class;
};

struct _PublishingGlueMediaSourcePublishableWrapperPrivate {
	MediaSource* wrapped;
	GFile* serialized_file;
	GeeMap* param_string;
};

typedef enum  {
	SCALE_CONSTRAINT_ORIGINAL,
	SCALE_CONSTRAINT_DIMENSIONS,
	SCALE_CONSTRAINT_WIDTH,
	SCALE_CONSTRAINT_HEIGHT,
	SCALE_CONSTRAINT_FILL_VIEWPORT
} ScaleConstraint;

struct _Dimensions {
	gint width;
	gint height;
};

struct _Scaling {
	ScaleConstraint constraint;
	gint scale;
	Dimensions viewport;
	gboolean scale_up;
};

typedef enum  {
	JPEG_QUALITY_LOW = 50,
	JPEG_QUALITY_MEDIUM = 75,
	JPEG_QUALITY_HIGH = 90,
	JPEG_QUALITY_MAXIMUM = 100
} JpegQuality;

typedef enum  {
	PHOTO_FILE_FORMAT_JFIF,
	PHOTO_FILE_FORMAT_RAW,
	PHOTO_FILE_FORMAT_PNG,
	PHOTO_FILE_FORMAT_TIFF,
	PHOTO_FILE_FORMAT_BMP,
	PHOTO_FILE_FORMAT_UNKNOWN
} PhotoFileFormat;


static gpointer publishing_glue_media_source_publishable_wrapper_parent_class = NULL;
static gint publishing_glue_media_source_publishable_wrapper_name_ticker;
static gint publishing_glue_media_source_publishable_wrapper_name_ticker = 0;
extern TagSourceCollection* tag_global;
static SpitPublishingPublishableIface * publishing_glue_media_source_publishable_wrapper_spit_publishing_publishable_parent_iface = NULL;

GType publishing_glue_media_source_publishable_wrapper_get_type (void) G_GNUC_CONST;
GType data_object_get_type (void) G_GNUC_CONST;
GType data_source_get_type (void) G_GNUC_CONST;
GType thumbnail_source_get_type (void) G_GNUC_CONST;
GType media_source_get_type (void) G_GNUC_CONST;
#define PUBLISHING_GLUE_MEDIA_SOURCE_PUBLISHABLE_WRAPPER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), PUBLISHING_GLUE_TYPE_MEDIA_SOURCE_PUBLISHABLE_WRAPPER, PublishingGlueMediaSourcePublishableWrapperPrivate))
PublishingGlueMediaSourcePublishableWrapper* publishing_glue_media_source_publishable_wrapper_new (MediaSource* to_wrap);
PublishingGlueMediaSourcePublishableWrapper* publishing_glue_media_source_publishable_wrapper_construct (GType object_type,
                                                                                                         MediaSource* to_wrap);
static void publishing_glue_media_source_publishable_wrapper_setup_parameters (PublishingGlueMediaSourcePublishableWrapper* self);
void publishing_glue_media_source_publishable_wrapper_clean_up (PublishingGlueMediaSourcePublishableWrapper* self);
gchar* media_source_get_basename (MediaSource* self);
gchar* media_source_get_title (MediaSource* self);
gchar* media_source_get_comment (MediaSource* self);
GType event_source_get_type (void) G_GNUC_CONST;
GType event_get_type (void) G_GNUC_CONST;
Event* media_source_get_event (MediaSource* self);
gchar* event_source_get_comment (EventSource* self);
GFile* publishing_glue_media_source_publishable_wrapper_serialize_for_publishing (PublishingGlueMediaSourcePublishableWrapper* self,
                                                                                  gint content_major_axis,
                                                                                  gboolean strip_metadata,
                                                                                  GError** error);
GType photo_source_get_type (void) G_GNUC_CONST;
GType photo_get_type (void) G_GNUC_CONST;
GType library_photo_get_type (void) G_GNUC_CONST;
GFile* app_dirs_get_temp_dir (void);
gchar* data_source_get_source_id (DataSource* self);
GType scaling_get_type (void) G_GNUC_CONST;
GType scale_constraint_get_type (void) G_GNUC_CONST;
GType dimensions_get_type (void) G_GNUC_CONST;
Dimensions* dimensions_dup (const Dimensions* self);
void dimensions_free (Dimensions* self);
Scaling* scaling_dup (const Scaling* self);
void scaling_free (Scaling* self);
void scaling_for_best_fit (gint pixels,
                           gboolean scale_up,
                           Scaling* result);
void scaling_for_original (Scaling* result);
GType jpeg_quality_get_type (void) G_GNUC_CONST;
GType photo_file_format_get_type (void) G_GNUC_CONST;
void photo_export (Photo* self,
                   GFile* dest_file,
                   Scaling* scaling,
                   JpegQuality quality,
                   PhotoFileFormat export_format,
                   gboolean direct_copy_unmodified,
                   gboolean export_metadata,
                   GError** error);
gchar* data_object_get_name (DataObject* self);
GType video_source_get_type (void) G_GNUC_CONST;
GType video_get_type (void) G_GNUC_CONST;
void disassemble_filename (const gchar* basename,
                           gchar* * name,
                           gchar* * ext);
GFile* media_source_get_file (MediaSource* self);
void video_export (Video* self,
                   GFile* dest_file,
                   GError** error);
static gchar* publishing_glue_media_source_publishable_wrapper_real_get_publishing_name (SpitPublishingPublishable* base);
static gchar* publishing_glue_media_source_publishable_wrapper_real_get_param_string (SpitPublishingPublishable* base,
                                                                               const gchar* name);
static gchar** publishing_glue_media_source_publishable_wrapper_real_get_publishing_keywords (SpitPublishingPublishable* base,
                                                                                       int* result_length1);
GType tag_get_type (void) G_GNUC_CONST;
gpointer data_collection_ref (gpointer instance);
void data_collection_unref (gpointer instance);
GParamSpec* param_spec_data_collection (const gchar* name,
                                        const gchar* nick,
                                        const gchar* blurb,
                                        GType object_type,
                                        GParamFlags flags);
void value_set_data_collection (GValue* value,
                                gpointer v_object);
void value_take_data_collection (GValue* value,
                                 gpointer v_object);
gpointer value_get_data_collection (const GValue* value);
GType data_collection_get_type (void) G_GNUC_CONST;
GType source_collection_get_type (void) G_GNUC_CONST;
GType database_source_collection_get_type (void) G_GNUC_CONST;
GType container_source_collection_get_type (void) G_GNUC_CONST;
GType tag_source_collection_get_type (void) G_GNUC_CONST;
GeeSortedSet* tag_source_collection_fetch_sorted_for_source (TagSourceCollection* self,
                                                             MediaSource* photo);
static void _vala_array_add63 (gchar** * array,
                        int* length,
                        int* size,
                        gchar* value);
static gchar** _vala_array_dup20 (gchar** self,
                           int length);
static SpitPublishingPublisherMediaType publishing_glue_media_source_publishable_wrapper_real_get_media_type (SpitPublishingPublishable* base);
static GFile* publishing_glue_media_source_publishable_wrapper_real_get_serialized_file (SpitPublishingPublishable* base);
static GDateTime* publishing_glue_media_source_publishable_wrapper_real_get_exposure_date_time (SpitPublishingPublishable* base);
time_t media_source_get_exposure_time (MediaSource* self);
static void publishing_glue_media_source_publishable_wrapper_finalize (GObject * obj);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);


static gpointer
_g_object_ref0 (gpointer self)
{
#line 16 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
	return self ? g_object_ref (self) : NULL;
#line 388 "APIGlue.c"
}


PublishingGlueMediaSourcePublishableWrapper*
publishing_glue_media_source_publishable_wrapper_construct (GType object_type,
                                                            MediaSource* to_wrap)
{
	PublishingGlueMediaSourcePublishableWrapper * self = NULL;
	MediaSource* _tmp0_;
#line 15 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
	g_return_val_if_fail (IS_MEDIA_SOURCE (to_wrap), NULL);
#line 15 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
	self = (PublishingGlueMediaSourcePublishableWrapper*) g_object_new (object_type, NULL);
#line 16 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
	_tmp0_ = _g_object_ref0 (to_wrap);
#line 16 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
	_g_object_unref0 (self->priv->wrapped);
#line 16 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
	self->priv->wrapped = _tmp0_;
#line 17 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
	publishing_glue_media_source_publishable_wrapper_setup_parameters (self);
#line 15 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
	return self;
#line 412 "APIGlue.c"
}


PublishingGlueMediaSourcePublishableWrapper*
publishing_glue_media_source_publishable_wrapper_new (MediaSource* to_wrap)
{
#line 15 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
	return publishing_glue_media_source_publishable_wrapper_construct (PUBLISHING_GLUE_TYPE_MEDIA_SOURCE_PUBLISHABLE_WRAPPER, to_wrap);
#line 421 "APIGlue.c"
}


void
publishing_glue_media_source_publishable_wrapper_clean_up (PublishingGlueMediaSourcePublishableWrapper* self)
{
	GFile* _tmp0_;
	GFile* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GError * _inner_error_ = NULL;
#line 20 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
	g_return_if_fail (PUBLISHING_GLUE_IS_MEDIA_SOURCE_PUBLISHABLE_WRAPPER (self));
#line 21 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
	_tmp0_ = self->priv->serialized_file;
#line 21 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
	if (_tmp0_ == NULL) {
#line 22 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
		return;
#line 441 "APIGlue.c"
	}
#line 24 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
	_tmp1_ = self->priv->serialized_file;
#line 24 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
	_tmp2_ = g_file_get_path (_tmp1_);
#line 24 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
	_tmp3_ = _tmp2_;
#line 24 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
	g_debug ("APIGlue.vala:24: cleaning up temporary publishing file '%s'.", _tmp3_);
#line 24 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
	_g_free0 (_tmp3_);
#line 453 "APIGlue.c"
	{
		GFile* _tmp4_;
#line 27 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
		_tmp4_ = self->priv->serialized_file;
#line 27 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
		g_file_delete (_tmp4_, NULL, &_inner_error_);
#line 27 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 462 "APIGlue.c"
			goto __catch43_g_error;
		}
	}
	goto __finally43;
	__catch43_g_error:
	{
		GError* err = NULL;
		GFile* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
#line 26 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
		err = _inner_error_;
#line 26 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
		_inner_error_ = NULL;
#line 29 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
		_tmp5_ = self->priv->serialized_file;
#line 29 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
		_tmp6_ = g_file_get_path (_tmp5_);
#line 29 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
		_tmp7_ = _tmp6_;
#line 29 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
		g_warning ("APIGlue.vala:29: couldn't delete temporary publishing file '%s'.", _tmp7_);
#line 29 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
		_g_free0 (_tmp7_);
#line 26 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
		_g_error_free0 (err);
#line 489 "APIGlue.c"
	}
	__finally43:
#line 26 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 26 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 26 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
		g_clear_error (&_inner_error_);
#line 26 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
		return;
#line 500 "APIGlue.c"
	}
#line 32 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
	_g_object_unref0 (self->priv->serialized_file);
#line 32 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
	self->priv->serialized_file = NULL;
#line 506 "APIGlue.c"
}


static void
publishing_glue_media_source_publishable_wrapper_setup_parameters (PublishingGlueMediaSourcePublishableWrapper* self)
{
	GeeMap* _tmp0_;
	MediaSource* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GeeMap* _tmp4_;
	MediaSource* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	GeeMap* _tmp8_;
	MediaSource* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	MediaSource* _tmp12_;
	Event* _tmp13_;
	Event* _tmp14_;
	gboolean _tmp15_;
#line 35 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
	g_return_if_fail (PUBLISHING_GLUE_IS_MEDIA_SOURCE_PUBLISHABLE_WRAPPER (self));
#line 36 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
	_tmp0_ = self->priv->param_string;
#line 36 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
	_tmp1_ = self->priv->wrapped;
#line 36 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
	_tmp2_ = media_source_get_basename (_tmp1_);
#line 36 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
	_tmp3_ = _tmp2_;
#line 36 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
	gee_map_set (_tmp0_, SPIT_PUBLISHING_PUBLISHABLE_PARAM_STRING_BASENAME, _tmp3_);
#line 36 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
	_g_free0 (_tmp3_);
#line 37 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
	_tmp4_ = self->priv->param_string;
#line 37 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
	_tmp5_ = self->priv->wrapped;
#line 37 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
	_tmp6_ = media_source_get_title (_tmp5_);
#line 37 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
	_tmp7_ = _tmp6_;
#line 37 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
	gee_map_set (_tmp4_, SPIT_PUBLISHING_PUBLISHABLE_PARAM_STRING_TITLE, _tmp7_);
#line 37 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
	_g_free0 (_tmp7_);
#line 38 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
	_tmp8_ = self->priv->param_string;
#line 38 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
	_tmp9_ = self->priv->wrapped;
#line 38 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
	_tmp10_ = media_source_get_comment (_tmp9_);
#line 38 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
	_tmp11_ = _tmp10_;
#line 38 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
	gee_map_set (_tmp8_, SPIT_PUBLISHING_PUBLISHABLE_PARAM_STRING_COMMENT, _tmp11_);
#line 38 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
	_g_free0 (_tmp11_);
#line 40 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
	_tmp12_ = self->priv->wrapped;
#line 40 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
	_tmp13_ = media_source_get_event (_tmp12_);
#line 40 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
	_tmp14_ = _tmp13_;
#line 40 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
	_tmp15_ = _tmp14_ != NULL;
#line 40 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
	_g_object_unref0 (_tmp14_);
#line 40 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
	if (_tmp15_) {
#line 579 "APIGlue.c"
		GeeMap* _tmp16_;
		MediaSource* _tmp17_;
		Event* _tmp18_;
		Event* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
#line 41 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
		_tmp16_ = self->priv->param_string;
#line 41 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
		_tmp17_ = self->priv->wrapped;
#line 41 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
		_tmp18_ = media_source_get_event (_tmp17_);
#line 41 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
		_tmp19_ = _tmp18_;
#line 41 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
		_tmp20_ = event_source_get_comment (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, TYPE_EVENT_SOURCE, EventSource));
#line 41 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
		_tmp21_ = _tmp20_;
#line 41 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
		gee_map_set (_tmp16_, SPIT_PUBLISHING_PUBLISHABLE_PARAM_STRING_EVENTCOMMENT, _tmp21_);
#line 41 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
		_g_free0 (_tmp21_);
#line 41 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
		_g_object_unref0 (_tmp19_);
#line 604 "APIGlue.c"
	} else {
		GeeMap* _tmp22_;
#line 43 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
		_tmp22_ = self->priv->param_string;
#line 43 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
		gee_map_set (_tmp22_, SPIT_PUBLISHING_PUBLISHABLE_PARAM_STRING_EVENTCOMMENT, "");
#line 611 "APIGlue.c"
	}
}


GFile*
publishing_glue_media_source_publishable_wrapper_serialize_for_publishing (PublishingGlueMediaSourcePublishableWrapper* self,
                                                                           gint content_major_axis,
                                                                           gboolean strip_metadata,
                                                                           GError** error)
{
	GFile* result = NULL;
	MediaSource* _tmp0_;
	GFile* _tmp60_;
	GFile* _tmp61_;
	GError * _inner_error_ = NULL;
#line 46 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
	g_return_val_if_fail (PUBLISHING_GLUE_IS_MEDIA_SOURCE_PUBLISHABLE_WRAPPER (self), NULL);
#line 49 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
	_tmp0_ = self->priv->wrapped;
#line 49 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, TYPE_LIBRARY_PHOTO)) {
#line 633 "APIGlue.c"
		LibraryPhoto* photo = NULL;
		MediaSource* _tmp1_;
		LibraryPhoto* _tmp2_;
		GFile* to_file = NULL;
		GFile* _tmp3_;
		GFile* _tmp4_;
		gint _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		GFile* _tmp8_;
		GFile* _tmp9_;
		LibraryPhoto* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		GFile* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		GFile* _tmp27_;
		GFile* _tmp28_;
#line 50 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
		_tmp1_ = self->priv->wrapped;
#line 50 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
		_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_LIBRARY_PHOTO, LibraryPhoto));
#line 50 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
		photo = _tmp2_;
#line 52 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
		_tmp3_ = app_dirs_get_temp_dir ();
#line 52 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
		_tmp4_ = _tmp3_;
#line 52 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
		_tmp5_ = publishing_glue_media_source_publishable_wrapper_name_ticker;
#line 52 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
		publishing_glue_media_source_publishable_wrapper_name_ticker = _tmp5_ + 1;
#line 52 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
		_tmp6_ = g_strdup_printf ("publishing-%d.jpg", _tmp5_);
#line 52 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
		_tmp7_ = _tmp6_;
#line 52 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
		_tmp8_ = g_file_get_child (_tmp4_, _tmp7_);
#line 52 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
		_tmp9_ = _tmp8_;
#line 52 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
		_g_free0 (_tmp7_);
#line 52 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
		_g_object_unref0 (_tmp4_);
#line 52 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
		to_file = _tmp9_;
#line 55 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
		_tmp10_ = photo;
#line 55 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
		_tmp11_ = data_source_get_source_id (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, TYPE_DATA_SOURCE, DataSource));
#line 55 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
		_tmp12_ = _tmp11_;
#line 55 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
		_tmp13_ = to_file;
#line 55 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
		_tmp14_ = g_file_get_path (_tmp13_);
#line 55 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
		_tmp15_ = _tmp14_;
#line 55 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
		g_debug ("APIGlue.vala:55: writing photo '%s' to temporary file '%s' for publish" \
"ing.", _tmp12_, _tmp15_);
#line 55 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
		_g_free0 (_tmp15_);
#line 55 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
		_g_free0 (_tmp12_);
#line 699 "APIGlue.c"
		{
			Scaling _tmp16_ = {0};
			Scaling scaling = {0};
			LibraryPhoto* _tmp19_;
			GFile* _tmp20_;
			Scaling _tmp21_;
#line 58 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
			if (content_major_axis > 0) {
#line 708 "APIGlue.c"
				Scaling _tmp17_ = {0};
#line 59 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
				scaling_for_best_fit (content_major_axis, FALSE, &_tmp17_);
#line 59 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
				_tmp16_ = _tmp17_;
#line 714 "APIGlue.c"
			} else {
				Scaling _tmp18_ = {0};
#line 59 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
				scaling_for_original (&_tmp18_);
#line 59 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
				_tmp16_ = _tmp18_;
#line 721 "APIGlue.c"
			}
#line 58 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
			scaling = _tmp16_;
#line 60 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
			_tmp19_ = photo;
#line 60 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
			_tmp20_ = to_file;
#line 60 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
			_tmp21_ = scaling;
#line 60 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
			photo_export (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, TYPE_PHOTO, Photo), _tmp20_, &_tmp21_, JPEG_QUALITY_HIGH, PHOTO_FILE_FORMAT_JFIF, FALSE, !strip_metadata, &_inner_error_);
#line 60 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 735 "APIGlue.c"
				goto __catch44_g_error;
			}
		}
		goto __finally44;
		__catch44_g_error:
		{
			GError* err = NULL;
			LibraryPhoto* _tmp22_;
			gchar* _tmp23_;
			gchar* _tmp24_;
			GError* _tmp25_;
			GError* _tmp26_;
#line 57 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
			err = _inner_error_;
#line 57 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
			_inner_error_ = NULL;
#line 62 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
			_tmp22_ = photo;
#line 62 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
			_tmp23_ = data_object_get_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, TYPE_DATA_OBJECT, DataObject));
#line 62 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
			_tmp24_ = _tmp23_;
#line 62 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
			_tmp25_ = g_error_new (SPIT_PUBLISHING_PUBLISHING_ERROR, SPIT_PUBLISHING_PUBLISHING_ERROR_LOCAL_FILE_ERROR, "unable to serialize photo '%s' for publishing.", _tmp24_);
#line 62 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
			_tmp26_ = _tmp25_;
#line 62 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
			_g_free0 (_tmp24_);
#line 62 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
			_inner_error_ = _tmp26_;
#line 62 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
			_g_error_free0 (err);
#line 768 "APIGlue.c"
			goto __finally44;
		}
		__finally44:
#line 57 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 57 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
			if (_inner_error_->domain == SPIT_PUBLISHING_PUBLISHING_ERROR) {
#line 57 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
				g_propagate_error (error, _inner_error_);
#line 57 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
				_g_object_unref0 (to_file);
#line 57 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
				_g_object_unref0 (photo);
#line 57 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
				return NULL;
#line 784 "APIGlue.c"
			} else {
#line 57 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
				_g_object_unref0 (to_file);
#line 57 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
				_g_object_unref0 (photo);
#line 57 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 57 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
				g_clear_error (&_inner_error_);
#line 57 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
				return NULL;
#line 796 "APIGlue.c"
			}
		}
#line 66 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
		_tmp27_ = to_file;
#line 66 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
		_tmp28_ = _g_object_ref0 (_tmp27_);
#line 66 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
		_g_object_unref0 (self->priv->serialized_file);
#line 66 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
		self->priv->serialized_file = _tmp28_;
#line 49 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
		_g_object_unref0 (to_file);
#line 49 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
		_g_object_unref0 (photo);
#line 811 "APIGlue.c"
	} else {
		MediaSource* _tmp29_;
#line 67 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
		_tmp29_ = self->priv->wrapped;
#line 67 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp29_, TYPE_VIDEO)) {
#line 818 "APIGlue.c"
			Video* video = NULL;
			MediaSource* _tmp30_;
			Video* _tmp31_;
			gchar* basename = NULL;
			gchar* extension = NULL;
			Video* _tmp32_;
			GFile* _tmp33_;
			GFile* _tmp34_;
			gchar* _tmp35_;
			gchar* _tmp36_;
			gchar* _tmp37_ = NULL;
			gchar* _tmp38_ = NULL;
			GFile* to_file = NULL;
			gint _tmp39_;
			const gchar* _tmp40_;
			gchar* _tmp41_;
			gchar* _tmp42_;
			GFile* _tmp43_;
			GFile* _tmp44_;
			Video* _tmp45_;
			gchar* _tmp46_;
			gchar* _tmp47_;
			GFile* _tmp48_;
			gchar* _tmp49_;
			gchar* _tmp50_;
			GFile* _tmp58_;
			GFile* _tmp59_;
#line 68 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
			_tmp30_ = self->priv->wrapped;
#line 68 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
			_tmp31_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp30_, TYPE_VIDEO, Video));
#line 68 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
			video = _tmp31_;
#line 72 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
			_tmp32_ = video;
#line 72 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
			_tmp33_ = media_source_get_file (G_TYPE_CHECK_INSTANCE_CAST (_tmp32_, TYPE_MEDIA_SOURCE, MediaSource));
#line 72 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
			_tmp34_ = _tmp33_;
#line 72 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
			_tmp35_ = g_file_get_basename (_tmp34_);
#line 72 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
			_tmp36_ = _tmp35_;
#line 72 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
			disassemble_filename (_tmp36_, &_tmp37_, &_tmp38_);
#line 72 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
			_g_free0 (basename);
#line 72 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
			basename = _tmp37_;
#line 72 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
			_g_free0 (extension);
#line 72 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
			extension = _tmp38_;
#line 72 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
			_g_free0 (_tmp36_);
#line 72 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
			_g_object_unref0 (_tmp34_);
#line 74 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
			_tmp39_ = publishing_glue_media_source_publishable_wrapper_name_ticker;
#line 74 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
			publishing_glue_media_source_publishable_wrapper_name_ticker = _tmp39_ + 1;
#line 74 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
			_tmp40_ = extension;
#line 74 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
			_tmp41_ = g_strdup_printf ("publishing-%d.%s", _tmp39_, _tmp40_);
#line 74 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
			_tmp42_ = _tmp41_;
#line 74 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
			_tmp43_ = g_file_new_for_path (_tmp42_);
#line 74 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
			_tmp44_ = _tmp43_;
#line 74 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
			_g_free0 (_tmp42_);
#line 74 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
			to_file = _tmp44_;
#line 77 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
			_tmp45_ = video;
#line 77 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
			_tmp46_ = data_source_get_source_id (G_TYPE_CHECK_INSTANCE_CAST (_tmp45_, TYPE_DATA_SOURCE, DataSource));
#line 77 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
			_tmp47_ = _tmp46_;
#line 77 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
			_tmp48_ = to_file;
#line 77 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
			_tmp49_ = g_file_get_path (_tmp48_);
#line 77 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
			_tmp50_ = _tmp49_;
#line 77 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
			g_debug ("APIGlue.vala:77: writing video '%s' to temporary file '%s' for publish" \
"ing.", _tmp47_, _tmp50_);
#line 77 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
			_g_free0 (_tmp50_);
#line 77 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
			_g_free0 (_tmp47_);
#line 912 "APIGlue.c"
			{
				Video* _tmp51_;
				GFile* _tmp52_;
#line 80 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
				_tmp51_ = video;
#line 80 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
				_tmp52_ = to_file;
#line 80 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
				video_export (_tmp51_, _tmp52_, &_inner_error_);
#line 80 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 924 "APIGlue.c"
					goto __catch45_g_error;
				}
			}
			goto __finally45;
			__catch45_g_error:
			{
				GError* err = NULL;
				Video* _tmp53_;
				gchar* _tmp54_;
				gchar* _tmp55_;
				GError* _tmp56_;
				GError* _tmp57_;
#line 79 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
				err = _inner_error_;
#line 79 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
				_inner_error_ = NULL;
#line 82 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
				_tmp53_ = video;
#line 82 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
				_tmp54_ = data_object_get_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp53_, TYPE_DATA_OBJECT, DataObject));
#line 82 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
				_tmp55_ = _tmp54_;
#line 82 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
				_tmp56_ = g_error_new (SPIT_PUBLISHING_PUBLISHING_ERROR, SPIT_PUBLISHING_PUBLISHING_ERROR_LOCAL_FILE_ERROR, "unable to serialize video '%s' for publishing.", _tmp55_);
#line 82 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
				_tmp57_ = _tmp56_;
#line 82 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
				_g_free0 (_tmp55_);
#line 82 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
				_inner_error_ = _tmp57_;
#line 82 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
				_g_error_free0 (err);
#line 957 "APIGlue.c"
				goto __finally45;
			}
			__finally45:
#line 79 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 79 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
				if (_inner_error_->domain == SPIT_PUBLISHING_PUBLISHING_ERROR) {
#line 79 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
					g_propagate_error (error, _inner_error_);
#line 79 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
					_g_object_unref0 (to_file);
#line 79 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
					_g_free0 (extension);
#line 79 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
					_g_free0 (basename);
#line 79 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
					_g_object_unref0 (video);
#line 79 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
					return NULL;
#line 977 "APIGlue.c"
				} else {
#line 79 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
					_g_object_unref0 (to_file);
#line 79 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
					_g_free0 (extension);
#line 79 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
					_g_free0 (basename);
#line 79 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
					_g_object_unref0 (video);
#line 79 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 79 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
					g_clear_error (&_inner_error_);
#line 79 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
					return NULL;
#line 993 "APIGlue.c"
				}
			}
#line 86 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
			_tmp58_ = to_file;
#line 86 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
			_tmp59_ = _g_object_ref0 (_tmp58_);
#line 86 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
			_g_object_unref0 (self->priv->serialized_file);
#line 86 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
			self->priv->serialized_file = _tmp59_;
#line 67 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
			_g_object_unref0 (to_file);
#line 67 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
			_g_free0 (extension);
#line 67 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
			_g_free0 (basename);
#line 67 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
			_g_object_unref0 (video);
#line 1012 "APIGlue.c"
		} else {
#line 88 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
			g_error ("APIGlue.vala:88: MediaSourcePublishableWrapper.serialize_for_publishin" \
"g( ): unknown media type.");
#line 1016 "APIGlue.c"
		}
	}
#line 91 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
	_tmp60_ = self->priv->serialized_file;
#line 91 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
	_tmp61_ = _g_object_ref0 (_tmp60_);
#line 91 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
	result = _tmp61_;
#line 91 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
	return result;
#line 1027 "APIGlue.c"
}


static gchar*
publishing_glue_media_source_publishable_wrapper_real_get_publishing_name (SpitPublishingPublishable* base)
{
	PublishingGlueMediaSourcePublishableWrapper * self;
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	MediaSource* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gboolean _tmp4_;
#line 94 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, PUBLISHING_GLUE_TYPE_MEDIA_SOURCE_PUBLISHABLE_WRAPPER, PublishingGlueMediaSourcePublishableWrapper);
#line 95 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
	_tmp1_ = self->priv->wrapped;
#line 95 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
	_tmp2_ = media_source_get_title (_tmp1_);
#line 95 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
	_tmp3_ = _tmp2_;
#line 95 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
	_tmp4_ = _tmp3_ != NULL;
#line 95 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
	_g_free0 (_tmp3_);
#line 95 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
	if (_tmp4_) {
#line 1055 "APIGlue.c"
		MediaSource* _tmp5_;
		gchar* _tmp6_;
#line 95 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
		_tmp5_ = self->priv->wrapped;
#line 95 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
		_tmp6_ = media_source_get_title (_tmp5_);
#line 95 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
		_g_free0 (_tmp0_);
#line 95 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
		_tmp0_ = _tmp6_;
#line 1066 "APIGlue.c"
	} else {
		gchar* _tmp7_;
#line 95 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
		_tmp7_ = g_strdup ("");
#line 95 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
		_g_free0 (_tmp0_);
#line 95 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
		_tmp0_ = _tmp7_;
#line 1075 "APIGlue.c"
	}
#line 95 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
	result = _tmp0_;
#line 95 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
	return result;
#line 1081 "APIGlue.c"
}


static gchar*
publishing_glue_media_source_publishable_wrapper_real_get_param_string (SpitPublishingPublishable* base,
                                                                        const gchar* name)
{
	PublishingGlueMediaSourcePublishableWrapper * self;
	gchar* result = NULL;
	GeeMap* _tmp0_;
	gpointer _tmp1_;
#line 98 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, PUBLISHING_GLUE_TYPE_MEDIA_SOURCE_PUBLISHABLE_WRAPPER, PublishingGlueMediaSourcePublishableWrapper);
#line 98 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 99 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
	_tmp0_ = self->priv->param_string;
#line 99 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
	_tmp1_ = gee_map_get (_tmp0_, name);
#line 99 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
	result = (gchar*) _tmp1_;
#line 99 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
	return result;
#line 1105 "APIGlue.c"
}


static void
_vala_array_add63 (gchar** * array,
                   int* length,
                   int* size,
                   gchar* value)
{
#line 108 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
	if ((*length) == (*size)) {
#line 108 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 108 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 1121 "APIGlue.c"
	}
#line 108 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
	(*array)[(*length)++] = value;
#line 108 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
	(*array)[*length] = NULL;
#line 1127 "APIGlue.c"
}


static gchar**
_vala_array_dup20 (gchar** self,
                   int length)
{
	gchar** result;
	int i;
#line 112 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
	result = g_new0 (gchar*, length + 1);
#line 112 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
	for (i = 0; i < length; i++) {
#line 1141 "APIGlue.c"
		gchar* _tmp0_;
#line 112 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
		_tmp0_ = g_strdup (self[i]);
#line 112 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
		result[i] = _tmp0_;
#line 1147 "APIGlue.c"
	}
#line 112 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
	return result;
#line 1151 "APIGlue.c"
}


static gchar**
publishing_glue_media_source_publishable_wrapper_real_get_publishing_keywords (SpitPublishingPublishable* base,
                                                                               int* result_length1)
{
	PublishingGlueMediaSourcePublishableWrapper * self;
	gchar** result = NULL;
	gchar** _result_ = NULL;
	gchar** _tmp0_;
	gint _result__length1;
	gint __result__size_;
	GeeCollection* tagset = NULL;
	TagSourceCollection* _tmp1_;
	MediaSource* _tmp2_;
	GeeSortedSet* _tmp3_;
	GeeCollection* _tmp4_;
	gchar** _tmp13_ = NULL;
	gint _tmp13__length1 = 0;
	gint __tmp13__size_ = 0;
	gchar** _tmp14_;
	gint _tmp14__length1;
	gchar** _tmp16_;
	gint _tmp16__length1;
	gchar** _tmp17_;
	gint _tmp17__length1;
#line 102 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, PUBLISHING_GLUE_TYPE_MEDIA_SOURCE_PUBLISHABLE_WRAPPER, PublishingGlueMediaSourcePublishableWrapper);
#line 103 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
	_tmp0_ = g_new0 (gchar*, 0 + 1);
#line 103 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
	_result_ = _tmp0_;
#line 103 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
	_result__length1 = 0;
#line 103 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
	__result__size_ = _result__length1;
#line 105 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
	_tmp1_ = tag_global;
#line 105 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
	_tmp2_ = self->priv->wrapped;
#line 105 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
	_tmp3_ = tag_source_collection_fetch_sorted_for_source (_tmp1_, _tmp2_);
#line 105 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
	tagset = G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_COLLECTION, GeeCollection);
#line 106 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
	_tmp4_ = tagset;
#line 106 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
	if (_tmp4_ != NULL) {
#line 1201 "APIGlue.c"
		{
			GeeIterator* _tag_it = NULL;
			GeeCollection* _tmp5_;
			GeeIterator* _tmp6_;
#line 107 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
			_tmp5_ = tagset;
#line 107 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
			_tmp6_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GEE_TYPE_ITERABLE, GeeIterable));
#line 107 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
			_tag_it = _tmp6_;
#line 107 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
			while (TRUE) {
#line 1214 "APIGlue.c"
				GeeIterator* _tmp7_;
				Tag* tag = NULL;
				GeeIterator* _tmp8_;
				gpointer _tmp9_;
				gchar** _tmp10_;
				gint _tmp10__length1;
				Tag* _tmp11_;
				gchar* _tmp12_;
#line 107 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
				_tmp7_ = _tag_it;
#line 107 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
				if (!gee_iterator_next (_tmp7_)) {
#line 107 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
					break;
#line 1229 "APIGlue.c"
				}
#line 107 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
				_tmp8_ = _tag_it;
#line 107 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
				_tmp9_ = gee_iterator_get (_tmp8_);
#line 107 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
				tag = (Tag*) _tmp9_;
#line 108 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
				_tmp10_ = _result_;
#line 108 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
				_tmp10__length1 = _result__length1;
#line 108 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
				_tmp11_ = tag;
#line 108 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
				_tmp12_ = data_object_get_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, TYPE_DATA_OBJECT, DataObject));
#line 108 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
				_vala_array_add63 (&_result_, &_result__length1, &__result__size_, _tmp12_);
#line 107 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
				_g_object_unref0 (tag);
#line 1249 "APIGlue.c"
			}
#line 107 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
			_g_object_unref0 (_tag_it);
#line 1253 "APIGlue.c"
		}
	}
#line 112 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
	_tmp14_ = _result_;
#line 112 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
	_tmp14__length1 = _result__length1;
#line 112 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
	if (_tmp14__length1 > 0) {
#line 1262 "APIGlue.c"
		gchar** _tmp15_;
		gint _tmp15__length1;
#line 112 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
		_tmp15_ = _result_;
#line 112 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
		_tmp15__length1 = _result__length1;
#line 112 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
		_tmp13_ = _tmp15_;
#line 112 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
		_tmp13__length1 = _tmp15__length1;
#line 112 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
		__tmp13__size_ = _tmp13__length1;
#line 1275 "APIGlue.c"
	} else {
#line 112 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
		_tmp13_ = NULL;
#line 112 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
		_tmp13__length1 = 0;
#line 112 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
		__tmp13__size_ = _tmp13__length1;
#line 1283 "APIGlue.c"
	}
#line 112 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
	_tmp16_ = (_tmp13_ != NULL) ? _vala_array_dup20 (_tmp13_, _tmp13__length1) : ((gpointer) _tmp13_);
#line 112 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
	_tmp16__length1 = _tmp13__length1;
#line 112 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
	_tmp17_ = _tmp16_;
#line 112 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
	_tmp17__length1 = _tmp16__length1;
#line 112 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
	if (result_length1) {
#line 112 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
		*result_length1 = _tmp17__length1;
#line 1297 "APIGlue.c"
	}
#line 112 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
	result = _tmp17_;
#line 112 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
	_g_object_unref0 (tagset);
#line 112 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
	_result_ = (_vala_array_free (_result_, _result__length1, (GDestroyNotify) g_free), NULL);
#line 112 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
	return result;
#line 1307 "APIGlue.c"
}


static SpitPublishingPublisherMediaType
publishing_glue_media_source_publishable_wrapper_real_get_media_type (SpitPublishingPublishable* base)
{
	PublishingGlueMediaSourcePublishableWrapper * self;
	SpitPublishingPublisherMediaType result = 0;
	MediaSource* _tmp0_;
#line 115 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, PUBLISHING_GLUE_TYPE_MEDIA_SOURCE_PUBLISHABLE_WRAPPER, PublishingGlueMediaSourcePublishableWrapper);
#line 116 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
	_tmp0_ = self->priv->wrapped;
#line 116 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, TYPE_LIBRARY_PHOTO)) {
#line 117 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
		result = SPIT_PUBLISHING_PUBLISHER_MEDIA_TYPE_PHOTO;
#line 117 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
		return result;
#line 1327 "APIGlue.c"
	} else {
		MediaSource* _tmp1_;
#line 118 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
		_tmp1_ = self->priv->wrapped;
#line 118 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, TYPE_VIDEO)) {
#line 119 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
			result = SPIT_PUBLISHING_PUBLISHER_MEDIA_TYPE_VIDEO;
#line 119 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
			return result;
#line 1338 "APIGlue.c"
		} else {
#line 121 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
			result = SPIT_PUBLISHING_PUBLISHER_MEDIA_TYPE_NONE;
#line 121 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
			return result;
#line 1344 "APIGlue.c"
		}
	}
}


static GFile*
publishing_glue_media_source_publishable_wrapper_real_get_serialized_file (SpitPublishingPublishable* base)
{
	PublishingGlueMediaSourcePublishableWrapper * self;
	GFile* result = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
#line 124 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, PUBLISHING_GLUE_TYPE_MEDIA_SOURCE_PUBLISHABLE_WRAPPER, PublishingGlueMediaSourcePublishableWrapper);
#line 125 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
	_tmp0_ = self->priv->serialized_file;
#line 125 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 125 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
	result = _tmp1_;
#line 125 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
	return result;
#line 1367 "APIGlue.c"
}


static GDateTime*
publishing_glue_media_source_publishable_wrapper_real_get_exposure_date_time (SpitPublishingPublishable* base)
{
	PublishingGlueMediaSourcePublishableWrapper * self;
	GDateTime* result = NULL;
	MediaSource* _tmp0_;
	GDateTime* _tmp1_;
#line 128 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (base, PUBLISHING_GLUE_TYPE_MEDIA_SOURCE_PUBLISHABLE_WRAPPER, PublishingGlueMediaSourcePublishableWrapper);
#line 129 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
	_tmp0_ = self->priv->wrapped;
#line 129 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
	_tmp1_ = g_date_time_new_from_unix_local ((gint64) media_source_get_exposure_time (_tmp0_));
#line 129 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
	result = _tmp1_;
#line 129 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
	return result;
#line 1388 "APIGlue.c"
}


static void
publishing_glue_media_source_publishable_wrapper_class_init (PublishingGlueMediaSourcePublishableWrapperClass * klass)
{
#line 8 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
	publishing_glue_media_source_publishable_wrapper_parent_class = g_type_class_peek_parent (klass);
#line 8 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
	g_type_class_add_private (klass, sizeof (PublishingGlueMediaSourcePublishableWrapperPrivate));
#line 8 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
	G_OBJECT_CLASS (klass)->finalize = publishing_glue_media_source_publishable_wrapper_finalize;
#line 1401 "APIGlue.c"
}


static void
publishing_glue_media_source_publishable_wrapper_spit_publishing_publishable_interface_init (SpitPublishingPublishableIface * iface)
{
#line 8 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
	publishing_glue_media_source_publishable_wrapper_spit_publishing_publishable_parent_iface = g_type_interface_peek_parent (iface);
#line 8 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
	iface->get_publishing_name = (gchar* (*) (SpitPublishingPublishable *)) publishing_glue_media_source_publishable_wrapper_real_get_publishing_name;
#line 8 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
	iface->get_param_string = (gchar* (*) (SpitPublishingPublishable *, const gchar*)) publishing_glue_media_source_publishable_wrapper_real_get_param_string;
#line 8 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
	iface->get_publishing_keywords = (gchar** (*) (SpitPublishingPublishable *, int*)) publishing_glue_media_source_publishable_wrapper_real_get_publishing_keywords;
#line 8 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
	iface->get_media_type = (SpitPublishingPublisherMediaType (*) (SpitPublishingPublishable *)) publishing_glue_media_source_publishable_wrapper_real_get_media_type;
#line 8 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
	iface->get_serialized_file = (GFile* (*) (SpitPublishingPublishable *)) publishing_glue_media_source_publishable_wrapper_real_get_serialized_file;
#line 8 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
	iface->get_exposure_date_time = (GDateTime* (*) (SpitPublishingPublishable *)) publishing_glue_media_source_publishable_wrapper_real_get_exposure_date_time;
#line 1422 "APIGlue.c"
}


static void
publishing_glue_media_source_publishable_wrapper_instance_init (PublishingGlueMediaSourcePublishableWrapper * self)
{
	GeeHashMap* _tmp0_;
#line 8 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
	self->priv = PUBLISHING_GLUE_MEDIA_SOURCE_PUBLISHABLE_WRAPPER_GET_PRIVATE (self);
#line 12 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
	self->priv->serialized_file = NULL;
#line 13 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 13 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
	self->priv->param_string = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_MAP, GeeMap);
#line 1438 "APIGlue.c"
}


static void
publishing_glue_media_source_publishable_wrapper_finalize (GObject * obj)
{
	PublishingGlueMediaSourcePublishableWrapper * self;
#line 8 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PUBLISHING_GLUE_TYPE_MEDIA_SOURCE_PUBLISHABLE_WRAPPER, PublishingGlueMediaSourcePublishableWrapper);
#line 11 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
	_g_object_unref0 (self->priv->wrapped);
#line 12 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
	_g_object_unref0 (self->priv->serialized_file);
#line 13 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
	_g_object_unref0 (self->priv->param_string);
#line 8 "/home/jens/Source/shotwell/src/publishing/APIGlue.vala"
	G_OBJECT_CLASS (publishing_glue_media_source_publishable_wrapper_parent_class)->finalize (obj);
#line 1456 "APIGlue.c"
}


GType
publishing_glue_media_source_publishable_wrapper_get_type (void)
{
	static volatile gsize publishing_glue_media_source_publishable_wrapper_type_id__volatile = 0;
	if (g_once_init_enter (&publishing_glue_media_source_publishable_wrapper_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PublishingGlueMediaSourcePublishableWrapperClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) publishing_glue_media_source_publishable_wrapper_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PublishingGlueMediaSourcePublishableWrapper), 0, (GInstanceInitFunc) publishing_glue_media_source_publishable_wrapper_instance_init, NULL };
		static const GInterfaceInfo spit_publishing_publishable_info = { (GInterfaceInitFunc) publishing_glue_media_source_publishable_wrapper_spit_publishing_publishable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType publishing_glue_media_source_publishable_wrapper_type_id;
		publishing_glue_media_source_publishable_wrapper_type_id = g_type_register_static (G_TYPE_OBJECT, "PublishingGlueMediaSourcePublishableWrapper", &g_define_type_info, 0);
		g_type_add_interface_static (publishing_glue_media_source_publishable_wrapper_type_id, SPIT_PUBLISHING_TYPE_PUBLISHABLE, &spit_publishing_publishable_info);
		g_once_init_leave (&publishing_glue_media_source_publishable_wrapper_type_id__volatile, publishing_glue_media_source_publishable_wrapper_type_id);
	}
	return publishing_glue_media_source_publishable_wrapper_type_id__volatile;
}


static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



