// Copyright 2011 The Closure Library Authors. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS-IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

goog.provide('goog.storage.mechanism.HTML5LocalStorageTest');
goog.setTestOnly('goog.storage.mechanism.HTML5LocalStorageTest');

goog.require('goog.storage.mechanism.HTML5LocalStorage');
/** @suppress {extraRequire} */
goog.require('goog.storage.mechanism.mechanismSeparationTester');
/** @suppress {extraRequire} */
goog.require('goog.storage.mechanism.mechanismSharingTester');
/** @suppress {extraRequire} */
goog.require('goog.storage.mechanism.mechanismTestDefinition');
goog.require('goog.testing.jsunit');
goog.require('goog.userAgent');
goog.require('goog.userAgent.product');

function shouldRunTests() {
  // Disabled in Safari because Apple SafariDriver runs tests in Private
  // Browsing mode, and Safari does not permit writing to localStorage in
  // Private Browsing windows.
  return !goog.userAgent.product.SAFARI;
}

function setUp() {
  var localStorage = new goog.storage.mechanism.HTML5LocalStorage();
  if (localStorage.isAvailable()) {
    mechanism = localStorage;
    // There should be at least 2 MiB.
    minimumQuota = 2 * 1024 * 1024;
    mechanism_shared = new goog.storage.mechanism.HTML5LocalStorage();
  }
}

function tearDown() {
  if (!!mechanism) {
    mechanism.clear();
    mechanism = null;
  }
  if (!!mechanism_shared) {
    mechanism_shared.clear();
    mechanism_shared = null;
  }
}

function testAvailability() {
  if (goog.userAgent.WEBKIT && goog.userAgent.isVersionOrHigher('532.5') ||
      goog.userAgent.GECKO && goog.userAgent.isVersionOrHigher('1.9.1') ||
      goog.userAgent.IE && goog.userAgent.isVersionOrHigher('8')) {
    assertNotNull(mechanism);
    assertTrue(mechanism.isAvailable());
    assertNotNull(mechanism_shared);
    assertTrue(mechanism_shared.isAvailable());
  }
}
