#!perl

#
#	Generate certain error strings
#	1. cfg error strings into CFG_ERR#
#

die "Cannot create NLS/ENGLISH.ERR" unless open(ERR, '>nls/english.err');
print ERR "/* automatically generated by $0 */\n\n";

#
#	cfg error strings
#
die "Cannot open inifile.loc" unless open(IN, "inifile.h");
die "Cannot create cfg error table" unless open(TBL, '>cfgi_tbl.loc');
print ERR "/*\n *\tcfg error codes\n */\n";
print TBL "/* automatically generated by $0 */\n";
while(<IN>) {
	next unless /^\s*\#define\s+CFG_ERR_(\S+)\s+\-?(\d+)\s*\/\*([^\*]+)/;
	$name = $1;
	$num = $2;
	$desc = $3;
	last if $name eq 'MAXNUM';
	# squeeze whitespaces
	$desc =~ s/\s+/ /g;
	$desc = $' if $desc =~ /^\s/;
	$desc = $` if $desc =~ /\s$/;
	die "Multiple cfg error number $num" if defined $nums{$num};
	print ERR "\#define E_CFG$num \"$desc\\n\"\n";
	print TBL "E_CFG$num\t,\n";
	$nums{$num} = 1;
}
close TBL;
close IN;
%nums = ();
print ERR "\n/* end of cfg error codes */\n\n\n";

#
#	Finish off
#

close ERR;
exit 0;
