/*==============================================================================

FICHIER     : [dvdinfo.h]

DATE        : 2006/01/0005 20:53:04

CREATEUR    : [Linux!jef]

COMMENTAIRE :

================================================================================

==============================================================================*/

#ifndef __DVDINFO_H__
#define __DVDINFO_H__
#	include <stdint.h>
#	include "dvdread/dvd_reader.h"
#	include "dvdread/ifo_read.h"
#	include "dvdread/ifo_print.h"
#	include "dvdread/nav_read.h"

#ifndef DVD_BLOCK_LEN
#	define DVD_BLOCK_LEN	2048
#endif

#ifdef __IN_DVDINFO__
ifo_handle_t * Ifo_zero, ** Ifo;
dvd_reader_t * Dvd;
int NrTitles;
#else
extern ifo_handle_t * Ifo_zero, ** Ifo;
extern dvd_reader_t * Dvd;
extern int NrTitles;
#endif

/*@$#[dvdinfo.c] global proto. AutoProtoSigV1.1. date: 2009/02/04 23:18:25 */
#include "proto.h"
#ifdef __cplusplus
extern "C" {
#endif
/* dvdinfo.c */
int GetDVDTitleUsingLibDVD PROTO((char *title));
int GetDVDTitle PROTO((char *device, char *title));
int DvdOpen PROTO((char *device));
void DvdClose PROTO((void));
char *DvdLangCode2String PROTO((char *langCode));
ifo_handle_t *CopyIfo PROTO((int vts));
#ifdef __cplusplus
}
#endif
/*@$% end of AutoProtoSigV1.1 (Dont remove this line) [-I ../include]*/

#endif	/* __DVDINFO_H__ */

