/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.seekablestream;

import htsjdk.samtools.seekablestream.SeekableStream;
import java.io.IOException;
import java.nio.ByteBuffer;

public class SeekableMemoryStream
extends SeekableStream {
    private final ByteBuffer buf;
    private final String source;

    public SeekableMemoryStream(byte[] data, String source) {
        this.buf = ByteBuffer.wrap(data);
        this.source = source;
    }

    @Override
    public void close() throws IOException {
        this.buf.clear();
    }

    @Override
    public boolean eof() throws IOException {
        return this.buf.position() == this.buf.limit();
    }

    @Override
    public String getSource() {
        return this.source;
    }

    @Override
    public long length() {
        return this.buf.array().length - this.buf.arrayOffset();
    }

    @Override
    public int read(byte[] buffer, int offset, int length) throws IOException {
        int availableLength = Math.min(length, this.buf.remaining());
        if (availableLength < 1) {
            return -1;
        }
        this.buf.get(buffer, offset, availableLength);
        return availableLength;
    }

    @Override
    public void seek(long position) throws IOException {
        this.buf.position((int)position);
    }

    @Override
    public int read() throws IOException {
        if (this.buf.position() < this.buf.limit()) {
            return this.buf.get();
        }
        return -1;
    }

    @Override
    public long position() throws IOException {
        return this.buf.position();
    }
}

