/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils.activeregion;

import com.google.java.contract.Ensures;
import com.google.java.contract.Requires;
import org.broadinstitute.gatk.utils.GenomeLoc;

public class ActivityProfileState {
    private final GenomeLoc loc;
    public double isActiveProb;
    public Type resultState;
    public Number resultValue;

    @Requires(value={"loc != null", "isActiveProb >= 0.0 && isActiveProb <= 1.0"})
    public ActivityProfileState(GenomeLoc loc, double isActiveProb) {
        this(loc, isActiveProb, Type.NONE, null);
    }

    @Requires(value={"loc != null", "isActiveProb >= 0.0 && isActiveProb <= 1.0"})
    public ActivityProfileState(GenomeLoc loc, double isActiveProb, Type resultState, Number resultValue) {
        if (loc.size() != 1) {
            throw new IllegalArgumentException("Location for an ActivityProfileState must have to size 1 bp but saw " + loc);
        }
        if (resultValue != null && resultValue.doubleValue() < 0.0) {
            throw new IllegalArgumentException("Result value isn't null and its < 0, which is illegal: " + resultValue);
        }
        this.loc = loc;
        this.isActiveProb = isActiveProb;
        this.resultState = resultState;
        this.resultValue = resultValue;
    }

    public int getOffset(GenomeLoc regionStartLoc) {
        return this.getLoc().getStart() - regionStartLoc.getStart();
    }

    @Ensures(value={"result != null"})
    public GenomeLoc getLoc() {
        return this.loc;
    }

    public String toString() {
        return "ActivityProfileState{loc=" + this.loc + ", isActiveProb=" + this.isActiveProb + ", resultState=" + (Object)((Object)this.resultState) + ", resultValue=" + this.resultValue + '}';
    }

    public static enum Type {
        NONE,
        HIGH_QUALITY_SOFT_CLIPS;

    }
}

