/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Window;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.core.Robot;
import org.fest.swing.driver.ComponentStateValidator;
import org.fest.swing.driver.ContainerDriver;
import org.fest.swing.driver.WindowLikeContainerLocations;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiQuery;
import org.fest.swing.edt.GuiTask;

public class WindowDriver
extends ContainerDriver {
    public WindowDriver(Robot robot) {
        super(robot);
    }

    @RunsInEDT
    public void resizeWidthTo(Window w, int width) {
        this.resizeWidth(w, width);
    }

    @RunsInEDT
    public void resizeHeightTo(Window w, int height) {
        this.resizeHeight(w, height);
    }

    @RunsInEDT
    public void resizeTo(Window w, Dimension size) {
        this.resize(w, size.width, size.height);
    }

    public void moveTo(Window w, Point where) {
        this.move(w, where.x, where.y);
    }

    @RunsInEDT
    public void close(Window w) {
        this.moveMouseIgnoringAnyError(w, WindowDriver.closeInfo(w));
        this.robot.close(w);
    }

    @RunsInEDT
    private static Point closeInfo(final Window w) {
        return GuiActionRunner.execute(new GuiQuery<Point>(){

            @Override
            protected Point executeInEDT() {
                ComponentStateValidator.validateIsEnabledAndShowing(w);
                return WindowLikeContainerLocations.closeLocationOf(w);
            }
        });
    }

    @RunsInEDT
    public void show(Window w) {
        this.robot.showWindow(w);
    }

    @RunsInEDT
    public void show(Window w, Dimension size) {
        this.robot.showWindow(w, size);
    }

    @RunsInEDT
    public void moveToFront(Window w) {
        WindowDriver.doMoveToFront(w);
        this.robot.waitForIdle();
    }

    @RunsInEDT
    private static void doMoveToFront(final Window w) {
        GuiActionRunner.execute(new GuiTask(){

            protected void executeInEDT() {
                w.toFront();
            }
        });
    }

    @RunsInEDT
    public void moveToBack(Window w) {
        WindowDriver.doMoveToBack(w);
        this.robot.waitForIdle();
    }

    @RunsInEDT
    private static void doMoveToBack(final Window w) {
        GuiActionRunner.execute(new GuiTask(){

            protected void executeInEDT() {
                w.toBack();
            }
        });
    }
}

