/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils.pairhmm;

import htsjdk.variant.variantcontext.Allele;
import java.io.File;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.broadinstitute.gatk.utils.genotyper.PerReadAlleleLikelihoodMap;
import org.broadinstitute.gatk.utils.haplotype.Haplotype;
import org.broadinstitute.gatk.utils.pairhmm.BatchPairHMM;
import org.broadinstitute.gatk.utils.pairhmm.PairHMM;
import org.broadinstitute.gatk.utils.sam.GATKSAMRecord;

public final class CnyPairHMM
extends PairHMM
implements BatchPairHMM {
    static final String libPath = "/opt/convey/personalities/32100.1.1.1.0";
    static final String libName = "gmvhdl_gatk_hmm";
    private static boolean loaded = false;
    private List<HmmInput> batchRequests = new LinkedList<HmmInput>();
    private ResultQueue resultQueue = new ResultQueue();

    public static boolean isAvailable() {
        if (!loaded) {
            File library = new File("/opt/convey/personalities/32100.1.1.1.0/libgmvhdl_gatk_hmm.so");
            return library.exists();
        }
        return true;
    }

    private native void initFpga();

    private native int dequeueRequirement(int var1, int var2);

    private native int enqueue(byte[] var1, byte[] var2, byte[] var3, byte[] var4, byte[] var5, byte[] var6, int var7, boolean var8);

    private native int flushQueue();

    private native int dequeue(double[] var1);

    private native double softHmm(byte[] var1, byte[] var2, byte[] var3, byte[] var4, byte[] var5, byte[] var6, int var7, boolean var8);

    public native void reportStats();

    @Override
    public void initialize(int READ_MAX_LENGTH, int HAPLOTYPE_MAX_LENGTH) {
        if (!loaded) {
            CnyPairHMM.addLibraryPath(libPath);
            System.loadLibrary(libName);
            this.initFpga();
            loaded = true;
            System.out.println("FPGA HMM Initialized");
        }
    }

    @Override
    public void batchAdd(List<Haplotype> haplotypes, byte[] readBases, byte[] readQuals, byte[] insertionGOP, byte[] deletionGOP, byte[] overallGCP) {
        int numHaplotypes = haplotypes.size();
        HmmInput test = new HmmInput();
        test.readBases = readBases;
        test.readQuals = readQuals;
        test.insertionGOP = insertionGOP;
        test.deletionGOP = deletionGOP;
        test.overallGCP = overallGCP;
        test.haplotypes = haplotypes;
        this.batchRequests.add(test);
        for (int jjj = 0; jjj < numHaplotypes; ++jjj) {
            boolean recacheReadValues = jjj == 0;
            Haplotype haplotype = haplotypes.get(jjj);
            this.enqueuePrepare(haplotype.getBases(), readBases);
            if (this.enqueue(haplotype.getBases(), readBases, readQuals, insertionGOP, deletionGOP, overallGCP, 0, recacheReadValues) != 0) continue;
            throw new RuntimeException("FPGA queue overflow in batchAdd");
        }
    }

    @Override
    public double[] batchGetResult() {
        double[] results;
        int n = this.flushQueue();
        if (n > 0) {
            results = new double[n];
            if (this.dequeue(results) != n) {
                System.out.println("queue underflow in enqueuePrepare");
            }
            this.resultQueue.push(results);
        }
        HmmInput test = this.batchRequests.remove(0);
        int numHaplotypes = test.haplotypes.size();
        results = new double[numHaplotypes];
        for (int jjj = 0; jjj < numHaplotypes; ++jjj) {
            results[jjj] = this.resultQueue.pop();
            if (!(results[jjj] < -60.0)) continue;
            Haplotype haplotype = test.haplotypes.get(jjj);
            results[jjj] = this.softHmm(haplotype.getBases(), test.readBases, test.readQuals, test.insertionGOP, test.deletionGOP, test.overallGCP, 0, true);
        }
        return results;
    }

    @Override
    public PerReadAlleleLikelihoodMap computeLikelihoods(List<GATKSAMRecord> reads, Map<Allele, Haplotype> alleleHaplotypeMap, Map<GATKSAMRecord, byte[]> GCPArrayMap) {
        if (!this.initialized) {
            int readMaxLength = this.findMaxReadLength(reads);
            int haplotypeMaxLength = this.findMaxHaplotypeLength(alleleHaplotypeMap);
            this.initialize(readMaxLength, haplotypeMaxLength);
        }
        this.performBatchAdditions(reads, alleleHaplotypeMap, GCPArrayMap);
        PerReadAlleleLikelihoodMap likelihoodMap = new PerReadAlleleLikelihoodMap();
        this.collectLikelihoodResults(reads, alleleHaplotypeMap, likelihoodMap);
        return likelihoodMap;
    }

    private void collectLikelihoodResults(List<GATKSAMRecord> reads, Map<Allele, Haplotype> alleleHaplotypeMap, PerReadAlleleLikelihoodMap likelihoodMap) {
        for (GATKSAMRecord read : reads) {
            double[] likelihoods = this.batchGetResult();
            int jjj = 0;
            for (Allele allele : alleleHaplotypeMap.keySet()) {
                double log10l = likelihoods[jjj];
                likelihoodMap.add(read, allele, (Double)log10l);
                ++jjj;
            }
        }
    }

    private void performBatchAdditions(List<GATKSAMRecord> reads, Map<Allele, Haplotype> alleleHaplotypeMap, Map<GATKSAMRecord, byte[]> GCPArrayMap) {
        List<Haplotype> haplotypeList = this.getHaplotypeList(alleleHaplotypeMap);
        for (GATKSAMRecord read : reads) {
            byte[] readBases = read.getReadBases();
            byte[] readQuals = read.getBaseQualities();
            byte[] readInsQuals = read.getBaseInsertionQualities();
            byte[] readDelQuals = read.getBaseDeletionQualities();
            byte[] overallGCP = GCPArrayMap.get(read);
            this.batchAdd(haplotypeList, readBases, readQuals, readInsQuals, readDelQuals, overallGCP);
        }
    }

    @Override
    protected double subComputeReadLikelihoodGivenHaplotypeLog10(byte[] haplotypeBases, byte[] readBases, byte[] readQuals, byte[] insertionGOP, byte[] deletionGOP, byte[] overallGCP, int hapStartIndex, boolean recacheReadValues, int nextHapStartIndex) {
        return 0.0;
    }

    private List<Haplotype> getHaplotypeList(Map<Allele, Haplotype> alleleHaplotypeMap) {
        LinkedList<Haplotype> haplotypeList = new LinkedList<Haplotype>();
        for (Allele a : alleleHaplotypeMap.keySet()) {
            haplotypeList.add(alleleHaplotypeMap.get(a));
        }
        return haplotypeList;
    }

    private void enqueuePrepare(byte[] haplotypeBases, byte[] readBases) {
        double[] results = null;
        int n = this.dequeueRequirement(haplotypeBases.length, readBases.length);
        if (n > 0) {
            results = new double[n];
            if (this.dequeue(results) != n) {
                System.out.println("queue underflow in enqueuePrepare");
            }
        } else if (n < 0 && (n = this.flushQueue()) > 0 && this.dequeue(results = new double[n]) != n) {
            System.out.println("queue underflow in enqueuePrepare");
        }
        if (results != null) {
            this.resultQueue.push(results);
        }
    }

    public static void addLibraryPath(String pathToAdd) {
        try {
            String[] paths;
            Field usrPathsField = ClassLoader.class.getDeclaredField("usr_paths");
            usrPathsField.setAccessible(true);
            for (String path : paths = (String[])usrPathsField.get(null)) {
                if (!path.equals(pathToAdd)) continue;
                return;
            }
            String[] newPaths = Arrays.copyOf(paths, paths.length + 1);
            newPaths[newPaths.length - 1] = pathToAdd;
            usrPathsField.set(null, newPaths);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static class ResultQueue {
        private int offset = 0;
        private List<double[]> batchResults = new LinkedList<double[]>();

        public void push(double[] results) {
            this.batchResults.add(results);
        }

        public double pop() {
            double[] results = this.batchResults.get(0);
            double top = results[this.offset++];
            if (this.offset == results.length) {
                this.batchResults.remove(0);
                this.offset = 0;
            }
            return top;
        }
    }

    private static class HmmInput {
        public byte[] readBases;
        public byte[] readQuals;
        public byte[] insertionGOP;
        public byte[] deletionGOP;
        public byte[] overallGCP;
        public List<Haplotype> haplotypes;

        private HmmInput() {
        }
    }
}

