/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.catalog.types;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.derby.catalog.TypeDescriptor;
import org.apache.derby.catalog.types.BaseTypeIdImpl;
import org.apache.derby.iapi.services.io.Formatable;

public class TypeDescriptorImpl
implements TypeDescriptor,
Formatable {
    private BaseTypeIdImpl typeId;
    private int precision;
    private int scale;
    private boolean isNullable;
    private int maximumWidth;
    private int collationType = 0;
    private int collationDerivation = 1;

    public TypeDescriptorImpl() {
    }

    public TypeDescriptorImpl(BaseTypeIdImpl baseTypeIdImpl, int n, int n2, boolean bl, int n3) {
        this.typeId = baseTypeIdImpl;
        this.precision = n;
        this.scale = n2;
        this.isNullable = bl;
        this.maximumWidth = n3;
    }

    public TypeDescriptorImpl(BaseTypeIdImpl baseTypeIdImpl, int n, int n2, boolean bl, int n3, int n4, int n5) {
        this.typeId = baseTypeIdImpl;
        this.precision = n;
        this.scale = n2;
        this.isNullable = bl;
        this.maximumWidth = n3;
        this.collationType = n4;
        this.collationDerivation = n5;
    }

    public TypeDescriptorImpl(BaseTypeIdImpl baseTypeIdImpl, boolean bl, int n) {
        this.typeId = baseTypeIdImpl;
        this.isNullable = bl;
        this.maximumWidth = n;
    }

    public TypeDescriptorImpl(TypeDescriptorImpl typeDescriptorImpl, int n, int n2, boolean bl, int n3) {
        this.typeId = typeDescriptorImpl.typeId;
        this.precision = n;
        this.scale = n2;
        this.isNullable = bl;
        this.maximumWidth = n3;
    }

    public TypeDescriptorImpl(TypeDescriptorImpl typeDescriptorImpl, int n, int n2, boolean bl, int n3, int n4, int n5) {
        this.typeId = typeDescriptorImpl.typeId;
        this.precision = n;
        this.scale = n2;
        this.isNullable = bl;
        this.maximumWidth = n3;
        this.collationType = n4;
        this.collationDerivation = n5;
    }

    public TypeDescriptorImpl(TypeDescriptorImpl typeDescriptorImpl, boolean bl, int n) {
        this.typeId = typeDescriptorImpl.typeId;
        this.precision = typeDescriptorImpl.precision;
        this.scale = typeDescriptorImpl.scale;
        this.isNullable = bl;
        this.maximumWidth = n;
    }

    public int getMaximumWidth() {
        return this.maximumWidth;
    }

    public int getMaximumWidthInBytes() {
        switch (this.typeId.getJDBCTypeId()) {
            case -7: 
            case -6: 
            case -4: 
            case -3: 
            case -2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 2004: {
                return this.maximumWidth;
            }
            case -5: {
                return 40;
            }
            case 91: 
            case 92: {
                return 6;
            }
            case 93: {
                return 16;
            }
            case 2: 
            case 3: {
                return 2 * (this.precision + 2);
            }
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                if (this.maximumWidth > 0 && 2 * this.maximumWidth < 0) {
                    return Integer.MAX_VALUE;
                }
                return 2 * this.maximumWidth;
            }
        }
        return -1;
    }

    public int getJDBCTypeId() {
        return this.typeId.getJDBCTypeId();
    }

    public String getTypeName() {
        return this.typeId.getSQLTypeName();
    }

    public int getPrecision() {
        return this.precision;
    }

    public int getScale() {
        return this.scale;
    }

    public boolean isNullable() {
        return this.isNullable;
    }

    public void setNullability(boolean bl) {
        this.isNullable = bl;
    }

    public int getCollationType() {
        return this.collationType;
    }

    public void setCollationType(int n) {
        this.collationType = n;
    }

    public int getCollationDerivation() {
        return this.collationDerivation;
    }

    public void setCollationDerivation(int n) {
        this.collationDerivation = n;
    }

    public String getCollationName() {
        return this.collationDerivation == 0 ? "NONE" : (this.collationType == 0 ? "UCS_BASIC" : "TERRITORY_BASED");
    }

    public String getSQLstring() {
        return this.typeId.toParsableString(this);
    }

    public String toString() {
        String string = this.getSQLstring();
        if (!this.isNullable()) {
            return string + " NOT NULL";
        }
        return string;
    }

    public BaseTypeIdImpl getTypeId() {
        return this.typeId;
    }

    public boolean equals(Object object) {
        TypeDescriptor typeDescriptor = (TypeDescriptor)object;
        if (!this.getTypeName().equals(typeDescriptor.getTypeName()) || this.precision != typeDescriptor.getPrecision() || this.scale != typeDescriptor.getScale() || this.isNullable != typeDescriptor.isNullable() || this.maximumWidth != typeDescriptor.getMaximumWidth()) {
            return false;
        }
        switch (this.typeId.getJDBCTypeId()) {
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                return this.collationDerivation == typeDescriptor.getCollationDerivation() && this.collationType == typeDescriptor.getCollationType();
            }
        }
        return true;
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.typeId = (BaseTypeIdImpl)objectInput.readObject();
        this.precision = objectInput.readInt();
        switch (this.typeId.getJDBCTypeId()) {
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                this.scale = 0;
                this.collationType = objectInput.readInt();
                this.collationDerivation = 1;
                break;
            }
            default: {
                this.scale = objectInput.readInt();
                this.collationType = 0;
                this.collationDerivation = 1;
            }
        }
        this.isNullable = objectInput.readBoolean();
        this.maximumWidth = objectInput.readInt();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(this.typeId);
        objectOutput.writeInt(this.precision);
        switch (this.typeId.getJDBCTypeId()) {
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                objectOutput.writeInt(this.collationType);
                break;
            }
            default: {
                objectOutput.writeInt(this.scale);
            }
        }
        objectOutput.writeBoolean(this.isNullable);
        objectOutput.writeInt(this.maximumWidth);
    }

    public int getTypeFormatId() {
        return 14;
    }
}

