/* xoreos-tools - Tools to help with xoreos development
 *
 * xoreos-tools is the legal property of its developers, whose names
 * can be found in the AUTHORS file distributed with this source
 * distribution.
 *
 * xoreos-tools is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 3
 * of the License, or (at your option) any later version.
 *
 * xoreos-tools is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with xoreos-tools. If not, see <http://www.gnu.org/licenses/>.
 */

/** @file
 *  Game-specific NWScript information for Star Wars: Knights of the Old Republic II - The Sith Lords.
 */

#ifndef NWSCRIPT_GAME_KOTOR2_H
#define NWSCRIPT_GAME_KOTOR2_H

#include "src/nwscript/game.h"

namespace NWScript {

namespace KotOR2 {

static const char * const kEngineTypeNames[] = {
	"Effect", "Event", "Location", "Talent"
};

static const char * const kFunctionNames[] = {
	/*   0 */ "Random",
	/*   1 */ "PrintString",
	/*   2 */ "PrintFloat",
	/*   3 */ "FloatToString",
	/*   4 */ "PrintInteger",
	/*   5 */ "PrintObject",
	/*   6 */ "AssignCommand",
	/*   7 */ "DelayCommand",
	/*   8 */ "ExecuteScript",
	/*   9 */ "ClearAllActions",
	/*  10 */ "SetFacing",
	/*  11 */ "SwitchPlayerCharacter",
	/*  12 */ "SetTime",
	/*  13 */ "SetPartyLeader",
	/*  14 */ "SetAreaUnescapable",
	/*  15 */ "GetAreaUnescapable",
	/*  16 */ "GetTimeHour",
	/*  17 */ "GetTimeMinute",
	/*  18 */ "GetTimeSecond",
	/*  19 */ "GetTimeMillisecond",
	/*  20 */ "ActionRandomWalk",
	/*  21 */ "ActionMoveToLocation",
	/*  22 */ "ActionMoveToObject",
	/*  23 */ "ActionMoveAwayFromObject",
	/*  24 */ "GetArea",
	/*  25 */ "GetEnteringObject",
	/*  26 */ "GetExitingObject",
	/*  27 */ "GetPosition",
	/*  28 */ "GetFacing",
	/*  29 */ "GetItemPossessor",
	/*  30 */ "GetItemPossessedBy",
	/*  31 */ "CreateItemOnObject",
	/*  32 */ "ActionEquipItem",
	/*  33 */ "ActionUnequipItem",
	/*  34 */ "ActionPickUpItem",
	/*  35 */ "ActionPutDownItem",
	/*  36 */ "GetLastAttacker",
	/*  37 */ "ActionAttack",
	/*  38 */ "GetNearestCreature",
	/*  39 */ "ActionSpeakString",
	/*  40 */ "ActionPlayAnimation",
	/*  41 */ "GetDistanceToObject",
	/*  42 */ "GetIsObjectValid",
	/*  43 */ "ActionOpenDoor",
	/*  44 */ "ActionCloseDoor",
	/*  45 */ "SetCameraFacing",
	/*  46 */ "PlaySound",
	/*  47 */ "GetSpellTargetObject",
	/*  48 */ "ActionCastSpellAtObject",
	/*  49 */ "GetCurrentHitPoints",
	/*  50 */ "GetMaxHitPoints",
	/*  51 */ "EffectAssuredHit",
	/*  52 */ "GetLastItemEquipped",
	/*  53 */ "GetSubScreenID",
	/*  54 */ "CancelCombat",
	/*  55 */ "GetCurrentForcePoints",
	/*  56 */ "GetMaxForcePoints",
	/*  57 */ "PauseGame",
	/*  58 */ "SetPlayerRestrictMode",
	/*  59 */ "GetStringLength",
	/*  60 */ "GetStringUpperCase",
	/*  61 */ "GetStringLowerCase",
	/*  62 */ "GetStringRight",
	/*  63 */ "GetStringLeft",
	/*  64 */ "InsertString",
	/*  65 */ "GetSubString",
	/*  66 */ "FindSubString",
	/*  67 */ "fabs",
	/*  68 */ "cos",
	/*  69 */ "sin",
	/*  70 */ "tan",
	/*  71 */ "acos",
	/*  72 */ "asin",
	/*  73 */ "atan",
	/*  74 */ "log",
	/*  75 */ "pow",
	/*  76 */ "sqrt",
	/*  77 */ "abs",
	/*  78 */ "EffectHeal",
	/*  79 */ "EffectDamage",
	/*  80 */ "EffectAbilityIncrease",
	/*  81 */ "EffectDamageResistance",
	/*  82 */ "EffectResurrection",
	/*  83 */ "GetPlayerRestrictMode",
	/*  84 */ "GetCasterLevel",
	/*  85 */ "GetFirstEffect",
	/*  86 */ "GetNextEffect",
	/*  87 */ "RemoveEffect",
	/*  88 */ "GetIsEffectValid",
	/*  89 */ "GetEffectDurationType",
	/*  90 */ "GetEffectSubType",
	/*  91 */ "GetEffectCreator",
	/*  92 */ "IntToString",
	/*  93 */ "GetFirstObjectInArea",
	/*  94 */ "GetNextObjectInArea",
	/*  95 */ "d2",
	/*  96 */ "d3",
	/*  97 */ "d4",
	/*  98 */ "d6",
	/*  99 */ "d8",
	/* 100 */ "d10",
	/* 101 */ "d12",
	/* 102 */ "d20",
	/* 103 */ "d100",
	/* 104 */ "VectorMagnitude",
	/* 105 */ "GetMetaMagicFeat",
	/* 106 */ "GetObjectType",
	/* 107 */ "GetRacialType",
	/* 108 */ "FortitudeSave",
	/* 109 */ "ReflexSave",
	/* 110 */ "WillSave",
	/* 111 */ "GetSpellSaveDC",
	/* 112 */ "MagicalEffect",
	/* 113 */ "SupernaturalEffect",
	/* 114 */ "ExtraordinaryEffect",
	/* 115 */ "EffectACIncrease",
	/* 116 */ "GetAC",
	/* 117 */ "EffectSavingThrowIncrease",
	/* 118 */ "EffectAttackIncrease",
	/* 119 */ "EffectDamageReduction",
	/* 120 */ "EffectDamageIncrease",
	/* 121 */ "RoundsToSeconds",
	/* 122 */ "HoursToSeconds",
	/* 123 */ "TurnsToSeconds",
	/* 124 */ "SoundObjectSetFixedVariance",
	/* 125 */ "GetGoodEvilValue",
	/* 126 */ "GetPartyMemberCount",
	/* 127 */ "GetAlignmentGoodEvil",
	/* 128 */ "GetFirstObjectInShape",
	/* 129 */ "GetNextObjectInShape",
	/* 130 */ "EffectEntangle",
	/* 131 */ "SignalEvent",
	/* 132 */ "EventUserDefined",
	/* 133 */ "EffectDeath",
	/* 134 */ "EffectKnockdown",
	/* 135 */ "ActionGiveItem",
	/* 136 */ "ActionTakeItem",
	/* 137 */ "VectorNormalize",
	/* 138 */ "GetItemStackSize",
	/* 139 */ "GetAbilityScore",
	/* 140 */ "GetIsDead",
	/* 141 */ "PrintVector",
	/* 142 */ "Vector",
	/* 143 */ "SetFacingPoint",
	/* 144 */ "AngleToVector",
	/* 145 */ "VectorToAngle",
	/* 146 */ "TouchAttackMelee",
	/* 147 */ "TouchAttackRanged",
	/* 148 */ "EffectParalyze",
	/* 149 */ "EffectSpellImmunity",
	/* 150 */ "SetItemStackSize",
	/* 151 */ "GetDistanceBetween",
	/* 152 */ "SetReturnStrref",
	/* 153 */ "EffectForceJump",
	/* 154 */ "EffectSleep",
	/* 155 */ "GetItemInSlot",
	/* 156 */ "EffectTemporaryForcePoints",
	/* 157 */ "EffectConfused",
	/* 158 */ "EffectFrightened",
	/* 159 */ "EffectChoke",
	/* 160 */ "SetGlobalString",
	/* 161 */ "EffectStunned",
	/* 162 */ "SetCommandable",
	/* 163 */ "GetCommandable",
	/* 164 */ "EffectRegenerate",
	/* 165 */ "EffectMovementSpeedIncrease",
	/* 166 */ "GetHitDice",
	/* 167 */ "ActionForceFollowObject",
	/* 168 */ "GetTag",
	/* 169 */ "ResistForce",
	/* 170 */ "GetEffectType",
	/* 171 */ "EffectAreaOfEffect",
	/* 172 */ "GetFactionEqual",
	/* 173 */ "ChangeFaction",
	/* 174 */ "GetIsListening",
	/* 175 */ "SetListening",
	/* 176 */ "SetListenPattern",
	/* 177 */ "TestStringAgainstPattern",
	/* 178 */ "GetMatchedSubstring",
	/* 179 */ "GetMatchedSubstringsCount",
	/* 180 */ "EffectVisualEffect",
	/* 181 */ "GetFactionWeakestMember",
	/* 182 */ "GetFactionStrongestMember",
	/* 183 */ "GetFactionMostDamagedMember",
	/* 184 */ "GetFactionLeastDamagedMember",
	/* 185 */ "GetFactionGold",
	/* 186 */ "GetFactionAverageReputation",
	/* 187 */ "GetFactionAverageGoodEvilAlignment",
	/* 188 */ "SoundObjectGetFixedVariance",
	/* 189 */ "GetFactionAverageLevel",
	/* 190 */ "GetFactionAverageXP",
	/* 191 */ "GetFactionMostFrequentClass",
	/* 192 */ "GetFactionWorstAC",
	/* 193 */ "GetFactionBestAC",
	/* 194 */ "GetGlobalString",
	/* 195 */ "GetListenPatternNumber",
	/* 196 */ "ActionJumpToObject",
	/* 197 */ "GetWaypointByTag",
	/* 198 */ "GetTransitionTarget",
	/* 199 */ "EffectLinkEffects",
	/* 200 */ "GetObjectByTag",
	/* 201 */ "AdjustAlignment",
	/* 202 */ "ActionWait",
	/* 203 */ "SetAreaTransitionBMP",
	/* 204 */ "ActionStartConversation",
	/* 205 */ "ActionPauseConversation",
	/* 206 */ "ActionResumeConversation",
	/* 207 */ "EffectBeam",
	/* 208 */ "GetReputation",
	/* 209 */ "AdjustReputation",
	/* 210 */ "GetModuleFileName",
	/* 211 */ "GetGoingToBeAttackedBy",
	/* 212 */ "EffectForceResistanceIncrease",
	/* 213 */ "GetLocation",
	/* 214 */ "ActionJumpToLocation",
	/* 215 */ "Location",
	/* 216 */ "ApplyEffectAtLocation",
	/* 217 */ "GetIsPC",
	/* 218 */ "FeetToMeters",
	/* 219 */ "YardsToMeters",
	/* 220 */ "ApplyEffectToObject",
	/* 221 */ "SpeakString",
	/* 222 */ "GetSpellTargetLocation",
	/* 223 */ "GetPositionFromLocation",
	/* 224 */ "EffectBodyFuel",
	/* 225 */ "GetFacingFromLocation",
	/* 226 */ "GetNearestCreatureToLocation",
	/* 227 */ "GetNearestObject",
	/* 228 */ "GetNearestObjectToLocation",
	/* 229 */ "GetNearestObjectByTag",
	/* 230 */ "IntToFloat",
	/* 231 */ "FloatToInt",
	/* 232 */ "StringToInt",
	/* 233 */ "StringToFloat",
	/* 234 */ "ActionCastSpellAtLocation",
	/* 235 */ "GetIsEnemy",
	/* 236 */ "GetIsFriend",
	/* 237 */ "GetIsNeutral",
	/* 238 */ "GetPCSpeaker",
	/* 239 */ "GetStringByStrRef",
	/* 240 */ "ActionSpeakStringByStrRef",
	/* 241 */ "DestroyObject",
	/* 242 */ "GetModule",
	/* 243 */ "CreateObject",
	/* 244 */ "EventSpellCastAt",
	/* 245 */ "GetLastSpellCaster",
	/* 246 */ "GetLastSpell",
	/* 247 */ "GetUserDefinedEventNumber",
	/* 248 */ "GetSpellId",
	/* 249 */ "RandomName",
	/* 250 */ "EffectPoison",
	/* 251 */ "GetLoadFromSaveGame",
	/* 252 */ "EffectAssuredDeflection",
	/* 253 */ "GetName",
	/* 254 */ "GetLastSpeaker",
	/* 255 */ "BeginConversation",
	/* 256 */ "GetLastPerceived",
	/* 257 */ "GetLastPerceptionHeard",
	/* 258 */ "GetLastPerceptionInaudible",
	/* 259 */ "GetLastPerceptionSeen",
	/* 260 */ "GetLastClosedBy",
	/* 261 */ "GetLastPerceptionVanished",
	/* 262 */ "GetFirstInPersistentObject",
	/* 263 */ "GetNextInPersistentObject",
	/* 264 */ "GetAreaOfEffectCreator",
	/* 265 */ "ShowLevelUpGUI",
	/* 266 */ "SetItemNonEquippable",
	/* 267 */ "GetButtonMashCheck",
	/* 268 */ "SetButtonMashCheck",
	/* 269 */ "EffectForcePushTargeted",
	/* 270 */ "EffectHaste",
	/* 271 */ "GiveItem",
	/* 272 */ "ObjectToString",
	/* 273 */ "EffectImmunity",
	/* 274 */ "GetIsImmune",
	/* 275 */ "EffectDamageImmunityIncrease",
	/* 276 */ "GetEncounterActive",
	/* 277 */ "SetEncounterActive",
	/* 278 */ "GetEncounterSpawnsMax",
	/* 279 */ "SetEncounterSpawnsMax",
	/* 280 */ "GetEncounterSpawnsCurrent",
	/* 281 */ "SetEncounterSpawnsCurrent",
	/* 282 */ "GetModuleItemAcquired",
	/* 283 */ "GetModuleItemAcquiredFrom",
	/* 284 */ "SetCustomToken",
	/* 285 */ "GetHasFeat",
	/* 286 */ "GetHasSkill",
	/* 287 */ "ActionUseFeat",
	/* 288 */ "ActionUseSkill",
	/* 289 */ "GetObjectSeen",
	/* 290 */ "GetObjectHeard",
	/* 291 */ "GetLastPlayerDied",
	/* 292 */ "GetModuleItemLost",
	/* 293 */ "GetModuleItemLostBy",
	/* 294 */ "ActionDoCommand",
	/* 295 */ "EventConversation",
	/* 296 */ "SetEncounterDifficulty",
	/* 297 */ "GetEncounterDifficulty",
	/* 298 */ "GetDistanceBetweenLocations",
	/* 299 */ "GetReflexAdjustedDamage",
	/* 300 */ "PlayAnimation",
	/* 301 */ "TalentSpell",
	/* 302 */ "TalentFeat",
	/* 303 */ "TalentSkill",
	/* 304 */ "GetHasSpellEffect",
	/* 305 */ "GetEffectSpellId",
	/* 306 */ "GetCreatureHasTalent",
	/* 307 */ "GetCreatureTalentRandom",
	/* 308 */ "GetCreatureTalentBest",
	/* 309 */ "ActionUseTalentOnObject",
	/* 310 */ "ActionUseTalentAtLocation",
	/* 311 */ "GetGoldPieceValue",
	/* 312 */ "GetIsPlayableRacialType",
	/* 313 */ "JumpToLocation",
	/* 314 */ "EffectTemporaryHitpoints",
	/* 315 */ "GetSkillRank",
	/* 316 */ "GetAttackTarget",
	/* 317 */ "GetLastAttackType",
	/* 318 */ "GetLastAttackMode",
	/* 319 */ "GetDistanceBetween2D",
	/* 320 */ "GetIsInCombat",
	/* 321 */ "GetLastAssociateCommand",
	/* 322 */ "GiveGoldToCreature",
	/* 323 */ "SetIsDestroyable",
	/* 324 */ "SetLocked",
	/* 325 */ "GetLocked",
	/* 326 */ "GetClickingObject",
	/* 327 */ "SetAssociateListenPatterns",
	/* 328 */ "GetLastWeaponUsed",
	/* 329 */ "ActionInteractObject",
	/* 330 */ "GetLastUsedBy",
	/* 331 */ "GetAbilityModifier",
	/* 332 */ "GetIdentified",
	/* 333 */ "SetIdentified",
	/* 334 */ "GetDistanceBetweenLocations2D",
	/* 335 */ "GetDistanceToObject2D",
	/* 336 */ "GetBlockingDoor",
	/* 337 */ "GetIsDoorActionPossible",
	/* 338 */ "DoDoorAction",
	/* 339 */ "GetFirstItemInInventory",
	/* 340 */ "GetNextItemInInventory",
	/* 341 */ "GetClassByPosition",
	/* 342 */ "GetLevelByPosition",
	/* 343 */ "GetLevelByClass",
	/* 344 */ "GetDamageDealtByType",
	/* 345 */ "GetTotalDamageDealt",
	/* 346 */ "GetLastDamager",
	/* 347 */ "GetLastDisarmed",
	/* 348 */ "GetLastDisturbed",
	/* 349 */ "GetLastLocked",
	/* 350 */ "GetLastUnlocked",
	/* 351 */ "EffectSkillIncrease",
	/* 352 */ "GetInventoryDisturbType",
	/* 353 */ "GetInventoryDisturbItem",
	/* 354 */ "ShowUpgradeScreen",
	/* 355 */ "VersusAlignmentEffect",
	/* 356 */ "VersusRacialTypeEffect",
	/* 357 */ "VersusTrapEffect",
	/* 358 */ "GetGender",
	/* 359 */ "GetIsTalentValid",
	/* 360 */ "ActionMoveAwayFromLocation",
	/* 361 */ "GetAttemptedAttackTarget",
	/* 362 */ "GetTypeFromTalent",
	/* 363 */ "GetIdFromTalent",
	/* 364 */ "PlayPazaak",
	/* 365 */ "GetLastPazaakResult",
	/* 366 */ "DisplayFeedBackText",
	/* 367 */ "AddJournalQuestEntry",
	/* 368 */ "RemoveJournalQuestEntry",
	/* 369 */ "GetJournalEntry",
	/* 370 */ "PlayRumblePattern",
	/* 371 */ "StopRumblePattern",
	/* 372 */ "EffectDamageForcePoints",
	/* 373 */ "EffectHealForcePoints",
	/* 374 */ "SendMessageToPC",
	/* 375 */ "GetAttemptedSpellTarget",
	/* 376 */ "GetLastOpenedBy",
	/* 377 */ "GetHasSpell",
	/* 378 */ "OpenStore",
	/* 379 */ "ActionSurrenderToEnemies",
	/* 380 */ "GetFirstFactionMember",
	/* 381 */ "GetNextFactionMember",
	/* 382 */ "ActionForceMoveToLocation",
	/* 383 */ "ActionForceMoveToObject",
	/* 384 */ "GetJournalQuestExperience",
	/* 385 */ "JumpToObject",
	/* 386 */ "SetMapPinEnabled",
	/* 387 */ "EffectHitPointChangeWhenDying",
	/* 388 */ "PopUpGUIPanel",
	/* 389 */ "AddMultiClass",
	/* 390 */ "GetIsLinkImmune",
	/* 391 */ "EffectDroidStun",
	/* 392 */ "EffectForcePushed",
	/* 393 */ "GiveXPToCreature",
	/* 394 */ "SetXP",
	/* 395 */ "GetXP",
	/* 396 */ "IntToHexString",
	/* 397 */ "GetBaseItemType",
	/* 398 */ "GetItemHasItemProperty",
	/* 399 */ "ActionEquipMostDamagingMelee",
	/* 400 */ "ActionEquipMostDamagingRanged",
	/* 401 */ "GetItemACValue",
	/* 402 */ "EffectForceResisted",
	/* 403 */ "ExploreAreaForPlayer",
	/* 404 */ "ActionEquipMostEffectiveArmor",
	/* 405 */ "GetIsDay",
	/* 406 */ "GetIsNight",
	/* 407 */ "GetIsDawn",
	/* 408 */ "GetIsDusk",
	/* 409 */ "GetIsEncounterCreature",
	/* 410 */ "GetLastPlayerDying",
	/* 411 */ "GetStartingLocation",
	/* 412 */ "ChangeToStandardFaction",
	/* 413 */ "SoundObjectPlay",
	/* 414 */ "SoundObjectStop",
	/* 415 */ "SoundObjectSetVolume",
	/* 416 */ "SoundObjectSetPosition",
	/* 417 */ "SpeakOneLinerConversation",
	/* 418 */ "GetGold",
	/* 419 */ "GetLastRespawnButtonPresser",
	/* 420 */ "EffectForceFizzle",
	/* 421 */ "SetLightsaberPowered",
	/* 422 */ "GetIsWeaponEffective",
	/* 423 */ "GetLastSpellHarmful",
	/* 424 */ "EventActivateItem",
	/* 425 */ "MusicBackgroundPlay",
	/* 426 */ "MusicBackgroundStop",
	/* 427 */ "MusicBackgroundSetDelay",
	/* 428 */ "MusicBackgroundChangeDay",
	/* 429 */ "MusicBackgroundChangeNight",
	/* 430 */ "MusicBattlePlay",
	/* 431 */ "MusicBattleStop",
	/* 432 */ "MusicBattleChange",
	/* 433 */ "AmbientSoundPlay",
	/* 434 */ "AmbientSoundStop",
	/* 435 */ "AmbientSoundChangeDay",
	/* 436 */ "AmbientSoundChangeNight",
	/* 437 */ "GetLastKiller",
	/* 438 */ "GetSpellCastItem",
	/* 439 */ "GetItemActivated",
	/* 440 */ "GetItemActivator",
	/* 441 */ "GetItemActivatedTargetLocation",
	/* 442 */ "GetItemActivatedTarget",
	/* 443 */ "GetIsOpen",
	/* 444 */ "TakeGoldFromCreature",
	/* 445 */ "GetIsInConversation",
	/* 446 */ "EffectAbilityDecrease",
	/* 447 */ "EffectAttackDecrease",
	/* 448 */ "EffectDamageDecrease",
	/* 449 */ "EffectDamageImmunityDecrease",
	/* 450 */ "EffectACDecrease",
	/* 451 */ "EffectMovementSpeedDecrease",
	/* 452 */ "EffectSavingThrowDecrease",
	/* 453 */ "EffectSkillDecrease",
	/* 454 */ "EffectForceResistanceDecrease",
	/* 455 */ "GetPlotFlag",
	/* 456 */ "SetPlotFlag",
	/* 457 */ "EffectInvisibility",
	/* 458 */ "EffectConcealment",
	/* 459 */ "EffectForceShield",
	/* 460 */ "EffectDispelMagicAll",
	/* 461 */ "SetDialogPlaceableCamera",
	/* 462 */ "GetSoloMode",
	/* 463 */ "EffectDisguise",
	/* 464 */ "GetMaxStealthXP",
	/* 465 */ "EffectTrueSeeing",
	/* 466 */ "EffectSeeInvisible",
	/* 467 */ "EffectTimeStop",
	/* 468 */ "SetMaxStealthXP",
	/* 469 */ "EffectBlasterDeflectionIncrease",
	/* 470 */ "EffectBlasterDeflectionDecrease",
	/* 471 */ "EffectHorrified",
	/* 472 */ "EffectSpellLevelAbsorption",
	/* 473 */ "EffectDispelMagicBest",
	/* 474 */ "GetCurrentStealthXP",
	/* 475 */ "GetNumStackedItems",
	/* 476 */ "SurrenderToEnemies",
	/* 477 */ "EffectMissChance",
	/* 478 */ "SetCurrentStealthXP",
	/* 479 */ "GetCreatureSize",
	/* 480 */ "AwardStealthXP",
	/* 481 */ "GetStealthXPEnabled",
	/* 482 */ "SetStealthXPEnabled",
	/* 483 */ "ActionUnlockObject",
	/* 484 */ "ActionLockObject",
	/* 485 */ "EffectModifyAttacks",
	/* 486 */ "GetLastTrapDetected",
	/* 487 */ "EffectDamageShield",
	/* 488 */ "GetNearestTrapToObject",
	/* 489 */ "GetAttemptedMovementTarget",
	/* 490 */ "GetBlockingCreature",
	/* 491 */ "GetFortitudeSavingThrow",
	/* 492 */ "GetWillSavingThrow",
	/* 493 */ "GetReflexSavingThrow",
	/* 494 */ "GetChallengeRating",
	/* 495 */ "GetFoundEnemyCreature",
	/* 496 */ "GetMovementRate",
	/* 497 */ "GetSubRace",
	/* 498 */ "GetStealthXPDecrement",
	/* 499 */ "SetStealthXPDecrement",
	/* 500 */ "DuplicateHeadAppearance",
	/* 501 */ "ActionCastFakeSpellAtObject",
	/* 502 */ "ActionCastFakeSpellAtLocation",
	/* 503 */ "CutsceneAttack",
	/* 504 */ "SetCameraMode",
	/* 505 */ "SetLockOrientationInDialog",
	/* 506 */ "SetLockHeadFollowInDialog",
	/* 507 */ "CutsceneMove",
	/* 508 */ "EnableVideoEffect",
	/* 509 */ "StartNewModule",
	/* 510 */ "DisableVideoEffect",
	/* 511 */ "GetWeaponRanged",
	/* 512 */ "DoSinglePlayerAutoSave",
	/* 513 */ "GetGameDifficulty",
	/* 514 */ "GetUserActionsPending",
	/* 515 */ "RevealMap",
	/* 516 */ "SetTutorialWindowsEnabled",
	/* 517 */ "ShowTutorialWindow",
	/* 518 */ "StartCreditSequence",
	/* 519 */ "IsCreditSequenceInProgress",
	/* 520 */ "SWMG_SetLateralAccelerationPerSecond",
	/* 521 */ "SWMG_GetLateralAccelerationPerSecond",
	/* 522 */ "GetCurrentAction",
	/* 523 */ "GetDifficultyModifier",
	/* 524 */ "GetAppearanceType",
	/* 525 */ "FloatingTextStrRefOnCreature",
	/* 526 */ "FloatingTextStringOnCreature",
	/* 527 */ "GetTrapDisarmable",
	/* 528 */ "GetTrapDetectable",
	/* 529 */ "GetTrapDetectedBy",
	/* 530 */ "GetTrapFlagged",
	/* 531 */ "GetTrapBaseType",
	/* 532 */ "GetTrapOneShot",
	/* 533 */ "GetTrapCreator",
	/* 534 */ "GetTrapKeyTag",
	/* 535 */ "GetTrapDisarmDC",
	/* 536 */ "GetTrapDetectDC",
	/* 537 */ "GetLockKeyRequired",
	/* 538 */ "GetLockKeyTag",
	/* 539 */ "GetLockLockable",
	/* 540 */ "GetLockUnlockDC",
	/* 541 */ "GetLockLockDC",
	/* 542 */ "GetPCLevellingUp",
	/* 543 */ "GetHasFeatEffect",
	/* 544 */ "SetPlaceableIllumination",
	/* 545 */ "GetPlaceableIllumination",
	/* 546 */ "GetIsPlaceableObjectActionPossible",
	/* 547 */ "DoPlaceableObjectAction",
	/* 548 */ "GetFirstPC",
	/* 549 */ "GetNextPC",
	/* 550 */ "SetTrapDetectedBy",
	/* 551 */ "GetIsTrapped",
	/* 552 */ "SetEffectIcon",
	/* 553 */ "FaceObjectAwayFromObject",
	/* 554 */ "PopUpDeathGUIPanel",
	/* 555 */ "SetTrapDisabled",
	/* 556 */ "GetLastHostileActor",
	/* 557 */ "ExportAllCharacters",
	/* 558 */ "MusicBackgroundGetDayTrack",
	/* 559 */ "MusicBackgroundGetNightTrack",
	/* 560 */ "WriteTimestampedLogEntry",
	/* 561 */ "GetModuleName",
	/* 562 */ "GetFactionLeader",
	/* 563 */ "SWMG_SetSpeedBlurEffect",
	/* 564 */ "EndGame",
	/* 565 */ "GetRunScriptVar",
	/* 566 */ "GetCreatureMovmentType",
	/* 567 */ "AmbientSoundSetDayVolume",
	/* 568 */ "AmbientSoundSetNightVolume",
	/* 569 */ "MusicBackgroundGetBattleTrack",
	/* 570 */ "GetHasInventory",
	/* 571 */ "GetStrRefSoundDuration",
	/* 572 */ "AddToParty",
	/* 573 */ "RemoveFromParty",
	/* 574 */ "AddPartyMember",
	/* 575 */ "RemovePartyMember",
	/* 576 */ "IsObjectPartyMember",
	/* 577 */ "GetPartyMemberByIndex",
	/* 578 */ "GetGlobalBoolean",
	/* 579 */ "SetGlobalBoolean",
	/* 580 */ "GetGlobalNumber",
	/* 581 */ "SetGlobalNumber",
	/* 582 */ "AurPostString",
	/* 583 */ "SWMG_GetLastEvent",
	/* 584 */ "SWMG_GetLastEventModelName",
	/* 585 */ "SWMG_GetObjectByName",
	/* 586 */ "SWMG_PlayAnimation",
	/* 587 */ "SWMG_GetLastBulletHitDamage",
	/* 588 */ "SWMG_GetLastBulletHitTarget",
	/* 589 */ "SWMG_GetLastBulletHitShooter",
	/* 590 */ "SWMG_AdjustFollowerHitPoints",
	/* 591 */ "SWMG_OnBulletHit",
	/* 592 */ "SWMG_OnObstacleHit",
	/* 593 */ "SWMG_GetLastFollowerHit",
	/* 594 */ "SWMG_GetLastObstacleHit",
	/* 595 */ "SWMG_GetLastBulletFiredDamage",
	/* 596 */ "SWMG_GetLastBulletFiredTarget",
	/* 597 */ "SWMG_GetObjectName",
	/* 598 */ "SWMG_OnDeath",
	/* 599 */ "SWMG_IsFollower",
	/* 600 */ "SWMG_IsPlayer",
	/* 601 */ "SWMG_IsEnemy",
	/* 602 */ "SWMG_IsTrigger",
	/* 603 */ "SWMG_IsObstacle",
	/* 604 */ "SWMG_SetFollowerHitPoints",
	/* 605 */ "SWMG_OnDamage",
	/* 606 */ "SWMG_GetLastHPChange",
	/* 607 */ "SWMG_RemoveAnimation",
	/* 608 */ "SWMG_GetCameraNearClip",
	/* 609 */ "SWMG_GetCameraFarClip",
	/* 610 */ "SWMG_SetCameraClip",
	/* 611 */ "SWMG_GetPlayer",
	/* 612 */ "SWMG_GetEnemyCount",
	/* 613 */ "SWMG_GetEnemy",
	/* 614 */ "SWMG_GetObstacleCount",
	/* 615 */ "SWMG_GetObstacle",
	/* 616 */ "SWMG_GetHitPoints",
	/* 617 */ "SWMG_GetMaxHitPoints",
	/* 618 */ "SWMG_SetMaxHitPoints",
	/* 619 */ "SWMG_GetSphereRadius",
	/* 620 */ "SWMG_SetSphereRadius",
	/* 621 */ "SWMG_GetNumLoops",
	/* 622 */ "SWMG_SetNumLoops",
	/* 623 */ "SWMG_GetPosition",
	/* 624 */ "SWMG_GetGunBankCount",
	/* 625 */ "SWMG_GetGunBankBulletModel",
	/* 626 */ "SWMG_GetGunBankGunModel",
	/* 627 */ "SWMG_GetGunBankDamage",
	/* 628 */ "SWMG_GetGunBankTimeBetweenShots",
	/* 629 */ "SWMG_GetGunBankLifespan",
	/* 630 */ "SWMG_GetGunBankSpeed",
	/* 631 */ "SWMG_GetGunBankTarget",
	/* 632 */ "SWMG_SetGunBankBulletModel",
	/* 633 */ "SWMG_SetGunBankGunModel",
	/* 634 */ "SWMG_SetGunBankDamage",
	/* 635 */ "SWMG_SetGunBankTimeBetweenShots",
	/* 636 */ "SWMG_SetGunBankLifespan",
	/* 637 */ "SWMG_SetGunBankSpeed",
	/* 638 */ "SWMG_SetGunBankTarget",
	/* 639 */ "SWMG_GetLastBulletHitPart",
	/* 640 */ "SWMG_IsGunBankTargetting",
	/* 641 */ "SWMG_GetPlayerOffset",
	/* 642 */ "SWMG_GetPlayerInvincibility",
	/* 643 */ "SWMG_GetPlayerSpeed",
	/* 644 */ "SWMG_GetPlayerMinSpeed",
	/* 645 */ "SWMG_GetPlayerAccelerationPerSecond",
	/* 646 */ "SWMG_GetPlayerTunnelPos",
	/* 647 */ "SWMG_SetPlayerOffset",
	/* 648 */ "SWMG_SetPlayerInvincibility",
	/* 649 */ "SWMG_SetPlayerSpeed",
	/* 650 */ "SWMG_SetPlayerMinSpeed",
	/* 651 */ "SWMG_SetPlayerAccelerationPerSecond",
	/* 652 */ "SWMG_SetPlayerTunnelPos",
	/* 653 */ "SWMG_GetPlayerTunnelNeg",
	/* 654 */ "SWMG_SetPlayerTunnelNeg",
	/* 655 */ "SWMG_GetPlayerOrigin",
	/* 656 */ "SWMG_SetPlayerOrigin",
	/* 657 */ "SWMG_GetGunBankHorizontalSpread",
	/* 658 */ "SWMG_GetGunBankVerticalSpread",
	/* 659 */ "SWMG_GetGunBankSensingRadius",
	/* 660 */ "SWMG_GetGunBankInaccuracy",
	/* 661 */ "SWMG_SetGunBankHorizontalSpread",
	/* 662 */ "SWMG_SetGunBankVerticalSpread",
	/* 663 */ "SWMG_SetGunBankSensingRadius",
	/* 664 */ "SWMG_SetGunBankInaccuracy",
	/* 665 */ "SWMG_GetIsInvulnerable",
	/* 666 */ "SWMG_StartInvulnerability",
	/* 667 */ "SWMG_GetPlayerMaxSpeed",
	/* 668 */ "SWMG_SetPlayerMaxSpeed",
	/* 669 */ "AddJournalEntry",
	/* 670 */ "AddJournalEntryStrref",
	/* 671 */ "BarkString",
	/* 672 */ "DeleteJournalAllEntries",
	/* 673 */ "DeleteJournalEntry",
	/* 674 */ "DeleteJournalEntryStrref",
	/* 675 */ "EffectForceDrain",
	/* 676 */ "EffectPsychicStatic",
	/* 677 */ "PlayVisualAreaEffect",
	/* 678 */ "SetJournalQuestEntryPicture",
	/* 679 */ "GetLocalBoolean",
	/* 680 */ "SetLocalBoolean",
	/* 681 */ "GetLocalNumber",
	/* 682 */ "SetLocalNumber",
	/* 683 */ "SWMG_GetSoundFrequency",
	/* 684 */ "SWMG_SetSoundFrequency",
	/* 685 */ "SWMG_GetSoundFrequencyIsRandom",
	/* 686 */ "SWMG_SetSoundFrequencyIsRandom",
	/* 687 */ "SWMG_GetSoundVolume",
	/* 688 */ "SWMG_SetSoundVolume",
	/* 689 */ "SoundObjectGetPitchVariance",
	/* 690 */ "SoundObjectSetPitchVariance",
	/* 691 */ "SoundObjectGetVolume",
	/* 692 */ "GetGlobalLocation",
	/* 693 */ "SetGlobalLocation",
	/* 694 */ "AddAvailableNPCByObject",
	/* 695 */ "RemoveAvailableNPC",
	/* 696 */ "IsAvailableCreature",
	/* 697 */ "AddAvailableNPCByTemplate",
	/* 698 */ "SpawnAvailableNPC",
	/* 699 */ "IsNPCPartyMember",
	/* 700 */ "ActionBarkString",
	/* 701 */ "GetIsConversationActive",
	/* 702 */ "EffectLightsaberThrow",
	/* 703 */ "EffectWhirlWind",
	/* 704 */ "GetPartyAIStyle",
	/* 705 */ "GetNPCAIStyle",
	/* 706 */ "SetPartyAIStyle",
	/* 707 */ "SetNPCAIStyle",
	/* 708 */ "SetNPCSelectability",
	/* 709 */ "GetNPCSelectability",
	/* 710 */ "ClearAllEffects",
	/* 711 */ "GetLastConversation",
	/* 712 */ "ShowPartySelectionGUI",
	/* 713 */ "GetStandardFaction",
	/* 714 */ "GivePlotXP",
	/* 715 */ "GetMinOneHP",
	/* 716 */ "SetMinOneHP",
	/* 717 */ "SWMG_GetPlayerTunnelInfinite",
	/* 718 */ "SWMG_SetPlayerTunnelInfinite",
	/* 719 */ "SetGlobalFadeIn",
	/* 720 */ "SetGlobalFadeOut",
	/* 721 */ "GetLastHostileTarget",
	/* 722 */ "GetLastAttackAction",
	/* 723 */ "GetLastForcePowerUsed",
	/* 724 */ "GetLastCombatFeatUsed",
	/* 725 */ "GetLastAttackResult",
	/* 726 */ "GetWasForcePowerSuccessful",
	/* 727 */ "GetFirstAttacker",
	/* 728 */ "GetNextAttacker",
	/* 729 */ "SetFormation",
	/* 730 */ "ActionFollowLeader",
	/* 731 */ "SetForcePowerUnsuccessful",
	/* 732 */ "GetIsDebilitated",
	/* 733 */ "PlayMovie",
	/* 734 */ "SaveNPCState",
	/* 735 */ "GetCategoryFromTalent",
	/* 736 */ "SurrenderByFaction",
	/* 737 */ "ChangeFactionByFaction",
	/* 738 */ "PlayRoomAnimation",
	/* 739 */ "ShowGalaxyMap",
	/* 740 */ "SetPlanetSelectable",
	/* 741 */ "GetPlanetSelectable",
	/* 742 */ "SetPlanetAvailable",
	/* 743 */ "GetPlanetAvailable",
	/* 744 */ "GetSelectedPlanet",
	/* 745 */ "SoundObjectFadeAndStop",
	/* 746 */ "SetAreaFogColor",
	/* 747 */ "ChangeItemCost",
	/* 748 */ "GetIsLiveContentAvailable",
	/* 749 */ "ResetDialogState",
	/* 750 */ "SetGoodEvilValue",
	/* 751 */ "GetIsPoisoned",
	/* 752 */ "GetSpellTarget",
	/* 753 */ "SetSoloMode",
	/* 754 */ "EffectCutSceneHorrified",
	/* 755 */ "EffectCutSceneParalyze",
	/* 756 */ "EffectCutSceneStunned",
	/* 757 */ "CancelPostDialogCharacterSwitch",
	/* 758 */ "SetMaxHitPoints",
	/* 759 */ "NoClicksFor",
	/* 760 */ "HoldFadeInForDialog",
	/* 761 */ "ShipBuild",
	/* 762 */ "SurrenderRetainBuffs",
	/* 763 */ "SuppressStatusSummaryEntry",
	/* 764 */ "GetCheatCode",
	/* 765 */ "SetMusicVolume",
	/* 766 */ "CreateItemOnFloor",
	/* 767 */ "SetAvailableNPCId",
	/* 768 */ "GetScriptParameter",
	/* 769 */ "SetFadeUntilScript",
	/* 770 */ "EffectForceBody",
	/* 771 */ "GetItemComponent",
	/* 772 */ "GetItemComponentPieceValue",
	/* 773 */ "ShowChemicalUpgradeScreen",
	/* 774 */ "GetChemicals",
	/* 775 */ "GetChemicalPieceValue",
	/* 776 */ "GetSpellForcePointCost",
	/* 777 */ "EffectFury",
	/* 778 */ "EffectBlind",
	/* 779 */ "EffectFPRegenModifier",
	/* 780 */ "EffectVPRegenModifier",
	/* 781 */ "EffectCrush",
	/* 782 */ "SWMG_GetSwoopUpgrade",
	/* 783 */ "GetFeatAcquired",
	/* 784 */ "GetSpellAcquired",
	/* 785 */ "ShowSwoopUpgradeScreen",
	/* 786 */ "GrantFeat",
	/* 787 */ "GrantSpell",
	/* 788 */ "SpawnMine",
	/* 789 */ "SWMG_GetTrackPosition",
	/* 790 */ "SWMG_SetFollowerPosition",
	/* 791 */ "SetFakeCombatState",
	/* 792 */ "SWMG_DestroyMiniGameObject",
	/* 793 */ "GetOwnerDemolitionsSkill",
	/* 794 */ "SetOrientOnClick",
	/* 795 */ "GetInfluence",
	/* 796 */ "SetInfluence",
	/* 797 */ "ModifyInfluence",
	/* 798 */ "GetRacialSubType",
	/* 799 */ "IncrementGlobalNumber",
	/* 800 */ "DecrementGlobalNumber",
	/* 801 */ "SetBonusForcePoints",
	/* 802 */ "AddBonusForcePoints",
	/* 803 */ "GetBonusForcePoints",
	/* 804 */ "SWMG_SetJumpSpeed",
	/* 805 */ "IsMoviePlaying",
	/* 806 */ "QueueMovie",
	/* 807 */ "PlayMovieQueue",
	/* 808 */ "YavinHackDoorClose",
	/* 809 */ "EffectDroidConfused",
	/* 810 */ "IsStealthed",
	/* 811 */ "IsMeditating",
	/* 812 */ "IsInTotalDefense",
	/* 813 */ "SetHealTarget",
	/* 814 */ "GetHealTarget",
	/* 815 */ "GetRandomDestination",
	/* 816 */ "IsFormActive",
	/* 817 */ "GetSpellFormMask",
	/* 818 */ "GetSpellBaseForcePointCost",
	/* 819 */ "SetKeepStealthInDialog",
	/* 820 */ "HasLineOfSight",
	/* 821 */ "ShowDemoScreen",
	/* 822 */ "ForceHeartbeat",
	/* 823 */ "EffectForceSight",
	/* 824 */ "IsRunning",
	/* 825 */ "SWMG_PlayerApplyForce",
	/* 826 */ "SetForfeitConditions",
	/* 827 */ "GetLastForfeitViolation",
	/* 828 */ "ModifyReflexSavingThrowBase",
	/* 829 */ "ModifyFortitudeSavingThrowBase",
	/* 830 */ "ModifyWillSavingThrowBase",
	/* 831 */ "GetScriptStringParameter",
	/* 832 */ "GetObjectPersonalSpace",
	/* 833 */ "AdjustCreatureAttributes",
	/* 834 */ "SetCreatureAILevel",
	/* 835 */ "ResetCreatureAILevel",
	/* 836 */ "AddAvailablePUPByTemplate",
	/* 837 */ "AddAvailablePUPByObject",
	/* 838 */ "AssignPUP",
	/* 839 */ "SpawnAvailablePUP",
	/* 840 */ "AddPartyPuppet",
	/* 841 */ "GetPUPOwner",
	/* 842 */ "GetIsPuppet",
	/* 843 */ "ActionFollowOwner",
	/* 844 */ "GetIsPartyLeader",
	/* 845 */ "GetPartyLeader",
	/* 846 */ "RemoveNPCFromPartyToBase",
	/* 847 */ "CreatureFlourishWeapon",
	/* 848 */ "EffectMindTrick",
	/* 849 */ "EffectFactionModifier",
	/* 850 */ "ChangeObjectAppearance",
	/* 851 */ "GetIsXBox",
	/* 852 */ "EffectDroidScramble",
	/* 853 */ "ActionSwitchWeapons",
	/* 854 */ "PlayOverlayAnimation",
	/* 855 */ "UnlockAllSongs",
	/* 856 */ "DisableMap",
	/* 857 */ "DetonateMine",
	/* 858 */ "DisableHealthRegen",
	/* 859 */ "SetCurrentForm",
	/* 860 */ "SetDisableTransit",
	/* 861 */ "SetInputClass",
	/* 862 */ "SetForceAlwaysUpdate",
	/* 863 */ "EnableRain",
	/* 864 */ "DisplayMessageBox",
	/* 865 */ "DisplayDatapad",
	/* 866 */ "RemoveHeartbeat",
	/* 867 */ "RemoveEffectByID",
	/* 868 */ "RemoveEffectByExactMatch",
	/* 869 */ "AdjustCreatureSkills",
	/* 870 */ "GetSkillRankBase",
	/* 871 */ "EnableRendering",
	/* 872 */ "GetCombatActionsPending",
	/* 873 */ "SaveNPCByObject",
	/* 874 */ "SavePUPByObject",
	/* 875 */ "GetIsPlayerMadeCharacter",
	/* 876 */ "RebuildPartyTable"
};

static const VariableType kFunctionSignatures[][GameInfo::kMaxSignatureSize] = {
	/*   0 */ { kTypeInt, kTypeInt },
	/*   1 */ { kTypeVoid, kTypeString },
	/*   2 */ { kTypeVoid, kTypeFloat, kTypeInt, kTypeInt },
	/*   3 */ { kTypeString, kTypeFloat, kTypeInt, kTypeInt },
	/*   4 */ { kTypeVoid, kTypeInt },
	/*   5 */ { kTypeVoid, kTypeObject },
	/*   6 */ { kTypeVoid, kTypeObject, kTypeScriptState },
	/*   7 */ { kTypeVoid, kTypeFloat, kTypeScriptState },
	/*   8 */ { kTypeVoid, kTypeString, kTypeObject, kTypeInt },
	/*   9 */ { kTypeVoid },
	/*  10 */ { kTypeVoid, kTypeFloat },
	/*  11 */ { kTypeInt, kTypeInt },
	/*  12 */ { kTypeVoid, kTypeInt, kTypeInt, kTypeInt, kTypeInt },
	/*  13 */ { kTypeInt, kTypeInt },
	/*  14 */ { kTypeVoid, kTypeInt },
	/*  15 */ { kTypeInt },
	/*  16 */ { kTypeInt },
	/*  17 */ { kTypeInt },
	/*  18 */ { kTypeInt },
	/*  19 */ { kTypeInt },
	/*  20 */ { kTypeVoid },
	/*  21 */ { kTypeVoid, kTypeEngineType2, kTypeInt },
	/*  22 */ { kTypeVoid, kTypeObject, kTypeInt, kTypeFloat },
	/*  23 */ { kTypeVoid, kTypeObject, kTypeInt, kTypeFloat },
	/*  24 */ { kTypeObject, kTypeObject },
	/*  25 */ { kTypeObject },
	/*  26 */ { kTypeObject },
	/*  27 */ { kTypeVector, kTypeObject },
	/*  28 */ { kTypeFloat, kTypeObject },
	/*  29 */ { kTypeObject, kTypeObject },
	/*  30 */ { kTypeObject, kTypeObject, kTypeString },
	/*  31 */ { kTypeObject, kTypeString, kTypeObject, kTypeInt, kTypeInt },
	/*  32 */ { kTypeVoid, kTypeObject, kTypeInt, kTypeInt },
	/*  33 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*  34 */ { kTypeVoid, kTypeObject },
	/*  35 */ { kTypeVoid, kTypeObject },
	/*  36 */ { kTypeObject, kTypeObject },
	/*  37 */ { kTypeVoid, kTypeObject, kTypeInt },
	/*  38 */ { kTypeObject, kTypeInt, kTypeInt, kTypeObject, kTypeInt, kTypeInt, kTypeInt, kTypeInt, kTypeInt },
	/*  39 */ { kTypeVoid, kTypeString, kTypeInt },
	/*  40 */ { kTypeVoid, kTypeInt, kTypeFloat, kTypeFloat },
	/*  41 */ { kTypeFloat, kTypeObject },
	/*  42 */ { kTypeInt, kTypeObject },
	/*  43 */ { kTypeVoid, kTypeObject },
	/*  44 */ { kTypeVoid, kTypeObject },
	/*  45 */ { kTypeVoid, kTypeFloat },
	/*  46 */ { kTypeVoid, kTypeString },
	/*  47 */ { kTypeObject },
	/*  48 */ { kTypeVoid, kTypeInt, kTypeObject, kTypeInt, kTypeInt, kTypeInt, kTypeInt, kTypeInt },
	/*  49 */ { kTypeInt, kTypeObject },
	/*  50 */ { kTypeInt, kTypeObject },
	/*  51 */ { kTypeEngineType0 },
	/*  52 */ { kTypeObject },
	/*  53 */ { kTypeInt },
	/*  54 */ { kTypeVoid, kTypeObject },
	/*  55 */ { kTypeInt, kTypeObject },
	/*  56 */ { kTypeInt, kTypeObject },
	/*  57 */ { kTypeVoid, kTypeInt },
	/*  58 */ { kTypeVoid, kTypeInt },
	/*  59 */ { kTypeInt, kTypeString },
	/*  60 */ { kTypeString, kTypeString },
	/*  61 */ { kTypeString, kTypeString },
	/*  62 */ { kTypeString, kTypeString, kTypeInt },
	/*  63 */ { kTypeString, kTypeString, kTypeInt },
	/*  64 */ { kTypeString, kTypeString, kTypeString, kTypeInt },
	/*  65 */ { kTypeString, kTypeString, kTypeInt, kTypeInt },
	/*  66 */ { kTypeInt, kTypeString, kTypeString },
	/*  67 */ { kTypeFloat, kTypeFloat },
	/*  68 */ { kTypeFloat, kTypeFloat },
	/*  69 */ { kTypeFloat, kTypeFloat },
	/*  70 */ { kTypeFloat, kTypeFloat },
	/*  71 */ { kTypeFloat, kTypeFloat },
	/*  72 */ { kTypeFloat, kTypeFloat },
	/*  73 */ { kTypeFloat, kTypeFloat },
	/*  74 */ { kTypeFloat, kTypeFloat },
	/*  75 */ { kTypeFloat, kTypeFloat, kTypeFloat },
	/*  76 */ { kTypeFloat, kTypeFloat },
	/*  77 */ { kTypeInt, kTypeInt },
	/*  78 */ { kTypeEngineType0, kTypeInt },
	/*  79 */ { kTypeEngineType0, kTypeInt, kTypeInt, kTypeInt },
	/*  80 */ { kTypeEngineType0, kTypeInt, kTypeInt },
	/*  81 */ { kTypeEngineType0, kTypeInt, kTypeInt, kTypeInt },
	/*  82 */ { kTypeEngineType0, kTypeInt },
	/*  83 */ { kTypeInt, kTypeObject },
	/*  84 */ { kTypeInt, kTypeObject },
	/*  85 */ { kTypeEngineType0, kTypeObject },
	/*  86 */ { kTypeEngineType0, kTypeObject },
	/*  87 */ { kTypeVoid, kTypeObject, kTypeEngineType0 },
	/*  88 */ { kTypeInt, kTypeEngineType0 },
	/*  89 */ { kTypeInt, kTypeEngineType0 },
	/*  90 */ { kTypeInt, kTypeEngineType0 },
	/*  91 */ { kTypeObject, kTypeEngineType0 },
	/*  92 */ { kTypeString, kTypeInt },
	/*  93 */ { kTypeObject, kTypeObject, kTypeInt },
	/*  94 */ { kTypeObject, kTypeObject, kTypeInt },
	/*  95 */ { kTypeInt, kTypeInt },
	/*  96 */ { kTypeInt, kTypeInt },
	/*  97 */ { kTypeInt, kTypeInt },
	/*  98 */ { kTypeInt, kTypeInt },
	/*  99 */ { kTypeInt, kTypeInt },
	/* 100 */ { kTypeInt, kTypeInt },
	/* 101 */ { kTypeInt, kTypeInt },
	/* 102 */ { kTypeInt, kTypeInt },
	/* 103 */ { kTypeInt, kTypeInt },
	/* 104 */ { kTypeFloat, kTypeVector },
	/* 105 */ { kTypeInt },
	/* 106 */ { kTypeInt, kTypeObject },
	/* 107 */ { kTypeInt, kTypeObject },
	/* 108 */ { kTypeInt, kTypeObject, kTypeInt, kTypeInt, kTypeObject },
	/* 109 */ { kTypeInt, kTypeObject, kTypeInt, kTypeInt, kTypeObject },
	/* 110 */ { kTypeInt, kTypeObject, kTypeInt, kTypeInt, kTypeObject },
	/* 111 */ { kTypeInt },
	/* 112 */ { kTypeEngineType0, kTypeEngineType0 },
	/* 113 */ { kTypeEngineType0, kTypeEngineType0 },
	/* 114 */ { kTypeEngineType0, kTypeEngineType0 },
	/* 115 */ { kTypeEngineType0, kTypeInt, kTypeInt, kTypeInt },
	/* 116 */ { kTypeInt, kTypeObject, kTypeInt },
	/* 117 */ { kTypeEngineType0, kTypeInt, kTypeInt, kTypeInt },
	/* 118 */ { kTypeEngineType0, kTypeInt, kTypeInt },
	/* 119 */ { kTypeEngineType0, kTypeInt, kTypeInt, kTypeInt },
	/* 120 */ { kTypeEngineType0, kTypeInt, kTypeInt },
	/* 121 */ { kTypeFloat, kTypeInt },
	/* 122 */ { kTypeFloat, kTypeInt },
	/* 123 */ { kTypeFloat, kTypeInt },
	/* 124 */ { kTypeVoid, kTypeObject, kTypeFloat },
	/* 125 */ { kTypeInt, kTypeObject },
	/* 126 */ { kTypeInt },
	/* 127 */ { kTypeInt, kTypeObject },
	/* 128 */ { kTypeObject, kTypeInt, kTypeFloat, kTypeEngineType2, kTypeInt, kTypeInt, kTypeVector },
	/* 129 */ { kTypeObject, kTypeInt, kTypeFloat, kTypeEngineType2, kTypeInt, kTypeInt, kTypeVector },
	/* 130 */ { kTypeEngineType0 },
	/* 131 */ { kTypeVoid, kTypeObject, kTypeEngineType1 },
	/* 132 */ { kTypeEngineType1, kTypeInt },
	/* 133 */ { kTypeEngineType0, kTypeInt, kTypeInt, kTypeInt },
	/* 134 */ { kTypeEngineType0 },
	/* 135 */ { kTypeVoid, kTypeObject, kTypeObject },
	/* 136 */ { kTypeVoid, kTypeObject, kTypeObject },
	/* 137 */ { kTypeVector, kTypeVector },
	/* 138 */ { kTypeInt, kTypeObject },
	/* 139 */ { kTypeInt, kTypeObject, kTypeInt },
	/* 140 */ { kTypeInt, kTypeObject },
	/* 141 */ { kTypeVoid, kTypeVector, kTypeInt },
	/* 142 */ { kTypeVector, kTypeFloat, kTypeFloat, kTypeFloat },
	/* 143 */ { kTypeVoid, kTypeVector },
	/* 144 */ { kTypeVector, kTypeFloat },
	/* 145 */ { kTypeFloat, kTypeVector },
	/* 146 */ { kTypeInt, kTypeObject, kTypeInt },
	/* 147 */ { kTypeInt, kTypeObject, kTypeInt },
	/* 148 */ { kTypeEngineType0 },
	/* 149 */ { kTypeEngineType0, kTypeInt },
	/* 150 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 151 */ { kTypeFloat, kTypeObject, kTypeObject },
	/* 152 */ { kTypeVoid, kTypeInt, kTypeInt, kTypeInt },
	/* 153 */ { kTypeEngineType0, kTypeObject, kTypeInt },
	/* 154 */ { kTypeEngineType0 },
	/* 155 */ { kTypeObject, kTypeInt, kTypeObject },
	/* 156 */ { kTypeEngineType0, kTypeInt },
	/* 157 */ { kTypeEngineType0 },
	/* 158 */ { kTypeEngineType0 },
	/* 159 */ { kTypeEngineType0 },
	/* 160 */ { kTypeVoid, kTypeString, kTypeString },
	/* 161 */ { kTypeEngineType0 },
	/* 162 */ { kTypeVoid, kTypeInt, kTypeObject },
	/* 163 */ { kTypeInt, kTypeObject },
	/* 164 */ { kTypeEngineType0, kTypeInt, kTypeFloat },
	/* 165 */ { kTypeEngineType0, kTypeInt },
	/* 166 */ { kTypeInt, kTypeObject },
	/* 167 */ { kTypeVoid, kTypeObject, kTypeFloat },
	/* 168 */ { kTypeString, kTypeObject },
	/* 169 */ { kTypeInt, kTypeObject, kTypeObject },
	/* 170 */ { kTypeInt, kTypeEngineType0 },
	/* 171 */ { kTypeEngineType0, kTypeInt, kTypeString, kTypeString, kTypeString },
	/* 172 */ { kTypeInt, kTypeObject, kTypeObject },
	/* 173 */ { kTypeVoid, kTypeObject, kTypeObject },
	/* 174 */ { kTypeInt, kTypeObject },
	/* 175 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 176 */ { kTypeVoid, kTypeObject, kTypeString, kTypeInt },
	/* 177 */ { kTypeInt, kTypeString, kTypeString },
	/* 178 */ { kTypeString, kTypeInt },
	/* 179 */ { kTypeInt },
	/* 180 */ { kTypeEngineType0, kTypeInt, kTypeInt },
	/* 181 */ { kTypeObject, kTypeObject, kTypeInt },
	/* 182 */ { kTypeObject, kTypeObject, kTypeInt },
	/* 183 */ { kTypeObject, kTypeObject, kTypeInt },
	/* 184 */ { kTypeObject, kTypeObject, kTypeInt },
	/* 185 */ { kTypeInt, kTypeObject },
	/* 186 */ { kTypeInt, kTypeObject, kTypeObject },
	/* 187 */ { kTypeInt, kTypeObject },
	/* 188 */ { kTypeFloat, kTypeObject },
	/* 189 */ { kTypeInt, kTypeObject },
	/* 190 */ { kTypeInt, kTypeObject },
	/* 191 */ { kTypeInt, kTypeObject },
	/* 192 */ { kTypeObject, kTypeObject, kTypeInt },
	/* 193 */ { kTypeObject, kTypeObject, kTypeInt },
	/* 194 */ { kTypeString, kTypeString },
	/* 195 */ { kTypeInt },
	/* 196 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 197 */ { kTypeObject, kTypeString },
	/* 198 */ { kTypeObject, kTypeObject },
	/* 199 */ { kTypeEngineType0, kTypeEngineType0, kTypeEngineType0 },
	/* 200 */ { kTypeObject, kTypeString, kTypeInt },
	/* 201 */ { kTypeVoid, kTypeObject, kTypeInt, kTypeInt, kTypeInt },
	/* 202 */ { kTypeVoid, kTypeFloat },
	/* 203 */ { kTypeVoid, kTypeInt, kTypeString },
	/* 204 */ { kTypeVoid, kTypeObject, kTypeString, kTypeInt, kTypeInt, kTypeInt, kTypeString, kTypeString, kTypeString, kTypeString, kTypeString, kTypeString, kTypeInt, kTypeInt, kTypeInt, kTypeInt },
	/* 205 */ { kTypeVoid },
	/* 206 */ { kTypeVoid },
	/* 207 */ { kTypeEngineType0, kTypeInt, kTypeObject, kTypeInt, kTypeInt },
	/* 208 */ { kTypeInt, kTypeObject, kTypeObject },
	/* 209 */ { kTypeVoid, kTypeObject, kTypeObject, kTypeInt },
	/* 210 */ { kTypeString },
	/* 211 */ { kTypeObject, kTypeObject },
	/* 212 */ { kTypeEngineType0, kTypeInt },
	/* 213 */ { kTypeEngineType2, kTypeObject },
	/* 214 */ { kTypeVoid, kTypeEngineType2 },
	/* 215 */ { kTypeEngineType2, kTypeVector, kTypeFloat },
	/* 216 */ { kTypeVoid, kTypeInt, kTypeEngineType0, kTypeEngineType2, kTypeFloat },
	/* 217 */ { kTypeInt, kTypeObject },
	/* 218 */ { kTypeFloat, kTypeFloat },
	/* 219 */ { kTypeFloat, kTypeFloat },
	/* 220 */ { kTypeVoid, kTypeInt, kTypeEngineType0, kTypeObject, kTypeFloat },
	/* 221 */ { kTypeVoid, kTypeString, kTypeInt },
	/* 222 */ { kTypeEngineType2 },
	/* 223 */ { kTypeVector, kTypeEngineType2 },
	/* 224 */ { kTypeEngineType0 },
	/* 225 */ { kTypeFloat, kTypeEngineType2 },
	/* 226 */ { kTypeObject, kTypeInt, kTypeInt, kTypeEngineType2, kTypeInt, kTypeInt, kTypeInt, kTypeInt, kTypeInt },
	/* 227 */ { kTypeObject, kTypeInt, kTypeObject, kTypeInt },
	/* 228 */ { kTypeObject, kTypeInt, kTypeEngineType2, kTypeInt },
	/* 229 */ { kTypeObject, kTypeString, kTypeObject, kTypeInt },
	/* 230 */ { kTypeFloat, kTypeInt },
	/* 231 */ { kTypeInt, kTypeFloat },
	/* 232 */ { kTypeInt, kTypeString },
	/* 233 */ { kTypeFloat, kTypeString },
	/* 234 */ { kTypeVoid, kTypeInt, kTypeEngineType2, kTypeInt, kTypeInt, kTypeInt, kTypeInt },
	/* 235 */ { kTypeInt, kTypeObject, kTypeObject },
	/* 236 */ { kTypeInt, kTypeObject, kTypeObject },
	/* 237 */ { kTypeInt, kTypeObject, kTypeObject },
	/* 238 */ { kTypeObject },
	/* 239 */ { kTypeString, kTypeInt },
	/* 240 */ { kTypeVoid, kTypeInt, kTypeInt },
	/* 241 */ { kTypeVoid, kTypeObject, kTypeFloat, kTypeInt, kTypeFloat, kTypeInt },
	/* 242 */ { kTypeObject },
	/* 243 */ { kTypeObject, kTypeInt, kTypeString, kTypeEngineType2, kTypeInt },
	/* 244 */ { kTypeEngineType1, kTypeObject, kTypeInt, kTypeInt },
	/* 245 */ { kTypeObject },
	/* 246 */ { kTypeInt },
	/* 247 */ { kTypeInt },
	/* 248 */ { kTypeInt },
	/* 249 */ { kTypeString },
	/* 250 */ { kTypeEngineType0, kTypeInt },
	/* 251 */ { kTypeInt },
	/* 252 */ { kTypeEngineType0, kTypeInt },
	/* 253 */ { kTypeString, kTypeObject },
	/* 254 */ { kTypeObject },
	/* 255 */ { kTypeInt, kTypeString, kTypeObject },
	/* 256 */ { kTypeObject },
	/* 257 */ { kTypeInt },
	/* 258 */ { kTypeInt },
	/* 259 */ { kTypeInt },
	/* 260 */ { kTypeObject },
	/* 261 */ { kTypeInt },
	/* 262 */ { kTypeObject, kTypeObject, kTypeInt, kTypeInt },
	/* 263 */ { kTypeObject, kTypeObject, kTypeInt, kTypeInt },
	/* 264 */ { kTypeObject, kTypeObject },
	/* 265 */ { kTypeInt },
	/* 266 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 267 */ { kTypeInt },
	/* 268 */ { kTypeVoid, kTypeInt },
	/* 269 */ { kTypeEngineType0, kTypeEngineType2, kTypeInt },
	/* 270 */ { kTypeEngineType0 },
	/* 271 */ { kTypeVoid, kTypeObject, kTypeObject },
	/* 272 */ { kTypeString, kTypeObject },
	/* 273 */ { kTypeEngineType0, kTypeInt },
	/* 274 */ { kTypeInt, kTypeObject, kTypeInt, kTypeObject },
	/* 275 */ { kTypeEngineType0, kTypeInt, kTypeInt },
	/* 276 */ { kTypeInt, kTypeObject },
	/* 277 */ { kTypeVoid, kTypeInt, kTypeObject },
	/* 278 */ { kTypeInt, kTypeObject },
	/* 279 */ { kTypeVoid, kTypeInt, kTypeObject },
	/* 280 */ { kTypeInt, kTypeObject },
	/* 281 */ { kTypeVoid, kTypeInt, kTypeObject },
	/* 282 */ { kTypeObject },
	/* 283 */ { kTypeObject },
	/* 284 */ { kTypeVoid, kTypeInt, kTypeString },
	/* 285 */ { kTypeInt, kTypeInt, kTypeObject },
	/* 286 */ { kTypeInt, kTypeInt, kTypeObject },
	/* 287 */ { kTypeVoid, kTypeInt, kTypeObject },
	/* 288 */ { kTypeVoid, kTypeInt, kTypeObject, kTypeInt, kTypeObject },
	/* 289 */ { kTypeInt, kTypeObject, kTypeObject },
	/* 290 */ { kTypeInt, kTypeObject, kTypeObject },
	/* 291 */ { kTypeObject },
	/* 292 */ { kTypeObject },
	/* 293 */ { kTypeObject },
	/* 294 */ { kTypeVoid, kTypeScriptState },
	/* 295 */ { kTypeEngineType1 },
	/* 296 */ { kTypeVoid, kTypeInt, kTypeObject },
	/* 297 */ { kTypeInt, kTypeObject },
	/* 298 */ { kTypeFloat, kTypeEngineType2, kTypeEngineType2 },
	/* 299 */ { kTypeInt, kTypeInt, kTypeObject, kTypeInt, kTypeInt, kTypeObject },
	/* 300 */ { kTypeVoid, kTypeInt, kTypeFloat, kTypeFloat },
	/* 301 */ { kTypeEngineType3, kTypeInt },
	/* 302 */ { kTypeEngineType3, kTypeInt },
	/* 303 */ { kTypeEngineType3, kTypeInt },
	/* 304 */ { kTypeInt, kTypeInt, kTypeObject },
	/* 305 */ { kTypeInt, kTypeEngineType0 },
	/* 306 */ { kTypeInt, kTypeEngineType3, kTypeObject },
	/* 307 */ { kTypeEngineType3, kTypeInt, kTypeObject, kTypeInt },
	/* 308 */ { kTypeEngineType3, kTypeInt, kTypeInt, kTypeObject, kTypeInt, kTypeInt, kTypeInt },
	/* 309 */ { kTypeVoid, kTypeEngineType3, kTypeObject },
	/* 310 */ { kTypeVoid, kTypeEngineType3, kTypeEngineType2 },
	/* 311 */ { kTypeInt, kTypeObject },
	/* 312 */ { kTypeInt, kTypeObject },
	/* 313 */ { kTypeVoid, kTypeEngineType2 },
	/* 314 */ { kTypeEngineType0, kTypeInt },
	/* 315 */ { kTypeInt, kTypeInt, kTypeObject },
	/* 316 */ { kTypeObject, kTypeObject },
	/* 317 */ { kTypeInt, kTypeObject },
	/* 318 */ { kTypeInt, kTypeObject },
	/* 319 */ { kTypeFloat, kTypeObject, kTypeObject },
	/* 320 */ { kTypeInt, kTypeObject, kTypeInt },
	/* 321 */ { kTypeInt, kTypeObject },
	/* 322 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 323 */ { kTypeVoid, kTypeInt, kTypeInt, kTypeInt },
	/* 324 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 325 */ { kTypeInt, kTypeObject },
	/* 326 */ { kTypeObject },
	/* 327 */ { kTypeVoid, kTypeObject },
	/* 328 */ { kTypeObject, kTypeObject },
	/* 329 */ { kTypeVoid, kTypeObject },
	/* 330 */ { kTypeObject },
	/* 331 */ { kTypeInt, kTypeInt, kTypeObject },
	/* 332 */ { kTypeInt, kTypeObject },
	/* 333 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 334 */ { kTypeFloat, kTypeEngineType2, kTypeEngineType2 },
	/* 335 */ { kTypeFloat, kTypeObject },
	/* 336 */ { kTypeObject },
	/* 337 */ { kTypeInt, kTypeObject, kTypeInt },
	/* 338 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 339 */ { kTypeObject, kTypeObject },
	/* 340 */ { kTypeObject, kTypeObject },
	/* 341 */ { kTypeInt, kTypeInt, kTypeObject },
	/* 342 */ { kTypeInt, kTypeInt, kTypeObject },
	/* 343 */ { kTypeInt, kTypeInt, kTypeObject },
	/* 344 */ { kTypeInt, kTypeInt },
	/* 345 */ { kTypeInt },
	/* 346 */ { kTypeObject },
	/* 347 */ { kTypeObject },
	/* 348 */ { kTypeObject },
	/* 349 */ { kTypeObject },
	/* 350 */ { kTypeObject },
	/* 351 */ { kTypeEngineType0, kTypeInt, kTypeInt },
	/* 352 */ { kTypeInt },
	/* 353 */ { kTypeObject },
	/* 354 */ { kTypeVoid, kTypeObject, kTypeObject, kTypeInt, kTypeInt, kTypeString },
	/* 355 */ { kTypeEngineType0, kTypeEngineType0, kTypeInt, kTypeInt },
	/* 356 */ { kTypeEngineType0, kTypeEngineType0, kTypeInt },
	/* 357 */ { kTypeEngineType0, kTypeEngineType0 },
	/* 358 */ { kTypeInt, kTypeObject },
	/* 359 */ { kTypeInt, kTypeEngineType3 },
	/* 360 */ { kTypeVoid, kTypeEngineType2, kTypeInt, kTypeFloat },
	/* 361 */ { kTypeObject },
	/* 362 */ { kTypeInt, kTypeEngineType3 },
	/* 363 */ { kTypeInt, kTypeEngineType3 },
	/* 364 */ { kTypeVoid, kTypeInt, kTypeString, kTypeInt, kTypeInt, kTypeObject },
	/* 365 */ { kTypeInt },
	/* 366 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 367 */ { kTypeVoid, kTypeString, kTypeInt, kTypeInt },
	/* 368 */ { kTypeVoid, kTypeString },
	/* 369 */ { kTypeInt, kTypeString },
	/* 370 */ { kTypeInt, kTypeInt },
	/* 371 */ { kTypeInt, kTypeInt },
	/* 372 */ { kTypeEngineType0, kTypeInt },
	/* 373 */ { kTypeEngineType0, kTypeInt },
	/* 374 */ { kTypeVoid, kTypeObject, kTypeString },
	/* 375 */ { kTypeObject },
	/* 376 */ { kTypeObject },
	/* 377 */ { kTypeInt, kTypeInt, kTypeObject },
	/* 378 */ { kTypeVoid, kTypeObject, kTypeObject, kTypeInt, kTypeInt },
	/* 379 */ { kTypeVoid },
	/* 380 */ { kTypeObject, kTypeObject, kTypeInt },
	/* 381 */ { kTypeObject, kTypeObject, kTypeInt },
	/* 382 */ { kTypeVoid, kTypeEngineType2, kTypeInt, kTypeFloat },
	/* 383 */ { kTypeVoid, kTypeObject, kTypeInt, kTypeFloat, kTypeFloat },
	/* 384 */ { kTypeInt, kTypeString },
	/* 385 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 386 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 387 */ { kTypeEngineType0, kTypeFloat },
	/* 388 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 389 */ { kTypeVoid, kTypeInt, kTypeObject },
	/* 390 */ { kTypeInt, kTypeObject, kTypeEngineType0 },
	/* 391 */ { kTypeEngineType0 },
	/* 392 */ { kTypeEngineType0 },
	/* 393 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 394 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 395 */ { kTypeInt, kTypeObject },
	/* 396 */ { kTypeString, kTypeInt },
	/* 397 */ { kTypeInt, kTypeObject },
	/* 398 */ { kTypeInt, kTypeObject, kTypeInt },
	/* 399 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 400 */ { kTypeVoid, kTypeObject },
	/* 401 */ { kTypeInt, kTypeObject },
	/* 402 */ { kTypeEngineType0, kTypeObject },
	/* 403 */ { kTypeVoid, kTypeObject, kTypeObject },
	/* 404 */ { kTypeVoid },
	/* 405 */ { kTypeInt },
	/* 406 */ { kTypeInt },
	/* 407 */ { kTypeInt },
	/* 408 */ { kTypeInt },
	/* 409 */ { kTypeInt, kTypeObject },
	/* 410 */ { kTypeObject },
	/* 411 */ { kTypeEngineType2 },
	/* 412 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 413 */ { kTypeVoid, kTypeObject },
	/* 414 */ { kTypeVoid, kTypeObject },
	/* 415 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 416 */ { kTypeVoid, kTypeObject, kTypeVector },
	/* 417 */ { kTypeVoid, kTypeString, kTypeObject },
	/* 418 */ { kTypeInt, kTypeObject },
	/* 419 */ { kTypeObject },
	/* 420 */ { kTypeEngineType0 },
	/* 421 */ { kTypeVoid, kTypeObject, kTypeInt, kTypeInt, kTypeInt },
	/* 422 */ { kTypeInt, kTypeObject, kTypeInt },
	/* 423 */ { kTypeInt },
	/* 424 */ { kTypeEngineType1, kTypeObject, kTypeEngineType2, kTypeObject },
	/* 425 */ { kTypeVoid, kTypeObject },
	/* 426 */ { kTypeVoid, kTypeObject },
	/* 427 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 428 */ { kTypeVoid, kTypeObject, kTypeInt, kTypeInt },
	/* 429 */ { kTypeVoid, kTypeObject, kTypeInt, kTypeInt },
	/* 430 */ { kTypeVoid, kTypeObject },
	/* 431 */ { kTypeVoid, kTypeObject },
	/* 432 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 433 */ { kTypeVoid, kTypeObject },
	/* 434 */ { kTypeVoid, kTypeObject },
	/* 435 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 436 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 437 */ { kTypeObject },
	/* 438 */ { kTypeObject },
	/* 439 */ { kTypeObject },
	/* 440 */ { kTypeObject },
	/* 441 */ { kTypeEngineType2 },
	/* 442 */ { kTypeObject },
	/* 443 */ { kTypeInt, kTypeObject },
	/* 444 */ { kTypeVoid, kTypeInt, kTypeObject, kTypeInt },
	/* 445 */ { kTypeInt, kTypeObject },
	/* 446 */ { kTypeEngineType0, kTypeInt, kTypeInt },
	/* 447 */ { kTypeEngineType0, kTypeInt, kTypeInt },
	/* 448 */ { kTypeEngineType0, kTypeInt, kTypeInt },
	/* 449 */ { kTypeEngineType0, kTypeInt, kTypeInt },
	/* 450 */ { kTypeEngineType0, kTypeInt, kTypeInt, kTypeInt },
	/* 451 */ { kTypeEngineType0, kTypeInt },
	/* 452 */ { kTypeEngineType0, kTypeInt, kTypeInt, kTypeInt },
	/* 453 */ { kTypeEngineType0, kTypeInt, kTypeInt },
	/* 454 */ { kTypeEngineType0, kTypeInt },
	/* 455 */ { kTypeInt, kTypeObject },
	/* 456 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 457 */ { kTypeEngineType0, kTypeInt },
	/* 458 */ { kTypeEngineType0, kTypeInt },
	/* 459 */ { kTypeEngineType0, kTypeInt },
	/* 460 */ { kTypeEngineType0, kTypeInt },
	/* 461 */ { kTypeVoid, kTypeInt },
	/* 462 */ { kTypeInt },
	/* 463 */ { kTypeEngineType0, kTypeInt },
	/* 464 */ { kTypeInt },
	/* 465 */ { kTypeEngineType0 },
	/* 466 */ { kTypeEngineType0 },
	/* 467 */ { kTypeEngineType0 },
	/* 468 */ { kTypeVoid, kTypeInt },
	/* 469 */ { kTypeEngineType0, kTypeInt },
	/* 470 */ { kTypeEngineType0, kTypeInt },
	/* 471 */ { kTypeEngineType0 },
	/* 472 */ { kTypeEngineType0, kTypeInt, kTypeInt, kTypeInt },
	/* 473 */ { kTypeEngineType0, kTypeInt },
	/* 474 */ { kTypeInt },
	/* 475 */ { kTypeInt, kTypeObject },
	/* 476 */ { kTypeVoid },
	/* 477 */ { kTypeEngineType0, kTypeInt },
	/* 478 */ { kTypeVoid, kTypeInt },
	/* 479 */ { kTypeInt, kTypeObject },
	/* 480 */ { kTypeVoid, kTypeObject },
	/* 481 */ { kTypeInt },
	/* 482 */ { kTypeVoid, kTypeInt },
	/* 483 */ { kTypeVoid, kTypeObject },
	/* 484 */ { kTypeVoid, kTypeObject },
	/* 485 */ { kTypeEngineType0, kTypeInt },
	/* 486 */ { kTypeObject, kTypeObject },
	/* 487 */ { kTypeEngineType0, kTypeInt, kTypeInt, kTypeInt },
	/* 488 */ { kTypeObject, kTypeObject, kTypeInt },
	/* 489 */ { kTypeObject },
	/* 490 */ { kTypeObject, kTypeObject },
	/* 491 */ { kTypeInt, kTypeObject },
	/* 492 */ { kTypeInt, kTypeObject },
	/* 493 */ { kTypeInt, kTypeObject },
	/* 494 */ { kTypeFloat, kTypeObject },
	/* 495 */ { kTypeObject, kTypeObject },
	/* 496 */ { kTypeInt, kTypeObject },
	/* 497 */ { kTypeInt, kTypeObject },
	/* 498 */ { kTypeInt },
	/* 499 */ { kTypeVoid, kTypeInt },
	/* 500 */ { kTypeVoid, kTypeObject, kTypeObject },
	/* 501 */ { kTypeVoid, kTypeInt, kTypeObject, kTypeInt },
	/* 502 */ { kTypeVoid, kTypeInt, kTypeEngineType2, kTypeInt },
	/* 503 */ { kTypeVoid, kTypeObject, kTypeInt, kTypeInt, kTypeInt },
	/* 504 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 505 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 506 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 507 */ { kTypeVoid, kTypeObject, kTypeVector, kTypeInt },
	/* 508 */ { kTypeVoid, kTypeInt },
	/* 509 */ { kTypeVoid, kTypeString, kTypeString, kTypeString, kTypeString, kTypeString, kTypeString, kTypeString, kTypeString },
	/* 510 */ { kTypeVoid },
	/* 511 */ { kTypeInt, kTypeObject },
	/* 512 */ { kTypeVoid },
	/* 513 */ { kTypeInt },
	/* 514 */ { kTypeInt },
	/* 515 */ { kTypeVoid, kTypeVector, kTypeInt },
	/* 516 */ { kTypeVoid, kTypeInt },
	/* 517 */ { kTypeVoid, kTypeInt },
	/* 518 */ { kTypeVoid, kTypeInt },
	/* 519 */ { kTypeInt },
	/* 520 */ { kTypeVoid, kTypeFloat },
	/* 521 */ { kTypeFloat },
	/* 522 */ { kTypeInt, kTypeObject },
	/* 523 */ { kTypeFloat },
	/* 524 */ { kTypeInt, kTypeObject },
	/* 525 */ { kTypeVoid, kTypeInt, kTypeObject, kTypeInt },
	/* 526 */ { kTypeVoid, kTypeString, kTypeObject, kTypeInt },
	/* 527 */ { kTypeInt, kTypeObject },
	/* 528 */ { kTypeInt, kTypeObject },
	/* 529 */ { kTypeInt, kTypeObject, kTypeObject },
	/* 530 */ { kTypeInt, kTypeObject },
	/* 531 */ { kTypeInt, kTypeObject },
	/* 532 */ { kTypeInt, kTypeObject },
	/* 533 */ { kTypeObject, kTypeObject },
	/* 534 */ { kTypeString, kTypeObject },
	/* 535 */ { kTypeInt, kTypeObject },
	/* 536 */ { kTypeInt, kTypeObject },
	/* 537 */ { kTypeInt, kTypeObject },
	/* 538 */ { kTypeInt, kTypeObject },
	/* 539 */ { kTypeInt, kTypeObject },
	/* 540 */ { kTypeInt, kTypeObject },
	/* 541 */ { kTypeInt, kTypeObject },
	/* 542 */ { kTypeObject },
	/* 543 */ { kTypeInt, kTypeInt, kTypeObject },
	/* 544 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 545 */ { kTypeInt, kTypeObject },
	/* 546 */ { kTypeInt, kTypeObject, kTypeInt },
	/* 547 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 548 */ { kTypeObject },
	/* 549 */ { kTypeObject },
	/* 550 */ { kTypeInt, kTypeObject, kTypeObject },
	/* 551 */ { kTypeInt, kTypeObject },
	/* 552 */ { kTypeEngineType0, kTypeEngineType0, kTypeInt },
	/* 553 */ { kTypeVoid, kTypeObject, kTypeObject },
	/* 554 */ { kTypeVoid, kTypeObject, kTypeInt, kTypeInt, kTypeInt, kTypeString },
	/* 555 */ { kTypeVoid, kTypeObject },
	/* 556 */ { kTypeObject, kTypeObject },
	/* 557 */ { kTypeVoid },
	/* 558 */ { kTypeInt, kTypeObject },
	/* 559 */ { kTypeInt, kTypeObject },
	/* 560 */ { kTypeVoid, kTypeString },
	/* 561 */ { kTypeString },
	/* 562 */ { kTypeObject, kTypeObject },
	/* 563 */ { kTypeVoid, kTypeInt, kTypeFloat },
	/* 564 */ { kTypeVoid, kTypeInt },
	/* 565 */ { kTypeInt },
	/* 566 */ { kTypeInt, kTypeObject },
	/* 567 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 568 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 569 */ { kTypeInt, kTypeObject },
	/* 570 */ { kTypeInt, kTypeObject },
	/* 571 */ { kTypeFloat, kTypeInt },
	/* 572 */ { kTypeVoid, kTypeObject, kTypeObject },
	/* 573 */ { kTypeVoid, kTypeObject },
	/* 574 */ { kTypeInt, kTypeInt, kTypeObject },
	/* 575 */ { kTypeInt, kTypeInt },
	/* 576 */ { kTypeInt, kTypeObject },
	/* 577 */ { kTypeObject, kTypeInt },
	/* 578 */ { kTypeInt, kTypeString },
	/* 579 */ { kTypeVoid, kTypeString, kTypeInt },
	/* 580 */ { kTypeInt, kTypeString },
	/* 581 */ { kTypeVoid, kTypeString, kTypeInt },
	/* 582 */ { kTypeVoid, kTypeString, kTypeInt, kTypeInt, kTypeFloat },
	/* 583 */ { kTypeString },
	/* 584 */ { kTypeString },
	/* 585 */ { kTypeObject, kTypeString },
	/* 586 */ { kTypeVoid, kTypeObject, kTypeString, kTypeInt, kTypeInt, kTypeInt },
	/* 587 */ { kTypeInt },
	/* 588 */ { kTypeInt },
	/* 589 */ { kTypeObject },
	/* 590 */ { kTypeInt, kTypeObject, kTypeInt, kTypeInt },
	/* 591 */ { kTypeVoid },
	/* 592 */ { kTypeVoid },
	/* 593 */ { kTypeObject },
	/* 594 */ { kTypeObject },
	/* 595 */ { kTypeInt },
	/* 596 */ { kTypeInt },
	/* 597 */ { kTypeString, kTypeObject },
	/* 598 */ { kTypeVoid },
	/* 599 */ { kTypeInt, kTypeObject },
	/* 600 */ { kTypeInt, kTypeObject },
	/* 601 */ { kTypeInt, kTypeObject },
	/* 602 */ { kTypeInt, kTypeObject },
	/* 603 */ { kTypeInt, kTypeObject },
	/* 604 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 605 */ { kTypeVoid },
	/* 606 */ { kTypeInt },
	/* 607 */ { kTypeVoid, kTypeObject, kTypeString },
	/* 608 */ { kTypeFloat },
	/* 609 */ { kTypeFloat },
	/* 610 */ { kTypeVoid, kTypeFloat, kTypeFloat },
	/* 611 */ { kTypeObject },
	/* 612 */ { kTypeInt },
	/* 613 */ { kTypeObject, kTypeInt },
	/* 614 */ { kTypeInt },
	/* 615 */ { kTypeObject, kTypeInt },
	/* 616 */ { kTypeInt, kTypeObject },
	/* 617 */ { kTypeInt, kTypeObject },
	/* 618 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 619 */ { kTypeFloat, kTypeObject },
	/* 620 */ { kTypeVoid, kTypeObject, kTypeFloat },
	/* 621 */ { kTypeInt, kTypeObject },
	/* 622 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 623 */ { kTypeVector, kTypeObject },
	/* 624 */ { kTypeInt, kTypeObject },
	/* 625 */ { kTypeString, kTypeObject, kTypeInt },
	/* 626 */ { kTypeString, kTypeObject, kTypeInt },
	/* 627 */ { kTypeInt, kTypeObject, kTypeInt },
	/* 628 */ { kTypeFloat, kTypeObject, kTypeInt },
	/* 629 */ { kTypeFloat, kTypeObject, kTypeInt },
	/* 630 */ { kTypeFloat, kTypeObject, kTypeInt },
	/* 631 */ { kTypeInt, kTypeObject, kTypeInt },
	/* 632 */ { kTypeVoid, kTypeObject, kTypeInt, kTypeString },
	/* 633 */ { kTypeVoid, kTypeObject, kTypeInt, kTypeString },
	/* 634 */ { kTypeVoid, kTypeObject, kTypeInt, kTypeInt },
	/* 635 */ { kTypeVoid, kTypeObject, kTypeInt, kTypeFloat },
	/* 636 */ { kTypeVoid, kTypeObject, kTypeInt, kTypeFloat },
	/* 637 */ { kTypeVoid, kTypeObject, kTypeInt, kTypeFloat },
	/* 638 */ { kTypeVoid, kTypeObject, kTypeInt, kTypeInt },
	/* 639 */ { kTypeString },
	/* 640 */ { kTypeInt, kTypeObject, kTypeInt },
	/* 641 */ { kTypeVector },
	/* 642 */ { kTypeFloat },
	/* 643 */ { kTypeFloat },
	/* 644 */ { kTypeFloat },
	/* 645 */ { kTypeFloat },
	/* 646 */ { kTypeVector },
	/* 647 */ { kTypeVoid, kTypeVector },
	/* 648 */ { kTypeVoid, kTypeFloat },
	/* 649 */ { kTypeVoid, kTypeFloat },
	/* 650 */ { kTypeVoid, kTypeFloat },
	/* 651 */ { kTypeVoid, kTypeFloat },
	/* 652 */ { kTypeVoid, kTypeVector },
	/* 653 */ { kTypeVector },
	/* 654 */ { kTypeVoid, kTypeVector },
	/* 655 */ { kTypeVector },
	/* 656 */ { kTypeVoid, kTypeVector },
	/* 657 */ { kTypeFloat, kTypeObject, kTypeInt },
	/* 658 */ { kTypeFloat, kTypeObject, kTypeInt },
	/* 659 */ { kTypeFloat, kTypeObject, kTypeInt },
	/* 660 */ { kTypeFloat, kTypeObject, kTypeInt },
	/* 661 */ { kTypeVoid, kTypeObject, kTypeInt, kTypeFloat },
	/* 662 */ { kTypeVoid, kTypeObject, kTypeInt, kTypeFloat },
	/* 663 */ { kTypeVoid, kTypeObject, kTypeInt, kTypeFloat },
	/* 664 */ { kTypeVoid, kTypeObject, kTypeInt, kTypeFloat },
	/* 665 */ { kTypeInt, kTypeObject },
	/* 666 */ { kTypeVoid, kTypeObject },
	/* 667 */ { kTypeFloat },
	/* 668 */ { kTypeVoid, kTypeFloat },
	/* 669 */ { kTypeVoid, kTypeInt, kTypeString, kTypeString },
	/* 670 */ { kTypeVoid, kTypeInt, kTypeInt },
	/* 671 */ { kTypeVoid, kTypeObject, kTypeInt, kTypeInt, kTypeInt },
	/* 672 */ { kTypeVoid },
	/* 673 */ { kTypeVoid, kTypeInt },
	/* 674 */ { kTypeVoid, kTypeInt },
	/* 675 */ { kTypeEngineType0, kTypeInt },
	/* 676 */ { kTypeEngineType0 },
	/* 677 */ { kTypeVoid, kTypeInt, kTypeEngineType2 },
	/* 678 */ { kTypeVoid, kTypeString, kTypeObject, kTypeInt, kTypeInt, kTypeInt },
	/* 679 */ { kTypeInt, kTypeObject, kTypeInt },
	/* 680 */ { kTypeVoid, kTypeObject, kTypeInt, kTypeInt },
	/* 681 */ { kTypeInt, kTypeObject, kTypeInt },
	/* 682 */ { kTypeVoid, kTypeObject, kTypeInt, kTypeInt },
	/* 683 */ { kTypeInt, kTypeObject, kTypeInt },
	/* 684 */ { kTypeVoid, kTypeObject, kTypeInt, kTypeInt },
	/* 685 */ { kTypeInt, kTypeObject, kTypeInt },
	/* 686 */ { kTypeVoid, kTypeObject, kTypeInt, kTypeInt },
	/* 687 */ { kTypeInt, kTypeObject, kTypeInt },
	/* 688 */ { kTypeVoid, kTypeObject, kTypeInt, kTypeInt },
	/* 689 */ { kTypeFloat, kTypeObject },
	/* 690 */ { kTypeVoid, kTypeObject, kTypeFloat },
	/* 691 */ { kTypeInt, kTypeObject },
	/* 692 */ { kTypeEngineType2, kTypeString },
	/* 693 */ { kTypeVoid, kTypeString, kTypeEngineType2 },
	/* 694 */ { kTypeInt, kTypeInt, kTypeObject },
	/* 695 */ { kTypeInt, kTypeInt },
	/* 696 */ { kTypeInt, kTypeInt },
	/* 697 */ { kTypeInt, kTypeInt, kTypeString },
	/* 698 */ { kTypeObject, kTypeInt, kTypeEngineType2 },
	/* 699 */ { kTypeInt, kTypeInt },
	/* 700 */ { kTypeVoid, kTypeInt },
	/* 701 */ { kTypeInt },
	/* 702 */ { kTypeEngineType0, kTypeObject, kTypeObject, kTypeObject, kTypeInt },
	/* 703 */ { kTypeEngineType0 },
	/* 704 */ { kTypeInt },
	/* 705 */ { kTypeInt, kTypeObject },
	/* 706 */ { kTypeVoid, kTypeInt },
	/* 707 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 708 */ { kTypeVoid, kTypeInt, kTypeInt },
	/* 709 */ { kTypeInt, kTypeInt },
	/* 710 */ { kTypeVoid },
	/* 711 */ { kTypeString },
	/* 712 */ { kTypeVoid, kTypeString, kTypeInt, kTypeInt, kTypeInt },
	/* 713 */ { kTypeInt, kTypeObject },
	/* 714 */ { kTypeVoid, kTypeString, kTypeInt },
	/* 715 */ { kTypeInt, kTypeObject },
	/* 716 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 717 */ { kTypeVector },
	/* 718 */ { kTypeVoid, kTypeVector },
	/* 719 */ { kTypeVoid, kTypeFloat, kTypeFloat, kTypeFloat, kTypeFloat, kTypeFloat },
	/* 720 */ { kTypeVoid, kTypeFloat, kTypeFloat, kTypeFloat, kTypeFloat, kTypeFloat },
	/* 721 */ { kTypeObject, kTypeObject },
	/* 722 */ { kTypeInt, kTypeObject },
	/* 723 */ { kTypeInt, kTypeObject },
	/* 724 */ { kTypeInt, kTypeObject },
	/* 725 */ { kTypeInt, kTypeObject },
	/* 726 */ { kTypeInt, kTypeObject },
	/* 727 */ { kTypeObject, kTypeObject },
	/* 728 */ { kTypeObject, kTypeObject },
	/* 729 */ { kTypeVoid, kTypeObject, kTypeObject, kTypeInt, kTypeInt },
	/* 730 */ { kTypeVoid },
	/* 731 */ { kTypeVoid, kTypeInt, kTypeObject },
	/* 732 */ { kTypeInt, kTypeObject },
	/* 733 */ { kTypeVoid, kTypeString, kTypeInt },
	/* 734 */ { kTypeVoid, kTypeInt },
	/* 735 */ { kTypeInt, kTypeEngineType3 },
	/* 736 */ { kTypeVoid, kTypeInt, kTypeInt },
	/* 737 */ { kTypeVoid, kTypeInt, kTypeInt },
	/* 738 */ { kTypeVoid, kTypeString, kTypeInt },
	/* 739 */ { kTypeVoid, kTypeInt },
	/* 740 */ { kTypeVoid, kTypeInt, kTypeInt },
	/* 741 */ { kTypeInt, kTypeInt },
	/* 742 */ { kTypeVoid, kTypeInt, kTypeInt },
	/* 743 */ { kTypeInt, kTypeInt },
	/* 744 */ { kTypeInt },
	/* 745 */ { kTypeVoid, kTypeObject, kTypeFloat },
	/* 746 */ { kTypeVoid, kTypeObject, kTypeFloat, kTypeFloat, kTypeFloat },
	/* 747 */ { kTypeVoid, kTypeString, kTypeFloat },
	/* 748 */ { kTypeInt, kTypeInt },
	/* 749 */ { kTypeVoid },
	/* 750 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 751 */ { kTypeInt, kTypeObject },
	/* 752 */ { kTypeObject, kTypeObject },
	/* 753 */ { kTypeVoid, kTypeInt },
	/* 754 */ { kTypeEngineType0 },
	/* 755 */ { kTypeEngineType0 },
	/* 756 */ { kTypeEngineType0 },
	/* 757 */ { kTypeVoid },
	/* 758 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 759 */ { kTypeVoid, kTypeFloat },
	/* 760 */ { kTypeVoid },
	/* 761 */ { kTypeInt },
	/* 762 */ { kTypeVoid },
	/* 763 */ { kTypeVoid, kTypeInt },
	/* 764 */ { kTypeInt, kTypeInt },
	/* 765 */ { kTypeVoid, kTypeFloat },
	/* 766 */ { kTypeObject, kTypeString, kTypeEngineType2, kTypeInt },
	/* 767 */ { kTypeVoid, kTypeInt, kTypeObject },
	/* 768 */ { kTypeInt, kTypeInt },
	/* 769 */ { kTypeVoid },
	/* 770 */ { kTypeEngineType0, kTypeInt },
	/* 771 */ { kTypeInt },
	/* 772 */ { kTypeInt },
	/* 773 */ { kTypeVoid, kTypeObject },
	/* 774 */ { kTypeInt },
	/* 775 */ { kTypeInt },
	/* 776 */ { kTypeInt },
	/* 777 */ { kTypeEngineType0 },
	/* 778 */ { kTypeEngineType0 },
	/* 779 */ { kTypeEngineType0, kTypeInt },
	/* 780 */ { kTypeEngineType0, kTypeInt },
	/* 781 */ { kTypeEngineType0 },
	/* 782 */ { kTypeInt, kTypeInt },
	/* 783 */ { kTypeInt, kTypeInt, kTypeObject },
	/* 784 */ { kTypeInt, kTypeInt, kTypeObject },
	/* 785 */ { kTypeVoid },
	/* 786 */ { kTypeVoid, kTypeInt, kTypeObject },
	/* 787 */ { kTypeVoid, kTypeInt, kTypeObject },
	/* 788 */ { kTypeVoid, kTypeInt, kTypeEngineType2, kTypeInt, kTypeInt, kTypeObject },
	/* 789 */ { kTypeVector, kTypeObject },
	/* 790 */ { kTypeVector, kTypeVector },
	/* 791 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 792 */ { kTypeVoid, kTypeObject },
	/* 793 */ { kTypeInt, kTypeObject },
	/* 794 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 795 */ { kTypeInt, kTypeInt },
	/* 796 */ { kTypeVoid, kTypeInt, kTypeInt },
	/* 797 */ { kTypeVoid, kTypeInt, kTypeInt },
	/* 798 */ { kTypeInt, kTypeObject },
	/* 799 */ { kTypeVoid, kTypeString, kTypeInt },
	/* 800 */ { kTypeVoid, kTypeString, kTypeInt },
	/* 801 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 802 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 803 */ { kTypeVoid, kTypeObject },
	/* 804 */ { kTypeVoid, kTypeFloat },
	/* 805 */ { kTypeInt },
	/* 806 */ { kTypeVoid, kTypeString, kTypeInt },
	/* 807 */ { kTypeVoid, kTypeInt },
	/* 808 */ { kTypeVoid, kTypeObject },
	/* 809 */ { kTypeEngineType0 },
	/* 810 */ { kTypeInt, kTypeObject },
	/* 811 */ { kTypeInt, kTypeObject },
	/* 812 */ { kTypeInt, kTypeObject },
	/* 813 */ { kTypeVoid, kTypeObject, kTypeObject },
	/* 814 */ { kTypeObject, kTypeObject },
	/* 815 */ { kTypeVector, kTypeObject, kTypeInt },
	/* 816 */ { kTypeInt, kTypeObject, kTypeInt },
	/* 817 */ { kTypeInt, kTypeInt },
	/* 818 */ { kTypeInt, kTypeInt },
	/* 819 */ { kTypeVoid, kTypeInt },
	/* 820 */ { kTypeInt, kTypeVector, kTypeVector, kTypeObject, kTypeObject },
	/* 821 */ { kTypeInt, kTypeString, kTypeInt, kTypeInt, kTypeInt, kTypeInt },
	/* 822 */ { kTypeVoid, kTypeObject },
	/* 823 */ { kTypeEngineType0 },
	/* 824 */ { kTypeInt, kTypeObject },
	/* 825 */ { kTypeVoid, kTypeVector },
	/* 826 */ { kTypeVoid, kTypeInt },
	/* 827 */ { kTypeInt },
	/* 828 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 829 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 830 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 831 */ { kTypeString },
	/* 832 */ { kTypeFloat, kTypeObject },
	/* 833 */ { kTypeVoid, kTypeObject, kTypeInt, kTypeInt },
	/* 834 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 835 */ { kTypeVoid, kTypeObject },
	/* 836 */ { kTypeInt, kTypeInt, kTypeString },
	/* 837 */ { kTypeInt, kTypeInt, kTypeObject },
	/* 838 */ { kTypeInt, kTypeInt, kTypeInt },
	/* 839 */ { kTypeObject, kTypeInt, kTypeEngineType2 },
	/* 840 */ { kTypeInt, kTypeInt, kTypeObject },
	/* 841 */ { kTypeObject, kTypeObject },
	/* 842 */ { kTypeInt, kTypeObject },
	/* 843 */ { kTypeVoid, kTypeFloat },
	/* 844 */ { kTypeInt, kTypeObject },
	/* 845 */ { kTypeObject },
	/* 846 */ { kTypeInt, kTypeInt },
	/* 847 */ { kTypeVoid, kTypeObject },
	/* 848 */ { kTypeEngineType0 },
	/* 849 */ { kTypeEngineType0, kTypeInt },
	/* 850 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 851 */ { kTypeInt },
	/* 852 */ { kTypeEngineType0 },
	/* 853 */ { kTypeVoid },
	/* 854 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 855 */ { kTypeVoid },
	/* 856 */ { kTypeVoid, kTypeInt },
	/* 857 */ { kTypeVoid, kTypeObject },
	/* 858 */ { kTypeVoid, kTypeInt },
	/* 859 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 860 */ { kTypeVoid, kTypeInt },
	/* 861 */ { kTypeVoid, kTypeInt },
	/* 862 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 863 */ { kTypeVoid, kTypeInt },
	/* 864 */ { kTypeVoid, kTypeInt, kTypeString },
	/* 865 */ { kTypeVoid, kTypeObject },
	/* 866 */ { kTypeVoid, kTypeObject },
	/* 867 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 868 */ { kTypeVoid, kTypeObject, kTypeEngineType0 },
	/* 869 */ { kTypeVoid, kTypeObject, kTypeInt, kTypeInt },
	/* 870 */ { kTypeInt, kTypeInt, kTypeObject },
	/* 871 */ { kTypeVoid, kTypeObject, kTypeInt },
	/* 872 */ { kTypeInt, kTypeObject },
	/* 873 */ { kTypeVoid, kTypeInt, kTypeObject },
	/* 874 */ { kTypeVoid, kTypeInt, kTypeObject },
	/* 875 */ { kTypeInt, kTypeObject },
	/* 876 */ { kTypeVoid }
};

} // End of namespace KotOR2

} // End of namespace NWScript

#endif // NWSCRIPT_GAME_KOTOR2_H
