# -*- Autoconf -*-
#
# Copyright (c) 2006-2007 The ABINIT Group (Yann Pouillon)
# All rights reserved.
#
# This file is part of the ABINIT software package. For license information,
# please see the COPYING file in the top-level directory of the ABINIT source
# distribution.
#

#
# Tricks for compilers and external libraries
#

 ##############################################################################

#
# Compilers
#



# ABI_TRICKS_AR(SYSTEM)
# ---------------------
#
# Applies archiver tricks and workarounds depending on the operating system.
#
AC_DEFUN([ABI_TRICKS_AR],
[dnl Do some sanity checking of the arguments
 m4_if([$1], , [AC_FATAL([$0: missing argument 1])])dnl

 case "$1" in

  aix*)
   ARFLAGS_64BITS="-X 64"
   ;;

 esac
]) # ABI_TRICKS_AR



# ABI_TRICKS_CPP(SYSTEM)
# ----------------------
#
# Applies C preprocessor tricks and workarounds depending on the
# operating system.
#
AC_DEFUN([ABI_TRICKS_CPP],
[dnl Do some sanity checking of the arguments
 m4_if([$1], , [AC_FATAL([$0: missing argument 1])])dnl

 dnl Find the true C preprocessor, needed by the wrapper
 AC_MSG_CHECKING([for the true C preprocessor])
 TRUE_CPP=""
 TRUE_CPPFLAGS=""
 if test -x "/lib/cpp"; then
  TRUE_CPP="/lib/cpp"
 fi
 if test "${TRUE_CPP}" = ""; then
  AC_PATH_PROG(TRUE_CPP,cpp,/usr/bin/cpp)
 fi
 AC_MSG_RESULT([${TRUE_CPP}])

 dnl Add command-line options to preprocessor calls
 AC_MSG_CHECKING([for C preprocessor options])
 case "$1" in

  aix*)
   TRUE_CPPFLAGS="-P"
   ;;

  *)
   TRUE_CPPFLAGS="-P -std=c89"
   ;;

 esac
 AC_MSG_RESULT([${TRUE_CPPFLAGS}])
]) # ABI_TRICKS_CPP



# ABI_TRICKS_CC(COMPILER, VERSION)
# ---------------------------------
#
# Applies tricks and workarounds depending on C compiler type and
# version.
#
AC_DEFUN([ABI_TRICKS_CC],
[dnl Do some sanity checking of the arguments
 m4_if([$1], , [AC_FATAL([$0: missing argument 1])])dnl
 m4_if([$2], , [AC_FATAL([$0: missing argument 2])])dnl

 if test "$1" != "UNKNOWN"; then
  AC_MSG_NOTICE([applying C compiler tricks (type: $1, version: $2)])
 fi

 case "$1" in

  compaq)
   if test "${ac_cv_c_bigendian}" = "yes"; then
    EXTRA_CFLAGS="${EXTRA_CFLAGS} -convert big_endian"
   fi
   ;;

  gnu)
   case "${target}" in
    mips*)
     CFLAGS_64BITS="-mabi=64"
     ;;
    *)
     CFLAGS_64BITS="-m64"
     ;;
   esac
   ;;

  ibm)
   CFLAGS_64BITS="-q64"
   ;;

  intel)
   EXTRA_CC_LDFLAGS="${EXTRA_CC_LDFLAGS} -static-libcxa -i-static"
   case "$2" in 
    9.0|9.1)
     EXTRA_CFLAGS="${EXTRA_CFLAGS} -vec-report0"
     ;;
   esac
   ;;

  pathscale)
    CFLAGS_64BITS="-m64"
   ;;

  sun)
   EXTRA_FCFLAGS='-M$(builddir)/../defs -M$(srcdir)/../defs'
   ;;

 esac
]) # ABI_TRICKS_CC



# ABI_TRICKS_CXX(COMPILER, VERSION)
# ----------------------------------
#
# Applies tricks and workarounds depending on C++ compiler type and
# version.
#
AC_DEFUN([ABI_TRICKS_CXX],
[dnl Do some sanity checking of the arguments
 m4_if([$1], , [AC_FATAL([$0: missing argument 1])])dnl
 m4_if([$2], , [AC_FATAL([$0: missing argument 2])])dnl

 if test "$1" != "UNKNOWN"; then
  AC_MSG_NOTICE([applying C++ compiler tricks (type: $1, version: $2)])
 fi

 case "$1" in

  compaq)
   if test "${ac_cv_c_bigendian}" = "yes"; then
    EXTRA_CXXFLAGS="${EXTRA_CXXFLAGS} -convert big_endian"
   fi
   ;;

  gnu)
   case "${target}" in
    mips*)
     CXXFLAGS_64BITS="-mabi=64"
     ;;
    *)
     CXXFLAGS_64BITS="-m64"
     ;;
   esac
   ;;

  ibm)
   CXXFLAGS_64BITS="-q64"
   ;;

  intel)
   EXTRA_CXX_LDFLAGS="${EXTRA_CXX_LDFLAGS} -static-libcxa -i-static"
   case "$2" in 
    9.0|9.1)
     EXTRA_CXXFLAGS="${EXTRA_CXXFLAGS} -vec-report0"
     ;;
   esac
   ;;

  pathscale)
   CXXFLAGS_64BITS="-m64"
   ;;

 esac
]) # ABI_TRICKS_CXX



# ABI_TRICKS_FC(COMPILER, VERSION)
# ---------------------------------
#
# Applies tricks and workarounds depending on Fortran compiler type and
# version.
#
AC_DEFUN([ABI_TRICKS_FC],
[dnl Do some sanity checking of the arguments
 m4_if([$1], , [AC_FATAL([$0: missing argument 1])])dnl
 m4_if([$2], , [AC_FATAL([$0: missing argument 2])])dnl

 if test "$1" != "UNKNOWN"; then
  AC_MSG_NOTICE([applying Fortran compiler tricks (type: $1, version: $2)])
 fi

 case "$1" in

  absoft)
   fc_wrap="yes"
   ;;

  compaq)
   if test "${ac_cv_c_bigendian}" = "yes"; then
    EXTRA_FCFLAGS="${EXTRA_FCFLAGS} -convert big_endian"
   fi
   ;;

  fujitsu)
   FCFLAGS_FREEFORM="-Free"
   FCFLAGS_FIXEDFORM="-Fixed"
   EXTRA_FCFLAGS="${EXTRA_FCFLAGS} -Am -Ee -Ep"
   fc_wrap="yes"
   ;;

  g95|gnu)
   FCFLAGS_64BITS="-m64"
   EXTRA_FCFLAGS="${EXTRA_FCFLAGS} -fno-second-underscore"
   FCFLAGS_NETCDF="${FCFLAGS_NETCDF} -fsecond-underscore"
   ;;

  hitachi)
   EXTRA_FCFLAGS="-hf95 -nosave -nohugeary"
   ;;

  ibm)
   FCFLAGS_64BITS="-q64"
   FCFLAGS_FREEFORM="-qsuffix=cpp=F90:f=f90 -qfree=f90"
   FCFLAGS_FIXEDFORM="-qsuffix=cpp=F:f=f -qfixed"
   fc_wrap="yes"
   ;;

  intel)
   case "$2" in
    7.*)
     EXTRA_FCFLAGS="${EXTRA_FCFLAGS} -132"
     EXTRA_FC_LDFLAGS="${EXTRA_FC_LDFLAGS} -Vaxlib"
     ;;
    8.0)
     AC_MSG_WARN([IFORT 8.0 is severely buggy and not able to produce reliable ABINIT binaries])
     AC_MSG_ERROR([Please use another version of IFORT, or another compiler],80)
     ;;
    8.1)
     EXTRA_FCFLAGS="${EXTRA_FCFLAGS} -extend_source"
     EXTRA_FC_LDFLAGS="${EXTRA_FC_LDFLAGS} -Vaxlib -static-libcxa"
     ;;
    9.0|9.1)
     EXTRA_FCFLAGS="${EXTRA_FCFLAGS} -extend_source -vec-report0"
     EXTRA_FC_LDFLAGS="${EXTRA_FC_LDFLAGS} -static-libcxa"
     ;;
   esac
   ;;

  mipspro)
   FCFLAGS_64BITS="-64"
   if test "${abi_cpu_type}" != ""; then
    EXTRA_FCFLAGS="${EXTRA_FCFLAGS} -${abi_cpu_type}"
   fi
   fc_wrap="yes"
   ;;

  pathscale)
   FCFLAGS_64BITS="-m64"
   EXTRA_FCFLAGS="${EXTRA_FCFLAGS} -extend-source -fno-second-underscore"
   FCFLAGS_NETCDF="${FCFLAGS_NETCDF} -fsecond-underscore"
   ;;

  pgi)
   EXTRA_FCFLAGS="${EXTRA_FCFLAGS} -Mextend"
   case "$2" in
    6.0)
     EXTRA_FCFLAGS="${EXTRA_FCFLAGS} -Msave"
     ;;
   esac
   ;;

  sun)
   fc_wrap="yes"
   ;;

 esac
]) # ABI_TRICKS_FC



 ##############################################################################

#
# External libraries
#



# ABI_TRICKS_BIGDFT()
# -------------------
#
# Applies tricks and workarounds to have the BigDFT library correctly
# linked to the binaries.
#
AC_DEFUN([ABI_TRICKS_BIGDFT],
[
 AC_MSG_NOTICE([applying BigDFT tricks (not implemented yet)])
]) # ABI_TRICKS_BIGDFT



# ABI_TRICKS_FFTW()
# -----------------
#
# Applies tricks and workarounds to have the FFTW library correctly
# linked to the binaries.
#
AC_DEFUN([ABI_TRICKS_FFTW],
[
 AC_MSG_NOTICE([applying FFTW tricks (not implemented yet)])
]) # ABI_TRICKS_FFTW



# ABI_TRICKS_ETSF_IO()
# --------------------
#
# Applies tricks and workarounds to have the ETSF I/O library correctly
# linked to the binaries.
#
AC_DEFUN([ABI_TRICKS_ETSF_IO],
[
 AC_MSG_NOTICE([applying ETSF I/O tricks (not implemented yet)])
]) # ABI_TRICKS_ETSF_IO



# ABI_TRICKS_ETSF_XC()
# --------------------
#
# Applies tricks and workarounds to have the ETSF_XC library correctly
# linked to the binaries.
#
AC_DEFUN([ABI_TRICKS_ETSF_XC],
[
 AC_MSG_NOTICE([applying ETSF_XC tricks (not implemented yet)])
]) # ABI_TRICKS_ETSF_XC



# ABI_TRICKS_LINALG(TYPE)
# -----------------------
#
# Applies tricks and workarounds to have the optimized linear algebra
# libraries correctly linked to the binaries.
#
AC_DEFUN([ABI_TRICKS_LINALG],
[dnl Do some sanity checking of the arguments
 m4_if([$1], , [AC_FATAL([$0: missing argument 1])])dnl

 if test "$1" != ""; then
  AC_MSG_NOTICE([applying linear algebra tricks (type: $1)])
 fi

 case "$1" in

  atlas)
   EXTRA_FC_LDFLAGS="${EXTRA_FC_LDFLAGS} -llapack -lf77blas -lcblas -latlas"
   linalg_tricks_bypass="yes"
   ;;

  essl)
   EXTRA_FCFLAGS="${EXTRA_FCFLAGS} -qessl"
   EXTRA_FC_LDFLAGS="${EXTRA_FC_LDFLAGS} -lessl"
   linalg_tricks_bypass="yes"
   ;;

 esac

 AC_SUBST(linalg_tricks_bypass)
]) # ABI_TRICKS_LINALG



# ABI_TRICKS_NETCDF(COMPILER, VERSION)
# ------------------------------------
#
# Applies tricks and workarounds to have the optimized linear algebra
# libraries correctly linked to the binaries.
#
AC_DEFUN([ABI_TRICKS_NETCDF],
[dnl Do some sanity checking of the arguments
 m4_if([$1], , [AC_FATAL([$0: missing argument 1])])dnl
 m4_if([$2], , [AC_FATAL([$0: missing argument 2])])dnl

 if test "$1" != "UNKNOWN"; then
  AC_MSG_NOTICE([applying compiler-specific NetCDF tricks (type: $1, version: $2)])
 fi

 case "$1" in

  g95|gnu)
   CPPFLAGS_NETCDF="${CPPFLAGS_NETCDF} -Df2cFortran"
   ;;

  ibm)
   CPPFLAGS_NETCDF="${CPPFLAGS_NETCDF} -DIBMR2Fortran"
   ;;

  intel)
   CPPFLAGS_NETCDF="${CPPFLAGS_NETCDF} -DpgiFortran"
   FCFLAGS_NETCDF="${FCFLAGS_NETCDF} -mp"
   ;;

  pathscale)
   CPPFLAGS_NETCDF="${CPPFLAGS_NETCDF} -Df2cFortran"
   ;;

 esac
]) # ABI_TRICKS_NETCDF



# ABI_TRICKS_XMLF90()
# -----------------
#
# Applies tricks and workarounds to have the XMLF90 library correctly
# linked to the binaries.
#
AC_DEFUN([ABI_TRICKS_XMLF90],
[
 AC_MSG_NOTICE([applying XMLF90 tricks (not implemented yet)])
]) # ABI_TRICKS_XMLF90
