#!/bin/sh

cpp_options=`grep -rh '^#' src/*/*.F90 | sed -e 's/#[ ]*//;s/#//' | grep '^if' | sed -e 's/if[^ ]* //;s/[!()&|]//g;s/defined / /g;' | perl -e 'while ( <> ){ s/[\s]+/ /g; s/ /\n/g; print $_; }' | sort -u`

echo "Preprocessing options used in ABINIT"
echo "------------------------------------"
echo ""
echo "${cpp_options}"
echo ""

for opt in ${cpp_options}; do
   opt_files=`grep -lr "${opt}" src/*/*.F90`
   opt_count=`echo "${opt_files}" | wc -l`
   opt_uline=`echo "${opt}" | sed -e 's/./-/g'`

   echo "${opt}"
   echo "${opt_uline}"
   echo ""
   echo "Used ${opt_count} times"
   echo ""
   if test "${opt}" != "HAVE_CONFIG_H" -a "${opt}" != "HAVE_FORTRAN_INTERFACES"; then
      echo "${opt_files}"
      echo ""
   fi
done
