/*
    ACfax - Fax reception with X11-interface for amateur radio
    Copyright (C) 1995-1998 Andreas Czechanowski, DL4SDC

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software Foundation,
    Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

    andreas.czechanowski@ins.uni-stuttgart.de
*/
    
/*
 * x_image.h - header file for the XImage and colormap handler x_image.c
 */

#include <X11/X.h>
#include <X11/Xlib.h>
#include <X11/Intrinsic.h>

/* some constants for the transportation-images */
#define DEFHEIGHT       16
#define DEFWIDTH        16

/* these are made global : */
extern XImage    *horimag;	/* intermediate-storage for horizontal scan */
extern XImage    *verimag;	/* intermediate-storage for vertical scan */
extern Colormap  icmap;		/* the colormap to use */
extern unsigned	long coltab[256];	/* mapping table grayscale->pixel-value */

void	create_images(Widget toplevel, Dimension wid, Dimension hei);
void	destroy_images(void);
void	alloc_cmap(Widget toplevel, Pixel *respix, unsigned nrespix);
void	fill_cmap_col(int invert, int flip, int rotate);
void	fill_cmap_gray(int invert);
