/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.params.shadow.com.univocity.parsers.common;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.junit.jupiter.params.shadow.com.univocity.parsers.common.ArgumentUtils;
import org.junit.jupiter.params.shadow.com.univocity.parsers.common.Context;
import org.junit.jupiter.params.shadow.com.univocity.parsers.common.ParserOutput;
import org.junit.jupiter.params.shadow.com.univocity.parsers.common.fields.FieldSelector;

public class ColumnMap {
    private Map<String, Integer> columnMap;
    private Map<String, Integer> normalizedColumnMap;
    private int[] enumMap;
    private int[] extractedIndexes = null;
    private final Context context;
    private final ParserOutput output;

    public ColumnMap(Context context, ParserOutput output) {
        this.context = context;
        this.output = output;
    }

    public int indexOf(String header) {
        Integer index;
        if (this.columnMap != null && this.columnMap.isEmpty()) {
            return -1;
        }
        this.validateHeader(header);
        if (this.columnMap == null) {
            int i;
            String[] headers = this.context.headers();
            if (headers == null) {
                this.columnMap = Collections.emptyMap();
                this.normalizedColumnMap = Collections.emptyMap();
                return -1;
            }
            this.columnMap = new HashMap<String, Integer>(headers.length);
            this.extractedIndexes = this.context.extractedFieldIndexes();
            if (this.extractedIndexes != null) {
                if (this.context.columnsReordered()) {
                    for (i = 0; i < this.extractedIndexes.length; ++i) {
                        int originalIndex = this.extractedIndexes[i];
                        String h = headers[originalIndex];
                        this.columnMap.put(h, i);
                    }
                } else {
                    for (i = 0; i < this.extractedIndexes.length; ++i) {
                        this.columnMap.put(headers[i], i);
                    }
                }
            } else {
                for (i = 0; i < headers.length; ++i) {
                    this.columnMap.put(headers[i], i);
                }
            }
            this.normalizedColumnMap = new HashMap<String, Integer>(headers.length);
            for (Map.Entry<String, Integer> e : this.columnMap.entrySet()) {
                if (e.getKey() == null) continue;
                this.normalizedColumnMap.put(e.getKey().trim().toLowerCase(), e.getValue());
            }
        }
        if ((index = this.columnMap.get(header)) == null && (index = this.normalizedColumnMap.get(header.trim().toLowerCase())) == null) {
            return -1;
        }
        return index;
    }

    private void validateHeader(Object header) {
        if (header == null) {
            if (this.context.headers() == null) {
                throw new IllegalArgumentException("Header name cannot be null.");
            }
            throw new IllegalArgumentException("Header name cannot be null. Use one of the available column names: " + Arrays.asList(this.context.headers()));
        }
    }

    public int indexOf(Enum<?> header) {
        if (this.enumMap != null && this.enumMap.length == 0) {
            return -1;
        }
        this.validateHeader(header);
        if (this.enumMap == null) {
            FieldSelector selector;
            String[] headers = this.context.headers();
            if (headers == null) {
                this.enumMap = new int[0];
                return -1;
            }
            Enum[] constants = (Enum[])header.getClass().getEnumConstants();
            int lastOrdinal = Integer.MIN_VALUE;
            for (int i = 0; i < constants.length; ++i) {
                if (lastOrdinal >= constants[i].ordinal()) continue;
                lastOrdinal = constants[i].ordinal();
            }
            this.enumMap = new int[lastOrdinal + 1];
            FieldSelector fieldSelector = selector = this.output == null ? null : this.output.getFieldSelector();
            if (!this.context.columnsReordered()) {
                selector = null;
            }
            for (int i = 0; i < constants.length; ++i) {
                int index;
                Enum constant = constants[i];
                String name = constant.toString();
                this.enumMap[constant.ordinal()] = index = ArgumentUtils.indexOf(headers, name, selector);
            }
        }
        return this.enumMap[header.ordinal()];
    }

    void reset() {
        this.columnMap = null;
        this.normalizedColumnMap = null;
        this.enumMap = null;
        this.extractedIndexes = null;
    }
}

