#!/bin/bash

MSG='Update vcs fields.'

for path in $(arriero list -f path "$@"); do
    echo $path;
    (
        cd $path
        change=0
        if grep -q '^Vcs-Browser:\s*http:\/\/git\.debian\.org' debian/control;
        then
            sed -i 's/^Vcs-Browser:\s*http:\/\/git\.debian\.org/Vcs-Browser: http:\/\/anonscm.debian.org\/gitweb/' debian/control
            change=1
        fi
        if grep -q '^Vcs-Git:\s*git:\/\/git\.debian\.org' debian/control;
        then
            sed -i 's/^Vcs-Git:\s*git:\/\/git\.debian\.org/Vcs-Git: git:\/\/anonscm.debian.org/' debian/control
            change=1
        fi
        if [ $change -gt 0 ]; then
            dch "$MSG";
            git commit -a -m "$MSG"
        fi
    )
done
