/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cobertura.coveragedata;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import net.sourceforge.cobertura.CoverageIgnore;
import net.sourceforge.cobertura.coveragedata.ProjectData;
import net.sourceforge.cobertura.util.ConfigurationUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@CoverageIgnore
public abstract class CoverageDataFileHandler {
    private static final Logger logger = LoggerFactory.getLogger(CoverageDataFileHandler.class);
    private static File defaultFile = null;

    public static File getDefaultDataFile() {
        if (defaultFile != null) {
            return defaultFile;
        }
        ConfigurationUtil config = new ConfigurationUtil();
        defaultFile = new File(config.getDatafile());
        return defaultFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProjectData loadCoverageData(File dataFile) {
        InputStream is = null;
        try {
            is = new BufferedInputStream(new FileInputStream(dataFile), 16384);
            ProjectData projectData = CoverageDataFileHandler.loadCoverageData(is);
            return projectData;
        }
        catch (IOException e) {
            logger.error("Cobertura: Error reading file " + dataFile.getAbsolutePath() + ": " + e.getLocalizedMessage(), (Throwable)e);
            ProjectData projectData = null;
            return projectData;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    logger.error("Cobertura: Error closing file " + dataFile.getAbsolutePath() + ": " + e.getLocalizedMessage(), (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ProjectData loadCoverageData(InputStream dataFile) throws IOException {
        ObjectInputStream objects = null;
        try {
            objects = new ObjectInputStream(dataFile);
            ProjectData projectData = (ProjectData)objects.readObject();
            logger.info("Cobertura: Loaded information on " + projectData.getNumberOfClasses() + " classes.");
            ProjectData projectData2 = projectData;
            return projectData2;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error("Cobertura: Error reading from object stream.", (Throwable)e);
            ProjectData projectData = null;
            return projectData;
        }
        finally {
            if (objects != null) {
                try {
                    objects.close();
                }
                catch (IOException e) {
                    logger.error("Cobertura: Error closing object stream.");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveCoverageData(ProjectData projectData, File dataFile) {
        FileOutputStream os = null;
        try {
            File dataDir = dataFile.getParentFile();
            if (dataDir != null && !dataDir.exists()) {
                dataDir.mkdirs();
            }
            os = new FileOutputStream(dataFile);
            CoverageDataFileHandler.saveCoverageData(projectData, os);
        }
        catch (IOException e) {
            logger.error("Cobertura: Error writing file " + dataFile.getAbsolutePath(), (Throwable)e);
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException e) {
                    logger.error("Cobertura: Error closing file " + dataFile.getAbsolutePath(), (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveCoverageData(ProjectData projectData, OutputStream dataFile) {
        ObjectOutputStream objects = null;
        try {
            objects = new ObjectOutputStream(dataFile);
            objects.writeObject(projectData);
            logger.info("Cobertura: Saved information on " + projectData.getNumberOfClasses() + " classes.");
        }
        catch (IOException e) {
            logger.error("Cobertura: Error writing to object stream.", (Throwable)e);
        }
        finally {
            if (objects != null) {
                try {
                    objects.close();
                }
                catch (IOException e) {
                    logger.error("Cobertura: Error closing object stream.", (Throwable)e);
                }
            }
        }
    }
}

