// This file is part of the AspectC++ compiler 'ac++'.
// Copyright (C) 1999-2003  The 'ac++' developers (see aspectc.org)
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __OrderPlannerImpl_h__
#define __OrderPlannerImpl_h__

#include <set>
#include <map>
#include <vector>
#include <list>

using namespace std;

class OrderPlannerImpl {

  struct Links;

  typedef map<void*,Links> NodeMap;
  typedef NodeMap::value_type Node;

  struct Links {
    set<Node*> _in;
    set<Node*> _out;
  };

  NodeMap _node_map;
  vector<void*> _total_order;

protected:

  // consider an order relation of two nodes
  void consider (void *first, void *later);

  // calculate the total order => false if there is a cycle
  bool plan ();

  // get the result
  int items () const { return _total_order.size (); }
  void *item (int i) const { return _total_order[i]; }
};

#endif // __OrderPlannerImpl_h__
