// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#include "Puma/Pipe.h"
#include <iostream>
using namespace std;

namespace Puma {


Pipe::Pipe (int buffer_size) {
  size   = buffer_size;
  buffer = new char[size];
  wpos   = buffer;
  rpos   = buffer;
  empty  = true;
}


Pipe::~Pipe () {
  delete[] buffer;
}


int Pipe::read (char *dest, int n) {
  int p;

  for (p = 0; p < n; p++) {
    if (! empty) {
      dest[p] = *rpos++;
      if (rpos == buffer + size) 
        rpos = buffer;
      if (rpos == wpos)
        empty = true;
    } else
      break;
  }
  return p;
}


int Pipe::write (const char *dest, int n) {
  int p;

  for (p = 0; p < n; p++) {
    if (rpos != wpos || empty) {
      *wpos++ = dest[p];
      if (wpos == buffer + size) 
        wpos = buffer;
      empty = false;
    } else
      break;
  }
  return p;
}


int Pipe::free () {
  if (wpos > rpos)
    return size - (wpos - buffer) + (rpos - buffer);
  else if (wpos == rpos)
    return empty ? size : 0;
  else
    return (rpos - buffer) - (wpos - buffer);
}

      
void Pipe::dump () {
  int p;

  cout << "DUMP: rpos=" << (rpos - buffer) << " wpos=" 
       << (wpos - buffer) << " buffer=\"";
  for (p = 0; p < size; p++)
    cout << buffer[p];
  cout << "\"" << endl;
}


} // namespace Puma
