//
// BAGEL - Parallel electron correlation program.
// Filename: _r2root_10.cc
// Copyright (C) 2013 Toru Shiozaki
//
// Author: Toru Shiozaki <shiozaki@northwestern.edu>
// Maintainer: Shiozaki group
//
// This file is part of the BAGEL package.
//
// The BAGEL package is free software; you can redistribute it and/or modify
// it under the terms of the GNU Library General Public License as published by
// the Free Software Foundation; either version 3, or (at your option)
// any later version.
//
// The BAGEL package is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public License
// along with the BAGEL package; see COPYING.  If not, write to
// the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
//

#include <algorithm>
#include <iostream>
#include <cassert>
#include <src/integral/rys/r2rootlist.h>

using namespace std;
using namespace bagel;

void R2RootList::r2root10(const double* ta, double* rr, double* ww, const int n) {

  constexpr double ax[10] = {7.294573323927575e-01,1.377939962252648e-01,1.808349800647653e+00,3.401446674552232e+00,5.552517323382231e+00,
    8.330184527452614e+00,1.184383102419147e+01,1.627931994088821e+01,2.199666973638226e+01,2.992081117328652e+01};
  constexpr double aw[10] = {2.005607296769464e-01,1.542211462307546e-01,1.090345597185418e-01,3.104384645250268e-02,4.750776604522325e-03,
    3.765056297965012e-04,1.412967060645209e-05,2.124665088519353e-07,9.197859153802983e-10,4.955932475689653e-13};
  constexpr double x[5270] = {  1.231314330331845e-02,  3.058325179565262e-04,  5.660252004981631e-06,  9.232534545476095e-08,  1.396154020217023e-09,
  1.999062003070671e-11,  2.735352880239360e-13,  3.589097183447625e-15,  4.511607528874182e-17,  5.406090800582931e-19,  6.105871311867447e-21,  6.353202708379518e-23,
  1.088191615587825e-01,  2.565276251364583e-03,  4.265768742639376e-05,  5.743993883979386e-07,  6.210376619072652e-09,  4.612127497153146e-11, -4.143189875396804e-15,
 -8.000283749734498e-15, -1.780791045459392e-16, -2.532118004869565e-18, -2.344829418936979e-20, -3.615060698655242e-23,  2.915106381238800e-01,  6.179445795196289e-03,
  8.098939752699492e-05,  6.209201914064485e-07, -1.118093587576052e-09, -1.188127676580027e-10, -1.830545569852180e-12, -8.884066686935939e-15,  2.209086977020969e-16,
  5.975308011696280e-18,  6.119059608453966e-20, -2.340569076461488e-22,  5.412778744159015e-01,  9.735408921294340e-03,  8.139413595396784e-05, -1.847035831784038e-07,
 -1.355608541764135e-08, -1.107204641199876e-10,  1.437227853545800e-12,  3.959735848786159e-14,  1.328011154129228e-16, -7.728755522304268e-18, -1.239581012788558e-19,
  4.430295222805676e-22,  8.328555661296342e-01,  1.189930643496499e-02,  3.474667410088742e-05, -1.070386838709949e-06, -8.767231797959724e-09,  1.601865796460345e-10,
  2.348855837364165e-12, -2.596798343380267e-14, -6.416114351303136e-16,  3.749865578606143e-18,  1.750501970574359e-19, -2.606888181922777e-22,  1.137922771571856e+00,
  1.191942253497914e-02, -3.172676702836178e-05, -1.070001187061990e-06,  8.276312240124549e-09,  1.587587312005102e-10, -2.243759365787163e-12, -2.527505632635411e-14,
  6.117100701168550e-16,  3.511076727116573e-18, -1.653182430244726e-19, -1.936727949987824e-22,  1.428098739058818e+00,  9.854757955588251e-03, -7.756003323924273e-05,
 -2.277974483205532e-07,  1.296869064213416e-08, -9.483554668411025e-11, -1.430492259380838e-12,  3.508013441251292e-14, -8.598638597989043e-17, -6.932621833980812e-18,
  1.007014300804626e-19,  4.825260799158602e-22,  1.677482520078298e+00,  6.489439818112340e-03, -7.963125268239130e-05,  5.390980241888475e-07,  2.099585487143277e-09,
 -1.155817831329764e-10,  1.522369275862932e-12, -4.025528813968653e-15, -2.310892729159806e-16,  4.866728982815960e-18, -3.699112716245876e-20, -4.033593847110054e-22,
  1.864608254073335e+00,  3.014853619304115e-03, -4.681549704996463e-05,  5.759107350724016e-07, -5.402406901081372e-09,  2.754228747109471e-11,  2.563109160836455e-13,
 -9.751857622950548e-15,  1.618594376336442e-16, -1.729767739442892e-18,  7.676109404139024e-21,  1.606201850724373e-22,  1.973859797084803e+00,  6.146167484016271e-04,
 -1.070219027011983e-05,  1.627859634689467e-07, -2.268601868843150e-09,  2.945402711125062e-11, -3.572622923519531e-13,  4.016298216787366e-15, -4.088123847397890e-17,
  3.547577162892895e-19, -2.118150289550595e-21, -4.740774246135752e-24,  1.363463345900552e-02,  3.559587900152931e-04,  6.916637121929758e-06,  1.182563502557046e-07,
  1.870681003016102e-09,  2.794435624811865e-11,  3.975380503026796e-13,  5.397325182257027e-15,  6.972743467215167e-17,  8.496130719109652e-19,  9.579500729316899e-21,
  9.574948719722640e-23,  1.198089205623983e-01,  2.935867783973348e-03,  5.017686030862164e-05,  6.810505254170973e-07,  7.109954140636419e-09,  4.259910680802243e-11,
 -3.229226086897612e-13, -1.533717553492147e-14, -2.858241734121766e-16, -3.422646863027317e-18, -1.847181603102280e-20,  3.263199248165248e-22,  3.175707541837067e-01,
  6.856664567167401e-03,  8.824676357057504e-05,  5.815661200541272e-07, -3.948798202629457e-09, -1.647172798899738e-10, -1.944831838524763e-12,  2.060608230052944e-15,
  4.747263769291562e-16,  7.890873271768244e-18,  2.512897752846390e-20, -1.530169637575282e-21,  5.815023690306634e-01,  1.037385475696451e-02,  7.781034706214884e-05,
 -4.170600894684591e-07, -1.533448216444063e-08, -6.273182121271909e-11,  2.557182590419374e-12,  3.850991318022703e-14, -2.248441284543761e-16, -1.172582220721929e-17,
 -6.106499540635478e-20,  2.456038545699430e-21,  8.809243670291925e-01,  1.212377856567589e-02,  2.117525095912374e-05, -1.182256680121562e-06, -5.069959293656968e-09,
  2.056855659829151e-10,  1.363912742910955e-12, -4.305063850734865e-14, -3.894047506209885e-16,  9.861292837393581e-18,  1.149289091395116e-19, -2.372627765206343e-21,
  1.185014984400341e+00,  1.161672077369877e-02, -4.367751146921306e-05, -9.153044306929106e-07,  1.086742245603709e-08,  9.869944117695517e-11, -2.667433871521568e-12,
 -4.935605224667936e-15,  6.223295466594498e-16, -2.700954385028143e-18, -1.327192730756332e-19,  1.514828832534039e-21,  1.466264274387393e+00,  9.226716252743900e-03,
 -7.911634902376252e-05, -3.701175373400192e-08,  1.080574104624368e-08, -1.178935930574688e-10, -5.186245059020236e-13,  2.913061435556841e-14, -2.614827538738439e-16,
 -2.858258804296507e-18,  9.506696331504048e-20, -6.056845867163869e-22,  1.702207741322736e+00,  5.878674557830030e-03, -7.303050626479378e-05,  5.561320871102016e-07,
  1.405176223507933e-10, -8.108207732007434e-11,  1.330286698878371e-12, -8.925699711228920e-15, -8.505129637766668e-17,  3.217427344971398e-18, -4.170400348434987e-20,
  1.162548777658348e-22,  1.875960372705456e+00,  2.666547518618191e-03, -4.040416860330685e-05,  4.941301984834217e-07, -4.809374471871653e-09,  3.094726025997284e-11,
  4.689439227995877e-14, -5.499336098650103e-15,  1.062666483401860e-16, -1.339541010316913e-18,  1.068509346201570e-20,  1.098539753252623e-24,  1.976158585056553e+00,
  5.362378157059591e-04, -8.948515518155075e-06,  1.307708288124168e-07, -1.756871369032865e-09,  2.209259361106649e-11, -2.613181782936885e-13,  2.895988320478208e-15,
 -2.963978969207541e-17,  2.706036534627568e-19, -2.002674254104985e-21,  7.426137648900933e-24,  1.517890121468055e-02,  4.175231352648148e-04,  8.535573337708419e-06,
  1.532330412340641e-07,  2.538651708939744e-09,  3.958202653006232e-11,  5.850772835901527e-13,  8.200814907062554e-15,  1.083234347110712e-16,  1.327720921078385e-18,
  1.458369152952318e-20,  1.306721433671575e-22,  1.324097924681560e-01,  3.371968208410351e-03,  5.905832661345314e-05,  8.010384520013131e-07,  7.843809821241291e-09,
  2.854409462860731e-11, -8.997319533432879e-13, -2.655743256016797e-14, -4.169873216245648e-16, -3.657242180408084e-18,  1.334458111528316e-20,  1.238124127131197e-21,
  3.464516927892192e-01,  7.589213164140631e-03,  9.472967937386026e-05,  4.895484241667021e-07, -7.695231323512830e-09, -2.087186717168836e-10, -1.631281091936082e-12,
  2.182876265032753e-14,  7.559945329023189e-16,  7.033117299570819e-18, -8.108191925019961e-20, -3.301305481198496e-21,  6.242050723071064e-01,  1.097207572508080e-02,
  7.130386959596100e-05, -6.687674575623804e-07, -1.589395406291245e-08,  1.036580100196704e-11,  3.469295108102599e-12,  2.433331927646191e-14, -6.600473572262750e-16,
 -1.149284015067785e-17,  8.287884837252838e-20,  3.819590307027352e-21,  9.296669110994031e-01,  1.223537529870601e-02,  6.641797244317275e-06, -1.229118502137726e-06,
 -7.323351224395572e-10,  2.229005930247393e-10,  4.243157145875143e-14, -4.917264164683174e-14,  1.965969436984731e-17,  1.200888705500204e-17, -1.307801043798795e-20,
 -3.121097849256130e-21,  1.230717806497306e+00,  1.122644935896222e-02, -5.356405179906028e-05, -7.291200778205853e-07,  1.220115994457464e-08,  3.515007066854297e-11,
 -2.547913774330064e-12,  1.254487136692037e-14,  4.479029212783743e-16, -6.443531293246605e-18, -5.112564404539805e-20,  1.969589176465801e-21,  1.501906374124216e+00,
  8.594765770157293e-03, -7.860242473325295e-05,  1.166001827059235e-07,  8.384268348296494e-09, -1.215685282583179e-10,  1.693023193581801e-13,  1.978916619124048e-14,
 -3.037262199626135e-16,  2.712962469877392e-19,  5.924310288998846e-20, -9.088104088235027e-22,  1.724596122623606e+00,  5.321050654204638e-03, -6.639156929481606e-05,
  5.470526849532506e-07, -1.183274752474474e-09, -5.236592980053420e-11,  1.057461815160541e-12, -1.010160980822430e-14,  2.632334640538954e-18,  1.718793283120540e-18,
 -3.207656817589256e-20,  2.773300438319067e-22,  1.886015865410608e+00,  2.365771472850184e-03, -3.491581049085920e-05,  4.221469366209154e-07, -4.189839607262291e-09,
  3.056757633969959e-11, -6.614720963131861e-14, -2.789128565091458e-15,  6.555222910515317e-17, -9.315452856032175e-19,  9.347622818298926e-21, -5.025918067761961e-23,
  1.978169665658261e+00,  4.704803186148443e-04, -7.534376990531852e-06,  1.058806945293494e-07, -1.371685427004390e-09,  1.669529779315598e-11, -1.921507772469893e-13,
  2.088634337681676e-15, -2.125068639229237e-17,  1.980978336118639e-19, -1.607251273135425e-21,  9.633584262200837e-24,  1.699826955795030e-02,  4.939189609839591e-04,
  1.064690750285747e-05,  2.010332598354460e-07,  3.491537579873996e-09,  5.681952952114431e-11,  8.712844810512240e-13,  1.255616066984468e-14,  1.680635205007688e-16,
  2.031485080177639e-18,  2.063160471465626e-20,  1.326045077926191e-22,  1.469065354057044e-01,  3.885052577153263e-03,  6.943807301735119e-05,  9.296517616425450e-07,
  8.130238136258359e-09, -3.595467242977562e-12, -1.848467748235441e-12, -4.177246133041275e-14, -5.219484802109050e-16, -1.586187191311335e-18,  1.028685011675888e-19,
  2.973430857750159e-21,  3.783580368527256e-01,  8.368125989019681e-03,  9.972156559051368e-05,  3.311622541368559e-07, -1.219658939038792e-08, -2.375972276438774e-10,
 -6.495626754259519e-13,  4.913624028120443e-14,  9.120773946245968e-16,  4.999582900296970e-19, -2.517083635149007e-19, -4.098738709221133e-21,  6.691773664891283e-01,
  1.150612879580785e-02,  6.177485572676505e-05, -9.167041271448946e-07, -1.481266691968125e-08,  9.906687005250739e-11,  3.799190972710445e-12, -2.441042488567645e-15,
 -9.740853359775875e-16, -4.909232517579054e-18,  2.387422335966729e-19,  2.777444683204205e-21,  9.786214311658313e-01,  1.222964966041351e-02, -8.031900335279888e-06,
 -1.205578254240813e-06,  3.626365226668856e-09,  2.078574173593850e-10, -1.262827391333434e-12, -4.198488801343174e-14,  4.113158211037534e-16,  8.968697563175357e-18,
 -1.300080058971208e-19, -1.914185636734701e-21,  1.274715895325500e+00,  1.076629043991364e-02, -6.112935446540678e-05, -5.314542719368384e-07,  1.232853650425105e-08,
 -2.038952863247275e-11, -2.032732194928215e-12,  2.293450081897887e-14,  1.989298532797337e-16, -6.886284526617418e-18,  2.429063147764117e-20,  1.338579785442892e-21,
  1.535039638811424e+00,  7.973641208133743e-03, -7.647738513775877e-05,  2.316871765356096e-07,  6.032827805506002e-09, -1.119309235616008e-10,  5.916124890664957e-13,
  1.060688276701480e-14, -2.606744899195119e-16,  1.875707062688555e-18,  2.243527275203827e-20, -7.145754348848783e-22,  1.744859087523539e+00,  4.815783666138660e-03,
 -5.997088716590095e-05,  5.210253242964466e-07, -1.999451470442663e-09, -3.032255008613730e-11,  7.834725617779895e-13, -9.250822474395300e-15,  4.438788424214571e-17,
  6.816761712389438e-19, -1.994101436098156e-20,  2.571952562121857e-22,  1.894950833012781e+00,  2.105614192015957e-03, -3.023243976055037e-05,  3.598913988282000e-07,
 -3.599586571233120e-09,  2.825141397450583e-11, -1.194287764259413e-13, -1.160437271449928e-15,  3.817897822400732e-17, -6.052555775027345e-19,  6.937152240035583e-21,
 -5.478204291342523e-23,  1.979938588627207e+00,  4.149383199257737e-04, -6.385232028294499e-06,  8.637299224105159e-08, -1.079529355001938e-09,  1.271478409122375e-11,
 -1.422009201623667e-13,  1.511128661387611e-15, -1.517579344195640e-17,  1.420875468586915e-19, -1.201166269913449e-21,  8.590374987979160e-24,  1.916103914493028e-02,
  5.897879039537099e-04,  1.343603036012374e-05,  2.672565324119357e-07,  4.868962933087321e-09,  8.263047526558505e-11,  1.310339418387960e-12,  1.927370300709965e-14,
  2.572400363011871e-16,  2.946287294630876e-18,  2.398948966355992e-20, -2.652389033696564e-23,  1.636315009228264e-01,  4.487368631708334e-03,  8.136304694691502e-05,
  1.056317923419067e-06,  7.510104424843924e-09, -6.389892077617670e-11, -3.253178088057170e-12, -5.829925250769266e-14, -4.674789213386923e-16,  5.803879228776514e-18,
  2.829999075623885e-19,  5.185422511039751e-21,  4.134460907388610e-01,  9.178112740575509e-03,  1.023665020671496e-04,  9.768081466329946e-08, -1.697615271416937e-08,
 -2.334401162822745e-10,  1.121768487766822e-12,  7.633611437241433e-14,  7.089937146957167e-16, -1.271622546678170e-17, -3.895913972862917e-19, -1.394284995307970e-21,
  7.161151604082359e-01,  1.195247918858645e-02,  4.943360286708102e-05, -1.132989966040745e-06, -1.194370028951475e-08,  1.858125489776731e-10,  3.282155884326006e-12,
 -3.440944283907199e-14, -9.575769536656505e-16,  6.164945416164795e-18,  2.887753772152590e-19, -7.731054896683825e-22,  1.027321688772384e+00,  1.210881645389543e-02,
 -2.201987673347895e-05, -1.116315447862503e-06,  7.394024046885745e-09,  1.651889972228619e-10, -2.213527077060521e-12, -2.478860848610794e-14,  6.258947395459262e-16,
  2.705787256073187e-18, -1.672052062154711e-19,  2.465451378623688e-22,  1.316767269865728e+00,  1.025505207427778e-02, -6.634468807788905e-05, -3.398822643732833e-07,
  1.148768392477480e-08, -6.096959492314863e-11, -1.336792018955363e-12,  2.561975982659218e-14, -1.984113113943199e-17, -5.016845866072818e-18,  6.229414215714393e-20,
  4.034403161671266e-22,  1.565730272849892e+00,  7.374419353185034e-03, -7.318912606091429e-05,  3.111598039105586e-07,  3.955663981134907e-09, -9.504374011527940e-11,
  7.828815720070073e-13,  3.463245484818429e-15, -1.836799992254403e-16,  2.243064537328554e-18, -1.557104019060732e-21, -3.728639624733680e-22,  1.763201465205398e+00,
  4.360442056233744e-03, -5.392746725869023e-05,  4.851192014028630e-07, -2.437942520987999e-09, -1.444928053390788e-11,  5.470493920293185e-13, -7.570762303289130e-15,
  5.711546401331753e-17,  9.006448222173395e-20, -1.016679471790716e-20,  1.858217456918381e-22,  1.902915595535179e+00,  1.880092258276502e-03, -2.624118655202548e-05,
  3.066537012620315e-07, -3.065218410974904e-09,  2.511493928831980e-11, -1.377371689254886e-13, -2.383299952707703e-16,  2.083003942163039e-17, -3.729136901745220e-19,
  4.775215229744116e-21, -4.185219977896842e-23,  1.981502352048002e+00,  3.677269247010072e-04, -5.444562782042096e-06,  7.096291410023324e-08, -8.561993528443246e-10,
  9.759238236109591e-12, -1.059810602454045e-13,  1.098784638996350e-15, -1.083853678231344e-17,  1.011487068486087e-19, -8.563159237595709e-22,  7.163415837342955e-24,
  2.175752919704195e-02,  7.115665013059049e-04,  1.717114467940453e-05,  3.602910374603507e-07,  6.885013394420856e-09,  1.215892018819734e-10,  1.982462669761348e-12,
  2.937769588567979e-14,  3.790732413482861e-16,  3.737690095644718e-18,  1.057968732289132e-20, -7.277670989726916e-22,  1.829657819781281e-01,  5.190891460950738e-03,
  9.470233476550974e-05,  1.161431531965316e-06,  5.311545202112391e-09, -1.629714002679819e-10, -5.045279360584257e-12, -6.725777253353411e-14,  4.021996701521049e-18,
  2.205984066652638e-17,  5.324860661234628e-19,  5.457423393165231e-21,  4.517968593872717e-01,  9.996774370505900e-03,  1.017617117697253e-04, -2.090589011199973e-07,
 -2.119154130568659e-08, -1.788366146338918e-10,  3.486361362413302e-12,  8.867737194689920e-14, -2.763848058445225e-17, -2.766032517651857e-17, -3.041694886077496e-19,
  5.871956031761124e-21,  7.646257263150108e-01,  1.229062418030159e-02,  3.482659040326905e-05, -1.290465718620721e-06, -7.534516364703067e-09,  2.498419311408203e-10,
  1.938221526752958e-12, -5.940871342138209e-14, -5.465676725501809e-16,  1.588448696444494e-17,  1.714630067004529e-19, -4.252022227228018e-21,  1.075322942078763e+00,
  1.188131680375125e-02, -3.460670616387475e-05, -9.746618241497533e-07,  1.012225109596677e-08,  1.060436367865412e-10, -2.621472928651061e-12, -4.436672040855175e-15,
  6.106777462274622e-16, -3.214472627542162e-18, -1.171004217887432e-19,  1.841642528644965e-21,  1.356704408384934e+00,  9.711002070660424e-03, -6.936568513548418e-05,
 -1.673369874985953e-07,  1.000455324830165e-08, -8.466519172973638e-11, -6.519163279063584e-13,  2.259723163066044e-14, -1.533405300505512e-16, -2.385807426674841e-18,
  6.474711214444656e-20, -2.144331672283772e-22,  1.594081909398661e+00,  6.804780240422679e-03, -6.913482326211152e-05,  3.602862731118051e-07,  2.247415593408633e-09,
 -7.568162318159292e-11,  8.094599940103596e-13, -1.160893983360139e-15, -1.071403309651953e-16,  1.946382329247355e-18, -1.111853514947663e-20, -7.759367393142980e-23,
  1.779816303307061e+00,  3.951627248485781e-03, -4.834749306451144e-05,  4.444452444442417e-07, -2.611735687593398e-09, -3.656777900224035e-12,  3.606704437062843e-13,
 -5.754858074653545e-15,  5.483180464927546e-17, -1.720975572219296e-19, -3.366217808706923e-21,  1.275010716795788e-22,  1.910038283073499e+00,  1.684085405636592e-03,
 -2.283961230534727e-05,  2.614479273321014e-07, -2.596175915800394e-09,  2.179331980321321e-11, -1.368532407809495e-13,  2.470133442553081e-16,  1.044814564501002e-17,
 -2.133437111306703e-19,  3.341875059461453e-21, -2.297725472601531e-23,  1.982891229629777e+00,  3.273577414802104e-04, -4.669182543710373e-06,  5.869679947562714e-08,
 -6.841470843522898e-10,  7.548835495012347e-12, -7.956698028805484e-14,  8.042026758466446e-16, -7.740151918385023e-18,  7.295180036831264e-20, -5.580258551840532e-22,
  6.531957700654278e-24,  2.490882612138866e-02,  8.683054574410450e-04,  2.224504825294825e-05,  4.927965976259920e-07,  9.866833090435271e-09,  1.805351696143359e-10,
  2.995183200405894e-12,  4.365331185627254e-14,  5.093114149165190e-16,  3.028674106970808e-18, -6.204624391308189e-20, -2.961027372287875e-21,  2.053345093388781e-01,
  6.005409992287689e-03,  1.090188238075379e-04,  1.213132679752385e-06,  6.924679909939383e-10, -3.057509387137425e-10, -6.775601405373337e-12, -4.991144289928748e-14,
  1.228048952156634e-15,  4.676322113452915e-17,  6.483595972705243e-19, -2.126049898279822e-21,  4.933878020984002e-01,  1.079483098375706e-02,  9.711758640483753e-05,
 -5.713612844556101e-07, -2.373510484318143e-08, -6.645703833971909e-11,  5.794171475744380e-12,  7.016715607921154e-14, -1.157614940668831e-15, -3.222498105632998e-17,
  1.298988992559597e-19,  1.310500650836586e-20,  8.142449976351263e-01,  1.250563841335634e-02,  1.878915555706521e-05, -1.369109803450399e-06, -2.215074172499132e-09,
  2.749875952955991e-10,  1.230497943474725e-13, -6.682081922431155e-14,  9.951230868448697e-17,  1.860052697011051e-17, -3.890402199341697e-20, -4.702046025559286e-21,
  1.122224499105749e+00,  1.156057156240671e-02, -4.527201958643247e-05, -7.991613881637921e-07,  1.161476223607443e-08,  4.371070261465395e-11, -2.494975500647507e-12,
  1.252055035708113e-14,  4.319672061053962e-16, -6.101282828905649e-18, -2.546436535243393e-20,  2.086947889553493e-21,  1.394429514467021e+00,  9.150632463047047e-03,
 -7.047136268203821e-05, -2.145636040297181e-08,  8.202900920966164e-09, -9.333504526212339e-11, -9.737287674769175e-14,  1.679209673596397e-14, -1.956765937406455e-16,
 -6.642620296407687e-20,  4.979955074841672e-20, -4.161172249023983e-22,  1.620222974827760e+00,  6.269498433763832e-03, -6.464221202915286e-05,  3.851741751035286e-07,
  9.236816291681280e-10, -5.697048042236876e-11,  7.388583569246141e-13, -3.556954596359862e-15, -4.532928862724149e-17,  1.493677301529729e-18, -1.031711946733961e-20,
  8.550418289383346e-23,  1.794882023550211e+00,  3.585467523106766e-03, -4.326590804142222e-05,  4.024914037484515e-07, -2.610364503321673e-09,  3.257555839759581e-12,
  2.230421438130832e-13, -4.115155176145005e-15,  4.744748821915086e-17, -2.073816071411975e-19,  1.280817030506905e-21,  8.232010540245902e-23,  1.916428106240582e+00,
  1.513243828428530e-03, -1.993765666145699e-05,  2.232205363261298e-07, -2.192425712363148e-09,  1.862340162910342e-11, -1.262366794216646e-13,  4.826018908791857e-16,
  4.976894178051772e-18, -9.492857700064683e-20,  2.678390360479355e-21, -9.730254071347421e-24,  1.984130166242038e+00,  2.926464757052867e-04, -4.025833157869379e-06,
  4.886168660391301e-08, -5.505773848522392e-10,  5.883738126498331e-12, -6.014956900435770e-14,  5.947852079237924e-16, -5.447558835127740e-18,  5.623451446837224e-20,
 -2.841119166192099e-22,  5.595260787452765e-24,  2.877960656582455e-02,  1.072905849011024e-03,  2.923884590515962e-05,  6.839070496685048e-07,  1.430524509790447e-08,
  2.690047078664359e-10,  4.456781917841597e-12,  6.088585119572785e-14,  5.303055974532880e-16, -3.441398938943497e-18, -3.048214513050087e-19, -8.982774587773493e-21,
  2.311922270427907e-01,  6.935455198256691e-03,  1.234114180497390e-04,  1.166082975950369e-06, -7.131721650446421e-09, -4.789703113886477e-10, -7.336671321927590e-12,
  2.084852381576298e-14,  3.309540814929686e-15,  6.552861006909091e-17,  1.316149626865307e-19, -2.376651736159245e-20,  5.380684019594575e-01,  1.153784142285416e-02,
  8.796490893809492e-05, -9.536209557404459e-07, -2.354046462541421e-08,  9.098594580811869e-11,  7.079715343474304e-12,  1.672735875222501e-14, -2.081012848383874e-15,
 -1.522259208434548e-17,  7.023218577889952e-19,  1.055561647088337e-20,  8.644638234443174e-01,  1.259004780577481e-02,  2.327496747793327e-06, -1.361014435783998e-06,
  3.167075525306102e-09,  2.564473539794678e-10, -1.607020711307911e-12, -5.359619500484748e-14,  6.962006442810461e-16,  1.347611183795528e-17, -2.002470938952013e-19,
 -2.421639846945758e-21,  1.167686218661711e+00,  1.116324087400350e-02, -5.372824119572180e-05, -6.094402645668859e-07,  1.192577828254672e-08, -1.060555406895190e-11,
 -1.984317451817775e-12,  2.280006110164754e-14,  2.141669487010471e-16, -5.515050731225726e-18,  4.684970511366982e-20,  1.004634297023236e-21,  1.429905834570784e+00,
  8.587920893385127e-03, -7.000296660292304e-05,  9.487670311537583e-08,  6.347295937847033e-09, -9.072679661520071e-11,  2.873089716795243e-13,  1.083921229455425e-14,
 -1.668772031929937e-16,  1.530112491492146e-18,  2.905323576753160e-20, -5.571925155532326e-22,  1.644296214600914e+00,  5.771019825853460e-03, -5.996602635818377e-05,
  3.917650743266806e-07, -4.711516783003787e-11, -4.054989597398974e-11,  6.265172608452010e-13, -4.218991098891349e-15,  1.965078794449852e-18,  1.157214203143470e-18,
 -6.977895522113484e-21,  1.925373334857007e-23,  1.808561234766564e+00,  3.257956485853515e-03, -3.868361386805695e-05,  3.615014544333803e-07, -2.500157225351300e-09,
  7.393055192936420e-12,  1.280578621869638e-13, -2.700479077903646e-15,  4.159363517683368e-17, -1.049124607120223e-19,  3.171628484705737e-21, -1.095328690315017e-23,
  1.922178237920336e+00,  1.363888083186068e-03, -1.745771161364801e-05,  1.909617413581953e-07, -1.849077708763118e-09,  1.577143235910200e-11, -1.108655357546257e-13,
  6.069739865258394e-16,  3.373966667821360e-18,  1.895208080176679e-21,  2.044413589366411e-21, -2.637101393803601e-23,  1.985239852062553e+00,  2.626438747991400e-04,
 -3.488704482867715e-06,  4.092074274142387e-08, -4.460836621997837e-10,  4.622101018936934e-12, -4.564487075618678e-14,  4.510845569771096e-16, -3.577702851190138e-18,
  4.867356579564152e-20, -1.339836401707089e-22,  2.326600174012743e-26,  3.359711196049419e-02,  1.343984836037370e-03,  3.901706420455134e-05,  9.622550352927887e-07,
  2.090210283333804e-08,  3.981215956580236e-10,  6.358376600925228e-12,  7.255920299632905e-14,  6.232053531896795e-17, -2.690216448043874e-17, -9.695164054901983e-19,
 -2.297365305850601e-20,  2.609934784511533e-01,  7.975990462748651e-03,  1.363737793598154e-04,  9.662147518491497e-07, -1.835360434050798e-08, -6.339220040370886e-10,
 -4.922706911712402e-12,  1.629587176067242e-13,  5.433745298486674e-15,  4.139271440460796e-17, -1.539422524849355e-18, -5.065552928676731e-20,  5.855459496440428e-01,
  1.218958238457112e-02,  7.435162749600426e-05, -1.306459256554332e-06, -2.002394799729386e-08,  2.587005996620564e-10,  6.576253198210683e-12, -5.252522101753662e-14,
 -2.046368594580033e-15,  1.813791522995244e-17,  8.443136014890598e-19, -5.892923082343215e-21,  9.147595275971202e-01,  1.254457438565102e-02, -1.353944378097756e-05,
 -1.271864986925510e-06,  7.803478683492412e-09,  2.027766208810095e-10, -2.734905418762249e-12, -2.526838541526688e-14,  1.017647532571792e-15,  3.985951546082419e-18,
 -2.617427417830108e-19, -7.334283278883256e-22,  1.211437751279388e+00,  1.070737381832331e-02, -5.991140930832590e-05, -4.226834704945708e-07,  1.129241775017960e-08,
 -4.996287863524625e-11, -1.276890580089440e-12,  2.689334321845743e-14,  5.515184251106472e-17, -3.300311071903571e-18,  4.931807644361925e-20, -9.782000948359102e-22,
  1.463146940494488e+00,  8.034042706848007e-03, -6.831351447048555e-05,  1.823848549660286e-07,  4.623419953382492e-09, -8.073520949542536e-11,  5.256198364718748e-13,
  6.550896152847216e-15, -9.771757109394251e-17,  2.093851989819157e-18, -4.213086349108901e-21, -1.012832701847782e-21,  1.666450518719640e+00,  5.310026998010079e-03,
 -5.529359344411164e-05,  3.853006636843126e-07, -7.171246681061791e-10, -2.688743201549267e-11,  5.151315900093120e-13, -3.546483187121560e-15,  3.806352225074303e-17,
  8.097219464179873e-19, -1.297977598349452e-20, -3.315634326650696e-22,  1.821000652977868e+00,  2.965171807530934e-03, -3.458025498776529e-05,  3.228257758445946e-07,
 -2.326921464338276e-09,  9.706796214838373e-12,  7.066585602645431e-14, -1.409231158352276e-15,  3.954004934430592e-17, -3.793419951353707e-20, -1.243072361386969e-21,
 -2.043738602366850e-22,  1.927368300372619e+00,  1.232912667647481e-03, -1.533372499914010e-05,  1.637613622271105e-07, -1.558815023533025e-09,  1.332735866546211e-11,
 -9.225327616572867e-14,  7.286758015603413e-16,  4.498147060862513e-18,  4.482185032380514e-20, -3.655443587610588e-22, -8.988203667568292e-23,  1.986237555770867e+00,
  2.365837591675129e-04, -3.037610601009939e-06,  3.446750132107326e-08, -3.636334852100346e-10,  3.666830201982810e-12, -3.436219906152309e-14,  3.634065779298216e-16,
 -1.952040882465589e-18,  3.988734841176693e-20, -4.041904232224417e-22, -1.342921316448855e-23,  3.967935195827811e-02,  1.708657373149325e-03,  5.286221057628239e-05,
  1.369359755648632e-06,  3.055132417256024e-08,  5.741094759571484e-10,  8.205671758384323e-12,  4.921000090126851e-14, -1.907568312874312e-15, -9.263325456379077e-17,
 -2.504652378960475e-18, -4.857673986630378e-20,  2.951444935473814e-01,  9.107370742561906e-03,  1.457723465716821e-04,  5.666277947877181e-07, -3.173842227365720e-08,
 -6.768243247755580e-10,  2.187506386343328e-12,  3.442561032991681e-13,  5.255437728958681e-15, -6.646054944110015e-17, -3.784439188498417e-18, -4.025962923219603e-20,
  6.353875101092530e-01,  1.271668479553390e-02,  5.694867234735047e-05, -1.577498192207997e-06, -1.342565586677849e-08,  3.922996987415458e-10,  4.328703518137547e-12,
 -1.019084005290086e-13, -9.019804063681491e-16,  4.088336439010021e-17,  1.625431819627305e-19, -2.340291201584038e-20,  9.646279048815727e-01,  1.237761599087141e-02,
 -2.793090499900009e-05, -1.118304759484105e-06,  1.116463757143358e-08,  1.323873604301401e-10, -2.979703200467734e-12,  7.509925092056190e-15,  9.649725077252313e-16,
 -7.147121329066416e-18, -2.980941080209853e-19, -1.107350757526703e-21,  1.253280764157672e+00,  1.021077979463422e-02, -6.393720258709529e-05, -2.514055931434422e-07,
  1.004830623548288e-08, -7.147159273307512e-11, -5.149831966133803e-13,  2.701743956513369e-14, -4.398683489545947e-17, -2.776327990515821e-18, -3.586489806219074e-20,
 -2.691059589672172e-21,  1.494205575898963e+00,  7.497428656699254e-03, -6.573195592800318e-05,  2.441842185389555e-07,  3.148179609616149e-09, -6.620644651600685e-11,
  6.758105535310673e-13,  4.499757198149183e-15, -3.770136701513020e-17,  8.627604111485506e-19, -6.102989321073848e-20, -1.499231605219979e-21,  1.686834888115057e+00,
  4.885940963211747e-03, -5.075448485792032e-05,  3.701654284106193e-07, -1.138475269033019e-09, -1.555575398353023e-11,  4.363465573142943e-13, -1.998587755235959e-15,
  5.317547341130690e-17, -1.284320082627846e-19, -3.673417459393723e-20, -7.052503788328232e-22,  1.832331717487004e+00,  2.703407779006648e-03, -3.092305567423614e-05,
  2.872294010561420e-07, -2.118291166885659e-09,  1.107013843623823e-11,  4.852636872086131e-14, -1.969016441140256e-16,  3.452256333074028e-17, -3.310268356502968e-19,
 -1.478722006889169e-20, -3.877050894864966e-22,  1.932066484488758e+00,  1.117698927057607e-03, -1.350980882054199e-05,  1.408396470045033e-07, -1.312666671069743e-09,
  1.137555323164437e-11, -6.966434947842606e-14,  8.864966270918739e-16,  4.687573674023368e-18, -7.130062769505873e-20, -5.925958216680871e-21, -1.543510293216269e-22,
  1.987137775934771e+00,  2.138437052954764e-04, -2.656625256124511e-06,  2.919459835659336e-08, -2.977509658124068e-10,  2.958364919672892e-12, -2.487577111158718e-14,
  3.193628196046424e-16, -9.913028353358441e-19,  7.398849948940103e-21, -1.317957564120766e-21, -2.644845549270540e-23,  4.747682000571631e-02,  2.206538112477596e-03,
  7.264190760057483e-05,  1.961035902299328e-06,  4.406287986273157e-08,  7.767967158081265e-10,  8.063044973798756e-12, -8.921235537465932e-14, -7.636638169573034e-15,
 -2.436255460330874e-16, -5.200189161813791e-18, -6.830273267006642e-20,  3.339358985482630e-01,  1.029112208610683e-02,  1.490972218352377e-04, -4.304624724014757e-08,
 -4.388432524212957e-08, -4.929715190046397e-10,  1.359851161001426e-11,  4.426105560234070e-13, -1.075213420985184e-16, -2.320987313124098e-16, -3.819856750908758e-18,
  5.182008723876288e-20,  6.870412090135957e-01,  1.309353045683188e-02,  3.700427934424324e-05, -1.724907506711208e-06, -4.782990774527928e-09,  4.600384505663542e-10,
  1.289147842319301e-12, -1.080894094793759e-13,  4.245880890830064e-16,  2.562091332520849e-17, -9.055978424102654e-19, -2.056073493190121e-20,  1.013611004649934e+00,
  1.210370348538895e-02, -4.020362935552404e-05, -9.222437138241247e-07,  1.313100550319820e-08,  6.656468015739208e-11, -2.392780399311630e-12,  3.187195925648313e-14,
  4.809757800807507e-16, -2.003758297973918e-17, -3.400811191651647e-19, -1.626272676660433e-22,  1.293085492632204e+00,  9.689836105795730e-03, -6.603808582310612e-05,
 -1.024866684756227e-07,  8.555284993397698e-09, -7.502054161377458e-11,  2.034167114083753e-13,  2.349493257580022e-14, -1.991438032922800e-16, -6.627648934110141e-18,
 -1.520176317359063e-19, -2.024061825691162e-21,  1.523163220915311e+00,  6.984055451701696e-03, -6.254025013024877e-05,  2.848838796112466e-07,  1.995796239328568e-09,
 -4.860273973331730e-11,  7.854792971260703e-13,  3.191220122126661e-15, -6.618420936548997e-17, -2.843370019382800e-18, -1.200467259246348e-19, -9.032568002955944e-22,
  1.705594248992123e+00,  4.497343330680670e-03, -4.643026101537197e-05,  3.500141658417709e-07, -1.348466207567433e-09, -5.578619176583978e-12,  4.011344927079317e-13,
 -7.160882976257979e-16,  1.456651518168819e-17, -2.212288013552223e-18, -6.564772398924235e-20, -4.482247634719360e-22,  1.842671618424117e+00,  2.469251406575741e-03,
 -2.767214766330364e-05,  2.551714266001797e-07, -1.885107770136818e-09,  1.227751717857638e-11,  5.567847366374062e-14,  5.693569267071889e-16,  7.842854185643482e-18,
 -1.257934370081992e-18, -3.058563349613521e-20, -2.501246313211856e-22,  1.936331345110553e+00,  1.016040457835308e-03, -1.193851176400151e-05,  1.215749218146157e-07,
 -1.099793964123912e-09,  1.001408329730194e-11, -4.353182931653124e-14,  9.363690825799217e-16, -3.773304481114519e-18, -4.407466883272080e-19, -1.214530260236305e-20,
 -9.770474234808815e-23,  1.987952754886139e+00,  1.939153565032193e-04, -2.333018572139447e-06,  2.487445825707680e-08, -2.438485274397611e-10,  2.464893046011102e-12,
 -1.642354828263455e-14,  2.794325408794717e-16, -1.954734918729296e-18, -6.819167346024888e-20, -2.392586954451767e-21, -1.668745850688640e-23,  5.763283658499981e-02,
  2.895030599685125e-03,  1.009473454425503e-04,  2.799378574005925e-06,  6.114883504248840e-08,  9.030438535015658e-10,  5.075434459124185e-13, -5.193784808401569e-13,
 -2.077531866994859e-14, -4.979205386444103e-16, -6.774494830825245e-18,  3.947774534638360e-20,  3.774650015936071e-01,  1.146928351318114e-02,  1.441111123782994e-04,
 -8.022398539797766e-07, -4.951440765530112e-08, -2.690219200461193e-11,  2.451382924499555e-11,  2.826664926609918e-13, -1.032920380702996e-14, -3.030565329209012e-16,
  1.077674277167920e-18,  1.589618430682228e-19,  7.398753992854571e-01,  1.330617337087662e-02,  1.615256604622672e-05, -1.727141390966826e-06,  4.492545804082750e-09,
  4.567603866954966e-10, -1.466777724974293e-12, -8.813206923195863e-14,  5.355191235175213e-16, -2.196726041712187e-17, -1.273389243212185e-18,  6.534206043380570e-21,
  1.061317622115584e+00,  1.174146089345560e-02, -4.997526790951353e-05, -7.042922030611796e-07,  1.396613823309008e-08,  2.082669722671956e-11, -1.411777091743641e-12,
  3.315620124279058e-14, -4.752284849301102e-16, -3.241843360068870e-17, -2.356267330556133e-19,  5.745996760794326e-21,  1.330783577032912e+00,  9.158827835455375e-03,
 -6.649469989453479e-05,  2.286731325271438e-08,  7.152159649255618e-09, -6.323010441954202e-11,  7.270782097632819e-13,  1.201223804289611e-14, -5.599581394979948e-16,
 -1.348479038379091e-17, -1.598753126902355e-19,  2.196997480245054e-21,  1.550121127420383e+00,  6.497883639975739e-03, -5.895873775669022e-05,  3.100889727721679e-07,
  1.217730754347517e-09, -2.904736829056599e-11,  8.228941880057990e-13, -1.536245720146356e-15, -2.594223348129640e-16, -7.849581651589910e-18, -1.123609121695683e-19,
  1.541694333064243e-21,  1.722866814464378e+00,  4.142330024786088e-03, -4.236155004998414e-05,  3.280622113958508e-07, -1.365498648639725e-09,  3.768316634302823e-12,
  3.718829172772615e-13, -2.052375706232651e-15, -1.143813661706746e-16, -4.919297405319582e-18, -6.004998532369039e-20,  8.704734907478410e-22,  1.852124564065990e+00,
  2.259628864823109e-03, -2.478270784742434e-05,  2.270520182819623e-07, -1.624966304913870e-09,  1.378280049069177e-11,  6.656001576408400e-14, -1.531361519288393e-16,
 -6.073955215117124e-17, -2.542589012374089e-18, -2.876668266109395e-20,  4.168898585695276e-22,  1.940213327782391e+00,  9.260837111195058e-04, -1.057874421895225e-05,
  1.055321530433434e-07, -9.079816864206117e-10,  9.252134385195606e-12, -2.209001289759215e-14,  4.630041644819158e-16, -2.888282297029528e-17, -9.505093335274056e-19,
 -1.144182293050849e-20,  1.621927294600488e-22,  1.988692889615711e+00,  1.763824751892578e-04, -2.056370189762139e-06,  2.134834568581277e-08, -1.979072087146821e-10,
  2.154595670977567e-12, -9.981229235681602e-15,  1.583185910556362e-16, -6.211224539617342e-18, -1.672673493526550e-19, -2.213103081785438e-21,  3.090515166168221e-23,
  7.106612816850104e-02,  3.854958117362967e-03,  1.409910682521800e-04,  3.916383675770404e-06,  7.768882674790133e-08,  6.473561104731917e-10, -2.635902048569959e-11,
 -1.513272086708021e-12, -4.209521887181946e-14, -6.071749104892860e-16,  5.811871157150117e-18,  6.673310940380937e-19,  4.255681499200443e-01,  1.257037396875784e-02,
  1.298221063922049e-04, -1.564913118524352e-06, -4.376165388365956e-08,  6.096190436258360e-10,  2.630140290671236e-11, -2.001033383828330e-13, -1.874592920566657e-14,
 -1.195887846555993e-16,  7.723788470659393e-18,  1.083162903522905e-19,  7.932298909518271e-01,  1.335439086757999e-02, -3.848815737840936e-06, -1.584908480584581e-06,
  1.308154615433393e-08,  3.928241443670032e-10, -3.877459000509503e-12, -9.234479493254236e-14, -1.016335897881299e-15, -5.774710509227023e-17, -2.969205328388534e-19,
  3.636257607603834e-20,  1.107435726566125e+00,  1.131167260192142e-02, -5.707748597890159e-05, -4.790722798321398e-07,  1.410539750837190e-08, -4.762263388868462e-12,
 -8.811132600835195e-13, -1.895951117412226e-15, -1.727576108131104e-15, -3.417788744964794e-17,  2.167594629816798e-19,  1.526396726688400e-20,  1.366359339059310e+00,
  8.629823703439655e-03, -6.557213404942072e-05,  1.282049608562071e-07,  6.076792098064439e-09, -4.425500136385641e-11,  7.323905630113857e-13, -1.461334833147234e-14,
 -1.121028184402277e-15, -1.614177991257294e-17,  7.509792762607603e-20,  8.825258091378517e-21,  1.575193306933097e+00,  6.041391897319713e-03, -5.513655172727829e-05,
  3.259630228632166e-07,  8.247385501935729e-10, -1.103988256548989e-11,  6.160575217212252e-13, -1.503293403096233e-14, -5.971879691385419e-16, -9.940320706811756e-18,
  3.611402763991843e-20,  5.448903261382776e-21,  1.738782769496498e+00,  3.818821938376485e-03, -3.855190962727746e-05,  3.072728796116940e-07, -1.208419749471604e-09,
  1.141256701737504e-11,  2.338441588590243e-13, -8.900882029924868e-15, -3.202615990035494e-16, -5.970541622720689e-18,  2.349047609679805e-20,  3.082257991855231e-21,
  1.860783216464551e+00,  2.071845194573768e-03, -2.220471859530994e-05,  2.033380384162422e-07, -1.335202355561792e-09,  1.501783691746862e-11,  2.000850143030922e-14,
 -3.730365356074143e-15, -1.659177469870255e-16, -3.029682298857750e-18,  1.256982655732944e-20,  1.544879092305416e-21,  1.943756092819423e+00,  8.462862185519754e-04,
 -9.393504943105488e-06,  9.245807860278239e-08, -7.278744756789110e-10,  8.738794712714767e-12, -2.772586733200433e-14, -1.076417084450709e-15, -6.858707572210258e-17,
 -1.149640304834240e-18,  4.678956263348490e-21,  6.039129638685212e-22,  1.989367068289489e+00,  1.609055995051302e-04, -1.817806282041402e-06,  1.851457666308535e-08,
 -1.569933573060259e-10,  1.939694902435660e-12, -9.336581001659044e-15, -1.499772490286951e-16, -1.330810412846513e-17, -2.072153988511691e-19,  8.068744884685125e-22,
  1.126837240008174e-22,  8.907021000583600e-02,  5.192681649696725e-03,  1.957152518787540e-04,  5.211235796840726e-06,  8.001687799513586e-08, -6.627076128563266e-10,
 -9.011522180914282e-11, -3.085508466800440e-12, -4.923333374701587e-14,  6.043974276581079e-16,  6.578038099251025e-17,  2.144901372453557e-18,  4.777925464376248e-01,
  1.352306674732317e-02,  1.073472689350468e-04, -2.136416559179868e-06, -2.606962174091520e-08,  1.104164275204257e-09,  1.211803319147633e-11, -8.028094695012764e-13,
 -1.678504927620642e-14,  2.359135864278254e-16,  8.894580527357798e-18, -4.257580443539700e-20,  8.464711837371732e-01,  1.325164243877024e-02, -2.137161881982360e-05,
 -1.318778065426301e-06,  1.977083028349316e-08,  2.631446852274408e-10, -7.227088431323650e-12, -1.568675407755717e-13, -2.858555915252701e-15, -3.043315740144965e-17,
  1.855271456781535e-18,  6.370826270859766e-20,  1.151738164522242e+00,  1.083587861525076e-02, -6.147945001697431e-05, -2.554409806276809e-07,  1.375760992150327e-08,
 -3.383347279944151e-11, -1.872506826755540e-12, -7.365423914858153e-14, -2.605085950314266e-15, -8.057792925464315e-18,  1.213766465004315e-18,  3.272605274974572e-20,
  1.399841474701306e+00,  8.112991284123751e-03, -6.347698712643856e-05,  2.190893174101899e-07,  5.311238668065343e-09, -3.613593844213776e-11, -2.570715032938131e-13,
 -5.828751916400963e-14, -1.529956574804672e-15, -2.565147627316749e-18,  6.889878940691173e-19,  2.072244057626004e-20,  1.598501762964154e+00,  5.616157593660766e-03,
 -5.115099805827376e-05,  3.380097998974980e-07,  7.052153329599398e-10, -3.772344511991627e-12, -1.210315787657828e-13, -3.902419547254402e-14, -8.561573769089745e-16,
 -1.970015249570613e-18,  4.152060130558930e-19,  1.280378643608893e-20,  1.753464140144472e+00,  3.524845883841542e-03, -3.497241031322582e-05,  2.899611146323936e-07,
 -9.510131568969556e-10,  1.269151940985439e-11, -1.880694209871400e-13, -2.208539071043587e-14, -4.768044451256271e-16, -1.309397169216815e-18,  2.403926342089354e-19,
  7.370215124316496e-21,  1.868730292755656e+00,  1.903627268786926e-03, -1.988297098297677e-05,  1.843562115968546e-07, -1.042007634523776e-09,  1.355118078885517e-11,
 -1.735676477852574e-13, -1.052582701206612e-14, -2.450186420486688e-16, -6.472640299510223e-19,  1.224249787563009e-19,  3.751136121035894e-21,  1.946997706055871e+00,
  7.753911623673692e-04, -8.348273221668108e-06,  8.215896459252471e-08, -5.636286972683727e-10,  7.428228282934860e-12, -9.420065603796993e-14, -3.833860260006829e-15,
 -9.841252097073368e-17, -2.258809704177676e-19,  4.776876142858699e-20,  1.473510812040141e-21,  1.989982956383713e+00,  1.472120050731430e-04, -1.609468133019473e-06,
  1.629848173831575e-08, -1.210566439613566e-10,  1.610710625523868e-12, -2.050856727152666e-14, -6.771351923167909e-16, -1.865882530415229e-17, -3.756137805066124e-20,
  8.842360260423520e-21,  2.746982105337950e-22,  1.133966797668137e-01,  7.028379509182670e-03,  2.650266924779585e-04,  6.235860015269670e-06,  3.738437146871289e-08,
 -3.997019561064915e-09, -1.905085221812752e-10, -3.602150409845826e-12,  4.506573976973046e-14,  5.324527636218048e-15,  1.653874421420123e-16,  1.267515139879844e-18,
  5.334322823548135e-01,  1.427394500263233e-02,  7.996427667739432e-05, -2.369673197249128e-06, -3.170532609907717e-09,  1.074763649432090e-09, -1.613641161420575e-11,
 -1.139130883884863e-12, -2.319035194719299e-15,  5.622527040258035e-16,  8.349722475112750e-18,  8.241254591991103e-20,  8.990436127016509e-01,  1.302307636304448e-02,
 -3.516035167734361e-05, -9.714518649332836e-07,  2.288807544956689e-08,  2.630077883531005e-11, -1.292686138417574e-11, -2.452376035576104e-13, -1.813278310478426e-15,
  1.146413619996823e-16,  5.828377886356930e-18,  1.208883239792891e-19,  1.194083784341085e+00,  1.033545245752899e-02, -6.325657435371704e-05, -4.404451630828651e-08,
  1.241614357420827e-08, -1.127946805126471e-10, -5.059687067256080e-12, -1.489125003033128e-13, -1.587503109474896e-15,  7.906727837489890e-17,  3.408187641353500e-18,
  6.779017152328447e-20,  1.431296419351074e+00,  7.617076070585248e-03, -6.036472565231992e-05,  2.972989009062468e-07,  4.366526089306283e-09, -6.726718627248004e-11,
 -2.538455523203148e-12, -1.012676567080155e-13, -8.519166929973018e-16,  4.933188958866510e-17,  2.065033767738850e-18,  4.162358906644683e-20,  1.620173925549201e+00,
  5.223357069360612e-03, -4.703132905638031e-05,  3.481051641577344e-07,  4.964525971910574e-10, -2.280484518160976e-11, -1.577648665577193e-12, -6.303387340933170e-14,
 -4.592928233598414e-16,  2.958742715152685e-17,  1.256562742205163e-18,  2.508500352626801e-20,  1.767025658975054e+00,  3.258742587660647e-03, -3.157724100029144e-05,
  2.762892656431083e-07, -8.012056989913931e-10, -9.262176089787841e-13, -1.009648535532027e-12, -3.548374820943229e-14, -2.537299273558538e-16,  1.689924174982647e-17,
  7.229441256356224e-19,  1.427153506904118e-20,  1.876040309857142e+00,  1.753147738354842e-03, -1.776283051567008e-05,  1.695099272426349e-07, -8.410309734246433e-10,
  4.984288924824019e-12, -5.726477067841898e-13, -1.740847461649604e-14, -1.307531039383130e-16,  8.619580719721679e-18,  3.674670200688403e-19,  7.208257369228039e-21,
  1.949971739610820e+00,  7.124055856606064e-04, -7.412084309325057e-06,  7.416374468662161e-08, -4.481790685591152e-10,  3.532634982400129e-12, -2.433762885208735e-13,
 -6.592975246485548e-15, -5.275110259572605e-17,  3.399397109144494e-18,  1.438041783157906e-19,  2.814265225240353e-21,  1.990547248076882e+00,  1.350878973547848e-04,
 -1.424551861714869e-06,  1.458489891561169e-08, -9.564321243401204e-11,  8.253771093539445e-13, -4.738486426370031e-14, -1.199376498811471e-15, -1.003046738594829e-17,
  6.354400757708395e-19,  2.671490507391849e-20,  5.225740868195445e-22,  1.462286800975786e-01,  9.450244354762664e-03,  3.399223969257517e-04,  5.917424961247541e-06,
 -9.468611069277437e-08, -9.393620316500261e-09, -2.333151322855093e-10,  2.146429288438441e-12,  3.455387501916324e-13,  1.019864969167199e-14, -2.410226381728866e-17,
 -1.269847354800663e-17,  5.916280944461135e-01,  1.480049590552935e-02,  5.183558888567032e-05, -2.280212645497507e-06,  1.191371198109649e-08,  3.176320625240335e-10,
 -4.550306897665850e-11, -8.130929731251414e-13,  2.551042093499225e-14,  1.038845416263075e-15,  1.602851828982084e-17,  1.152485285157404e-19,  9.505082115154508e-01,
  1.270130803150188e-02, -4.466428398914737e-05, -6.202770356415598e-07,  1.974446286088673e-08, -3.672102820358644e-10, -1.960188314605063e-11, -1.814225828993829e-13,
  7.829997397700556e-15,  4.536921919653604e-16,  1.042176085506825e-17,  9.133813424702567e-21,  1.234414620452258e+00,  9.830441294398359e-03, -6.269300312764955e-05,
  1.284919705682785e-07,  8.593589022060002e-09, -2.862831363643448e-10, -9.290343686515289e-12, -1.219245434907089e-13,  4.431457619229378e-15,  2.721241130271126e-16,
  5.747051316006683e-18, -8.748737038460731e-21,  1.460822991595208e+00,  7.149487636571599e-03, -5.643578019787556e-05,  3.520982572007958e-07,  2.175686518413079e-09,
 -1.629958720433535e-10, -5.354066918083781e-12, -8.060013999749706e-14,  2.840761178259416e-15,  1.654587774448056e-16,  3.397395039356572e-18, -1.036038966733895e-20,
  1.640341432942029e+00,  4.863899445544741e-03, -4.282979920054548e-05,  3.497288506183236e-07, -4.842112830268749e-10, -8.212398532537409e-11, -3.306615161174870e-12,
 -4.886463678588530e-14,  1.765082197037187e-15,  9.952083268955134e-17,  2.016287478442641e-18, -8.430978894426801e-21,  1.779576069072042e+00,  3.019156942425079e-03,
 -2.834450423508703e-05,  2.616602858058180e-07, -1.144054387434592e-09, -3.720583313055144e-11, -1.978579895513529e-12, -2.709080485269988e-14,  1.018205114336678e-15,
  5.680234430464989e-17,  1.138183078773183e-18, -5.687530062646223e-21,  1.882781258172580e+00,  1.618954693774056e-03, -1.580904264776044e-05,  1.559347396885828e-07,
 -9.190711703829701e-10, -1.467792142605820e-11, -1.048252306777720e-12, -1.318990652705293e-14,  5.157777046481638e-16,  2.879631838254957e-17,  5.713825937179635e-19,
 -3.178111006909565e-21,  1.952708237041312e+00,  6.565498547578638e-04, -6.564016767012920e-06,  6.717642682029577e-08, -4.512317505004633e-10, -4.555681396590896e-12,
 -4.239236900313654e-13, -4.979108115615218e-15,  2.009899801662442e-16,  1.127276460586768e-17,  2.219786337352165e-19, -1.315378559725041e-21,  1.991065879639313e+00,
  1.243663376336814e-04, -1.258402243392510e-06,  1.311315926355872e-08, -9.329556039017368e-11, -7.215093405459809e-13, -8.029662572073767e-14, -9.048004096313666e-16,
  3.723182875361085e-17,  2.096190499996865e-18,  4.109056446811175e-20, -2.514163131852739e-22,  1.898607148562783e-01,  1.241185729631520e-02,  3.947751273329080e-04,
  2.642158317953181e-06, -3.259200408899891e-07, -1.272366242876065e-08,  2.736772707538923e-11,  1.744883169037315e-11,  5.092970753151290e-13, -7.186331598233641e-15,
 -9.104372917243454e-16, -1.963020612234755e-17,  6.514908402321039e-01,  1.510903821986272e-02,  2.561808395440068e-05, -2.103703415010620e-06,  6.140825111755371e-09,
 -9.165160946302649e-10, -5.037556726209414e-11,  7.144314442863083e-13,  7.222583708760005e-14,  1.355572487204943e-15, -1.682458947497051e-17, -2.163157692596745e-18,
  1.000558303723194e+00,  1.231886097884697e-02, -5.054031316092514e-05, -3.896774548972800e-07,  7.504694373315491e-09, -8.525062263166338e-10, -1.819347141805476e-11,
  4.004262930334260e-13,  2.994311078472629e-14,  6.609221180987333e-16, -7.682783040890168e-18, -1.028333882145076e-18,  1.272745684939371e+00,  9.336884338731130e-03,
 -6.055649887459021e-05,  2.073276743597368e-07,  4.883370305965552e-10, -5.236884757165191e-10, -8.965473634517393e-12,  2.136404509422129e-13,  1.721459636894554e-14,
  3.688911155181725e-16, -5.147487210177620e-18, -5.830545936215997e-19,  1.488545177372002e+00,  6.715197997408873e-03, -5.213340847572914e-05,  3.533447574914384e-07,
 -2.472421952335260e-09, -3.019539349295236e-10, -5.280160132953334e-12,  1.268894999292874e-13,  1.048568518475928e-14,  2.159168072960586e-16, -3.394675325834523e-18,
 -3.507940662167929e-19,  1.659137945456814e+00,  4.537761809068311e-03, -3.874859810048414e-05,  3.242268848795660e-07, -2.982223722492159e-09, -1.677126395710325e-10,
 -3.250393762758131e-12,  7.731929122428022e-14,  6.317679081936000e-15,  1.266905931549600e-16, -2.155564078198234e-18, -2.103387405410033e-19,  1.791218534830126e+00,
  2.804575185590044e-03, -2.534781005634009e-05,  2.346577769435157e-07, -2.396391536532491e-09, -8.794559821349522e-11, -1.920464858432582e-12,  4.509435450906587e-14,
  3.597494331737549e-15,  7.101030554584512e-17, -1.274505877113290e-18, -1.196678956091756e-19,  1.889015589237565e+00,  1.499685601413072e-03, -1.404040451975085e-05,
  1.374358799832607e-07, -1.479904637716011e-09, -4.130646573112782e-11, -1.004208698309457e-12,  2.332152607121194e-14,  1.816085231271573e-15,  3.552501558822226e-17,
 -6.608393922979364e-19, -6.045314647225270e-20,  1.955234330471513e+00,  6.071287741247091e-04, -5.806101740883502e-06,  5.864603754520003e-08, -6.498323507511985e-10,
 -1.524752666355199e-11, -4.020642488655138e-13,  9.265060841252767e-15,  7.080460067397442e-16,  1.378274279474905e-17, -2.622428874756427e-19, -2.359373704475505e-20,
  1.991544168989280e+00,  1.149013684633341e-04, -1.110831625021365e-06,  1.139508462788749e-08, -1.280203899466370e-10, -2.738392702772393e-12, -7.571939523158974e-14,
  1.737336058862988e-15,  1.313161220790332e-16,  2.550358596228614e-18, -4.910397453103063e-20, -4.379024848034648e-21,  2.458761344001198e-01,  1.559006392286750e-02,
  3.874322003326948e-04, -4.379183686194313e-06, -5.267567426658145e-07, -4.880111814782439e-09,  6.493158759584027e-10,  2.174714023247921e-11, -4.731210640766291e-13,
 -4.398472966143644e-14, -3.360083297694763e-16,  5.856520511453592e-17,  7.121770506863175e-01,  1.521291014161097e-02,  1.764546347074376e-07, -2.205795158620813e-06,
 -2.115349622624548e-08, -1.589678204079606e-09,  7.000967514995393e-12,  3.427270844386131e-12,  7.672462000594986e-14, -2.160895732024201e-15, -1.695830801476816e-16,
 -3.175186058910371e-18,  1.048996499854848e+00,  1.189645298390649e-02, -5.511985620740326e-05, -4.237273845844302e-07, -1.236698707354658e-08, -1.029127151493159e-09,
  8.951829292396042e-12,  1.567199175756815e-12,  3.377727443727877e-14, -9.032427306782939e-16, -7.365613270867952e-17, -1.295009194234740e-18,  1.309139135861840e+00,
  8.861660059768031e-03, -5.839664455562069e-05,  1.229454495946992e-07, -1.128870773513029e-08, -5.954577827472555e-10,  6.089355996059754e-12,  8.749196002648800e-13,
  1.886073987091394e-14, -5.211554586349374e-16, -4.039583615473528e-17, -6.440778264727193e-19,  1.514597089080248e+00,  6.313924116304675e-03, -4.834710475253206e-05,
  2.605541562699553e-07, -9.270728180813579e-09, -3.427601567893102e-10,  3.743054268680680e-12,  5.237206721618024e-13,  1.114330479563741e-14, -3.203080616149079e-16,
 -2.374389633952067e-17, -3.502687124614543e-19,  1.676692147036026e+00,  4.242247771541068e-03, -3.526548998117544e-05,  2.466299224606928e-07, -6.809093522661806e-09,
 -1.938011825393229e-10,  2.187800907418697e-12,  3.139656484965622e-13,  6.565809252267186e-15, -1.950729794646697e-16, -1.400568107825792e-17, -1.945938711194634e-19,
  1.802047991483118e+00,  2.612257682555043e-03, -2.282633534651938e-05,  1.804277664505416e-07, -4.438910189887254e-09, -1.041616242096274e-10,  1.197906045744671e-12,
  1.789448298265913e-13,  3.681273192808915e-15, -1.121897722450176e-16, -7.878584940480855e-18, -1.046199345241147e-19,  1.894799470485692e+00,  1.393487085993205e-03,
 -1.256383056216415e-05,  1.061912374460116e-07, -2.456335399600817e-09, -5.015380505696847e-11,  5.830369570375316e-13,  9.060138951320125e-14,  1.839032221455449e-15,
 -5.709152949180781e-17, -3.949840044448853e-18, -5.075526296335147e-20,  1.957574121432937e+00,  5.632922750453005e-04, -5.176132463469562e-06,  4.542380024266380e-08,
 -1.015535784568450e-09, -1.889548485356927e-11,  2.210029679622671e-13,  3.542734850901470e-14,  7.122640951112039e-16, -2.238531503001348e-17, -1.534151000573913e-18,
 -1.928652110737955e-20,  1.991986811872998e+00,  1.065221740759707e-04, -9.884400428863009e-07,  8.835829681061024e-09, -1.942901494648772e-10, -3.436516140042627e-12,
  4.031350725660964e-14,  6.582995516793725e-15,  1.316402979670482e-16, -4.164886900123540e-18, -2.840228054303714e-19, -3.528338725050438e-21,  3.138983913658346e-01,
  1.833496419746113e-02,  2.842862124048857e-04, -1.258364629646675e-05, -4.341176967707959e-07,  1.489158787328054e-08,  8.247384314153456e-10, -1.518977902369332e-11,
 -1.532426454944697e-12,  6.237360432157253e-15,  2.627812732741127e-15,  2.495327523877759e-17,  7.728528563094395e-01,  1.510051041206517e-02, -2.924527497818445e-05,
 -2.753264977320636e-06, -4.254826019485900e-08, -1.149400191142047e-10,  1.156014275551327e-10,  3.242593468883978e-12, -1.263974702274153e-13, -8.084631412645247e-15,
 -1.533661872103734e-18,  1.312799849864041e-17,  1.095661573671973e+00,  1.143038397277983e-02, -6.198844060832817e-05, -7.580672234997632e-07, -2.682221486250134e-08,
 -2.174089010806466e-10,  5.873364436812588e-11,  1.523567553437895e-12, -5.323225502003217e-14, -3.524258792324428e-15, -8.013904617316980e-18,  5.174206694091101e-18,
  1.343655365507209e+00,  8.396509458793612e-03, -5.834730168826891e-05, -1.357882135788930e-07, -1.951621537112818e-08, -1.162922104325636e-10,  3.386556023601634e-11,
  8.521070513093569e-13, -2.920010686444540e-14, -1.920176030520307e-15, -3.849388363161169e-18,  2.722912261262281e-18,  1.539094859972579e+00,  5.936669971479284e-03,
 -4.630592177017736e-05,  6.776854449970491e-08, -1.390184999661480e-08, -5.419996128551629e-11,  2.029880953134887e-11,  5.065488225188057e-13, -1.732207310641206e-14,
 -1.121910986231842e-15, -1.685629656630243e-18,  1.567170193340801e-18,  1.693112674115706e+00,  3.969850135472260e-03, -3.306933761847986e-05,  1.128224761310649e-07,
 -9.367512134357325e-09, -2.258103234579896e-11,  1.206451347659510e-11,  3.011490629900746e-13, -1.031818582598826e-14, -6.584416194644814e-16, -6.933910278813690e-19,
  9.130169378034928e-19,  1.812143624057951e+00,  2.436961168051799e-03, -2.114594214874820e-05,  9.617444749168112e-08, -5.784076497493449e-09, -7.964158475833801e-12,
  6.802921232813971e-12,  1.703713703608965e-13, -5.852410491654111e-15, -3.689052325092064e-16, -2.579426594372844e-19,  5.095664998541392e-19,  1.900179436217324e+00,
  1.297338852854453e-03, -1.155341343921260e-05,  6.057227971568122e-08, -3.091806879489658e-09, -2.095799489328617e-12,  3.411352816043588e-12,  8.576169644726801e-14,
 -2.952522144090556e-15, -1.843912849268048e-16, -8.108036318031455e-20,  2.541673920521699e-19,  1.959747501360410e+00,  5.237622994898806e-04, -4.739072220844032e-06,
  2.680990098425307e-08, -1.251500562864991e-09, -2.939632792448329e-13,  1.324361239251293e-12,  3.340056337162563e-14, -1.151700313237497e-15, -7.147319617697604e-17,
 -1.904837074009763e-20,  9.841000069178502e-20,  1.992397676398441e+00,  9.898138197818105e-05, -9.029733845320855e-07,  5.298576925041116e-09, -2.368379587695022e-10,
 -4.520552091801022e-16,  2.450708362062700e-13,  6.192624336327467e-15, -2.137189688652840e-16, -1.321730458062753e-17, -2.281244519614939e-21,  1.818916264228657e-20,
  3.907010924114373e-01,  1.991568951974496e-02,  1.043043423646584e-04, -1.630597449688185e-05,  2.055270476198386e-09,  2.495717804134662e-08, -1.146760513391435e-10,
 -4.194092806021653e-11,  2.834736824063548e-13,  7.252612439132223e-14, -5.345382042211531e-16, -1.273403402677374e-16,  8.325625241616887e-01,  1.472373159265191e-02,
 -6.589915430604273e-05, -3.282237743460306e-06, -1.315247080012337e-08,  3.054070574948867e-09,  1.133250875693419e-10, -4.190891491145657e-12, -2.618969025871833e-13,
  4.373046750266234e-15,  5.230632646647709e-16, -9.799112894727764e-19,  1.140323637997776e+00,  1.089101363997141e-02, -7.352741901751398e-05, -1.135802693286884e-06,
 -1.507894551961469e-08,  1.404764338510736e-09,  6.099566038372843e-11, -1.756265156099361e-12, -1.222610924277530e-13,  1.326677274009949e-15,  2.200127932225044e-16,
  8.021024917263171e-19,  1.376290197479488e+00,  7.918044770964359e-03, -6.176813862439631e-05, -4.170581854430310e-07, -1.258128912820414e-08,  8.188460811617272e-10,
  3.558935802862603e-11, -9.485598219245401e-13, -6.783945202670065e-14,  6.327740372563601e-16,  1.163498529899315e-16,  5.542930845967023e-19,  1.562100587104339e+00,
  5.565801542607244e-03, -4.676783969360884e-05, -1.336209797938433e-07, -9.437013053434752e-09,  5.065108592712329e-10,  2.144268017576259e-11, -5.532375205553227e-13,
 -3.996998228784095e-14,  3.513081386028422e-16,  6.667583104331432e-17,  3.316362706081545e-19,  1.708468039159102e+00,  3.708241411137817e-03, -3.257305816070737e-05,
 -2.300816455010629e-08, -6.520131852573603e-09,  3.109266816227653e-10,  1.278491359915389e-11, -3.247351728334310e-13, -2.357320612562247e-14,  2.022226973659088e-16,
  3.863356295710610e-17,  1.907121310214026e-19,  1.821558285837061e+00,  2.270888248308581e-03, -2.052045221093576e-05,  1.231881625555796e-08, -4.082080395771708e-09,
  1.802558287429983e-10,  7.225279053072339e-12, -1.820470636798002e-13, -1.324938995911661e-14,  1.125641950543477e-16,  2.145946813178000e-17,  1.037916998205114e-19,
  1.905187389168540e+00,  1.207006771329358e-03, -1.110872772293099e-05,  1.576677284007901e-08, -2.199848222819287e-09,  9.236180577916068e-11,  3.628976590395771e-12,
 -9.104670999822600e-14, -6.636501276205375e-15,  5.618698582295362e-17,  1.066468035385469e-17,  5.051708639922051e-20,  1.961768297368335e+00,  4.868081353766826e-04,
 -4.531472031901033e-06,  8.680200253243838e-09, -8.946663981013278e-10,  3.639839236948513e-11,  1.410375237140618e-12, -3.530671017432732e-14, -2.575872073445722e-15,
  2.178753636237360e-17,  4.118882409563174e-18,  1.919520020656113e-20,  1.992779468980634e+00,  9.194979978311919e-05, -8.609760761128499e-07,  1.868420153065893e-09,
 -1.697095053159387e-10,  6.791773839103077e-12,  2.611431033470117e-13, -6.530774787737769e-15, -4.766854013795194e-16,  4.031491634407723e-18,  7.602483640081044e-19,
  3.509200568896191e-21,  4.708408317138186e-01,  2.000315001711218e-02, -7.616845097251766e-05, -1.278279656949264e-05,  3.927782670976809e-07,  1.116733717821665e-08,
 -8.523268884642726e-10, -3.984126281202289e-12,  1.522851278648538e-12, -1.664605876948790e-14, -2.404051661566554e-15,  6.337887751343049e-17,  8.901555815799774e-01,
  1.404075899443744e-02, -1.041975884277678e-04, -2.910022659615072e-06,  6.181986371794325e-08,  3.691398832966999e-09, -7.334815503295825e-11, -6.891509732201677e-12,
  1.450300425667042e-13,  1.240279517296143e-14, -2.966547331482022e-16, -2.242428130753072e-17,  1.182622473308612e+00,  1.024671470157762e-02, -8.748227914789505e-05,
 -1.096302945991152e-06,  2.178403208295701e-08,  1.937140723361197e-09, -2.482270241649260e-11, -3.451404535978909e-12,  4.542976614968361e-14,  5.872326858782104e-15,
 -8.082019168686988e-17, -1.013129004995823e-17,  1.406939505674091e+00,  7.401944040059453e-03, -6.732396405853802e-05, -4.538041260752731e-07,  9.119374830420906e-09,
  1.160338445786220e-09, -1.204652645477536e-11, -1.968506984874343e-12,  2.067277450829096e-14,  3.232922519305434e-15, -3.378145754119354e-17, -5.370798509999318e-18,
  1.583602929499737e+00,  5.183594062286461e-03, -4.887234197814769e-05, -1.831523659720465e-07,  3.951811198245778e-09,  7.198571378262028e-10, -6.657482004412628e-12,
 -1.175539379339175e-12,  1.085266058514708e-14,  1.888466200926402e-15, -1.685247434704829e-17, -3.057354238980760e-18,  1.722776317646210e+00,  3.445339037256165e-03,
 -3.322761830694991e-05, -6.534772817129812e-08,  1.655693267901086e-09,  4.402688551975383e-10, -3.802343262723393e-12, -6.984748739316073e-13,  5.953087827924915e-15,
  1.105987671829393e-15, -8.960697496964242e-18, -1.758842062637655e-18,  1.830313304386163e+00,  2.106529045537896e-03, -2.062160889997687e-05, -1.722238425964359e-08,
  6.332858570733065e-10,  2.539579146414191e-10, -2.102623547960533e-12, -3.942994045471628e-13,  3.191559883050922e-15,  6.183324272970808e-16, -4.712384187916591e-18,
 -9.711410456336518e-19,  1.909838246828582e+00,  1.118460643753194e-03, -1.105772277998770e-05, -1.167233159613979e-09,  2.060832617730450e-10,  1.295342259610134e-10,
 -1.044677210465795e-12, -1.980198830250324e-13,  1.550096584773708e-15,  3.085377741913542e-16, -2.261802383253265e-18, -4.804589371154173e-19,  1.963643427726328e+00,
  4.507946501453722e-04, -4.484496808125101e-06,  1.544832904950548e-09,  5.064122381740473e-11,  5.087495977159844e-11, -4.039178313690355e-13, -7.697622993345615e-14,
  5.902579188697125e-16,  1.194537317078420e-16, -8.552930715222490e-19, -1.849976241385410e-19,  1.993133585279535e+00,  8.511762778639049e-05, -8.494982350744615e-07,
  4.908157646807154e-10,  6.385266364234808e-12,  9.474643303847572e-12, -7.462817316407167e-14, -1.425588364630822e-14,  1.081524417024167e-16,  2.207586709592426e-17,
 -1.561702891509092e-19, -3.408953266074233e-20,  5.488275556588401e-01,  1.889699032869332e-02, -1.879763837379547e-04, -5.774157858302694e-06,  4.267609313251799e-07,
 -6.169037540773561e-09, -4.640357280674683e-10,  2.361290005012018e-11,  6.807156055084551e-14, -4.021008393178413e-14,  9.920295279488052e-16,  3.948160280168507e-17,
  9.444603141326621e-01,  1.308902938002875e-02, -1.312038615895163e-04, -1.477914664647573e-06,  1.064602022295581e-07,  4.356860940226121e-10, -1.582375009927726e-10,
  1.396106407509499e-12,  2.525993714878383e-13, -6.583982562712964e-15, -3.354500977838047e-16,  1.748810029967009e-17,  1.222138103106452e+00,  9.502749826092553e-03,
 -9.745091144295869e-05, -4.979503326299709e-07,  4.827979780328746e-08,  5.013415131913237e-10, -7.775220644252211e-11,  1.171415799326950e-13,  1.277971583484327e-13,
 -1.998640440362489e-15, -1.846252201386753e-16,  5.996374003974609e-18,  1.435441205960381e+00,  6.845628559726599e-03, -7.122451367995812e-05, -1.541381109927076e-07,
  2.574712873947710e-08,  3.730567621315708e-10, -4.446285454133658e-11, -6.469053904175370e-14,  7.256135220612519e-14, -8.449430391842113e-16, -1.057705232206206e-16,
  2.750349842540280e-18,  1.603544256361356e+00,  4.785886519610380e-03, -5.027111490120922e-05, -2.319994936011832e-08,  1.451899633780060e-08,  2.568841285198186e-10,
 -2.669248817970559e-11, -7.987132870525555e-14,  4.311267052429730e-14, -4.128561718528773e-16, -6.272745771135020e-17,  1.430844341234987e-18,  1.736022506341773e+00,
  3.177438791965106e-03, -3.359463627435424e-05,  2.078610623737749e-08,  8.212011552582179e-09,  1.669046395126866e-10, -1.594125714631670e-11, -6.204975315583154e-14,
  2.551266488216432e-14, -2.130798611685748e-16, -3.698529522676607e-17,  7.754164212560443e-19,  1.838408874855991e+00,  1.941252998169788e-03, -2.061798716254316e-05,
  2.749137418225739e-08,  4.449787248846221e-09,  1.000073571816208e-10, -9.037821951856400e-12, -4.023665902119255e-14,  1.435902330917885e-14, -1.088334929874439e-16,
 -2.074499976524024e-17,  4.111138050399230e-19,  1.914135394267188e+00,  1.030178398273040e-03, -1.097551337268781e-05,  1.982697682988577e-08,  2.164233467541215e-09,
  5.227241551164577e-11, -4.553914695431770e-12, -2.188328392614891e-14,  7.195946529091371e-15, -5.098028683510728e-17, -1.036822390714906e-17,  1.979124922305923e-19,
  1.965375084813141e+00,  4.150771895883556e-04, -4.431034818597280e-06,  9.319701972281630e-09,  8.225131605557091e-10,  2.084194185911398e-11, -1.774302782249376e-12,
 -8.906319628177739e-15,  2.793435931674031e-15, -1.894202068297518e-17, -4.017387577563774e-18,  7.489762749840687e-20,  1.993460521011071e+00,  7.836009177240725e-05,
 -8.373926374641135e-07,  1.891386840067421e-09,  1.504055547195797e-10,  3.911932719022099e-12, -3.290158895984654e-13, -1.687649248838345e-15,  5.169612313570424e-16,
 -3.424360813500382e-18, -7.427026065778423e-19,  1.367626929297333e-20,  6.211169435864111e-01,  1.721987432176806e-02, -2.217351710809317e-04, -3.229458980248281e-07,
  2.423155142951859e-07, -1.014438447100503e-08,  7.406353401987147e-11,  1.165183738868205e-11, -5.454798353939315e-13,  3.295423868290716e-15,  6.744186196121439e-16,
 -2.945425389991296e-17,  9.946450597117944e-01,  1.199685844818823e-02, -1.390310050254041e-04,  1.151311120948246e-07,  8.394073103339209e-08, -2.252956245916869e-09,
 -5.121547473582146e-11,  4.605897922393070e-12, -4.537282793591476e-14, -5.981459741910119e-15,  2.413470211432639e-16,  2.622301302361268e-18,  1.258570800030331e+00,
  8.712511474131652e-03, -9.876858305440813e-05,  2.615453999476112e-07,  4.187963641951124e-08, -9.659110051975405e-10, -3.472106719345774e-11,  2.233516299810298e-12,
 -2.763349574552541e-15, -3.337330904203629e-15,  8.935290596482572e-17,  2.821942108890468e-18,  1.461682590266053e+00,  6.275641535538294e-03, -7.053561754994258e-05,
  2.630397998464472e-07,  2.354393855834331e-08, -5.034750103794067e-10, -2.244707459631290e-11,  1.254434346431645e-12,  3.512912122955181e-15, -1.954463719224063e-15,
  4.190282969764694e-17,  1.902532174286492e-18,  1.621887514364672e+00,  4.386724061378611e-03, -4.909489195805492e-05,  2.171272507803044e-07,  1.376614043192576e-08,
 -2.818051508977798e-10, -1.436855935992094e-11,  7.420872245352373e-13,  3.795040100691203e-15, -1.176993936724638e-15,  2.186657042955965e-17,  1.214422253609614e-18,
  1.748199648612397e+00,  2.912034973996356e-03, -3.251201605074208e-05,  1.589904897898467e-07,  7.999917026191126e-09, -1.593947793712137e-10, -8.917057973858658e-12,
  4.382345229633847e-13,  2.879778684577535e-15, -7.012882116026806e-16,  1.180572169048750e-17,  7.457200672294457e-19,  1.845847902916813e+00,  1.778916055066047e-03,
 -1.983207753476208e-05,  1.033613961008338e-07,  4.425457393077130e-09, -8.666540101592935e-11, -5.180663305978815e-12,  2.463865178994200e-13,  1.855093476412137e-15,
 -3.961974830166363e-16,  6.223774633661829e-18,  4.286729227896859e-19,  1.918082894544250e+00,  9.439562483726771e-04, -1.051409729416007e-05,  5.709440001456454e-08,
  2.185787431930011e-09, -4.233698439072682e-11, -2.651937798692150e-12,  1.234074290350796e-13,  1.006990154418542e-15, -1.989861532284892e-16,  2.979917422051325e-18,
  2.175533133886108e-19,  1.966965544287658e+00,  3.803168884476964e-04, -4.233806732365337e-06,  2.358059841106348e-08,  8.395041095739490e-10, -1.615264438099109e-11,
 -1.043367090431009e-12,  4.789288488461654e-14,  4.096702606410918e-16, -7.734111264020827e-17,  1.123010162397786e-18,  8.507738801036556e-20,  1.993760768978544e+00,
  7.179585268917711e-05, -7.990345566500079e-07,  4.509149774072377e-09,  1.544108080358813e-10, -2.960901002540556e-12, -1.944552170150834e-13,  8.862090980151687e-15,
  7.762825003917158e-17, -1.432164024201654e-17,  2.045605543447295e-19,  1.580284637533879e-20,  6.864981551098703e-01,  1.548202513285545e-02, -2.085071614832225e-04,
  2.105780344087882e-06,  7.438906298736471e-08, -6.186752776311140e-09,  1.974929956503587e-10, -9.547403108544136e-13, -2.074863772550188e-13,  9.934688966021844e-15,
 -1.558025270854243e-16, -5.964613929259439e-18,  1.040444162288527e+00,  1.090930906180360e-02, -1.311859352798383e-04,  1.069930431440104e-06,  3.558668180661308e-08,
 -2.231364452613942e-09,  3.808892689054171e-11,  1.493169370586460e-12, -1.028558539267556e-13,  1.609449924597358e-15,  8.334236470456724e-17, -5.234606079833235e-18,
  1.291874324622241e+00,  7.944646625199454e-03, -9.233865104851850e-05,  7.517287180195195e-07,  1.887163792541555e-08, -1.142074727913728e-09,  1.405883914353055e-11,
  9.997135678642839e-13, -5.148839013482112e-14,  3.627546869765134e-16,  5.725107068079289e-17, -2.411265022470640e-18,  1.485684440392920e+00,  5.729488736875591e-03,
 -6.551439796758888e-05,  5.413887813912301e-07,  1.077239878775622e-08, -6.590229371864788e-10,  6.502274859995763e-12,  6.431578965071119e-13, -2.910223823570241e-14,
  7.751491542878025e-17,  3.612623230681998e-17, -1.265119725696101e-18,  1.638670004308740e+00,  4.007615906672142e-03, -4.539554911458009e-05,  3.804438157087981e-07,
  6.297036027698111e-09, -3.950366678175710e-10,  3.305720395878383e-12,  4.100618961612126e-13, -1.722018020301482e-14,  1.399911329229424e-19,  2.259387950006879e-17,
 -7.078627171945560e-19,  1.759342361997158e+00,  2.661449100501097e-03, -2.996772393412808e-05,  2.539597931718045e-07,  3.636109924405775e-09, -2.347527743735191e-10,
  1.730032589493990e-12,  2.536469665118508e-13, -1.015496937415576e-14, -1.759692013432524e-17,  1.376325206685604e-17, -4.005354405869828e-19,  1.852655593946675e+00,
  1.626260499853300e-03, -1.823960372228939e-05,  1.558663326736248e-07,  1.994686647528205e-09, -1.323458908500919e-10,  8.843314605657798e-13,  1.469786267298122e-13,
 -5.699778956960971e-15, -1.659300722219481e-17,  7.884135219221413e-18, -2.181323507459585e-19,  1.921695566474704e+00,  8.630975526745914e-04, -9.655068782119462e-06,
  8.300132873020334e-08,  9.772716990725605e-10, -6.635357688643458e-11,  4.122007137553981e-13,  7.508863343186424e-14, -2.850638110342504e-15, -1.055766490141982e-17,
  3.994859582043266e-18, -1.067933992076785e-19,  1.968421144693372e+00,  3.477755267332032e-04, -3.884068839138805e-06,  3.352144778553106e-08,  3.729552016866958e-10,
 -2.575650913535728e-11,  1.522361967417894e-13,  2.950269221064304e-14, -1.105102277644801e-15, -4.648035327487969e-18,  1.561117863428696e-18, -4.082645461467890e-20,
  1.994035562329614e+00,  6.565628760403692e-05, -7.326460295045576e-07,  6.336478909450467e-09,  6.833644931958104e-11, -4.765841104774633e-12,  2.740534861035064e-14,
  5.494409939358595e-15, -2.043620973910901e-16, -9.136237470762069e-19,  2.898865109814212e-19, -7.493489339654001e-21,  7.452683503868205e-01,  1.392746170671762e-02,
 -1.793945581168145e-04,  2.544816820431741e-06, -6.768774056354186e-09, -2.237496452684696e-09,  1.215155787250298e-10, -3.294602786362838e-12,  1.720890975215069e-14,
  2.762599646883352e-15, -1.389538737215236e-16,  3.167195570942798e-18,  1.082073395442362e+00,  9.917835085177032e-03, -1.162177269900681e-04,  1.340323475512458e-06,
  1.844439964321405e-09, -1.120561116486265e-09,  4.491208944532476e-11, -5.945796939435961e-13, -2.748459655779753e-14,  1.777800796243882e-15, -3.873456289800640e-17,
 -5.138220719758589e-19,  1.322237774592798e+00,  7.245571184946433e-03, -8.218209613463928e-05,  8.957143088564151e-07,  8.025169534590047e-10, -6.318803418056199e-10,
  2.298987986575545e-11, -1.840149560040919e-13, -1.936441680740654e-14,  9.483119220994488e-16, -1.350052251219396e-17, -5.825982591761372e-19,  1.507598224159613e+00,
  5.233366744796086e-03, -5.837867001820284e-05,  6.211218855344475e-07,  1.060239940568188e-10, -3.821858098418592e-10,  1.327036753280663e-11, -6.830113508203923e-14,
 -1.272006500209993e-14,  5.505196019049002e-16, -5.659593321950830e-18, -4.226761012151016e-19,  1.654004732962303e+00,  3.663868146765148e-03, -4.046439820473488e-05,
  4.251338992947261e-07, -1.842858511940814e-10, -2.354621812463964e-10,  7.964698596849399e-12, -2.663960787772818e-14, -8.198328110911488e-15,  3.303063728254039e-16,
 -2.586845750738874e-18, -2.830267637605981e-19,  1.769528931549094e+00,  2.434553607919391e-03, -2.671371578258404e-05,  2.786099941000015e-07, -2.497156818330733e-10,
 -1.423883764149490e-10,  4.741219797725337e-12, -1.009002561101088e-14, -5.103343651646045e-15,  1.963632831032764e-16, -1.217571661169420e-18, -1.794286414520898e-19,
  1.858881165016802e+00,  1.488179606270567e-03, -1.625837967102709e-05,  1.687980401694360e-07, -2.091362503561122e-10, -8.120641190152021e-11,  2.677677426358035e-12,
 -3.443431171289124e-15, -2.968812030250111e-15,  1.107627310770512e-16, -5.630827999210358e-19, -1.054042859598060e-19,  1.925000033829697e+00,  7.900123269590826e-04,
 -8.605771754507941e-06,  8.909244208042509e-08, -1.320873224362698e-10, -4.102620977238794e-11,  1.344575316421658e-12, -9.543152076505779e-16, -1.520456911328319e-15,
  5.556787801187686e-17, -2.403928115874772e-19, -5.427897088003781e-20,  1.969752743909707e+00,  3.183766956880442e-04, -3.461766819882644e-06,  3.577670086347985e-08,
 -5.876097926309229e-11, -1.600155296216786e-11,  5.225314552503430e-13, -1.776032193183393e-16, -5.982861851792524e-16,  2.158209480244991e-17, -8.294042674976473e-20,
 -2.142358050756995e-20,  1.994286963952035e+00,  6.011105234747487e-05, -6.529662797677094e-07,  6.742338403984989e-09, -1.165290922899076e-11, -2.968255734919198e-12,
  9.675160038766795e-14, -1.388564375771331e-17, -1.115062737096700e-16,  3.994881288940316e-18, -1.433210947930544e-20, -3.998757452349974e-21,  7.982953231845835e-01,
  1.261009573942204e-02, -1.505511206753013e-04,  2.207580982509728e-06, -2.923400766506518e-08, -3.057827550018841e-10,  4.580036173222579e-11, -1.966319022191785e-12,
  4.779245353990348e-14, -3.248921694369913e-16, -2.856361803604075e-17,  1.520968269102670e-18,  1.119986018484008e+00,  9.051574662144329e-03, -1.005249766249455e-04,
  1.242310914305509e-06, -1.143913559487278e-08, -2.936748669124047e-10,  2.339355873539337e-11, -7.523463146744014e-13,  9.061541452680731e-15,  3.654469243308021e-16,
 -2.402739379383400e-17,  6.354938183692614e-19,  1.349972492104995e+00,  6.630548758887172e-03, -7.168343847313098e-05,  8.347818878340597e-07, -6.978983273042746e-09,
 -1.848981396897344e-10,  1.339115643286984e-11, -3.860874680203735e-13,  2.623438081663973e-15,  2.794370036832591e-16, -1.382917946320614e-17,  2.783640310015790e-19,
  1.527644247061972e+00,  4.795705742172750e-03, -5.111451536236047e-05,  5.777094461532972e-07, -4.675416420575469e-09, -1.164907113039356e-10,  8.195481395129464e-12,
 -2.226457992401997e-13,  8.383039343039149e-16,  1.897697204782288e-16, -8.327937504845240e-18,  1.402743399682956e-19,  1.668044624143917e+00,  3.360215869141519e-03,
 -3.550393575126706e-05,  3.942405469177147e-07, -3.153008802189980e-09, -7.305161020149650e-11,  5.098258392824310e-12, -1.334715544514556e-13,  2.396181696533606e-16,
  1.245425956132656e-16, -5.103928800233650e-18,  7.559546747608920e-20,  1.778860568383511e+00,  2.233971424784950e-03, -2.346920816008438e-05,  2.576649564595438e-07,
 -2.052260636091407e-09, -4.451974043825710e-11,  3.107515811292335e-12, -7.938068694330233e-14,  3.505299803401341e-17,  7.838911772502400e-17, -3.075349718124431e-18,
  4.138227608382972e-20,  1.864586362598320e+00,  1.366056449579097e-03, -1.429562321947114e-05,  1.557689033357456e-07, -1.239384897318508e-09, -2.546782863040967e-11,
  1.783482622286963e-12, -4.480366726805331e-14, -2.265537288616123e-17,  4.592927457192379e-17, -1.750200476670403e-18,  2.192494445937727e-20,  1.928029042784793e+00,
  7.253553252215741e-04, -7.570954593659590e-06,  8.208249189390287e-08, -6.531709470145784e-10, -1.287740908443659e-11,  9.053448080835919e-13, -2.248892260969728e-14,
 -2.604239627434902e-17,  2.363215716287824e-17, -8.832173487573580e-19,  1.050706526724953e-20,  1.970973532235021e+00,  2.923638283055314e-04, -3.046520558265248e-06,
  3.292573399549422e-08, -2.621164408168297e-10, -5.022381396875639e-12,  3.542757903831404e-13, -8.737651498432010e-15, -1.379109129989981e-17,  9.325943640971891e-18,
 -3.442974861509296e-19,  3.957295874158770e-21,  1.994517463698843e+00,  5.520406822053879e-05, -5.747415571351732e-07,  6.201359260149453e-09, -4.938432348744457e-11,
 -9.314347057267195e-13,  6.583710367856651e-14, -1.617671637630748e-15, -2.915032134553555e-18,  1.740746123670760e-18, -6.385263502522913e-20,  7.203160982231567e-22,
  8.464832154443540e-01,  1.150354127635562e-02, -1.269190494227363e-04,  1.734831076520443e-06, -2.798988291299871e-08,  2.895282189961744e-10,  9.429019669679581e-12,
 -7.443326333902819e-13,  2.711925193511751e-14, -6.074193971818260e-16,  5.128872040736965e-18,  2.363639552464591e-19,  1.154673561566211e+00,  8.303613337609563e-03,
 -8.682833691263451e-05,  1.036329891151037e-06, -1.320360797312778e-08,  5.454098464385025e-11,  7.335756653997129e-12, -3.877231136363155e-13,  1.084849167963932e-14,
 -1.309760758069929e-16, -3.687557843295569e-18,  2.604427789248722e-19,  1.375408266934420e+00,  6.095067660035241e-03, -6.241094562465065e-05,  7.075779595047064e-07,
 -8.262214353509120e-09,  2.232670587641551e-11,  4.646453697712715e-12, -2.240738353328377e-13,  5.624063703237530e-15, -4.084490733320630e-17, -3.145165028736488e-18,
  1.617431818902176e-19,  1.546051190046814e+00,  4.413130242697420e-03, -4.467863268250359e-05,  4.929469134272632e-07, -5.508170522521865e-09,  1.275524260451275e-11,
  2.980160502467910e-12, -1.379324070716414e-13,  3.253939782507294e-15, -1.422920041799488e-17, -2.226609686830826e-18,  1.012118966858406e-19,  1.680946076742319e+00,
  3.094176365732980e-03, -3.110576085977211e-05,  3.375378469423829e-07, -3.675671361116139e-09,  8.239607255418576e-12,  1.903605806510584e-12, -8.615779657645389e-14,
  1.953102562579876e-15, -4.784210150172656e-18, -1.494474279259576e-18,  6.347248290841696e-20,  1.787439680711571e+00,  2.057982469475007e-03, -2.059250439155621e-05,
  2.210302576027511e-07, -2.367934144242503e-09,  5.375522031696235e-12,  1.179450182430403e-12, -5.267671968760171e-14,  1.162173332269412e-15, -1.287667496224921e-18,
 -9.537267699161513e-19,  3.882096093848092e-20,  1.869833186408697e+00,  1.258805588100890e-03, -1.255578770793758e-05,  1.337768020357818e-07, -1.417843869183476e-09,
  3.299644139462204e-12,  6.841099314759660e-13, -3.030248385906597e-14,  6.560861634518946e-16, -1.049577447453157e-19, -5.638411643526424e-19,  2.231644164960804e-20,
  1.930815298848308e+00,  6.685370404286463e-04, -6.653915540247066e-06,  7.054403576362000e-08, -7.423940193757695e-10,  1.769686051086522e-12,  3.496585106998236e-13,
 -1.540836291030886e-14,  3.293468155695745e-16,  1.637364868681014e-19, -2.918262160945480e-19,  1.133776404824658e-20,  1.972096638143567e+00,  2.694957653480274e-04,
 -2.678615745179527e-06,  2.830930569480056e-08, -2.966095133734730e-10,  7.199919880478677e-13,  1.374054753637659e-13, -6.036384659488204e-15,  1.279659121595543e-16,
  1.180287925848522e-19, -1.155859955584342e-19,  4.438547887816799e-21,  1.994729535190857e+00,  5.088943532183461e-05, -5.054440307170493e-07,  5.333025410881189e-09,
 -5.574793114811335e-11,  1.367436383638769e-13,  2.559064367374709e-14, -1.122472079201986e-15,  2.369164105279378e-17,  2.722438620299218e-20, -2.161612642281958e-20,
  8.250062198027215e-22,  8.905884202862493e-01,  1.056433862679919e-02, -1.085728341881179e-04,  1.340049082906407e-06, -2.119716851795888e-08,  3.453337838375287e-10,
 -2.195020331192471e-12, -1.753109999258644e-13,  1.016383955903837e-14, -3.259854368766530e-16,  6.824001241575284e-18, -6.631352767381438e-20,  1.186572620816488e+00,
  7.655268473373154e-03, -7.560146270529771e-05,  8.403170687191561e-07, -1.104954850770073e-08,  1.346253595179490e-10,  5.294356731330623e-13, -1.277018134629575e-13,
  5.406312419159832e-15, -1.369094129230338e-16,  1.714006417275681e-18,  2.843894387605909e-20,  1.398840648770784e+00,  5.627560631487357e-03, -5.468381896890801e-05,
  5.832229006613738e-07, -7.111611984550307e-09,  7.695031658001011e-11,  5.633924627432046e-13, -8.100996256500444e-14,  3.154185757839564e-15, -7.214285406627897e-17,
  6.058156787003447e-19,  2.831071187475955e-20,  1.563024252121442e+00,  4.077903351716003e-03, -3.927414830043961e-05,  4.096311207293187e-07, -4.793495463738355e-09,
  4.879525505553325e-11,  4.180883630340170e-13, -5.221776823601062e-14,  1.951656792482192e-15, -4.205947057119112e-17,  2.466313621674741e-19,  2.108858356141511e-20,
  1.692849363906853e+00,  2.860557391474971e-03, -2.739663826323609e-05,  2.818294385982517e-07, -3.214718204569694e-09,  3.158391747349332e-11,  2.845668794578747e-13,
 -3.351918098837527e-14,  1.223080926684218e-15, -2.535259247755452e-17,  1.053242453764306e-19,  1.453351765086436e-20,  1.795358040211911e+00,  1.903223780864622e-03,
 -1.816012666429798e-05,  1.851129691415751e-07, -2.076014676395192e-09,  1.995072721298147e-11,  1.820481231789747e-13, -2.085679038208297e-14,  7.494726216024072e-16,
 -1.512509231028237e-17,  4.464136440550008e-20,  9.424469667765861e-21,  1.874677151111465e+00,  1.164404467871492e-03, -1.108219967237270e-05,  1.122642875055182e-07,
 -1.244576471727900e-09,  1.179119013473939e-11,  1.074152191066263e-13, -1.213947330487096e-14,  4.318213537234057e-16, -8.552943343947066e-18,  1.793071194529889e-20,
  5.629582064349732e-21,  1.933388067120419e+00,  6.184949079333189e-04, -5.876362329312384e-06,  5.927902383681464e-08, -6.520751341342988e-10,  6.121121038379144e-12,
  5.541359332234322e-14, -6.221097553261200e-15,  2.198174169731292e-16, -4.298140684939138e-18,  6.453210114921983e-21,  2.933403694371184e-21,  1.973133803563146e+00,
  2.493470146680582e-04, -2.366460367589621e-06,  2.380859146631748e-08, -2.606040411778980e-10,  2.432492561360625e-12,  2.188264773400677e-14, -2.449172801560512e-15,
  8.617768400064087e-17, -1.671144672852346e-18,  1.863966190230948e-21,  1.166740665075625e-21,  1.994925390220158e+00,  4.708708261556893e-05, -4.466267381368700e-07,
  4.487128510243812e-09, -4.898719493911695e-11,  4.559111611814122e-13,  4.084634123281819e-15, -4.565998633000188e-16,  1.603100865748133e-17, -3.095044668263787e-19,
  2.814003524762570e-22,  2.186735112513294e-22,  9.312029746780252e-01,  9.754812960907005e-03, -9.431176136208782e-05,  1.052156135164607e-06, -1.506461897805030e-08,
  2.613842507610840e-10, -3.975948751266567e-12,  8.401305002103103e-15,  2.539270271467786e-15, -1.202454265857068e-16,  3.473145987003180e-18, -6.851050888748342e-20,
  1.216043961937719e+00,  7.087990834900565e-03, -6.648991793508063e-05,  6.848373276674972e-07, -8.436065335423273e-09,  1.199235249780093e-10, -1.264225079955934e-12,
 -1.937471663633348e-14,  1.796846530573613e-15, -6.531378297242003e-17,  1.530019519029154e-18, -1.988172263409397e-20,  1.420517700700987e+00,  5.216269061802850e-03,
 -4.831636829344759e-05,  4.818890572742066e-07, -5.571616087092868e-09,  7.246561283014087e-11, -6.400311772669982e-13, -1.555205190841643e-14,  1.142599029667530e-15,
 -3.848529881792010e-17,  8.219328829023074e-19, -7.896983738924396e-21,  1.578736870200807e+00,  3.782144327361139e-03, -3.478586942816077e-05,  3.409004924290855e-07,
 -3.804789782200096e-09,  4.704212118301544e-11, -3.766586277497135e-13, -1.095562932929375e-14,  7.388126215818943e-16, -2.394122374242270e-17,  4.841018394364691e-19,
 -3.632638905384292e-21,  1.703873496587802e+00,  2.654086816261896e-03, -2.430195354278726e-05,  2.355685880905199e-07, -2.571306609748939e-09,  3.078190490931285e-11,
 -2.324301531300531e-13, -7.362535710959077e-15,  4.755161870915934e-16, -1.505382433463641e-17,  2.936237279910248e-19, -1.784049487986027e-21,  1.802693685637192e+00,
  1.766294572072552e-03, -1.612457072739178e-05,  1.551702431313764e-07, -1.668646786740657e-09,  1.954604604193547e-11, -1.422745411101988e-13, -4.706559625471978e-15,
  2.965140648440976e-16, -9.245126433639670e-18,  1.758861748596059e-19, -8.913246092558067e-22,  1.879165532154364e+00,  1.080815392155667e-03, -9.846527513177588e-06,
  9.428672764675394e-08, -1.003595250289897e-09,  1.158109287276874e-11, -8.234203392093654e-14, -2.786031993158206e-15,  1.728682393725305e-16, -5.334869480104757e-18,
  9.973360377182630e-20, -4.337631215183961e-22,  1.935772292325296e+00,  5.741615694209126e-04, -5.223470533661669e-06,  4.985076119616056e-08, -5.269397297455181e-10,
  6.019084877216200e-12, -4.215970356808582e-14, -1.443114608640832e-15,  8.869776787964769e-17, -2.718521187560726e-18,  5.021197278696226e-20, -1.932411786836877e-22,
  1.974095042628313e+00,  2.314910471944090e-04, -2.104129106159158e-06,  2.003825943701078e-08, -2.108744463922438e-10,  2.393157476727120e-12, -1.661070682181420e-14,
 -5.718447124953410e-16,  3.494809150200469e-17, -1.066483093109231e-18,  1.954555262748252e-20, -6.886634779480576e-23,  1.995106915668935e+00,  4.371683615925568e-05,
 -3.971754590047168e-07,  3.778173436743627e-09, -3.966688934551939e-11,  4.486243823386293e-13, -3.099406715168553e-15, -1.069654795159278e-16,  6.518325328155037e-18,
 -1.984599791142876e-19,  3.622162621695219e-21, -1.213284287783687e-23,  9.687878998795405e-01,  9.047089323813751e-03, -8.297585060754187e-05,  8.479613579224124e-07,
 -1.073857177111079e-08,  1.747909128688957e-10, -3.093724510717405e-12,  4.195559543298906e-14,  8.253252241370952e-17, -3.085647459502394e-17,  1.257416377104816e-18,
 -3.323074361314160e-20,  1.243381120962120e+00,  6.586820120733203e-03, -5.900819841373409e-05,  5.673079247857412e-07, -6.359192047123264e-09,  8.777607115155446e-11,
 -1.281102643742401e-12,  1.057452787572024e-14,  3.339360669101894e-16, -2.154328583475697e-17,  6.967302819385923e-19, -1.529804403390326e-20,  1.440644336917799e+00,
  4.851457552312256e-03, -4.302370810122780e-05,  4.034150593924635e-07, -4.294497095732392e-09,  5.493882513225363e-11, -7.311003308678634e-13,  4.411944286897257e-15,
  2.520080013547345e-16, -1.374731726857207e-17,  4.146586621851034e-19, -8.382744704115681e-21,  1.593333410814189e+00,  3.519253651505334e-03, -3.103105556731296e-05,
  2.869942382337955e-07, -2.968308934595110e-09,  3.632049607914637e-11, -4.576150705009072e-13,  2.234403197938242e-15,  1.749395315606078e-16, -8.915519299771457e-18,
  2.593841428217704e-19, -4.992404824585700e-21,  1.714117987335431e+00,  2.470323661803251e-03, -2.170277115582724e-05,  1.990048856140350e-07, -2.021109457297512e-09,
  2.402442580080236e-11, -2.920828321425245e-13,  1.231929914285602e-15,  1.170428108908175e-16, -5.750907016906851e-18,  1.636593510282191e-19, -3.049383017093433e-21,
  1.809512060431502e+00,  1.644320654249952e-03, -1.441050214198186e-05,  1.313847365597781e-07, -1.318141914156728e-09,  1.536048986918435e-11, -1.822428227731284e-13,
  6.943502178967852e-16,  7.474016107206233e-17, -3.591925651598444e-18,  1.007401052716262e-19, -1.835270512931017e-21,  1.883338051908747e+00,  1.006312769626253e-03,
 -8.804186049600265e-06,  7.995751416202174e-08, -7.954810093244976e-10,  9.142478205504828e-12, -1.066426702466591e-13,  3.788276266119381e-16,  4.424937783222293e-17,
 -2.096624597218130e-18,  5.822284611821459e-20, -1.044042641565765e-21,  1.937988960940239e+00,  5.346320575216615e-04, -4.672079009981820e-06,  4.231880747616523e-08,
 -4.186271929226645e-10,  4.765832285467652e-12, -5.494836179109887e-14,  1.862346349485250e-16,  2.293292487977792e-17, -1.076692386332712e-18,  2.970043296323417e-20,
 -5.267950951796769e-22,  1.974988787278310e+00,  2.155659706068548e-04, -1.882414909375183e-06,  1.702193944725617e-08, -1.677734044732140e-10,  1.898392092568469e-12,
 -2.172516888341176e-14,  7.149355886782729e-17,  9.092265636726832e-18, -4.244719080521315e-19,  1.165942964429566e-20, -2.053497092248322e-22,  1.995275700976865e+00,
  4.071064747118011e-05, -3.553643258614933e-07,  3.210572145915349e-09, -3.158356229929570e-11,  3.562194560380484e-13, -4.060480404804354e-15,  1.315848138085801e-17,
  1.701333499853788e-18, -7.919442987565930e-20,  2.170457221064760e-21, -3.808358137785531e-23,  1.003709284682339e+00,  8.421305212930148e-03, -7.372784158334313e-05,
  7.004710866409539e-07, -7.891843335008744e-09,  1.141957984767343e-10, -1.993991856284757e-12,  3.414296123466564e-14, -4.049018238935711e-16, -2.305987234273153e-18,
  3.257335802174117e-19, -1.178422426923012e-20,  1.268825106657333e+00,  6.140378740965661e-03, -5.275815423158571e-05,  4.780493328713460e-07, -4.883348055842363e-09,
  6.123640681036798e-11, -9.204441309652605e-13,  1.308352469469378e-14, -7.654727155936914e-17, -4.355229062758342e-18,  2.262317036030033e-19, -6.652359179115758e-21,
  1.459390900863422e+00,  4.525541278114310e-03, -3.856168418680334e-05,  3.425934947950706e-07, -3.358045858301586e-09,  3.942684858747491e-11, -5.500323359830241e-13,
  7.117060726835464e-15, -2.109487053249267e-17, -3.203999449984947e-18,  1.449913370167189e-19, -3.998060660246624e-21,  1.606934668335794e+00,  3.284025021176925e-03,
 -2.784996530741396e-05,  2.447453226208694e-07, -2.344419520274088e-09,  2.648623361919200e-11, -3.529351700752982e-13,  4.312284770179687e-15, -5.691843096823012e-18,
 -2.210441595327144e-18,  9.432300256330819e-20, -2.514795633018304e-21,  1.723666431036527e+00,  2.305738109757195e-03, -1.949407084247343e-05,  1.701474536373798e-07,
 -1.606406467076810e-09,  1.769939722393394e-11, -2.286743348954279e-13,  2.689572104299090e-15, -8.137957170950756e-19, -1.476139773798918e-18,  6.097396889326786e-20,
 -1.592249287715951e-21,  1.815868282983412e+00,  1.535006421855231e-03, -1.295103187540449e-05,  1.125246855848910e-07, -1.052116527669243e-09,  1.139487711648937e-11,
 -1.440621471164218e-13,  1.650270977897097e-15,  5.877491578402714e-19, -9.421979370506022e-19,  3.814177448252739e-20, -9.823855800473772e-22,  1.887228224532884e+00,
  9.395138910946868e-04, -7.915463358399919e-06,  6.855928543348706e-08, -6.367837926308773e-10,  6.814578615696424e-12, -8.483950416736946e-14,  9.540501879815201e-16,
  7.546737193974003e-19, -5.578556431652661e-19,  2.228789461489195e-20, -5.686744246300827e-22,  1.940055800363349e+00,  4.991796536375678e-04, -4.201520602234584e-06,
  3.631453109298349e-08, -3.357727659420063e-10,  3.563894648233845e-12, -4.389775462975282e-14,  4.874042700299774e-16,  5.242700582751298e-19, -2.891799640054019e-19,
  1.145437029736475e-20, -2.904028208837983e-22,  1.975822165343471e+00,  2.012807768003837e-04, -1.693093764715667e-06,  1.461409767207694e-08, -1.347370774317708e-10,
  1.422572242987173e-12, -1.740141095613714e-14,  1.916359923238359e-16,  2.399002091290241e-19, -1.146763850212671e-19,  4.517974283240469e-21, -1.140809856915523e-22,
  1.995433090284637e+00,  3.801375762206790e-05, -3.196509829231070e-07,  2.757142876160066e-09, -2.538129647528383e-11,  2.672291457181823e-13, -3.256783711285744e-15,
  3.571028398736595e-17,  4.796453623081809e-20, -2.146106440741540e-20,  8.431493881997620e-22, -2.124440395022240e-23,  1.036265274810852e+00,  7.863116701109630e-03,
 -6.601203487345759e-05,  5.901711835050630e-07, -6.016683271146767e-09,  7.633996507077743e-11, -1.218766858315837e-12,  2.156669245566680e-14, -3.475250367271697e-16,
  3.594828871203177e-18,  3.210904775116188e-20, -3.047121296648043e-21,  1.292577061316147e+00,  5.740017479064616e-03, -4.745351023812450e-05,  4.086315637338097e-07,
 -3.851710889535628e-09,  4.317036310812667e-11, -6.023191907522193e-13,  9.402374421798044e-15, -1.256789149089020e-16,  4.621619162501740e-19,  4.744766717240786e-20,
 -2.116382539322646e-21,  1.476900900185512e+00,  4.232634499933228e-03, -3.474905674310521e-05,  2.945211646416656e-07, -2.686100100811051e-09,  2.846715176144368e-11,
 -3.712665386771444e-13,  5.430207501068965e-15, -6.573116893349916e-17,  3.433348664242170e-21,  3.449354070156257e-20, -1.363169919073082e-21,  1.619642918918574e+00,
  3.072372860819550e-03, -2.512198592562705e-05,  2.110521388584132e-07, -1.889957899000382e-09,  1.939195285776038e-11, -2.425891580641344e-13,  3.404209158012634e-15,
 -3.871820801684716e-17, -8.533373235424242e-20,  2.374006460295055e-20, -8.897330418479361e-22,  1.732589825870343e+00,  2.157540769146750e-03, -1.759573198899509e-05,
  1.470037264568920e-07, -1.301372412754754e-09,  1.307671538167331e-11, -1.590479783227603e-13,  2.168963719085704e-15, -2.365019074640304e-17, -8.750037253937499e-20,
  1.584686212776752e-20, -5.764379224653088e-22,  1.821809261416062e+00,  1.436529352817454e-03, -1.169478441150095e-05,  9.734158033612649e-08, -8.551407659150967e-10,
  8.471346408337910e-12, -1.010143130027479e-13,  1.349649625749357e-15, -1.428766328780757e-17, -6.748382590253404e-20,  1.011610458883973e-20, -3.611440268560626e-22,
  1.890864611469692e+00,  8.793175087627804e-04, -7.149719395721739e-06,  5.935939238217413e-08, -5.187356351698411e-10,  5.088247656275154e-12, -5.982580554702810e-14,
  7.876517337911906e-16, -8.165825871032332e-18, -4.433504154342763e-20,  5.991181322129988e-21, -2.112614499611598e-22,  1.941987932317301e+00,  4.672243241678574e-04,
 -3.795801122445170e-06,  3.145972493876553e-08, -2.739461891237348e-10,  2.669008508923081e-12, -3.107562735126500e-14,  4.049288428636009e-16, -4.137785007140049e-18,
 -2.444456770628825e-20,  3.106546724908604e-21, -1.086544791649978e-22,  1.976601260558907e+00,  1.884028787547133e-04, -1.529789020767940e-06,  1.266502618913606e-08,
 -1.100352029589311e-10,  1.067413383909823e-12, -1.234941452169126e-14,  1.598370490929628e-16, -1.618137986797416e-18, -1.005077888633012e-20,  1.232184974661336e-21,
 -4.287752977674373e-23,  1.995580231198653e+00,  3.558236917574423e-05, -2.888383378381471e-07,  2.389887851301185e-09, -2.073876652356270e-11,  2.007172949051531e-13,
 -2.314337518286071e-15,  2.984615698706897e-17, -3.006561867741183e-19, -1.915544741068097e-21,  2.306254001495027e-22, -8.003907000353122e-24, -2.006678055488732e+00,
  4.204788019059211e-03, -1.095344708802393e-03,  2.918346833741018e-04, -7.950857583484343e-05,  2.215261271889893e-05, -6.315269498452214e-06,  1.843893313822355e-06,
 -5.520798574775605e-07,  1.695781645862951e-07, -5.300092192720731e-08,  1.546141812755453e-08, -2.005879859943050e+00,  3.653176614581260e-03, -8.906065346726880e-04,
  2.226400020601299e-04, -5.717006266868335e-05,  1.510760331609964e-05, -4.117016675427925e-06,  1.159584958425139e-06, -3.382766348914479e-07,  1.022709431188657e-07,
 -3.175268728725719e-08,  9.260228901924917e-09, -2.005420000559856e+00,  3.341428545762921e-03, -7.826783406318835e-04,  1.886048396877061e-04, -4.689416928310508e-05,
  1.206534798286746e-05, -3.221254406612308e-06,  8.947156078128149e-07, -2.590415977846238e-07,  7.816817687440173e-08, -2.432668131062554e-08,  7.123624490986339e-09,
 -2.005112587494327e+00,  3.135495590473059e-03, -7.145098728219280e-04,  1.680211456991968e-04, -4.092704513480592e-05,  1.036254300956238e-05, -2.735638354381815e-06,
  7.548339217540870e-07, -2.180134960575133e-07,  6.584781827379374e-08, -2.055511970949200e-08,  6.040119772137419e-09, -2.004893970640017e+00,  2.990250450460639e-03,
 -6.679396206714737e-04,  1.543785431807079e-04, -3.708003726586057e-05,  9.291034640169942e-06, -2.436141718165515e-06,  6.698837481144606e-07, -1.933554364940522e-07,
  5.848384021481150e-08, -1.830362128198416e-08,  5.392426311139178e-09, -2.004734558467104e+00,  2.884970947840819e-03, -6.349688763018401e-04,  1.449301964927435e-04,
 -3.446780022857622e-05,  8.575593054466513e-06, -2.238839025580183e-06,  6.144617312687246e-07, -1.773634563597758e-07,  5.371932450993489e-08, -1.684624163785067e-08,
  4.972390074944366e-09, -2.004618383270223e+00,  2.808581466074692e-03, -6.114607382540540e-04,  1.383016448783603e-04, -3.266114948760059e-05,  8.086650818963754e-06,
 -2.105238102798367e-06,  5.771709964899284e-07, -1.666409806130686e-07,  5.052789201801545e-08, -1.586913581148242e-08,  4.690286388307308e-09, -2.004536110471808e+00,
  2.754655062156802e-03, -5.950762423590635e-04,  1.337355448629842e-04, -3.142928154239661e-05,  7.756049312977377e-06, -2.015472908718090e-06,  5.522202290852366e-07,
 -1.594818808775890e-07,  4.839778192802352e-08, -1.521635903350853e-08,  4.501557354264151e-09, -2.004482108081577e+00,  2.719335813013059e-03, -5.844399584493220e-04,
  1.307952220063038e-04, -3.064154205486421e-05,  7.545833126773003e-06, -1.958633415904321e-06,  5.364636257969051e-07, -1.549665416564422e-07,  4.705438074364208e-08,
 -1.480435831849534e-08,  4.382319520510479e-09, -2.004453058467627e+00,  2.700361726760102e-03, -5.787569952081710e-04,  1.292319399538134e-04, -3.022449563354900e-05,
  7.434918491196437e-06, -1.928718196364624e-06,  5.281836545942945e-07, -1.525954048602645e-07,  4.634890463171518e-08, -1.458789030335541e-08,  4.319631025962583e-09,
 -2.002199568447502e+00,  1.322748893482219e-03, -2.683315135658296e-04,  5.463034491972224e-05, -1.116154228284397e-05,  2.288243660733599e-06, -4.706826359703801e-07,
  9.713206922982750e-08, -2.010787074184776e-08,  4.175124483449530e-09, -8.679647667027974e-10,  1.736612808118886e-10, -2.002092274477189e+00,  1.252688587390957e-03,
 -2.474780333745910e-04,  4.906504142166892e-05, -9.762520274831966e-06,  1.949471946157586e-06, -3.907031780001616e-07,  7.858868380157062e-08, -1.586579384618437e-08,
  3.214615848523233e-09, -6.526606556818285e-10,  1.278391239334933e-10, -2.002021434396369e+00,  1.206746598373069e-03, -2.341926281132709e-04,  4.562171964360994e-05,
 -8.921971935429855e-06,  1.751815749848879e-06, -3.453818318212112e-07,  6.838108880222828e-08, -1.359675315461412e-08,  2.715216350052665e-09, -5.437806228193623e-10,
  1.052405009113690e-10, -2.001969839229889e+00,  1.173442994957317e-03, -2.247555465502230e-04,  4.322520659364394e-05, -8.348716530516780e-06,  1.619696394606599e-06,
 -3.156824314528004e-07,  6.182111520261871e-08, -1.216613245202954e-08,  2.406164913914863e-09, -4.776046383987528e-10,  9.172535653539429e-11, -2.001930877491579e+00,
  1.148381893856277e-03, -2.177617117832033e-04,  4.147602518135992e-05, -7.936567514649944e-06,  1.526106026628368e-06, -2.949474491523154e-07,  5.730563407661259e-08,
 -1.119484493492047e-08,  2.199116064491201e-09, -4.338312963653916e-10,  8.288610090463938e-11, -2.001901194849443e+00,  1.129340052938408e-03, -2.125096008837640e-04,
  4.017766948572823e-05, -7.634131046935365e-06,  1.458195084247156e-06, -2.800651836279825e-07,  5.409883079829327e-08, -1.051206274754661e-08,  2.054986146007297e-09,
 -4.036417790695051e-10,  7.683958062684916e-11, -2.001878852535508e+00,  1.115036065325786e-03, -2.085995103058361e-04,  3.921961752942228e-05, -7.412898868170711e-06,
  1.408937835752458e-06, -2.693591286524057e-07,  5.181011935011656e-08, -1.002844622835285e-08,  1.953634896013220e-09, -3.825569372110627e-10,  7.264172849681108e-11,
 -2.001862654384556e+00,  1.104681223039652e-03, -2.057878271367261e-04,  3.853523615644967e-05, -7.255879836190834e-06,  1.374196182107680e-06, -2.618536198542341e-07,
  5.021491173459035e-08, -9.693235082975920e-09,  1.883753153674509e-09, -3.680902832699897e-10,  6.977382774471893e-11, -2.001851848328590e+00,  1.097780593808109e-03,
 -2.039228908350922e-04,  3.808340299720020e-05, -7.152683355038685e-06,  1.351463133985118e-06, -2.569631244547401e-07,  4.917968745347587e-08, -9.476531196043824e-09,
  1.838740261773329e-09, -3.588033225200669e-10,  6.793814716100571e-11, -2.001845977406538e+00,  1.094033922129147e-03, -2.029132848741714e-04,  3.783949992445243e-05,
 -7.097132802879703e-06,  1.339259033896085e-06, -2.543445104235239e-07,  4.862675174596324e-08, -9.361057213664591e-09,  1.814807549167052e-09, -3.538757314266253e-10,
  6.696588043842955e-11, -2.000934415550778e+00,  5.537828538569780e-04, -1.026304347469201e-04,  1.903515377778223e-05, -3.533260739901282e-06,  6.563409954934919e-07,
 -1.220150358108385e-07,  2.269982643407453e-08, -4.226218092711766e-09,  7.873725719744783e-10, -1.466316299523917e-10,  2.643629276861991e-11, -2.000913383974445e+00,
  5.403101273098259e-04, -9.893962065107214e-05,  1.813095263076113e-05, -3.325024716014945e-06,  6.102300117618337e-07, -1.120771738187139e-07,  2.059994750016205e-08,
 -3.789136304487431e-09,  6.974680940616921e-10, -1.283406565006878e-10,  2.288076407156260e-11, -2.000898811722182e+00,  5.310028181291576e-04, -9.642358174213188e-05,
  1.752279947844732e-05, -3.186851500544556e-06,  5.800461038291949e-07, -1.056597865350971e-07,  1.926227378486793e-08, -3.514467161123071e-09,  6.417334091937840e-10,
 -1.171535527599409e-10,  2.073321212610306e-11, -2.000887835621258e+00,  5.240072861205299e-04, -9.455062814268402e-05,  1.707446978581675e-05, -3.085978581762400e-06,
  5.582240817056965e-07, -1.010651071964862e-07,  1.831377399864559e-08, -3.321580208591057e-09,  6.029680126668192e-10, -1.094462077916939e-10,  1.926663713071635e-11,
 -2.000879336541513e+00,  5.185992628301756e-04, -9.311339284810416e-05,  1.673299345754333e-05, -3.009717737906980e-06,  5.418485156592001e-07, -9.764258751577240e-08,
  1.761242250498794e-08, -3.179991046839535e-09,  5.747176455458001e-10, -1.038694943821035e-10,  1.821247916171325e-11, -2.000872736390770e+00,  5.144048370700616e-04,
 -9.200510540759129e-05,  1.647119647456094e-05, -2.951588918677825e-06,  5.294381301548053e-07, -9.506359007318075e-08,  1.708691824310914e-08, -3.074497043723309e-09,
  5.537860039640490e-10, -9.976011792150635e-11,  1.743961249619613e-11, -2.000867695372436e+00,  5.112043647521118e-04, -9.116322570774947e-05,  1.627322033194302e-05,
 -2.907826801943273e-06,  5.201363940687435e-07, -9.313909032767764e-08,  1.669648233026087e-08, -2.996455124495966e-09,  5.383671468698096e-10, -9.674568727585525e-11,
  1.687486244491678e-11, -2.000864000740497e+00,  5.088604087811063e-04, -9.054872648672823e-05,  1.612920200134260e-05, -2.876098658223816e-06,  5.134149339210842e-07,
 -9.175302133854440e-08,  1.641619734687406e-08, -2.940610915397964e-09,  5.273689600345220e-10, -9.460221116395200e-11,  1.647443754297007e-11, -2.000861517108727e+00,
  5.072855529776502e-04, -9.013684293943840e-05,  1.603290074535417e-05, -2.854933262493128e-06,  5.089416933751320e-07, -9.083271728176829e-08,  1.623052539055825e-08,
 -2.903701452891466e-09,  5.201161222533387e-10, -9.319177957302203e-11,  1.621148525783057e-11, -2.000860161365897e+00,  5.064261611190117e-04, -8.991241417123714e-05,
  1.598050576972360e-05, -2.843434737790566e-06,  5.065150707677268e-07, -9.033419701702776e-08,  1.613009220076505e-08, -2.883764595204487e-09,  5.162038932118685e-10,
 -9.243201677366222e-11,  1.607001667924182e-11, -2.000433841851439e+00,  2.555458383813682e-04, -4.550374649075845e-05,  8.104135003950990e-06, -1.443599838955254e-06,
  2.571977119448554e-07, -4.583180515223555e-08,  8.168566784638518e-09, -1.456139096971983e-09,  2.596119692203342e-10, -4.624996251698760e-11,  7.994546792158881e-12,
 -2.000429135912595e+00,  2.525559154747396e-04, -4.471465850573822e-05,  7.918032048436231e-06, -1.402360274976468e-06,  2.484145310750710e-07, -4.401183528237875e-08,
  7.798966771183680e-09, -1.382227130615466e-09,  2.450102470836494e-10, -4.339711406442483e-11,  7.460650557526588e-12, -2.000425805854809e+00,  2.504430900444143e-04,
 -4.416060341222082e-05,  7.788202815893107e-06, -1.373777097991752e-06,  2.423664557164841e-07, -4.276676730827352e-08,  7.547766289718672e-09, -1.332320295739745e-09,
  2.352152406822124e-10, -4.149583081096980e-11,  7.106996690848448e-12, -2.000423259141299e+00,  2.488289121901310e-04, -4.373929499552769e-05,  7.689946844761347e-06,
 -1.352247842003604e-06,  2.378326271698883e-07, -4.183786565323258e-08,  7.361245831165341e-09, -1.295439805159834e-09,  2.280112290477793e-10, -4.010408000643522e-11,
  6.849261055287995e-12, -2.000421264049022e+00,  2.475653588858761e-04, -4.341070134116378e-05,  7.613594706110115e-06, -1.335579560742114e-06,  2.343353804765637e-07,
 -4.112397492580283e-08,  7.218424964493050e-09, -1.267303437908337e-09,  2.225353272455242e-10, -3.905002406116088e-11,  6.654723563965956e-12, -2.000419700610174e+00,
  2.465757937482598e-04, -4.315409591207281e-05,  7.554141646016560e-06, -1.322637946439582e-06,  2.316278736378533e-07, -4.057288431926454e-08,  7.108490482553447e-09,
 -1.245707861133244e-09,  2.183443906081297e-10, -3.824559545381008e-11,  6.506649636412193e-12, -2.000418498101963e+00,  2.458150404436285e-04, -4.295726379188566e-05,
  7.508639871289862e-06, -1.312755466312134e-06,  2.295650031900019e-07, -4.015394336994946e-08,  7.025104273263954e-09, -1.229363834531388e-09,  2.151796125279807e-10,
 -3.763946536580109e-11,  6.395305389622235e-12, -2.000417612111661e+00,  2.452547310645743e-04, -4.281253772312770e-05,  7.475240271826911e-06, -1.305513759311546e-06,
  2.280559289790560e-07, -3.984798846390626e-08,  6.964309315770599e-09, -1.217467746985182e-09,  2.128799530214126e-10, -3.719975374958645e-11,  6.314656085795809e-12,
 -2.000417014298264e+00,  2.448767647563627e-04, -4.271502746291730e-05,  7.452764216201388e-06, -1.300646379219202e-06,  2.270428537050061e-07, -3.964284049631940e-08,
  6.923593961725223e-09, -1.209510221140212e-09,  2.113434856089471e-10, -3.690631423825581e-11,  6.260893899927979e-12, -2.000416687210795e+00,  2.446699974578674e-04,
 -4.266172422054748e-05,  7.440487106381991e-06, -1.297989668665451e-06,  2.264903126446467e-07, -3.953103447765860e-08,  6.901420537960547e-09, -1.205179793730804e-09,
  2.105079672886596e-10, -3.674686065097763e-11,  6.231699643502573e-12, -2.000209358397902e+00,  1.229698020767682e-04, -2.148666687658318e-05,  3.754562942007333e-06,
 -6.560990767324024e-07,  1.146566105626416e-07, -2.003772181239364e-08,  3.502007592623953e-09, -6.120753803437467e-10,  1.069794766613795e-10, -1.868245633186851e-11,
  3.168888350253245e-12, -2.000208242852066e+00,  1.222637512822388e-04, -2.130361195206754e-05,  3.712161520384389e-06, -6.468723472411344e-07,  1.127271198858654e-07,
 -1.964519495084386e-08,  3.423752595704566e-09, -5.967139233300590e-10,  1.040007875817662e-10, -1.811123223930595e-11,  3.063839680643453e-12, -2.000207445602598e+00,
  1.217594949857652e-04, -2.117328479699154e-05,  3.682069088711224e-06, -6.403449266681621e-07,  1.113664591199501e-07, -1.936927213583526e-08,  3.368919888053908e-09,
 -5.859847038787920e-10,  1.019269808406914e-10, -1.771480596861170e-11,  2.991154247225802e-12, -2.000206831448194e+00,  1.213712377808870e-04, -2.107317059768952e-05,
  3.659006898170536e-06, -6.353542038518554e-07,  1.103285759481401e-07, -1.915929980341001e-08,  3.327291501225875e-09, -5.778583952335936e-10,  1.003599806840342e-10,
 -1.741596269335861e-11,  2.936481125292485e-12, -2.000206347605534e+00,  1.210654791752213e-04, -2.099447152430345e-05,  3.640910926372495e-06, -6.314453483012847e-07,
  1.095171694237419e-07, -1.899544630922124e-08,  3.294865980806709e-09, -5.715401746975178e-10,  9.914386392086654e-11, -1.718445864595203e-11,  2.894199802265953e-12,
 -2.000205966767788e+00,  1.208248863690555e-04, -2.093263369010849e-05,  3.626712449694910e-06, -6.283828004116165e-07,  1.088823580362039e-07, -1.886743894508791e-08,
  3.269570693303820e-09, -5.666184034604710e-10,  9.819789535011022e-11, -1.700463852095475e-11,  2.861401864281048e-12, -2.000205672840526e+00,  1.206392429386615e-04,
 -2.088497222679678e-05,  3.615781273878615e-06, -6.260276489858922e-07,  1.083947270743326e-07, -1.876922065318951e-08,  3.250183793279808e-09, -5.628504796373731e-10,
  9.747450927892026e-11, -1.686728261029611e-11,  2.836375229582264e-12, -2.000205455715909e+00,  1.205021324090783e-04, -2.084980065244577e-05,  3.607721525125123e-06,
 -6.242926355813675e-07,  1.080358013433844e-07, -1.869698771157390e-08,  3.235938173250094e-09, -5.600841385665659e-10,  9.694386304204663e-11, -1.676660893865145e-11,
  2.818046671884275e-12, -2.000205308942309e+00,  1.204094592082992e-04, -2.082604243706638e-05,  3.602280508402201e-06, -6.231220655106368e-07,  1.077937902832048e-07,
 -1.864831313127091e-08,  3.226344499564136e-09, -5.582222810702787e-10,  9.658693268345864e-11, -1.669893309763894e-11,  2.805732583580843e-12, -2.000205228544075e+00,
  1.203586996241447e-04, -2.081303431867882e-05,  3.599302566569418e-06, -6.224816398223467e-07,  1.076614348567553e-07, -1.862170317605892e-08,  3.221101708867322e-09,
 -5.572051896958084e-10,  9.639202302981655e-11, -1.666199105437392e-11,  2.799013076180173e-12, -2.000102875529559e+00,  6.034322666369798e-05, -1.044728903397031e-05,
  1.808770925469987e-06, -3.131615230051166e-07,  5.421982186407549e-08, -9.387557930379491e-09,  1.625369140905714e-09, -2.814206088148923e-10,  4.872519703779098e-11,
 -8.429244172015801e-12,  1.417026434308266e-12, -2.000102603819335e+00,  6.017157451917873e-05, -1.040317034515755e-05,  1.798641011280429e-06, -3.109766077157493e-07,
  5.376694991030428e-08, -9.296244297584573e-09,  1.607326464311412e-09, -2.779103913609739e-10,  4.805062082034052e-11, -8.301033233839004e-12,  1.393645501036796e-12,
 -2.000102408699851e+00,  6.004834905689259e-05, -1.037154762359586e-05,  1.791391632057178e-06, -3.094154560766803e-07,  5.344387758908284e-08, -9.231205456316234e-09,
  1.594495765837403e-09, -2.754181218387250e-10,  4.757242760427987e-11, -8.210290566905725e-12,  1.377121874341088e-12, -2.000102257856279e+00,  5.995310885642619e-05,
 -1.034713477016062e-05,  1.785801596461069e-06, -3.082130496305529e-07,  5.319533693978464e-08, -9.181229466499074e-09,  1.584648185579318e-09, -2.735075442548725e-10,
  4.720627381398856e-11, -8.140889798608931e-12,  1.364498291897056e-12, -2.000102138689571e+00,  5.987788329363093e-05, -1.032786960829977e-05,  1.781394283633893e-06,
 -3.072659092886647e-07,  5.299973932748712e-08, -9.141935099348619e-09,  1.576912459805948e-09, -2.720080706349488e-10,  4.691916903579132e-11, -8.086521506591642e-12,
  1.354617461095364e-12, -2.000102044687417e+00,  5.981855214245628e-05, -1.031268578811731e-05,  1.777923157408263e-06, -3.065204946318161e-07,  5.284591190698932e-08,
 -9.111054412673984e-09,  1.570837490014319e-09, -2.708313636274875e-10,  4.669402702187426e-11, -8.043917552467410e-12,  1.346879875878747e-12, -2.000101972013729e+00,
  5.977268824762163e-05, -1.030095499138534e-05,  1.775242922106896e-06, -3.059452458559727e-07,  5.272726771478299e-08, -9.087250161065996e-09,  1.566157266682480e-09,
 -2.699253270219457e-10,  4.652077070800637e-11, -8.011150396842267e-12,  1.340931944089297e-12, -2.000101918260224e+00,  5.973876779504520e-05, -1.029228268132983e-05,
  1.773262329667306e-06, -3.055203404835782e-07,  5.263966912415523e-08, -9.069682285919756e-09,  1.562704673677705e-09, -2.692572312210264e-10,  4.639306908709396e-11,
 -7.987009057985621e-12,  1.336551526326135e-12, -2.000101881890096e+00,  5.971581836085959e-05, -1.028641705561184e-05,  1.771923138138435e-06, -3.052331252817047e-07,
  5.258047483534427e-08, -9.057814508521513e-09,  1.560373025355370e-09, -2.688061819537671e-10,  4.630688058171288e-11, -7.970720499005432e-12,  1.333596825309331e-12,
 -2.000101861956178e+00,  5.970324062455229e-05, -1.028320292797125e-05,  1.771189454215246e-06, -3.050758027149198e-07,  5.254805725321653e-08, -9.051316393282138e-09,
  1.559096591547424e-09, -2.685593072920606e-10,  4.625971564539957e-11, -7.961808597882744e-12,  1.331980516910902e-12, -2.000050997142874e+00,  2.989316828454739e-05,
 -5.151993605273174e-06,  8.879323833822732e-07, -1.530332092312022e-07,  2.637501323222532e-08, -4.545701303687932e-09,  7.834482271705932e-10, -1.350269934885926e-10,
  2.327133948387787e-11, -4.007397385700347e-12,  6.707547462665689e-13, -2.000050930086475e+00,  2.985084421864778e-05, -5.141161924732163e-06,  8.854561316901051e-07,
 -1.525014312859107e-07,  2.626527138750917e-08, -4.523670543125577e-09,  7.791142305967408e-10, -1.341875093647033e-10,  2.311072001832484e-11, -3.977003458812145e-12,
  6.652347852636979e-13, -2.000050881817982e+00,  2.982038352892043e-05, -5.133372372801812e-06,  8.836767370293139e-07, -1.521196037354662e-07,  2.618653637592993e-08,
 -4.507876861380263e-09,  7.760096680791736e-10, -1.335866372135131e-10,  2.299584504563346e-11, -3.955282796652333e-12,  6.612929133589248e-13, -2.000050844436808e+00,
  2.979679634599722e-05, -5.127344010663893e-06,  8.823004558699608e-07, -1.518244494037702e-07,  2.612570938788644e-08, -4.495682528893027e-09,  7.736140304811834e-10,
 -1.331232449919538e-10,  2.290730535064526e-11, -3.938551382781130e-12,  6.582581498120060e-13, -2.000050814865066e+00,  2.977813861916725e-05, -5.122577650328827e-06,
  8.812127845719368e-07, -1.515912959400867e-07,  2.607768179015187e-08, -4.486058559503487e-09,  7.717242173487636e-10, -1.327578623040834e-10,  2.283752410010119e-11,
 -3.925370766711082e-12,  6.558684540473973e-13, -2.000050791512728e+00,  2.976340601474252e-05, -5.118815350709457e-06,  8.803545452954170e-07, -1.514073898052845e-07,
  2.603981237777467e-08, -4.478472868375094e-09,  7.702351890974416e-10, -1.324700726572234e-10,  2.278258151343293e-11, -3.914996679420036e-12,  6.539882265589358e-13,
 -2.000050773443572e+00,  2.975200715403365e-05, -5.115905206539358e-06,  8.796908823701533e-07, -1.512652181605753e-07,  2.601054507269906e-08, -4.472611937149882e-09,
  7.690850465582815e-10, -1.322478434471266e-10,  2.274016720808651e-11, -3.906990395684790e-12,  6.525375287989382e-13, -2.000050760070022e+00,  2.974357087595723e-05,
 -5.113751868407550e-06,  8.791999149275149e-07, -1.511600643046142e-07,  2.598890284903897e-08, -4.468278897772211e-09,  7.682349181771073e-10, -1.320836178587436e-10,
  2.270883010048111e-11, -3.901076348153665e-12,  6.514661480002503e-13, -2.000050751017203e+00,  2.973786037491816e-05, -5.112294497370785e-06,  8.788676805638989e-07,
 -1.510889182569859e-07,  2.597426217489633e-08, -4.465348103036381e-09,  7.676599936458220e-10, -1.319725724236242e-10,  2.268764393418663e-11, -3.897078630084435e-12,
  6.507420301824154e-13, -2.000050746054067e+00,  2.973472970131824e-05, -5.111495596643489e-06,  8.786855738525099e-07, -1.510499248884457e-07,  2.596623875423658e-08,
 -4.463742114739410e-09,  7.673449822315777e-10, -1.319117344640109e-10,  2.267603787439944e-11, -3.894888836015010e-12,  6.503454220473646e-13, -2.000025389669031e+00,
  1.487782023306542e-05, -2.558369102766201e-06,  4.399338689605291e-07, -7.565051632441411e-08,  1.300878381915252e-08, -2.236978438375768e-09,  3.846690029246326e-10,
 -6.614736888341309e-11,  1.137437867601039e-11, -1.954273339649515e-12,  3.264043632803900e-13, -2.000025373012258e+00,  1.486731171298063e-05, -2.555685472019232e-06,
  4.393216801370176e-07, -7.551933239170169e-08,  1.298177037033380e-08, -2.231567243079469e-09,  3.836068009984074e-10, -6.594207080034026e-11,  1.133518428832721e-11,
 -1.946872701237176e-12,  3.250630400288989e-13, -2.000025361008283e+00,  1.485973919415557e-05, -2.553752373030237e-06,  4.388808740571064e-07, -7.542491043934435e-08,
  1.296233458214032e-08, -2.227675493252948e-09,  3.828431617573584e-10, -6.579453568531900e-11,  1.130702875814152e-11, -1.941558487616536e-12,  3.241002228338476e-13,
 -2.000025351703768e+00,  1.485386994348899e-05, -2.552254510891824e-06,  4.385394142921569e-07, -7.535179002483085e-08,  1.294728788149522e-08, -2.224663476742456e-09,
  3.822523163126038e-10, -6.568041766811215e-11,  1.128525689082829e-11, -1.937450353221353e-12,  3.233561233646902e-13, -2.000025344338061e+00,  1.484922390592929e-05,
 -2.551069084908610e-06,  4.382692401928516e-07, -7.529394793056162e-08,  1.293538786282290e-08, -2.222281899881302e-09,  3.817852463113893e-10, -6.559022669123006e-11,
  1.126805384521141e-11, -1.934205048349638e-12,  3.227684321509503e-13, -2.000025338518336e+00,  1.484555315893387e-05, -2.550132668366077e-06,  4.380558568628725e-07,
 -7.524827250274954e-08,  1.292599262128332e-08, -2.220401948917128e-09,  3.814166207384453e-10, -6.551905814117631e-11,  1.125448159332684e-11, -1.931645142800316e-12,
  3.223049378794427e-13, -2.000025334013348e+00,  1.484271175619782e-05, -2.549407920345422e-06,  4.378907300965935e-07, -7.521293153768140e-08,  1.291872416117163e-08,
 -2.218947764106007e-09,  3.811315207950501e-10, -6.546402321877237e-11,  1.124398760139160e-11, -1.929666116391442e-12,  3.219466644014568e-13, -2.000025330677996e+00,
  1.484060811652660e-05, -2.548871407977030e-06,  4.377685040199543e-07, -7.518677511667610e-08,  1.291334523280480e-08, -2.217871729238016e-09,  3.809205816221102e-10,
 -6.542330846414785e-11,  1.123622499528297e-11, -1.928202349327163e-12,  3.216816975830454e-13, -2.000025328419712e+00,  1.483918381793019e-05, -2.548508182157066e-06,
  4.376857616781991e-07, -7.516906958010163e-08,  1.290970446222894e-08, -2.217143462216329e-09,  3.807778276273842e-10, -6.539575668954914e-11,  1.123097242305875e-11,
 -1.927211965992484e-12,  3.215024341220894e-13, -2.000025327181449e+00,  1.483840285377382e-05, -2.548309029404063e-06,  4.376403971125633e-07, -7.515936275261377e-08,
  1.290770855310149e-08, -2.216744237601901e-09,  3.806995758626177e-10, -6.538065468323130e-11,  1.122809345857874e-11, -1.926669157180174e-12,  3.214041878852144e-13,
 -2.000012667763492e+00,  7.421823582939948e-06, -1.274812652016756e-06,  2.189687698212065e-07, -3.761127597906058e-08,  6.460320014175180e-09, -1.109660356160197e-09,
  1.906014393926038e-10, -3.273874647288943e-11,  5.623251241110213e-12, -9.650654850163776e-13,  1.610146476149321e-13, -2.000012663612619e+00,  7.419205445796297e-06,
 -1.274144752317286e-06,  2.188165724429096e-07, -3.757869727134520e-08,  6.453618642969327e-09, -1.108319424465676e-09,  1.903385034854160e-10, -3.268798236677981e-11,
  5.613570143459925e-12, -9.632394859376060e-13,  1.606840310931043e-13, -2.000012660619471e+00,  7.417317613535102e-06, -1.273663249732914e-06,  2.187068715730711e-07,
 -3.755521976668841e-08,  6.448790314972733e-09, -1.107353474456030e-09,  1.901491328073227e-10, -3.265142841152410e-11,  5.606600396403072e-12, -9.619251448226819e-13,
  1.604460992968822e-13, -2.000012658298412e+00,  7.415853724668642e-06, -1.273289929866035e-06,  2.186218303090971e-07, -3.753702240303300e-08,  6.445048433041275e-09,
 -1.106604986752315e-09,  1.900024161541368e-10, -3.262311203476826e-11,  5.601202097279285e-12, -9.609072922017017e-13,  1.602618651679401e-13, -2.000012656460373e+00,
  7.414694502888938e-06, -1.272994339128114e-06,  2.185545031580827e-07, -3.752261719213148e-08,  6.442086660208101e-09, -1.106012611647572e-09,  1.898863135477369e-10,
 -3.260070674072362e-11,  5.596931188301759e-12, -9.601021012695578e-13,  1.601161389362813e-13, -2.000012655007726e+00,  7.413778359317430e-06, -1.272760751794611e-06,
  2.185013033844593e-07, -3.751123567664453e-08,  6.439746782997811e-09, -1.105544662211958e-09,  1.897946060423427e-10, -3.258301077273158e-11,  5.593558278281181e-12,
 -9.594662665494049e-13,  1.600010730864124e-13, -2.000012653883010e+00,  7.413069042953532e-06, -1.272579911359835e-06,  2.184601196663626e-07, -3.750242548700065e-08,
  6.437935661578498e-09, -1.105182483658049e-09,  1.897236322573721e-10, -3.256931657222148e-11,  5.590948303053247e-12, -9.589742890211578e-13,  1.599120466939919e-13,
 -2.000012653050172e+00,  7.412543808708385e-06, -1.272446009789997e-06,  2.184296272020925e-07, -3.749590276329889e-08,  6.436594849225931e-09, -1.104914369436140e-09,
  1.896710944724207e-10, -3.255918009293713e-11,  5.589016497090177e-12, -9.586101651580887e-13,  1.598461595241864e-13, -2.000012652486214e+00,  7.412188148007801e-06,
 -1.272355342183194e-06,  2.184089808901400e-07, -3.749148642476395e-08,  6.435687060555505e-09, -1.104732851321702e-09,  1.896355268174175e-10, -3.255231804164909e-11,
  5.587708780380265e-12, -9.583636845654666e-13,  1.598015611642695e-13, -2.000012652176962e+00,  7.411993119022863e-06, -1.272305625150010e-06,  2.183976598792610e-07,
 -3.748906486768595e-08,  6.435189315766018e-09, -1.104633326470744e-09,  1.896160258394738e-10, -3.254855581714000e-11,  5.586991821889746e-12, -9.582285542775642e-13,
  1.597771111488007e-13, -2.000006327133186e+00,  3.706653122714446e-06, -6.363176923429228e-07,  1.092360708535838e-07, -1.875245625947250e-08,  3.219217134520091e-09,
 -5.526401053042599e-10,  9.487123113144353e-11, -1.628644827846103e-11,  2.795810817368129e-12, -4.795498421908980e-13,  7.996724876229477e-14, -2.000006326097127e+00,
  3.705999708249883e-06, -6.361510916712857e-07,  1.091981271540886e-07, -1.874433856947843e-08,  3.217548243700550e-09, -5.523063437827834e-10,  9.480582105134420e-11,
 -1.627382661594349e-11,  2.793405073393712e-12, -4.790963276009660e-13,  7.988517663815495e-14, -2.000006325349817e+00,  3.705528410239203e-06, -6.360309366800429e-07,
  1.091707642285437e-07, -1.873848510568296e-08,  3.216344965824838e-09, -5.520657237654309e-10,  9.475866932284039e-11, -1.626472901403301e-11,  2.791671200748013e-12,
 -4.787695015665877e-13,  7.982603664390456e-14, -2.000006324770185e+00,  3.705162864797029e-06, -6.359377494328253e-07,  1.091495442087101e-07, -1.873394605891615e-08,
  3.215411956352444e-09, -5.518791630325162e-10,  9.472211367839581e-11, -1.625767636808578e-11,  2.790327165461907e-12, -4.785161762640339e-13,  7.978019991566017e-14,
 -2.000006324311097e+00,  3.704873344579177e-06, -6.358639471730096e-07,  1.091327393689972e-07, -1.873035164108730e-08,  3.214673159188955e-09, -5.517314446166743e-10,
  9.469317064369258e-11, -1.625209273450849e-11,  2.789263143226630e-12, -4.783156395438346e-13,  7.974391669871921e-14, -2.000006323948221e+00,  3.704644501127684e-06,
 -6.358056147541263e-07,  1.091194576208062e-07, -1.872751091151726e-08,  3.214089301535701e-09, -5.516147107682702e-10,  9.467029956662695e-11, -1.624768069041838e-11,
  2.788422418119648e-12, -4.781571948569842e-13,  7.971525042588172e-14, -2.000006323667233e+00,  3.704467301032562e-06, -6.357604478467997e-07,  1.091091738978411e-07,
 -1.872531148368946e-08,  3.213637267154636e-09, -5.515243362607552e-10,  9.465259356918725e-11, -1.624426515922214e-11,  2.787771603857691e-12, -4.780345454595597e-13,
  7.969306107426166e-14, -2.000006323459148e+00,  3.704336076740371e-06, -6.357270006921514e-07,  1.091015587627130e-07, -1.872368284278907e-08,  3.213302551948728e-09,
 -5.514574189840199e-10,  9.463948361891272e-11, -1.624173628498999e-11,  2.787289751084170e-12, -4.779437401810880e-13,  7.967663327514514e-14, -2.000006323318235e+00,
  3.704247213191737e-06, -6.357043510987391e-07,  1.090964020779378e-07, -1.872258000913091e-08,  3.213075903992886e-09, -5.514121077069909e-10,  9.463060673046533e-11,
 -1.624002398986657e-11,  2.786963495899519e-12, -4.778822584824883e-13,  7.966551067395678e-14, -2.000006323240961e+00,  3.704198482391629e-06, -6.356919307100956e-07,
  1.090935743332589e-07, -1.872197526113739e-08,  3.212951621191342e-09, -5.513872614868638e-10,  9.462573918985596e-11, -1.623908508360851e-11,  2.786784601877471e-12,
 -4.778485469048135e-13,  7.965941200975929e-14, -2.000003161881844e+00,  1.852263509115093e-06, -3.178872281082967e-07,  5.455610953404177e-08, -9.362971697370831e-09,
  1.606882175114845e-09, -2.757746615649082e-10,  4.732871169699683e-11, -8.122593187024747e-12,  1.393972716607151e-12, -2.390335121303976e-13,  3.984944710538585e-14,
 -2.000003161623037e+00,  1.852100295209680e-06, -3.178456246134772e-07,  5.454663677853742e-08, -9.360945637523223e-09,  1.606465755996674e-09, -2.756914043660812e-10,
  4.731239948273372e-11, -8.119446399289405e-12,  1.393373087201753e-12, -2.389205044724817e-13,  3.982900137512001e-14, -2.000003161436331e+00,  1.851982553081426e-06,
 -3.178156133936476e-07,  5.453980381563996e-08, -9.359484255300970e-09,  1.606165410598059e-09, -2.756313574281657e-10,  4.730063532822114e-11, -8.117177088524277e-12,
  1.392940684732011e-12, -2.388390167983441e-13,  3.981425902255030e-14, -2.000003161291502e+00,  1.851891219992891e-06, -3.177923343913339e-07,  5.453450383752624e-08,
 -9.358350777370277e-09,  1.605932465039209e-09, -2.755847871853063e-10,  4.729151180607004e-11, -8.115417221108598e-12,  1.392605365620219e-12, -2.387758270986820e-13,
  3.980282743970043e-14, -2.000003161176783e+00,  1.851818875546686e-06, -3.177738957360861e-07,  5.453030598996014e-08, -9.357453031709283e-09,  1.605747971010553e-09,
 -2.755479043753228e-10,  4.728428634376943e-11, -8.114023516733622e-12,  1.392339821540539e-12, -2.387257876794861e-13,  3.979377510181695e-14, -2.000003161086100e+00,
  1.851761688710585e-06, -3.177593206716063e-07,  5.452698782344566e-08, -9.356743429335793e-09,  1.605602145242625e-09, -2.755187525226211e-10,  4.727857553005039e-11,
 -8.112921994649626e-12,  1.392129952025965e-12, -2.386862405264973e-13,  3.978662100926023e-14, -2.000003161015876e+00,  1.851717404792956e-06, -3.177480343374759e-07,
  5.452441841602645e-08, -9.356193961588219e-09,  1.605489229693385e-09, -2.754961801108271e-10,  4.727415369928560e-11, -8.112069111278385e-12,  1.391967457733454e-12,
 -2.386556211513946e-13,  3.978108204613028e-14, -2.000003160963871e+00,  1.851684609241708e-06, -3.177396760737153e-07,  5.452251562824823e-08, -9.355787055889137e-09,
  1.605405611747525e-09, -2.754794646683510e-10,  4.727087926563272e-11, -8.111437546520301e-12,  1.391847131446730e-12, -2.386329479465271e-13,  3.977698057546469e-14,
 -2.000003160928652e+00,  1.851662399800569e-06, -3.177340158359254e-07,  5.452122706771180e-08, -9.355511503552553e-09,  1.605348987080138e-09, -2.754681453601234e-10,
  4.726866191670502e-11, -8.111009873781780e-12,  1.391765651632846e-12, -2.386175947688145e-13,  3.977420328640900e-14, -2.000003160909338e+00,  1.851650220402530e-06,
 -3.177309118459310e-07,  5.452052044453209e-08, -9.355360396561361e-09,  1.605317935512837e-09, -2.754619381685900e-10,  4.726744599195782e-11, -8.110775352844761e-12,
  1.391720971189169e-12, -2.386091757179828e-13,  3.977268034391605e-14,     0.994276476667339,      0.99891884155893,     0.985810917472067,     0.973310036086861,
     0.956429614873128,     0.934629941849988,     0.907050659552964,     0.872229714582395,     0.827334843659898,     0.765089137238244,     0.997144732733588,
     0.999460643245782,     0.992921663071259,     0.986685792993156,     0.978265710540204,     0.967392670514352,     0.953638299538311,     0.936274704718763,
     0.913891954593426,     0.882867799373008,     0.998573860516483,     0.999730603373963,     0.996464547437598,     0.993349919181084,     0.989144393111306,
     0.983713790566012,     0.976844234822549,     0.968172307160595,     0.956994064180167,     0.941500997792158,     0.999287290267475,     0.999865369633337,
     0.998233167613055,     0.996676644933636,     0.994574956480326,     0.991861052994692,     0.988428059933184,     0.984094376197701,     0.978508239201464,
     0.970765929551022,     0.999643733575352,     0.999932701515978,     0.999116803230098,     0.998338735678972,     0.997288153836171,     0.995931542141505,
      0.99421547776314,     0.992049184650428,     0.989256828860276,      0.98538667196155,     0.999821888710301,      0.99996635489826,     0.999558455983494,
     0.999169470164537,     0.998644244085339,     0.997966022120178,     0.997108096284657,     0.996025084378652,     0.994629080699545,     0.992694244932034,
     0.999910949812768,     0.999983178479958,     0.999779241524044,     0.999584760543507,     0.999322163621958,      0.99898307347136,     0.998554136935728,
     0.998012664335136,     0.997314705567177,      0.99634734752992,     0.999955476267935,     0.999991589497161,     0.999889624137687,     0.999792386622196,
     0.999661092179476,     0.999491552295016,     0.999277090597206,     0.999006362596674,     0.998657393921067,      0.99817372976264,        0.999977738474,
     0.999995794812811,     0.999944812911838,     0.999896194896858,     0.999830548678587,     0.999745780031931,     0.999638550822353,     0.999503188892263,
     0.999328707224159,     0.999086878847415,     0.999988869321964,     0.999997897422455,     0.999972406666553,     0.999948097844639,     0.999915274986097,
     0.999872890986397,     0.999819276791044,     0.999751596342948,       0.9996643561754,     0.999543442911079,     0.999994434682217,     0.999998948715239,
      0.99998620338592,     0.999974049021343,     0.999957637654698,     0.999936445735722,     0.999909638740355,     0.999875798645471,     0.999832178728208,
     0.999771722326864  };
  constexpr double w[5270] = {  1.447408175739011e-01, -6.301402915342401e-02,  1.472048628282835e-02, -2.338046142119721e-03,  2.809295324118172e-04,
 -2.713460381177472e-05,  2.190899460068657e-06, -1.519653361843289e-07,  9.238903068650614e-09, -4.999734260581985e-10,  2.437928900530449e-11, -1.080128529260118e-12,
  1.450498450698614e-01, -6.069032000860901e-02,  1.361078785383966e-02, -2.080993870227430e-03,  2.414691461322428e-04, -2.259353907099960e-05,  1.772275385107807e-06,
 -1.197412111179425e-07,  7.107993596846282e-09, -3.763926830757755e-10,  1.799431136308051e-11, -7.830746738395398e-13,  1.454061942848960e-01, -5.600324416769113e-02,
  1.155919387199059e-02, -1.636717590150737e-03,  1.770793599626209e-04, -1.554784609165923e-05,  1.151143744498606e-06, -7.379786610447962e-08,  4.176521302543665e-09,
 -2.117588952930292e-10,  9.730964985925825e-12, -4.085191373298436e-13,  1.451695961988798e-01, -4.896998206303034e-02,  8.894532614868450e-03, -1.120862825750666e-03,
  1.091260202035525e-04, -8.708582049141927e-06,  5.912699772717327e-07, -3.503642331812701e-08,  1.845807046699876e-09, -8.767397785790210e-11,  3.796057572920539e-12,
 -1.509543857684368e-13,  1.431228396242401e-01, -3.985209349331397e-02,  6.068630156653109e-03, -6.530807279331776e-04,  5.518447690233480e-05, -3.875765424256492e-06,
  2.343997166416452e-07, -1.250375397680575e-08,  5.985686890615194e-10, -2.605101884881803e-11,  1.041273509616520e-12, -3.849113886727559e-14,  1.373100035967381e-01,
 -2.937997878026005e-02,  3.558431611740616e-03, -3.131838676276889e-04,  2.212787497315053e-05, -1.323310187453751e-06,  6.919746717373204e-08, -3.233870717154274e-09,
  1.371984764938412e-10, -5.346227411474001e-12,  1.930835943099509e-13, -6.503642852278394e-15,  1.251524933860308e-01, -1.885998208788902e-02,  1.715535990762364e-03,
 -1.179339617492075e-04,  6.698434969504479e-06, -3.293848994683966e-07,  1.442791167035646e-08, -5.737716834093535e-10,  2.099854453467216e-11, -7.143789447478662e-13,
  2.276814705905489e-14, -6.834720441056065e-16,  1.041224870750811e-01, -9.939477420296858e-03,  6.373225976744300e-04, -3.252625883657157e-05,  1.421255170960460e-06,
 -5.524356731808681e-08,  1.955031710252470e-09, -6.397543754900769e-11,  1.957179939915369e-12, -5.643485603138202e-14,  1.543418292427039e-15, -4.020940573539271e-17,
  7.300040585536720e-02, -3.931077911178795e-03,  1.641164969208909e-04, -5.841078442149827e-06,  1.858060794573199e-07, -5.428072058075229e-09,  1.480977880495479e-10,
 -3.816325472522282e-12,  9.362618367704935e-14, -2.199751427978047e-15,  4.972181863304563e-17, -1.084637790037124e-18,  3.321333065761251e-02, -9.831114735277095e-04,
  2.369260871704694e-05, -5.264194470041017e-07,  1.108080911327360e-08, -2.234166677409662e-10,  4.344872870093797e-12, -8.191968053104496e-14,  1.503388056414464e-15,
 -2.693839104361178e-17,  4.724476629100702e-19, -8.123568108439536e-21,  2.087064955898567e-02, -9.066761457477122e-03,  2.113278174164161e-03, -3.349284983009403e-04,
  4.016246207451209e-05, -3.871949036764012e-06,  3.120810760626826e-07, -2.161122931103726e-08,  1.311873383148701e-09, -7.089203522251222e-11,  3.452146443563403e-12,
 -1.527559027794836e-13,  2.308767074277318e-02, -9.558438399871564e-03,  2.120916984480356e-03, -3.211000750271448e-04,  3.692737904815253e-05, -3.427291105229681e-06,
  2.668730825477580e-07, -1.791083078827791e-08,  1.056762101299573e-09, -5.564942513451321e-11,  2.646978010455675e-12, -1.146577906792394e-13,  2.784473449016379e-02,
 -1.043951814579339e-02,  2.099202121248415e-03, -2.902625034198656e-04,  3.073920287045641e-05, -2.647381915009308e-06,  1.926213883555142e-07, -1.215508343941062e-08,
  6.781025521749602e-10, -3.393476201011899e-11,  1.540906019148596e-12, -6.398864424138537e-14,  3.561834128626281e-02, -1.143300685329389e-02,  1.983117962818603e-03,
 -2.398073821793342e-04,  2.250020597200484e-05, -1.736830874501732e-06,  1.144274621886880e-07, -6.597808155977327e-09,  3.390425429127528e-10, -1.574185930318285e-11,
  6.675163277029479e-13, -2.604208776953435e-14,  4.653455267347576e-02, -1.201031920143166e-02,  1.710414278580098e-03, -1.735014376896447e-04,  1.390737921903349e-05,
 -9.314386094719025e-07,  5.395562303859213e-08, -2.767219657830749e-09,  1.277815884756711e-10, -5.380061241909989e-12,  2.085708689621697e-13, -7.495524158613442e-15,
  5.935576777738880e-02, -1.147492279759044e-02,  1.276683578927836e-03, -1.043410131345869e-04,  6.901191232612711e-06, -3.888071665147856e-07,  1.925396636051292e-08,
 -8.559159418341827e-10,  3.467351716763789e-11, -1.294485880138811e-12,  4.492602153662343e-14, -1.458174630446702e-15,  7.023673378104342e-02, -9.375448155150500e-03,
  7.747328792384893e-04, -4.899526217141432e-05,  2.582646269486106e-06, -1.186533517879041e-07,  4.882176803247976e-09, -1.832118685397897e-10,  6.351947164227821e-12,
 -2.054203691521376e-13,  6.242724620669911e-15, -1.791974151109988e-16,  7.254250510189927e-02, -6.085561824059885e-03,  3.538425192599335e-04, -1.657795293343449e-05,
  6.704195027616629e-07, -2.426499312143572e-08,  8.035091929640369e-10, -2.470330282371414e-11,  7.125230485103752e-13, -1.943047960980020e-14,  5.039545239424750e-16,
 -1.248317836584738e-17,  5.951989450531698e-02, -2.855132957858532e-03,  1.088175650222595e-04, -3.574612227226776e-06,  1.056153098476446e-07, -2.878906998710170e-09,
  7.355791510842233e-11, -1.780541051945300e-12,  4.114124951484205e-14, -9.125240640111825e-16,  1.951310589205838e-17, -4.034895192510903e-19,  2.962380800649708e-02,
 -8.161310516647952e-04,  1.830831262063691e-05, -3.798998445657318e-07,  7.494168963929430e-09, -1.420095581373953e-10,  2.601306420272022e-12, -4.627893218118896e-14,
  8.025776160725062e-16, -1.360705468738257e-17,  2.260582654529356e-19, -3.686002514702421e-21,  3.025887905007831e-03, -1.311195062538907e-03,  3.048029948603621e-04,
 -4.818612884744717e-05,  5.764650847697843e-06, -5.545478945039195e-07,  4.460692453027748e-08, -3.083204343003581e-09,  1.868355089455968e-10, -1.008000756333291e-11,
  4.901115408770698e-13, -2.165657498530605e-14,  3.769069533029436e-03, -1.540267473169641e-03,  3.373727801313608e-04, -5.047464015219584e-05,  5.742784615078373e-06,
 -5.278640217552327e-07,  4.074551983853705e-08, -2.713034169827936e-09,  1.589278532910827e-10, -8.314749104083240e-12,  3.931473001363811e-13, -1.693769885496108e-14,
  5.634085730172337e-03, -2.044786958445049e-03,  3.986020404160210e-04, -5.359349622106244e-05,  5.534838145857730e-06, -4.660475346502586e-07,  3.322685328043275e-08,
 -2.058551307595869e-09,  1.129438967924746e-10, -5.567149671485469e-12,  2.493260129163806e-13, -1.022420443227894e-14,  9.475870309973291e-03, -2.870338366686963e-03,
  4.722853836529548e-04, -5.449440952867673e-05,  4.903454873307525e-06, -3.645473799721396e-07,  2.321610777550417e-08, -1.298036039318230e-09,  6.485748770536112e-11,
 -2.935143430783749e-12,  1.215718280749902e-13, -4.641895036128694e-15,  1.659650156017929e-02, -3.934494469297727e-03,  5.206336973029351e-04, -4.951792227145193e-05,
  3.748097191900100e-06, -2.384054687505884e-07,  1.317860992156430e-08, -6.476121936948007e-10,  2.875482504306339e-11, -1.167744515256486e-12,  4.378542143149635e-14,
 -1.525776489603341e-15,  2.798916463730731e-02, -4.853459722161788e-03,  4.939905196338978e-04, -3.736695338360646e-05,  2.306883035402234e-06, -1.221127767647016e-07,
  5.712195260742015e-09, -2.409540819991268e-10,  9.298576337356087e-12, -3.318334601741967e-13,  1.104208662390840e-14, -3.445984545581892e-16,  4.220421984989717e-02,
 -4.973109702434061e-03,  3.731021543876006e-04, -2.169522753933846e-05,  1.060720230032082e-06, -4.549942388671600e-08,  1.757235070057649e-09, -6.217053525084071e-11,
  2.039898044614861e-12, -6.264280730058931e-14,  1.813127571924503e-15, -4.970659473140238e-17,  5.281797382688652e-02, -3.899289170142770e-03,  2.060998291382496e-04,
 -8.881781021112818e-06,  3.329402343452457e-07, -1.123446785015534e-08,  3.484253046686305e-10, -1.007121882866020e-11,  2.740085111293769e-13, -7.068816936641822e-15,
  1.738933744468723e-16, -4.095389757820949e-18,  4.960425405902007e-02, -2.131273707062382e-03,  7.443129245834233e-05, -2.264089058431645e-06,  6.231001202492517e-08,
 -1.588729590244618e-09,  3.809741604886149e-11, -8.679161318088563e-13,  1.891968148819185e-14, -3.967541989078082e-16,  8.036808839140092e-18, -1.577081556339066e-19,
  2.662596291225760e-02, -6.860571392332581e-04,  1.438512667681630e-05, -2.797161705197882e-07,  5.186612936937222e-09, -9.262306236571287e-11,  1.602232596316486e-12,
 -2.696251406729950e-14,  4.428892396617379e-16, -7.120488037041902e-18,  1.122933717194521e-19, -1.739805688816109e-21,  4.415500872065421e-04, -1.907538923102155e-04,
  4.420337733381364e-05, -6.967372197630263e-06,  8.312420752033024e-07, -7.976171962226101e-08,  6.400948938585554e-09, -4.414773355528621e-10,  2.669925203189443e-11,
 -1.437793689046237e-12,  6.978833980912735e-14, -3.078807039825383e-15,  6.343845461819150e-04, -2.551126821280838e-04,  5.500170494746927e-05, -8.111320045388619e-06,
  9.110186662918963e-07, -8.277299202032583e-08,  6.322908018243755e-09, -4.170705502096857e-10,  2.422502743396704e-11, -1.257677871280685e-12,  5.905237831149822e-14,
 -2.527996375339553e-15,  1.214669997031932e-03, -4.238929481816691e-04,  7.964457660064681e-05, -1.036139249291504e-05,  1.039067200352138e-06, -8.522031270184292e-08,
  5.933840373670926e-09, -3.598724067244002e-10,  1.936729222326949e-11, -9.380607025569115e-13,  4.134666887056275e-14, -1.671085352123417e-15,  2.751113477159390e-03,
 -7.792015397227279e-04,  1.207535785148258e-04, -1.321604253403818e-05,  1.134632761416358e-06, -8.087771539282102e-08,  4.958771485572790e-09, -2.678639231707029e-10,
  1.297065937914577e-11, -5.703940795300455e-13,  2.301220520552956e-14, -8.577206518942686e-16,  6.497498460927906e-03, -1.401966015761753e-03,  1.713251842013638e-04,
 -1.520318005011572e-05,  1.082020926469072e-06, -6.511424311268243e-08,  3.422774298847957e-09, -1.606381515080462e-10,  6.837401104715879e-12, -2.670532787343904e-13,
  9.658580594793770e-15, -3.255119825891236e-16,  1.432992904153500e-02, -2.214239706986250e-03,  2.055127456899575e-04, -1.435148451878836e-05,  8.251245936269155e-07,
 -4.095004550151674e-08,  1.805745975871882e-09, -7.213234024574494e-11,  2.646431734462942e-12, -9.009701713549446e-14,  2.868937597131464e-15, -8.591924846398767e-17,
  2.696443243099625e-02, -2.797898452706131e-03,  1.906340889833049e-04, -1.019382875422637e-05,  4.622764773179301e-07, -1.851089653221245e-08,  6.708167784971745e-10,
 -2.236519258907275e-11,  6.940808518873017e-13, -2.022514095305958e-14,  5.570868682961786e-16, -1.457279899467392e-17,  3.995194763371192e-02, -2.600793610742311e-03,
  1.253129219005126e-04, -4.978558438655212e-06,  1.733046532014170e-07, -5.459993722313589e-09,  1.587879305920279e-10, -4.319320624148547e-12,  1.109332291861337e-13,
 -2.708863745308711e-15,  6.323003928498875e-17, -1.416175376685750e-18,  4.211909426282663e-02, -1.629679976020325e-03,  5.233640415723110e-05, -1.478827915794137e-06,
  3.801505062956919e-08, -9.088719486602497e-10,  2.049915561851576e-11, -4.403732698931784e-13,  9.072413199103339e-15, -1.801557772197549e-16,  3.461747836485127e-18,
 -6.454587737417064e-20,  2.409245966908766e-02, -5.831201232431721e-04,  1.147144603603025e-05, -2.096913686348058e-07,  3.664910174915635e-09, -6.183659321569229e-11,
  1.012572276849154e-12, -1.615457017107458e-14,  2.518881853202809e-16, -3.848288144660469e-18,  5.772356540916286e-20, -8.515051747382221e-22,  6.493457352958504e-05,
 -2.794886615669227e-05,  6.452057710088709e-06, -1.013382667520079e-06,  1.205090164035343e-07, -1.152904768447964e-08,  9.226954452227425e-10, -6.347961338049026e-11,
  3.830213977498219e-12, -2.058237443338162e-13,  9.970694317420245e-15, -4.390685089732274e-16,  1.107944828178554e-04, -4.367192271169969e-05,  9.234483356109335e-06,
 -1.338206697532811e-06,  1.479690116200517e-07, -1.325784093047568e-08,  1.000181603544010e-09, -6.523860468308139e-11,  3.751261798877344e-12, -1.929857426102962e-13,
  8.986891450059328e-15, -3.818587345126809e-16,  2.815422005734465e-04, -9.372157202429209e-05,  1.685970756124819e-05, -2.110348066286316e-06,  2.045064841215402e-07,
 -1.626835230710678e-08,  1.102171883474505e-09, -6.521698114712665e-11,  3.432495429587369e-12, -1.629307340956245e-13,  7.050806806418422e-15, -2.802491896717604e-16,
  8.763225188527297e-04, -2.297661273971843e-04,  3.328876788235756e-05, -3.434912382413975e-06,  2.799039617891959e-07, -1.904176151955578e-08,  1.119359469772524e-09,
 -5.820023077297847e-11,  2.721802665137632e-12, -1.159419820267021e-13,  4.542907518811382e-15, -1.648427904659544e-16,  2.789438898843441e-03, -5.428971979822394e-04,
  6.093146124385100e-05, -5.022477925105916e-06,  3.348199399866177e-07, -1.899708504782420e-08,  9.465663648032799e-10, -4.230044854108032e-11,  1.721082017713400e-12,
 -6.447695038460584e-14,  2.243529029388001e-15, -7.294627380061445e-17,  7.921059077435347e-03, -1.084343916959116e-03,  9.157504880247991e-05, -5.893181295784322e-06,
  3.150331538878686e-07, -1.463555467628933e-08,  6.074227090409843e-10, -2.294134005771356e-11,  7.989155000793849e-13, -2.590538429845149e-14,  7.880714786001226e-16,
 -2.261100400238789e-17,  1.819472937249535e-02, -1.659743308421768e-03,  1.028137959206355e-04, -5.059485601157945e-06,  2.129206028147029e-07, -7.961424750676652e-09,
  2.707465535314728e-10, -8.505784393743045e-12,  2.496134116413595e-13, -6.899406141360846e-15,  1.807624244865719e-16, -4.509252325021425e-18,  3.123249305966429e-02,
 -1.797254495216880e-03,  7.917739770850836e-05, -2.907130330086206e-06,  9.416346694280772e-08, -2.774499582181648e-09,  7.576766567312642e-11, -1.941832016517227e-12,
  4.712348226682211e-14, -1.090038393178939e-15,  2.415699944743216e-17, -5.147725786358495e-19,  3.633833826356912e-02, -1.272858862810647e-03,  3.771646237257750e-05,
 -9.929462035900468e-07,  2.390584187959948e-08, -5.372103535238234e-10,  1.142076401336737e-11, -2.318042018532754e-13,  4.521137642761147e-15, -8.514907950513451e-17,
  1.554295242888242e-18, -2.757257503242846e-20,  2.192887912190994e-02, -5.005030004204971e-04,  9.270061890825739e-06, -1.597651673263771e-07,  2.638773860468031e-09,
 -4.216568338149819e-11,  6.550620248458106e-13, -9.929177921948557e-15,  1.472579090265290e-16, -2.142340195782659e-18,  3.060748065716863e-20, -4.312635332038154e-22,
  9.639683293057930e-06, -4.130202351532854e-06,  9.490657289135988e-07, -1.484271898062556e-07,  1.758197002551458e-08, -1.676115462793115e-09,  1.337117723023693e-10,
 -9.172098208118070e-12,  5.519359820620364e-13, -2.958611784445225e-14,  1.429978501422940e-15, -6.283850339782551e-17,  2.023559151310009e-05, -7.778674366662680e-06,
  1.605912151122592e-06, -2.277970646553827e-07,  2.471530287261412e-08, -2.177524241158121e-09,  1.618316219858487e-10, -1.041535698120487e-11,  5.917397694254793e-13,
 -3.011509740484394e-14,  1.388771931941494e-15, -5.849212622292145e-17,  7.081008379515180e-05, -2.227407114779196e-05,  3.807460457556299e-06, -4.556652288846074e-07,
  4.244115523786554e-08, -3.259297376974649e-09,  2.139669023329281e-10, -1.230715628846666e-11,  6.313970487573178e-13, -2.928429005862435e-14,  1.240873108864768e-15,
 -4.838604875789298e-17,  3.074315598959005e-04, -7.383013504723777e-05,  9.926217611887956e-06, -9.598651612194134e-07,  7.386006973752554e-08, -4.773722910853833e-09,
  2.679511378330317e-10, -1.335975614649690e-11,  6.013331508633018e-13, -2.473320029322655e-14,  9.384026715356266e-16, -3.305721409965397e-17,  1.309657685155738e-03,
 -2.279339396472135e-04,  2.338422317823187e-05, -1.783727314753531e-06,  1.110184130043470e-07, -5.921211820528038e-09,  2.788833361557028e-10, -1.183546146742421e-11,
  4.591430257928149e-13, -1.645804516922441e-14,  5.496463724316668e-16, -1.720167245917974e-17,  4.698018715458937e-03, -5.669330950382417e-04,  4.351431162957516e-05,
 -2.577914827195870e-06,  1.280067699248705e-07, -5.561123349071979e-09,  2.169981895763070e-10, -7.740013681340194e-12,  2.555353579441955e-13, -7.881884880597431e-15,
  2.287697076851389e-16, -6.279787255728473e-18,  1.288453008291397e-02, -1.032326408402155e-03,  5.824172629133660e-05, -2.640782338023198e-06,  1.032260336794456e-07,
 -3.606627336150361e-09,  1.151507236868654e-10, -3.409699228693499e-12,  9.462994850361230e-14, -2.480919232480459e-15,  6.181513364288488e-17, -1.470055140959601e-18,
  2.512068003643241e-02, -1.281421204298294e-03,  5.177637245284991e-05, -1.761460944412337e-06,  5.320159179781255e-08, -1.468676659364073e-09,  3.771932974803871e-11,
 -9.119871972211530e-13,  2.093518200598834e-14, -4.591617327596934e-16,  9.668792651738138e-18, -1.961527208132687e-19,  3.178311538419033e-02, -1.013015871359232e-03,
  2.778435811528596e-05, -6.834588452837021e-07,  1.545075052553250e-08, -3.271053210279125e-10,  6.568437878259563e-12, -1.261985202362331e-13,  2.334284099910547e-15,
 -4.176293252756092e-17,  7.252068055825739e-19, -1.225684454726565e-20,  2.006398120838246e-02, -4.333524623085281e-04,  7.580902751354234e-06, -1.235228761938720e-07,
  1.932633308860989e-09, -2.931156330627286e-11,  4.329141949173901e-13, -6.247266770113265e-15,  8.826454825888588e-17, -1.226604331596770e-18,  1.666010292458000e-20,
 -2.262624870164973e-22,  1.447728698801030e-06, -6.167568285612989e-07,  1.409138478608878e-07, -2.192282898928220e-08,  2.584632328752499e-09, -2.453500418933298e-10,
  1.949763159457928e-11, -1.332808085191502e-12,  7.994869725049873e-14, -4.273213330495783e-15,  2.059897930239841e-16, -9.030000081434995e-18,  3.901381210953368e-06,
 -1.453075705511148e-06,  2.912480272390775e-07, -4.024735298901845e-08,  4.267423911050545e-09, -3.684228142267965e-10,  2.689256928466181e-11, -1.703281715370460e-12,
  9.539498507482538e-14, -4.792938410265055e-15,  2.184888163328086e-16, -9.107008262451164e-18,  1.950020318867419e-05, -5.733502500100853e-06,  9.235207804998384e-07,
 -1.049495073516914e-07,  9.340555641245028e-09, -6.889740267619761e-10,  4.363086059858104e-11, -2.429775328190059e-12,  1.210719323331568e-13, -5.468918672701990e-15,
  2.262390715445653e-16, -8.631376244088421e-18,  1.190199355768414e-04, -2.589262899951695e-05,  3.207481865742034e-06, -2.890131920198406e-07,  2.089777371728016e-08,
 -1.277645062113989e-09,  6.820731121288499e-11, -3.249253706627722e-12,  1.402873899622675e-13, -5.553850207838178e-15,  2.034380490121889e-16, -6.938090613632988e-18,
  6.696857381497648e-04, -1.033781610233333e-04,  9.658543682244488e-06, -6.797337297367197e-07,  3.939451926068353e-08, -1.970289570575574e-09,  8.751385174011920e-11,
 -3.519060414697413e-12,  1.298786273461385e-13, -4.444841829509412e-15,  1.421731168893867e-16, -4.273805792390052e-18,  2.970542271865932e-03, -3.146635002436293e-04,
  2.194667727009897e-05, -1.196510542365752e-06,  5.516562295717415e-08, -2.240051441447627e-09,  8.212913992783256e-11, -2.764569807608187e-12,  8.645862128818090e-14,
 -2.534442463682436e-15,  7.011565299536103e-17, -1.839470815542792e-18,  9.519862104928101e-03, -6.697185584523197e-04,  3.449217685052865e-05, -1.443284854987425e-06,
  5.246808436327510e-08, -1.714631988148838e-09,  5.143452642977460e-11, -1.436281598953467e-12,  3.771157285392503e-14, -9.379752979725056e-16,  2.222774939934936e-17,
 -5.039099134362554e-19,  2.070738818544659e-02, -9.392405276833300e-04,  3.491537015773138e-05, -1.103530252466886e-06,  3.114726173605709e-08, -8.071089109075010e-10,
  1.952592992998462e-11, -4.460077387248699e-13,  9.696787945787527e-15, -2.018603905406781e-16,  4.042694734191802e-18, -7.813857077303028e-20,  2.812899981927771e-02,
 -8.197913833514302e-04,  2.087502726515114e-05, -4.810840097668174e-07,  1.023723209404405e-08, -2.046370759934362e-10,  3.889166949711872e-12, -7.086427033306748e-14,
  1.245116777223398e-15, -2.119764832852584e-17,  3.506159347795003e-19, -5.653655703930718e-21,  1.844316574121549e-02, -3.781498216587996e-04,  6.266494295499308e-06,
 -9.678028603789362e-08,  1.437624310714076e-09, -2.073818312925480e-11,  2.917101581787136e-13, -4.017951220187274e-15,  5.403571628478861e-17, -7.238095918923499e-19,
  9.229336827293319e-21, -1.224824279143679e-22,  2.206028247652914e-07, -9.329736149521539e-08,  2.116340003089505e-08, -3.271178891720208e-09,  3.834290397288082e-10,
 -3.620939368662082e-11,  2.864184067686166e-12, -1.949727191774730e-13,  1.165146830539515e-14, -6.206397776338899e-16,  2.982494892189741e-17, -1.303739037585779e-18,
  8.028565128557456e-07, -2.873216044761173e-07,  5.552282075012987e-08, -7.431429683861058e-09,  7.662743109402726e-10, -6.455522440495506e-11,  4.611416773808443e-12,
 -2.865284854979010e-13,  1.577592690557080e-14, -7.806251337243224e-16,  3.510110974302186e-17, -1.445186067483953e-18,  5.928427477687324e-06, -1.609284428358172e-06,
  2.420757690497734e-07, -2.593303039342483e-08,  2.191916584787636e-09, -1.544618616236993e-10,  9.391188506962433e-12, -5.042067369615937e-13,  2.430813676274094e-14,
 -1.065665977187916e-15,  4.290212974872943e-17, -1.596789543777598e-18,  5.084526700202795e-05, -9.908692689904724e-06,  1.123584591363783e-06, -9.384854238038880e-08,
  6.348307926579366e-09, -3.656773844190264e-10,  1.849914827790383e-11, -8.391409720100229e-13,  3.464169330101663e-14, -1.316051021535851e-15,  4.640830277796001e-17,
 -1.528102557255395e-18,  3.709945269147936e-04, -5.041272307741690e-05,  4.278210356077940e-06, -2.771714085468585e-07,  1.492882894292027e-08, -6.988547491672126e-10,
  2.921945672176407e-11, -1.111264472133332e-12,  3.894805076415463e-14, -1.270284566637712e-15,  3.884422585066295e-17, -1.119546617377053e-18,  1.989535391769583e-03,
 -1.843376838523896e-04,  1.169253407491670e-05, -5.867830498431731e-07,  2.512318546821824e-08, -9.534743682386138e-10,  3.284070753744911e-11, -1.042899234886104e-12,
  3.088144838775008e-14, -8.598404825571396e-16,  2.265811710489847e-17, -5.676782491739901e-19,  7.300361235706145e-03, -4.510171300974176e-04,  2.126307762094416e-05,
 -8.226328862871006e-07,  2.785391891303129e-08, -8.524197901449433e-10,  2.404835078929805e-11, -6.337786385201768e-13,  1.575308243761594e-14, -3.718751706514413e-16,
  8.384162503323002e-18, -1.812233532004902e-19,  1.743573221286323e-02, -7.054951317645654e-04,  2.420267912925033e-05, -7.125410582535869e-07,  1.883606751647827e-08,
 -4.590268046500851e-10,  1.047826998881123e-11, -2.264375296505726e-13,  4.669019622506757e-15, -9.234947118498528e-17,  1.760910597817852e-18, -3.245692392995252e-20,
  2.515083112108430e-02, -6.733798189544055e-04,  1.596449451827823e-05, -3.455605474074659e-07,  6.937764341622294e-09, -1.312242643612470e-10,  2.364867113924612e-12,
 -4.094421279126412e-14,  6.843073237082457e-16, -1.110721626975365e-17,  1.752195944366153e-19, -2.697137341589077e-21,  1.702398844738834e-02, -3.323015145091924e-04,
  5.230591101097839e-06, -7.675103711949391e-08,  1.084674524562752e-09, -1.491354569697092e-11,  1.999511502304353e-13, -2.643814587293718e-15,  3.350452463479461e-17,
 -4.431392949734229e-19,  5.227778116882416e-21, -6.388669082870952e-23,  3.424079601284337e-08, -1.434413955045485e-08,  3.224008256710484e-09, -4.942577223897655e-10,
  5.751637806892845e-11, -5.396983666856511e-12,  4.244896920040742e-13, -2.875037497266577e-14,  1.710339246491365e-15, -9.073389877252284e-17,  4.344179784135416e-18,
 -1.892640341629977e-19,  1.786107904409279e-07, -6.077070557522457e-08,  1.122607023963342e-08, -1.445197412892727e-09,  1.440750706252439e-10, -1.178548247017462e-11,
  8.203748825257956e-13, -4.982109492737044e-14,  2.687930881841070e-15, -1.306159041553396e-16,  5.778673391027914e-18, -2.344852588193859e-19,  2.003051508140619e-06,
 -4.951738640004675e-07,  6.891980949471154e-08, -6.908728857477126e-09,  5.510988767576656e-10, -3.689954461004929e-11,  2.143465027504476e-12, -1.104627820368951e-13,
  5.132078014993632e-15, -2.175657207799394e-16,  8.495427850960838e-18, -3.075190859176785e-19,  2.391834830692940e-05, -4.129242560052999e-06,  4.262192978928039e-07,
 -3.285262380890083e-08,  2.070956776333623e-09, -1.120004531284819e-10,  5.351705860238956e-12, -2.304469820350912e-13,  9.069718723655136e-15, -3.297233389551161e-16,
  1.116325147151350e-17, -3.539770799485674e-19,  2.213202970765974e-04, -2.628917330074744e-05,  2.023693824520751e-06, -1.205222284427147e-07,  6.025153600385445e-09,
 -2.636540415431716e-10,  1.036295053434770e-11, -3.722430065551889e-13,  1.237191654582619e-14, -3.839848588083551e-16,  1.120863664480765e-17, -3.092589641840370e-19,
  1.402705018273919e-03, -1.133427858023514e-04,  6.549406326388220e-06, -3.027763239287421e-07,  1.204532773578051e-08, -4.274199730063943e-10,  1.383274186910840e-11,
 -4.144159641772081e-13,  1.161763172178710e-14, -3.071623625003885e-16,  7.706922596815786e-18, -1.843134089486537e-19,  5.783194015180829e-03, -3.139408432212162e-04,
  1.359011853343313e-05, -4.871454533321012e-07,  1.538895334290575e-08, -4.416366012042528e-10,  1.173195983159248e-11, -2.920604389731730e-13,  6.878181859865075e-15,
 -1.541949938609495e-16,  3.308889296105753e-18, -6.822653622698124e-20,  1.495325469006016e-02, -5.415708001479722e-04,  1.719651537880396e-05, -4.728316032329732e-07,
  1.173254574101232e-08, -2.693951672770857e-10,  5.812801659384024e-12, -1.189983312684774e-13,  2.330863648541674e-15, -4.384678715439244e-17,  7.967145306862924e-19,
 -1.402907774788181e-20,  2.268890535983701e-02, -5.605448923919461e-04,  1.240620719012692e-05, -2.528179826773510e-07,  4.799365472179745e-09, -8.607653532407770e-11,
  1.473337551725257e-12, -2.429322895593335e-14,  3.865212584728423e-16, -5.992178793919662e-18,  9.043619652915114e-20, -1.324565755953623e-21,  1.577302738775458e-02,
 -2.938668953347128e-04,  4.404645154428870e-06, -6.154484077453104e-08,  8.289641552533716e-10, -1.089530656118108e-11,  1.387958839852105e-13, -1.791270284755971e-15,
  2.075685438545386e-17, -2.773704718127388e-19,  3.358480015245471e-21, -2.293311526684229e-23,  5.443025219643956e-09, -2.251505160776870e-09,  5.000242263545890e-10,
 -7.585469667079843e-11,  8.746713127657362e-12, -8.142019126067768e-13,  6.359146522417398e-14, -4.280372729632495e-15,  2.532371115255499e-16, -1.336833449354598e-17,
  6.372310401144161e-19, -2.765230740595137e-20,  4.356496803811137e-08, -1.390582959896171e-08,  2.430782964999146e-09, -2.985308594789935e-10,  2.857900761951299e-11,
 -2.256896932545743e-12,  1.523292103886871e-13, -9.002806999605043e-15,  4.741539665903035e-16, -2.255182457664478e-17,  9.787854375442685e-19, -3.904127261673934e-20,
  7.554990217936074e-07, -1.675918078656446e-07,  2.138719989006720e-08, -1.991685801944702e-09,  1.490256907057870e-10, -9.430117563786393e-12,  5.208566003582247e-13,
 -2.565238402079753e-14,  1.143917368302269e-15, -4.672074161415853e-17,  1.763396987394693e-18, -6.188295500447402e-20,  1.234109109851957e-05, -1.866919852395049e-06,
  1.746558437647666e-07, -1.237783762166796e-08,  7.248514053460152e-10, -3.669772903393089e-11,  1.651705446604793e-12, -6.733692819630458e-14,  2.520101172779588e-15,
 -8.745207922084607e-17,  2.835769856155404e-18, -8.638768103676694e-20,  1.412607722919971e-04, -1.457361978065714e-05,  1.017553752005915e-06, -5.566771631798002e-08,
  2.581398038655043e-09, -1.055111194642017e-10,  3.895439102439388e-12, -1.320343327073548e-13,  4.157188328814707e-15, -1.226491229479481e-16,  3.413557976788347e-18,
 -9.005344693843001e-20,  1.035009159289533e-03, -7.275387260028189e-05,  3.839565227196458e-06, -1.637025187281083e-07,  6.057292378918455e-09, -2.010947938572103e-10,
  6.118643057243074e-12, -1.729758105467448e-13,  4.591743982103765e-15, -1.152861608666788e-16,  2.753688872238192e-18, -6.285230495734372e-20,  4.712984099484288e-03,
 -2.250011660953727e-04,  8.973141143631031e-06, -2.986762761023297e-07,  8.819184875083779e-09, -2.376730336917013e-10,  5.954182943863887e-12, -1.401277574504886e-13,
  3.130268586731688e-15, -6.670275392834771e-17,  1.362525824383828e-18, -2.683011154091215e-20,  1.303020180382091e-02, -4.238686435901938e-04,  1.249284582694365e-05,
 -3.216321664567869e-07,  7.507910861955669e-09, -1.627081441013909e-10,  3.325511979083587e-12, -6.454762988410597e-14,  1.203317399981615e-15, -2.156572831743357e-17,
  3.729613660876468e-19, -6.300459168934507e-21,  2.062769583303361e-02, -4.722444790932348e-04,  9.781966849288980e-06, -1.880876027564193e-07,  3.382798825830367e-09,
 -5.765821053725067e-11,  9.382482682999428e-13, -1.477744706958833e-14,  2.240203638458163e-16, -3.311790232343837e-18,  4.833099817007022e-20, -6.671570458652354e-22,
  1.466365459310836e-02, -2.613738727552474e-04,  3.739039411583325e-06, -4.985948541575881e-08,  6.406584373045852e-10, -8.099352781322723e-12,  9.661457263913403e-14,
 -1.262278983335741e-15,  1.303393738402561e-17, -1.538307126291883e-19,  3.019811085874460e-21,  4.425728265033614e-24,  8.928880139282323e-10, -3.630162707674355e-10,
  7.934738279772288e-11, -1.187327325427215e-11,  1.353086816622080e-12, -1.246834430417693e-13,  9.652751552351378e-15, -6.447473696082218e-16,  3.788710719773335e-17,
 -1.988081006249845e-18,  9.426086792222480e-20, -4.070914262135117e-21,  1.182191431211651e-08, -3.482494609085019e-09,  5.693197454078813e-10, -6.608428399637900e-11,
  6.028503911442663e-12, -4.566095590865229e-13,  2.971521371057929e-14, -1.700735227542058e-15,  8.706473379649032e-17, -4.037695156147349e-18,  1.713337621551152e-19,
 -6.697619224430145e-21,  3.186600077470766e-07, -6.244835769647655e-08,  7.246081950824791e-09, -6.226817166318047e-10,  4.345623560684693e-11, -2.585728454015881e-12,
  1.351772106236854e-13, -6.335691094499536e-15,  2.701173572929730e-16, -1.059011193064099e-17,  3.850367564377062e-19, -1.305766770663530e-20,  6.946400980673654e-06,
 -9.110631442930680e-07,  7.703876933323195e-08, -5.005936733386775e-09,  2.716902927387942e-10, -1.284733004670600e-11,  5.434691277644531e-13, -2.093099598884842e-14,
  7.432899092147004e-16, -2.456843976394689e-17,  7.614006593104728e-19, -2.223692673369879e-20,  9.583130592678828e-05, -8.535773563883311e-06,  5.412910658217974e-07,
 -2.719830634491857e-08,  1.169905785317816e-09, -4.465117053578945e-11,  1.547991806962926e-12, -4.948193524700011e-14,  1.474959385948936e-15, -4.133612490222282e-17,
  1.095962901461982e-18, -2.761962302636019e-20,  7.949649249136057e-04, -4.850842778919590e-05,  2.345883407957409e-06, -9.237289167079315e-08,  3.183490250760715e-09,
 -9.895362203437679e-11,  2.833615540572722e-12, -7.562115880013095e-14,  1.901466829163426e-15, -4.536166249991149e-17,  1.031211133105194e-18, -2.246668609386833e-20,
  3.936816914918553e-03, -1.654703835568564e-04,  6.100743732264763e-06, -1.889882513364904e-07,  5.227207375897654e-09, -1.324294034775492e-10,  3.135435200606278e-12,
 -6.980174032023777e-14,  1.480084319924517e-15, -3.005533973858310e-17,  5.835590912406849e-19, -1.099005822352379e-20,  1.151275780307493e-02, -3.375439737844184e-04,
  9.259170101887364e-06, -2.237469115873193e-07,  4.925256160981362e-09, -1.008590752658823e-10,  1.958316367797672e-12, -3.605054501767929e-14,  6.399350337529990e-16,
 -1.099813782725065e-17,  1.797323191147097e-19, -2.925337836526421e-21,  1.888212740265605e-02, -4.021771633714803e-04,  7.815220903264619e-06, -1.420920571462742e-07,
  2.425062353387477e-09, -3.939352967327170e-11,  6.092799209934152e-13, -9.193693786253322e-15,  1.335618697831317e-16, -1.854825763232693e-18,  2.681679890895827e-20,
 -3.489027412809167e-22,  1.367442515570693e-02, -2.336921025840048e-04,  3.197260404202115e-06, -4.079008766798091e-08,  4.992209721315722e-10, -6.161868237546598e-12,
  6.644685055893614e-14, -9.099146888742748e-16,  9.743411910873044e-18, -2.676344829371297e-20,  3.327741466568584e-21,  3.412277923535426e-24,  1.527894458480298e-10,
 -6.063325111123231e-11,  1.297048125850437e-11, -1.905898014923573e-12,  2.138917255598836e-13, -1.945415433105258e-14,  1.489343196732264e-15, -9.852105148653936e-17,
  5.740717235980550e-18, -2.990143687888668e-19,  1.408471573840226e-20, -6.047704064017495e-22,  3.619391232673590e-09, -9.647208219379285e-10,  1.456015497746382e-10,
 -1.581214405896152e-11,  1.363065485898561e-12, -9.831622195137455e-14,  6.131078412032464e-15, -3.379893871169541e-16,  1.673749704971501e-17, -7.536312021968715e-19,
  3.114713036370373e-20, -1.189206431296219e-21,  1.501326757899954e-07, -2.557448864572457e-08,  2.679514383305360e-09, -2.112227106597834e-10,  1.368107720137243e-11,
 -7.620195452748417e-13,  3.754963770201810e-14, -1.668365571682060e-15,  6.775653892385412e-17, -2.541135176718438e-18,  8.870783154015453e-20, -2.898086540806910e-21,
  4.237691695879803e-06, -4.768856964586465e-07,  3.641883108265552e-08, -2.165412408697801e-09,  1.087638940180610e-10, -4.795562904704663e-12,  1.903623630757527e-13,
 -6.914583995293388e-15,  2.325859737838527e-16, -7.310067585837778e-18,  2.161298521090361e-19, -6.040527664382814e-21,  6.865563036422886e-05, -5.249506782078915e-06,
  3.032019452772288e-07, -1.399557837704722e-08,  5.588428143874377e-10, -1.991432139155153e-11,  6.484516134348914e-13, -1.954567976589194e-14,  5.513057309060019e-16,
 -1.467412381707738e-17,  3.703909117247765e-19, -8.911016020253746e-21,  6.324955763152935e-04, -3.343888436513800e-05,  1.487977127380215e-06, -5.418766991272412e-08,
  1.743009481566116e-09, -5.074560967542916e-11,  1.369823793629238e-12, -3.453966315576244e-14,  8.222637383646474e-16, -1.867492972643672e-17,  4.038491106187421e-19,
 -8.396563878688626e-21,  3.359955889638686e-03, -1.244917467923499e-04,  4.258928337697175e-06, -1.230326437413649e-07,  3.196750013884019e-09, -7.613970242889089e-11,
  1.708773749770444e-12, -3.604610665472626e-14,  7.233051514828003e-16, -1.410417985318503e-17,  2.594942266694303e-19, -4.660401453862336e-21,  1.029543204643972e-02,
 -2.730090597096309e-04,  6.987889837412289e-06, -1.588324332894899e-07,  3.306877088095567e-09, -6.398028008641738e-11,  1.184675221109425e-12, -2.073753227245224e-14,
  3.474873258997077e-16, -5.841621182803210e-18,  8.927025974421372e-20, -1.375703637739499e-21,  1.738852157803156e-02, -3.458713160528681e-04,  6.319276254565890e-06,
 -1.088790811412847e-07,  1.764826574170263e-09, -2.743191058198319e-11,  4.029726076448091e-13, -5.807762196768944e-15,  8.289249158109061e-17, -1.036544951870315e-18,
  1.517659570063566e-20, -1.994454921888670e-22,  1.278789287737756e-02, -2.099449989997298e-04,  2.751896254494046e-06, -3.370983524038171e-08,  3.900488160783987e-10,
 -4.837616021748159e-12,  4.537197983761374e-14, -5.880451735233265e-16,  1.113460669091725e-17,  1.002911372108207e-19,  2.732569715405940e-21, -3.652395879173504e-23,
  2.769715219545670e-11, -1.061493213694760e-11,  2.204205763329989e-12, -3.160581813464190e-13,  3.475786516361817e-14, -3.108062707761225e-15,  2.345412053257025e-16,
 -1.532514959123745e-17,  8.835413539611405e-19, -4.559737524306938e-20,  2.130501837378153e-21, -9.083121756128069e-23,  1.264958754055161e-09, -2.980911123968327e-10,
  4.098673932468244e-11, -4.120654442686751e-12,  3.327665143754380e-13, -2.268722113548635e-14,  1.346906585874521e-15, -7.110523576038111e-17,  3.388668801542767e-18,
 -1.474560494510288e-19,  5.910975179060086e-21, -2.195968203466238e-22,  7.870268228284021e-08, -1.146005086986140e-08,  1.079159823006373e-09, -7.764201596905506e-11,
  4.648949812450776e-12, -2.414628281493669e-13,  1.117539137880128e-14, -4.691017655592447e-16,  1.808836175410720e-17, -6.468970705961681e-19,  2.161603757363775e-20,
 -6.783193611962047e-22,  2.782129235365177e-06, -2.658421978749487e-07,  1.836501636171789e-08, -9.975594519388092e-10,  4.635405545263138e-11, -1.903400949357269e-12,
  7.082861685563081e-14, -2.423891287929261e-15,  7.711890202065063e-17, -2.301882302669049e-18,  6.483518928884084e-20, -1.731498253788626e-21,  5.162580271457112e-05,
 -3.369246977247578e-06,  1.780655709773846e-07, -7.550392278602185e-09,  2.804059047134508e-10, -9.327426663194007e-12,  2.854094706934355e-13, -8.119557478355516e-15,
  2.164749777436987e-16, -5.476131720121095e-18,  1.315488254954057e-19, -3.018879239270821e-21,  5.190098894035684e-04, -2.372894496815973e-05,  9.765629654553089e-07,
 -3.291487732555537e-08,  9.916045149507636e-10, -2.702718403963364e-11,  6.886666273101458e-13, -1.646802933219201e-14,  3.695849420568548e-16, -8.027779922106663e-18,
  1.652843101569706e-19, -3.266330730796097e-21,  2.921872607021298e-03, -9.555915809487763e-05,  3.045554086227371e-06, -8.214023474506911e-08,  2.014067534396629e-09,
 -4.503148138583178e-11,  9.594514633089796e-13, -1.936204897705273e-14,  3.618946617548420e-16, -6.881402385497225e-18,  1.207019834003303e-19, -2.011664295958065e-21,
  9.304283952110968e-03, -2.239185369875785e-04,  5.361647933299441e-06, -1.147915111481848e-07,  2.270311280027130e-09, -4.143166892826619e-11,  7.323933301447904e-13,
 -1.239551370731233e-14,  1.893258379986109e-16, -3.220383185373390e-18,  4.727963486392387e-20, -6.152891455687429e-22,  1.609849663381836e-02, -3.001018056163430e-04,
  5.165608750705936e-06, -8.455578623039530e-08,  1.301146532994284e-09, -1.944292449496657e-11,  2.726246183209587e-13, -3.650776376557796e-15,  5.460793644804761e-17,
 -5.819569192906096e-19,  7.998418471894800e-21, -1.380227648420330e-22,  1.198972181215455e-02, -1.894488012444451e-04,  2.381808296940909e-06, -2.818873212114899e-08,
  3.030767628731724e-10, -3.902016407873312e-12,  3.456464506401920e-14, -1.571169188057537e-16,  1.615543659690334e-17,  1.583432244026000e-19, -3.647918542122622e-22,
 -1.105535291424634e-22,  5.437987067423677e-12, -1.979307551321786e-12,  3.942745580662645e-13, -5.468092955383903e-14,  5.852587171875136e-15, -5.117558239135875e-16,
  3.790190865214878e-17, -2.437640921622729e-18,  1.386497436892817e-19, -7.072509929174991e-21,  3.271335826424746e-22, -1.382452309548325e-23,  5.086632604266725e-10,
 -1.031928127325053e-10,  1.277074209516426e-11, -1.176299928109328e-12,  8.824446043882064e-14, -5.644781404907571e-15,  3.169555597591251e-16, -1.592940922431741e-17,
  7.266847574238571e-19, -3.041137067833396e-20,  1.177190274340991e-21, -4.238268263969676e-23,  4.562652246046139e-08, -5.579617767422761e-09,  4.717230142014971e-10,
 -3.083593993931064e-11,  1.702427310941996e-12, -8.220118881747585e-14,  3.562806868592969e-15, -1.409069160398144e-16,  5.143845421722676e-18, -1.749463796166288e-19,
  5.580483495800424e-21, -1.677545604032236e-22,  1.951408732737479e-06, -1.565868530016345e-07,  9.834421196447364e-09, -4.869667865083712e-10,  2.095880111025289e-11,
 -8.008595932257911e-13,  2.790961808226077e-14, -9.000459200417412e-16,  2.704341803975648e-17, -7.661037049165028e-19,  2.053837500520286e-20, -5.232996978760395e-22,
  4.051565551163900e-05, -2.242964236798830e-06,  1.092475370021928e-07, -4.249348561266612e-09,  1.473271422536551e-10, -4.574379148967798e-12,  1.313777031281175e-13,
 -3.543787217964014e-15,  8.898667203139112e-17, -2.142061514141037e-18,  4.908696358444697e-20, -1.069360634433318e-21,  4.375507041238258e-04, -1.726257720520210e-05,
  6.614723175562615e-07, -2.061128641274274e-08,  5.849112431398465e-10, -1.492353116996995e-11,  3.573870280707108e-13, -8.224787378559409e-15,  1.717158863317148e-16,
 -3.577542084181462e-18,  7.135335536601441e-20, -1.298231730856261e-21,  2.582814567426870e-03, -7.465077845945263e-05,  2.227100932024967e-06, -5.603248480812108e-08,
  1.305693850643476e-09, -2.740105961149897e-11,  5.479728941636284e-13, -1.096006416744081e-14,  1.836621664187845e-16, -3.406457210626936e-18,  6.171138443139792e-20,
 -8.081108325555851e-22,  8.486467942860836e-03, -1.859751329266466e-04,  4.177552875069804e-06, -8.424749835034651e-08,  1.592466605852400e-09, -2.742973843191065e-11,
  4.550475075860207e-13, -7.871166741135072e-15,  1.022324571963095e-16, -1.728094453141946e-18,  3.053656075857382e-20, -1.716398711361644e-22,  1.497477630355219e-02,
 -2.625091039852974e-04,  4.264081705735205e-06, -6.652423846470924e-08,  9.703834674848799e-10, -1.394657102201270e-11,  1.920905911914432e-13, -2.188389448920496e-15,
  3.798746921626825e-17, -3.808010315847075e-19,  1.977181560856738e-21, -1.499042902967483e-22,  1.126800212328463e-02, -1.716705982961691e-04,  2.070208135367974e-06,
 -2.391913462113570e-08,  2.332986442823837e-10, -3.061942753585385e-12,  3.817520615569104e-14,  4.367465085611032e-16,  2.010989672413507e-17,  1.072533257599322e-20,
 -8.116473172557895e-21, -2.634327307061831e-22,  1.193135048733385e-12, -4.015149770432898e-13,  7.545032017601298e-14, -9.997143681280468e-15,  1.031742087236149e-15,
 -8.757953661320993e-17,  6.329256376272592e-18, -3.987951928809852e-19,  2.229269514696282e-20, -1.120429202467330e-21,  5.116824093933531e-23, -2.138641230103808e-24,
  2.360486350938523e-10, -3.997938318607991e-11,  4.416357130817920e-12, -3.689738598148203e-13,  2.552371802149765e-14, -1.521328505508905e-15,  8.028785657030251e-17,
 -3.819641621549975e-18,  1.659144062213642e-19, -6.645335852833074e-21,  2.472737657905229e-22, -8.591640460033430e-24,  2.903235153962765e-08, -2.923180329524468e-09,
  2.229248372521576e-10, -1.317200357505512e-11,  6.699755098293183e-13, -3.001271835673560e-14,  1.214863083979660e-15, -4.519984291460062e-17,  1.558038552640497e-18,
 -5.028198000827715e-20,  1.527898330500347e-21, -4.388131156552138e-23,  1.452099174101648e-06, -9.660233086077309e-08,  5.572396206004313e-09, -2.504568512376406e-10,
  1.001341497884179e-11, -3.564149715598485e-13,  1.159181600966296e-14, -3.535410956548226e-16,  1.000825227679983e-17, -2.686854263429290e-19,  6.874879467151168e-21,
 -1.661870216225526e-22,  3.301743776503583e-05, -1.538866502614421e-06,  6.985461068647000e-08, -2.481441632959584e-09,  8.073642727344492e-11, -2.349925656942915e-12,
  6.267472417486350e-14, -1.626931335803450e-15,  3.826884576079851e-17, -8.681254832179433e-19,  1.948031591284803e-20, -3.891407551285237e-22,  3.777155822526695e-04,
 -1.282104866205978e-05,  4.617584080241647e-07, -1.324291789008247e-08,  3.563275664348015e-10, -8.590571119713635e-12,  1.880325597955546e-13, -4.332941617509905e-15,
  8.327739893674959e-17, -1.575322861820569e-18,  3.462465633120422e-20, -4.840509259734753e-22,  2.316038343133487e-03, -5.920586278329660e-05,  1.664028479687054e-06,
 -3.890468341987455e-08,  8.673373993549428e-10, -1.736591459673980e-11,  3.079974841555343e-13, -6.624506943532426e-15,  9.893166321254777e-17, -1.430888616916351e-18,
  4.174463676700737e-20, -1.675074846874835e-22,  7.803566417366074e-03, -1.562036242912448e-04,  3.303088004328136e-06, -6.263234703430264e-08,  1.136927895187828e-09,
 -1.883293648774744e-11,  2.727300755901161e-13, -5.367586177319921e-15,  6.117648506086134e-17, -5.505788810147620e-19,  3.074818581683121e-20,  1.512688150105988e-22,
  1.398825596627534e-02, -2.313453348286347e-04,  3.550502987299897e-06, -5.299758991557108e-08,  7.332475718030700e-10, -9.946796504040592e-12,  1.458011059079591e-13,
 -1.191052628058350e-15,  2.391179099913204e-17, -4.565063621274909e-19, -6.404928107286912e-21, -2.334395338704191e-22,  1.061270909540274e-02, -1.561978992858127e-04,
  1.803730025860619e-06, -2.062104298713083e-08,  1.825795089974364e-10, -1.928798158701757e-12,  5.887198522481668e-14,  9.967314139616909e-16,  1.118677244107061e-17,
 -6.201711285371204e-19, -2.526877278163666e-20, -5.028539493981566e-22,  3.052084043402593e-13, -9.091480725497008e-14,  1.576428879715825e-14, -1.962689064032845e-15,
  1.929311837140153e-16, -1.574614444818062e-17,  1.101946542830794e-18, -6.760409553027629e-20,  3.695435762699987e-21, -1.822463460185210e-22,  8.189316072419321e-24,
 -3.375612602025082e-25,  1.261825331803229e-10, -1.719385593607096e-11,  1.695577303805921e-12, -1.271624112749364e-13,  8.066012078116395e-15, -4.454066026089072e-16,
  2.196273511001593e-17, -9.842556078820723e-19,  4.050132100702982e-20, -1.545311069677109e-21,  5.503844200543799e-23, -1.837551589377562e-24,  2.011325617542424e-08,
 -1.626919651664223e-09,  1.135302924113244e-10, -6.017105676381245e-12,  2.820750748154942e-13, -1.173792337770878e-14,  4.414804157883650e-16, -1.546948446026078e-17,
  5.024850447902129e-19, -1.533135209023402e-20,  4.444319221885635e-22, -1.213452212812056e-23,  1.139050438824796e-06, -6.177939895139815e-08,  3.334085965860478e-09,
 -1.349657763697676e-10,  5.020351509384162e-12, -1.681532520145235e-13,  5.031491866672856e-15, -1.465409715465018e-16,  3.925187403491188e-18, -9.789089543835555e-20,
  2.455984111573271e-21, -5.531041894898525e-23,  2.781793530422060e-05, -1.080287337393130e-06,  4.650475703432005e-08, -1.497240681948654e-09,  4.569983261448983e-11,
 -1.278219496293346e-12,  3.047425518112173e-14, -7.796410398398718e-16,  1.777677233266322e-17, -3.410477360658873e-19,  8.590122927311967e-21, -1.506151915273503e-22,
  3.329344554041007e-04, -9.677369867696374e-06,  3.320743567983391e-07, -8.707390123177442e-09,  2.211826722262619e-10, -5.276260203561964e-12,  9.719471731787292e-14,
 -2.342383653990691e-15,  4.744840122111469e-17, -5.045988335312524e-19,  2.068912763587060e-20, -2.445646451522488e-22,  2.103183782216139e-03, -4.754921955085003e-05,
  1.270118217460164e-06, -2.746133041878417e-08,  5.806020921816639e-10, -1.187840393157172e-11,  1.613284447533043e-13, -3.970176902915484e-15,  7.635536809375123e-17,
  1.484399681635738e-19,  3.652542917911861e-20, -2.906622810329304e-22,  7.227242728837823e-03, -1.325025821022213e-04,  2.649236812158488e-06, -4.714639853808641e-08,
  8.146482683662047e-10, -1.387919245426729e-11,  1.486374207291476e-13, -3.476128340543198e-15,  6.508861330672393e-17,  7.942592653158422e-19,  3.362092735901294e-20,
 -2.780906096564360e-22,  1.311591798561715e-02, -2.052996865264445e-04,  2.978946949507713e-06, -4.267699059599377e-08,  5.669769669900273e-10, -6.778753353166582e-12,
  1.202240807068071e-13, -7.582844664690075e-16,  4.460038708501019e-19, -9.038122677062428e-19, -1.441057473019198e-20,  9.290682334725647e-25,  1.001527691252427e-02,
 -1.427105916121968e-04,  1.572807759443010e-06, -1.792173397041983e-08,  1.604860909744339e-10, -1.691823946765797e-13,  8.679884440331335e-14,  7.605960647936274e-16,
 -3.431538341074990e-17, -2.011346122444122e-18, -3.937160086090234e-20,  2.258034364774439e-22,  9.591807801561641e-14, -2.356427823480633e-14,  3.682328989705147e-15,
 -4.214715466133402e-16,  3.887143569887192e-17, -3.013453759921300e-18,  2.022281741351686e-19, -1.198590424291658e-20,  6.365366177917037e-22, -3.063895520821898e-23,
  1.348713412046425e-24, -5.462323058973753e-26,  7.726492718596998e-11, -8.067749446983292e-12,  7.223228380937744e-13, -4.800226529552166e-14,  2.780306300070931e-15,
 -1.419436907138618e-16,  6.491985769362609e-18, -2.732462906541915e-19,  1.060851227283138e-20, -3.833344099820062e-22,  1.304007715464858e-23, -4.163004874777809e-25,
  1.505351140403734e-08, -9.454932657444141e-10,  6.218615661408312e-11, -2.926364896184084e-12,  1.257892442389246e-13, -4.932135301787678e-15,  1.699846938549572e-16,
 -5.616301597532635e-18,  1.738650787737579e-19, -4.903768966047153e-21,  1.375362373032463e-22, -3.597233618099528e-24,  9.366579921776655e-07, -4.043851482657048e-08,
  2.103446014732070e-09, -7.615919012061764e-11,  2.594162658582933e-12, -8.512168370503520e-14,  2.268913599554092e-15, -6.227305445930347e-17,  1.707350021838394e-18,
 -3.538121784217867e-20,  9.028902479952125e-22, -2.261450646193504e-23,  2.414234432502718e-05, -7.694037870934872e-07,  3.219238057616433e-08, -9.372101040634838e-10,
  2.597279474515912e-11, -7.537822457505808e-13,  1.516755893103833e-14, -3.524654668648185e-16,  1.028501974850001e-17, -1.109148537634674e-19,  3.054878632607870e-21,
 -1.300519548977499e-22,  2.989516810164847e-04, -7.385863295077705e-06,  2.456935668671585e-07, -5.905303176766034e-09,  1.345061109523871e-10, -3.570711286035577e-12,
  5.113347742036136e-14, -9.798416822652832e-16,  4.093504928623124e-17,  2.488546768172265e-20,  2.323322760562275e-21, -7.112075111277271e-22,  1.931422398752524e-03,
 -3.856534926982139e-05,  9.890707674153665e-07, -1.989454333444162e-08,  3.742299026445222e-10, -9.050413118915333e-12,  8.692642295988121e-14, -1.208259896095565e-15,
  1.010780116462040e-16,  8.991817919834336e-19, -1.424402907402864e-20, -2.345849400404447e-21,  6.736323482234812e-03, -1.133701131866365e-04,  2.153074520027778e-06,
 -3.616731113441657e-08,  5.662122662526053e-10, -1.120998249147911e-11,  8.631884567352905e-14, -7.331592747724265e-16,  1.097011590599412e-16,  1.282659482981537e-18,
 -2.863347306665082e-20, -2.884772600279914e-21,  1.233934431173097e-02, -1.833717110852292e-04,  2.517266130421880e-06, -3.454079932899856e-08,  4.584030748549723e-10,
 -4.180268657322824e-12,  9.359452053688072e-14, -1.357493714780399e-15, -3.953409724183511e-17, -1.134703991100539e-18,  1.431147917618104e-20,  1.550075465055932e-21,
  9.468299661598742e-03, -1.309442187467831e-04,  1.373420936996435e-06, -1.526378564104224e-08,  1.786984665371349e-10,  1.969045307977648e-12,  8.001949238420146e-14,
 -1.730776736447424e-15, -1.247720568096061e-16, -2.464434818001016e-18,  4.610261908881650e-20,  4.175933819667548e-21,  3.905916647203075e-14, -7.064992300872267e-15,
  9.870295185665179e-16, -1.008166240115582e-16,  8.580041198180876e-18, -6.233483363697690e-19,  3.961050661637544e-20, -2.247346727516127e-21,  1.150367678945420e-22,
 -5.366128690195178e-24,  2.301991089658092e-25, -9.117133944148044e-27,  5.374241914246782e-11, -4.008373928430037e-12,  3.412016804852881e-13, -1.980785293561042e-14,
  1.034657933956270e-15, -4.946320849699161e-17,  2.071704010408998e-18, -8.134071812361773e-20,  3.009938556638110e-21, -1.012542588171924e-22,  3.277128400317617e-24,
 -1.018008706842779e-25,  1.208406993418929e-08, -5.605373637411719e-10,  3.648558075866914e-11, -1.525144201015726e-12,  5.787897852301054e-14, -2.242576514037509e-15,
  7.015317158982278e-17, -2.066336135782099e-18,  6.681438653654637e-20, -1.674404829137953e-21,  4.002389823595367e-23, -1.318546216956220e-24,  8.036176535244861e-07,
 -2.667367634025301e-08,  1.390597829774387e-09, -4.580814381817120e-11,  1.322708185154168e-12, -4.639019052676063e-14,  1.137994013933752e-15, -2.281763835490694e-17,
  8.694005126475381e-19, -1.654829838011973e-20,  8.585739002327287e-23, -1.534715022433627e-23,  2.151718689133033e-05, -5.508175633883033e-07,  2.299817068412255e-08,
 -6.251997218272809e-10,  1.391664142789078e-11, -4.741422296598786e-13,  9.403907886048928e-15, -7.591649327590686e-17,  6.953310148188906e-18, -1.195131081911869e-19,
 -3.669443873813045e-21, -1.443767252579671e-22,  2.729355186275424e-04, -5.672213405131797e-06,  1.855827671556225e-07, -4.264502851864305e-09,  7.390691756668646e-11,
 -2.524991194987584e-12,  4.188438552225168e-14,  2.891870222315323e-16,  3.423353095782609e-17, -6.796243361116998e-19, -3.890564209459318e-20, -8.160508002386102e-22,
  1.791600607015729e-03, -3.151898017503674e-05,  7.806412963412209e-07, -1.524620637142212e-08,  2.133267649064789e-10, -6.984463565888427e-12,  1.010867457964377e-13,
  2.192359162381028e-15,  9.264709943902909e-17, -2.278269130825352e-18, -1.460475996351469e-19, -2.269383431947605e-21,  6.314739382071146e-03, -9.774385026026254e-05,
  1.766388228427928e-06, -2.878838106315578e-08,  3.632463405612387e-10, -8.960234882232570e-12,  1.186433803004579e-13,  3.004179681598281e-15,  9.876915443895606e-17,
 -2.939303882148730e-18, -1.795303449711401e-19, -2.172422678159615e-21,  1.164367718070327e-02, -1.647724919329271e-04,  2.144377177634605e-06, -2.776905533320242e-08,
  3.933094728292120e-10, -2.562942157842944e-12,  3.345523088644444e-14, -3.000285354576755e-15, -4.903997600324193e-17,  1.254663044427399e-18,  1.082614422184298e-19,
  1.775181268235746e-21,  8.965410751505582e-03, -1.206373539219315e-04,  1.208981684300413e-06, -1.201065680251230e-08,  2.307580655742286e-10,  2.797794046447842e-12,
 -3.270973031542711e-14, -6.360074590991652e-15, -1.265559683614617e-16,  3.934982245529704e-18,  2.721084682049050e-19,  3.463353560559340e-21,  2.129705388051449e-14,
 -2.368299117365164e-15,  3.124068220756790e-16, -2.731805183016846e-17,  2.096161271508488e-18, -1.420349244621639e-19,  8.394890831042117e-21, -4.498528237603061e-22,
  2.211260183606642e-23, -9.887528078332500e-25,  4.091724288212003e-26, -1.586706988620938e-27,  4.197915747264957e-11, -2.008919039347193e-12,  1.772162993758798e-13,
 -9.080207336084088e-15,  4.027838880236880e-16, -1.883228426507877e-17,  7.339560615721221e-19, -2.488383952192632e-20,  9.267265125345038e-22, -3.048524946112705e-23,
  7.909864122773171e-25, -2.648209955305291e-26,  1.032815824201596e-08, -3.290131472100227e-10,  2.251179713397181e-11, -8.823626718199677e-13,  2.622223290387063e-14,
 -1.058699884838257e-15,  3.480496555512051e-17, -6.784533089920984e-19,  2.421954673011397e-20, -9.207892472078822e-22,  5.659401429877585e-24, -1.926741951682309e-25,
  7.161171230415660e-07, -1.744965315715690e-08,  9.415967159146613e-10, -3.075101198169756e-11,  6.301772173444937e-13, -2.415644456856181e-14,  7.973062796843460e-16,
 -4.929561658227608e-18,  2.148375683967384e-19, -2.148028375962542e-20, -1.394005630599335e-22,  1.096878802398803e-23,  1.963886392061961e-05, -3.936994483332304e-07,
  1.655753906540210e-08, -4.664667200177485e-10,  6.627158163619978e-12, -2.540353943043180e-13,  9.493067728069748e-15,  4.140473769016074e-17, -7.982200389755097e-19,
 -3.050050443676613e-19, -2.355087811980805e-21,  2.895999709073055e-22,  2.529156800780359e-04, -4.375606509305443e-06,  1.400262428347608e-07, -3.426797871727914e-09,
  3.461622093607532e-11, -1.333230874242721e-12,  5.927491097296213e-14,  6.615844276100074e-16, -2.059177375513367e-17, -2.200373824207698e-18, -1.147788168330078e-20,
  2.572330454683673e-21,  1.676925384841455e-03, -2.595727936159504e-05,  6.140520103801685e-07, -1.279316495458158e-08,  1.041252751959156e-10, -3.605114300950040e-12,
  1.831784731911773e-13,  2.669837746919322e-15, -9.491927245814775e-17, -7.332341218618496e-18, -1.740058865836307e-20,  9.439523651971122e-21,  5.949961269493632e-03,
 -8.490823593573447e-05,  1.450476565871462e-06, -2.422209483827780e-08,  2.205745579550944e-10, -4.894872530100659e-12,  2.210428990452763e-13,  3.089025632346293e-15,
 -1.291669499385895e-16, -8.528551745663292e-18,  6.378311176055268e-21,  1.169151864695441e-20,  1.101693286629373e-02, -1.488471731802497e-04,  1.847272068232928e-06,
 -2.187345520472276e-08,  3.426519488781809e-10, -2.871780458800522e-12, -5.936669071152235e-14, -2.959807806085392e-15,  7.654750778662110e-17,  5.205475537727968e-18,
  2.478389039481116e-20, -6.713634581431826e-21,  8.501385704842957e-03, -1.114755961187076e-04,  1.088534899023901e-06, -7.979874306758050e-09,  2.629127911971762e-10,
 -3.733152817411519e-13, -2.308116877081635e-13, -6.022838325400043e-15,  2.034698370962051e-16,  1.270402990835008e-17,  6.812058667294257e-21, -1.738127094301192e-20,
  1.533571233646403e-14, -7.715312950621174e-16,  1.185626998899151e-16, -8.734415336115279e-18,  5.559930525666210e-19, -3.601214183304546e-20,  2.001527045413608e-21,
 -9.574281225613671e-23,  4.493242472988903e-24, -2.002818921825365e-25,  7.645665826462854e-27, -2.744017672542324e-28,  3.621241926940758e-11, -9.408592128586473e-13,
  9.706512445142355e-14, -4.879566511036683e-15,  1.595152099982833e-16, -7.067401943208223e-18,  3.209038655765387e-19, -8.324569855404764e-21,  2.126662706092691e-22,
 -1.210590596542228e-23,  3.292419720325990e-25,  7.754591279371131e-28,  9.313520962648361e-09, -1.854810719299422e-10,  1.387437279839128e-11, -5.920737050294958e-13,
  1.219100069176559e-14, -3.927961006677008e-16,  2.200846957227256e-17, -3.829884750229169e-19, -3.359078222687573e-21, -4.903313330384343e-22,  2.257990751388417e-23,
  6.421587187079697e-25,  6.592488141721854e-07, -1.125169127813591e-08,  6.203913407469702e-10, -2.353573213421595e-11,  3.281762443162903e-13, -6.617745220329121e-15,
  6.403280381238067e-16, -9.914380525178465e-18, -4.488506047332430e-19, -8.001587167960205e-21,  9.122726430523561e-22,  2.182273578498325e-23,  1.829567393757857e-05,
 -2.821313685521679e-07,  1.146924783270808e-08, -3.884869463699765e-10,  3.860829821190760e-12, -2.519094860470693e-14,  8.701107135903388e-15, -1.448886270938570e-16,
 -9.255646674896750e-18, -3.667249289599441e-20,  1.583197965694819e-20,  2.658920436153517e-22,  2.374045186007705e-04, -3.411968972822166e-06,  1.016102411610122e-07,
 -3.004920194523415e-09,  2.299175274581173e-11,  1.673154115931053e-13,  5.756926151480567e-14, -1.084123221662664e-15, -7.435932877233952e-17,  1.567384567440109e-19,
  1.218967655152206e-19,  1.390619141474727e-21,  1.581983645099995e-03, -2.163445040817940e-05,  4.689724357842815e-07, -1.144886418771125e-08,  7.928777837438860e-11,
  1.119151201626585e-12,  1.801585234656468e-13, -3.787198399649265e-15, -2.552741498676985e-16,  1.489977445760938e-18,  4.147264525447343e-19,  3.091896248463286e-21,
  5.631772445277151e-03, -7.441255532074096e-05,  1.178742290715501e-06, -2.117023754288529e-08,  1.792098812326102e-10,  7.264520081246288e-13,  2.102924777736683e-13,
 -4.795557663489352e-15, -2.953395695152811e-16,  2.696811609532763e-18,  4.839893359714561e-19,  1.797950968629192e-21,  1.044956319613419e-02, -1.350307013240728e-04,
  1.615478781726446e-06, -1.694896515033973e-08,  2.663927963654028e-10, -4.850851720973556e-12, -8.232873852835500e-14,  1.994955550771445e-15,  1.965675036744217e-16,
 -8.577627663437458e-19, -3.028212171748012e-19, -2.934658591523830e-21,  8.072390893360818e-03, -1.030815744170618e-04,  1.016681135714817e-06, -4.172971795478404e-09,
  1.918625302376284e-10, -6.817393006550890e-12, -2.488399418570809e-13,  6.181779093493462e-15,  4.595748016822113e-16, -3.720715393689475e-18, -7.308995248168115e-19,
 -3.681987644386541e-21,  1.364107810689771e-14, -1.324145036256745e-16,  4.987315529882503e-17, -3.677979543351735e-18,  1.608593749165308e-19, -8.903554711935242e-21,
  5.677482343482050e-22, -2.524122324066377e-23,  8.432422796418684e-25, -3.795423319203769e-26,  1.958725969659587e-27, -5.918108973675180e-29,  3.368126223074522e-11,
 -3.635454104751123e-13,  5.032215413500158e-14, -3.109305845244137e-15,  7.890956653194262e-17, -1.702779882236961e-18,  1.363257145496488e-19, -5.851353431039995e-21,
  2.333180669073775e-23,  1.279520485638472e-24,  2.599910628133492e-25, -8.937522951316828e-27,  8.752694362893810e-09, -1.000197723192274e-10,  7.762738608933139e-12,
 -4.351696897380701e-13,  8.642606236616304e-15, -1.449033367229127e-17,  8.589708934146850e-18, -5.647509519104501e-19, -1.448036704871597e-21,  5.567291096874542e-22,
  1.575293852893759e-23, -1.125807825815282e-24,  6.224984694017244e-07, -7.334236626028185e-09,  3.674743380966534e-10, -1.863304706401156e-11,  3.185058436483216e-13,
  3.807885226365097e-15,  1.739667791873402e-16, -2.110445374603034e-17, -2.727261739227285e-20,  2.738833812890835e-20,  3.093741687378970e-22, -4.734287555301684e-23,
  1.732264519086913e-05, -2.079483979725806e-07,  7.193009890023812e-09, -3.213501094667774e-10,  4.955192017203437e-12,  1.048304811412898e-13,  1.203489200280015e-15,
 -3.376057069963163e-16,  4.829285437468052e-19,  4.807181775432981e-19,  1.689214513802133e-21, -7.876737591262964e-22,  2.251637267494464e-04, -2.736397034824102e-06,
  6.807298507756784e-08, -2.549968197200426e-09,  3.645209525912735e-11,  9.547648493284837e-13,  1.379936827718495e-15, -2.470207041894903e-15,  9.798543976813095e-18,
  3.643290411732151e-18, -4.639561854094250e-21, -5.809182928116613e-21,  1.502113608719157e-03, -1.840766352754570e-05,  3.405624666642660e-07, -9.817184290443159e-09,
  1.321688072240104e-10,  3.408195352828761e-12, -1.042682336036570e-14, -8.160656065878107e-15,  4.957704009090849e-17,  1.217296615636526e-17, -5.634461027219010e-20,
 -1.907748415755991e-20,  5.351445319200767e-03, -6.594745428845055e-05,  9.431054034885810e-07, -1.797487809002592e-08,  2.286597971814720e-10,  3.309954847912726e-12,
 -1.718602243693998e-14, -9.412459272646826e-15,  7.772680140645199e-17,  1.390009156133668e-17, -1.083548987458892e-19, -2.147258421101983e-20,  9.934091797471317e-03,
 -1.228558909176205e-04,  1.434195804646152e-06, -1.353958131160473e-08,  1.573902363460154e-10, -5.556793902567210e-12,  4.074715993957265e-14,  5.593313292680526e-15,
 -2.390222005834949e-17, -9.104163067152226e-18,  2.687009865235569e-20,  1.426745296264260e-20,  7.676072192977254e-03, -9.510830984002977e-05,  9.796991030927647e-07,
 -2.433205969990902e-09,  1.716701023299606e-11, -9.366739582907703e-12,  7.252408286830970e-14,  1.371397329089760e-14, -1.000795098983748e-16, -2.128918675642208e-17,
  1.425431421770016e-19,  3.290201838103581e-20,  1.367861109129606e-14,  1.240453375556728e-16,  1.715086709980293e-17, -1.985683255525071e-18,  7.379484080389065e-20,
 -1.547152637605381e-21,  1.143815715942116e-22, -9.545938182914854e-24,  3.416815755424308e-25, -2.661695458326733e-27,  5.370703209413962e-29, -2.293354935272023e-29,
  3.282394585691037e-11, -9.045155567437088e-14,  1.989153245402808e-14, -1.994544132087190e-15,  6.510637240434915e-17, -2.211755069482304e-19, -1.233929758757581e-21,
 -3.306877638245116e-21,  1.387199327781133e-22,  1.936618359762799e-24, -1.904512415915337e-25, -4.305518165218781e-27,  8.447095633530818e-09, -5.643064996949843e-11,
  3.382759313009016e-12, -2.932169779608853e-13,  9.192386469132672e-15,  1.691008740112844e-17, -4.606916061543444e-18, -2.746317959024387e-19,  1.707623495676822e-20,
  1.672469182835744e-22, -2.726112227697106e-23, -1.306194759525914e-25,  5.977556174859252e-07, -5.195896589615651e-09,  1.771747409720935e-10, -1.289183859987195e-11,
  3.918869391953273e-13,  1.687530089941372e-15, -2.876389661597441e-16, -7.839882876250680e-18,  7.021357397879756e-19,  3.080523968949604e-21, -1.114743358735757e-21,
  4.172996779726587e-24,  1.658362436867232e-05, -1.643269129850964e-07,  3.878503978112848e-09, -2.267110253733882e-10,  6.648278701176471e-12,  3.686766774409513e-14,
 -5.710260893173003e-15, -9.471504314287749e-17,  1.167989131559446e-17,  2.990468949477458e-21, -1.801085051715496e-20,  1.667263253023630e-22,  2.151293011533473e-04,
 -2.302942790832145e-06,  4.154920620762602e-08, -1.833605106032484e-09,  5.093145661072608e-11,  3.017716383651313e-13, -4.656088576115681e-14, -5.322446958600219e-16,
  8.685385825285100e-17, -2.382862868266851e-19, -1.299933949433502e-19,  1.712448168479406e-21,  1.433242884496140e-03, -1.611370248770088e-05,  2.374557580513856e-07,
 -7.240497378881820e-09,  1.817903241316425e-10,  9.480276911036707e-13, -1.622859375964707e-13, -1.382535264583693e-15,  2.883707640008485e-16, -1.436394259241567e-18,
 -4.201800239080199e-19,  6.781974155087709e-21,  5.101472856828847e-03, -5.919872978353664e-05,  7.512492257179674e-07, -1.388838828286123e-08,  2.725611914593108e-10,
  4.084164565946541e-13, -1.857454170725077e-13, -1.254559648876716e-15,  3.298815688730633e-16, -2.360287404233672e-18, -4.656194826237259e-19,  8.898891500290581e-21,
  9.464636395440783e-03, -1.119972699350674e-04,  1.283468785505815e-06, -1.180917711613088e-08,  6.710530241688398e-11, -3.053587495682299e-12,  1.452120476802832e-13,
  8.489577638110702e-16, -2.104335504914207e-16,  7.679017500606122e-19,  3.175366887522629e-19, -4.627885409546785e-21,  7.311118535801837e-03, -8.739587168026569e-05,
  9.465959632977434e-07, -3.446772062948253e-09, -1.261876907086258e-10, -3.987021325731129e-12,  3.184121191554141e-13,  1.679470541871110e-15, -4.982916584465164e-16,
  3.157120049786898e-18,  7.186348169486058e-19, -1.295068231265275e-20,  1.432430411427049e-14,  1.842638673677789e-16, -3.285087175208564e-19, -9.732675948315370e-19,
  5.460894721164464e-20, -8.795824175495416e-22, -1.825628417665812e-23, -8.124713053255251e-25,  1.733871215456373e-25, -6.887040090831690e-27, -2.299763686588323e-29,
  9.158708972348667e-30,  3.265321771303161e-11, -9.813564604467195e-15,  1.992437278416790e-15, -1.012013834370398e-15,  5.555161877092036e-17, -8.507581511349845e-19,
 -3.202753738496825e-20,  7.655087263723108e-22,  7.836872530438073e-23, -4.031004744768555e-24, -2.292199639097904e-26,  6.886897923891939e-27,  8.256716868555788e-09,
 -4.096442894197474e-11,  7.338671084040280e-13, -1.509442474392305e-13,  8.118563761157856e-15, -1.257222745871696e-16, -5.123815552581158e-18,  1.825771115107513e-19,
  7.320402660348860e-21, -5.096426188709027e-22,  2.615488776174461e-25,  7.891731436600076e-25,  5.789776082583183e-07, -4.290774612881490e-09,  5.989583377642774e-11,
 -6.757155384240543e-12,  3.513589063346047e-13, -5.483410608556110e-15, -2.289801559370564e-16,  9.374019992372726e-18,  2.289396491239372e-19, -2.061158579204622e-20,
  1.088055260874515e-22,  2.888292750754121e-23,  1.597370668660020e-05, -1.423665390280483e-07,  1.795698254571036e-09, -1.220701267733721e-10,  6.003107441721513e-12,
 -9.394338053453644e-14, -3.933621643188808e-15,  1.731828387050435e-16,  3.008585681276410e-18, -3.360845074886125e-19,  2.908515791990545e-21,  4.339767561391628e-22,
  2.064626239465739e-04, -2.044648121812209e-06,  2.443676847186822e-08, -1.030959736809703e-09,  4.606238703771317e-11, -7.183837449745498e-13, -2.957039083200465e-14,
  1.364355867542800e-15,  1.833576830384315e-17, -2.456492992397973e-18,  2.720657193723346e-20,  2.972628108628123e-21,  1.372107069267861e-03, -1.451208154675714e-05,
  1.679677294052750e-07, -4.387779798655025e-09,  1.634971084582828e-10, -2.511259416963698e-12, -9.762272276450398e-14,  4.684684673137366e-15,  5.135856230308331e-17,
 -8.038855076517280e-18,  1.035953405020601e-19,  9.229995050563312e-21,  4.875745930973041e-03, -5.378217377355445e-05,  6.102540652465399e-07, -9.696826885828012e-09,
  2.387503108362257e-10, -3.459450873278148e-12, -1.053287291287694e-13,  5.441538269101459e-15,  4.898948144364449e-17, -9.041616132613799e-18,  1.325319485925413e-19,
  9.818475570724412e-21,  9.036306504338449e-03, -1.022815307365696e-04,  1.146790141083430e-06, -1.103924457670155e-08,  3.925743662215505e-11,  5.390427273606591e-14,
  9.269024018835877e-14, -3.648270945753001e-15, -3.930052475861792e-17,  5.992303799077502e-18, -7.153386246675737e-20, -7.114522157189719e-21,  6.976365533402782e-03,
 -8.002627720273899e-05,  8.918061833421112e-07, -5.701919019514794e-09, -1.339654649137297e-10,  2.682339447023031e-12,  1.896371084803686e-13, -8.539214591714503e-15,
 -7.683309515273108e-17,  1.383652536212548e-17, -1.940803949862730e-19, -1.537855148689064e-20,  1.500114344033656e-14,  1.482783726121349e-16, -7.423140543916093e-18,
 -2.633742821794184e-19,  3.309458725483317e-20, -1.181972872647171e-21,  2.051859883807194e-24,  1.238652936782946e-24, -1.724582758976949e-26, -2.546824678157599e-27,
  1.500507172910809e-28, -1.905930498027150e-30,  3.258827639286178e-11, -2.885416650794105e-14, -5.487052200740419e-15, -2.903653249721051e-16,  3.349907932129102e-17,
 -1.206918218600964e-18,  4.230856147323296e-21,  1.233280932066601e-21, -3.125481360985225e-23, -1.278086378808871e-24,  9.639583983209499e-26, -1.277785485293038e-27,
  8.095952143769660e-09, -4.035523079325134e-11, -3.972568144174772e-13, -4.583510506457689e-14,  4.858080489991644e-15, -1.764061283787653e-16,  8.286705322212424e-19,
  1.749115301913815e-19, -5.292042627562736e-21, -1.178937728605171e-22,  1.168763828963537e-23, -1.961322968540693e-25,  5.623813675957307e-07, -4.050181430618724e-09,
  8.216043650048255e-12, -2.215303674366696e-12,  2.096320543752322e-13, -7.609364973034268e-15,  4.117351688557737e-17,  7.392928202226965e-18, -2.445205998109029e-19,
 -3.540569235565124e-21,  4.541791062283377e-22, -8.933125570357233e-24,  1.542577971566674e-05, -1.323950701784453e-07,  8.332273761450014e-10, -4.446585762122683e-11,
  3.586963598362265e-12, -1.289651580548362e-13,  7.591849640890516e-16,  1.231265946050497e-16, -4.296532128215072e-18, -4.403803717130385e-20,  7.181548807602816e-21,
 -1.569574669008092e-22,  1.986126800845934e-04, -1.887387506716627e-06,  1.592450297272527e-08, -4.342151166624778e-10,  2.773085969894659e-11, -9.729271593171921e-13,
  6.075782473065239e-15,  9.097839782108641e-16, -3.290542640902723e-17, -2.514218248891156e-19,  5.128861170074323e-20, -1.205682366439800e-21,  1.316469737577179e-03,
 -1.333890181967496e-05,  1.290635263459286e-07, -2.256013705660140e-09,  1.004434422635105e-10, -3.319218485262690e-12,  2.185715758251699e-14,  2.989180240309171e-15,
 -1.110995669911146e-16, -6.528512415470636e-19,  1.648439569397971e-19, -4.087016222804679e-21,  4.669728280417161e-03, -4.930654136854603e-05,  5.142258000825479e-07,
 -6.516061514012461e-09,  1.564450552369348e-10, -4.231469067655989e-12,  3.054828359940751e-14,  3.328521106124900e-15, -1.280668153368034e-16, -5.526875494328713e-19,
  1.819843746681027e-19, -4.748461332184078e-21,  8.644705999908915e-03, -9.362572291905201e-05,  1.018418969489491e-06, -1.031665438852194e-08,  5.430982453969968e-11,
  1.079173017038164e-12, -1.002913891516400e-15, -2.392346711733829e-15,  8.359748911696590e-17,  5.371178815098676e-19, -1.244516113025815e-19,  3.003476580809247e-21,
  6.670051439332250e-03, -7.319668027403985e-05,  8.128711145486331e-07, -7.250023342156827e-09, -5.392763097285728e-11,  4.470304759767028e-12, -2.475906495676224e-14,
 -5.327148762469379e-15,  1.969167106912172e-16,  9.255138146526969e-19, -2.808593096756503e-19,  7.198875395927413e-21,  1.546589463934279e-14,  8.352513983665265e-17,
 -8.150096599400536e-18,  8.964713688850937e-20,  1.220789945451397e-20, -8.278874479763792e-22,  2.212349352296052e-23,  1.369100689393518e-25, -3.155630392168999e-26,
  8.372770130307880e-28,  1.956112665196242e-29, -2.218405863027880e-30,  3.237354912967028e-11, -7.932618056354728e-14, -6.507749599059706e-15,  6.742527190313840e-17,
  1.249362272060876e-17, -8.237054207476551e-19,  2.224373968170379e-20,  8.046507483206437e-23, -2.828084321715054e-23,  8.327241182450186e-25,  9.183987372393597e-27,
 -1.501434535972950e-27,  7.926220783715026e-09, -4.466630901032451e-11, -5.901623700650166e-13,  6.048068087691238e-15,  1.820087366267773e-15, -1.181008128886691e-16,
  3.236917170549288e-18,  6.177202745902965e-21, -3.841641483077926e-21,  1.215748023994662e-22,  6.173588857044475e-25, -1.774952240169150e-25,  5.462097712873616e-07,
 -4.044702284717565e-09, -2.938311998770061e-12,  2.902272708239642e-14,  7.940960408178547e-14, -5.036019318435935e-15,  1.392191648713101e-16,  1.208441607265760e-19,
 -1.584084613270375e-19,  5.250863601334536e-21,  9.071901623009464e-24, -6.709561670849914e-24,  1.490728444581518e-05, -1.270728828734577e-07,  5.645980439939176e-10,
 -5.828487608782852e-12,  1.388621173820844e-12, -8.476857626124978e-14,  2.350561055197746e-15,  4.096153851620981e-19, -2.597230727922661e-18,  8.883190436407495e-20,
 -3.279407502527446e-23, -1.036771304898651e-22,  1.912937275722353e-04, -1.774684091249347e-06,  1.277813322842092e-08, -1.317367062076528e-10,  1.118599818860447e-11,
 -6.374235983093624e-13,  1.761146668940033e-14, -5.922546295454332e-18, -1.899690361030008e-17,  6.643843797070453e-19, -1.179977206628050e-21, -7.269758014381599e-22,
  1.265039979055972e-03, -1.239210956337555e-05,  1.095960831206106e-07, -1.130167836720739e-09,  4.405149268214719e-11, -2.177586642484420e-12,  5.913239617464417e-14,
 -4.683315136134122e-17, -6.205488505436659e-17,  2.207861977100814e-18, -6.147765659308607e-21, -2.302218129148868e-21,  4.480286580192462e-03, -4.546900195156554e-05,
  4.484549002270587e-07, -4.626611564422233e-09,  8.437355428730555e-11, -2.821852121516690e-12,  7.090214973551431e-14, -1.123822645053596e-16, -6.925909350876294e-17,
  2.513608412919709e-18, -9.386594678226264e-21, -2.502443231367299e-21,  8.285736641267782e-03, -8.595725752697375e-05,  9.004916624085088e-07, -9.293727620712870e-09,
  7.176203279253512e-11,  5.440177972680479e-13, -3.285420875610018e-14, -8.799354970267002e-17,  4.769906849847946e-17, -1.652878638176109e-18,  3.830441568909096e-21,
  1.753438671813292e-21,  6.389707394577350e-03, -6.704999605015947e-05,  7.234314379021517e-07, -7.468044277643846e-09,  2.103505963149082e-11,  2.767773342333505e-12,
 -9.234052196886547e-14, -5.133960947802951e-18,  1.080350967555657e-16, -3.854722547344480e-18,  1.319185084613044e-20,  3.885817036619928e-21,  1.567967118998083e-14,
  2.487646875655153e-17, -6.355882435171347e-18,  1.809901722965986e-19,  8.062193987034784e-22, -3.354745476395987e-22,  1.659433211023950e-23, -3.758230387125792e-25,
 -2.703746349001926e-27,  5.309382103332141e-28, -1.790069293598118e-29,  8.029121528988487e-32,  3.196062617218284e-11, -1.258195006364684e-13, -4.950497730698094e-15,
  1.638213293537873e-16,  1.130501041493130e-18, -3.373512143232772e-19,  1.627482180626602e-20, -3.661514575593549e-22, -2.079924438489492e-24,  4.669070891545223e-25,
 -1.567366206481465e-26,  9.119731391021043e-29,  7.739068743365181e-09, -4.875487179887337e-11, -4.074601444260817e-13,  2.035420573259091e-14,  1.939642515983060e-16,
 -4.830813983030924e-17,  2.315065648439578e-18, -5.266242704235812e-20, -2.205752197510503e-22,  6.239076951668174e-23, -2.145389532579840e-24,  1.620703101438936e-26,
  5.300080077722832e-07, -4.051720111565116e-09,  2.280665047327149e-12,  6.683711043239248e-13,  1.012978046398666e-14, -2.060685675554966e-15,  9.810605475022607e-17,
 -2.251039596192536e-18, -7.200545543632684e-21,  2.542412766150201e-21, -8.926500524027570e-23,  7.873027098053400e-25,  1.440797131333416e-05, -1.225676348053574e-07,
  5.816289945338775e-10,  5.762913264612803e-12,  2.217303851022890e-13, -3.482969806078841e-14,  1.640091121062721e-15, -3.783571044783097e-17, -9.527294536561088e-20,
  4.133489362374157e-20, -1.474729549641367e-21,  1.433457511239595e-23,  1.843926301178097e-04, -1.676563828096519e-06,  1.192230344963188e-08, -3.280521211111998e-11,
  2.384587606105053e-12, -2.648137123408159e-13,  1.220663293959573e-14, -2.821354405581353e-16, -5.698362032224689e-19,  3.005257677567256e-19, -1.085413545442260e-20,
  1.125848761917140e-22,  1.217152349779621e-03, -1.156043138856349e-05,  9.906660472749263e-08, -7.002385138035839e-10,  1.371902916301057e-11, -9.304268875590436e-13,
  4.081749007514543e-14, -9.396312766595403e-16, -1.506362060485261e-18,  9.776916602142680e-19, -3.565943590346356e-20,  3.874480032285054e-22,  4.305261705331535e-03,
 -4.208419909105071e-05,  3.994609438023606e-07, -3.640237632016159e-09,  4.373616809879349e-11, -1.331302284957737e-12,  4.893797924967936e-14, -1.094496626999901e-15,
 -1.080975510053001e-18,  1.089426881175507e-18, -4.018472568073485e-20,  4.561456464835613e-22,  7.955637457850197e-03, -7.917934921986736e-05,  7.960800715859906e-07,
 -8.099739292005785e-09,  7.522897789193102e-11, -1.527128547312820e-13, -2.206105091124432e-14,  6.164226504295674e-16,  2.077011255545779e-18, -7.428309205527099e-19,
  2.673992659421540e-20, -2.834788217332927e-22,  6.132527407936002e-03, -6.161184157984785e-05,  6.372843282379200e-07, -6.803627547160365e-09,  5.572555675001852e-11,
  8.220557353747567e-13, -6.285501956345332e-14,  1.553597769204392e-15,  3.032524976433036e-18, -1.687115456614221e-18,  6.170686789312446e-20, -6.896490729505360e-22,
  1.569103083822811e-14, -1.745093740757658e-17, -4.267720447786421e-18,  1.582795200269164e-19, -2.765396889992198e-21, -6.016339653497922e-23,  6.841600142250662e-24,
 -2.775672378641899e-25,  5.798771568120181e-27,  2.140655637939057e-29, -6.572620460035230e-30,  2.544513621013266e-31,  3.139050128311102e-11, -1.576447432666804e-13,
 -3.039517457468495e-15,  1.456934915882354e-16, -2.528626945647206e-18, -6.574959519902484e-20,  6.839900531763285e-21, -2.693522944469624e-22,  5.465871141811557e-24,
  2.081301964848406e-26, -5.890466007757316e-27,  2.183553704420643e-28,  7.539076177011030e-09, -5.104107963810791e-11, -1.680510234413060e-13,  1.825264467912267e-14,
 -3.333279626443060e-16, -9.703065408335643e-18,  9.739261646521458e-19, -3.807655949158928e-20,  7.740385438929696e-22,  2.313248380609873e-24, -7.865407440092665e-25,
  2.918587958093546e-26,  5.138890929895693e-07, -4.001043990527500e-09,  1.027015199066834e-11,  6.076289083051659e-13, -1.250187785540546e-14, -4.262603910047699e-16,
  4.125689153724865e-17, -1.606546051807738e-18,  3.280029013218267e-20,  7.647567565583104e-23, -3.194871096833066e-23,  1.193513552527771e-24,  1.392747551619618e-05,
 -1.176184822898287e-07,  6.550420597350440e-10,  5.524055925978595e-12, -1.643533343709144e-13, -7.516527172552539e-15,  6.901838437524219e-16, -2.675237398504577e-17,
  5.481503539019940e-19,  1.011534087221711e-21, -5.178008333504839e-22,  1.947569456879661e-23,  1.778751377136034e-04, -1.582423669319978e-06,  1.162714143121236e-08,
 -2.372657233421459e-11, -6.001419693813710e-13, -6.140485011192660e-14,  5.153684903706007e-15, -1.981513034781467e-16,  4.068483450090170e-18,  6.018202380865439e-21,
 -3.754943459030757e-21,  1.420638028643935e-22,  1.172446257661015e-03, -1.079889050234632e-05,  9.151515208779726e-08, -5.850917627870550e-10,  2.852900562439881e-12,
 -2.482580653436823e-13,  1.740706406192295e-14, -6.567133897676686e-16,  1.347560373893738e-17,  1.588801521880425e-20, -1.219191300792627e-20,  4.635956825350726e-22,
  4.143054213147020e-03, -3.905300639784481e-05,  3.592769900180322e-07, -3.099777663218064e-09,  2.646989604565885e-11, -5.021120716564713e-13,  2.177474320656226e-14,
 -7.620959271431465e-16,  1.546041780073686e-17,  1.212647065403625e-20, -1.356972608897217e-20,  5.191025340984982e-22,  7.651070143514910e-03, -7.317942408624626e-05,
  7.059270097716396e-07, -6.943523744382059e-09,  6.823652668602043e-11, -4.856424646918612e-13, -6.600933087532169e-15,  4.293813958785219e-16, -9.465452807464861e-18,
 -1.885824697620406e-20,  9.225276115763171e-21, -3.483382619583957e-22,  5.895781978513923e-03, -5.682419450067000e-05,  5.613071378897046e-07, -5.848030697873973e-09,
  6.047980864229194e-11, -1.943918328189919e-13, -2.416065753325361e-14,  1.079472407285032e-15, -2.281797325462827e-17, -2.870246921758516e-20,  2.096062436327839e-20,
 -7.982568980319752e-22,  1.556384915233091e-14, -4.479255729775923e-17, -2.650973910925268e-18,  1.110584224762354e-19, -2.849876383500630e-21,  3.111146082197735e-23,
  1.529983436543576e-24, -1.122840108877734e-25,  3.963988303457739e-27, -7.979422226131287e-29,  8.295238963269810e-32,  6.288338851861978e-32,  3.072131916282788e-11,
 -1.757086689546721e-13, -1.554603681525932e-15,  1.014223287305197e-16, -2.712435231391963e-18,  2.714579773382730e-20,  1.629015310584753e-21, -1.121952699420038e-22,
  3.824451700480903e-24, -7.348230164743363e-26, -1.608399576224353e-29,  5.881806880759484e-29,  7.333471240882153e-09, -5.160812065179018e-11,  1.582053496209289e-14,
  1.232407043978185e-14, -3.658250959299431e-16,  3.590860943526756e-18,  2.363155023469181e-19, -1.594489503409218e-20,  5.382402638699528e-22, -1.026041344308828e-23,
 -6.250582591099384e-28,  7.934354943164242e-27,  4.980901222165394e-07, -3.893482852221690e-09,  1.621773399787635e-11,  3.799998103176351e-13, -1.417014191575464e-14,
  1.386680189835214e-16,  1.013526931211274e-17, -6.737391487623042e-19,  2.263803488289049e-20, -4.310633283474769e-22,  9.268051810263344e-26,  3.233231691733826e-25,
  1.346782990745445e-05, -1.121643946918124e-07,  7.028958712649574e-10,  2.372058269339217e-12, -1.997293237056830e-13,  1.968275453865444e-15,  1.719990576340708e-16,
 -1.122909600777193e-17,  3.759945129397652e-19, -7.162211019551469e-21,  3.293420560598500e-24,  5.245506607788401e-24,  1.717293654112852e-04, -1.490766632051663e-06,
  1.126152289300385e-08, -3.806040034689458e-11, -9.667901596340993e-13,  9.844956228445434e-15,  1.314743698843702e-15, -8.330594583927454e-17,  2.777404001825547e-18,
 -5.292740336904719e-20,  3.490146426084737e-23,  3.804778017754084e-23,  1.130671221208292e-03, -1.009433511751717e-05,  8.466259589158789e-08, -5.618623451036989e-10,
  8.206472077551587e-13, -4.389899108071663e-15,  4.669002676748392e-15, -2.773027863356247e-16,  9.165634778885419e-18, -1.745705665760522e-19,  1.444658541980106e-22,
  1.235368230283986e-22,  3.992364387739410e-03, -3.632099073620176e-05,  3.243639001930230e-07, -2.734476128559380e-09,  2.020530846033211e-11, -1.820542152873860e-13,
  6.902392500431935e-15, -3.280568669764226e-16,  1.048227580706119e-17, -1.985338515612596e-19,  2.060972593275704e-22,  1.375294939902752e-22,  7.369144752482907e-03,
 -6.784751308484432e-05,  6.288167346307246e-07, -5.934566099562836e-09,  5.774089180213121e-11, -5.327498158800513e-13,  1.438107651895933e-15,  1.619047203609174e-16,
 -6.432801553492505e-18,  1.265324810525879e-19, -6.149635150353609e-23, -9.327638548581095e-23,  5.677044296374245e-03, -5.259844743854620e-05,  4.967310486767001e-07,
 -4.934137292367813e-09,  5.282740235317674e-11, -4.907092928411889e-13, -3.500050605024773e-15,  4.375292128363637e-16, -1.546188276896213e-17,  2.985537027290635e-19,
 -2.487248299897865e-22, -2.121378433262880e-22,  1.534968274446669e-14, -6.138883398705623e-17, -1.567236857826141e-18,  7.158932176634781e-20, -2.051885996884870e-21,
  4.190432700060705e-23, -2.433707020082438e-25, -2.719538824747771e-26,  1.547192536337746e-27, -4.912659442921290e-29,  9.679827528751707e-31, -5.011384081835849e-33,
  3.000034374703984e-11, -1.839643453950732e-13, -5.755187261405455e-16,  6.364106518974265e-17, -1.971621110063988e-18,  4.001876307266533e-20, -1.766169516031724e-22,
 -2.884188541989119e-23,  1.550436165446656e-24, -4.734770545401903e-26,  8.816102407146670e-28, -3.005317010709639e-30,  7.128096990328499e-09, -5.098267154594000e-11,
  1.316185295678694e-13,  7.232515183235918e-15, -2.648034603301421e-16,  5.522438102277313e-18, -2.172310449741632e-20, -4.172526745865583e-21,  2.203513809111364e-22,
 -6.647001475485659e-24,  1.218954750990122e-25, -3.814622692557765e-28,  4.827994668171475e-07, -3.749085113969112e-09,  1.953735834554291e-11,  1.835604712858361e-13,
 -1.012833828882808e-14,  2.236011967508920e-16, -7.991880413098278e-19, -1.780018925713174e-19,  9.304045825835732e-21, -2.790044069059434e-22,  5.086917145500532e-24,
 -1.586287380473945e-26,  1.303052748196109e-05, -1.064776881113762e-07,  7.139724266270374e-10, -3.698128618226799e-13, -1.385049340017262e-13,  3.453926702565892e-15,
 -1.066606485761470e-17, -2.990852993064328e-18,  1.548574156415141e-19, -4.626242342483291e-21,  8.412273647783257e-23, -2.665708113233349e-25,  1.659432491546127e-04,
 -1.402741492367280e-06,  1.072225734420300e-08, -5.087375725780126e-11, -5.986207713809657e-13,  2.176097036574583e-14, -4.440635279928483e-17, -2.242480135943599e-17,
  1.145919819418506e-18, -3.411789040465562e-20,  6.194502370993486e-22, -2.000937541528680e-24,  1.091606123498951e-03, -9.443758581056900e-06,  7.800991826285922e-08,
 -5.454619732694987e-10,  1.371931887789868e-12,  4.206566647043746e-14,  1.182326292087948e-16, -7.623442492572456e-17,  3.792009604923651e-18, -1.123380957747000e-19,
  2.036735149336014e-21, -6.702606542110921e-24,  3.852069878730800e-03, -3.385206981295570e-05,  2.933918244265805e-07, -2.433842507266293e-09,  1.764556842574883e-11,
 -9.504762053618240e-14,  1.399040980797117e-15, -9.737598560984018e-17,  4.380430624722040e-18, -1.275751562206657e-19,  2.303924875644887e-21, -7.768610327086765e-24,
  7.107385868615449e-03, -6.308692431818480e-05,  5.628028457000691e-07, -5.092901171179967e-09,  4.769532983962624e-11, -4.630534358106924e-13,  3.737437547422473e-15,
  2.301345102898976e-17, -2.532485342114631e-18,  8.131153836680880e-20, -1.499211646571287e-21,  4.750211037293082e-24,  5.474242494810974e-03, -4.884782709028674e-05,
  4.422634098104046e-07, -4.168693322930878e-09,  4.291733889201069e-11, -4.740872765497943e-13,  3.349811926341973e-15,  1.004236059385648e-16, -6.278504287010722e-18,
  1.916746662409996e-19, -3.497394414919288e-21,  1.153602337386394e-23,  1.508378470519056e-14, -7.098786323063483e-17, -8.790229045901567e-19,  4.496981040890666e-20,
 -1.310985413240425e-21,  3.113746348073041e-23, -5.281542016510584e-25,  7.967716581820891e-28,  3.855386608785830e-28, -1.838865583401115e-29,  5.356515384426454e-31,
 -1.035761518650035e-32,  2.925943474866930e-11, -1.859916893269184e-13,  2.401799617848687e-17,  3.807624170388490e-17, -1.255906940933295e-18,  3.035193959509521e-20,
 -5.002231606508238e-22, -2.260242186841664e-25,  4.101021462571051e-25, -1.852580775688922e-26,  5.177636221881758e-28, -9.422548176326599e-30,  6.926730840838835e-09,
 -4.964652690154338e-11,  1.964610685541313e-13,  3.823022719630734e-15, -1.657342220351826e-16,  4.206872260947695e-18, -6.948636508560032e-20, -7.967610641641378e-23,
  5.939673176976985e-23, -2.636436528371741e-24,  7.264036564151332e-26, -1.295955280193206e-27,  4.681262172085371e-07, -3.586403476322742e-09,  2.090855897779975e-11,
  5.504625989528695e-14, -6.112425589896558e-15,  1.703136559957464e-16, -2.860974237519455e-18, -4.636739499696322e-21,  2.532229721688084e-21, -1.113513659186502e-22,
  3.046162157292804e-24, -5.385294567640200e-26,  1.261596567361996e-05, -1.008162800663848e-07,  6.984153347523749e-10, -2.067321443519111e-12, -7.644734580830938e-14,
  2.621232421428038e-15, -4.570515262569355e-17, -9.915737796919119e-20,  4.243100395299955e-20, -1.852824398831900e-21,  5.046374380871913e-23, -8.877147608985241e-25,
  1.604997851765224e-04, -1.319536300977544e-06,  1.006804703515312e-08, -5.717969040758962e-11, -2.077214523627493e-13,  1.633223427703249e-14, -3.114331593292324e-16,
 -9.829380848589127e-19,  3.160985582253610e-19, -1.369772549489268e-20,  3.718284997233573e-22, -6.520607576464150e-24,  1.055038401763748e-03, -8.845426053841811e-06,
  7.162285998087120e-08, -5.171479731985868e-10,  2.125694608760315e-12,  2.979938516188066e-14, -8.198321267420951e-16, -5.053877742983921e-18,  1.057459738910164e-18,
 -4.521408833601525e-20,  1.222825698867205e-21, -2.139353600908782e-23,  3.721177492558998e-03, -3.161709629828486e-05,  2.658209136703272e-07, -2.165587056302906e-09,
  1.592561308451086e-11, -8.198709376264798e-14,  6.397943410394624e-17, -1.424096352603025e-17,  1.268567528274439e-18, -5.167082240371629e-20,  1.383744362185990e-21,
 -2.412047352159079e-23,  6.863673383975128e-03, -5.881665932986390e-05,  5.059772246597799e-07, -4.398905771048408e-09,  3.934614388258511e-11, -3.724697108673791e-13,
  3.609514159833552e-15, -2.190033069672170e-17, -5.696375111370742e-19,  3.189809006621408e-20, -8.982417966643847e-22,  1.587325042725809e-23,  5.285626150362991e-03,
 -4.549883246506875e-05,  3.960621951286604e-07, -3.552881617693414e-09,  3.437365769964320e-11, -3.771966633404529e-13,  4.204841153518143e-15, -1.505345677469760e-17,
 -1.626644946072957e-18,  7.644800569919819e-20, -2.097737485067522e-21,  3.679582502140532e-23,  1.478874007593766e-14, -7.617511288194866e-17, -4.468533523817481e-19,
  2.831344487879720e-20, -8.081050128549385e-22,  1.963921871279212e-23, -4.079091965001557e-25,  5.871269388352790e-27,  1.255846540675432e-29, -4.604235201719209e-30,
  1.921684660053267e-31, -5.200755785027262e-33,  2.851831938066055e-11, -1.842715212553736e-13,  3.783288343105480e-16,  2.220363745358016e-17, -7.639261988699647e-19,
  1.926133745866806e-20, -3.989667987077983e-22,  5.479068138509823e-24,  2.643049065627878e-26, -4.928196835245752e-27,  1.949804053127090e-28, -5.057029380458728e-30,
  6.731522717281202e-09, -4.793059864296542e-11,  2.289150171384357e-13,  1.755922939715408e-15, -9.765178876101031e-17,  2.656950308547283e-18, -5.598204041492572e-20,
  7.603830402524556e-22,  4.407495417926257e-24, -7.157213021772337e-25,  2.781128348367414e-26, -7.101332516126731e-28,  4.541172877302383e-07, -3.417920417231426e-09,
  2.108283094036412e-11, -1.915253001923026e-14, -3.368987738715331e-15,  1.062771530528753e-16, -2.316481161145903e-18,  3.149215138213036e-20,  2.013567243761853e-22,
 -3.054381682611279e-23,  1.175740379648168e-24, -2.977920703857518e-26,  1.222369349654396e-05, -9.534538127530040e-08,  6.678080790233916e-10, -2.929531779923907e-12,
 -3.464048433055165e-14,  1.594929002531740e-15, -3.713718424775693e-17,  5.103737741412512e-19,  3.558092706998878e-21, -5.116405559764056e-22,  1.957024480948218e-23,
 -4.932099634538390e-25,  1.553783327321234e-04, -1.241770843955131e-06,  9.371426306006691e-09, -5.828991138642113e-11,  4.625484678341411e-14,  9.304422364795456e-15,
 -2.540574371913139e-16,  3.593950586611661e-18,  2.819259571270859e-20, -3.803478623817079e-21,  1.446582838558726e-22, -3.632777292099267e-24,  1.020764227271203e-03,
 -8.296649755524036e-06,  6.563735374952824e-08, -4.794336307600702e-10,  2.527929307664129e-12,  1.103945089805339e-14, -6.749933966824731e-16,  1.047893959248716e-17,
  1.050596356221440e-19, -1.264274098543553e-20,  4.770128286694774e-22, -1.194025560652630e-23,  3.598803608685196e-03, -2.959026988319444e-05,  2.413086736396146e-07,
 -1.923883450402485e-09,  1.428657436123672e-11, -8.203491138917318e-14,  1.879317035024761e-17,  5.353181076872441e-18,  1.733915584431236e-19, -1.475163405339091e-20,
  5.423700680634549e-22, -1.348708423536484e-23,  6.636182465028519e-03, -5.496982357775352e-05,  4.567363681472673e-07, -3.824489954856693e-09,  3.270642118721224e-11,
 -2.944145448620266e-13,  2.871720252254639e-15, -2.742651522427143e-17,  8.413920347396156e-20,  8.090370328215343e-21, -3.452078768790805e-22,  8.837118470027013e-24,
  5.109710283813421e-03, -4.249206234619536e-05,  3.564957127201217e-07, -3.057993103128782e-09,  2.778326933181171e-11, -2.851822018248323e-13,  3.370086079390623e-15,
 -3.633757783905200e-17, -3.203934013152239e-20,  2.064920529000533e-20, -8.147554557446156e-22,  2.054088213477422e-23,  1.447876681997314e-14, -7.858402772470354e-17,
 -1.732799076998358e-19,  1.804931859704631e-20, -5.001564079593433e-22,  1.175777647307435e-23, -2.544469254596195e-25,  4.732167115349811e-27, -5.877664758136926e-29,
 -3.013147306896016e-31,  4.774528392725673e-32, -1.790906323813104e-33,  2.778871534488055e-11, -1.803607466662085e-13,  5.826058150944057e-16,  1.259461209593475e-17,
 -4.620615470487189e-19,  1.150309387436588e-20, -2.518261306333946e-22,  4.625871827584789e-24, -5.381383736878308e-26, -4.675959377073248e-28,  5.152153863983384e-29,
 -1.832401552747177e-30,  6.543563686127747e-09, -4.603795496192418e-11,  2.421485752574885e-13,  5.528910545781796e-16, -5.621897444598414e-17,  1.567343464922094e-18,
 -3.536573103602355e-20,  6.523618896172746e-22, -7.427537974335943e-24, -7.456900360723600e-26,  7.509322874243492e-27, -2.621524367183164e-28,  4.407803721658564e-07,
 -3.250950034832858e-09,  2.059076374154394e-11, -5.877005422576388e-14, -1.727525038616279e-15,  6.124363062098577e-17, -1.457943330191465e-18,  2.725542486696651e-20,
 -3.077247937393770e-22, -3.330415876885109e-24,  3.210346309484862e-25, -1.109862039577463e-26,  1.185276378406494e-05, -9.015082226774697e-08,  6.302374469892960e-10,
 -3.272099970703555e-12, -1.048638005170058e-14,  8.754432563901651e-16, -2.315771261240058e-17,  4.447404380655318e-19, -5.016029387525509e-21, -5.754576126123981e-23,
  5.381342226363134e-24, -1.848741725870428e-25,  1.505567960511652e-04, -1.169572604857233e-06,  8.681550665652202e-09, -5.635765220059967e-11,  1.796336972287967e-13,
  4.423130141788564e-15, -1.549899356715441e-16,  3.157701362288880e-18, -3.587484119491998e-20, -4.408162614251668e-22,  3.998747208825697e-23, -1.366940163629501e-24,
  9.885923752165858e-04, -7.793864573835408e-06,  6.013154579965441e-08, -4.379983217118901e-10,  2.611071134433403e-12, -1.570928561795648e-15, -3.818496777949749e-16,
  9.371814399806884e-18, -1.095550456073174e-19, -1.534551879285578e-21,  1.325755598921831e-22, -4.506320030925028e-24,  3.484162574977614e-03, -2.774838520439811e-05,
  2.195396749764605e-07, -1.708342117499042e-09,  1.266414797450089e-11, -7.952461324652145e-14,  1.905400801339701e-16,  5.609292004090295e-18, -8.350733345865248e-20,
 -2.070991954331935e-21,  1.527068200049490e-22, -5.111450391473736e-24,  6.423332289734304e-03, -5.149103644931145e-05,  4.137994273175994e-07, -3.344801801064392e-09,
  2.744756138689801e-11, -2.342138678774602e-13,  2.170076331308304e-15, -2.209635483351256e-17,  2.029060618769429e-19,  1.705481978904031e-22, -9.111388524666286e-23,
  3.303282497332740e-24,  4.945223689516932e-03, -3.977972989095714e-05,  3.222920694349113e-07, -2.655036470671321e-09,  2.280765536307200e-11, -2.161247710408839e-13,
  2.414075044989033e-15, -3.026345306004202e-17,  3.017395071632958e-19,  1.770218971153745e-21, -2.225019470277591e-22,  7.738480934289196e-24,  1.956529321898486e+00,
  2.989297861052525e-02, -1.084321475403519e-02,  3.520021191999693e-03, -1.087002089435293e-03,  3.283425509213261e-04, -9.860507267282111e-05,  2.977575276578675e-05,
 -9.120057217458376e-06,  2.849887000573910e-06, -9.040296576787018e-07,  2.669858739456072e-07,  1.973139939229689e+00,  1.840123935434250e-02, -6.568818544253566e-03,
  2.081454824279318e-03, -6.268258545244538e-04,  1.850189429808821e-04, -5.449862956443646e-05,  1.622061350540415e-05, -4.923973877501831e-06,  1.533356855418500e-06,
 -4.869277308505999e-07,  1.442793488710827e-07,  1.982978833234121e+00,  1.169236540275095e-02, -4.198094578617056e-03,  1.321136844253312e-03, -3.940503168025478e-04,
  1.152596458901373e-04, -3.371143958382540e-05,  9.989943122492494e-06, -3.027997284147037e-06,  9.438942639573881e-07, -3.005549332609091e-07,  8.932490501048075e-08,
  1.989664075338519e+00,  7.175104980281697e-03, -2.653485400943519e-03,  8.402321832097655e-04, -2.505313040483490e-04,  7.313715515252208e-05, -2.135586987380203e-05,
  6.324986052067915e-06, -1.918557837322163e-06,  5.991638033116390e-07, -1.912528094711996e-07,  5.696729731562115e-08,  1.994470518727228e+00,  3.947850996806623e-03,
 -1.575394806410396e-03,  5.113349909124325e-04, -1.540134703625082e-04,  4.517453612492075e-05, -1.322724115335894e-05,  3.926153398323210e-06, -1.193560572024585e-06,
  3.736181986091058e-07, -1.195294538319514e-07,  3.566737675309569e-08,  1.998002545149609e+00,  1.587174853302332e-03, -8.001917625064814e-04,  2.782682590885323e-04,
 -8.641191862310999e-05,  2.575708330865047e-05, -7.613884787966035e-06,  2.274090551803322e-06, -6.944142148604142e-07,  2.181084020064290e-07, -6.995877921803711e-08,
  2.091224467412829e-08,  2.000591015779858e+00, -1.370296674593804e-04, -2.411424537587702e-04,  1.119637933138773e-04, -3.857236226410281e-05,  1.209634636997540e-05,
 -3.678755363252694e-06,  1.117681398769689e-06, -3.449666547210058e-07,  1.090962074150573e-07, -3.514632108549147e-08,  1.053289745124747e-08,  2.002431457826597e+00,
 -1.359970803161177e-03,  1.517238615032850e-04, -4.017096275984048e-06, -5.402748737885591e-06,  2.662563615222440e-06, -9.675208615003943e-07,  3.216079308518591e-07,
 -1.043360372462039e-07,  3.395270679840005e-08, -1.111767547105093e-08,  3.360435821383010e-09,  2.003642796111836e+00, -2.163527782728696e-03,  4.082135409126928e-04,
 -7.934258409131573e-05,  1.605522332896625e-05, -3.424173477664695e-06,  7.792218798112143e-07, -1.910302079160768e-07,  5.066336880470942e-08, -1.448619964809085e-08,
  4.385829839028531e-09, -1.270905087353010e-09,  2.004295496402142e+00, -2.596059247876410e-03,  5.457327304513249e-04, -1.196007877904507e-04,  2.749645688407997e-05,
 -6.664485468588683e-06,  1.708324926155004e-06, -4.636389565870827e-07,  1.331047950908855e-07, -4.026203137661554e-08,  1.264031758388364e-08, -3.737906274278410e-09,
  1.994695394182240e+00,  3.547956140441108e-03, -1.145204219052803e-03,  3.131363232185251e-04, -7.897749319006068e-05,  1.899782764221270e-05, -4.431516339391800e-06,
  1.011972474554232e-06, -2.275774894695909e-07,  5.059616788671121e-08, -1.113018440089694e-08,  2.327600623518867e-09,  1.996836561950524e+00,  2.146292729960352e-03,
 -7.237550705006522e-04,  1.996998545653423e-04, -5.026382782589336e-05,  1.200740359604435e-05, -2.774696318728823e-06,  6.268554758380703e-07, -1.393642624266267e-07,
  3.062094301992573e-08, -6.657062920099662e-09,  1.377247581823233e-09,  1.998259747072445e+00,  1.220163802829290e-03, -4.521009940342792e-04,  1.283535819004641e-04,
 -3.263387326574358e-05,  7.815207362099002e-06, -1.803649732411810e-06,  4.061313714893239e-07, -8.989196307346210e-08,  1.965142791774891e-08, -4.249698666254655e-09,
  8.748659848409669e-10,  1.999301015056625e+00,  5.453553400851135e-04, -2.575870196912119e-04,  7.813255230095907e-05, -2.042806856170835e-05,  4.958890027488563e-06,
 -1.152141661595723e-06,  2.602088659499638e-07, -5.764294622668933e-08,  1.259596723985877e-08, -2.720698434083034e-09,  5.592744066994886e-10,  2.000089941577226e+00,
  3.564841109649054e-05, -1.125794674307318e-04,  4.116796138751316e-05, -1.155365853437029e-05,  2.906372535170835e-06, -6.891685469305956e-07,  1.576029694402851e-07,
 -3.519132478118549e-08,  7.729501623269286e-09, -1.675122614523606e-09,  3.450539137985859e-10,  2.000692485609332e+00, -3.527314880518603e-04, -3.196630133631337e-06,
  1.355475537727294e-05, -4.985657500203207e-06,  1.400626616995635e-06, -3.523383537955439e-07,  8.353247003788062e-08, -1.910073804379449e-08,  4.265100435156937e-09,
 -9.353189639902603e-10,  1.942633778773185e-10,  2.001146882138278e+00, -6.450997195443382e-04,  7.851270100041656e-05, -6.920018740671206e-06, -1.497555442873860e-07,
  2.993048391048001e-07, -1.075015783379499e-07,  3.000153689292596e-08, -7.533748156086874e-09,  1.786743011322957e-09, -4.083944791667907e-10,  8.725640690885359e-11,
  2.001476778914058e+00, -8.570818473924705e-04,  1.374159967127263e-04, -2.159889183205759e-05,  3.299196927035524e-06, -4.823252284279278e-07,  6.547551386331597e-08,
 -7.659607767972984e-09,  5.728825109509061e-10,  5.584441905897913e-11, -4.152942094319063e-11,  1.294578761373305e-11,  2.001697073194106e+00, -9.985053027970891e-04,
  1.765540966849386e-04, -3.131451820452591e-05,  5.573666106924864e-06, -9.960296487437001e-07,  1.788013102333683e-07, -3.226179014109761e-08,  5.854584054677576e-09,
 -1.069207753367540e-09,  1.964244457613839e-10, -3.516965998790313e-11,  2.001816830868722e+00, -1.075342658579805e-03,  1.977649695421167e-04, -3.656729596834313e-05,
  6.800596014649120e-06, -1.272559033394267e-06,  2.396869167475104e-07, -4.545615945501440e-08,  8.682654046413838e-09, -1.670745234996163e-09,  3.234908750881765e-10,
 -6.083639621195797e-11,  1.999402280849868e+00,  4.250963796056019e-04, -1.623627843986772e-04,  4.511157855593220e-05, -1.106350312504722e-05,  2.537431951439146e-06,
 -5.581367406567578e-07,  1.193166333086707e-07, -2.498569281299725e-08,  5.150851523168943e-09, -1.047476295180380e-09,  2.031909551409948e-10,  1.999811822839099e+00,
  1.623463449006720e-04, -8.990066288290295e-05,  2.724676398003127e-05, -6.924835139073593e-06,  1.615911249141543e-06, -3.585110202425686e-07,  7.693564827002474e-08,
 -1.612582322994824e-08,  3.321183333724088e-09, -6.738901121756359e-10,  1.303486529789802e-10,  2.000096301006406e+00, -1.967405699420855e-05, -4.030239648943919e-05,
  1.516509020280840e-05, -4.159210918818161e-06,  1.007377641736388e-06, -2.282270708481636e-07,  4.959611601237661e-08, -1.047586487240240e-08,  2.167615932331602e-09,
 -4.409764254115908e-10,  8.540041565656370e-11,  2.000310961397097e+00, -1.567551947098988e-04, -3.274188747235711e-06,  6.223524775080915e-06, -2.129950801417124e-06,
  5.646525424980223e-07, -1.342338365550148e-07,  3.003443189646274e-08, -6.466045346153333e-09,  1.355451359701301e-09, -2.782746210969659e-10,  5.422644100041251e-11,
  2.000477405718149e+00, -2.628877085901122e-04,  2.520240054809011e-05, -6.072661440174609e-07, -5.898997167000755e-07,  2.308293027521834e-07, -6.381116041640919e-08,
  1.546957583962060e-08, -3.498750119388444e-09,  7.580451836422999e-10, -1.592944568358916e-10,  3.155119106424524e-11,  2.000606798312065e+00, -3.452989884419829e-04,
  4.719874659747116e-05, -5.856270318969808e-06,  5.874872779832286e-07, -2.310389205300886e-08, -1.050496181022558e-08,  4.497750519882345e-09, -1.273968278772627e-09,
  3.121853379163063e-10, -7.089226937801641e-11,  1.477188735654641e-11,  2.000705705183546e+00, -4.082374062687080e-04,  6.392952160012741e-05, -9.832730913973473e-06,
  1.475917805321202e-06, -2.139762337049518e-07,  2.941201628647938e-08, -3.687911812270528e-09,  3.798851502096510e-10, -1.809556887051984e-11, -5.628536788768818e-12,
  2.422602237410288e-12,  2.000778239495447e+00, -4.543629389689313e-04,  7.615350872419167e-05, -1.272927464783976e-05,  2.121153098336441e-06, -3.521981935558709e-07,
  5.823646979241191e-08, -9.582558224912918e-09,  1.567658121123433e-09, -2.546795345669304e-10,  4.100276586020409e-11, -6.380860087207794e-12,  2.000827019976222e+00,
 -4.853683608110325e-04,  8.435261708096798e-05, -1.466794142290370e-05,  2.552105197545658e-06, -4.443272751523890e-07,  7.741043354857277e-08, -1.349603592498962e-08,
  2.354734022930579e-09, -4.111639304693658e-10,  7.179166141435192e-11, -1.218414174037965e-11,  2.000853654934076e+00, -5.022928386304304e-04,  8.882210122096519e-05,
 -1.572333601563277e-05,  2.786405872547779e-06, -4.943523363726056e-07,  8.780876065825813e-08, -1.561581206329705e-08,  2.780562392925397e-09, -4.957298876118494e-10,
  8.841212939963051e-11, -1.531377017977143e-11,  2.000084620060822e+00, -3.394510273291011e-05, -1.264360805306269e-05,  5.530015828614515e-06, -1.560069612027004e-06,
  3.787942825336626e-07, -8.518492868374114e-08,  1.828350125212353e-08, -3.802951764002522e-09,  7.733222002624893e-10, -1.543986462651593e-10,  2.935391764819489e-11,
  2.000175134740338e+00, -9.150022174628193e-05,  2.602288991077761e-06,  1.921290888890042e-06, -7.575660794503647e-07,  2.072905472181699e-07, -4.952910807043670e-08,
  1.101912721052959e-08, -2.345693012550373e-09,  4.845618930777289e-10, -9.781713789226613e-11,  1.873707828696694e-11,  2.000239256646411e+00, -1.322205612616472e-04,
  1.332510825444877e-05, -6.017489607676247e-07, -1.998236017609113e-07,  8.879980499101910e-08, -2.503986744899715e-08,  6.059052044453030e-09, -1.356493954144114e-09,
  2.896877278025159e-10, -5.985195520212986e-11,  1.165147007193176e-11,  2.000288334571327e+00, -1.633578541533062e-04,  2.148880738897228e-05, -2.514258060277029e-06,
  2.211155961766902e-07, -2.402159643833672e-10, -6.716636574385594e-09,  2.363728121692599e-09, -6.226603033919900e-10,  1.457313885321700e-10, -3.192356782688267e-11,
  6.459268711307108e-12,  2.000326806161802e+00, -1.877481598515055e-04,  2.786197292372768e-05, -4.002247564617873e-06,  5.475151158805538e-07, -6.905123804664477e-08,
  7.396633872327513e-09, -4.731583542562531e-10, -6.114405364857729e-11,  3.593632476800849e-11, -1.069094899835020e-11,  2.523621880448446e-12,  2.000356968853146e+00,
 -2.068598065309925e-04,  3.284257466426606e-05, -5.162013909958554e-06,  8.012438964983118e-07, -1.224014212684145e-07,  1.831034580808644e-08, -2.661240034485905e-09,
  3.708431327470765e-10, -4.831738529995355e-11,  5.561659211543370e-12, -4.819601771322148e-13,  2.000380177074089e+00, -2.215584106956046e-04,  3.666518693665760e-05,
 -6.050291549312460e-06,  9.951773770904220e-07, -1.630954629855040e-07,  2.661816745949214e-08, -4.323528449317219e-09,  6.983727636190040e-10, -1.120724610642825e-10,
  1.783626844940312e-11, -2.747826358015823e-12,  2.000397281438606e+00, -2.323875708541585e-04,  3.947707683963930e-05, -6.702679732441137e-06,  1.137388531059300e-06,
 -1.928902943204153e-07,  3.269158191998646e-08, -5.536902132065084e-09,  9.370924642217678e-10, -1.584715284660315e-10,  2.675635653040737e-11, -4.392235220336146e-12,
  2.000408824786392e+00, -2.396941744099384e-04,  4.137218845996337e-05, -7.141875793308835e-06,  1.233020939757857e-06, -2.129043793172479e-07,  3.676684722835184e-08,
 -6.350202105192956e-09,  1.096931519443580e-09, -1.895062472763526e-10,  3.271653246496490e-11, -5.489937745419650e-12,  2.000415141409627e+00, -2.436918159140604e-04,
  4.240833437580631e-05, -7.381837847097969e-06,  1.285235224657878e-06, -2.238243847680123e-07,  3.898887231598186e-08, -6.793354434528722e-09,  1.183967285613668e-09,
 -2.063942679459834e-10,  3.595776989275082e-11, -6.086530811101632e-12,  2.000125838369376e+00, -7.014053522692767e-05,  7.828760860178625e-06, -6.000281666753070e-07,
 -2.836487718880036e-08,  2.806562771309642e-08, -8.913301914660986e-09,  2.253083362098980e-09, -5.143915029908294e-10,  1.108205516817809e-10, -2.296536966336959e-11,
  4.469643537487055e-12,  2.000147163637453e+00, -8.364331419282060e-05,  1.133632990219865e-05, -1.414056462035431e-06,  1.491082747501823e-07, -9.117265083717433e-09,
 -1.334952458530177e-09,  7.394840616857918e-10, -2.167362560285645e-10,  5.300068564514917e-11, -1.185791547922767e-11,  2.423686165081372e-12,  2.000162412166293e+00,
 -9.329232825147376e-05,  1.383546686972450e-05, -1.992335544264535e-06,  2.748104296751459e-07, -3.537552201801638e-08,  4.000997267330837e-09, -3.231034228253734e-10,
 -8.389559176288396e-12,  1.264798910958704e-11, -4.128599100931422e-12,  1.003850184315942e-12,  2.000174163259564e+00, -1.007247636869615e-04,  1.575631952939105e-05,
 -2.435832573706496e-06,  3.710036395377291e-07, -5.542565407308351e-08,  8.066504719449701e-09, -1.130936970891660e-09,  1.496626901283829e-10, -1.789746398140738e-11,
  1.709643979230148e-12, -6.645712556883820e-14,  2.000183423763986e+00, -1.065798077014191e-04,  1.726694541595552e-05, -2.784019744929644e-06,  4.463956757857415e-07,
 -7.111333168857228e-08,  1.124205186896337e-08, -1.760864278623421e-09,  2.726999185080448e-10, -4.163592611430821e-11,  6.239290363962460e-12, -8.955729278956326e-13,
  2.000190714520532e+00, -1.111881436739599e-04,  1.845432664464882e-05, -3.057333753884691e-06,  5.054960995037343e-07, -8.339454019983925e-08,  1.372472876906616e-08,
 -2.252692442133676e-09,  3.686362504646617e-10, -6.012117395656153e-11,  9.761928906539261e-12, -1.539576524794803e-12,  2.000196342495079e+00, -1.147446768848557e-04,
  1.936974399154178e-05, -3.267825257316324e-06,  5.509642457557959e-07, -9.283303926992207e-08,  1.563075481771316e-08, -2.629891542322112e-09,  4.421368609669321e-10,
 -7.426887358464584e-11,  1.245523293524647e-11, -2.031493959785264e-12,  2.000200500467596e+00, -1.173718157227347e-04,  2.004540873775849e-05, -3.423064263051998e-06,
  5.844706620853992e-07, -9.978294838317673e-08,  1.703312218113223e-08, -2.907199206613201e-09,  4.961304271520986e-10, -8.465368117441540e-11,  1.443066776622019e-11,
 -2.392036821023134e-12,  2.000203311484224e+00, -1.191476915442536e-04,  2.050188234250100e-05, -3.527882986849356e-06,  6.070816665505057e-07, -1.044702794289456e-07,
  1.797840968264413e-08, -3.094018066962543e-09,  5.324849762541726e-10, -9.164202690518265e-11,  1.575928567752569e-11, -2.634402941787486e-12,  2.000204851370896e+00,
 -1.201204507030455e-04,  2.075183357275867e-05, -3.585258238137739e-06,  6.194540078828607e-07, -1.070341994165434e-07,  1.849529024567101e-08, -3.196134388368757e-09,
  5.523496813086807e-10, -9.545924939925505e-11,  1.648476389676653e-11, -2.766702214542367e-12,  2.000082444265959e+00, -4.743971385986646e-05,  7.135462494759172e-06,
 -1.049440142334234e-06,  1.496163323477204e-07, -2.037007174817373e-08,  2.572147587643570e-09, -2.806442150987747e-10,  2.017889075747820e-11,  1.406880793561048e-12,
 -1.085316150174678e-12,  3.157546745271221e-13,  2.000087622535066e+00, -5.071175674667513e-05,  7.977283636816633e-06, -1.242918242183288e-06,  1.913886158270867e-07,
 -2.903678609623939e-08,  4.321340174206164e-09, -6.266021103754951e-10,  8.755001596017144e-11, -1.155253375051526e-11,  1.380095109132747e-12, -1.342403946157647e-13,
  2.000091342075104e+00, -5.306132635330272e-05,  8.580889714522425e-06, -1.381442044990935e-06,  2.212519174051232e-07, -3.522350796690032e-08,  5.568150244838377e-09,
 -8.728331640510404e-10,  1.354296459828101e-10, -2.074899013888022e-11,  3.127067807000439e-12, -4.526652852949486e-13,  2.000094218127826e+00, -5.487765992158463e-05,
  9.047000570493060e-06, -1.488294461265446e-06,  2.442621459349522e-07, -3.998525894793297e-08,  6.526732947638873e-09, -1.061934999020651e-09,  1.721602351484230e-10,
 -2.779628665713530e-11,  4.464327645845486e-12, -6.961628928544031e-13,  2.000096490547333e+00, -5.631251803836506e-05,  9.414904171660945e-06, -1.572561479361891e-06,
  2.623931504685454e-07, -4.373408440847418e-08,  7.280758411160738e-09, -1.210556106269697e-09,  2.010033066935646e-10, -3.332552989796219e-11,  5.512640040799108e-12,
 -8.868955662976819e-13,  2.000098283304646e+00, -5.744434518579861e-05,  9.704914850625715e-06, -1.638942521163228e-06,  2.766661161101391e-07, -4.668321167132138e-08,
  7.873534294276180e-09, -1.327315448412564e-09,  2.236476523387838e-10, -3.766355121348831e-11,  6.334553787862972e-12, -1.036343147564211e-12,  2.000099669422291e+00,
 -5.831934976884610e-05,  9.929001701155573e-06, -1.690207034037303e-06,  2.876829543108123e-07, -4.895834211215848e-08,  8.330594708207830e-09, -1.417295321828012e-09,
  2.410891828017798e-10, -4.100310220886758e-11,  6.966959354374706e-12, -1.151276487679771e-12,  2.000100694742192e+00, -5.896654145346785e-05,  1.009468016664870e-05,
 -1.728094215040196e-06,  2.958217080647996e-07, -5.063843302819987e-08,  8.667979773848032e-09, -1.483688534490060e-09,  2.539535758045266e-10, -4.346528105895042e-11,
  7.433033634523264e-12, -1.235949408350932e-12,  2.000101388517156e+00, -5.940443243881447e-05,  1.020674667301026e-05, -1.753714138322973e-06,  3.013236881002825e-07,
 -5.177388694509913e-08,  8.895929134861351e-09, -1.528533348501400e-09,  2.626402616786612e-10, -4.512739575916312e-11,  7.747572215589828e-12, -1.293077359557745e-12,
  2.000101768776304e+00, -5.964443214318499e-05,  1.026815729279879e-05, -1.767750929559486e-06,  3.043376050363102e-07, -5.239576334507126e-08,  9.020752344650188e-09,
 -1.553085623668912e-09,  2.673953254540057e-10, -4.603707048146624e-11,  7.919688705618857e-12, -1.324332797195282e-12,  2.000045943978954e+00, -2.670423297338938e-05,
  4.336447827294117e-06, -7.016214079623465e-07,  1.130512630793225e-07, -1.812992630932892e-08,  2.891678337982433e-09, -4.582939318926117e-10,  7.209054831749398e-11,
 -1.123826223308897e-11,  1.732009368009734e-12, -2.577888595972799e-13,  2.000047219994313e+00, -2.750970203937699e-05,  4.542687971144147e-06, -7.487939674562444e-07,
  1.231866982627070e-07, -2.022259968204837e-08,  3.311993731839359e-09, -5.410215249181020e-10,  8.812262136071313e-11, -1.430721367520680e-11,  2.313030175958950e-12,
 -3.633587242909154e-13,  2.000048138609418e+00, -2.808947676618657e-05,  4.691030761266932e-06, -7.826988717854467e-07,  1.304660755893691e-07, -2.172446703665162e-08,
  3.613421703451240e-09, -6.003054210725782e-10,  9.960294618634935e-11, -1.650321612914639e-11,  2.728475918012738e-12, -4.387919349457095e-13,  2.000048850089911e+00,
 -2.853846889249276e-05,  4.805848809566830e-06, -8.089270629321130e-07,  1.360941700754235e-07, -2.288500610787780e-08,  3.846216193355365e-09, -6.460655100841519e-10,
  1.084595120589101e-10, -1.819640430877846e-11,  3.048622675816068e-12, -4.968917531734278e-13,  2.000049412973261e+00, -2.889365425748658e-05,  4.896639669065004e-06,
 -8.296577770903231e-07,  1.405406945166507e-07, -2.380150564117835e-08,  4.029979296418454e-09, -6.821720321975091e-10,  1.154446891495173e-10, -1.953124892524746e-11,
  3.300906234750560e-12, -5.426575150514454e-13,  2.000049857498788e+00, -2.917413463204254e-05,  4.968310714932384e-06, -8.460172297530506e-07,  1.440484365039236e-07,
 -2.452426131894444e-08,  4.174846430736331e-09, -7.106264397974755e-10,  1.209476159202048e-10, -2.058248338216305e-11,  3.499520818172626e-12, -5.786760020821974e-13,
  2.000050201471212e+00, -2.939115736383657e-05,  5.023751878706861e-06, -8.586687350164928e-07,  1.467604108208382e-07, -2.508290364708033e-08,  4.286789339586512e-09,
 -7.326081108913448e-10,  1.251976205663345e-10, -2.139415412325005e-11,  3.652833000393599e-12, -6.064720777816375e-13,  2.000050456064665e+00, -2.955178137753618e-05,
  5.064777098109789e-06, -8.680286808823436e-07,  1.487664020140109e-07, -2.549603630606692e-08,  4.369557731808595e-09, -7.488576452031456e-10,  1.283387220255494e-10,
 -2.199392433376334e-11,  3.766097696514078e-12, -6.270035359571260e-13,  2.000050628408170e+00, -2.966051029801780e-05,  5.092543760704728e-06, -8.743627636490008e-07,
  1.501237052066254e-07, -2.577553177955310e-08,  4.425544729125596e-09, -7.598477292751367e-10,  1.304628444624418e-10, -2.239945157204520e-11,  3.842669273028944e-12,
 -6.408817837408268e-13,  2.000050722895533e+00, -2.972011982801430e-05,  5.107765197760511e-06, -8.778347397024557e-07,  1.508676329649894e-07, -2.592870736479781e-08,
  4.456225256889152e-09, -7.658696851106392e-10,  1.316266409186932e-10, -2.262161803052210e-11,  3.884614952662319e-12, -6.484836097674102e-13,  2.000024133122020e+00,
 -1.408514163264279e-05,  2.356008632594534e-06, -3.937878596989406e-07,  6.576556303982499e-08, -1.097399693038188e-08,  1.829526059009548e-09, -3.047158881260985e-10,
  5.069988364435541e-11, -8.426284417408540e-12,  1.397815977765215e-12, -2.255833575826968e-13,  2.000024449841942e+00, -1.428496627724464e-05,  2.407051929500284e-06,
 -4.054347697445324e-07,  6.826197117712937e-08, -1.148818811854995e-08,  1.932552190958566e-09, -3.249447175816306e-10,  5.461061431846641e-11, -9.173087439669289e-12,
  1.538861697275049e-12, -2.511530677310872e-13,  2.000024678105462e+00, -1.442897096844734e-05,  2.443823135380578e-06, -4.138220258616780e-07,  7.005903792496675e-08,
 -1.185819722145702e-08,  2.006661744624710e-09, -3.394904807923212e-10,  5.742162567453282e-11, -9.709686271865747e-12,  1.640169578296888e-12, -2.695124816241308e-13,
  2.000024855045104e+00, -1.454059053580331e-05,  2.472317155826591e-06, -4.203195335038893e-07,  7.145082149680291e-08, -1.214468118499415e-08,  2.064026140651964e-09,
 -3.507465051029821e-10,  5.959628575313138e-11, -1.012469651188050e-11,  1.718500486073984e-12, -2.837042669201098e-13,  2.000024995120369e+00, -1.462895082548056e-05,
  2.494868805515347e-06, -4.254608968299485e-07,  7.255187844648584e-08, -1.237127331820093e-08,  2.109388256889307e-09, -3.596455264867386e-10,  6.131520294691331e-11,
 -1.045266246841518e-11,  1.780388979746986e-12, -2.949148039321698e-13,  2.000025105798510e+00, -1.469876475827333e-05,  2.512683990601820e-06, -4.295217442915054e-07,
  7.342138781207863e-08, -1.255018359985575e-08,  2.145198702128919e-09, -3.666695279106548e-10,  6.267171365594474e-11, -1.071143787334134e-11,  1.829212651867788e-12,
 -3.037573606704931e-13,  2.000025191475194e+00, -1.475280668321909e-05,  2.526472645818424e-06, -4.326643549468142e-07,  7.409419449336391e-08, -1.268860185647384e-08,
  2.172900617978369e-09, -3.721023649153111e-10,  6.372079053591039e-11, -1.091153880770261e-11,  1.866961078607033e-12, -3.105932052444041e-13,  2.000025254908633e+00,
 -1.479281748345303e-05,  2.536680276505988e-06, -4.349905697595626e-07,  7.459216725126901e-08, -1.279104069659204e-08,  2.193399824278670e-09, -3.761222151489573e-10,
  6.449694199001123e-11, -1.105956693981871e-11,  1.894883314019470e-12, -3.156491513697657e-13,  2.000025297858331e+00, -1.481990770431182e-05,  2.543591091981135e-06,
 -4.365653607269902e-07,  7.492925838255109e-08, -1.286037928455695e-08,  2.207274280435495e-09, -3.788427692963439e-10,  6.502218775482031e-11, -1.115973492566330e-11,
  1.913776430845740e-12, -3.190699425571149e-13,  2.000025321408703e+00, -1.483476179634307e-05,  2.547380256897555e-06, -4.374287717531484e-07,  7.511406707761479e-08,
 -1.289839213512267e-08,  2.214880200812562e-09, -3.803340985556865e-10,  6.531009930346122e-11, -1.121463915997102e-11,  1.924131689974404e-12, -3.209447886087127e-13,
  2.000012354464342e+00, -7.224219479283264e-06,  1.224411721737610e-06, -2.074857145482224e-07,  3.515370081359564e-08, -5.954892184959490e-09,  1.008543265908241e-09,
 -1.707774897685040e-10,  2.891209089059757e-11, -4.893609666160759e-12,  8.274687338060595e-13, -1.361054557064342e-13,  2.000012433360991e+00, -7.273984355074123e-06,
  1.237108576347860e-06, -2.103793707571557e-07,  3.577318275316750e-08, -6.082334476268908e-09,  1.034047463729695e-09, -1.757791020194269e-10,  2.987785698194236e-11,
 -5.077811885236138e-12,  8.622163959747503e-13, -1.423976326321167e-13,  2.000012490254228e+00, -7.309868968283110e-06,  1.246262395139410e-06, -2.124651730375730e-07,
  3.621963456316583e-08, -6.174163315066216e-09,  1.052421166728651e-09, -1.793816892070334e-10,  3.057335494728948e-11, -5.210440795945178e-12,  8.872307162451112e-13,
 -1.469264916967161e-13,  2.000012534373513e+00, -7.337695791878455e-06,  1.253359786701350e-06, -2.140821733603985e-07,  3.656569491358634e-08, -6.245333242923890e-09,
  1.066659339073006e-09, -1.821730253744987e-10,  3.111216238141103e-11, -5.313175221290033e-12,  9.066041601650407e-13, -1.504336145216279e-13,  2.000012569312072e+00,
 -7.359731672063368e-06,  1.258979568086885e-06, -2.153623921626874e-07,  3.683964989430506e-08, -6.301668082544127e-09,  1.077928404958450e-09, -1.843820417133749e-10,
  3.153851944851894e-11, -5.394459955477919e-12,  9.219310180333018e-13, -1.532079149582544e-13,  2.000012596925245e+00, -7.377147094338867e-06,  1.263420627065729e-06,
 -2.163740053416815e-07,  3.705610732407892e-08, -6.346175594082196e-09,  1.086830804665624e-09, -1.861269837423774e-10,  3.187527784793702e-11, -5.458657270009481e-12,
  9.340348827413416e-13, -1.553986496271918e-13,  2.000012618305061e+00, -7.390630997333402e-06,  1.266858893838523e-06, -2.171571439778261e-07,  3.722366630237955e-08,
 -6.380626409308044e-09,  1.093721201556207e-09, -1.874774666662888e-10,  3.213589168484288e-11, -5.508335582973959e-12,  9.434006876585850e-13, -1.570937042556067e-13,
  2.000012634136687e+00, -7.400615641700690e-06,  1.269404755744142e-06, -2.177369890942815e-07,  3.734772266870941e-08, -6.406131614238790e-09,  1.098822156583372e-09,
 -1.884771772414427e-10,  3.232880428201247e-11, -5.545106790296665e-12,  9.503327775440344e-13, -1.583482374979893e-13,  2.000012644857172e+00, -7.407376755528296e-06,
  1.271128627675905e-06, -2.181296037607121e-07,  3.743171852710155e-08, -6.423400006607128e-09,  1.102275651698521e-09, -1.891539858778208e-10,  3.245940225764905e-11,
 -5.569999260793959e-12,  9.550253244167609e-13, -1.591974412549527e-13,  2.000012650735876e+00, -7.411084273626251e-06,  1.272073907407595e-06, -2.183448879264739e-07,
  3.747777531307689e-08, -6.432868433541179e-09,  1.104169193647401e-09, -1.895250697956185e-10,  3.253100552518042e-11, -5.583646806394223e-12,  9.575980020556904e-13,
 -1.596630053390124e-13,  2.000006248912764e+00, -3.657322550819177e-06,  6.237410115367121e-07, -1.063719557433188e-07,  1.813976087325663e-08, -3.093266213460781e-09,
  5.274534256365267e-10, -8.993562453713808e-11,  1.533414867498743e-11, -2.614314579300745e-12,  4.453384441514943e-13, -7.377656001427036e-14,  2.000006268601644e+00,
 -3.669739954713519e-06,  6.269072675469431e-07, -1.070931237090220e-07,  1.829405762782713e-08, -3.124989624121151e-09,  5.337981951859926e-10, -9.117914207227308e-11,
  1.557411563210074e-11, -2.660056239885024e-12,  4.539618991309344e-13, -7.533723155257553e-14,  2.000006282803443e+00, -3.678696588587530e-06,  6.291908697875785e-07,
 -1.076132045891233e-07,  1.840532071917792e-08, -3.147863196423256e-09,  5.383725486966014e-10, -9.207559090909495e-11,  1.574709119215107e-11, -2.693025175997354e-12,
  4.601767995764499e-13, -7.646190579441927e-14,  2.000006293818854e+00, -3.685643566360572e-06,  6.309619657570729e-07, -1.080165366804072e-07,  1.849160131826758e-08,
 -3.165599622292244e-09,  5.419193093878183e-10, -9.277061154908256e-11,  1.588119063079794e-11, -2.718582605256902e-12,  4.649942422336128e-13, -7.733363405271547e-14,
  2.000006302543489e+00, -3.691145781887621e-06,  6.323646526085317e-07, -1.083359537528337e-07,  1.855992718086197e-08, -3.179644393195211e-09,  5.447276966433987e-10,
 -9.332091134327245e-11,  1.598736144336811e-11, -2.738816145694664e-12,  4.688079542740369e-13, -7.802369992623622e-14,  2.000006309439755e+00, -3.695494892830869e-06,
  6.334733304493782e-07, -1.085884089640305e-07,  1.861392706651146e-08, -3.190743904128175e-09,  5.469470559837781e-10, -9.375577330325579e-11,  1.607125693824001e-11,
 -2.754803875912458e-12,  4.718212678962690e-13, -7.856891724640405e-14,  2.000006314779802e+00, -3.698862555086560e-06,  6.343317885765572e-07, -1.087838805581285e-07,
  1.865573682556186e-08, -3.199337484643121e-09,  5.486652943019593e-10, -9.409243418200477e-11,  1.613620487035634e-11, -2.767180407473865e-12,  4.741538771390998e-13,
 -7.899095734519237e-14,  2.000006318734375e+00, -3.701356465097882e-06,  6.349675007206448e-07, -1.089286290613738e-07,  1.868669654987733e-08, -3.205700786756327e-09,
  5.499375686001509e-10, -9.434170931782377e-11,  1.618429329923672e-11, -2.776343945058599e-12,  4.758808885276351e-13, -7.930341891230171e-14,  2.000006321412384e+00,
 -3.703045317092738e-06,  6.353979912209059e-07, -1.090266478479182e-07,  1.870766104801220e-08, -3.210009643539123e-09,  5.507990628701067e-10, -9.451049776556604e-11,
  1.621685420382918e-11, -2.782548507435577e-12,  4.770502138103320e-13, -7.951497687778515e-14,  2.000006322880951e+00, -3.703971447953082e-06,  6.356340605103482e-07,
 -1.090803980808555e-07,  1.871915714949246e-08, -3.212372423386788e-09,  5.512714615412991e-10, -9.460305152540738e-11,  1.623470850595263e-11, -2.785950651061236e-12,
  4.776913819305653e-13, -7.963097777788880e-14,  2.000003142339764e+00, -1.839939657993182e-06,  3.147459958625065e-07, -5.384090984392236e-08,  9.210009561609670e-09,
 -1.575445039396645e-09,  2.694895249303461e-10, -4.609734770317264e-11,  7.885061486808604e-12, -1.348712394102794e-12,  2.305040181364830e-13, -3.830632642812857e-14,
  2.000003147257582e+00, -1.843041038036894e-06,  3.155365675585077e-07, -5.402092187191023e-08,  9.248512268891119e-09, -1.583358810491006e-09,  2.710718235832928e-10,
 -4.640737035520515e-11,  7.944869835067471e-12, -1.360109409384998e-12,  2.326519963542746e-13, -3.869495753381355e-14,  2.000003150805347e+00, -1.845278384722996e-06,
  3.161068628298072e-07, -5.415077130233752e-08,  9.276284433321890e-09, -1.589066782578711e-09,  2.722130365265718e-10, -4.663095991309944e-11,  7.988001850293741e-12,
 -1.368328219020776e-12,  2.342009113872772e-13, -3.897518871439544e-14,  2.000003153557401e+00, -1.847013915044407e-06,  3.165492310961161e-07, -5.425148983059992e-08,
  9.297825346921996e-09, -1.593493902344032e-09,  2.730981340827848e-10, -4.680436466035430e-11,  8.021451703928111e-12, -1.374701871772441e-12,  2.354020472612941e-13,
 -3.919249235010195e-14,  2.000003155737311e+00, -1.848388625826679e-06,  3.168996209880520e-07, -5.433126455857734e-08,  9.314886500419216e-09, -1.597000240761520e-09,
  2.737991243297523e-10, -4.694169613507972e-11,  8.047942291100469e-12, -1.379749344986016e-12,  2.363532346234071e-13, -3.936457217697515e-14,  2.000003157460501e+00,
 -1.849475311293532e-06,  3.171765924126663e-07, -5.439432245998227e-08,  9.328372195024651e-09, -1.599771706354334e-09,  2.743531863197908e-10, -4.705024047460569e-11,
  8.068879529213952e-12, -1.383738606808044e-12,  2.371049879134385e-13, -3.950056955919613e-14,  2.000003158794899e+00, -1.850316813218275e-06,  3.173910685955606e-07,
 -5.444315129935566e-08,  9.338814658427260e-09, -1.601917716997444e-09,  2.747822022994124e-10, -4.713428608152256e-11,  8.085090907974735e-12, -1.386827378611670e-12,
  2.376870393605585e-13, -3.960586505333178e-14,  2.000003159783127e+00, -1.850940009702410e-06,  3.175499026137628e-07, -5.447931187781183e-08,  9.346547808253099e-09,
 -1.603506921615310e-09,  2.750999013330260e-10, -4.719652354972235e-11,  8.097095608344471e-12, -1.389114618247421e-12,  2.381180437689810e-13, -3.968383459159204e-14,
  2.000003160452365e+00, -1.851362044624573e-06,  3.176574656474783e-07, -5.450379974582687e-08,  9.351784633751673e-09, -1.604583108165988e-09,  2.753150406053150e-10,
 -4.723866910458803e-11,  8.105224797679949e-12, -1.390663447838943e-12,  2.384099005262457e-13, -3.973663160035562e-14,  2.000003160819368e+00, -1.851593483878092e-06,
  3.177164516888223e-07, -5.451722846951047e-08,  9.354656402124815e-09, -1.605173263592868e-09,  2.754330172598129e-10, -4.726178047467443e-11,  8.109682578268876e-12,
 -1.391512770323178e-12,  2.385699433776960e-13, -3.976558326516611e-14,   0.00157322429307089,   0.00120998670321152,  0.000854948263057205,  0.000243275302781882,
   3.7199616672289e-05,  2.94498515947774e-06,  1.10366826297354e-07,  1.65652614838865e-09,  7.15323449075179e-12,  3.83968742838929e-15,  0.000784993726195545,
  0.000603649350826484,  0.000426723805435028,  0.000121479318030023,  1.85872549467351e-05,  1.47272788765639e-06,  5.52528903655149e-08,  8.30516696761176e-10,
  3.59356925417184e-12,   1.9348627200998e-15,  0.000392104370896686,  0.000301511991404619,  0.000213162615174252,  6.06888881699615e-05,  9.28710470256227e-06,
  7.35976455339885e-07,  2.76181632927228e-08,  4.15255483339728e-10,  1.79747230194855e-12,  9.68347164849239e-16,  0.000195955361748543,  0.000150680262450988,
  0.000106530324551359,  3.03306268929106e-05,  4.64158295611486e-06,  3.67847106884516e-07,  1.38045021453494e-08,  2.07572640620246e-10,  8.98575557341583e-13,
  4.84146453564659e-16,  9.79536267482662e-05,  7.53214792112782e-05,  5.32522861224003e-05,  1.51617320015106e-05,  2.32026092168954e-06,  1.83883306261555e-07,
  6.90082650509878e-09,  1.03766538184925e-10,  4.49211353720761e-13,  2.42038997564839e-16,   4.8970818220095e-05,  3.76561104511606e-05,  2.66229085480614e-05,
  7.57995549688508e-06,  1.15999327693803e-06,  9.19310019941447e-08,  3.45002404132946e-09,  5.18776166229428e-11,  2.24582327327739e-13,  1.21007758657362e-16,
  2.44839125832119e-05,  1.88269020901606e-05,  1.33106437602447e-05,  3.78974827415441e-06,  5.79961788091981e-07,  4.59627664132528e-08,  1.72491069614777e-09,
  2.59373094193959e-11,  1.12284812997812e-13,  6.05005609389669e-17,  1.22415824404408e-05,  9.41316327562631e-06,  6.65511901896264e-06,  1.89481654017594e-06,
  2.89972112986131e-07,  2.29806906994421e-08,  8.62429521042039e-10,  1.29682694223958e-11,   5.6140755711017e-14,  3.02494038286401e-17,  6.12069779236339e-06,
  4.70650975945667e-06,  3.32750876528575e-06,  9.47393842488776e-07,  1.44983852721388e-07,  1.14901711222875e-08,  4.31208242195309e-10,   6.4840370785481e-12,
  2.80699573323441e-14,  1.51244769275651e-17,  3.06032554357591e-06,  2.35323691812188e-06,  1.66374169299217e-06,  4.73693310808242e-07,  7.24913743576335e-08,
  5.74504186714141e-09,  2.15602483846339e-10,  3.24199396786132e-12,  1.40348725610762e-14,  7.56218149211604e-18,   1.5301569341808e-06,  1.17661396965603e-06,
  8.31867673633895e-07,  2.36845752353689e-07,  3.62455490457331e-08,  2.87250999295426e-09,  1.07800831653229e-10,  1.62099082070873e-12,  7.01740963272322e-15,
  3.78107641272709e-18  };
  int offset = -10;
  const int ibox0 = static_cast<int>(log(64.0) / log(2.0));
  for (int i = 1; i <= n; ++i) {
    double t = ta[i-1];
    offset += 10;
    if (std::isnan(t)) {
      fill_n(rr+offset, 10, 0.5);
      fill_n(ww+offset, 10, 0.0);
    } else if (t >= 131072.0) {
      for (int r = 0; r != 10; ++r) {
        ww[offset+r] = aw[10-r-1] / t;
        rr[offset+r] = 1.0 - ax[10-r-1] / t;
      }
    } else {
      assert(t >= 0);
      int it;
      double bigT = 0.0;
      if (t >= 64.0 && t < 131072.0) {
        bigT = t;
        it = static_cast<int>(log(bigT) / log(2.0) + 32 - ibox0);
        t = (t - 1.5 * pow(2.0, it + ibox0 - 32))* 2/pow(2.0, it + ibox0 - 32);
      } else {
        it = static_cast<int>(t*   0.500000000000000);
        t = (t - it *2.000000000000000-   1.000000000000000) *   1.000000000000000;
      }
      const double t2 = t * 2.0;
      for (int j=1; j <=10; ++j) {
        const int boxof = it*120+12*(j-1);
        double d = x[boxof+11];
        double e = w[boxof+11];
        double f = t2*d + x[boxof+10];
        double g = t2*e + w[boxof+10];
        d = t2*f - d + x[boxof+9];
        e = t2*g - e + w[boxof+9];
        f = t2*d - f + x[boxof+8];
        g = t2*e - g + w[boxof+8];
        d = t2*f - d + x[boxof+7];
        e = t2*g - e + w[boxof+7];
        f = t2*d - f + x[boxof+6];
        g = t2*e - g + w[boxof+6];
        d = t2*f - d + x[boxof+5];
        e = t2*g - e + w[boxof+5];
        f = t2*d - f + x[boxof+4];
        g = t2*e - g + w[boxof+4];
        d = t2*f - d + x[boxof+3];
        e = t2*g - e + w[boxof+3];
        f = t2*d - f + x[boxof+2];
        g = t2*e - g + w[boxof+2];
        d = t2*f - d + x[boxof+1];
        e = t2*g - e + w[boxof+1];
        rr[offset+j-1] = t*d - f + x[boxof+0]*0.5;
        ww[offset+j-1] = t*e - g + w[boxof+0]*0.5;
        if (64.0 <= bigT && bigT < 131072.0) {
          const int iref = 5160 + (it - 32) * 10 + 10 - j;
          double rr_infty = x[iref];
          double ww_infty = w[iref];
          double Tref = pow(2.0, it + ibox0 + 1 - 32);
          ww[offset+j-1] = ww[offset+j-1] * ww_infty * Tref / bigT;
          rr[offset+j-1] = 1.0 + rr[offset+j-1] * (1.0 - rr_infty) * Tref /bigT;
        }
      }
    }
  }
}
