//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      Device/Histo/SimulationResult.h
//! @brief     Defines class SimulationResult.
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_DEVICE_HISTO_SIMULATIONRESULT_H
#define BORNAGAIN_DEVICE_HISTO_SIMULATIONRESULT_H

#include "Device/Data/Datafield.h"

#include "Device/Coord/Tags.h"
#include <string>

class ICoordSystem;

//! Wrapper around Datafield that also provides unit conversions.

class SimulationResult : public Datafield {
public:
    SimulationResult(); // required by Swig
    SimulationResult(const Datafield& data, const ICoordSystem* coords);

    SimulationResult(const SimulationResult& other);
    SimulationResult(SimulationResult&& other) noexcept;
    ~SimulationResult() override;

    SimulationResult& operator=(SimulationResult&& other) noexcept;

    Datafield extracted_field() const;

    std::pair<double, double> axisMinMax(size_t i, Coords units = Coords::UNDEFINED) const;

    std::string name_of_axis(size_t i, Coords units = Coords::UNDEFINED) const;

    //! Returns intensity data as Python numpy array
#ifdef BORNAGAIN_PYTHON
    PyObject* array(Coords units = Coords::UNDEFINED) const;
#endif

    std::vector<double> convertedBinCenters(Coords units = Coords::UNDEFINED) const;

    //! Returns axis coordinates as a numpy array. With no parameters given
    //! Returns coordinates of x-axis in default units.
    std::vector<double> convertedBinCenters(size_t i_axis, Coords units = Coords::UNDEFINED) const;

    void setTitle(const std::string& title);
    std::string title();

#ifndef SWIG

    //! Returns underlying unit converter
    const ICoordSystem& converter() const;

private:
    std::string m_title;
#endif // SWIG
};

#endif // BORNAGAIN_DEVICE_HISTO_SIMULATIONRESULT_H
