+++
title = "TruncatedSpheroid"
+++

### TruncatedSpheroid

A vertically oriented, horizontally truncated spheroid.

<img src="/img/draw/ff/3d/TruncatedSpheroid.png" width="30%" >
<img src="/img/draw/ff/2d/TruncatedSpheroid_xy.svg" width="30%">
<img src="/img/draw/ff/2d/TruncatedSpheroid_xz.svg" width="30%">

#### Constructor

```python
TruncatedSpheroid(R, H, f_p, dh)
```

Parameters:
- R, radius
- H, untruncated height (height before top removal)
- f_p, height flattering $f_p$
- dh, top removal

Constraint:

$ dh < H \le 2f_pR $

#### Usage

As for any other [Form factor](/ref/sample/particle/ff).

#### Implementation

Class {{% ref-class "Sample/HardParticle" "TruncatedSpheroid" %}} inherits from the interface class
{{% ref-class "Sample/Particle" "IFormFactor" %}}.

Computation involves numerical integration in vertical direction,

$$ F(\mathbf{q})=2\pi \exp\[iq_z(H-f_pR)\]  \int_{f_pR-H}^{f_pR-dh} \text{d}z \space R_z^2 \frac{J_1(q_{||}R_z)}{q_{||}R_z} \exp(iq_z z), $$

with the notation

$$ q_{||} := \sqrt{q_x^2 + q_y^2}, \quad R_z:=\sqrt{R^2-z^2/f_p^2} $$

Volume [has been validated]({{% url-src %}}/Tests/Unit/Sample/FormFactorBasicTest.cpp)
against
$$ V=\dfrac{\pi}{3f_p^2} \[ 3f_pR(H^2-dh^2) + dh^3 -H^3 \]. $$

#### Related shapes

- [HemiEllipsoid](/ref/sample/particle/ff/hard/hemiellipsoid), top half of ellipsoid.

More special:
- [Spheroid](/ref/sample/particle/ff/hard/spheroid), if $H=2f_pR, \space dh=0.$
- [TruncatedSphere](/ref/sample/particle/ff/hard/truncatedsphere), if $f_p=1$.

#### Example

Scattering by uncorrelated, oriented truncated spheroids for horizontal incidence. Rotation around $y$ axis:

<img src="/img/auto/ff/TruncatedSpheroid.png">

Generated by {{% ref-ex "ff/TruncatedSpheroid.py" %}}.

#### History

Agrees with the IsGISAXS form factor "Spheroid" [[manual](/lit/lazzari2006), Eq. 2.42].
