/*
 * Copyright 2014 - Present Rafael Winterhalter
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.bytebuddy.test.precompiled.v7;

import net.bytebuddy.asm.Advice;
import net.bytebuddy.asm.AdviceTest;

import java.lang.invoke.MethodHandle;

public class AdviceOriginMethodHandle {

    @Advice.OnMethodEnter
    private static void enter(@Advice.Origin MethodHandle origin) throws Exception {
        if (origin == null) {
            throw new AssertionError();
        }
        AdviceTest.Sample.enter++;
    }

    @Advice.OnMethodExit
    private static void exit(@Advice.Origin MethodHandle origin) throws Exception {
        if (origin == null) {
            throw new AssertionError();
        }
        AdviceTest.Sample.exit++;
    }
}
