/*
  This file is part of CDO. CDO is a collection of Operators to manipulate and analyse Climate model Data.

  Author: Uwe Schulzweida

*/
#ifndef VERTICAL_INTERP_H
#define VERTICAL_INTERP_H

#include <cstddef>

void height_to_pressure(double *phlev, const double *hlev, long nphlev);

template <typename T>
void vct_to_hybrid_pressure(T *fullp, T *halfp, const double *vct, const T *ps, long nhlev, long ngp);

void extrapolate_P(double *slp, const double *halfp, const double *fullp, const double *geop, const double *temp, long ngp);

template <typename T>
void vertical_interp_T(const T *geop, const T *gt, T *pt, const T *fullp, const T *halfp, const int *vertIndex, const double *plev,
                       long nplev, long ngp, long nhlev, double missval);

template <typename T>
void vertical_interp_Z(const T *geop, const T *gz, T *pz, const T *fullp, const T *halfp, const int *vertIndex, const T *gt,
                       const double *plev, long nplev, long ngp, long nhlev, double missval);

template <typename T>
void vertical_interp_X(const T *gt, T *pt, const T *hyb_press, const int *vertIndex, const double *plev, long nplev, long ngp, long nhlev,
                       double missval);

template <typename T>
void gen_vert_index(int *vertIndex, const double *plev, const T *fullp, long ngp, long nplev, long nhlev, bool lreverse = false);

template <typename T>
void gen_vert_index_mv(int *vertIndex, const double *plev, long ngp, long nplev, const T *psProg, size_t *pnmiss,
                       bool lreverse = false);

#endif /* VERTICAL_INTERP_H */
