# test bytecode interpreter - statements

# Copyright (c) 2006-2008, 2023-2024 Claudio Calvelli, all rights reserved.

# CLC-INTERCAL is copyrighted software. However, permission to use, modify,
# and distribute it is granted provided that the conditions set out in the
# licence agreement are met. See files README and COPYING in the distribution.

# PERVERSION: CLC-INTERCAL/Base t/05bytecode-statements.t 1.00

use Language::INTERCAL::ByteCode '1.-94.-2.2', qw(:BC BC);
use Language::INTERCAL::Registers '1.-94.-2.2', qw(reg_code);
use Language::INTERCAL::Splats '1.-94.-2.2', qw(SP_HIDDEN);
use Language::INTERCAL::TestBC '1.-94.-2', qw(test_bc test_str);

my @all_tests = (
    ['Comment 1', undef, '', "*000 ERROR\n", undef, 0,
     'ERROR', [], [BC_MSP, BC(0), BC(1), test_str('ERROR')]],
    ['Comment 2', undef, '', "*578 Invalid bytecode pattern in NAME: PROBLEM\n", undef, 578,
     '(Invalid code)', [],
     [BC_MSP, BC(578), BC(2), test_str('NAME'), test_str('PROBLEM')]],
    ['Compiler BUG 1', undef, '', "*774 Compiler error\n", undef, 774,
     'BUG', [], [BC_BUG, BC(0)]],
    ['Compiler BUG 2', undef, '', "*775 Unexplainable compiler error\n", undef, 775,
     'BUG', [], [BC_BUG, BC(1)]],
    ['READ OUT 1', undef, '', "II\n", undef, undef,
     'DO READ OUT #2', [], [BC_ROU, BC(1), BC(2)]],
    ['READ OUT 2', undef, '', "ABCD\n", undef, undef,
     'DO READ OUT <ARRAY>', [], [BC_ROU, BC(1), test_str("[_CYNI")]],
    ['READ OUT 3', undef, '', "ABCD\n", undef, undef,
     'DO ,2 <- #6', [], [BC_STO, BC(6), BC_TAI, BC(2)],
     'DO ,2 SUB #1 <- #91', [], [BC_STO, BC(91), BC_SUB, BC(1), BC_TAI, BC(2)],
     'DO ,2 SUB #2 <- #95', [], [BC_STO, BC(95), BC_SUB, BC(2), BC_TAI, BC(2)],
     'DO ,2 SUB #3 <- #67', [], [BC_STO, BC(67), BC_SUB, BC(3), BC_TAI, BC(2)],
     'DO ,2 SUB #3 <- #89', [], [BC_STO, BC(89), BC_SUB, BC(4), BC_TAI, BC(2)],
     'DO ,2 SUB #4 <- #78', [], [BC_STO, BC(78), BC_SUB, BC(5), BC_TAI, BC(2)],
     'DO ,2 SUB #5 <- #73', [], [BC_STO, BC(73), BC_SUB, BC(6), BC_TAI, BC(2)],
     'DO READ OUT ,2', [], [BC_ROU, BC(1), BC_TAI, BC(2)]],
    ['READ OUT 4', undef, '', "Hi\n", undef, undef,
     'DO ;2 <- #3', [], [BC_STO, BC(3), BC_HYB, BC(2)],
     'DO ;2 SUB #1 <- #29', [], [BC_STO, BC(29), BC_SUB, BC(1), BC_HYB, BC(2)],
     'DO ;2 SUB #2 <- #1118', [], [BC_STO, BC(1118), BC_SUB, BC(2), BC_HYB, BC(2)],
     'DO ;2 SUB #3 <- #92', [], [BC_STO, BC(92), BC_SUB, BC(3), BC_HYB, BC(2)],
     'DO READ OUT ;2', [], [BC_ROU, BC(1), BC_HYB, BC(2)]],
    ['READ OUT 5', undef, '', "Hi\n", undef, undef,
     'DO %IO <- ?C', [], [BC_STO, test_str('C'), reg_code('%IO')],
     'DO ;2 <- #2', [], [BC_STO, BC(2), BC_HYB, BC(2)],
     'DO ;2 SUB #1 <- #238', [], [BC_STO, BC(238), BC_SUB, BC(1), BC_HYB, BC(2)],
     'DO ;2 SUB #2 <- #124', [], [BC_STO, BC(124), BC_SUB, BC(2), BC_HYB, BC(2)],
     'DO ,2 <- #1', [], [BC_STO, BC(1), BC_TAI, BC(2)],
     'DO ,2 SUB #1 <- #70', [], [BC_STO, BC(70), BC_SUB, BC(1), BC_TAI, BC(2)],
     'DO READ OUT ;2 + ,2', [], [BC_ROU, BC(2), BC_HYB, BC(2), BC_TAI, BC(2)]],
    ['READ OUT 6', undef, '', "I\nIII\n", ['', "II\nIV\n"], undef,
     'DO READ OUT #1 + @69 + #2 + @ORFH + #3 + @69 + #4', [],
	[BC_ROU, BC(7), BC(1), BC_WHP, BC(69), BC(2), reg_code('@ORFH'), BC(3), BC_WHP, BC(69), BC(4)]],
    ['READ OUT 7', undef, '', "ABCD\n", ['', "ABCD\n"], undef,
     'DO READ OUT @69 + <ARRAY> + @1 + <ARRAY>', [], [BC_ROU, BC(4), BC_WHP, BC(69), test_str("[_CYNI"), reg_code('@ORFH'), test_str("[_CYNI")]],
    ['READ OUT 8', undef, '', '', ['', "ABCD\n"], undef,
     'DO ,2 <- #6', [], [BC_STO, BC(6), BC_TAI, BC(2)],
     'DO ,2 SUB #1 <- #91', [], [BC_STO, BC(91), BC_SUB, BC(1), BC_TAI, BC(2)],
     'DO ,2 SUB #2 <- #95', [], [BC_STO, BC(95), BC_SUB, BC(2), BC_TAI, BC(2)],
     'DO ,2 SUB #3 <- #67', [], [BC_STO, BC(67), BC_SUB, BC(3), BC_TAI, BC(2)],
     'DO ,2 SUB #3 <- #89', [], [BC_STO, BC(89), BC_SUB, BC(4), BC_TAI, BC(2)],
     'DO ,2 SUB #4 <- #78', [], [BC_STO, BC(78), BC_SUB, BC(5), BC_TAI, BC(2)],
     'DO ,2 SUB #5 <- #73', [], [BC_STO, BC(73), BC_SUB, BC(6), BC_TAI, BC(2)],
     'DO READ OUT @69 + ,2', [], [BC_ROU, BC(2), BC_WHP, BC(69), BC_TAI, BC(2)]],
    ['READ OUT 9', undef, '', '', ['', "Hi\n"], undef,
     'DO ;2 <- #3', [], [BC_STO, BC(3), BC_HYB, BC(2)],
     'DO ;2 SUB #1 <- #29', [], [BC_STO, BC(29), BC_SUB, BC(1), BC_HYB, BC(2)],
     'DO ;2 SUB #2 <- #1118', [], [BC_STO, BC(1118), BC_SUB, BC(2), BC_HYB, BC(2)],
     'DO ;2 SUB #3 <- #92', [], [BC_STO, BC(92), BC_SUB, BC(3), BC_HYB, BC(2)],
     'DO READ OUT @69 + ;2', [], [BC_ROU, BC(2), BC_WHP, BC(69), BC_HYB, BC(2)]],
    ['READ OUT 10', undef, '', '', ['', "Hi\n"], undef,
     'DO %IO <- ?C', [], [BC_STO, test_str('C'), reg_code('%IO')],
     'DO ;2 <- #2', [], [BC_STO, BC(2), BC_HYB, BC(2)],
     'DO ;2 SUB #1 <- #238', [], [BC_STO, BC(238), BC_SUB, BC(1), BC_HYB, BC(2)],
     'DO ;2 SUB #2 <- #124', [], [BC_STO, BC(124), BC_SUB, BC(2), BC_HYB, BC(2)],
     'DO ,2 <- #1', [], [BC_STO, BC(1), BC_TAI, BC(2)],
     'DO ,2 SUB #1 <- #70', [], [BC_STO, BC(70), BC_SUB, BC(1), BC_TAI, BC(2)],
     'DO READ OUT @69 + ;2 + ,2', [], [BC_ROU, BC(3), BC_WHP, BC(69), BC_HYB, BC(2), BC_TAI, BC(2)]],
    ['WRITE IN 1', undef, 'TWO SIX', "XXVI\n", undef, undef,
     'DO WRITE IN .2', [], [BC_WIN, BC(1), BC_SPO, BC(2)],
     'DO READ OUT .2', [], [BC_ROU, BC(1), BC_SPO, BC(2)]],
    ['WRITE IN 2', undef, 'ABCD', "ABCD\n", undef, undef,
     'DO ,2 <- #7', [], [BC_STO, BC(7), BC_TAI, BC(2)],
     'DO WRITE IN ,2', [], [BC_WIN, BC(1), BC_TAI, BC(2)],
     'DO READ OUT ,2', [], [BC_ROU, BC(1), BC_TAI, BC(2)]],
    ['WRITE IN 3', undef, 'TWO SIX', "XXVI\n", undef, undef,
     'DO WRITE IN #2', [], [BC_WIN, BC(1), BC(2)],
     'DO READ OUT #2', [], [BC_ROU, BC(1), BC(2)]],
    ['WRITE IN 4', undef, "Hi\n", "XV\nLXIII\nXV\n", undef, undef,
     'DO ;2 <- #3', [], [BC_STO, BC(3), BC_HYB, BC(2)],
     'DO WRITE IN ;2', [], [BC_WIN, BC(1), BC_HYB, BC(2)],
     'DO READ OUT #65535 ~ ;2 SUB #1', [], [BC_ROU, BC(1), BC_SEL, BC(65535), BC_SUB, BC(1), BC_HYB, BC(2)],
     'DO READ OUT #65535 ~ ;2 SUB #2', [], [BC_ROU, BC(1), BC_SEL, BC(65535), BC_SUB, BC(2), BC_HYB, BC(2)],
     'DO READ OUT #65535 ~ ;2 SUB #3', [], [BC_ROU, BC(1), BC_SEL, BC(65535), BC_SUB, BC(3), BC_HYB, BC(2)]],
    ['WRITE IN 5', undef, "Hi\n", "LXXII\nXXXIII\nCLXI\n", undef, undef,
     'DO %IO <- ?C', [], [BC_STO, test_str('C'), reg_code('%IO')],
     'DO ;2 <- #2', [], [BC_STO, BC(2), BC_HYB, BC(2)],
     'DO ,2 <- #1', [], [BC_STO, BC(1), BC_TAI, BC(2)],
     'DO WRITE IN ;2 + ,2', [], [BC_WIN, BC(2), BC_HYB, BC(2), BC_TAI, BC(2)],
     'DO READ OUT ;2 SUB #1', [], [BC_ROU, BC(1), BC_SUB, BC(1), BC_HYB, BC(2)],
     'DO READ OUT ;2 SUB #2', [], [BC_ROU, BC(1), BC_SUB, BC(2), BC_HYB, BC(2)],
     'DO READ OUT ,2 SUB #1', [], [BC_ROU, BC(1), BC_SUB, BC(1), BC_TAI, BC(2)]],
    ['WRITE IN 6', undef, 'TWO SIX', "XIII\n", ['ONE THREE', "XXVI\n"], undef,
     'DO WRITE IN @68 + .1 + @OWFH + .2', [], [BC_WIN, BC(4), BC_WHP, BC(68), BC_SPO, BC(1), reg_code('@OWFH'), BC_SPO, BC(2)],
     'DO READ OUT .1 + @69 + .2', [], [BC_ROU, BC(3), BC_SPO, BC(1), BC_WHP, BC(69), BC_SPO, BC(2)]],
    ['WRITE IN 7', undef, '', '', ['ABCD', "ABCD\n"], undef,
     'DO ,2 <- #7', [], [BC_STO, BC(7), BC_TAI, BC(2)],
     'DO WRITE IN @68 + ,2', [], [BC_WIN, BC(2), BC_WHP, BC(68), BC_TAI, BC(2)],
     'DO READ OUT @69 + ,2', [], [BC_ROU, BC(2), BC_WHP, BC(69), BC_TAI, BC(2)]],
    ['WRITE IN 8', undef, '', '', ['TWO SIX', "XXVI\n"], undef,
     'DO WRITE IN @68 + #2', [], [BC_WIN, BC(2), BC_WHP, BC(68), BC(2)],
     'DO READ OUT @69 + #2', [], [BC_ROU, BC(2), BC_WHP, BC(69), BC(2)]],
    ['WRITE IN 9', undef, '', '', ["Hi\n", "XV\nLXIII\nXV\n"], undef,
     'DO ;2 <- #3', [], [BC_STO, BC(3), BC_HYB, BC(2)],
     'DO WRITE IN @68 + ;2', [], [BC_WIN, BC(2), BC_WHP, BC(68), BC_HYB, BC(2)],
     'DO READ OUT @69 + #65535 ~ ;2 SUB #1', [], [BC_ROU, BC(2), BC_WHP, BC(69), BC_SEL, BC(65535), BC_SUB, BC(1), BC_HYB, BC(2)],
     'DO READ OUT @69 + #65535 ~ ;2 SUB #2', [], [BC_ROU, BC(2), BC_WHP, BC(69), BC_SEL, BC(65535), BC_SUB, BC(2), BC_HYB, BC(2)],
     'DO READ OUT @69 + #65535 ~ ;2 SUB #3', [], [BC_ROU, BC(2), BC_WHP, BC(69), BC_SEL, BC(65535), BC_SUB, BC(3), BC_HYB, BC(2)]],
    ['WRITE IN 10', undef, '', '', ["Hi\n", "LXXII\nXXXIII\nCLXI\n"], undef,
     'DO %IO <- ?C', [], [BC_STO, test_str('C'), reg_code('%IO')],
     'DO ;2 <- #2', [], [BC_STO, BC(2), BC_HYB, BC(2)],
     'DO ,2 <- #1', [], [BC_STO, BC(1), BC_TAI, BC(2)],
     'DO WRITE IN @68 + ;2 + ,2', [], [BC_WIN, BC(3), BC_WHP, BC(68), BC_HYB, BC(2), BC_TAI, BC(2)],
     'DO READ OUT @69 + ;2 SUB #1', [], [BC_ROU, BC(2), BC_WHP, BC(69), BC_SUB, BC(1), BC_HYB, BC(2)],
     'DO READ OUT @69 + ;2 SUB #2', [], [BC_ROU, BC(2), BC_WHP, BC(69), BC_SUB, BC(2), BC_HYB, BC(2)],
     'DO READ OUT @69 + ,2 SUB #1', [], [BC_ROU, BC(2), BC_WHP, BC(69), BC_SUB, BC(1), BC_TAI, BC(2)]],
    ['NOT', undef, '', "IV\n", undef, undef,
     'DO NOT READ OUT #2', [BC_NOT], [BC_ROU, BC(1), BC(2)],
     'DO READ OUT #4', [], [BC_ROU, BC(1), BC(4)]],
    ['Double Oh Seven 1', undef, '', [10, '', "II\n"], undef, undef,
     'DO %50 READ OUT #2', [BC_DSX, BC(50)], [BC_ROU, BC(1), BC(2)]],
    ['Double Oh Seven 2', undef, '', [10, '', "II\n", "IV\n", "II\nIV\n"], undef, undef,
     'DO %50 READ OUT #2', [BC_DSX, BC(50)], [BC_ROU, BC(1), BC(2)],
     'DO %50 READ OUT #4', [BC_DSX, BC(50)], [BC_ROU, BC(1), BC(4)]],
    ['Double Oh Seven 3', undef, '', [10, '', "II\n", "IV\n", "II\nIV\n"], undef, undef,
     'DO %75 READ OUT #2', [BC_DSX, BC(50)], [BC_ROU, BC(1), BC(2)],
     'DO %25 READ OUT #4', [BC_DSX, BC(50)], [BC_ROU, BC(1), BC(4)]],
    ['REINSTATE LABEL', undef, '', "II\nIV\n", undef, undef,
     'DO REINSTATE (1)', [], [BC_REL, BC(1)],
     '(1) DO NOT READ OUT #2', [BC_LAB, BC(1), BC_NOT], [BC_ROU, BC(1), BC(2)],
     'DO READ OUT #4', [], [BC_ROU, BC(1), BC(4)]],
    ['REINSTATE COMPUTED LABEL', undef, '', "II\nIV\n", undef, undef,
     'DO REINSTATE (2)', [], [BC_REL, BC(2)],
     '.1 <- #2', [], [BC_STO, BC(2), BC_SPO, BC(1)],
     '(.1) DO NOT READ OUT #2', [BC_LAB, BC_SPO, BC(1), BC_NOT], [BC_ROU, BC(1), BC(2)],
     'DO READ OUT #4', [], [BC_ROU, BC(1), BC(4)]],
    ['COMPUTED REINSTATE LABEL', undef, '', "II\nIV\n", undef, undef,
     '.1 <- #2', [], [BC_STO, BC(2), BC_SPO, BC(1)],
     'DO REINSTATE (.1)', [], [BC_REL, BC_SPO, BC(1)],
     '(2) DO NOT READ OUT #2', [BC_LAB, BC(2), BC_NOT], [BC_ROU, BC(1), BC(2)],
     'DO READ OUT #4', [], [BC_ROU, BC(1), BC(4)]],
    ['REINSTATE OVERLOADED LABEL', undef, '', "II\nIV\n", undef, undef,
     'DO REINSTATE (2)', [], [BC_REL, BC(2)],
     '#1 <- #2', [], [BC_STO, BC(2), BC(1)],
     '(1) DO NOT READ OUT #2', [BC_LAB, BC(1), BC_NOT], [BC_ROU, BC(1), BC(2)],
     'DO READ OUT #4', [], [BC_ROU, BC(1), BC(4)]],
    ['OVERLOADED REINSTATE LABEL', undef, '', "II\nIV\n", undef, undef,
     '#1 <- #2', [], [BC_STO, BC(2), BC(1)],
     'DO REINSTATE (1)', [], [BC_REL, BC(1)],
     '(2) DO NOT READ OUT #2', [BC_LAB, BC(2), BC_NOT], [BC_ROU, BC(1), BC(2)],
     'DO READ OUT #4', [], [BC_ROU, BC(1), BC(4)]],
    ['REINSTATE GERUND', undef, '', "II\nIV\n", undef, undef,
     'DO REINSTATE READING OUT', [], [BC_REG, BC(1), BC_ROU],
     '(1) DO NOT READ OUT #2', [BC_LAB, BC(1), BC_NOT], [BC_ROU, BC(1), BC(2)],
     'DO READ OUT #4', [], [BC_ROU, BC(1), BC(4)]],
    ['ABSTAIN FROM LABEL', undef, '', "IV\n", undef, undef,
     'DO ABSTAIN FROM (1)', [], [BC_ABL, BC(1)],
     '(1) DO READ OUT #2', [BC_LAB, BC(1)], [BC_ROU, BC(1), BC(2)],
     'DO READ OUT #4', [], [BC_ROU, BC(1), BC(4)]],
    ['ABSTAIN FROM COMPUTED LABEL', undef, '', "IV\n", undef, undef,
     'DO ABSTAIN FROM (2)', [], [BC_ABL, BC(2)],
     '.1 <- #2', [], [BC_STO, BC(2), BC_SPO, BC(1)],
     '(.1) DO READ OUT #2', [BC_LAB, BC_SPO, BC(1)], [BC_ROU, BC(1), BC(2)],
     'DO READ OUT #4', [], [BC_ROU, BC(1), BC(4)]],
    ['COMPUTED ABSTAIN FROM LABEL', undef, '', "IV\n", undef, undef,
     '.1 <- #2', [], [BC_STO, BC(2), BC_SPO, BC(1)],
     'DO ABSTAIN FROM (.1)', [], [BC_ABL, BC_SPO, BC(1)],
     '(2) DO READ OUT #2', [BC_LAB, BC(2)], [BC_ROU, BC(1), BC(2)],
     'DO READ OUT #4', [], [BC_ROU, BC(1), BC(4)]],
    ['ABSTAIN FROM OVERLOADED LABEL', undef, '', "IV\n", undef, undef,
     'DO ABSTAIN FROM (2)', [], [BC_ABL, BC(2)],
     '#1 <- #2', [], [BC_STO, BC(2), BC(1)],
     '(1) DO READ OUT #2', [BC_LAB, BC(1)], [BC_ROU, BC(1), BC(2)],
     'DO READ OUT #4', [], [BC_ROU, BC(1), BC(4)]],
    ['OVERLOADED ABSTAIN FROM LABEL', undef, '', "IV\n", undef, undef,
     '#1 <- #2', [], [BC_STO, BC(2), BC(1)],
     'DO ABSTAIN FROM (1)', [], [BC_ABL, BC(1)],
     '(2) DO READ OUT #2', [BC_LAB, BC(2)], [BC_ROU, BC(1), BC(2)],
     'DO READ OUT #4', [], [BC_ROU, BC(1), BC(4)]],
    ['ABSTAIN FROM GERUND 1', undef, '', '', undef, undef,
     'DO ABSTAIN FROM READING OUT', [], [BC_ABG, BC(1), BC_ROU],
     'DO READ OUT #2', [], [BC_ROU, BC(1), BC(2)],
     'DO READ OUT #4', [], [BC_ROU, BC(1), BC(4)]],
    ['ABSTAIN FROM GERUND 2', 'sick', '', "II\n", undef, undef,
     'DO ABSTAIN FROM CREATION + EVOLUTION', [], [BC_ABG, BC(2), BC_CRE, BC(0)],
     # extend sick to have another name for unary division which will
     # make the READ OUT statement valid; note that the above ABSTAIN
     # FROM actually REINSTATEs creation...
     'DO NOT CREATE ?UNARY ,D, AS UDV', [BC_NOT],
     [BC_CRE, BC(1), test_str('UNARY'), BC(1), BC(0), BC(1), test_str('D'),
      BC(1), BC(4), BC(1), BC_UDV],
     'DO READ OUT #D8', [], [BC_MSP, BC(0), BC(1), test_str('DO READ OUT #D8')]],
    ['ABSTAIN FROM GERUND 3', 'sick', '', "*000 DO READ OUT #D8\n", undef, 0,
     'DO ABSTAIN FROM EVOLUTION + CREATION', [], [BC_ABG, BC(2), BC(0), BC_CRE],
     # CREATE won't be executed, unlike the previous test
     'DO CREATE ?UNARY ,D, AS UDV', [],
     [BC_CRE, BC(1), test_str('UNARY'), BC(1), BC(0), BC(1), test_str('D'),
      BC(1), BC(4), BC(1), BC_UDV],
     'DO READ OUT #D8', [], [BC_MSP, BC(0), BC(1), test_str('DO READ OUT #D8')]],
    ['ABSTAIN + REINSTATE 1', undef, '', "II\n", undef, undef,
     'DO ABSTAIN FROM READING OUT', [], [BC_ABG, BC(1), BC_ROU],
     'DO REINSTATE (1)', [], [BC_REL, BC(1)],
     '(1) DO READ OUT #2', [BC_LAB, BC(1)], [BC_ROU, BC(1), BC(2)],
     'DO READ OUT #4', [], [BC_ROU, BC(1), BC(4)]],
    ['ABSTAIN + REINSTATE 2', undef, '', "", undef, undef,
     'DO REINSTATE (1)', [], [BC_REL, BC(1)],
     'DO ABSTAIN FROM READING OUT', [], [BC_ABG, BC(1), BC_ROU],
     '(1) DO READ OUT #2', [BC_LAB, BC(1)], [BC_ROU, BC(1), BC(2)],
     'DO READ OUT #4', [], [BC_ROU, BC(1), BC(4)]],
    ['REINSTATE GERUND 1', undef, '', "II\nIV\n", undef, undef,
     'DO REINSTATE READING OUT', [], [BC_REG, BC(1), BC_ROU],
     'DO NOT READ OUT #2', [BC_NOT], [BC_ROU, BC(1), BC(2)],
     'DO NOT READ OUT #4', [BC_NOT], [BC_ROU, BC(1), BC(4)]],
    ['REINSTATE GERUND 2', 'sick', '', "*000 DO READ OUT #D8\n", undef, 0,
     'DO REINSTATE CREATION + EVOLUTION', [], [BC_REG, BC(2), BC_CRE, BC(0)],
     # CREATE won't be executed, so the READ OUT is an error
     'DO CREATE ?UNARY ,D, AS UDV', [],
     [BC_CRE, BC(1), test_str('UNARY'), BC(1), BC(0), BC(1), test_str('D'),
      BC(1), BC(4), BC(1), BC_UDV],
     'DO READ OUT #D8', [], [BC_MSP, BC(0), BC(1), test_str('DO READ OUT #D8')]],
    ['REINSTATE GERUND 3', 'sick', '', "II\n", undef, undef,
     'DO REINSTATE EVOLUTION + CREATION', [], [BC_REG, BC(2), BC(0), BC_CRE],
     # CREATE will be executed, unlike the previous test
     'DO CREATE ?UNARY ,D, AS UDV', [],
     [BC_CRE, BC(1), test_str('UNARY'), BC(1), BC(0), BC(1), test_str('D'),
      BC(1), BC(4), BC(1), BC_UDV],
     'DO READ OUT #D8', [], [BC_MSP, BC(0), BC(1), test_str('DO READ OUT #D8')]],
    ['STASH/RETRIEVE 1', undef, '', "II\n", undef, undef,
     'DO .1 <- #2', [], [BC_STO, BC(2), BC_SPO, BC(1)],
     'DO STASH .1', [], [BC_STA, BC(1), BC_SPO, BC(1)],
     'DO .1 <- #4', [], [BC_STO, BC(4), BC_SPO, BC(1)],
     'DO RETRIEVE .1', [], [BC_RET, BC(1), BC_SPO, BC(1)],
     'DO READ OUT .1', [], [BC_ROU, BC(1), BC_SPO, BC(1)]],
    ['STASH/RETRIEVE 2', undef, '', "A\n", undef, undef,
     'DO ,1 <- #3', [], [BC_STO, BC(3), BC_TAI, BC(1)],
     'DO ,1 SUB #1 <- #91', [], [BC_STO, BC(91), BC_SUB, BC(1), BC_TAI, BC(1)],
     'DO ,1 SUB #2 <- #95', [], [BC_STO, BC(95), BC_SUB, BC(2), BC_TAI, BC(1)],
     'DO ,1 SUB #3 <- #67', [], [BC_STO, BC(67), BC_SUB, BC(3), BC_TAI, BC(1)],
     'DO STASH ,1', [], [BC_STA, BC(1), BC_TAI, BC(1)],
     'DO ,1 SUB #3 <- #68', [], [BC_STO, BC(68), BC_SUB, BC(3), BC_TAI, BC(1)],
     'DO RETRIEVE ,1', [], [BC_RET, BC(1), BC_TAI, BC(1)],
     'DO READ OUT ,1', [], [BC_ROU, BC(1), BC_TAI, BC(1)]],
    ['STASH/RETRIEVE 3', undef, '', "*436 Register ,1 stashed away too well\n", undef, SP_HIDDEN,
     'DO ,1 <- #3', [], [BC_STO, BC(3), BC_TAI, BC(1)],
     'DO ,1 SUB #1 <- #91', [], [BC_STO, BC(91), BC_SUB, BC(1), BC_TAI, BC(1)],
     'DO ,1 SUB #2 <- #95', [], [BC_STO, BC(95), BC_SUB, BC(2), BC_TAI, BC(1)],
     'DO ,1 SUB #3 <- #67', [], [BC_STO, BC(67), BC_SUB, BC(3), BC_TAI, BC(1)],
     'DO STASH ,1', [], [BC_STA, BC(1), BC_TAI, BC(1)],
     'DO ,1 SUB #3 <- #68', [], [BC_STO, BC(68), BC_SUB, BC(3), BC_TAI, BC(1)],
     'DO RETRIEVE ,1', [], [BC_RET, BC(1), BC_TAI, BC(1)],
     'DO RETRIEVE ,1', [], [BC_RET, BC(1), BC_TAI, BC(1)],
     'DO READ OUT ,1', [], [BC_ROU, BC(1), BC_TAI, BC(1)]],
    ['IGNORE 1', undef, '', "II\n", undef, undef,
     'DO .1 <- #2', [], [BC_STO, BC(2), BC_SPO, BC(1)],
     'DO IGNORE .1', [], [BC_IGN, BC(1), BC_SPO, BC(1)],
     'DO .1 <- #4', [], [BC_STO, BC(4), BC_SPO, BC(1)],
     'DO READ OUT .1', [], [BC_ROU, BC(1), BC_SPO, BC(1)]],
    ['IGNORE 2', undef, 'TWO SIX', "II\n", undef, undef,
     'DO .1 <- #2', [], [BC_STO, BC(2), BC_SPO, BC(1)],
     'DO IGNORE .1', [], [BC_IGN, BC(1), BC_SPO, BC(1)],
     'DO WRITE IN .1', [], [BC_WIN, BC(1), BC_SPO, BC(1)],
     'DO READ OUT .1', [], [BC_ROU, BC(1), BC_SPO, BC(1)]],
    ['IGNORE 3', undef, 'TEST', "A\n", undef, undef,
     'DO ,2 <- #3', [], [BC_STO, BC(3), BC_TAI, BC(2)],
     'DO ,2 SUB #1 <- #91', [], [BC_STO, BC(91), BC_SUB, BC(1), BC_TAI, BC(2)],
     'DO ,2 SUB #2 <- #95', [], [BC_STO, BC(95), BC_SUB, BC(2), BC_TAI, BC(2)],
     'DO ,2 SUB #3 <- #67', [], [BC_STO, BC(67), BC_SUB, BC(3), BC_TAI, BC(2)],
     'DO IGNORE ,2', [], [BC_IGN, BC(1), BC_TAI, BC(2)],
     'DO WRITE IN ,2', [], [BC_WIN, BC(1), BC_TAI, BC(2)],
     'DO READ OUT ,2', [], [BC_ROU, BC(1), BC_TAI, BC(2)]],
    ['IGNORE 5', undef, '', "IV\n", undef, undef,
     'DO .1 <- #2', [], [BC_STO, BC(2), BC_SPO, BC(1)],
     'DO STASH .1', [], [BC_STA, BC(1), BC_SPO, BC(1)],
     'DO .1 <- #4', [], [BC_STO, BC(4), BC_SPO, BC(1)],
     'DO IGNORE .1', [], [BC_IGN, BC(1), BC_SPO, BC(1)],
     'DO RETRIEVE .1', [], [BC_RET, BC(1), BC_SPO, BC(1)],
     'DO READ OUT .1', [], [BC_ROU, BC(1), BC_SPO, BC(1)]],
    ['REMEMBER 1', undef, '', "IV\n", undef, undef,
     'DO .1 <- #2', [], [BC_STO, BC(2), BC_SPO, BC(1)],
     'DO IGNORE .1', [], [BC_IGN, BC(1), BC_SPO, BC(1)],
     'DO REMEMBER .1', [], [BC_REM, BC(1), BC_SPO, BC(1)],
     'DO .1 <- #4', [], [BC_STO, BC(4), BC_SPO, BC(1)],
     'DO READ OUT .1', [], [BC_ROU, BC(1), BC_SPO, BC(1)]],
    ['REMEMBER 2', undef, 'TWO SIX', "XXVI\n", undef, undef,
     'DO .1 <- #2', [], [BC_STO, BC(2), BC_SPO, BC(1)],
     'DO IGNORE .1', [], [BC_IGN, BC(1), BC_SPO, BC(1)],
     'DO REMEMBER .1', [], [BC_REM, BC(1), BC_SPO, BC(1)],
     'DO WRITE IN .1', [], [BC_WIN, BC(1), BC_SPO, BC(1)],
     'DO READ OUT .1', [], [BC_ROU, BC(1), BC_SPO, BC(1)]],
    ['REMEMBER 3', undef, 'TEST', "TEST\n", undef, undef,
     'DO ,2 <- #7', [], [BC_STO, BC(7), BC_TAI, BC(2)],
     'DO ,2 SUB #1 <- #91', [], [BC_STO, BC(91), BC_SUB, BC(1), BC_TAI, BC(2)],
     'DO ,2 SUB #2 <- #95', [], [BC_STO, BC(95), BC_SUB, BC(2), BC_TAI, BC(2)],
     'DO ,2 SUB #3 <- #67', [], [BC_STO, BC(67), BC_SUB, BC(3), BC_TAI, BC(2)],
     'DO IGNORE ,2', [], [BC_IGN, BC(1), BC_TAI, BC(2)],
     'DO REMEMBER ,2', [], [BC_REM, BC(1), BC_TAI, BC(2)],
     'DO WRITE IN ,2', [], [BC_WIN, BC(1), BC_TAI, BC(2)],
     'DO READ OUT ,2', [], [BC_ROU, BC(1), BC_TAI, BC(2)]],
    ['REMEMBER 5', undef, '', "II\n", undef, undef,
     'DO .1 <- #2', [], [BC_STO, BC(2), BC_SPO, BC(1)],
     'DO STASH .1', [], [BC_STA, BC(1), BC_SPO, BC(1)],
     'DO .1 <- #4', [], [BC_STO, BC(4), BC_SPO, BC(1)],
     'DO IGNORE .1', [], [BC_IGN, BC(1), BC_SPO, BC(1)],
     'DO REMEMBER .1', [], [BC_REM, BC(1), BC_SPO, BC(1)],
     'DO RETRIEVE .1', [], [BC_RET, BC(1), BC_SPO, BC(1)],
     'DO READ OUT .1', [], [BC_ROU, BC(1), BC_SPO, BC(1)]],
    ['RETRIEVE/IGNORED', undef, '', "II\n", undef, undef,
     'DO .1 <- #2', [], [BC_STO, BC(2), BC_SPO, BC(1)],
     'DO STASH .1', [], [BC_STA, BC(1), BC_SPO, BC(1)],
     'DO IGNORE .1', [], [BC_IGN, BC(1), BC_SPO, BC(1)],
     'DO .1 <- #4', [], [BC_STO, BC(4), BC_SPO, BC(1)],
     'DO RETRIEVE .1', [], [BC_RET, BC(1), BC_SPO, BC(1)],
     'DO READ OUT .1', [], [BC_ROU, BC(1), BC_SPO, BC(1)]],
    ['RETRIEVE/REMEMBERED', undef, '', "III\n", undef, undef,
     'DO .1 <- #3', [], [BC_STO, BC(3), BC_SPO, BC(1)],
     'DO STASH .1', [], [BC_STA, BC(1), BC_SPO, BC(1)],
     'DO .1 <- #2', [], [BC_STO, BC(2), BC_SPO, BC(1)],
     'DO IGNORE .1', [], [BC_IGN, BC(1), BC_SPO, BC(1)],
     'DO STASH .1', [], [BC_STA, BC(1), BC_SPO, BC(1)],
     'DO .1 <- #4', [], [BC_STO, BC(4), BC_SPO, BC(1)],
     'DO RETRIEVE .1', [], [BC_RET, BC(1), BC_SPO, BC(1)],
     'DO REMEMBER .1', [], [BC_REM, BC(1), BC_SPO, BC(1)],
     'DO RETRIEVE .1', [], [BC_RET, BC(1), BC_SPO, BC(1)],
     'DO READ OUT .1', [], [BC_ROU, BC(1), BC_SPO, BC(1)]],
    ['MAKE BELONG 1', undef, '', "IV\n", undef, undef,
     'DO .1 <- #2', [], [BC_STO, BC(2), BC_SPO, BC(1)],
     'DO MAKE .2 BELONG TO .1', [], [BC_MKB, BC_SPO, BC(2), BC_SPO, BC(1)],
     'DO $.2 <- #4', [], [BC_STO, BC(4), BC_BLM, BC(1), BC_SPO, BC(2)],
     'DO READ OUT .1', [], [BC_ROU, BC(1), BC_SPO, BC(1)]],
    ['MAKE BELONG 2', undef, '', "IV\n", undef, undef,
     'DO .1 <- #2', [], [BC_STO, BC(2), BC_SPO, BC(1)],
     'DO MAKE .2 BELONG TO .1', [], [BC_MKB, BC_SPO, BC(2), BC_SPO, BC(1)],
     'DO MAKE .2 BELONG TO .3', [], [BC_MKB, BC_SPO, BC(2), BC_SPO, BC(3)],
     'DO MAKE .2 BELONG TO .4', [], [BC_MKB, BC_SPO, BC(2), BC_SPO, BC(4)],
     'DO 3.2 <- #4', [], [BC_STO, BC(4), BC_BLM, BC(3), BC_SPO, BC(2)],
     'DO READ OUT .1', [], [BC_ROU, BC(1), BC_SPO, BC(1)]],
    ['MAKE BELONG 3', undef, '', "IV\n", undef, undef,
     'DO .1 <- #2', [], [BC_STO, BC(2), BC_SPO, BC(1)],
     'DO MAKE .2 BELONG TO .1', [], [BC_MKB, BC_SPO, BC(2), BC_SPO, BC(1)],
     'DO MAKE .2 BELONG TO .3', [], [BC_MKB, BC_SPO, BC(2), BC_SPO, BC(3)],
     'DO MAKE .2 BELONG TO .4', [], [BC_MKB, BC_SPO, BC(2), BC_SPO, BC(4)],
     'DO MAKE .3 BELONG TO .2', [], [BC_MKB, BC_SPO, BC(3), BC_SPO, BC(2)],
     'DO MAKE .3 BELONG TO .1', [], [BC_MKB, BC_SPO, BC(3), BC_SPO, BC(1)],
     'DO MAKE .4 BELONG TO .3', [], [BC_MKB, BC_SPO, BC(4), BC_SPO, BC(3)],
     'DO $23.4 <- #4', [], [BC_STO, BC(4), BC_BLM, BC(3), BC_BLM, BC(2), BC_BLM, BC(1), BC_SPO, BC(4)],
     'DO READ OUT .1', [], [BC_ROU, BC(1), BC_SPO, BC(1)]],
    ['NO LONGER BELONG 1', undef, '', "IV\n", undef, undef,
     'DO .1 <- #2', [], [BC_STO, BC(2), BC_SPO, BC(1)],
     'DO MAKE .2 BELONG TO .1', [], [BC_MKB, BC_SPO, BC(2), BC_SPO, BC(1)],
     'DO MAKE .2 BELONG TO .3', [], [BC_MKB, BC_SPO, BC(2), BC_SPO, BC(3)],
     'DO MAKE .2 BELONG TO .4', [], [BC_MKB, BC_SPO, BC(2), BC_SPO, BC(4)],
     'DO MAKE .3 BELONG TO .2', [], [BC_MKB, BC_SPO, BC(3), BC_SPO, BC(2)],
     'DO MAKE .3 BELONG TO .1', [], [BC_MKB, BC_SPO, BC(3), BC_SPO, BC(1)],
     'DO MAKE .4 BELONG TO .1', [], [BC_MKB, BC_SPO, BC(4), BC_SPO, BC(1)],
     'DO MAKE .4 BELONG TO .3', [], [BC_MKB, BC_SPO, BC(4), BC_SPO, BC(3)],
     'DO MAKE .4 NO LONGER BELONG TO .1', [], [BC_NLB, BC_SPO, BC(4), BC_SPO, BC(1)],
     'DO MAKE .2 NO LONGER BELONG TO .3', [], [BC_NLB, BC_SPO, BC(2), BC_SPO, BC(3)],
     'DO $22.4 <- #4', [], [BC_STO, BC(4), BC_BLM, BC(2), BC_BLM, BC(2), BC_BLM, BC(1), BC_SPO, BC(4)],
     'DO READ OUT .1', [], [BC_ROU, BC(1), BC_SPO, BC(1)]],
    ['NO LONGER BELONG 2', undef, '', "*511 Register .4 does not belong to anything\n", undef, 511,
     'DO MAKE .4 NO LONGER BELONG TO .1', [], [BC_NLB, BC_SPO, BC(4), BC_SPO, BC(1)]],
    ['NO LONGER BELONG 3', undef, '', "*512 Register .2 does not belong to register .2\n", undef, 512,
     'DO MAKE .2 BELONG TO .1', [], [BC_MKB, BC_SPO, BC(2), BC_SPO, BC(1)],
     'DO MAKE .2 BELONG TO .3', [], [BC_MKB, BC_SPO, BC(2), BC_SPO, BC(3)],
     'DO MAKE .2 NO LONGER BELONG TO .2', [], [BC_NLB, BC_SPO, BC(2), BC_SPO, BC(2)]],
    ['COME FROM LABEL', undef, '', "X\nV\n", undef, undef,
     '(69) DO .1 <- #1', [BC_LAB, BC(69)], [BC_STO, BC(1), BC_SPO, BC(1)],
     'DO .1 <- #2', [], [BC_STO, BC(2), BC_SPO, BC(1)],
     'DO COME FROM (70)', [], [BC_CFL, BC(70)],
     'DO READ OUT .1', [], [BC_ROU, BC(1), BC_SPO, BC(1)],
     'DO GIVE UP', [], [BC_GUP],
     'DO COME FROM (69)', [], [BC_CFL, BC(69)],
     'DO READ OUT #10', [], [BC_ROU, BC(1), BC(10)],
     '(70) DO .1 <- #5', [BC_LAB, BC(70)], [BC_STO, BC(5), BC_SPO, BC(1)]],
    ['COMPUTED COME FROM LABEL', undef, '', "X\nV\n", undef, undef,
     '(69) DO .1 <- #69', [BC_LAB, BC(69)], [BC_STO, BC(69), BC_SPO, BC(1)],
     'DO .1 <- #2', [], [BC_STO, BC(2), BC_SPO, BC(1)],
     'DO COME FROM (70)', [], [BC_CFL, BC(70)],
     'DO READ OUT .1', [], [BC_ROU, BC(1), BC_SPO, BC(1)],
     'DO GIVE UP', [], [BC_GUP],
     'DO COME FROM (.1)', [], [BC_CFL, BC_SPO, BC(1)],
     'DO READ OUT #10', [], [BC_ROU, BC(1), BC(10)],
     '(70) DO .1 <- #5', [BC_LAB, BC(70)], [BC_STO, BC(5), BC_SPO, BC(1)]],
    ['COME FROM COMPUTED LABEL', undef, '', "X\nV\n", undef, undef,
     '(.1) DO .1 <- #69', [BC_LAB, BC_SPO, BC(1)], [BC_STO, BC(69), BC_SPO, BC(1)],
     'DO .1 <- #2', [], [BC_STO, BC(2), BC_SPO, BC(1)],
     'DO COME FROM (70)', [], [BC_CFL, BC(70)],
     'DO READ OUT .1', [], [BC_ROU, BC(1), BC_SPO, BC(1)],
     'DO GIVE UP', [], [BC_GUP],
     'DO COME FROM (69)', [], [BC_CFL, BC(69)],
     'DO READ OUT #10', [], [BC_ROU, BC(1), BC(10)],
     '(70) DO .1 <- #5', [BC_LAB, BC(70)], [BC_STO, BC(5), BC_SPO, BC(1)]],
    ['COME FROM OVERLOADED LABEL', undef, '', "X\nV\n", undef, undef,
     '(1) DO #1 <- #69', [BC_LAB, BC(1)], [BC_STO, BC(69), BC(1)],
     'DO #1 <- #2', [], [BC_STO, BC(2), BC(1)],
     'DO COME FROM (70)', [], [BC_CFL, BC(70)],
     'DO READ OUT #1', [], [BC_ROU, BC(1), BC(1)],
     'DO GIVE UP', [], [BC_GUP],
     'DO COME FROM (69)', [], [BC_CFL, BC(69)],
     'DO READ OUT #10', [], [BC_ROU, BC(1), BC(10)],
     '(70) DO #1 <- #5', [BC_LAB, BC(70)], [BC_STO, BC(5), BC(1)]],
    ['OVERLOADED COME FROM LABEL', undef, '', "X\nV\n", undef, undef,
     '(69) DO #1 <- #69', [BC_LAB, BC(69)], [BC_STO, BC(69), BC(1)],
     'DO #1 <- #2', [], [BC_STO, BC(2), BC(1)],
     'DO COME FROM (70)', [], [BC_CFL, BC(70)],
     'DO READ OUT #1', [], [BC_ROU, BC(1), BC(1)],
     'DO GIVE UP', [], [BC_GUP],
     'DO COME FROM (1)', [], [BC_CFL, BC(1)],
     'DO READ OUT #10', [], [BC_ROU, BC(1), BC(10)],
     '(70) DO #1 <- #5', [BC_LAB, BC(70)], [BC_STO, BC(5), BC(1)]],
    ['COME FROM GERUND', undef, '', "X\nV\n", undef, undef,
     'DO %CF <- #2', [], [BC_STO, BC(2), reg_code('%CF')],
     'DO ABSTAIN FROM (99)', [], [BC_ABL, BC(99)],
     'DO COME FROM (70)', [], [BC_CFL, BC(70)],
     'DO READ OUT .1', [], [BC_ROU, BC(1), BC_SPO, BC(1)],
     'DO GIVE UP', [], [BC_GUP],
     'DO COME FROM ABSTAINING', [], [BC_CFG, BC(2), BC_ABL, BC_ABG],
     'DO READ OUT #10', [], [BC_ROU, BC(1), BC(10)],
     '(70) DO .1 <- #5', [BC_LAB, BC(70)], [BC_STO, BC(5), BC_SPO, BC(1)]],
    ['%50 COME FROM LABEL', undef, '', [10, "X\nV\n", "II\n"], undef, undef,
     '(69) DO .1 <- #1', [BC_LAB, BC(69)], [BC_STO, BC(1), BC_SPO, BC(1)],
     'DO .1 <- #2', [], [BC_STO, BC(2), BC_SPO, BC(1)],
     'DO COME FROM (70)', [], [BC_CFL, BC(70)],
     'DO READ OUT .1', [], [BC_ROU, BC(1), BC_SPO, BC(1)],
     'DO GIVE UP', [], [BC_GUP],
     'DO %50 COME FROM (69)', [BC_DSX, BC(50)], [BC_CFL, BC(69)],
     'DO READ OUT #10', [], [BC_ROU, BC(1), BC(10)],
     '(70) DO .1 <- #5', [BC_LAB, BC(70)], [BC_STO, BC(5), BC_SPO, BC(1)]],
    ['NOT COME FROM LABEL', undef, '', "II\n", undef, undef,
     '(69) DO .1 <- #1', [BC_LAB, BC(69)], [BC_STO, BC(1), BC_SPO, BC(1)],
     'DO .1 <- #2', [], [BC_STO, BC(2), BC_SPO, BC(1)],
     'DO COME FROM (70)', [], [BC_CFL, BC(70)],
     'DO READ OUT .1', [], [BC_ROU, BC(1), BC_SPO, BC(1)],
     'DO GIVE UP', [], [BC_GUP],
     'DO NOT COME FROM (69)', [BC_NOT], [BC_CFL, BC(69)],
     'DO READ OUT #10', [], [BC_ROU, BC(1), BC(10)],
     '(70) DO .1 <- #5', [BC_LAB, BC(70)], [BC_STO, BC(5), BC_SPO, BC(1)]],
    ['ABSTAINED COME FROM LABEL', undef, '', "II\n", undef, undef,
     'DO ABSTAIN FROM COMING FROM', [], [BC_ABG, BC(2), BC_CFL, BC_CFG],
     '(69) DO .1 <- #1', [BC_LAB, BC(69)], [BC_STO, BC(1), BC_SPO, BC(1)],
     'DO .1 <- #2', [], [BC_STO, BC(2), BC_SPO, BC(1)],
     'DO COME FROM (70)', [], [BC_CFL, BC(70)],
     'DO READ OUT .1', [], [BC_ROU, BC(1), BC_SPO, BC(1)],
     'DO GIVE UP', [], [BC_GUP],
     'DO COME FROM (69)', [], [BC_CFL, BC(69)],
     'DO READ OUT #10', [], [BC_ROU, BC(1), BC(10)],
     '(70) DO .1 <- #5', [BC_LAB, BC(70)], [BC_STO, BC(5), BC_SPO, BC(1)]],
    ['REINSTATED NOT COME FROM LABEL', undef, '', "X\nV\n", undef, undef,
     'DO REINSTATE COMING FROM', [], [BC_REG, BC(2), BC_CFL, BC_CFG],
     '(69) DO .1 <- #1', [BC_LAB, BC(69)], [BC_STO, BC(1), BC_SPO, BC(1)],
     'DO .1 <- #2', [], [BC_STO, BC(2), BC_SPO, BC(1)],
     'DO COME FROM (70)', [], [BC_CFL, BC(70)],
     'DO READ OUT .1', [], [BC_ROU, BC(1), BC_SPO, BC(1)],
     'DO GIVE UP', [], [BC_GUP],
     'DO NOT COME FROM (69)', [BC_NOT], [BC_CFL, BC(69)],
     'DO READ OUT #10', [], [BC_ROU, BC(1), BC(10)],
     '(70) DO .1 <- #5', [BC_LAB, BC(70)], [BC_STO, BC(5), BC_SPO, BC(1)]],
    ['MULTIPLE COME FROM - UNTHREADED', undef, '', "*555 Multiple \"COME FROM\" (69)\n", undef, 555,
     '(69) DO .1 <- #2', [BC_LAB, BC(69)], [BC_STO, BC(2), BC_SPO, BC(1)],
     'DO GIVE UP', [], [BC_GUP],
     'DO COME FROM (69)', [], [BC_CFL, BC(69)],
     'DO READ OUT .1', [], [BC_ROU, BC(1), BC_SPO, BC(1)],
     'DO GIVE UP', [], [BC_GUP],
     'DO COME FROM (69)', [], [BC_CFL, BC(69)],
     "DO READ OUT .\xa51", [], [BC_ROU, BC(1), BC_SWB, BC_SPO, BC(1)],
     'DO GIVE UP', [], [BC_GUP],
     'DO COME FROM (69)', [], [BC_CFL, BC(69)],
     'DO READ OUT #10', [], [BC_ROU, BC(1), BC(10)]],
    ['MULTIPLE COME FROM - THREADED', undef, '', [-1, "II\n", "III\n", "X\n"], undef, undef,
     'DO %CF <- #1', [], [BC_STO, BC(1), reg_code('%CF')],
     '(69) DO .1 <- #2', [BC_LAB, BC(69)], [BC_STO, BC(2), BC_SPO, BC(1)],
     'DO GIVE UP', [], [BC_GUP],
     'DO COME FROM (69)', [], [BC_CFL, BC(69)],
     'DO READ OUT .1', [], [BC_ROU, BC(1), BC_SPO, BC(1)],
     'DO GIVE UP', [], [BC_GUP],
     'DO COME FROM (69)', [], [BC_CFL, BC(69)],
     "DO READ OUT .\xa51", [], [BC_ROU, BC(1), BC_SWB, BC_SPO, BC(1)],
     'DO GIVE UP', [], [BC_GUP],
     'DO COME FROM (69)', [], [BC_CFL, BC(69)],
     'DO READ OUT #10', [], [BC_ROU, BC(1), BC(10)]],
    ['NEXT', undef, '', "I\n", undef, undef,
     'DO .1 <- #1', [], [BC_STO, BC(1), BC_SPO, BC(1)],
     'DO (69) NEXT', [], [BC_NXT, BC(69)],
     'DO READ OUT #10', [], [BC_ROU, BC(1), BC(10)],
     'DO GIVE UP', [], [BC_GUP],
     '(60) DO READ OUT .1', [BC_LAB, BC(69)], [BC_ROU, BC(1), BC_SPO, BC(1)]],
    ['RESUME 1', undef, '', "I\nX\n", undef, undef,
     'DO .1 <- #1', [], [BC_STO, BC(1), BC_SPO, BC(1)],
     'DO (69) NEXT', [], [BC_NXT, BC(69)],
     'DO READ OUT #10', [], [BC_ROU, BC(1), BC(10)],
     'DO GIVE UP', [], [BC_GUP],
     '(69) DO READ OUT .1', [BC_LAB, BC(69)], [BC_ROU, BC(1), BC_SPO, BC(1)],
     'DO RESUME #1', [], [BC_RES, BC(1)]],
    ['RESUME 2', undef, '', "I\n*632 Program terminated via RESUME\n", undef, 632,
     'DO .1 <- #1', [], [BC_STO, BC(1), BC_SPO, BC(1)],
     'DO (69) NEXT', [], [BC_NXT, BC(69)],
     'DO READ OUT #10', [], [BC_ROU, BC(1), BC(10)],
     'DO GIVE UP', [], [BC_GUP],
     '(69) DO READ OUT .1', [BC_LAB, BC(69)], [BC_ROU, BC(1), BC_SPO, BC(1)],
     'DO RESUME #2', [], [BC_RES, BC(2)]],
    ['RESUME 3', undef, '', "I\n*621 Pointless RESUME\n", undef, 621,
     'DO .1 <- #1', [], [BC_STO, BC(1), BC_SPO, BC(1)],
     'DO (69) NEXT', [], [BC_NXT, BC(69)],
     'DO READ OUT #10', [], [BC_ROU, BC(1), BC(10)],
     'DO GIVE UP', [], [BC_GUP],
     '(69) DO READ OUT .1', [BC_LAB, BC(69)], [BC_ROU, BC(1), BC_SPO, BC(1)],
     'DO RESUME #0', [], [BC_RES, BC(0)]],
    ['RESUME 4', undef, '', "I\nV\n", undef, undef,
     'DO .1 <- #1', [], [BC_STO, BC(1), BC_SPO, BC(1)],
     '(68) DO (69) NEXT', [BC_LAB, BC(68)], [BC_NXT, BC(69)],
     'DO READ OUT #10', [], [BC_ROU, BC(1), BC(10)],
     'DO GIVE UP', [], [BC_GUP],
     'DO COME FROM (68)', [], [BC_CFL, BC(68)],
     'DO READ OUT #5', [], [BC_ROU, BC(1), BC(5)],
     'DO GIVE UP', [], [BC_GUP],
     '(69) DO READ OUT .1', [BC_LAB, BC(69)], [BC_ROU, BC(1), BC_SPO, BC(1)],
     'DO RESUME #1', [], [BC_RES, BC(1)]],
    ['FORGET 1', undef, '', "I\n*632 Program terminated via RESUME\n", undef, 632,
     'DO .1 <- #1', [], [BC_STO, BC(1), BC_SPO, BC(1)],
     'DO (69) NEXT', [], [BC_NXT, BC(69)],
     'DO READ OUT #10', [], [BC_ROU, BC(1), BC(10)],
     'DO GIVE UP', [], [BC_GUP],
     '(69) DO READ OUT .1', [BC_LAB, BC(69)], [BC_ROU, BC(1), BC_SPO, BC(1)],
     'DO FORGET #1', [], [BC_FOR, BC(1)],
     'DO RESUME #1', [], [BC_RES, BC(1)]],
    ['FORGET 2', undef, '', "XX\nX\n", undef, undef,
     'DO .1 <- #1', [], [BC_STO, BC(1), BC_SPO, BC(1)],
     'DO (69) NEXT', [], [BC_NXT, BC(69)],
     'DO READ OUT #10', [], [BC_ROU, BC(1), BC(10)],
     'DO GIVE UP', [], [BC_GUP],
     '(69) DO (70) NEXT', [BC_LAB, BC(69)], [BC_NXT, BC(70)],
     'DO GIVE UP', [], [BC_GUP],
     '(70) DO READ OUT #20', [BC_LAB, BC(70)], [BC_ROU, BC(1), BC(20)],
     'DO FORGET #1', [], [BC_FOR, BC(1)],
     'DO RESUME #1', [], [BC_RES, BC(1)]],
    ['NEXT FROM LABEL', undef, '', "X\nII\n", undef, undef,
     '(69) DO .1 <- #1', [BC_LAB, BC(69)], [BC_STO, BC(1), BC_SPO, BC(1)],
     'DO .1 <- #2', [], [BC_STO, BC(2), BC_SPO, BC(1)],
     'DO READ OUT .1', [], [BC_ROU, BC(1), BC_SPO, BC(1)],
     'DO GIVE UP', [], [BC_GUP],
     'DO NEXT FROM (69)', [], [BC_NXL, BC(69)],
     'DO READ OUT #10', [], [BC_ROU, BC(1), BC(10)],
     'DO RESUME .1', [], [BC_RES, BC_SPO, BC(1)]],
    ['COMPUTED NEXT FROM LABEL', undef, '', "X\nII\n", undef, undef,
     '(69) DO .1 <- #69', [BC_LAB, BC(69)], [BC_STO, BC(69), BC_SPO, BC(1)],
     'DO .1 <- #2', [], [BC_STO, BC(2), BC_SPO, BC(1)],
     'DO READ OUT .1', [], [BC_ROU, BC(1), BC_SPO, BC(1)],
     'DO GIVE UP', [], [BC_GUP],
     'DO NEXT FROM (.1)', [], [BC_NXL, BC_SPO, BC(1)],
     'DO READ OUT #10', [], [BC_ROU, BC(1), BC(10)],
     'DO RESUME #1', [], [BC_RES, BC(1)]],
    ['NEXT FROM COMPUTED LABEL', undef, '', "X\nV\n", undef, undef,
     '(.1) DO .1 <- #69', [BC_LAB, BC_SPO, BC(1)], [BC_STO, BC(69), BC_SPO, BC(1)],
     'DO READ OUT .1', [], [BC_ROU, BC(1), BC_SPO, BC(1)],
     'DO GIVE UP', [], [BC_GUP],
     'DO NEXT FROM (69)', [], [BC_NXL, BC(69)],
     'DO READ OUT #10', [], [BC_ROU, BC(1), BC(10)],
     'DO .1 <- #5', [], [BC_STO, BC(5), BC_SPO, BC(1)],
     'DO RESUME #1', [], [BC_RES, BC(1)]],
    ['OVERLOADED NEXT FROM LABEL', undef, '', "X\nIII\n", undef, undef,
     'DO #2 <- #1', [], [BC_STO, BC(1), BC(2)],
     '(69) DO #1 <- #69', [BC_LAB, BC(69)], [BC_STO, BC(69), BC(1)],
     'DO READ OUT #3', [], [BC_ROU, BC(1), BC(3)],
     'DO GIVE UP', [], [BC_GUP],
     'DO NEXT FROM (1)', [], [BC_NXL, BC(1)],
     'DO READ OUT #10', [], [BC_ROU, BC(1), BC(10)],
     'DO RESUME #2', [], [BC_RES, BC(2)]],
    ['NEXT FROM OVERLOADED LABEL', undef, '', "X\nV\n", undef, undef,
     'DO #2 <- #1', [], [BC_STO, BC(1), BC(2)],
     '(1) DO #1 <- #69', [BC_LAB, BC(1)], [BC_STO, BC(69), BC(1)],
     'DO READ OUT #5', [], [BC_ROU, BC(1), BC(5)],
     'DO GIVE UP', [], [BC_GUP],
     'DO NEXT FROM (69)', [], [BC_NXL, BC(69)],
     'DO READ OUT #10', [], [BC_ROU, BC(1), BC(10)],
     'DO #1 <- #5', [], [BC_STO, BC(5), BC_SPO, BC(1)],
     'DO RESUME #2', [], [BC_RES, BC(2)]],
    ['NEXT FROM GERUND', undef, '', "X\nV\n", undef, undef,
     'DO %CF <- #2', [], [BC_STO, BC(2), reg_code('%CF')],
     'DO ABSTAIN FROM (99)', [], [BC_ABL, BC(99)],
     'DO READ OUT .1', [], [BC_ROU, BC(1), BC_SPO, BC(1)],
     'DO GIVE UP', [], [BC_GUP],
     'DO NEXT FROM ABSTAINING', [], [BC_NXG, BC(2), BC_ABL, BC_ABG],
     'DO READ OUT #10', [], [BC_ROU, BC(1), BC(10)],
     'DO .1 <- #5', [], [BC_STO, BC(5), BC_SPO, BC(1)],
     'DO RESUME #1', [], [BC_RES, BC(1)]],
    ['STUDY 1', undef, '', "M\nMM\n", undef, undef,
     'DO STUDY #1 AT (1000) IN CLASS @2', [], [BC_STU, BC(1), BC(1000), BC_WHP, BC(2)],
     'DO STUDY #2 AT (2000) IN CLASS @2', [], [BC_STU, BC(2), BC(2000), BC_WHP, BC(2)],
     'DO READ OUT @2 SUB #1', [], [BC_ROU, BC(1), BC_SUB, BC(1), BC_WHP, BC(2)],
     'DO READ OUT @2 SUB #2', [], [BC_ROU, BC(1), BC_SUB, BC(2), BC_WHP, BC(2)]],
    ['STUDY 2', undef, '', "*999 Lecture at 100 is too early\n", undef, 999,
     'DO STUDY #1 AT (100) IN CLASS @2', [], [BC_STU, BC(1), BC(100), BC_WHP, BC(2)]],
    ['ENROL 1', undef, '', "M\nMM\n", undef, undef,
     'DO STUDY #1 AT (1000) IN CLASS @2', [], [BC_STU, BC(1), BC(1000), BC_WHP, BC(2)],
     'DO STUDY #2 AT (2000) IN CLASS @2', [], [BC_STU, BC(2), BC(2000), BC_WHP, BC(2)],
     'DO ENROL .1 TO LEARN #1', [], [BC_ENR, BC(1), BC(1), BC_SPO, BC(1)],
     'DO ENROL .2 TO LEARN #2', [], [BC_ENR, BC(1), BC(2), BC_SPO, BC(2)],
     'DO ENROL .3 TO LEARN #1 + #2', [], [BC_ENR, BC(2), BC(1), BC(2), BC_SPO, BC(3)],
     'DO READ OUT @2 SUB #1', [], [BC_ROU, BC(1), BC_SUB, BC(1), BC_WHP, BC(2)],
     'DO READ OUT @2 SUB #2', [], [BC_ROU, BC(1), BC_SUB, BC(2), BC_WHP, BC(2)]],
    ['ENROL 2', undef, '', "*799 No class teaches subjects #1 + #2\n", undef, 799,
     'DO STUDY #1 AT (1000) IN CLASS @1', [], [BC_STU, BC(1), BC(1000), BC_WHP, BC(1)],
     'DO STUDY #2 AT (2000) IN CLASS @2', [], [BC_STU, BC(2), BC(2000), BC_WHP, BC(2)],
     'DO ENROL .1 TO LEARN #1 + #2', [], [BC_ENR, BC(2), BC(1), BC(2), BC_SPO, BC(1)]],
    ['ENROL 3', undef, '', "*603 Class war between \@1 and \@2\n", undef, 603,
     'DO STUDY #1 AT (1000) IN CLASS @1', [], [BC_STU, BC(1), BC(1000), BC_WHP, BC(1)],
     'DO STUDY #1 AT (2000) IN CLASS @2', [], [BC_STU, BC(1), BC(2000), BC_WHP, BC(2)],
     'DO ENROL .1 TO LEARN #1', [], [BC_ENR, BC(1), BC(1), BC_SPO, BC(1)]],
    ['LEARNS 1', undef, '', "M\n", undef, undef,
     'DO STUDY #1 AT (1000) IN CLASS @1', [], [BC_STU, BC(1), BC(1000), BC_WHP, BC(1)],
     'DO ENROL .1 TO LEARN #1', [], [BC_ENR, BC(1), BC(1), BC_SPO, BC(1)],
     'DO .1 LEARNS #1', [], [BC_LEA, BC(1), BC_SPO, BC(1)],
     'DO READ OUT @2 SUB #2', [], [BC_ROU, BC(1), BC_SUB, BC(2), BC_WHP, BC(2)],
     '(1000) DO READ OUT @1 SUB #1', [BC_LAB, BC(1000)], [BC_ROU, BC(1), BC_SUB, BC(1), BC_WHP, BC(1)]],
    ['LEARNS 2', undef, '', "*822 Register .1 is not a student\n", undef, 822,
     'DO .1 LEARNS #4', [], [BC_LEA, BC(1), BC_SPO, BC(1)]],
    ['LEARNS 3', undef, '', "*823 Subject #4 is not in .1's curriculum\n", undef, 823,
     'DO STUDY #2 AT (3000) IN CLASS @1', [], [BC_STU, BC(2), BC(3000), BC_WHP, BC(1)],
     'DO STUDY #3 AT (4000) IN CLASS @2', [], [BC_STU, BC(3), BC(4000), BC_WHP, BC(2)],
     'DO ENROL .1 TO LEARN #2', [], [BC_ENR, BC(1), BC(2), BC_SPO, BC(1)],
     'DO ENROL .1 TO LEARN #3', [], [BC_ENR, BC(1), BC(3), BC_SPO, BC(1)],
     'DO .1 LEARNS #4', [], [BC_LEA, BC(4), BC_SPO, BC(1)]],
    ['LEARNS 4', undef, '', "*603 Class war between \@1 and \@2\n", undef, 603,
     'DO STUDY #1 AT (1000) IN CLASS @1', [], [BC_STU, BC(1), BC(1000), BC_WHP, BC(1)],
     'DO STUDY #1 AT (2000) IN CLASS @2', [], [BC_STU, BC(1), BC(2000), BC_WHP, BC(2)],
     'DO STUDY #2 AT (3000) IN CLASS @1', [], [BC_STU, BC(2), BC(3000), BC_WHP, BC(1)],
     'DO STUDY #3 AT (4000) IN CLASS @2', [], [BC_STU, BC(3), BC(4000), BC_WHP, BC(2)],
     'DO ENROL .1 TO LEARN #2', [], [BC_ENR, BC(1), BC(2), BC_SPO, BC(1)],
     'DO ENROL .1 TO LEARN #3', [], [BC_ENR, BC(1), BC(3), BC_SPO, BC(1)],
     'DO .1 LEARNS #1', [], [BC_LEA, BC(1), BC_SPO, BC(1)]],
    ['FINISH LECTURE 1', undef, '', "M\nV\n", undef, undef,
     'DO STUDY #1 AT (1000) IN CLASS @1', [], [BC_STU, BC(1), BC(1000), BC_WHP, BC(1)],
     'DO ENROL .1 TO LEARN #1', [], [BC_ENR, BC(1), BC(1), BC_SPO, BC(1)],
     'DO .1 LEARNS #1', [], [BC_LEA, BC(1), BC_SPO, BC(1)],
     'DO READ OUT .1', [], [BC_ROU, BC(1), BC_SPO, BC(1)],
     'DO GIVE UP', [], [BC_GUP],
     '(1000) DO READ OUT @1 SUB #1', [BC_LAB, BC(1000)], [BC_ROU, BC(1), BC_SUB, BC(1), BC_WHP, BC(1)],
     'DO $@1 <- #5', [], [BC_STO, BC(5), BC_BLM, BC(1), BC_WHP, BC(1)],
     'DO FINISH LECTURE', [], [BC_FIN]],
    ['FINISH LECTURE 2', undef, '', "M\nX\n", undef, undef,
     'DO STUDY #1 AT (1000) IN CLASS @1', [], [BC_STU, BC(1), BC(1000), BC_WHP, BC(1)],
     'DO ENROL .1 TO LEARN #1', [], [BC_ENR, BC(1), BC(1), BC_SPO, BC(1)],
     '(69) DO .1 LEARNS #1', [BC_LAB, BC(69)], [BC_LEA, BC(1), BC_SPO, BC(1)],
     'DO READ OUT .1', [], [BC_ROU, BC(1), BC_SPO, BC(1)],
     'DO GIVE UP', [], [BC_GUP],
     'DO COME FROM (69)', [], [BC_CFL, BC(69)],
     'DO READ OUT #10', [], [BC_ROU, BC(1), BC(10)],
     'DO GIVE UP', [], [BC_GUP],
     '(1000) DO READ OUT @1 SUB #1', [BC_LAB, BC(1000)], [BC_ROU, BC(1), BC_SUB, BC(1), BC_WHP, BC(1)],
     'DO $@1 <- #5', [], [BC_STO, BC(5), BC_BLM, BC(1), BC_WHP, BC(1)],
     'DO FINISH LECTURE', [], [BC_FIN]],
    ['FINISH LECTURE 3', undef, '', "*699 Not in a lecture\n", undef, 699,
     'DO FINISH LECTURE', [], [BC_FIN]],
    ['GRADUATES', undef, '', "*822 Register .1 is not a student\n", undef, 822,
     'DO STUDY #1 AT (1000) IN CLASS @1', [], [BC_STU, BC(1), BC(1000), BC_WHP, BC(1)],
     'DO ENROL .1 TO LEARN #1', [], [BC_ENR, BC(1), BC(1), BC_SPO, BC(1)],
     'DO .1 GRADUATES', [], [BC_GRA, BC_SPO, BC(1)],
     'DO .1 LEARNS #4', [], [BC_LEA, BC(1), BC_SPO, BC(1)]],
    ['SWAP 1', undef, '', "XX\nX\n", undef, undef,
     'DO .1 <- #1', [], [BC_STO, BC(1), BC_SPO, BC(1)],
     'DO SWAP RESUME EXPRESSION AND FORGET EXPRESSION', [], [BC_SWA, BC_RES, BC_FOR],
     'DO (69) NEXT', [], [BC_NXT, BC(69)],
     'DO READ OUT #10', [], [BC_ROU, BC(1), BC(10)],
     'DO GIVE UP', [], [BC_GUP],
     '(69) DO (70) NEXT', [BC_LAB, BC(69)], [BC_NXT, BC(70)],
     'DO GIVE UP', [], [BC_GUP],
     '(70) DO READ OUT #20', [BC_LAB, BC(70)], [BC_ROU, BC(1), BC(20)],
     'DO RESUME #1', [], [BC_RES, BC(1)],  # really executed as FORGET
     'DO FORGET #1', [], [BC_FOR, BC(1)]], # really executed as RESUME
    ['SWAP 2', undef, '', "XX\nX\n", undef, undef,
     'DO .1 <- #1', [], [BC_STO, BC(1), BC_SPO, BC(1)],
     'DO SWAP SWAP STATEMENT AND STATEMENT AND CONVERT STATEMENT TO STATEMENT', [], [BC_SWA, BC_SWA, BC_CON],
     'DO CONVERT RESUME EXPRESSION TO FORGET EXPRESSION', [], [BC_CON, BC_RES, BC_FOR],
     'DO (69) NEXT', [], [BC_NXT, BC(69)],
     'DO READ OUT #10', [], [BC_ROU, BC(1), BC(10)],
     'DO GIVE UP', [], [BC_GUP],
     '(69) DO (70) NEXT', [BC_LAB, BC(69)], [BC_NXT, BC(70)],
     'DO GIVE UP', [], [BC_GUP],
     '(70) DO READ OUT #20', [BC_LAB, BC(70)], [BC_ROU, BC(1), BC(20)],
     'DO RESUME #1', [], [BC_RES, BC(1)],  # really executed as FORGET
     'DO FORGET #1', [], [BC_FOR, BC(1)]], # really executed as RESUME
    ['SWAP 3', undef, '', "*445 Cannot swap RES and FIN\n", undef, 445,
     'DO SWAP RESUME EXPRESSION AND FINISH LECTURE', [], [BC_SWA, BC_RES, BC_FIN]],
    ['SWAP 4', undef, '', "III\n", undef, undef,
     'DO SWAP COME FROM LABEL AND ABSTAIN FROM LABEL', [], [BC_SWA, BC_CFL, BC_ABL],
     'DO COME FROM (1)', [], [BC_CFL, BC(1)],
     '(1) DO READ OUT #1', [BC_LAB, BC(1)], [BC_ROU, BC(1), BC(1)],
     'DO READ OUT #2', [], [BC_ROU, BC(1), BC(2)],
     'DO ABSTAIN FROM (1)', [], [BC_ABL, BC(1)],
     'DO READ OUT #3', [], [BC_ROU, BC(1), BC(3)]],
    ['CONVERT 1', undef, '', "XX\n", undef, undef,
     'DO .1 <- #1', [], [BC_STO, BC(1), BC_SPO, BC(1)],
     'DO CONVERT FORGET EXPRESSION TO RESUME EXPRESSION', [], [BC_CON, BC_FOR, BC_RES],
     'DO (69) NEXT', [], [BC_NXT, BC(69)],
     'DO READ OUT #10', [], [BC_ROU, BC(1), BC(10)],
     'DO GIVE UP', [], [BC_GUP],
     '(69) DO (70) NEXT', [BC_LAB, BC(69)], [BC_NXT, BC(70)],
     'DO GIVE UP', [], [BC_GUP],
     '(70) DO READ OUT #20', [BC_LAB, BC(70)], [BC_ROU, BC(1), BC(20)],
     'DO FORGET #1', [], [BC_FOR, BC(1)]], # really executed as RESUME
    ['CONVERT 2', undef, '', "XX\n", undef, undef,
     'DO .1 <- #1', [], [BC_STO, BC(1), BC_SPO, BC(1)],
     'DO SWAP SWAP STATEMENT AND STATEMENT AND CONVERT STATEMENT TO STATEMENT', [], [BC_SWA, BC_SWA, BC_CON],
     'DO SWAP FORGET EXPRESSION AND RESUME EXPRESSION', [], [BC_SWA, BC_FOR, BC_RES],
     'DO (69) NEXT', [], [BC_NXT, BC(69)],
     'DO READ OUT #10', [], [BC_ROU, BC(1), BC(10)],
     'DO GIVE UP', [], [BC_GUP],
     '(69) DO (70) NEXT', [BC_LAB, BC(69)], [BC_NXT, BC(70)],
     'DO GIVE UP', [], [BC_GUP],
     '(70) DO READ OUT #20', [BC_LAB, BC(70)], [BC_ROU, BC(1), BC(20)],
     'DO FORGET #1', [], [BC_FOR, BC(1)]], # really executed as RESUME
    ['CONVERT 3', undef, '', "*444 Cannot convert RES to FIN\n", undef, 444,
     'DO CONVERT RESUME EXPRESSION TO FINISH LECTURE', [], [BC_CON, BC_RES, BC_FIN]],
    ['CONVERT 4', undef, '', "II\n", undef, undef,
     'DO CONVERT COME FROM LABEL TO ABSTAIN FROM LABEL', [], [BC_CON, BC_CFL, BC_ABL],
     'DO COME FROM (1)', [], [BC_CFL, BC(1)],
     '(1) DO READ OUT #1', [BC_LAB, BC(1)], [BC_ROU, BC(1), BC(1)],
     'DO READ OUT #2', [], [BC_ROU, BC(1), BC(2)]],
    ['CONVERT 5', undef, '', "II\n", undef, undef,
     '(1) DO CONVERT ABSTAIN FROM LABEL TO COME FROM LABEL', [BC_LAB, BC(1)], [BC_CON, BC_ABL, BC_CFL],
     'DO READ OUT #1', [], [BC_ROU, BC(1), BC(1)],
     'DO ABSTAIN FROM (1)', [], [BC_ABL, BC(1)],
     'DO READ OUT #2', [], [BC_ROU, BC(1), BC(2)]],
    ['CREATE 1', '1972', '', "\nII\n\nIII\n", undef, undef,
     # extend the 1972 compiler with Unary Division and call it D
     'DO CREATE ?UNARY ,D, AS UDV', [],
     [BC_CRE, BC(1), test_str('UNARY'), BC(1), BC(0), BC(1), test_str('D'),
      BC(1), BC(4), BC(1), BC_UDV],
     'DO .1 <- #D8', [], [BC_MSP, BC(0), BC(1), test_str('DO .1 <- #D8')],
     'DO READ OUT .1', [], [BC_ROU, BC(1), BC_SPO, BC(1)],
     'DO .2 <- #D3', [], [BC_MSP, BC(0), BC(1), test_str('DO .1 <- #D3')],
     'DO READ OUT .2', [], [BC_ROU, BC(1), BC_SPO, BC(2)]],
    ['DESTROY', 'sick', '', "II\n*000 DO .1 <- #-8\n", undef, 0,
     # extend sick to have another name for unary division, then destroy original
     'DO CREATE ?UNARY ,D, AS UDV', [],
     [BC_CRE, BC(1), test_str('UNARY'), BC(1), BC(0), BC(1), test_str('D'),
      BC(1), BC(4), BC(1), BC_UDV],
     'DO DESTROY ?UNARY ,#45,', [],
     [BC_DES, BC(1), test_str('UNARY'), BC(1), BC(0), BC(1), test_str('-')],
     'DO .1 <- #D8', [], [BC_STO, BC_UDV, BC(8), BC_SPO, BC(1)],
     'DO READ OUT .1', [], [BC_ROU, BC(1), BC_SPO, BC(1)],
     'DO .1 <- #-8', [], [BC_STO, BC_UDV, BC(8), BC_SPO, BC(1)],
     'DO READ OUT .1', [], [BC_ROU, BC(1), BC_SPO, BC(1)]],
    ['CREATE 2', 'sick', '', "II\nII\n", undef, undef,
     # add D as unary division; delete original and new; then add them again;
     # note that the program needs only be recompiled once even though there
     # are many creations/destructions
     'DO CREATE ?UNARY ,D, AS UDV', [],
     [BC_CRE, BC(1), test_str('UNARY'), BC(1), BC(0), BC(1), test_str('D'),
      BC(1), BC(4), BC(1), BC_UDV],
     'DO DESTROY ?UNARY ,#45,', [],
     [BC_DES, BC(1), test_str('UNARY'), BC(1), BC(0), BC(1), test_str('-')],
     'DO DESTROY ?UNARY ,D,', [],
     [BC_DES, BC(1), test_str('UNARY'), BC(1), BC(0), BC(1), test_str('D')],
     'DO CREATE ?UNARY ,#45, AS UDV', [],
     [BC_CRE, BC(1), test_str('UNARY'), BC(1), BC(0), BC(1), test_str('-'),
      BC(1), BC(4), BC(1), BC_UDV],
     'DO CREATE ?UNARY ,D, AS UDV', [],
     [BC_CRE, BC(1), test_str('UNARY'), BC(1), BC(0), BC(1), test_str('D'),
      BC(1), BC(4), BC(1), BC_UDV],
     'DO .1 <- #D8', [], [BC_STO, BC_UDV, BC(8), BC_SPO, BC(1)],
     'DO READ OUT .1', [], [BC_ROU, BC(1), BC_SPO, BC(1)],
     'DO .1 <- #-8', [], [BC_STO, BC_UDV, BC(8), BC_SPO, BC(1)],
     'DO READ OUT .1', [], [BC_ROU, BC(1), BC_SPO, BC(1)]],
    ['EVENTS 1', undef, '', "IV\nVI\nII\n", undef, undef,
     'DO .2 <- #4', [], [BC_STO, BC(4), BC_SPO, BC(2)],
     'DO #1 WHILE READ OUT .2', [], [BC_ECB, BC(1), BC_ROU, BC(1), BC_SPO, BC(2)],
     # make sure the event has time to execute before continuing
     'DO NOTHING FOR A WHILE', [BC_NOT], [BC_MSP, BC(0), BC(0)],
     'DO NOTHING FOR A WHILE', [BC_NOT], [BC_MSP, BC(0), BC(0)],
     'DO NOTHING FOR A WHILE', [BC_NOT], [BC_MSP, BC(0), BC(0)],
     'DO NOTHING FOR A WHILE', [BC_NOT], [BC_MSP, BC(0), BC(0)],
     'DO .2 <- #6', [], [BC_STO, BC(6), BC_SPO, BC(2)],
     'DO READ OUT .2', [], [BC_ROU, BC(1), BC_SPO, BC(2)],
     'DO .2 <- #2', [], [BC_STO, BC(2), BC_SPO, BC(2)],
     'DO READ OUT .2', [], [BC_ROU, BC(1), BC_SPO, BC(2)]],
    ['EVENTS 2', undef, '', "VI\nII\n*456 No splat\nIV\n", undef, 456,
     'DO * WHILE READ OUT .2', [], [BC_ECB, BC_SPL, BC_ROU, BC(1), BC_SPO, BC(2)],
     'DO .2 <- #6', [], [BC_STO, BC(6), BC_SPO, BC(2)],
     'DO READ OUT .2', [], [BC_ROU, BC(1), BC_SPO, BC(2)],
     'DO .2 <- #2', [], [BC_STO, BC(2), BC_SPO, BC(2)],
     'DO READ OUT .2', [], [BC_ROU, BC(1), BC_SPO, BC(2)],
     'DO .2 <- #4', [], [BC_STO, BC(4), BC_SPO, BC(2)],
     'DO .2 <- *', [], [BC_STO, BC_SPL, BC_SPO, BC(2)]],
    ['EVENTS 3', undef, '', "VI\nII\nIV\n", undef, undef,
     'DO * WHILE READ OUT .2', [], [BC_ECB, BC_SPL, BC_ROU, BC(1), BC_SPO, BC(2)],
     'DO .2 <- #6', [], [BC_STO, BC(6), BC_SPO, BC(2)],
     'DO READ OUT .2', [], [BC_ROU, BC(1), BC_SPO, BC(2)],
     'DO .2 <- #2', [], [BC_STO, BC(2), BC_SPO, BC(2)],
     'DO READ OUT .2', [], [BC_ROU, BC(1), BC_SPO, BC(2)],
     'DO .2 <- #4', [], [BC_STO, BC(4), BC_SPO, BC(2)],
     'DO READ OUT .2', [], [BC_ROU, BC(1), BC_SPO, BC(2)]],
    ['EVENTS 4', undef, '', "*751 Invalid event: BODY WHILE CONDITION\n", undef, 751,
     'DO .2 <- #4', [], [BC_STO, BC(4), BC_SPO, BC(2)],
     'DO READ OUT .2 WHILE #1', [], [BC_EBC, BC(1), BC_ROU, BC(1), BC_SPO, BC(2)],
     'DO .2 <- #6', [], [BC_STO, BC(6), BC_SPO, BC(2)],
     'DO READ OUT .2', [], [BC_ROU, BC(1), BC_SPO, BC(2)],
     'DO .2 <- #2', [], [BC_STO, BC(2), BC_SPO, BC(2)],
     'DO READ OUT .2', [], [BC_ROU, BC(1), BC_SPO, BC(2)]],
    ['EVENTS 5', undef, '', "*751 Invalid event: BODY WHILE CONDITION\n", undef, 751,
     'DO READ OUT .2 WHILE *', [], [BC_EBC, BC_SPL, BC_ROU, BC(1), BC_SPO, BC(2)],
     'DO .2 <- #6', [], [BC_STO, BC(6), BC_SPO, BC(2)],
     'DO READ OUT .2', [], [BC_ROU, BC(1), BC_SPO, BC(2)],
     'DO .2 <- #2', [], [BC_STO, BC(2), BC_SPO, BC(2)],
     'DO READ OUT .2', [], [BC_ROU, BC(1), BC_SPO, BC(2)],
     'DO .2 <- #4', [], [BC_STO, BC(4), BC_SPO, BC(2)],
     'DO .2 <- *', [], [BC_STO, BC_SPL, BC_SPO, BC(2)]],
    ['EVENTS 6', undef, '', "*751 Invalid event: BODY WHILE CONDITION\n", undef, 751,
     'DO READ OUT .2 WHILE *', [], [BC_EBC, BC_SPL, BC_ROU, BC(1), BC_SPO, BC(2)],
     'DO .2 <- #6', [], [BC_STO, BC(6), BC_SPO, BC(2)],
     'DO READ OUT .2', [], [BC_ROU, BC(1), BC_SPO, BC(2)],
     'DO .2 <- #2', [], [BC_STO, BC(2), BC_SPO, BC(2)],
     'DO READ OUT .2', [], [BC_ROU, BC(1), BC_SPO, BC(2)],
     'DO .2 <- #4', [], [BC_STO, BC(4), BC_SPO, BC(2)],
     'DO READ OUT .2', [], [BC_ROU, BC(1), BC_SPO, BC(2)]],
    ['EVENTS 7', undef, '', "*751 Invalid event: BODY WHILE CONDITION\n", undef, 751,
     'DO SWAP EXPRESSION WHILE STATEMENT AND STATEMENT WHILE EXPRESSION', [], [BC_SWA, BC_ECB, BC_EBC],
     'DO .2 <- #4', [], [BC_STO, BC(4), BC_SPO, BC(2)],
     'DO READ OUT .2 WHILE #1', [], [BC_ECB, BC(1), BC_ROU, BC(1), BC_SPO, BC(2)],
     'DO .2 <- #6', [], [BC_STO, BC(6), BC_SPO, BC(2)],
     'DO READ OUT .2', [], [BC_ROU, BC(1), BC_SPO, BC(2)],
     'DO .2 <- #2', [], [BC_STO, BC(2), BC_SPO, BC(2)],
     'DO READ OUT .2', [], [BC_ROU, BC(1), BC_SPO, BC(2)]],
    ['EVENTS 8', undef, '', "*751 Invalid event: BODY WHILE CONDITION\n", undef, 751,
     'DO SWAP EXPRESSION WHILE STATEMENT AND STATEMENT WHILE EXPRESSION', [], [BC_SWA, BC_ECB, BC_EBC],
     'DO READ OUT .2 WHILE *', [], [BC_ECB, BC_SPL, BC_ROU, BC(1), BC_SPO, BC(2)],
     'DO .2 <- #6', [], [BC_STO, BC(6), BC_SPO, BC(2)],
     'DO READ OUT .2', [], [BC_ROU, BC(1), BC_SPO, BC(2)],
     'DO .2 <- #2', [], [BC_STO, BC(2), BC_SPO, BC(2)],
     'DO READ OUT .2', [], [BC_ROU, BC(1), BC_SPO, BC(2)],
     'DO .2 <- #4', [], [BC_STO, BC(4), BC_SPO, BC(2)],
     'DO .2 <- *', [], [BC_STO, BC_SPL, BC_SPO, BC(2)]],
    ['EVENTS 9', undef, '', "*751 Invalid event: BODY WHILE CONDITION\n", undef, 751,
     'DO SWAP EXPRESSION WHILE STATEMENT AND STATEMENT WHILE EXPRESSION', [], [BC_SWA, BC_ECB, BC_EBC],
     'DO READ OUT .2 WHILE *', [], [BC_ECB, BC_SPL, BC_ROU, BC(1), BC_SPO, BC(2)],
     'DO .2 <- #6', [], [BC_STO, BC(6), BC_SPO, BC(2)],
     'DO READ OUT .2', [], [BC_ROU, BC(1), BC_SPO, BC(2)],
     'DO .2 <- #2', [], [BC_STO, BC(2), BC_SPO, BC(2)],
     'DO READ OUT .2', [], [BC_ROU, BC(1), BC_SPO, BC(2)],
     'DO .2 <- #4', [], [BC_STO, BC(4), BC_SPO, BC(2)],
     'DO READ OUT .2', [], [BC_ROU, BC(1), BC_SPO, BC(2)]],
    ['EVENTS 10', undef, '', "IV\nVI\nII\n", undef, undef,
     'DO SWAP EXPRESSION WHILE STATEMENT AND STATEMENT WHILE EXPRESSION', [], [BC_SWA, BC_ECB, BC_EBC],
     'DO .2 <- #4', [], [BC_STO, BC(4), BC_SPO, BC(2)],
     'DO #1 WHILE READ OUT .2', [], [BC_EBC, BC(1), BC_ROU, BC(1), BC_SPO, BC(2)],
     # make sure the event has time to execute before continuing
     'DO NOTHING FOR A WHILE', [BC_NOT], [BC_MSP, BC(0), BC(0)],
     'DO NOTHING FOR A WHILE', [BC_NOT], [BC_MSP, BC(0), BC(0)],
     'DO NOTHING FOR A WHILE', [BC_NOT], [BC_MSP, BC(0), BC(0)],
     'DO NOTHING FOR A WHILE', [BC_NOT], [BC_MSP, BC(0), BC(0)],
     'DO .2 <- #6', [], [BC_STO, BC(6), BC_SPO, BC(2)],
     'DO READ OUT .2', [], [BC_ROU, BC(1), BC_SPO, BC(2)],
     'DO .2 <- #2', [], [BC_STO, BC(2), BC_SPO, BC(2)],
     'DO READ OUT .2', [], [BC_ROU, BC(1), BC_SPO, BC(2)]],
    ['EVENTS 11', undef, '', "VI\nII\n*456 No splat\nIV\n", undef, 456,
     'DO SWAP EXPRESSION WHILE STATEMENT AND STATEMENT WHILE EXPRESSION', [], [BC_SWA, BC_ECB, BC_EBC],
     'DO * WHILE READ OUT .2', [], [BC_EBC, BC_SPL, BC_ROU, BC(1), BC_SPO, BC(2)],
     'DO .2 <- #6', [], [BC_STO, BC(6), BC_SPO, BC(2)],
     'DO READ OUT .2', [], [BC_ROU, BC(1), BC_SPO, BC(2)],
     'DO .2 <- #2', [], [BC_STO, BC(2), BC_SPO, BC(2)],
     'DO READ OUT .2', [], [BC_ROU, BC(1), BC_SPO, BC(2)],
     'DO .2 <- #4', [], [BC_STO, BC(4), BC_SPO, BC(2)],
     'DO .2 <- *', [], [BC_STO, BC_SPL, BC_SPO, BC(2)]],
    ['EVENTS 12', undef, '', "VI\nII\nIV\n", undef, undef,
     'DO SWAP EXPRESSION WHILE STATEMENT AND STATEMENT WHILE EXPRESSION', [], [BC_SWA, BC_ECB, BC_EBC],
     'DO * WHILE READ OUT .2', [], [BC_EBC, BC_SPL, BC_ROU, BC(1), BC_SPO, BC(2)],
     'DO .2 <- #6', [], [BC_STO, BC(6), BC_SPO, BC(2)],
     'DO READ OUT .2', [], [BC_ROU, BC(1), BC_SPO, BC(2)],
     'DO .2 <- #2', [], [BC_STO, BC(2), BC_SPO, BC(2)],
     'DO READ OUT .2', [], [BC_ROU, BC(1), BC_SPO, BC(2)],
     'DO .2 <- #4', [], [BC_STO, BC(4), BC_SPO, BC(2)],
     'DO READ OUT .2', [], [BC_ROU, BC(1), BC_SPO, BC(2)]],
    ['EVENTS 13', undef, '', "VI\n*456 No splat\nIII\n", undef, 456,
     'DO * WHILE (1) NEXT', [], [BC_ECB, BC_SPL, BC_NXT, BC(1)],
     'DO .2 <- #6', [], [BC_STO, BC(6), BC_SPO, BC(2)],
     'DO READ OUT .2', [], [BC_ROU, BC(1), BC_SPO, BC(2)],
     'DO .2 <- *', [], [BC_STO, BC_SPL, BC_SPO, BC(2)],
     'DO READ OUT .2', [], [BC_ROU, BC(1), BC_SPO, BC(2)],
     'DO GIVE UP', [], [BC_GUP],
     '(1) DO .2 <- #3', [BC_LAB, BC(1)], [BC_STO, BC(3), BC_SPO, BC(2)],
     'DO READ OUT .2', [], [BC_ROU, BC(1), BC_SPO, BC(2)],
     'DO RESUME #1', [], [BC_RES, BC(1)]],
    ['EVENTS 14', undef, '', "VI\nIII\n", undef, undef,
     'DO #1 WHILE (1) NEXT', [], [BC_ECB, BC(1), BC_NXT, BC(1)],
     'DO .2 <- #6', [], [BC_STO, BC(6), BC_SPO, BC(2)],
     'DO READ OUT .2', [], [BC_ROU, BC(1), BC_SPO, BC(2)],
     'DO GIVE UP', [], [BC_GUP],
     '(1) DO .2 <- #3', [BC_LAB, BC(1)], [BC_STO, BC(3), BC_SPO, BC(2)],
     'DO READ OUT .2', [], [BC_ROU, BC(1), BC_SPO, BC(2)],
     'DO RESUME #1', [], [BC_RES, BC(1)]],
    ['EVENTS 15', undef, '', "VI\n", undef, undef,
     'DO ABSTAIN FROM NEXTING', [], [BC_ABG, BC(1), BC_NXT],
     'DO #1 WHILE (1) NEXT', [], [BC_ECB, BC(1), BC_NXT, BC(1)],
     'DO .2 <- #6', [], [BC_STO, BC(6), BC_SPO, BC(2)],
     'DO READ OUT .2', [], [BC_ROU, BC(1), BC_SPO, BC(2)],
     'DO GIVE UP', [], [BC_GUP],
     '(1) DO .2 <- #3', [BC_LAB, BC(1)], [BC_STO, BC(3), BC_SPO, BC(2)],
     'DO READ OUT .2', [], [BC_ROU, BC(1), BC_SPO, BC(2)],
     'DO RESUME #1', [], [BC_RES, BC(1)]],
    ['EVENTS 16', undef, '', "VI\n", undef, undef,
     'DO ABSTAIN FROM READING OUT', [], [BC_ABG, BC(1), BC_ROU],
     'DO REINSTATE (2)', [], [BC_REL, BC(2)],
     'DO #1 WHILE (1) NEXT', [], [BC_ECB, BC(1), BC_NXT, BC(1)],
     'DO .2 <- #6', [], [BC_STO, BC(6), BC_SPO, BC(2)],
     '(2) DO READ OUT .2', [BC_LAB, BC(2)], [BC_ROU, BC(1), BC_SPO, BC(2)],
     'DO GIVE UP', [], [BC_GUP],
     '(1) DO .2 <- #3', [BC_LAB, BC(1)], [BC_STO, BC(3), BC_SPO, BC(2)],
     'DO READ OUT .2', [], [BC_ROU, BC(1), BC_SPO, BC(2)],
     'DO RESUME #1', [], [BC_RES, BC(1)]],
    ['EVENTS 17', undef, '', "III\nVI\n", undef, undef,
     '(1) DO #1 WHILE (2) NEXT', [BC_LAB, BC(1)], [BC_ECB, BC(1), BC_NXT, BC(2)],
     'DO .2 <- #8', [], [BC_STO, BC(8), BC_SPO, BC(2)],
     'DO READ OUT .2', [], [BC_ROU, BC(1), BC_SPO, BC(2)],
     'DO GIVE UP', [], [BC_GUP],
     'DO COME FROM (1)', [], [BC_CFL, BC(1)],
     # make sure the event has time to execute before continuing
     'DO NOTHING FOR A WHILE', [BC_NOT], [BC_MSP, BC(0), BC(0)],
     'DO NOTHING FOR A WHILE', [BC_NOT], [BC_MSP, BC(0), BC(0)],
     'DO NOTHING FOR A WHILE', [BC_NOT], [BC_MSP, BC(0), BC(0)],
     'DO NOTHING FOR A WHILE', [BC_NOT], [BC_MSP, BC(0), BC(0)],
     'DO NOTHING FOR A WHILE', [BC_NOT], [BC_MSP, BC(0), BC(0)],
     'DO NOTHING FOR A WHILE', [BC_NOT], [BC_MSP, BC(0), BC(0)],
     'DO .1 <- #6', [], [BC_STO, BC(6), BC_SPO, BC(1)],
     'DO READ OUT .1', [], [BC_ROU, BC(1), BC_SPO, BC(1)],
     'DO GIVE UP', [], [BC_GUP],
     '(2) DO .2 <- #3', [BC_LAB, BC(2)], [BC_STO, BC(3), BC_SPO, BC(2)],
     'DO READ OUT .2', [], [BC_ROU, BC(1), BC_SPO, BC(2)],
     'DO RESUME #1', [], [BC_RES, BC(1)]],
    ['EVENTS 18', undef, '', [1, "VI\n", "IV\n", "III\n"], undef, undef,
     'DO %CF <- #3', [], [BC_STO, BC(3), reg_code('%CF')],
     'DO #1 WHILE REINSTATE READING OUT', [], [BC_ECB, BC(1), BC_REG, BC(1), BC_ROU],
     'DO GIVE UP', [], [BC_GUP],
     'DO COME FROM REINSTATING', [], [BC_CFG, BC(2), BC_REG, BC_REL],
     'DO NOT READ OUT %CF', [BC_NOT], [BC_ROU, BC(1), reg_code('%CF')],
     'DO GIVE UP', [], [BC_GUP],
     'DO COME FROM REINSTATING', [], [BC_CFG, BC(2), BC_REG, BC_REL],
     'DO .1 <- #4', [], [BC_STO, BC(4), BC_SPO, BC(1)],
     'DO READ OUT .1', [], [BC_ROU, BC(1), BC_SPO, BC(1)],
     'DO GIVE UP', [], [BC_GUP],
     'DO COME FROM REINSTATING', [], [BC_CFG, BC(2), BC_REG, BC_REL],
     'DO .2 <- #6', [], [BC_STO, BC(6), BC_SPO, BC(2)],
     'DO READ OUT .2', [], [BC_ROU, BC(1), BC_SPO, BC(2)],
     'DO GIVE UP', [], [BC_GUP]],
    ['LOOPS 1a', undef, 'SIX', "IV\nVI\n", undef, undef,
     'DO .2 <- #4', [], [BC_STO, BC(4), BC_SPO, BC(2)],
     'DO READ OUT .2 WHILE WRITE IN .1', [],
      [BC_CWB, BC_WIN, BC(1), BC_SPO, BC(1), BC_ROU, BC(1), BC_SPO, BC(2)],
     'DO READ OUT .1', [], [BC_ROU, BC(1), BC_SPO, BC(1)]],
    ['LOOPS 1b', undef, 'SIX', "IV\nVI\n", undef, undef,
     'DO .2 <- #4', [], [BC_STO, BC(4), BC_SPO, BC(2)],
     'DO READ OUT .2 WHILE WRITE IN .1', [],
      [BC_BWC, BC_ROU, BC(1), BC_SPO, BC(2), BC_WIN, BC(1), BC_SPO, BC(1)],
     'DO READ OUT .1', [], [BC_ROU, BC(1), BC_SPO, BC(1)]],
    ['LOOPS 2a', undef, '', "IV\nIV\nIV\nIV\nIV\n", undef, undef,
     'DO .2 <- #4', [], [BC_STO, BC(4), BC_SPO, BC(2)],
     'DO (1) NEXT WHILE READ OUT .2', [],
      [BC_CWB, BC_ROU, BC(1), BC_SPO, BC(2), BC_NXT, BC(1)],
     'DO GIVE UP', [], [BC_GUP],
     '(1) DO NOT GIVE UP', [BC_LAB, BC(1), BC_NOT], [BC_GUP],
     'DO NOT GIVE UP', [BC_NOT], [BC_GUP],
     'DO NOT GIVE UP', [BC_NOT], [BC_GUP],
     'DO RESUME #1', [], [BC_RES, BC(1)]],
    ['LOOPS 2b', undef, '', "IV\nIV\nIV\nIV\nIV\n", undef, undef,
     'DO .2 <- #4', [], [BC_STO, BC(4), BC_SPO, BC(2)],
     'DO (1) NEXT WHILE READ OUT .2', [],
      [BC_BWC, BC_NXT, BC(1), BC_ROU, BC(1), BC_SPO, BC(2)],
     'DO GIVE UP', [], [BC_GUP],
     '(1) DO NOT GIVE UP', [BC_LAB, BC(1), BC_NOT], [BC_GUP],
     'DO NOT GIVE UP', [BC_NOT], [BC_GUP],
     'DO NOT GIVE UP', [BC_NOT], [BC_GUP],
     'DO RESUME #1', [], [BC_RES, BC(1)]],
    ['LOOPS 3a', undef, '', "IV\nIV\nII\nII\nII\n", undef, undef,
     'DO .2 <- #4', [], [BC_STO, BC(4), BC_SPO, BC(2)],
     'DO STUDY #1 AT (1000) IN CLASS @1', [], [BC_STU, BC(1), BC(1000), BC_WHP, BC(1)],
     'DO ENROL .2 TO LEARN #1', [], [BC_ENR, BC(1), BC(1), BC_SPO, BC(2)],
     'DO .2 LEARNS #1 WHILE READ OUT .2', [],
      [BC_CWB, BC_ROU, BC(1), BC_SPO, BC(2), BC_LEA, BC(1), BC_SPO, BC(2)],
     'DO GIVE UP', [], [BC_GUP],
     '(1000) DO NOT GIVE UP', [BC_LAB, BC(1000), BC_NOT], [BC_GUP],
     'DO $@1 <- #2', [], [BC_STO, BC(2), BC_BLM, BC(1), BC_WHP, BC(1)],
     'DO NOT GIVE UP', [BC_NOT], [BC_GUP],
     'DO FINISH LECTURE', [], [BC_FIN]],
    ['LOOPS 3b', undef, '', "IV\nIV\nII\nII\nII\n", undef, undef,
     'DO .2 <- #4', [], [BC_STO, BC(4), BC_SPO, BC(2)],
     'DO STUDY #1 AT (1000) IN CLASS @1', [], [BC_STU, BC(1), BC(1000), BC_WHP, BC(1)],
     'DO ENROL .2 TO LEARN #1', [], [BC_ENR, BC(1), BC(1), BC_SPO, BC(2)],
     'DO .2 LEARNS #1 WHILE READ OUT .2', [],
      [BC_BWC, BC_LEA, BC(1), BC_SPO, BC(2), BC_ROU, BC(1), BC_SPO, BC(2)],
     'DO GIVE UP', [], [BC_GUP],
     '(1000) DO NOT GIVE UP', [BC_LAB, BC(1000), BC_NOT], [BC_GUP],
     'DO $@1 <- #2', [], [BC_STO, BC(2), BC_BLM, BC(1), BC_WHP, BC(1)],
     'DO NOT GIVE UP', [BC_NOT], [BC_GUP],
     'DO FINISH LECTURE', [], [BC_FIN]],
    ['LOOPS 4a', undef, '', "IV\nV\n", undef, undef,
     'DO .2 <- #4', [], [BC_STO, BC(4), BC_SPO, BC(2)],
     'DO .3 <- #5', [], [BC_STO, BC(5), BC_SPO, BC(3)],
     'DO READ OUT .2 WHILE (2) NEXT', [],
      [BC_CWB, BC_NXT, BC(2), BC_ROU, BC(1), BC_SPO, BC(2)],
     'DO GIVE UP', [], [BC_GUP],
     '(2) DO READ OUT .3', [BC_LAB, BC(2)], [BC_ROU, BC(1), BC_SPO, BC(3)],
     'DO RESUME #1', [], [BC_RES, BC(1)]],
    ['LOOPS 4b', undef, '', "IV\nV\n", undef, undef,
     'DO .2 <- #4', [], [BC_STO, BC(4), BC_SPO, BC(2)],
     'DO .3 <- #5', [], [BC_STO, BC(5), BC_SPO, BC(3)],
     'DO READ OUT .2 WHILE (2) NEXT', [],
      [BC_BWC, BC_ROU, BC(1), BC_SPO, BC(2), BC_NXT, BC(2)],
     'DO GIVE UP', [], [BC_GUP],
     '(2) DO READ OUT .3', [BC_LAB, BC(2)], [BC_ROU, BC(1), BC_SPO, BC(3)],
     'DO RESUME #1', [], [BC_RES, BC(1)]],
    ['LOOPS 5a', undef, '', "V\nV\n", undef, undef,
     'DO .3 <- #5', [], [BC_STO, BC(5), BC_SPO, BC(3)],
     'DO (1) NEXT WHILE (2) NEXT', [],
      [BC_CWB, BC_NXT, BC(2), BC_NXT, BC(1)],
     'DO GIVE UP', [], [BC_GUP],
     '(1) DO NOT GIVE UP', [BC_LAB, BC(1), BC_NOT], [BC_GUP],
     'DO NOT GIVE UP', [BC_NOT], [BC_GUP],
     'DO NOT GIVE UP', [BC_NOT], [BC_GUP],
     'DO RESUME #1', [], [BC_RES, BC(1)],
     '(2) DO READ OUT .3', [BC_LAB, BC(2)], [BC_ROU, BC(1), BC_SPO, BC(3)],
     'DO RESUME #1', [], [BC_RES, BC(1)]],
    ['LOOPS 5b', undef, '', "V\nV\n", undef, undef,
     'DO .3 <- #5', [], [BC_STO, BC(5), BC_SPO, BC(3)],
     'DO (1) NEXT WHILE (2) NEXT', [],
      [BC_BWC, BC_NXT, BC(1), BC_NXT, BC(2)],
     'DO GIVE UP', [], [BC_GUP],
     '(1) DO NOT GIVE UP', [BC_LAB, BC(1), BC_NOT], [BC_GUP],
     'DO NOT GIVE UP', [BC_NOT], [BC_GUP],
     'DO NOT GIVE UP', [BC_NOT], [BC_GUP],
     'DO RESUME #1', [], [BC_RES, BC(1)],
     '(2) DO READ OUT .3', [BC_LAB, BC(2)], [BC_ROU, BC(1), BC_SPO, BC(3)],
     'DO RESUME #1', [], [BC_RES, BC(1)]],
    ['LOOPS 6a', undef, '', "V\nII\n", undef, undef,
     'DO .3 <- #5', [], [BC_STO, BC(5), BC_SPO, BC(3)],
     'DO STUDY #1 AT (1000) IN CLASS @1', [], [BC_STU, BC(1), BC(1000), BC_WHP, BC(1)],
     'DO ENROL .3 TO LEARN #1', [], [BC_ENR, BC(1), BC(1), BC_SPO, BC(3)],
     'DO .3 LEARNS #1 WHILE (1) NEXT', [],
      [BC_CWB, BC_NXT, BC(1), BC_LEA, BC(1), BC_SPO, BC(3)],
     'DO GIVE UP', [], [BC_GUP],
     '(1000) DO NOT GIVE UP', [BC_LAB, BC(1000), BC_NOT], [BC_GUP],
     'DO $@1 <- #2', [], [BC_STO, BC(2), BC_BLM, BC(1), BC_WHP, BC(1)],
     'DO NOT GIVE UP', [BC_NOT], [BC_GUP],
     'DO FINISH LECTURE', [], [BC_FIN],
     '(1) DO READ OUT .3', [BC_LAB, BC(1)], [BC_ROU, BC(1), BC_SPO, BC(3)],
     'DO RESUME #1', [], [BC_RES, BC(1)]],
    ['LOOPS 6b', undef, '', "V\nII\n", undef, undef,
     'DO .3 <- #5', [], [BC_STO, BC(5), BC_SPO, BC(3)],
     'DO STUDY #1 AT (1000) IN CLASS @1', [], [BC_STU, BC(1), BC(1000), BC_WHP, BC(1)],
     'DO ENROL .3 TO LEARN #1', [], [BC_ENR, BC(1), BC(1), BC_SPO, BC(3)],
     'DO .3 LEARNS #1 WHILE (1) NEXT', [],
      [BC_BWC, BC_LEA, BC(1), BC_SPO, BC(3), BC_NXT, BC(1)],
     'DO GIVE UP', [], [BC_GUP],
     '(1000) DO NOT GIVE UP', [BC_LAB, BC(1000), BC_NOT], [BC_GUP],
     'DO $@1 <- #2', [], [BC_STO, BC(2), BC_BLM, BC(1), BC_WHP, BC(1)],
     'DO NOT GIVE UP', [BC_NOT], [BC_GUP],
     'DO FINISH LECTURE', [], [BC_FIN],
     '(1) DO READ OUT .3', [BC_LAB, BC(1)], [BC_ROU, BC(1), BC_SPO, BC(3)],
     'DO RESUME #1', [], [BC_RES, BC(1)]],
    ['LOOPS 7a', undef, '', "IV\nV\n", undef, undef,
     'DO .2 <- #4', [], [BC_STO, BC(4), BC_SPO, BC(2)],
     'DO .3 <- #5', [], [BC_STO, BC(5), BC_SPO, BC(3)],
     'DO STUDY #1 AT (1000) IN CLASS @1', [], [BC_STU, BC(1), BC(1000), BC_WHP, BC(1)],
     'DO ENROL .2 TO LEARN #1', [], [BC_ENR, BC(1), BC(1), BC_SPO, BC(2)],
     'DO READ OUT .2 WHILE .2 LEARNS #1', [],
      [BC_CWB, BC_LEA, BC(1), BC_SPO, BC(2), BC_ROU, BC(1), BC_SPO, BC(2)],
     'DO GIVE UP', [], [BC_GUP],
     '(1000) DO READ OUT .3', [BC_LAB, BC(1000)], [BC_ROU, BC(1), BC_SPO, BC(3)],
     'DO FINISH LECTURE', [], [BC_FIN]],
    ['LOOPS 7b', undef, '', "IV\nV\n", undef, undef,
     'DO .2 <- #4', [], [BC_STO, BC(4), BC_SPO, BC(2)],
     'DO .3 <- #5', [], [BC_STO, BC(5), BC_SPO, BC(3)],
     'DO STUDY #1 AT (1000) IN CLASS @1', [], [BC_STU, BC(1), BC(1000), BC_WHP, BC(1)],
     'DO ENROL .2 TO LEARN #1', [], [BC_ENR, BC(1), BC(1), BC_SPO, BC(2)],
     'DO READ OUT .2 WHILE .2 LEARNS #1', [],
      [BC_BWC, BC_ROU, BC(1), BC_SPO, BC(2), BC_LEA, BC(1), BC_SPO, BC(2)],
     'DO GIVE UP', [], [BC_GUP],
     '(1000) DO READ OUT .3', [BC_LAB, BC(1000)], [BC_ROU, BC(1), BC_SPO, BC(3)],
     'DO FINISH LECTURE', [], [BC_FIN]],
    ['LOOPS 8a', undef, '', "V\nV\n", undef, undef,
     'DO .3 <- #5', [], [BC_STO, BC(5), BC_SPO, BC(3)],
     'DO STUDY #1 AT (1000) IN CLASS @1', [], [BC_STU, BC(1), BC(1000), BC_WHP, BC(1)],
     'DO ENROL .3 TO LEARN #1', [], [BC_ENR, BC(1), BC(1), BC_SPO, BC(3)],
     'DO (1) NEXT WHILE .3 LEARHS #1', [],
      [BC_CWB, BC_LEA, BC(1), BC_SPO, BC(3), BC_NXT, BC(1)],
     'DO GIVE UP', [], [BC_GUP],
     '(1) DO NOT GIVE UP', [BC_LAB, BC(1), BC_NOT], [BC_GUP],
     'DO NOT GIVE UP', [BC_NOT], [BC_GUP],
     'DO NOT GIVE UP', [BC_NOT], [BC_GUP],
     'DO RESUME #1', [], [BC_RES, BC(1)],
     '(1000) DO READ OUT $@1', [BC_LAB, BC(1000)], [BC_ROU, BC(1), BC_BLM, BC(1), BC_WHP, BC(1)],
     'DO FINISH LECTURE', [], [BC_FIN]],
    ['LOOPS 8b', undef, '', "V\nV\n", undef, undef,
     'DO .3 <- #5', [], [BC_STO, BC(5), BC_SPO, BC(3)],
     'DO STUDY #1 AT (1000) IN CLASS @1', [], [BC_STU, BC(1), BC(1000), BC_WHP, BC(1)],
     'DO ENROL .3 TO LEARN #1', [], [BC_ENR, BC(1), BC(1), BC_SPO, BC(3)],
     'DO (1) NEXT WHILE .3 LEARHS #1', [],
      [BC_BWC, BC_NXT, BC(1), BC_LEA, BC(1), BC_SPO, BC(3)],
     'DO GIVE UP', [], [BC_GUP],
     '(1) DO NOT GIVE UP', [BC_LAB, BC(1), BC_NOT], [BC_GUP],
     'DO NOT GIVE UP', [BC_NOT], [BC_GUP],
     'DO NOT GIVE UP', [BC_NOT], [BC_GUP],
     'DO RESUME #1', [], [BC_RES, BC(1)],
     '(1000) DO READ OUT $@1', [BC_LAB, BC(1000)], [BC_ROU, BC(1), BC_BLM, BC(1), BC_WHP, BC(1)],
     'DO FINISH LECTURE', [], [BC_FIN]],
    ['LOOPS 9a', undef, '', "V\nII\n", undef, undef,
     'DO .3 <- #5', [], [BC_STO, BC(5), BC_SPO, BC(3)],
     'DO STUDY #1 AT (1000) IN CLASS @1', [], [BC_STU, BC(1), BC(1000), BC_WHP, BC(1)],
     'DO STUDY #2 AT (2000) IN CLASS @1', [], [BC_STU, BC(2), BC(2000), BC_WHP, BC(1)],
     'DO ENROL .3 TO LEARN #1', [], [BC_ENR, BC(1), BC(1), BC_SPO, BC(3)],
     'DO .3 LEARNS #1 WHILE .3 LEARNS #2', [],
      [BC_CWB, BC_LEA, BC(2), BC_SPO, BC(3), BC_LEA, BC(1), BC_SPO, BC(3)],
     'DO GIVE UP', [], [BC_GUP],
     '(1000) DO NOT GIVE UP', [BC_LAB, BC(1000), BC_NOT], [BC_GUP],
     'DO $@1 <- #2', [], [BC_STO, BC(2), BC_BLM, BC(1), BC_WHP, BC(1)],
     'DO NOT GIVE UP', [BC_NOT], [BC_GUP],
     'DO FINISH LECTURE', [], [BC_FIN],
     '(2000) DO READ OUT $@1', [BC_LAB, BC(2000)], [BC_ROU, BC(1), BC_BLM, BC(1), BC_WHP, BC(1)],
     'DO FINISH LECTURE', [], [BC_FIN]],
    ['LOOPS 9b', undef, '', "V\nII\n", undef, undef,
     'DO .3 <- #5', [], [BC_STO, BC(5), BC_SPO, BC(3)],
     'DO STUDY #1 AT (1000) IN CLASS @1', [], [BC_STU, BC(1), BC(1000), BC_WHP, BC(1)],
     'DO STUDY #2 AT (2000) IN CLASS @1', [], [BC_STU, BC(2), BC(2000), BC_WHP, BC(1)],
     'DO ENROL .3 TO LEARN #1', [], [BC_ENR, BC(1), BC(1), BC_SPO, BC(3)],
     'DO .3 LEARNS #1 WHILE .3 LEARNS #2', [],
      [BC_BWC, BC_LEA, BC(1), BC_SPO, BC(3), BC_LEA, BC(2), BC_SPO, BC(3)],
     'DO GIVE UP', [], [BC_GUP],
     '(1000) DO NOT GIVE UP', [BC_LAB, BC(1000), BC_NOT], [BC_GUP],
     'DO $@1 <- #2', [], [BC_STO, BC(2), BC_BLM, BC(1), BC_WHP, BC(1)],
     'DO NOT GIVE UP', [BC_NOT], [BC_GUP],
     'DO FINISH LECTURE', [], [BC_FIN],
     '(2000) DO READ OUT $@1', [BC_LAB, BC(2000)], [BC_ROU, BC(1), BC_BLM, BC(1), BC_WHP, BC(1)],
     'DO FINISH LECTURE', [], [BC_FIN]],
    ['LOOPS 10a', undef, '', "IV\nIV\nIV\n", undef, undef,
     'DO .2 <- #4', [], [BC_STO, BC(4), BC_SPO, BC(2)],
     'DO (1) NEXT WHILE READ OUT .2', [],
      [BC_CWB, BC_ROU, BC(1), BC_SPO, BC(2), BC_NXT, BC(1)],
     'DO GIVE UP', [], [BC_GUP],
     '(1) DO NOT GIVE UP', [BC_LAB, BC(1), BC_NOT], [BC_GUP],
     'DO NOT GIVE UP', [BC_NOT], [BC_GUP],
     'DO ABSTAIN FROM READING OUT', [], [BC_ABG, BC(1), BC_ROU],
     'DO NOT GIVE UP', [BC_NOT], [BC_GUP],
     'DO RESUME #1', [], [BC_RES, BC(1)]],
    ['LOOPS 10b', undef, '', "IV\nIV\nIV\n", undef, undef,
     'DO .2 <- #4', [], [BC_STO, BC(4), BC_SPO, BC(2)],
     'DO (1) NEXT WHILE READ OUT .2', [],
      [BC_BWC, BC_NXT, BC(1), BC_ROU, BC(1), BC_SPO, BC(2)],
     'DO GIVE UP', [], [BC_GUP],
     '(1) DO NOT GIVE UP', [BC_LAB, BC(1), BC_NOT], [BC_GUP],
     'DO NOT GIVE UP', [BC_NOT], [BC_GUP],
     'DO ABSTAIN FROM READING OUT', [], [BC_ABG, BC(1), BC_ROU],
     'DO NOT GIVE UP', [BC_NOT], [BC_GUP],
     'DO RESUME #1', [], [BC_RES, BC(1)]],
    ['LOOPS 11a', undef, 'SIX', "IV\nVI\nV\n", undef, undef,
     'DO %CF <- #2', [], [BC_STO, BC(2), reg_code('%CF')],
     'DO .2 <- #4', [], [BC_STO, BC(4), BC_SPO, BC(2)],
     'DO READ OUT .2 WHILE WRITE IN .1', [],
      [BC_CWB, BC_WIN, BC(1), BC_SPO, BC(1), BC_ROU, BC(1), BC_SPO, BC(2)],
     'DO READ OUT .1', [], [BC_ROU, BC(1), BC_SPO, BC(1)],
     'DO GIVE UP', [], [BC_GUP],
     'DO NEXT FROM WRITING IN', [], [BC_NXG, BC(1), BC_WIN],
     'DO READ OUT #5', [], [BC_ROU, BC(1), BC(5)],
     'DO RESUME #1', [], [BC_RES, BC(1)]],
    ['LOOPS 11b', undef, 'SIX', "IV\nVI\nV\n", undef, undef,
     'DO %CF <- #2', [], [BC_STO, BC(2), reg_code('%CF')],
     'DO .2 <- #4', [], [BC_STO, BC(4), BC_SPO, BC(2)],
     'DO READ OUT .2 WHILE WRITE IN .1', [],
      [BC_BWC, BC_ROU, BC(1), BC_SPO, BC(2), BC_WIN, BC(1), BC_SPO, BC(1)],
     'DO READ OUT .1', [], [BC_ROU, BC(1), BC_SPO, BC(1)],
     'DO GIVE UP', [], [BC_GUP],
     'DO NEXT FROM WRITING IN', [], [BC_NXG, BC(1), BC_WIN],
     'DO READ OUT #5', [], [BC_ROU, BC(1), BC(5)],
     'DO RESUME #1', [], [BC_RES, BC(1)]],
    ['LOOPS 12a', undef, "SIX\nNINE\nONE TWO\n", "IV\nXII\n", undef, undef,
     'DO %CF <- #2', [], [BC_STO, BC(2), reg_code('%CF')],
     'DO .2 <- #4', [], [BC_STO, BC(4), BC_SPO, BC(2)],
     'DO READ OUT .2 WHILE WRITE IN .1', [],
      [BC_CWB, BC_WIN, BC(1), BC_SPO, BC(1), BC_ROU, BC(1), BC_SPO, BC(2)],
     'DO READ OUT .1', [], [BC_ROU, BC(1), BC_SPO, BC(1)],
     'DO GIVE UP', [], [BC_GUP],
     'DO NEXT FROM READING OUT', [], [BC_NXG, BC(1), BC_ROU],
     'DO RESUME #1', [], [BC_RES, BC(1)]],
    ['LOOPS 12b', undef, "SIX\nNINE\nONE TWO\n", "IV\nXII\n", undef, undef,
     'DO %CF <- #2', [], [BC_STO, BC(2), reg_code('%CF')],
     'DO .2 <- #4', [], [BC_STO, BC(4), BC_SPO, BC(2)],
     'DO READ OUT .2 WHILE WRITE IN .1', [],
      [BC_BWC, BC_ROU, BC(1), BC_SPO, BC(2), BC_WIN, BC(1), BC_SPO, BC(1)],
     'DO READ OUT .1', [], [BC_ROU, BC(1), BC_SPO, BC(1)],
     'DO GIVE UP', [], [BC_GUP],
     'DO NEXT FROM READING OUT', [], [BC_NXG, BC(1), BC_ROU],
     'DO RESUME #1', [], [BC_RES, BC(1)]],
    ['LOOPS 13a', undef, 'SIX', "IV\nVI\nV\nV\n", undef, undef,
     'DO %CF <- #3', [], [BC_STO, BC(3), reg_code('%CF')],
     'DO .2 <- #4', [], [BC_STO, BC(4), BC_SPO, BC(2)],
     'DO READ OUT .2 WHILE WRITE IN .1', [],
      [BC_CWB, BC_WIN, BC(1), BC_SPO, BC(1), BC_ROU, BC(1), BC_SPO, BC(2)],
     'DO READ OUT .1', [], [BC_ROU, BC(1), BC_SPO, BC(1)],
     'DO GIVE UP', [], [BC_GUP],
     'DO NEXT FROM WRITING IN', [], [BC_NXG, BC(1), BC_WIN],
     'DO READ OUT #5', [], [BC_ROU, BC(1), BC(5)],
     'DO RESUME #1', [], [BC_RES, BC(1)],
     'DO NEXT FROM WRITING IN', [], [BC_NXG, BC(1), BC_WIN],
     'DO READ OUT #5', [], [BC_ROU, BC(1), BC(5)],
     'DO RESUME #1', [], [BC_RES, BC(1)]],
    ['LOOPS 13b', undef, 'SIX', "IV\nVI\nV\nV\n", undef, undef,
     'DO %CF <- #3', [], [BC_STO, BC(3), reg_code('%CF')],
     'DO .2 <- #4', [], [BC_STO, BC(4), BC_SPO, BC(2)],
     'DO READ OUT .2 WHILE WRITE IN .1', [],
      [BC_BWC, BC_ROU, BC(1), BC_SPO, BC(2), BC_WIN, BC(1), BC_SPO, BC(1)],
     'DO READ OUT .1', [], [BC_ROU, BC(1), BC_SPO, BC(1)],
     'DO GIVE UP', [], [BC_GUP],
     'DO NEXT FROM WRITING IN', [], [BC_NXG, BC(1), BC_WIN],
     'DO READ OUT #5', [], [BC_ROU, BC(1), BC(5)],
     'DO RESUME #1', [], [BC_RES, BC(1)],
     'DO NEXT FROM WRITING IN', [], [BC_NXG, BC(1), BC_WIN],
     'DO READ OUT #5', [], [BC_ROU, BC(1), BC(5)],
     'DO RESUME #1', [], [BC_RES, BC(1)]],
    ['LOOPS 14a', undef, "SIX\nNINE\nONE TWO\n", "IV\nXII\nXII\n", undef, undef,
     'DO %CF <- #3', [], [BC_STO, BC(3), reg_code('%CF')],
     'DO .2 <- #4', [], [BC_STO, BC(4), BC_SPO, BC(2)],
     'DO READ OUT .2 WHILE WRITE IN .1', [],
      [BC_CWB, BC_WIN, BC(1), BC_SPO, BC(1), BC_ROU, BC(1), BC_SPO, BC(2)],
     'DO READ OUT .1', [], [BC_ROU, BC(1), BC_SPO, BC(1)],
     'DO GIVE UP', [], [BC_GUP],
     'DO NEXT FROM READING OUT', [], [BC_NXG, BC(1), BC_ROU],
     'DO RESUME #1', [], [BC_RES, BC(1)],
     'DO NEXT FROM READING OUT', [], [BC_NXG, BC(1), BC_ROU],
     'DO RESUME #1', [], [BC_RES, BC(1)]],
    ['LOOPS 14b', undef, "SIX\nNINE\nONE TWO\n", "IV\nXII\nXII\n", undef, undef,
     'DO %CF <- #3', [], [BC_STO, BC(3), reg_code('%CF')],
     'DO .2 <- #4', [], [BC_STO, BC(4), BC_SPO, BC(2)],
     'DO READ OUT .2 WHILE WRITE IN .1', [],
      [BC_BWC, BC_ROU, BC(1), BC_SPO, BC(2), BC_WIN, BC(1), BC_SPO, BC(1)],
     'DO READ OUT .1', [], [BC_ROU, BC(1), BC_SPO, BC(1)],
     'DO GIVE UP', [], [BC_GUP],
     'DO NEXT FROM READING OUT', [], [BC_NXG, BC(1), BC_ROU],
     'DO RESUME #1', [], [BC_RES, BC(1)],
     'DO NEXT FROM READING OUT', [], [BC_NXG, BC(1), BC_ROU],
     'DO RESUME #1', [], [BC_RES, BC(1)]],
    ['LOOPS 15a', undef, '', "IV\nIV\nIV\nIV\nIV\n", undef, undef,
     'DO SWAP CONDITION WHILE BODY AND BODY WHILE CONDITION', [], [BC_SWA, BC_CWB, BC_BWC],
     'DO .2 <- #4', [], [BC_STO, BC(4), BC_SPO, BC(2)],
     'DO (1) NEXT WHILE READ OUT .2', [],
      [BC_CWB, BC_NXT, BC(1), BC_ROU, BC(1), BC_SPO, BC(2)],
     'DO GIVE UP', [], [BC_GUP],
     '(1) DO NOT GIVE UP', [BC_LAB, BC(1), BC_NOT], [BC_GUP],
     'DO NOT GIVE UP', [BC_NOT], [BC_GUP],
     'DO NOT GIVE UP', [BC_NOT], [BC_GUP],
     'DO RESUME #1', [], [BC_RES, BC(1)]],
    ['LOOPS 15b', undef, '', "IV\nIV\nIV\nIV\nIV\n", undef, undef,
     'DO SWAP CONDITION WHILE BODY AND BODY WHILE CONDITION', [], [BC_SWA, BC_CWB, BC_BWC],
     'DO .2 <- #4', [], [BC_STO, BC(4), BC_SPO, BC(2)],
     'DO (1) NEXT WHILE READ OUT .2', [],
      [BC_BWC, BC_ROU, BC(1), BC_SPO, BC(2), BC_NXT, BC(1)],
     'DO GIVE UP', [], [BC_GUP],
     '(1) DO NOT GIVE UP', [BC_LAB, BC(1), BC_NOT], [BC_GUP],
     'DO NOT GIVE UP', [BC_NOT], [BC_GUP],
     'DO NOT GIVE UP', [BC_NOT], [BC_GUP],
     'DO RESUME #1', [], [BC_RES, BC(1)]],
    ['GIVE UP 1', undef, '', "M\nMM\n", undef, undef,
     'DO .1 <- #1000', [], [BC_STO, BC(1000), BC_SPO, BC(1)],
     'DO .2 <- #2000', [], [BC_STO, BC(2000), BC_SPO, BC(2)],
     'DO READ OUT .1', [], [BC_ROU, BC(1), BC_SPO, BC(1)],
     'PLEASE GIVE UP', [], [BC_GUP],
     undef,
     'DO READ OUT .2', [], [BC_ROU, BC(1), BC_SPO, BC(2)]],
    ['GIVE UP 2', undef, '', "M\nMM\n", undef, undef,
     'DO .1 <- #1000', [], [BC_STO, BC(1000), BC_SPO, BC(1)],
     'DO .2 <- #2000', [], [BC_STO, BC(2000), BC_SPO, BC(2)],
     'DO READ OUT .1', [], [BC_ROU, BC(1), BC_SPO, BC(1)],
     'PLEASE GIVE UP', [], [BC_GUP],
     'DO READ OUT .1', [], [BC_ROU, BC(1), BC_SPO, BC(1)],
     'DO READ OUT .2', [], [BC_ROU, BC(1), BC_SPO, BC(2)],
     undef,
     'DO READ OUT .2', [], [BC_ROU, BC(1), BC_SPO, BC(2)]],
    ['GIVE UP 3', undef, '', "M\nMM\n", undef, undef,
     'DO .1 <- #1000', [], [BC_STO, BC(1000), BC_SPO, BC(1)],
     'DO .2 <- #2000', [], [BC_STO, BC(2000), BC_SPO, BC(2)],
     'PLEASE GIVE UP', [], [BC_GUP],
     'DO READ OUT .2', [], [BC_ROU, BC(1), BC_SPO, BC(2)],
     undef,
     'DO READ OUT .1', [], [BC_ROU, BC(1), BC_SPO, BC(1)],
     'PLEASE GIVE UP', [], [BC_GUP],
     'DO READ OUT .1', [], [BC_ROU, BC(1), BC_SPO, BC(1)],
     'DO READ OUT .2', [], [BC_ROU, BC(1), BC_SPO, BC(2)],
     undef,
     'DO READ OUT .2', [], [BC_ROU, BC(1), BC_SPO, BC(2)]],
    ['ONCE 1', undef, '', "I\nII\n", undef, undef,
     'DO .1 <- #1', [], [BC_STO, BC(1), BC_SPO, BC(1)],
     'PLEASE COME FROM (1) ONCE', [BC_BIT, BC(3)], [BC_CFL, BC(1)],
     'DO READ OUT .1', [], [BC_ROU, BC(1), BC_SPO, BC(1)],
     '(1) DO .1 <- #2', [BC_LAB, BC(1)], [BC_STO, BC(2), BC_SPO, BC(1)]],
    ['ONCE 2', undef, '', "II\n", undef, undef,
     'DO .1 <- #1', [], [BC_STO, BC(1), BC_SPO, BC(1)],
     'PLEASE COME FROM (1) ONCE', [BC_BIT, BC(3)], [BC_CFL, BC(1)],
     'DO NOT READ OUT .1 ONCE', [BC_BIT, BC(3), BC_NOT], [BC_ROU, BC(1), BC_SPO, BC(1)],
     '(1) DO .1 <- #2', [BC_LAB, BC(1)], [BC_STO, BC(2), BC_SPO, BC(1)]],
    ['ONCE 3', undef, '', "I\nII\n", undef, undef,
     'DO .1 <- #1', [], [BC_STO, BC(1), BC_SPO, BC(1)],
     'PLEASE COME FROM .1', [], [BC_CFL, BC_SPO, BC(1)],
     'DO READ OUT .1', [], [BC_ROU, BC(1), BC_SPO, BC(1)],
     'DO .1 <- #3', [], [BC_STO, BC(3), BC_SPO, BC(1)],
     '(2) DO .1 <- #2 ONCE', [BC_LAB, BC(2), BC_BIT, BC(3)], [BC_STO, BC(2), BC_SPO, BC(1)]],
    ['ONCE 4', undef, '', "I\nII\n", undef, undef,
     'DO .1 <- #1', [], [BC_STO, BC(1), BC_SPO, BC(1)],
     'PLEASE COME FROM (1)', [], [BC_CFL, BC(1)],
     'DO READ OUT .1', [], [BC_ROU, BC(1), BC_SPO, BC(1)],
     'DO .1 <- #2', [], [BC_STO, BC(2), BC_SPO, BC(1)],
     '(1) DO NOT GIVE UP ONCE', [BC_LAB, BC(1), BC_BIT, BC(3), BC_NOT], [BC_GUP]],
    ['AGAIN 1', undef, '', "II\n", undef, undef,
     'DO .1 <- #1', [], [BC_STO, BC(1), BC_SPO, BC(1)],
     'PLEASE ABSTAIN FROM READING OUT', [], [BC_ABG, BC(1), BC_ROU],
     'PLEASE COME FROM (1) ONCE', [BC_BIT, BC(3)], [BC_CFL, BC(1)],
     'DO READ OUT .1 AGAIN', [BC_BIT, BC(4)], [BC_ROU, BC(1), BC_SPO, BC(1)],
     '(1) DO .1 <- #2', [BC_LAB, BC(1)], [BC_STO, BC(2), BC_SPO, BC(1)]],
    ['AGAIN 2', undef, '', "I\n", undef, undef,
     'DO .1 <- #1', [], [BC_STO, BC(1), BC_SPO, BC(1)],
     'PLEASE REINSTATE READING OUT', [], [BC_REG, BC(1), BC_ROU],
     'PLEASE COME FROM (1) ONCE', [BC_BIT, BC(3)], [BC_CFL, BC(1)],
     'DO NOT READ OUT .1 AGAIN', [BC_BIT, BC(4), BC_NOT], [BC_ROU, BC(1), BC_SPO, BC(1)],
     '(1) DO .1 <- #2', [BC_LAB, BC(1)], [BC_STO, BC(2), BC_SPO, BC(1)]],
    ['SYSCALL', undef, '', "II\n", undef, undef,
     'DO %OS <- #42', [], [BC_STO, BC(42), reg_code('%OS')],
     'SYSCALL#3 = READ OUT :-$%OS', [],
     [BC_SYS, BC(3), BC(1), BC_ROU, BC(1), BC_TSP, BC_NUM, BC_BLM, BC(1), reg_code('%OS')],
     'DO .1 <- #3', [], [BC_STO, BC(3), BC_SPO, BC(1)],
     '(42) DO :1 <- #2', [BC_LAB, BC(42)], [BC_STO, BC(2), BC_TSP, BC(1)],
     'PLEASE GIVE UP', [], [BC_GUP]],
    ['DIVERSION', undef, '', "X\nXI\nXII\n", undef, undef,
     'DO CLOSE OFF BETWEEN (1) AND (2) AND DIVERT VIA (3) TO (4)', [],
     [BC_DIV, BC(1), BC(2), BC(3), BC(4)],
     '(1) DO .1 <- #5', [BC_LAB, BC(1)], [BC_STO, BC(5), BC_SPO, BC(1)],
     'DO .2 <- #6', [], [BC_STO, BC(6), BC_SPO, BC(2)],
     '(2) DO .3 <- #7', [BC_LAB, BC(2)], [BC_STO, BC(7), BC_SPO, BC(3)],
     'DO READ OUT .1 + .2 + .3', [], [BC_ROU, BC(3), BC_SPO, BC(1), BC_SPO, BC(2), BC_SPO, BC(3)],
     '(3) DO .1 <- #10', [BC_LAB, BC(3)], [BC_STO, BC(10), BC_SPO, BC(1)],
     'DO .2 <- #11', [], [BC_STO, BC(11), BC_SPO, BC(2)],
     '(4) DO .3 <- #12', [BC_LAB, BC(4)], [BC_STO, BC(12), BC_SPO, BC(3)]],
    ['DIVERSION, COMPUTED LABEL', undef, '', "X\nXI\nXII\n", undef, undef,
     'DO .1 <- #1', [], [BC_STO, BC(1), BC_SPO, BC(1)],
     'DO .2 <- #2', [], [BC_STO, BC(2), BC_SPO, BC(2)],
     'DO .3 <- #3', [], [BC_STO, BC(3), BC_SPO, BC(3)],
     'DO .4 <- #4', [], [BC_STO, BC(4), BC_SPO, BC(4)],
     'DO CLOSE OFF BETWEEN (1) AND (2) AND DIVERT VIA (3) TO (4)', [],
     [BC_DIV, BC(1), BC(2), BC(3), BC(4)],
     '(.1) DO .1 <- #5', [BC_LAB, BC_SPO, BC(1)], [BC_STO, BC(5), BC_SPO, BC(1)],
     'DO .2 <- #6', [], [BC_STO, BC(6), BC_SPO, BC(2)],
     '(.2) DO .3 <- #7', [BC_LAB, BC_SPO, BC(2)], [BC_STO, BC(7), BC_SPO, BC(3)],
     'DO READ OUT .1 + .2 + .3', [], [BC_ROU, BC(3), BC_SPO, BC(1), BC_SPO, BC(2), BC_SPO, BC(3)],
     '(.3) DO .1 <- #10', [BC_LAB, BC_SPO, BC(3)], [BC_STO, BC(10), BC_SPO, BC(1)],
     'DO .2 <- #11', [], [BC_STO, BC(11), BC_SPO, BC(2)],
     '(.4) DO .3 <- #12', [BC_LAB, BC_SPO, BC(4)], [BC_STO, BC(12), BC_SPO, BC(3)]],
    ['DIVERSION, OVERLOADED LABEL', undef, '', "X\nXI\nXII\n", undef, undef,
     'DO #41 <- #1', [], [BC_STO, BC(1), BC(41)],
     'DO #42 <- #2', [], [BC_STO, BC(2), BC(42)],
     'DO #43 <- #3', [], [BC_STO, BC(3), BC(43)],
     'DO #44 <- #4', [], [BC_STO, BC(4), BC(44)],
     'DO CLOSE OFF BETWEEN (1) AND (2) AND DIVERT VIA (3) TO (4)', [],
     [BC_DIV, BC(1), BC(2), BC(3), BC(4)],
     '(41) DO .1 <- #5', [BC_LAB, BC(41)], [BC_STO, BC(5), BC_SPO, BC(1)],
     'DO .2 <- #6', [], [BC_STO, BC(6), BC_SPO, BC(2)],
     '(42) DO .3 <- #7', [BC_LAB, BC(42)], [BC_STO, BC(7), BC_SPO, BC(3)],
     'DO READ OUT .1 + .42 + .3', [], [BC_ROU, BC(3), BC_SPO, BC(1), BC_SPO, BC(42), BC_SPO, BC(3)],
     '(43) DO .1 <- #10', [BC_LAB, BC(43)], [BC_STO, BC(10), BC_SPO, BC(1)],
     'DO .2 <- #11', [], [BC_STO, BC(11), BC_SPO, BC(2)],
     '(44) DO .3 <- #12', [BC_LAB, BC(44)], [BC_STO, BC(12), BC_SPO, BC(3)]],
    ['REOPENING', undef, '', "V\nVI\nVII\n", undef, undef,
     'DO CLOSE OFF BETWEEN (1) AND (2) AND DIVERT VIA (3) TO (4)', [],
     [BC_DIV, BC(1), BC(2), BC(3), BC(4)],
     'DO REOPEN BETWEEN (1) AND (2)', [], [BC_REO, BC(1), BC(2)],
     '(1) DO .1 <- #5', [BC_LAB, BC(1)], [BC_STO, BC(5), BC_SPO, BC(1)],
     'DO .2 <- #6', [], [BC_STO, BC(6), BC_SPO, BC(2)],
     '(2) DO .3 <- #7', [BC_LAB, BC(2)], [BC_STO, BC(7), BC_SPO, BC(3)],
     'DO READ OUT .1 + .2 + .3', [], [BC_ROU, BC(3), BC_SPO, BC(1), BC_SPO, BC(2), BC_SPO, BC(3)],
     '(3) DO .1 <- #10', [BC_LAB, BC(3)], [BC_STO, BC(10), BC_SPO, BC(1)],
     'DO .2 <- #11', [], [BC_STO, BC(11), BC_SPO, BC(2)],
     '(4) DO .3 <- #12', [BC_LAB, BC(4)], [BC_STO, BC(12), BC_SPO, BC(3)]],
    ['REOPENING, COMPUTED LABEL', undef, '', "V\nVI\nVII\n", undef, undef,
     'DO .1 <- #1', [], [BC_STO, BC(1), BC_SPO, BC(1)],
     'DO .2 <- #2', [], [BC_STO, BC(2), BC_SPO, BC(2)],
     'DO CLOSE OFF BETWEEN (1) AND (2) AND DIVERT VIA (3) TO (4)', [],
     [BC_DIV, BC(1), BC(2), BC(3), BC(4)],
     'DO REOPEN BETWEEN (1) AND (2)', [], [BC_REO, BC(1), BC(2)],
     '(.1) DO .1 <- #5', [BC_LAB, BC_SPO, BC(1)], [BC_STO, BC(5), BC_SPO, BC(1)],
     'DO .2 <- #6', [], [BC_STO, BC(6), BC_SPO, BC(2)],
     '(.2) DO .3 <- #7', [BC_LAB, BC_SPO, BC(2)], [BC_STO, BC(7), BC_SPO, BC(3)],
     'DO READ OUT .1 + .2 + .3', [], [BC_ROU, BC(3), BC_SPO, BC(1), BC_SPO, BC(2), BC_SPO, BC(3)],
     '(3) DO .1 <- #10', [BC_LAB, BC(3)], [BC_STO, BC(10), BC_SPO, BC(1)],
     'DO .2 <- #11', [], [BC_STO, BC(11), BC_SPO, BC(2)],
     '(4) DO .3 <- #12', [BC_LAB, BC(4)], [BC_STO, BC(12), BC_SPO, BC(3)]],
    ['REOPENING, OVERLOADED LABEL 1', undef, '', "V\nVI\nVII\n", undef, undef,
     'DO CLOSE OFF BETWEEN (41) AND (42) AND DIVERT VIA (43) TO (44)', [],
     [BC_DIV, BC(41), BC(42), BC(43), BC(44)],
     'DO #41 <- #1', [], [BC_STO, BC(1), BC(41)],
     'DO #42 <- #2', [], [BC_STO, BC(2), BC(42)],
     'DO REOPEN BETWEEN (1) AND (2)', [], [BC_REO, BC(1), BC(2)],
     '(41) DO .1 <- #5', [BC_LAB, BC(41)], [BC_STO, BC(5), BC_SPO, BC(1)],
     'DO .2 <- #6', [], [BC_STO, BC(6), BC_SPO, BC(2)],
     '(42) DO .3 <- #7', [BC_LAB, BC(42)], [BC_STO, BC(7), BC_SPO, BC(3)],
     'DO READ OUT .1 + .42 + .3', [], [BC_ROU, BC(3), BC_SPO, BC(1), BC_SPO, BC(42), BC_SPO, BC(3)],
     '(43) DO .1 <- #10', [BC_LAB, BC(43)], [BC_STO, BC(10), BC_SPO, BC(1)],
     'DO .2 <- #11', [], [BC_STO, BC(11), BC_SPO, BC(2)],
     '(44) DO .3 <- #12', [BC_LAB, BC(44)], [BC_STO, BC(12), BC_SPO, BC(3)]],
    ['REOPENING, OVERLOADED LABEL 2', undef, '', "V\nVI\nVII\n", undef, undef,
     'DO #41 <- #1', [], [BC_STO, BC(1), BC(41)],
     'DO #42 <- #2', [], [BC_STO, BC(2), BC(42)],
     'DO #43 <- #3', [], [BC_STO, BC(3), BC(43)],
     'DO #44 <- #4', [], [BC_STO, BC(4), BC(44)],
     'DO CLOSE OFF BETWEEN (1) AND (2) AND DIVERT VIA (3) TO (4)', [],
     [BC_DIV, BC(1), BC(2), BC(3), BC(4)],
     'DO #41 <- #5', [], [BC_STO, BC(5), BC(41)],
     'DO #42 <- #6', [], [BC_STO, BC(6), BC(42)],
     'DO #43 <- #7', [], [BC_STO, BC(7), BC(43)],
     'DO #44 <- #8', [], [BC_STO, BC(8), BC(44)],
     'DO REOPEN BETWEEN (5) AND (6)', [], [BC_REO, BC(5), BC(6)],
     '(41) DO .1 <- #5', [BC_LAB, BC(41)], [BC_STO, BC(5), BC_SPO, BC(1)],
     'DO .6 <- #6', [], [BC_STO, BC(6), BC_SPO, BC(6)],
     '(42) DO .3 <- #7', [BC_LAB, BC(42)], [BC_STO, BC(7), BC_SPO, BC(3)],
     'DO READ OUT .1 + .42 + .3', [], [BC_ROU, BC(3), BC_SPO, BC(1), BC_SPO, BC(42), BC_SPO, BC(3)],
     '(43) DO .1 <- #10', [BC_LAB, BC(43)], [BC_STO, BC(10), BC_SPO, BC(1)],
     'DO .2 <- #11', [], [BC_STO, BC(11), BC_SPO, BC(2)],
     '(44) DO .3 <- #12', [BC_LAB, BC(44)], [BC_STO, BC(12), BC_SPO, BC(3)]],
    ['TRICKLE DOWN', undef, '', "I\nI\nI\n", undef, undef,
     'DO TRICKLE .1 DOWN TO .2 + .3 AFTER #10', [],
	[BC_TRD, BC_SPO, BC(1), BC(10), BC(2), BC_SPO, BC(2), BC_SPO, BC(3)],
     'DO .1 <- #1', [], [BC_STO, BC(1), BC_SPO, BC(1)],
     'DO .2 <- #2', [], [BC_STO, BC(2), BC_SPO, BC(2)],
     'DO .3 <- #3', [], [BC_STO, BC(3), BC_SPO, BC(3)],
     # wait for #1 to trickle down
     '(2) PLEASE COME FROM .2', [BC_LAB, BC(2)], [BC_CFL, BC_SPO, BC(2)],
     'DO READ OUT .1 + .2 + .3', [], [BC_ROU, BC(3), BC_SPO, BC(1), BC_SPO, BC(2), BC_SPO, BC(3)]],
    ['TRICKLE DOWN: IGNORED REGISTER', undef, '', "I\nI\nIII\n", undef, undef,
     'DO TRICKLE .1 DOWN TO .2 + .3 AFTER #10', [],
	[BC_TRD, BC_SPO, BC(1), BC(10), BC(2), BC_SPO, BC(2), BC_SPO, BC(3)],
     'DO .1 <- #1', [], [BC_STO, BC(1), BC_SPO, BC(1)],
     'DO .2 <- #2', [], [BC_STO, BC(2), BC_SPO, BC(2)],
     'DO .3 <- #3', [], [BC_STO, BC(3), BC_SPO, BC(3)],
     'DO IGNORE .3', [], [BC_IGN, BC(1), BC_SPO, BC(3)],
     # wait for #1 to trickle down
     '(2) PLEASE COME FROM .2', [BC_LAB, BC(2)], [BC_CFL, BC_SPO, BC(2)],
     'DO READ OUT .1 + .2 + .3', [], [BC_ROU, BC(3), BC_SPO, BC(1), BC_SPO, BC(2), BC_SPO, BC(3)]],
    ['TRICKLE DOWN, REMEMBERED REGISTER', undef, '', "I\nI\nI\n", undef, undef,
     'DO .3 <- #4', [], [BC_STO, BC(4), BC_SPO, BC(3)],
     'DO IGNORE .3', [], [BC_IGN, BC(1), BC_SPO, BC(3)],
     'DO TRICKLE .1 DOWN TO .2 + .3 AFTER #10', [],
	[BC_TRD, BC_SPO, BC(1), BC(10), BC(2), BC_SPO, BC(2), BC_SPO, BC(3)],
     'DO .1 <- #1', [], [BC_STO, BC(1), BC_SPO, BC(1)],
     'DO .2 <- #2', [], [BC_STO, BC(2), BC_SPO, BC(2)],
     'DO .3 <- #3', [], [BC_STO, BC(3), BC_SPO, BC(3)],
     'DO REMEMBER .3', [], [BC_REM, BC(1), BC_SPO, BC(3)],
     # wait for #1 to trickle down
     '(2) PLEASE COME FROM .2', [BC_LAB, BC(2)], [BC_CFL, BC_SPO, BC(2)],
     'DO READ OUT .1 + .2 + .3', [], [BC_ROU, BC(3), BC_SPO, BC(1), BC_SPO, BC(2), BC_SPO, BC(3)]],
    ['TRICKLE DOWN: OVERLOADED REGISTER', undef, '', "I\nI\nIII\nI\n", undef, undef,
     'DO TRICKLE .1 DOWN TO .2 + .3 AFTER #10', [],
	[BC_TRD, BC_SPO, BC(1), BC(10), BC(2), BC_SPO, BC(2), BC_SPO, BC(3)],
     'DO .1 <- #1', [], [BC_STO, BC(1), BC_SPO, BC(1)],
     'DO .2 <- #2', [], [BC_STO, BC(2), BC_SPO, BC(2)],
     'DO .3 <- #3', [], [BC_STO, BC(3), BC_SPO, BC(3)],
     'DO .42 <- .3/.4', [], [BC_STO, BC_OVR, BC_SPO, BC(4), BC_SPO, BC(3), BC_SPO, BC(42)],
     # wait for #1 to trickle down
     '(2) PLEASE COME FROM .2', [BC_LAB, BC(2)], [BC_CFL, BC_SPO, BC(2)],
     'DO .42 <- .3/.3', [], [BC_STO, BC_OVR, BC_SPO, BC(3), BC_SPO, BC(3), BC_SPO, BC(42)],
     'DO READ OUT .1 + .2 + .3 + .4', [],
	[BC_ROU, BC(4), BC_SPO, BC(1), BC_SPO, BC(2), BC_SPO, BC(3), BC_SPO, BC(4)]],
    ['TRUSS UP', undef, '', "I\nII\nIII\n", undef, undef,
     'DO TRICKLE .1 DOWN TO .2 + .3 AFTER #20', [],
	[BC_TRD, BC_SPO, BC(1), BC(10), BC(2), BC_SPO, BC(2), BC_SPO, BC(3)],
     'DO TRICKLE :1 DOWN TO :2 + :3 AFTER #10', [],
	[BC_TRD, BC_SPO, BC(1), BC(10), BC(2), BC_SPO, BC(2), BC_SPO, BC(3)],
     'DO TRUSS :1 + :2 UP', [], [BC_TRU, BC(2), BC_TSP, BC(1), BC_TSP, BC(2)],
     'DO .1 <- #1', [], [BC_STO, BC(1), BC_SPO, BC(1)],
     'DO .2 <- #2', [], [BC_STO, BC(2), BC_SPO, BC(2)],
     'DO .3 <- #3', [], [BC_STO, BC(3), BC_SPO, BC(3)],
     'DO :1 <- #1', [], [BC_STO, BC(1), BC_TSP, BC(1)],
     'DO :2 <- #2', [], [BC_STO, BC(2), BC_TSP, BC(2)],
     'DO :3 <- #3', [], [BC_STO, BC(3), BC_TSP, BC(3)],
     # wait for #1 to trickle down
     '(2) PLEASE COME FROM .2', [BC_LAB, BC(2)], [BC_CFL, BC_SPO, BC(2)],
     'DO READ OUT :1 + :2 + :3', [], [BC_ROU, BC(3), BC_TSP, BC(1), BC_TSP, BC(2), BC_TSP, BC(3)]],
);

test_bc(@all_tests);

