/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.xqj;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import javax.xml.datatype.DatatypeConstants;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.CalendarValue;
import net.sf.saxon.value.DateTimeValue;
import net.sf.saxon.value.DateValue;
import net.sf.saxon.value.GDayValue;
import net.sf.saxon.value.GMonthDayValue;
import net.sf.saxon.value.GMonthValue;
import net.sf.saxon.value.GYearMonthValue;
import net.sf.saxon.value.GYearValue;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.TimeValue;
import net.sf.saxon.xqj.SaxonDuration;

public class SaxonXMLGregorianCalendar
extends XMLGregorianCalendar {
    private BigInteger year;
    private int month;
    private int day;
    private int hour;
    private int minute;
    private int second;
    private int microsecond;
    private int tzOffset;

    public SaxonXMLGregorianCalendar(CalendarValue calendarValue) {
        this.clear();
        this.setCalendarValue(calendarValue);
    }

    private SaxonXMLGregorianCalendar() {
    }

    public void setCalendarValue(CalendarValue calendarValue) {
        try {
            if (calendarValue instanceof GYearValue) {
                this.year = BigInteger.valueOf(((IntegerValue)calendarValue.getComponent(1)).longValue());
            } else if (calendarValue instanceof GYearMonthValue) {
                this.year = BigInteger.valueOf(((IntegerValue)calendarValue.getComponent(1)).longValue());
                this.month = (int)((IntegerValue)calendarValue.getComponent(2)).longValue();
            } else if (calendarValue instanceof GMonthValue) {
                this.month = (int)((IntegerValue)calendarValue.getComponent(2)).longValue();
            } else if (calendarValue instanceof GMonthDayValue) {
                this.month = (int)((IntegerValue)calendarValue.getComponent(2)).longValue();
                this.day = (int)((IntegerValue)calendarValue.getComponent(3)).longValue();
            } else if (calendarValue instanceof GDayValue) {
                this.day = (int)((IntegerValue)calendarValue.getComponent(3)).longValue();
            } else if (calendarValue instanceof DateValue) {
                this.year = BigInteger.valueOf(((IntegerValue)calendarValue.getComponent(1)).longValue());
                this.month = (int)((IntegerValue)calendarValue.getComponent(2)).longValue();
                this.day = (int)((IntegerValue)calendarValue.getComponent(3)).longValue();
            } else if (calendarValue instanceof TimeValue) {
                this.hour = (int)((IntegerValue)calendarValue.getComponent(4)).longValue();
                this.minute = (int)((IntegerValue)calendarValue.getComponent(5)).longValue();
                this.second = (int)((IntegerValue)calendarValue.getComponent(12)).longValue();
                this.microsecond = (int)((IntegerValue)calendarValue.getComponent(11)).longValue();
            } else {
                this.year = BigInteger.valueOf(((IntegerValue)calendarValue.getComponent(1)).longValue());
                this.month = (int)((IntegerValue)calendarValue.getComponent(2)).longValue();
                this.day = (int)((IntegerValue)calendarValue.getComponent(3)).longValue();
                this.hour = (int)((IntegerValue)calendarValue.getComponent(4)).longValue();
                this.minute = (int)((IntegerValue)calendarValue.getComponent(5)).longValue();
                this.second = (int)((IntegerValue)calendarValue.getComponent(12)).longValue();
                this.microsecond = (int)((IntegerValue)calendarValue.getComponent(11)).longValue();
            }
        }
        catch (XPathException xPathException) {
            throw new IllegalArgumentException(xPathException.getMessage());
        }
    }

    public void clear() {
        this.year = null;
        this.month = Integer.MIN_VALUE;
        this.day = Integer.MIN_VALUE;
        this.hour = Integer.MIN_VALUE;
        this.minute = Integer.MIN_VALUE;
        this.second = Integer.MIN_VALUE;
        this.microsecond = Integer.MIN_VALUE;
        this.tzOffset = Integer.MIN_VALUE;
    }

    public void reset() {
        this.clear();
    }

    public void setYear(BigInteger bigInteger) {
        this.year = bigInteger;
    }

    public void setYear(int n) {
        this.year = BigInteger.valueOf(n);
    }

    public void setMonth(int n) {
        this.month = n;
    }

    public void setDay(int n) {
        this.day = n;
    }

    public void setTimezone(int n) {
        this.tzOffset = n;
    }

    public void setHour(int n) {
        this.hour = n;
    }

    public void setMinute(int n) {
        this.minute = n;
    }

    public void setSecond(int n) {
        this.second = n;
    }

    public void setMillisecond(int n) {
        this.microsecond = n * 1000;
    }

    public void setFractionalSecond(BigDecimal bigDecimal) {
        this.second = bigDecimal.intValue();
        BigInteger bigInteger = bigDecimal.movePointRight(6).toBigInteger();
        bigInteger = bigInteger.remainder(BigInteger.valueOf(1000000L));
        this.microsecond = bigInteger.intValue();
    }

    public BigInteger getEon() {
        return this.year.divide(BigInteger.valueOf(1000000000L));
    }

    public int getYear() {
        return this.year.intValue();
    }

    public BigInteger getEonAndYear() {
        return this.year;
    }

    public int getMonth() {
        return this.month;
    }

    public int getDay() {
        return this.day;
    }

    public int getTimezone() {
        return this.tzOffset;
    }

    public int getHour() {
        return this.hour;
    }

    public int getMinute() {
        return this.minute;
    }

    public int getSecond() {
        return this.second;
    }

    public int getMicrosecond() {
        BigDecimal bigDecimal = this.getFractionalSecond();
        if (bigDecimal == null) {
            return Integer.MIN_VALUE;
        }
        return this.getFractionalSecond().movePointRight(6).intValue();
    }

    public BigDecimal getFractionalSecond() {
        if (this.second == Integer.MIN_VALUE) {
            return null;
        }
        return BigDecimal.valueOf(this.microsecond).movePointLeft(6);
    }

    public int compare(XMLGregorianCalendar xMLGregorianCalendar) {
        return this.toCalendarValue().compareTo(((SaxonXMLGregorianCalendar)xMLGregorianCalendar).toCalendarValue());
    }

    public XMLGregorianCalendar normalize() {
        return this;
    }

    public String toXMLFormat() {
        return this.toCalendarValue().getStringValue();
    }

    public QName getXMLSchemaType() {
        if (this.second == Integer.MIN_VALUE) {
            if (this.year == null) {
                if (this.month == Integer.MIN_VALUE) {
                    return DatatypeConstants.GDAY;
                }
                if (this.day == Integer.MIN_VALUE) {
                    return DatatypeConstants.GMONTH;
                }
                return DatatypeConstants.GMONTHDAY;
            }
            if (this.day == Integer.MIN_VALUE) {
                if (this.month == Integer.MIN_VALUE) {
                    return DatatypeConstants.GYEAR;
                }
                return DatatypeConstants.GYEARMONTH;
            }
            return DatatypeConstants.DATE;
        }
        if (this.year == null) {
            return DatatypeConstants.TIME;
        }
        return DatatypeConstants.DATETIME;
    }

    public boolean isValid() {
        return true;
    }

    public void add(Duration duration) {
        try {
            CalendarValue calendarValue = this.toCalendarValue().add(((SaxonDuration)duration).getDurationValue());
            this.setCalendarValue(calendarValue);
        }
        catch (XPathException xPathException) {
            throw new IllegalArgumentException(xPathException.getMessage());
        }
    }

    public GregorianCalendar toGregorianCalendar() {
        return this.toCalendarValue().getCalendar();
    }

    public GregorianCalendar toGregorianCalendar(TimeZone timeZone, Locale locale, XMLGregorianCalendar xMLGregorianCalendar) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(timeZone, locale);
        gregorianCalendar.setGregorianChange(new Date(Long.MIN_VALUE));
        gregorianCalendar.set(0, this.year.signum());
        gregorianCalendar.set(1, this.year.abs().intValue());
        gregorianCalendar.set(2, this.month);
        gregorianCalendar.set(5, this.day);
        gregorianCalendar.set(10, this.hour);
        gregorianCalendar.set(12, this.minute);
        gregorianCalendar.set(13, this.second);
        gregorianCalendar.set(14, this.getMillisecond() / 1000);
        return gregorianCalendar;
    }

    public TimeZone getTimeZone(int n) {
        if (this.tzOffset == Integer.MIN_VALUE) {
            if (n == Integer.MIN_VALUE) {
                return new GregorianCalendar().getTimeZone();
            }
            return new SimpleTimeZone(n * 60000, "XXX");
        }
        return new SimpleTimeZone(this.tzOffset * 60000, "XXX");
    }

    public Object clone() {
        SaxonXMLGregorianCalendar saxonXMLGregorianCalendar = new SaxonXMLGregorianCalendar();
        saxonXMLGregorianCalendar.setYear(this.year);
        saxonXMLGregorianCalendar.setMonth(this.month);
        saxonXMLGregorianCalendar.setDay(this.day);
        saxonXMLGregorianCalendar.setHour(this.hour);
        saxonXMLGregorianCalendar.setMinute(this.minute);
        saxonXMLGregorianCalendar.setSecond(this.second);
        saxonXMLGregorianCalendar.setMillisecond(this.microsecond / 1000);
        saxonXMLGregorianCalendar.setTimezone(this.tzOffset);
        return saxonXMLGregorianCalendar;
    }

    /*
     * Enabled aggressive block sorting
     */
    public CalendarValue toCalendarValue() {
        if (this.second != Integer.MIN_VALUE) {
            if (this.year != null) return new DateTimeValue(this.year.intValue(), (byte)this.month, (byte)this.day, (byte)this.hour, (byte)this.minute, (byte)this.second, this.getMicrosecond(), this.tzOffset);
            return new TimeValue((byte)this.hour, (byte)this.minute, (byte)this.second, this.getMicrosecond(), this.tzOffset);
        }
        if (this.year != null) {
            if (this.day != Integer.MIN_VALUE) return new DateValue(this.year.intValue(), (byte)this.month, (byte)this.day, this.tzOffset);
            if (this.month != Integer.MIN_VALUE) return new GYearMonthValue(this.year.intValue(), (byte)this.month, this.tzOffset);
            return new GYearValue(this.year.intValue(), this.tzOffset);
        }
        if (this.month == Integer.MIN_VALUE) {
            new GDayValue((byte)this.day, this.tzOffset);
            return new DateValue(this.year.intValue(), (byte)this.month, (byte)this.day, this.tzOffset);
        }
        if (this.day != Integer.MIN_VALUE) return new GMonthDayValue((byte)this.month, (byte)this.day, this.tzOffset);
        return new GMonthValue((byte)this.month, this.tzOffset);
    }
}

