//
// C++ Interface: filelog
//
// Description: 
//
//
// Author: Arsenij Vodjanov <arsenij@gmail.com>, (C) 2005
//
// Copyright: See COPYING file that comes with this distribution
//
//

#ifndef FILELOG_H_
#define FILELOG_H_

#include "log.h"

#include <QTime>


//! Log implementation that logs to a file.
class FileLog : public Log
{
public:
    FileLog();
    virtual void info(const char* format, ...);
    virtual void info(const QString&);
    virtual void error(const char* format, ...);
    virtual void error(const QString&);
    virtual void warn(const char* format, ...);
    virtual void warn(const QString&);
    virtual void debug(const char* format, ...);
    virtual void debug(const QString&);
	virtual void msg(const QString&,const QColor& color);
    virtual ~FileLog();
    
private:
    void printMessage(const QString msg);
    void printMessage(const char* format, va_list va);
	QTime time;
};

#endif
