/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.validators.datatype;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.xerces.utils.XMLCharacterProperties;
import org.apache.xerces.utils.regex.RegularExpression;
import org.apache.xerces.validators.datatype.AbstractDatatypeValidator;
import org.apache.xerces.validators.datatype.DatatypeValidator;
import org.apache.xerces.validators.datatype.InvalidDatatypeFacetException;
import org.apache.xerces.validators.datatype.InvalidDatatypeValueException;

public abstract class AbstractStringValidator
extends AbstractDatatypeValidator {
    protected int fLength = 0;
    protected int fMaxLength = Integer.MAX_VALUE;
    protected int fMinLength = 0;
    protected Vector fEnumeration = null;
    public static final String FACET_SPECIAL_TOKEN = "specialToken";
    public static final String SPECIAL_TOKEN_NONE = "NONE";
    public static final String SPECIAL_TOKEN_NMTOKEN = "NMTOKEN";
    public static final String SPECIAL_TOKEN_NAME = "Name";
    public static final String SPECIAL_TOKEN_IDNAME = "ID(Name)";
    public static final String SPECIAL_TOKEN_IDREFNAME = "IDREF(Name)";
    public static final String SPECIAL_TOKEN_NCNAME = "NCName";
    public static final String SPECIAL_TOKEN_IDNCNAME = "ID(NCName)";
    public static final String SPECIAL_TOKEN_IDREFNCNAME = "IDREF(NCName)";
    public static final String SPECIAL_TOKEN_ENTITY = "ENTITY(NCName)";
    protected String fTokenType = "NONE";

    public AbstractStringValidator() throws InvalidDatatypeFacetException {
        this(null, null, false);
    }

    public AbstractStringValidator(DatatypeValidator datatypeValidator, Hashtable hashtable, boolean bl) throws InvalidDatatypeFacetException {
        this.fBaseValidator = datatypeValidator;
        if (this.derivationList(bl)) {
            return;
        }
        if (hashtable != null) {
            Object object;
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string;
                object = (String)enumeration.nextElement();
                if (((String)object).equals("length")) {
                    this.fFacetsDefined = (short)(this.fFacetsDefined | 1);
                    string = (String)hashtable.get(object);
                    try {
                        this.fLength = Integer.parseInt(string);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new InvalidDatatypeFacetException("Length value '" + string + "' is invalid.");
                    }
                    if (this.fLength >= 0) continue;
                    throw new InvalidDatatypeFacetException("Length value '" + string + "'  must be a nonNegativeInteger.");
                }
                if (((String)object).equals("minLength")) {
                    this.fFacetsDefined = (short)(this.fFacetsDefined | 2);
                    string = (String)hashtable.get(object);
                    try {
                        this.fMinLength = Integer.parseInt(string);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new InvalidDatatypeFacetException("minLength value '" + string + "' is invalid.");
                    }
                    if (this.fMinLength >= 0) continue;
                    throw new InvalidDatatypeFacetException("minLength value '" + string + "'  must be a nonNegativeInteger.");
                }
                if (((String)object).equals("maxLength")) {
                    this.fFacetsDefined = (short)(this.fFacetsDefined | 4);
                    string = (String)hashtable.get(object);
                    try {
                        this.fMaxLength = Integer.parseInt(string);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new InvalidDatatypeFacetException("maxLength value '" + string + "' is invalid.");
                    }
                    if (this.fMaxLength >= 0) continue;
                    throw new InvalidDatatypeFacetException("maxLength value '" + string + "'  must be a nonNegativeInteger.");
                }
                if (((String)object).equals("pattern")) {
                    this.fFacetsDefined = (short)(this.fFacetsDefined | 8);
                    this.fPattern = (String)hashtable.get(object);
                    if (this.fPattern == null) continue;
                    this.fRegex = new RegularExpression(this.fPattern, "X");
                    continue;
                }
                if (((String)object).equals("enumeration")) {
                    this.fEnumeration = (Vector)hashtable.get(object);
                    this.fFacetsDefined = (short)(this.fFacetsDefined | 0x10);
                    continue;
                }
                if (((String)object).equals("fixed")) {
                    this.fFlags = (Short)hashtable.get(object);
                    continue;
                }
                if (object == FACET_SPECIAL_TOKEN) {
                    this.setTokenType((String)hashtable.get(object));
                    continue;
                }
                this.assignAdditionalFacets((String)object, hashtable);
            }
            if (datatypeValidator != null && (this.fFacetsDefined & 0x10) != 0 && this.fEnumeration != null) {
                int n = 0;
                try {
                    while (n < this.fEnumeration.size()) {
                        ((AbstractStringValidator)datatypeValidator).checkContent((String)this.fEnumeration.elementAt(n), null, false);
                        ++n;
                    }
                }
                catch (Exception exception) {
                    throw new InvalidDatatypeFacetException("Value of enumeration = '" + this.fEnumeration.elementAt(n) + "' must be from the value space of base.");
                }
            }
            if ((this.fFacetsDefined & 1) != 0) {
                if ((this.fFacetsDefined & 4) != 0) {
                    throw new InvalidDatatypeFacetException("It is an error for both length and maxLength to be members of facets.");
                }
                if ((this.fFacetsDefined & 2) != 0) {
                    throw new InvalidDatatypeFacetException("It is an error for both length and minLength to be members of facets.");
                }
            }
            if ((this.fFacetsDefined & 6) != 0 && this.fMinLength > this.fMaxLength) {
                throw new InvalidDatatypeFacetException("Value of minLength = '" + this.fMinLength + "'must be <= the value of maxLength = '" + this.fMaxLength + "'.");
            }
            if (datatypeValidator != null) {
                object = (AbstractStringValidator)datatypeValidator;
                if ((this.fFacetsDefined & 1) != 0) {
                    if ((((AbstractDatatypeValidator)object).fFacetsDefined & 4) != 0) {
                        throw new InvalidDatatypeFacetException("It is an error for both length and maxLength to be members of facets.");
                    }
                    if ((((AbstractDatatypeValidator)object).fFacetsDefined & 2) != 0) {
                        throw new InvalidDatatypeFacetException("It is an error for both length and minLength to be members of facets.");
                    }
                    if ((((AbstractDatatypeValidator)object).fFacetsDefined & 1) != 0 && this.fLength != ((AbstractStringValidator)object).fLength) {
                        throw new InvalidDatatypeFacetException("Value of length = '" + this.fLength + "' must be = the value of base.length = '" + ((AbstractStringValidator)object).fLength + "'.");
                    }
                }
                if ((((AbstractDatatypeValidator)object).fFacetsDefined & 1) != 0) {
                    if ((this.fFacetsDefined & 4) != 0) {
                        throw new InvalidDatatypeFacetException("It is an error for both length and maxLength to be members of facets.");
                    }
                    if ((this.fFacetsDefined & 2) != 0) {
                        throw new InvalidDatatypeFacetException("It is an error for both length and minLength to be members of facets.");
                    }
                }
                if ((this.fFacetsDefined & 2) != 0) {
                    if ((((AbstractDatatypeValidator)object).fFacetsDefined & 4) != 0) {
                        if (this.fMinLength > ((AbstractStringValidator)object).fMaxLength) {
                            throw new InvalidDatatypeFacetException("Value of minLength = '" + this.fMinLength + "'must be <= the value of maxLength = '" + this.fMaxLength + "'.");
                        }
                    } else if ((((AbstractDatatypeValidator)object).fFacetsDefined & 2) != 0) {
                        if ((((AbstractDatatypeValidator)object).fFlags & 2) != 0 && this.fMinLength != ((AbstractStringValidator)object).fMinLength) {
                            throw new InvalidDatatypeFacetException("minLength value = '" + this.fMinLength + "' must be equal to base.minLength value = '" + ((AbstractStringValidator)object).fMinLength + "' with attribute {fixed} = true");
                        }
                        if (this.fMinLength < ((AbstractStringValidator)object).fMinLength) {
                            throw new InvalidDatatypeFacetException("Value of minLength = '" + this.fMinLength + "' must be >= the value of base.minLength = '" + ((AbstractStringValidator)object).fMinLength + "'.");
                        }
                    }
                }
                if ((((AbstractDatatypeValidator)object).fFacetsDefined & 2) != 0 && (this.fFacetsDefined & 4) != 0 && ((AbstractStringValidator)object).fMinLength > this.fMaxLength) {
                    throw new InvalidDatatypeFacetException("Value of minLength = '" + this.fMinLength + "'must be <= the value of maxLength = '" + this.fMaxLength + "'.");
                }
                if ((this.fFacetsDefined & 4) != 0) {
                    if ((((AbstractDatatypeValidator)object).fFlags & 4) != 0 && this.fMaxLength != ((AbstractStringValidator)object).fMaxLength) {
                        throw new InvalidDatatypeFacetException("maxLength value = '" + this.fMaxLength + "' must be equal to base.maxLength value = '" + ((AbstractStringValidator)object).fMaxLength + "' with attribute {fixed} = true");
                    }
                    if ((((AbstractDatatypeValidator)object).fFacetsDefined & 4) != 0 && this.fMaxLength > ((AbstractStringValidator)object).fMaxLength) {
                        throw new InvalidDatatypeFacetException("Value of maxLength = '" + this.fMaxLength + "' must be <= the value of base.maxLength = '" + ((AbstractStringValidator)object).fMaxLength + "'.");
                    }
                }
                this.checkBaseFacetConstraints();
                if ((((AbstractDatatypeValidator)object).fFacetsDefined & 1) != 0 && (this.fFacetsDefined & 1) == 0) {
                    this.fFacetsDefined = (short)(this.fFacetsDefined | 1);
                    this.fLength = ((AbstractStringValidator)object).fLength;
                }
                if ((((AbstractDatatypeValidator)object).fFacetsDefined & 2) != 0 && (this.fFacetsDefined & 2) == 0) {
                    this.fFacetsDefined = (short)(this.fFacetsDefined | 2);
                    this.fMinLength = ((AbstractStringValidator)object).fMinLength;
                }
                if ((((AbstractDatatypeValidator)object).fFacetsDefined & 4) != 0 && (this.fFacetsDefined & 4) == 0) {
                    this.fFacetsDefined = (short)(this.fFacetsDefined | 4);
                    this.fMaxLength = ((AbstractStringValidator)object).fMaxLength;
                }
                if ((this.fFacetsDefined & 0x10) == 0 && (((AbstractDatatypeValidator)object).fFacetsDefined & 0x10) != 0) {
                    this.fFacetsDefined = (short)(this.fFacetsDefined | 0x10);
                    this.fEnumeration = ((AbstractStringValidator)object).fEnumeration;
                }
                this.inheritAdditionalFacets();
                this.fFlags = (short)(this.fFlags | ((AbstractDatatypeValidator)object).fFlags);
            }
        }
    }

    protected abstract void assignAdditionalFacets(String var1, Hashtable var2) throws InvalidDatatypeFacetException;

    protected void checkBaseFacetConstraints() throws InvalidDatatypeFacetException {
    }

    private void checkContent(String string, Object object, boolean bl) throws InvalidDatatypeValueException {
        if (this.fBaseValidator != null) {
            ((AbstractStringValidator)this.fBaseValidator).checkContent(string, object, true);
        }
        if (!((this.fFacetsDefined & 8) == 0 || this.fRegex != null && this.fRegex.matches(string))) {
            throw new InvalidDatatypeValueException("Value '" + string + "' does not match regular expression facet '" + this.fPattern + "'.");
        }
        if (this.fTokenType != SPECIAL_TOKEN_NONE) {
            AbstractStringValidator.validateToken(this.fTokenType, string);
        }
        if (bl) {
            return;
        }
        this.checkValueSpace(string);
        int n = this.getLength(string);
        if ((this.fFacetsDefined & 4) != 0 && n > this.fMaxLength) {
            throw new InvalidDatatypeValueException("Value '" + string + "' with length '" + n + "' exceeds maximum length facet of '" + this.fMaxLength + "'.");
        }
        if ((this.fFacetsDefined & 2) != 0 && n < this.fMinLength) {
            throw new InvalidDatatypeValueException("Value '" + string + "' with length '" + n + "' is less than minimum length facet of '" + this.fMinLength + "'.");
        }
        if ((this.fFacetsDefined & 1) != 0 && n != this.fLength) {
            throw new InvalidDatatypeValueException("Value '" + string + "' with length '" + n + "' is not equal to length facet '" + this.fLength + "'.");
        }
        if ((this.fFacetsDefined & 0x10) != 0 && this.fEnumeration != null && !this.fEnumeration.contains(string)) {
            throw new InvalidDatatypeValueException("Value '" + string + "' must be one of " + this.fEnumeration);
        }
    }

    protected void checkValueSpace(String string) throws InvalidDatatypeValueException {
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException("clone() is not supported in " + this.getClass().getName());
    }

    protected boolean derivationList(boolean bl) {
        return bl;
    }

    protected int getLength(String string) {
        return string.length();
    }

    protected void inheritAdditionalFacets() {
    }

    public void setTokenType(String string) {
        this.fTokenType = string;
    }

    public Object validate(String string, Object object) throws InvalidDatatypeValueException {
        this.checkContent(string, object, false);
        return null;
    }

    protected static void validateToken(String string, String string2) throws InvalidDatatypeValueException {
        int n;
        if (string2 == null || (n = string2.length()) == 0) {
            throw new InvalidDatatypeValueException("The length of the content must be greater than 0");
        }
        boolean bl = false;
        if (string == SPECIAL_TOKEN_NMTOKEN) {
            bl = XMLCharacterProperties.validNmtoken(string2) ^ true;
        } else if (string == SPECIAL_TOKEN_NAME || string == SPECIAL_TOKEN_IDNAME || string == SPECIAL_TOKEN_IDREFNAME) {
            bl = XMLCharacterProperties.validName(string2) ^ true;
        } else if (string == SPECIAL_TOKEN_NCNAME || string == SPECIAL_TOKEN_IDNCNAME || string == SPECIAL_TOKEN_IDREFNCNAME || string == SPECIAL_TOKEN_ENTITY) {
            bl = XMLCharacterProperties.validNCName(string2) ^ true;
        }
        if (bl) {
            throw new InvalidDatatypeValueException("Value '" + string2 + "' is not a valid " + string);
        }
    }
}

